// Persistence of Vision Ray Tracer Scene Description File
// File: apples.pov
// Vers: 3
// Desc: "A Cup of Sunlight"
// Date: 10/30/96
// Auth: M Preddy
//

#version 3.0  

#include "Chain.inc"
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "shapes2.inc"

global_settings { ambient_light rgb<1, 1, 1> }

camera { location <.7,50,-50> direction <0,0,1> look_at <0,0,-60> rotate <0,0,0>}


light_source { <0,231/*160*/,0> color rgb<1,1,1> }

sphere { 0,5 translate <0,166,0> pigment {White}}

light_source { <0,-5,0> color rgb<.5,.5,.5> }
light_source { <0,-25,0> color rgb<.5,.5,.5> }

#declare Involute1 =
union{
sphere { <	5	,	0	,	0	>,	0.1	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.3	,	1	>} }}
sphere { <	5.240447466	,	0	,	0.05109162	>,	0.154	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.2	,	0.91	>} }}
sphere { <	5.890857336	,	0	,	0.3967365	>,	0.23716	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.1	,	0.82	>} }}
sphere { <	6.750005497	,	0	,	1.273391453	>,	0.3652264	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.2	,	0.73	>} }}
sphere { <	7.519511477	,	0	,	2.809866037	>,	0.562448656	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.3	,	0.64	>} }}
sphere { <	7.853979145	,	0	,	4.99374725	>,	0.86617093	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.2	,	0.55	>} }}
sphere { <	7.421189808	,	0	,	7.659134536	>,	1.333903233	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.1	,	0.46	>} }}
sphere { <	5.963878211	,	0	,	10.49820255	>,	2.054210978	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.2	,	0.37	>} }}
sphere { <	3.354186322	,	0	,	13.0959167	>,	3.163484906	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.3	,	0.28	>} }}
sphere { <	-0.367394867	,	0	,	14.98405556	>,	4.871766756	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.2	,	0.19	>} }}
sphere { <	-4.974989008	,	0	,	15.70794335	>,	7.502520804	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.1	,	0.1	>} }}
}

#declare Involute2 =
union{
sphere { <	10	,	0	,	0	>,	0.1	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.7	,	1	>} }}
sphere { <	10.48089493	,	0	,	0.10218324	>,	0.16	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.6	,	0.91	>} }}
sphere { <	11.78171467	,	0	,	0.793473001	>,	0.256	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.5	,	0.82	>} }}
sphere { <	13.50001099	,	0	,	2.546782906	>,	0.4096	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.6	,	0.73	>} }}
sphere { <	15.03902295	,	0	,	5.619732073	>,	0.65536	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.7	,	0.64	>} }}
sphere { <	15.70795829	,	0	,	9.9874945	>,	1.048576	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.6	,	0.55	>} }}
sphere { <	14.84237962	,	0	,	15.31826907	>,	1.6777216	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.5	,	0.46	>} }}
sphere { <	11.92775642	,	0	,	20.99640509	>,	2.68435456	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.6	,	0.37	>} }}
sphere { <	6.708372644	,	0	,	26.19183339	>,	4.294967296	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.1	,	0.7	,	0.28	>} }}
sphere { <	-0.734789734	,	0	,	29.96811112	>,	6.871947674	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.5	,	0.6	,	0.19	>} }}
sphere { <	-9.949978016	,	0	,	31.41588671	>,	10.99511628	scale <	1	,	1	,	1	> texture { Polished_Chrome pigment {rgb<	0.9	,	0.5	,	0.1	>} }}
}

#declare Packet1 =
union{
object { Involute1 }
object { Involute1 rotate <0,90,0> }
object { Involute1 rotate <0,180,0> }
object { Involute1 rotate <0,270,0> }
}

#declare Packet2 =
union{
object { Involute2 }
object { Involute2 rotate <0,90,0> }
object { Involute2 rotate <0,180,0> }
object { Involute2 rotate <0,270,0> }
}

#declare Build1 =
union {
object { Packet1 }
object { Packet1 translate < 0,-6,0> }
object { Packet1 translate < 0,-12,0> }
object { Packet1 translate < 0,-18,0> }
object { Packet1 translate < 0,-24,0> }
object { Packet1 translate < 0,-30,0> }
object { Packet1 translate < 0,-36,0> }
object { Packet1 translate < 0,-42,0> }
object { Packet1 translate < 0,-48,0> }
object { Packet1 translate < 0,-54,0> }
object { Packet1 translate < 0,-60,0> }
object { Packet1 translate < 0,-66,0> }
object { Packet1 translate < 0,-72,0> }
object { Packet1 translate < 0,-78,0> }
}

#declare Build2 =
union {
object { Packet2 }
object { Packet2 translate < 0,-6,0> }
object { Packet2 translate < 0,-12,0> }
object { Packet2 translate < 0,-18,0> }
object { Packet2 translate < 0,-24,0> }
object { Packet2 translate < 0,-30,0> }
object { Packet2 translate < 0,-36,0> }
object { Packet2 translate < 0,-42,0> }
object { Packet2 translate < 0,-48,0> }
object { Packet2 translate < 0,-54,0> }
object { Packet2 translate < 0,-60,0> }
object { Packet2 translate < 0,-66,0> }
object { Packet2 translate < 0,-72,0> }
object { Packet2 translate < 0,-78,0> }
}

object { Build1 translate y*0 scale <1,1,1> }
object { Build2 translate y*0 scale <1,1,1> }

object { Build1 rotate 45*y translate <0,0,60> }
object { Build2 rotate 45*y translate <0,0,60> }

object { Build1 rotate 45*y translate <0,0,-60> }
object { Build2 rotate 45*y translate <0,0,-60> }

object { Build1 rotate 45*y translate <60,0,0> }
object { Build2 rotate 45*y translate <60,0,0> }

object { Build1 rotate 45*y translate <-60,0,0> }
object { Build2 rotate 45*y translate <-60,0,0> }

object { Chain scale .8 translate x*60 }
object { Chain scale .8 rotate 0*y translate x*-60 }
object { Chain scale .8 translate z*60 }
object { Chain scale .8 rotate y*45 translate z*-60 }

// chain apertures:
cylinder { <0,20,0>,<0,-.5,0>,65 open texture {Chrome_Texture} translate <0,230,0> }
cylinder { <0,.5,0>,<0,-.5,0>,105 open pigment {Grey} translate <0,241,0> }
// spacecraft lights:
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <-105,230,0> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <105,230,0> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <0,230,105> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <0,230,-105> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <74.25,230,74.25> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <-74.25,230,74.25> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <74.25,230,-74.25> }
cylinder { <0,.5,0>,<0,-.5,0>,15 pigment { White} finish { Luminous } translate <-74.25,230,-74.25> }
// spacecraft fuselage:
cone { <0,.5,0>,107,<0,-.5,0>,305 open pigment {Grey} translate <0,241,0> }
torus { 280,25 pigment { Grey } translate <0,241,0> }
torus { 125,25 pigment { Grey } translate <0,241,0> }
torus { 171,25 pigment { Grey } translate <0,241,0> }

#declare Glower =
  cylinder { <0,0,0>,<0,-78,0>,1 scale <40,1,40>
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, .9> ]
      }
      samples 10
      scale 25
    }
    hollow
  }

object { Glower translate x*-60 }
object { Glower translate x*60 }
object { Glower translate z*-60 }
object { Glower translate z*60 }

// star eclipsing sphere:
object{
sphere
{
  <0, 0, 0> // center of sphere <X Y Z>
  500       // radius of sphere
}
clipped_by {
box
{
  <-1000, -1, -1000>  // one corner position <X1 Y1 Z1>
  < 1000,  1000,  1000>  // other corner position <X2 Y2 Z2>
//  translate 2000*y
}
}
hollow
pigment { Black }
//translate -500*y
}


// stars:
object {
        sphere { <0,0,0>,1 hollow}
        texture
{
  pigment
  {
    granite turbulence <5,1,1>
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.72 color rgb<0.000, 0.000, 0.000>]
      [0.75 color rgb<0.800, 0.800, 0.800>]
      [0.77 color rgb<0.200, 0.200, 0.200>]
      [0.78 color rgb<0.949, 0.949, 0.949>]
      [0.81 color rgb<0.000, 0.000, 0.000>]
      [0.85 color rgb<1.000, 1.000, 1.000>]
      [0.91 color rgb<0.949, 0.949, 0.949>]
      [0.91 color rgb<0.000, 0.000, 0.000>]
      [1.00 color rgb<0.000, 0.000, 0.000>]
    }
  }
scale 0.03}
        scale <4000,4000,4000>
        finish { Luminous }
}

