#include "colors.inc"
#include "metals.inc"
#include "shapes.inc"
#include "glass.inc"

#declare BlackGreen = rgb < 0, .32, .12>

#declare F_Glass_Colored = 
finish {
    ambient 0.4
    diffuse 0
    reflection 0.5
    refraction 1
    ior 1.5
    phong 0.3
    phong_size 60
}

#declare roughGrips= texture {
	pigment{
		color Gray10
	}
	finish{
		roughness 0.65
	}
}

camera {
  location <-.7,-2.5,-7>
  look_at  <-.7,-1.5,0>
  blur_samples 20
}

light_source { <-0.7,-1.5,-10> White }

#declare horBars=
union{
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.05,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.1,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.15,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.2,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.05,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.1,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.15,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.2,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.25,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.3,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.35,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.25,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.3,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.35,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.4,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.45,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,-0.5,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.4,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.45,0>}
  box{<-1,-0.05,-0.05>,<1,0.05,0.05> rotate x*45 translate <0,0.5,0>}
}

#declare verBars=
object{horBars rotate z*90}

#declare tooledTexture=
union{
  object{horBars}
  object{verBars}
}

#declare Gun=
union{
  cylinder{  //main barrel
    <0,0,0>,<0,-3.5,0>,.7
  }
  box{<-0.9,-0.5,-0.4>,<0.2,0.5,0.4>} //top box, ammo storage?
  //cone{<0,0,0>,0.7,<0,0.2,0>,0.2}
  union{
    box{<0,0,-0.2>,<3.5,-1,0.2>} //handle
    cylinder{<0,0,0>,<3.5,0,0>,0.2}
    cylinder{<0,-1,0>,<3.5,-1,0>,0.2}
    box{<0.1,-0.1,-0.21>,<3.4,-0.9,0.21> texture{roughGrips}}
    rotate z*15
  }
  difference{  //tooled top grip
    cylinder{<-0.2,.3,-0.7>,<-0.2,.3,0.7>,0.5}
    cylinder{<-0.2,.3,-0.5>,<-0.2,.3,-1>,0.17}
    object{tooledTexture translate <-0.2,.3,-.7>}
  }
  cylinder{  //underbarrel
    <0,0,0>,<0,-3.3,0>,0.2
    scale <1,1,3>
    translate<0.7,0,0>
  }
  difference{
    box{<0.8,0,0.2>,<1,-3.3,-0.2>}
    box{<0.85,0,-0.1>,<0.95,-3.5,-0.3>}
  }
  difference{  //top of the rear grip
    cone{
      <-0.2,.3,0>,0.7,<1.5,.23,0>,0.1
    }
    cylinder{
      <-0.2,.3,-0.5>,<-0.2,.3,-1>,0.17
    }
  }
  //torus {     0.8,0.1 rotate x*90 translate<0.5,-0.5,0>} //trigger guard
  difference {
    superellipsoid {<0.25,0.25>}
    superellipsoid {<0.25,0.25> scale 0.95}
    box{<-2,-2,-2>,<2,2,-0.2>}
    box{<-2,-2,0.2>,<2,2,2>}
    box{<-2,0,-2>,<2,2,2>}
    translate <0.7,-0.7,0>
  }
  sphere{<0.9,-3,-0.1>,0.05 pigment{color Red} finish{ambient 0.8}}
  sphere{<0.9,-2.8,-0.1>,0.05 pigment{color Blue} finish{ambient 0.8}}
  sphere{<0.9,-2.6,-0.1>,0.05 pigment{color Red} }
  sphere{<0.9,-2.5,-0.1>,0.05 pigment{color Red} }
  sphere{<0.9,-2.4,-0.1>,0.05 pigment{color Yellow} }
  sphere{<0.9,-2.3,-0.1>,0.05 pigment{color Green} }

}

object{  Gun  //Put the gun in the case
  texture{T_Chrome_5E}
  //pigment{color White}
  translate <0,0,-0.5>
  rotate z*-90
} 


#declare GunCase =  //Build half the shell for the gun case
union {
  intersection{
    box{<-8,-8,0>,<8,8,6> pigment{color ForestGreen} finish{crand 0.1}}
    superellipsoid{<.25,.25> translate<0,-1,0.9> scale <2.8,1.7,1>}
    translate<0,0,0.2>
  }
  difference{
    superellipsoid{<0.25,0.25> translate<0,0,1> scale<2.8,1.7,1> texture{T_Chrome_5E}}
    superellipsoid{<0.25,0.25> translate<0,0,0.9> scale<2.7,1.6,1> pigment{color ForestGreen}}
    translate <0,-1.7,0>
  }
  scale 1.75
}


difference{ //Lower lid of the gun case
  object {GunCase translate<-0.6,1.4,-1>}
  object{Gun rotate z*-90 translate<0,0,-0.2>}
}

object{GunCase translate <-0.6,7,-1>}  //Upper lid of the gun case
cylinder{<-4,1.2,-0.5>,<3,1.2,-0.5>,-0.1 texture{T_Chrome_5E}}  //Hinge


#declare StrangeBox=
union{
  box{<1.3,-2,-1>,<1.6,0,1>}
  cylinder{<1.3,-0.7,-1>,<1.3,-0.7,1>,0.05}
  cylinder{<1.3,-0.8,-1>,<1.3,-0.8,1>,0.05}
  cylinder{<1.3,-0.9,-1>,<1.3,-0.9,1>,0.05}
  cylinder{<1.5,-1.9,-1>,<1.5,-0.7,-1>, 0.05 texture{pigment{color Green} finish{F_Glass_Colored}}}
  texture{T_Chrome_5E}
}

object{StrangeBox}  //Hmmm, this is a strange box
object{StrangeBox translate<1,0,0>}  //Gee another, what is this thing?
object{StrangeBox translate<2,0,0>}  //I dunno, but I'm not going to touch it

union{  //Mr. Phelps, here's your instruction disk
  difference{
    cylinder{<0,0,0>,<0,0,-0.1>,1}
    cylinder{<0,0,0.1>,<0,0,-0.2>,0.3}
    texture{T_Chrome_5E}
  }
  difference{
    cylinder{<0,0,0>,<0,0,-0.1>,0.3}
    cylinder{<0,0,0.1>,<0,0,-0.2>,-0.15}
    texture{T_Glass1}
  }
  translate<-2.7,-2.7,-0.7>
}


