//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Originally generated by Moray version 2.0.
//  Post-edited by Nathan Kopp to include povray 3.0
//  features.
//
//  Date : October 28, 1996
//

global_settings {
   #max_trace_level 5
}

#declare UseAtmosphere = yes


// ********  T E X T U R E S  *******

#include "atlantis.inc"


// ******** C A M E R A ***********
camera {  //  Camera StdCam
  location  <34.2, -141.450, 27.90>
  direction <0.0,     0.0,  1.7912>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <8.278, 2.777, 10.000>
}


// ********* F O G  /  A T M O S P H E R E **********
#if (UseAtmosphere = yes)
  atmosphere {
    type 1
    //type 1 = ind, 2 = perp minimal, 3 = antiparallel minimal
    //samples 7
    samples 10

    distance 140
    // distance 140 for type 1
    // distance 250 for type 3 ?

    scattering 0.0025    // .002 for type 1
                        // .014 for type 3?

    //aa_level 4
    //aa_threshold 0.1
    //jitter 0.2

    //colour rgb<0.15, 0.15, 0.20>  // for type 3 ?
    colour rgb<0.065, 0.07, 0.10>  // for type 1

    //turbulence 0.4
  }

#else 
  fog {
     distance 140
     colour rgb<0.09, 0.09, 0.17>
     turbulence 0.4
  }

#end



// *******  L I G H T S *******
light_source {   // Light2
  <-50.000, -50.000, 300.000>
  #if (UseAtmosphere = yes)
    color rgb <0.094, 0.406, 0.500>
  #else
    color rgb<0.094, 0.406, 0.500> * 1.2
  #end
  shadowless
  atmosphere off
}

light_source {   // Light1
  <-50.000, -50.000, 301.000>
  color rgb <1.000, 1.000, 1.000>
}

//************* FX   LIGHTS (& fake spotlight) ******************
sphere {
  <0,0,0>,1
  translate <-12.6, 50.0, 34.8>
  scale .4
  pigment { rgb <1,1,1> }
  finish {
    diffuse 0
    ambient 2
    specular 0
    phong 0
  }
}

cone { // SpotLightHalo
  <0,0,0>, 0.1, <0,0,40>, 10.0

    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      poly
      max_value 1
      exponent 6
      color_map {
        [ 0.0 color rgbt <1, 1, 1, 1> ]
        [ 1.0 color rgbt <1, 1, 1, .6> ]
      }
      samples 10
      scale <40,40,30>  // z value changes length of visibility
      turbulence .02
    }

    finish {
      #if (UseAtmosphere = yes)
        fade_distance 70
      #else
        fade_distance 90  // also for atmospheres other than type 1
      #end
      fade_power 1.5
    }
  hollow
  no_shadow
  rotate 130.0*y
  translate  <-12.6, 50.0, 34.8>
}

light_source {   // HitFlash
  <21.773, -27.627, 16.373>
  color rgb <2.000, 2.000, 1.5>
  fade_distance 2
  fade_power 2
}

light_source {   // ShootLight
  <29.830, -127.876, 25.392>
  color rgb <2.000, 1.000, .5>
  fade_distance 1
  fade_power 2
}

light_source {   // LaserLight2
  <16.500, -84.8500, 7.95>
  color rgb <2.000, 0.000, 0.000>
  fade_distance 5
  fade_power 2
}

// ********** Dust cloud where laser hits ground ******

sphere { // DustCloud
  <0,0,0>,1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      spherical_mapping
      linear
      turbulence 1.5
      lambda 2.3
      omega .7
      color_map {
        [ 0.0 color rgbt <.3, .3, .3, 1> ]
        [ 0.7 color rgbt <.4, .3, .3, -1> ]
        [ 1.0 color rgbt <.4, .3, .3, -1> ]
      }
      samples 10
      scale 0.75
    }
    finish {
       refraction 1
       ior 1.330
       #if (UseAtmosphere = yes)
         fade_distance 70
       #else
         fade_distance 90  // also for atmospheres other than type 1
       #end
       fade_power 1.5
  }
  hollow
  no_shadow
  scale <5, 5, 5>
  rotate <0.0, 15.0, 0.0>
  translate  <13.8, -88.4, 6>
}


// ----------- Begin SUB1 (Curvy sub) declaration -----------
// This is actually just the declaration of the sub.  Two versions of this sub
// are used in the scene.
//
// Include file contains 'Sub1Sweep'
//
#include "sub1.in2"
#declare Sub1Sweep = object {
  Sub1Sweep_Raw
  scale <2.0, 1.0, 2.0>
  rotate -90.0*x
}
#declare UnderMSubTotal = merge {
  cylinder { // UnderMinus1
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.3, 10.0>
    rotate -90.0*x
    translate  <0.75, -5.15, -0.15>
  }
  cylinder { // UnderMinus2
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.3, 10.0>
    rotate -90.0*x
    translate  <-0.75, -5.15, -0.15>
  }
  box { // UnderMinus3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.0, 0.5>
    translate  -0.5*z
  }
}
#declare UnderMinusTotal = intersection {
  object { UnderMSubTotal }
  cylinder { // UnderMinus4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 10.0, 3.0>
    rotate <0.0, -90.0, 0.0>
    translate  <1.5, -5.55, -0.5>
  }
}
#declare TopSide = difference {
  object { Sub1Sweep }
  object { UnderMinusTotal }
  texture {
    Silver3
    scale <10.0, 3.2, 1.0>
    rotate 90.0*z
  translate <1.600000, -5.000000, 0.000000>
  }
}
#declare UnderSide = difference {
  cylinder { // UnderSide1
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 0.45, 6.8>
    rotate -90.0*x
    translate  <0.0, -2.6, 0.1>
  }
  cylinder { // UnderSide2
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 2.55, 2.65>
    rotate <0.0, -90.0, 0.0>
    translate  <1.35, 4.15, -0.6>
  }
  box { // UnderSide3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate 10.0*z
    translate  <1.2, 2.65, 0.0>
  }
  box { // UnderSide4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -10.0*z
    translate  <-1.2, 2.65, 0.0>
  }
  box { // UnderSide6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 2.6, 0.35>
    translate  <0.0, 3.5, 0.5>
  }
  texture {
    Silver3
  }
}
#declare Windshield = difference {
  sphere { // WindshieldSph
    <0,0,0>,1
    scale <1.1, 1.1, 0.45>
    translate  <0.0, -2.6, 0.1>
  }
  box { // WindShieldMinus
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.7, 0.5>
    translate  <0.0, -2.2, 0.65>
  }
  texture {
    Gold_Metal
  }
}
#declare JetOut = difference {
  cone { // JetOut1
    <0,0,0>, 0.3, <0,0,1>, 0.25
    open
    scale <1.0, 1.0, 0.4>
    rotate -90.0*x
    translate  4.3*y
  }
  box { // JetOutMinus1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.3, 0.4>
    translate  4.5*y
  }
  box { // JetOutMinus2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.3, 0.4>
    rotate -45.0*y
    translate  4.5*y
  }
  box { // JetOutMinus3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.3, 0.4>
    rotate -90.0*y
    translate  4.5*y
  }
  texture {
    DarkGrey
  }
  scale <2.0, 1.0, 1.0>
}
#declare DorsalFin = difference {
  cylinder { // Fin1a2
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 1.35, 0.05>
    rotate <90.0, 75.0, 90.0>
    translate  <-0.025, -0.4, 0.7>
  }
  cylinder { // Fin1a1
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.3, 0.1>
    rotate <-90.0, 60.0, -90.0>
    translate  <-0.05, 0.75, 0.7>
  }
  texture {
    Silver4
  }
}
#declare SideFin1 = difference {
  cylinder { // Fin1a3
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 1.35, 0.05>
    rotate <90.0, 75.0, 90.0>
    translate  <-0.025, -0.4, 0.7>
  }
  cylinder { // Fin1a4
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.3, 0.1>
    rotate <-90.0, 60.0, -90.0>
    translate  <-0.05, 0.75, 0.7>
  }
  texture {
    Silver4
  }
  scale <1.0, 1.3, 1.3>
  rotate <-155.0, -80.0, -180.0>
  translate  <0.35, 4.0, 0.1>
}
#declare SideFin2 = difference {
  cylinder { // Fin1a5
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 1.35, 0.05>
    rotate <90.0, 75.0, 90.0>
    translate  <-0.025, -0.4, 0.7>
  }
  cylinder { // Fin1a6
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.3, 0.1>
    rotate <-90.0, 60.0, -90.0>
    translate  <-0.05, 0.75, 0.7>
  }
  texture {
    Silver4
  }
  scale <1.0, 1.3, 1.3>
  rotate <-155.0, -280.0, -180.0>
  translate  <-0.35, 4.0, 0.1>
}
#declare Sub1shell = merge {
  object { TopSide }
  object { UnderSide }
  object { Windshield }
  object { JetOut }
  object { DorsalFin }
  object { SideFin1 }
  object { SideFin2 }
}
#declare Sub1 = difference { // Sub1
  object { Sub1shell }
  cylinder { // Duct1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Bronze_Textur
    }
    scale <0.4, 0.15, 1.6>
    rotate <-90.0, -25.0, 0.0>
    translate  <1.15, -4.15, 0.45>
  }
  cylinder { // Duct2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Bronze_Textur
    }
    scale <0.4, 0.15, 1.6>
    rotate <-90.0, 25.0, 0.0>
    translate  <-1.15, -4.15, 0.45>
  }
  cylinder { // Duct3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Bronze_Textur
    }
    scale <0.1, 0.1, 1.6>
    rotate <-90.0, -25.0, 0.0>
    translate  <0.95, -3.0, 0.35>
  }
  cylinder { // Duct4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Bronze_Textur
    }
    scale <0.1, 0.1, 1.6>
    rotate <-90.0, -25.0, 0.0>
    translate  <-0.95, -3.0, 0.35>
  }
  sphere { // Underside7
    <0,0,0>,1
    texture {
      Black
    }
    scale <0.85, 0.8, 0.25>
    translate  <0.0, -2.6, -0.05>
  }
}


// ---------------- End SUB1 Declaration ----------------

// ************** Sub type 1 being hit ******************
union { // HitSub
  object { // Sub1b->Sub1
    Sub1
    scale 1.5
  }
  sphere { // SmokeCloud
    0,1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      spherical_mapping
      linear
      turbulence 1
      color_map {
        [ 0 color rgbt <.5, .5, .5,  1> ]
        [ 1 color rgbt <.5, .5, .5, 0> ]
      }
      samples 10
      scale 0.75
    }
    hollow
    scale <2.0, 20.0, 1.0>
    rotate <-5.0, 0.0, 0.0>
    translate  <-0.05, 19.0, 0.0>
  }
  sphere { // HitFlashSph
    <0,0,0>,1
    texture {
      HitTex
    }
    no_shadow
    scale <0.35, 1.0, 0.2>
    rotate -25.0*y
    translate  <-1.55, -2.05, 0.8>
  }
  rotate <45.0, -45.0, 0.0>
  translate  <22.6, -25.4, 17.95>
}

// *************** Sub type 1 (firing laser beam) **********************
object { // Sub1a->Sub1
  Sub1
  scale 1.5
  rotate <10.0, 0.0, -40.0>
  translate  <46.950001, -48.600001, 19.95>
}


// ************ the laser beam (with turbulence) ***************
union { // LaserBeam
  cylinder { // LaserShot
    <0,0,1>, <0,0,0>, 1 
    texture {
      RedLaser
    }
    no_shadow
    scale <0.05, 0.05, 1.0>
  }
  cylinder { // LaserTurb
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.35, 0.35, 1.0>
    texture {
      LaserTurbTex
    }
    hollow
  }
  scale <1.5, 1.5, 50.0>
  rotate <105.0, 0.0, -40.0>
  translate  <43.550001, -52.650001, 19.4>
}


// ***************** the ocean floor ******************
object {   // HgtFld001
  height_field {
    tga "seafloor.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <110.5, 102.650002, 26.050001>
  translate  <0.0, 1.2, 21.1>
  texture {
    Dirt
  }
}

plane { // GroundPlane
  z,0
  translate  <-0.25, 1.25, -4.9>
  texture {
    Dirt
  }
}


// ********** begin Sub2 (Not referenced...only one copy) ***********
#declare Sub2Shell = intersection {
  cylinder { // TopEdge
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 6.0, 5.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.5, 0.0, -4.0>
  }
  cylinder { // BottomEdge
    <0,0,1>, <0,0,0>, 1 
    scale <9.900001, 4.5, 5.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.5, 0.0, 3.0>
  }
  cone { // TopCone
    <0,0,0>, 0.4, <0,0,1>, 1.0
    scale <3.4, 12.8, 5.45>
    rotate 180.0*x
    translate  2.55*z
  }
  cone { // BottomCone
    <0,0,0>, 0.4, <0,0,1>, 1.0
    open
    scale <3.4, 12.8, 5.45>
    translate  -2.55*z
  }
  texture {
    Silver3
    scale <6.15, 18.9, 1.0>
    rotate <-180.0, -90.0, 0.0>
  translate <0.000000, 9.500000, -3.450000>
  }
  scale <2.0, 1.0, 0.8>
}
#declare Sub3Union1 = union {
  object { Sub2Shell }
  sphere { // GunFlare
    <0,0,0>,1
    texture {
      Silver3
    }
    scale <0.32, 0.32, 1.0>
    rotate -90.0*x
    translate  <4.0, 1.19, -0.7>
  }
  cylinder { // Cyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver4
    }
    scale <0.03, 0.03, 0.7>
    rotate <180.0, 55.0, 180.0>
    translate  <3.25, 0.0, -0.9>
  }
  cylinder { // Cyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver4
    }
    scale <0.03, 0.03, 0.7>
    rotate <180.0, 55.0, 180.0>
    translate  <3.25, -0.5, -0.9>
  }
  cylinder { // Cyl3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver4
    }
    scale <0.03, 0.03, 0.7>
    rotate <180.0, 55.0, 180.0>
    translate  <3.25, -1.0, -0.9>
  }
  cylinder { // Cyl4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver4
    }
    scale <0.03, 0.03, 0.7>
    rotate <180.0, 55.0, 180.0>
    translate  <3.25, -1.5, -0.9>
  }
}
#declare Hatch = difference {
  cylinder { // HatchOuter
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate 45.0*y
    translate  <29.7, -131.000002, 27.25>
  }
  cylinder { // HatchInner
    <0,0,1>, <0,0,0>, 1 
    scale <0.55, 0.55, 0.7>
    rotate 45.0*y
    translate  <29.65, -131.000002, 27.2>
  }
  texture {
    Bronze_Textur
  }
  rotate 0.0*y
  translate  <-25.9, 131.15, -26.45>
}
#declare Sub3Diff = difference {
  object { Sub3Union1 }
  cylinder { // GunMinus
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black
    }
    scale <0.32, 0.32, 1.51>
    rotate -90.0*x
    translate  <4.0, 1.19, -0.7>
  }
  object { Hatch }
}
#declare Gatling = union {
  cylinder { // Turret1
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 1.0>
    translate  -4.3*z
  }
  cylinder { // Turret2
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 1.0>
    translate  -3.7*z
  }
  cylinder { // Turret
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 1.0>
    translate  -3.0*z
  }
  cylinder { // Gun1
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    translate  <-1.0, 0.0, -2.0>
  }
  cylinder { // Gun2
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate -30.0*z
    translate  <-0.866025, 0.5, -2.0>
  }
  cylinder { // Gun3
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate -60.0*z
    translate  <-0.5, 0.866025, -2.0>
  }
  cylinder { // Gun4
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate -90.0*z
    translate  <0.0, 1.0, -2.0>
  }
  cylinder { // Gun5
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate -120.0*z
    translate  <0.5, 0.866025, -2.0>
  }
  cylinder { // Gun6
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate -150.0*z
    translate  <0.866025, 0.5, -2.0>
  }
  cylinder { // Gun7
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 180.0*z
    translate  <1.0, 0.0, -2.0>
  }
  cylinder { // Gun8
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 150.0*z
    translate  <0.866025, -0.5, -2.0>
  }
  cylinder { // Gun9
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 120.0*z
    translate  <0.5, -0.866025, -2.0>
  }
  cylinder { // Gun10
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 90.0*z
    translate  <0.0, -1.0, -2.0>
  }
  cylinder { // Gun11
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 60.0*z
    translate  <-0.5, -0.866025, -2.0>
  }
  cylinder { // Gun12
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 4.0>
    rotate 30.0*z
    translate  <-0.866025, -0.5, -2.0>
  }
  texture {
    Silver4
  }
  scale 0.2
  rotate -90.0*x
  translate  <4.0, 2.05, -0.7>
}
// ------- end declarations for sub3 ----------------------------------
// ******* now place it in the scene (with other stuff added) *********
union { // Sub3Union2
  object { Sub3Diff }
  object { Gatling }
  cylinder { // Shots1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.1, 100.0>
    rotate <-90.8, 0, .6>
    //rotate <-90.5, 0, .5> ???????
    translate  <4.22, 3.05, -0.7>
    texture {
      Bubbles1
    }
    hollow
    no_shadow
  }
  cylinder { // ShootCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShotTex
    }
    no_shadow
    hollow
    scale <0.2, 0.2, 1.5>
    rotate -90.0*x
    translate  <4.2, 2.5, -0.7>
  }
  superellipsoid { // BumpOnSub
    <.2,.2>
    texture {
      Silver4
      //Copper_Textur1
    }
    scale 0.2
    rotate <0.0, 50.0, 0.0>
    translate  <3.7, -1.600002, 0.75>
  }

  rotate <-5.0, 0.0, 5.0>
  translate  <25.9, -131.15, 26.45>
}

//*********** The mining colony in the background **********
cylinder { // Colony
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <6.0, 6.0, 17.5>
  translate  <-17.15, 50.050001, 7.45>
}
box { // PostTop
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BlackVoid
  }
  scale <1.3, 1.3, 0.2>
  translate  <-14.0, 50.000001, 35.050001>
}


cylinder { // Post4
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <0.3, 0.3, 10.0>
  translate  <-15.0, 49.0, 25.0>
}


cylinder { // Post3
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <0.3, 0.3, 10.0>
  translate  <-13.0, 49.0, 25.0>
}


cylinder { // Post2
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <0.3, 0.3, 10.0>
  translate  <-13.0, 51.0, 25.0>
}


cylinder { // Post1
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <0.3, 0.3, 10.0>
  translate  <-15.0, 51.0, 25.0>
}

//********* The big submarine in the background **********
cylinder { // SubMiddle
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackVoid
  }
  scale <2.0, 2.0, 17.5>
  rotate <0.0, -90.0, 0.0>
  translate  <33.0, 70.0, 25.0>
}

box { // BigSubCube
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BlackVoid
  }
  scale <4.35, 0.55, 1.65>
  translate  <23.45, 70.0, 28.15>
}

sphere { // BigSubBack
  <0,0,0>,1
  texture {
    BlackVoid
  }
  scale <15.0, 2.0, 2.0>
  translate  <15.7, 70.0, 25.0>
}

sphere { // BigSubFront
  <0,0,0>,1
  texture {
    BlackVoid
  }
  scale <15.0, 2.0, 2.0>
  translate  <33.0, 70.0, 25.0>
}

//********** The water surface **********
plane { // WaterPlane
  z,0
  texture {
    Water
  }
  translate  <0.0, 0.75, 50>
  hollow
}

