
// Persistence of Vision Ray Tracer Include File
// File: laser.inc
// Vers: 3
// Desc: Rotatable laser turret
// Date: Sep 1996
// Auth: Roy Schulz

union {
  difference {
    union {
      box { -1, 1 scale <0.3, 1, 0.3> }
      cylinder { <-0.3, 1, 0>, <0.3, 1, 0>, 0.3 }
    }
    box { <-0.2, 0.4, -2>, <0.2, 2, 2> }
  }
  cylinder { <-0.21, 1.1, 0>, <0.21, 1.1, 0>, 0.05 }
  union {
    difference {
      cylinder { <0, 0, -0.5>, <0, 0, 1.6>, 0.1 }
      cylinder { <0, 0, -0.4>, <0, 0, 1.7>, 0.08 }
    }
    #declare i=-0.4
    #while (i<0.5)
      torus {
        0.13, 0.03
        rotate x*90
        translate z*i
      }
      #declare i=i+0.1
    #end
    #declare i=1.3
    #while (i<1.6)
      torus {
        0.13, 0.03
        rotate x*90
        translate z*i
      }
      #declare i=i+0.1
    #end
    cylinder {
      0, <0, 1, 0>, 1
      pigment { color rgbt <1, 1, 1, 1> }
      hollow
      halo {
        emitting
        cylindrical_mapping
        linear
        color_map {
          [ 0 color rgbt <1, 0, 1, 1> ]
          [ 1 color rgbt <1, 0.8, 1, -1> ]
        }
      }
      scale <0.1, length, 0.1>
      translate y*1.6
      rotate x*90
    }
    rotate -x*vertical
    translate y*1.1
  }
  pigment { White }
  finish { reflection 0.5 }
  rotate y*horizontal
  translate y*4.5
  scale 0.2
}
