
// Persistence of Vision Ray Tracer Include File
// File: slab.inc
// Vers: 3
// Desc: concrete slab for landing pad
// Date: Oct 1996
// Auth: Roy Schulz

#declare Lighting = union {
  difference {
    sphere { 0, 1 }
    sphere { 0, 0.8 }
    box { <0, -1.1, -1.1>, 1.1 }
  }
  light_source {
    <0, 0.4, 0>
    color light*2
    area_light  <0.6, 0.6, 0>, <0, 0, 0.6>, 4, 4
    adaptive 1
    jitter
    fade_power 8
    fade_distance 0.6
    looks_like { sphere { <0, -0.6, 0>, 0.8 pigment { light } finish { ambient 1 } } }
  }
}

union {
  difference {
    intersection {
      superellipsoid {
        <0.3, 0.3>
      }
      box { <-1.01, 0, -1.01>, <1.01, 0.03, 1.01> }
      bounded_by { box { <-1.01, 0, -1.01>, <1.01, 0.03, 1.01> } }
    }
    cylinder { -y, y, 0.8 }
  }
  object {
    Lighting
    scale 0.07
    rotate y*45
    translate <-0.73, 0.03, 0.73>
  }
  object {
    Lighting
    scale 0.07
    rotate y*135
    translate <0.73, 0.03, 0.73>
  }
  object {
    Lighting
    scale 0.07
    rotate -y*45
    translate <-0.73, 0.03, -0.73>
  }
  object {
    Lighting
    scale 0.07
    rotate -y*135
    translate <0.73, 0.03, -0.73>
  }
  pigment {
    image_map {
      gif "stripes.gif"
      once
    }
    rotate x*90
    scale 2
    translate <-1, 0, -1>
  }
  finish { ambient 0.2 }
}
