// B5_JUMP  961025 - Created for the ray-trace competision at www.povray.org
//
// Copyright David Eliasson 1996
// Comments to David@cebec.arosnet.se


#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare gube=
  union
    {
      intersection
        {
          sphere { <0,0,0> 2 texture { pigment { color rgb <0,.3,.6> } finish { Metal } } }
          box { <-3,-1,-3> <3,3,3> texture { pigment { color rgb <0,.3,.6> } finish { Metal } } }
        }
      intersection
        {
          box { <-3,-1,-1> <3,1.5,3> texture { pigment{ White }
          finish { ambient 0.1 diffuse 0.7 brilliance 6.0 reflection 1 phong 0.8 phong_size 120 } } }
          sphere { <0,0,0> 2.02  texture { pigment{ White }
          finish { ambient 0.1 diffuse 0.7 brilliance 6.0 reflection 1 phong 0.8 phong_size 120 } } }
         }
      cylinder { <0,-1,0> <0,-2,0> 0.6  texture { pigment { color rgb <0,.3,.6> } finish { Metal } } }
      cylinder { <0,-5,0> <0,-2,0> 1.5 scale <2,1,1> texture { pigment { granite turbulence 0.1 color_map
       {
         [0.0, 0.3 color rgb <0.0, 0.0, 0.3> color rgb <1.0, 0.5, 0.5>]
         [0.3, 1.0 color rgb <0.3, 0.3, 0.9> color rgb <1.0, 0.2, 0.2>]
       } } finish { ambient 0.1 diffuse 0.7 brilliance 2.0 reflection 0.4 phong 0.3 phong_size 120 } } }
      cylinder { <-1,-5,3> <-3.3,-2.5,0> 0.5 texture { pigment { granite turbulence 0.1 color_map
       {
         [0.0, 0.3 color rgb <0.0, 0.0, 0.3> color rgb <1.0, 0.5, 0.5>]
         [0.3, 1.0 color rgb <0.3, 0.3, 0.9> color rgb <1.0, 0.2, 0.2>]
       } } finish { ambient 0.1 diffuse 0.7 brilliance 2.0 reflection 0.4 phong 0.3 phong_size 120 } } }
      cylinder { <1,-5,3> <3.3,-2.5,0> 0.5 texture { pigment { granite turbulence 0.1 color_map
       {
         [0.0, 0.3 color rgb <0.0, 0.0, 0.3> color rgb <1.0, 0.5, 0.5>]
         [0.3, 1.0 color rgb <0.3, 0.3, 0.9> color rgb <1.0, 0.2, 0.2>]
       } } finish { ambient 0.1 diffuse 0.7 brilliance 2.0 reflection 0.4 phong 0.3 phong_size 120 } } }
      cylinder { <0,-6.5,0> <0,-5,0> 1.5 scale <2,1,1> texture { pigment { color Blue } } }
      cylinder { <-1.5,-6.,0> <-2,-6,4> 0.7 texture { pigment { color Blue } } }
      cylinder { <1.5,-6,0> <2,-6,4> 0.7 texture { pigment { color Blue } } }
      sphere { <-2,-6,4> 0.7 texture { pigment { color Blue } } }
      sphere { <2,-6,4> 0.7 texture { pigment { color Blue } } }
      cone { <-2,-6,4> 0.7 <-2,-8,4> 0.4 texture { pigment { color Blue } } }
      cone { <2,-6,4> 0.7 <2,-8,4> 0.4 texture { pigment { color Blue } } }

      box { <-3,-8,3.5> <3,-6.7,-1> texture { pigment { color rgb <0.3 0.3 0.8> } } }
      box { <-3,-8,-1> <3,0,-2.3> texture { pigment { color rgb <0.3 0.3 0.8> } } }
      cylinder { <-3,0,-1.65> <3,0,-1.65> 1 texture { pigment { color rgb <0.3 0.3 0.8> } } }
    }

#declare power=
sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0 color rgbt <1,1,1,0.5> ]
      [ 1 color rgbt <0,0,0.8,-1.0> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale 1.5
}

#declare power2=
cone { <0,0,0>,0.4 <0,0,4>,0.2
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0 color rgbt <1,1,1,0.5> ]
      [ 1 color rgbt <0,0,0.8,-1.0> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale 1.5
}

#declare engine=
   light_source { <0,0,0> color rgb <0.7 0.7 1.0>
        looks_like {
          union {
            object { power }
            object { power2 }
                } } fade_distance 6 fade_power 1.4 }

#declare gun=
  union
    {
      cylinder { <0,0,1> <0,0,-0.5> 0.3 texture { pigment{ Grey } finish { Metal } } }
      cylinder { <0,0,-0.5> <0,0,-1.1> 0.1 texture { pigment{ Grey } finish { Metal } } }
      cylinder { <0,0,-1.1> <0,0,-1.3> 0.3 texture { pigment{ Grey } finish { Metal } } }
      cone { <0,0,-1.3>,0.3 <0,0,-1.5> 0.2 open texture { pigment{ Grey } finish { Metal } } }
     }


#declare Window_finish=
  finish { specular 1 roughness 0.001 ambient 0 diffuse 0 reflection 0.3 refraction 0 ior 1.0 }

#declare starf=
  union
    {
      // Cabin

      cylinder { <-2,0,0> <-1,2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <-1,2,0> <1,2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <2,0,0> <1,2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <-2,0,0> <-1,-2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <-1,-2,0> <1,-2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <2,0,0> <1,-2,0> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }

      cylinder { <-1,2,0> <-0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <1,2,0> <0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <-1,-2,0> <-0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <1,-2,0> <0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }

      cylinder { <-2,0,0> <-0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <2,0,0> <0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }
      cylinder { <-0.8,0,-2> <0.8,0,-2> 0.1 texture { pigment{ Grey } finish { Metal reflection 0.6 } } }

      light_source { <0,-1,-2> color rgb <0.0,0.3,0.0> looks_like {
        polygon { 5 , <-1,-0.3,2>,<1,-0.3,2>,<1,0,1>,<-1,0,1>,<-1,-0.3,2>
                texture { pigment { color rgb <0.0,0.3,0.0> } finish { Metal } } } } fade_distance 2 fade_power 2 }

      object { gube scale 0.3 rotate <0,180,0> translate <0,.6,1.8> }

      // Windows

      polygon { 5 , <-1,2,0>,<1,2,0>,<0.8,0,-2>,<-0.8,0,-2>,<-1,2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }
      polygon { 5 , <-1,-2,0>,<1,-2,0>,<0.8,0,-2>,<-0.8,0,-2>,<-1,-2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }
      polygon { 4 , <-1,2,0>,<-0.8,0,-2>,<-2,0,0>,<-1,2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }
      polygon { 4 , <-1,-2,0>,<-0.8,0,-2>,<-2,0,0>,<-1,-2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }
      polygon { 4 , <1,2,0>,<0.8,0,-2>,<2,0,0>,<1,2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }
      polygon { 4 , <1,-2,0>,<0.8,0,-2>,<2,0,0>,<1,-2,0>
                texture { pigment { color Clear } finish { Window_finish } } hollow
              }

      // Top and bottom

      polygon { 9 , <-1,2,0>,<-2,2,.5>,<-2.5,2,1>,<-2.5,2,4>,<2.5,2,4>,<2.5,2,1>,<2,2,.5>,<1,2,0>,<-1,2,0>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 9 , <-1,-2,0>,<-2,-2,.5>,<-2.5,-2,1>,<-2.5,-2,4>,<2.5,-2,4>,<2.5,-2,1>,<2,-2,.5>,<1,-2,0>,<-1,-2,0>
                texture { pigment{ Grey } finish { Metal } }
              }

      // Sides

      polygon { 4 , <1,2,0>,<2,2,.5>,<2,0,0>,<1,2,0>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <2,2,.5>,<2.5,2,1>,<2,0,0>,<2,2,.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <1,-2,0>,<2,-2,.5>,<2,0,0>,<1,-2,0>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <2,-2,.5>,<2.5,-2,1>,<2,0,0>,<2,-2,.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <2.5,-2,1>,<2,0,0>,<2.5,2,1>,<2.5,-2,1>
                texture { pigment{ Grey } finish { Metal } }
              }

      polygon { 4 , <-1,2,0>,<-2,2,.5>,<-2,0,0>,<-1,2,0>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <-2,2,.5>,<-2.5,2,1>,<-2,0,0>,<-2,2,.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <-1,-2,0>,<-2,-2,.5>,<-2,0,0>,<-1,-2,0>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <-2,-2,.5>,<-2.5,-2,1>,<-2,0,0>,<-2,-2,.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 4 , <-2.5,-2,1>,<-2,0,0>,<-2.5,2,1>,<-2.5,-2,1>
                texture { pigment{ Grey } finish { Metal } }
              }


      polygon { 5 , <2.5,2,1>,<2.5,2,4>,<2.5,-2,4>,<2.5,-2,1>,<2.5,2,1>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <-2.5,2,1>,<-2.5,2,4>,<-2.5,-2,4>,<-2.5,-2,1>,<-2.5,2,1>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <2.5,2,4>,<2.5,-2,4>,<-2.5,-2,4>,<-2.5,2,4>,<2.5,2,4>
                texture { pigment{ Grey } finish { Metal } }
              }

      // Wing right up
      polygon { 5 , <2.5,2,1.5>,<7,4,2>,<7,4,5>,<2.5,2,4>,<2.5,2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Wing - tipp
      polygon { 5 , <7,4,2>,<8,4,2>,<8,4,5>,<7,4,5>,<7,4,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Lower part
      polygon { 5 , <2.5,1,1.5>,<7,3.8,2>,<7,3.8,5>,<2.5,1,4>,<2.5,1,1.5>   //1.2
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <7,3.8,2>,<8,3.8,2>,<8,3.8,5>,<7,3.8,5>,<7,3.8,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Leading edge
      cone { <2.5,1.5,1.5>, 0.5 <7,3.9,2>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <7,4,2> <8,4,2> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Tailing edge
      cone { <2.5,1.6,4>, 0.3 <7,3.9,5>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <7,4,5> <8,4,5> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Thruster
      cone { <8.5,4,0>,0.5 <8.5,4,5.5>,0.8
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <8.5,4,0> <8.5,4,-0.3> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <8.5,4,1> <9.5,4,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <8.5,4,1> <8.5,5,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cone { <8.5,4,5.5>,0.7 <8.5,4,6>,0.5 open
                texture { pigment{ Black } finish { Metal } }
              }

      // Wing left up
      polygon { 5 , <-2.5,2,1.5>,<-7,4,2>,<-7,4,5>,<-2.5,2,4>,<-2.5,2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Wing - tipp
      polygon { 5 , <-7,4,2>,<-8,4,2>,<-8,4,5>,<-7,4,5>,<-7,4,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Lower part
      polygon { 5 , <-2.5,1,1.5>,<-7,3.8,2>,<-7,3.8,5>,<-2.5,1,4>,<-2.5,1,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <-7,3.8,2>,<-8,3.8,2>,<-8,3.8,5>,<-7,3.8,5>,<-7,3.8,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Leading edge
      cone { <-2.5,1.5,1.5>, 0.5 <-7,3.9,2>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-7,4,2> <-8,4,2> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Tailing edge
      cone { <-2.5,1.6,4>, 0.3 <-7,3.9,5>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-7,4,5> <-8,4,5> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Thruster
      cone { <-8.5,4,0>,0.5 <-8.5,4,5.5>,0.8
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-8.5,4,0> <-8.5,4,-0.3> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <-8.5,4,1> <-9.5,4,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <-8.5,4,1> <-8.5,5,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cone { <-8.5,4,5.5>,0.7 <-8.5,4,6>,0.5 open
                texture { pigment{ Black } finish { Metal } }
              }

      // Wing right down
      polygon { 5 , <2.5,-2,1.5>,<7,-4,2>,<7,-4,5>,<2.5,-2,4>,<2.5,-2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Wing - tipp
      polygon { 5 , <7,-4,2>,<8,-4,2>,<8,-4,5>,<7,-4,5>,<7,-4,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Lower part
      polygon { 5 , <2.5,-1.2,1.5>,<7,-3.8,2>,<7,-3.8,5>,<2.5,-1.2,4>,<2.5,-1.2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <7,-3.8,2>,<8,-3.8,2>,<8,-3.8,5>,<7,-3.8,5>,<7,-3.8,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Leading edge
      cone { <2.5,-1.6,1.5>, 0.3 <7,-3.9,2>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <7,-4,2> <8,-4,2> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Tailing edge
      cone { <2.5,-1.6,4>, 0.3 <7,-3.9,5>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <7,-4,5> <8,-4,5> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Thruster
      cone { <8.5,-4,0>,0.5 <8.5,-4,5.5>,0.8
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <8.5,-4,0> <8.5,-4,-0.3> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <8.5,-4,1> <9.5,-4,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <8.5,-4,1> <8.5,-5,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cone { <8.5,-4,5.5>,0.7 <8.5,-4,6>,0.5 open
                texture { pigment{ Black } finish { Metal } }
              }

      // Wing left down
      polygon { 5 , <-2.5,-2,1.5>,<-7,-4,2>,<-7,-4,5>,<-2.5,-2,4>,<-2.5,-2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Wing - tipp
      polygon { 5 , <-7,-4,2>,<-8,-4,2>,<-8,-4,5>,<-7,-4,5>,<-7,-4,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Lower part
      polygon { 5 , <-2.5,-1.2,1.5>,<-7,-3.8,2>,<-7,-3.8,5>,<-2.5,-1.2,4>,<-2.5,-1.2,1.5>
                texture { pigment{ Grey } finish { Metal } }
              }
      polygon { 5 , <-7,-3.8,2>,<-8,-3.8,2>,<-8,-3.8,5>,<-7,-3.8,5>,<-7,-3.8,2>
                texture { pigment{ Grey } finish { Metal } }
              }
      // Leading edge
      cone { <-2.5,-1.6,1.5>, 0.3 <-7,-3.9,2>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-7,-4,2> <-8,-4,2> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Tailing edge
      cone { <-2.5,-1.6,4>, 0.3 <-7,-3.9,5>,0.1
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-7,-4,5> <-8,-4,5> 0.1 texture { pigment{ Grey } finish { Metal } } }
      // Thruster
      cone { <-8.5,-4,0>,0.5 <-8.5,-4,5.5>,0.8
                texture { pigment{ Grey } finish { Metal } }
              }
      cylinder { <-8.5,-4,0> <-8.5,-4,-0.3> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <-8.5,-4,1> <-9.5,-4,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cylinder { <-8.5,-4,1> <-8.5,-5,1> 0.3 open texture { pigment{ Black } finish { Metal } } }
      cone { <-8.5,-4,5.5>,0.7 <-8.5,-4,6>,0.5 open
                texture { pigment{ Black } finish { Metal } }
              }
      object { engine translate <8.5,4,6> }
      object { engine translate <-8.5,4,6> }
      object { engine translate <8.5,-4,6> }
      object { engine translate <-8.5,-4,6> }

      object { gun translate <-2,-1.5,0> }
      object { gun translate <2,-1.5,0> }
      intersection
        {
          box { <-2,2,0> <2,4,4> texture { pigment{ Grey } finish { Metal } } }
          sphere { <0,0,2> 3 texture { pigment{ Grey } finish { Metal } } }
         }
   }



