#include "colors.inc"
#include "metals.inc"
#include "stars.inc"
#include "stones1.inc"
#include "textures.inc"
#include "klingon.inc"
#include "ncc1701b.inc"

#declare R1 = seed(0)

camera {
       location <-5, 5, -10>
       look_at <-5, 5, 0>
}

light_source { <1000, 600, -1000> color White }

sphere {
       <0, 0, 0>, 3500
       texture { Starfield1 scale 100 }
       hollow
}

height_field {
             gif "battle1.ghf"
             texture {
                     pigment {
                             image_map {
                                       gif "battle1.ghf"
                             }
                             turbulence 0.2
                     }
             }
             translate <-0.5, 0, -0.5>
             scale <50, 10, 50>
             smooth
             hollow
}

plane {
      <0, 1, 0>, 3
      texture {
              T_Grnt4
              finish {
                     crand 0.1
              }
              normal {
                     dents
                     scale 0.2
                     turbulence 0.2
                     translate <-5, 0, -10>
              }
      }
      hollow
}

union {
      sphere { <0, 0, 0>, 1 }
      cylinder { <0, 0, 0>, <2, 0, 0>, 0.1 open }
      cylinder { <0, 0, 0>, <0, 0, 2>, 0.1 open }
      cylinder { <0, 0, 0>, <-2, 0, 0>, 0.1 open }
      cylinder { <0, 0, 0>, <0, 0, -2>, 0.1 open }
      texture {
              T_Chrome_2A
              normal {
                     wrinkles 0.3
                     scale 0.1
              }
      }
      hollow
      translate <-6, 3, 1>
}

cylinder { <-6, 3, 1.5>, <-15, 25, -20>, 0.01
         hollow
         texture {
                 pigment { color Red }
                 finish { diffuse 1 }
         }
}

object {
       Klingon
       scale 0.5
       rotate <-50, 10, -40>
       translate <-11, 19, 25>
       hollow
}

object {
       Klingon
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <-20, 15, 50>
       hollow
}

object {
       Klingon
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <-40, 30, 45>
       hollow
}

object {
       Klingon
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <17, 22, 30>
       hollow
}

object {
       Klingon
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <0, 22, 40>
       hollow
}

object {
       Klingon
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <7, 18, 35>
       hollow
}

cylinder { <1, 23, 40>, <3.5, 30, 37.5>, 0.05
        texture {
                pigment { color Red }
                finish { diffuse 0.7 }
        }
        hollow
}

cylinder { <7.5, 18.5, 35>, <3.5, 30, 37.5>, 0.05
         texture {
                 pigment { color Red }
                 finish { diffuse 0.7 }
         }
         hollow
}

object {
       NCC1701B
       scale 0.5
       rotate <50, 10, 40>
       translate <-4, 11, 25>
       hollow
}

object {
       NCC1701B
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <-6, 19, 20>
       hollow
}

object {
       NCC1701B
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <-20, 10, 30>
       hollow
}

object {
       NCC1701B
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <-32, 22, 40>
       hollow
}

object {
       NCC1701B
       scale 0.5
       translate <7, 11, 17>
       hollow
}

object {
       NCC1701B
       scale 0.5
       rotate <(rand(R1)*360), (rand(R1)*360), (rand(R1)*360)>
       translate <2, 21, 32>
       hollow
}

cylinder { <-4.5, 11.25, 24>, <-9, 17, 25>, 0.05
         texture {
                 pigment { color Yellow }
                 finish { diffuse 0.8 }
         }
         hollow
}

cylinder { <30, 30, 30>, <17, 22, 30>, 0.05
         texture {
                 pigment { color Yellow }
                 finish { diffuse 0.7 }
         }
         hollow
}

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0.0 color rgbt <1, 0, 0,  1.0> ]
      [ 0.5 color rgbt <1, 1, 0, -1.0> ]
      [ 1.0 color rgbt <1, 0, 0,  1.0> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale 5
  translate <3.5, 30, 37.5>
}

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0.0 color rgbt <1, 0, 0,  1.0> ]
      [ 0.5 color rgbt <1, 1, 0, -1.0> ]
      [ 1.0 color rgbt <1, 0, 0,  1.0> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale 1.5
  translate <17, 22, 30>
}

union {
      cylinder { <0, 0, 0>, <0, 25, 0>, 1
               pigment { color rgbt <1, 1, 1, 1> }
               halo {
                    emitting
                    cylindrical_mapping
                    linear
                    turbulence 1.5
                    color_map {
                              [ 0.0 color rgbt <1, 0, 0,  1.0> ]
                              [ 0.5 color rgbt <1, 0.5, 0, -1.0> ]
                              [ 1.0 color rgbt <1, 0, 0,  1.0> ]
                    }
                    frequency 2
                    samples 20
                    scale 0.5
               }
               hollow
               scale 0.09
               rotate <0, 0, -90>
      }
      sphere { <0, 0, 0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
             halo {
                  emitting
                  spherical_mapping
                  linear
                  turbulence 1.5
                  color_map {
                      [0.0 color rgbt <1, 0, 0, 1>]
                      [0.5 color rgbt <1, 0.5, 0, -1>]
                      [1.0 color rgbt <1, 0, 0, 1>]
                  }
                  frequency 2
                  samples 10
                  scale 0.5
             }
             hollow
             scale 0.5
             translate <2.5, 0, 0>
      }
      translate <-6, 3, 1>
}

union {
      cylinder { <0, 0, 0>, <0, 25, 0>, 1
               pigment { color rgbt <1, 1, 1, 1> }
               halo {
                    emitting
                    cylindrical_mapping
                    linear
                    turbulence 1.5
                    color_map {
                              [ 0.0 color rgbt <1, 0, 0,  1.0> ]
                              [ 0.5 color rgbt <1, 0.5, 0, -1.0> ]
                              [ 1.0 color rgbt <1, 0, 0,  1.0> ]
                    }
                    frequency 2
                    samples 20
                    scale 0.5
               }
               hollow
               scale 0.09
               rotate <0, 0, 90>
      }
      sphere { <0, 0, 0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
             halo {
                  emitting
                  spherical_mapping
                  linear
                  turbulence 1.5
                  color_map {
                      [0.0 color rgbt <1, 0, 0, 1>]
                      [0.5 color rgbt <1, 0.5, 0, -1>]
                      [1.0 color rgbt <1, 0, 0, 1>]
                  }
                  frequency 2
                  samples 10
                  scale 0.5
             }
             hollow
             scale 0.5
             translate <-2.5, 0, 0>
      }
      translate <-6, 3, 1>
}

union {
      cylinder { <0, 0, 0>, <0, 25, 0>, 1
               pigment { color rgbt <1, 1, 1, 1> }
               halo {
                    emitting
                    cylindrical_mapping
                    linear
                    turbulence 1.5
                    color_map {
                              [ 0.0 color rgbt <1, 0, 0,  1.0> ]
                              [ 0.5 color rgbt <1, 0.5, 0, -1.0> ]
                              [ 1.0 color rgbt <1, 0, 0,  1.0> ]
                    }
                    frequency 2
                    samples 20
                    scale 0.5
               }
               hollow
               scale 0.09
               rotate <-90, 0, 0>
      }
      sphere { <0, 0, 0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
             halo {
                  emitting
                  spherical_mapping
                  linear
                  turbulence 1.5
                  color_map {
                      [0.0 color rgbt <1, 0, 0, 1>]
                      [0.5 color rgbt <1, 0.5, 0, -1>]
                      [1.0 color rgbt <1, 0, 0, 1>]
                  }
                  frequency 2
                  samples 10
                  scale 0.5
             }
             hollow
             scale 0.5
             translate <0, 0, -2.5>
      }
      translate <-6, 3, 1>
}

union {
      cylinder { <0, 0, 0>, <0, 25, 0>, 1
               pigment { color rgbt <1, 1, 1, 1> }
               halo {
                    emitting
                    cylindrical_mapping
                    linear
                    turbulence 1.5
                    color_map {
                              [ 0.0 color rgbt <1, 0, 0,  1.0> ]
                              [ 0.5 color rgbt <1, 0.5, 0, -1.0> ]
                              [ 1.0 color rgbt <1, 0, 0,  1.0> ]
                    }
                    frequency 2
                    samples 20
                    scale 0.5
               }
               hollow
               scale 0.09
               rotate <90, 0, 0>
      }
      sphere { <0, 0, 0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
             halo {
                  emitting
                  spherical_mapping
                  linear
                  turbulence 1.5
                  color_map {
                      [0.0 color rgbt <1, 0, 0, 1>]
                      [0.5 color rgbt <1, 0.5, 0, -1>]
                      [1.0 color rgbt <1, 0, 0, 1>]
                  }
                  frequency 2
                  samples 10
                  scale 0.5
             }
             hollow
             scale 0.5
             translate <0, 0, 2.5>
      }
      translate <-6, 3, 1>
}

sphere { <0, 0, 0>, 1
       pigment { color rgbt <1, 1, 1, 1> }
       halo {
            emitting
            spherical_mapping
            linear
            turbulence 1
            color_map {
                      [0.0 color rgbt <1, 0, 0, 1>]
                      [0.5 color rgbt <1, 0, 0, 0.5>]
                      [1.0 color rgbt <1, 0, 0, 1>]
            }
            samples 10
            scale 0.5
       }
       hollow
       scale 2.5
       translate <-6, 3.5, 0.5>
}
