// A scene with a bridge crossing a deep valley.
// Robert Fredriksson.     1996-08-24

// Globals
#version 3.0
global_settings { 
   assumed_gamma 2.2 
   ambient_light color red 0.4 green 0.5 blue 0.65
}

// Include files
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "b_textur.inc"
#include "bridge.inc"
#include "v_ailien.inc"

// The camera facing +Z
camera {
   location  <0,  7.0, 60.0>
   direction <0,  0,   1>
   up        <0,  1,   0>
   right   <4/3,  0,   0>
}

// ****************************************************************
//                              FOG
// ****************************************************************
fog{
    color red 0.25 green 0.30 blue 0.40
    fog_type 2
    fog_alt 0.35
    fog_offset 0
    distance 1.5
    turbulence <.15, .15, .15>
    omega 0.35
    lambda 1.25
    octaves 5
}


// ****************************************************************
//                           MOUNTAINS
// ****************************************************************

// Mountains to the left
object
{
   height_field
   {
      gif"mount2.gif"
      smooth
      water_level 0.6
   }
   texture{
      Mountain_texture1
   }
   scale<600.0 250.0 150.0>
   rotate<0.0, 90.0,0.0>
   translate<-30.5, -160.0, 280.0>
}

// Faraway mountains to the left
object
{
   height_field
   {
      gif"mount2.gif"
      smooth
      water_level 0.6
   }
   texture{
      Mountain_texture1
   }
   scale<600.0 250.0 150.0>
   rotate<0.0, 95.0,0.0>
   translate<-40.5, -160.0, 800.0>
}

// Mountains to the right
object
{
   height_field
   {
      gif"mount2.gif"
      smooth
      water_level 0.6
   }
   texture{
      Mountain_texture1
   }
   scale<600.0 250.0 150.0>
   rotate<0.0, -90.0,0.0>
   translate<30.5, -160.0, 20.0>
}


// Faraway mountains to the right
object
{
   height_field
   {
      gif"mount2.gif"
      smooth
      water_level 0.6
   }
   texture{
      Mountain_texture1
   }
   scale<600.0 250.0 150.0>
   rotate<0.0, -85.0,0.0>
   translate<30.5, -160.0, 620.0>
}

// *********************************************************
//                         SKY
// *********************************************************

// The sky. 
object{
   sphere  
   {
      <0, 0, 0>, 1
      texture 
      { 
         Srealsky5 
         scale 1.0
      }
      scale <Sky_Top*10, Sky_Top, Sky_Top*10>
   }
   scale 1.0
   no_shadow
}

// *********************************************************
//                      WATER
// *********************************************************


// The water
plane { y, -10
   texture{
      Water1
   }
}


// *********************************************************
//                       THE BRIDGE
// *********************************************************
object{
   Bridge
   scale <5.3, 4.0, 4.0>
   translate<-40.0, -55.0, 130.0>
}

// *********************************************************
//                       THE AILIENS
// *********************************************************
object{
   V_Ailien
   scale 5.0
   rotate<0.0, 0.0, 15.0>
   translate<-20.0, 10.0, 120>
}

object{
   V_Ailien
   scale 5.0
   translate<-10.0, 15.0, 150>
}

object{
   V_Ailien
   scale 5.0
   rotate<0.0, 0.0, -15.0>
   translate<0.0, 25.0, 170>
}


// *********************************************************
//                        LIGHTS
// *********************************************************


// Faraway light
light_source{
   <-40.0, 200.0, 0.0>
   color red 0.7 green 0.55 blue 0.55
   area_light<40.0, 0.0, 0.0>,<0.0, 0.0, 1.0>, 100, 1
   adaptive 4
   jitter
}

