// b_textur.inc
// The non-standard textures used in the scene bridge.inc
// Robert Fredriksson    1996-09-22

// *******************************************************************
// Sky textures.
// *******************************************************************

// A modification off Jussi Kantola's sky texture. Surealistic 
// colormaps added. Map onto a sphere with radius 1, scale it like
// "scale<Sky_Top*10, Sky_Top, Sky_Top*10>" and last scale the sphere
// to the right size to fit your scene.
// Robert Fredriksson     95-12-17

#declare Sky_Top = 100 

#declare Sureal5 = color_map  
   {
   [0.02 color VioletRed]
   [0.1 color Navy]
   [0.4 color MidnightBlue]
   [0.7 color VioletRed]
   [0.8 color MediumVioletRed]
   [0.96 color VioletRed]
   [1.0 color Black]
   }
      


#declare Srealsky5 = texture  // Very surealistic
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 10    // bigger values are worth trying
      color_map { Sureal5 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }


// *********************************************************************
//                             Water textures
// *********************************************************************

#declare Water1  = texture {
   pigment{
      color red 0.60 green 0.50 blue 0.45    
   }
   finish{
      Metal
   }
   normal{
      waves 30.0
      frequency 4.0
      phase 0.1
   }
   scale<2.0, 600.0, 1.0>
}
 
 
// ************************************************************
//                Mountain textures
// ************************************************************

// A red and yellow mountain texture
#declare Mountain_texture1 = texture{
   pigment{
      bozo
      color_map{
         [0.2 color Khaki]
         [0.5 color red 0.55 green 0.52 blue 0.20]
         [0.7 color Firebrick]       
         [0.9 color Khaki]
      }
      turbulence 0.4
      omega 0.85
   }
}

// ********************************************************
//                  BRICK TEXTURES
// ********************************************************

#declare Brick2 = texture {
    pigment {
        brick Gray30, Khaki
    }
    normal {
        brick 0.75
    }
    finish {
        crand 0.003
        diffuse 0.6 ambient 0.20
    }
    scale <0.1, 0.1, 0.05>
    translate <0.25, 0.30, 0.25>
}

