/***************************************************************************
  different tires

  Created by Cedric Joulain (1996)
****************************************************************************/


#declare Roue =
union {
   torus { 
      1-1/6, 1/6
      rotate <90, 0, 0>
      pigment { Black }
      finish { 
         specular 0.1 
         roughness 0.05
         }
      }
   union {
      difference {
         cylinder {
            <0, 0, -1/6+1/20>, <0, 0, 1/6-1/20>, 1-1/6+1/20
            }
         sphere {
            <0, 0, 0>, 1
            scale <0.65, 0.65, 1/6>
            translate <0, 0, -1/6>
            }
         sphere {
            <0, 0, 0>, 1
            scale <0.65, 0.65, 1/6>
            translate <0, 0, 1/6>
            }
         #declare NbrTrou = 8
         #declare Count = 0
         #while (Count < NbrTrou)
            cylinder {
               <0, 0, -1>, <0, 0, 1>, 0.05
               translate <0.45, 0, 0>
               rotate<0, 0, Count * (360/NbrTrou)> 
               }
            #declare Count = Count +1
         #end
         }   
      sphere { 
         <0, 0, 0>, 1/10 
         }

      texture {
         finish { 
            reflection Gold
            ambient 0
            diffuse 0
            }
         }
      }
   scale <1, 1, 6>
   
   bounded_by { box {<-1, -1, -1> <1, 1, 1>} }
   }


