//** three rows of light, pretty cheesy!
#declare color_pad = union
{
  #declare Count = 0
  #while (Count < 7)
    union
    {
      sphere
      {
        <0, 0, 0>, 6
        translate <-10, 0, 0>
        pigment
        {
          color Blue
        }
      }
      sphere
      {
        <0, 0, 0>, 6
        translate <0, 0, 0>
        pigment
        {
          color Red
        }
      }
      sphere
      {
        <0, 0, 0>, 6
        translate <10, 0, 0>
        pigment
        {
          color Green
        }
      }
      translate <0, Count*10, 0>
    }
    #declare Count=Count+1

  #end
}

//***We need something in the pod, try to give it depth
#declare control_panel = union
{
  superellipsoid
  {
    <0.3, 0.3>
    scale <40, 70, 5>
    pigment
    {
      color White
    }
    finish
    {
      ambient 0.12
    }
  }
  object
  {
    color_pad
    translate <20, -55, 0>
  }
  box
  {
    <  0, 5, 0>,
    <-30, -50, 6>
    texture
    {
      Ruby_Glass
    }
    /*
    texture
    {
      pigment
      {
        color LightSteelBlue
      }
      normal
      {
        bumps 0.15 scale 0.6
      }
      finish
      {
        Dull
        //ambient 0.15
        //reflection 0.2
      }
      scale 20
    }
    */
  }
  sphere
  {
    <0, 0, 0>, 10
    scale <2.5, 3, 0.8>
    translate <0, 35, 0>
    pigment
    {
      color MidnightBlue
    }
  }
  rotate <0, 0, 180>
  translate <25, 310, 0>
}

//*** now the hand holds that go around the pod (avoid the door!)
#declare hand_holds = union
{
  #declare Count = 0
  #declare y_left = 280
  #declare y_right = y_left+100

  #while (Count < 10)
    #if (Count = 7)
      // drag the hand rail behind the pod
      union
      {
        cylinder
        {
          < 0, y_left, 0>,
          <-12, y_left, 0>, 2
        }
        sphere
        {
          <0, y_left, 0>, 2
        }
        cylinder
        {
          <0, y_right, 0>,
          <5, y_right+20, 10>, 2
        }
        sphere
        {
          <5, y_right+20, 10>, 2
        }
        cylinder
        {
          <5, y_right+20, 10>,
          <12, y_right+40, 24>, 2
        }
        sphere
        {
          <12, y_right+40, 24>, 2
        }
        cylinder
        {
          <12, y_right+40, 24>,
          <5, y_right+(y_right-y_left-20), 40>, 2
        }
        sphere
        {
          <0, y_right, 0>, 2
        }
        cylinder
        {
          < 0, y_right, 0>,
          <-12, y_right, 0>, 2
        }
        translate <115, 0, 0>
        rotate <0, Count*36-2, 0> // -2 to avoid the door
      }
    #else
      union
      {
        cylinder
        {
          < 0, y_left, 0>,
          <-12, y_left, 0>, 2
        }
        sphere
        {
          <0, y_left, 0>, 2
        }
        cylinder
        {
          <0, y_left, 0>,
          <0, y_right, 0>, 2
        }
        sphere
        {
          <0, y_right, 0>, 2
        }
        cylinder
        {
          < 0, y_right, 0>,
          <-12, y_right, 0>, 2
        }
        translate <115, 0, 0>
        rotate <0, Count*36-2, 0> // -2 to avoid the door
      }
    #end

    #declare Count=Count+1
  #end
  texture
  {
    Chrome_Metal
  }
}

// four directional cones, pretty simple
#declare retros = union
{
  #declare Count = 0
  #while (Count < 4)
    union
    {
      box
      {
        <1, 1, 1>,
        <-1, -1, -1>
        scale <1, 2, 1>
      }
      difference
      {
        cone
        {
          <0, 0, 0>, 0.01
          <5, 0, 0>, 2
        }
        sphere
        {
          <5, 0, 0>, 1.8
        }
      }
      difference
      {
        cone
        {
          <0, 0, 0>, 0.01
          <-5, 0, 0>, 2
        }
        sphere
        {
          <-5, 0, 0>, 1.8
        }
      }
      difference
      {
        cone
        {
          <0, 0, 0>, 0.01
          <0, 5, 0>, 2
        }
        sphere
        {
          <0, 5, 0>, 1.8
        }
      }
      difference
      {
        cone
        {
          <0, 0, 0>, 0.01
          <0, -5, 0>, 2
        }
        sphere
        {
          <0, -5, 0>, 1.8
        }
      }
      scale 3
      translate <0, 0, 114>
      rotate <0, Count*90-24, 0>
    }

    #declare Count=Count+1
  #end
  texture
  {
    Chrome_Metal
  }
  translate <0, 225, 0>
}

#declare stern_railing = union
{
  #declare Count = 0
  #declare stern_rad = 1.5

  #while (Count < 15)
    sphere
    {
      <94, 404, 0>, 12.5
      rotate <0, Count*24+12, 0>
    }
    cylinder
    {
      <100, 390, 0>
      <115, 445, 0>, stern_rad
      rotate <0, Count*24+12, 0>
    }
    #declare Count=Count+1
  #end
  torus
  {
    115, stern_rad
    clipped_by
    {
      box
      {
        <  55, -4, -120>,
        <-120,  4,  120>
      }
    }
    translate <0, 445, 0>
  }
  // bend the bottom part of the railing as if it were dragged behind the pod
  torus
  {
    115, stern_rad
    clipped_by
    {
      box
      {
        < 55, -4, -120>,
        <120,  4,  120>
      }
    }
    translate <-55, 0, 0>
    rotate <0, 0, 55>
    translate <55, 0, 0>
    translate <0, 445, 0>
  }
  rotate <0, 180, 0>
  texture
  {
    Chrome_Metal
  }
}

#declare jet_cones = union
{
  #declare Count = 0

  #while (Count < 5)
    union
    {
      torus
      {
        22, 4
        rotate <0, 0, 90>
        translate <0, 445, 0>
      }
      torus
      {
        11, 2
        translate <0, 470, 0>
      }
      torus
      {
        15, 2
        translate <0, 480, 0>
      }
      torus
      {
        19, 2
        translate <0, 490, 0>
      }
      torus
      {
        8.75, 6
        translate <0, 455, 0>
      }
      cylinder
      {
        <0, 450, 0>,
        <0, 460, 0>, 8
      }
      difference
      {
        cone
        {
          <0, 450, 0>,  4
          <0, 500, 0>, 25
        }
        sphere
        {
          <0, 500, 0>, 23
        }
      }
      translate <70, 0, 0>
      rotate <0, Count*72 - 15, 0>
      texture
      {
        pigment
        {
          White
        }
        normal
        {
          crackle 0.6
          scale 0.24
        }
        finish
        {
          phong 0.8
          phong_size 200
        }
        scale 5
      }
    }

    #declare Count=Count+1
  #end
}

#declare crash_mound = union
{
  #declare Count = 0
  #declare x_pos = -670
  #declare z_rot = 9
  #while (Count < 9)

    #declare x_pos=x_pos-12
    #declare z_rot=z_rot+4.2
    // trying to get a little randomness to the mound
    #declare rad=(mod(Count, 3) * Count)
    #declare z_scale = 1.7 - (Count * 0.02)
    #declare x_scale = 4.9 + (Count * 0.01)
    torus
    {
      116+rad, 100-rad
      scale <4.9, 1.25, z_scale>
      translate <x_pos, 0, 0>
      rotate <0, 0, z_rot>
    }

    #declare Count=Count+1
  #end
  translate <-175, -89, 0>
  rotate <0, 25, 0>
}

// these colors were generated by Trees.exe by Phil Drinkwater
#declare C1=color red .784 green .352 blue 0.000
#declare C2=color red .156 green .509 blue 0.000
#declare C3=color red 0.000 green 1.000 blue 0.000
#declare C4=color red .588 green .196 blue 0.000


#declare half_coconut = union
  {
    difference
    {
      sphere
      {
        <0, 0, 0>,12.000
      }
      sphere
      {
        <0, 0, 0>,10.000
      }
      pigment
      {
        color C4
      }
    }
    difference
    {
      sphere
      {
        <0, 0, 0>,10.000
      }
      sphere
      {
        <0, 0, 0>, 8.000
      }
      pigment
      {
        White
      }
      finish
      {
        ambient 0.3
      }
    }
    clipped_by
    {
      box
      {
        <12,  12,  12>,
        < 0, -12, -12>
      }
    }
  }

#declare coconut = union
{
  object
  {
    half_coconut
    rotate <90, 0, -45>
    translate <20, -3, 0>
  }
  object
  {
    half_coconut
    rotate <0, 0, -90>
    translate <-12, 0, 0>
  }
  translate <0, 12, 0>
}

#declare palm_tree = union
{
  cylinder { <0.000,0.000,0.000>,<-.406,20.996,0.000>,17.000 pigment {color C1} }
  cylinder { <-.406,20.996,0.000>,<-.858,41.991,0.000>,16.000 pigment {color C1} }
  cylinder { <-.858,41.991,0.000>,<-1.359,62.985,0.000>,16.000 pigment {color C1} }
  cylinder { <-1.359,62.985,0.000>,<-1.915,83.977,0.000>,15.000 pigment {color C1} }
  cylinder { <-1.915,83.977,0.000>,<-2.533,104.968,0.000>,15.000 pigment {color C1} }
  cylinder { <-2.533,104.968,0.000>,<-3.218,125.957,0.000>,14.000 pigment {color C1} }
  cylinder { <-3.218,125.957,0.000>,<-3.979,146.943,0.000>,14.000 pigment {color C1} }
  cylinder { <-3.979,146.943,0.000>,<-4.823,167.926,0.000>,13.000 pigment {color C1} }
  cylinder { <-4.823,167.926,0.000>,<-5.760,188.905,0.000>,13.000 pigment {color C1} }
  cylinder { <-5.760,188.905,0.000>,<-6.801,209.880,0.000>,12.000 pigment {color C1} }
  cylinder { <-6.801,209.880,0.000>,<-7.955,230.848,0.000>,12.000 pigment {color C1} }
  cylinder { <-7.955,230.848,0.000>,<-9.236,251.809,0.000>,11.000 pigment {color C1} }
  cylinder { <-9.236,251.809,0.000>,<-10.658,272.761,0.000>,11.000 pigment {color C1} }
  cylinder { <-10.658,272.761,0.000>,<-12.236,293.701,0.000>,10.000 pigment {color C1} }
  cylinder { <-12.236,293.701,0.000>,<-13.986,314.628,0.000>,10.000 pigment {color C1} }
  cylinder { <-13.986,314.628,0.000>,<-15.929,335.538,0.000>,9.000 pigment {color C1} }
  cylinder { <-15.929,335.538,0.000>,<-18.084,356.427,0.000>,9.000 pigment {color C1} }
  cylinder { <-18.084,356.427,0.000>,<-20.475,377.291,0.000>,8.000 pigment {color C1} }
  cylinder { <-20.475,377.291,0.000>,<-23.127,398.122,0.000>,8.000 pigment {color C1} }
  cylinder { <-23.127,398.122,0.000>,<-26.069,418.915,0.000>,7.000 pigment {color C1} }
  cylinder { <-26.069,418.915,0.000>,<-29.330,439.661,0.000>,7.000 pigment {color C1} }
  cylinder { <-29.330,439.661,0.000>,<-32.945,460.347,0.000>,6.000 pigment {color C1} }
  cylinder { <-32.945,460.347,0.000>,<-36.951,480.962,0.000>,6.000 pigment {color C1} }
  cylinder { <-36.951,480.962,0.000>,<-41.389,501.487,0.000>,5.000 pigment {color C1} }
  cylinder { <-41.389,501.487,0.000>,<-46.302,521.904,0.000>,5.000 pigment {color C1} }
  cylinder { <-46.302,521.904,0.000>,<-51.740,542.188,0.000>,4.000 pigment {color C1} }
  cylinder { <-51.740,542.188,0.000>,<-57.753,562.309,0.000>,4.000 pigment {color C1} }
  cylinder { <-57.753,562.309,0.000>,<-64.396,582.230,0.000>,3.000 pigment {color C1} }
  cylinder { <-64.396,582.230,0.000>,<-71.729,601.908,0.000>,3.000 pigment {color C1} }
  cylinder { <-71.729,601.908,0.000>,<-70.514,600.083,-4.769>,2.000 pigment {color C2} }
  cylinder { <-70.514,600.083,-4.769>,<-33.282,608.351,32.320>,1.000 pigment {color C3} }
  cylinder { <-70.514,600.083,-4.769>,<-110.530,579.567,23.656>,1.000 pigment {color C3} }
  cylinder { <-70.514,600.083,-4.769>,<-69.305,598.188,-9.514>,2.000 pigment {color C2} }
  cylinder { <-69.305,598.188,-9.514>,<-31.427,606.735,26.851>,1.000 pigment {color C3} }
  cylinder { <-69.305,598.188,-9.514>,<-109.096,578.630,19.887>,1.000 pigment {color C3} }
  cylinder { <-69.305,598.188,-9.514>,<-68.102,596.224,-14.232>,2.000 pigment {color C2} }
  cylinder { <-68.102,596.224,-14.232>,<-29.507,604.783,20.312>,1.000 pigment {color C3} }
  cylinder { <-68.102,596.224,-14.232>,<-108.765,575.303,11.557>,1.000 pigment {color C3} }
  cylinder { <-68.102,596.224,-14.232>,<-66.907,594.193,-18.924>,2.000 pigment {color C2} }
  cylinder { <-66.907,594.193,-18.924>,<-27.704,602.947,14.879>,1.000 pigment {color C3} }
  cylinder { <-66.907,594.193,-18.924>,<-107.640,573.762,7.145>,1.000 pigment {color C3} }
  cylinder { <-66.907,594.193,-18.924>,<-65.719,592.096,-23.587>,2.000 pigment {color C2} }
  cylinder { <-65.719,592.096,-23.587>,<-24.835,600.390,7.119>,1.000 pigment {color C3} }
  cylinder { <-65.719,592.096,-23.587>,<-106.792,570.681,-.401>,1.000 pigment {color C3} }
  cylinder { <-65.719,592.096,-23.587>,<-64.538,589.932,-28.223>,2.000 pigment {color C2} }
  cylinder { <-64.538,589.932,-28.223>,<-23.625,598.496,2.372>,1.000 pigment {color C3} }
  cylinder { <-64.538,589.932,-28.223>,<-105.853,568.528,-5.461>,1.000 pigment {color C3} }
  cylinder { <-64.538,589.932,-28.223>,<-63.364,587.704,-32.829>,2.000 pigment {color C2} }
  cylinder { <-63.364,587.704,-32.829>,<-21.011,595.572,-5.342>,1.000 pigment {color C3} }
  cylinder { <-63.364,587.704,-32.829>,<-104.732,565.276,-12.905>,1.000 pigment {color C3} }
  cylinder { <-63.364,587.704,-32.829>,<-62.198,585.411,-37.405>,2.000 pigment {color C2} }
  cylinder { <-62.198,585.411,-37.405>,<-18.906,593.014,-11.344>,1.000 pigment {color C3} }
  cylinder { <-62.198,585.411,-37.405>,<-103.395,564.274,-15.789>,1.000 pigment {color C3} }
  cylinder { <-62.198,585.411,-37.405>,<-61.039,583.054,-41.952>,2.000 pigment {color C2} }
  cylinder { <-61.039,583.054,-41.952>,<-17.056,589.952,-18.329>,1.000 pigment {color C3} }
  cylinder { <-61.039,583.054,-41.952>,<-102.249,560.407,-23.811>,1.000 pigment {color C3} }
  cylinder { <-61.039,583.054,-41.952>,<-59.889,580.635,-46.467>,2.000 pigment {color C2} }
  cylinder { <-59.889,580.635,-46.467>,<-16.289,587.974,-22.273>,1.000 pigment {color C3} }
  cylinder { <-59.889,580.635,-46.467>,<-101.097,558.809,-27.344>,1.000 pigment {color C3} }
  cylinder { <-59.889,580.635,-46.467>,<-58.746,578.154,-50.950>,2.000 pigment {color C2} }
  cylinder { <-58.746,578.154,-50.950>,<-14.563,584.676,-29.147>,1.000 pigment {color C3} }
  cylinder { <-58.746,578.154,-50.950>,<-99.694,554.786,-35.223>,1.000 pigment {color C3} }
  cylinder { <-58.746,578.154,-50.950>,<-57.612,575.612,-55.401>,2.000 pigment {color C2} }
  cylinder { <-57.612,575.612,-55.401>,<-12.693,581.630,-35.002>,1.000 pigment {color C3} }
  cylinder { <-57.612,575.612,-55.401>,<-98.644,552.136,-40.060>,1.000 pigment {color C3} }
  cylinder { <-57.612,575.612,-55.401>,<-56.486,573.010,-59.820>,2.000 pigment {color C2} }
  cylinder { <-56.486,573.010,-59.820>,<-11.219,578.039,-41.748>,1.000 pigment {color C3} }
  cylinder { <-56.486,573.010,-59.820>,<-96.963,548.865,-46.415>,1.000 pigment {color C3} }
  cylinder { <-56.486,573.010,-59.820>,<-55.369,570.348,-64.205>,2.000 pigment {color C2} }
  cylinder { <-55.369,570.348,-64.205>,<-10.086,575.460,-46.197>,1.000 pigment {color C3} }
  cylinder { <-55.369,570.348,-64.205>,<-95.922,546.505,-50.497>,1.000 pigment {color C3} }
  cylinder { <-55.369,570.348,-64.205>,<-54.260,567.629,-68.557>,2.000 pigment {color C2} }
  cylinder { <-54.260,567.629,-68.557>,<-8.289,570.877,-54.101>,1.000 pigment {color C3} }
  cylinder { <-54.260,567.629,-68.557>,<-94.145,543.096,-56.716>,1.000 pigment {color C3} }
  cylinder { <-54.260,567.629,-68.557>,<-53.160,564.852,-72.875>,2.000 pigment {color C2} }
  cylinder { <-53.160,564.852,-72.875>,<-7.666,568.915,-57.170>,1.000 pigment {color C3} }
  cylinder { <-53.160,564.852,-72.875>,<-92.949,539.710,-62.032>,1.000 pigment {color C3} }
  cylinder { <-53.160,564.852,-72.875>,<-52.069,562.018,-77.157>,2.000 pigment {color C2} }
  cylinder { <-52.069,562.018,-77.157>,<-6.316,564.479,-64.258>,1.000 pigment {color C3} }
  cylinder { <-52.069,562.018,-77.157>,<-91.139,536.623,-67.442>,1.000 pigment {color C3} }
  cylinder { <-52.069,562.018,-77.157>,<-50.986,559.129,-81.405>,2.000 pigment {color C2} }
  cylinder { <-50.986,559.129,-81.405>,<-5.033,561.186,-69.166>,1.000 pigment {color C3} }
  cylinder { <-50.986,559.129,-81.405>,<-90.007,533.537,-72.013>,1.000 pigment {color C3} }
  cylinder { <-50.986,559.129,-81.405>,<-49.913,556.186,-85.618>,2.000 pigment {color C2} }
  cylinder { <-49.913,556.186,-85.618>,<-4.000,556.494,-76.051>,1.000 pigment {color C3} }
  cylinder { <-49.913,556.186,-85.618>,<-87.984,529.903,-77.911>,1.000 pigment {color C3} }
  cylinder { <-49.913,556.186,-85.618>,<-48.849,553.188,-89.795>,2.000 pigment {color C2} }
  cylinder { <-48.849,553.188,-89.795>,<-2.811,553.022,-80.844>,1.000 pigment {color C3} }
  cylinder { <-48.849,553.188,-89.795>,<-87.163,527.554,-81.161>,1.000 pigment {color C3} }
  cylinder { <-48.849,553.188,-89.795>,<-47.794,550.138,-93.935>,2.000 pigment {color C2} }
  cylinder { <-47.794,550.138,-93.935>,<-2.241,549.031,-86.310>,1.000 pigment {color C3} }
  cylinder { <-47.794,550.138,-93.935>,<-84.474,522.540,-88.704>,1.000 pigment {color C3} }
  cylinder { <-47.794,550.138,-93.935>,<-46.748,547.036,-98.039>,2.000 pigment {color C2} }
  cylinder { <-46.748,547.036,-98.039>,<-1.198,545.882,-90.401>,1.000 pigment {color C3} }
  cylinder { <-46.748,547.036,-98.039>,<-83.730,520.036,-91.895>,1.000 pigment {color C3} }
  cylinder { <-46.748,547.036,-98.039>,<-45.711,543.882,-102.107>,2.000 pigment {color C2} }
  cylinder { <-45.711,543.882,-102.107>,<-.573,539.371,-98.581>,1.000 pigment {color C3} }
  cylinder { <-45.711,543.882,-102.107>,<-81.018,515.397,-98.603>,1.000 pigment {color C3} }
  cylinder { <-45.711,543.882,-102.107>,<-44.684,540.679,-106.138>,2.000 pigment {color C2} }
  cylinder { <-44.684,540.679,-106.138>,<.425,537.052,-101.431>,1.000 pigment {color C3} }
  cylinder { <-44.684,540.679,-106.138>,<-80.336,512.754,-101.740>,1.000 pigment {color C3} }
  cylinder { <-44.684,540.679,-106.138>,<-43.667,537.427,-110.131>,2.000 pigment {color C2} }
  cylinder { <-43.667,537.427,-110.131>,<.711,531.821,-107.646>,1.000 pigment {color C3} }
  cylinder { <-43.667,537.427,-110.131>,<-77.755,508.461,-107.675>,1.000 pigment {color C3} }
  cylinder { <-43.667,537.427,-110.131>,<-42.659,534.126,-114.087>,2.000 pigment {color C2} }
  cylinder { <-42.659,534.126,-114.087>,<1.729,528.918,-110.999>,1.000 pigment {color C3} }
  cylinder { <-42.659,534.126,-114.087>,<-76.217,504.496,-112.375>,1.000 pigment {color C3} }
  cylinder { <-42.659,534.126,-114.087>,<-41.660,530.777,-118.006>,2.000 pigment {color C2} }
  cylinder { <-41.660,530.777,-118.006>,<1.833,523.565,-116.993>,1.000 pigment {color C3} }
  cylinder { <-41.660,530.777,-118.006>,<-73.792,500.576,-117.543>,1.000 pigment {color C3} }
  cylinder { <-41.660,530.777,-118.006>,<-40.671,527.383,-121.886>,2.000 pigment {color C2} }
  cylinder { <-40.671,527.383,-121.886>,<2.801,520.058,-120.792>,1.000 pigment {color C3} }
  cylinder { <-40.671,527.383,-121.886>,<-72.889,497.280,-121.087>,1.000 pigment {color C3} }
  cylinder { <-40.671,527.383,-121.886>,<-39.692,523.942,-125.729>,2.000 pigment {color C2} }
  cylinder { <-39.692,523.942,-125.729>,<2.266,513.081,-127.976>,1.000 pigment {color C3} }
  cylinder { <-39.692,523.942,-125.729>,<-70.422,493.298,-126.092>,1.000 pigment {color C3} }
  cylinder { <-39.692,523.942,-125.729>,<-38.723,520.457,-129.534>,2.000 pigment {color C2} }
  cylinder { <-38.723,520.457,-129.534>,<3.497,510.478,-130.716>,1.000 pigment {color C3} }
  cylinder { <-38.723,520.457,-129.534>,<-69.539,489.897,-129.560>,1.000 pigment {color C3} }
  cylinder { <-38.723,520.457,-129.534>,<-37.763,516.928,-133.301>,2.000 pigment {color C2} }
  cylinder { <-37.763,516.928,-133.301>,<2.738,503.938,-137.066>,1.000 pigment {color C3} }
  cylinder { <-37.763,516.928,-133.301>,<-66.641,485.513,-134.863>,1.000 pigment {color C3} }
  cylinder { <-37.763,516.928,-133.301>,<-36.813,513.356,-137.029>,2.000 pigment {color C2} }
  cylinder { <-36.813,513.356,-137.029>,<3.851,500.726,-140.217>,1.000 pigment {color C3} }
  cylinder { <-36.813,513.356,-137.029>,<-65.777,482.006,-138.254>,1.000 pigment {color C3} }
  cylinder { <-36.813,513.356,-137.029>,<-35.873,509.742,-140.720>,2.000 pigment {color C2} }
  cylinder { <-35.873,509.742,-140.720>,<3.685,496.166,-144.566>,1.000 pigment {color C3} }
  cylinder { <-35.873,509.742,-140.720>,<-62.802,477.619,-143.343>,1.000 pigment {color C3} }
  cylinder { <-35.873,509.742,-140.720>,<-34.942,506.087,-144.371>,2.000 pigment {color C2} }
  cylinder { <-34.942,506.087,-144.371>,<4.127,491.351,-148.890>,1.000 pigment {color C3} }
  cylinder { <-34.942,506.087,-144.371>,<-61.524,473.683,-147.081>,1.000 pigment {color C3} }
  cylinder { <-34.942,506.087,-144.371>,<-34.021,502.392,-147.985>,2.000 pigment {color C2} }
  cylinder { <-34.021,502.392,-147.985>,<3.605,486.260,-153.430>,1.000 pigment {color C3} }
  cylinder { <-34.021,502.392,-147.985>,<-58.917,469.631,-151.534>,1.000 pigment {color C3} }
  cylinder { <-34.021,502.392,-147.985>,<-33.110,498.657,-151.560>,2.000 pigment {color C2} }
  cylinder { <-33.110,498.657,-151.560>,<4.736,482.870,-156.463>,1.000 pigment {color C3} }
  cylinder { <-33.110,498.657,-151.560>,<-58.543,466.238,-154.373>,1.000 pigment {color C3} }
  cylinder { <-33.110,498.657,-151.560>,<-32.209,494.883,-155.097>,2.000 pigment {color C2} }
  cylinder { <-32.209,494.883,-155.097>,<3.855,477.258,-161.183>,1.000 pigment {color C3} }
  cylinder { <-32.209,494.883,-155.097>,<-54.030,461.023,-160.169>,1.000 pigment {color C3} }
  cylinder { <-32.209,494.883,-155.097>,<-31.318,491.071,-158.596>,2.000 pigment {color C2} }
  cylinder { <-31.318,491.071,-158.596>,<4.399,472.806,-164.842>,1.000 pigment {color C3} }
  cylinder { <-31.318,491.071,-158.596>,<-54.196,457.771,-162.600>,1.000 pigment {color C3} }
  cylinder { <-31.318,491.071,-158.596>,<-30.436,487.223,-162.056>,2.000 pigment {color C2} }
  cylinder { <-30.436,487.223,-162.056>,<3.665,467.697,-168.971>,1.000 pigment {color C3} }
  cylinder { <-30.436,487.223,-162.056>,<-50.059,452.948,-167.731>,1.000 pigment {color C3} }
  cylinder { <-30.436,487.223,-162.056>,<-29.564,483.338,-165.478>,2.000 pigment {color C2} }
  cylinder { <-29.564,483.338,-165.478>,<3.445,462.258,-173.094>,1.000 pigment {color C3} }
  cylinder { <-29.564,483.338,-165.478>,<-49.273,449.058,-170.814>,1.000 pigment {color C3} }
  cylinder { <-29.564,483.338,-165.478>,<-28.702,479.418,-168.862>,2.000 pigment {color C2} }
  cylinder { <-28.702,479.418,-168.862>,<2.178,456.765,-177.221>,1.000 pigment {color C3} }
  cylinder { <-28.702,479.418,-168.862>,<-47.644,445.499,-174.093>,1.000 pigment {color C3} }
  cylinder { <-28.702,479.418,-168.862>,<-27.849,475.463,-172.207>,2.000 pigment {color C2} }
  cylinder { <-27.849,475.463,-172.207>,<4.115,453.995,-179.558>,1.000 pigment {color C3} }
  cylinder { <-27.849,475.463,-172.207>,<-45.846,441.078,-177.727>,1.000 pigment {color C3} }
  cylinder { <-27.849,475.463,-172.207>,<-27.006,471.474,-175.515>,2.000 pigment {color C2} }
  cylinder { <-27.006,471.474,-175.515>,<2.422,448.065,-183.775>,1.000 pigment {color C3} }
  cylinder { <-27.006,471.474,-175.515>,<-43.205,437.061,-181.480>,1.000 pigment {color C3} }
  cylinder { <-27.006,471.474,-175.515>,<-26.173,467.452,-178.785>,2.000 pigment {color C2} }
  cylinder { <-26.173,467.452,-178.785>,<2.372,443.053,-187.273>,1.000 pigment {color C3} }
  cylinder { <-26.173,467.452,-178.785>,<-41.387,432.631,-184.975>,1.000 pigment {color C3} }
  cylinder { <-26.173,467.452,-178.785>,<-25.350,463.398,-182.017>,2.000 pigment {color C2} }
  cylinder { <-25.350,463.398,-182.017>,<.901,437.702,-190.928>,1.000 pigment {color C3} }
  cylinder { <-25.350,463.398,-182.017>,<-39.300,428.831,-188.292>,1.000 pigment {color C3} }
  cylinder { <-25.350,463.398,-182.017>,<-24.535,459.312,-185.212>,2.000 pigment {color C2} }
  cylinder { <-24.535,459.312,-185.212>,<2.096,433.865,-193.697>,1.000 pigment {color C3} }
  cylinder { <-24.535,459.312,-185.212>,<-38.026,424.551,-191.416>,1.000 pigment {color C3} }
  cylinder { <-24.535,459.312,-185.212>,<-23.731,455.195,-188.369>,2.000 pigment {color C2} }
  cylinder { <-23.731,455.195,-188.369>,<.107,428.213,-197.317>,1.000 pigment {color C3} }
  cylinder { <-23.731,455.195,-188.369>,<-34.882,420.451,-195.070>,1.000 pigment {color C3} }
  cylinder { <-23.731,455.195,-188.369>,<-22.936,451.048,-191.489>,2.000 pigment {color C2} }
  cylinder { <-22.936,451.048,-191.489>,<.840,423.932,-200.193>,1.000 pigment {color C3} }
  cylinder { <-22.936,451.048,-191.489>,<-33.615,416.138,-198.094>,1.000 pigment {color C3} }
  cylinder { <-22.936,451.048,-191.489>,<-22.151,446.872,-194.572>,2.000 pigment {color C2} }
  cylinder { <-22.151,446.872,-194.572>,<.187,419.444,-203.155>,1.000 pigment {color C3} }
  cylinder { <-22.151,446.872,-194.572>,<-31.057,412.236,-201.352>,1.000 pigment {color C3} }
  cylinder { <-22.151,446.872,-194.572>,<-21.374,442.667,-197.618>,2.000 pigment {color C2} }
  cylinder { <-21.374,442.667,-197.618>,<1.370,415.459,-205.824>,1.000 pigment {color C3} }
  cylinder { <-21.374,442.667,-197.618>,<-30.912,408.104,-203.897>,1.000 pigment {color C3} }
  cylinder { <-21.374,442.667,-197.618>,<-20.608,438.434,-200.627>,2.000 pigment {color C2} }
  cylinder { <-20.608,438.434,-200.627>,<-.236,410.316,-208.927>,1.000 pigment {color C3} }
  cylinder { <-20.608,438.434,-200.627>,<-27.295,404.025,-207.396>,1.000 pigment {color C3} }
  cylinder { <-20.608,438.434,-200.627>,<-19.850,434.173,-203.600>,2.000 pigment {color C2} }
  cylinder { <-19.850,434.173,-203.600>,<-.0245,405.629,-211.762>,1.000 pigment {color C3} }
  cylinder { <-19.850,434.173,-203.600>,<-27.719,399.895,-209.727>,1.000 pigment {color C3} }
  cylinder { <-19.850,434.173,-203.600>,<-19.102,429.886,-206.536>,2.000 pigment {color C2} }
  cylinder { <-19.102,429.886,-206.536>,<-2.178,400.363,-214.718>,1.000 pigment {color C3} }
  cylinder { <-19.102,429.886,-206.536>,<-24.712,395.932,-212.913>,1.000 pigment {color C3} }
  cylinder { <-19.102,429.886,-206.536>,<-18.363,425.573,-209.437>,2.000 pigment {color C2} }
  cylinder { <-18.363,425.573,-209.437>,<-1.502,395.946,-217.370>,1.000 pigment {color C3} }
  cylinder { <-18.363,425.573,-209.437>,<-22.942,391.467,-215.826>,1.000 pigment {color C3} }
  cylinder { <-18.363,425.573,-209.437>,<-17.633,421.234,-212.301>,2.000 pigment {color C2} }
  cylinder { <-17.633,421.234,-212.301>,<-16.912,416.871,-215.130>,2.000 pigment {color C2} }
  sphere { <-71.604,535.247,5.774>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-71.072,600.145,4.901>,2.000 pigment {color C2} }
  cylinder { <-71.072,600.145,4.901>,<-108.934,577.005,-23.156>,1.000 pigment {color C3} }
  cylinder { <-71.072,600.145,4.901>,<-28.772,607.735,-25.254>,1.000 pigment {color C3} }
  cylinder { <-71.072,600.145,4.901>,<-70.419,598.313,9.777>,2.000 pigment {color C2} }
  cylinder { <-70.419,598.313,9.777>,<-107.729,576.454,-19.995>,1.000 pigment {color C3} }
  cylinder { <-70.419,598.313,9.777>,<-27.111,606.023,-18.880>,1.000 pigment {color C3} }
  cylinder { <-70.419,598.313,9.777>,<-69.768,596.411,14.627>,2.000 pigment {color C2} }
  cylinder { <-69.768,596.411,14.627>,<-107.746,573.687,-12.289>,1.000 pigment {color C3} }
  cylinder { <-69.768,596.411,14.627>,<-26.090,604.064,-12.146>,1.000 pigment {color C3} }
  cylinder { <-69.768,596.411,14.627>,<-69.122,594.441,19.450>,2.000 pigment {color C2} }
  cylinder { <-69.122,594.441,19.450>,<-106.879,572.578,-8.471>,1.000 pigment {color C3} }
  cylinder { <-69.122,594.441,19.450>,<-25.429,602.384,-7.215>,1.000 pigment {color C3} }
  cylinder { <-69.122,594.441,19.450>,<-68.479,592.404,24.246>,2.000 pigment {color C2} }
  cylinder { <-68.479,592.404,24.246>,<-107.304,568.401,1.274>,1.000 pigment {color C3} }
  cylinder { <-68.479,592.404,24.246>,<-23.659,599.826,.852>,1.000 pigment {color C3} }
  cylinder { <-68.479,592.404,24.246>,<-67.840,590.300,29.013>,2.000 pigment {color C2} }
  cylinder { <-67.840,590.300,29.013>,<-106.709,566.685,5.715>,1.000 pigment {color C3} }
  cylinder { <-67.840,590.300,29.013>,<-22.227,597.550,7.149>,1.000 pigment {color C3} }
  cylinder { <-67.840,590.300,29.013>,<-67.205,588.130,33.751>,2.000 pigment {color C2} }
  cylinder { <-67.205,588.130,33.751>,<-106.039,563.987,12.557>,1.000 pigment {color C3} }
  cylinder { <-67.205,588.130,33.751>,<-21.837,595.269,12.992>,1.000 pigment {color C3} }
  cylinder { <-67.205,588.130,33.751>,<-66.574,585.895,38.460>,2.000 pigment {color C2} }
  cylinder { <-66.574,585.895,38.460>,<-105.312,562.530,16.242>,1.000 pigment {color C3} }
  cylinder { <-66.574,585.895,38.460>,<-20.170,592.495,19.933>,1.000 pigment {color C3} }
  cylinder { <-66.574,585.895,38.460>,<-65.947,583.595,43.138>,2.000 pigment {color C2} }
  cylinder { <-65.947,583.595,43.138>,<-104.745,558.839,24.379>,1.000 pigment {color C3} }
  cylinder { <-65.947,583.595,43.138>,<-19.278,589.453,27.081>,1.000 pigment {color C3} }
  cylinder { <-65.947,583.595,43.138>,<-65.324,581.233,47.784>,2.000 pigment {color C2} }
  cylinder { <-65.324,581.233,47.784>,<-104.166,556.799,28.697>,1.000 pigment {color C3} }
  cylinder { <-65.324,581.233,47.784>,<-18.645,587.221,31.807>,1.000 pigment {color C3} }
  cylinder { <-65.324,581.233,47.784>,<-64.706,578.807,52.399>,2.000 pigment {color C2} }
  cylinder { <-64.706,578.807,52.399>,<-103.173,554.201,34.629>,1.000 pigment {color C3} }
  cylinder { <-64.706,578.807,52.399>,<-17.904,583.922,38.819>,1.000 pigment {color C3} }
  cylinder { <-64.706,578.807,52.399>,<-64.091,576.320,56.982>,2.000 pigment {color C2} }
  cylinder { <-64.091,576.320,56.982>,<-102.648,551.597,39.571>,1.000 pigment {color C3} }
  cylinder { <-64.091,576.320,56.982>,<-17.050,581.204,44.167>,1.000 pigment {color C3} }
  cylinder { <-64.091,576.320,56.982>,<-63.482,573.772,61.531>,2.000 pigment {color C2} }
  cylinder { <-63.482,573.772,61.531>,<-101.582,548.030,46.747>,1.000 pigment {color C3} }
  cylinder { <-63.482,573.772,61.531>,<-16.688,577.991,50.333>,1.000 pigment {color C3} }
  cylinder { <-63.482,573.772,61.531>,<-62.876,571.164,66.048>,2.000 pigment {color C2} }
  cylinder { <-62.876,571.164,66.048>,<-100.970,544.854,52.280>,1.000 pigment {color C3} }
  cylinder { <-62.876,571.164,66.048>,<-15.711,574.728,56.268>,1.000 pigment {color C3} }
  cylinder { <-62.876,571.164,66.048>,<-62.276,568.497,70.530>,2.000 pigment {color C2} }
  cylinder { <-62.276,568.497,70.530>,<-99.608,541.191,59.285>,1.000 pigment {color C3} }
  cylinder { <-62.276,568.497,70.530>,<-15.117,570.150,64.278>,1.000 pigment {color C3} }
  cylinder { <-62.276,568.497,70.530>,<-61.679,565.772,74.977>,2.000 pigment {color C2} }
  cylinder { <-61.679,565.772,74.977>,<-99.140,539.084,62.723>,1.000 pigment {color C3} }
  cylinder { <-61.679,565.772,74.977>,<-14.626,567.823,68.084>,1.000 pigment {color C3} }
  cylinder { <-61.679,565.772,74.977>,<-61.088,562.990,79.390>,2.000 pigment {color C2} }
  cylinder { <-61.088,562.990,79.390>,<-97.764,535.696,68.924>,1.000 pigment {color C3} }
  cylinder { <-61.088,562.990,79.390>,<-14.322,562.969,75.852>,1.000 pigment {color C3} }
  cylinder { <-61.088,562.990,79.390>,<-60.501,560.151,83.767>,2.000 pigment {color C2} }
  cylinder { <-60.501,560.151,83.767>,<-96.975,532.247,74.245>,1.000 pigment {color C3} }
  cylinder { <-60.501,560.151,83.767>,<-13.735,560.096,80.229>,1.000 pigment {color C3} }
  cylinder { <-60.501,560.151,83.767>,<-59.919,557.256,88.108>,2.000 pigment {color C2} }
  cylinder { <-59.919,557.256,88.108>,<-95.438,528.769,80.274>,1.000 pigment {color C3} }
  cylinder { <-59.919,557.256,88.108>,<-13.767,555.422,87.097>,1.000 pigment {color C3} }
  cylinder { <-59.919,557.256,88.108>,<-59.342,554.307,92.413>,2.000 pigment {color C2} }
  cylinder { <-59.342,554.307,92.413>,<-94.731,525.587,84.851>,1.000 pigment {color C3} }
  cylinder { <-59.342,554.307,92.413>,<-13.235,553.747,89.542>,1.000 pigment {color C3} }
  cylinder { <-59.342,554.307,92.413>,<-58.770,551.305,96.681>,2.000 pigment {color C2} }
  cylinder { <-58.770,551.305,96.681>,<-93.079,522.020,90.714>,1.000 pigment {color C3} }
  cylinder { <-58.770,551.305,96.681>,<-13.359,548.465,96.823>,1.000 pigment {color C3} }
  cylinder { <-58.770,551.305,96.681>,<-58.203,548.249,100.913>,2.000 pigment {color C2} }
  cylinder { <-58.203,548.249,100.913>,<-92.767,519.482,93.985>,1.000 pigment {color C3} }
  cylinder { <-58.203,548.249,100.913>,<-12.884,544.400,102.181>,1.000 pigment {color C3} }
  cylinder { <-58.203,548.249,100.913>,<-57.641,545.142,105.107>,2.000 pigment {color C2} }
  cylinder { <-57.641,545.142,105.107>,<-91.071,515.810,99.711>,1.000 pigment {color C3} }
  cylinder { <-57.641,545.142,105.107>,<-13.087,540.795,106.871>,1.000 pigment {color C3} }
  cylinder { <-57.641,545.142,105.107>,<-57.084,541.984,109.264>,2.000 pigment {color C2} }
  cylinder { <-57.084,541.984,109.264>,<-90.072,512.020,104.680>,1.000 pigment {color C3} }
  cylinder { <-57.084,541.984,109.264>,<-12.699,536.585,112.076>,1.000 pigment {color C3} }
  cylinder { <-57.084,541.984,109.264>,<-56.532,538.776,113.382>,2.000 pigment {color C2} }
  cylinder { <-56.532,538.776,113.382>,<-87.956,507.945,110.777>,1.000 pigment {color C3} }
  cylinder { <-56.532,538.776,113.382>,<-13.058,532.396,117.146>,1.000 pigment {color C3} }
  cylinder { <-56.532,538.776,113.382>,<-55.985,535.518,117.463>,2.000 pigment {color C2} }
  cylinder { <-55.985,535.518,117.463>,<-87.458,504.770,114.495>,1.000 pigment {color C3} }
  cylinder { <-55.985,535.518,117.463>,<-12.521,529.026,121.151>,1.000 pigment {color C3} }
  cylinder { <-55.985,535.518,117.463>,<-55.443,532.213,121.506>,2.000 pigment {color C2} }
  cylinder { <-55.443,532.213,121.506>,<-84.881,500.328,120.922>,1.000 pigment {color C3} }
  cylinder { <-55.443,532.213,121.506>,<-13.405,523.265,127.536>,1.000 pigment {color C3} }
  cylinder { <-55.443,532.213,121.506>,<-54.906,528.860,125.510>,2.000 pigment {color C2} }
  cylinder { <-54.906,528.860,125.510>,<-84.394,497.030,124.558>,1.000 pigment {color C3} }
  cylinder { <-54.906,528.860,125.510>,<-12.883,519.778,131.436>,1.000 pigment {color C3} }
  cylinder { <-54.906,528.860,125.510>,<-54.375,525.460,129.475>,2.000 pigment {color C2} }
  cylinder { <-54.375,525.460,129.475>,<-82.742,493.547,129.208>,1.000 pigment {color C3} }
  cylinder { <-54.375,525.460,129.475>,<-13.612,514.912,136.576>,1.000 pigment {color C3} }
  cylinder { <-54.375,525.460,129.475>,<-53.848,522.016,133.402>,2.000 pigment {color C2} }
  cylinder { <-53.848,522.016,133.402>,<-82.264,490.150,132.773>,1.000 pigment {color C3} }
  cylinder { <-53.848,522.016,133.402>,<-13.102,511.326,140.383>,1.000 pigment {color C3} }
  cylinder { <-53.848,522.016,133.402>,<-53.327,518.526,137.290>,2.000 pigment {color C2} }
  cylinder { <-53.327,518.526,137.290>,<-79.458,485.678,138.759>,1.000 pigment {color C3} }
  cylinder { <-53.327,518.526,137.290>,<-14.687,504.909,146.537>,1.000 pigment {color C3} }
  cylinder { <-53.327,518.526,137.290>,<-52.811,514.993,141.139>,2.000 pigment {color C2} }
  cylinder { <-52.811,514.993,141.139>,<-78.590,481.873,142.718>,1.000 pigment {color C3} }
  cylinder { <-52.811,514.993,141.139>,<-14.192,501.217,150.233>,1.000 pigment {color C3} }
  cylinder { <-52.811,514.993,141.139>,<-52.301,511.417,144.948>,2.000 pigment {color C2} }
  cylinder { <-52.301,511.417,144.948>,<-76.463,478.022,147.515>,1.000 pigment {color C3} }
  cylinder { <-52.301,511.417,144.948>,<-14.897,496.736,154.496>,1.000 pigment {color C3} }
  cylinder { <-52.301,511.417,144.948>,<-51.795,507.799,148.719>,2.000 pigment {color C2} }
  cylinder { <-51.795,507.799,148.719>,<-76.427,474.694,150.472>,1.000 pigment {color C3} }
  cylinder { <-51.795,507.799,148.719>,<-15.321,491.492,159.177>,1.000 pigment {color C3} }
  cylinder { <-51.795,507.799,148.719>,<-51.295,504.140,152.450>,2.000 pigment {color C2} }
  cylinder { <-51.295,504.140,152.450>,<-73.411,470.276,155.987>,1.000 pigment {color C3} }
  cylinder { <-51.295,504.140,152.450>,<-16.790,486.039,163.856>,1.000 pigment {color C3} }
  cylinder { <-51.295,504.140,152.450>,<-50.800,500.441,156.142>,2.000 pigment {color C2} }
  cylinder { <-50.800,500.441,156.142>,<-73.409,466.831,158.896>,1.000 pigment {color C3} }
  cylinder { <-50.800,500.441,156.142>,<-16.321,482.170,167.354>,1.000 pigment {color C3} }
  cylinder { <-50.800,500.441,156.142>,<-50.311,496.702,159.795>,2.000 pigment {color C2} }
  cylinder { <-50.311,496.702,159.795>,<-70.315,462.458,164.177>,1.000 pigment {color C3} }
  cylinder { <-50.311,496.702,159.795>,<-17.530,477.188,171.486>,1.000 pigment {color C3} }
  cylinder { <-50.311,496.702,159.795>,<-49.826,492.924,163.409>,2.000 pigment {color C2} }
  cylinder { <-49.826,492.924,163.409>,<-69.878,458.664,167.433>,1.000 pigment {color C3} }
  cylinder { <-49.826,492.924,163.409>,<-17.073,473.244,174.895>,1.000 pigment {color C3} }
  cylinder { <-49.826,492.924,163.409>,<-49.347,489.109,166.983>,2.000 pigment {color C2} }
  cylinder { <-49.347,489.109,166.983>,<-67.189,454.580,172.088>,1.000 pigment {color C3} }
  cylinder { <-49.347,489.109,166.983>,<-18.735,467.815,179.070>,1.000 pigment {color C3} }
  cylinder { <-49.347,489.109,166.983>,<-48.873,485.257,170.519>,2.000 pigment {color C2} }
  cylinder { <-48.873,485.257,170.519>,<-66.763,450.702,175.271>,1.000 pigment {color C3} }
  cylinder { <-48.873,485.257,170.519>,<-17.892,464.245,182.151>,1.000 pigment {color C3} }
  cylinder { <-48.873,485.257,170.519>,<-48.405,481.368,174.015>,2.000 pigment {color C2} }
  cylinder { <-48.405,481.368,174.015>,<-63.541,446.489,180.061>,1.000 pigment {color C3} }
  cylinder { <-48.405,481.368,174.015>,<-20.042,458.417,186.304>,1.000 pigment {color C3} }
  cylinder { <-48.405,481.368,174.015>,<-47.941,477.445,177.472>,2.000 pigment {color C2} }
  cylinder { <-47.941,477.445,177.472>,<-64.134,442.879,182.498>,1.000 pigment {color C3} }
  cylinder { <-47.941,477.445,177.472>,<-20.040,453.914,189.722>,1.000 pigment {color C3} }
  cylinder { <-47.941,477.445,177.472>,<-47.483,473.486,180.890>,2.000 pigment {color C2} }
  cylinder { <-47.483,473.486,180.890>,<-61.932,439.005,186.467>,1.000 pigment {color C3} }
  cylinder { <-47.483,473.486,180.890>,<-20.989,449.416,193.035>,1.000 pigment {color C3} }
  cylinder { <-47.483,473.486,180.890>,<-47.030,469.494,184.270>,2.000 pigment {color C2} }
  cylinder { <-47.030,469.494,184.270>,<-61.524,434.979,189.510>,1.000 pigment {color C3} }
  cylinder { <-47.030,469.494,184.270>,<-20.567,445.272,196.179>,1.000 pigment {color C3} }
  cylinder { <-47.030,469.494,184.270>,<-46.583,465.469,187.611>,2.000 pigment {color C2} }
  cylinder { <-46.583,465.469,187.611>,<-58.303,430.839,193.919>,1.000 pigment {color C3} }
  cylinder { <-46.583,465.469,187.611>,<-22.432,440.006,199.642>,1.000 pigment {color C3} }
  cylinder { <-46.583,465.469,187.611>,<-46.140,461.412,190.913>,2.000 pigment {color C2} }
  cylinder { <-46.140,461.412,190.913>,<-57.904,426.738,196.890>,1.000 pigment {color C3} }
  cylinder { <-46.140,461.412,190.913>,<-22.486,435.430,202.823>,1.000 pigment {color C3} }
  cylinder { <-46.140,461.412,190.913>,<-45.702,457.323,194.176>,2.000 pigment {color C2} }
  cylinder { <-45.702,457.323,194.176>,<-54.141,422.640,201.309>,1.000 pigment {color C3} }
  cylinder { <-45.702,457.323,194.176>,<-23.931,430.627,205.935>,1.000 pigment {color C3} }
  cylinder { <-45.702,457.323,194.176>,<-45.270,453.203,197.402>,2.000 pigment {color C2} }
  cylinder { <-45.270,453.203,197.402>,<-54.286,418.553,203.959>,1.000 pigment {color C3} }
  cylinder { <-45.270,453.203,197.402>,<-24.012,426.027,208.999>,1.000 pigment {color C3} }
  cylinder { <-45.270,453.203,197.402>,<-44.843,449.054,200.589>,2.000 pigment {color C2} }
  cylinder { <-44.843,449.054,200.589>,<-52.676,414.856,207.194>,1.000 pigment {color C3} }
  cylinder { <-44.843,449.054,200.589>,<-24.984,421.613,211.866>,1.000 pigment {color C3} }
  cylinder { <-44.843,449.054,200.589>,<-44.421,444.874,203.739>,2.000 pigment {color C2} }
  cylinder { <-44.421,444.874,203.739>,<-50.694,410.431,210.725>,1.000 pigment {color C3} }
  cylinder { <-44.421,444.874,203.739>,<-25.083,416.989,214.827>,1.000 pigment {color C3} }
  cylinder { <-44.421,444.874,203.739>,<-44.004,440.667,206.850>,2.000 pigment {color C2} }
  cylinder { <-44.004,440.667,206.850>,<-48.061,406.695,214.230>,1.000 pigment {color C3} }
  cylinder { <-44.004,440.667,206.850>,<-28.039,411.468,217.693>,1.000 pigment {color C3} }
  cylinder { <-44.004,440.667,206.850>,<-43.592,436.431,209.925>,2.000 pigment {color C2} }
  cylinder { <-43.592,436.431,209.925>,<-48.226,402.427,216.801>,1.000 pigment {color C3} }
  cylinder { <-43.592,436.431,209.925>,<-27.662,407.117,220.507>,1.000 pigment {color C3} }
  cylinder { <-43.592,436.431,209.925>,<-43.185,432.168,212.961>,2.000 pigment {color C2} }
  cylinder { <-43.185,432.168,212.961>,<-42.783,427.878,215.961>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-71.652,600.206,4.965>,2.000 pigment {color C2} }
  cylinder { <-71.652,600.206,4.965>,<-106.318,576.344,-25.234>,1.000 pigment {color C3} }
  cylinder { <-71.652,600.206,4.965>,<-24.423,606.607,-15.325>,1.000 pigment {color C3} }
  cylinder { <-71.652,600.206,4.965>,<-71.575,598.433,9.906>,2.000 pigment {color C2} }
  cylinder { <-71.575,598.433,9.906>,<-106.893,574.241,-19.258>,1.000 pigment {color C3} }
  cylinder { <-71.575,598.433,9.906>,<-24.697,605.244,-11.052>,1.000 pigment {color C3} }
  cylinder { <-71.575,598.433,9.906>,<-71.498,596.591,14.822>,2.000 pigment {color C2} }
  cylinder { <-71.498,596.591,14.822>,<-106.932,572.376,-12.913>,1.000 pigment {color C3} }
  cylinder { <-71.498,596.591,14.822>,<-24.247,603.146,-3.496>,1.000 pigment {color C3} }
  cylinder { <-71.498,596.591,14.822>,<-71.422,594.680,19.711>,2.000 pigment {color C2} }
  cylinder { <-71.422,594.680,19.711>,<-106.573,571.256,-9.044>,1.000 pigment {color C3} }
  cylinder { <-71.422,594.680,19.711>,<-24.169,601.481,1.486>,1.000 pigment {color C3} }
  cylinder { <-71.422,594.680,19.711>,<-71.346,592.700,24.573>,2.000 pigment {color C2} }
  cylinder { <-71.346,592.700,24.573>,<-107.534,567.670,-.00418>,1.000 pigment {color C3} }
  cylinder { <-71.346,592.700,24.573>,<-23.334,598.682,10.456>,1.000 pigment {color C3} }
  cylinder { <-71.346,592.700,24.573>,<-71.271,590.654,29.407>,2.000 pigment {color C2} }
  cylinder { <-71.271,590.654,29.407>,<-107.464,565.975,4.484>,1.000 pigment {color C3} }
  cylinder { <-71.271,590.654,29.407>,<-23.258,596.820,15.375>,1.000 pigment {color C3} }
  cylinder { <-71.271,590.654,29.407>,<-71.196,588.540,34.212>,2.000 pigment {color C2} }
  cylinder { <-71.196,588.540,34.212>,<-107.289,563.772,10.676>,1.000 pigment {color C3} }
  cylinder { <-71.196,588.540,34.212>,<-23.167,594.091,22.699>,1.000 pigment {color C3} }
  cylinder { <-71.196,588.540,34.212>,<-71.121,586.361,38.988>,2.000 pigment {color C2} }
  cylinder { <-71.121,586.361,38.988>,<-107.219,561.927,15.114>,1.000 pigment {color C3} }
  cylinder { <-71.121,586.361,38.988>,<-23.092,592.060,27.552>,1.000 pigment {color C3} }
  cylinder { <-71.121,586.361,38.988>,<-71.047,584.117,43.734>,2.000 pigment {color C2} }
  cylinder { <-71.047,584.117,43.734>,<-107.510,558.010,23.988>,1.000 pigment {color C3} }
  cylinder { <-71.047,584.117,43.734>,<-22.975,588.780,35.470>,1.000 pigment {color C3} }
  cylinder { <-71.047,584.117,43.734>,<-70.974,581.809,48.448>,2.000 pigment {color C2} }
  cylinder { <-70.974,581.809,48.448>,<-107.330,556.372,27.659>,1.000 pigment {color C3} }
  cylinder { <-70.974,581.809,48.448>,<-22.900,586.573,40.248>,1.000 pigment {color C3} }
  cylinder { <-70.974,581.809,48.448>,<-70.901,579.437,53.132>,2.000 pigment {color C2} }
  cylinder { <-70.901,579.437,53.132>,<-107.170,552.707,35.727>,1.000 pigment {color C3} }
  cylinder { <-70.901,579.437,53.132>,<-22.913,582.655,48.694>,1.000 pigment {color C3} }
  cylinder { <-70.901,579.437,53.132>,<-70.828,577.003,57.783>,2.000 pigment {color C2} }
  cylinder { <-70.828,577.003,57.783>,<-107.103,550.516,40.022>,1.000 pigment {color C3} }
  cylinder { <-70.828,577.003,57.783>,<-22.934,580.606,52.678>,1.000 pigment {color C3} }
  cylinder { <-70.828,577.003,57.783>,<-70.756,574.508,62.401>,2.000 pigment {color C2} }
  cylinder { <-70.756,574.508,62.401>,<-106.612,547.489,46.586>,1.000 pigment {color C3} }
  cylinder { <-70.756,574.508,62.401>,<-23.314,577.079,59.504>,1.000 pigment {color C3} }
  cylinder { <-70.756,574.508,62.401>,<-70.685,571.951,66.986>,2.000 pigment {color C2} }
  cylinder { <-70.685,571.951,66.986>,<-106.525,545.542,50.140>,1.000 pigment {color C3} }
  cylinder { <-70.685,571.951,66.986>,<-23.242,574.551,64.123>,1.000 pigment {color C3} }
  cylinder { <-70.685,571.951,66.986>,<-70.614,569.335,71.537>,2.000 pigment {color C2} }
  cylinder { <-70.614,569.335,71.537>,<-105.870,541.242,58.599>,1.000 pigment {color C3} }
  cylinder { <-70.614,569.335,71.537>,<-23.722,570.040,72.099>,1.000 pigment {color C3} }
  cylinder { <-70.614,569.335,71.537>,<-70.543,566.660,76.054>,2.000 pigment {color C2} }
  cylinder { <-70.543,566.660,76.054>,<-105.876,539.511,61.419>,1.000 pigment {color C3} }
  cylinder { <-70.543,566.660,76.054>,<-23.660,566.950,77.283>,1.000 pigment {color C3} }
  cylinder { <-70.543,566.660,76.054>,<-70.473,563.927,80.536>,2.000 pigment {color C2} }
  cylinder { <-70.473,563.927,80.536>,<-104.825,534.758,70.360>,1.000 pigment {color C3} }
  cylinder { <-70.473,563.927,80.536>,<-24.517,562.129,84.921>,1.000 pigment {color C3} }
  cylinder { <-70.473,563.927,80.536>,<-70.404,561.136,84.982>,2.000 pigment {color C2} }
  cylinder { <-70.404,561.136,84.982>,<-104.954,532.849,73.127>,1.000 pigment {color C3} }
  cylinder { <-70.404,561.136,84.982>,<-24.320,560.124,88.096>,1.000 pigment {color C3} }
  cylinder { <-70.404,561.136,84.982>,<-70.335,558.290,89.393>,2.000 pigment {color C2} }
  cylinder { <-70.335,558.290,89.393>,<-104.066,529.475,79.283>,1.000 pigment {color C3} }
  cylinder { <-70.335,558.290,89.393>,<-25.473,554.649,96.055>,1.000 pigment {color C3} }
  cylinder { <-70.335,558.290,89.393>,<-70.267,555.388,93.768>,2.000 pigment {color C2} }
  cylinder { <-70.267,555.388,93.768>,<-104.003,526.709,83.295>,1.000 pigment {color C3} }
  cylinder { <-70.267,555.388,93.768>,<-25.406,551.655,100.383>,1.000 pigment {color C3} }
  cylinder { <-70.267,555.388,93.768>,<-70.200,552.431,98.105>,2.000 pigment {color C2} }
  cylinder { <-70.200,552.431,98.105>,<-102.861,522.877,89.933>,1.000 pigment {color C3} }
  cylinder { <-70.200,552.431,98.105>,<-26.446,547.309,106.259>,1.000 pigment {color C3} }
  cylinder { <-70.200,552.431,98.105>,<-70.133,549.421,102.406>,2.000 pigment {color C2} }
  cylinder { <-70.133,549.421,102.406>,<-102.800,519.977,93.868>,1.000 pigment {color C3} }
  cylinder { <-70.133,549.421,102.406>,<-26.090,545.111,109.387>,1.000 pigment {color C3} }
  cylinder { <-70.133,549.421,102.406>,<-70.066,546.358,106.670>,2.000 pigment {color C2} }
  cylinder { <-70.066,546.358,106.670>,<-101.495,516.079,100.328>,1.000 pigment {color C3} }
  cylinder { <-70.066,546.358,106.670>,<-27.330,540.177,115.628>,1.000 pigment {color C3} }
  cylinder { <-70.066,546.358,106.670>,<-70.000,543.244,110.896>,2.000 pigment {color C2} }
  cylinder { <-70.000,543.244,110.896>,<-101.223,512.705,104.785>,1.000 pigment {color C3} }
  cylinder { <-70.000,543.244,110.896>,<-27.849,535.525,121.311>,1.000 pigment {color C3} }
  cylinder { <-70.000,543.244,110.896>,<-69.935,540.079,115.084>,2.000 pigment {color C2} }
  cylinder { <-69.935,540.079,115.084>,<-99.725,508.778,111.043>,1.000 pigment {color C3} }
  cylinder { <-69.935,540.079,115.084>,<-29.373,530.451,127.150>,1.000 pigment {color C3} }
  cylinder { <-69.935,540.079,115.084>,<-69.870,536.864,119.234>,2.000 pigment {color C2} }
  cylinder { <-69.870,536.864,119.234>,<-99.404,505.295,115.396>,1.000 pigment {color C3} }
  cylinder { <-69.870,536.864,119.234>,<-29.310,527.084,131.184>,1.000 pigment {color C3} }
  cylinder { <-69.870,536.864,119.234>,<-69.806,533.600,123.345>,2.000 pigment {color C2} }
  cylinder { <-69.806,533.600,123.345>,<-98.322,501.961,120.325>,1.000 pigment {color C3} }
  cylinder { <-69.806,533.600,123.345>,<-30.418,522.872,135.868>,1.000 pigment {color C3} }
  cylinder { <-69.806,533.600,123.345>,<-69.743,530.287,127.418>,2.000 pigment {color C2} }
  cylinder { <-69.743,530.287,127.418>,<-97.975,498.379,124.582>,1.000 pigment {color C3} }
  cylinder { <-69.743,530.287,127.418>,<-30.631,518.922,140.239>,1.000 pigment {color C3} }
  cylinder { <-69.743,530.287,127.418>,<-69.680,526.928,131.452>,2.000 pigment {color C2} }
  cylinder { <-69.680,526.928,131.452>,<-95.885,494.109,130.984>,1.000 pigment {color C3} }
  cylinder { <-69.680,526.928,131.452>,<-32.080,514.154,145.130>,1.000 pigment {color C3} }
  cylinder { <-69.680,526.928,131.452>,<-69.617,523.522,135.447>,2.000 pigment {color C2} }
  cylinder { <-69.617,523.522,135.447>,<-95.485,490.435,135.129>,1.000 pigment {color C3} }
  cylinder { <-69.617,523.522,135.447>,<-32.330,510.101,149.357>,1.000 pigment {color C3} }
  cylinder { <-69.617,523.522,135.447>,<-69.556,520.071,139.403>,2.000 pigment {color C2} }
  cylinder { <-69.556,520.071,139.403>,<-93.931,486.742,140.249>,1.000 pigment {color C3} }
  cylinder { <-69.556,520.071,139.403>,<-33.863,505.280,153.994>,1.000 pigment {color C3} }
  cylinder { <-69.556,520.071,139.403>,<-69.495,516.576,143.319>,2.000 pigment {color C2} }
  cylinder { <-69.495,516.576,143.319>,<-94.597,483.784,142.777>,1.000 pigment {color C3} }
  cylinder { <-69.495,516.576,143.319>,<-34.499,500.659,158.406>,1.000 pigment {color C3} }
  cylinder { <-69.495,516.576,143.319>,<-69.434,513.037,147.197>,2.000 pigment {color C2} }
  cylinder { <-69.434,513.037,147.197>,<-92.280,479.510,148.754>,1.000 pigment {color C3} }
  cylinder { <-69.434,513.037,147.197>,<-35.753,496.280,162.465>,1.000 pigment {color C3} }
  cylinder { <-69.434,513.037,147.197>,<-69.374,509.455,151.034>,2.000 pigment {color C2} }
  cylinder { <-69.374,509.455,151.034>,<-92.611,476.169,151.739>,1.000 pigment {color C3} }
  cylinder { <-69.374,509.455,151.034>,<-36.068,492.055,166.407>,1.000 pigment {color C3} }
  cylinder { <-69.374,509.455,151.034>,<-69.315,505.831,154.833>,2.000 pigment {color C2} }
  cylinder { <-69.315,505.831,154.833>,<-89.340,471.504,158.395>,1.000 pigment {color C3} }
  cylinder { <-69.315,505.831,154.833>,<-37.735,487.184,170.549>,1.000 pigment {color C3} }
  cylinder { <-69.315,505.831,154.833>,<-69.257,502.166,158.591>,2.000 pigment {color C2} }
  cylinder { <-69.257,502.166,158.591>,<-90.542,468.468,160.424>,1.000 pigment {color C3} }
  cylinder { <-69.257,502.166,158.591>,<-38.080,482.888,174.351>,1.000 pigment {color C3} }
  cylinder { <-69.257,502.166,158.591>,<-69.199,498.461,162.311>,2.000 pigment {color C2} }
  cylinder { <-69.199,498.461,162.311>,<-88.024,464.270,165.948>,1.000 pigment {color C3} }
  cylinder { <-69.199,498.461,162.311>,<-39.380,478.459,178.041>,1.000 pigment {color C3} }
  cylinder { <-69.199,498.461,162.311>,<-69.141,494.717,165.990>,2.000 pigment {color C2} }
  cylinder { <-69.141,494.717,165.990>,<-87.532,460.297,169.690>,1.000 pigment {color C3} }
  cylinder { <-69.141,494.717,165.990>,<-39.742,474.101,181.717>,1.000 pigment {color C3} }
  cylinder { <-69.141,494.717,165.990>,<-69.085,490.934,169.630>,2.000 pigment {color C2} }
  cylinder { <-69.085,490.934,169.630>,<-84.888,456.229,174.929>,1.000 pigment {color C3} }
  cylinder { <-69.085,490.934,169.630>,<-42.365,468.391,185.759>,1.000 pigment {color C3} }
  cylinder { <-69.085,490.934,169.630>,<-69.028,487.114,173.231>,2.000 pigment {color C2} }
  cylinder { <-69.028,487.114,173.231>,<-85.304,452.520,177.774>,1.000 pigment {color C3} }
  cylinder { <-69.028,487.114,173.231>,<-42.312,464.400,189.124>,1.000 pigment {color C3} }
  cylinder { <-69.028,487.114,173.231>,<-68.973,483.256,176.792>,2.000 pigment {color C2} }
  cylinder { <-68.973,483.256,176.792>,<-83.092,448.647,182.420>,1.000 pigment {color C3} }
  cylinder { <-68.973,483.256,176.792>,<-44.094,459.579,192.580>,1.000 pigment {color C3} }
  cylinder { <-68.973,483.256,176.792>,<-68.918,479.363,180.313>,2.000 pigment {color C2} }
  cylinder { <-68.918,479.363,180.313>,<-83.043,444.700,185.589>,1.000 pigment {color C3} }
  cylinder { <-68.918,479.363,180.313>,<-43.587,455.924,195.733>,1.000 pigment {color C3} }
  cylinder { <-68.918,479.363,180.313>,<-68.864,475.434,183.796>,2.000 pigment {color C2} }
  cylinder { <-68.864,475.434,183.796>,<-81.783,441.102,189.345>,1.000 pigment {color C3} }
  cylinder { <-68.864,475.434,183.796>,<-47.258,449.616,199.384>,1.000 pigment {color C3} }
  cylinder { <-68.864,475.434,183.796>,<-68.810,471.471,187.238>,2.000 pigment {color C2} }
  cylinder { <-68.810,471.471,187.238>,<-81.251,436.964,192.795>,1.000 pigment {color C3} }
  cylinder { <-68.810,471.471,187.238>,<-46.727,445.861,202.497>,1.000 pigment {color C3} }
  cylinder { <-68.810,471.471,187.238>,<-68.757,467.475,190.642>,2.000 pigment {color C2} }
  cylinder { <-68.757,467.475,190.642>,<-79.518,433.244,196.759>,1.000 pigment {color C3} }
  cylinder { <-68.757,467.475,190.642>,<-49.014,440.797,205.591>,1.000 pigment {color C3} }
  cylinder { <-68.757,467.475,190.642>,<-68.704,463.445,194.007>,2.000 pigment {color C2} }
  cylinder { <-68.704,463.445,194.007>,<-78.480,428.976,200.432>,1.000 pigment {color C3} }
  cylinder { <-68.704,463.445,194.007>,<-47.996,437.310,208.604>,1.000 pigment {color C3} }
  cylinder { <-68.704,463.445,194.007>,<-68.653,459.383,197.333>,2.000 pigment {color C2} }
  cylinder { <-68.653,459.383,197.333>,<-77.256,425.367,203.917>,1.000 pigment {color C3} }
  cylinder { <-68.653,459.383,197.333>,<-51.754,431.345,211.572>,1.000 pigment {color C3} }
  cylinder { <-68.653,459.383,197.333>,<-68.601,455.290,200.620>,2.000 pigment {color C2} }
  cylinder { <-68.601,455.290,200.620>,<-76.206,421.089,207.470>,1.000 pigment {color C3} }
  cylinder { <-68.601,455.290,200.620>,<-51.207,427.420,214.592>,1.000 pigment {color C3} }
  cylinder { <-68.601,455.290,200.620>,<-68.551,451.166,203.869>,2.000 pigment {color C2} }
  cylinder { <-68.551,451.166,203.869>,<-74.000,417.415,211.365>,1.000 pigment {color C3} }
  cylinder { <-68.551,451.166,203.869>,<-53.482,422.554,217.258>,1.000 pigment {color C3} }
  cylinder { <-68.551,451.166,203.869>,<-68.501,447.012,207.079>,2.000 pigment {color C2} }
  cylinder { <-68.501,447.012,207.079>,<-74.967,413.263,213.724>,1.000 pigment {color C3} }
  cylinder { <-68.501,447.012,207.079>,<-53.436,418.275,220.202>,1.000 pigment {color C3} }
  cylinder { <-68.501,447.012,207.079>,<-68.451,442.829,210.251>,2.000 pigment {color C2} }
  cylinder { <-68.451,442.829,210.251>,<-68.402,438.617,213.385>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-69.552,601.270,4.734>,2.000 pigment {color C2} }
  cylinder { <-69.552,601.270,4.734>,<-111.530,572.365,1.058>,1.000 pigment {color C3} }
  cylinder { <-69.552,601.270,4.734>,<-33.688,601.586,-31.664>,1.000 pigment {color C3} }
  cylinder { <-69.552,601.270,4.734>,<-67.378,600.553,9.459>,2.000 pigment {color C2} }
  cylinder { <-67.378,600.553,9.459>,<-109.589,572.169,4.584>,1.000 pigment {color C3} }
  cylinder { <-67.378,600.553,9.459>,<-32.725,601.137,-28.090>,1.000 pigment {color C3} }
  cylinder { <-67.378,600.553,9.459>,<-65.210,599.760,14.174>,2.000 pigment {color C2} }
  cylinder { <-65.210,599.760,14.174>,<-106.498,570.858,13.764>,1.000 pigment {color C3} }
  cylinder { <-65.210,599.760,14.174>,<-28.672,600.562,-20.531>,1.000 pigment {color C3} }
  cylinder { <-65.210,599.760,14.174>,<-63.047,598.890,18.878>,2.000 pigment {color C2} }
  cylinder { <-63.047,598.890,18.878>,<-104.830,570.886,15.704>,1.000 pigment {color C3} }
  cylinder { <-63.047,598.890,18.878>,<-25.385,599.848,-14.600>,1.000 pigment {color C3} }
  cylinder { <-63.047,598.890,18.878>,<-60.889,597.943,23.569>,2.000 pigment {color C2} }
  cylinder { <-60.889,597.943,23.569>,<-101.349,569.145,25.500>,1.000 pigment {color C3} }
  cylinder { <-60.889,597.943,23.569>,<-22.167,598.903,-7.572>,1.000 pigment {color C3} }
  cylinder { <-60.889,597.943,23.569>,<-58.737,596.920,28.247>,2.000 pigment {color C2} }
  cylinder { <-58.737,596.920,28.247>,<-99.701,568.776,28.255>,1.000 pigment {color C3} }
  cylinder { <-58.737,596.920,28.247>,<-19.012,597.878,-1.602>,1.000 pigment {color C3} }
  cylinder { <-58.737,596.920,28.247>,<-56.592,595.822,32.912>,2.000 pigment {color C2} }
  cylinder { <-56.592,595.822,32.912>,<-96.457,567.453,35.565>,1.000 pigment {color C3} }
  cylinder { <-56.592,595.822,32.912>,<-16.945,596.810,4.134>,1.000 pigment {color C3} }
  cylinder { <-56.592,595.822,32.912>,<-54.454,594.648,37.561>,2.000 pigment {color C2} }
  cylinder { <-54.454,594.648,37.561>,<-94.683,566.715,39.089>,1.000 pigment {color C3} }
  cylinder { <-54.454,594.648,37.561>,<-14.337,595.652,9.442>,1.000 pigment {color C3} }
  cylinder { <-54.454,594.648,37.561>,<-52.323,593.400,42.193>,2.000 pigment {color C2} }
  cylinder { <-52.323,593.400,42.193>,<-91.077,564.973,46.981>,1.000 pigment {color C3} }
  cylinder { <-52.323,593.400,42.193>,<-11.062,593.930,17.091>,1.000 pigment {color C3} }
  cylinder { <-52.323,593.400,42.193>,<-50.200,592.077,46.809>,2.000 pigment {color C2} }
  cylinder { <-50.200,592.077,46.809>,<-88.876,563.603,51.940>,1.000 pigment {color C3} }
  cylinder { <-50.200,592.077,46.809>,<-8.935,592.688,21.715>,1.000 pigment {color C3} }
  cylinder { <-50.200,592.077,46.809>,<-48.086,590.681,51.407>,2.000 pigment {color C2} }
  cylinder { <-48.086,590.681,51.407>,<-84.952,561.696,59.562>,1.000 pigment {color C3} }
  cylinder { <-48.086,590.681,51.407>,<-6.275,590.814,28.656>,1.000 pigment {color C3} }
  cylinder { <-48.086,590.681,51.407>,<-45.980,589.212,55.986>,2.000 pigment {color C2} }
  cylinder { <-45.980,589.212,55.986>,<-83.623,560.791,62.391>,1.000 pigment {color C3} }
  cylinder { <-45.980,589.212,55.986>,<-3.470,588.981,34.571>,1.000 pigment {color C3} }
  cylinder { <-45.980,589.212,55.986>,<-43.883,587.670,60.546>,2.000 pigment {color C2} }
  cylinder { <-43.883,587.670,60.546>,<-79.912,558.908,69.163>,1.000 pigment {color C3} }
  cylinder { <-43.883,587.670,60.546>,<-.493,586.327,42.792>,1.000 pigment {color C3} }
  cylinder { <-43.883,587.670,60.546>,<-41.795,586.057,65.085>,2.000 pigment {color C2} }
  cylinder { <-41.795,586.057,65.085>,<-78.320,557.631,72.669>,1.000 pigment {color C3} }
  cylinder { <-41.795,586.057,65.085>,<.722,585.413,45.301>,1.000 pigment {color C3} }
  cylinder { <-41.795,586.057,65.085>,<-39.717,584.372,69.602>,2.000 pigment {color C2} }
  cylinder { <-39.717,584.372,69.602>,<-73.397,554.925,81.134>,1.000 pigment {color C3} }
  cylinder { <-39.717,584.372,69.602>,<3.265,582.736,52.743>,1.000 pigment {color C3} }
  cylinder { <-39.717,584.372,69.602>,<-37.650,582.617,74.098>,2.000 pigment {color C2} }
  cylinder { <-37.650,582.617,74.098>,<-72.626,553.899,83.391>,1.000 pigment {color C3} }
  cylinder { <-37.650,582.617,74.098>,<5.797,580.398,58.548>,1.000 pigment {color C3} }
  cylinder { <-37.650,582.617,74.098>,<-35.593,580.792,78.570>,2.000 pigment {color C2} }
  cylinder { <-35.593,580.792,78.570>,<-68.316,551.463,90.369>,1.000 pigment {color C3} }
  cylinder { <-35.593,580.792,78.570>,<7.788,577.690,65.204>,1.000 pigment {color C3} }
  cylinder { <-35.593,580.792,78.570>,<-33.547,578.899,83.019>,2.000 pigment {color C2} }
  cylinder { <-33.547,578.899,83.019>,<-66.841,549.841,93.855>,1.000 pigment {color C3} }
  cylinder { <-33.547,578.899,83.019>,<9.815,575.712,69.612>,1.000 pigment {color C3} }
  cylinder { <-33.547,578.899,83.019>,<-31.512,576.936,87.443>,2.000 pigment {color C2} }
  cylinder { <-31.512,576.936,87.443>,<-62.401,547.263,100.574>,1.000 pigment {color C3} }
  cylinder { <-31.512,576.936,87.443>,<11.772,572.469,76.791>,1.000 pigment {color C3} }
  cylinder { <-31.512,576.936,87.443>,<-29.489,574.907,91.841>,2.000 pigment {color C2} }
  cylinder { <-29.489,574.907,91.841>,<-60.982,545.474,104.047>,1.000 pigment {color C3} }
  cylinder { <-29.489,574.907,91.841>,<13.995,569.663,82.427>,1.000 pigment {color C3} }
  cylinder { <-29.489,574.907,91.841>,<-27.478,572.810,96.214>,2.000 pigment {color C2} }
  cylinder { <-27.478,572.810,96.214>,<-56.429,542.768,110.501>,1.000 pigment {color C3} }
  cylinder { <-27.478,572.810,96.214>,<15.584,566.159,89.418>,1.000 pigment {color C3} }
  cylinder { <-27.478,572.810,96.214>,<-25.479,570.648,100.561>,2.000 pigment {color C2} }
  cylinder { <-25.479,570.648,100.561>,<-54.603,540.596,114.472>,1.000 pigment {color C3} }
  cylinder { <-25.479,570.648,100.561>,<17.544,563.835,93.680>,1.000 pigment {color C3} }
  cylinder { <-25.479,570.648,100.561>,<-23.493,568.420,104.880>,2.000 pigment {color C2} }
  cylinder { <-23.493,568.420,104.880>,<-50.909,538.200,119.668>,1.000 pigment {color C3} }
  cylinder { <-23.493,568.420,104.880>,<18.869,560.846,99.255>,1.000 pigment {color C3} }
  cylinder { <-23.493,568.420,104.880>,<-21.519,566.128,109.171>,2.000 pigment {color C2} }
  cylinder { <-21.519,566.128,109.171>,<-48.121,535.465,124.523>,1.000 pigment {color C3} }
  cylinder { <-21.519,566.128,109.171>,<20.805,557.650,104.672>,1.000 pigment {color C3} }
  cylinder { <-21.519,566.128,109.171>,<-19.558,563.772,113.433>,2.000 pigment {color C2} }
  cylinder { <-19.558,563.772,113.433>,<-43.865,532.778,129.921>,1.000 pigment {color C3} }
  cylinder { <-19.558,563.772,113.433>,<21.895,553.765,111.273>,1.000 pigment {color C3} }
  cylinder { <-19.558,563.772,113.433>,<-17.611,561.354,117.667>,2.000 pigment {color C2} }
  cylinder { <-17.611,561.354,117.667>,<-43.124,530.699,132.919>,1.000 pigment {color C3} }
  cylinder { <-17.611,561.354,117.667>,<23.841,551.521,114.798>,1.000 pigment {color C3} }
  cylinder { <-17.611,561.354,117.667>,<-15.678,558.874,121.871>,2.000 pigment {color C2} }
  cylinder { <-15.678,558.874,121.871>,<-38.348,527.699,138.550>,1.000 pigment {color C3} }
  cylinder { <-15.678,558.874,121.871>,<24.915,548.250,120.072>,1.000 pigment {color C3} }
  cylinder { <-15.678,558.874,121.871>,<-13.758,556.333,126.045>,2.000 pigment {color C2} }
  cylinder { <-13.758,556.333,126.045>,<-36.601,525.086,142.349>,1.000 pigment {color C3} }
  cylinder { <-13.758,556.333,126.045>,<26.693,545.119,124.681>,1.000 pigment {color C3} }
  cylinder { <-13.758,556.333,126.045>,<-11.853,553.732,130.188>,2.000 pigment {color C2} }
  cylinder { <-11.853,553.732,130.188>,<-32.872,522.385,146.959>,1.000 pigment {color C3} }
  cylinder { <-11.853,553.732,130.188>,<27.544,541.342,130.350>,1.000 pigment {color C3} }
  cylinder { <-11.853,553.732,130.188>,<-9.962,551.072,134.300>,2.000 pigment {color C2} }
  cylinder { <-9.962,551.072,134.300>,<-30.601,519.463,151.051>,1.000 pigment {color C3} }
  cylinder { <-9.962,551.072,134.300>,<29.367,538.467,134.314>,1.000 pigment {color C3} }
  cylinder { <-9.962,551.072,134.300>,<-8.085,548.353,138.380>,2.000 pigment {color C2} }
  cylinder { <-8.085,548.353,138.380>,<-26.318,516.523,155.780>,1.000 pigment {color C3} }
  cylinder { <-8.085,548.353,138.380>,<29.352,533.030,141.845>,1.000 pigment {color C3} }
  cylinder { <-8.085,548.353,138.380>,<-6.223,545.577,142.429>,2.000 pigment {color C2} }
  cylinder { <-6.223,545.577,142.429>,<-24.627,513.644,159.457>,1.000 pigment {color C3} }
  cylinder { <-6.223,545.577,142.429>,<31.131,530.014,145.713>,1.000 pigment {color C3} }
  cylinder { <-6.223,545.577,142.429>,<-4.376,542.744,146.445>,2.000 pigment {color C2} }
  cylinder { <-4.376,542.744,146.445>,<-20.933,510.796,163.683>,1.000 pigment {color C3} }
  cylinder { <-4.376,542.744,146.445>,<31.589,526.061,150.934>,1.000 pigment {color C3} }
  cylinder { <-4.376,542.744,146.445>,<-2.544,539.856,150.428>,2.000 pigment {color C2} }
  cylinder { <-2.544,539.856,150.428>,<-17.527,507.367,168.091>,1.000 pigment {color C3} }
  cylinder { <-2.544,539.856,150.428>,<33.087,522.546,155.192>,1.000 pigment {color C3} }
  cylinder { <-2.544,539.856,150.428>,<-.727,536.913,154.378>,2.000 pigment {color C2} }
  cylinder { <-.727,536.913,154.378>,<-15.035,504.742,171.609>,1.000 pigment {color C3} }
  cylinder { <-.727,536.913,154.378>,<33.401,518.533,160.206>,1.000 pigment {color C3} }
  cylinder { <-.727,536.913,154.378>,<1.073,533.917,158.294>,2.000 pigment {color C2} }
  cylinder { <1.073,533.917,158.294>,<-12.817,501.494,175.395>,1.000 pigment {color C3} }
  cylinder { <1.073,533.917,158.294>,<34.822,514.917,164.348>,1.000 pigment {color C3} }
  cylinder { <1.073,533.917,158.294>,<2.859,530.867,162.177>,2.000 pigment {color C2} }
  cylinder { <2.859,530.867,162.177>,<-8.613,498.429,179.450>,1.000 pigment {color C3} }
  cylinder { <2.859,530.867,162.177>,<35.005,510.862,169.155>,1.000 pigment {color C3} }
  cylinder { <2.859,530.867,162.177>,<4.629,527.766,166.025>,2.000 pigment {color C2} }
  cylinder { <4.629,527.766,166.025>,<-7.598,495.312,182.742>,1.000 pigment {color C3} }
  cylinder { <4.629,527.766,166.025>,<36.672,507.521,172.780>,1.000 pigment {color C3} }
  cylinder { <4.629,527.766,166.025>,<6.383,524.614,169.839>,2.000 pigment {color C2} }
  cylinder { <6.383,524.614,169.839>,<-3.449,492.201,186.619>,1.000 pigment {color C3} }
  cylinder { <6.383,524.614,169.839>,<37.097,503.785,177.026>,1.000 pigment {color C3} }
  cylinder { <6.383,524.614,169.839>,<8.121,521.411,173.619>,2.000 pigment {color C2} }
  cylinder { <8.121,521.411,173.619>,<-1.282,488.772,190.204>,1.000 pigment {color C3} }
  cylinder { <8.121,521.411,173.619>,<38.392,499.993,180.953>,1.000 pigment {color C3} }
  cylinder { <8.121,521.411,173.619>,<9.843,518.159,177.363>,2.000 pigment {color C2} }
  cylinder { <9.843,518.159,177.363>,<2.803,485.674,193.843>,1.000 pigment {color C3} }
  cylinder { <9.843,518.159,177.363>,<37.650,495.201,186.089>,1.000 pigment {color C3} }
  cylinder { <9.843,518.159,177.363>,<11.549,514.859,181.073>,2.000 pigment {color C2} }
  cylinder { <11.549,514.859,181.073>,<3.758,482.309,197.079>,1.000 pigment {color C3} }
  cylinder { <11.549,514.859,181.073>,<39.621,492.009,189.214>,1.000 pigment {color C3} }
  cylinder { <11.549,514.859,181.073>,<13.239,511.512,184.747>,2.000 pigment {color C2} }
  cylinder { <13.239,511.512,184.747>,<7.769,479.182,200.555>,1.000 pigment {color C3} }
  cylinder { <13.239,511.512,184.747>,<39.528,487.892,193.463>,1.000 pigment {color C3} }
  cylinder { <13.239,511.512,184.747>,<14.913,508.118,188.386>,2.000 pigment {color C2} }
  cylinder { <14.913,508.118,188.386>,<10.463,475.553,204.029>,1.000 pigment {color C3} }
  cylinder { <14.913,508.118,188.386>,<40.689,483.961,197.161>,1.000 pigment {color C3} }
  cylinder { <14.913,508.118,188.386>,<16.570,504.678,191.990>,2.000 pigment {color C2} }
  cylinder { <16.570,504.678,191.990>,<14.378,472.481,207.256>,1.000 pigment {color C3} }
  cylinder { <16.570,504.678,191.990>,<40.516,479.859,201.216>,1.000 pigment {color C3} }
  cylinder { <16.570,504.678,191.990>,<18.211,501.194,195.558>,2.000 pigment {color C2} }
  cylinder { <18.211,501.194,195.558>,<15.283,468.875,210.438>,1.000 pigment {color C3} }
  cylinder { <18.211,501.194,195.558>,<42.039,476.168,204.527>,1.000 pigment {color C3} }
  cylinder { <18.211,501.194,195.558>,<19.836,497.665,199.090>,2.000 pigment {color C2} }
  cylinder { <19.836,497.665,199.090>,<19.105,465.787,213.520>,1.000 pigment {color C3} }
  cylinder { <19.836,497.665,199.090>,<40.934,471.524,208.912>,1.000 pigment {color C3} }
  cylinder { <19.836,497.665,199.090>,<21.444,494.094,202.586>,2.000 pigment {color C2} }
  cylinder { <21.444,494.094,202.586>,<21.138,462.075,216.718>,1.000 pigment {color C3} }
  cylinder { <21.444,494.094,202.586>,<41.970,467.491,212.381>,1.000 pigment {color C3} }
  cylinder { <21.444,494.094,202.586>,<23.035,490.481,206.046>,2.000 pigment {color C2} }
  cylinder { <23.035,490.481,206.046>,<24.610,486.826,209.471>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-74.376,599.757,-3.990>,2.000 pigment {color C2} }
  cylinder { <-74.376,599.757,-3.990>,<-26.194,602.965,-18.426>,1.000 pigment {color C3} }
  cylinder { <-74.376,599.757,-3.990>,<-91.797,578.519,38.265>,1.000 pigment {color C3} }
  cylinder { <-74.376,599.757,-3.990>,<-77.007,597.541,-7.956>,2.000 pigment {color C2} }
  cylinder { <-77.007,597.541,-7.956>,<-29.291,600.410,-23.930>,1.000 pigment {color C3} }
  cylinder { <-77.007,597.541,-7.956>,<-93.095,577.460,35.380>,1.000 pigment {color C3} }
  cylinder { <-77.007,597.541,-7.956>,<-79.621,595.259,-11.897>,2.000 pigment {color C2} }
  cylinder { <-79.621,595.259,-11.897>,<-32.823,597.981,-28.409>,1.000 pigment {color C3} }
  cylinder { <-79.621,595.259,-11.897>,<-99.232,573.015,27.985>,1.000 pigment {color C3} }
  cylinder { <-79.621,595.259,-11.897>,<-82.217,592.915,-15.811>,2.000 pigment {color C2} }
  cylinder { <-82.217,592.915,-15.811>,<-36.204,594.890,-34.492>,1.000 pigment {color C3} }
  cylinder { <-82.217,592.915,-15.811>,<-101.664,570.975,24.320>,1.000 pigment {color C3} }
  cylinder { <-82.217,592.915,-15.811>,<-84.796,590.507,-19.699>,2.000 pigment {color C2} }
  cylinder { <-84.796,590.507,-19.699>,<-40.294,591.614,-40.177>,1.000 pigment {color C3} }
  cylinder { <-84.796,590.507,-19.699>,<-105.801,567.569,18.164>,1.000 pigment {color C3} }
  cylinder { <-84.796,590.507,-19.699>,<-87.357,588.038,-23.560>,2.000 pigment {color C2} }
  cylinder { <-87.357,588.038,-23.560>,<-42.292,589.916,-42.707>,1.000 pigment {color C3} }
  cylinder { <-87.357,588.038,-23.560>,<-107.221,566.185,15.540>,1.000 pigment {color C3} }
  cylinder { <-87.357,588.038,-23.560>,<-89.899,585.507,-27.393>,2.000 pigment {color C2} }
  cylinder { <-89.899,585.507,-27.393>,<-46.652,586.096,-48.893>,1.000 pigment {color C3} }
  cylinder { <-89.899,585.507,-27.393>,<-112.075,561.811,8.378>,1.000 pigment {color C3} }
  cylinder { <-89.899,585.507,-27.393>,<-92.423,582.916,-31.198>,2.000 pigment {color C2} }
  cylinder { <-92.423,582.916,-31.198>,<-49.495,583.219,-53.333>,1.000 pigment {color C3} }
  cylinder { <-92.423,582.916,-31.198>,<-113.995,559.861,5.353>,1.000 pigment {color C3} }
  cylinder { <-92.423,582.916,-31.198>,<-94.929,580.266,-34.975>,2.000 pigment {color C2} }
  cylinder { <-94.929,580.266,-34.975>,<-53.608,579.501,-58.592>,1.000 pigment {color C3} }
  cylinder { <-94.929,580.266,-34.975>,<-118.052,555.758,-1.353>,1.000 pigment {color C3} }
  cylinder { <-94.929,580.266,-34.975>,<-97.414,577.557,-38.723>,2.000 pigment {color C2} }
  cylinder { <-97.414,577.557,-38.723>,<-56.089,576.833,-62.332>,1.000 pigment {color C3} }
  cylinder { <-97.414,577.557,-38.723>,<-120.364,553.249,-4.837>,1.000 pigment {color C3} }
  cylinder { <-97.414,577.557,-38.723>,<-99.881,574.791,-42.441>,2.000 pigment {color C2} }
  cylinder { <-99.881,574.791,-42.441>,<-60.940,572.100,-68.441>,1.000 pigment {color C3} }
  cylinder { <-99.881,574.791,-42.441>,<-123.730,549.432,-11.013>,1.000 pigment {color C3} }
  cylinder { <-99.881,574.791,-42.441>,<-102.328,571.968,-46.130>,2.000 pigment {color C2} }
  cylinder { <-102.328,571.968,-46.130>,<-64.141,568.429,-73.127>,1.000 pigment {color C3} }
  cylinder { <-102.328,571.968,-46.130>,<-124.967,548.002,-12.772>,1.000 pigment {color C3} }
  cylinder { <-102.328,571.968,-46.130>,<-104.755,569.089,-49.788>,2.000 pigment {color C2} }
  cylinder { <-104.755,569.089,-49.788>,<-68.313,564.292,-77.778>,1.000 pigment {color C3} }
  cylinder { <-104.755,569.089,-49.788>,<-129.109,542.852,-20.583>,1.000 pigment {color C3} }
  cylinder { <-104.755,569.089,-49.788>,<-107.161,566.155,-53.417>,2.000 pigment {color C2} }
  cylinder { <-107.161,566.155,-53.417>,<-70.281,561.760,-80.893>,1.000 pigment {color C3} }
  cylinder { <-107.161,566.155,-53.417>,<-130.450,541.268,-22.229>,1.000 pigment {color C3} }
  cylinder { <-107.161,566.155,-53.417>,<-109.548,563.168,-57.014>,2.000 pigment {color C2} }
  cylinder { <-109.548,563.168,-57.014>,<-75.260,556.575,-86.188>,1.000 pigment {color C3} }
  cylinder { <-109.548,563.168,-57.014>,<-133.704,536.814,-28.868>,1.000 pigment {color C3} }
  cylinder { <-109.548,563.168,-57.014>,<-111.913,560.127,-60.581>,2.000 pigment {color C2} }
  cylinder { <-111.913,560.127,-60.581>,<-78.014,553.009,-90.084>,1.000 pigment {color C3} }
  cylinder { <-111.913,560.127,-60.581>,<-135.635,534.301,-31.589>,1.000 pigment {color C3} }
  cylinder { <-111.913,560.127,-60.581>,<-114.258,557.035,-64.116>,2.000 pigment {color C2} }
  cylinder { <-114.258,557.035,-64.116>,<-82.603,548.106,-94.535>,1.000 pigment {color C3} }
  cylinder { <-114.258,557.035,-64.116>,<-138.788,529.395,-38.791>,1.000 pigment {color C3} }
  cylinder { <-114.258,557.035,-64.116>,<-116.583,553.891,-67.620>,2.000 pigment {color C2} }
  cylinder { <-116.583,553.891,-67.620>,<-84.417,545.339,-97.608>,1.000 pigment {color C3} }
  cylinder { <-116.583,553.891,-67.620>,<-140.927,526.345,-42.016>,1.000 pigment {color C3} }
  cylinder { <-116.583,553.891,-67.620>,<-118.886,550.697,-71.092>,2.000 pigment {color C2} }
  cylinder { <-118.886,550.697,-71.092>,<-88.054,541.253,-101.176>,1.000 pigment {color C3} }
  cylinder { <-118.886,550.697,-71.092>,<-143.336,522.173,-47.997>,1.000 pigment {color C3} }
  cylinder { <-118.886,550.697,-71.092>,<-121.168,547.454,-74.533>,2.000 pigment {color C2} }
  cylinder { <-121.168,547.454,-74.533>,<-90.273,537.915,-104.522>,1.000 pigment {color C3} }
  cylinder { <-121.168,547.454,-74.533>,<-145.430,518.999,-51.155>,1.000 pigment {color C3} }
  cylinder { <-121.168,547.454,-74.533>,<-123.428,544.162,-77.941>,2.000 pigment {color C2} }
  cylinder { <-123.428,544.162,-77.941>,<-96.179,531.355,-109.198>,1.000 pigment {color C3} }
  cylinder { <-123.428,544.162,-77.941>,<-147.695,514.431,-57.674>,1.000 pigment {color C3} }
  cylinder { <-123.428,544.162,-77.941>,<-125.668,540.822,-81.317>,2.000 pigment {color C2} }
  cylinder { <-125.668,540.822,-81.317>,<-96.929,529.330,-111.740>,1.000 pigment {color C3} }
  cylinder { <-125.668,540.822,-81.317>,<-149.436,512.218,-58.947>,1.000 pigment {color C3} }
  cylinder { <-125.668,540.822,-81.317>,<-127.885,537.436,-84.660>,2.000 pigment {color C2} }
  cylinder { <-127.885,537.436,-84.660>,<-101.381,524.111,-115.372>,1.000 pigment {color C3} }
  cylinder { <-127.885,537.436,-84.660>,<-151.641,506.904,-66.584>,1.000 pigment {color C3} }
  cylinder { <-127.885,537.436,-84.660>,<-130.081,534.004,-87.971>,2.000 pigment {color C2} }
  cylinder { <-130.081,534.004,-87.971>,<-104.441,519.593,-118.926>,1.000 pigment {color C3} }
  cylinder { <-130.081,534.004,-87.971>,<-153.540,504.181,-68.386>,1.000 pigment {color C3} }
  cylinder { <-130.081,534.004,-87.971>,<-132.256,530.527,-91.249>,2.000 pigment {color C2} }
  cylinder { <-132.256,530.527,-91.249>,<-108.862,514.330,-122.142>,1.000 pigment {color C3} }
  cylinder { <-132.256,530.527,-91.249>,<-155.319,499.564,-74.715>,1.000 pigment {color C3} }
  cylinder { <-132.256,530.527,-91.249>,<-134.409,527.007,-94.494>,2.000 pigment {color C2} }
  cylinder { <-134.409,527.007,-94.494>,<-110.914,510.667,-125.235>,1.000 pigment {color C3} }
  cylinder { <-134.409,527.007,-94.494>,<-157.243,496.718,-76.462>,1.000 pigment {color C3} }
  cylinder { <-134.409,527.007,-94.494>,<-136.539,523.443,-97.707>,2.000 pigment {color C2} }
  cylinder { <-136.539,523.443,-97.707>,<-114.294,506.301,-127.989>,1.000 pigment {color C3} }
  cylinder { <-136.539,523.443,-97.707>,<-158.793,491.780,-83.286>,1.000 pigment {color C3} }
  cylinder { <-136.539,523.443,-97.707>,<-138.649,519.836,-100.886>,2.000 pigment {color C2} }
  cylinder { <-138.649,519.836,-100.886>,<-116.780,502.085,-131.092>,1.000 pigment {color C3} }
  cylinder { <-138.649,519.836,-100.886>,<-160.756,488.793,-84.972>,1.000 pigment {color C3} }
  cylinder { <-138.649,519.836,-100.886>,<-140.736,516.189,-104.033>,2.000 pigment {color C2} }
  cylinder { <-140.736,516.189,-104.033>,<-122.038,495.869,-133.797>,1.000 pigment {color C3} }
  cylinder { <-140.736,516.189,-104.033>,<-162.025,483.902,-91.675>,1.000 pigment {color C3} }
  cylinder { <-140.736,516.189,-104.033>,<-142.801,512.501,-107.147>,2.000 pigment {color C2} }
  cylinder { <-142.801,512.501,-107.147>,<-123.005,492.930,-136.701>,1.000 pigment {color C3} }
  cylinder { <-142.801,512.501,-107.147>,<-164.024,480.778,-93.305>,1.000 pigment {color C3} }
  cylinder { <-142.801,512.501,-107.147>,<-144.845,508.773,-110.228>,2.000 pigment {color C2} }
  cylinder { <-144.845,508.773,-110.228>,<-126.713,488.061,-139.111>,1.000 pigment {color C3} }
  cylinder { <-144.845,508.773,-110.228>,<-165.227,476.470,-98.691>,1.000 pigment {color C3} }
  cylinder { <-144.845,508.773,-110.228>,<-146.866,505.007,-113.275>,2.000 pigment {color C2} }
  cylinder { <-146.866,505.007,-113.275>,<-129.096,483.705,-141.954>,1.000 pigment {color C3} }
  cylinder { <-146.866,505.007,-113.275>,<-166.963,472.419,-102.043>,1.000 pigment {color C3} }
  cylinder { <-146.866,505.007,-113.275>,<-148.866,501.202,-116.290>,2.000 pigment {color C2} }
  cylinder { <-148.866,501.202,-116.290>,<-133.199,478.425,-144.082>,1.000 pigment {color C3} }
  cylinder { <-148.866,501.202,-116.290>,<-168.086,468.406,-106.714>,1.000 pigment {color C3} }
  cylinder { <-148.866,501.202,-116.290>,<-150.844,497.360,-119.272>,2.000 pigment {color C2} }
  cylinder { <-150.844,497.360,-119.272>,<-136.011,473.602,-146.698>,1.000 pigment {color C3} }
  cylinder { <-150.844,497.360,-119.272>,<-169.745,464.295,-109.994>,1.000 pigment {color C3} }
  cylinder { <-150.844,497.360,-119.272>,<-152.800,493.482,-122.221>,2.000 pigment {color C2} }
  cylinder { <-152.800,493.482,-122.221>,<-139.529,468.805,-148.625>,1.000 pigment {color C3} }
  cylinder { <-152.800,493.482,-122.221>,<-170.405,459.873,-115.683>,1.000 pigment {color C3} }
  cylinder { <-152.800,493.482,-122.221>,<-154.734,489.568,-125.137>,2.000 pigment {color C2} }
  cylinder { <-154.734,489.568,-125.137>,<-141.325,464.744,-151.332>,1.000 pigment {color C3} }
  cylinder { <-154.734,489.568,-125.137>,<-172.152,455.918,-118.316>,1.000 pigment {color C3} }
  cylinder { <-154.734,489.568,-125.137>,<-156.647,485.620,-128.020>,2.000 pigment {color C2} }
  cylinder { <-156.647,485.620,-128.020>,<-145.220,459.596,-152.941>,1.000 pigment {color C3} }
  cylinder { <-156.647,485.620,-128.020>,<-172.808,451.779,-123.282>,1.000 pigment {color C3} }
  cylinder { <-156.647,485.620,-128.020>,<-158.538,481.637,-130.871>,2.000 pigment {color C2} }
  cylinder { <-158.538,481.637,-130.871>,<-146.969,455.472,-155.577>,1.000 pigment {color C3} }
  cylinder { <-158.538,481.637,-130.871>,<-174.514,447.749,-125.853>,1.000 pigment {color C3} }
  cylinder { <-158.538,481.637,-130.871>,<-160.407,477.622,-133.689>,2.000 pigment {color C2} }
  cylinder { <-160.407,477.622,-133.689>,<-150.752,450.401,-156.975>,1.000 pigment {color C3} }
  cylinder { <-160.407,477.622,-133.689>,<-175.041,443.664,-130.671>,1.000 pigment {color C3} }
  cylinder { <-160.407,477.622,-133.689>,<-162.255,473.573,-136.475>,2.000 pigment {color C2} }
  cylinder { <-162.255,473.573,-136.475>,<-152.913,445.881,-159.328>,1.000 pigment {color C3} }
  cylinder { <-162.255,473.573,-136.475>,<-176.707,439.563,-133.183>,1.000 pigment {color C3} }
  cylinder { <-162.255,473.573,-136.475>,<-164.081,469.493,-139.228>,2.000 pigment {color C2} }
  cylinder { <-164.081,469.493,-139.228>,<-156.120,441.236,-160.748>,1.000 pigment {color C3} }
  cylinder { <-164.081,469.493,-139.228>,<-177.119,435.537,-137.848>,1.000 pigment {color C3} }
  cylinder { <-164.081,469.493,-139.228>,<-165.886,465.382,-141.949>,2.000 pigment {color C2} }
  cylinder { <-165.886,465.382,-141.949>,<-158.225,436.691,-162.998>,1.000 pigment {color C3} }
  cylinder { <-165.886,465.382,-141.949>,<-179.244,431.630,-139.248>,1.000 pigment {color C3} }
  cylinder { <-165.886,465.382,-141.949>,<-167.670,461.241,-144.638>,2.000 pigment {color C2} }
  cylinder { <-167.670,461.241,-144.638>,<-160.886,432.396,-164.549>,1.000 pigment {color C3} }
  cylinder { <-167.670,461.241,-144.638>,<-179.058,427.407,-144.811>,1.000 pigment {color C3} }
  cylinder { <-167.670,461.241,-144.638>,<-169.432,457.070,-147.295>,2.000 pigment {color C2} }
  cylinder { <-169.432,457.070,-147.295>,<-162.065,428.398,-167.248>,1.000 pigment {color C3} }
  cylinder { <-169.432,457.070,-147.295>,<-180.369,423.090,-147.715>,1.000 pigment {color C3} }
  cylinder { <-169.432,457.070,-147.295>,<-171.173,452.871,-149.921>,2.000 pigment {color C2} }
  cylinder { <-171.173,452.871,-149.921>,<-165.934,423.298,-167.892>,1.000 pigment {color C3} }
  cylinder { <-171.173,452.871,-149.921>,<-181.164,419.346,-151.067>,1.000 pigment {color C3} }
  cylinder { <-171.173,452.871,-149.921>,<-172.894,448.643,-152.514>,2.000 pigment {color C2} }
  cylinder { <-172.894,448.643,-152.514>,<-168.349,418.470,-169.659>,1.000 pigment {color C3} }
  cylinder { <-172.894,448.643,-152.514>,<-182.718,415.061,-153.409>,1.000 pigment {color C3} }
  cylinder { <-172.894,448.643,-152.514>,<-174.594,444.387,-155.077>,2.000 pigment {color C2} }
  cylinder { <-174.594,444.387,-155.077>,<-176.272,440.105,-157.608>,2.000 pigment {color C2} }
  sphere { <-72.421,535.388,1.251>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-72.119,600.887,-5.134>,2.000 pigment {color C2} }
  cylinder { <-72.119,600.887,-5.134>,<-23.021,603.151,2.242>,1.000 pigment {color C3} }
  cylinder { <-72.119,600.887,-5.134>,<-107.357,571.593,14.107>,1.000 pigment {color C3} }
  cylinder { <-72.119,600.887,-5.134>,<-72.507,599.790,-10.254>,2.000 pigment {color C2} }
  cylinder { <-72.507,599.790,-10.254>,<-23.189,602.011,-4.513>,1.000 pigment {color C3} }
  cylinder { <-72.507,599.790,-10.254>,<-107.230,571.209,10.901>,1.000 pigment {color C3} }
  cylinder { <-72.507,599.790,-10.254>,<-72.894,598.617,-15.357>,2.000 pigment {color C2} }
  cylinder { <-72.894,598.617,-15.357>,<-24.041,600.566,-12.099>,1.000 pigment {color C3} }
  cylinder { <-72.894,598.617,-15.357>,<-108.373,569.312,1.478>,1.000 pigment {color C3} }
  cylinder { <-72.894,598.617,-15.357>,<-73.280,597.370,-20.442>,2.000 pigment {color C2} }
  cylinder { <-73.280,597.370,-20.442>,<-24.377,599.272,-18.001>,1.000 pigment {color C3} }
  cylinder { <-73.280,597.370,-20.442>,<-108.726,568.274,-3.181>,1.000 pigment {color C3} }
  cylinder { <-73.280,597.370,-20.442>,<-73.664,596.049,-25.508>,2.000 pigment {color C2} }
  cylinder { <-73.664,596.049,-25.508>,<-25.386,597.331,-26.223>,1.000 pigment {color C3} }
  cylinder { <-73.664,596.049,-25.508>,<-109.033,566.881,-10.303>,1.000 pigment {color C3} }
  cylinder { <-73.664,596.049,-25.508>,<-74.047,594.654,-30.555>,2.000 pigment {color C2} }
  cylinder { <-74.047,594.654,-30.555>,<-25.770,596.167,-30.520>,1.000 pigment {color C3} }
  cylinder { <-74.047,594.654,-30.555>,<-109.243,565.911,-14.187>,1.000 pigment {color C3} }
  cylinder { <-74.047,594.654,-30.555>,<-74.428,593.186,-35.581>,2.000 pigment {color C2} }
  cylinder { <-74.428,593.186,-35.581>,<-26.890,594.125,-37.830>,1.000 pigment {color C3} }
  cylinder { <-74.428,593.186,-35.581>,<-109.460,564.329,-21.237>,1.000 pigment {color C3} }
  cylinder { <-74.428,593.186,-35.581>,<-74.807,591.646,-40.586>,2.000 pigment {color C2} }
  cylinder { <-74.807,591.646,-40.586>,<-27.246,592.821,-42.099>,1.000 pigment {color C3} }
  cylinder { <-74.807,591.646,-40.586>,<-109.909,562.715,-26.563>,1.000 pigment {color C3} }
  cylinder { <-74.807,591.646,-40.586>,<-75.185,590.033,-45.568>,2.000 pigment {color C2} }
  cylinder { <-75.185,590.033,-45.568>,<-28.570,590.052,-50.730>,1.000 pigment {color C3} }
  cylinder { <-75.185,590.033,-45.568>,<-110.048,560.499,-34.987>,1.000 pigment {color C3} }
  cylinder { <-75.185,590.033,-45.568>,<-75.561,588.350,-50.526>,2.000 pigment {color C2} }
  cylinder { <-75.561,588.350,-50.526>,<-28.946,588.345,-55.689>,1.000 pigment {color C3} }
  cylinder { <-75.561,588.350,-50.526>,<-110.416,558.697,-40.258>,1.000 pigment {color C3} }
  cylinder { <-75.561,588.350,-50.526>,<-75.936,586.596,-55.460>,2.000 pigment {color C2} }
  cylinder { <-75.936,586.596,-55.460>,<-30.306,585.765,-62.652>,1.000 pigment {color C3} }
  cylinder { <-75.936,586.596,-55.460>,<-110.235,556.797,-47.095>,1.000 pigment {color C3} }
  cylinder { <-75.936,586.596,-55.460>,<-76.308,584.773,-60.369>,2.000 pigment {color C2} }
  cylinder { <-76.308,584.773,-60.369>,<-30.931,583.313,-68.927>,1.000 pigment {color C3} }
  cylinder { <-76.308,584.773,-60.369>,<-110.576,555.058,-51.585>,1.000 pigment {color C3} }
  cylinder { <-76.308,584.773,-60.369>,<-76.678,582.880,-65.252>,2.000 pigment {color C2} }
  cylinder { <-76.678,582.880,-65.252>,<-32.815,579.843,-76.960>,1.000 pigment {color C3} }
  cylinder { <-76.678,582.880,-65.252>,<-110.221,552.775,-59.022>,1.000 pigment {color C3} }
  cylinder { <-76.678,582.880,-65.252>,<-77.047,580.919,-70.108>,2.000 pigment {color C2} }
  cylinder { <-77.047,580.919,-70.108>,<-32.815,578.406,-80.475>,1.000 pigment {color C3} }
  cylinder { <-77.047,580.919,-70.108>,<-110.557,550.868,-63.458>,1.000 pigment {color C3} }
  cylinder { <-77.047,580.919,-70.108>,<-77.413,578.890,-74.937>,2.000 pigment {color C2} }
  cylinder { <-77.413,578.890,-74.937>,<-34.842,574.676,-88.242>,1.000 pigment {color C3} }
  cylinder { <-77.413,578.890,-74.937>,<-110.219,548.895,-69.363>,1.000 pigment {color C3} }
  cylinder { <-77.413,578.890,-74.937>,<-77.777,576.795,-79.737>,2.000 pigment {color C2} }
  cylinder { <-77.777,576.795,-79.737>,<-35.202,572.442,-92.983>,1.000 pigment {color C3} }
  cylinder { <-77.777,576.795,-79.737>,<-110.346,546.380,-75.128>,1.000 pigment {color C3} }
  cylinder { <-77.777,576.795,-79.737>,<-78.139,574.634,-84.507>,2.000 pigment {color C2} }
  cylinder { <-78.139,574.634,-84.507>,<-36.688,569.514,-98.665>,1.000 pigment {color C3} }
  cylinder { <-78.139,574.634,-84.507>,<-109.460,543.628,-82.932>,1.000 pigment {color C3} }
  cylinder { <-78.139,574.634,-84.507>,<-78.498,572.407,-89.248>,2.000 pigment {color C2} }
  cylinder { <-78.498,572.407,-89.248>,<-37.818,566.045,-105.041>,1.000 pigment {color C3} }
  cylinder { <-78.498,572.407,-89.248>,<-109.952,541.611,-86.580>,1.000 pigment {color C3} }
  cylinder { <-78.498,572.407,-89.248>,<-78.856,570.116,-93.958>,2.000 pigment {color C2} }
  cylinder { <-78.856,570.116,-93.958>,<-39.375,562.944,-110.493>,1.000 pigment {color C3} }
  cylinder { <-78.856,570.116,-93.958>,<-109.064,538.957,-93.541>,1.000 pigment {color C3} }
  cylinder { <-78.856,570.116,-93.958>,<-79.210,567.762,-98.637>,2.000 pigment {color C2} }
  cylinder { <-79.210,567.762,-98.637>,<-39.437,560.788,-114.544>,1.000 pigment {color C3} }
  cylinder { <-79.210,567.762,-98.637>,<-109.582,536.795,-97.150>,1.000 pigment {color C3} }
  cylinder { <-79.210,567.762,-98.637>,<-79.563,565.344,-103.285>,2.000 pigment {color C2} }
  cylinder { <-79.563,565.344,-103.285>,<-41.605,556.785,-120.869>,1.000 pigment {color C3} }
  cylinder { <-79.563,565.344,-103.285>,<-108.344,533.828,-104.580>,1.000 pigment {color C3} }
  cylinder { <-79.563,565.344,-103.285>,<-79.913,562.865,-107.899>,2.000 pigment {color C2} }
  cylinder { <-79.913,562.865,-107.899>,<-42.595,553.326,-126.329>,1.000 pigment {color C3} }
  cylinder { <-79.913,562.865,-107.899>,<-108.662,531.306,-108.776>,1.000 pigment {color C3} }
  cylinder { <-79.913,562.865,-107.899>,<-80.260,560.325,-112.481>,2.000 pigment {color C2} }
  cylinder { <-80.260,560.325,-112.481>,<-45.304,548.768,-132.691>,1.000 pigment {color C3} }
  cylinder { <-80.260,560.325,-112.481>,<-108.013,528.845,-114.155>,1.000 pigment {color C3} }
  cylinder { <-80.260,560.325,-112.481>,<-80.605,557.725,-117.028>,2.000 pigment {color C2} }
  cylinder { <-80.605,557.725,-117.028>,<-45.637,545.939,-137.086>,1.000 pigment {color C3} }
  cylinder { <-80.605,557.725,-117.028>,<-107.509,525.619,-120.098>,1.000 pigment {color C3} }
  cylinder { <-80.605,557.725,-117.028>,<-80.948,555.066,-121.542>,2.000 pigment {color C2} }
  cylinder { <-80.948,555.066,-121.542>,<-47.692,542.056,-142.291>,1.000 pigment {color C3} }
  cylinder { <-80.948,555.066,-121.542>,<-106.787,523.069,-125.316>,1.000 pigment {color C3} }
  cylinder { <-80.948,555.066,-121.542>,<-81.287,552.348,-126.021>,2.000 pigment {color C2} }
  cylinder { <-81.287,552.348,-126.021>,<-48.416,538.700,-146.971>,1.000 pigment {color C3} }
  cylinder { <-81.287,552.348,-126.021>,<-107.095,520.280,-129.382>,1.000 pigment {color C3} }
  cylinder { <-81.287,552.348,-126.021>,<-81.625,549.573,-130.465>,2.000 pigment {color C2} }
  cylinder { <-81.625,549.573,-130.465>,<-50.102,535.123,-151.582>,1.000 pigment {color C3} }
  cylinder { <-81.625,549.573,-130.465>,<-105.700,517.288,-135.603>,1.000 pigment {color C3} }
  cylinder { <-81.625,549.573,-130.465>,<-81.959,546.742,-134.873>,2.000 pigment {color C2} }
  cylinder { <-81.959,546.742,-134.873>,<-50.017,532.460,-155.467>,1.000 pigment {color C3} }
  cylinder { <-81.959,546.742,-134.873>,<-106.333,514.542,-139.048>,1.000 pigment {color C3} }
  cylinder { <-81.959,546.742,-134.873>,<-82.291,543.854,-139.246>,2.000 pigment {color C2} }
  cylinder { <-82.291,543.854,-139.246>,<-53.392,527.199,-161.143>,1.000 pigment {color C3} }
  cylinder { <-82.291,543.854,-139.246>,<-104.865,511.478,-145.093>,1.000 pigment {color C3} }
  cylinder { <-82.291,543.854,-139.246>,<-82.619,540.912,-143.581>,2.000 pigment {color C2} }
  cylinder { <-82.619,540.912,-143.581>,<-53.705,524.013,-165.270>,1.000 pigment {color C3} }
  cylinder { <-82.619,540.912,-143.581>,<-104.437,508.141,-150.069>,1.000 pigment {color C3} }
  cylinder { <-82.619,540.912,-143.581>,<-82.945,537.917,-147.880>,2.000 pigment {color C2} }
  cylinder { <-82.945,537.917,-147.880>,<-55.849,519.901,-169.741>,1.000 pigment {color C3} }
  cylinder { <-82.945,537.917,-147.880>,<-102.825,505.086,-155.854>,1.000 pigment {color C3} }
  cylinder { <-82.945,537.917,-147.880>,<-83.269,534.868,-152.142>,2.000 pigment {color C2} }
  cylinder { <-83.269,534.868,-152.142>,<-56.611,516.220,-174.011>,1.000 pigment {color C3} }
  cylinder { <-83.269,534.868,-152.142>,<-103.118,501.923,-159.712>,1.000 pigment {color C3} }
  cylinder { <-83.269,534.868,-152.142>,<-83.589,531.768,-156.367>,2.000 pigment {color C2} }
  cylinder { <-83.589,531.768,-156.367>,<-59.717,511.323,-178.602>,1.000 pigment {color C3} }
  cylinder { <-83.589,531.768,-156.367>,<-101.851,498.947,-164.825>,1.000 pigment {color C3} }
  cylinder { <-83.589,531.768,-156.367>,<-83.907,528.616,-160.554>,2.000 pigment {color C2} }
  cylinder { <-83.907,528.616,-160.554>,<-58.602,509.062,-181.991>,1.000 pigment {color C3} }
  cylinder { <-83.907,528.616,-160.554>,<-102.547,495.796,-168.148>,1.000 pigment {color C3} }
  cylinder { <-83.907,528.616,-160.554>,<-84.221,525.414,-164.702>,2.000 pigment {color C2} }
  cylinder { <-84.221,525.414,-164.702>,<-62.183,503.773,-186.493>,1.000 pigment {color C3} }
  cylinder { <-84.221,525.414,-164.702>,<-100.847,492.647,-173.574>,1.000 pigment {color C3} }
  cylinder { <-84.221,525.414,-164.702>,<-84.533,522.163,-168.813>,2.000 pigment {color C2} }
  cylinder { <-84.533,522.163,-168.813>,<-62.475,500.285,-190.345>,1.000 pigment {color C3} }
  cylinder { <-84.533,522.163,-168.813>,<-100.266,489.090,-178.165>,1.000 pigment {color C3} }
  cylinder { <-84.533,522.163,-168.813>,<-84.842,518.864,-172.885>,2.000 pigment {color C2} }
  cylinder { <-84.842,518.864,-172.885>,<-64.138,496.459,-193.999>,1.000 pigment {color C3} }
  cylinder { <-84.842,518.864,-172.885>,<-98.486,485.982,-183.326>,1.000 pigment {color C3} }
  cylinder { <-84.842,518.864,-172.885>,<-85.148,515.517,-176.918>,2.000 pigment {color C2} }
  cylinder { <-85.148,515.517,-176.918>,<-65.905,491.856,-198.044>,1.000 pigment {color C3} }
  cylinder { <-85.148,515.517,-176.918>,<-98.763,482.504,-186.976>,1.000 pigment {color C3} }
  cylinder { <-85.148,515.517,-176.918>,<-85.451,512.124,-180.913>,2.000 pigment {color C2} }
  cylinder { <-85.451,512.124,-180.913>,<-67.044,488.359,-201.440>,1.000 pigment {color C3} }
  cylinder { <-85.451,512.124,-180.913>,<-97.879,479.488,-191.179>,1.000 pigment {color C3} }
  cylinder { <-85.451,512.124,-180.913>,<-85.751,508.685,-184.869>,2.000 pigment {color C2} }
  cylinder { <-85.751,508.685,-184.869>,<-68.320,484.055,-205.228>,1.000 pigment {color C3} }
  cylinder { <-85.751,508.685,-184.869>,<-96.758,475.783,-195.879>,1.000 pigment {color C3} }
  cylinder { <-85.751,508.685,-184.869>,<-86.048,505.202,-188.785>,2.000 pigment {color C2} }
  cylinder { <-86.048,505.202,-188.785>,<-70.930,479.620,-208.572>,1.000 pigment {color C3} }
  cylinder { <-86.048,505.202,-188.785>,<-94.929,472.706,-200.602>,1.000 pigment {color C3} }
  cylinder { <-86.048,505.202,-188.785>,<-86.342,501.674,-192.662>,2.000 pigment {color C2} }
  cylinder { <-86.342,501.674,-192.662>,<-71.710,475.593,-212.161>,1.000 pigment {color C3} }
  cylinder { <-86.342,501.674,-192.662>,<-96.148,469.081,-203.435>,1.000 pigment {color C3} }
  cylinder { <-86.342,501.674,-192.662>,<-86.633,498.104,-196.500>,2.000 pigment {color C2} }
  cylinder { <-86.633,498.104,-196.500>,<-72.767,472.055,-215.321>,1.000 pigment {color C3} }
  cylinder { <-86.633,498.104,-196.500>,<-93.371,465.975,-208.638>,1.000 pigment {color C3} }
  cylinder { <-86.633,498.104,-196.500>,<-86.921,494.491,-200.299>,2.000 pigment {color C2} }
  cylinder { <-86.921,494.491,-200.299>,<-73.536,467.973,-218.810>,1.000 pigment {color C3} }
  cylinder { <-86.921,494.491,-200.299>,<-95.075,462.228,-211.143>,1.000 pigment {color C3} }
  cylinder { <-86.921,494.491,-200.299>,<-87.206,490.837,-204.058>,2.000 pigment {color C2} }
  cylinder { <-87.206,490.837,-204.058>,<-87.488,487.143,-207.777>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-70.354,601.835,5.066>,2.000 pigment {color C2} }
  cylinder { <-70.354,601.835,5.066>,<-108.068,570.710,8.213>,1.000 pigment {color C3} }
  cylinder { <-70.354,601.835,5.066>,<-25.797,601.544,-15.319>,1.000 pigment {color C3} }
  cylinder { <-70.354,601.835,5.066>,<-68.979,601.683,10.130>,2.000 pigment {color C2} }
  cylinder { <-68.979,601.683,10.130>,<-107.002,570.795,11.237>,1.000 pigment {color C3} }
  cylinder { <-68.979,601.683,10.130>,<-24.423,601.512,-10.258>,1.000 pigment {color C3} }
  cylinder { <-68.979,601.683,10.130>,<-67.605,601.453,15.192>,2.000 pigment {color C2} }
  cylinder { <-67.605,601.453,15.192>,<-104.498,570.738,20.524>,1.000 pigment {color C3} }
  cylinder { <-67.605,601.453,15.192>,<-22.187,601.405,-1.241>,1.000 pigment {color C3} }
  cylinder { <-67.605,601.453,15.192>,<-66.232,601.144,20.250>,2.000 pigment {color C2} }
  cylinder { <-66.232,601.144,20.250>,<-103.245,570.500,25.138>,1.000 pigment {color C3} }
  cylinder { <-66.232,601.144,20.250>,<-21.677,601.203,1.602>,1.000 pigment {color C3} }
  cylinder { <-66.232,601.144,20.250>,<-64.860,600.756,25.303>,2.000 pigment {color C2} }
  cylinder { <-64.860,600.756,25.303>,<-100.740,570.366,32.711>,1.000 pigment {color C3} }
  cylinder { <-64.860,600.756,25.303>,<-19.136,600.651,12.071>,1.000 pigment {color C3} }
  cylinder { <-64.860,600.756,25.303>,<-63.490,600.290,30.349>,2.000 pigment {color C2} }
  cylinder { <-63.490,600.290,30.349>,<-99.686,570.009,36.568>,1.000 pigment {color C3} }
  cylinder { <-63.490,600.290,30.349>,<-17.767,600.197,17.116>,1.000 pigment {color C3} }
  cylinder { <-63.490,600.290,30.349>,<-62.122,599.746,35.389>,2.000 pigment {color C2} }
  cylinder { <-62.122,599.746,35.389>,<-97.502,569.806,42.562>,1.000 pigment {color C3} }
  cylinder { <-62.122,599.746,35.389>,<-16.865,599.588,23.086>,1.000 pigment {color C3} }
  cylinder { <-62.122,599.746,35.389>,<-60.757,599.125,40.420>,2.000 pigment {color C2} }
  cylinder { <-60.757,599.125,40.420>,<-96.035,569.138,47.895>,1.000 pigment {color C3} }
  cylinder { <-60.757,599.125,40.420>,<-15.124,598.776,29.594>,1.000 pigment {color C3} }
  cylinder { <-60.757,599.125,40.420>,<-59.394,598.425,45.441>,2.000 pigment {color C2} }
  cylinder { <-59.394,598.425,45.441>,<-93.281,568.587,55.229>,1.000 pigment {color C3} }
  cylinder { <-59.394,598.425,45.441>,<-14.124,597.831,36.236>,1.000 pigment {color C3} }
  cylinder { <-59.394,598.425,45.441>,<-58.033,597.649,50.452>,2.000 pigment {color C2} }
  cylinder { <-58.033,597.649,50.452>,<-92.037,567.806,59.812>,1.000 pigment {color C3} }
  cylinder { <-58.033,597.649,50.452>,<-12.625,596.879,41.970>,1.000 pigment {color C3} }
  cylinder { <-58.033,597.649,50.452>,<-56.676,596.795,55.451>,2.000 pigment {color C2} }
  cylinder { <-56.676,596.795,55.451>,<-88.490,566.921,68.322>,1.000 pigment {color C3} }
  cylinder { <-56.676,596.795,55.451>,<-11.529,595.380,49.978>,1.000 pigment {color C3} }
  cylinder { <-56.676,596.795,55.451>,<-55.323,595.865,60.438>,2.000 pigment {color C2} }
  cylinder { <-55.323,595.865,60.438>,<-87.253,565.934,72.882>,1.000 pigment {color C3} }
  cylinder { <-55.323,595.865,60.438>,<-10.041,594.006,56.388>,1.000 pigment {color C3} }
  cylinder { <-55.323,595.865,60.438>,<-53.973,594.859,65.410>,2.000 pigment {color C2} }
  cylinder { <-53.973,594.859,65.410>,<-85.194,565.254,77.893>,1.000 pigment {color C3} }
  cylinder { <-53.973,594.859,65.410>,<-9.346,592.726,62.105>,1.000 pigment {color C3} }
  cylinder { <-53.973,594.859,65.410>,<-52.627,593.777,70.368>,2.000 pigment {color C2} }
  cylinder { <-52.627,593.777,70.368>,<-83.963,564.118,82.430>,1.000 pigment {color C3} }
  cylinder { <-52.627,593.777,70.368>,<-7.972,591.319,67.738>,1.000 pigment {color C3} }
  cylinder { <-52.627,593.777,70.368>,<-51.285,592.619,75.310>,2.000 pigment {color C2} }
  cylinder { <-51.285,592.619,75.310>,<-80.835,563.009,89.269>,1.000 pigment {color C3} }
  cylinder { <-51.285,592.619,75.310>,<-7.381,588.753,76.819>,1.000 pigment {color C3} }
  cylinder { <-51.285,592.619,75.310>,<-49.948,591.387,80.235>,2.000 pigment {color C2} }
  cylinder { <-49.948,591.387,80.235>,<-79.612,561.696,93.775>,1.000 pigment {color C3} }
  cylinder { <-49.948,591.387,80.235>,<-5.994,587.802,80.322>,1.000 pigment {color C3} }
  cylinder { <-49.948,591.387,80.235>,<-48.616,590.081,85.143>,2.000 pigment {color C2} }
  cylinder { <-48.616,590.081,85.143>,<-76.376,560.423,100.419>,1.000 pigment {color C3} }
  cylinder { <-48.616,590.081,85.143>,<-5.553,585.413,87.846>,1.000 pigment {color C3} }
  cylinder { <-48.616,590.081,85.143>,<-47.289,588.701,90.031>,2.000 pigment {color C2} }
  cylinder { <-47.289,588.701,90.031>,<-74.752,558.848,105.465>,1.000 pigment {color C3} }
  cylinder { <-47.289,588.701,90.031>,<-4.407,583.310,93.982>,1.000 pigment {color C3} }
  cylinder { <-47.289,588.701,90.031>,<-45.968,587.247,94.900>,2.000 pigment {color C2} }
  cylinder { <-45.968,587.247,94.900>,<-70.943,557.361,112.401>,1.000 pigment {color C3} }
  cylinder { <-45.968,587.247,94.900>,<-4.007,581.190,99.987>,1.000 pigment {color C3} }
  cylinder { <-45.968,587.247,94.900>,<-44.652,585.721,99.748>,2.000 pigment {color C2} }
  cylinder { <-44.652,585.721,99.748>,<-69.283,555.613,117.357>,1.000 pigment {color C3} }
  cylinder { <-44.652,585.721,99.748>,<-2.837,579.154,105.378>,1.000 pigment {color C3} }
  cylinder { <-44.652,585.721,99.748>,<-43.341,584.124,104.574>,2.000 pigment {color C2} }
  cylinder { <-43.341,584.124,104.574>,<-66.280,554.144,122.987>,1.000 pigment {color C3} }
  cylinder { <-43.341,584.124,104.574>,<-2.839,576.276,112.447>,1.000 pigment {color C3} }
  cylinder { <-43.341,584.124,104.574>,<-42.037,582.455,109.378>,2.000 pigment {color C2} }
  cylinder { <-42.037,582.455,109.378>,<-65.089,552.310,127.377>,1.000 pigment {color C3} }
  cylinder { <-42.037,582.455,109.378>,<-1.565,574.347,117.141>,1.000 pigment {color C3} }
  cylinder { <-42.037,582.455,109.378>,<-40.740,580.715,114.158>,2.000 pigment {color C2} }
  cylinder { <-40.740,580.715,114.158>,<-61.573,550.636,133.314>,1.000 pigment {color C3} }
  cylinder { <-40.740,580.715,114.158>,<-1.339,571.883,122.834>,1.000 pigment {color C3} }
  cylinder { <-40.740,580.715,114.158>,<-39.449,578.905,118.914>,2.000 pigment {color C2} }
  cylinder { <-39.449,578.905,118.914>,<-59.889,548.580,138.105>,1.000 pigment {color C3} }
  cylinder { <-39.449,578.905,118.914>,<-.0818,569.809,127.468>,1.000 pigment {color C3} }
  cylinder { <-39.449,578.905,118.914>,<-38.164,577.026,123.645>,2.000 pigment {color C2} }
  cylinder { <-38.164,577.026,123.645>,<-56.315,546.804,143.783>,1.000 pigment {color C3} }
  cylinder { <-38.164,577.026,123.645>,<-.850,565.933,135.175>,1.000 pigment {color C3} }
  cylinder { <-38.164,577.026,123.645>,<-36.887,575.079,128.350>,2.000 pigment {color C2} }
  cylinder { <-36.887,575.079,128.350>,<-56.699,544.842,146.833>,1.000 pigment {color C3} }
  cylinder { <-36.887,575.079,128.350>,<.385,563.694,139.729>,1.000 pigment {color C3} }
  cylinder { <-36.887,575.079,128.350>,<-35.617,573.064,133.029>,2.000 pigment {color C2} }
  cylinder { <-35.617,573.064,133.029>,<-52.625,542.861,152.790>,1.000 pigment {color C3} }
  cylinder { <-35.617,573.064,133.029>,<.441,560.944,145.065>,1.000 pigment {color C3} }
  cylinder { <-35.617,573.064,133.029>,<-34.355,570.982,137.680>,2.000 pigment {color C2} }
  cylinder { <-34.355,570.982,137.680>,<-50.940,540.525,157.412>,1.000 pigment {color C3} }
  cylinder { <-34.355,570.982,137.680>,<1.378,558.242,150.042>,1.000 pigment {color C3} }
  cylinder { <-34.355,570.982,137.680>,<-33.100,568.834,142.303>,2.000 pigment {color C2} }
  cylinder { <-33.100,568.834,142.303>,<-46.799,538.503,163.015>,1.000 pigment {color C3} }
  cylinder { <-33.100,568.834,142.303>,<1.070,555.046,155.679>,1.000 pigment {color C3} }
  cylinder { <-33.100,568.834,142.303>,<-31.852,566.620,146.898>,2.000 pigment {color C2} }
  cylinder { <-31.852,566.620,146.898>,<-45.661,536.067,167.207>,1.000 pigment {color C3} }
  cylinder { <-31.852,566.620,146.898>,<2.267,552.535,160.089>,1.000 pigment {color C3} }
  cylinder { <-31.852,566.620,146.898>,<-30.613,564.342,151.462>,2.000 pigment {color C2} }
  cylinder { <-30.613,564.342,151.462>,<-43.185,534.056,171.635>,1.000 pigment {color C3} }
  cylinder { <-30.613,564.342,151.462>,<1.193,548.578,166.364>,1.000 pigment {color C3} }
  cylinder { <-30.613,564.342,151.462>,<-29.382,562.000,155.997>,2.000 pigment {color C2} }
  cylinder { <-29.382,562.000,155.997>,<-40.946,531.441,176.361>,1.000 pigment {color C3} }
  cylinder { <-29.382,562.000,155.997>,<2.718,546.261,170.282>,1.000 pigment {color C3} }
  cylinder { <-29.382,562.000,155.997>,<-28.160,559.596,160.501>,2.000 pigment {color C2} }
  cylinder { <-28.160,559.596,160.501>,<-38.506,529.332,180.649>,1.000 pigment {color C3} }
  cylinder { <-28.160,559.596,160.501>,<1.871,542.550,175.875>,1.000 pigment {color C3} }
  cylinder { <-28.160,559.596,160.501>,<-26.946,557.129,164.974>,2.000 pigment {color C2} }
  cylinder { <-26.946,557.129,164.974>,<-37.956,526.669,184.462>,1.000 pigment {color C3} }
  cylinder { <-26.946,557.129,164.974>,<2.646,539.457,180.493>,1.000 pigment {color C3} }
  cylinder { <-26.946,557.129,164.974>,<-25.740,554.601,169.414>,2.000 pigment {color C2} }
  cylinder { <-25.740,554.601,169.414>,<-33.872,524.416,189.393>,1.000 pigment {color C3} }
  cylinder { <-25.740,554.601,169.414>,<1.668,535.699,185.781>,1.000 pigment {color C3} }
  cylinder { <-25.740,554.601,169.414>,<-24.543,552.013,173.822>,2.000 pigment {color C2} }
  cylinder { <-24.543,552.013,173.822>,<-31.644,521.604,193.854>,1.000 pigment {color C3} }
  cylinder { <-24.543,552.013,173.822>,<2.385,532.498,190.266>,1.000 pigment {color C3} }
  cylinder { <-24.543,552.013,173.822>,<-23.356,549.366,178.198>,2.000 pigment {color C2} }
  cylinder { <-23.356,549.366,178.198>,<-29.864,519.313,197.677>,1.000 pigment {color C3} }
  cylinder { <-23.356,549.366,178.198>,<.856,528.426,195.524>,1.000 pigment {color C3} }
  cylinder { <-23.356,549.366,178.198>,<-22.177,546.660,182.539>,2.000 pigment {color C2} }
  cylinder { <-22.177,546.660,182.539>,<-27.656,516.405,202.023>,1.000 pigment {color C3} }
  cylinder { <-22.177,546.660,182.539>,<3.273,526.320,198.773>,1.000 pigment {color C3} }
  cylinder { <-22.177,546.660,182.539>,<-21.008,543.896,186.847>,2.000 pigment {color C2} }
  cylinder { <-21.008,543.896,186.847>,<-24.800,514.065,206.089>,1.000 pigment {color C3} }
  cylinder { <-21.008,543.896,186.847>,<1.708,522.209,203.821>,1.000 pigment {color C3} }
  cylinder { <-21.008,543.896,186.847>,<-19.848,541.076,191.121>,2.000 pigment {color C2} }
  cylinder { <-19.848,541.076,191.121>,<-24.303,511.002,209.834>,1.000 pigment {color C3} }
  cylinder { <-19.848,541.076,191.121>,<1.878,518.544,208.289>,1.000 pigment {color C3} }
  cylinder { <-19.848,541.076,191.121>,<-18.697,538.200,195.359>,2.000 pigment {color C2} }
  cylinder { <-18.697,538.200,195.359>,<-19.266,508.761,214.281>,1.000 pigment {color C3} }
  cylinder { <-18.697,538.200,195.359>,<1.134,515.035,212.537>,1.000 pigment {color C3} }
  cylinder { <-18.697,538.200,195.359>,<-17.556,535.269,199.563>,2.000 pigment {color C2} }
  cylinder { <-17.556,535.269,199.563>,<-18.222,505.605,218.127>,1.000 pigment {color C3} }
  cylinder { <-17.556,535.269,199.563>,<1.722,511.574,216.647>,1.000 pigment {color C3} }
  cylinder { <-17.556,535.269,199.563>,<-16.425,532.284,203.731>,2.000 pigment {color C2} }
  cylinder { <-16.425,532.284,203.731>,<-15.303,529.246,207.863>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-75.706,600.133,2.931>,2.000 pigment {color C2} }
  cylinder { <-75.706,600.133,2.931>,<-89.970,577.434,-37.245>,1.000 pigment {color C3} }
  cylinder { <-75.706,600.133,2.931>,<-42.585,595.091,37.723>,1.000 pigment {color C3} }
  cylinder { <-75.706,600.133,2.931>,<-79.662,598.289,5.848>,2.000 pigment {color C2} }
  cylinder { <-79.662,598.289,5.848>,<-93.669,575.766,-34.518>,1.000 pigment {color C3} }
  cylinder { <-79.662,598.289,5.848>,<-46.485,593.332,40.598>,1.000 pigment {color C3} }
  cylinder { <-79.662,598.289,5.848>,<-83.598,596.375,8.749>,2.000 pigment {color C2} }
  cylinder { <-83.598,596.375,8.749>,<-98.375,573.768,-30.446>,1.000 pigment {color C3} }
  cylinder { <-83.598,596.375,8.749>,<-52.524,590.750,44.365>,1.000 pigment {color C3} }
  cylinder { <-83.598,596.375,8.749>,<-87.511,594.393,11.634>,2.000 pigment {color C2} }
  cylinder { <-87.511,594.393,11.634>,<-102.634,571.646,-27.348>,1.000 pigment {color C3} }
  cylinder { <-87.511,594.393,11.634>,<-56.374,588.823,47.204>,1.000 pigment {color C3} }
  cylinder { <-87.511,594.393,11.634>,<-91.402,592.344,14.502>,2.000 pigment {color C2} }
  cylinder { <-91.402,592.344,14.502>,<-108.333,568.883,-22.410>,1.000 pigment {color C3} }
  cylinder { <-91.402,592.344,14.502>,<-63.528,585.404,51.576>,1.000 pigment {color C3} }
  cylinder { <-91.402,592.344,14.502>,<-95.269,590.229,17.353>,2.000 pigment {color C2} }
  cylinder { <-95.269,590.229,17.353>,<-111.940,566.884,-19.750>,1.000 pigment {color C3} }
  cylinder { <-95.269,590.229,17.353>,<-66.735,583.611,53.981>,1.000 pigment {color C3} }
  cylinder { <-95.269,590.229,17.353>,<-99.113,588.047,20.186>,2.000 pigment {color C2} }
  cylinder { <-99.113,588.047,20.186>,<-117.387,563.954,-14.741>,1.000 pigment {color C3} }
  cylinder { <-99.113,588.047,20.186>,<-73.254,580.250,57.669>,1.000 pigment {color C3} }
  cylinder { <-99.113,588.047,20.186>,<-102.932,585.801,23.002>,2.000 pigment {color C2} }
  cylinder { <-102.932,585.801,23.002>,<-121.942,561.183,-11.158>,1.000 pigment {color C3} }
  cylinder { <-102.932,585.801,23.002>,<-77.580,577.647,60.754>,1.000 pigment {color C3} }
  cylinder { <-102.932,585.801,23.002>,<-106.727,583.491,25.799>,2.000 pigment {color C2} }
  cylinder { <-106.727,583.491,25.799>,<-127.046,558.117,-6.036>,1.000 pigment {color C3} }
  cylinder { <-106.727,583.491,25.799>,<-83.438,574.398,63.815>,1.000 pigment {color C3} }
  cylinder { <-106.727,583.491,25.799>,<-110.496,581.117,28.578>,2.000 pigment {color C2} }
  cylinder { <-110.496,581.117,28.578>,<-130.091,556.083,-3.973>,1.000 pigment {color C3} }
  cylinder { <-110.496,581.117,28.578>,<-85.933,572.684,65.938>,1.000 pigment {color C3} }
  cylinder { <-110.496,581.117,28.578>,<-114.240,578.681,31.338>,2.000 pigment {color C2} }
  cylinder { <-114.240,578.681,31.338>,<-134.977,552.874,1.154>,1.000 pigment {color C3} }
  cylinder { <-114.240,578.681,31.338>,<-92.284,568.910,69.147>,1.000 pigment {color C3} }
  cylinder { <-114.240,578.681,31.338>,<-117.957,576.183,34.078>,2.000 pigment {color C2} }
  cylinder { <-117.957,576.183,34.078>,<-137.586,551.008,2.646>,1.000 pigment {color C3} }
  cylinder { <-117.957,576.183,34.078>,<-97.076,565.608,72.277>,1.000 pigment {color C3} }
  cylinder { <-117.957,576.183,34.078>,<-121.647,573.625,36.798>,2.000 pigment {color C2} }
  cylinder { <-121.647,573.625,36.798>,<-142.297,547.656,7.746>,1.000 pigment {color C3} }
  cylinder { <-121.647,573.625,36.798>,<-102.150,562.391,74.725>,1.000 pigment {color C3} }
  cylinder { <-121.647,573.625,36.798>,<-125.310,571.007,39.498>,2.000 pigment {color C2} }
  cylinder { <-125.310,571.007,39.498>,<-146.059,544.744,10.784>,1.000 pigment {color C3} }
  cylinder { <-125.310,571.007,39.498>,<-107.462,558.536,77.848>,1.000 pigment {color C3} }
  cylinder { <-125.310,571.007,39.498>,<-128.945,568.330,42.178>,2.000 pigment {color C2} }
  cylinder { <-128.945,568.330,42.178>,<-150.785,541.013,16.480>,1.000 pigment {color C3} }
  cylinder { <-128.945,568.330,42.178>,<-112.419,555.181,80.093>,1.000 pigment {color C3} }
  cylinder { <-128.945,568.330,42.178>,<-132.552,565.594,44.837>,2.000 pigment {color C2} }
  cylinder { <-132.552,565.594,44.837>,<-154.416,537.960,19.502>,1.000 pigment {color C3} }
  cylinder { <-132.552,565.594,44.837>,<-115.889,552.328,82.651>,1.000 pigment {color C3} }
  cylinder { <-132.552,565.594,44.837>,<-136.130,562.802,47.475>,2.000 pigment {color C2} }
  cylinder { <-136.130,562.802,47.475>,<-158.474,534.460,24.654>,1.000 pigment {color C3} }
  cylinder { <-136.130,562.802,47.475>,<-121.319,548.464,84.869>,1.000 pigment {color C3} }
  cylinder { <-136.130,562.802,47.475>,<-139.680,559.953,50.092>,2.000 pigment {color C2} }
  cylinder { <-139.680,559.953,50.092>,<-161.734,531.557,27.057>,1.000 pigment {color C3} }
  cylinder { <-139.680,559.953,50.092>,<-125.870,544.694,87.504>,1.000 pigment {color C3} }
  cylinder { <-139.680,559.953,50.092>,<-143.201,557.049,52.687>,2.000 pigment {color C2} }
  cylinder { <-143.201,557.049,52.687>,<-165.537,527.989,32.179>,1.000 pigment {color C3} }
  cylinder { <-143.201,557.049,52.687>,<-131.726,540.335,89.470>,1.000 pigment {color C3} }
  cylinder { <-143.201,557.049,52.687>,<-146.692,554.091,55.260>,2.000 pigment {color C2} }
  cylinder { <-146.692,554.091,55.260>,<-168.520,525.229,33.940>,1.000 pigment {color C3} }
  cylinder { <-146.692,554.091,55.260>,<-135.048,537.221,91.919>,1.000 pigment {color C3} }
  cylinder { <-146.692,554.091,55.260>,<-150.153,551.079,57.812>,2.000 pigment {color C2} }
  cylinder { <-150.153,551.079,57.812>,<-172.116,521.588,39.008>,1.000 pigment {color C3} }
  cylinder { <-150.153,551.079,57.812>,<-139.641,533.556,93.702>,1.000 pigment {color C3} }
  cylinder { <-150.153,551.079,57.812>,<-153.584,548.015,60.342>,2.000 pigment {color C2} }
  cylinder { <-153.584,548.015,60.342>,<-175.076,518.707,40.724>,1.000 pigment {color C3} }
  cylinder { <-153.584,548.015,60.342>,<-143.447,529.940,96.066>,1.000 pigment {color C3} }
  cylinder { <-153.584,548.015,60.342>,<-156.985,544.898,62.849>,2.000 pigment {color C2} }
  cylinder { <-156.985,544.898,62.849>,<-178.472,515.005,45.731>,1.000 pigment {color C3} }
  cylinder { <-156.985,544.898,62.849>,<-148.456,525.809,97.651>,1.000 pigment {color C3} }
  cylinder { <-156.985,544.898,62.849>,<-160.356,541.731,65.333>,2.000 pigment {color C2} }
  cylinder { <-160.356,541.731,65.333>,<-181.407,512.005,47.401>,1.000 pigment {color C3} }
  cylinder { <-160.356,541.731,65.333>,<-153.241,521.320,99.701>,1.000 pigment {color C3} }
  cylinder { <-160.356,541.731,65.333>,<-163.695,538.515,67.795>,2.000 pigment {color C2} }
  cylinder { <-163.695,538.515,67.795>,<-184.713,508.024,52.944>,1.000 pigment {color C3} }
  cylinder { <-163.695,538.515,67.795>,<-157.549,517.532,101.171>,1.000 pigment {color C3} }
  cylinder { <-163.695,538.515,67.795>,<-167.004,535.249,70.234>,2.000 pigment {color C2} }
  cylinder { <-167.004,535.249,70.234>,<-187.730,504.664,55.168>,1.000 pigment {color C3} }
  cylinder { <-167.004,535.249,70.234>,<-160.140,514.470,103.598>,1.000 pigment {color C3} }
  cylinder { <-167.004,535.249,70.234>,<-170.282,531.935,72.650>,2.000 pigment {color C2} }
  cylinder { <-170.282,531.935,72.650>,<-190.721,500.715,60.642>,1.000 pigment {color C3} }
  cylinder { <-170.282,531.935,72.650>,<-165.355,509.875,104.677>,1.000 pigment {color C3} }
  cylinder { <-170.282,531.935,72.650>,<-173.528,528.574,75.044>,2.000 pigment {color C2} }
  cylinder { <-173.528,528.574,75.044>,<-193.718,497.045,63.428>,1.000 pigment {color C3} }
  cylinder { <-173.528,528.574,75.044>,<-168.394,506.340,106.918>,1.000 pigment {color C3} }
  cylinder { <-173.528,528.574,75.044>,<-176.743,525.167,77.414>,2.000 pigment {color C2} }
  cylinder { <-176.743,525.167,77.414>,<-196.358,493.526,67.598>,1.000 pigment {color C3} }
  cylinder { <-176.743,525.167,77.414>,<-173.908,501.393,107.564>,1.000 pigment {color C3} }
  cylinder { <-176.743,525.167,77.414>,<-179.926,521.714,79.760>,2.000 pigment {color C2} }
  cylinder { <-179.926,521.714,79.760>,<-199.236,490.150,69.128>,1.000 pigment {color C3} }
  cylinder { <-179.926,521.714,79.760>,<-177.820,497.079,109.272>,1.000 pigment {color C3} }
  cylinder { <-179.926,521.714,79.760>,<-183.078,518.217,82.084>,2.000 pigment {color C2} }
  cylinder { <-183.078,518.217,82.084>,<-201.705,486.095,75.008>,1.000 pigment {color C3} }
  cylinder { <-183.078,518.217,82.084>,<-181.706,493.196,110.384>,1.000 pigment {color C3} }
  cylinder { <-183.078,518.217,82.084>,<-186.199,514.677,84.384>,2.000 pigment {color C2} }
  cylinder { <-186.199,514.677,84.384>,<-204.566,482.594,76.496>,1.000 pigment {color C3} }
  cylinder { <-186.199,514.677,84.384>,<-184.600,489.482,112.518>,1.000 pigment {color C3} }
  cylinder { <-186.199,514.677,84.384>,<-189.287,511.093,86.661>,2.000 pigment {color C2} }
  cylinder { <-189.287,511.093,86.661>,<-206.860,478.902,81.065>,1.000 pigment {color C3} }
  cylinder { <-189.287,511.093,86.661>,<-190.109,484.347,112.359>,1.000 pigment {color C3} }
  cylinder { <-189.287,511.093,86.661>,<-192.344,507.468,88.914>,2.000 pigment {color C2} }
  cylinder { <-192.344,507.468,88.914>,<-209.737,475.451,81.931>,1.000 pigment {color C3} }
  cylinder { <-192.344,507.468,88.914>,<-192.073,481.149,115.061>,1.000 pigment {color C3} }
  cylinder { <-192.344,507.468,88.914>,<-195.368,503.802,91.144>,2.000 pigment {color C2} }
  cylinder { <-195.368,503.802,91.144>,<-211.918,471.731,86.400>,1.000 pigment {color C3} }
  cylinder { <-195.368,503.802,91.144>,<-196.124,476.938,115.695>,1.000 pigment {color C3} }
  cylinder { <-195.368,503.802,91.144>,<-198.361,500.095,93.350>,2.000 pigment {color C2} }
  cylinder { <-198.361,500.095,93.350>,<-214.465,467.673,89.559>,1.000 pigment {color C3} }
  cylinder { <-198.361,500.095,93.350>,<-198.884,473.071,117.730>,1.000 pigment {color C3} }
  cylinder { <-198.361,500.095,93.350>,<-201.322,496.350,95.533>,2.000 pigment {color C2} }
  cylinder { <-201.322,496.350,95.533>,<-216.648,464.227,92.748>,1.000 pigment {color C3} }
  cylinder { <-201.322,496.350,95.533>,<-203.950,468.099,117.201>,1.000 pigment {color C3} }
  cylinder { <-201.322,496.350,95.533>,<-204.252,492.566,97.693>,2.000 pigment {color C2} }
  cylinder { <-204.252,492.566,97.693>,<-219.196,460.234,95.273>,1.000 pigment {color C3} }
  cylinder { <-204.252,492.566,97.693>,<-205.876,464.668,119.909>,1.000 pigment {color C3} }
  cylinder { <-204.252,492.566,97.693>,<-207.149,488.744,99.828>,2.000 pigment {color C2} }
  cylinder { <-207.149,488.744,99.828>,<-220.740,456.499,100.582>,1.000 pigment {color C3} }
  cylinder { <-207.149,488.744,99.828>,<-210.708,459.817,119.209>,1.000 pigment {color C3} }
  cylinder { <-207.149,488.744,99.828>,<-210.015,484.885,101.941>,2.000 pigment {color C2} }
  cylinder { <-210.015,484.885,101.941>,<-223.339,452.526,102.497>,1.000 pigment {color C3} }
  cylinder { <-210.015,484.885,101.941>,<-212.619,456.266,121.919>,1.000 pigment {color C3} }
  cylinder { <-210.015,484.885,101.941>,<-212.848,480.991,104.030>,2.000 pigment {color C2} }
  cylinder { <-212.848,480.991,104.030>,<-215.651,477.061,106.096>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-74.263,600.964,-4.500>,2.000 pigment {color C2} }
  cylinder { <-74.263,600.964,-4.500>,<-32.651,599.096,-27.537>,1.000 pigment {color C3} }
  cylinder { <-74.263,600.964,-4.500>,<-103.326,572.761,20.512>,1.000 pigment {color C3} }
  cylinder { <-74.263,600.964,-4.500>,<-76.789,599.944,-8.987>,2.000 pigment {color C2} }
  cylinder { <-76.789,599.944,-8.987>,<-34.794,598.231,-31.330>,1.000 pigment {color C3} }
  cylinder { <-76.789,599.944,-8.987>,<-105.649,571.855,16.386>,1.000 pigment {color C3} }
  cylinder { <-76.789,599.944,-8.987>,<-79.308,598.848,-13.461>,2.000 pigment {color C2} }
  cylinder { <-79.308,598.848,-13.461>,<-39.843,596.345,-38.676>,1.000 pigment {color C3} }
  cylinder { <-79.308,598.848,-13.461>,<-109.758,570.327,7.962>,1.000 pigment {color C3} }
  cylinder { <-79.308,598.848,-13.461>,<-81.819,597.677,-17.920>,2.000 pigment {color C2} }
  cylinder { <-81.819,597.677,-17.920>,<-41.931,595.321,-42.476>,1.000 pigment {color C3} }
  cylinder { <-81.819,597.677,-17.920>,<-112.064,569.214,3.867>,1.000 pigment {color C3} }
  cylinder { <-81.819,597.677,-17.920>,<-84.321,596.431,-22.365>,2.000 pigment {color C2} }
  cylinder { <-84.321,596.431,-22.365>,<-46.660,593.290,-48.939>,1.000 pigment {color C3} }
  cylinder { <-84.321,596.431,-22.365>,<-114.237,568.290,-1.209>,1.000 pigment {color C3} }
  cylinder { <-84.321,596.431,-22.365>,<-86.815,595.111,-26.792>,2.000 pigment {color C2} }
  cylinder { <-86.815,595.111,-26.792>,<-49.566,591.684,-53.907>,1.000 pigment {color C3} }
  cylinder { <-86.815,595.111,-26.792>,<-116.529,567.028,-5.280>,1.000 pigment {color C3} }
  cylinder { <-86.815,595.111,-26.792>,<-89.298,593.718,-31.203>,2.000 pigment {color C2} }
  cylinder { <-89.298,593.718,-31.203>,<-53.925,589.572,-59.520>,1.000 pigment {color C3} }
  cylinder { <-89.298,593.718,-31.203>,<-119.785,565.262,-13.008>,1.000 pigment {color C3} }
  cylinder { <-89.298,593.718,-31.203>,<-91.771,592.251,-35.595>,2.000 pigment {color C2} }
  cylinder { <-91.771,592.251,-35.595>,<-56.369,588.000,-63.860>,1.000 pigment {color C3} }
  cylinder { <-91.771,592.251,-35.595>,<-121.796,563.985,-16.365>,1.000 pigment {color C3} }
  cylinder { <-91.771,592.251,-35.595>,<-94.234,590.712,-39.969>,2.000 pigment {color C2} }
  cylinder { <-94.234,590.712,-39.969>,<-61.209,585.392,-69.770>,1.000 pigment {color C3} }
  cylinder { <-94.234,590.712,-39.969>,<-125.157,561.734,-25.440>,1.000 pigment {color C3} }
  cylinder { <-94.234,590.712,-39.969>,<-96.685,589.101,-44.323>,2.000 pigment {color C2} }
  cylinder { <-96.685,589.101,-44.323>,<-63.146,583.913,-73.568>,1.000 pigment {color C3} }
  cylinder { <-96.685,589.101,-44.323>,<-127.404,560.090,-29.431>,1.000 pigment {color C3} }
  cylinder { <-96.685,589.101,-44.323>,<-99.125,587.419,-48.657>,2.000 pigment {color C2} }
  cylinder { <-99.125,587.419,-48.657>,<-67.990,581.065,-79.235>,1.000 pigment {color C3} }
  cylinder { <-99.125,587.419,-48.657>,<-129.649,558.346,-35.700>,1.000 pigment {color C3} }
  cylinder { <-99.125,587.419,-48.657>,<-101.553,585.666,-52.969>,2.000 pigment {color C2} }
  cylinder { <-101.553,585.666,-52.969>,<-69.884,579.444,-83.022>,1.000 pigment {color C3} }
  cylinder { <-101.553,585.666,-52.969>,<-131.724,556.712,-38.964>,1.000 pigment {color C3} }
  cylinder { <-101.553,585.666,-52.969>,<-103.969,583.844,-57.259>,2.000 pigment {color C2} }
  cylinder { <-103.969,583.844,-57.259>,<-76.262,575.456,-89.595>,1.000 pigment {color C3} }
  cylinder { <-103.969,583.844,-57.259>,<-133.868,554.806,-45.159>,1.000 pigment {color C3} }
  cylinder { <-103.969,583.844,-57.259>,<-106.371,581.952,-61.527>,2.000 pigment {color C2} }
  cylinder { <-106.371,581.952,-61.527>,<-78.088,573.676,-93.387>,1.000 pigment {color C3} }
  cylinder { <-106.371,581.952,-61.527>,<-136.182,552.690,-49.752>,1.000 pigment {color C3} }
  cylinder { <-106.371,581.952,-61.527>,<-108.761,579.992,-65.771>,2.000 pigment {color C2} }
  cylinder { <-108.761,579.992,-65.771>,<-83.482,570.054,-98.717>,1.000 pigment {color C3} }
  cylinder { <-108.761,579.992,-65.771>,<-138.316,550.195,-57.904>,1.000 pigment {color C3} }
  cylinder { <-108.761,579.992,-65.771>,<-111.137,577.965,-69.991>,2.000 pigment {color C2} }
  cylinder { <-111.137,577.965,-69.991>,<-84.214,568.790,-101.838>,1.000 pigment {color C3} }
  cylinder { <-111.137,577.965,-69.991>,<-140.329,548.542,-59.723>,1.000 pigment {color C3} }
  cylinder { <-111.137,577.965,-69.991>,<-113.499,575.871,-74.186>,2.000 pigment {color C2} }
  cylinder { <-113.499,575.871,-74.186>,<-89.024,565.321,-106.646>,1.000 pigment {color C3} }
  cylinder { <-113.499,575.871,-74.186>,<-142.224,545.776,-68.427>,1.000 pigment {color C3} }
  cylinder { <-113.499,575.871,-74.186>,<-115.846,573.711,-78.355>,2.000 pigment {color C2} }
  cylinder { <-115.846,573.711,-78.355>,<-91.299,562.938,-110.687>,1.000 pigment {color C3} }
  cylinder { <-115.846,573.711,-78.355>,<-144.371,543.641,-71.562>,1.000 pigment {color C3} }
  cylinder { <-115.846,573.711,-78.355>,<-118.179,571.485,-82.498>,2.000 pigment {color C2} }
  cylinder { <-118.179,571.485,-82.498>,<-97.151,558.623,-115.635>,1.000 pigment {color C3} }
  cylinder { <-118.179,571.485,-82.498>,<-146.011,541.511,-76.787>,1.000 pigment {color C3} }
  cylinder { <-118.179,571.485,-82.498>,<-120.497,569.195,-86.615>,2.000 pigment {color C2} }
  cylinder { <-120.497,569.195,-86.615>,<-99.382,556.082,-119.598>,1.000 pigment {color C3} }
  cylinder { <-120.497,569.195,-86.615>,<-148.066,538.812,-81.869>,1.000 pigment {color C3} }
  cylinder { <-120.497,569.195,-86.615>,<-122.800,566.842,-90.704>,2.000 pigment {color C2} }
  cylinder { <-122.800,566.842,-90.704>,<-103.567,552.665,-123.530>,1.000 pigment {color C3} }
  cylinder { <-122.800,566.842,-90.704>,<-149.365,536.191,-88.931>,1.000 pigment {color C3} }
  cylinder { <-122.800,566.842,-90.704>,<-125.086,564.426,-94.766>,2.000 pigment {color C2} }
  cylinder { <-125.086,564.426,-94.766>,<-106.849,549.291,-127.731>,1.000 pigment {color C3} }
  cylinder { <-125.086,564.426,-94.766>,<-151.539,533.751,-91.986>,1.000 pigment {color C3} }
  cylinder { <-125.086,564.426,-94.766>,<-127.357,561.948,-98.799>,2.000 pigment {color C2} }
  cylinder { <-127.357,561.948,-98.799>,<-110.415,546.120,-131.271>,1.000 pigment {color C3} }
  cylinder { <-127.357,561.948,-98.799>,<-152.863,531.287,-97.620>,1.000 pigment {color C3} }
  cylinder { <-127.357,561.948,-98.799>,<-129.612,559.409,-102.803>,2.000 pigment {color C2} }
  cylinder { <-129.612,559.409,-102.803>,<-112.027,543.670,-134.976>,1.000 pigment {color C3} }
  cylinder { <-129.612,559.409,-102.803>,<-154.918,528.599,-101.270>,1.000 pigment {color C3} }
  cylinder { <-129.612,559.409,-102.803>,<-131.850,556.810,-106.778>,2.000 pigment {color C2} }
  cylinder { <-131.850,556.810,-106.778>,<-118.224,538.677,-138.750>,1.000 pigment {color C3} }
  cylinder { <-131.850,556.810,-106.778>,<-155.992,525.932,-107.398>,1.000 pigment {color C3} }
  cylinder { <-131.850,556.810,-106.778>,<-134.071,554.151,-110.723>,2.000 pigment {color C2} }
  cylinder { <-134.071,554.151,-110.723>,<-119.787,536.089,-142.446>,1.000 pigment {color C3} }
  cylinder { <-134.071,554.151,-110.723>,<-158.161,523.229,-110.376>,1.000 pigment {color C3} }
  cylinder { <-134.071,554.151,-110.723>,<-136.275,551.435,-114.637>,2.000 pigment {color C2} }
  cylinder { <-136.275,551.435,-114.637>,<-124.800,531.748,-145.670>,1.000 pigment {color C3} }
  cylinder { <-136.275,551.435,-114.637>,<-158.543,520.225,-118.147>,1.000 pigment {color C3} }
  cylinder { <-136.275,551.435,-114.637>,<-138.462,548.661,-118.521>,2.000 pigment {color C2} }
  cylinder { <-138.462,548.661,-118.521>,<-126.862,528.701,-149.332>,1.000 pigment {color C3} }
  cylinder { <-138.462,548.661,-118.521>,<-161.102,517.552,-119.896>,1.000 pigment {color C3} }
  cylinder { <-138.462,548.661,-118.521>,<-140.631,545.830,-122.374>,2.000 pigment {color C2} }
  cylinder { <-140.631,545.830,-122.374>,<-131.225,524.671,-152.251>,1.000 pigment {color C3} }
  cylinder { <-140.631,545.830,-122.374>,<-161.240,514.550,-127.437>,1.000 pigment {color C3} }
  cylinder { <-140.631,545.830,-122.374>,<-142.783,542.944,-126.196>,2.000 pigment {color C2} }
  cylinder { <-142.783,542.944,-126.196>,<-133.244,521.516,-155.838>,1.000 pigment {color C3} }
  cylinder { <-142.783,542.944,-126.196>,<-163.427,511.552,-130.342>,1.000 pigment {color C3} }
  cylinder { <-142.783,542.944,-126.196>,<-144.916,540.003,-129.985>,2.000 pigment {color C2} }
  cylinder { <-144.916,540.003,-129.985>,<-135.940,518.397,-158.778>,1.000 pigment {color C3} }
  cylinder { <-144.916,540.003,-129.985>,<-164.286,508.826,-135.390>,1.000 pigment {color C3} }
  cylinder { <-144.916,540.003,-129.985>,<-147.032,537.008,-133.743>,2.000 pigment {color C2} }
  cylinder { <-147.032,537.008,-133.743>,<-137.923,515.147,-162.300>,1.000 pigment {color C3} }
  cylinder { <-147.032,537.008,-133.743>,<-165.960,505.599,-139.360>,1.000 pigment {color C3} }
  cylinder { <-147.032,537.008,-133.743>,<-149.129,533.961,-137.467>,2.000 pigment {color C2} }
  cylinder { <-149.129,533.961,-137.467>,<-142.074,511.046,-164.856>,1.000 pigment {color C3} }
  cylinder { <-149.129,533.961,-137.467>,<-166.730,502.829,-144.251>,1.000 pigment {color C3} }
  cylinder { <-149.129,533.961,-137.467>,<-151.208,530.861,-141.160>,2.000 pigment {color C2} }
  cylinder { <-151.208,530.861,-141.160>,<-144.517,507.402,-168.176>,1.000 pigment {color C3} }
  cylinder { <-151.208,530.861,-141.160>,<-168.345,499.515,-148.139>,1.000 pigment {color C3} }
  cylinder { <-151.208,530.861,-141.160>,<-153.268,527.710,-144.819>,2.000 pigment {color C2} }
  cylinder { <-153.268,527.710,-144.819>,<-148.040,503.610,-170.633>,1.000 pigment {color C3} }
  cylinder { <-153.268,527.710,-144.819>,<-169.037,496.709,-152.869>,1.000 pigment {color C3} }
  cylinder { <-153.268,527.710,-144.819>,<-155.310,524.509,-148.445>,2.000 pigment {color C2} }
  cylinder { <-155.310,524.509,-148.445>,<-150.915,499.624,-173.662>,1.000 pigment {color C3} }
  cylinder { <-155.310,524.509,-148.445>,<-170.596,493.314,-156.673>,1.000 pigment {color C3} }
  cylinder { <-155.310,524.509,-148.445>,<-157.333,521.259,-152.038>,2.000 pigment {color C2} }
  cylinder { <-157.333,521.259,-152.038>,<-155.251,495.368,-175.497>,1.000 pigment {color C3} }
  cylinder { <-157.333,521.259,-152.038>,<-170.576,490.494,-162.192>,1.000 pigment {color C3} }
  cylinder { <-157.333,521.259,-152.038>,<-159.337,517.961,-155.597>,2.000 pigment {color C2} }
  cylinder { <-159.337,517.961,-155.597>,<-157.104,491.843,-178.789>,1.000 pigment {color C3} }
  cylinder { <-159.337,517.961,-155.597>,<-173.359,487.014,-164.003>,1.000 pigment {color C3} }
  cylinder { <-159.337,517.961,-155.597>,<-161.322,514.615,-159.122>,2.000 pigment {color C2} }
  cylinder { <-161.322,514.615,-159.122>,<-163.287,511.222,-162.614>,2.000 pigment {color C2} }
  sphere { <-49.903,543.334,23.868>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-72.930,601.754,-5.108>,2.000 pigment {color C2} }
  cylinder { <-72.930,601.754,-5.108>,<-28.076,601.545,-18.807>,1.000 pigment {color C3} }
  cylinder { <-72.930,601.754,-5.108>,<-108.225,571.636,1.729>,1.000 pigment {color C3} }
  cylinder { <-72.930,601.754,-5.108>,<-74.131,601.521,-10.214>,2.000 pigment {color C2} }
  cylinder { <-74.131,601.521,-10.214>,<-29.057,601.316,-23.173>,1.000 pigment {color C3} }
  cylinder { <-74.131,601.521,-10.214>,<-108.850,571.467,-.679>,1.000 pigment {color C3} }
  cylinder { <-74.131,601.521,-10.214>,<-75.330,601.210,-15.315>,2.000 pigment {color C2} }
  cylinder { <-75.330,601.210,-15.315>,<-31.370,600.848,-29.523>,1.000 pigment {color C3} }
  cylinder { <-75.330,601.210,-15.315>,<-110.026,571.483,-8.459>,1.000 pigment {color C3} }
  cylinder { <-75.330,601.210,-15.315>,<-76.528,600.820,-20.412>,2.000 pigment {color C2} }
  cylinder { <-76.528,600.820,-20.412>,<-32.805,600.321,-35.328>,1.000 pigment {color C3} }
  cylinder { <-76.528,600.820,-20.412>,<-111.440,570.984,-15.370>,1.000 pigment {color C3} }
  cylinder { <-76.528,600.820,-20.412>,<-77.725,600.351,-25.502>,2.000 pigment {color C2} }
  cylinder { <-77.725,600.351,-25.502>,<-35.434,599.497,-42.265>,1.000 pigment {color C3} }
  cylinder { <-77.725,600.351,-25.502>,<-112.088,570.892,-20.850>,1.000 pigment {color C3} }
  cylinder { <-77.725,600.351,-25.502>,<-78.920,599.805,-30.585>,2.000 pigment {color C2} }
  cylinder { <-78.920,599.805,-30.585>,<-37.497,598.484,-49.364>,1.000 pigment {color C3} }
  cylinder { <-78.920,599.805,-30.585>,<-113.250,570.260,-26.246>,1.000 pigment {color C3} }
  cylinder { <-78.920,599.805,-30.585>,<-80.113,599.181,-35.659>,2.000 pigment {color C2} }
  cylinder { <-80.113,599.181,-35.659>,<-40.276,597.323,-56.070>,1.000 pigment {color C3} }
  cylinder { <-80.113,599.181,-35.659>,<-113.963,569.887,-33.895>,1.000 pigment {color C3} }
  cylinder { <-80.113,599.181,-35.659>,<-81.304,598.479,-40.724>,2.000 pigment {color C2} }
  cylinder { <-81.304,598.479,-40.724>,<-41.460,596.461,-61.107>,1.000 pigment {color C3} }
  cylinder { <-81.304,598.479,-40.724>,<-115.035,569.141,-37.801>,1.000 pigment {color C3} }
  cylinder { <-81.304,598.479,-40.724>,<-82.492,597.700,-45.778>,2.000 pigment {color C2} }
  cylinder { <-82.492,597.700,-45.778>,<-43.939,595.216,-67.045>,1.000 pigment {color C3} }
  cylinder { <-82.492,597.700,-45.778>,<-115.572,568.537,-46.091>,1.000 pigment {color C3} }
  cylinder { <-82.492,597.700,-45.778>,<-83.678,596.844,-50.820>,2.000 pigment {color C2} }
  cylinder { <-83.678,596.844,-50.820>,<-45.468,593.999,-72.655>,1.000 pigment {color C3} }
  cylinder { <-83.678,596.844,-50.820>,<-116.618,567.528,-51.433>,1.000 pigment {color C3} }
  cylinder { <-83.678,596.844,-50.820>,<-84.860,595.912,-55.850>,2.000 pigment {color C2} }
  cylinder { <-84.860,595.912,-55.850>,<-48.343,592.334,-79.028>,1.000 pigment {color C3} }
  cylinder { <-84.860,595.912,-55.850>,<-116.807,566.771,-59.570>,1.000 pigment {color C3} }
  cylinder { <-84.860,595.912,-55.850>,<-86.040,594.903,-60.865>,2.000 pigment {color C2} }
  cylinder { <-86.040,594.903,-60.865>,<-49.510,591.116,-83.991>,1.000 pigment {color C3} }
  cylinder { <-86.040,594.903,-60.865>,<-118.071,565.680,-62.756>,1.000 pigment {color C3} }
  cylinder { <-86.040,594.903,-60.865>,<-87.215,593.819,-65.866>,2.000 pigment {color C2} }
  cylinder { <-87.215,593.819,-65.866>,<-52.823,588.991,-90.709>,1.000 pigment {color C3} }
  cylinder { <-87.215,593.819,-65.866>,<-118.344,564.804,-69.389>,1.000 pigment {color C3} }
  cylinder { <-87.215,593.819,-65.866>,<-88.387,592.659,-70.850>,2.000 pigment {color C2} }
  cylinder { <-88.387,592.659,-70.850>,<-53.979,587.592,-95.622>,1.000 pigment {color C3} }
  cylinder { <-88.387,592.659,-70.850>,<-119.030,563.374,-76.019>,1.000 pigment {color C3} }
  cylinder { <-88.387,592.659,-70.850>,<-89.555,591.425,-75.817>,2.000 pigment {color C2} }
  cylinder { <-89.555,591.425,-75.817>,<-58.698,584.451,-103.444>,1.000 pigment {color C3} }
  cylinder { <-89.555,591.425,-75.817>,<-119.289,562.377,-81.831>,1.000 pigment {color C3} }
  cylinder { <-89.555,591.425,-75.817>,<-90.719,590.116,-80.767>,2.000 pigment {color C2} }
  cylinder { <-90.719,590.116,-80.767>,<-59.838,582.854,-108.292>,1.000 pigment {color C3} }
  cylinder { <-90.719,590.116,-80.767>,<-120.516,560.930,-85.698>,1.000 pigment {color C3} }
  cylinder { <-90.719,590.116,-80.767>,<-91.878,588.733,-85.697>,2.000 pigment {color C2} }
  cylinder { <-91.878,588.733,-85.697>,<-62.399,580.770,-113.504>,1.000 pigment {color C3} }
  cylinder { <-91.878,588.733,-85.697>,<-119.759,559.620,-94.682>,1.000 pigment {color C3} }
  cylinder { <-91.878,588.733,-85.697>,<-93.033,587.278,-90.607>,2.000 pigment {color C2} }
  cylinder { <-93.033,587.278,-90.607>,<-64.465,578.460,-119.100>,1.000 pigment {color C3} }
  cylinder { <-93.033,587.278,-90.607>,<-121.037,557.978,-98.541>,1.000 pigment {color C3} }
  cylinder { <-93.033,587.278,-90.607>,<-94.182,585.750,-95.497>,2.000 pigment {color C2} }
  cylinder { <-94.182,585.750,-95.497>,<-67.018,576.211,-124.123>,1.000 pigment {color C3} }
  cylinder { <-94.182,585.750,-95.497>,<-120.937,556.653,-104.766>,1.000 pigment {color C3} }
  cylinder { <-94.182,585.750,-95.497>,<-95.327,584.150,-100.364>,2.000 pigment {color C2} }
  cylinder { <-95.327,584.150,-100.364>,<-69.103,573.715,-129.550>,1.000 pigment {color C3} }
  cylinder { <-95.327,584.150,-100.364>,<-122.222,554.874,-108.604>,1.000 pigment {color C3} }
  cylinder { <-95.327,584.150,-100.364>,<-96.466,582.479,-105.209>,2.000 pigment {color C2} }
  cylinder { <-96.466,582.479,-105.209>,<-71.147,571.614,-134.069>,1.000 pigment {color C3} }
  cylinder { <-96.466,582.479,-105.209>,<-120.977,553.326,-117.099>,1.000 pigment {color C3} }
  cylinder { <-96.466,582.479,-105.209>,<-97.599,580.737,-110.030>,2.000 pigment {color C2} }
  cylinder { <-97.599,580.737,-110.030>,<-72.245,569.556,-138.738>,1.000 pigment {color C3} }
  cylinder { <-97.599,580.737,-110.030>,<-122.584,551.385,-120.337>,1.000 pigment {color C3} }
  cylinder { <-97.599,580.737,-110.030>,<-98.727,578.925,-114.827>,2.000 pigment {color C2} }
  cylinder { <-98.727,578.925,-114.827>,<-77.271,565.520,-144.770>,1.000 pigment {color C3} }
  cylinder { <-98.727,578.925,-114.827>,<-122.026,549.783,-126.850>,1.000 pigment {color C3} }
  cylinder { <-98.727,578.925,-114.827>,<-99.849,577.044,-119.598>,2.000 pigment {color C2} }
  cylinder { <-99.849,577.044,-119.598>,<-77.327,563.912,-148.872>,1.000 pigment {color C3} }
  cylinder { <-99.849,577.044,-119.598>,<-122.423,547.639,-132.341>,1.000 pigment {color C3} }
  cylinder { <-99.849,577.044,-119.598>,<-100.964,575.094,-124.343>,2.000 pigment {color C2} }
  cylinder { <-100.964,575.094,-124.343>,<-80.826,560.657,-153.809>,1.000 pigment {color C3} }
  cylinder { <-100.964,575.094,-124.343>,<-122.391,545.958,-137.544>,1.000 pigment {color C3} }
  cylinder { <-100.964,575.094,-124.343>,<-102.074,573.077,-129.062>,2.000 pigment {color C2} }
  cylinder { <-102.074,573.077,-129.062>,<-81.377,558.614,-158.125>,1.000 pigment {color C3} }
  cylinder { <-102.074,573.077,-129.062>,<-123.068,543.690,-142.399>,1.000 pigment {color C3} }
  cylinder { <-102.074,573.077,-129.062>,<-103.177,570.993,-133.752>,2.000 pigment {color C2} }
  cylinder { <-103.177,570.993,-133.752>,<-84.842,555.253,-162.820>,1.000 pigment {color C3} }
  cylinder { <-103.177,570.993,-133.752>,<-121.920,541.921,-148.995>,1.000 pigment {color C3} }
  cylinder { <-103.177,570.993,-133.752>,<-104.273,568.843,-138.415>,2.000 pigment {color C2} }
  cylinder { <-104.273,568.843,-138.415>,<-87.451,551.860,-167.697>,1.000 pigment {color C3} }
  cylinder { <-104.273,568.843,-138.415>,<-123.658,539.497,-152.266>,1.000 pigment {color C3} }
  cylinder { <-104.273,568.843,-138.415>,<-105.362,566.628,-143.048>,2.000 pigment {color C2} }
  cylinder { <-105.362,566.628,-143.048>,<-90.888,548.448,-171.969>,1.000 pigment {color C3} }
  cylinder { <-105.362,566.628,-143.048>,<-123.206,537.598,-157.721>,1.000 pigment {color C3} }
  cylinder { <-105.362,566.628,-143.048>,<-106.445,564.348,-147.652>,2.000 pigment {color C2} }
  cylinder { <-106.445,564.348,-147.652>,<-90.345,546.724,-176.052>,1.000 pigment {color C3} }
  cylinder { <-106.445,564.348,-147.652>,<-123.820,535.081,-162.415>,1.000 pigment {color C3} }
  cylinder { <-106.445,564.348,-147.652>,<-107.520,562.004,-152.225>,2.000 pigment {color C2} }
  cylinder { <-107.520,562.004,-152.225>,<-94.244,542.937,-180.246>,1.000 pigment {color C3} }
  cylinder { <-107.520,562.004,-152.225>,<-122.928,533.123,-168.145>,1.000 pigment {color C3} }
  cylinder { <-107.520,562.004,-152.225>,<-108.588,559.597,-156.767>,2.000 pigment {color C2} }
  cylinder { <-108.588,559.597,-156.767>,<-95.775,539.920,-184.580>,1.000 pigment {color C3} }
  cylinder { <-108.588,559.597,-156.767>,<-123.503,530.492,-172.747>,1.000 pigment {color C3} }
  cylinder { <-108.588,559.597,-156.767>,<-109.648,557.129,-161.277>,2.000 pigment {color C2} }
  cylinder { <-109.648,557.129,-161.277>,<-99.607,536.146,-188.358>,1.000 pigment {color C3} }
  cylinder { <-109.648,557.129,-161.277>,<-122.966,528.441,-177.834>,1.000 pigment {color C3} }
  cylinder { <-109.648,557.129,-161.277>,<-110.701,554.599,-165.755>,2.000 pigment {color C2} }
  cylinder { <-110.701,554.599,-165.755>,<-99.558,533.841,-192.578>,1.000 pigment {color C3} }
  cylinder { <-110.701,554.599,-165.755>,<-123.088,525.750,-182.748>,1.000 pigment {color C3} }
  cylinder { <-110.701,554.599,-165.755>,<-111.746,552.009,-170.201>,2.000 pigment {color C2} }
  cylinder { <-111.746,552.009,-170.201>,<-102.287,530.560,-196.191>,1.000 pigment {color C3} }
  cylinder { <-111.746,552.009,-170.201>,<-122.958,523.581,-187.264>,1.000 pigment {color C3} }
  cylinder { <-111.746,552.009,-170.201>,<-112.784,549.360,-174.613>,2.000 pigment {color C2} }
  cylinder { <-112.784,549.360,-174.613>,<-104.282,527.096,-200.246>,1.000 pigment {color C3} }
  cylinder { <-112.784,549.360,-174.613>,<-124.336,520.633,-190.933>,1.000 pigment {color C3} }
  cylinder { <-112.784,549.360,-174.613>,<-113.813,546.652,-178.991>,2.000 pigment {color C2} }
  cylinder { <-113.813,546.652,-178.991>,<-114.835,543.887,-183.336>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-71.324,602.645,-5.182>,2.000 pigment {color C2} }
  cylinder { <-71.324,602.645,-5.182>,<-25.142,603.590,-6.039>,1.000 pigment {color C3} }
  cylinder { <-71.324,602.645,-5.182>,<-105.318,573.798,-17.295>,1.000 pigment {color C3} }
  cylinder { <-71.324,602.645,-5.182>,<-70.919,603.304,-10.374>,2.000 pigment {color C2} }
  cylinder { <-70.919,603.304,-10.374>,<-24.735,604.183,-11.245>,1.000 pigment {color C3} }
  cylinder { <-70.919,603.304,-10.374>,<-105.323,573.960,-19.847>,1.000 pigment {color C3} }
  cylinder { <-70.919,603.304,-10.374>,<-70.513,603.885,-15.576>,2.000 pigment {color C2} }
  cylinder { <-70.513,603.885,-15.576>,<-25.338,604.931,-20.904>,1.000 pigment {color C3} }
  cylinder { <-70.513,603.885,-15.576>,<-103.750,575.448,-28.101>,1.000 pigment {color C3} }
  cylinder { <-70.513,603.885,-15.576>,<-70.106,604.389,-20.786>,2.000 pigment {color C2} }
  cylinder { <-70.106,604.389,-20.786>,<-24.848,605.285,-25.387>,1.000 pigment {color C3} }
  cylinder { <-70.106,604.389,-20.786>,<-103.021,576.039,-34.318>,1.000 pigment {color C3} }
  cylinder { <-70.106,604.389,-20.786>,<-69.699,604.815,-26.003>,2.000 pigment {color C2} }
  cylinder { <-69.699,604.815,-26.003>,<-25.530,605.579,-33.457>,1.000 pigment {color C3} }
  cylinder { <-69.699,604.815,-26.003>,<-101.743,576.966,-40.308>,1.000 pigment {color C3} }
  cylinder { <-69.699,604.815,-26.003>,<-69.291,605.162,-31.226>,2.000 pigment {color C2} }
  cylinder { <-69.291,605.162,-31.226>,<-25.121,605.764,-38.690>,1.000 pigment {color C3} }
  cylinder { <-69.291,605.162,-31.226>,<-101.368,577.140,-45.114>,1.000 pigment {color C3} }
  cylinder { <-69.291,605.162,-31.226>,<-68.883,605.431,-36.453>,2.000 pigment {color C2} }
  cylinder { <-68.883,605.431,-36.453>,<-25.976,605.709,-46.639>,1.000 pigment {color C3} }
  cylinder { <-68.883,605.431,-36.453>,<-99.319,578.199,-53.092>,1.000 pigment {color C3} }
  cylinder { <-68.883,605.431,-36.453>,<-68.474,605.622,-41.684>,2.000 pigment {color C2} }
  cylinder { <-68.474,605.622,-41.684>,<-25.258,605.804,-50.463>,1.000 pigment {color C3} }
  cylinder { <-68.474,605.622,-41.684>,<-99.445,577.982,-56.572>,1.000 pigment {color C3} }
  cylinder { <-68.474,605.622,-41.684>,<-68.066,605.733,-46.916>,2.000 pigment {color C2} }
  cylinder { <-68.066,605.733,-46.916>,<-26.585,605.308,-59.674>,1.000 pigment {color C3} }
  cylinder { <-68.066,605.733,-46.916>,<-97.260,578.819,-64.433>,1.000 pigment {color C3} }
  cylinder { <-68.066,605.733,-46.916>,<-67.657,605.766,-52.150>,2.000 pigment {color C2} }
  cylinder { <-67.657,605.766,-52.150>,<-25.782,605.280,-63.544>,1.000 pigment {color C3} }
  cylinder { <-67.657,605.766,-52.150>,<-97.168,578.535,-68.617>,1.000 pigment {color C3} }
  cylinder { <-67.657,605.766,-52.150>,<-67.248,605.720,-57.384>,2.000 pigment {color C2} }
  cylinder { <-67.248,605.720,-57.384>,<-27.600,604.277,-73.171>,1.000 pigment {color C3} }
  cylinder { <-67.248,605.720,-57.384>,<-94.481,579.264,-76.923>,1.000 pigment {color C3} }
  cylinder { <-67.248,605.720,-57.384>,<-66.840,605.596,-62.617>,2.000 pigment {color C2} }
  cylinder { <-66.840,605.596,-62.617>,<-26.940,603.998,-77.740>,1.000 pigment {color C3} }
  cylinder { <-66.840,605.596,-62.617>,<-94.755,578.705,-80.531>,1.000 pigment {color C3} }
  cylinder { <-66.840,605.596,-62.617>,<-66.431,605.393,-67.847>,2.000 pigment {color C2} }
  cylinder { <-66.431,605.393,-67.847>,<-28.249,602.993,-85.177>,1.000 pigment {color C3} }
  cylinder { <-66.431,605.393,-67.847>,<-92.244,579.132,-88.049>,1.000 pigment {color C3} }
  cylinder { <-66.431,605.393,-67.847>,<-66.023,605.111,-73.073>,2.000 pigment {color C2} }
  cylinder { <-66.023,605.111,-73.073>,<-27.292,602.712,-89.140>,1.000 pigment {color C3} }
  cylinder { <-66.023,605.111,-73.073>,<-91.867,578.582,-92.881>,1.000 pigment {color C3} }
  cylinder { <-66.023,605.111,-73.073>,<-65.616,604.751,-78.295>,2.000 pigment {color C2} }
  cylinder { <-65.616,604.751,-78.295>,<-29.280,601.124,-97.588>,1.000 pigment {color C3} }
  cylinder { <-65.616,604.751,-78.295>,<-89.958,578.645,-99.072>,1.000 pigment {color C3} }
  cylinder { <-65.616,604.751,-78.295>,<-65.208,604.312,-83.511>,2.000 pigment {color C2} }
  cylinder { <-65.208,604.312,-83.511>,<-28.561,600.536,-102.176>,1.000 pigment {color C3} }
  cylinder { <-65.208,604.312,-83.511>,<-89.196,578.007,-104.448>,1.000 pigment {color C3} }
  cylinder { <-65.208,604.312,-83.511>,<-64.802,603.795,-88.720>,2.000 pigment {color C2} }
  cylinder { <-64.802,603.795,-88.720>,<-30.784,598.617,-110.268>,1.000 pigment {color C3} }
  cylinder { <-64.802,603.795,-88.720>,<-85.965,578.160,-112.029>,1.000 pigment {color C3} }
  cylinder { <-64.802,603.795,-88.720>,<-64.396,603.200,-93.920>,2.000 pigment {color C2} }
  cylinder { <-64.396,603.200,-93.920>,<-30.027,597.868,-114.865>,1.000 pigment {color C3} }
  cylinder { <-64.396,603.200,-93.920>,<-85.588,577.245,-116.845>,1.000 pigment {color C3} }
  cylinder { <-64.396,603.200,-93.920>,<-63.990,602.528,-99.111>,2.000 pigment {color C2} }
  cylinder { <-63.990,602.528,-99.111>,<-30.931,596.523,-120.630>,1.000 pigment {color C3} }
  cylinder { <-63.990,602.528,-99.111>,<-83.537,576.964,-122.699>,1.000 pigment {color C3} }
  cylinder { <-63.990,602.528,-99.111>,<-63.586,601.778,-104.291>,2.000 pigment {color C2} }
  cylinder { <-63.586,601.778,-104.291>,<-30.903,595.196,-126.212>,1.000 pigment {color C3} }
  cylinder { <-63.586,601.778,-104.291>,<-83.607,575.810,-127.025>,1.000 pigment {color C3} }
  cylinder { <-63.586,601.778,-104.291>,<-63.182,600.951,-109.460>,2.000 pigment {color C2} }
  cylinder { <-63.182,600.951,-109.460>,<-33.017,592.990,-133.195>,1.000 pigment {color C3} }
  cylinder { <-63.182,600.951,-109.460>,<-80.627,575.531,-133.670>,1.000 pigment {color C3} }
  cylinder { <-63.182,600.951,-109.460>,<-62.780,600.048,-114.616>,2.000 pigment {color C2} }
  cylinder { <-62.780,600.048,-114.616>,<-32.220,591.939,-137.790>,1.000 pigment {color C3} }
  cylinder { <-62.780,600.048,-114.616>,<-80.254,574.293,-138.448>,1.000 pigment {color C3} }
  cylinder { <-62.780,600.048,-114.616>,<-62.378,599.068,-119.758>,2.000 pigment {color C2} }
  cylinder { <-62.378,599.068,-119.758>,<-34.434,589.532,-144.465>,1.000 pigment {color C3} }
  cylinder { <-62.378,599.068,-119.758>,<-77.679,573.781,-144.430>,1.000 pigment {color C3} }
  cylinder { <-62.378,599.068,-119.758>,<-61.978,598.012,-124.885>,2.000 pigment {color C2} }
  cylinder { <-61.978,598.012,-124.885>,<-34.479,587.834,-149.834>,1.000 pigment {color C3} }
  cylinder { <-61.978,598.012,-124.885>,<-78.266,572.223,-148.376>,1.000 pigment {color C3} }
  cylinder { <-61.978,598.012,-124.885>,<-61.579,596.881,-129.996>,2.000 pigment {color C2} }
  cylinder { <-61.579,596.881,-129.996>,<-35.025,586.250,-154.709>,1.000 pigment {color C3} }
  cylinder { <-61.579,596.881,-129.996>,<-74.707,571.727,-154.972>,1.000 pigment {color C3} }
  cylinder { <-61.579,596.881,-129.996>,<-61.181,595.675,-135.091>,2.000 pigment {color C2} }
  cylinder { <-61.181,595.675,-135.091>,<-35.527,584.144,-160.345>,1.000 pigment {color C3} }
  cylinder { <-61.181,595.675,-135.091>,<-74.338,570.174,-159.696>,1.000 pigment {color C3} }
  cylinder { <-61.181,595.675,-135.091>,<-60.785,594.394,-140.166>,2.000 pigment {color C2} }
  cylinder { <-60.785,594.394,-140.166>,<-36.516,582.181,-165.431>,1.000 pigment {color C3} }
  cylinder { <-60.785,594.394,-140.166>,<-72.234,569.290,-164.967>,1.000 pigment {color C3} }
  cylinder { <-60.785,594.394,-140.166>,<-60.390,593.040,-145.223>,2.000 pigment {color C2} }
  cylinder { <-60.390,593.040,-145.223>,<-36.594,580.176,-170.614>,1.000 pigment {color C3} }
  cylinder { <-60.390,593.040,-145.223>,<-71.360,567.680,-169.981>,1.000 pigment {color C3} }
  cylinder { <-60.390,593.040,-145.223>,<-59.997,591.612,-150.260>,2.000 pigment {color C2} }
  cylinder { <-59.997,591.612,-150.260>,<-38.521,577.584,-176.086>,1.000 pigment {color C3} }
  cylinder { <-59.997,591.612,-150.260>,<-68.233,566.870,-175.656>,1.000 pigment {color C3} }
  cylinder { <-59.997,591.612,-150.260>,<-59.605,590.111,-155.276>,2.000 pigment {color C2} }
  cylinder { <-59.605,590.111,-155.276>,<-38.623,575.433,-181.146>,1.000 pigment {color C3} }
  cylinder { <-59.605,590.111,-155.276>,<-68.389,564.917,-180.035>,1.000 pigment {color C3} }
  cylinder { <-59.605,590.111,-155.276>,<-59.215,588.538,-160.269>,2.000 pigment {color C2} }
  cylinder { <-59.215,588.538,-160.269>,<-40.579,572.752,-186.307>,1.000 pigment {color C3} }
  cylinder { <-59.215,588.538,-160.269>,<-66.319,563.783,-184.991>,1.000 pigment {color C3} }
  cylinder { <-59.215,588.538,-160.269>,<-58.827,586.894,-165.240>,2.000 pigment {color C2} }
  cylinder { <-58.827,586.894,-165.240>,<-39.236,571.222,-190.638>,1.000 pigment {color C3} }
  cylinder { <-58.827,586.894,-165.240>,<-66.475,561.699,-189.349>,1.000 pigment {color C3} }
  cylinder { <-58.827,586.894,-165.240>,<-58.441,585.179,-170.187>,2.000 pigment {color C2} }
  cylinder { <-58.441,585.179,-170.187>,<-41.669,568.205,-195.792>,1.000 pigment {color C3} }
  cylinder { <-58.441,585.179,-170.187>,<-63.402,560.650,-194.656>,1.000 pigment {color C3} }
  cylinder { <-58.441,585.179,-170.187>,<-58.056,583.393,-175.109>,2.000 pigment {color C2} }
  cylinder { <-58.056,583.393,-175.109>,<-42.300,565.556,-200.772>,1.000 pigment {color C3} }
  cylinder { <-58.056,583.393,-175.109>,<-61.998,558.748,-199.646>,1.000 pigment {color C3} }
  cylinder { <-58.056,583.393,-175.109>,<-57.674,581.539,-180.006>,2.000 pigment {color C2} }
  cylinder { <-57.674,581.539,-180.006>,<-57.294,579.615,-184.876>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-75.511,601.376,-3.602>,2.000 pigment {color C2} }
  cylinder { <-75.511,601.376,-3.602>,<-49.725,595.821,-40.676>,1.000 pigment {color C3} }
  cylinder { <-75.511,601.376,-3.602>,<-104.092,575.439,20.495>,1.000 pigment {color C3} }
  cylinder { <-75.511,601.376,-3.602>,<-79.287,600.765,-7.198>,2.000 pigment {color C2} }
  cylinder { <-79.287,600.765,-7.198>,<-54.056,594.990,-44.618>,1.000 pigment {color C3} }
  cylinder { <-79.287,600.765,-7.198>,<-108.476,574.662,15.972>,1.000 pigment {color C3} }
  cylinder { <-79.287,600.765,-7.198>,<-83.056,600.077,-10.787>,2.000 pigment {color C2} }
  cylinder { <-83.056,600.077,-10.787>,<-60.004,593.883,-48.699>,1.000 pigment {color C3} }
  cylinder { <-83.056,600.077,-10.787>,<-111.941,574.244,11.692>,1.000 pigment {color C3} }
  cylinder { <-83.056,600.077,-10.787>,<-86.817,599.311,-14.369>,2.000 pigment {color C2} }
  cylinder { <-86.817,599.311,-14.369>,<-63.698,592.977,-52.217>,1.000 pigment {color C3} }
  cylinder { <-86.817,599.311,-14.369>,<-115.835,573.334,7.770>,1.000 pigment {color C3} }
  cylinder { <-86.817,599.311,-14.369>,<-90.569,598.468,-17.943>,2.000 pigment {color C2} }
  cylinder { <-90.569,598.468,-17.943>,<-71.521,591.127,-57.034>,1.000 pigment {color C3} }
  cylinder { <-90.569,598.468,-17.943>,<-120.376,572.548,1.665>,1.000 pigment {color C3} }
  cylinder { <-90.569,598.468,-17.943>,<-94.312,597.549,-21.508>,2.000 pigment {color C2} }
  cylinder { <-94.312,597.549,-21.508>,<-73.278,590.539,-59.629>,1.000 pigment {color C3} }
  cylinder { <-94.312,597.549,-21.508>,<-123.477,571.585,-1.012>,1.000 pigment {color C3} }
  cylinder { <-94.312,597.549,-21.508>,<-98.045,596.554,-25.063>,2.000 pigment {color C2} }
  cylinder { <-98.045,596.554,-25.063>,<-79.772,588.762,-63.650>,1.000 pigment {color C3} }
  cylinder { <-98.045,596.554,-25.063>,<-127.839,570.600,-7.111>,1.000 pigment {color C3} }
  cylinder { <-98.045,596.554,-25.063>,<-101.766,595.482,-28.608>,2.000 pigment {color C2} }
  cylinder { <-101.766,595.482,-28.608>,<-83.410,587.495,-67.115>,1.000 pigment {color C3} }
  cylinder { <-101.766,595.482,-28.608>,<-131.902,569.247,-11.664>,1.000 pigment {color C3} }
  cylinder { <-101.766,595.482,-28.608>,<-105.476,594.336,-32.141>,2.000 pigment {color C2} }
  cylinder { <-105.476,594.336,-32.141>,<-91.762,584.829,-71.445>,1.000 pigment {color C3} }
  cylinder { <-105.476,594.336,-32.141>,<-135.941,568.092,-17.773>,1.000 pigment {color C3} }
  cylinder { <-105.476,594.336,-32.141>,<-109.174,593.114,-35.662>,2.000 pigment {color C2} }
  cylinder { <-109.174,593.114,-35.662>,<-94.717,583.578,-74.692>,1.000 pigment {color C3} }
  cylinder { <-109.174,593.114,-35.662>,<-138.837,566.850,-19.738>,1.000 pigment {color C3} }
  cylinder { <-109.174,593.114,-35.662>,<-112.858,591.818,-39.171>,2.000 pigment {color C2} }
  cylinder { <-112.858,591.818,-39.171>,<-100.428,581.523,-77.946>,1.000 pigment {color C3} }
  cylinder { <-112.858,591.818,-39.171>,<-143.171,565.371,-27.102>,1.000 pigment {color C3} }
  cylinder { <-112.858,591.818,-39.171>,<-116.528,590.448,-42.666>,2.000 pigment {color C2} }
  cylinder { <-116.528,590.448,-42.666>,<-105.256,579.421,-81.594>,1.000 pigment {color C3} }
  cylinder { <-116.528,590.448,-42.666>,<-146.562,563.806,-30.331>,1.000 pigment {color C3} }
  cylinder { <-116.528,590.448,-42.666>,<-120.183,589.005,-46.148>,2.000 pigment {color C2} }
  cylinder { <-120.183,589.005,-46.148>,<-110.859,577.168,-84.601>,1.000 pigment {color C3} }
  cylinder { <-120.183,589.005,-46.148>,<-149.988,562.394,-35.699>,1.000 pigment {color C3} }
  cylinder { <-120.183,589.005,-46.148>,<-123.823,587.490,-49.614>,2.000 pigment {color C2} }
  cylinder { <-123.823,587.490,-49.614>,<-113.127,575.870,-87.775>,1.000 pigment {color C3} }
  cylinder { <-123.823,587.490,-49.614>,<-153.660,560.527,-40.210>,1.000 pigment {color C3} }
  cylinder { <-123.823,587.490,-49.614>,<-127.446,585.902,-53.065>,2.000 pigment {color C2} }
  cylinder { <-127.446,585.902,-53.065>,<-119.257,573.204,-90.749>,1.000 pigment {color C3} }
  cylinder { <-127.446,585.902,-53.065>,<-156.763,559.042,-44.855>,1.000 pigment {color C3} }
  cylinder { <-127.446,585.902,-53.065>,<-131.053,584.243,-56.501>,2.000 pigment {color C2} }
  cylinder { <-131.053,584.243,-56.501>,<-123.343,570.999,-94.097>,1.000 pigment {color C3} }
  cylinder { <-131.053,584.243,-56.501>,<-160.090,557.163,-48.024>,1.000 pigment {color C3} }
  cylinder { <-131.053,584.243,-56.501>,<-134.643,582.514,-59.919>,2.000 pigment {color C2} }
  cylinder { <-134.643,582.514,-59.919>,<-130.527,567.645,-96.716>,1.000 pigment {color C3} }
  cylinder { <-134.643,582.514,-59.919>,<-163.289,555.399,-53.899>,1.000 pigment {color C3} }
  cylinder { <-134.643,582.514,-59.919>,<-138.214,580.714,-63.321>,2.000 pigment {color C2} }
  cylinder { <-138.214,580.714,-63.321>,<-132.750,566.062,-100.029>,1.000 pigment {color C3} }
  cylinder { <-138.214,580.714,-63.321>,<-166.650,553.299,-57.681>,1.000 pigment {color C3} }
  cylinder { <-138.214,580.714,-63.321>,<-141.767,578.845,-66.704>,2.000 pigment {color C2} }
  cylinder { <-141.767,578.845,-66.704>,<-138.584,563.091,-102.458>,1.000 pigment {color C3} }
  cylinder { <-141.767,578.845,-66.704>,<-169.614,551.379,-64.095>,1.000 pigment {color C3} }
  cylinder { <-141.767,578.845,-66.704>,<-145.300,576.907,-70.069>,2.000 pigment {color C2} }
  cylinder { <-145.300,576.907,-70.069>,<-141.956,560.841,-105.669>,1.000 pigment {color C3} }
  cylinder { <-145.300,576.907,-70.069>,<-172.867,549.187,-67.193>,1.000 pigment {color C3} }
  cylinder { <-145.300,576.907,-70.069>,<-148.813,574.902,-73.415>,2.000 pigment {color C2} }
  cylinder { <-148.813,574.902,-73.415>,<-148.749,557.228,-107.619>,1.000 pigment {color C3} }
  cylinder { <-148.813,574.902,-73.415>,<-175.613,547.322,-71.586>,1.000 pigment {color C3} }
  cylinder { <-148.813,574.902,-73.415>,<-152.306,572.829,-76.742>,2.000 pigment {color C2} }
  cylinder { <-152.306,572.829,-76.742>,<-151.506,555.097,-110.906>,1.000 pigment {color C3} }
  cylinder { <-152.306,572.829,-76.742>,<-178.813,544.946,-75.276>,1.000 pigment {color C3} }
  cylinder { <-152.306,572.829,-76.742>,<-155.778,570.690,-80.049>,2.000 pigment {color C2} }
  cylinder { <-155.778,570.690,-80.049>,<-156.985,551.923,-112.838>,1.000 pigment {color C3} }
  cylinder { <-155.778,570.690,-80.049>,<-181.425,542.923,-80.199>,1.000 pigment {color C3} }
  cylinder { <-155.778,570.690,-80.049>,<-159.228,568.486,-83.335>,2.000 pigment {color C2} }
  cylinder { <-159.228,568.486,-83.335>,<-159.173,549.926,-116.265>,1.000 pigment {color C3} }
  cylinder { <-159.228,568.486,-83.335>,<-184.482,540.382,-84.453>,1.000 pigment {color C3} }
  cylinder { <-159.228,568.486,-83.335>,<-162.657,566.217,-86.600>,2.000 pigment {color C2} }
  cylinder { <-162.657,566.217,-86.600>,<-164.513,546.658,-118.071>,1.000 pigment {color C3} }
  cylinder { <-162.657,566.217,-86.600>,<-187.016,538.309,-88.642>,1.000 pigment {color C3} }
  cylinder { <-162.657,566.217,-86.600>,<-166.062,563.884,-89.844>,2.000 pigment {color C2} }
  cylinder { <-166.062,563.884,-89.844>,<-167.726,544.016,-121.131>,1.000 pigment {color C3} }
  cylinder { <-166.062,563.884,-89.844>,<-190.228,535.759,-91.023>,1.000 pigment {color C3} }
  cylinder { <-166.062,563.884,-89.844>,<-169.445,561.489,-93.066>,2.000 pigment {color C2} }
  cylinder { <-169.445,561.489,-93.066>,<-173.375,540.447,-122.507>,1.000 pigment {color C3} }
  cylinder { <-169.445,561.489,-93.066>,<-192.510,533.517,-96.319>,1.000 pigment {color C3} }
  cylinder { <-169.445,561.489,-93.066>,<-172.804,559.031,-96.265>,2.000 pigment {color C2} }
  cylinder { <-172.804,559.031,-96.265>,<-176.529,537.682,-125.511>,1.000 pigment {color C3} }
  cylinder { <-172.804,559.031,-96.265>,<-195.481,530.783,-99.845>,1.000 pigment {color C3} }
  cylinder { <-172.804,559.031,-96.265>,<-176.140,556.512,-99.442>,2.000 pigment {color C2} }
  cylinder { <-176.140,556.512,-99.442>,<-182.392,533.885,-126.339>,1.000 pigment {color C3} }
  cylinder { <-176.140,556.512,-99.442>,<-197.570,528.500,-104.975>,1.000 pigment {color C3} }
  cylinder { <-176.140,556.512,-99.442>,<-179.451,553.932,-102.595>,2.000 pigment {color C2} }
  cylinder { <-179.451,553.932,-102.595>,<-184.107,531.690,-130.129>,1.000 pigment {color C3} }
  cylinder { <-179.451,553.932,-102.595>,<-200.761,525.680,-107.307>,1.000 pigment {color C3} }
  cylinder { <-179.451,553.932,-102.595>,<-182.737,551.293,-105.725>,2.000 pigment {color C2} }
  cylinder { <-182.737,551.293,-105.725>,<-188.882,528.306,-131.394>,1.000 pigment {color C3} }
  cylinder { <-182.737,551.293,-105.725>,<-202.177,523.368,-113.929>,1.000 pigment {color C3} }
  cylinder { <-182.737,551.293,-105.725>,<-185.999,548.595,-108.831>,2.000 pigment {color C2} }
  cylinder { <-185.999,548.595,-108.831>,<-192.362,525.108,-133.988>,1.000 pigment {color C3} }
  cylinder { <-185.999,548.595,-108.831>,<-205.368,520.402,-116.244>,1.000 pigment {color C3} }
  cylinder { <-185.999,548.595,-108.831>,<-189.235,545.840,-111.913>,2.000 pigment {color C2} }
  cylinder { <-189.235,545.840,-111.913>,<-192.445,543.028,-114.971>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-68.708,604.199,-3.631>,2.000 pigment {color C2} }
  cylinder { <-68.708,604.199,-3.631>,<-28.436,605.471,15.955>,1.000 pigment {color C3} }
  cylinder { <-68.708,604.199,-3.631>,<-83.611,584.593,-41.055>,1.000 pigment {color C3} }
  cylinder { <-68.708,604.199,-3.631>,<-65.667,606.426,-7.285>,2.000 pigment {color C2} }
  cylinder { <-65.667,606.426,-7.285>,<-25.685,607.293,12.906>,1.000 pigment {color C3} }
  cylinder { <-65.667,606.426,-7.285>,<-79.691,587.252,-45.268>,1.000 pigment {color C3} }
  cylinder { <-65.667,606.426,-7.285>,<-62.606,608.588,-10.963>,2.000 pigment {color C2} }
  cylinder { <-62.606,608.588,-10.963>,<-21.610,610.725,5.145>,1.000 pigment {color C3} }
  cylinder { <-62.606,608.588,-10.963>,<-74.972,590.451,-49.211>,1.000 pigment {color C3} }
  cylinder { <-62.606,608.588,-10.963>,<-59.528,610.684,-14.663>,2.000 pigment {color C2} }
  cylinder { <-59.528,610.684,-14.663>,<-18.275,612.843,.774>,1.000 pigment {color C3} }
  cylinder { <-59.528,610.684,-14.663>,<-71.503,592.585,-53.053>,1.000 pigment {color C3} }
  cylinder { <-59.528,610.684,-14.663>,<-56.431,612.714,-18.384>,2.000 pigment {color C2} }
  cylinder { <-56.431,612.714,-18.384>,<-14.974,615.393,-5.827>,1.000 pigment {color C3} }
  cylinder { <-56.431,612.714,-18.384>,<-66.143,595.889,-57.194>,1.000 pigment {color C3} }
  cylinder { <-56.431,612.714,-18.384>,<-53.317,614.677,-22.127>,2.000 pigment {color C2} }
  cylinder { <-53.317,614.677,-22.127>,<-11.837,617.122,-9.597>,1.000 pigment {color C3} }
  cylinder { <-53.317,614.677,-22.127>,<-63.178,597.527,-60.756>,1.000 pigment {color C3} }
  cylinder { <-53.317,614.677,-22.127>,<-50.185,616.572,-25.891>,2.000 pigment {color C2} }
  cylinder { <-50.185,616.572,-25.891>,<-9.170,618.902,-14.245>,1.000 pigment {color C3} }
  cylinder { <-50.185,616.572,-25.891>,<-58.900,599.985,-64.260>,1.000 pigment {color C3} }
  cylinder { <-50.185,616.572,-25.891>,<-47.037,618.398,-29.675>,2.000 pigment {color C2} }
  cylinder { <-47.037,618.398,-29.675>,<-5.510,620.899,-20.052>,1.000 pigment {color C3} }
  cylinder { <-47.037,618.398,-29.675>,<-55.323,601.775,-68.123>,1.000 pigment {color C3} }
  cylinder { <-47.037,618.398,-29.675>,<-43.872,620.155,-33.478>,2.000 pigment {color C2} }
  cylinder { <-43.872,620.155,-33.478>,<-2.734,622.580,-25.369>,1.000 pigment {color C3} }
  cylinder { <-43.872,620.155,-33.478>,<-50.429,604.328,-71.825>,1.000 pigment {color C3} }
  cylinder { <-43.872,620.155,-33.478>,<-40.692,621.842,-37.299>,2.000 pigment {color C2} }
  cylinder { <-40.692,621.842,-37.299>,<.466,623.983,-29.215>,1.000 pigment {color C3} }
  cylinder { <-40.692,621.842,-37.299>,<-46.208,606.219,-75.893>,1.000 pigment {color C3} }
  cylinder { <-40.692,621.842,-37.299>,<-37.497,623.458,-41.139>,2.000 pigment {color C2} }
  cylinder { <-37.497,623.458,-41.139>,<3.484,625.686,-36.536>,1.000 pigment {color C3} }
  cylinder { <-37.497,623.458,-41.139>,<-41.878,608.272,-79.295>,1.000 pigment {color C3} }
  cylinder { <-37.497,623.458,-41.139>,<-34.288,625.002,-44.996>,2.000 pigment {color C2} }
  cylinder { <-34.288,625.002,-44.996>,<6.635,626.843,-39.746>,1.000 pigment {color C3} }
  cylinder { <-34.288,625.002,-44.996>,<-37.607,609.967,-83.318>,1.000 pigment {color C3} }
  cylinder { <-34.288,625.002,-44.996>,<-31.064,626.475,-48.870>,2.000 pigment {color C2} }
  cylinder { <-31.064,626.475,-48.870>,<9.378,628.122,-45.709>,1.000 pigment {color C3} }
  cylinder { <-31.064,626.475,-48.870>,<-32.666,612.072,-86.795>,1.000 pigment {color C3} }
  cylinder { <-31.064,626.475,-48.870>,<-27.828,627.875,-52.759>,2.000 pigment {color C2} }
  cylinder { <-27.828,627.875,-52.759>,<12.707,629.247,-50.943>,1.000 pigment {color C3} }
  cylinder { <-27.828,627.875,-52.759>,<-29.564,613.068,-90.523>,1.000 pigment {color C3} }
  cylinder { <-27.828,627.875,-52.759>,<-24.579,629.201,-56.664>,2.000 pigment {color C2} }
  cylinder { <-24.579,629.201,-56.664>,<15.304,630.232,-56.199>,1.000 pigment {color C3} }
  cylinder { <-24.579,629.201,-56.664>,<-23.414,615.445,-94.099>,1.000 pigment {color C3} }
  cylinder { <-24.579,629.201,-56.664>,<-21.318,630.454,-60.583>,2.000 pigment {color C2} }
  cylinder { <-21.318,630.454,-60.583>,<18.566,631.118,-61.437>,1.000 pigment {color C3} }
  cylinder { <-21.318,630.454,-60.583>,<-20.283,616.270,-97.863>,1.000 pigment {color C3} }
  cylinder { <-21.318,630.454,-60.583>,<-18.046,631.632,-64.516>,2.000 pigment {color C2} }
  cylinder { <-18.046,631.632,-64.516>,<21.055,631.857,-67.285>,1.000 pigment {color C3} }
  cylinder { <-18.046,631.632,-64.516>,<-15.960,617.725,-101.106>,1.000 pigment {color C3} }
  cylinder { <-18.046,631.632,-64.516>,<-14.762,632.735,-68.461>,2.000 pigment {color C2} }
  cylinder { <-14.762,632.735,-68.461>,<24.226,632.495,-72.510>,1.000 pigment {color C3} }
  cylinder { <-14.762,632.735,-68.461>,<-12.809,618.399,-104.893>,1.000 pigment {color C3} }
  cylinder { <-14.762,632.735,-68.461>,<-11.469,633.763,-72.419>,2.000 pigment {color C2} }
  cylinder { <-11.469,633.763,-72.419>,<26.473,632.921,-78.884>,1.000 pigment {color C3} }
  cylinder { <-11.469,633.763,-72.419>,<-5.518,620.724,-108.151>,1.000 pigment {color C3} }
  cylinder { <-11.469,633.763,-72.419>,<-8.167,634.715,-76.387>,2.000 pigment {color C2} }
  cylinder { <-8.167,634.715,-76.387>,<29.766,633.443,-82.840>,1.000 pigment {color C3} }
  cylinder { <-8.167,634.715,-76.387>,<-2.938,621.013,-111.984>,1.000 pigment {color C3} }
  cylinder { <-8.167,634.715,-76.387>,<-4.856,635.591,-80.366>,2.000 pigment {color C2} }
  cylinder { <-4.856,635.591,-80.366>,<32.262,633.848,-87.292>,1.000 pigment {color C3} }
  cylinder { <-4.856,635.591,-80.366>,<3.083,622.674,-114.992>,1.000 pigment {color C3} }
  cylinder { <-4.856,635.591,-80.366>,<-1.537,636.390,-84.355>,2.000 pigment {color C2} }
  cylinder { <-1.537,636.390,-84.355>,<35.309,634.057,-92.461>,1.000 pigment {color C3} }
  cylinder { <-1.537,636.390,-84.355>,<5.102,622.623,-118.927>,1.000 pigment {color C3} }
  cylinder { <-1.537,636.390,-84.355>,<1.788,637.112,-88.352>,2.000 pigment {color C2} }
  cylinder { <1.788,637.112,-88.352>,<37.638,634.208,-97.447>,1.000 pigment {color C3} }
  cylinder { <1.788,637.112,-88.352>,<9.909,623.703,-121.977>,1.000 pigment {color C3} }
  cylinder { <1.788,637.112,-88.352>,<5.120,637.757,-92.357>,2.000 pigment {color C2} }
  cylinder { <5.120,637.757,-92.357>,<40.430,634.102,-103.142>,1.000 pigment {color C3} }
  cylinder { <5.120,637.757,-92.357>,<13.689,624.067,-125.758>,1.000 pigment {color C3} }
  cylinder { <5.120,637.757,-92.357>,<8.459,638.324,-96.369>,2.000 pigment {color C2} }
  cylinder { <8.459,638.324,-96.369>,<42.682,634.065,-108.015>,1.000 pigment {color C3} }
  cylinder { <8.459,638.324,-96.369>,<20.107,625.478,-128.373>,1.000 pigment {color C3} }
  cylinder { <8.459,638.324,-96.369>,<11.802,638.813,-100.387>,2.000 pigment {color C2} }
  cylinder { <11.802,638.813,-100.387>,<45.982,634.095,-111.981>,1.000 pigment {color C3} }
  cylinder { <11.802,638.813,-100.387>,<22.207,625.151,-132.482>,1.000 pigment {color C3} }
  cylinder { <11.802,638.813,-100.387>,<15.150,639.224,-104.411>,2.000 pigment {color C2} }
  cylinder { <15.150,639.224,-104.411>,<47.514,633.523,-118.360>,1.000 pigment {color C3} }
  cylinder { <15.150,639.224,-104.411>,<27.957,626.186,-135.078>,1.000 pigment {color C3} }
  cylinder { <15.150,639.224,-104.411>,<18.501,639.557,-108.438>,2.000 pigment {color C2} }
  cylinder { <18.501,639.557,-108.438>,<50.808,633.386,-122.319>,1.000 pigment {color C3} }
  cylinder { <18.501,639.557,-108.438>,<31.721,626.207,-138.794>,1.000 pigment {color C3} }
  cylinder { <18.501,639.557,-108.438>,<21.855,639.811,-112.469>,2.000 pigment {color C2} }
  cylinder { <21.855,639.811,-112.469>,<52.428,632.755,-127.977>,1.000 pigment {color C3} }
  cylinder { <21.855,639.811,-112.469>,<36.263,626.728,-141.559>,1.000 pigment {color C3} }
  cylinder { <21.855,639.811,-112.469>,<25.211,639.987,-116.502>,2.000 pigment {color C2} }
  cylinder { <25.211,639.987,-116.502>,<55.989,632.602,-131.443>,1.000 pigment {color C3} }
  cylinder { <25.211,639.987,-116.502>,<38.442,626.124,-145.790>,1.000 pigment {color C3} }
  cylinder { <25.211,639.987,-116.502>,<28.569,640.084,-120.537>,2.000 pigment {color C2} }
  cylinder { <28.569,640.084,-120.537>,<31.927,640.102,-124.573>,2.000 pigment {color C2} }
  sphere { <-28.719,546.845,9.383>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-75.129,602.092,-3.996>,2.000 pigment {color C2} }
  cylinder { <-75.129,602.092,-3.996>,<-52.718,598.809,-41.835>,1.000 pigment {color C3} }
  cylinder { <-75.129,602.092,-3.996>,<-109.690,577.202,7.445>,1.000 pigment {color C3} }
  cylinder { <-75.129,602.092,-3.996>,<-78.531,602.196,-7.993>,2.000 pigment {color C2} }
  cylinder { <-78.531,602.196,-7.993>,<-55.468,598.753,-45.424>,1.000 pigment {color C3} }
  cylinder { <-78.531,602.196,-7.993>,<-112.263,576.961,5.047>,1.000 pigment {color C3} }
  cylinder { <-78.531,602.196,-7.993>,<-81.933,602.222,-11.992>,2.000 pigment {color C2} }
  cylinder { <-81.933,602.222,-11.992>,<-61.672,598.366,-50.178>,1.000 pigment {color C3} }
  cylinder { <-81.933,602.222,-11.992>,<-115.997,577.469,-1.482>,1.000 pigment {color C3} }
  cylinder { <-81.933,602.222,-11.992>,<-85.334,602.169,-15.990>,2.000 pigment {color C2} }
  cylinder { <-85.334,602.169,-15.990>,<-63.790,598.234,-53.459>,1.000 pigment {color C3} }
  cylinder { <-85.334,602.169,-15.990>,<-119.646,577.335,-6.527>,1.000 pigment {color C3} }
  cylinder { <-85.334,602.169,-15.990>,<-88.736,602.037,-19.987>,2.000 pigment {color C2} }
  cylinder { <-88.736,602.037,-19.987>,<-71.867,597.280,-58.924>,1.000 pigment {color C3} }
  cylinder { <-88.736,602.037,-19.987>,<-123.262,577.704,-13.734>,1.000 pigment {color C3} }
  cylinder { <-88.736,602.037,-19.987>,<-92.135,601.826,-23.983>,2.000 pigment {color C2} }
  cylinder { <-92.135,601.826,-23.983>,<-75.218,596.789,-62.864>,1.000 pigment {color C3} }
  cylinder { <-92.135,601.826,-23.983>,<-125.852,577.060,-15.436>,1.000 pigment {color C3} }
  cylinder { <-92.135,601.826,-23.983>,<-95.532,601.537,-27.975>,2.000 pigment {color C2} }
  cylinder { <-95.532,601.537,-27.975>,<-81.382,595.798,-67.101>,1.000 pigment {color C3} }
  cylinder { <-95.532,601.537,-27.975>,<-129.485,577.266,-23.278>,1.000 pigment {color C3} }
  cylinder { <-95.532,601.537,-27.975>,<-98.926,601.170,-31.964>,2.000 pigment {color C2} }
  cylinder { <-98.926,601.170,-31.964>,<-83.444,595.400,-70.578>,1.000 pigment {color C3} }
  cylinder { <-98.926,601.170,-31.964>,<-132.499,576.574,-26.317>,1.000 pigment {color C3} }
  cylinder { <-98.926,601.170,-31.964>,<-102.315,600.724,-35.948>,2.000 pigment {color C2} }
  cylinder { <-102.315,600.724,-35.948>,<-88.916,594.327,-74.486>,1.000 pigment {color C3} }
  cylinder { <-102.315,600.724,-35.948>,<-135.689,576.524,-33.442>,1.000 pigment {color C3} }
  cylinder { <-102.315,600.724,-35.948>,<-105.701,600.200,-39.926>,2.000 pigment {color C2} }
  cylinder { <-105.701,600.200,-39.926>,<-92.237,593.495,-78.390>,1.000 pigment {color C3} }
  cylinder { <-105.701,600.200,-39.926>,<-138.741,575.662,-36.475>,1.000 pigment {color C3} }
  cylinder { <-105.701,600.200,-39.926>,<-109.080,599.598,-43.899>,2.000 pigment {color C2} }
  cylinder { <-109.080,599.598,-43.899>,<-100.163,591.519,-82.674>,1.000 pigment {color C3} }
  cylinder { <-109.080,599.598,-43.899>,<-141.695,575.421,-43.530>,1.000 pigment {color C3} }
  cylinder { <-109.080,599.598,-43.899>,<-112.454,598.919,-47.864>,2.000 pigment {color C2} }
  cylinder { <-112.454,598.919,-47.864>,<-102.197,590.849,-86.309>,1.000 pigment {color C3} }
  cylinder { <-112.454,598.919,-47.864>,<-144.718,574.353,-45.895>,1.000 pigment {color C3} }
  cylinder { <-112.454,598.919,-47.864>,<-115.820,598.162,-51.820>,2.000 pigment {color C2} }
  cylinder { <-115.820,598.162,-51.820>,<-109.381,588.773,-90.062>,1.000 pigment {color C3} }
  cylinder { <-115.820,598.162,-51.820>,<-147.479,573.880,-52.217>,1.000 pigment {color C3} }
  cylinder { <-115.820,598.162,-51.820>,<-119.179,597.328,-55.768>,2.000 pigment {color C2} }
  cylinder { <-119.179,597.328,-55.768>,<-112.648,587.570,-93.901>,1.000 pigment {color C3} }
  cylinder { <-119.179,597.328,-55.768>,<-150.622,572.776,-56.542>,1.000 pigment {color C3} }
  cylinder { <-119.179,597.328,-55.768>,<-122.530,596.417,-59.706>,2.000 pigment {color C2} }
  cylinder { <-122.530,596.417,-59.706>,<-118.456,585.659,-97.180>,1.000 pigment {color C3} }
  cylinder { <-122.530,596.417,-59.706>,<-153.124,572.190,-63.399>,1.000 pigment {color C3} }
  cylinder { <-122.530,596.417,-59.706>,<-125.871,595.430,-63.633>,2.000 pigment {color C2} }
  cylinder { <-125.871,595.430,-63.633>,<-121.085,584.501,-100.973>,1.000 pigment {color C3} }
  cylinder { <-125.871,595.430,-63.633>,<-156.188,570.914,-67.692>,1.000 pigment {color C3} }
  cylinder { <-125.871,595.430,-63.633>,<-129.203,594.368,-67.549>,2.000 pigment {color C2} }
  cylinder { <-129.203,594.368,-67.549>,<-126.182,582.631,-104.092>,1.000 pigment {color C3} }
  cylinder { <-129.203,594.368,-67.549>,<-158.556,570.091,-73.143>,1.000 pigment {color C3} }
  cylinder { <-129.203,594.368,-67.549>,<-132.524,593.230,-71.452>,2.000 pigment {color C2} }
  cylinder { <-132.524,593.230,-71.452>,<-129.981,580.896,-107.835>,1.000 pigment {color C3} }
  cylinder { <-132.524,593.230,-71.452>,<-161.560,568.657,-77.397>,1.000 pigment {color C3} }
  cylinder { <-132.524,593.230,-71.452>,<-135.834,592.017,-75.343>,2.000 pigment {color C2} }
  cylinder { <-135.834,592.017,-75.343>,<-136.104,578.441,-110.620>,1.000 pigment {color C3} }
  cylinder { <-135.834,592.017,-75.343>,<-163.918,567.644,-82.130>,1.000 pigment {color C3} }
  cylinder { <-135.834,592.017,-75.343>,<-139.132,590.729,-79.219>,2.000 pigment {color C2} }
  cylinder { <-139.132,590.729,-79.219>,<-138.126,577.206,-114.503>,1.000 pigment {color C3} }
  cylinder { <-139.132,590.729,-79.219>,<-166.984,566.018,-85.734>,1.000 pigment {color C3} }
  cylinder { <-139.132,590.729,-79.219>,<-142.418,589.368,-83.081>,2.000 pigment {color C2} }
  cylinder { <-142.418,589.368,-83.081>,<-143.539,574.833,-117.197>,1.000 pigment {color C3} }
  cylinder { <-142.418,589.368,-83.081>,<-169.168,564.908,-90.991>,1.000 pigment {color C3} }
  cylinder { <-142.418,589.368,-83.081>,<-145.691,587.933,-86.927>,2.000 pigment {color C2} }
  cylinder { <-145.691,587.933,-86.927>,<-147.226,572.788,-120.760>,1.000 pigment {color C3} }
  cylinder { <-145.691,587.933,-86.927>,<-171.925,563.227,-95.745>,1.000 pigment {color C3} }
  cylinder { <-145.691,587.933,-86.927>,<-148.950,586.426,-90.757>,2.000 pigment {color C2} }
  cylinder { <-148.950,586.426,-90.757>,<-151.390,570.745,-123.516>,1.000 pigment {color C3} }
  cylinder { <-148.950,586.426,-90.757>,<-174.146,561.946,-100.288>,1.000 pigment {color C3} }
  cylinder { <-148.950,586.426,-90.757>,<-152.194,584.846,-94.571>,2.000 pigment {color C2} }
  cylinder { <-152.194,584.846,-94.571>,<-154.487,568.786,-127.156>,1.000 pigment {color C3} }
  cylinder { <-152.194,584.846,-94.571>,<-177.161,560.030,-103.832>,1.000 pigment {color C3} }
  cylinder { <-152.194,584.846,-94.571>,<-155.424,583.196,-98.366>,2.000 pigment {color C2} }
  cylinder { <-155.424,583.196,-98.366>,<-161.109,565.556,-128.879>,1.000 pigment {color C3} }
  cylinder { <-155.424,583.196,-98.366>,<-178.759,558.787,-109.948>,1.000 pigment {color C3} }
  cylinder { <-155.424,583.196,-98.366>,<-158.637,581.474,-102.144>,2.000 pigment {color C2} }
  cylinder { <-158.637,581.474,-102.144>,<-162.644,564.102,-133.073>,1.000 pigment {color C3} }
  cylinder { <-158.637,581.474,-102.144>,<-181.317,556.849,-114.542>,1.000 pigment {color C3} }
  cylinder { <-158.637,581.474,-102.144>,<-161.835,579.682,-105.902>,2.000 pigment {color C2} }
  cylinder { <-161.835,579.682,-105.902>,<-167.570,561.436,-135.214>,1.000 pigment {color C3} }
  cylinder { <-161.835,579.682,-105.902>,<-183.156,555.406,-119.359>,1.000 pigment {color C3} }
  cylinder { <-161.835,579.682,-105.902>,<-165.016,577.821,-109.641>,2.000 pigment {color C2} }
  cylinder { <-165.016,577.821,-109.641>,<-171.543,558.792,-138.282>,1.000 pigment {color C3} }
  cylinder { <-165.016,577.821,-109.641>,<-186.114,553.208,-122.835>,1.000 pigment {color C3} }
  cylinder { <-165.016,577.821,-109.641>,<-168.180,575.891,-113.360>,2.000 pigment {color C2} }
  cylinder { <-168.180,575.891,-113.360>,<-171.327,573.893,-117.057>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-75.546,602.218,3.591>,2.000 pigment {color C2} }
  cylinder { <-75.546,602.218,3.591>,<-110.197,579.278,-8.924>,1.000 pigment {color C3} }
  cylinder { <-75.546,602.218,3.591>,<-58.563,598.300,43.338>,1.000 pigment {color C3} }
  cylinder { <-75.546,602.218,3.591>,<-79.365,602.448,7.186>,2.000 pigment {color C2} }
  cylinder { <-79.365,602.448,7.186>,<-114.345,579.459,-4.281>,1.000 pigment {color C3} }
  cylinder { <-79.365,602.448,7.186>,<-62.995,598.272,47.163>,1.000 pigment {color C3} }
  cylinder { <-79.365,602.448,7.186>,<-83.187,602.600,10.782>,2.000 pigment {color C2} }
  cylinder { <-83.187,602.600,10.782>,<-117.624,579.816,-.0937>,1.000 pigment {color C3} }
  cylinder { <-83.187,602.600,10.782>,<-69.659,598.051,51.026>,1.000 pigment {color C3} }
  cylinder { <-83.187,602.600,10.782>,<-87.010,602.673,14.380>,2.000 pigment {color C2} }
  cylinder { <-87.010,602.673,14.380>,<-121.941,579.890,5.215>,1.000 pigment {color C3} }
  cylinder { <-87.010,602.673,14.380>,<-74.095,597.789,54.786>,1.000 pigment {color C3} }
  cylinder { <-87.010,602.673,14.380>,<-90.833,602.668,17.978>,2.000 pigment {color C2} }
  cylinder { <-90.833,602.668,17.978>,<-125.380,580.145,10.027>,1.000 pigment {color C3} }
  cylinder { <-90.833,602.668,17.978>,<-80.716,597.256,58.380>,1.000 pigment {color C3} }
  cylinder { <-90.833,602.668,17.978>,<-94.656,602.584,21.575>,2.000 pigment {color C2} }
  cylinder { <-94.656,602.584,21.575>,<-129.347,579.927,14.703>,1.000 pigment {color C3} }
  cylinder { <-94.656,602.584,21.575>,<-83.815,596.965,61.761>,1.000 pigment {color C3} }
  cylinder { <-94.656,602.584,21.575>,<-98.477,602.421,25.171>,2.000 pigment {color C2} }
  cylinder { <-98.477,602.421,25.171>,<-132.983,580.153,20.797>,1.000 pigment {color C3} }
  cylinder { <-98.477,602.421,25.171>,<-89.715,596.286,65.062>,1.000 pigment {color C3} }
  cylinder { <-98.477,602.421,25.171>,<-102.296,602.179,28.765>,2.000 pigment {color C2} }
  cylinder { <-102.296,602.179,28.765>,<-136.558,579.582,24.161>,1.000 pigment {color C3} }
  cylinder { <-102.296,602.179,28.765>,<-93.465,595.731,68.592>,1.000 pigment {color C3} }
  cylinder { <-102.296,602.179,28.765>,<-106.113,601.859,32.357>,2.000 pigment {color C2} }
  cylinder { <-106.113,601.859,32.357>,<-140.005,579.610,30.209>,1.000 pigment {color C3} }
  cylinder { <-106.113,601.859,32.357>,<-100.590,594.563,71.912>,1.000 pigment {color C3} }
  cylinder { <-106.113,601.859,32.357>,<-109.925,601.461,35.944>,2.000 pigment {color C2} }
  cylinder { <-109.925,601.461,35.944>,<-143.573,578.866,33.566>,1.000 pigment {color C3} }
  cylinder { <-109.925,601.461,35.944>,<-103.674,593.962,75.353>,1.000 pigment {color C3} }
  cylinder { <-109.925,601.461,35.944>,<-113.732,600.984,39.527>,2.000 pigment {color C2} }
  cylinder { <-113.732,600.984,39.527>,<-146.643,578.507,37.607>,1.000 pigment {color C3} }
  cylinder { <-113.732,600.984,39.527>,<-109.412,592.839,78.347>,1.000 pigment {color C3} }
  cylinder { <-113.732,600.984,39.527>,<-117.534,600.429,43.105>,2.000 pigment {color C2} }
  cylinder { <-117.534,600.429,43.105>,<-150.274,577.673,41.600>,1.000 pigment {color C3} }
  cylinder { <-117.534,600.429,43.105>,<-113.123,591.935,81.840>,1.000 pigment {color C3} }
  cylinder { <-117.534,600.429,43.105>,<-121.330,599.796,46.677>,2.000 pigment {color C2} }
  cylinder { <-121.330,599.796,46.677>,<-153.442,577.331,47.522>,1.000 pigment {color C3} }
  cylinder { <-121.330,599.796,46.677>,<-119.388,590.450,84.697>,1.000 pigment {color C3} }
  cylinder { <-121.330,599.796,46.677>,<-125.118,599.086,50.242>,2.000 pigment {color C2} }
  cylinder { <-125.118,599.086,50.242>,<-156.952,576.213,50.216>,1.000 pigment {color C3} }
  cylinder { <-125.118,599.086,50.242>,<-123.072,589.374,88.164>,1.000 pigment {color C3} }
  cylinder { <-125.118,599.086,50.242>,<-128.898,598.299,53.799>,2.000 pigment {color C2} }
  cylinder { <-128.898,598.299,53.799>,<-159.975,575.757,56.688>,1.000 pigment {color C3} }
  cylinder { <-128.898,598.299,53.799>,<-129.202,587.689,90.807>,1.000 pigment {color C3} }
  cylinder { <-128.898,598.299,53.799>,<-132.669,597.435,57.348>,2.000 pigment {color C2} }
  cylinder { <-132.669,597.435,57.348>,<-163.450,574.643,61.263>,1.000 pigment {color C3} }
  cylinder { <-132.669,597.435,57.348>,<-134.652,585.886,94.021>,1.000 pigment {color C3} }
  cylinder { <-132.669,597.435,57.348>,<-136.430,596.494,60.887>,2.000 pigment {color C2} }
  cylinder { <-136.430,596.494,60.887>,<-166.259,573.927,66.348>,1.000 pigment {color C3} }
  cylinder { <-136.430,596.494,60.887>,<-139.415,584.392,96.573>,1.000 pigment {color C3} }
  cylinder { <-136.430,596.494,60.887>,<-140.181,595.477,64.417>,2.000 pigment {color C2} }
  cylinder { <-140.181,595.477,64.417>,<-169.765,572.536,69.648>,1.000 pigment {color C3} }
  cylinder { <-140.181,595.477,64.417>,<-144.185,582.595,99.728>,1.000 pigment {color C3} }
  cylinder { <-140.181,595.477,64.417>,<-143.921,594.384,67.936>,2.000 pigment {color C2} }
  cylinder { <-143.921,594.384,67.936>,<-172.480,571.673,74.644>,1.000 pigment {color C3} }
  cylinder { <-143.921,594.384,67.936>,<-148.271,581.155,102.324>,1.000 pigment {color C3} }
  cylinder { <-143.921,594.384,67.936>,<-147.648,593.217,71.444>,2.000 pigment {color C2} }
  cylinder { <-147.648,593.217,71.444>,<-176.050,570.082,77.322>,1.000 pigment {color C3} }
  cylinder { <-147.648,593.217,71.444>,<-152.410,579.398,105.544>,1.000 pigment {color C3} }
  cylinder { <-147.648,593.217,71.444>,<-151.363,591.974,74.940>,2.000 pigment {color C2} }
  cylinder { <-151.363,591.974,74.940>,<-178.187,569.326,84.557>,1.000 pigment {color C3} }
  cylinder { <-151.363,591.974,74.940>,<-158.027,577.241,107.551>,1.000 pigment {color C3} }
  cylinder { <-151.363,591.974,74.940>,<-155.064,590.657,78.423>,2.000 pigment {color C2} }
  cylinder { <-155.064,590.657,78.423>,<-181.787,567.567,87.235>,1.000 pigment {color C3} }
  cylinder { <-155.064,590.657,78.423>,<-161.041,575.729,111.079>,1.000 pigment {color C3} }
  cylinder { <-155.064,590.657,78.423>,<-158.750,589.267,81.892>,2.000 pigment {color C2} }
  cylinder { <-158.750,589.267,81.892>,<-183.934,566.585,93.109>,1.000 pigment {color C3} }
  cylinder { <-158.750,589.267,81.892>,<-167.993,572.874,112.229>,1.000 pigment {color C3} }
  cylinder { <-158.750,589.267,81.892>,<-162.422,587.803,85.348>,2.000 pigment {color C2} }
  cylinder { <-162.422,587.803,85.348>,<-187.861,564.553,94.664>,1.000 pigment {color C3} }
  cylinder { <-162.422,587.803,85.348>,<-170.502,571.405,116.012>,1.000 pigment {color C3} }
  cylinder { <-162.422,587.803,85.348>,<-166.078,586.267,88.788>,2.000 pigment {color C2} }
  cylinder { <-166.078,586.267,88.788>,<-189.524,563.592,101.481>,1.000 pigment {color C3} }
  cylinder { <-166.078,586.267,88.788>,<-176.210,568.853,117.408>,1.000 pigment {color C3} }
  cylinder { <-166.078,586.267,88.788>,<-169.718,584.660,92.213>,2.000 pigment {color C2} }
  cylinder { <-169.718,584.660,92.213>,<-193.129,561.542,104.150>,1.000 pigment {color C3} }
  cylinder { <-169.718,584.660,92.213>,<-178.729,567.243,121.204>,1.000 pigment {color C3} }
  cylinder { <-169.718,584.660,92.213>,<-173.340,582.981,95.622>,2.000 pigment {color C2} }
  cylinder { <-173.340,582.981,95.622>,<-176.945,581.231,99.015>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-75.518,602.504,3.584>,2.000 pigment {color C2} }
  cylinder { <-75.518,602.504,3.584>,<-111.263,581.120,-5.810>,1.000 pigment {color C3} }
  cylinder { <-75.518,602.504,3.584>,<-60.760,599.695,43.554>,1.000 pigment {color C3} }
  cylinder { <-75.518,602.504,3.584>,<-79.314,603.022,7.174>,2.000 pigment {color C2} }
  cylinder { <-79.314,603.022,7.174>,<-115.077,581.489,-1.802>,1.000 pigment {color C3} }
  cylinder { <-79.314,603.022,7.174>,<-66.512,599.919,47.792>,1.000 pigment {color C3} }
  cylinder { <-79.314,603.022,7.174>,<-83.114,603.462,10.770>,2.000 pigment {color C2} }
  cylinder { <-83.114,603.462,10.770>,<-119.133,582.668,4.922>,1.000 pigment {color C3} }
  cylinder { <-83.114,603.462,10.770>,<-72.472,600.037,51.254>,1.000 pigment {color C3} }
  cylinder { <-83.114,603.462,10.770>,<-86.919,603.824,14.369>,2.000 pigment {color C2} }
  cylinder { <-86.919,603.824,14.369>,<-122.893,582.834,8.957>,1.000 pigment {color C3} }
  cylinder { <-86.919,603.824,14.369>,<-75.574,600.145,54.640>,1.000 pigment {color C3} }
  cylinder { <-86.919,603.824,14.369>,<-90.727,604.107,17.972>,2.000 pigment {color C2} }
  cylinder { <-90.727,604.107,17.972>,<-126.348,583.518,14.375>,1.000 pigment {color C3} }
  cylinder { <-90.727,604.107,17.972>,<-83.481,599.837,58.406>,1.000 pigment {color C3} }
  cylinder { <-90.727,604.107,17.972>,<-94.538,604.312,21.577>,2.000 pigment {color C2} }
  cylinder { <-94.538,604.312,21.577>,<-129.785,583.255,17.116>,1.000 pigment {color C3} }
  cylinder { <-94.538,604.312,21.577>,<-87.244,599.705,61.965>,1.000 pigment {color C3} }
  cylinder { <-94.538,604.312,21.577>,<-98.351,604.438,25.184>,2.000 pigment {color C2} }
  cylinder { <-98.351,604.438,25.184>,<-133.179,583.745,22.511>,1.000 pigment {color C3} }
  cylinder { <-98.351,604.438,25.184>,<-93.089,599.312,65.113>,1.000 pigment {color C3} }
  cylinder { <-98.351,604.438,25.184>,<-102.165,604.486,28.791>,2.000 pigment {color C2} }
  cylinder { <-102.165,604.486,28.791>,<-136.765,583.443,25.903>,1.000 pigment {color C3} }
  cylinder { <-102.165,604.486,28.791>,<-96.192,599.105,68.587>,1.000 pigment {color C3} }
  cylinder { <-102.165,604.486,28.791>,<-105.978,604.454,32.399>,2.000 pigment {color C2} }
  cylinder { <-105.978,604.454,32.399>,<-140.313,584.179,33.828>,1.000 pigment {color C3} }
  cylinder { <-105.978,604.454,32.399>,<-102.618,598.393,71.693>,1.000 pigment {color C3} }
  cylinder { <-105.978,604.454,32.399>,<-109.791,604.344,36.006>,2.000 pigment {color C2} }
  cylinder { <-109.791,604.344,36.006>,<-143.903,583.682,37.225>,1.000 pigment {color C3} }
  cylinder { <-109.791,604.344,36.006>,<-107.648,597.670,75.285>,1.000 pigment {color C3} }
  cylinder { <-109.791,604.344,36.006>,<-113.603,604.156,39.612>,2.000 pigment {color C2} }
  cylinder { <-113.603,604.156,39.612>,<-146.929,583.580,41.232>,1.000 pigment {color C3} }
  cylinder { <-113.603,604.156,39.612>,<-112.053,597.093,78.139>,1.000 pigment {color C3} }
  cylinder { <-113.603,604.156,39.612>,<-117.412,603.888,43.215>,2.000 pigment {color C2} }
  cylinder { <-117.412,603.888,43.215>,<-150.539,583.030,45.256>,1.000 pigment {color C3} }
  cylinder { <-117.412,603.888,43.215>,<-115.783,596.447,81.668>,1.000 pigment {color C3} }
  cylinder { <-117.412,603.888,43.215>,<-121.217,603.542,46.815>,2.000 pigment {color C2} }
  cylinder { <-121.217,603.542,46.815>,<-153.545,582.958,50.481>,1.000 pigment {color C3} }
  cylinder { <-121.217,603.542,46.815>,<-121.992,595.282,84.410>,1.000 pigment {color C3} }
  cylinder { <-121.217,603.542,46.815>,<-125.019,603.118,50.411>,2.000 pigment {color C2} }
  cylinder { <-125.019,603.118,50.411>,<-157.045,582.424,55.736>,1.000 pigment {color C3} }
  cylinder { <-125.019,603.118,50.411>,<-127.527,593.995,87.730>,1.000 pigment {color C3} }
  cylinder { <-125.019,603.118,50.411>,<-128.815,602.616,54.002>,2.000 pigment {color C2} }
  cylinder { <-128.815,602.616,54.002>,<-159.793,582.279,61.458>,1.000 pigment {color C3} }
  cylinder { <-128.815,602.616,54.002>,<-132.361,592.933,90.369>,1.000 pigment {color C3} }
  cylinder { <-128.815,602.616,54.002>,<-132.606,602.035,57.588>,2.000 pigment {color C2} }
  cylinder { <-132.606,602.035,57.588>,<-163.436,581.196,64.225>,1.000 pigment {color C3} }
  cylinder { <-132.606,602.035,57.588>,<-136.044,591.942,93.853>,1.000 pigment {color C3} }
  cylinder { <-132.606,602.035,57.588>,<-136.389,601.377,61.168>,2.000 pigment {color C2} }
  cylinder { <-136.389,601.377,61.168>,<-166.176,580.794,69.259>,1.000 pigment {color C3} }
  cylinder { <-136.389,601.377,61.168>,<-142.503,590.216,96.017>,1.000 pigment {color C3} }
  cylinder { <-136.389,601.377,61.168>,<-140.166,600.641,64.740>,2.000 pigment {color C2} }
  cylinder { <-140.166,600.641,64.740>,<-169.626,579.743,73.212>,1.000 pigment {color C3} }
  cylinder { <-140.166,600.641,64.740>,<-145.028,589.412,99.764>,1.000 pigment {color C3} }
  cylinder { <-140.166,600.641,64.740>,<-143.933,599.829,68.304>,2.000 pigment {color C2} }
  cylinder { <-143.933,599.829,68.304>,<-172.257,579.190,78.141>,1.000 pigment {color C3} }
  cylinder { <-143.933,599.829,68.304>,<-151.318,587.522,101.755>,1.000 pigment {color C3} }
  cylinder { <-143.933,599.829,68.304>,<-147.692,598.939,71.860>,2.000 pigment {color C2} }
  cylinder { <-147.692,598.939,71.860>,<-175.919,577.813,80.907>,1.000 pigment {color C3} }
  cylinder { <-147.692,598.939,71.860>,<-155.478,586.033,104.993>,1.000 pigment {color C3} }
  cylinder { <-147.692,598.939,71.860>,<-151.441,597.973,75.406>,2.000 pigment {color C2} }
  cylinder { <-151.441,597.973,75.406>,<-177.832,577.478,87.974>,1.000 pigment {color C3} }
  cylinder { <-151.441,597.973,75.406>,<-160.997,584.184,106.919>,1.000 pigment {color C3} }
  cylinder { <-151.441,597.973,75.406>,<-155.179,596.932,78.943>,2.000 pigment {color C2} }
  cylinder { <-155.179,596.932,78.943>,<-181.528,575.936,90.751>,1.000 pigment {color C3} }
  cylinder { <-155.179,596.932,78.943>,<-163.568,583.088,110.762>,1.000 pigment {color C3} }
  cylinder { <-155.179,596.932,78.943>,<-158.905,595.814,82.468>,2.000 pigment {color C2} }
  cylinder { <-158.905,595.814,82.468>,<-183.761,575.203,95.972>,1.000 pigment {color C3} }
  cylinder { <-158.905,595.814,82.468>,<-169.438,580.936,112.346>,1.000 pigment {color C3} }
  cylinder { <-158.905,595.814,82.468>,<-162.620,594.622,85.981>,2.000 pigment {color C2} }
  cylinder { <-162.620,594.622,85.981>,<-187.647,573.431,98.213>,1.000 pigment {color C3} }
  cylinder { <-162.620,594.622,85.981>,<-172.991,579.332,115.708>,1.000 pigment {color C3} }
  cylinder { <-162.620,594.622,85.981>,<-166.321,593.355,89.483>,2.000 pigment {color C2} }
  cylinder { <-166.321,593.355,89.483>,<-170.008,592.014,92.971>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-68.177,605.511,-1.402>,2.000 pigment {color C2} }
  cylinder { <-68.177,605.511,-1.402>,<-35.643,612.195,24.304>,1.000 pigment {color C3} }
  cylinder { <-68.177,605.511,-1.402>,<-53.874,605.659,-40.891>,1.000 pigment {color C3} }
  cylinder { <-68.177,605.511,-1.402>,<-64.588,609.072,-2.818>,2.000 pigment {color C2} }
  cylinder { <-64.588,609.072,-2.818>,<-31.678,615.895,22.367>,1.000 pigment {color C3} }
  cylinder { <-64.588,609.072,-2.818>,<-50.787,608.478,-42.482>,1.000 pigment {color C3} }
  cylinder { <-64.588,609.072,-2.818>,<-60.963,612.589,-4.249>,2.000 pigment {color C2} }
  cylinder { <-60.963,612.589,-4.249>,<-27.100,620.764,17.935>,1.000 pigment {color C3} }
  cylinder { <-60.963,612.589,-4.249>,<-46.405,612.559,-42.898>,1.000 pigment {color C3} }
  cylinder { <-60.963,612.589,-4.249>,<-57.302,616.064,-5.694>,2.000 pigment {color C2} }
  cylinder { <-57.302,616.064,-5.694>,<-23.356,623.978,16.457>,1.000 pigment {color C3} }
  cylinder { <-57.302,616.064,-5.694>,<-42.247,616.141,-44.152>,1.000 pigment {color C3} }
  cylinder { <-57.302,616.064,-5.694>,<-53.605,619.493,-7.154>,2.000 pigment {color C2} }
  cylinder { <-53.605,619.493,-7.154>,<-19.628,627.623,13.529>,1.000 pigment {color C3} }
  cylinder { <-53.605,619.493,-7.154>,<-35.877,621.619,-43.617>,1.000 pigment {color C3} }
  cylinder { <-53.605,619.493,-7.154>,<-49.872,622.878,-8.628>,2.000 pigment {color C2} }
  cylinder { <-49.872,622.878,-8.628>,<-15.556,631.026,11.481>,1.000 pigment {color C3} }
  cylinder { <-49.872,622.878,-8.628>,<-33.099,623.899,-45.587>,1.000 pigment {color C3} }
  cylinder { <-49.872,622.878,-8.628>,<-46.103,626.216,-10.115>,2.000 pigment {color C2} }
  cylinder { <-46.103,626.216,-10.115>,<-11.358,635.016,7.416>,1.000 pigment {color C3} }
  cylinder { <-46.103,626.216,-10.115>,<-27.688,628.363,-45.447>,1.000 pigment {color C3} }
  cylinder { <-46.103,626.216,-10.115>,<-42.298,629.507,-11.617>,2.000 pigment {color C2} }
  cylinder { <-42.298,629.507,-11.617>,<-7.685,637.753,6.436>,1.000 pigment {color C3} }
  cylinder { <-42.298,629.507,-11.617>,<-23.862,631.305,-46.957>,1.000 pigment {color C3} }
  cylinder { <-42.298,629.507,-11.617>,<-38.458,632.750,-13.133>,2.000 pigment {color C2} }
  cylinder { <-38.458,632.750,-13.133>,<-3.518,641.503,2.334>,1.000 pigment {color C3} }
  cylinder { <-38.458,632.750,-13.133>,<-17.541,636.179,-46.109>,1.000 pigment {color C3} }
  cylinder { <-38.458,632.750,-13.133>,<-34.582,635.944,-14.663>,2.000 pigment {color C2} }
  cylinder { <-34.582,635.944,-14.663>,<.248,644.157,1.335>,1.000 pigment {color C3} }
  cylinder { <-34.582,635.944,-14.663>,<-13.630,639.001,-47.653>,1.000 pigment {color C3} }
  cylinder { <-34.582,635.944,-14.663>,<-30.672,639.088,-16.207>,2.000 pigment {color C2} }
  cylinder { <-30.672,639.088,-16.207>,<4.709,648.045,-3.952>,1.000 pigment {color C3} }
  cylinder { <-30.672,639.088,-16.207>,<-9.612,642.028,-48.302>,1.000 pigment {color C3} }
  cylinder { <-30.672,639.088,-16.207>,<-26.726,642.182,-17.764>,2.000 pigment {color C2} }
  cylinder { <-26.726,642.182,-17.764>,<8.752,650.796,-5.548>,1.000 pigment {color C3} }
  cylinder { <-26.726,642.182,-17.764>,<-5.185,645.045,-49.546>,1.000 pigment {color C3} }
  cylinder { <-26.726,642.182,-17.764>,<-22.746,645.223,-19.336>,2.000 pigment {color C2} }
  cylinder { <-22.746,645.223,-19.336>,<12.614,653.829,-9.120>,1.000 pigment {color C3} }
  cylinder { <-22.746,645.223,-19.336>,<.169,648.782,-49.186>,1.000 pigment {color C3} }
  cylinder { <-22.746,645.223,-19.336>,<-18.732,648.213,-20.920>,2.000 pigment {color C2} }
  cylinder { <-18.732,648.213,-20.920>,<16.725,656.461,-10.742>,1.000 pigment {color C3} }
  cylinder { <-18.732,648.213,-20.920>,<3.791,651.105,-51.139>,1.000 pigment {color C3} }
  cylinder { <-18.732,648.213,-20.920>,<-14.683,651.149,-22.518>,2.000 pigment {color C2} }
  cylinder { <-14.683,651.149,-22.518>,<20.765,659.533,-15.484>,1.000 pigment {color C3} }
  cylinder { <-14.683,651.149,-22.518>,<9.534,654.875,-50.375>,1.000 pigment {color C3} }
  cylinder { <-14.683,651.149,-22.518>,<-10.601,654.030,-24.130>,2.000 pigment {color C2} }
  cylinder { <-10.601,654.030,-24.130>,<25.029,662.144,-17.726>,1.000 pigment {color C3} }
  cylinder { <-10.601,654.030,-24.130>,<14.061,657.588,-51.616>,1.000 pigment {color C3} }
  cylinder { <-10.601,654.030,-24.130>,<-6.486,656.856,-25.754>,2.000 pigment {color C2} }
  cylinder { <-6.486,656.856,-25.754>,<28.710,664.626,-20.676>,1.000 pigment {color C3} }
  cylinder { <-6.486,656.856,-25.754>,<19.662,661.039,-50.728>,1.000 pigment {color C3} }
  cylinder { <-6.486,656.856,-25.754>,<-2.338,659.627,-27.392>,2.000 pigment {color C2} }
  cylinder { <-2.338,659.627,-27.392>,<33.062,667.165,-23.527>,1.000 pigment {color C3} }
  cylinder { <-2.338,659.627,-27.392>,<22.718,662.747,-53.609>,1.000 pigment {color C3} }
  cylinder { <-2.338,659.627,-27.392>,<1.842,662.340,-29.042>,2.000 pigment {color C2} }
  cylinder { <1.842,662.340,-29.042>,<36.727,669.467,-26.446>,1.000 pigment {color C3} }
  cylinder { <1.842,662.340,-29.042>,<28.992,666.373,-51.870>,1.000 pigment {color C3} }
  cylinder { <1.842,662.340,-29.042>,<6.055,664.995,-30.705>,2.000 pigment {color C2} }
  cylinder { <6.055,664.995,-30.705>,<41.050,671.770,-28.724>,1.000 pigment {color C3} }
  cylinder { <6.055,664.995,-30.705>,<32.550,668.226,-54.413>,1.000 pigment {color C3} }
  cylinder { <6.055,664.995,-30.705>,<10.299,667.591,-32.380>,2.000 pigment {color C2} }
  cylinder { <10.299,667.591,-32.380>,<44.710,673.975,-32.760>,1.000 pigment {color C3} }
  cylinder { <10.299,667.591,-32.380>,<37.337,670.867,-54.362>,1.000 pigment {color C3} }
  cylinder { <10.299,667.591,-32.380>,<14.574,670.128,-34.068>,2.000 pigment {color C2} }
  cylinder { <14.574,670.128,-34.068>,<49.045,676.113,-35.051>,1.000 pigment {color C3} }
  cylinder { <14.574,670.128,-34.068>,<42.625,673.460,-54.733>,1.000 pigment {color C3} }
  cylinder { <14.574,670.128,-34.068>,<18.881,672.604,-35.768>,2.000 pigment {color C2} }
  cylinder { <18.881,672.604,-35.768>,<23.217,675.018,-37.480>,2.000 pigment {color C2} }
  sphere { <-55.691,541.177,-23.055>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-70.919,604.754,4.337>,2.000 pigment {color C2} }
  cylinder { <-70.919,604.754,4.337>,<-88.034,595.997,40.889>,1.000 pigment {color C3} }
  cylinder { <-70.919,604.754,4.337>,<-33.219,616.155,16.763>,1.000 pigment {color C3} }
  cylinder { <-70.919,604.754,4.337>,<-70.103,607.543,8.709>,2.000 pigment {color C2} }
  cylinder { <-70.103,607.543,8.709>,<-88.499,597.108,44.182>,1.000 pigment {color C3} }
  cylinder { <-70.103,607.543,8.709>,<-31.893,618.353,20.059>,1.000 pigment {color C3} }
  cylinder { <-70.103,607.543,8.709>,<-69.280,610.276,13.115>,2.000 pigment {color C2} }
  cylinder { <-69.280,610.276,13.115>,<-84.391,602.486,49.985>,1.000 pigment {color C3} }
  cylinder { <-69.280,610.276,13.115>,<-32.681,621.308,26.795>,1.000 pigment {color C3} }
  cylinder { <-69.280,610.276,13.115>,<-68.451,612.951,17.556>,2.000 pigment {color C2} }
  cylinder { <-68.451,612.951,17.556>,<-84.031,604.331,54.043>,1.000 pigment {color C3} }
  cylinder { <-68.451,612.951,17.556>,<-32.096,623.858,31.967>,1.000 pigment {color C3} }
  cylinder { <-68.451,612.951,17.556>,<-67.616,615.567,22.030>,2.000 pigment {color C2} }
  cylinder { <-67.616,615.567,22.030>,<-80.668,608.623,59.090>,1.000 pigment {color C3} }
  cylinder { <-67.616,615.567,22.030>,<-33.318,626.552,39.207>,1.000 pigment {color C3} }
  cylinder { <-67.616,615.567,22.030>,<-66.774,618.125,26.537>,2.000 pigment {color C2} }
  cylinder { <-66.774,618.125,26.537>,<-80.312,610.355,63.257>,1.000 pigment {color C3} }
  cylinder { <-66.774,618.125,26.537>,<-31.552,628.528,42.131>,1.000 pigment {color C3} }
  cylinder { <-66.774,618.125,26.537>,<-65.927,620.621,31.077>,2.000 pigment {color C2} }
  cylinder { <-65.927,620.621,31.077>,<-78.317,613.299,67.540>,1.000 pigment {color C3} }
  cylinder { <-65.927,620.621,31.077>,<-33.475,631.064,50.430>,1.000 pigment {color C3} }
  cylinder { <-65.927,620.621,31.077>,<-65.073,623.057,35.649>,2.000 pigment {color C2} }
  cylinder { <-65.073,623.057,35.649>,<-76.042,616.386,72.687>,1.000 pigment {color C3} }
  cylinder { <-65.073,623.057,35.649>,<-32.261,633.123,54.589>,1.000 pigment {color C3} }
  cylinder { <-65.073,623.057,35.649>,<-64.213,625.431,40.252>,2.000 pigment {color C2} }
  cylinder { <-64.213,625.431,40.252>,<-74.034,619.132,76.942>,1.000 pigment {color C3} }
  cylinder { <-64.213,625.431,40.252>,<-32.976,635.093,60.578>,1.000 pigment {color C3} }
  cylinder { <-64.213,625.431,40.252>,<-63.348,627.742,44.886>,2.000 pigment {color C2} }
  cylinder { <-63.348,627.742,44.886>,<-72.692,621.331,81.681>,1.000 pigment {color C3} }
  cylinder { <-63.348,627.742,44.886>,<-32.441,637.073,65.860>,1.000 pigment {color C3} }
  cylinder { <-63.348,627.742,44.886>,<-62.477,629.989,49.550>,2.000 pigment {color C2} }
  cylinder { <-62.477,629.989,49.550>,<-69.683,624.567,86.259>,1.000 pigment {color C3} }
  cylinder { <-62.477,629.989,49.550>,<-33.570,638.775,72.266>,1.000 pigment {color C3} }
  cylinder { <-62.477,629.989,49.550>,<-61.601,632.171,54.244>,2.000 pigment {color C2} }
  cylinder { <-61.601,632.171,54.244>,<-69.823,625.625,90.553>,1.000 pigment {color C3} }
  cylinder { <-61.601,632.171,54.244>,<-32.672,640.583,77.074>,1.000 pigment {color C3} }
  cylinder { <-61.601,632.171,54.244>,<-60.719,634.289,58.967>,2.000 pigment {color C2} }
  cylinder { <-60.719,634.289,58.967>,<-66.314,628.984,95.257>,1.000 pigment {color C3} }
  cylinder { <-60.719,634.289,58.967>,<-33.850,642.009,83.356>,1.000 pigment {color C3} }
  cylinder { <-60.719,634.289,58.967>,<-59.832,636.340,63.717>,2.000 pigment {color C2} }
  cylinder { <-59.832,636.340,63.717>,<-65.441,630.560,99.933>,1.000 pigment {color C3} }
  cylinder { <-59.832,636.340,63.717>,<-32.158,643.766,87.284>,1.000 pigment {color C3} }
  cylinder { <-59.832,636.340,63.717>,<-58.940,638.324,68.495>,2.000 pigment {color C2} }
  cylinder { <-58.940,638.324,68.495>,<-62.435,633.375,104.387>,1.000 pigment {color C3} }
  cylinder { <-58.940,638.324,68.495>,<-34.578,644.744,94.768>,1.000 pigment {color C3} }
  cylinder { <-58.940,638.324,68.495>,<-58.043,640.241,73.300>,2.000 pigment {color C2} }
  cylinder { <-58.043,640.241,73.300>,<-62.062,634.518,109.022>,1.000 pigment {color C3} }
  cylinder { <-58.043,640.241,73.300>,<-33.246,646.329,99.242>,1.000 pigment {color C3} }
  cylinder { <-58.043,640.241,73.300>,<-57.141,642.089,78.130>,2.000 pigment {color C2} }
  cylinder { <-57.141,642.089,78.130>,<-58.049,637.686,113.546>,1.000 pigment {color C3} }
  cylinder { <-57.141,642.089,78.130>,<-33.635,647.459,104.457>,1.000 pigment {color C3} }
  cylinder { <-57.141,642.089,78.130>,<-56.235,643.868,82.986>,2.000 pigment {color C2} }
  cylinder { <-56.235,643.868,82.986>,<-57.669,638.705,118.282>,1.000 pigment {color C3} }
  cylinder { <-56.235,643.868,82.986>,<-33.567,648.596,110.158>,1.000 pigment {color C3} }
  cylinder { <-56.235,643.868,82.986>,<-55.324,645.577,87.866>,2.000 pigment {color C2} }
  cylinder { <-55.324,645.577,87.866>,<-54.201,641.354,122.592>,1.000 pigment {color C3} }
  cylinder { <-55.324,645.577,87.866>,<-35.267,649.155,116.325>,1.000 pigment {color C3} }
  cylinder { <-55.324,645.577,87.866>,<-54.408,647.215,92.769>,2.000 pigment {color C2} }
  cylinder { <-54.408,647.215,92.769>,<-52.783,642.762,127.446>,1.000 pigment {color C3} }
  cylinder { <-54.408,647.215,92.769>,<-33.456,650.616,120.598>,1.000 pigment {color C3} }
  cylinder { <-54.408,647.215,92.769>,<-53.488,648.782,97.694>,2.000 pigment {color C2} }
  cylinder { <-53.488,648.782,97.694>,<-52.565,650.277,102.641>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-70.778,605.064,-4.086>,2.000 pigment {color C2} }
  cylinder { <-70.778,605.064,-4.086>,<-34.406,618.595,-16.017>,1.000 pigment {color C3} }
  cylinder { <-70.778,605.064,-4.086>,<-84.349,599.985,-42.012>,1.000 pigment {color C3} }
  cylinder { <-70.778,605.064,-4.086>,<-69.818,608.169,-8.209>,2.000 pigment {color C2} }
  cylinder { <-69.818,608.169,-8.209>,<-32.911,621.100,-19.117>,1.000 pigment {color C3} }
  cylinder { <-69.818,608.169,-8.209>,<-84.286,601.804,-45.606>,1.000 pigment {color C3} }
  cylinder { <-69.818,608.169,-8.209>,<-68.850,611.223,-12.368>,2.000 pigment {color C2} }
  cylinder { <-68.850,611.223,-12.368>,<-34.412,624.779,-27.275>,1.000 pigment {color C3} }
  cylinder { <-68.850,611.223,-12.368>,<-81.322,606.283,-49.946>,1.000 pigment {color C3} }
  cylinder { <-68.850,611.223,-12.368>,<-67.874,614.225,-16.564>,2.000 pigment {color C2} }
  cylinder { <-67.874,614.225,-16.564>,<-33.398,627.507,-31.630>,1.000 pigment {color C3} }
  cylinder { <-67.874,614.225,-16.564>,<-80.360,608.873,-54.080>,1.000 pigment {color C3} }
  cylinder { <-67.874,614.225,-16.564>,<-66.889,617.173,-20.795>,2.000 pigment {color C2} }
  cylinder { <-66.889,617.173,-20.795>,<-34.211,630.352,-37.974>,1.000 pigment {color C3} }
  cylinder { <-66.889,617.173,-20.795>,<-76.386,613.936,-58.689>,1.000 pigment {color C3} }
  cylinder { <-66.889,617.173,-20.795>,<-65.896,620.067,-25.061>,2.000 pigment {color C2} }
  cylinder { <-65.896,620.067,-25.061>,<-33.182,632.945,-42.397>,1.000 pigment {color C3} }
  cylinder { <-65.896,620.067,-25.061>,<-75.402,616.399,-62.913>,1.000 pigment {color C3} }
  cylinder { <-65.896,620.067,-25.061>,<-64.895,622.906,-29.362>,2.000 pigment {color C2} }
  cylinder { <-64.895,622.906,-29.362>,<-33.716,635.444,-48.147>,1.000 pigment {color C3} }
  cylinder { <-64.895,622.906,-29.362>,<-72.311,620.402,-67.058>,1.000 pigment {color C3} }
  cylinder { <-64.895,622.906,-29.362>,<-63.886,625.689,-33.698>,2.000 pigment {color C2} }
  cylinder { <-63.886,625.689,-33.698>,<-32.671,637.906,-52.635>,1.000 pigment {color C3} }
  cylinder { <-63.886,625.689,-33.698>,<-72.768,621.612,-70.937>,1.000 pigment {color C3} }
  cylinder { <-63.886,625.689,-33.698>,<-62.869,628.415,-38.068>,2.000 pigment {color C2} }
  cylinder { <-62.869,628.415,-38.068>,<-33.222,640.183,-58.350>,1.000 pigment {color C3} }
  cylinder { <-62.869,628.415,-38.068>,<-68.694,626.170,-75.349>,1.000 pigment {color C3} }
  cylinder { <-62.869,628.415,-38.068>,<-61.844,631.084,-42.471>,2.000 pigment {color C2} }
  cylinder { <-61.844,631.084,-42.471>,<-32.888,642.529,-63.904>,1.000 pigment {color C3} }
  cylinder { <-61.844,631.084,-42.471>,<-68.172,628.034,-79.613>,1.000 pigment {color C3} }
  cylinder { <-61.844,631.084,-42.471>,<-60.812,633.693,-46.908>,2.000 pigment {color C2} }
  cylinder { <-60.812,633.693,-46.908>,<-33.477,644.541,-69.526>,1.000 pigment {color C3} }
  cylinder { <-60.812,633.693,-46.908>,<-64.559,631.970,-83.778>,1.000 pigment {color C3} }
  cylinder { <-60.812,633.693,-46.908>,<-59.771,636.244,-51.377>,2.000 pigment {color C2} }
  cylinder { <-59.771,636.244,-51.377>,<-32.405,646.723,-74.130>,1.000 pigment {color C3} }
  cylinder { <-59.771,636.244,-51.377>,<-64.526,633.392,-88.061>,1.000 pigment {color C3} }
  cylinder { <-59.771,636.244,-51.377>,<-58.724,638.734,-55.879>,2.000 pigment {color C2} }
  cylinder { <-58.724,638.734,-55.879>,<-33.798,648.419,-80.575>,1.000 pigment {color C3} }
  cylinder { <-58.724,638.734,-55.879>,<-60.915,637.110,-92.177>,1.000 pigment {color C3} }
  cylinder { <-58.724,638.734,-55.879>,<-57.669,641.163,-60.412>,2.000 pigment {color C2} }
  cylinder { <-57.669,641.163,-60.412>,<-31.915,650.574,-84.352>,1.000 pigment {color C3} }
  cylinder { <-57.669,641.163,-60.412>,<-60.368,638.761,-96.633>,1.000 pigment {color C3} }
  cylinder { <-57.669,641.163,-60.412>,<-56.606,643.529,-64.977>,2.000 pigment {color C2} }
  cylinder { <-56.606,643.529,-64.977>,<-33.743,651.932,-91.075>,1.000 pigment {color C3} }
  cylinder { <-56.606,643.529,-64.977>,<-56.262,642.538,-100.661>,1.000 pigment {color C3} }
  cylinder { <-56.606,643.529,-64.977>,<-55.537,645.833,-69.572>,2.000 pigment {color C2} }
  cylinder { <-55.537,645.833,-69.572>,<-31.412,654.086,-94.558>,1.000 pigment {color C3} }
  cylinder { <-55.537,645.833,-69.572>,<-55.703,644.080,-105.228>,1.000 pigment {color C3} }
  cylinder { <-55.537,645.833,-69.572>,<-54.461,648.073,-74.196>,2.000 pigment {color C2} }
  cylinder { <-54.461,648.073,-74.196>,<-33.258,655.186,-101.119>,1.000 pigment {color C3} }
  cylinder { <-54.461,648.073,-74.196>,<-51.627,647.580,-109.078>,1.000 pigment {color C3} }
  cylinder { <-54.461,648.073,-74.196>,<-53.378,650.248,-78.850>,2.000 pigment {color C2} }
  cylinder { <-53.378,650.248,-78.850>,<-32.153,656.940,-105.864>,1.000 pigment {color C3} }
  cylinder { <-53.378,650.248,-78.850>,<-50.546,649.286,-113.722>,1.000 pigment {color C3} }
  cylinder { <-53.378,650.248,-78.850>,<-52.288,652.358,-83.532>,2.000 pigment {color C2} }
  cylinder { <-52.288,652.358,-83.532>,<-51.192,654.401,-88.242>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-76.553,603.162,1.649>,2.000 pigment {color C2} }
  cylinder { <-76.553,603.162,1.649>,<-112.413,592.724,-12.390>,1.000 pigment {color C3} }
  cylinder { <-76.553,603.162,1.649>,<-91.076,599.545,38.635>,1.000 pigment {color C3} }
  cylinder { <-76.553,603.162,1.649>,<-81.394,604.342,3.304>,2.000 pigment {color C2} }
  cylinder { <-81.394,604.342,3.304>,<-117.107,593.477,-10.785>,1.000 pigment {color C3} }
  cylinder { <-81.394,604.342,3.304>,<-96.472,600.406,40.035>,1.000 pigment {color C3} }
  cylinder { <-81.394,604.342,3.304>,<-86.250,605.446,4.965>,2.000 pigment {color C2} }
  cylinder { <-86.250,605.446,4.965>,<-121.959,594.819,-7.224>,1.000 pigment {color C3} }
  cylinder { <-86.250,605.446,4.965>,<-103.932,601.404,39.716>,1.000 pigment {color C3} }
  cylinder { <-86.250,605.446,4.965>,<-91.121,606.476,6.630>,2.000 pigment {color C2} }
  cylinder { <-91.121,606.476,6.630>,<-126.170,595.114,-6.753>,1.000 pigment {color C3} }
  cylinder { <-91.121,606.476,6.630>,<-108.168,601.995,41.644>,1.000 pigment {color C3} }
  cylinder { <-91.121,606.476,6.630>,<-96.006,607.429,8.300>,2.000 pigment {color C2} }
  cylinder { <-96.006,607.429,8.300>,<-131.455,596.551,-2.056>,1.000 pigment {color C3} }
  cylinder { <-96.006,607.429,8.300>,<-115.468,602.712,41.182>,1.000 pigment {color C3} }
  cylinder { <-96.006,607.429,8.300>,<-100.904,608.306,9.975>,2.000 pigment {color C2} }
  cylinder { <-100.904,608.306,9.975>,<-136.604,597.247,.731>,1.000 pigment {color C3} }
  cylinder { <-100.904,608.306,9.975>,<-120.297,603.161,42.834>,1.000 pigment {color C3} }
  cylinder { <-100.904,608.306,9.975>,<-105.814,609.107,11.654>,2.000 pigment {color C2} }
  cylinder { <-105.814,609.107,11.654>,<-141.071,598.048,3.686>,1.000 pigment {color C3} }
  cylinder { <-105.814,609.107,11.654>,<-126.358,603.617,42.905>,1.000 pigment {color C3} }
  cylinder { <-105.814,609.107,11.654>,<-110.734,609.830,13.336>,2.000 pigment {color C2} }
  cylinder { <-110.734,609.830,13.336>,<-146.156,598.550,6.488>,1.000 pigment {color C3} }
  cylinder { <-110.734,609.830,13.336>,<-131.198,603.903,44.560>,1.000 pigment {color C3} }
  cylinder { <-110.734,609.830,13.336>,<-115.664,610.476,15.022>,2.000 pigment {color C2} }
  cylinder { <-115.664,610.476,15.022>,<-150.788,599.385,10.584>,1.000 pigment {color C3} }
  cylinder { <-115.664,610.476,15.022>,<-137.159,604.162,44.593>,1.000 pigment {color C3} }
  cylinder { <-115.664,610.476,15.022>,<-120.602,611.045,16.710>,2.000 pigment {color C2} }
  cylinder { <-120.602,611.045,16.710>,<-155.566,599.481,12.218>,1.000 pigment {color C3} }
  cylinder { <-120.602,611.045,16.710>,<-142.006,604.286,46.250>,1.000 pigment {color C3} }
  cylinder { <-120.602,611.045,16.710>,<-125.548,611.536,18.402>,2.000 pigment {color C2} }
  cylinder { <-125.548,611.536,18.402>,<-159.971,600.019,15.682>,1.000 pigment {color C3} }
  cylinder { <-125.548,611.536,18.402>,<-148.766,604.274,45.478>,1.000 pigment {color C3} }
  cylinder { <-125.548,611.536,18.402>,<-130.500,611.948,20.095>,2.000 pigment {color C2} }
  cylinder { <-130.500,611.948,20.095>,<-164.577,599.774,16.153>,1.000 pigment {color C3} }
  cylinder { <-130.500,611.948,20.095>,<-154.490,604.130,46.331>,1.000 pigment {color C3} }
  cylinder { <-130.500,611.948,20.095>,<-135.458,612.282,21.790>,2.000 pigment {color C2} }
  cylinder { <-135.458,612.282,21.790>,<-169.079,600.325,20.735>,1.000 pigment {color C3} }
  cylinder { <-135.458,612.282,21.790>,<-159.293,604.105,47.078>,1.000 pigment {color C3} }
  cylinder { <-135.458,612.282,21.790>,<-140.420,612.538,23.487>,2.000 pigment {color C2} }
  cylinder { <-140.420,612.538,23.487>,<-173.813,600.028,21.796>,1.000 pigment {color C3} }
  cylinder { <-140.420,612.538,23.487>,<-165.346,603.722,47.474>,1.000 pigment {color C3} }
  cylinder { <-140.420,612.538,23.487>,<-145.384,612.715,25.184>,2.000 pigment {color C2} }
  cylinder { <-145.384,612.715,25.184>,<-178.108,600.310,25.734>,1.000 pigment {color C3} }
  cylinder { <-145.384,612.715,25.184>,<-171.171,603.352,46.918>,1.000 pigment {color C3} }
  cylinder { <-145.384,612.715,25.184>,<-150.351,612.814,26.882>,2.000 pigment {color C2} }
  cylinder { <-150.351,612.814,26.882>,<-182.915,600.173,29.078>,1.000 pigment {color C3} }
  cylinder { <-150.351,612.814,26.882>,<-174.910,603.186,49.886>,1.000 pigment {color C3} }
  cylinder { <-150.351,612.814,26.882>,<-155.319,612.834,28.581>,2.000 pigment {color C2} }
  cylinder { <-155.319,612.834,28.581>,<-160.286,612.775,30.279>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-76.067,603.585,-2.436>,2.000 pigment {color C2} }
  cylinder { <-76.067,603.585,-2.436>,<-87.085,604.803,-40.036>,1.000 pigment {color C3} }
  cylinder { <-76.067,603.585,-2.436>,<-113.849,594.270,2.293>,1.000 pigment {color C3} }
  cylinder { <-76.067,603.585,-2.436>,<-80.425,605.191,-4.883>,2.000 pigment {color C2} }
  cylinder { <-80.425,605.191,-4.883>,<-91.456,606.010,-42.490>,1.000 pigment {color C3} }
  cylinder { <-80.425,605.191,-4.883>,<-118.218,595.671,-.674>,1.000 pigment {color C3} }
  cylinder { <-80.425,605.191,-4.883>,<-84.802,606.725,-7.342>,2.000 pigment {color C2} }
  cylinder { <-84.802,606.725,-7.342>,<-98.040,607.236,-43.491>,1.000 pigment {color C3} }
  cylinder { <-84.802,606.725,-7.342>,<-122.286,598.032,-6.063>,1.000 pigment {color C3} }
  cylinder { <-84.802,606.725,-7.342>,<-89.199,608.188,-9.811>,2.000 pigment {color C2} }
  cylinder { <-89.199,608.188,-9.811>,<-101.846,608.266,-46.174>,1.000 pigment {color C3} }
  cylinder { <-89.199,608.188,-9.811>,<-126.304,598.401,-6.705>,1.000 pigment {color C3} }
  cylinder { <-89.199,608.188,-9.811>,<-93.613,609.577,-12.290>,2.000 pigment {color C2} }
  cylinder { <-93.613,609.577,-12.290>,<-107.769,609.255,-47.338>,1.000 pigment {color C3} }
  cylinder { <-93.613,609.577,-12.290>,<-130.317,600.542,-12.074>,1.000 pigment {color C3} }
  cylinder { <-93.613,609.577,-12.290>,<-98.044,610.893,-14.779>,2.000 pigment {color C2} }
  cylinder { <-98.044,610.893,-14.779>,<-112.767,610.135,-49.586>,1.000 pigment {color C3} }
  cylinder { <-98.044,610.893,-14.779>,<-134.631,601.397,-14.497>,1.000 pigment {color C3} }
  cylinder { <-98.044,610.893,-14.779>,<-102.492,612.135,-17.277>,2.000 pigment {color C2} }
  cylinder { <-102.492,612.135,-17.277>,<-119.136,610.873,-50.410>,1.000 pigment {color C3} }
  cylinder { <-102.492,612.135,-17.277>,<-138.422,603.103,-19.246>,1.000 pigment {color C3} }
  cylinder { <-102.492,612.135,-17.277>,<-106.955,613.303,-19.783>,2.000 pigment {color C2} }
  cylinder { <-106.955,613.303,-19.783>,<-124.119,611.557,-52.627>,1.000 pigment {color C3} }
  cylinder { <-106.955,613.303,-19.783>,<-142.778,603.980,-22.268>,1.000 pigment {color C3} }
  cylinder { <-106.955,613.303,-19.783>,<-111.432,614.395,-22.298>,2.000 pigment {color C2} }
  cylinder { <-111.432,614.395,-22.298>,<-130.315,612.046,-53.328>,1.000 pigment {color C3} }
  cylinder { <-111.432,614.395,-22.298>,<-146.409,605.459,-26.958>,1.000 pigment {color C3} }
  cylinder { <-111.432,614.395,-22.298>,<-115.923,615.413,-24.820>,2.000 pigment {color C2} }
  cylinder { <-115.923,615.413,-24.820>,<-134.772,612.599,-55.832>,1.000 pigment {color C3} }
  cylinder { <-115.923,615.413,-24.820>,<-150.824,605.668,-28.267>,1.000 pigment {color C3} }
  cylinder { <-115.923,615.413,-24.820>,<-120.426,616.354,-27.349>,2.000 pigment {color C2} }
  cylinder { <-120.426,616.354,-27.349>,<-140.810,612.875,-56.451>,1.000 pigment {color C3} }
  cylinder { <-120.426,616.354,-27.349>,<-154.362,607.116,-33.475>,1.000 pigment {color C3} }
  cylinder { <-120.426,616.354,-27.349>,<-124.941,617.219,-29.885>,2.000 pigment {color C2} }
  cylinder { <-124.941,617.219,-29.885>,<-145.277,613.268,-58.959>,1.000 pigment {color C3} }
  cylinder { <-124.941,617.219,-29.885>,<-158.620,607.803,-37.065>,1.000 pigment {color C3} }
  cylinder { <-124.941,617.219,-29.885>,<-129.467,618.007,-32.426>,2.000 pigment {color C2} }
  cylinder { <-129.467,618.007,-32.426>,<-150.706,613.430,-59.866>,1.000 pigment {color C3} }
  cylinder { <-129.467,618.007,-32.426>,<-162.284,608.443,-39.947>,1.000 pigment {color C3} }
  cylinder { <-129.467,618.007,-32.426>,<-134.002,618.718,-34.973>,2.000 pigment {color C2} }
  cylinder { <-134.002,618.718,-34.973>,<-155.179,613.668,-62.378>,1.000 pigment {color C3} }
  cylinder { <-134.002,618.718,-34.973>,<-166.605,608.817,-42.973>,1.000 pigment {color C3} }
  cylinder { <-134.002,618.718,-34.973>,<-138.546,619.352,-37.525>,2.000 pigment {color C2} }
  cylinder { <-138.546,619.352,-37.525>,<-143.098,619.908,-40.082>,2.000 pigment {color C2} }
  sphere { <-54.091,535.691,-21.567>,12.000 pigment { color C4} }
  cylinder { <-71.729,601.908,0.000>,<-75.936,603.867,2.455>,2.000 pigment {color C2} }
  cylinder { <-75.936,603.867,2.455>,<-113.887,597.417,1.832>,1.000 pigment {color C3} }
  cylinder { <-75.936,603.867,2.455>,<-88.255,607.238,38.775>,1.000 pigment {color C3} }
  cylinder { <-75.936,603.867,2.455>,<-80.166,605.757,4.924>,2.000 pigment {color C2} }
  cylinder { <-80.166,605.757,4.924>,<-118.037,598.856,4.254>,1.000 pigment {color C3} }
  cylinder { <-80.166,605.757,4.924>,<-91.326,608.637,41.658>,1.000 pigment {color C3} }
  cylinder { <-80.166,605.757,4.924>,<-84.419,607.578,7.406>,2.000 pigment {color C2} }
  cylinder { <-84.419,607.578,7.406>,<-121.670,601.536,9.561>,1.000 pigment {color C3} }
  cylinder { <-84.419,607.578,7.406>,<-97.748,610.151,42.684>,1.000 pigment {color C3} }
  cylinder { <-84.419,607.578,7.406>,<-88.693,609.330,9.901>,2.000 pigment {color C2} }
  cylinder { <-88.693,609.330,9.901>,<-125.868,602.820,12.011>,1.000 pigment {color C3} }
  cylinder { <-88.693,609.330,9.901>,<-101.470,611.470,45.411>,1.000 pigment {color C3} }
  cylinder { <-88.693,609.330,9.901>,<-92.988,611.012,12.407>,2.000 pigment {color C2} }
  cylinder { <-92.988,611.012,12.407>,<-129.349,605.026,16.707>,1.000 pigment {color C3} }
  cylinder { <-92.988,611.012,12.407>,<-107.812,612.746,46.373>,1.000 pigment {color C3} }
  cylinder { <-92.988,611.012,12.407>,<-97.304,612.623,14.926>,2.000 pigment {color C2} }
  cylinder { <-97.304,612.623,14.926>,<-133.588,606.160,19.181>,1.000 pigment {color C3} }
  cylinder { <-97.304,612.623,14.926>,<-112.146,613.932,48.902>,1.000 pigment {color C3} }
  cylinder { <-97.304,612.623,14.926>,<-101.639,614.163,17.456>,2.000 pigment {color C2} }
  cylinder { <-101.639,614.163,17.456>,<-136.968,608.145,23.828>,1.000 pigment {color C3} }
  cylinder { <-101.639,614.163,17.456>,<-118.897,614.934,49.495>,1.000 pigment {color C3} }
  cylinder { <-101.639,614.163,17.456>,<-105.992,615.630,19.997>,2.000 pigment {color C2} }
  cylinder { <-105.992,615.630,19.997>,<-141.304,608.937,25.762>,1.000 pigment {color C3} }
  cylinder { <-105.992,615.630,19.997>,<-122.730,615.986,52.319>,1.000 pigment {color C3} }
  cylinder { <-105.992,615.630,19.997>,<-110.363,617.025,22.548>,2.000 pigment {color C2} }
  cylinder { <-110.363,617.025,22.548>,<-144.419,611.079,31.454>,1.000 pigment {color C3} }
  cylinder { <-110.363,617.025,22.548>,<-129.316,616.732,52.801>,1.000 pigment {color C3} }
  cylinder { <-110.363,617.025,22.548>,<-114.752,618.346,25.110>,2.000 pigment {color C2} }
  cylinder { <-114.752,618.346,25.110>,<-148.930,611.559,32.872>,1.000 pigment {color C3} }
  cylinder { <-114.752,618.346,25.110>,<-134.673,617.482,54.722>,1.000 pigment {color C3} }
  cylinder { <-114.752,618.346,25.110>,<-119.156,619.594,27.680>,2.000 pigment {color C2} }
  cylinder { <-119.156,619.594,27.680>,<-152.025,613.302,37.928>,1.000 pigment {color C3} }
  cylinder { <-119.156,619.594,27.680>,<-140.064,618.086,55.708>,1.000 pigment {color C3} }
  cylinder { <-119.156,619.594,27.680>,<-123.576,620.767,30.260>,2.000 pigment {color C2} }
  cylinder { <-123.576,620.767,30.260>,<-156.225,614.147,40.993>,1.000 pigment {color C3} }
  cylinder { <-123.576,620.767,30.260>,<-143.542,618.935,58.947>,1.000 pigment {color C3} }
  cylinder { <-123.576,620.767,30.260>,<-128.009,621.865,32.848>,2.000 pigment {color C2} }
  cylinder { <-128.009,621.865,32.848>,<-132.457,622.888,35.443>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-72.384,605.413,-3.853>,2.000 pigment {color C2} }
  cylinder { <-72.384,605.413,-3.853>,<-52.533,623.334,-30.567>,1.000 pigment {color C3} }
  cylinder { <-72.384,605.413,-3.853>,<-90.668,608.867,-36.756>,1.000 pigment {color C3} }
  cylinder { <-72.384,605.413,-3.853>,<-73.045,608.874,-7.745>,2.000 pigment {color C2} }
  cylinder { <-73.045,608.874,-7.745>,<-52.208,626.406,-33.961>,1.000 pigment {color C3} }
  cylinder { <-73.045,608.874,-7.745>,<-91.750,611.515,-40.486>,1.000 pigment {color C3} }
  cylinder { <-73.045,608.874,-7.745>,<-73.713,612.291,-11.675>,2.000 pigment {color C2} }
  cylinder { <-73.713,612.291,-11.675>,<-55.830,629.489,-39.258>,1.000 pigment {color C3} }
  cylinder { <-73.713,612.291,-11.675>,<-89.978,616.493,-44.753>,1.000 pigment {color C3} }
  cylinder { <-73.713,612.291,-11.675>,<-74.387,615.661,-15.643>,2.000 pigment {color C2} }
  cylinder { <-74.387,615.661,-15.643>,<-56.536,632.583,-43.418>,1.000 pigment {color C3} }
  cylinder { <-74.387,615.661,-15.643>,<-91.092,619.069,-48.594>,1.000 pigment {color C3} }
  cylinder { <-74.387,615.661,-15.643>,<-75.068,618.986,-19.649>,2.000 pigment {color C2} }
  cylinder { <-75.068,618.986,-19.649>,<-59.127,635.334,-47.997>,1.000 pigment {color C3} }
  cylinder { <-75.068,618.986,-19.649>,<-89.734,623.443,-52.664>,1.000 pigment {color C3} }
  cylinder { <-75.068,618.986,-19.649>,<-75.755,622.263,-23.693>,2.000 pigment {color C2} }
  cylinder { <-75.755,622.263,-23.693>,<-59.846,638.316,-52.227>,1.000 pigment {color C3} }
  cylinder { <-75.755,622.263,-23.693>,<-90.870,625.941,-56.601>,1.000 pigment {color C3} }
  cylinder { <-75.755,622.263,-23.693>,<-76.448,625.491,-27.775>,2.000 pigment {color C2} }
  cylinder { <-76.448,625.491,-27.775>,<-63.462,640.788,-57.301>,1.000 pigment {color C3} }
  cylinder { <-76.448,625.491,-27.775>,<-88.607,630.820,-60.914>,1.000 pigment {color C3} }
  cylinder { <-76.448,625.491,-27.775>,<-77.148,628.670,-31.893>,2.000 pigment {color C2} }
  cylinder { <-77.148,628.670,-31.893>,<-64.192,643.648,-61.597>,1.000 pigment {color C3} }
  cylinder { <-77.148,628.670,-31.893>,<-88.854,633.928,-65.207>,1.000 pigment {color C3} }
  cylinder { <-77.148,628.670,-31.893>,<-77.854,631.800,-36.049>,2.000 pigment {color C2} }
  cylinder { <-77.854,631.800,-36.049>,<-67.255,645.886,-66.285>,1.000 pigment {color C3} }
  cylinder { <-77.854,631.800,-36.049>,<-87.480,637.834,-69.154>,1.000 pigment {color C3} }
  cylinder { <-77.854,631.800,-36.049>,<-78.566,634.878,-40.242>,2.000 pigment {color C2} }
  cylinder { <-78.566,634.878,-40.242>,<-67.474,648.709,-70.419>,1.000 pigment {color C3} }
  cylinder { <-78.566,634.878,-40.242>,<-89.142,639.864,-73.231>,1.000 pigment {color C3} }
  cylinder { <-78.566,634.878,-40.242>,<-79.285,637.904,-44.472>,2.000 pigment {color C2} }
  cylinder { <-79.285,637.904,-44.472>,<-80.010,640.878,-48.737>,2.000 pigment {color C2} }
  cylinder { <-71.729,601.908,0.000>,<-75.909,604.312,-2.075>,2.000 pigment {color C2} }
  cylinder { <-75.909,604.312,-2.075>,<-94.132,610.497,-33.795>,1.000 pigment {color C3} }
  cylinder { <-75.909,604.312,-2.075>,<-112.975,602.736,-2.359>,1.000 pigment {color C3} }
  cylinder { <-75.909,604.312,-2.075>,<-80.118,606.654,-4.165>,2.000 pigment {color C2} }
  cylinder { <-80.118,606.654,-4.165>,<-97.356,612.348,-36.520>,1.000 pigment {color C3} }
  cylinder { <-80.118,606.654,-4.165>,<-117.162,604.633,-4.438>,1.000 pigment {color C3} }
  cylinder { <-80.118,606.654,-4.165>,<-84.354,608.932,-6.269>,2.000 pigment {color C2} }
  cylinder { <-84.354,608.932,-6.269>,<-103.889,614.273,-36.515>,1.000 pigment {color C3} }
  cylinder { <-84.354,608.932,-6.269>,<-120.567,607.918,-9.814>,1.000 pigment {color C3} }
  cylinder { <-84.354,608.932,-6.269>,<-88.617,611.146,-8.386>,2.000 pigment {color C2} }
  cylinder { <-88.617,611.146,-8.386>,<-108.712,616.080,-38.333>,1.000 pigment {color C3} }
  cylinder { <-88.617,611.146,-8.386>,<-124.815,609.673,-11.924>,1.000 pigment {color C3} }
  cylinder { <-88.617,611.146,-8.386>,<-92.908,613.296,-10.517>,2.000 pigment {color C2} }
  cylinder { <-92.908,613.296,-10.517>,<-115.034,617.679,-38.188>,1.000 pigment {color C3} }
  cylinder { <-92.908,613.296,-10.517>,<-128.221,612.033,-15.605>,1.000 pigment {color C3} }
  cylinder { <-92.908,613.296,-10.517>,<-97.224,615.379,-12.660>,2.000 pigment {color C2} }
  cylinder { <-97.224,615.379,-12.660>,<-119.401,619.322,-40.357>,1.000 pigment {color C3} }
  cylinder { <-97.224,615.379,-12.660>,<-132.445,613.856,-18.283>,1.000 pigment {color C3} }
  cylinder { <-97.224,615.379,-12.660>,<-101.565,617.396,-14.816>,2.000 pigment {color C2} }
  cylinder { <-101.565,617.396,-14.816>,<-125.101,620.691,-40.510>,1.000 pigment {color C3} }
  cylinder { <-101.565,617.396,-14.816>,<-135.701,616.206,-22.451>,1.000 pigment {color C3} }
  cylinder { <-101.565,617.396,-14.816>,<-105.931,619.346,-16.984>,2.000 pigment {color C2} }
  cylinder { <-105.931,619.346,-16.984>,<-128.644,622.273,-43.452>,1.000 pigment {color C3} }
  cylinder { <-105.931,619.346,-16.984>,<-140.155,617.501,-24.077>,1.000 pigment {color C3} }
  cylinder { <-105.931,619.346,-16.984>,<-110.320,621.227,-19.164>,2.000 pigment {color C2} }
  cylinder { <-110.320,621.227,-19.164>,<-114.733,623.040,-21.356>,2.000 pigment {color C2} }
}

#declare P_Cloud2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.35 green 0.55 blue 0.75
                    color red 0.35 green 0.55 blue 0.65]
        [0.1, 0.5   color red 0.55 green 0.75 blue 0.85
                    color rgb <0.258, 0.258, 0.635>  ]
        [0.5, 1.001 color rgb <0.258, 0.258, 0.635>
                    color rgb <0.258, 0.258, 0.635> ]
    }
    scale <6, 1, 6>
}

#declare P_Cloud3 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.55 green 0.55 blue 0.75
                    color red 0.25 green 0.40 blue 0.75]
        [0.1, 0.5   color red 0.45 green 0.60 blue 0.95
                    color rgb <0.184, 0.184, 0.609> ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.609>
                    color rgb <0.1, 0.1, 0.2>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare S_Cloud1 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.547, 0.649, 0.977> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.35> rotate z*10]
        }
    }
}


