// ----------------- Funny 1-person spacecraft -------------
// bound box : <-150,-75,-180> to <150,75,180>
// ship facing +x

#declare Space_Metal = texture
{
   pigment { color White }
   finish 
   { 
      ambient 0.2 
      diffuse 0.8 
      brilliance 2
      // reflection 0.3
      metallic
      phong 1
   }
}

#declare Black_Spots = texture
{
   pigment
   {
      spotted
      turbulence 0.6
      color_map
      {
         [0.0 color rgbf<1,1,1,1>]
         [0.4 color rgbf<1,1,1,1>]
         [1.0 color rgbf<0,0,0,0.5>]
      }
   }
   scale 20
}

#declare Space_Glass = texture
{
   pigment { color White filter 0.80}
   finish 
   { 
      // refraction 1
      // ior 1.51
      ambient 0 
      diffuse 0
      // reflection 0.4
      phong 1
   }
}

#declare Laser_Texture = texture
{
   pigment { color rgb <1,0,0.4> }
   finish
   {
      ambient 0.8
      diffuse 0.3
      brilliance 1
      phong 1
   }
}

#declare Dark_Metal = texture
{
   pigment {color rgb <0.5,0.5,0.5> }
   finish
   {
      ambient 0.2
      diffuse 0.8
      brilliance 2
      metallic
      phong 1
   }
}

#declare Chair_Cloth = texture
{
   pigment { color rgb <0.7,0,0> }
   finish
   {
      ambient 0.3
      diffuse 0.7
      brilliance 0.4
   }
}

#declare Side_Screen = texture
{
   pigment {checker color Yellow color Black scale 4}
   finish {ambient 1 diffuse 0}
}
#declare Back_Screen = texture
{
   pigment {checker color Red color Black scale 10}
   finish {ambient 1 diffuse 0}
}
#declare Holo_Screen = texture
{
   pigment {checker color Blue color Black scale 8}
   finish {ambient 1 diffuse 0}
}
#declare Main_Screen = texture
{
   pigment {checker color rgb <1,0,1> color Black scale 4}
   finish {ambient 1 diffuse 0}
}

// hull 
#declare Hull = object
{
   difference
   {
      // outside
      
      object
      {
         union
         {
            intersection      // front
            {
               sphere {<0,0,0> 1 scale <150,75,90>}
               box {<0,-75,-90> <150,75,90>}
            }
            cylinder {<0.1,0,0> <-50.1,0,0> 1 scale <1,75,90>}    // mid
            intersection     // back
            {
               sphere {<0,0,0> 1 scale <150,75,90>}
               box {<-150,-75,-90> <0,75,90>}
               translate <-50,0,0>
            }
            // tailstrips
            difference
            {
               box {<-50,0,-5> <-200,75,5> rotate <45,0,0>}
               sphere {<0,0,0> 1 scale <150,75,90>}
            }
            difference
            {
               box {<-50,0,-5> <-200,75,5> rotate <-45,0,0>}
               sphere {<0,0,0> 1 scale <150,75,90>}
            }
         }
         texture {Space_Metal}
         texture {Black_Spots}
      }
      
      // inside

      object 
      {
         union
         {
            sphere {<0,0,0> 1 scale <140,65,80> }      // front
            box {<50,0,-90> <150,75,90> }        // cockpit

            cylinder {<20,0,0> <-70,0,0> 1 scale <1,65,80>}    // mid
            // sphere {<0,0,0> 1 scale <140,65,80> }    // back
               
            cylinder {<-250,0,0> <-150,0,0> 40 }     // hole for engine
         }
         texture {Space_Metal}
      }
   }     // end difference
}  // end hull

// canopy
#declare Canopy = object
{
   intersection
   {
      sphere {<0,0,0> 1 scale <145,70,85>}
      sphere {<0,0,0> 1 scale <140,65,80> inverse}
      box {<50,0,-90> <150,75,90>}
   }
   texture { Space_Glass }
}

// wing bulb cannons
#declare LaserTorch = object
{
   union
   {
      sphere {<40,0,0> 8}
      cylinder {<40,0,0> <90,0,0> 2}
   }
   texture {Laser_Texture}
}

#declare WingBulb = object
{
   union
   {
      object 
      {
         difference
         {
            union
            {
               sphere {<0,0,0> 1 scale <50,30,30>}
               box {<-50,-29.9,-3> <0,29.9,3>}
               box {<-50,-3,-29.9> <0,3,29.9>}
            }
            cylinder { <40,0,0> <60,0,0> 9}
         }
         texture {Space_Metal}
         texture {Black_Spots}
      }
      object {LaserTorch}
   }
}

// wings 
#declare Lwing = object
{
   difference
   {
      union
      {
         cylinder {<0,0,80> <-35,0,150> 15}
         cylinder {<-50,0,80> <-50,0,150> 15}
         intersection
         {
            box {<-50,-15,80> <0,15,150>}
            plane {<2,0,1> 0 translate <0,0,80>}
         }
      }
      sphere {<0,0,0> 1 scale <145,70,85> }   // dont go through hull
   }
   texture {Space_Metal}
   texture {Black_Spots}
}

#declare Rwing = object
{
   difference
   {
      union
      {
         cylinder {<0,0,-80> <-35,0,-150> 15}
         cylinder {<-50,0,-80> <-50,0,-150> 15}
         intersection
         {
            box {<-50,-15,-80> <0,15,-150>}
            plane {<2,0,-1> 0 translate <0,0,-80>}
         }
      }
      sphere {<0,0,0> 1 scale <145,70,85> }     // not through hull
   }
   texture {Space_Metal}
   texture {Black_Spots}
}

#declare Motor = object
{
   difference
   {
      union
      {
         cylinder {<-215,0,0> <-150,0,0> 25 }
         box {<-215,0,-5> <-150,32,5> rotate <0,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <45,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <90,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <135,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <180,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <225,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <270,0,0> }
         box {<-215,0,-5> <-150,32,5> rotate <315,0,0> }
      }
      cylinder {<-230,0,0> <-140,0,0> 18 }
   }
   texture {Dark_Metal}
}

#declare ChairBase = object
{
   union
   {
      box {<0,-5,-20> <50,5,20>}            // sit here
      cylinder {<0,0,-20> <0,0,20> 5}       // round edge
      cylinder {<50,0,-20> <50,0,20> 5}
      union    // legs and feet
      {
         box {<0,-5,-20> <30,5,20> }         // lie here
         cylinder {<30,0,-20> <30,0,20> 5}   // round edge
         box {<30,-5,20> <35,15,10>}         // feet
         box {<30,-5,-20> <35,15,-10>}       // feet
         rotate <0,0,-15>
         translate <50,0,0>
      }
      union    // back and head
      {
         box {<-60,-5,-20> <0,5,20> }       // lie here
         cylinder {<-20,5,-20> <-40,5,-20> 5}  // back/side
         cylinder {<-20,5,20> <-40,5,20> 5}    // back/size
         cylinder {<-60,0,-20> <-60,0,20> 5}   //  round edge
         union
         {
            cylinder {<0,0,-8> <-8,0,-8> 2.5}   // stick
            cylinder {<0,0,8> <-8,0,8> 2.5}   // stick
            box {<-8,-5,-12> <-30,8,12>}      // head
            rotate <0,0,-15>
            translate <-60,0,0>
         }
         rotate <0,0,-80>
         translate <0,0,0>
      }
      rotate <0,0,15>
   }
   texture {Space_Metal}
}

#declare ChairCover = object
{
   union
   {
      box {<0,5,-18> <50,7,18>}            // sit here
      box {<0,5,-18> <30,7,18> rotate <0,0,-15> translate <50,0,0> }  // lie here
      union    // rug en hoofd steun
      {
         box {<-60,5,-20> <0,7,20> }       // lie
         box {<-8,8,-12> <-30,10,12> rotate <0,0,-15> translate <-60,0,0> }  // head
         rotate <0,0,-80>
         translate <0,0,0>
      }
      rotate <0,0,15>
   }
   
   texture {Chair_Cloth}
}

#declare ChairSide = object
{
   union
   {
      // metal side
      object 
      {
         difference
         {
            box {<-10,0,-20> <30,20,-30> }
            box {<0,18,-22> <25,22,-28>}
         }
         texture { Space_Metal }
      }
      
      // computer console screen
      object
      {
         box {<0,18,-22> <25,20,-28>}
         texture {Side_Screen}
      }
   }
}

#declare Chair = object
{
   union
   {
      object {ChairBase}
      object {ChairCover}
      object {ChairSide translate <15,0,0>}
      object {ChairSide translate <15,0,50>}
   }
}

#declare BackMonitor1 = object
{
   union
   {
      object
      {
         intersection
         {
            box {<-10,-20,-50> <40,20,-80>}
            box {<-5,-15,-55> <35,15,-40> inverse }
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      object
      {
         box {<-5,-15,-55> <35,15,-50> inverse }
         texture { Back_Screen }
      }
   }
}

#declare BackMonitor2 = object
{
   union
   {
      object
      {
         intersection
         {
            box {<-10,-20,50> <40,20,80>}
            box {<-5,-15,55> <35,15,40> inverse }
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      object
      {
         box {<-5,-15,55> <35,15,50> inverse }
         texture { Back_Screen }
      }
   }
}

#declare HoloSphere1 = object
{
   union
   {
      object
      {
         intersection
         {
            intersection
            {
               sphere {<0,0,0> 10}
               box {<-10,-10,0> <10,10,10>}
               rotate <0,45,0>
               translate <120,0,30>
            }
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      
      object
      {
         intersection
         {
            sphere {<0,0,0> 8}
            box {<-10,-10,-10> <10,10,0>}
            rotate <0,45,0>
            translate <120,0,30>
         }
         texture { Holo_Screen }
      }
   }
}

#declare HoloSphere2 = object
{
   union
   {
      object
      {
         intersection
         {
            intersection
            {
               sphere {<0,0,0> 10}
               box {<-10,-10,0> <10,10,10>}
               rotate <0,-225,0>
               translate <120,0,-30>
            }
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      
      object
      {
         intersection
         {
            sphere {<0,0,0> 8}
            box {<-10,-10,-10> <10,10,0>}
            rotate <0,-225,0>
            translate <120,0,-30>
         }
         texture { Holo_Screen }
      }
   }
}

#declare SpaceFillers = object
{
   union
   {
      object
      {
         intersection
         {
            cylinder {<70,-75,-90> <75,-75,-90> 75}
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      object
      {
         intersection
         {
            cylinder {<70,-75,90> <75,-75,90> 75}
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
      object
      {
         intersection
         {
            cylinder {<150,-75,-2.5> <150,-75,2.5> 75}
            sphere {<0,0,0> 1 scale <140,65,80> }
         }
         texture {Space_Metal}
      }
   }
}

#declare ConsoleArm = object
{
   union
   {
      cylinder {<0,0,0> <0,35,0> 3.5}
      sphere {<0,35,0> 3.5}
      cylinder {<0,35,0> <0,35,-30> 3.5}
      sphere {<0,35,-30> 3.5}
      cylinder {<0,35,-30> <-10,35,-30> 3.5}
      intersection
      {
         cylinder {<-20,40,-17> <-20,40,-43> 10}
         box {<0,-10,-13> <10,10,13> rotate <0,0,-45> translate <-20,40,-30>}
      }
   }
   texture {Space_Metal}
}

#declare ConsoleMonitor = object
{
   box {<-2,-8,-11> <0,8,11> }
   texture { Main_Screen }
   rotate <0,0,-45> 
   translate <-20,40,-30>
}

#declare MainConsole = object
{
   union
   {
      object {ConsoleArm}
      object {ConsoleMonitor}
      rotate <0,-30,0>
      translate <50,-45,30>
   }
}

#declare SpaceShip = object
{
   union
   {
      object {Hull}
      object {Canopy}
      object {Lwing}
      object {Rwing}
      object {WingBulb translate <-25,0,150>}
      object {WingBulb translate <-25,0,-150>}
      object {Motor}
      object {Chair translate <0,-45,0>}
      object {BackMonitor1}
      object {BackMonitor2}
      object {HoloSphere1}
      object {HoloSphere2}
      object {SpaceFillers}
      object {MainConsole}
   }  
}

// -------------- solid version of spaceship ----------------
// --------------- for cutting a hole in the ground ----------

// solidhull

#declare SolidHull = object
{
   union
   {
      intersection
      {
         sphere {<0,0,0> 1 scale <150,75,90>}         // front
         box {<0,-75,-90> <150,75,90>}
      }
      cylinder {<0.1,0,0> <-50.1,0,0> 1 scale <1,75,90>}      // mid
      intersection
      {
         sphere {<0,0,0> 1 scale <150,75,90>}
         box {<-150,-75,-90> <0,75,90>}
      }
   }
   // texture {Space_Metal}
}
