#version 3.0
global_settings { 
   assumed_gamma 2.2 
   max_trace_level 6
}

#include "colors.inc"
// #include "textures.inc"
// #include "shapes.inc"
#include "crash.inc"

camera {
   direction <0, 0, 2.0>
   up <0, 1, 0>
   right <1.33, 0, 0>
   location <400, 250, 600>
   look_at <-25, 100, 0>
}

object
{
   light_source { <7500, 10000, 11500> color rgb <1,1,1> }
}

// ------------- texture declarations -------------

#declare GreenWater = texture
{
   pigment {color rgbf <0.0, 1.0, 0.50, 0.60>}
   finish
   {
      diffuse 0.3
      ambient 0
      reflection 0.6
      // refraction 1
      // ior 1.33
      specular 1
      roughness 0.003      
   }
   normal { 
      ripples 0.2
      frequency 50
      scale 1000 
   }
}

#declare Sand = texture
{
   pigment {color rgb<0.7,0.4,0.4>}
   normal { bumps 0.3 scale 8/60 }
   finish {crand 0.045}
}

#declare Growth = texture
{
   pigment {color rgb<0.2,0.60,0.2>}
   normal { bumps 1 scale 1/60 }
}

#declare Ground = texture 
{
   spotted
   turbulence 0.4
   texture_map
   {
      [0.0 Sand]
      [0.7 Sand]
      [0.7 Growth]
      [1.0 Growth]
   }
   scale 60
}

// ------------- constants -----------------
#declare ShipAngle1 = transform { rotate <-20,0,0> }
#declare ShipAngle2 = transform { rotate <0,-80,0> }
#declare ShipTrans = transform { translate <-25,100,0> }

#declare PoolLevel = 50

// ----------- landscape ---------
object 
{
   difference
   {
      height_field
      {
         tga "crash_hf.tga"
         smooth
         // water_level PoolLevel/900
         translate <-.5,0,-.5>
         scale <1800,900,1800>
         rotate <0,90,0>
      }
      object  { SolidHull 
         transform ShipAngle1
         transform ShipAngle2
         transform ShipTrans
         texture {Sand}
      }
   }
   texture {Ground}
}

// ---------- the ship ------------
object {
   object {SpaceShip}
   transform ShipAngle1
   transform ShipAngle2
   transform ShipTrans
}

// object {light_source {<-10,64,0> color rgb 1}}

// ------- pool ---------
object 
{
   difference
   {
      box {<-18000,0,-1800> <1800,PoolLevel,1800>}
      object  { SolidHull 
         transform ShipAngle1
         transform ShipAngle2
         transform ShipTrans
         texture {Sand}
      }
   }
   texture {GreenWater}
}

// ---- steam  ----

object
{
   sphere {<0,0,0> 1.5}
   hollow
   pigment {color rgbt<1,1,1,1>}
   halo
   {
      attenuating
      spherical_mapping
      linear
      samples 10
      aa_level 1
      aa_threshold .3
      jitter 0
      
      turbulence 1
      lambda 2
      omega 0.5
      
      color_map
      {
         [0.0 color rgbt<1,1,1,1>]
         [0.5 color rgbt<1,1,1,0.25>]
         [1.0 color rgbt<1,1,1,1>]
      }
      frequency 3
      scale 1
   }
   scale 60
   translate <50,55,-150>
   transform ShipAngle1
   transform ShipAngle2
   transform ShipTrans
}





