//Crash landing on a red planet
//by Brian Naughton 1996
//turn on the area light only if you have a very fast computer or days to spare
//same goes for smoothed height_field, but to a lesser extent
//pointless except on very high res. images

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"

#declare Number = 1
#declare Count = 1
#declare Counter = 1
#declare Counteile = 1

#declare Cam =
camera {
location <-15.4,17,-51> 
look_at <-15.4,8,0>
}

#declare ZoomCam =
camera {
location <-16,4,-50>
look_at <-16,0,0>
}

camera {Cam}

light_source{
<0,0,0> colour rgb <1,.865,.865>
//area_light <200,0,0>,<0,200,0>,6,6 
//adaptive 1 jitter 
rotate <45,45,0> translate <800,400,-800>
}


#declare Seeit =
texture {pigment {colour rgb <0,1,0>}finish {ambient 1}}

#declare FPSurfaceTex =
texture {
pigment {
bozo turbulence .8
colour_map {
[0 .5 colour rgb <.8,.2,.2> colour rgb <.6,.2,.2>]
[.5 1 colour rgb <.6,.2,.2> colour rgb <.8,.2,.2>]}}
normal {bump_map {gif "fprints.gif" bump_size 10 map_type 0 }
rotate <90,0,0> scale 1.2/2000}
finish {specular .1 roughness .2 crand .01}
translate <.5,0,0>
}

#declare NOFPSurfaceTex =
texture {
pigment {
bozo turbulence .8
colour_map {
[0 .5 colour rgb <.8,.2,.2> colour rgb <.6,.2,.2>]
[.5 1 colour rgb <.6,.2,.2> colour rgb <.8,.2,.2>]}}
finish {specular .1 roughness .2 crand .01}
}

#declare SurfaceTex =
texture {
gradient x
texture_map {
[0 NOFPSurfaceTex]
[.5 NOFPSurfaceTex]
[.5 FPSurfaceTex] 
[.5+(1.2/2000) FPSurfaceTex]
[.5+(1.2/2000) NOFPSurfaceTex]
[1 NOFPSurfaceTex]}
}

height_field { 
png "hf.png"
//smooth
texture {SurfaceTex}
translate <-.5,0,-.5>
scale <2000,350,2000>
}  

#declare RedCost =
texture {
pigment {colour Gray05}
finish {phong .65 phong_size 100}
}

#declare BlueCost =
texture {
pigment {colour rgb <.9,.9,.9>}
normal {wrinkles .8 scale <3,.7,.7>}
finish {ambient .1 phong .4 phong_size 30 reflection .15}
}

#declare BeltTex =
texture {
pigment {colour Gray05}
finish {phong .65 phong_size 100}
}

#declare CostumeTex =
texture {
gradient y
texture_map {
[.28 RedCost]
[.28 BeltTex]
[.32 BeltTex]
[.32 BlueCost]
[1.01 BlueCost]}
}

#declare HighArm =
blob {
threshold .8
cylinder {<0,0,0><0,-1,0>,.8,1 scale <.5,1,1>}
sphere {<0,0,0>,.5,1 scale <.4,1.3,.75> translate <0,-.4,-.1>}
texture {BlueCost}
}

#declare LowArm =
blob {
threshold .8
cylinder {<0,0,0><0,-.8,0>,.8,1 scale <.5,1,1>}
sphere {<0,0,0>,.24,1 scale <.4,1.5,1> translate <.07,-.4,0>}
texture {BlueCost}
}


#declare HighLeg =
blob {
threshold .8
cylinder {<0,0,0><0,-1.15,0>,1,1 scale <.5,1,1>}
sphere {<0,0,0>,.7,1 scale <.4,1.3,.75> translate <0,-.4,.1>}
texture {BlueCost}
}

#declare LowLeg =
blob {
threshold .8
cylinder {<0,0,0><0,-.8,0>,.95,1 scale <.5,1,1>}
sphere {<0,0,0>,.3,1 scale <.4,1.5,1> translate <.08,-.4,0>}
texture {BlueCost}
}

#declare Boot =
difference {
blob {
cylinder {<0,0,0><0,-1,0>,1,1.2 scale <.54,1,1>}
sphere {<0,0,0>,1,1.2 scale <.54,.4,1> translate <0,-1,-.5>}}
box {<-2,-1,-2><2,-4,2>}
texture {RedCost}
}

#declare Hand =
blob {
threshold .7
sphere {<0,0,0>,.8,1 scale <.3,1,.8>}
cylinder {<0,0,0><0,-.35,0>,.05,1 scale <1,1,1> rotate <70,0,0>}
cylinder {<0,0,0><0,-.35,0>,.05,1 scale <1,1.3,1> rotate <40,0,0>}
cylinder {<0,0,0><0,-.35,0>,.05,1 scale <1,1.5,1> rotate <0,0,0>}
cylinder {<0,0,0><0,-.35,0>,.05,1 scale <1,1.25,1> rotate <-30,0,0>}
texture {RedCost}
}

#declare Torso =
lathe {
cubic_spline
9,
<0,1>
<.6,.96>
<.7,.93>
<.75,.8>
<.86,.64>
<.93,.45>
<1,.3>//middle
<.8,.1>
<0,0>
sturm
texture {CostumeTex}
}

#declare LeftArm =
union {
object {HighArm}
object {LowArm translate <0,-.8,0>}
object {Hand translate <0,-2,0>}
}

#declare RightArm =
union {
object {HighArm}
object {LowArm translate <0,-.8,0>}
object {Hand translate <0,-2,0>}
}

#declare LeftLeg =
union {
object {HighLeg}
object {LowLeg translate <0,-1.3,0>}
object {Boot translate <0,-2.2,0>}
scale <1.4,1,1.4>
}

#declare RightLeg =
union {
object {HighLeg}
object {LowLeg translate <0,-1.3,0>}
object {Boot translate <0,-2.2,0>}
scale <1.4,1,1.4>
}

#declare HelmetTex =
texture {
pigment {rgb <.8,.8,.8>}
finish {specular .7 roughness .05 metallic
ambient .2 diffuse .5 brilliance 5 reflection .6}
}

#declare Helmet =
object {sphere {<0,0,0>,1.26}}

#declare Tank =
union {
cylinder {<0,.9,0><0,2.7,0>,.36}
sphere {<0,2.7,0>,.36}
texture {HelmetTex}
}

#declare Tanks =
union {
object {Tank translate <-.2,0,1.275>}
object {Tank translate <.2,0,1.275>}
}

#declare Man =
union {
object {LeftLeg translate <.5,0,0>}

object {RightLeg translate <-.5,0,0>}

object {LeftArm rotate <0,0,20> translate <.7,3,0> }

object {RightArm rotate <0,0,-20> translate <-.7,3,0> }

object {Torso scale <1,3.33333333,1.4>}

object {Tanks}

object {Helmet translate <0,4.3,0> 
texture {HelmetTex}}

}

object {Man rotate <0,180,0> translate <0,3.2,0> scale 1}

#declare ShipTex =
texture {
pigment {colour rgb <.7,.5,.25>}
normal {dents .4}
finish {ambient .3 brilliance 3 diffuse .4 metallic specular .7 
roughness .03 reflection .4}
}

#declare ShipTex2 =
texture {
pigment {colour rgb <.5,.3,.15>}
finish {ambient .3 brilliance 3 diffuse .4 metallic specular .8 
roughness .06 reflection .3}
}

#declare ShipTex3 =
texture {
pigment {colour rgb <.7,.7,.6>}
finish {ambient .17 brilliance 5 diffuse .6 metallic specular .83 
roughness .005 reflection .4}
}

#declare Ship =
difference {
union {
cylinder {<0,0,0><0,1,0>,.4}
cylinder {<0,1,0><0,.9,0>,.44 texture {ShipTex2}}
cylinder {<.4,1,0><.4,.6,0>,.06 rotate <0,0,0>}
cylinder {<.4,1,0><.4,.6,0>,.06 rotate <0,90,0>}
cylinder {<.4,1,0><.4,.6,0>,.06 rotate <0,180,0>}
cylinder {<.4,1,0><.4,.6,0>,.06 rotate <0,270,0>}
sphere {<.4,.6,0>,.06 rotate <0,0,0>}
sphere {<.4,.6,0>,.06 rotate <0,90,0>}
sphere {<.4,.6,0>,.06 rotate <0,180,0>}
sphere {<.4,.6,0>,.06 rotate <0,270,0>}
torus {.43,.01 translate <0,.8,0>}

#while (Number<=30)
union {sphere {<.4,0,0>,.012}sphere {<.4,0,0>,.012 rotate <0,90,0>}
sphere {<.4,0,0>,.012 rotate <0,180,0>}sphere {<.4,0,0>,.012 rotate <0,270,0>}
texture {ShipTex2} translate <0,.02*Number,0>}
#declare Number = Number + 1
#end

difference {
cone {<0,1,0>,.25<0,1.08,0>,.3}cone {<0,.99,0>,.248<0,1.09,0>,.298}
texture {radial texture_map{[0 ShipTex ][.9 ShipTex]
[.9 pigment {colour Black}][1 pigment {colour Black}]}frequency 60}
}

sphere {<0,0,0>,1 hollow
texture {
pigment {colour rgbt 1}
halo {
dust dust_type 2
samples 9
aa_level 2
aa_threshold .3
jitter .13
turbulence .65
spherical_mapping
poly exponent 1.2
colour_map {
[0 colour rgbt <1,1,1,1>]
[1 colour rgbt <1,1,1,.3>]}
}
scale .8}
scale <.36,.5,.36>
translate <0,1.25,0>} //end of halo object
texture {ShipTex}
}//end of union

sphere {<.4,.5,0>,.1 rotate <0,45,0> texture {ShipTex3}}
sphere {<.4,.5,0>,.1 rotate <0,135,0> texture {ShipTex3}}
sphere {<.4,.5,0>,.1 rotate <0,225,0> texture {ShipTex3}}
sphere {<.4,.5,0>,.1 rotate <0,315,0> texture {ShipTex3}}
torus {.4,.02 translate <0,.5,0>}
texture {ShipTex}
}//end of difference

object {Ship scale <16,24,16> rotate <-6,0,6> translate <-32,-1,-4>}


#declare Rock =
box {<-.5,-.5,-.5><.5,.5,.5>}

#declare Rock2 =
sphere {0,.5}

#declare R1 = seed(124)

//Rocks unearthed...
#while (Count<=360)
union {
object {Rock rotate <rand(R1)*90,rand(R1)*90,rand(R1)*90> 
scale .05 scale rand(R1)/5+.9 translate <.42,0,0> rotate <0,Count,0>}
object {Rock rotate <rand(R1)*90,rand(R1)*90,rand(R1)*90> 
scale .05 scale rand(R1)/5+.9 translate <.44,0,0> rotate <0,Count,0>}
object {Rock rotate <rand(R1)*90,rand(R1)*90,rand(R1)*90> 
scale .05 scale rand(R1)/5+.9 translate <.47,0,0> rotate <0,Count,0>}
object {Rock rotate <rand(R1)*90,rand(R1)*90,rand(R1)*90> 
scale .05 scale rand(R1)/5+.9 translate <.5+(rand(R1)/7.5),0,0> rotate <0,Count,0>}

texture {pigment {colour rgbf <.1,.1,.1,.86>}} texture {NOFPSurfaceTex}
scale <16,24,16> rotate <0,0,0> translate <-32,1,-4>
}
#declare Count = Count + 1
#end

//Scattered rocks, slightly further from the ship... 
#while (Counter<=70)
object {Rock rotate <(rand(R1)*4)+43,0,(rand(R1)*4)+43> scale .04 
scale (rand(R1)/5)+.78 translate <0,-.01,0>
translate <.5+(rand(R1)/2.6),0,0> rotate <0,rand(R1)*360,0>
texture {pigment {colour rgbf <.1,.1,.1,.86>}} texture {NOFPSurfaceTex}
scale <16,24,16> rotate <0,0,0> translate <-32,1,-4>
}
#declare Counter = Counter + 1
#end

//Rocks strewn everywhere...
#while (Counteile<=400)
object {
object {Rock rotate <rand(R1)*10+40,0,rand(R1)*10+40> 
scale 1.2 scale rand(R1)/4+.875 translate <0,0,rand(R1)*450> rotate <0,rand(R1)*180,0>
translate <-70,.14+(rand(R1)/28),80>}
texture {NOFPSurfaceTex}
}
#declare Counteile = Counteile + 1
#end

//Sky
sky_sphere {
pigment {
bozo
turbulence .5
colour_map {
[0 colour rgb <.808,.373,.255>]
[.5 colour rgb <.647,.365,.255>]
[1 colour rgb <.490,.243,.259>]}
scale <1,.4,1>}
}

#declare Moon =
union {
object {
sphere {0,1}
texture {
pigment {rgb <.63,.4,.4>}
normal {wrinkles .8 scale <1,.1,.1>}
finish {specular .3 roughness .3 reflection .2}
}
} 
object {
sphere {0,1.5 hollow}
texture {
pigment {colour rgbt 1}
halo {
attenuating
samples 4
aa_level 1
aa_threshold .5
jitter .1
turbulence .16
poly exponent .52
spherical_mapping
colour_map {
[0 colour rgbt <.65,.43,.43,1>]
[1 colour rgbt <1,1,1,.5>]}
scale 1.4} 
} 
}
}
//Doesn't look right
//object {Moon scale 130 translate <1500,850,4000>}
