//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 2 lights, 14 textures and 99 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.0.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 09/21/1996    (21.09.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera Camera01
  location  <53.014, -11.874, 6.672>
  direction <0.0,     0.0,  3.7717>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <9.830, -1.626, 6.339>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <34.097, -21.323, 8.000> // Attached to SpotL001
  direction <0.0,     0.0,  2.1663>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <33.253, -20.792, 7.919> // Following SpotL001
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight SpotL001
  <34.097, -21.323, 8.000>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <33.253, -20.792, 7.919>
    falloff   13.0  // outer radius (in deg)
      radius    9.7  // inner radius
}

light_source {   // Light001
  <40.409, -20.192, 30.087>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "crawler.inc"



// ********  REFERENCED OBJECTS  *******

#declare Laser = object {
  cylinder { // Laser
    <0,0,1>, <0,0,0>, 1 
    texture {
      LaserBeam
    }
    no_shadow
    scale <0.03, 0.03, 20.0>
    rotate 90.0*y
    translate  <6.405153, -0.779388, 2.4>
  }
}


#declare TailPivot1 = object {
  sphere { // TailPivot1
    <0,0,0>,1
    scale 0.5
    translate  <-4.65, 2.0, 2.5>
  }
}




// ********  OBJECTS  *******

object { // Laser1->Laser
  Laser
  rotate <0.0, 0.0, 0.0>
  translate  <-0.004685, 1.628627, 0.0>
}


object { Laser }


sphere { // Windshield1
  <0,0,0>,1
  texture {
    Glass1
  }
  scale <0.400446, 0.583873, 0.267673>
  translate  <5.246339, 0.0, 2.747453>
}


object {   // GroundPlane
  height_field {
    tga "D:\MORAY\MAPS\TERRAIN.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Texture01
  }
  scale <50.0, 37.596901, 5.0>
  rotate 16.454899*z
  translate  <-1.433626, 1.410356, 3.927857>
}


#declare Gun1 = union {
  cylinder { // Shield1
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 1.0>
  }
  cylinder { // Barrel1
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 1.5>
  }
  texture {
    GUnBlack1
  }
  rotate <90.0, 0.0, 90.0>
  translate  <5.0, 2.8, 2.4>
}
#declare Gun = union {
  cylinder { // Shield
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 1.0>
  }
  cylinder { // Barrel
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 1.5>
  }
  texture {
    GUnBlack1
  }
  rotate <90.0, 0.0, 90.0>
  translate  <5.0, 1.17, 2.4>
}
// The following include file contains the definition for Head
#include "crawler.in1"
#declare Head = object {
  Head_Raw
  scale <1.0, 1.0, 3.0>
  rotate <90.0, 0.0, -90.0>
  translate  <7.5, 2.0, 2.0>
}
#declare HeadUnit = union {
  object { Gun1 }
  object { Gun }
  cylinder { // Neck
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.5, 0.5, 1.5>
    rotate <-90.0, 0.0, -90.0>
    translate  <3.5, 2.0, 2.3>
  }
  object { Head }
}
#declare Stinger = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.834910, 0.000000, -0.021394>, <-0.834910, -0.000506, -0.021394>, <-0.834282, -0.000920, -0.021394>, <-0.833515, -0.000920, -0.021394>, 
      <-0.020959, 0.000000, 0.500000>, <-0.020959, -0.013283, 0.500000>, <-0.011527, -0.024151, 0.500000>, <0.000000, -0.024151, 0.500000>, 
      <-0.090904, 0.000000, 1.000000>, <-0.090904, -0.053110, 1.000000>, <-0.049997, -0.096564, 1.000000>, <0.000000, -0.096564, 1.000000>, 
      <-0.195473, -0.005022, 1.500000>, <-0.195473, -0.116185, 1.500000>, <-0.107510, -0.207136, 1.500000>, <0.000000, -0.207136, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.833515, -0.000920, -0.021394>, <-0.832747, -0.000920, -0.021394>, <-0.832119, -0.000506, -0.021394>, <-0.832119, 0.000000, -0.021394>, 
      <0.000000, -0.024151, 0.500000>, <0.011527, -0.024151, 0.500000>, <0.020959, -0.013283, 0.500000>, <0.020959, 0.000000, 0.500000>, 
      <0.000000, -0.096564, 1.000000>, <0.049997, -0.096564, 1.000000>, <0.090904, -0.053110, 1.000000>, <0.090904, 0.000000, 1.000000>, 
      <0.000000, -0.207136, 1.500000>, <0.107510, -0.207136, 1.500000>, <0.195473, -0.116185, 1.500000>, <0.195473, -0.005022, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.832119, 0.000000, -0.021394>, <-0.832119, 0.000506, -0.021394>, <-0.832747, 0.000920, -0.021394>, <-0.833515, 0.000920, -0.021394>, 
      <0.020959, 0.000000, 0.500000>, <0.020959, 0.013283, 0.500000>, <0.011527, 0.024151, 0.500000>, <0.000000, 0.024151, 0.500000>, 
      <0.090904, 0.000000, 1.000000>, <0.090904, 0.053110, 1.000000>, <0.049997, 0.096564, 1.000000>, <0.000000, 0.096564, 1.000000>, 
      <0.195473, -0.005022, 1.500000>, <0.195473, 0.106140, 1.500000>, <0.107510, 0.197091, 1.500000>, <0.000000, 0.197091, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.833515, 0.000920, -0.021394>, <-0.834282, 0.000920, -0.021394>, <-0.834910, 0.000506, -0.021394>, <-0.834910, 0.000000, -0.021394>, 
      <0.000000, 0.024151, 0.500000>, <-0.011527, 0.024151, 0.500000>, <-0.020959, 0.013283, 0.500000>, <-0.020959, 0.000000, 0.500000>, 
      <0.000000, 0.096564, 1.000000>, <-0.049997, 0.096564, 1.000000>, <-0.090904, 0.053110, 1.000000>, <-0.090904, 0.000000, 1.000000>, 
      <0.000000, 0.197091, 1.500000>, <-0.107510, 0.197091, 1.500000>, <-0.195473, 0.106140, 1.500000>, <-0.195473, -0.005022, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.195473, -0.005022, 1.500000>, <-0.195473, -0.116185, 1.500000>, <-0.107510, -0.207136, 1.500000>, <0.000000, -0.207136, 1.500000>, 
      <-0.300042, -0.010044, 2.000000>, <-0.300042, -0.179259, 2.000000>, <-0.165023, -0.317707, 2.000000>, <0.000000, -0.317707, 2.000000>, 
      <-0.586679, 0.000000, 2.500000>, <-0.586679, -0.305617, 2.500000>, <-0.322673, -0.555668, 2.500000>, <0.000000, -0.555668, 2.500000>, 
      <-0.309272, 0.000000, 3.000000>, <-0.309272, -0.167108, 3.000000>, <-0.170099, -0.303833, 3.000000>, <0.000000, -0.303833, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.207136, 1.500000>, <0.107510, -0.207136, 1.500000>, <0.195473, -0.116185, 1.500000>, <0.195473, -0.005022, 1.500000>, 
      <0.000000, -0.317707, 2.000000>, <0.165023, -0.317707, 2.000000>, <0.300042, -0.179259, 2.000000>, <0.300042, -0.010044, 2.000000>, 
      <0.000000, -0.555668, 2.500000>, <0.322673, -0.555668, 2.500000>, <0.586679, -0.305617, 2.500000>, <0.586679, 0.000000, 2.500000>, 
      <0.000000, -0.303833, 3.000000>, <0.170099, -0.303833, 3.000000>, <0.309272, -0.167108, 3.000000>, <0.309272, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.195473, -0.005022, 1.500000>, <0.195473, 0.106140, 1.500000>, <0.107510, 0.197091, 1.500000>, <0.000000, 0.197091, 1.500000>, 
      <0.300042, -0.010044, 2.000000>, <0.300042, 0.159170, 2.000000>, <0.165023, 0.297618, 2.000000>, <0.000000, 0.297618, 2.000000>, 
      <0.586679, 0.000000, 2.500000>, <0.586679, 0.305617, 2.500000>, <0.322673, 0.555668, 2.500000>, <0.000000, 0.555668, 2.500000>, 
      <0.309272, 0.000000, 3.000000>, <0.309272, 0.167108, 3.000000>, <0.170099, 0.303833, 3.000000>, <0.000000, 0.303833, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.197091, 1.500000>, <-0.107510, 0.197091, 1.500000>, <-0.195473, 0.106140, 1.500000>, <-0.195473, -0.005022, 1.500000>, 
      <0.000000, 0.297618, 2.000000>, <-0.165023, 0.297618, 2.000000>, <-0.300042, 0.159170, 2.000000>, <-0.300042, -0.010044, 2.000000>, 
      <0.000000, 0.555668, 2.500000>, <-0.322673, 0.555668, 2.500000>, <-0.586679, 0.305617, 2.500000>, <-0.586679, 0.000000, 2.500000>, 
      <0.000000, 0.303833, 3.000000>, <-0.170099, 0.303833, 3.000000>, <-0.309272, 0.167108, 3.000000>, <-0.309272, 0.000000, 3.000000>
    }
  }
  texture {
    Chrome_Metal3
  }
  rotate <-90.0, 0.0, -100.0>
  translate  <0.369169, -2.879171, 2.509956>
}
#declare TailUnit = union {
  object { TailPivot1 }
  object { // TailPivot2->TailPivot1
    TailPivot1
    rotate -5.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot3->TailPivot1
    TailPivot1
    rotate -10.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot4->TailPivot1
    TailPivot1
    rotate -15.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot5->TailPivot1
    TailPivot1
    rotate -20.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot6->TailPivot1
    TailPivot1
    rotate -25.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot7->TailPivot1
    TailPivot1
    rotate -30.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot8->TailPivot1
    TailPivot1
    rotate -35.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot9->TailPivot1
    TailPivot1
    rotate -40.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot10->TailPivot1
    TailPivot1
    rotate -45.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot11->TailPivot1
    TailPivot1
    rotate -50.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot12->TailPivot1
    TailPivot1
    rotate -55.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot13->TailPivot1
    TailPivot1
    rotate -60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot14->TailPivot1
    TailPivot1
    rotate -65.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot15->TailPivot1
    TailPivot1
    rotate -70.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot16->TailPivot1
    TailPivot1
    rotate -75.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot17->TailPivot1
    TailPivot1
    rotate -80.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot18->TailPivot1
    TailPivot1
    rotate -85.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot19->TailPivot1
    TailPivot1
    rotate -90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot20->TailPivot1
    TailPivot1
    rotate -95.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot21->TailPivot1
    TailPivot1
    rotate -100.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot22->TailPivot1
    TailPivot1
    rotate -105.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot23->TailPivot1
    TailPivot1
    rotate -110.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot24->TailPivot1
    TailPivot1
    rotate -115.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot25->TailPivot1
    TailPivot1
    rotate -120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot26->TailPivot1
    TailPivot1
    rotate -125.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot27->TailPivot1
    TailPivot1
    rotate -130.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot28->TailPivot1
    TailPivot1
    rotate -135.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot29->TailPivot1
    TailPivot1
    rotate -140.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot30->TailPivot1
    TailPivot1
    rotate -145.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot31->TailPivot1
    TailPivot1
    rotate -150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot32->TailPivot1
    TailPivot1
    rotate -155.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot33->TailPivot1
    TailPivot1
    rotate -160.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot34->TailPivot1
    TailPivot1
    rotate -165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot35->TailPivot1
    TailPivot1
    rotate -170.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot36->TailPivot1
    TailPivot1
    rotate -175.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot37->TailPivot1
    TailPivot1
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot38->TailPivot1
    TailPivot1
    rotate 175.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot39->TailPivot1
    TailPivot1
    rotate 170.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot40->TailPivot1
    TailPivot1
    rotate 165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // TailPivot41->TailPivot1
    TailPivot1
    rotate 160.0*z
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // TailCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      BodyTexture1
    }
    scale <0.5, 0.5, 0.95>
    rotate <-90.0, 0.0, -100.0>
    translate  <-5.2, 1.6, 2.5>
  }
  object { Stinger }
  no_shadow
  rotate <-90.0, -80.0, 180.0>
  translate  <-3.5309, 4.452505, 7.416477>
}
#declare LowerArmUnit3 = union {
  cylinder { // ArmJoint7
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit3 = union {
  cylinder { // ArmJoint8
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -124.111008*x
  translate  3.25*z
}
#declare LowerArmAndCl3 = union {
  object { LowerArmUnit3 }
  object { ClawUnit3 }
  rotate <94.714981, -1.283782, 0.0>
  translate  2.5*z
}
#declare UpperLowerCla3 = union {
  sphere { // SholderPivot3
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndCl3 }
  rotate <3.676109, -0.215345, -12.854415>
  translate  -0.5*y
}
#declare LeftCenter = union {
  cylinder { // Sholder3
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerCla3 }
  rotate 180.0*z
  translate  <0.0, 4.15, 0.0>
}
#declare LowerArmUnit4 = union {
  cylinder { // ArmJoint9
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit4 = union {
  cylinder { // ArmJoint10
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -124.111008*x
  translate  3.25*z
}
#declare LowerArmAndCl4 = union {
  object { LowerArmUnit4 }
  object { ClawUnit4 }
  rotate 94.405807*x
  translate  2.5*z
}
#declare UpperLowerCla4 = union {
  sphere { // SholderPivot4
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndCl4 }
  rotate 39.568413*x
  translate  -0.5*y
}
#declare LeftRear = union {
  cylinder { // Sholder4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerCla4 }
  rotate -149.571686*z
  translate  <-2.0, 4.0, 0.0>
}
#declare LowerArmUnit5 = union {
  cylinder { // ArmJoint11
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit5 = union {
  cylinder { // ArmJoint12
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -124.111008*x
  translate  3.25*z
}
#declare LowerArmAndCl5 = union {
  object { LowerArmUnit5 }
  object { ClawUnit5 }
  rotate 94.405807*x
  translate  2.5*z
}
#declare UpperLowerCla5 = union {
  sphere { // SholderPivot5
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndCl5 }
  rotate <30.0, 0.0, -30.0>
  translate  -0.5*y
}
#declare LeftFront = union {
  cylinder { // Sholder5
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerCla5 }
  rotate 168.541855*z
  translate  <2.0, 4.0, 0.0>
}
#declare LowerArmUnit = union {
  cylinder { // ArmJoint1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit = union {
  cylinder { // ArmJoint2
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -110.79364*x
  translate  3.25*z
}
#declare LowerArmAndClaw = union {
  object { LowerArmUnit }
  object { ClawUnit }
  rotate 77.4785*x
  translate  2.5*z
}
#declare UpperLowerClaw = union {
  sphere { // SholderPivot
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndClaw }
  rotate 30.0*x
  translate  -0.5*y
}
#declare RightCenter = union {
  cylinder { // Sholder
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerClaw }
  translate  <0.0, -0.15, 0.0>
}
#declare LowerArmUnit1 = union {
  cylinder { // ArmJoint3
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit1 = union {
  cylinder { // ArmJoint4
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -145.804352*x
  translate  3.25*z
}
#declare LowerArmAndCl1 = union {
  object { LowerArmUnit1 }
  object { ClawUnit1 }
  rotate <78.460625, 0.0, 11.530929>
  translate  2.5*z
}
#declare UpperLowerCla1 = union {
  sphere { // SholderPivot1
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndCl1 }
  rotate <23.739567, 5.838536, 0.354824>
  translate  -0.5*y
}
#declare RightFront = union {
  cylinder { // Sholder1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerCla1 }
  rotate 43.409435*z
  translate  2.0*x
}
#declare LowerArmUnit2 = union {
  cylinder { // ArmJoint5
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, -0.763367, -90.0>
    translate  -0.315*x
  }
  cylinder { // LowerArm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 3.0>
    rotate -0.763367*x
  }
}
#declare ClawUnit2 = union {
  cylinder { // ArmJoint6
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.315*x
  }
  cone { // Claw2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  <0.0, 0.0, -2.25>
  }
  rotate -124.111008*x
  translate  3.25*z
}
#declare LowerArmAndCl2 = union {
  object { LowerArmUnit2 }
  object { ClawUnit2 }
  rotate 94.405807*x
  translate  2.5*z
}
#declare UpperLowerCla2 = union {
  sphere { // SholderPivot2
    <0,0,0>,1
    scale 0.5
  }
  cylinder { // UpperArm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal3
    }
    scale <0.25, 0.25, 2.0>
    translate  0.25*z
  }
  object { LowerArmAndCl2 }
  rotate <25.0, -2.75, 0.25>
  translate  -0.5*y
}
#declare RightRear = union {
  cylinder { // Sholder2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  -0.5*z
  }
  object { UpperLowerCla2 }
  rotate -14.834324*z
  translate  -2.0*x
}
#declare LegsUnit = union {
  object { LeftCenter }
  object { LeftRear }
  object { LeftFront }
  object { RightCenter }
  object { RightFront }
  object { RightRear }
  translate  2.5*z
}
union { // Crawler
  sphere { // Body
    <0,0,0>,1
    scale <4.201274, 2.299673, 1.083571>
    translate  <0.0, 1.9, 2.5>
  }
  object { HeadUnit }
  object { TailUnit }
  object { LegsUnit }
  texture {
    BodyTexture1
  }
  translate  -1.95*y
}


sphere { // Sky
  <0,0,0>,1
  texture {
    Apocalypse2
  }
  scale 200.0
  rotate <0.0, 0.0, 2.988649>
  translate  <0.0, 0.0, 0.0>
}






