
// Persistence of Vision Ray Tracer Scene Description File
// File: BACKDROP.pov
// Vers: 3.00e Watcom Win32
// Desc: Classroom objects and assembly
// Date: Oct. 6/1996
// Auth: Sonya Roberts
// Note:

#declare Walls=
object {
	difference {
		box {<-1,-1,-1>,<30,11,51>}			// Basic box
		box {<0,-.01,0>,<22.5,10,35>}			// Classroom
		box {<23,-.01,0>,<29,11,50>}			// Hallway
		box {<22.4,-.03,2.9>,<23.1,7.1,6.1>}		// Doorway
		box {<22.4,-.03,29.9>,<23.1,7.1,33.1>}		// Doorway
		box {<-1.11,2.4,1.9>,<0.11,8.1,32.1>}		// Window Opening
	}
//	pigment {color LightBlue}
	texture {Frottage_PaleBlueGreen	scale <.75,.75,.75>}
	finish {
		reflection .075
	}
}

#declare Windows=
object {
	union {
		difference {
			box {<-1.1,2.25,1.75>,<.1,8.25,32.25>}
			box {<-1.12,2.5,2>,<.12,8,32>}
		}
		cylinder {<-.5,1.9,17>,<-.5,8.1,17>,.075}
		cylinder {<-.5,1.9,9.5>,<-.5,8.1,9.5>,.075}
		cylinder {<-.5,1.9,26.5>,<-.5,8.1,26.5>,.075}
		cylinder {<-.5,7,1.9>,<-.5,7,32.1>,.075}
		box {<-.51,2.4,1.9>,<-.49,8.1,32.1>	texture {T_Glass1}}
	}
	texture {WierdWood}
}

#declare Doorway=
object {
	difference {
		box {<22.4,-.01,-.25>,<23.1,7.25,3.25>}
		box {<22.3,-.02,0>,<23.2,7,3>}
	}
	texture {WierdWood}
}

#declare Door=
object {
	union {
		difference {
			box {<-.1,.1,0>,<.1,7,-3>}
			box {<-.11,4,-.5>,<.11,6.25,-2.5>}
		}
		box {<-.01,3.9,-.4>,<.01,6.3,-2.6>		texture {T_Glass1}}	// Window in door
		cylinder {<-.2,3.5,-2.5>,<.2,3.5,-2.5>,.035	texture {T_Brass_3C}}	// Door Handle
		sphere {<-.25,3.5,-2.5>,.1			texture {T_Brass_3C}}
		sphere {<.25,3.5,-2.5>,.1			texture {T_Brass_3C}}
	}
	texture {WierdWood	rotate x*90}
}

#declare Floor=
object {
	box {<-.1,-.1,-.1>,<29.1,0,50.1>}
	texture {
		checker
		texture {T_Stone2	finish {reflection .1}}
		texture {T_Stone8	finish {reflection .1}}
	}
}

#declare LightGlobe=
union {
	object {
		sphere {<0,0,0>,.5}
		texture {T_Glass2}
	}
	object {
		union {
			intersection {
				sphere {<0,0,0>,.51}
				box{<-.6,.4,-.6>,<.6,.6,.6>}
			}
			cylinder {<0,.45,0>,<0,1.5,0>,.02}
			sphere {<0,2,0>,.55}
		}
		texture {T_Chrome_4D}
	}
//	light_source {<0,0,0>,color White	atmosphere off}
	light_source {
		<0,0,0>,
		color White
		area_light x,z,4,4
		adaptive 1
		atmosphere off
	}
	translate <0,8.5,0>
}

#declare Whiteboard=
union {
	object {
		difference {
			box {<.1,.1,-.01>,<15.1,3.75,.05>}				// Basic Shape
			box {<5.08,0,-.011>,<5.12,3.76,.04>}				// Seams every 5 feet
			box {<10.08,0,-.011>,<10.12,3.76,.04>}
		}
		pigment {color White}
		finish {
			ambient .4
			reflection .2
		}
	}
	object {
		box{<.1,3.8,-.01>,<15.1,4,.05>}						// Cork Strip
		texture {Frottage_Tans	scale <.5,.5,.5>}
	}
	object {
		union {
			box{<0,0,0>,<15.2,4.2,.1>}
			difference {
				box{<0,0,0>,<15.2,.1,.35>}
				cylinder {<.1,.1,.051>,<15.1,.1,.051>,.05}
				cylinder {<.1,.1,.152>,<15.1,.1,.152>,.05}
				cylinder {<.1,.1,.253>,<15.1,.1,.253>,.05}
				translate <0,0,-.349>
			}
		}
		texture {T_Chrome_4C}
	}
	translate <-8.6,2.75,-.1>
}

#declare Desk=
union {
	object {
		difference {
			box {<0,0,0>,<2.5,.5,1.75>}
			box {<.05,.05,-.1>,<2.45,.51,1.7>}
		}
		pigment {color rgb <.93,.83,.61>}
		finish {
			reflection .075
		}
	}
	object {
		box {<-.1,.49,-.1>,<2.6,.6,1.85>}
	}
	object {cylinder {<.05,0,.05>,<.05,-2.25,.05>,.05}	texture {T_Chrome_4E}}
	object {cylinder {<2.45,0,.05>,<2.45,-2.25,.05>,.05}	texture {T_Chrome_4E}}
	object {cylinder {<.05,0,1.7>,<.05,-2.25,1.7>,.05}	texture {T_Chrome_4E}}
	object {cylinder {<2.45,0,1.7>,<2.45,-2.25,1.7>,.05}	texture {T_Chrome_4E}}
	translate <-1.25,2.25,0>
}

#declare Chair=
union {
	object {
		union {
			cylinder {<0,0,0>,<0,-2,0>,.05	rotate x*-10	translate <0,1.8,.5>	rotate y*45}
			cylinder {<0,0,0>,<0,-2,0>,.05	rotate x*-10	translate <0,1.8,.5>	rotate y*135}
			cylinder {<0,0,0>,<0,-2,0>,.05	rotate x*-10	translate <0,1.8,.5>	rotate y*225}
			cylinder {<0,0,0>,<0,-2,0>,.05	rotate x*-10	translate <0,1.8,.5>	rotate y*315}
			torus {.55,.05	translate <0,.75,0>}
		}
		texture {T_Chrome_4E}
	}
	object {
		cylinder {<0,1.75,0>,<0,1.85,0>,.6}
	}
}

#declare Outline=
object {
	box {<0,0,0>,<1,1,-.01>}
	pigment {
		image_map {
			gif "outline.gif"
		}
	}
	finish {ambient .4}
	scale <1,.75,1>
}

#declare Lectern=
union {
	object {
		union {
			box {<0,-.025,.01>,<1.5,.1,1.1>}
			box {<0,0,0>,<1.5,.2,.1>}
			object {Outline		rotate x*90	translate <.25,.1,.1>}
			texture {SRYello_Pine	rotate y*36	scale <.25,.1,.5>}
		}
		rotate x*-40
		translate  <-1.25,3.5,0>
	}
	object {
		union {
			cylinder {<0,0,.5>,<0,3.5,0>,.1}
			sphere {<0,-2,.5>,2.25}
		}
		texture {T_Chrome_4D}
	}
}

// ==== Assemble Classroom ====
#declare Classroom=
union {
	object {Walls}
	object {Floor}
	object {Windows}
	object {Doorway		translate <0,0,3>}				// Door at Back of Class
	object {Door		rotate y*180	translate <22.75,0,3>}
	object {Doorway		translate <0,0,30>}				// Door at Front of Class
	object {Door		rotate y*35	translate <22.75,0,33>}
	object {Whiteboard	translate <11.25,0,35>}				// White Board - Front Wall
	object {Whiteboard	rotate y*90	translate <22.5,0,17.5>}	// White Board - Side Wall
	object {Lectern		rotate y*160	translate <3.25,0,32.5>}

	#declare R1=seed(1)
	#declare X1=1
	#while (X1<=4)
		#declare Y1=1
		#while (Y1<= 5)
			object {
				Desk
				rotate y*((rand(R1)*8)-4)
				translate <3.75+((X1-1)*5),0,(3+((Y1-1)*5))>
				texture {SRYello_Pine	scale <.25,.25,.25>	rotate (y*(rand(R1)*360))}
			}
			object {
				Chair
				rotate (y*(rand(R1)*360))
				translate <3.75+((X1-1)*5),0,(1.5+((Y1-1)*5))>
				texture {SRYello_Pine	scale <.25,.25,.25>	rotate (y*(rand(R1)*360))}
			}
			#declare Y1=Y1+1
		#end
		#declare X1=X1+1
	#end
}
