#declare Show_Head = on
#declare Show_Torus = on
#declare Show_Torso = on
#declare Show_Legs = on
#declare Show_Treads = on
#declare Show_Rocks = on

#include "colors.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones1.inc"
#include "finish.inc"

// POV 3 complains about this but does it anyway!
#max_trace_level 5

#declare ft = 12 // Everything is in feet and inches(the basic unit)

// Camera
camera
    {
    location <-1*ft, -8.5*ft, 6*ft>// robot is at <0,0,0> facing in the -y direction
    direction <0,0,1>
    right     <6/8,0,0> // square image NxN  - default is x=1.333
    sky <0,0,1>              // Z is up...(I hate Z into the scene!)
    look_at -y*22+z*4*ft           // look at robot's front
    }

#declare half_flood = union
    {
    light_source 
        { 
        <0,0,0>
        color 1
        area_light <0,0,0><4,4,0>, 4, 4
        fade_distance 20*ft fade_power 2
        }
    intersection // half a hollow cylinder
        {
        cylinder{ <-6,0,0><6,0,0> 6 open }
        box{<-7,-7,-7><7,7,0>}
        }
    }

// Lights
light_source 
    { 
    <10*ft,-20*ft,20*ft> 
    color 1 
    spotlight
    point_at 0
    radius 30
    falloff 50
    area_light <0,0,0><4,4,0>, 4, 4
    fade_distance 20*ft fade_power 2
    }

light_source
    {
    <-10*ft,-20*ft,20*ft>
    color rgb<0.9,0.8,0.8>
    spotlight
    point_at 0
    radius 30
    falloff 50
    area_light <0,0,0><4,4,0>, 4, 4
    fade_distance 20*ft fade_power 2
    }

light_source
    {
    <0,15*ft,20*ft>
    color rgb<0.8,0.8,0.85>
    spotlight
    point_at 0
    radius 30
    falloff 50
    area_light <0,0,0><2,2,0>, 2, 2
    fade_distance 20*ft fade_power 2
    }

// wash lights...grid in the xy plane
#declare xx = -50*ft
#while ( xx < 150*ft )
#declare yy = -10*ft
#while (yy < 150*ft)
    light_source
        {
        <xx,yy,20*ft>
        color rgb<0.3,0.3,0.5>
        fade_distance 20*ft fade_power 2
        }
#declare yy = yy + 30*ft
#end
#declare xx = xx + 30*ft
#end


// textures and other declares
#declare brushed_wave = slope_map
    {
    [0   <0, 0.1>]
    [0.5 <0.03,-0.1>]
    [1   <0,-0.1>]
    }

#declare tread_wave = slope_map
    {
    [0   <0,  0>]   
    [0.9 <2, 40>]
    [0.99<2,  0>]
    [1   <0,-40>]
    }

#declare brushed_aluminum =
texture {
    T_Chrome_3C
    normal{ gradient z turbulence 0.1 slope_map{brushed_wave} scale<1,1,0.5> }
    finish {specular 0.4 roughness 0.50 reflection 0 ambient 0.6}
}

// Simple clear glass
#declare robot_glass =
texture {
    pigment { color rgbf<1, 1, 1, 1> }
    finish  { F_Glass1 refraction 1 }
}

// tread texture
#declare tread_texture = texture
    {
    pigment {rgb<0.2,0.2,0.2>}
    normal{ gradient z turbulence 0 slope_map{tread_wave} scale<1,1,2> }
    }

#declare torso_base = 48 // bottom of torso
#declare torso_height = 20
#declare torso_radius = 16
#declare head_base = torso_base+torso_height+15

#declare eye_bolt = union
    {
    cylinder
        {
        <0,-torso_radius,torso_base+6><0,-(torso_radius+0.5),torso_base+6> 0.5
        }
    torus 
        {
        1 0.25
        rotate z*90
        rotate y*90
        translate <0,-(torso_radius+1.75), torso_base+6>
        }
    texture{ brushed_aluminum }
    }

// Main torso
#declare basic_torso=union
    {

    // basic central cylinder
    cylinder{ z*(torso_base+3) z*(torso_height+torso_base-3) torso_radius }
    // torus under the cylinder - with a cutout
    difference
        {
        torus
            {
            torso_radius-6 6
            rotate x*90
            translate z*(torso_base+3)
            }
        cone
            {
            <0,-(torso_radius+1),(torso_base+3)> 3
            <0,-(torso_radius-6),(torso_base-6)> 2
            }
        }
    // This is the same as the torus in the cutout above, just a little smaller
    torus
        {
        torso_radius-6 5.5
        rotate x*90
        translate z*(torso_base+3)
        texture
            { 
            robot_glass 
            normal{ gradient x scallop_wave }
            }
        }
    // curved area above the cylinder
    intersection
        {
        sphere{ z*(torso_base-6) torso_height+8 }
        cylinder { z*(torso_base+torso_height-3) z*(torso_base+torso_height) torso_radius }
        }
    // band around the top of the cylinder
    cylinder{ z*(torso_height+torso_base-4) z*(torso_height+torso_base-3) torso_radius+1/4  }
    // band around the bottom of the cylinder
    cylinder{ z*(torso_base+3) z*(torso_base+4) torso_radius+1/4  }
    // short cylinder above the main torso
    cylinder{ z*(torso_base+torso_height) z*(torso_base+torso_height+1/2) 11 }

    // outlines around the arm cutouts
    intersection
        {
        cylinder
            {
            <torso_radius-6,-(torso_radius+8),torso_base+(torso_height/2)>
            <torso_radius-6,-(torso_radius-8),torso_base+(torso_height/2)>
            4.75
            }
        cylinder{ z*(torso_base+3) z*(torso_height+torso_base-3) torso_radius+(1/4) }
        }
    intersection
        {
        cylinder
            {
            <-(torso_radius-6),-(torso_radius+8),torso_base+(torso_height/2)>
            <-(torso_radius-6),-(torso_radius-8),torso_base+(torso_height/2)>
            4.75
            }
        cylinder{ z*(torso_base+3) z*(torso_height+torso_base-3) torso_radius+(1/4) }
        }

    // The right angle shaped lift points on his upper torso
    // they're curved at the top so make them a blob with cylinders
#declare i = torso_base+torso_height-2.5
    blob
        {
        threshold 0.2
        cylinder { <-(torso_radius-1), 0, i>   <-(torso_radius-1.5),0, i+2> 0.5 1.0 }
        cylinder { <-(torso_radius-1.5), 0, i+2> <-(torso_radius-4),0, i+1> 0.5 1.0 }
        texture{ brushed_aluminum }
        }
    blob
        {
        threshold 0.2
        cylinder { <(torso_radius-1), 0, i>   <(torso_radius-1.5),0, i+2> 0.5 1.0 }
        cylinder { <(torso_radius-1.5), 0, i+2> <(torso_radius-4),0, i+1> 0.5 1.0 }
        texture{ brushed_aluminum }
        }

    // The eye-bolts on his front.
    //  This guy's really pretty useful!  Somebody really thought about
    //  what you would do with a robot in space!
    object{ eye_bolt rotate z*15 }
    object{ eye_bolt rotate z*-15 }
    }
#declare torso=difference
    {
    object {basic_torso}

    // arm cutouts
    cylinder
        {
        <torso_radius-6,-(torso_radius+8),torso_base+(torso_height/2)>
        <torso_radius-6,-(torso_radius-8),torso_base+(torso_height/2)>
        4.5
        }
    cylinder
        {
        <-(torso_radius-6),-(torso_radius+8),torso_base+(torso_height/2)>
        <-(torso_radius-6),-(torso_radius-8),torso_base+(torso_height/2)>
        4.5
        }
    // panel cutout
    box
        {
        <-3,-(torso_radius+6),(torso_base+4)>
        <+3,-(torso_radius-1),(torso_height+torso_base-3)>
        }
    // top area of the vox_light
    intersection
        {
        cone
            {
            <0,-(torso_radius+1),(torso_height+torso_base-3)> 2.5
            <0,-(torso_radius-4),(torso_height+torso_base-1)> 4
            }
        // Same cylinder as the intersection of the curved area 
        //  above the main torso
        cylinder { z*(torso_base+torso_height-3) z*(torso_base+torso_height) torso_radius }
        }
    // bottom(front) area of the vox_light
    box
        {
        <-3,-(torso_radius+6),(torso_height+torso_base-5.5)>
        <+3,-(torso_radius-3),(torso_height+torso_base-2)>
        }
    }

#declare arc_rad = 1.25*ft

#declare R1 = seed(25);

#declare square_button = union
    {
    box{<0,0,0><1,1/4,1> texture{ T_Chrome_4D }}
    // random color button!
    box{<1/16,-1/32,1/16><15/16,0,15/16>}
    }

#declare panel = union
    {
    // eyes
    cylinder{<-1.5,-(torso_radius-0.5),torso_height+torso_base-9>
             <-1.5,-(torso_radius-1),torso_height+torso_base-9>
             0.8 texture{pigment{White} finish{Shiny}}}
    cylinder{<+1.5,-(torso_radius-0.5),torso_height+torso_base-9>
             <+1.5,-(torso_radius-1),torso_height+torso_base-9>
             0.8 texture{pigment{White} finish{Shiny}}}
    // square buttons below eyes
#declare i = 0
#while (i<6)
    object
        {
        square_button
        pigment{ rgb <rand(R1)*2,rand(R1)*2,rand(R1)*2> }
        finish{Shiny}
        translate <-3+i, -(torso_radius-3/4), torso_height+torso_base-12>
        }
    object
        {
        square_button
        pigment{ rgb <rand(R1)*2,rand(R1)*2,rand(R1)*2> }
        finish{Shiny}
        translate <-3+i, -(torso_radius-3/4), torso_height+torso_base-13>
        }
#declare i = i+1
#end
// round buttons below the square buttons
#declare i = 0
#while (i<6)
    cylinder
        {
        <-2.5+i,-(torso_radius-0.5),torso_height+torso_base-14>
        <-2.5+i,-(torso_radius-1),torso_height+torso_base-14>
        0.35
        texture{ pigment{rgb <rand(R1),rand(R1),rand(R1)>} finish{Shiny}}
        }
    cylinder
        {
        <-2.5+i,-(torso_radius-0.5),torso_height+torso_base-15>
        <-2.5+i,-(torso_radius-1),torso_height+torso_base-15>
        0.35 
        texture{ pigment{rgb <rand(R1),rand(R1),rand(R1)>} finish{Shiny}}
        }
#declare i = i+1
#end
    


    // thin bar between the eyes area and the front of the vox_light
    box
        {
        <-3.1, -(torso_radius),   (torso_height+torso_base-6)>
        <+3.1, -(torso_radius-1), (torso_height+torso_base-5.5)>
        texture{ brushed_aluminum }
        }
// front of the vox_light - vertical series of cylinders
#declare i = torso_height+torso_base-5.5    
#while (i < torso_height+torso_base-3 )
    cylinder
        {
        <-3,-(torso_radius-1),i+(1/4)>
        <+3,-(torso_radius-1),i+(1/4)> 1/4 
        texture{robot_glass}
        finish{Shiny reflection 0.1}
        }
#declare i = i+1/2
#end

// top of the vox_light - another series of cylinders this time with a 
//  delta y and a delta z
#declare i = i-1/4
#declare j = 0
#while ( i < torso_height+torso_base-1/2 )
    cylinder
        {
        <-4,-(torso_radius-1-j/2),i+(1/4)>
        <+4,-(torso_radius-1-j/2),i+(1/4)> 1/4 
        texture{robot_glass}
        finish{Shiny reflection 0.1}
        }
#declare j = j +1
#declare i = i + 31/128
#end
    // Redish lights inside the vox_light
    // they fade fast beyond 4 inchs
    light_source 
        { 
        <-2,-(torso_radius-1.5),torso_height+torso_base-3> 
        Red 
        fade_distance 4
        fade_power 3
        }
    light_source 
        { 
        <+2,-(torso_radius-1.5),torso_height+torso_base-3> 
        Red 
        fade_distance 4
        fade_power 3
        }
    light_source 
        { 
        <0,-(torso_radius-1.5),torso_height+torso_base-3> 
        Yellow/4 
        fade_distance 4
        fade_power 3
        }
    }


// the <==> shaped thing between his torso and his neck
//      THIS WAS A REAL PAIN!
#declare glass_arc = torus
    {
    arc_rad-(1/4) 1/4
    clipped_by {box{<-1*ft,-(1/4),arc_rad><1*ft,(1/4),arc_rad-(1*ft)>}}
    }

#declare double_arc = union
    {
    object{ glass_arc }
    object{ glass_arc rotate x*180 translate z*((arc_rad*2)-12.75) }
    }

#declare v_torus = union
    {
    
    #declare i = 0
    #while (i < 180)
        object{ double_arc rotate z*i }
    #declare i = i + (180/40)
    #end
    
    sphere 
        { 
        0 arc_rad-1/4 
        clipped_by {cylinder{<0,0,arc_rad><0,0,arc_rad-6.375> arc_rad-1/4}}
        texture{ robot_glass }
        finish{ reflection 0 }
        }
    sphere 
        {
        0 arc_rad-1/4 clipped_by {cylinder{<0,0,-arc_rad><0,0,-(arc_rad-6.375)> arc_rad-1/4}}
        translate z*((arc_rad*2)-12.5)
        texture{ robot_glass }
        finish{ reflection 0 }
        }
    clipped_by { cylinder{ z*(arc_rad-8.25) z*(arc_rad-4) arc_rad+1/4} }
    }

#declare neck = union
    {
    #declare i = 0
    #while (i < 15)
        cone{<0,0,i> 2 <0,0,i+0.5> 1.5}
        cone{<0,0,i+0.5> 1.5 <0,0,i+1> 2}
    #declare i = i+1
    #end
    }


#declare head_sphere = difference
    {
    union
        {
        // if this reflection is not 0 we get infinite reflections!
        cylinder{  z*-4 z*4 8 } 
        torus{ 8 4 rotate x*90 }
        texture{robot_glass}
        finish{reflection 0 refraction 1}
        }

    // the inside of the difference here must have ior=1.0 so that the ray
    // will 'hit' air inside the head, not create a head of solid glass
    union
        {
        cylinder{  z*-4 z*4 8 }
        torus{ 8 4 rotate x*90 }
        scale 0.97
        texture{robot_glass}
        finish{reflection 0 refraction 1 ior 1.0}
        }
    }

#declare head = union
    {
    object{head_sphere}
    // three pronged thing
    box{ <0,0,-2> <10,3/4,2> rotate z*60  texture{brushed_aluminum}}
    box{ <0,0,-2> <10,3/4,2> rotate z*180 texture{brushed_aluminum}}
    box{ <0,0,-2> <10,3/4,2> rotate z*300 texture{brushed_aluminum}}
    cone{ 0 0 z*3.5 2 texture{brushed_aluminum} }
    // kinda flat splayed thing
    difference
        {
        cone{ <0,0,2> 0 <0,0,3.5> 6 }
        #declare i = 0
        #while (i <= 4)
            box{<-9,-1/2,2><9,1/2,4.5> rotate z*i*45}
        #declare i = i+1
        #end
        texture{ brushed_aluminum }
        }
    }

#declare shoulders = union
    {
    // main shoulder
    cylinder{ z*0, z*1.5 10 texture{brushed_aluminum} }

    // wing nut and support
    cone{ <10,0,0.75> 0.5 <12,0,0.75> 0.25 }
    sphere{<12.75,0,0.75> 0.75}
    cylinder{<12.75,0,1.5> <12.75,0,3> 0.25}
    cylinder{<12.75/2,-0.125,3.75> <12.75/2,+0.125,3.75> 0.75 scale<2,1,1>}

    // same thing, rotated to other side
    cone{ <10,0,0.75> 0.5 <12,0,0.75> 0.25 rotate z*180 }
    sphere{<12.75,0,0.75> 0.75 rotate z*180}
    cylinder{<12.75,0,1.5> <12.75,0,3> 0.25 rotate z*180}
    cylinder{<12.75/2,-0.125,3.75> <12.75/2,+0.125,3.75> 0.75 scale<2,1,1> rotate z*180}

    // Lock collar
    cylinder{ z*1.5, z*3, 4 }
    cylinder{ z*1.5+y*4  z*3+y*4  1/4 }
    cylinder{ z*1.5+y*-4 z*3+y*-4 1/4 }
    cylinder{ z*1.5+x*4  z*3+x*4  1/4 }
    cylinder{ z*1.5+x*-4 z*3+x*-4 1/4 }
    cylinder{ z*1.5+y*4  z*3+y*4  1/4 rotate z*45}
    cylinder{ z*1.5+y*-4 z*3+y*-4 1/4 rotate z*45}
    cylinder{ z*1.5+x*4  z*3+x*4  1/4 rotate z*45}
    cylinder{ z*1.5+x*-4 z*3+x*-4 1/4 rotate z*45}
    texture{ T_Chrome_4D finish {ambient 0.3} }
    }

#declare Hand = union
    {
    cylinder {0        y*-1.5 3.8 texture{brushed_aluminum}}
    cone     {y*-1 3.8 y*-2.5 1.5   texture{brushed_aluminum}}
    difference
        {
        cylinder{ <-1/2, -6.5, 0> <1/2, -6.5, 0> 4 }
        cylinder{ <-1, -7.25, 0> <1, -7.25, 0> 2.5 }
        box{<-1, -11, -0.1 ><1, -6, 0.1>}
        texture{ pigment{ Red*0.7 } finish{Shiny} }
        }
    }


#declare boot = blob
    {
    threshold 0.2
    cylinder { <-0.365, -0.375, 0> <+0.365, -0.375, 0> 0.125 1.0 }
    cylinder { <-0.365, +0.375, 0> <+0.365, +0.375, 0> 0.125 1.0 }
    cylinder { <-0.375, -0.365, 0> <-0.375, +0.365, 0> 0.125 1.0 }
    cylinder { <+0.375, -0.365, 0> <+0.375, +0.365, 0> 0.125 1.0 }
   texture {
      pigment{ color rgb<0.1,0.1,0.1> }
      finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 reflection 0 }
   }
}


#declare Legs = union
    {
    // torus under the torso
    torus
        {
        torso_radius-4 1
        rotate x*90
        translate z*(torso_base-4)
        texture{ brushed_aluminum }
        }

#declare rndvar = 1 // random variation (-0.5 to +0.5 here)
#declare R2 = seed(0.357);

#declare i = 1
#while (i <= 5)
object
    { 
    boot scale <(torso_radius-2)*2, (torso_radius-2)*2, 15> 
    translate z*(torso_base-4.5-(i*2))
    // add in a slight random x & y rotation
    rotate x*(rand(R2)*rndvar-rndvar/2)+y*(rand(R2)*rndvar-rndvar/2)
    }
#declare i = i+1
#end
#declare i = 1
#while (i <= 5)
object
    { 
    boot scale <(torso_radius-2)-(i/2), ((torso_radius-2)*2)-(i/2), 15> 
    translate x*(torso_radius-2-i)/2+z*(torso_base-4.5-((i+5)*2))
    // add in a slight random x & y rotation
    rotate x*(rand(R2)*rndvar-rndvar/2)+y*(rand(R2)*rndvar-rndvar/2)
    }
object
    { 
    boot scale <(torso_radius-2)-(i/2), ((torso_radius-2)*2)-(i/2), 15> 
    translate x*-(torso_radius-2-i)/2+z*(torso_base-4.5-((i+5)*2))
    // add in a slight random x & y rotation
    rotate x*(rand(R2)*rndvar-rndvar/2)+y*(rand(R2)*rndvar-rndvar/2)
    }
#declare i = i+1
#end
    box
        {
        <-(torso_radius-4), -(torso_radius-4), torso_base-26>
        <(torso_radius-4), (torso_radius-4), torso_base-27>
        texture{ brushed_aluminum }
        }
    }


#declare Tread_End = union
    {
    cylinder{ <-18, 0, 0> <18, 0, 0> 6 }
    box{ <-18, -6, 0 > <18, 20, 20 > rotate x*-30 }
    cylinder{ <-18, 0, 20> <18, 0, 20> 6 rotate x*-30 }
    }
    
#declare Tread_Shape = union
    {
    // front
    object { Tread_End translate y*-20}
    // back
    object { Tread_End rotate z*180 translate y*20}
    box{ <-18, -11, 0> <18, 11, 23.5 > }
    box{ <-18, -20, -6> <18, 20, 8> }
    }

#declare Treads_With_Cuts = difference
    {
    object {
        Tread_Shape scale <0.8, 0.6, 0.6>
        translate z*6
        }
    object {Tread_Shape scale <0.1, 1, 0.6> translate <-14*0.8, 0, 5.5>}
    object {Tread_Shape scale <0.1, 1, 0.6> translate <+14*0.8, 0, 5.5>}
    object {Tread_Shape scale <0.1, 1, 0.6> translate <-3*0.8, 0, 5.5>}
    object {Tread_Shape scale <0.1, 1, 0.6> translate <+3*0.8, 0, 5.5>}
    }

#declare Treads = union
    {
    object{ Treads_With_Cuts texture{brushed_aluminum} }
    object 
        {
        Tread_Shape 
        scale <0.1, 0.65, 0.6> 
        translate <-14*0.8, 0, 5.5>
        texture{ tread_texture }
        }
    object 
        {
        Tread_Shape
        scale <0.1, 0.65, 0.6> 
        translate <+14*0.8, 0, 5.5>
        texture{ tread_texture }
        }
    object
        {
        Tread_Shape 
        scale <0.1, 0.65, 0.6> 
        translate <-3*0.8, 0, 5.5>
        texture{ tread_texture }
        }
    object 
        {
        Tread_Shape 
        scale <0.1, 0.65, 0.6> 
        translate <+3*0.8, 0, 5.5>
        texture{ tread_texture }
        }
    }

// This is the 'show-it' section where we show the objects declared above

#if (Show_Torso=on)

object {
    torso
    texture {brushed_aluminum}
    }

object{ panel }
object
    { 
    Hand  
    translate <torso_radius-6,-(torso_radius-8),torso_base+(torso_height/2)>
    }
object
    { 
    Hand  
    translate <-(torso_radius-6),-(torso_radius-8),torso_base+(torso_height/2)>
    }

#else
    cylinder
        {
        z*torso_base z*(torso_base+torso_height) torso_radius
        texture{ brushed_aluminum }
        }

#end

#if (Show_Torus = on)
object {
    v_torus
    translate z*((torso_base+torso_height+(1/2)) -6.75)
    texture{ T_Glass2 }
    }
#end

#if (Show_Head = on)
object {
    neck
    translate z*((torso_base+torso_height-1))
    pigment {Black}
    finish {specular 0.5 roughness 0.15}   
    }

object {
    shoulders
    translate z*((torso_base+torso_height+5))
    }

object {
    head
    translate z*head_base
    }

#end

#if (Show_Legs = on)
object { Legs }
#end

#if (Show_Treads = on)
object { Treads }
#end    
    
// This is the Environmental section - floor, sky sphere, rocks, backdrop
// The idea is to make this look pretty much like a TV studio

// floor
plane { z 0 texture{T_Grnt5 finish{reflection 0}} }
// backdrop
box { 
    <-300*ft,200*ft,0><300*ft,200*ft+1,300*ft> 
    texture
        {
        pigment
            {
            gradient z
            color_map
                {
                [ 0  White*0.75 ]
                [ 1  rgb<0.2,0.2,1>    ]
                }
            }
        scale 300*ft
        }
    finish{ reflection 0 ambient 0 }
    }

#declare i = -50*ft
#while( i < 150*ft )
   object { half_flood rotate x*15 translate<i, 180*ft, 1> }
   object { half_flood rotate x*150 translate<i, 180*ft, 60*ft> }
#declare i = i + 25*ft
#end

// Rocks
#if (Show_Rocks=on)

#declare Rocks = object
    {
    height_field { gif "rock1.gif" }
    translate <-0.5,-0.5,-(1/255)>      // centered over origin
    rotate <-90,0,0>
    }

object{ 
    Rocks
    scale <40*ft, 40*ft, 6*ft>
    translate y*30*ft
    texture{ T_Grnt1 finish{reflection 0 refraction 0}}
    }

object{ 
    Rocks
    scale <50*ft, 50*ft, 3*ft>
    translate y*10*ft
    texture{ T_Grnt1 finish{reflection 0 refraction 0}}
    }

object{ 
    Rocks
    rotate z*180
    scale <50*ft, 50*ft, 12*ft>
    translate x*-5*ft+y*50*ft
    texture{ T_Grnt5 finish{reflection 0 refraction 0}}
    }

object{ 
    Rocks
    rotate z*90
    scale <200*ft, 20*ft, 50*ft>
    translate y*80*ft
    texture{ T_Grnt4 finish{reflection 0 refraction 0}}
    }

object{ 
    Rocks
    scale <200*ft, 20*ft, 50*ft>
    translate x*100*ft+y*120*ft
    texture{ T_Grnt5 finish{reflection 0 refraction 0}}
    }
#end
