
//------------------------------------------------------------------->
//
// e-p-o.pov
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// Remember to turn these all "on" for the final render!

        #declare Show_Floor    = on
        #declare Show_Outdoors = on
        #declare Show_Oven     = on
        #declare Show_People   = on
        #declare Show_Screen   = on
        #declare Show_Table    = on
        #declare Show_Thing_1  = on
        #declare Show_Thing_2  = on
        #declare Show_Thing_3  = on
        #declare Show_Thing_4  = on
        #declare Show_Thing_5  = on
        #declare Show_Thing_6  = on
        #declare Show_Walls    = on
        #declare Show_Wires    = on

        #declare Which_Camera = 1

//------------------------------------------------------------------->
//
// All of the usual initializing.

        #include "colors.inc"
        #include "textures.inc"
        #include "metals.inc"
        #include "skies.inc"
        #include "woods.inc"
        #include "stones.inc"

        #default { finish { Shiny } }
        background { White }

//------------------------------------------------------------------->
//
// Camera #1 is the "final" setting, #2 is for testing!

        #if ( Which_Camera = 1 )
                camera { location < 4.5*12, 6*12, -4*12 >
                        look_at < 0, 2.5*12, 0 > }
        #end

        #if ( Which_Camera = 2 )
                camera { location < 4.5*12, 14*12, -16*12 >
                        look_at < 0, 2.5*12, 0 > }
        #end

//------------------------------------------------------------------->
//
// Lights.

        // Four main lights.
        light_source { < -5*12, 7*12, -5*12 > color rgb 1.0 }
        light_source { < -5*12, 7*12,  5*12 > color rgb 1.0 }
        light_source { <  5*12, 7*12, -5*12 > color rgb 1.0 }
        light_source { <  5*12, 7*12,  5*12 > color rgb 1.0 }

        // One way up high.
        light_source { <  0*12, 200*12,  0*12 > color rgb 1.0 }

        // One halfway across.
        light_source { <  0*12, 7*12,  -5*12 > color rgb 1.0 }

//------------------------------------------------------------------->
//
// Miscellaneous variables.

        #declare P4_RAND = seed(0)
        #declare R1 = seed(0)

        #declare Count_Triangles = 0
        #declare Count_Wall = 0
        #declare Count_Floor = 0
        #declare Count_Temp = 0

//------------------------------------------------------------------->
//
// Always include the baking pan, since it's used in several places.

        #include "bake-pan.inc"

//------------------------------------------------------------------->
//
// The floor.

#if ( Show_Floor = on )

        // Floor tiles.

                #include "floor.inc"

                #declare X = -7*12 #while ( X <= 6*12 )
                #declare Z = -6*12 #while ( Z <= 7*12 )

                        object { Floor_Tile translate < X, 0, Z > }
                        #declare Count_Floor = Count_Floor + 1

                #declare Z = Z + 1*12 #end
                #declare X = X + 1*12 #end

        // This hides any gaps.

                box { < -10*12, -1*12, -10*12 > < 10*12, -2*12, 10*12 >
                        pigment { Gray10 } }

        // Add the triangles to the grand total.
                #declare Count_Triangles = Count_Triangles +
                        ( Count_Floor * Count_Temp )


#end

//------------------------------------------------------------------->
//
// The Great Outdoors (tm).

#if ( Show_Outdoors = on )

                sky_sphere { S_Cloud2 }

#end

//------------------------------------------------------------------->
//
// The oven.

#if ( Show_Oven = on )

        #include "oven.inc"

        object { Oven translate y*(2.5*12)
                rotate y * -20
                translate x * (1*12) }

        // Show baking pan halfway out of oven.
                object { Baking_Pan translate <15, 12.2, 0>
                        // Spin it same as oven!
                                translate y*(2.5*12)
                                rotate y * -20
                                translate x * (1*12) }

#end

//------------------------------------------------------------------->
//
// The people.

#if ( Show_People = on )

        // Julie.
        #include "p4def_01.inc"
        object{One_Person rotate y*-190 translate < -2.4*12, 0, -2.5*12 > }

        // Tony.
        #include "p4def_02.inc"
        object{One_Person rotate y*1 translate<1.8*12,0,3*12>}

#end

//------------------------------------------------------------------->
//
// The screen that shows the TGA of the first thing.
//
// Note: If you get an error in this section, it's probably because the
//       required TGA file is missing. Run TEST-1.POV at a resolution
//       of 200x150 to create TEST-1.TGA.


#if ( Show_Screen = on )

        #include "screen.inc"

        object { Screen
                rotate y * -20
                translate < -2.8*12, 2.5*12, -0.5*12 > }

#end


//------------------------------------------------------------------->
//
// The table.

#if ( Show_Table = on )

        #include "table.inc"

        object { Table rotate y*10 }

#end

//------------------------------------------------------------------->
//
// The first thing (curly halfway out of oven).

#if ( Show_Thing_1 = on )

        #include"thing-1.inc"

        object { Thing_1

                // Make it a little bigger.
                        scale 1.2

                // Move it to edge of tunnel.
                        translate < 15, 13.5, 0 >

                // Spin it same as oven!
                        translate y * ( 2.5 * 12 )
                        rotate y * -20
                        translate x * (1*12)

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The second thing (fractori).

#if ( Show_Thing_2 = on )

        #declare Thing_2_Loc = < 2.9*12, 2.5*12, -1.7*12 >

        #include "thing-2.inc"

        object { Thing_2

                // Move it into baking pan.
                        scale 0.15 translate y*1.5

                // Move it to same place as baking pan.
                        translate Thing_2_Loc

                } // End of object.

        object { Baking_Pan

                rotate y*-10
                translate Thing_2_Loc

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The third thing (checkerboard with mirror spheres).

#if ( Show_Thing_3 = on )

        #declare Thing_3_Loc = < 0.7*12, 2.5*12, -1.8*12 >

        #include "thing-3.inc"

        object { Thing_3

                // Move it to same place as baking pan.
                        translate Thing_3_Loc

                } // End of object.

        object { Baking_Pan

                rotate y*-20
                translate Thing_3_Loc

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The fourth thing (a bunch of spheres).

#if ( Show_Thing_4 = on )

        #declare Thing_4_Loc = < 3.2*12, 2.5*12, 0.7*12 >

        #include "thing-4.inc"

        object { Thing_4

                // Move it to same place as baking pan.
                        translate Thing_4_Loc

                } // End of object.

        object { Baking_Pan

                rotate y*-10
                translate Thing_4_Loc

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The fifth thing (a tray of plastic people).

#if ( Show_Thing_5 = on )

        #declare Thing_5_Loc = < 2.8*12, 2.5*12, -0.5*12 >

        #include "thing-5.inc"

        object { Thing_5

                // Move it to same place as baking pan.
                        translate Thing_5_Loc

                } // End of object.

        object { Baking_Pan

                rotate y * 25
                translate Thing_5_Loc

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The sixth thing (a big mirror sphere).

#if ( Show_Thing_6 = on )

        #declare Thing_6_Loc = < 1.8*12, 2.5*12, -1.7*12 >

        #include "thing-6.inc"

        object { Thing_6 rotate y * 120

                // Move it to same place as baking pan.
                        translate Thing_6_Loc

                } // End of object.

        object { Baking_Pan

                rotate y * -5
                translate Thing_6_Loc

                } // End of object.

#end

//------------------------------------------------------------------->
//
// The four walls.

#if ( Show_Walls = on )

        #include "wall.inc"

// Left side wall.

        #declare Z = -6 #while ( Z <= 7 )
        #declare Y = 0 #while ( Y <= 6 )

                        object { Wall_Tile

                                // Spin it around.
                                translate < -6, -6, 0 >
                                rotate z * ( 90 * int ( rand(R1)*100 ) )
                                translate < 6, 6, 0 >

                                rotate <0,-90,0>
                                translate < -7*12, Y*12, Z*12 >

                                } // End of object.

                        #declare Count_Wall = Count_Wall + 1

        #declare Y = Y + 1 #end
        #declare Z = Z + 1 #end

// Rear wall.

        #declare X = -7 #while ( X <= 6 )
        #declare Y = 0 #while ( Y <= 6 )

                        object { Wall_Tile

                                // Spin it around.
                                translate < -6, -6, 0 >
                                rotate z * ( 90 * int ( rand(R1)*100 ) )
                                translate < 6, 6, 0 >

                                translate < X*12, Y*12, 8*12 >

                                } // End of object.

                        #declare Count_Wall = Count_Wall + 1

        #declare Y = Y + 1 #end
        #declare X = X + 1 #end

// Right side wall.

        #declare Z = -6 #while ( Z <= 7 )
        #declare Y = 0 #while ( Y <= 6 )

                        object { Wall_Tile

                                // Spin it around.
                                translate < -6, -6, 0 >
                                rotate z * ( 90 * int ( rand(R1)*100 ) )
                                translate < 6, 6, 0 >

                                rotate < 0, 90, 0 >
                                translate < 7*12, Y*12, (Z+1)*12 >

                                } // End of object.

                        #declare Count_Wall = Count_Wall + 1

        #declare Y = Y + 1 #end
        #declare Z = Z + 1 #end

// Front wall.

        #declare X = -7 #while ( X <= 6 )
        #declare Y = 0 #while ( Y <= 6 )

                        object { Wall_Tile

                                // Spin it around.
                                translate < -6, -6, 0 >
                                rotate z * ( 90 * int ( rand(R1)*100 ) )
                                translate < 6, 6, 0 >

                                rotate y * 180
                                translate < (X+1)*12, Y*12, -6*12 >

                                } // End of object.

                        #declare Count_Wall = Count_Wall + 1

        #declare Y = Y + 1 #end
        #declare X = X + 1 #end

// Add the triangles to the grand total.

        #declare Count_Triangles = Count_Triangles +
                ( Count_Wall * Count_Temp )

#end

//------------------------------------------------------------------->
//
// The jumbled wires.

#if ( Show_Wires = on )

        #include "wires.inc"

        object { Wires scale < 1, 1, 0.5 >

                // Move to front of original oven.
                        translate < -7.5, 0.8, -6 >

                // Now move to new oven location.
                        translate y * (2.5*12)
                        rotate y * -20
                        translate x * (1*12)

                } // End of object.

        // Big computer chip.
                union {

                // Base.
                box { <0,0,0><6,2,6>
                        pigment { Gray50 }
                        normal { crackle 0.1 scale 0.1 }
                        } // End of box.

                // CPU.
                box { <0.5,2.5,0.5><5.5,3,5.5>
                        pigment { image_map{gif "cpu.gif" interpolate 2 }
                                scale<6,6,6> rotate x*90 }
                        } // End of box.

                // Gold pins.
                box { <0.5,2,0.5><5.5,2.5,5.5>
                        pigment{checker BrightGold,Black scale<0.1,100,0.1>}
                        } // End of box.

                // Connector to laptop.
                cylinder {<1,1, 6>< 1,1,10>,0.5 pigment{SteelBlue}}
                cylinder {<1,1,10><-8,1,10>,0.5 pigment{SteelBlue}}
                sphere {<1,1,10>,0.5 pigment{SteelBlue}}

                        // Move to left of original oven.
                                translate < -23, 0, -5 >
                        // Now move to new oven location.
                                translate y*(2.5*12)
                                rotate y * -20
                                translate x * (1*12)

                } // End of union.

#end

//------------------------------------------------------------------->
//
// Show the grand total of triangles.

        #debug concat ( "Number of floor blocks: ",
                str ( Count_Floor, 0, 0 ), "\n" )
        #debug concat ( " Number of wall blocks: ",
                str ( Count_Wall, 0, 0 ), "\n" )
        #debug concat ( "   Number of triangles: ",
                str ( Count_Triangles, 0, 0 ), "\n" )

//------------------------------------------------------------------->
//
// End of this file.

