
//------------------------------------------------------------------->
//
// oven.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the "Oven" object.

//------------------------------------------------------------------->
//
// Spiral texture for the burners.

        #declare T_Spiral_Burner = texture {

                pigment { spiral1 1

                color_map { [ 0.0, 0.3 color OrangeRed color OrangeRed ]
                            [ 0.3, 0.4 color OrangeRed color Gray20    ]
                            [ 0.4, 1.0 color Gray20    color Gray20    ] }

                } // End of pigment.

                scale < 0.5, 0.5, 0.5 >
                rotate x * 90

                } // End of texture.

//------------------------------------------------------------------->
//
// Special plastic oven texture.

        #declare T_Oven = texture {

                finish {
                        ambient 0.10
                        diffuse 0.90
                        phong 1.00
                        phong_size 35.0
                        } // End of finish.

                pigment { rgb < 0.75, 0.75, 0.45 > }

        } // End of texture.

//------------------------------------------------------------------->
//
// Well, go ahead and make something.

        #declare Oven = union {

        // Floor base.
                box { < -11.5, 0, -5.5 > < 11.5, 1, 5.5 >
                        //texture { T_Oven } }
                        pigment { Gray70 } }

        // Lower left side, with two doors.
                box { < -12, 1, -6, > < 0, 12, 6 > texture { T_Oven } }
                box { < -12, 1, -6, > < -6.1, 12, -6.1 > texture { T_Oven } }
                box { < -5.9, 1, -6, > < 0, 12, -6.1 > texture { T_Oven } }

        // Tiny door handles.
                box { < -5.8, 6, -6.1, > < -5.5, 8, -6.2 > pigment{Black} }
                box { < -6.2, 6, -6.1, > < -6.5, 8, -6.2 > pigment{Black} }

        // Middle left tunnel.

                box { < -12.5, 12, -6.5, > < 0, 15, 6.5 >texture { T_Oven } }

        // Nameplate.

                box { < 0, 0, 0 > < 1, 1, 0.1 >
                        pigment {
                        image_map { gif "sticker.gif" interpolate 2 transmit 249,1 }
                        } // End of pigment.

                        scale < 12.3, 2.8, 1 >
                        translate < -12.4, 12.1, -6.51 >

                        } // End of box.

        // Upper left side.
                box { < -12, 15, -6, > < 0, 25, 6 > texture { T_Oven } }
                // Overhang to make shadow.
                box { < -12.1, 25, -6.1, > < 0.1, 25.1, 6.1 > texture { T_Oven } }

        // Little LED lights on upper left side.
                #declare X = -11 #while ( X <= -2 )
                #declare Y =  18 #while ( Y <= 22 )

                        box { < X+0.25, Y+0.0, -6 > < X+0.75, Y+0.5, -6.1 >
                                pigment { Black } }

                        #declare TEMP = int(rand(R1)*3)
                        #if(TEMP=0) #declare TEMP_PIG=Yellow #end
                        #if(TEMP=1) #declare TEMP_PIG=Green  #end
                        #if(TEMP=2) #declare TEMP_PIG=Red    #end

                        box { < X+0.35, Y+0.1, -6 > < X+0.65, Y+0.4, -6.2 >
                                pigment{TEMP_PIG} }

                #declare Y = Y + 1 #end
                #declare X = X + 1 #end

        // Top handle on left side.
                box { < -10, 27, -1, > < -2, 28, 1 > texture { T_Oven } }
                box { < -10, 25, -1, > < -9, 27, 1 > texture { T_Oven } }
                box { <  -3, 25, -1, > < -2, 27, 1 > texture { T_Oven } }

        // Lower right side (open).
                // Back.
                box { < 0, 1, 5.9, > < 12, 12, 6 > texture { T_Oven } }
                // Right.
                box { < 11.9, 1, -6, > < 12, 12, 6 > texture { T_Oven } }
                // Floor.
                box { < 0, 1, -6, > < 11.9, 1.1, 5.9 > texture { T_Oven } }

        // Stuff on floor of lower right side.

                // Circuit board.
                box { < 0.5, 1.4, -5.5, > < 11, 1.5, 4.5 >
                        pigment { SpringGreen } }

                #declare X = 1 #while ( X <= 9 )
                #declare Z = -5 #while ( Z <= 3 )

                        // Chip.
                        box { < X, 1.7, Z > < X+1.5, 2.0, Z+1 >
                                pigment { Black } }

                        // Legs.
                        box { < X+0.1, 1.5, Z-0.1 >< X+1.4, 1.9, Z+0.1 >
                                pigment{checker Silver,Black
                                scale < 0.1, 10, 10 > } }

                #declare Z = Z + 2 #end
                #declare X = X + 2 #end

        // Right side tunnel.
                difference {
                        box { <  0.0, 12.0, -6.5, > < 12.5, 15.0, 6.5 > }
                        box { < -0.1, 12.2, -6.3, > < 12.6, 14.8, 6.3 > }
                        texture { T_Oven }
                } // End of difference.

        // Burners.
                #declare X = 3.5 #while ( X <= 8.5 )
                #declare Z = -3 #while ( Z <= 3 )

                // Hot part.
                cylinder { < 0, 0, 0 > < 0, 0.2, 0 >, 2
                        texture { T_Spiral_Burner }
                        translate < X, 15, Z > }

                // Chrome trim.
                cylinder { < 0, 0, 0 > < 0, 0.1, 0 >, 2.3
                        texture { T_Silver_5A }
                        translate < X, 15, Z > }

                #declare Z = Z + 6 #end
                #declare X = X + 5 #end

        // Knobs.
                // Outer black edge.
                cylinder { <3.5,13.5,-6.5><3.5,13.5,-6.55>,1.05 pigment{Black} }
                cylinder { <8.5,13.5,-6.5><8.5,13.5,-6.55>,1.05 pigment{Black} }

                // Big chrome.
                cone { <3.5,13.5,-6.5>,1 <3.5,13.5,-6.7>,0.7 texture{T_Silver_5A} }
                cone { <8.5,13.5,-6.5>,1 <8.5,13.5,-6.7>,0.7 texture{T_Silver_5A} }

                // Center black part.
                cone { <3.5,13.5,-6.5>,0.4 <3.5,13.5,-7>,0.3 pigment{Gray30} }
                cone { <8.5,13.5,-6.5>,0.4 <8.5,13.5,-7>,0.3 pigment{Gray30} }



        } // End of union.

//------------------------------------------------------------------->
//
// End of this file.

