
//------------------------------------------------------------------->
//
// p4def_02.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the guy (Tony) watching the "Easy POV Oven".
//
//------------------------------------------------------------------->
//
// Declare the *textures* for everything.

        #declare P4_Eye_Texture = texture { pigment { Sapphire_Agate } }
        #declare P4_Glasses_Texture = texture { pigment{White} }

        #declare P4_Hair_Texture = texture {
                pigment { Brown_Agate } }

        #declare P4_Hat_Texture = texture {
                pigment { MandarinOrange }
                finish { F_MetalA }
                normal { bumps 0.3 scale 2 } }

        #declare P4_Shirt_Texture = texture {
                pigment {
                        image_map { gif "shirt-1.gif" interpolate 2 once }
                        translate < -0.5, 0, 0 >
                        scale < 26, 24, 24 >
                        } // End of pigment.
                normal { bumps 0.5 scale 2 }
                } // End of texture.

        #declare P4_Shoe_Texture = texture { pigment{Gray20} }

        #declare P4_Shorts_Texture = texture { T_Stone21 scale 3
                normal { bumps 0.2 scale 2 } }

        #declare P4_Skin_Texture = texture {
                pigment { Tan }
                normal { crackle 0.02 scale 0.5 } }

//------------------------------------------------------------------->
//
// Now choose *types* of things. You will have to read the directions
// to see what numbers are legal here!

        #declare P4_Eye_Type = 1
        #declare P4_Glasses_Type = 0
        #declare P4_Hair_Type = 1
        #declare P4_Hand_Type = 2
        #declare P4_Hat_Type = 1
        #declare P4_Mouth_Type = 2
        #declare P4_Nose_Type = 2
        #declare P4_Shirt_Type = 2
        #declare P4_Shoe_Type = 1
        #declare P4_Shorts_Type = 3

//------------------------------------------------------------------->
//
// Set the sizes of various things.

        #declare P4_Leg_Length = 34
        #declare P4_Neck_Height = 3
        #declare P4_Shirt_Height = 24
        #declare P4_Shorts_Height = 14

//------------------------------------------------------------------->
//
// Choose the rotation values. Please read the directions!

        #declare P4_Hat_Rotate = < -10, 120-30, 0 >
        #declare P4_Neck_Rotate = < -10, -10, 0 >
        #declare P4_Waist_Rotate = < -10, 0, 0 >

        #declare P4_Left_Hand_Rotate = < 30, 0, 0 >
        #declare P4_Right_Hand_Rotate = < 80, 0, 0 >

        #declare P4_Left_Elbow_Rotate = < 0, -40, 0 >
        #declare P4_Right_Elbow_Rotate = < 0, 40, 0 >

        #declare P4_Left_Eyelid_Rotate = -20
        #declare P4_Right_Eyelid_Rotate = -20

        #declare P4_Left_Knee_Rotate = < -10, 0, 0 >
        #declare P4_Right_Knee_Rotate = < -10, 0, 0 >

        #declare P4_Left_Leg_Rotate = < 10, 0, -10 >
        #declare P4_Right_Leg_Rotate = < 10, 0, 10 >

        #declare P4_Left_Shoulder_Rotate = < -30, -30,  40 >
        #declare P4_Right_Shoulder_Rotate = < 0, 50, -60 >

//------------------------------------------------------------------->
//
// Create the optional "holding" object. This will go into the left
// hand, and move with the hand. This is optional - just comment it
// out if not needed, and set the flag to "false".
//
// The flag is necessary to prevent person #2 from carrying the object
// that you gave to person #1. Set it to true or false.

        #declare P4_Holding_Flag = false

//------------------------------------------------------------------->
//
// Make another optional object - a "bracelet". This also has a flag
// to set on/off. This prevents duplicate bracelets! The bracelet
// should be at <0,0,0>, just like a standard torus.

        #declare P4_Bracelet_Flag = false

//------------------------------------------------------------------->
//
// Despite my attempts at using "realistic inches" as units, the
// people always seem to end up 8 or 9 feet tall. This variable lets
// you scale the person down to a normal size. Use the P4_TEST.POV
// scene to see how tall your person actually is!

        #declare P4_Total_Scale = 80/100

//------------------------------------------------------------------->
//
// This is the height to move the person up, so his/her feet are on
// the floor. Sorry, but because of bendable legs, this has to be
// adjusted manually (by YOU). 8-)

        #declare P4_Y_Adjust = 33

//------------------------------------------------------------------->
//
// Now call "p4_main.inc" to create the object.

        #include "p4_main.inc"

//------------------------------------------------------------------->
//
// End of this file.


