
// Persistence of Vision Ray Tracer Scene Description File
// File: Ezekiel.inc
// Vers: 3
// Desc: General Include file for Ezekiel pic
// Date: 4th October, 1996
// Auth: Mick McMullin

#version 3


// -------------------------------
// Colors used...
// -------------------------------

#declare Black   = rgb 0
#declare White   = rgb 1


#declare Ship_Body_Color = texture {

                                    pigment { rgb <0.5, 0.5, 0.5> }
                                    finish { ambient 0 }
                                   }
#declare Dome_Color      = texture {
                                    pigment { rgb 1 }
                                    finish {  irid {
                                                  0.4 // amount of saturation (0...1) [0]
                                                  thickness 0.2
                                                  turbulence 0.7
                                                  }
                                               ambient 0
                                            } // **END FINISH
                                   } //**END TEXTURE
#declare Shiny_Silver_1  = texture { pigment { rgb 0.6 } finish { ambient 0 reflection 0.4 } }
#declare Shiny_Silver_2  = texture { pigment { rgb 0.9 } finish { ambient 0 reflection 0.8 } }



// -------------------------------
// Lights used...
// -------------------------------

#declare Main_Light_1 = light_source
         {
             <-30, 30, -30>
             color rgb 1.0
             area_light <8,0,0>, <0,0,8>, 5, 5
//             [ adaptive ADAPTIVE ]
//             [ jitter JITTER ]
//             [ looks_like { OBJECT } ]
             fade_distance 40
             fade_power 2
             atmospheric_attenuation off
//             [ shadowless ]
         }


#declare Subtle_Spotlight_1 = light_source
         {
           <30, 50, -40>
           color rgb 0.3
           //area_light <8,2,0>, <0,0,8>, 5, 5
           spotlight
           point_at <0, 0, 0>
           radius 3       // hotspot (inner, in degrees)
           tightness 70   // tightness of falloff (1...100) lower is softer, higher is tighter
           falloff 5      // intensity falloff radius (outer, in degrees)
           atmospheric_attenuation on
          }



#declare Flame_Light_1 = light_source
         {
             <0, 0, 0>
             color red 0.3 green 1 blue 1
             area_light <1,0,0>, <0,1,0>, 2, 2
             fade_distance 10
             fade_power 2
         }



// for testing scenes...
#declare Main_Light_1_test = light_source
         {
             <-30, 30, -30>
             color rgb 1.0
             fade_distance 40
             fade_power 2
         }
