
// Persistence of Vision Ray Tracer Scene Description File
// File: Spaceship.inc
// Vers: 3
// Desc: Include file for spaceship descriptions
// Date: 4th October, 1996
// Auth: Mick McMullin

#version 3

// -------------------------------
// Main Variables
// -------------------------------
#declare Axis1_rotate = 0         // amount to rotate wheels
#declare Axis2_rotate = EXTEND    // amount to rotate wheel direction
#declare Axis3_rotate = EXTEND    // amount to rotate lower area
#declare Axis4_rotate = 0         // amount to rotate higher area

#if (Axis3_rotate > 40)
    #declare Axis4_rotate = Axis3_rotate - 40
    #declare Axis3_rotate = 40
#end

#if (Axis4_rotate > 40)
    #declare Axis4_rotate = 40
#end


// -------------------------------
// Main Spaceship Shapes
// -------------------------------

#declare Ship_Top_Body = difference
         {
           cone { <0,0,0>, 1.15, <0,0.5,0>, 0.65 }
           sphere { <0, 0.5, 0> 0.6 }
           texture { Ship_Body_Color }
         }

#declare Ship_Bottom_Body = object
         {
           cone { <0,0,0>, 1.15, <0,-0.25,0>, 0.6 }
           texture { Ship_Body_Color }
         }

#declare Ship_Dome = object
         {
           sphere { <0, 0.53, 0> 0.5 }
           texture { Dome_Color }
         }

// ------------------------------------
// Wheel attachments
// ------------------------------------

#declare Attachment_1 = difference
         {
           box { <-0.125, -0.125, -0.25>, <0.125, 0.7, 0> }
           cylinder { <-0.2, 0.5, -0.25>, <0.2, 0.5, -0.25>, 0.125 }
           cylinder { <0, 0.5, -0.25>, <0, -0.125, -0.25>, 0.06 }
           cylinder { <-0.2, -0.125, -0.25>, <0.2, -0.125, -0.25>, 0.125 }
           cylinder { <0, -0.125, -0.25>, <0, -0.125, 0.125>, 0.06 }
           texture { Ship_Body_Color }
         }

#declare Axis_1 = union
         {
          superellipsoid { <0.3, 1.0>
                           texture { Ship_Body_Color }
                           scale <0.1, 0.2, 0.2>
                           translate <-0.2, -0.125, 0.8>
                         }
          superellipsoid { <0.3, 1.0>
                          texture { Ship_Body_Color }
                          scale <0.1, 0.2, 0.2>
                          translate <0.2, -0.125, 0.8>
                         }
         }

#declare Axis_2 = union
         {
           object { Axis_1 }
           object { cylinder { <0, -0.125, 0.625>, <0, -0.125, 0.8>, 0.055 }
                    texture { Shiny_Silver_2 } }
           object { cylinder { <-0.1, -0.125, 0.8>, <0.1, -0.125, 0.8>, 0.055 }
                    texture { Shiny_Silver_2 } }
           object { cylinder { <-0.4, -0.125, 0.8>, <0.4, -0.125, 0.8>, 0.035 }
                    texture { Shiny_Silver_2 } }
           object { cylinder { <-0.35, -0.125, 0.8>, <-0.2, -0.125, 0.8>, 0.07 }
                    texture { Shiny_Silver_2 } }
           object { cylinder { <0.35, -0.125, 0.8>, <0.2, -0.125, 0.8>, 0.07 }
                    texture { Shiny_Silver_2 } }
           translate <0, 0.125, 0>
           rotate z * Axis2_rotate
           translate <0, -0.125, 0>
         }

#declare Axis_3 = union
         {
           object { Axis_2 }
           difference { cylinder { <-0.21, -0.125, -0.25>, <0.21, -0.125, -0.25>, 0.125 }
                        cylinder { <-0.22, -0.125, -0.25>, <-0.2, -0.125, -0.25>, 0.1 }
                        cylinder { <0.22, -0.125, -0.25>, <0.2, -0.125, -0.25>, 0.1 }
                        box { <-0.065, -0.125, 0>, <0.065, 0, -0.375> }
                        texture { Shiny_Silver_1 }
                      }
           object { cylinder { <0, -0.125, -0.5>, <0, -0.125, 0.125>, 0.055 }
                    texture { Shiny_Silver_2 }
                  }
           object { box { <-0.15, -0.2, 0.125>, <0.15, -0.05, 0.25 > }
                    texture { Ship_Body_Color }
                  }
           object { cylinder { <-0.05, -0.125, 0.25>, <-0.05, -0.125, 0.5>, 0.04 }
                    texture { Shiny_Silver_2 }
                  }
           object { cylinder { <0.05, -0.125, 0.25>, <0.05, -0.125, 0.5>, 0.04 }
                    texture { Shiny_Silver_2 }
                  }
           object { box { <-0.15, -0.2, 0.5>, <0.15, -0.05, 0.625 > }
                    texture { Ship_Body_Color }
                  }
           translate <0, 0.125, 0.25>
           rotate x * Axis3_rotate
           translate <0, -0.125, -0.25>
         }


#declare Axis_4 = union
         {
           object { Axis_3 }
           difference { cylinder { <-0.21, 0.5, -0.25>, <0.21, 0.5, -0.25>, 0.125 }
                        cylinder { <-0.22, 0.5, -0.25>, <-0.2, 0.5, -0.25>, 0.1 }
                        cylinder { <0.22, 0.5, -0.25>, <0.2, 0.5, -0.25>, 0.1 }
                        box { <-0.065, 0.375, 0>, <0.065, 0.5, -0.375> }
                        texture { Shiny_Silver_1 }
                      }
           object { cylinder { <0, 0.5, -0.25>, <0, -0.125, -0.25>, 0.055 }
                    texture { Shiny_Silver_2 }
                  }
           translate <0, -0.5, 0.25>
           rotate x * Axis4_rotate
           translate <0, 0.5, -0.25>
         }



#declare Attachments = union
         {
           object { Attachment_1 }
           object { Axis_4 }
           rotate x*45
           translate <0, 0, -1.14>
         }

#declare Jet_Flame =   sphere { 0, 1
                       pigment { color rgbt <1, 1, 1, 1> }
                       halo {
                            emitting
                            spherical_mapping
                            linear
                            turbulence SMOKE    //1.5
                            color_map {
                                      [ 0.0 color rgbt <0, 1, 1,  1> ]
                                      [ 0.4 color rgbt <1, 1, 1, -1> ]
                                      [ 1.0 color rgbt <0, 1, 0.4,  1> ]
                                      }
                            frequency 2
                            samples 20
                            scale 0.5
                            }
                       hollow
                       no_shadow
                      }


#declare Spaceship = union {
                           object { Ship_Top_Body }
                           object { Ship_Bottom_Body }
                           object { Ship_Dome }
                           object { Flame_Light_1 translate <0, -0.26, 0> }
                           object { Jet_Flame translate <0, -0.4, 0> }
                           object { Attachments }
                           object { Attachments rotate y*90 }
                           object { Attachments rotate y*180}
                           object { Attachments rotate y*270}
                           }
