#declare WARM =
union{
polygon{
    5,
    <0.5,0,1>, <0.5,-6,1>, <0.5,-6,-1>, <0.5,0,-1>, <0.5,0,1>
}
polygon{
    5,
    <-0.5,0,1>, <-0.5,-6,1>, <-0.5,-6,-1>, <-0.5,0,-1>, <-0.5,0,1>
}
polygon{
    5,
    <0.5,0,1>, <0.5,-6,1>, <-0.5,-6,1>, <-0.5,0,1>, <0.5,0,1>
}
polygon{
    5,
    <0.5,0,-1>, <0.5,-6,-1>, <-0.5,-6,-1>, <-0.5,0,-1>, <0.5,0,-1>
}
polygon{
    5,
    <1,-6,6>, <1,-6,-3>, <-1,-6,-3>, <-1,-6,6>, <1,-6,6>
}
polygon{
    5,
    <1,-6,6>, <2,-7,6>, <2,-7,-3>, <1,-6,-3>, <1,-6,6>
}
polygon{
    5,
    <-1,-6,6>, <-2,-7,6>, <-2,-7,-3>, <-1,-6,-3>, <-1,-6,6>
}
polygon{
    5,
    <2,-7,6>, <2,-9,6>, <2,-9,-3>, <2,-7,-3>, <2,-7,6>
}
polygon{
    5,
    <-2,-7,6>, <-2,-9,6>, <-2,-9,-3>, <-2,-7,-3>, <-2,-7,6>
}
//begin hazard panelling
//polygon{
//    5,
//    <1,-10,6>, <1,-10,-3>, <-1,-10,-3>, <-1,-10,6>, <1,-10,6>
//}
polygon{
    5,
    <1,-10,6>, <0.9,-9.9,5.9>, <-0.9,-9.9,5.9>, <-1,-10,6>, <1,-10,6>
}
polygon{
    5,
    <1,-10,-3>, <0.9,-9.9,-2.9>, <-0.9,-9.9,-2.9>, <-1,-10,-3>, <1,-10,-3>
}
polygon{
    5,
    <1,-10,6>, <0.9,-9.9,5.9>, <0.9,-9.9,-2.9>, <1,-10,-3>, <1,-10,6>
}
polygon{
    5,
    <-1,-10,6>, <-0.9,-9.9,5.9>, <-0.9,-9.9,-2.9>, <-1,-10,-3>, <-1,-10,6>
}

polygon{
    5,
    <0.9,-9.9,5.9>, <0.9,-9.9,-2.9>, <-0.9,-9.9,-2.9>, <-0.9,-9.9,5.9>, <0.9,-9.9,5.9>
}

polygon{
    5,
    <0.8,-9.9,5.8>, <0.8,-9.9,-2.8>, <0.7,-10,-2.8>, <0.7,-10,5.8>, <0.8,-9.9,5.8>
}
polygon{
    5,
    <-0.8,-9.9,5.8>, <-0.8,-9.9,-2.8>, <-0.7,-10,-2.8>, <-0.7,-10,5.8>, <-0.8,-9.9,5.8>
}
polygon{
    5,
    <0.8,-9.9,5.8>, <-0.8,-9.9,5.8>, <-0.7,-10,5.7>, <0.7,-10,5.7>, <0.8,-9.9,5.8>
}
polygon{
    5,
    <0.8,-9.9,-2.8>, <-0.8,-9.9,-2.8>, <-0.7,-10,-2.7>, <0.7,-10,-2.7>, <0.8,-9.9,-2.8>
}

polygon{
    10,
    <0.7,-10,5.7>, <0.7,-10,-2.7>, <-0.7,-10,-2.7>, <-0.7,-10,5.7>, <0.7,-10,5.7>,
    <0.6,-10,5.6>, <0.6,-10,-2.6>, <-0.6,-10,-2.6>, <-0.6,-10,5.6>, <0.6,-10,5.6>
}

polygon{
    40,
    <0,-10,5.6>, <0.6,-10,5.6>, <-0.6,-10,4.4>, <-0.6,-10,5>, <0,-10,5.6>,
    <0.6,-10,5>, <0.6,-10,4.4>, <-0.6,-10,3.2>, <-0.6,-10,3.8>, <0.6,-10,5>,
    <0.6,-10,3.8>, <0.6,-10,3.2>, <-0.6,-10,2>, <-0.6,-10,2.6>, <0.6,-10,3.8>,
    <0.6,-10,2.6>, <0.6,-10,2>, <-0.6,-10,0.8>, <-0.6,-10,1.4>, <0.6,-10,2.6>,
    <0.6,-10,1.4>, <0.6,-10,0.8>, <-0.6,-10,-0.4>, <-0.6,-10,0.2>, <0.6,-10,1.4>,
    <0.6,-10,0.2>, <0.6,-10,-0.4>, <-0.6,-10,-1.6>, <-0.6,-10,-1>, <0.6,-10,0.2>,
    <0.6,-10,-1>, <0.6,-10,-1.6>, <-0.4,-10,-2.6>, <-0.6,-10,-2.6>, <-0.6,-10,-2.2>, <0.6,-10,-1>,
    <0.6,-10,-2.2>, <0.6,-10,-2.6>, <0.2,-10,-2.6>, <0.6,-10,-2.2>
   pigment{color Black}
}

polygon{
    45,
    <0.6,-10,5.6>, <0.6,-10,-2.6>, <-0.6,-10,-2.6>, <-0.6,-10,5.6>, <0.6,-10,5.6>,
    <0,-10,5.6>, <0.6,-10,5.6>, <-0.6,-10,4.4>, <-0.6,-10,5>, <0,-10,5.6>,
    <0.6,-10,5>, <0.6,-10,4.4>, <-0.6,-10,3.2>, <-0.6,-10,3.8>, <0.6,-10,5>,
    <0.6,-10,3.8>, <0.6,-10,3.2>, <-0.6,-10,2>, <-0.6,-10,2.6>, <0.6,-10,3.8>,
    <0.6,-10,2.6>, <0.6,-10,2>, <-0.6,-10,0.8>, <-0.6,-10,1.4>, <0.6,-10,2.6>,
    <0.6,-10,1.4>, <0.6,-10,0.8>, <-0.6,-10,-0.4>, <-0.6,-10,0.2>, <0.6,-10,1.4>,
    <0.6,-10,0.2>, <0.6,-10,-0.4>, <-0.6,-10,-1.6>, <-0.6,-10,-1>, <0.6,-10,0.2>,
    <0.6,-10,-1>, <0.6,-10,-1.6>, <-0.4,-10,-2.6>, <-0.6,-10,-2.6>, <-0.6,-10,-2.2>, <0.6,-10,-1>,
    <0.6,-10,-2.2>, <0.6,-10,-2.6>, <0.2,-10,-2.6>, <0.6,-10,-2.2>
    pigment{color Yellow}
}
//end hazard panelling

//begin number panelling
polygon{//bottom arrow
    4,
    <2.01,-8.8,5.4>, <2.01,-8.4,5.4>, <2.01,-8.6,5.8>, <2.01,-8.8,5.4>
    pigment{color Red}
}

polygon{//top arrow
    4,
    <2.01,-7.2,5.4>, <2.01,-7.6,5.4>, <2.01,-7.4,5.8>, <2.01,-7.2,5.4>
    pigment{color Red}
}

polygon{//number 8
    25,
    <2.01,-7.2,3>, <2.01,-7.2,2.6>, <2.01,-7.4,2.4>, <2.01,-7.6,2.4>, <2.01,-7.7,2.5>, <2.01,-7.8,2.4>, <2.01,-8,2.4>, <2.01,-8.2,2.6>, <2.01,-8.2,3>, <2.01,-7.8,3.2>, <2.01,-7.6,3.2>, <2.01,-7.7,3.1>, <2.01,-7.6,3.2>, <2.01,-7.4,3.2>, <2.01,-7.2,3>,
    <2.01,-7.4,3>, <2.01,-7.4,2.6>, <2.01,-7.6,2.6>, <2.01,-7.6,3>, <2.01,-7.4,3>,
    <2.01,-7.8,3>, <2.01,-7.8,2.6>, <2.01,-8,2.6>, <2.01,-8,3>, <2.01,-7.8,3>
    pigment{color Black}
    finish{phong 1}
}
polygon{//number 5
    15,
    <2.01,-7.2,2.2>, <2.01,-7.2,1.4>, <2.01,-7.4,1.4>, <2.01,-7.4,2>, <2.01,-7.6,2>,
    <2.01,-7.6,1.6>, <2.01,-7.8,1.4>, <2.01,-8,1.4>, <2.01,-8.2,1.6>, <2.01,-8.2,2.2>,
    <2.01,-8,2.2>, <2.01,-8,1.6>, <2.01,-7.8,1.6>, <2.01,-7.8,2.2>, <2.01,-7.2,2.2>
    pigment{color Black}
    finish{phong 1}
}
polygon{//number 1
    5,
    <2.01,-7.2,1.2>, <2.01,-7.2,1>, <2.01,-8.2,1>, <2.01,-8.2,1.2>, <2.01,-7.2,1.2>
    pigment{color Black}
    finish{phong 1}
}
polygon{//number 2
    15,
    <2.01,-7.2,0>, <2.01,-7.2,0.8>, <2.01,-7.4,0.8>, <2.01,-7.4,0.2>, <2.01,-7.6,0.2>,
    <2.01,-7.6,0.6>, <2.01,-7.8,0.8>, <2.01,-8,0.8>, <2.01,-8.2,0.6>, <2.01,-8.2,0>,
    <2.01,-8,0>, <2.01,-8,0.6>, <2.01,-7.8,0.6>, <2.01,-7.8,0>, <2.01,-7.2,0>
    pigment{color Black}
    finish{phong 1}
}
polygon{//number 8
    25,
    <2.01,-7.2,-0.4>, <2.01,-7.2,-0.8>, <2.01,-7.4,-1>, <2.01,-7.6,-1>, <2.01,-7.7,-0.9>, <2.01,-7.8,-1>, <2.01,-8,-1>, <2.01,-8.2,-0.8>, <2.01,-8.2,-0.4>, <2.01,-7.8,-0.2>, <2.01,-7.6,-0.2>, <2.01,-7.7,-0.3>, <2.01,-7.6,-0.2>, <2.01,-7.4,-0.2>, <2.01,-7.2,-0.4>,
    <2.01,-7.4,-0.4>, <2.01,-7.4,-0.8>, <2.01,-7.6,-0.8>, <2.01,-7.6,-0.4>, <2.01,-7.4,-0.4>,
    <2.01,-7.8,-0.4>, <2.01,-7.8,-0.8>, <2.01,-8,-0.8>, <2.01,-8,-0.4>, <2.01,-7.8,-0.4>
    pigment{color Black}
    finish{phong 1}
}//end number panelling

//begin CLAN SIGNAT
polygon{
    7,
    <-2.0009,-8.6,2.6>, <-2.0009,-8.6,1.4>, <-2.0009,-8.2,1.4>, <-2.0009,-7.85,1.9>,
    <-2.0009,-7.85,2.1>, <-2.0009,-8.2,2.6>, <-2.0009,-8.6,2.6>
    pigment{color rgb < 0, 0.5, 0>}
}

polygon{
    4,
    <-2.001,-8.5,2.5>, <-2.001,-8.4,2.05>, <-2.001,-8.3,2.15>, <-2.001,-8.5,2.5>
    pigment{color White}
}
polygon{
    4,
    <-2.001,-8.5,1.5>, <-2.001,-8.4,1.95>, <-2.001,-8.3,1.85>, <-2.001,-8.5,1.5>
    pigment{color White}
}
polygon{
    6,
    <-2.001,-8.3,2.1>, <-2.001,-8.275,2.05>, <-2.001,-8.25,2.1>, <-2.001,-8.15,2.05>, <-2.001,-8.25,2.15>, <-2.001,-8.3,2.1>
    pigment{color Black}
}
polygon{
    6,
    <-2.001,-8.3,1.9>, <-2.001,-8.275,1.95>, <-2.001,-8.25,1.9>, <-2.001,-8.15,1.95>, <-2.001,-8.25,1.85>, <-2.001,-8.3,1.9>
    pigment{color Black}
}
polygon{
    8,
    <-2.001,-8.1,2.2>, <-2.001,-8.05,2.15>, <-2.001,-7.9,2.2>, <-2.001,-7.85,2.2>, <-2.001,-7.5,2.15>,
    <-2.001,-7.8,2.25>, <-2.001,-8,2.25>, <-2.001,-8.1,2.2>
    pigment{color White}
}
polygon{
    8,
    <-2.001,-8.1,1.8>, <-2.001,-8.05,1.85>, <-2.001,-7.9,1.8>, <-2.001,-7.85,1.8>, <-2.001,-7.5,1.85>,
    <-2.001,-7.8,1.75>, <-2.001,-8,1.75>, <-2.001,-8.1,1.8>
    pigment{color White}
}

//end SIGNAT

polygon{
    5,
    <1,-10,6>, <2,-9,6>, <2,-9,-3>, <1,-10,-3>, <1,-10,6>
}
polygon{
    5,
    <-1,-10,6>, <-2,-9,6>, <-2,-9,-3>, <-1,-10,-3>, <-1,-10,6>
}
polygon{
    9,
    <1,-6,-3>, <2,-7,-3>, <2,-9,-3>, <1,-10,-3>,
    <-1,-10,-3>, <-2,-9,-3>, <-2,-7,-3>, <-1,-6,-3>,
    <1,-6,-3>
}
polygon{
    5,
    <1,-6,6>, <1,-7,8>, <-1,-7,8>, <-1,-6,6>, <1,-6,6>
}
polygon{
    4,
    <1,-6,6>, <1,-7,8>, <2,-7,6>, <1,-6,6>
}
polygon{
    4,
    <-1,-6,6>, <-1,-7,8>, <-2,-7,6>, <-1,-6,6>
}
polygon{
    5,
    <1,-10,6>, <1,-9,8>, <-1,-9,8>, <-1,-10,6>, <1,-10,6>
}
polygon{
    4,
    <1,-10,6>, <1,-9,8>, <2,-9,6>, <1,-10,6>
}
polygon{
    4,
    <-1,-10,6>, <-1,-9,8>, <-2,-9,6>, <-1,-10,6>
}
polygon{
    5,
    <2,-7,6>, <2,-9,6>, <1,-9,8>, <1,-7,8>, <2, -7, 6>
}
polygon{
    5,
    <-2,-7,6>, <-2,-9,6>, <-1,-9,8>, <-1,-7,8>, <-2, -7, 6>
}
polygon{
    9,
    <1,-6,6>, <2,-7,6>, <2,-9,6>, <1,-10,6>,
    <-1,-10,6>, <-2,-9,6>, <-2,-7,6>, <-1,-6,6>,
    <1,-6,6>
}
polygon{
    4,
    <1,-7,8>, <-1,-7,8>, <0,-8,6>, <1,-7,8>
}
polygon{
    4,
    <1,-9,8>, <-1,-9,8>, <0,-8,6>, <1,-9,8>
}
polygon{
    4,
    <-1,-7,8>, <-1,-9,8>, <0,-8,6>, <-1,-7,8>
}
polygon{
    4,
    <1,-7,8>, <1,-9,8>, <0,-8,6>, <1,-7,8>
}
}

#declare S_MISSILE =
lathe{

   12,

   <0,4.25>,<0.1875,4>,<0.25,3.75>,<0.25,3.625>,<0.1875,3.625>,<0.1875,0.625>,
   <0.25,0.5>,<0.25,0>,<0.125,0>,<0.125,0.375>,<0,0.5>,<0,4.25>

   pigment{color Red}
   rotate<90,0,0>
}

#declare STILLETO =
union{
polygon{//begin nose segment
    5,
    <1,1,24>, <1,2,22>, <-1,2,22>, <-1,1,24>, <1,1,24>
}
polygon{
    4,
    <1,1,24>, <1,2,22>, <1.25,1.25,22.5>, <1,1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <1,1,24>, <2,1,22>, <1.25,1.25,22.5>, <1,1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <1,2,22>, <2,1,22>, <1.25,1.25,22.5>, <1,2,22>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,1,24>, <-1,2,22>, <-1.25,1.25,22.5>, <-1,1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,1,24>, <-2,1,22>, <-1.25,1.25,22.5>, <-1,1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,2,22>, <-2,1,22>, <-1.25,1.25,22.5>, <-1,2,22>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <1,1,24>, <2,1,22>, <2,-1,22>, < 1,-1,24>, <1,1,24>
}
polygon{
    5,
    <-1,1,24>, <-2,1,22>, <-2,-1,22>, < -1,-1,24>, <-1,1,24>
}
polygon{
    5,
    <1,-1,24>, <1,-2,22>, <-1,-2,22>, <-1,-1,24>, <1,-1,24>
}
polygon{
    4,
    <1,-1,24>, <1,-2,22>, <1.25,-1.25,22.5>, <1,-1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <1,-1,24>, <2,-1,22>, <1.25,-1.25,22.5>, <1,-1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <1,-2,22>, <2,-1,22>, <1.25,-1.25,22.5>, <1,-2,22>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,-1,24>, <-1,-2,22>, <-1.25,-1.25,22.5>, <-1,-1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,-1,24>, <-2,-1,22>, <-1.25,-1.25,22.5>, <-1,-1,24>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    4,
    <-1,-2,22>, <-2,-1,22>, <-1.25,-1.25,22.5>, <-1,-2,22>
    pigment{color rgb<0.1,0.6,0.1>}
}

polygon{//front cap
    10,
    <1,1,24>, <-1,1,24>, <-1,-1,24>, <1,-1,24>, <1,1,24>
    <0.75,0.75,24>, <-0.75,0.75,24>, <-0.75,-0.75,24>, <0.75,-0.75,24>, <0.75,0.75,24>
}
polygon{
    5,
    <0.5,0.5,23.5>, <-0.5,0.5,23.5>, <-0.5,-0.5,23.5>, <0.5,-0.5,23.5>, <0.5,0.5,23.5>
}
polygon{
    5,
    <0.75,0.75,24>, <0.5,0.5,23.5>, <-0.5,0.5,23.5>, <-0.75,0.75,24>, <0.75,0.75,24>
}
polygon{
    5,
    <0.75,-0.75,24>, <0.5,-0.5,23.5>, <-0.5,-0.5,23.5>, <-0.75,-0.75,24>, <0.75,-0.75,24>
}
polygon{
    5,
    <0.75,0.75,24>, <0.5, 0.5, 23.5>, <0.5,-0.5,23.5>, <0.75,-0.75,24>, <0.75,0.75,24>
}
polygon{
    5,
    <-0.75,0.75,24>, <-0.5, 0.5, 23.5>, <-0.5,-0.5,23.5>, <-0.75,-0.75,24>, <-0.75,0.75,24>
}
polygon{
    5,
    <0,0.75,24>, <0,0.5,23.5>, <0,-0.5,23.5>, <0,-0.75,24>, <0,0.75,24>
    pigment{Gray50}
}
polygon{
    5,
    <0.25,0.75,24>, <0.25,0.5,23.5>, <0.25,-0.5,23.5>, <0.25,-0.75,24>, <0.25,0.75,24>
    pigment{Gray50}
}
polygon{
    5,
    <0.5,0.75,24>, <0.5,0.5,23.5>, <0.5,-0.5,23.5>, <0.5,-0.75,24>, <0.5,0.75,24>
    pigment{Gray50}
}
polygon{
    5,
    <-0.25,0.75,24>, <-0.25,0.5,23.5>, <-0.25,-0.5,23.5>, <-0.25,-0.75,24>, <-0.25,0.75,24>
    pigment{Gray50}
}
polygon{
    5,
    <-0.5,0.75,24>, <-0.5,0.5,23.5>, <-0.5,-0.5,23.5>, <-0.5,-0.75,24>, <-0.5,0.75,24>
    pigment{Gray50}
}
//end nose segment

polygon{//begin cockpit section
    5,
    <1,2,22>, <1,2,16>, <-1,2,16>, <-1,2,22>, <1,2,22>
}
polygon{
    5,
    <1,2,22>, <2,1,22>, <2,1,16>, <1,2,16>, <1,2,22>
}
polygon{
    5,
    <-1,2,22>, <-2,1,22>, <-2,1,16>, <-1,2,16>, <-1,2,22>
}
polygon{
    5,
    <2,1,22>, <2,-1,22>, <2,-1,16>, <2,1,16>, <2,1,22>
}
polygon{
    5,
    <-2,1,22>, <-2,-1,22>, <-2,-1,16>, <-2,1,16>, <-2,1,22>
}
polygon{
    5,
    <1,-2,22>, <1,-2,16>, <-1,-2,16>, <-1,-2,22>, <1,-2,22>
}
polygon{
    5,
    <1,-2,22>, <2,-1,22>, <2,-1,16>, <1,-2,16>, <1,-2,22>
}
polygon{
    5,
    <-1,-2,22>, <-2,-1,22>, <-2,-1,16>, <-1,-2,16>, <-1,-2,22>
}//end cockpit section
polygon{//begin back cockpit segment
    5,
    <1,1,14>, <1,2,16>, <-1,2,16>, <-1,1,14>, <1,1,14>
}
polygon{
    4,
    <1,1,14>, <1,2,16>, <2,1,16>, <1,1,14>
}
polygon{
    4,
    <-1,1,14>, <-1,2,16>, <-2,1,16>, <-1,1,14>
}
polygon{
    5,
    <1,1,14>, <2,1,16>, <2,-1,16>, < 1,-1,14>, <1,1,14>
}
polygon{
    5,
    <-1,1,14>, <-2,1,16>, <-2,-1,16>, < -1,-1,14>, <-1,1,14>
}
polygon{
    5,
    <1,-1,14>, <1,-2,16>, <-1,-2,16>, <-1,-1,14>, <1,-1,14>
}
polygon{
    4,
    <1,-1,14>, <1,-2,16>, <2,-1,16>, <1,-1,14>
}
polygon{
    4,
    <-1,-1,14>, <-1,-2,16>, <-2,-1,16>, <-1,-1,14>
}//end back cockpit
polygon{//begin fuselage
    5,
    <1,1,14>, <1,1,4>, <-1,1,4>, <-1,1,14>, <1,1,14>
}
polygon{
    5,
    <1,-1,14>, <1,-1,4>, <-1,-1,4>, <-1,-1,14>, <1,-1,14>
}
polygon{
    5,
    <1,1,14>, <1,-1,14>, <1,-1,4>, <1,1,4>, <1,1,14>
}
polygon{
    5,
    <-1,1,14>, <-1,-1,14>, <-1,-1,4>, <-1,1,4>, <-1,1,14>
}//end fuselage
polygon{//begin engine section
    5,
    <1,1,4>, <1,2,2>, <-1,2,2>, <-1,1,4>, <1,1,4>
}
polygon{
    4,
    <1,1,4>, <1,2,2>, <2,1,2>, <1,1,4>
}
polygon{
    4,
    <-1,1,4>, <-1,2,2>, <-2,1,2>, <-1,1,4>
}
polygon{
    5,
    <1,1,4>, <2,1,2>, <2,-1,2>, < 1,-1,4>, <1,1,4>
}
polygon{
    5,
    <-1,1,4>, <-2,1,2>, <-2,-1,2>, < -1,-1,4>, <-1,1,4>
}
polygon{
    5,
    <1,-1,4>, <1,-2,2>, <-1,-2,2>, <-1,-1,4>, <1,-1,4>
}
polygon{
    4,
    <1,-1,4>, <1,-2,2>, <2,-1,2>, <1,-1,4>
}
polygon{
    4,
    <-1,-1,4>, <-1,-2,2>, <-2,-1,2>, <-1,-1,4>
}
polygon{
    5,
    <1,1,4>, <1,-1,4>, <-1,-1,4>, <-1,1,4>, <1,1,4>
}//thrust cap
//end engine section
polygon{//begin exhaust section
    5,
    <1,2,2>, <1,2,0>, <-1,2,0>, <-1,2,2>, <1,2,2>
}
polygon{
    5,
    <1,2,2>, <2,1,2>, <2,1,0>, <1,2,0>, <1,2,2>
}
polygon{
    5,
    <-1,2,2>, <-2,1,2>, <-2,1,0>, <-1,2,0>, <-1,2,2>
}
polygon{
    5,
    <2,1,2>, <2,-1,2>, <2,-1,0>, <2,1,0>, <2,1,2>
}
polygon{
    5,
    <-2,1,2>, <-2,-1,2>, <-2,-1,0>, <-2,1,0>, <-2,1,2>
}
polygon{
    5,
    <1,-2,2>, <1,-2,0>, <-1,-2,0>, <-1,-2,2>, <1,-2,2>
}
polygon{
    5,
    <1,-2,2>, <2,-1,2>, <2,-1,0>, <1,-2,0>, <1,-2,2>
}
polygon{
    5,
    <-1,-2,2>, <-2,-1,2>, <-2,-1,0>, <-1,-2,0>, <-1,-2,2>
}//end cockpit section

polygon{//begin left weapon pod
    5,
    <-2,1,21>, <-2,1,17>, <-3,1,17>, <-3,1,21>, <-2,1,21>
}
polygon{
    5,
    <-2,-1,21>, <-2,-1,17>, <-3,-1,17>, <-3,-1,21>, <-2,-1,21>
}
polygon{
    5,
    <-3,1,21>, <-3,1,17>, <-3,-1,17>, <-3,-1,21>, <-3,1,21>
}
polygon{
    5,
    <-2,1,17>, <-2,-1,17>, <-3,-1,17>, <-3,1,17>, <-2,1,17>
}
polygon{
    15,
    <-2,1,21>, <-3,1,21>, <-3,-1,21>, <-2,-1,21>, <-2,1,21>,
    <-2.125,0.875,21>, <-2.875,0.875,21>, <-2.875,0.125,21>, <-2.125,0.125,21>, <-2.125,0.875,21>
    <-2.125,-0.875,21>, <-2.875,-0.875,21>, <-2.875,-0.125,21>, <-2.125,-0.125,21>, <-2.125,-0.875,21>
}
polygon{
    5,
    <-2.125,0.875,21>, <-2.125, 0.875, 17.5>, <-2.875, 0.875, 17.5>, <-2.875, 0.875, 21>, <-2.125, 0.875, 21>
}
polygon{
    5,
    <-2.125,0.125,21>, <-2.125, 0.125, 17.5>, <-2.875, 0.125, 17.5>, <-2.875, 0.125, 21>, <-2.125, 0.125, 21>
}
polygon{
    5,
    <-2.125,-0.875,21>, <-2.125, -0.875, 17.5>, <-2.875, -0.875, 17.5>, <-2.875, -0.875, 21>, <-2.125, -0.875, 21>
}
polygon{
    5,
    <-2.125,-0.125,21>, <-2.125, -0.125, 17.5>, <-2.875, -0.125, 17.5>, <-2.875, -0.125, 21>, <-2.125, -0.125, 21>
}
polygon{
    5,
    <-2.125,0.875,21>, <-2.125, 0.875, 17.5>, <-2.125, -0.875, 17.5>, <-2.125, -0.875, 21>, <-2.125, 0.875, 21>
}
polygon{
    5,
    <-2.875,0.875,21>, <-2.875, 0.875, 17.5>, <-2.875, -0.875, 17.5>, <-2.875, -0.875, 21>, <-2.875, 0.875, 21>
}
polygon{
    4,
    <-1,2,22>, <-2,1,21>, <-3,1,21>, <-1,2,22>
}
polygon{
    4,
    <-1,2,21.75>, <-2,1,20.75>, <-3,1,20.75>, <-1,2,21.75>
}
polygon{
    5,
    <-1,2,22>, <-3,1,21>, <-3,1,20.75>, <-1,2,21.75>, <-1,2,22>
}
polygon{
    4,
    <-1,2,16>, <-2,1,17>, <-3,1,17>, <-1,2,16>
}
polygon{
    4,
    <-1,2,16.25>, <-2,1,17.25>, <-3,1,17.25>, <-1,2,16.25>
}
polygon{
    5,
    <-1,2,16>, <-3,1,17>, <-3,1,17.25>, <-1,2,16.25>, <-1,2,16>
}
polygon{
    4,
    <-1,2,19.125>, <-2,1,19.125>, <-3,1,19.125>, <-1,2,19.125>
}
polygon{
    4,
    <-1,2,18.875>, <-2,1,18.875>, <-3,1,18.875>, <-1,2,18.875>
}
polygon{
    5,
    <-1,2,19.125>, <-3,1,19.125>, <-3,1,18.875>, <-1,2,18.875>, <-1,2,19.125>
}
polygon{
    4,
    <-1,-2,22>, <-2,-1,21>, <-3,-1,21>, <-1,-2,22>
}
polygon{
    4,
    <-1,-2,21.75>, <-2,-1,20.75>, <-3,-1,20.75>, <-1,-2,21.75>
}
polygon{
    5,
    <-1,-2,22>, <-3,-1,21>, <-3,-1,20.75>, <-1,-2,21.75>, <-1,-2,22>
}
polygon{
    4,
    <-1,-2,16>, <-2,-1,17>, <-3,-1,17>, <-1,-2,16>
}
polygon{
    4,
    <-1,-2,16.25>, <-2,-1,17.25>, <-3,-1,17.25>, <-1,-2,16.25>
}
polygon{
    5,
    <-1,-2,16>, <-3,-1,17>, <-3,-1,17.25>, <-1,-2,16.25>, <-1,-2,16>
}
polygon{
    4,
    <-1,-2,19.125>, <-2,-1,19.125>, <-3,-1,19.125>, <-1,-2,19.125>
}
polygon{
    4,
    <-1,-2,18.875>, <-2,-1,18.875>, <-3,-1,18.875>, <-1,-2,18.875>
}
polygon{
    5,
    <-1,-2,19.125>, <-3,-1,19.125>, <-3,-1,18.875>, <-1,-2,18.875>, <-1,-2,19.125>
}//end left weapon pod

polygon{//begin right weapon pod
    5,
    <2,1,21>, <2,1,17>, <3,1,17>, <3,1,21>, <2,1,21>
}
polygon{
    5,
    <2,-1,21>, <2,-1,17>, <3,-1,17>, <3,-1,21>, <2,-1,21>
}
polygon{
    5,
    <3,1,21>, <3,1,17>, <3,-1,17>, <3,-1,21>, <3,1,21>
}
polygon{
    5,
    <2,1,17>, <2,-1,17>, <3,-1,17>, <3,1,17>, <2,1,17>
}
polygon{
    15,
    <2,1,21>, <3,1,21>, <3,-1,21>, <2,-1,21>, <2,1,21>,
    <2.125,0.875,21>, <2.875,0.875,21>, <2.875,0.125,21>, <2.125,0.125,21>, <2.125,0.875,21>
    <2.125,-0.875,21>, <2.875,-0.875,21>, <2.875,-0.125,21>, <2.125,-0.125,21>, <2.125,-0.875,21>
}
polygon{
    5,
    <2.125,0.875,21>, <2.125, 0.875, 17.5>, <2.875, 0.875, 17.5>, <2.875, 0.875, 21>, <2.125, 0.875, 21>
}
polygon{
    5,
    <2.125,0.125,21>, <2.125, 0.125, 17.5>, <2.875, 0.125, 17.5>, <2.875, 0.125, 21>, <2.125, 0.125, 21>
}
polygon{
    5,
    <2.125,-0.875,21>, <2.125, -0.875, 17.5>, <2.875, -0.875, 17.5>, <2.875, -0.875, 21>, <2.125, -0.875, 21>
}
polygon{
    5,
    <2.125,-0.125,21>, <2.125, -0.125, 17.5>, <2.875, -0.125, 17.5>, <2.875, -0.125, 21>, <2.125, -0.125, 21>
}
polygon{
    5,
    <2.125,0.875,21>, <2.125, 0.875, 17.5>, <2.125, -0.875, 17.5>, <2.125, -0.875, 21>, <2.125, 0.875, 21>
}
polygon{
    5,
    <2.875,0.875,21>, <2.875, 0.875, 17.5>, <2.875, -0.875, 17.5>, <2.875, -0.875, 21>, <2.875, 0.875, 21>
}
polygon{
    4,
    <1,2,22>, <2,1,21>, <3,1,21>, <1,2,22>
}
polygon{
    4,
    <1,2,21.75>, <2,1,20.75>, <3,1,20.75>, <1,2,21.75>
}
polygon{
    5,
    <1,2,22>, <3,1,21>, <3,1,20.75>, <1,2,21.75>, <1,2,22>
}
polygon{
    4,
    <1,2,16>, <2,1,17>, <3,1,17>, <1,2,16>
}
polygon{
    4,
    <1,2,16.25>, <2,1,17.25>, <3,1,17.25>, <1,2,16.25>
}
polygon{
    5,
    <1,2,16>, <3,1,17>, <3,1,17.25>, <1,2,16.25>, <1,2,16>
}
polygon{
    4,
    <1,2,19.125>, <2,1,19.125>, <3,1,19.125>, <1,2,19.125>
}
polygon{
    4,
    <1,2,18.875>, <2,1,18.875>, <3,1,18.875>, <1,2,18.875>
}
polygon{
    5,
    <1,2,19.125>, <3,1,19.125>, <3,1,18.875>, <1,2,18.875>, <1,2,19.125>
}
polygon{
    4,
    <1,-2,22>, <2,-1,21>, <3,-1,21>, <1,-2,22>
}
polygon{
    4,
    <1,-2,21.75>, <2,-1,20.75>, <3,-1,20.75>, <1,-2,21.75>
}
polygon{
    5,
    <1,-2,22>, <3,-1,21>, <3,-1,20.75>, <1,-2,21.75>, <1,-2,22>
}
polygon{
    4,
    <1,-2,16>, <2,-1,17>, <3,-1,17>, <1,-2,16>
}
polygon{
    4,
    <1,-2,16.25>, <2,-1,17.25>, <3,-1,17.25>, <1,-2,16.25>
}
polygon{
    5,
    <1,-2,16>, <3,-1,17>, <3,-1,17.25>, <1,-2,16.25>, <1,-2,16>
}
polygon{
    4,
    <1,-2,19.125>, <2,-1,19.125>, <3,-1,19.125>, <1,-2,19.125>
}
polygon{
    4,
    <1,-2,18.875>, <2,-1,18.875>, <3,-1,18.875>, <1,-2,18.875>
}
polygon{
    5,
    <1,-2,19.125>, <3,-1,19.125>, <3,-1,18.875>, <1,-2,18.875>, <1,-2,19.125>
}//end right weapon pod

polygon{//begin bottom weapon pod
    5,
    <1,-2,21>, <1,-2,17>, <1,-3,17>, <1,-3,21>, <1,-2,21>
}
polygon{
    5,
    <-1,-2,21>, <-1,-2,17>, <-1,-3,17>, <-1,-3,21>, <-1,-2,21>
}
polygon{
    5,
    <1,-3,21>, <1,-3,17>, <-1,-3,17>, <-1,-3,21>, <1,-3,21>
}
polygon{
    5,
    <1,-2,17>, <-1,-2,17>, <-1,-3,17>, <1,-3,17>, <1,-2,17>
}
polygon{
    15,
    <1,-2,21>, <1,-3,21>, <-1,-3,21>, <-1,-2,21>, <1,-2,21>,
    <0.875,-2.125,21>, <0.875,-2.875,21>, <0.125,-2.875,21>, <0.125,-2.125,21>, <-2.125,0.875,21>
    <-0.875,-2.125,21>, <-0.875,-2.875,21>, <-0.125,-2.875,21>, <-0.125,-2.125,21>, <-0.875,-2.125,21>
}
polygon{
    5,
    <0.875,-2.125,21>, <0.875,-2.125,17.5>, <0.875,-2.875, 17.5>, <0.875,-2.875, 21>, <0.875,-2.125, 21>
}
polygon{
    5,
    <0.125,-2.125,21>, <0.125,-2.125, 17.5>, <0.125,-2.875, 17.5>, <0.125,-2.875, 21>, <0.125,-2.125, 21>
}
polygon{
    5,
    <-0.875,-2.125,21>, <-0.875,-2.125, 17.5>, <-0.875,-2.875, 17.5>, <-0.875,-2.875, 21>, <-0.875,-2.125, 21>
}
polygon{
    5,
    <-0.125,-2.125,21>, <-0.125,-2.125, 17.5>, <-0.125,-2.875, 17.5>, <-0.125,-2.875, 21>, <-0.125,-2.125,21>
}
polygon{
    5,
    <0.875,-2.125,21>, <0.875,-2.125, 17.5>, <-0.875,-2.125, 17.5>, <-0.875,-2.125, 21>, <0.875,-2.125,21>
}
polygon{
    5,
    <0.875,-2.875,21>, <0.875,-2.875, 17.5>, <-0.875,-2.875, 17.5>, <-0.875, -2.875, 21>, <0.875, -2.875, 21>
}
polygon{
    4,
    <2,-1,22>, <1,-2,21>, <1,-3,21>, <2,-1,22>
}
polygon{
    4,
    <2,-1,21.75>, <1,-2,20.75>, <1,-3,20.75>, <2,-1,21.75>
}
polygon{
    5,
    <2,-1,22>, <1,-3,21>, <1,-3,20.75>, <2,-1,21.75>, <2,-1,22>
}
polygon{
    4,
    <2,-1,16>, <1,-2,17>, <1,-3,17>, <2,-1,16>
}
polygon{
    4,
    <2,-1,16.25>, <1,-2,17.25>, <1,-3,17.25>, <2,-1,16.25>
}
polygon{
    5,
    <2,-1,16>, <1,-3,17>, <1,-3,17.25>, <2,-1,16.25>, <2,-1,16>
}
polygon{
    4,
    <2,-1,19.125>, <1,-2,19.125>, <1,-3,19.125>, <2,-1,19.125>
}
polygon{
    4,
    <2,-1,18.875>, <1,-2,18.875>, <1,-3,18.875>, <2,-1,18.875>
}
polygon{
    5,
    <2,-1,19.125>, <1,-3,19.125>, <1,-3,18.875>, <2,-1,18.875>, <2,-1,19.125>
}
polygon{
    4,
    <-2,-1,22>, <-1,-2,21>, <-1,-3,21>, <-2,-1,22>
}
polygon{
    4,
    <-2,-1,21.75>, <-1,-2,20.75>, <-1,-3,20.75>, <-2,-1,21.75>
}
polygon{
    5,
    <-2,-1,22>, <-1,-3,21>, <-1,-3,20.75>, <-2,-1,21.75>, <-2,-1,22>
}
polygon{
    4,
    <-2,-1,16>, <-1,-2,17>, <-1,-3,17>, <-2,-1,16>
}
polygon{
    4,
    <-2,-1,16.25>, <-1,-2,17.25>, <-1,-3,17.25>, <-2,-1,16.25>
}
polygon{
    5,
    <-2,-1,16>, <-1,-3,17>, <-1,-3,17.25>, <-2,-1,16.25>, <-2,-1,16>
}
polygon{
    4,
    <-2,-1,19.125>, <-1,-2,19.125>, <-1,-3,19.125>, <-2,-1,19.125>
}
polygon{
    4,
    <-2,-1,18.875>, <-1,-2,18.875>, <-1,-3,18.875>, <-2,-1,18.875>
}
polygon{
    5,
    <-2,-1,19.125>, <-1,-3,19.125>, <-1,-3,18.875>, <-2,-1,18.875>, <-2,-1,19.125>
}//end bottom weapon pod

polygon{//canopy
    4,
    <0.5,2,22>,<0.5,3,20>,<1,2,21>,<0.5,2,22>
    pigment{color Blue}
    finish{reflection 1}
}
polygon{
    4,
    <-0.5,2,22>,<-0.5,3,20>,<-1,2,21>,<-0.5,2,22>
    pigment{color Blue}
    finish{reflection 1}
}
polygon{
    5,
    <0.5,2,22>,<0.5,3,20>,<-0.5,3,20>,<-0.5,2,22>,<0.5,2,22>
    pigment{color Blue}
    finish{reflection 1}
}
polygon{
    5,
    <0.5,3,20>,<1,2,21>,<1,2,17>,<0.5,3,17.5>,<0.5,3,20>
    pigment{color Blue}
    finish{reflection 1}
}
polygon{
    5,
    <-0.5,3,20>,<-1,2,21>,<-1,2,17>,<-0.5,3,17.5>,<-0.5,3,20>
    pigment{color Blue}
    finish{reflection 1}
}
polygon{//top `o canopy
    15,
    <0.5,3,20>,<0.5,3,17.5>,<-0.5,3,17.5>,<-0.5,3,20>,<0.5,3,20>
    <0.4,3,19.9>,<0.4,3,18.9>,<-0.4,3,18.9>,<-0.4,3,19.9>,<0.4,3,19.9>
    <0.4,3,18.6>,<0.4,3,17.6>,<-0.4,3,17.6>,<-0.4,3,18.6>,<0.4,3,18.6>
    pigment{color rgb<0.1,0.6,0.1>}
    finish{diffuse 1}
}

polygon{
    5,
    <0.4,3,19.9>, <0.4,3,18.9>, <0.3,2.9,19>, <0.3,2.9,19.8>, <0.4,3,19.9>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <-0.4,3,19.9>, <-0.4,3,18.9>, <-0.3,2.9,19>, <-0.3,2.9,19.8>, <-0.4,3,19.9>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <0.4,3,19.9>, <-0.4,3,19.9>, <-0.3,2.9,19.8>, <0.3,2.9,19.8>, <0.4,3,19.9>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <0.4,3,18.9>, <-0.4,3,18.9>, <-0.3,2.9,19>, <0.3,2.9,19>, <0.4,3,18.9>
    pigment{color rgb<0.1,0.6,0.1>}
}

polygon{
    5,
    <0.4,3,18.6>, <0.4,3,17.4>, <0.3,2.9,17.3>, <0.3,2.9,18.5>, <0.4,3,18.6>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <-0.4,3,18.6>, <-0.4,3,17.4>, <-0.3,2.9,17.3>, <-0.3,2.9,18.5>, <-0.4,3,18.6>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <0.4,3,18.6>, <-0.4,3,18.6>, <-0.3,2.9,18.5>, <0.3,2.9,18.5>, <0.4,3,18.6>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <0.4,3,17.4>, <-0.4,3,17.4>, <-0.3,2.9,17.3>, <0.3,2.9,17.3>, <0.4,3,17.4>
    pigment{color rgb<0.1,0.6,0.1>}
}
polygon{
    5,
    <0.3,2.9,19.8>, <0.3,2.9,17.3>, <-0.3,2.9,17.3>, <-0.3,2.9,19.8>, <0.3,2.9,19.8>
    pigment{color rgb<0.1,0.6,0.1>}
}

polygon{
    4,
    <0.5,3,17.5>,<0.5,2,16.5>,<1,2,17>,<0.5,3,17.5>
    pigment{color rgb<0.1,0.6,0.1>}
    finish{diffuse 1}
}
polygon{
    4,
    <-0.5,3,17.5>,<-0.5,2,16.5>,<-1,2,17>,<-0.5,3,17.5>
    pigment{color rgb<0.1,0.6,0.1>}
    finish{diffuse 1}
}
polygon{
    5,
    <0.5,3,17.5>,<0.5,2,16.5>,<-0.5,2,16.5>,<-0.5,3,17.5>,<0.5,3,17.5>
    pigment{color rgb<0.1,0.6,0.1>}
    finish{diffuse 1}
}

object{WARM
      translate< 0, 0, 5>
      }

#declare BEAM =
texture{
    pigment { color rgbt<1,1,1,1> }
    halo {
      emitting
      planar_mapping
      linear
      color_map {
        [ 0 color rgbt < 0.5, 0, 0.5, 1> ]
        [ 1.5 color rgbt <1, 1, 1, 0> ]
      }
      turbulence 0.35
      samples 10
    }
}

/*box{
<1,1,6>,<-1,-1,200>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
} */

object{WARM
      rotate < 0, 0, 120 >
      translate< 0, 0, 5>
      }

/*box{
<1,1,6>,<-1,-1,200>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
rotate < 0, 0, 120 >
} */

object{WARM
      rotate < 0, 0, -120 >
      translate< 0, 0, 5>
      }

/*box{
<1,1,6>,<-1,-1,200>
hollow
  texture {BEAM}
translate < 0, -8, 0 >
rotate < 0, 0, -120 >
} */

#declare T_CONE = texture{
  halo{
     color_map{
       [ 0 color rgbt <0,1,1,1>]
       [ 1 color rgbt <1,1,1,0>]
     }
  }
  finish{ambient 0.5}
}

//light_source{<0,0,0> color rgb<0,1,1>}

//cone{
//<0,0,1>,1.5,<0,0,-125>,0.1
//  texture {T_CONE}
//  hollow
//  rotate < 0, 0, 45>
//}


object{S_MISSILE
      translate<2.5,0.5,18>
      }
object{S_MISSILE
      translate<2.5,-0.5,18>
      }
object{S_MISSILE
      translate<-2.5,0.5,18>
      }
object{S_MISSILE
      translate<-2.5,-0.5,18>
      }
object{S_MISSILE
      translate<-0.5,-2.5,18>
      }
object{S_MISSILE
      translate<0.5,-2.5,18>
      }

texture{
        pigment{color Green}
        finish{diffuse 1}
       }

//rotate< 0, 180, 0 >
}

