// Persistence of Vision Ray Tracer Scene Description File
// File: explorer.pov
// Vers: 3
// Desc: A spacecraft reaching Jupiter
// Date: 12.10.1996
// Auth: Tim Woehrle
//
#version 3
#include "colors.inc"
#include "metals.inc"

///////////////////////////////////////////////////////////////////
// The 3 textures: the spacecrafts surface, a brihgt white
// and old-looking metal

#declare SondenLack = texture
{
   pigment { color Gray90 }
   finish { reflection 0.1 phong 0.2 ambient 0.1 }
   normal { bumps 0.7 turbulence 0.5 scale 0.4 }
}

#declare ParabolFarbe = texture
{
   pigment { color White }
   finish { reflection 0 phong 0.2 ambient 0.1 diffuse 0.6}
}

#declare TMetallVerbeult = texture
{
   T_Chrome_2A
   normal { bumps 0.4 turbulence 0.3 scale 0.3 }
   finish { ambient 0.1 diffuse 0.7 }
}

///////////////////////////////////////////////////////////////////
// the following object definitions are parts of the spacecraft
// which will be linked together in the comolete definition 
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
// A Booster
#declare SeitenTriebwerk = union
{
   difference
   {
      union
      {
         cylinder { <0,0,0>, <4,0,0>, 1 }
         sphere { <0,0,0>, 1 scale <0.4,1,1> translate <4,0,0> }
      }
      cylinder { <-1,0,0>, <1,0,0>, 0.8 }
      texture { SondenLack }
   }
   difference
   {
      union
      {
         cylinder { <1,0,0>, <-0.6,0,0>, 0.5 }
         cone { <-0.6,0,0>, 0.5, <-1.8,0,-1>, 0.8 }
      }
      cone { <-0.6,0,0>, 0.3<-1.801,0,-1>, 0.6 }
      texture { T_Brass_1A }
     }
   #declare a = 0
   #while (a < 360)
      cylinder { <0,0.85,0>, <3,0.85,0>, 0.2 rotate <a,0,0> texture { SondenLack } }
      #declare a = a + 30
   #end
} //SeitenTriebwerk


///////////////////////////////////////////////////////////////////
// An "antenna"
#declare Antenne = union
{
   cylinder { <0,0,0>, <5,0,0>, 0.1 }
   cylinder { <0,0,0>, <2,0,0>, 0.15 }
   cylinder { <4,0,0>, <4.22,0,0>, 0.14 }
   cylinder { <4.66,0,0>, <5,0,0>, 0.14 }
   sphere { <0,0,0>, 0.1 scale <2,1,1> translate <5,0,0> }
   texture { ParabolFarbe }
} // Antenne

///////////////////////////////////////////////////////////////////
// the "wings"
#declare Ausleger = union
{
   difference
   {
      cylinder { <0.5,0,0>, <5,0,0>, 0.5 }
      cone { <4.5,0,0>, 0, <5.1,0,0>, 0.5 }
   }
   sphere { <0.5,0,0>, 0.5 }
   object { Antenne translate <5,0,0> }
   texture { SondenLack }
} // Ausleger


///////////////////////////////////////////////////////////////////
// the engine
#declare Duese = union
{
   difference
   {
      cylinder { <0,0,0>, <3,0,0>, 0.3 }
      cylinder { <-1,0,0>, <4,0,0>, 0.2 }
   }
   cone { <3,0,0>, 0.3, <4,0,0>, 0.5 }
   cylinder { <4,0,0>, <7,0,0>, 0.5 }
   texture { T_Brass_1A }
} // Duese


///////////////////////////////////////////////////////////////////
// the "parbol antenna" (??)
#declare ParabolSchuessel = union
{
   difference
   {
      sphere { <0,0,0>, 2 }
      sphere { <0.5,0,0>, 2.2 }
      texture { ParabolFarbe }
   }
   cylinder { <0.5,0,0> <2,0,0>,0.3 }
   cylinder { <-1.5,-2,0>, <0,-2.6,0>, 0.1 }
   cylinder { <0,-2.6,0>, <1.25,-2,0>, 0.1 }
   cylinder { <1.25,-2,0>, <1.25,0,0> 0.1 }
   difference
   {
      union
      {
         cylinder { <-3.5,0,0>, <0,0,0>, 0.5 }
         sphere { <-3.5,0,0>, 0.5 }
      }
      sphere { <0,0,0>, 2 }
      rotate <0,0,60>
   }
   translate <2,3.5,0>
} // ParabolSchuessel



///////////////////////////////////////////////////////////////////
// the halo which models the fire
#declare AntriebStrahl = sphere
{
   <0,0,0>, 5
   pigment { color rgbt <1, 1, 1, 1> }
   halo
   {
      emitting
      spherical_mapping 
      linear
      turbulence 0.5
      color_map
      {
         [ 0 color rgbt <1, 0, 0,  1> ]
         [ 0.2 color rgbt <1, 0, 0,  0> ]
         [ 0.6 color rgbt <1, 1, 0, -0.5> ]
         [ 1 color rgbt <1, 1, 0.6, -1> ]
      }
      samples 10
      scale 1.5
   }
   hollow
   rotate <60,0,0>
   scale <3,1,1>
} // AntriebStrahl 



///////////////////////////////////////////////////////////////////
// the whole spacecraft definition
#declare Sonde = union
{
   // Rumpf
   difference
   {
      cylinder { <0,0,0>, <16,0,0>, 2 }
      cylinder { <-1,0,0>, <4,0,0>, 1.9 }
   }
   // Nase
   difference
   {
      cone { <16,0,0>, 2, <27,0,0>, 0.5 }
      cone { <26,0,0>, 0, <27.1, 0,0>, 0.5 }
   }
   // Runde Tanks
   union
   {
      #declare a = 0
      #while (a < 360)
         sphere { <5.5,3,0>, 1.5 rotate <a,0,0> }
         sphere { <16,2.5,0>, 1.2 rotate <a,0,0> }
         cylinder  { <5.5,4,0>, < 5, 4*cos(radians(60)), 4*sin(radians(60))>, 0.3 rotate <a,0,0> }
         cylinder  { <16,3.4,0>, < 16, 3.4*cos(radians(60)), 3.4*sin(radians(60))>, 0.2 rotate <a,0,0> }
         #declare a = a + 60
      #end
      texture { TMetallVerbeult }
   }

   // Ausleger
   object { Ausleger translate <16,7,0> }
   object { Ausleger translate <12,-5,-5> }
   object { Ausleger translate <8,-3,7> }
   // Halterungen der Ausleger
   cylinder { <11,0,0>, <18,7,0>, 0.3 }
   cylinder { <15,0,0>, <14,-5,-5>, 0.3 }
   cylinder { <12,0,0>, <10,-3,7>, 0.3 }

   // Antennen
   object { Antenne translate <26,0,0> }
   object { Antenne rotate <0,0,20> translate <20,1,0> }
   object { Antenne rotate <0,0,20> translate <20,1,0> rotate <80,0,0> }
   object { Antenne rotate <0,0,20> translate <20,1,0> rotate <-80,0,0> }

   // Booster
   object { SeitenTriebwerk translate <10,0,-2.2> }
   object { SeitenTriebwerk translate <10,0,-2.2> rotate <90,0,0> }
   object { SeitenTriebwerk translate <10,0,-2.2> rotate <180,0,0> }

   // Antennen-Block
   union
   {
      box { <0,-0.5,-2>, <4,0.5,2> }
      cylinder { <0,0,-2>, <4,0,-2>, 0.5 }
      cylinder { <0,0,2>, <4,0,2>, 0.5 }
      object { Antenne translate <2,0,-2> }
      object { Antenne translate <2,0,0> }
      object { Antenne translate <2,0,2> }
      rotate <0,0,-25>
      translate <8,-2.5,0>
   }
   // Antennenblock-Halterung
   cylinder { <12,0,0>, <9,-3.5,0>, 0.5 }

   // Triebwerke
   object { Duese translate <-5,0,0> }
   #declare a = 0
   #while (a < 360)
      object { Duese translate <-5,1.2,0> rotate <a,0,0> }
      #declare a = a + 40
   #end
   object { AntriebStrahl translate <-5,0,0> }

   // Parabol-Schssel
   object { ParabolSchuessel rotate <0,80,0> translate <2,1.5,0.3> }

   hollow
   texture { SondenLack }
   translate <-13.5,0,0>
} // Sonde

///////////////////////////////////////////////////////////////////
// the scene 
///////////////////////////////////////////////////////////////////
camera
{
   location  <0,0,-50>
   look_at   <0,0,0>
}

light_source
{
  <200, 200, -100>
  color red 1.0  green 1.0  blue 1.0
  atmosphere off
}

object { Sonde rotate <0,-35,0> translate <7,-5,-15> }

///////////////////////////////////////////////////////////////////
// the background image of Jupiter
///////////////////////////////////////////////////////////////////
box
{
   <-50,-35,20>, <50,35,20.01>
   pigment { image_map
      {
         tga "jupiter.tga"
         once
      }
      scale <100,70,1>
      translate <-50,-35,0>
   }
   finish { ambient 1.0 diffuse 0.0 reflection 0.0}
}

