#include "COLORS.INC"
#include "TEXTURES.INC"

#declare SHIP = texture {
    pigment { brick pigment {color rgb<0.60, 0.60, 0.60>},
                    pigment { color rgb<0.85, 0.85, 0.85>}
                    turbulence .52 }
    normal { bumps .5 scale .385}
    finish { reflection 0.110 specular 0.10 ambient 0.035
             roughness 0.5 crand 0.10 }
    scale 1.175
}

#declare SHINY_WHITE = texture {
    pigment { color rgbf<1, 1, 0.8, 0>
    }
    finish { reflection 0.30 specular 0.90 ambient 0.25  }
}

#declare DARK_BLUE = texture {
    pigment { color rgbf<0, 0, 0.12, 0>
    }
    finish { reflection 0.275 specular 0.75 ambient 0.225  }
}

#declare SHINY_RED = texture {
    pigment { color rgbf<1, 0, 0, 0>
    }
    finish { reflection 0.275 specular 0.35 ambient 0.12
             roughness 0.75 crand 0.125 }
}

#declare GNL_SILVER =
texture {
pigment { color rgb <.8325 .8325 .775> }
finish {
    metallic
    ambient 0.2125
    diffuse 0.635
    reflection 0.375
    brilliance 6
    phong 1
    phong_size 100
    specular 0.8175
    }
}

// From my texture collection.
#declare GNL_NightSky =
texture {
	pigment { granite
        color_map {
            [ .2 .4 color Black color Black]
            [ .4 .6 color Black color Black]
            [ .6 .8 color Black color Black]
            [1 color White]
        }
    scale .1235
    }
    finish { ambient .995 }
}


#declare SHIPS_LIGHT =
texture {
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 color rgbt <1, 0, 0,  -.5> ]
      [ 1 color rgbt <1, 0, 0, -1.0> ]
    }
    samples 10
  }
}

#declare EXPLOSION =
texture {
        pigment { color rgbt <1, 1, 1, 1> }
                halo {
                emitting
                spherical_mapping 
                linear
                turbulence 1.6
                color_map {
                        [  0 color rgbt <.75     0 0    1> ]
                        [ .5 color rgbt <.75 .3128 0 .125> ]  
                        [  1 color rgbt <.75     0 0    1> ]
                          }
                frequency 2.026
                scale 8.1
                samples 20
                    }
}             

/*---------------------------------------------------------------------------
The Escape -- Copyright (C) 1996, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/
