//**************************************************************************
// Title                : Magic Lamps
// Author               : Gautam N. Lad
// E-Mail Address       : gautam@interlog.com
// Website              : http://www.interlog.com/~gautam
// Date Rendered        : September 25-26, 1996
// Total Rendering Time : 2 hours  28 minutes  12.0 seconds (8892 seconds)
// Renderer             : POV-Ray v3.0.msdos.wat-cwa
//**************************************************************************

#include "COLORS.INC"
#include "TEXTURES.INC"

global_settings { assumed_gamma 1.2 }


//**************************************************************************
// These are the various textures used by MAGLAMPS.POV scene file.  The
// Chrome_Metal and Copper_Metal are from the POV-Ray texture collection.
// The COLORS.INC and TEXTURES.INC files must be available to render this
// scene error-free.
//**************************************************************************

// Clock's glass.
#declare GNL_Glass1 =
texture {
    pigment { color rgbf <0.925, .925, .975, 0.975> }
    finish  { crand .01 ambient 0.250 diffuse 0.15 reflection 0.575
              refraction .575 ior 1.0 specular .65 phong 2 phong_size 500 }
}

// Very nice dark wood.  Part of my texture collection.
#declare GNL_DWood1 =
texture {
	pigment { wood
	color_map {      
	[0.09090909 color rgb<0.49090910 0.29090911 0.19090909>]
	[0.18181819 color rgb<0.48181820 0.28181821 0.18181817>]
	[0.27272728 color rgb<0.47272730 0.27272731 0.17272726>]
	[0.36363637 color rgb<0.46363640 0.26363641 0.16363634>]
	[0.45454547 color rgb<0.45454550 0.25454551 0.15454543>]
	[0.54545456 color rgb<0.44545460 0.24545459 0.14545451>]
	[0.63636363 color rgb<0.43636370 0.23636368 0.13636360>]
	[0.72727269 color rgb<0.42727280 0.22727276 0.12727268>]
	[0.81818175 color rgb<0.41818190 0.21818185 0.11818177>]
	[0.90909082 color rgb<0.40909100 0.20909093 0.10909086>]
	}
	turbulence .75
	scale .75
	}
    finish { crand 0.125 roughness 0.25 }                
}

// Main lamp texture
#declare SHINY_WHITE = texture {
    pigment { color rgb<1 1 1>
    }
    finish { reflection 0.40 specular 0.90 ambient 0.20
             roughness 0.03 }
}

// Lamp's black pigments/textures.
#declare SHINY_BLACK = texture {
    pigment { color rgb<.05 .05 .05>
    }
    finish { reflection 0.45 specular 0.75 ambient 0.10 }
}


// Subsitute any image with dimensions Width 167  x  Height 190
#declare MAP = texture {
    pigment {
        image_map {
            gif "GAUTAMNL"
            map_type 0
        }
    }
    scale <20 19.72 1>
}

// Very nice texture for walls.
#declare CREAM = texture {
    pigment { color rgb<1 .9 .8>
    }
    finish { crand 0.125 roughness 0.35 }
}

// Glowing texture for the disc in front of the lamp head.
#declare GLOW =
texture {
          pigment { color rgb<1 .875 .5> }
          finish { ambient 1 specular 1 }
}

//**************************************************************************
//
// Main scene.
//
//**************************************************************************


camera {
    location <-50, 9, -82>
   direction <0, 0, 1.86603>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <3.15, -10, -3.5>
}
    light_source {  <35, -11, 17.5>
        color rgb<1, .8, .4>  
        spotlight
        point_at <15, -38, 17.5>
        radius 175
        falloff 200
        tightness 1
    }
    light_source {  <25, 750, -75>
        color rgb<.50 .50 .50>
        shadowless
    }
    light_source {  <1000, 1000, -1000>
        color rgb<.030 .030 .030>
    }

    merge { // Poly_Pipe
        cone { <-17.9698, -37.0625, 7.61163>, 0.25, <-19.0462, -37.0625, 6.69135>, 0.25 }
        sphere { <-19.0462, -37.0625, 6.69135>, 0.25 }
        cone { <-19.0462, -37.0625, 6.69135>, 0.25, <-20.1843, -37.0625, 5.84942>, 0.25 }
        sphere { <-20.1843, -37.0625, 5.84942>, 0.25 }
        cone { <-20.1843, -37.0625, 5.84942>, 0.25, <-21.3986, -37.0625, 5.12192>, 0.25 }
        sphere { <-21.3986, -37.0625, 5.12192>, 0.25 }
        cone { <-21.3986, -37.0625, 5.12192>, 0.25, <-22.6864, -37.0625, 4.535>, 0.25 }
        sphere { <-22.6864, -37.0625, 4.535>, 0.25 }
        cone { <-22.6864, -37.0625, 4.535>, 0.25, <-24.0532, -37.0625, 4.17679>, 0.25 }
        sphere { <-24.0532, -37.0625, 4.17679>, 0.25 }
        cone { <-24.0532, -37.0625, 4.17679>, 0.25, <-25.4612, -37.0625, 4.21873>, 0.25 }
        sphere { <-25.4612, -37.0625, 4.21873>, 0.25 }
        cone { <-25.4612, -37.0625, 4.21873>, 0.25, <-26.6897, -37.0625, 4.87687>, 0.25 }
        sphere { <-26.6897, -37.0625, 4.87687>, 0.25 }
        cone { <-26.6897, -37.0625, 4.87687>, 0.25, <-27.3438, -37.0625, 6.11798>, 0.25 }
        sphere { <-27.3438, -37.0625, 6.11798>, 0.25 }
        cone { <-27.3438, -37.0625, 6.11798>, 0.25, <-27.5868, -37.0625, 7.5098>, 0.25 }
        sphere { <-27.5868, -37.0625, 7.5098>, 0.25 }
        cone { <-27.5868, -37.0625, 7.5098>, 0.25, <-27.4963, -37.0625, 8.91832>, 0.25 }
        sphere { <-27.4963, -37.0625, 8.91832>, 0.25 }
        cone { <-27.4963, -37.0625, 8.91832>, 0.25, <-26.9851, -37.0625, 10.2313>, 0.25 }
        sphere { <-26.9851, -37.0625, 10.2313>, 0.25 }
        cone { <-26.9851, -37.0625, 10.2313>, 0.25, <-26.071, -37.0625, 11.3036>, 0.25 }
        sphere { <-26.071, -37.0625, 11.3036>, 0.25 }
        cone { <-26.071, -37.0625, 11.3036>, 0.25, <-24.873, -37.0625, 12.0506>, 0.25 }
        sphere { <-24.873, -37.0625, 12.0506>, 0.25 }
        cone { <-24.873, -37.0625, 12.0506>, 0.25, <-23.5317, -37.0625, 12.4936>, 0.25 }
        sphere { <-23.5317, -37.0625, 12.4936>, 0.25 }
        cone { <-23.5317, -37.0625, 12.4936>, 0.25, <-22.1253, -37.0625, 12.6535>, 0.25 }
        sphere { <-22.1253, -37.0625, 12.6535>, 0.25 }
        cone { <-22.1253, -37.0625, 12.6535>, 0.25, <-20.7961, -37.0625, 13.1131>, 0.25 }
        sphere { <-20.7961, -37.0625, 13.1131>, 0.25 }
        cone { <-20.7961, -37.0625, 13.1131>, 0.25, <-19.7305, -37.0625, 14.0372>, 0.25 }
        sphere { <-19.7305, -37.0625, 14.0372>, 0.25 }
        cone { <-19.7305, -37.0625, 14.0372>, 0.25, <-18.8619, -37.0625, 15.1548>, 0.25 }
        sphere { <-18.8619, -37.0625, 15.1548>, 0.25 }
        cone { <-18.8619, -37.0625, 15.1548>, 0.25, <-18.0773, -37.0625, 16.3337>, 0.25 }
        sphere { <-18.0773, -37.0625, 16.3337>, 0.25 }
        cone { <-18.0773, -37.0625, 16.3337>, 0.25, <-17.2966, -37.0625, 17.515>, 0.25 }
        sphere { <-17.2966, -37.0625, 17.515>, 0.25 }
        cone { <-17.2966, -37.0625, 17.515>, 0.25, <-16.368, -37.0625, 18.5809>, 0.25 }
        sphere { <-16.368, -37.0625, 18.5809>, 0.25 }
        cone { <-16.368, -37.0625, 18.5809>, 0.25, <-15.2419, -37.0625, 19.4366>, 0.25 }
        sphere { <-15.2419, -37.0625, 19.4366>, 0.25 }
        cone { <-15.2419, -37.0625, 19.4366>, 0.25, <-14.0307, -37.0625, 20.1704>, 0.25 }
        sphere { <-14.0307, -37.0625, 20.1704>, 0.25 }
        cone { <-14.0307, -37.0625, 20.1704>, 0.25, <-12.8368, -37.0625, 20.9309>, 0.25 }
        sphere { <-12.8368, -37.0625, 20.9309>, 0.25 }
        cone { <-12.8368, -37.0625, 20.9309>, 0.25, <-11.7386, -37.0625, 21.824>, 0.25 }
        texture { SHINY_BLACK }
    }
    box { <0.0, 0.0, 0.0>, <2.5, 1, 4.5> 
        texture { SHINY_BLACK }
        rotate <.0, 53.9741, .0>
        translate <-19.0552, -37.75, 8.32723>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <4, 0.5, 0.25> 
        texture { Copper_Metal }
        rotate <.0, 143.569, .0>
        translate <-12.8711, -37.4766, 12.4348>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <4, 0.5, 0.25> 
        texture { Copper_Metal }
        rotate <.0, 143.569, .0>
        translate <-11.8749, -37.4766, 11.085>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <6, 65.683, 6> 
        texture { GNL_DWood1 }
        translate <-52.5, -107, 39>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <6, 65.683, 6> 
        texture { GNL_DWood1 }
        translate <-52.5, -107, -21>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <6, 65.683, 6> 
        texture { GNL_DWood1 }
        translate <80, -107, -21>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 6.10328, 0
        texture { GLOW }
        rotate <.0, .0, 323.755>
        translate <37, -9.5, 17.5>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <4, 0.5, 0.25> 
        texture { Copper_Metal }
        translate <15.2368, -37.4766, 0.4643963>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <4, 0.5, 0.25> 
        texture { Copper_Metal }
        translate <15.2368, -37.4766, -1.21324>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <2.5, 1, 4.5> 
        texture { SHINY_BLACK }
        rotate <.0, 270.405, .0>
        translate <22.6516, -37.75, -1.58082>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <6, 65.683, 6> 
        texture { GNL_DWood1 }
        translate <80, -107, 39>
        no_shadow
    }
    plane { y, 0.0 
        texture { CREAM }
        scale <100, 100, 100>
        rotate <270, .0, .0>
        translate <0, 0, 50>
        no_shadow
    }
    merge { // Poly_Pipe
        cone { <60, -37.5, 17.5>, 0.25, <63.776, -37.5, 17.4487>, 0.25 }
        sphere { <63.776, -37.5, 17.4487>, 0.25 }
        cone { <63.776, -37.5, 17.4487>, 0.25, <67.5378, -37.5, 17.1318>, 0.25 }
        sphere { <67.5378, -37.5, 17.1318>, 0.25 }
        cone { <67.5378, -37.5, 17.1318>, 0.25, <71.2509, -37.5, 16.4514>, 0.25 }
        sphere { <71.2509, -37.5, 16.4514>, 0.25 }
        cone { <71.2509, -37.5, 16.4514>, 0.25, <74.8636, -37.5, 15.3602>, 0.25 }
        sphere { <74.8636, -37.5, 15.3602>, 0.25 }
        cone { <74.8636, -37.5, 15.3602>, 0.25, <78.232, -37.5, 13.6718>, 0.25 }
        sphere { <78.232, -37.5, 13.6718>, 0.25 }
        cone { <78.232, -37.5, 13.6718>, 0.25, <80.9786, -37.5, 11.1092>, 0.25 }
        sphere { <80.9786, -37.5, 11.1092>, 0.25 }
        cone { <80.9786, -37.5, 11.1092>, 0.25, <82.2809, -37.5, 7.6283>, 0.25 }
        sphere { <82.2809, -37.5, 7.6283>, 0.25 }
        cone { <82.2809, -37.5, 7.6283>, 0.25, <81.4064, -37.5, 3.99087>, 0.25 }
        sphere { <81.4064, -37.5, 3.99087>, 0.25 }
        cone { <81.4064, -37.5, 3.99087>, 0.25, <79.4431, -37.5, 0.7751335>, 0.25 }
        sphere { <79.4431, -37.5, 0.7751335>, 0.25 }
        cone { <79.4431, -37.5, 0.7751335>, 0.25, <76.7825, -37.5, -1.88703>, 0.25 }
        sphere { <76.7825, -37.5, -1.88703>, 0.25 }
        cone { <76.7825, -37.5, -1.88703>, 0.25, <73.4471, -37.5, -3.61725>, 0.25 }
        sphere { <73.4471, -37.5, -3.61725>, 0.25 }
        cone { <73.4471, -37.5, -3.61725>, 0.25, <69.7285, -37.5, -4.15581>, 0.25 }
        sphere { <69.7285, -37.5, -4.15581>, 0.25 }
        cone { <69.7285, -37.5, -4.15581>, 0.25, <66.0139, -37.5, -3.54342>, 0.25 }
        sphere { <66.0139, -37.5, -3.54342>, 0.25 }
        cone { <66.0139, -37.5, -3.54342>, 0.25, <62.5472, -37.5, -2.06979>, 0.25 }
        sphere { <62.5472, -37.5, -2.06979>, 0.25 }
        cone { <62.5472, -37.5, -2.06979>, 0.25, <59.4486, -37.5, 0.08563885>, 0.25 }
        sphere { <59.4486, -37.5, 0.08563885>, 0.25 }
        cone { <59.4486, -37.5, 0.08563885>, 0.25, <55.9771, -37.5, 1.50495>, 0.25 }
        sphere { <55.9771, -37.5, 1.50495>, 0.25 }
        cone { <55.9771, -37.5, 1.50495>, 0.25, <52.2159, -37.5, 1.52965>, 0.25 }
        sphere { <52.2159, -37.5, 1.52965>, 0.25 }
        cone { <52.2159, -37.5, 1.52965>, 0.25, <48.5086, -37.5, 0.8199728>, 0.25 }
        sphere { <48.5086, -37.5, 0.8199728>, 0.25 }
        cone { <48.5086, -37.5, 0.8199728>, 0.25, <44.8618, -37.5, -0.1603281>, 0.25 }
        sphere { <44.8618, -37.5, -0.1603281>, 0.25 }
        cone { <44.8618, -37.5, -0.1603281>, 0.25, <41.2184, -37.5, -1.15246>, 0.25 }
        sphere { <41.2184, -37.5, -1.15246>, 0.25 }
        cone { <41.2184, -37.5, -1.15246>, 0.25, <37.4821, -37.5, -1.65279>, 0.25 }
        sphere { <37.4821, -37.5, -1.65279>, 0.25 }
        cone { <37.4821, -37.5, -1.65279>, 0.25, <33.7201, -37.5, -1.38465>, 0.25 }
        sphere { <33.7201, -37.5, -1.38465>, 0.25 }
        cone { <33.7201, -37.5, -1.38465>, 0.25, <30.0024, -37.5, -0.7224538>, 0.25 }
        sphere { <30.0024, -37.5, -0.7224538>, 0.25 }
        cone { <30.0024, -37.5, -0.7224538>, 0.25, <26.272, -37.5, -0.1442107>, 0.25 }
        sphere { <26.272, -37.5, -0.1442107>, 0.25 }
        cone { <26.272, -37.5, -0.1442107>, 0.25, <22.5, -37.5, 2.11419e-017>, 0.25 }
        texture { SHINY_BLACK }
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 5, 0.0>, 3  
        texture { SHINY_WHITE }
        rotate <.0, .0, 323.755>
        translate <43.8981, 0.08973004, 17.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 2, 0.0>, 3  
        texture { SHINY_WHITE }
        rotate <.0, .0, -36.2453>
        translate <42.9201, -1.27173, 17.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3 
        texture { SHINY_WHITE }
        translate <46.994, 4.24098, 17.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 6, <0.0, 10, 0.0>, 6  
        texture { SHINY_WHITE }
        rotate <.0, .0, -36.2453>
        translate <37.0238, -9.28962, 17.5>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <20, 20, 20> 
        texture { MAP }
        scale <1, 1.5, 0.01>
        rotate <90, .0, .0>
        translate <10, -37.8029, 3.25>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <150, 4, 75> 
        texture { GNL_DWood1 }
        translate <-60, -42, -25>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 6, 0.0>, 2.5  
        texture { SHINY_BLACK }
        translate <52.5, -35, 18>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.6 
        texture { Chrome_Metal }
        translate <52.8836, -27.7321, 16.9913>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.6 
        texture { Chrome_Metal }
        translate <52.8836, -27.7321, 18.9776>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.6 
        texture { Chrome_Metal }
        translate <63.9453, -13.7422, 18.9776>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.6 
        texture { Chrome_Metal }
        translate <63.9453, -13.7422, 16.9913>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2.5, 0.0>, 0.25  
        texture { SHINY_BLACK }
        rotate <.0, .0, -38.3407>
        translate <49.9491, 8.21046, 17.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 10, <0.0, 2.5, 0.0>, 10  
        texture { SHINY_WHITE }
        translate <52.5, -37.5, 17.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 2, 0.0>, 3  
        texture { SHINY_BLACK }
        rotate <270, .0, .0>
        rotate <.0, .0, -27.9034>
        translate <52.9347, -27.67, 19>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <1, 17.5, 1> 
        texture { SHINY_WHITE }
        rotate <.0, .0, -36.9456>
        translate <53.7021, -27.9493, 17.5>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <1, 17.5, 1> 
        texture { SHINY_WHITE }
        rotate <.0, .0, -36.9456>
        translate <52.2375, -26.5829, 17.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 2, 0.0>, 3  
        texture { SHINY_BLACK }
        rotate <270, .0, .0>
        rotate <.0, .0, -27.9034>
        translate <63.9726, -13.7793, 19>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1.25, <0.0, 3.75, 0.0>, 1.25  
        texture { SHINY_BLACK }
        rotate <360, .0, .0>
        rotate <.0, .0, -37.6505>
        translate <48.4876, 6.2707, 17.5>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <1, 25, 1> 
        texture { SHINY_WHITE }
        rotate <.0, .0, -146.98>
        translate <51.1536, 9.05306, 17.5>
        no_shadow
    }
    box { <0.0, 0.0, 0.0>, <1, 25, 1> 
        texture { SHINY_WHITE }
        rotate <.0, .0, -146.98>
        translate <49.6714, 8.08973, 17.5>
        no_shadow
    }

    cone { <0.0, 0.0, 0.0>, 1, <0.0, 5, 0.0>, 0  
        texture { SHINY_BLACK }
        scale <1, 1, 0.25>
        rotate <.0, .0, -11.7251>
        translate <36.4382, 5.555, 49>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 7.5, 0.0>, 0  
        texture { SHINY_BLACK }
        scale <1, 1, 0.25>
        translate <36, 5, 49>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 1, 0.0>, 2
        texture { SHINY_BLACK }
        rotate <90, .0, .0>
        translate <36, 5, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <39.75, 11.4952, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <42.4952, 8.75, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <43.5, 5, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <42.4952, 1.25, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <39.75, -1.49519, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <36, -2.5, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <32.25, -1.49519, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <29.5048, 1.25, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <28.5, 5, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <29.5048, 8.75, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <32.25, 11.4952, 48.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1 
        texture { SHINY_BLACK }
        translate <36, 12.5, 48.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 11, 0 
        texture { GNL_Glass1 }
        rotate <270, .0, .0>
        translate <36, 5, 48>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 11, 0 
        texture { SHINY_WHITE }
        rotate <270, .0, .0>
        translate <36, 5, 49>
        no_shadow
    }
    torus { 11, 1.5 sturm 
        texture { SHINY_BLACK }
        rotate <270, .0, .0>
        translate <36, 5, 49>
        no_shadow
    }
    torus { 0.375, 0.15 sturm 
        texture { SHINY_BLACK }
        rotate <.0, .0, -270>
        rotate <.0, 322.351, .0>
        translate <-12.1757, -37.0673, 21.4687>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.2 
        texture { SHINY_BLACK }
        scale <1.55318, 0.7765875, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <-3.68349, -6.01756, 25.5439>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1.5, 0.0>, 0.2  
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <-2.26223, -7.74926, 24.9043>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.3, <0.0, 0.3, 0.0>, 0.3  
        texture { Chrome_Metal }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <-2.26223, -7.74926, 24.9043>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 0.6, 0.0>, 0.5  
        texture { Chrome_Metal }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <-1.78848, -8.32649, 24.6912>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 2 
        texture { SHINY_WHITE }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <-0.3672211, -10.0582, 24.0516>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 2, <0.0, 4, 0.0>, 2  
        texture { SHINY_WHITE }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <3.4228, -14.6761, 22.3461>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 2, 0.0>, 2  
        texture { SHINY_WHITE }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <5.3178, -16.985, 21.4933>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 3, 0.0>, 4  
        texture { SHINY_WHITE }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, .0, -318.013>
        rotate <.0, 24.2277, .0>
        translate <8.16032, -20.4484, 20.2142>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <0.3409657, -13.1645, 23.7329>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-0.2549292, -13.6554, 24.0011>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-0.8491167, -14.1487, 24.2684>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-1.43962, -14.6473, 24.5342>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-2.02315, -15.1556, 24.7968>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-2.59281, -15.6824, 25.0531>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-3.13297, -16.2451, 25.2962>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-3.62624, -16.8573, 25.5182>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-4.07363, -17.5108, 25.7195>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-4.4885, -18.1896, 25.9062>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-4.87069, -18.8911, 26.0782>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-5.22236, -19.6115, 26.2364>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-5.53692, -20.3522, 26.378>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-5.81246, -21.1113, 26.5019>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.03781, -21.8901, 26.6034>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.21987, -22.6824, 26.6853>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.35793, -23.4853, 26.7474>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.46131, -24.2946, 26.7939>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.53886, -25.1073, 26.8288>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.59636, -25.9221, 26.8547>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.6388, -26.738, 26.8738>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.67025, -27.5545, 26.888>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.69364, -28.3713, 26.8985>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.71033, -29.1884, 26.906>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.72168, -30.0055, 26.9111>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.72981, -30.8228, 26.9148>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.73539, -31.64, 26.9173>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.73854, -32.4572, 26.9187>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.74001, -33.2745, 26.9193>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.74074, -34.0917, 26.9197>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 5, <0.0, 2, 0.0>, 4.8  
        texture { SHINY_WHITE }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.7409, -38.0153, 26.9197>
        no_shadow
    }
    torus { 1, 0.25 sturm 
        texture { SHINY_BLACK }
        scale <1.55318, 1.55318, 1.55318>
        rotate <.0, 24.2277, .0>
        translate <-6.7409, -34.909, 26.9197>
        no_shadow
    }

/*---------------------------------------------------------------------------
Magic Lamps -- Copyright (C) 1996, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
----------------------------------------------------------------------------*/
