//  Persistance of Vision Raytracer V3.0
//  World definition file.
//  Title: Hornet fighter
//  Autor: Martin Mueller

global_settings{ #max_trace_level 5 }

// *** CAMERA ***

camera { 
  location  <651.995, -499.090, 225.399>
  direction <0.0,     0.0,  2.1604>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <51.697, -81.555, -31.132>
}

// *** LIGHTS ***

light_source {  
  <686.984, -517.437, 243.355>
  color rgb <1.000, 1.000, 1.000>
}


// *** TEXTURES ***

#declare Shiphull = texture {
   pigment {
     spotted
     color_map {
       [ 0.000  color rgb <0.000, 0.342, 0.000> ]
       [ 0.173  color rgb <0.000, 0.518, 0.000> ]
       [ 0.572  color rgb <0.000, 0.423, 0.000> ]
       [ 1.000  color rgb <0.000, 0.150, 0.000> ]
     }
   }
   finish {
     diffuse 0.560
     ambient 0.410
     phong_size 20.000
     reflection 0.050
     specular 0.400
     roughness 0.0200
     metallic
   }
}

#declare Shiphull2 = texture {
   pigment {
     spotted
     color_map {
       [ 0.000  color rgb <0.000, 0.000, 0.000> ]
       [ 0.500  color rgb <0.315, 0.315, 0.315> ]
       [ 1.000  color rgb <0.614, 0.614, 0.614> ]
     }
   }
   finish {
     diffuse 0.560
     ambient 0.410
     phong_size 20.000
     reflection 0.390
     specular 0.750
     roughness 0.940
     metallic
   }
}


#declare Laserlight = texture {
   pigment {
     color rgb<1.000, 0.000, 0.000>
   }
   finish {
     diffuse 1.000
     ambient 1.000
   }

}

// *** OBJECTS ***

// Laser 1
cylinder {
  <0,0,1>, <0,0,0>, 1 
  texture { Laserlight }
  scale <1.0, 1.0, 100.0>
  no_shadow
  rotate -90.0*y
  translate  <280.318583, -85.368594, -142.364295>
}


// Laser 2
cylinder {
  <0,0,1>, <0,0,0>, 1 
  texture { Laserlight }
  scale <1.0, 1.0, 100.0>
  no_shadow
  rotate -90.0*y
  translate  <397.58523, -170.069768, 7.826483>
}


// Laser 3
cylinder { 
  <0,0,1>, <0,0,0>, 1 
  texture { Laserlight }
  scale <1.0, 1.0, 100.0>
  no_shadow
  rotate -90.0*y
  translate  <278.010706, 37.881222, -32.08105>
}

//Explosion
sphere { <0,0,0>,1
  pigment { color rgbt <1,1,1,1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1.5
    color_map{
      [ 0 color rgbt <1,0,0,1> ]
      [ 1 color rgbt <1,1,0,-1> ]
	     }
    samples 30
    jitter 0.2
    scale 0.5
       }
  hollow
  scale 450.0
  translate  <-422.35095, 81.033008, -107.834817>
}


#include "hornet.inc"

object { Hornet
  texture { Shiphull2 
	    scale 70
	  }
  scale 0.25
  rotate -11.228169*x
  translate  <0.0, -121.272419, -109.145178>
	}

object { Hornet
  texture { Shiphull2 
	    scale 70
	  }
  scale 0.25
  rotate -11.228169*x
  translate  <0.0, 109.145178, 87.922504>
	}

object { Hornet
  texture { Shiphull2
  	    scale 70
  	  }
  scale 0.25
  rotate -11.228169*x
	}


