
// Persistence of Vision Ray Tracer Scene Description File
// File: Station.pov
// Vers: 3.00e Watcom Win32
// Desc: Space Station in Orbit
// Date: October 13, 1996
// Auth: Sonya Roberts
// Note: Wierd-looking Space Station Orbiting Planet - subfile for InOrbit.pov

#if (InsertMainModule=True)
	#declare ScaffUnit=
	object {
		union {
			cylinder {<-5,0,-5>,<-5,10,-5>,.65}		// Main Poles
			cylinder {<-5,0,5>,<-5,10,5>,.65}
			cylinder {<5,0,-5>,<5,10,-5>,.65}
			cylinder {<5,0,5>,<5,10,5>,.65}
			cylinder {<-5,5,-5>,<5,5,5>,.5}			// Cross Braces
			cylinder {<-5,5,5>,<5,5,-5>,.5}
			cylinder {<-5,1,-5>,<5,9,-5>,.5}		// Angle Braces
			cylinder {<5,1,-5>,<5,9,5>,.5}
			cylinder {<5,1,5>,<-5,9,5>,.5}
			cylinder {<-5,1,5>,<-5,9,-5>,.5}
			cylinder {<-5,9.75,-5>,<-5,10.25,-5>,.7}	// Joints
			cylinder {<-5,9.75,5>,<-5,10.25,5>,.7}
			cylinder {<5,9.75,-5>,<5,10.25,-5>,.7}
			cylinder {<5,9.75,5>,<5,10.25,5>,.7}
		}
		texture {T_Chrome_4D}
	}
	#declare Scaffold=
	object {
		#declare UN=1
		union {
			#while (UN<=20)
				object {ScaffUnit	translate <0,-10*UN,0>}
				#declare UN=UN+1
			#end
			box {<-6,0,-6>,<6,12,6>		texture {T_Brass_4B}}
			box {<-6,-212,-6>,<6,-200,6>	texture {T_Brass_4B}}
		}
		translate <0,-40,0>
	}
	#declare Tank=
	object {
		union {
			blob {
				threshold .2
				sphere {<0,0,0>,20,1	scale <1,.25,1>}
				cylinder {<0,0,0>,<0,100,0>,20,1}
				sphere {<0,110,0>,20,1}
				sphere {<0,125,0>,15,1}
				sphere {<0,135,0>,10,1}
				texture {MetalPlating1	scale <20,20,20>	rotate y*180}
			}
			union {
				cylinder {<0,130,0>,<0,160,0>,1}
				sphere {<0,160,0>,3}
				texture {T_Gold_3B}
			}
		}
	}
	#declare HabitatRing=
	object {
		torus {120,20}
		texture {MetalPlating1	scale <1,5,1>}
	}
	#declare MainModule=
	union {
		object {
			union {
				sphere {<0,160,0>,5}				// Cross-point
				cylinder {<-40,160,0>,<40,160,0>,2.5}		// Cross-corridors
				cylinder {<0,160,-40>,<0,160,40>,2.5}
				cylinder {<-41,160,0>,<-38,160,0>,3}		// Joins to Box Bays
				cylinder {<38,160,0>,<41,160,0>,3}
				cylinder {<0,160,-41>,<0,160,-38>,3}
				cylinder {<0,160,38>,<0,160,41>,3}
			}
			texture {T_Gold_3B}
		}
		object {Tank		translate <-21,0,0>}			// Fuel/Water/Whatever Tanks
		object {Tank		rotate y*90	translate <21,0,0>}
		object {Tank		rotate y*180	translate <0,0,21>}
		object {Tank		rotate y*270	translate <0,0,-21>}
		object {Scaffold	translate <-46,196,0>}			// Longitudinal Scaffolds
		object {Scaffold	translate <46,196,0>}
		object {Scaffold	translate <0,196,-46>}
		object {Scaffold	translate <0,196,46>}
		object {Scaffold	rotate x*90	translate <0,-50,137.5>}	// Cross Scaffolds
		object {Scaffold	rotate z*90	translate <-137.5,-50,0>}
		object {HabitatRing	translate <0,-50,0>}
	}
#end

#if (InsertCARM1=True | InsertCARM2=True)
	#declare CARMShape=
	object {
		intersection {
			union {
				box {<-7,0,-1>,<7,9,60>}
				box {<-6,8.9,-1>,<6,10,60>}
				cylinder {<-6,9,-1>,<-6,9,60>,1}
				cylinder {<6,9,-1>,<6,9,60>,1}
			}
			union {
				sphere {<0,0,0>,10	scale <1.5,.75,3.5>	translate <0,4,15>}
				box{<-8,-1,0>,<8,11,15>}
			}
		}
	}
	#declare CARMBody=
	union {
		object {
			union {
				difference {
					difference {
						object {CARMShape}
						object {CARMShape translate <0,-5,-20>	scale <.95,.95,.95>	translate <0,5,20>}
					}
					box {<-10,5,30>,<10,9,55>}
					cylinder {<-10,7,20>,<10,7,20>,1}
					cylinder {<-10,7,15>,<10,7,15>,1}
					cylinder {<-10,7,10>,<10,7,10>,1}
				}
				difference {
					sphere {<0,0,0>,15	scale <1,.075,2>}
					box {<-15,-15,-31>,<15,15,0>}
					translate <0,1,0>
				}
			}
			texture {
				pigment {
					gradient y
					color_map {
						[0	color Gray30]
						[.1	color Gray50]
						[.1	color Gray80]
						[1	color White]
					}
					scale <1,11,1>
				}
				finish {ambient .3}
			}
			texture {
				pigment {
					brick
					pigment {color Gray40},
					pigment {color Clear}
					brick_size <2,2,2>
					mortar .1
				}
				finish {phong .3}
			}
		}
		object {
			intersection {
				difference {
					object {CARMShape}
					object {CARMShape translate <0,-5,-20>	scale <.95,.95,.95>	translate <0,5,20>}
				}
				union {
					box {<-10,5,30>,<10,9,55>}
					cylinder {<-10,7,20>,<10,7,20>,1}
					cylinder {<-10,7,15>,<10,7,15>,1}
					cylinder {<-10,7,10>,<10,7,10>,1}
				}
			}
			texture {T_Green_Glass}
		}
	}
	#declare CARMExhaust=
	object {
		difference {
			sphere {
				<0,0,0>, 1
				pigment { color rgbt <1, 1, 1, 1> }
				halo {
					emitting
					spherical_mapping
					linear
					turbulence .75
					color_map {
						[ 0.0 color rgbt <1, 0, 0,  1> ]
						[ 0.5 color rgbt <1, 1, 0, -1> ]
						[ 1.0 color rgbt <1, 0, 0,  1> ]
					}
					frequency 2
					samples 20
					scale 0.5
				}
				hollow
				scale <3,3,15>
			}
			box {<-10,-10,0>,<10,10,30>}
		}

	}
	#declare CARMRocket=
	object {
		difference {
			cone {<0,0,0>,2,<0,0,-4>,3}
			cone {<0,0,0>,2,<0,0,-4>,3	translate <0,0,-.25>}
			pigment {color Gray40}
			finish {phong .3}
		}
	}
	#declare CARM=
	union {
		object {CARMBody}
		object {CARMRocket	translate <-4,5,-.9>}
		object {CARMRocket	translate <4,5,-.9>}
	}

	#if (InsertCARM1=True)
		#declare CARMName1=
		object {
			box {<0,0,-.01>,<1,1,0>}
			pigment {
				image_map {
					gif "sonyar.gif"
					map_type 0
					filter 1, 1
				}
			}
			scale <7.5,3,1>
		}
		#declare CARM1=
		union {
			object {CARM}
			object {CARMExhaust	translate <-4,5,-1.9>}
			object {CARMExhaust	rotate z*160	translate <4,5,-1.9>}
			object {CARMName1	rotate y*-90	translate <6.995,5,.5>}
			object {CARMName1	rotate y*90	translate <-6.995,5,8>}
		}
	#end

	#if (InsertCARM2=True)
		#declare CARMName2=
		object {
			box {<0,0,-.01>,<1,1,0>}
			pigment {
				image_map {
					gif "strebor.gif"
					map_type 0
					filter 1, 1
				}
			}
			scale <7.5,3,1>
		}
		#declare CARM2=
		union {
			object {CARM}
			object {CARMExhaust	scale <1,1,3>	rotate z*45	translate <-4,5,-1.9>}
			object {CARMExhaust	scale <1,1,3>	rotate z*250	translate <4,5,-1.9>}
			object {CARMName2	rotate y*-90	translate <6.995,5,.5>}
			object {CARMName2	rotate y*90	translate <-6.995,5,8>}
		}
	#end
#end

