#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "mechparts_BM.inc"
#include "mechparts.inc"
#include "loc1.inc"
#include "loc2.inc"
#include "loc3.inc"
#include "loc4.inc"
#include "skies.inc"
#include "stones.inc"


global_settings
{
  assumed_gamma 1.0
}

// Set a color of the background (sky)
background { color red 0.005 green 0.01 blue 0.005 }

// sets the default texture that objects get when they have no texture specified
#default
{
 pigment {color Gray10}
}

/* ----------------------------------------
 camera
 {
   location  <2, 5, -40>
   direction 1.5*z
   right     4/3*x
   look_at   <2,3,0>
 }


// ----------------camera 2------------------------
 camera
 {
   location  <5, 0, 22>
   direction 1.5*z
   right     4/3*x
   look_at   <3,5,0>
 }
*/

// ----------------camera 3------------------------
 camera
 {
   location  <2, 0, -40>
   direction 1.5*z
   right     4/3*x
   look_at   <2,6,0>
 }


/* light_source
{
  0*x // light's position
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-3000, 3000, 3000>
}


light_source
{
  0*x // light's position
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-3000, 3000, -3000>
}
*/


light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <800, 0, 0> <0, 0, 8000> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  translate <-3000, 3000, -3000>
}



sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
 }
}

#declare MAPTEX   = texture{T_Stone4}

//near hill
#declare hills    = height_field {    tga "bumpmap1.tga"
translate <-.5, -.5, -.5>
scale <1740, 230, 1740>
scale <1.5, 1.5, 1.5>
rotate -10*y
translate< 0,-31,1230>
texture {MAPTEX} smooth}

//far mountain
#declare mountain = height_field {    tga "bumpmap2.tga"
translate <-.5, -.5, -.5>
scale <1250, 600, 1250>
scale <3, 3, 3>
rotate   0*y
translate<50,  0,2200>
texture {MAPTEX} smooth}

object{hills}
object{mountain}
object{O_Cloud2 scale 24 hollow}

/*
fog { distance 1100
colour rgbt<0.8, 0.8, 0.8,.3>
fog_type 2
fog_offset -11
fog_alt 20
turbulence 0.1
turb_depth 0.2  }

fog { distance 600
colour rgbf<0.7, 0.7, 0.8,.1>
fog_type 2
fog_offset -24
fog_alt 14
turbulence 0.5
turb_depth 0.3  }
*/

#declare Orig_Fog = 1
#declare Ground_Mist= 2

fog{
   fog_type Ground_Mist
   fog_alt 3
   fog_offset -1
   distance 40
   color LightSteelBlue
   turbulence <0.05, 0.05, 0.05>
   omega 0.25
   lambda 2.5
   octaves 6
}


/*   ----------------flat plane ------------------------
plane { y, -1
texture {
        pigment {color rgb <0.7,0.5,0.3>}
}
 translate <0,0,0>
}
*/

// Sand
object {
  height_field {
    tga "sand.tga"
    smooth
  }
  texture {MAPTEX}
  scale <250,2,250>
  translate <-125,-2,-125>
    }


// ------------------ scene -----------------

union { // Including locusts full scene

union { //  BM scene

// --------------begining right leg

object {Foot
rotate <-20,15, 0>
translate <.7,0,1>
}

object { Calf
rotate <-20,15, 0>
translate <.7,0,1>
}

object { Leg
scale <1,1,1.3>
translate <-1.2,4.5,.9>
}

// --------------end right leg

// --------------begining left leg


object { Foot
rotate <0,-25, 0>
translate <4,.5,-1.5>
}

object { Calf
rotate <0,-25, 0>
translate <4,.5,-1.5>
}

object { Leg
scale <1,1,1.3>
rotate <50, 0, 15>
translate <1.4,3.8,.9>
}

// ---------------- end left leg -------------

// ----------------- torso-------------

object { Torso_Pin
        scale <1,1,1.2>
        translate <2,6,.75>
}

object { Torso_Girdle
        rotate <0,0,7>
        translate <2,4.9,.4>
}

object { Crotch_Joint
        translate <2,5,-.5>
}

union {

object { Torso
        scale <1,1,1>
        translate <2,6,2>
        rotate <15,0,-7>
}

object {BM_torso  // left
        rotate <7,0,0>
        translate <3.7, 7.7, .6>
        rotate <25,0,-7>
}

object {BM_torso // right
         rotate <7,0,0>
         translate <.3, 7.7, .6>
         rotate <25,0,-7>
}


object { Tube_Launcher  // left
        translate <3.7,9.4,.5>
        rotate <25,0,-7>
}

object { Tube_Launcher  // right
        translate <.3,9.4,.5>
        rotate <25,0,-7>
}

object { Canopy
        finish { ambient 0.2 specular 0.9 reflection 0.3 }
        translate <2,9,0>
        rotate <25,0,-7>
}

object { Canopy_Backplate
        translate <2,9,0>
        rotate <25,0,-7>
}

translate <-.5,1,-3>
}

// --------------- arms --------------

object { Left_Arm
        rotate <75,-30,0>
        translate <3,5.5,-7.5>
}

object { Gun_BM
        scale <.33,.33,.33>
        rotate <-15,-30,0>
        translate <7.5,6.5,-2>
}

object { Right_Arm
        rotate <180,45,-5>
        translate <-4.7,16,5>}


  sphere { <0,0,0>, 2
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale .4
    }
finish { ambient 0.0 specular 0.0 reflection 0.0 }
hollow
scale <4,4,4>
translate <8,6, -5>
}



  sphere { <0,0,0>, 2
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale 1
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 10
      scale <.5,.5,.5>
    }
finish { ambient 0.0 specular 0.0 reflection 0.0 }
hollow
scale <4,4,4>
translate <1, 3, 1>
}






// -------------- scene --------------

translate <-2,0,0>
rotate <0,80,0>
}


// A Swarm of Locusts

object { Loc1
        texture { pigment {color Yellow}
 finish {
        ambient 0.2
        specular 0.5
        reflection 0.01
        metallic }
}
        rotate <0, 200, 0>
        scale <.25, .25, .25>
        translate <-11,-2, -20>
}

object { Loc2
        texture { pigment {color Yellow}
 finish {
        ambient 0.2
        specular 0.5
        reflection 0.01
        metallic }
}
        rotate <0,-90, 0>
        scale <.25, .25, .25>
        translate <-13,-2,-5>
}

object { Loc3
        texture { pigment {color Yellow}
 finish {
        ambient 0.2
        specular 0.5
        reflection 0.01
        metallic }
}
        rotate <0, -25, 0>
        scale <.25, .25, .25>
        translate <6,-2,20>
}


object { Loc4
        texture { pigment {color Yellow}
 finish {
        ambient 0.2
        specular 0.5
        reflection 0.01
        metallic }
}
        rotate <0,90, 0>
        scale <.25, .25, .25>
        translate <10,-2,0>
}




 finish {
        ambient 0.2
        specular 0.5
        reflection 0.01
        metallic }
rotate <0, -45, 0>
}
