#include "colors.inc"

#declare Cylindrical_Leg =
    cone { <0.0, 0.0, 0.0>, 0.3500053, <0.0, 9.90396, 0.0>, 0.3500053 }


#declare Pin =
    cone { <0.0, 0.0, 0.0>, 0.3846154, <0.0, 2, 0.0>, 0.3846154
        rotate <.0, .0, -270>
    }

#declare Toe =
union {  // Layer name: skin
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 1.9721, 0.0>, 0.25
        rotate <270, .0, .0>
        translate <-0.9998337, 0.2436823, 1.97201>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 1.9721, 0.0>, 0.5
        rotate <270, .0, .0>
        translate <1.00017, 0.4936823, 1.97201>
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.9998337, -0.006317728, 1.97201>, <-1.2723e-008, 3.94421, -5.70748e-011>,
                         <1.00017, -0.006317722, 1.97201>, <-1.2723e-008, 3.94421, -5.70748e-011>,
                         <1.00017, -0.006317722, -8.92198e-005>, <-1.2723e-008, 3.94421, -5.70748e-011> }
        smooth_triangle {<1.00017, -0.006317722, -8.92198e-005>, <-1.2723e-008, 3.94421, -5.70748e-011>,
                         <-0.9998337, -0.006317728, -8.92232e-005>, <-1.2723e-008, 3.94421, -5.70748e-011>,
                         <-0.9998337, -0.006317728, 1.97201>, <-1.2723e-008, 3.94421, -5.70748e-011> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-1.05961, 0.4864293, 1.97201>, <3.33449e-009, -2.84691e-011, -1.96744>,
                         <0.8770883, 0.9782973, 1.97201>, <3.33449e-009, -2.84691e-011, -1.96744>,
                         <1.00017, -0.006317722, 1.97201>, <3.33449e-009, -2.84691e-011, -1.96744> }
        smooth_triangle {<1.00017, -0.006317722, 1.97201>, <2.50237e-009, -2.13648e-011, -1.47647>,
                         <-0.9998337, -0.006317728, 1.97201>, <1.67025e-009, -1.42605e-011, -0.985494>,
                         <-1.05961, 0.4864293, 1.97201>, <2.50237e-009, -2.13648e-011, -1.47647> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.9998337, -0.006317728, -8.92232e-005>, <-3.33751e-009, 2.84956e-011, 1.96923>,
                         <1.00017, -0.006317722, -8.92198e-005>, <-3.33751e-009, 2.84956e-011, 1.96923>,
                         <0.8770883, 0.9782973, -8.92201e-005>, <-3.33751e-009, 2.84956e-011, 1.96923> }
        smooth_triangle {<0.8770883, 0.9782973, -8.92201e-005>, <-2.50237e-009, 2.13651e-011, 1.47647>,
                         <-1.05961, 0.4864293, -8.92233e-005>, <-1.66722e-009, 1.42345e-011, 0.983708>,
                         <-0.9998337, -0.006317728, -8.92232e-005>, <-2.50237e-009, 2.13651e-011, 1.47647> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-1.05961, 0.4864293, 1.97201>, <-0.9700142, 3.81938, -1.69928e-009>,
                         <0.8770883, 0.9782973, 1.97201>, <-0.9700142, 3.81938, -1.69928e-009>,
                         <0.8770883, 0.9782973, -8.92201e-005>, <-0.9700142, 3.81938, -1.69928e-009> }
        smooth_triangle {<0.8770883, 0.9782973, -8.92201e-005>, <-0.9700142, 3.81938, -1.69928e-009>,
                         <-1.05961, 0.4864293, -8.92233e-005>, <-0.9700142, 3.81938, -1.69928e-009>,
                         <-1.05961, 0.4864293, 1.97201>, <-0.9700142, 3.81938, -1.69928e-009> }
    }
}

#declare Gun =
union {
difference {

union {
    box { <0.0, 0.0, 0.0>, <1.97291, 5.28846, 9.47115>
        translate <-0.986456, -2.93269, -4.90385>
    }
    cone { <0.0, 0.0, 0.0>, 0.986456, <0.0, 9.47115, 0.0>, 0.986456
        rotate <90, .0, .0>
        translate <0, 2.35577, -4.90385>
    }
    cone { <0.0, 0.0, 0.0>, 0.986456, <0.0, 9.47115, 0.0>, 0.986456
        rotate <90, .0, .0>
        translate <0, -2.93269, -4.90385>
   }
//        pigment {color Yellow}
     }

union {
      cylinder
        { <1,1,-.001>, <1, 1, 7> .6
        translate <-0.986456, -3.5, -4.90385>
        }
      cylinder
        { <1,1,-.001>, <1, 1, 7> .6
        translate <-0.986456, -1.25, -4.90385>
        }
      cylinder
        { <1,1,-.001>, <1, 1, 7> .6
        translate <-0.986456, 1, -4.90385>
        }
        pigment {color Gray05}
      }
}

union {
difference {
cylinder
{
  <1,1,-1>, <1, 1, 7> .7
}
cylinder
{
  <1,1,-1.001>, <1, 1, 7> .6
}
translate <-0.986456, -3.5, -4.90385>
}


difference {
cylinder
{
  <1,1,-1>, <1, 1, 7> .7
}
cylinder
{
  <1,1,-1.001>, <1, 1, 7> .6
}
translate <-0.986456, -1.25, -4.90385>
}

difference {
cylinder
{
  <1,1,-1>, <1, 1, 7> .7
}
cylinder
{
  <1,1,-1.001>, <1, 1, 7> .6
}
translate <-0.986456, 1, -4.90385>
}
pigment { color Gray05 }
}


}



#declare Boot =
union {  // Layer name: BOOT
    union { // Poly_Mesh
        smooth_triangle {<-0.7599071, 2.60807, 1.17677>, <-5.92873e-010, -0.007181679, 0.05147548>,
                         <-0.6029557, 2.43221, 1.15224>, <-5.11075e-010, -0.006190826, 0.04437343>,
                         <-0.4889268, 2.63242, 1.18017>, <-5.92873e-010, -0.007181679, 0.05147548> }
        smooth_triangle {<-0.4889268, 2.63242, 1.18017>, <-6.75627e-010, -0.008184104, 0.05866047>,
                         <-0.598967, 2.86552, 1.21269>, <-7.58381e-010, -0.009186528, 0.06584546>,
                         <-0.7599071, 2.60807, 1.17677>, <-6.75627e-010, -0.008184104, 0.05866047> }
        smooth_triangle {<-0.6029557, 2.43221, 1.15224>, <-5.11075e-010, -0.006190826, 0.04437343>,
                         <-0.4328977, 2.24598, 1.12626>, <-4.4251e-010, -0.005360279, 0.03842039>,
                         <-0.3717734, 2.40268, 1.14812>, <-4.38021e-010, -0.005305901, 0.03803064> }
        smooth_triangle {<-0.3717734, 2.40268, 1.14812>, <-5.04947e-010, -0.006116603, 0.04384143>,
                         <-0.4889268, 2.63242, 1.18017>, <-5.82373e-010, -0.007054492, 0.05056386>,
                         <-0.6029557, 2.43221, 1.15224>, <-5.26274e-010, -0.006374946, 0.04569313> }
        smooth_triangle {<-0.4328977, 2.24598, 1.12626>, <-4.4251e-010, -0.005360279, 0.03842039>,
                         <-0.1846984, 2.11424, 1.10788>, <-4.94241e-010, -0.00598691, 0.04291184>,
                         <-0.1661363, 2.24821, 1.12657>, <-4.1114e-010, -0.004980287, 0.03569676> }
        smooth_triangle {<-0.1661363, 2.24821, 1.12657>, <-4.45506e-010, -0.005396568, 0.0386805>,
                         <-0.3717734, 2.40268, 1.14812>, <-4.58946e-010, -0.005559375, 0.03984744>,
                         <-0.4328977, 2.24598, 1.12626>, <-4.5185e-010, -0.005473421, 0.03923136> }
        smooth_triangle {<-0.1846984, 2.11424, 1.10788>, <-4.94241e-010, -0.00598691, 0.04291184>,
                         <0.0962085, 2.11424, 1.10788>, <-5.65435e-010, -0.006849314, 0.04909322>,
                         <0.07764642, 2.24821, 1.12657>, <-4.33444e-010, -0.00525046, 0.03763326> }
        smooth_triangle {<0.07764642, 2.24821, 1.12657>, <-4.04802e-010, -0.004903515, 0.03514649>,
                         <-0.1661363, 2.24821, 1.12657>, <-3.93651e-010, -0.004768428, 0.03417824>,
                         <-0.1846984, 2.11424, 1.10788>, <-4.64721e-010, -0.005629325, 0.04034881> }
        smooth_triangle {<0.0962085, 2.11424, 1.10788>, <-5.65435e-010, -0.006849314, 0.04909322>,
                         <0.3444078, 2.24598, 1.12626>, <-6.21689e-010, -0.007530741, 0.05397742>,
                         <0.2832835, 2.40268, 1.14812>, <-5.40687e-010, -0.006549529, 0.04694448> }
        smooth_triangle {<0.2832835, 2.40268, 1.14812>, <-4.45506e-010, -0.005396568, 0.0386805>,
                         <0.07764642, 2.24821, 1.12657>, <-3.91884e-010, -0.004747033, 0.03402489>,
                         <0.0962085, 2.11424, 1.10788>, <-5.11658e-010, -0.006197887, 0.04442404> }
        smooth_triangle {<0.3444078, 2.24598, 1.12626>, <-6.21689e-010, -0.007530741, 0.05397742>,
                         <0.5144657, 2.43221, 1.15224>, <-6.64013e-010, -0.008043418, 0.0576521>,
                         <0.4004369, 2.63242, 1.18017>, <-6.36721e-010, -0.007712829, 0.05528256> }
        smooth_triangle {<0.4004369, 2.63242, 1.18017>, <-5.04947e-010, -0.006116603, 0.04384143>,
                         <0.2832835, 2.40268, 1.14812>, <-4.5693e-010, -0.005534953, 0.03967239>,
                         <0.3444078, 2.24598, 1.12626>, <-5.5956e-010, -0.00677815, 0.04858314> }
        smooth_triangle {<0.5144657, 2.43221, 1.15224>, <-6.64013e-010, -0.008043418, 0.0576521>,
                         <0.6714172, 2.60807, 1.17677>, <-6.92689e-010, -0.008390783, 0.06014187>,
                         <0.5104771, 2.86552, 1.21269>, <-7.91371e-010, -0.009586156, 0.06870984> }
        smooth_triangle {<0.5104771, 2.86552, 1.21269>, <-6.75627e-010, -0.008184104, 0.05866047>,
                         <0.4004369, 2.63242, 1.18017>, <-5.98302e-010, -0.00724744, 0.05194683>,
                         <0.5144657, 2.43221, 1.15224>, <-6.3798e-010, -0.007728077, 0.05539185> }
        smooth_triangle {<-0.7362556, 2.24823, 1.12657>, <-5.0233e-010, -0.006084898, 0.04361418>,
                         <-0.5851333, 2.12962, 1.11002>, <-4.98567e-010, -0.006039317, 0.04328748>,
                         <-0.6029557, 2.43221, 1.15224>, <-5.11075e-010, -0.006190826, 0.04437343> }
        smooth_triangle {<-0.6029557, 2.43221, 1.15224>, <-5.33949e-010, -0.006467908, 0.04635945>,
                         <-0.7599071, 2.60807, 1.17677>, <-5.97722e-010, -0.007240416, 0.05189649>,
                         <-0.7362556, 2.24823, 1.12657>, <-5.52451e-010, -0.006692026, 0.04796584> }
        smooth_triangle {<-0.5851333, 2.12962, 1.11002>, <-4.98567e-010, -0.006039317, 0.04328748>,
                         <-0.4149113, 1.9869, 1.09011>, <-5.4138e-010, -0.006557921, 0.04700463>,
                         <-0.4328977, 2.24598, 1.12626>, <-4.4251e-010, -0.005360279, 0.03842039> }
        smooth_triangle {<-0.4328977, 2.24598, 1.12626>, <-4.70493e-010, -0.005699247, 0.04084998>,
                         <-0.6029557, 2.43221, 1.15224>, <-5.21917e-010, -0.006322157, 0.04531476>,
                         <-0.5851333, 2.12962, 1.11002>, <-5.12536e-010, -0.006208525, 0.0445003> }
        smooth_triangle {<-0.4149113, 1.9869, 1.09011>, <-5.4138e-010, -0.006557921, 0.04700463>,
                         <-0.1768903, 1.87789, 1.0749>, <-6.62809e-010, -0.008028838, 0.05754759>,
                         <-0.1846984, 2.11424, 1.10788>, <-4.94241e-010, -0.00598691, 0.04291184> }
        smooth_triangle {<-0.1846984, 2.11424, 1.10788>, <-5.49011e-010, -0.006650366, 0.04766724>,
                         <-0.4328977, 2.24598, 1.12626>, <-5.10213e-010, -0.006180393, 0.04429865>,
                         <-0.4149113, 1.9869, 1.09011>, <-5.84365e-010, -0.007078624, 0.05073683> }
        smooth_triangle {<-0.1768903, 1.87789, 1.0749>, <-6.62809e-010, -0.008028838, 0.05754759>,
                         <0.08840034, 1.87789, 1.0749>, <-7.01267e-010, -0.008494698, 0.06088669>,
                         <0.0962085, 2.11424, 1.10788>, <-5.65435e-010, -0.006849314, 0.04909322> }
        smooth_triangle {<0.0962085, 2.11424, 1.10788>, <-6.15248e-010, -0.00745271, 0.05341813>,
                         <-0.1846984, 2.11424, 1.10788>, <-5.61852e-010, -0.006805907, 0.0487821>,
                         <-0.1768903, 1.87789, 1.0749>, <-6.88278e-010, -0.008337353, 0.05975891> }
        smooth_triangle {<0.08840034, 1.87789, 1.0749>, <-7.01267e-010, -0.008494698, 0.06088669>,
                         <0.3264214, 1.9869, 1.09011>, <-6.44551e-010, -0.007807675, 0.05596238>,
                         <0.3444078, 2.24598, 1.12626>, <-6.21689e-010, -0.007530741, 0.05397742> }
        smooth_triangle {<0.3444078, 2.24598, 1.12626>, <-6.32217e-010, -0.007658269, 0.0548915>,
                         <0.0962085, 2.11424, 1.10788>, <-5.90027e-010, -0.007147199, 0.05122834>,
                         <0.08840034, 1.87789, 1.0749>, <-6.91901e-010, -0.008381237, 0.06007345> }
        smooth_triangle {<0.3264214, 1.9869, 1.09011>, <-6.44551e-010, -0.007807675, 0.05596238>,
                         <0.4966434, 2.12962, 1.11002>, <-5.85645e-010, -0.007094128, 0.05084795>,
                         <0.5144657, 2.43221, 1.15224>, <-6.64013e-010, -0.008043418, 0.0576521> }
        smooth_triangle {<0.5144657, 2.43221, 1.15224>, <-6.15226e-010, -0.007452446, 0.05341623>,
                         <0.3444078, 2.24598, 1.12626>, <-5.83483e-010, -0.007067938, 0.05066023>,
                         <0.3264214, 1.9869, 1.09011>, <-6.0063e-010, -0.007275639, 0.05214895> }
        smooth_triangle {<0.4966434, 2.12962, 1.11002>, <-5.85645e-010, -0.007094128, 0.05084795>,
                         <0.6477657, 2.24823, 1.12657>, <-6.02742e-010, -0.00730123, 0.05233238>,
                         <0.6714172, 2.60807, 1.17677>, <-6.92689e-010, -0.008390783, 0.06014187> }
        smooth_triangle {<0.6714172, 2.60807, 1.17677>, <-6.32091e-010, -0.007656736, 0.0548805>,
                         <0.5144657, 2.43221, 1.15224>, <-6.25733e-010, -0.007579724, 0.05432852>,
                         <0.4966434, 2.12962, 1.11002>, <-5.66958e-010, -0.006867756, 0.04922541> }
        smooth_triangle {<-0.7248999, 1.88677, 1.07614>, <-5.15003e-010, -0.006238406, 0.04471447>,
                         <-0.5760937, 1.82541, 1.06758>, <-5.3087e-010, -0.006430611, 0.04609212>,
                         <-0.5851333, 2.12962, 1.11002>, <-4.98567e-010, -0.006039317, 0.04328748> }
        smooth_triangle {<-0.5851333, 2.12962, 1.11002>, <-5.27334e-010, -0.006387777, 0.0457851>,
                         <-0.7362556, 2.24823, 1.12657>, <-5.57982e-010, -0.006759027, 0.04844608>,
                         <-0.7248999, 1.88677, 1.07614>, <-5.64318e-010, -0.006835781, 0.04899622> }
        smooth_triangle {<-0.5760937, 1.82541, 1.06758>, <-5.3087e-010, -0.006430611, 0.04609212>,
                         <-0.4021945, 1.7262, 1.05374>, <-5.74209e-010, -0.006955595, 0.049855>,
                         <-0.4149113, 1.9869, 1.09011>, <-5.4138e-010, -0.006557921, 0.04700463> }
        smooth_triangle {<-0.4149113, 1.9869, 1.09011>, <-5.51427e-010, -0.00667963, 0.04787699>,
                         <-0.5851333, 2.12962, 1.11002>, <-5.19318e-010, -0.006290677, 0.04508913>,
                         <-0.5760937, 1.82541, 1.06758>, <-5.43545e-010, -0.006584147, 0.04719261> }
        smooth_triangle {<-0.4021945, 1.7262, 1.05374>, <-5.74209e-010, -0.006955595, 0.049855>,
                         <-0.1708387, 1.63991, 1.0417>, <-6.59324e-010, -0.007986618, 0.05724498>,
                         <-0.1768903, 1.87789, 1.0749>, <-6.62809e-010, -0.008028838, 0.05754759> }
        smooth_triangle {<-0.1768903, 1.87789, 1.0749>, <-6.7179e-010, -0.008137629, 0.05832736>,
                         <-0.4149113, 1.9869, 1.09011>, <-5.80718e-010, -0.00703444, 0.05042013>,
                         <-0.4021945, 1.7262, 1.05374>, <-6.0534e-010, -0.007332697, 0.05255792> }
        smooth_triangle {<-0.1708387, 1.63991, 1.0417>, <-6.59324e-010, -0.007986618, 0.05724498>,
                         <0.08234873, 1.63991, 1.0417>, <-6.9134e-010, -0.008374444, 0.06002476>,
                         <0.08840034, 1.87789, 1.0749>, <-7.01267e-010, -0.008494698, 0.06088669> }
        smooth_triangle {<0.08840034, 1.87789, 1.0749>, <-7.07736e-010, -0.008573055, 0.06144833>,
                         <-0.1768903, 1.87789, 1.0749>, <-6.78892e-010, -0.00822366, 0.058944>,
                         <-0.1708387, 1.63991, 1.0417>, <-6.76278e-010, -0.008191995, 0.05871704> }
        smooth_triangle {<0.08234873, 1.63991, 1.0417>, <-6.9134e-010, -0.008374444, 0.06002476>,
                         <0.3137046, 1.7262, 1.05374>, <-6.69514e-010, -0.008110056, 0.05812973>,
                         <0.3264214, 1.9869, 1.09011>, <-6.44551e-010, -0.007807675, 0.05596238> }
        smooth_triangle {<0.3264214, 1.9869, 1.09011>, <-6.44614e-010, -0.007808428, 0.05596778>,
                         <0.08840034, 1.87789, 1.0749>, <-6.87151e-010, -0.008323695, 0.05966101>,
                         <0.08234873, 1.63991, 1.0417>, <-6.79705e-010, -0.008233505, 0.05901456> }
        smooth_triangle {<0.3137046, 1.7262, 1.05374>, <-6.69514e-010, -0.008110056, 0.05812973>,
                         <0.4876038, 1.82541, 1.06758>, <-6.36343e-010, -0.007708248, 0.05524972>,
                         <0.4966434, 2.12962, 1.11002>, <-5.85645e-010, -0.007094128, 0.05084795> }
        smooth_triangle {<0.4966434, 2.12962, 1.11002>, <-5.61789e-010, -0.006805142, 0.04877661>,
                         <0.3264214, 1.9869, 1.09011>, <-6.05968e-010, -0.007340303, 0.05261244>,
                         <0.3137046, 1.7262, 1.05374>, <-6.2469e-010, -0.007567088, 0.05423795> }
        smooth_triangle {<0.4876038, 1.82541, 1.06758>, <-6.36343e-010, -0.007708248, 0.05524972>,
                         <0.6364099, 1.88677, 1.07614>, <-6.45253e-010, -0.007816182, 0.05602336>,
                         <0.6477657, 2.24823, 1.12657>, <-6.02742e-010, -0.00730123, 0.05233238> }
        smooth_triangle {<0.6477657, 2.24823, 1.12657>, <-5.74214e-010, -0.006955657, 0.04985545>,
                         <0.4966434, 2.12962, 1.11002>, <-5.68523e-010, -0.006886724, 0.04936136>,
                         <0.4876038, 1.82541, 1.06758>, <-6.06547e-010, -0.007347314, 0.05266269> }
        smooth_triangle {<-0.7758374, 1.52919, 1.02625>, <-5.69974e-010, -0.006904296, 0.04948731>,
                         <-0.6115493, 1.52507, 1.02568>, <-5.86337e-010, -0.007102508, 0.05090801>,
                         <-0.5760937, 1.82541, 1.06758>, <-5.3087e-010, -0.006430611, 0.04609212> }
        smooth_triangle {<-0.5760937, 1.82541, 1.06758>, <-5.60365e-010, -0.0067879, 0.04865303>,
                         <-0.7248999, 1.88677, 1.07614>, <-5.81927e-010, -0.007049087, 0.05052511>,
                         <-0.7758374, 1.52919, 1.02625>, <-6.09413e-010, -0.007382032, 0.05291153> }
        smooth_triangle {<-0.6115493, 1.52507, 1.02568>, <-5.86337e-010, -0.007102508, 0.05090801>,
                         <-0.4161748, 1.46938, 1.01791>, <-6.30493e-010, -0.007637383, 0.0547418>,
                         <-0.4021945, 1.7262, 1.05374>, <-5.74209e-010, -0.006955595, 0.049855> }
        smooth_triangle {<-0.4021945, 1.7262, 1.05374>, <-5.91169e-010, -0.007161042, 0.05132756>,
                         <-0.5760937, 1.82541, 1.06758>, <-5.58665e-010, -0.006767303, 0.0485054>,
                         <-0.6115493, 1.52507, 1.02568>, <-6.00266e-010, -0.007271226, 0.05211732> }
        smooth_triangle {<-0.4161748, 1.46938, 1.01791>, <-6.30493e-010, -0.007637383, 0.0547418>,
                         <-0.1736861, 1.40582, 1.00904>, <-6.80878e-010, -0.008247713, 0.0591164>,
                         <-0.1708387, 1.63991, 1.0417>, <-6.59324e-010, -0.007986618, 0.05724498> }
        smooth_triangle {<-0.1708387, 1.63991, 1.0417>, <-6.69052e-010, -0.008104463, 0.05808964>,
                         <-0.4021945, 1.7262, 1.05374>, <-6.05216e-010, -0.007331196, 0.05254716>,
                         <-0.4161748, 1.46938, 1.01791>, <-6.47429e-010, -0.007842537, 0.05621226> }
        smooth_triangle {<-0.1736861, 1.40582, 1.00904>, <-6.80878e-010, -0.008247713, 0.0591164>,
                         <0.08519616, 1.40582, 1.00904>, <-7.13792e-010, -0.008646409, 0.0619741>,
                         <0.08234873, 1.63991, 1.0417>, <-6.9134e-010, -0.008374444, 0.06002476> }
        smooth_triangle {<0.08234873, 1.63991, 1.0417>, <-6.89167e-010, -0.008348125, 0.05983611>,
                         <-0.1708387, 1.63991, 1.0417>, <-6.65155e-010, -0.008057256, 0.05775128>,
                         <-0.1736861, 1.40582, 1.00904>, <-6.81321e-010, -0.008253076, 0.05915484> }
        smooth_triangle {<0.08519616, 1.40582, 1.00904>, <-7.13792e-010, -0.008646409, 0.0619741>,
                         <0.3276849, 1.46938, 1.01791>, <-7.29648e-010, -0.008838482, 0.0633508>,
                         <0.3137046, 1.7262, 1.05374>, <-6.69514e-010, -0.008110056, 0.05812973> }
        smooth_triangle {<0.3137046, 1.7262, 1.05374>, <-6.5879e-010, -0.007980148, 0.0571986>,
                         <0.08234873, 1.63991, 1.0417>, <-6.75159e-010, -0.008178439, 0.05861987>,
                         <0.08519616, 1.40582, 1.00904>, <-6.91998e-010, -0.008382412, 0.06008187> }
        smooth_triangle {<0.3276849, 1.46938, 1.01791>, <-7.29648e-010, -0.008838482, 0.0633508>,
                         <0.5230593, 1.52507, 1.02568>, <-7.13396e-010, -0.008641623, 0.06193979>,
                         <0.4876038, 1.82541, 1.06758>, <-6.36343e-010, -0.007708248, 0.05524972> }
        smooth_triangle {<0.4876038, 1.82541, 1.06758>, <-6.09848e-010, -0.007387303, 0.05294931>,
                         <0.3137046, 1.7262, 1.05374>, <-6.34726e-010, -0.007688659, 0.05510932>,
                         <0.3276849, 1.46938, 1.01791>, <-6.79827e-010, -0.008234978, 0.05902512> }
        smooth_triangle {<0.5230593, 1.52507, 1.02568>, <-7.13396e-010, -0.008641623, 0.06193979>,
                         <0.6873475, 1.52919, 1.02625>, <-6.95202e-010, -0.008421223, 0.06036005>,
                         <0.6364099, 1.88677, 1.07614>, <-6.45253e-010, -0.007816182, 0.05602336> }
        smooth_triangle {<0.6364099, 1.88677, 1.07614>, <-6.10101e-010, -0.007390372, 0.05297131>,
                         <0.4876038, 1.82541, 1.06758>, <-6.12207e-010, -0.007415873, 0.0531541>,
                         <0.5230593, 1.52507, 1.02568>, <-6.69997e-010, -0.008115905, 0.05817165> }
        smooth_triangle {<-0.838747, 1.17379, 0.9766691>, <-6.02158e-010, -0.007294151, 0.05228164>,
                         <-0.6555563, 1.22691, 0.9840815>, <-6.32972e-010, -0.007667407, 0.05495699>,
                         <-0.6115493, 1.52507, 1.02568>, <-5.86337e-010, -0.007102508, 0.05090801> }
        smooth_triangle {<-0.6115493, 1.52507, 1.02568>, <-6.08623e-010, -0.007372456, 0.0528429>,
                         <-0.7758374, 1.52919, 1.02625>, <-6.22726e-010, -0.007543297, 0.05406742>,
                         <-0.838747, 1.17379, 0.9766691>, <-6.38818e-010, -0.007738225, 0.05546459> }
        smooth_triangle {<-0.6555563, 1.22691, 0.9840815>, <-6.32972e-010, -0.007667407, 0.05495699>,
                         <-0.435286, 1.21473, 0.9823819>, <-6.76344e-010, -0.008192797, 0.05872278>,
                         <-0.4161748, 1.46938, 1.01791>, <-6.30493e-010, -0.007637383, 0.0547418> }
        smooth_triangle {<-0.4161748, 1.46938, 1.01791>, <-6.47658e-010, -0.007845313, 0.05623216>,
                         <-0.6115493, 1.52507, 1.02568>, <-6.14542e-010, -0.007444157, 0.05335682>,
                         <-0.6555563, 1.22691, 0.9840815>, <-6.49517e-010, -0.007867831, 0.05639355> }
        smooth_triangle {<-0.435286, 1.21473, 0.9823819>, <-6.76344e-010, -0.008192797, 0.05872278>,
                         <-0.1782438, 1.1739, 0.9766847>, <-7.02124e-010, -0.008505076, 0.06096108>,
                         <-0.1736861, 1.40582, 1.00904>, <-6.80878e-010, -0.008247713, 0.0591164> }
        smooth_triangle {<-0.1736861, 1.40582, 1.00904>, <-6.91955e-010, -0.008381893, 0.06007815>,
                         <-0.4161748, 1.46938, 1.01791>, <-6.54166e-010, -0.007924146, 0.0567972>,
                         <-0.435286, 1.21473, 0.9823819>, <-6.88555e-010, -0.008340706, 0.05978294> }
        smooth_triangle {<-0.1782438, 1.1739, 0.9766847>, <-7.02124e-010, -0.008505076, 0.06096108>,
                         <0.08975388, 1.1739, 0.9766847>, <-7.32117e-010, -0.008868393, 0.0635652>,
                         <0.08519616, 1.40582, 1.00904>, <-7.13792e-010, -0.008646409, 0.0619741> }
        smooth_triangle {<0.08519616, 1.40582, 1.00904>, <-7.08222e-010, -0.008578943, 0.06149053>,
                         <-0.1736861, 1.40582, 1.00904>, <-6.83537e-010, -0.008279921, 0.05934725>,
                         <-0.1782438, 1.1739, 0.9766847>, <-6.99471e-010, -0.008472943, 0.06073076> }
        smooth_triangle {<0.08975388, 1.1739, 0.9766847>, <-7.32117e-010, -0.008868393, 0.0635652>,
                         <0.3467961, 1.21473, 0.9823819>, <-7.64636e-010, -0.00926231, 0.06638864>,
                         <0.3276849, 1.46938, 1.01791>, <-7.29648e-010, -0.008838482, 0.0633508> }
        smooth_triangle {<0.3276849, 1.46938, 1.01791>, <-7.10001e-010, -0.008600493, 0.06164499>,
                         <0.08519616, 1.40582, 1.00904>, <-6.98109e-010, -0.008456438, 0.06061246>,
                         <0.08975388, 1.1739, 0.9766847>, <-7.11853e-010, -0.008622927, 0.06180579> }
        smooth_triangle {<0.3467961, 1.21473, 0.9823819>, <-7.64636e-010, -0.00926231, 0.06638864>,
                         <0.5670664, 1.22691, 0.9840815>, <-7.59069e-010, -0.009194875, 0.06590529>,
                         <0.5230593, 1.52507, 1.02568>, <-7.13396e-010, -0.008641623, 0.06193979> }
        smooth_triangle {<0.5230593, 1.52507, 1.02568>, <-6.81365e-010, -0.00825362, 0.05915874>,
                         <0.3276849, 1.46938, 1.01791>, <-6.93554e-010, -0.008401265, 0.060217>,
                         <0.3467961, 1.21473, 0.9823819>, <-7.19796e-010, -0.008719136, 0.06249538> }
        smooth_triangle {<0.5670664, 1.22691, 0.9840815>, <-7.59069e-010, -0.009194875, 0.06590529>,
                         <0.7502571, 1.17379, 0.9766691>, <-7.39162e-010, -0.008953725, 0.06417682>,
                         <0.6873475, 1.52919, 1.02625>, <-6.95202e-010, -0.008421223, 0.06036005> }
        smooth_triangle {<0.6873475, 1.52919, 1.02625>, <-6.52221e-010, -0.007900588, 0.05662834>,
                         <0.5230593, 1.52507, 1.02568>, <-6.76613e-010, -0.008196046, 0.05874607>,
                         <0.5670664, 1.22691, 0.9840815>, <-7.10867e-010, -0.008610985, 0.0617202> }
        smooth_triangle {<-0.84625, 0.8118369, 0.9261714>, <-6.48045e-010, -0.007849993, 0.0562657>,
                         <-0.6599872, 0.9222114, 0.9415704>, <-6.66102e-010, -0.00806872, 0.05783345>,
                         <-0.6555563, 1.22691, 0.9840815>, <-6.32972e-010, -0.007667407, 0.05495699> }
        smooth_triangle {<-0.6555563, 1.22691, 0.9840815>, <-6.64501e-010, -0.008049331, 0.05769448>,
                         <-0.838747, 1.17379, 0.9766691>, <-6.80624e-010, -0.008244628, 0.05909429>,
                         <-0.84625, 0.8118369, 0.9261714>, <-7.03567e-010, -0.008522549, 0.06108632> }
        smooth_triangle {<-0.6599872, 0.9222114, 0.9415704>, <-6.66102e-010, -0.00806872, 0.05783345>,
                         <-0.4306516, 0.9535418, 0.9459415>, <-7.03823e-010, -0.008525651, 0.06110855>,
                         <-0.435286, 1.21473, 0.9823819>, <-6.76344e-010, -0.008192797, 0.05872278> }
        smooth_triangle {<-0.435286, 1.21473, 0.9823819>, <-7.0067e-010, -0.008487459, 0.06083481>,
                         <-0.6555563, 1.22691, 0.9840815>, <-6.6814e-010, -0.008093416, 0.05801046>,
                         <-0.6599872, 0.9222114, 0.9415704>, <-6.92988e-010, -0.008394401, 0.06016781> }
        smooth_triangle {<-0.4306516, 0.9535418, 0.9459415>, <-7.03823e-010, -0.008525651, 0.06110855>,
                         <-0.1748863, 0.9354327, 0.943415>, <-7.04515e-010, -0.008534044, 0.06116871>,
                         <-0.1782438, 1.1739, 0.9766847>, <-7.02124e-010, -0.008505076, 0.06096108> }
        smooth_triangle {<-0.1782438, 1.1739, 0.9766847>, <-7.19362e-010, -0.008713886, 0.06245775>,
                         <-0.435286, 1.21473, 0.9823819>, <-7.00027e-010, -0.008479677, 0.06077903>,
                         <-0.4306516, 0.9535418, 0.9459415>, <-7.20636e-010, -0.008729318, 0.06256836> }
        smooth_triangle {<-0.1748863, 0.9354327, 0.943415>, <-7.04515e-010, -0.008534044, 0.06116871>,
                         <0.08639637, 0.9354327, 0.943415>, <-7.26738e-010, -0.008803235, 0.06309816>,
                         <0.08975388, 1.1739, 0.9766847>, <-7.32117e-010, -0.008868393, 0.0635652> }
        smooth_triangle {<0.08975388, 1.1739, 0.9766847>, <-7.33104e-010, -0.008880348, 0.06365088>,
                         <-0.1782438, 1.1739, 0.9766847>, <-7.10609e-010, -0.00860786, 0.06169779>,
                         <-0.1748863, 0.9354327, 0.943415>, <-7.12403e-010, -0.008629586, 0.06185352> }
        smooth_triangle {<0.08639637, 0.9354327, 0.943415>, <-7.26738e-010, -0.008803235, 0.06309816>,
                         <0.3421616, 0.9535418, 0.9459415>, <-7.77373e-010, -0.009416596, 0.0674945>,
                         <0.3467961, 1.21473, 0.9823819>, <-7.64636e-010, -0.00926231, 0.06638864> }
        smooth_triangle {<0.3467961, 1.21473, 0.9823819>, <-7.49576e-010, -0.009079882, 0.06508107>,
                         <0.08975388, 1.1739, 0.9766847>, <-7.25187e-010, -0.008784445, 0.06296348>,
                         <0.08639637, 0.9354327, 0.943415>, <-7.21153e-010, -0.008735576, 0.06261321> }
        smooth_triangle {<0.3421616, 0.9535418, 0.9459415>, <-7.77373e-010, -0.009416596, 0.0674945>,
                         <0.5714972, 0.9222114, 0.9415704>, <-8.00223e-010, -0.009693388, 0.06947844>,
                         <0.5670664, 1.22691, 0.9840815>, <-7.59069e-010, -0.009194875, 0.06590529> }
        smooth_triangle {<0.5670664, 1.22691, 0.9840815>, <-7.34798e-010, -0.008900871, 0.06379798>,
                         <0.3467961, 1.21473, 0.9823819>, <-7.38974e-010, -0.008951447, 0.06416049>,
                         <0.3421616, 0.9535418, 0.9459415>, <-7.48526e-010, -0.009067161, 0.06498989> }
        smooth_triangle {<0.5714972, 0.9222114, 0.9415704>, <-8.00223e-010, -0.009693388, 0.06947844>,
                         <0.7577601, 0.8118369, 0.9261714>, <-7.735e-010, -0.009369677, 0.06715821>,
                         <0.7502571, 1.17379, 0.9766691>, <-7.39162e-010, -0.008953725, 0.06417682> }
        smooth_triangle {<0.7502571, 1.17379, 0.9766691>, <-7.06169e-010, -0.008554077, 0.0613123>,
                         <0.5670664, 1.22691, 0.9840815>, <-7.29348e-010, -0.008834852, 0.06332478>,
                         <0.5714972, 0.9222114, 0.9415704>, <-7.60214e-010, -0.009208737, 0.06600465> }
        smooth_triangle {<-0.8469602, 0.4497867, 0.8756594>, <-6.58681e-010, -0.00797883, 0.05718915>,
                         <-0.6595661, 0.617407, 0.8990452>, <-6.88401e-010, -0.008338843, 0.05976958>,
                         <-0.6599872, 0.9222114, 0.9415704>, <-6.66102e-010, -0.00806872, 0.05783345> }
        smooth_triangle {<-0.6599872, 0.9222114, 0.9415704>, <-6.93527e-010, -0.008400932, 0.06021461>,
                         <-0.84625, 0.8118369, 0.9261714>, <-7.11924e-010, -0.00862378, 0.0618119>,
                         <-0.8469602, 0.4497867, 0.8756594>, <-7.17242e-010, -0.008688198, 0.06227363> }
        smooth_triangle {<-0.6595661, 0.617407, 0.8990452>, <-6.88401e-010, -0.008338843, 0.05976958>,
                         <-0.4231059, 0.6922493, 0.9094869>, <-7.06139e-010, -0.008553712, 0.06130968>,
                         <-0.4306516, 0.9535418, 0.9459415>, <-7.03823e-010, -0.008525651, 0.06110855> }
        smooth_triangle {<-0.4306516, 0.9535418, 0.9459415>, <-7.29182e-010, -0.008832837, 0.06331034>,
                         <-0.6599872, 0.9222114, 0.9415704>, <-7.00891e-010, -0.008490139, 0.06085401>,
                         <-0.6595661, 0.617407, 0.8990452>, <-7.27354e-010, -0.008810693, 0.06315162> }
        smooth_triangle {<-0.4231059, 0.6922493, 0.9094869>, <-7.06139e-010, -0.008553712, 0.06130968>,
                         <-0.1705584, 0.6968662, 0.9101311>, <-6.94151e-010, -0.008408494, 0.06026882>,
                         <-0.1748863, 0.9354327, 0.943415>, <-7.04515e-010, -0.008534044, 0.06116871> }
        smooth_triangle {<-0.1748863, 0.9354327, 0.943415>, <-7.20422e-010, -0.008726723, 0.06254976>,
                         <-0.4306516, 0.9535418, 0.9459415>, <-7.19902e-010, -0.008720429, 0.06250464>,
                         <-0.4231059, 0.6922493, 0.9094869>, <-7.26806e-010, -0.008804061, 0.06310409> }
        smooth_triangle {<-0.1705584, 0.6968662, 0.9101311>, <-6.94151e-010, -0.008408494, 0.06026882>,
                         <0.08206846, 0.6968662, 0.9101311>, <-7.27289e-010, -0.008809902, 0.06314595>,
                         <0.08639637, 0.9354327, 0.943415>, <-7.26738e-010, -0.008803235, 0.06309816> }
        smooth_triangle {<0.08639637, 0.9354327, 0.943415>, <-7.24536e-010, -0.008776556, 0.06290694>,
                         <-0.1748863, 0.9354327, 0.943415>, <-7.07869e-010, -0.008574663, 0.06145985>,
                         <-0.1705584, 0.6968662, 0.9101311>, <-7.02077e-010, -0.008504503, 0.06095697> }
        smooth_triangle {<0.08206846, 0.6968662, 0.9101311>, <-7.27289e-010, -0.008809902, 0.06314595>,
                         <0.334616, 0.6922493, 0.9094869>, <-7.95457e-010, -0.009635654, 0.06906462>,
                         <0.3421616, 0.9535418, 0.9459415>, <-7.77373e-010, -0.009416596, 0.0674945> }
        smooth_triangle {<0.3421616, 0.9535418, 0.9459415>, <-7.58496e-010, -0.009187933, 0.06585553>,
                         <0.08639637, 0.9354327, 0.943415>, <-7.2052e-010, -0.008727912, 0.06255828>,
                         <0.08206846, 0.6968662, 0.9101311>, <-7.18814e-010, -0.00870725, 0.06241018> }
        smooth_triangle {<0.334616, 0.6922493, 0.9094869>, <-7.95457e-010, -0.009635654, 0.06906462>,
                         <0.5710761, 0.617407, 0.8990452>, <-8.05267e-010, -0.009754482, 0.06991634>,
                         <0.5714972, 0.9222114, 0.9415704>, <-8.00223e-010, -0.009693388, 0.06947844> }
        smooth_triangle {<0.5714972, 0.9222114, 0.9415704>, <-7.73392e-010, -0.009368372, 0.06714885>,
                         <0.3421616, 0.9535418, 0.9459415>, <-7.56255e-010, -0.009160778, 0.06566089>,
                         <0.334616, 0.6922493, 0.9094869>, <-7.61271e-010, -0.009221544, 0.06609644> }
        smooth_triangle {<0.5710761, 0.617407, 0.8990452>, <-8.05267e-010, -0.009754482, 0.06991634>,
                         <0.7584703, 0.4497867, 0.8756594>, <-7.80052e-010, -0.009449039, 0.06772704>,
                         <0.7577601, 0.8118369, 0.9261714>, <-7.735e-010, -0.009369677, 0.06715821> }
        smooth_triangle {<0.7577601, 0.8118369, 0.9261714>, <-7.33811e-010, -0.008888904, 0.06371221>,
                         <0.5714972, 0.9222114, 0.9415704>, <-7.63775e-010, -0.009251881, 0.06631388>,
                         <0.5710761, 0.617407, 0.8990452>, <-7.54989e-010, -0.009145441, 0.06555096> }
    }
    union { // Poly_Mesh
        smooth_triangle {<0.5333099, 3.0256, 2.1682>, <-0.03086542, 0.01691518, 0.01485776>,
                         <0.4167461, 2.7925, 2.19143>, <-0.03245445, 0.01830833, 0.01598533>,
                         <0.4004369, 2.63242, 2.33979>, <-0.03086542, 0.01691518, 0.01485776> }
        smooth_triangle {<0.4004369, 2.63242, 2.33979>, <-0.02903875, 0.01573815, 0.01357527>,
                         <0.5104771, 2.86552, 2.30727>, <-0.02721207, 0.01456112, 0.01229279>,
                         <0.5333099, 3.0256, 2.1682>, <-0.02903875, 0.01573815, 0.01357527> }
        smooth_triangle {<0.4167461, 2.7925, 2.19143>, <-0.03245445, 0.01830833, 0.01598533>,
                         <0.293069, 2.56276, 2.21432>, <-0.03031041, 0.02501833, 0.02300568>,
                         <0.2832835, 2.40268, 2.37184>, <-0.03252461, 0.01925798, 0.01754998> }
        smooth_triangle {<0.2832835, 2.40268, 2.37184>, <-0.03073964, 0.01805837, 0.01627844>,
                         <0.4004369, 2.63242, 2.33979>, <-0.02991005, 0.01688697, 0.01493234>,
                         <0.4167461, 2.7925, 2.19143>, <-0.0315795, 0.01794593, 0.01574073> }
        smooth_triangle {<0.293069, 2.56276, 2.21432>, <-0.03031041, 0.02501833, 0.02300568>,
                         <0.08090825, 2.40829, 2.22971>, <-0.01589908, 0.03757454, 0.03557572>,
                         <0.07764641, 2.24821, 2.39339>, <-0.02281888, 0.03467638, 0.03345866> }
        smooth_triangle {<0.07764641, 2.24821, 2.39339>, <-0.02185051, 0.03342907, 0.03243267>,
                         <0.2832835, 2.40268, 2.37184>, <-0.02670338, 0.02571986, 0.02447832>,
                         <0.293069, 2.56276, 2.21432>, <-0.02795334, 0.02680919, 0.02510593> }
        smooth_triangle {<0.08090825, 2.40829, 2.22971>, <-0.01589908, 0.03757454, 0.03557572>,
                         <-0.1693982, 2.40829, 2.22971>, <0.007289265, 0.03927974, 0.03735032>,
                         <-0.1661364, 2.24821, 2.39339>, <-1.93122e-010, 0.0409703, 0.04006883> }
        smooth_triangle {<-0.1661364, 2.24821, 2.39339>, <-1.84177e-010, 0.0404364, 0.03954667>,
                         <0.07764641, 2.24821, 2.39339>, <-0.01140944, 0.03728944, 0.03624159>,
                         <0.08090825, 2.40829, 2.22971>, <-0.01192431, 0.03815653, 0.03643792> }
        smooth_triangle {<-0.1693982, 2.40829, 2.22971>, <0.007289265, 0.03927974, 0.03735032>,
                         <-0.381559, 2.56276, 2.21432>, <0.02540524, 0.02897607, 0.0269395>,
                         <-0.3717735, 2.40268, 2.37184>, <0.02186779, 0.03326963, 0.03245098> }
        smooth_triangle {<-0.3717735, 2.40268, 2.37184>, <0.02185051, 0.03342907, 0.03243267>,
                         <-0.1661364, 2.24821, 2.39339>, <0.01091662, 0.0372794, 0.03624159>,
                         <-0.1693982, 2.40829, 2.22971>, <0.01092526, 0.03785693, 0.03611633> }
        smooth_triangle {<-0.381559, 2.56276, 2.21432>, <0.02540524, 0.02897607, 0.0269395>,
                         <-0.505236, 2.7925, 2.19143>, <0.03086798, 0.01783788, 0.01536097>,
                         <-0.4889268, 2.63242, 2.33979>, <0.03042066, 0.017976, 0.01605122> }
        smooth_triangle {<-0.4889268, 2.63242, 2.33979>, <0.03073964, 0.01805837, 0.01627844>,
                         <-0.3717735, 2.40268, 2.37184>, <0.02646321, 0.02570518, 0.02447832>,
                         <-0.381559, 2.56276, 2.21432>, <0.02681859, 0.02626724, 0.02433105> }
        smooth_triangle {<-0.505236, 2.7925, 2.19143>, <0.03086798, 0.01783788, 0.01536097>,
                         <-0.6217999, 3.0256, 2.1682>, <0.03025344, 0.01660822, 0.01377616>,
                         <-0.598967, 2.86552, 2.30727>, <0.0286995, 0.01568055, 0.01333709> }
        smooth_triangle {<-0.598967, 2.86552, 2.30727>, <0.02903875, 0.01573815, 0.01357527>,
                         <-0.4889268, 2.63242, 2.33979>, <0.02989933, 0.01688588, 0.01493234>,
                         <-0.505236, 2.7925, 2.19143>, <0.03049548, 0.01732735, 0.01497409> }
        smooth_triangle {<0.5533254, 3.18, 2.02251>, <-0.03397331, 0.01875182, 0.01554826>,
                         <0.4310429, 2.9469, 2.03645>, <-0.03672284, 0.02068255, 0.01598263>,
                         <0.4167461, 2.7925, 2.19143>, <-0.03245445, 0.01830833, 0.01598533> }
        smooth_triangle {<0.4167461, 2.7925, 2.19143>, <-0.03193401, 0.01786044, 0.01532206>,
                         <0.5333099, 3.0256, 2.1682>, <-0.03061906, 0.01671598, 0.014095>,
                         <0.5533254, 3.18, 2.02251>, <-0.032173, 0.0176343, 0.01444025> }
        smooth_triangle {<0.4310429, 2.9469, 2.03645>, <-0.03672284, 0.02068255, 0.01598263>,
                         <0.3016471, 2.71716, 2.05018>, <-0.03419746, 0.02762072, 0.02244202>,
                         <0.293069, 2.56276, 2.21432>, <-0.03031041, 0.02501833, 0.02300568> }
        smooth_triangle {<0.293069, 2.56276, 2.21432>, <-0.03075025, 0.02347372, 0.02120716>,
                         <0.4167461, 2.7925, 2.19143>, <-0.03235827, 0.01844122, 0.0159419>,
                         <0.4310429, 2.9469, 2.03645>, <-0.03555957, 0.02022188, 0.01593988> }
        smooth_triangle {<0.3016471, 2.71716, 2.05018>, <-0.03419746, 0.02762072, 0.02244202>,
                         <0.08376761, 2.5627, 2.05942>, <-0.01805096, 0.04105842, 0.03375446>,
                         <0.08090825, 2.40829, 2.22971>, <-0.01589908, 0.03757454, 0.03557572> }
        smooth_triangle {<0.08090825, 2.40829, 2.22971>, <-0.01766845, 0.03685369, 0.03454012>,
                         <0.293069, 2.56276, 2.21432>, <-0.02847694, 0.02743653, 0.02511259>,
                         <0.3016471, 2.71716, 2.05018>, <-0.03139223, 0.02938832, 0.02468985> }
        smooth_triangle {<0.08376761, 2.5627, 2.05942>, <-0.01805096, 0.04105842, 0.03375446>,
                         <-0.1722575, 2.5627, 2.05942>, <0.007975754, 0.04303815, 0.03520135>,
                         <-0.1693982, 2.40829, 2.22971>, <0.007289265, 0.03927974, 0.03735032> }
        smooth_triangle {<-0.1693982, 2.40829, 2.22971>, <0.005466948, 0.04011616, 0.03767478>,
                         <0.08090825, 2.40829, 2.22971>, <-0.01192431, 0.03883727, 0.03634383>,
                         <0.08376761, 2.5627, 2.05942>, <-0.01353822, 0.04145017, 0.03497788> }
        smooth_triangle {<-0.1722575, 2.5627, 2.05942>, <0.007975754, 0.04303815, 0.03520135>,
                         <-0.390137, 2.71716, 2.05018>, <0.02857816, 0.03222202, 0.02567463>,
                         <-0.381559, 2.56276, 2.21432>, <0.02540524, 0.02897607, 0.0269395> }
        smooth_triangle {<-0.381559, 2.56276, 2.21432>, <0.02503584, 0.03075342, 0.0282838>,
                         <-0.1693982, 2.40829, 2.22971>, <0.01144886, 0.03848118, 0.03609191>,
                         <-0.1722575, 2.5627, 2.05942>, <0.01196373, 0.04129998, 0.03448018> }
        smooth_triangle {<-0.390137, 2.71716, 2.05018>, <0.02857816, 0.03222202, 0.02567463>,
                         <-0.5195328, 2.9469, 2.03645>, <0.0351045, 0.02027545, 0.01541833>,
                         <-0.505236, 2.7925, 2.19143>, <0.03086798, 0.01783788, 0.01536097> }
        smooth_triangle {<-0.505236, 2.7925, 2.19143>, <0.03169441, 0.01840427, 0.01580208>,
                         <-0.381559, 2.56276, 2.21432>, <0.02759736, 0.02675791, 0.02448598>,
                         <-0.390137, 2.71716, 2.05018>, <0.02997705, 0.02919238, 0.02353732> }
        smooth_triangle {<-0.5195328, 2.9469, 2.03645>, <0.0351045, 0.02027545, 0.01541833>,
                         <-0.6418154, 3.18, 2.02251>, <0.03512447, 0.01926399, 0.01391118>,
                         <-0.6217999, 3.0256, 2.1682>, <0.03025344, 0.01660822, 0.01377616> }
        smooth_triangle {<-0.6217999, 3.0256, 2.1682>, <0.03101517, 0.01698305, 0.01407253>,
                         <-0.505236, 2.7925, 2.19143>, <0.03128564, 0.01781158, 0.01518704>,
                         <-0.5195328, 2.9469, 2.03645>, <0.03446303, 0.01963976, 0.01523007> }
        smooth_triangle {<0.5650987, 3.31014, 1.855>, <-0.04060748, 0.02217521, 0.01439123>,
                         <0.4394523, 3.07704, 1.85965>, <-0.04426633, 0.02461105, 0.01057537>,
                         <0.4310429, 2.9469, 2.03645>, <-0.03672284, 0.02068255, 0.01598263> }
        smooth_triangle {<0.4310429, 2.9469, 2.03645>, <-0.03685021, 0.02059173, 0.01527932>,
                         <0.5533254, 3.18, 2.02251>, <-0.03560282, 0.01953553, 0.01435882>,
                         <0.5650987, 3.31014, 1.855>, <-0.03891991, 0.02124722, 0.0137803> }
        smooth_triangle {<0.4394523, 3.07704, 1.85965>, <-0.04426633, 0.02461105, 0.01057537>,
                         <0.3066928, 2.8473, 1.86423>, <-0.04094953, 0.03229991, 0.01532525>,
                         <0.3016471, 2.71716, 2.05018>, <-0.03419746, 0.02762072, 0.02244202> }
        smooth_triangle {<0.3016471, 2.71716, 2.05018>, <-0.03535573, 0.02640596, 0.02055837>,
                         <0.4310429, 2.9469, 2.03645>, <-0.03724977, 0.02120233, 0.01571383>,
                         <0.4394523, 3.07704, 1.85965>, <-0.04290738, 0.0241487, 0.01165838> }
        smooth_triangle {<0.3066928, 2.8473, 1.86423>, <-0.04094953, 0.03229991, 0.01532525>,
                         <0.0854495, 2.69283, 1.86731>, <-0.02160544, 0.04774222, 0.02152301>,
                         <0.08376761, 2.5627, 2.05942>, <-0.01805096, 0.04105842, 0.03375446> }
        smooth_triangle {<0.08376761, 2.5627, 2.05942>, <-0.02041876, 0.04091127, 0.03220965>,
                         <0.3016471, 2.71716, 2.05018>, <-0.03252863, 0.030833, 0.02372532>,
                         <0.3066928, 2.8473, 1.86423>, <-0.03759268, 0.03434238, 0.01838774> }
        smooth_triangle {<0.0854495, 2.69283, 1.86731>, <-0.02160544, 0.04774222, 0.02152301>,
                         <-0.1739394, 2.69283, 1.86731>, <0.00944115, 0.05020769, 0.02148516>,
                         <-0.1722575, 2.5627, 2.05942>, <0.007975754, 0.04303815, 0.03520135> }
        smooth_triangle {<-0.1722575, 2.5627, 2.05942>, <0.005981816, 0.04457519, 0.03473072>,
                         <0.08376761, 2.5627, 2.05942>, <-0.01353822, 0.0430904, 0.03364555>,
                         <0.0854495, 2.69283, 1.86731>, <-0.01620408, 0.04810325, 0.02447197> }
        smooth_triangle {<-0.1739394, 2.69283, 1.86731>, <0.00944115, 0.05020769, 0.02148516>,
                         <-0.3951827, 2.8473, 1.86423>, <0.03431216, 0.03803072, 0.01520518>,
                         <-0.390137, 2.71716, 2.05018>, <0.02857816, 0.03222202, 0.02567463> }
        smooth_triangle {<-0.390137, 2.71716, 2.05018>, <0.02855193, 0.03462713, 0.02627967>,
                         <-0.1722575, 2.5627, 2.05942>, <0.01310012, 0.04273922, 0.03342472>,
                         <-0.1739394, 2.69283, 1.86731>, <0.01419917, 0.04811638, 0.02313757> }
        smooth_triangle {<-0.3951827, 2.8473, 1.86423>, <0.03431216, 0.03803072, 0.01520518>,
                         <-0.5279423, 3.07704, 1.85965>, <0.04260257, 0.02431504, 0.01008135>,
                         <-0.5195328, 2.9469, 2.03645>, <0.0351045, 0.02027545, 0.01541833> }
        smooth_triangle {<-0.5195328, 2.9469, 2.03645>, <0.036562, 0.0212048, 0.01548381>,
                         <-0.390137, 2.71716, 2.05018>, <0.03166725, 0.03016473, 0.02317603>,
                         <-0.3951827, 2.8473, 1.86423>, <0.03596775, 0.03452126, 0.01532394> }
        smooth_triangle {<-0.5279423, 3.07704, 1.85965>, <0.04260257, 0.02431504, 0.01008135>,
                         <-0.6535886, 3.31014, 1.855>, <0.04317042, 0.02340865, 0.007395021>,
                         <-0.6418154, 3.18, 2.02251>, <0.03512447, 0.01926399, 0.01391118> }
        smooth_triangle {<-0.6418154, 3.18, 2.02251>, <0.03654907, 0.02001011, 0.01392528>,
                         <-0.5195328, 2.9469, 2.03645>, <0.03617794, 0.02058218, 0.01505212>,
                         <-0.5279423, 3.07704, 1.85965>, <0.04180149, 0.02361187, 0.01104938> }
        smooth_triangle {<0.5656088, 3.32049, 1.64972>, <-0.0500652, 0.02699336, 0.001216881>,
                         <0.4398167, 3.08739, 1.64507>, <-0.04724055, 0.02623272, -0.003665069>,
                         <0.4394523, 3.07704, 1.85965>, <-0.04426633, 0.02461105, 0.01057537> }
        smooth_triangle {<0.4394523, 3.07704, 1.85965>, <-0.04515052, 0.02490592, 0.008226874>,
                         <0.5650987, 3.31014, 1.855>, <-0.0442053, 0.02398287, 0.007786316>,
                         <0.5656088, 3.32049, 1.64972>, <-0.04893416, 0.02639195, 0.00119914> }
        smooth_triangle {<0.4398167, 3.08739, 1.64507>, <-0.04724055, 0.02623272, -0.003665069>,
                         <0.3069114, 2.85765, 1.6405>, <-0.0429076, 0.03503772, -0.003855805>,
                         <0.3066928, 2.8473, 1.86423>, <-0.04094953, 0.03229991, 0.01532525> }
        smooth_triangle {<0.3066928, 2.8473, 1.86423>, <-0.0430244, 0.03134619, 0.01181649>,
                         <0.4394523, 3.07704, 1.85965>, <-0.045512, 0.02557954, 0.008254077>,
                         <0.4398167, 3.08739, 1.64507>, <-0.04774267, 0.0267958, -0.002426249> }
        smooth_triangle {<0.3069114, 2.85765, 1.6405>, <-0.0429076, 0.03503772, -0.003855805>,
                         <0.08552238, 2.70318, 1.63742>, <-0.02151735, 0.05105696, -0.007373986>,
                         <0.0854495, 2.69283, 1.86731>, <-0.02160544, 0.04774222, 0.02152301> }
        smooth_triangle {<0.0854495, 2.69283, 1.86731>, <-0.02483582, 0.04818127, 0.01670623>,
                         <0.3066928, 2.8473, 1.86423>, <-0.03934389, 0.03659953, 0.0120579>,
                         <0.3069114, 2.85765, 1.6405>, <-0.04081244, 0.03865289, -0.002327887> }
        smooth_triangle {<0.08552238, 2.70318, 1.63742>, <-0.02151735, 0.05105696, -0.007373986>,
                         <-0.1740123, 2.70318, 1.63742>, <0.01153023, 0.05309079, -0.009054087>,
                         <-0.1739394, 2.69283, 1.86731>, <0.00944115, 0.05020769, 0.02148516> }
        smooth_triangle {<-0.1739394, 2.69283, 1.86731>, <0.007080863, 0.05256342, 0.01678497>,
                         <0.0854495, 2.69283, 1.86731>, <-0.01620408, 0.05071432, 0.01681336>,
                         <0.08552238, 2.70318, 1.63742>, <-0.01613802, 0.05320037, -0.004859389> }
        smooth_triangle {<-0.1740123, 2.70318, 1.63742>, <0.01153023, 0.05309079, -0.009054087>,
                         <-0.3954013, 2.85765, 1.6405>, <0.03733123, 0.03976364, -0.007685239>,
                         <-0.3951827, 2.8473, 1.86423>, <0.03431216, 0.03803072, 0.01520518> }
        smooth_triangle {<-0.3951827, 2.8473, 1.86423>, <0.03460363, 0.04123832, 0.01197348>,
                         <-0.1739394, 2.69283, 1.86731>, <0.01595037, 0.05037105, 0.01668346>,
                         <-0.1740123, 2.70318, 1.63742>, <0.01751718, 0.05253337, -0.006220971> }
        smooth_triangle {<-0.3954013, 2.85765, 1.6405>, <0.03733123, 0.03976364, -0.007685239>,
                         <-0.5283066, 3.08739, 1.64507>, <0.04562413, 0.02586512, -0.003993193>,
                         <-0.5279423, 3.07704, 1.85965>, <0.04260257, 0.02431504, 0.01008135> }
        smooth_triangle {<-0.5279423, 3.07704, 1.85965>, <0.04479017, 0.02566165, 0.007891933>,
                         <-0.3951827, 2.8473, 1.86423>, <0.03857236, 0.03594842, 0.01173481>,
                         <-0.3954013, 2.85765, 1.6405>, <0.04083666, 0.0372481, -0.005433005> }
        smooth_triangle {<-0.5283066, 3.08739, 1.64507>, <0.04562413, 0.02586512, -0.003993193>,
                         <-0.6540987, 3.32049, 1.64972>, <0.04297104, 0.02330526, -0.005812793>,
                         <-0.6535886, 3.31014, 1.855>, <0.04317042, 0.02340865, 0.007395021> }
        smooth_triangle {<-0.6535886, 3.31014, 1.855>, <0.04543663, 0.024592, 0.005335139>,
                         <-0.5279423, 3.07704, 1.85965>, <0.04444419, 0.02497595, 0.007864853>,
                         <-0.5283066, 3.08739, 1.64507>, <0.04671036, 0.02613851, -0.002691052> }
        smooth_triangle {<0.5546659, 3.19528, 1.47903>, <-0.04020871, 0.02196869, -0.01353729>,
                         <0.4320004, 2.96218, 1.46509>, <-0.03757282, 0.02113563, -0.01468902>,
                         <0.4398167, 3.08739, 1.64507>, <-0.04724055, 0.02623272, -0.003665069> }
        smooth_triangle {<0.4398167, 3.08739, 1.64507>, <-0.04523197, 0.02502971, -0.006048795>,
                         <0.5656088, 3.32049, 1.64972>, <-0.04463572, 0.02420702, -0.005991547>,
                         <0.5546659, 3.19528, 1.47903>, <-0.03970748, 0.02169468, -0.01336863> }
        smooth_triangle {<0.4320004, 2.96218, 1.46509>, <-0.03757282, 0.02113563, -0.01468902>,
                         <0.3022216, 2.73244, 1.45136>, <-0.0343935, 0.02879211, -0.0200493>,
                         <0.3069114, 2.85765, 1.6405>, <-0.0429076, 0.03503772, -0.003855805> }
        smooth_triangle {<0.3069114, 2.85765, 1.6405>, <-0.0423747, 0.03224949, -0.006603276>,
                         <0.4398167, 3.08739, 1.64507>, <-0.04562442, 0.02564574, -0.006460224>,
                         <0.4320004, 2.96218, 1.46509>, <-0.03837362, 0.02182293, -0.01472818> }
        smooth_triangle {<0.3022216, 2.73244, 1.45136>, <-0.0343935, 0.02879211, -0.0200493>,
                         <0.08395911, 2.57797, 1.44212>, <-0.01725674, 0.04244735, -0.03094801>,
                         <0.08552238, 2.70318, 1.63742>, <-0.02151735, 0.05105696, -0.007373986> }
        smooth_triangle {<0.08552238, 2.70318, 1.63742>, <-0.02334556, 0.0487575, -0.01227956>,
                         <0.3069114, 2.85765, 1.6405>, <-0.03938824, 0.03674307, -0.009640927>,
                         <0.3022216, 2.73244, 1.45136>, <-0.03300267, 0.03205887, -0.02178605> }
        smooth_triangle {<0.08395911, 2.57797, 1.44212>, <-0.01725674, 0.04244735, -0.03094801>,
                         <-0.172449, 2.57797, 1.44212>, <0.009353068, 0.04408166, -0.03297828>,
                         <-0.1740123, 2.70318, 1.63742>, <0.01153023, 0.05309079, -0.009054087> }
        smooth_triangle {<-0.1740123, 2.70318, 1.63742>, <0.008647671, 0.05248971, -0.01491482>,
                         <0.08552238, 2.70318, 1.63742>, <-0.01613802, 0.05096434, -0.01365475>,
                         <0.08395911, 2.57797, 1.44212>, <-0.01294256, 0.04450713, -0.03133526> }
        smooth_triangle {<-0.172449, 2.57797, 1.44212>, <0.009353068, 0.04408166, -0.03297828>,
                         <-0.3907115, 2.73244, 1.45136>, <0.02983246, 0.03258205, -0.02460303>,
                         <-0.3954013, 2.85765, 1.6405>, <0.03733123, 0.03976364, -0.007685239> }
        smooth_triangle {<-0.3954013, 2.85765, 1.6405>, <0.03544373, 0.04063071, -0.01263374>,
                         <-0.1740123, 2.70318, 1.63742>, <0.01609299, 0.05062607, -0.01366037>,
                         <-0.172449, 2.57797, 1.44212>, <0.01446012, 0.04386922, -0.03160352> }
        smooth_triangle {<-0.3907115, 2.73244, 1.45136>, <0.02983246, 0.03258205, -0.02460303>,
                         <-0.5204903, 2.96218, 1.46509>, <0.03600171, 0.02068331, -0.01460359>,
                         <-0.5283066, 3.08739, 1.64507>, <0.04562413, 0.02586512, -0.003993193> }
        smooth_triangle {<-0.5283066, 3.08739, 1.64507>, <0.04493809, 0.0256779, -0.006885891>,
                         <-0.3954013, 2.85765, 1.6405>, <0.03871841, 0.0361018, -0.009654925>,
                         <-0.3907115, 2.73244, 1.45136>, <0.03309434, 0.0307156, -0.02234327> }
        smooth_triangle {<-0.5204903, 2.96218, 1.46509>, <0.03600171, 0.02068331, -0.01460359>,
                         <-0.6431559, 3.19528, 1.47903>, <0.03332667, 0.01826026, -0.01340329>,
                         <-0.6540987, 3.32049, 1.64972>, <0.04297104, 0.02330526, -0.005812793> }
        smooth_triangle {<-0.6540987, 3.32049, 1.64972>, <0.04243808, 0.02307152, -0.008518119>,
                         <-0.5283066, 3.08739, 1.64507>, <0.04456114, 0.02504985, -0.006477088>,
                         <-0.5204903, 2.96218, 1.46509>, <0.03734432, 0.02116349, -0.01443489> }
        smooth_triangle {<0.5342581, 3.03475, 1.34029>, <-0.03077646, 0.01695624, -0.01535725>,
                         <0.4174234, 2.80165, 1.31706>, <-0.02987303, 0.01691667, -0.01596917>,
                         <0.4320004, 2.96218, 1.46509>, <-0.03757282, 0.02113563, -0.01468902> }
        smooth_triangle {<0.4320004, 2.96218, 1.46509>, <-0.03570514, 0.02003517, -0.01475029>,
                         <0.5546659, 3.19528, 1.47903>, <-0.03515542, 0.01935123, -0.01423569>,
                         <0.5342581, 3.03475, 1.34029>, <-0.03043929, 0.016845, -0.01514568> }
        smooth_triangle {<0.4174234, 2.80165, 1.31706>, <-0.02987303, 0.01691667, -0.01596917>,
                         <0.2934754, 2.57191, 1.29417>, <-0.02777534, 0.02357353, -0.02300761>,
                         <0.3022216, 2.73244, 1.45136>, <-0.0343935, 0.02879211, -0.0200493> }
        smooth_triangle {<0.3022216, 2.73244, 1.45136>, <-0.0337459, 0.02634676, -0.019408>,
                         <0.4320004, 2.96218, 1.46509>, <-0.03613038, 0.0206044, -0.01538778>,
                         <0.4174234, 2.80165, 1.31706>, <-0.03035554, 0.01744018, -0.0163479> }
        smooth_triangle {<0.2934754, 2.57191, 1.29417>, <-0.02777534, 0.02357353, -0.02300761>,
                         <0.08104371, 2.41744, 1.27878>, <-0.01420785, 0.03560357, -0.03605017>,
                         <0.08395911, 2.57797, 1.44212>, <-0.01725674, 0.04244735, -0.03094801> }
        smooth_triangle {<0.08395911, 2.57797, 1.44212>, <-0.01864187, 0.04039228, -0.03163253>,
                         <0.3022216, 2.73244, 1.45136>, <-0.03149444, 0.03015086, -0.0234585>,
                         <0.2934754, 2.57191, 1.29417>, <-0.02653082, 0.02623692, -0.02567723> }
        smooth_triangle {<0.08104371, 2.41744, 1.27878>, <-0.01420785, 0.03560357, -0.03605017>,
                         <-0.1695336, 2.41744, 1.27878>, <0.007269616, 0.03709739, -0.03807668>,
                         <-0.172449, 2.57797, 1.44212>, <0.009353068, 0.04408166, -0.03297828> }
        smooth_triangle {<-0.172449, 2.57797, 1.44212>, <0.007014801, 0.0435319, -0.03502383>,
                         <0.08395911, 2.57797, 1.44212>, <-0.01294256, 0.04230617, -0.03350113>,
                         <0.08104371, 2.41744, 1.27878>, <-0.01065589, 0.03717333, -0.03732775> }
        smooth_triangle {<-0.1695336, 2.41744, 1.27878>, <0.007269616, 0.03709739, -0.03807668>,
                         <-0.3819653, 2.57191, 1.29417>, <0.02368479, 0.02702808, -0.02750797>,
                         <-0.3907115, 2.73244, 1.45136>, <0.02983246, 0.03258205, -0.02460303> }
        smooth_triangle {<-0.3907115, 2.73244, 1.45136>, <0.02831143, 0.03334275, -0.02709896>,
                         <-0.172449, 2.57797, 1.44212>, <0.01295189, 0.04196746, -0.03338039>,
                         <-0.1695336, 2.41744, 1.27878>, <0.0113893, 0.03672925, -0.03720419> }
        smooth_triangle {<-0.3819653, 2.57191, 1.29417>, <0.02368479, 0.02702808, -0.02750797>,
                         <-0.5059133, 2.80165, 1.31706>, <0.02832291, 0.01641402, -0.01548987>,
                         <-0.5204903, 2.96218, 1.46509>, <0.03600171, 0.02068331, -0.01460359> }
        smooth_triangle {<-0.5204903, 2.96218, 1.46509>, <0.03547804, 0.02058231, -0.01565861>,
                         <-0.3907115, 2.73244, 1.45136>, <0.0308511, 0.02950636, -0.02315819>,
                         <-0.3819653, 2.57191, 1.29417>, <0.02624035, 0.02534088, -0.0253369> }
        smooth_triangle {<-0.5059133, 2.80165, 1.31706>, <0.02832291, 0.01641402, -0.01548987>,
                         <-0.622748, 3.03475, 1.34029>, <0.02642516, 0.01450142, -0.01353844>,
                         <-0.6431559, 3.19528, 1.47903>, <0.03332667, 0.01826026, -0.01340329> }
        smooth_triangle {<-0.6431559, 3.19528, 1.47903>, <0.03297379, 0.01815845, -0.01436661>,
                         <-0.5204903, 2.96218, 1.46509>, <0.03506829, 0.02000118, -0.01502601>,
                         <-0.5059133, 2.80165, 1.31706>, <0.0293092, 0.01679922, -0.01569072> }
        smooth_triangle {<0.5104771, 2.86552, 1.21269>, <-0.0264057, 0.01451108, -0.01466261>,
                         <0.4004369, 2.63242, 1.18017>, <-0.02726743, 0.01564726, -0.01607352>,
                         <0.4174234, 2.80165, 1.31706>, <-0.02987303, 0.01691667, -0.01596917> }
        smooth_triangle {<0.4174234, 2.80165, 1.31706>, <-0.02885783, 0.0162764, -0.01553404>,
                         <0.5342581, 3.03475, 1.34029>, <-0.02829435, 0.01565592, -0.01479295>,
                         <0.5104771, 2.86552, 1.21269>, <-0.02610896, 0.01443334, -0.01444563> }
        smooth_triangle {<0.4004369, 2.63242, 1.18017>, <-0.02726743, 0.01564726, -0.01607352>,
                         <0.2832835, 2.40268, 1.14812>, <-0.02399638, 0.02400473, -0.02587986>,
                         <0.2934754, 2.57191, 1.29417>, <-0.02777534, 0.02357353, -0.02300761> }
        smooth_triangle {<0.2934754, 2.57191, 1.29417>, <-0.02772526, 0.02182476, -0.02152403>,
                         <0.4174234, 2.80165, 1.31706>, <-0.02929852, 0.01683212, -0.0162452>,
                         <0.4004369, 2.63242, 1.18017>, <-0.02736995, 0.01595766, -0.01640677> }
        smooth_triangle {<0.2832835, 2.40268, 1.14812>, <-0.02399638, 0.02400473, -0.02587986>,
                         <0.07764642, 2.24821, 1.12657>, <-0.009931807, 0.03416563, -0.03776538>,
                         <0.08104371, 2.41744, 1.27878>, <-0.01420785, 0.03560357, -0.03605017> }
        smooth_triangle {<0.08104371, 2.41744, 1.27878>, <-0.01564452, 0.03441981, -0.03563153>,
                         <0.2934754, 2.57191, 1.29417>, <-0.02582014, 0.02539728, -0.02584961>,
                         <0.2832835, 2.40268, 1.14812>, <-0.0226491, 0.02629266, -0.02871178> }
        smooth_triangle {<0.07764642, 2.24821, 1.12657>, <-0.009931807, 0.03416563, -0.03776538>,
                         <-0.1661363, 2.24821, 1.12657>, <0.009456263, 0.03345933, -0.03724062>,
                         <-0.1695336, 2.41744, 1.27878>, <0.007269616, 0.03709739, -0.03807668> }
        smooth_triangle {<-0.1695336, 2.41744, 1.27878>, <0.005452212, 0.03735789, -0.03915884>,
                         <0.08104371, 2.41744, 1.27878>, <-0.01065589, 0.03623753, -0.03763896>,
                         <0.07764642, 2.24821, 1.12657>, <-0.006621204, 0.03549023, -0.03931203> }
        smooth_triangle {<-0.1661363, 2.24821, 1.12657>, <0.009456263, 0.03345933, -0.03724062>,
                         <-0.3717734, 2.40268, 1.14812>, <0.02246887, 0.0226531, -0.0245746>,
                         <-0.3819653, 2.57191, 1.29417>, <0.02368479, 0.02702808, -0.02750797> }
        smooth_triangle {<-0.3819653, 2.57191, 1.29417>, <0.02298999, 0.02834134, -0.02948727>,
                         <-0.1695336, 2.41744, 1.27878>, <0.01067862, 0.03589332, -0.03741379>,
                         <-0.1661363, 2.24821, 1.12657>, <0.01327271, 0.03306659, -0.03663546> }
        smooth_triangle {<-0.3717734, 2.40268, 1.14812>, <0.02246887, 0.0226531, -0.0245746>,
                         <-0.4889268, 2.63242, 1.18017>, <0.02513249, 0.01438021, -0.01450111>,
                         <-0.5059133, 2.80165, 1.31706>, <0.02832291, 0.01641402, -0.01548987> }
        smooth_triangle {<-0.5059133, 2.80165, 1.31706>, <0.02866192, 0.01677779, -0.01627597>,
                         <-0.3819653, 2.57191, 1.29417>, <0.02518333, 0.02473834, -0.02528955>,
                         <-0.3717734, 2.40268, 1.14812>, <0.02487223, 0.02105844, -0.02259449> }
        smooth_triangle {<-0.4889268, 2.63242, 1.18017>, <0.02513249, 0.01438021, -0.01450111>,
                         <-0.598967, 2.86552, 1.21269>, <0.02423978, 0.01326764, -0.01307879>,
                         <-0.622748, 3.03475, 1.34029>, <0.02642516, 0.01450142, -0.01353844> }
        smooth_triangle {<-0.622748, 3.03475, 1.34029>, <0.02694282, 0.01486729, -0.01429645>,
                         <-0.5059133, 2.80165, 1.31706>, <0.02823672, 0.01621027, -0.01557052>,
                         <-0.4889268, 2.63242, 1.18017>, <0.02608105, 0.01478649, -0.01493823> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.84625, 0.8118369, 0.9261714>, <0.09452847, 0.0004560562, 0.001824873>,
                         <-0.8499704, 0.6971982, 1.14754>, <0.09534384, 0.0001849476, 0.002162096>,
                         <-0.8473372, 0.2878365, 1.11344>, <0.09452847, 0.0004560562, 0.001824873> }
        smooth_triangle {<-0.8473372, 0.2878365, 1.11344>, <0.09439945, 0.0001340652, 0.0009231735>,
                         <-0.8469602, 0.4497867, 0.8756594>, <0.09427044, -0.0001879258, 2.14743e-005>,
                         <-0.84625, 0.8118369, 0.9261714>, <0.09439945, 0.0001340652, 0.0009231735> }
        smooth_triangle {<-0.8499704, 0.6971982, 1.14754>, <0.09534384, 0.0001849476, 0.002162096>,
                         <-0.8531632, 0.5881453, 1.37494>, <0.1079762, 0.0008450947, 0.0020531>,
                         <-0.8476608, 0.1338536, 1.35641>, <0.1053278, 0.00119209, 0.002050508> }
        smooth_triangle {<-0.8476608, 0.1338536, 1.35641>, <0.1050199, 0.00091042, 0.001294226>,
                         <-0.8473372, 0.2878365, 1.11344>, <0.09962025, 0.0005424029, 0.001181409>,
                         <-0.8499704, 0.6971982, 1.14754>, <0.09768589, 0.0002958981, 0.001756058> }
        smooth_triangle {<-0.8531632, 0.5881453, 1.37494>, <0.1079762, 0.0008450947, 0.0020531>,
                         <-0.8548656, 0.5022423, 1.62166>, <0.1225657, 0.00121971, 0.000994417>,
                         <-0.8478232, 0.01276458, 1.61659>, <0.1211969, 0.001728842, 0.001438254> }
        smooth_triangle {<-0.8478232, 0.01276458, 1.61659>, <0.1208177, 0.001578702, 0.001089135>,
                         <-0.8476608, 0.1338536, 1.35641>, <0.1128831, 0.001310326, 0.001395262>,
                         <-0.8531632, 0.5881453, 1.37494>, <0.1110917, 0.0009909617, 0.001724829> }
        smooth_triangle {<-0.8548656, 0.5022423, 1.62166>, <0.1225657, 0.00121971, 0.000994417>,
                         <-0.8547898, 0.5047527, 1.89267>, <0.1234942, 0.00106525, -0.0004754046>,
                         <-0.8478197, 0.01741817, 1.89934>, <0.1320913, 0.001888482, -5.44566e-005> }
        smooth_triangle {<-0.8478197, 0.01741817, 1.89934>, <0.1352356, 0.001939903, -4.44616e-005>,
                         <-0.8478232, 0.01276458, 1.61659>, <0.1297884, 0.001860083, 0.0007018935>,
                         <-0.8548656, 0.5022423, 1.62166>, <0.1265192, 0.001412614, 0.0007371961> }
        smooth_triangle {<-0.8547898, 0.5047527, 1.89267>, <0.1234942, 0.00106525, -0.0004754046>,
                         <-0.8529572, 0.593843, 2.13724>, <0.1049028, 0.0004382995, -0.00144608>,
                         <-0.8476439, 0.1430467, 2.15755>, <0.1120619, 0.001262282, -0.001299475> }
        smooth_triangle {<-0.8476439, 0.1430467, 2.15755>, <0.1193664, 0.001530412, -0.00113039>,
                         <-0.8478197, 0.01741817, 1.89934>, <0.1293811, 0.001843512, -0.0005078809>,
                         <-0.8547898, 0.5047527, 1.89267>, <0.1242884, 0.001248573, -0.0005968797> }
        smooth_triangle {<-0.8529572, 0.593843, 2.13724>, <0.1049028, 0.0004382995, -0.00144608>,
                         <-0.8498234, 0.700974, 2.36741>, <0.09164679, -0.0003365355, -0.00163578>,
                         <-0.8473238, 0.2937667, 2.40259>, <0.09749407, 0.0004651202, -0.001543888> }
        smooth_triangle {<-0.8473238, 0.2937667, 2.40259>, <0.1055079, 0.0008802841, -0.001244516>,
                         <-0.8476439, 0.1430467, 2.15755>, <0.1127918, 0.001278865, -0.00112231>,
                         <-0.8529572, 0.593843, 2.13724>, <0.1070575, 0.0006525866, -0.001320846> }
        smooth_triangle {<-0.8498234, 0.700974, 2.36741>, <0.09164679, -0.0003365355, -0.00163578>,
                         <-0.84625, 0.8118369, 2.59379>, <0.08363308, -0.001133648, -0.001588627>,
                         <-0.8469602, 0.4497867, 2.6443>, <0.08756082, -0.0003412838, -0.001215025> }
        smooth_triangle {<-0.8469602, 0.4497867, 2.6443>, <0.09573912, 0.0001250741, -0.0008765287>,
                         <-0.8473238, 0.2937667, 2.40259>, <0.1007057, 0.0005282761, -0.00104096>,
                         <-0.8498234, 0.700974, 2.36741>, <0.09471445, -0.0001045436, -0.001361343> }
        smooth_triangle {<-0.838747, 1.17379, 0.9766691>, <0.08617524, -0.001093304, 0.002610907>,
                         <-0.8458109, 1.10646, 1.18163>, <0.08676091, -0.004357762, 0.002760121>,
                         <-0.8499704, 0.6971982, 1.14754>, <0.09534384, 0.0001849476, 0.002162096> }
        smooth_triangle {<-0.8499704, 0.6971982, 1.14754>, <0.09298612, -0.0003234892, 0.00174319>,
                         <-0.84625, 0.8118369, 0.9261714>, <0.0902207, -0.0006963717, 0.001155673>,
                         <-0.838747, 1.17379, 0.9766691>, <0.08604409, -0.001471052, 0.001548691> }
        smooth_triangle {<-0.8458109, 1.10646, 1.18163>, <0.08676091, -0.004357762, 0.002760121>,
                         <-0.8518728, 1.04234, 1.39347>, <0.1000469, -0.003883005, 0.002393263>,
                         <-0.8531632, 0.5881453, 1.37494>, <0.1079762, 0.0008450947, 0.0020531> }
        smooth_triangle {<-0.8531632, 0.5881453, 1.37494>, <0.1051781, 0.0003701405, 0.001753092>,
                         <-0.8499704, 0.6971982, 1.14754>, <0.09570384, -0.0001249699, 0.001834839>,
                         <-0.8458109, 1.10646, 1.18163>, <0.08926664, -0.003532002, 0.002283358> }
        smooth_triangle {<-0.8518728, 1.04234, 1.39347>, <0.1000469, -0.003883005, 0.002393263>,
                         <-0.8551153, 0.9916181, 1.62673>, <0.1156899, -0.004024999, 0.0009932295>,
                         <-0.8548656, 0.5022423, 1.62166>, <0.1225657, 0.00121971, 0.000994417> }
        smooth_triangle {<-0.8548656, 0.5022423, 1.62166>, <0.1203359, 0.0008273094, 0.0009114036>,
                         <-0.8531632, 0.5881453, 1.37494>, <0.1093938, 0.0005463478, 0.001705416>,
                         <-0.8518728, 1.04234, 1.39347>, <0.1034468, -0.002999727, 0.001960538> }
        smooth_triangle {<-0.8551153, 0.9916181, 1.62673>, <0.1156899, -0.004024999, 0.0009932295>,
                         <-0.8549671, 0.9919852, 1.886>, <0.116861, -0.004684857, -0.0005904294>,
                         <-0.8547898, 0.5047527, 1.89267>, <0.1234942, 0.00106525, -0.0004754046> }
        smooth_triangle {<-0.8547898, 0.5047527, 1.89267>, <0.1257744, 0.0008159507, -0.0003659886>,
                         <-0.8548656, 0.5022423, 1.62166>, <0.125078, 0.0009317962, 0.0007363775>,
                         <-0.8551153, 0.9916181, 1.62673>, <0.1199212, -0.003001735, 0.000735487> }
        smooth_triangle {<-0.8549671, 0.9919852, 1.886>, <0.116861, -0.004684857, -0.0005904294>,
                         <-0.8514777, 1.04454, 2.11695>, <0.09733133, -0.004675184, -0.00167266>,
                         <-0.8529572, 0.593843, 2.13724>, <0.1049028, 0.0004382995, -0.00144608> }
        smooth_triangle {<-0.8529572, 0.593843, 2.13724>, <0.1086167, 0.0003365102, -0.001311731>,
                         <-0.8547898, 0.5047527, 1.89267>, <0.1225603, 0.0008067228, -0.0005837237>,
                         <-0.8549671, 0.9919852, 1.886>, <0.1175854, -0.003505857, -0.0006699923> }
        smooth_triangle {<-0.8514777, 1.04454, 2.11695>, <0.09733133, -0.004675184, -0.00167266>,
                         <-0.8455303, 1.10808, 2.33225>, <0.08355729, -0.00511451, -0.00214293>,
                         <-0.8498234, 0.700974, 2.36741>, <0.09164679, -0.0003365355, -0.00163578> }
        smooth_triangle {<-0.8498234, 0.700974, 2.36741>, <0.09521257, -0.0003534357, -0.001540304>,
                         <-0.8529572, 0.593843, 2.13724>, <0.1051546, 0.0002276906, -0.00139803>,
                         <-0.8514777, 1.04454, 2.11695>, <0.09947597, -0.003607422, -0.001567964> }
        smooth_triangle {<-0.8455303, 1.10808, 2.33225>, <0.08355729, -0.00511451, -0.00214293>,
                         <-0.838747, 1.17379, 2.54329>, <0.07518644, -0.00737498, -0.002110567>,
                         <-0.84625, 0.8118369, 2.59379>, <0.08363308, -0.001133648, -0.001588627> }
        smooth_triangle {<-0.84625, 0.8118369, 2.59379>, <0.08777496, -0.001121605, -0.001385358>,
                         <-0.8498234, 0.700974, 2.36741>, <0.09274977, -0.0005267818, -0.00147154>,
                         <-0.8455303, 1.10808, 2.33225>, <0.08668265, -0.004110263, -0.001851903> }
        smooth_triangle {<-0.7758374, 1.52919, 1.02625>, <0.07670372, -0.01159433, 0.002998919>,
                         <-0.7862447, 1.50917, 1.21506>, <0.07799473, -0.01052513, 0.004258464>,
                         <-0.8458109, 1.10646, 1.18163>, <0.08676091, -0.004357762, 0.002760121> }
        smooth_triangle {<-0.8458109, 1.10646, 1.18163>, <0.0841158, -0.006579314, 0.00163884>,
                         <-0.838747, 1.17379, 0.9766691>, <0.08117787, -0.007168637, 0.0004429526>,
                         <-0.7758374, 1.52919, 1.02625>, <0.07644211, -0.01241915, 0.0006369583> }
        smooth_triangle {<-0.7862447, 1.50917, 1.21506>, <0.07799473, -0.01052513, 0.004258464>,
                         <-0.7951758, 1.48998, 1.4116>, <0.09189194, -0.01059483, 0.003607145>,
                         <-0.8518728, 1.04234, 1.39347>, <0.1000469, -0.003883005, 0.002393263> }
        smooth_triangle {<-0.8518728, 1.04234, 1.39347>, <0.09689901, -0.006117557, 0.001450369>,
                         <-0.8458109, 1.10646, 1.18163>, <0.0869345, -0.006473625, 0.001725513>,
                         <-0.7862447, 1.50917, 1.21506>, <0.08035987, -0.01109915, 0.00284927> }
        smooth_triangle {<-0.7951758, 1.48998, 1.4116>, <0.09189194, -0.01059483, 0.003607145>,
                         <-0.7999584, 1.47445, 1.63166>, <0.1085423, -0.01160345, 0.001721235>,
                         <-0.8551153, 0.9916181, 1.62673>, <0.1156899, -0.004024999, 0.0009932295> }
        smooth_triangle {<-0.8551153, 0.9916181, 1.62673>, <0.1131018, -0.006339731, 0.0003889153>,
                         <-0.8518728, 1.04234, 1.39347>, <0.1013695, -0.006233236, 0.00143894>,
                         <-0.7951758, 1.48998, 1.4116>, <0.09525326, -0.01126711, 0.002349352> }
        smooth_triangle {<-0.7999584, 1.47445, 1.63166>, <0.1085423, -0.01160345, 0.001721235>,
                         <-0.7997378, 1.47267, 1.87946>, <0.1100329, -0.0121291, -0.0006299367>,
                         <-0.8549671, 0.9919852, 1.886>, <0.116861, -0.004684857, -0.0005904294> }
        smooth_triangle {<-0.8549671, 0.9919852, 1.886>, <0.1189418, -0.007088657, -0.0004556503>,
                         <-0.8551153, 0.9916181, 1.62673>, <0.1180634, -0.006593764, 0.0007320939>,
                         <-0.7999584, 1.47445, 1.63166>, <0.1127027, -0.0122776, 0.001278098> }
        smooth_triangle {<-0.7997378, 1.47267, 1.87946>, <0.1100329, -0.0121291, -0.0006299367>,
                         <-0.7945917, 1.48869, 2.09704>, <0.0895772, -0.01135601, -0.002550317>,
                         <-0.8514777, 1.04454, 2.11695>, <0.09733133, -0.004675184, -0.00167266> }
        smooth_triangle {<-0.8514777, 1.04454, 2.11695>, <0.1008376, -0.006700831, -0.0009482114>,
                         <-0.8549671, 0.9919852, 1.886>, <0.1154848, -0.006708085, -0.0001365386>,
                         <-0.7997378, 1.47267, 1.87946>, <0.1103637, -0.01229126, -0.0001661691> }
        smooth_triangle {<-0.7945917, 1.48869, 2.09704>, <0.0895772, -0.01135601, -0.002550317>,
                         <-0.7858307, 1.50864, 2.29774>, <0.07528027, -0.0114626, -0.003455559>,
                         <-0.8455303, 1.10808, 2.33225>, <0.08355729, -0.00511451, -0.00214293> }
        smooth_triangle {<-0.8455303, 1.10808, 2.33225>, <0.08689092, -0.006927423, -0.001363918>,
                         <-0.8514777, 1.04454, 2.11695>, <0.09722145, -0.006597928, -0.001011216>,
                         <-0.7945917, 1.48869, 2.09704>, <0.09140585, -0.01160855, -0.001669459> }
        smooth_triangle {<-0.7858307, 1.50864, 2.29774>, <0.07528027, -0.0114626, -0.003455559>,
                         <-0.7758374, 1.52919, 2.49371>, <0.06704691, -0.01134632, -0.004116781>,
                         <-0.838747, 1.17379, 2.54329>, <0.07518644, -0.00737498, -0.002110567> }
        smooth_triangle {<-0.838747, 1.17379, 2.54329>, <0.07905887, -0.009194456, -0.001005216>,
                         <-0.8455303, 1.10808, 2.33225>, <0.0843689, -0.007044235, -0.001305825>,
                         <-0.7858307, 1.50864, 2.29774>, <0.07816114, -0.0118053, -0.002290297> }
        smooth_triangle {<-0.7248999, 1.88677, 1.07614>, <0.06895232, -0.008675883, 0.006866677>,
                         <-0.7386506, 1.91406, 1.24871>, <0.07042297, -0.005093212, 0.006405588>,
                         <-0.7862447, 1.50917, 1.21506>, <0.07799473, -0.01052513, 0.004258464> }
        smooth_triangle {<-0.7862447, 1.50917, 1.21506>, <0.0756239, -0.01042796, 0.003869321>,
                         <-0.7758374, 1.52919, 1.02625>, <0.07260755, -0.0108654, 0.002850406>,
                         <-0.7248999, 1.88677, 1.07614>, <0.06873185, -0.009406173, 0.004784285> }
        smooth_triangle {<-0.7386506, 1.91406, 1.24871>, <0.07042297, -0.005093212, 0.006405588>,
                         <-0.7504509, 1.9398, 1.42986>, <0.08501394, -0.004880289, 0.00526284>,
                         <-0.7951758, 1.48998, 1.4116>, <0.09189194, -0.01059483, 0.003607145> }
        smooth_triangle {<-0.7951758, 1.48998, 1.4116>, <0.08897477, -0.0103598, 0.003381027>,
                         <-0.7862447, 1.50917, 1.21506>, <0.07855186, -0.01030752, 0.003869516>,
                         <-0.7386506, 1.91406, 1.24871>, <0.07287303, -0.006233581, 0.005479859> }
        smooth_triangle {<-0.7504509, 1.9398, 1.42986>, <0.08501394, -0.004880289, 0.00526284>,
                         <-0.7567735, 1.95946, 1.63665>, <0.1028286, -0.005175768, 0.002133463>,
                         <-0.7999584, 1.47445, 1.63166>, <0.1085423, -0.01160345, 0.001721235> }
        smooth_triangle {<-0.7999584, 1.47445, 1.63166>, <0.1062253, -0.01118503, 0.001655093>,
                         <-0.7951758, 1.48998, 1.4116>, <0.09373748, -0.01042857, 0.003069526>,
                         <-0.7504509, 1.9398, 1.42986>, <0.08857898, -0.006142664, 0.004311297> }
        smooth_triangle {<-0.7567735, 1.95946, 1.63665>, <0.1028286, -0.005175768, 0.002133463>,
                         <-0.7564806, 1.95554, 1.87288>, <0.1046586, -0.005084536, -0.001443857>,
                         <-0.7997378, 1.47267, 1.87946>, <0.1100329, -0.0121291, -0.0006299367> }
        smooth_triangle {<-0.7997378, 1.47267, 1.87946>, <0.1125726, -0.01177181, -0.000518375>,
                         <-0.7999584, 1.47445, 1.63166>, <0.1114547, -0.01137757, 0.001245003>,
                         <-0.7567735, 1.95946, 1.63665>, <0.1071694, -0.006556814, 0.001554174> }
        smooth_triangle {<-0.7564806, 1.95554, 1.87288>, <0.1046586, -0.005084536, -0.001443857>,
                         <-0.7496777, 1.93501, 2.077>, <0.08313385, -0.005148192, -0.004188227>,
                         <-0.7945917, 1.48869, 2.09704>, <0.0895772, -0.01135601, -0.002550317> }
        smooth_triangle {<-0.7945917, 1.48869, 2.09704>, <0.09347442, -0.01087843, -0.002360778>,
                         <-0.7997378, 1.47267, 1.87946>, <0.1088162, -0.01145825, -0.0009204922>,
                         <-0.7564806, 1.95554, 1.87288>, <0.1047854, -0.006174829, -0.001530933> }
        smooth_triangle {<-0.7496777, 1.93501, 2.077>, <0.08313385, -0.005148192, -0.004188227>,
                         <-0.738103, 1.91138, 2.26301>, <0.06825227, -0.005720189, -0.005545213>,
                         <-0.7858307, 1.50864, 2.29774>, <0.07528027, -0.0114626, -0.003455559> }
        smooth_triangle {<-0.7858307, 1.50864, 2.29774>, <0.07895457, -0.0108944, -0.003345195>,
                         <-0.7945917, 1.48869, 2.09704>, <0.08967726, -0.01081445, -0.002666264>,
                         <-0.7496777, 1.93501, 2.077>, <0.08484475, -0.006158593, -0.003894697> }
        smooth_triangle {<-0.738103, 1.91138, 2.26301>, <0.06825227, -0.005720189, -0.005545213>,
                         <-0.7248999, 1.88677, 2.44382>, <0.0598639, -0.004408546, -0.005557555>,
                         <-0.7758374, 1.52919, 2.49371>, <0.06704691, -0.01134632, -0.004116781> }
        smooth_triangle {<-0.7758374, 1.52919, 2.49371>, <0.07124402, -0.01079763, -0.003759153>,
                         <-0.7858307, 1.50864, 2.29774>, <0.07636977, -0.01102201, -0.003352643>,
                         <-0.738103, 1.91138, 2.26301>, <0.07109877, -0.006715207, -0.004919884> }
        smooth_triangle {<-0.7362556, 2.24823, 1.12657>, <0.06130031, 0.001713793, 0.005890965>,
                         <-0.7533497, 2.32284, 1.28275>, <0.06264638, 0.002478265, 0.005444986>,
                         <-0.7386506, 1.91406, 1.24871>, <0.07042297, -0.005093212, 0.006405588> }
        smooth_triangle {<-0.7386506, 1.91406, 1.24871>, <0.06806716, -0.003503365, 0.005969289>,
                         <-0.7248999, 1.88677, 1.07614>, <0.06497602, -0.003704854, 0.005763536>,
                         <-0.7362556, 2.24823, 1.12657>, <0.06115002, 0.001489984, 0.00527568> }
        smooth_triangle {<-0.7533497, 2.32284, 1.28275>, <0.06264638, 0.002478265, 0.005444986>,
                         <-0.7680192, 2.3935, 1.44836>, <0.07794174, 0.003484648, 0.004228923>,
                         <-0.7504509, 1.9398, 1.42986>, <0.08501394, -0.004880289, 0.00526284> }
        smooth_triangle {<-0.7504509, 1.9398, 1.42986>, <0.08205402, -0.003094931, 0.005058462>,
                         <-0.7386506, 1.91406, 1.24871>, <0.07111079, -0.003254623, 0.005915523>,
                         <-0.7533497, 2.32284, 1.28275>, <0.06527835, 0.002423985, 0.005195072> }
        smooth_triangle {<-0.7680192, 2.3935, 1.44836>, <0.07794174, 0.003484648, 0.004228923>,
                         <-0.7758819, 2.44835, 1.64171>, <0.09691124, 0.004510353, 0.001496023>,
                         <-0.7567735, 1.95946, 1.63665>, <0.1028286, -0.005175768, 0.002133463> }
        smooth_triangle {<-0.7567735, 1.95946, 1.63665>, <0.1004853, -0.003002841, 0.002230921>,
                         <-0.7504509, 1.9398, 1.42986>, <0.08712438, -0.002781231, 0.004577954>,
                         <-0.7680192, 2.3935, 1.44836>, <0.08182024, 0.003492472, 0.003802517> }
        smooth_triangle {<-0.7758819, 2.44835, 1.64171>, <0.09691124, 0.004510353, 0.001496023>,
                         <-0.7755166, 2.44228, 1.86622>, <0.09902011, 0.004692389, -0.0009448629>,
                         <-0.7564806, 1.95554, 1.87288>, <0.1046586, -0.005084536, -0.001443857> }
        smooth_triangle {<-0.7564806, 1.95554, 1.87288>, <0.1073715, -0.002684532, -0.001099978>,
                         <-0.7567735, 1.95946, 1.63665>, <0.105999, -0.002752956, 0.001583012>,
                         <-0.7758819, 2.44835, 1.64171>, <0.1015611, 0.004511635, 0.001104932> }
        smooth_triangle {<-0.7755166, 2.44228, 1.86622>, <0.09902011, 0.004692389, -0.0009448629>,
                         <-0.7670569, 2.38522, 2.05673>, <0.0764503, 0.003391664, -0.003149571>,
                         <-0.7496777, 1.93501, 2.077>, <0.08313385, -0.005148192, -0.004188227> }
        smooth_triangle {<-0.7496777, 1.93501, 2.077>, <0.08715533, -0.002901044, -0.003871315>,
                         <-0.7564806, 1.95554, 1.87288>, <0.1032989, -0.002853302, -0.001813038>,
                         <-0.7755166, 2.44228, 1.86622>, <0.09907003, 0.004479392, -0.001438793> }
        smooth_triangle {<-0.7670569, 2.38522, 2.05673>, <0.0764503, 0.003391664, -0.003149571>,
                         <-0.7526687, 2.31799, 2.2279>, <0.06100045, 0.002212992, -0.004667269>,
                         <-0.738103, 1.91138, 2.26301>, <0.06825227, -0.005720189, -0.005545213> }
        smooth_triangle {<-0.738103, 1.91138, 2.26301>, <0.07200519, -0.003540616, -0.005358962>,
                         <-0.7496777, 1.93501, 2.077>, <0.08316638, -0.003111618, -0.004341222>,
                         <-0.7670569, 2.38522, 2.05673>, <0.07815372, 0.003293274, -0.00356223> }
        smooth_triangle {<-0.7526687, 2.31799, 2.2279>, <0.06100045, 0.002212992, -0.004667269>,
                         <-0.7362556, 2.24823, 2.39339>, <0.05229748, 0.001809975, -0.004741706>,
                         <-0.7248999, 1.88677, 2.44382>, <0.0598639, -0.004408546, -0.005557555> }
        smooth_triangle {<-0.7248999, 1.88677, 2.44382>, <0.0641281, -0.0022157, -0.005375107>,
                         <-0.738103, 1.91138, 2.26301>, <0.06935333, -0.003747644, -0.005411463>,
                         <-0.7526687, 2.31799, 2.2279>, <0.06391446, 0.002202242, -0.004753005> }
        smooth_triangle {<-0.7599071, 2.60807, 1.17677>, <0.05280791, 0.003082814, 0.005029912>,
                         <-0.7803447, 2.72998, 1.31662>, <0.05114489, -0.00447614, 0.01447477>,
                         <-0.7533497, 2.32284, 1.28275>, <0.06264638, 0.002478265, 0.005444986> }
        smooth_triangle {<-0.7533497, 2.32284, 1.28275>, <0.06009765, 0.002567593, 0.005180367>,
                         <-0.7362556, 2.24823, 1.12657>, <0.05687589, 0.002274684, 0.005138737>,
                         <-0.7599071, 2.60807, 1.17677>, <0.05262969, 0.002959195, 0.004708211> }
        smooth_triangle {<-0.7803447, 2.72998, 1.31662>, <0.05114489, -0.00447614, 0.01447477>,
                         <-0.7978833, 2.84558, 1.46675>, <0.06651164, -0.003983705, 0.01273518>,
                         <-0.7680192, 2.3935, 1.44836>, <0.07794174, 0.003484648, 0.004228923> }
        smooth_triangle {<-0.7680192, 2.3935, 1.44836>, <0.07471479, 0.003606915, 0.004187937>,
                         <-0.7533497, 2.32284, 1.28275>, <0.06324327, 0.002852128, 0.005099984>,
                         <-0.7803447, 2.72998, 1.31662>, <0.05461715, -0.002363676, 0.01187233> }
        smooth_triangle {<-0.7978833, 2.84558, 1.46675>, <0.06651164, -0.003983705, 0.01273518>,
                         <-0.8072861, 2.93561, 1.64673>, <0.08525764, -0.004636401, 0.008397295>,
                         <-0.7758819, 2.44835, 1.64171>, <0.09691124, 0.004510353, 0.001496023> }
        smooth_triangle {<-0.7758819, 2.44835, 1.64171>, <0.09428351, 0.00479016, 0.001601213>,
                         <-0.7680192, 2.3935, 1.44836>, <0.08005639, 0.004020882, 0.003650888>,
                         <-0.7978833, 2.84558, 1.46675>, <0.07148381, -0.001580383, 0.01003058> }
        smooth_triangle {<-0.8072861, 2.93561, 1.64673>, <0.08525764, -0.004636401, 0.008397295>,
                         <-0.8068484, 2.9274, 1.85959>, <0.08640863, -0.006583322, -0.001165674>,
                         <-0.7755166, 2.44228, 1.86622>, <0.09902011, 0.004692389, -0.0009448629> }
        smooth_triangle {<-0.7755166, 2.44228, 1.86622>, <0.1016217, 0.005282399, -0.000705556>,
                         <-0.7758819, 2.44835, 1.64171>, <0.10004, 0.005145871, 0.001125108>,
                         <-0.8072861, 2.93561, 1.64673>, <0.09129983, -0.001714194, 0.006301062> }
        smooth_triangle {<-0.8068484, 2.9274, 1.85959>, <0.08640863, -0.006583322, -0.001165674>,
                         <-0.796732, 2.8338, 2.03656>, <0.06437411, -0.005822726, -0.009995675>,
                         <-0.7670569, 2.38522, 2.05673>, <0.0764503, 0.003391664, -0.003149571> }
        smooth_triangle {<-0.7670569, 2.38522, 2.05673>, <0.08034885, 0.004022027, -0.0029412>,
                         <-0.7755166, 2.44228, 1.86622>, <0.0972762, 0.004997571, -0.001287669>,
                         <-0.8068484, 2.9274, 1.85959>, <0.08781759, -0.003459212, -0.001453277> }
        smooth_triangle {<-0.796732, 2.8338, 2.03656>, <0.06437411, -0.005822726, -0.009995675>,
                         <-0.7795301, 2.72299, 2.19295>, <0.04933995, -0.005768874, -0.01291465>,
                         <-0.7526687, 2.31799, 2.2279>, <0.06100045, 0.002212992, -0.004667269> }
        smooth_triangle {<-0.7526687, 2.31799, 2.2279>, <0.06460669, 0.002857016, -0.0046153>,
                         <-0.7670569, 2.38522, 2.05673>, <0.07619408, 0.00374102, -0.003477027>,
                         <-0.796732, 2.8338, 2.03656>, <0.06713694, -0.003169772, -0.008611605> }
        smooth_triangle {<-0.7795301, 2.72299, 2.19295>, <0.04933995, -0.005768874, -0.01291465>,
                         <-0.7599071, 2.60807, 2.34319>, <0.03917432, -0.01031715, -0.01799226>,
                         <-0.7362556, 2.24823, 2.39339>, <0.05229748, 0.001809975, -0.004741706> }
        smooth_triangle {<-0.7362556, 2.24823, 2.39339>, <0.05639347, 0.002497229, -0.004752196>,
                         <-0.7526687, 2.31799, 2.2279>, <0.0618967, 0.002627678, -0.004693746>,
                         <-0.7795301, 2.72299, 2.19295>, <0.05315133, -0.003358721, -0.01087928> }
        smooth_triangle {<-0.598967, 2.86552, 1.21269>, <0.0348818, -0.02067215, 0.0339178>,
                         <-0.622748, 3.03475, 1.34029>, <0.0407134, -0.02119452, 0.03294615>,
                         <-0.7803447, 2.72998, 1.31662>, <0.05114489, -0.00447614, 0.01447477> }
        smooth_triangle {<-0.7803447, 2.72998, 1.31662>, <0.04626485, -0.009167339, 0.01707693>,
                         <-0.7599071, 2.60807, 1.17677>, <0.04221633, -0.01007906, 0.01495665>,
                         <-0.598967, 2.86552, 1.21269>, <0.03325328, -0.02195654, 0.0294006> }
        smooth_triangle {<-0.622748, 3.03475, 1.34029>, <0.0407134, -0.02119452, 0.03294615>,
                         <-0.6431559, 3.19528, 1.47903>, <0.05593336, -0.02394861, 0.02768361>,
                         <-0.7978833, 2.84558, 1.46675>, <0.06651164, -0.003983705, 0.01273518> }
        smooth_triangle {<-0.7978833, 2.84558, 1.46675>, <0.06063847, -0.009006685, 0.01544211>,
                         <-0.7803447, 2.72998, 1.31662>, <0.0491134, -0.009376011, 0.01674681>,
                         <-0.622748, 3.03475, 1.34029>, <0.04148191, -0.02215489, 0.0298184> }
        smooth_triangle {<-0.6431559, 3.19528, 1.47903>, <0.05593336, -0.02394861, 0.02768361>,
                         <-0.6540987, 3.32049, 1.64972>, <0.07192176, -0.02882205, 0.0108057>,
                         <-0.8072861, 2.93561, 1.64673>, <0.08525764, -0.004636401, 0.008397295> }
        smooth_triangle {<-0.8072861, 2.93561, 1.64673>, <0.07940149, -0.01046812, 0.0106024>,
                         <-0.7978833, 2.84558, 1.46675>, <0.06534199, -0.009978594, 0.01385581>,
                         <-0.6431559, 3.19528, 1.47903>, <0.05789993, -0.02528682, 0.02419498> }
        smooth_triangle {<-0.6540987, 3.32049, 1.64972>, <0.07192176, -0.02882205, 0.0108057>,
                         <-0.6535886, 3.31014, 1.855>, <0.06734235, -0.0287895, -0.01300894>,
                         <-0.8068484, 2.9274, 1.85959>, <0.08640863, -0.006583322, -0.001165674> }
        smooth_triangle {<-0.8068484, 2.9274, 1.85959>, <0.08529369, -0.01308887, -0.001230628>,
                         <-0.8072861, 2.93561, 1.64673>, <0.08443044, -0.01162868, 0.005941599>,
                         <-0.6540987, 3.32049, 1.64972>, <0.07526413, -0.03008321, 0.006728637> }
        smooth_triangle {<-0.6535886, 3.31014, 1.855>, <0.06734235, -0.0287895, -0.01300894>,
                         <-0.6418154, 3.18, 2.02251>, <0.04821388, -0.02479483, -0.02732378>,
                         <-0.796732, 2.8338, 2.03656>, <0.06437411, -0.005822726, -0.009995675> }
        smooth_triangle {<-0.796732, 2.8338, 2.03656>, <0.06510666, -0.01115929, -0.01205105>,
                         <-0.8068484, 2.9274, 1.85959>, <0.08163255, -0.01172973, -0.005428551>,
                         <-0.6535886, 3.31014, 1.855>, <0.06732966, -0.02824932, -0.01474502> }
        smooth_triangle {<-0.6418154, 3.18, 2.02251>, <0.04821388, -0.02479483, -0.02732378>,
                         <-0.6217999, 3.0256, 2.1682>, <0.03516002, -0.02333855, -0.03102628>,
                         <-0.7795301, 2.72299, 2.19295>, <0.04933995, -0.005768874, -0.01291465> }
        smooth_triangle {<-0.7795301, 2.72299, 2.19295>, <0.05015085, -0.01044373, -0.01546656>,
                         <-0.796732, 2.8338, 2.03656>, <0.06142647, -0.01048412, -0.01327732>,
                         <-0.6418154, 3.18, 2.02251>, <0.04967043, -0.024686, -0.02592328> }
        smooth_triangle {<-0.6217999, 3.0256, 2.1682>, <0.03516002, -0.02333855, -0.03102628>,
                         <-0.598967, 2.86552, 2.30727>, <0.03005519, -0.02320265, -0.03164156>,
                         <-0.7599071, 2.60807, 2.34319>, <0.03917432, -0.01031715, -0.01799226> }
        smooth_triangle {<-0.7599071, 2.60807, 2.34319>, <0.04032324, -0.01493929, -0.02001644>,
                         <-0.7795301, 2.72299, 2.19295>, <0.04766023, -0.01037255, -0.01570219>,
                         <-0.6217999, 3.0256, 2.1682>, <0.03764704, -0.02362022, -0.02870579> }
    }
    union { // Poly_Mesh
        smooth_triangle {<0.7580933, 0.2878365, 1.11344>, <-0.09452847, 0.0005019372, 0.001572649>,
                         <0.7608342, 0.6971982, 1.14754>, <-0.09534384, 0.0002323199, 0.001930232>,
                         <0.7577601, 0.8118369, 0.9261714>, <-0.09452847, 0.0005019372, 0.001572649> }
        smooth_triangle {<0.7577601, 0.8118369, 0.9261714>, <-0.09439945, 0.0001760491, 0.0006605652>,
                         <0.7584703, 0.4497867, 0.8756594>, <-0.09427044, -0.0001498389, -0.0002515188>,
                         <0.7580933, 0.2878365, 1.11344>, <-0.09439945, 0.0001760491, 0.0006605652> }
        smooth_triangle {<0.7608342, 0.6971982, 1.14754>, <-0.09534384, 0.0002323199, 0.001930232>,
                         <0.7567823, 1.10646, 1.18163>, <-0.08676091, -0.004315713, 0.00256623>,
                         <0.7502571, 1.17379, 0.9766691>, <-0.08617524, -0.001052869, 0.002397738> }
        smooth_triangle {<0.7502571, 1.17379, 0.9766691>, <-0.08604409, -0.001434516, 0.001325142>,
                         <0.7577601, 0.8118369, 0.9261714>, <-0.0902207, -0.0006571128, 0.0009125974>,
                         <0.7608342, 0.6971982, 1.14754>, <-0.09298612, -0.0002798008, 0.00151081> }
        smooth_triangle {<0.7567823, 1.10646, 1.18163>, <-0.08676091, -0.004315713, 0.00256623>,
                         <0.6973239, 1.50917, 1.21506>, <-0.07799473, -0.01048838, 0.004102843>,
                         <0.6873475, 1.52919, 1.02625>, <-0.07670372, -0.01155959, 0.002827557> }
        smooth_triangle {<0.6873475, 1.52919, 1.02625>, <-0.07644211, -0.01238843, 0.0004555698>,
                         <0.7502571, 1.17379, 0.9766691>, <-0.08117787, -0.007135067, 0.0002406601>,
                         <0.7567823, 1.10646, 1.18163>, <-0.0841158, -0.006541101, 0.001445568> }
        smooth_triangle {<0.6973239, 1.50917, 1.21506>, <-0.07799473, -0.01048838, 0.004102843>,
                         <0.6498375, 1.91406, 1.24871>, <-0.07042297, -0.005061563, 0.006285651>,
                         <0.6364099, 1.88677, 1.07614>, <-0.06895232, -0.00864642, 0.006732895> }
        smooth_triangle {<0.6364099, 1.88677, 1.07614>, <-0.06873185, -0.009380694, 0.004640359>,
                         <0.6873475, 1.52919, 1.02625>, <-0.07260755, -0.01083728, 0.00268769>,
                         <0.6973239, 1.50917, 1.21506>, <-0.0756239, -0.01039503, 0.003714088> }
        smooth_triangle {<0.6498375, 1.91406, 1.24871>, <-0.07042297, -0.005061563, 0.006285651>,
                         <0.6646444, 2.32284, 1.28275>, <-0.06264638, 0.002504745, 0.005361272>,
                         <0.6477657, 2.24823, 1.12657>, <-0.06130031, 0.001737948, 0.005794864> }
        smooth_triangle {<0.6477657, 2.24823, 1.12657>, <-0.06115002, 0.00151021, 0.005169225>,
                         <0.6364099, 1.88677, 1.07614>, <-0.06497602, -0.003681974, 0.005638241>,
                         <0.6498375, 1.91406, 1.24871>, <-0.06806716, -0.003475554, 0.005850135> }
        smooth_triangle {<0.6646444, 2.32284, 1.28275>, <-0.06264638, 0.002504745, 0.005361272>,
                         <0.6917471, 2.72998, 1.31662>, <-0.05114489, -0.004454736, 0.01442805>,
                         <0.6714172, 2.60807, 1.17677>, <-0.05280791, 0.003101527, 0.004972921> }
        smooth_triangle {<0.6714172, 2.60807, 1.17677>, <-0.05262969, 0.002973959, 0.004640955>,
                         <0.6477657, 2.24823, 1.12657>, <-0.05687589, 0.00229217, 0.005051926>,
                         <0.6646444, 2.32284, 1.28275>, <-0.06009765, 0.002590157, 0.005098201> }
        smooth_triangle {<0.6917471, 2.72998, 1.31662>, <-0.05114489, -0.004454736, 0.01442805>,
                         <0.5342581, 3.03475, 1.34029>, <-0.0407134, -0.02117376, 0.03292097>,
                         <0.5104771, 2.86552, 1.21269>, <-0.0348818, -0.02065841, 0.03389957> }
        smooth_triangle {<0.5104771, 2.86552, 1.21269>, <-0.03325328, -0.02194774, 0.02937761>,
                         <0.6714172, 2.60807, 1.17677>, <-0.04221633, -0.01006777, 0.01491429>,
                         <0.6917471, 2.72998, 1.31662>, <-0.04626485, -0.009150319, 0.01703496> }
        smooth_triangle {<0.7577697, 0.1338536, 1.35641>, <-0.1053278, 0.001247891, 0.001820308>,
                         <0.7634722, 0.5881453, 1.37494>, <-0.1079762, 0.0009014314, 0.001872312>,
                         <0.7608342, 0.6971982, 1.14754>, <-0.09534384, 0.0002323199, 0.001930232> }
        smooth_triangle {<0.7608342, 0.6971982, 1.14754>, <-0.09768589, 0.0003434872, 0.001520068>,
                         <0.7580933, 0.2878365, 1.11344>, <-0.09962025, 0.0005894632, 0.0009311133>,
                         <0.7577697, 0.1338536, 1.35641>, <-0.1050199, 0.0009624401, 0.001054943> }
        smooth_triangle {<0.7634722, 0.5881453, 1.37494>, <-0.1079762, 0.0009014314, 0.001872312>,
                         <0.762382, 1.04234, 1.39347>, <-0.1000469, -0.003831103, 0.002239985>,
                         <0.7567823, 1.10646, 1.18163>, <-0.08676091, -0.004315713, 0.00256623> }
        smooth_triangle {<0.7567823, 1.10646, 1.18163>, <-0.08926664, -0.003489614, 0.002084115>,
                         <0.7608342, 0.6971982, 1.14754>, <-0.09570384, -7.85895e-005, 0.001607116>,
                         <0.7634722, 0.5881453, 1.37494>, <-0.1051781, 0.0004232441, 0.001563676> }
        smooth_triangle {<0.762382, 1.04234, 1.39347>, <-0.1000469, -0.003831103, 0.002239985>,
                         <0.7058852, 1.48998, 1.4116>, <-0.09189194, -0.01054732, 0.00348135>,
                         <0.6973239, 1.50917, 1.21506>, <-0.07799473, -0.01048838, 0.004102843> }
        smooth_triangle {<0.6973239, 1.50917, 1.21506>, <-0.08035987, -0.01106202, 0.002687736>,
                         <0.7567823, 1.10646, 1.18163>, <-0.0869345, -0.006432519, 0.001535276>,
                         <0.762382, 1.04234, 1.39347>, <-0.09689901, -0.006069062, 0.001290592> }
        smooth_triangle {<0.7058852, 1.48998, 1.4116>, <-0.09189194, -0.01054732, 0.00348135>,
                         <0.6613604, 1.9398, 1.42986>, <-0.08501394, -0.004837096, 0.005162739>,
                         <0.6498375, 1.91406, 1.24871>, <-0.07042297, -0.005061563, 0.006285651> }
        smooth_triangle {<0.6498375, 1.91406, 1.24871>, <-0.07287303, -0.00620144, 0.005352986>,
                         <0.6973239, 1.50917, 1.21506>, <-0.07855186, -0.01027155, 0.003715879>,
                         <0.7058852, 1.48998, 1.4116>, <-0.08897477, -0.01031576, 0.00324976> }
        smooth_triangle {<0.6613604, 1.9398, 1.42986>, <-0.08501394, -0.004837096, 0.005162739>,
                         <0.6791289, 2.3935, 1.44836>, <-0.07794174, 0.00352347, 0.004154971>,
                         <0.6646444, 2.32284, 1.28275>, <-0.06264638, 0.002504745, 0.005361272> }
        smooth_triangle {<0.6646444, 2.32284, 1.28275>, <-0.06527835, 0.002451083, 0.005103247>,
                         <0.6498375, 1.91406, 1.24871>, <-0.07111079, -0.003223648, 0.005796531>,
                         <0.6613604, 1.9398, 1.42986>, <-0.08205402, -0.003055298, 0.004954347> }
        smooth_triangle {<0.6791289, 2.3935, 1.44836>, <-0.07794174, 0.00352347, 0.004154971>,
                         <0.7091932, 2.84558, 1.46675>, <-0.06651164, -0.003948993, 0.01268789>,
                         <0.6917471, 2.72998, 1.31662>, <-0.05114489, -0.004454736, 0.01442805> }
        smooth_triangle {<0.6917471, 2.72998, 1.31662>, <-0.05461715, -0.002341597, 0.01181656>,
                         <0.6646444, 2.32284, 1.28275>, <-0.06324327, 0.002878013, 0.005016473>,
                         <0.6791289, 2.3935, 1.44836>, <-0.07471479, 0.003642057, 0.004111746> }
        smooth_triangle {<0.7091932, 2.84558, 1.46675>, <-0.06651164, -0.003948993, 0.01268789>,
                         <0.5546659, 3.19528, 1.47903>, <-0.05593336, -0.02391368, 0.02765211>,
                         <0.5342581, 3.03475, 1.34029>, <-0.0407134, -0.02117376, 0.03292097> }
        smooth_triangle {<0.5342581, 3.03475, 1.34029>, <-0.04148191, -0.02213493, 0.02978807>,
                         <0.6917471, 2.72998, 1.31662>, <-0.0491134, -0.009355368, 0.01670161>,
                         <0.7091932, 2.84558, 1.46675>, <-0.06063847, -0.008976061, 0.01539649> }
        smooth_triangle {<0.7576073, 0.01276457, 1.61659>, <-0.1211969, 0.001791082, 0.001323232>,
                         <0.7648963, 0.5022423, 1.62166>, <-0.1225657, 0.001282216, 0.0009231767>,
                         <0.7634722, 0.5881453, 1.37494>, <-0.1079762, 0.0009014314, 0.001872312> }
        smooth_triangle {<0.7634722, 0.5881453, 1.37494>, <-0.1110917, 0.001047738, 0.001558428>,
                         <0.7577697, 0.1338536, 1.35641>, <-0.1128831, 0.001367275, 0.001218542>,
                         <0.7576073, 0.01276457, 1.61659>, <-0.1208177, 0.00163887, 0.0009700041> }
        smooth_triangle {<0.7648963, 0.5022423, 1.62166>, <-0.1225657, 0.001282216, 0.0009231767>,
                         <0.7653926, 0.9916181, 1.62673>, <-0.1156899, -0.003965811, 0.0009317648>,
                         <0.762382, 1.04234, 1.39347>, <-0.1000469, -0.003831103, 0.002239985> }
        smooth_triangle {<0.762382, 1.04234, 1.39347>, <-0.1034468, -0.002947165, 0.001818283>,
                         <0.7634722, 0.5881453, 1.37494>, <-0.1093938, 0.0006022357, 0.001542528>,
                         <0.7648963, 0.5022423, 1.62166>, <-0.1203359, 0.0008878239, 0.0008306768> }
        smooth_triangle {<0.7653926, 0.9916181, 1.62673>, <-0.1156899, -0.003965811, 0.0009317648>,
                         <0.7104822, 1.47445, 1.63166>, <-0.1085423, -0.01154754, 0.001669325>,
                         <0.7058852, 1.48998, 1.4116>, <-0.09189194, -0.01054732, 0.00348135> }
        smooth_triangle {<0.7058852, 1.48998, 1.4116>, <-0.09525326, -0.01121875, 0.002231593>,
                         <0.762382, 1.04234, 1.39347>, <-0.1013695, -0.006181585, 0.001300569>,
                         <0.7653926, 0.9916181, 1.62673>, <-0.1131018, -0.006282616, 0.0003194045> }
        smooth_triangle {<0.7104822, 1.47445, 1.63166>, <-0.1085423, -0.01154754, 0.001669325>,
                         <0.6675439, 1.95946, 1.63665>, <-0.1028286, -0.005123153, 0.002090529>,
                         <0.6613604, 1.9398, 1.42986>, <-0.08501394, -0.004837096, 0.005162739> }
        smooth_triangle {<0.6613604, 1.9398, 1.42986>, <-0.08857898, -0.00609841, 0.004216137>,
                         <0.7058852, 1.48998, 1.4116>, <-0.09373748, -0.01038108, 0.002955095>,
                         <0.7104822, 1.47445, 1.63166>, <-0.1062253, -0.01113124, 0.001596077> }
        smooth_triangle {<0.6675439, 1.95946, 1.63665>, <-0.1028286, -0.005123153, 0.002090529>,
                         <0.6868989, 2.44835, 1.64171>, <-0.09691124, 0.004559651, 0.001462285>,
                         <0.6791289, 2.3935, 1.44836>, <-0.07794174, 0.00352347, 0.004154971> }
        smooth_triangle {<0.6791289, 2.3935, 1.44836>, <-0.08182024, 0.00353258, 0.003730288>,
                         <0.6613604, 1.9398, 1.42986>, <-0.08712438, -0.002737845, 0.004486114>,
                         <0.6675439, 1.95946, 1.63665>, <-0.1004853, -0.002952387, 0.002181957> }
        smooth_triangle {<0.6868989, 2.44835, 1.64171>, <-0.09691124, 0.004559651, 0.001462285>,
                         <0.7185497, 2.93561, 1.64673>, <-0.08525764, -0.004590078, 0.008372903>,
                         <0.7091932, 2.84558, 1.46675>, <-0.06651164, -0.003948993, 0.01268789> }
        smooth_triangle {<0.7091932, 2.84558, 1.46675>, <-0.07148381, -0.001544246, 0.009981884>,
                         <0.6791289, 2.3935, 1.44836>, <-0.08005639, 0.004060101, 0.003582196>,
                         <0.6868989, 2.44835, 1.64171>, <-0.09428351, 0.004837237, 0.001562682> }
        smooth_triangle {<0.7185497, 2.93561, 1.64673>, <-0.08525764, -0.004590078, 0.008372903>,
                         <0.5656088, 3.32049, 1.64972>, <-0.07192176, -0.02877581, 0.01079153>,
                         <0.5546659, 3.19528, 1.47903>, <-0.05593336, -0.02391368, 0.02765211> }
        smooth_triangle {<0.5546659, 3.19528, 1.47903>, <-0.05789993, -0.02525134, 0.02416257>,
                         <0.7091932, 2.84558, 1.46675>, <-0.06534199, -0.009943411, 0.01381179>,
                         <0.7185497, 2.93561, 1.64673>, <-0.07940149, -0.01042423, 0.01057555> }
        smooth_triangle {<0.7576108, 0.01741816, 1.89934>, <-0.1320913, 0.001955073, -5.21821e-005>,
                         <0.7648264, 0.5047527, 1.89267>, <-0.1234942, 0.001126645, -0.0004343934>,
                         <0.7648963, 0.5022423, 1.62166>, <-0.1225657, 0.001282216, 0.0009231767> }
        smooth_triangle {<0.7648963, 0.5022423, 1.62166>, <-0.1265192, 0.001476913, 0.000684326>,
                         <0.7576073, 0.01276457, 1.61659>, <-0.1297884, 0.001926043, 0.0006455029>,
                         <0.7576108, 0.01741816, 1.89934>, <-0.1352356, 0.002008038, -4.22041e-005> }
        smooth_triangle {<0.7648264, 0.5047527, 1.89267>, <-0.1234942, 0.001126645, -0.0004343934>,
                         <0.7652493, 0.9919852, 1.886>, <-0.116861, -0.004626594, -0.0005545738>,
                         <0.7653926, 0.9916181, 1.62673>, <-0.1156899, -0.003965811, 0.0009317648> }
        smooth_triangle {<0.7653926, 0.9916181, 1.62673>, <-0.1199212, -0.002940647, 0.0006899594>,
                         <0.7648963, 0.5022423, 1.62166>, <-0.125078, 0.0009953728, 0.0006835184>,
                         <0.7648264, 0.5047527, 1.89267>, <-0.1257744, 0.0008786947, -0.0003346592> }
        smooth_triangle {<0.7652493, 0.9919852, 1.886>, <-0.116861, -0.004626594, -0.0005545738>,
                         <0.7102656, 1.47267, 1.87946>, <-0.1100329, -0.01207396, -0.0005996603>,
                         <0.7104822, 1.47445, 1.63166>, <-0.1085423, -0.01154754, 0.001669325> }
        smooth_triangle {<0.7104822, 1.47445, 1.63166>, <-0.1127027, -0.01221969, 0.00123974>,
                         <0.7653926, 0.9916181, 1.62673>, <-0.1180634, -0.006533398, 0.0006865693>,
                         <0.7652493, 0.9919852, 1.886>, <-0.1189418, -0.007028985, -0.0004281846> }
        smooth_triangle {<0.7102656, 1.47267, 1.87946>, <-0.1100329, -0.01207396, -0.0005996603>,
                         <0.6672539, 1.95554, 1.87288>, <-0.1046586, -0.005032514, -0.00141849>,
                         <0.6675439, 1.95946, 1.63665>, <-0.1028286, -0.005123153, 0.002090529> }
        smooth_triangle {<0.6675439, 1.95946, 1.63665>, <-0.1071694, -0.006502083, 0.001522563>,
                         <0.7104822, 1.47445, 1.63166>, <-0.1114547, -0.01132037, 0.00120666>,
                         <0.7102656, 1.47267, 1.87946>, <-0.1125726, -0.01171519, -0.0004950789> }
        smooth_triangle {<0.6672539, 1.95554, 1.87288>, <-0.1046586, -0.005032514, -0.00141849>,
                         <0.6865355, 2.44228, 1.86622>, <-0.09902011, 0.00474128, -0.0009244255>,
                         <0.6868989, 2.44835, 1.64171>, <-0.09691124, 0.004559651, 0.001462285> }
        smooth_triangle {<0.6868989, 2.44835, 1.64171>, <-0.1015611, 0.004563165, 0.001080232>,
                         <0.6675439, 1.95946, 1.63665>, <-0.105999, -0.002698937, 0.001551416>,
                         <0.6672539, 1.95554, 1.87288>, <-0.1073715, -0.002630958, -0.001080349> }
        smooth_triangle {<0.6865355, 2.44228, 1.86622>, <-0.09902011, 0.00474128, -0.0009244255>,
                         <0.7181129, 2.9274, 1.85959>, <-0.08640863, -0.006537233, -0.001150392>,
                         <0.7185497, 2.93561, 1.64673>, <-0.08525764, -0.004590078, 0.008372903> }
        smooth_triangle {<0.7185497, 2.93561, 1.64673>, <-0.09129983, -0.001665616, 0.006283383>,
                         <0.6868989, 2.44835, 1.64171>, <-0.10004, 0.005196681, 0.001100419>,
                         <0.6865355, 2.44228, 1.86622>, <-0.1016217, 0.005332903, -0.0006896136> }
        smooth_triangle {<0.7181129, 2.9274, 1.85959>, <-0.08640863, -0.006537233, -0.001150392>,
                         <0.5650987, 3.31014, 1.855>, <-0.06734235, -0.02874794, -0.01299496>,
                         <0.5656088, 3.32049, 1.64972>, <-0.07192176, -0.02877581, 0.01079153> }
        smooth_triangle {<0.5656088, 3.32049, 1.64972>, <-0.07526413, -0.03003489, 0.006719994>,
                         <0.7185497, 2.93561, 1.64673>, <-0.08443044, -0.01158082, 0.005923906>,
                         <0.7181129, 2.9274, 1.85959>, <-0.08529369, -0.01304119, -0.001218565> }
        smooth_triangle {<0.7577866, 0.1430467, 2.15755>, <-0.1120619, 0.001316176, -0.001181035>,
                         <0.7632952, 0.593843, 2.13724>, <-0.1049028, 0.0004874045, -0.001301509>,
                         <0.7648264, 0.5047527, 1.89267>, <-0.1234942, 0.001126645, -0.0004343934> }
        smooth_triangle {<0.7648264, 0.5047527, 1.89267>, <-0.1242884, 0.001311057, -0.0005310013>,
                         <0.7576108, 0.01741816, 1.89934>, <-0.1293811, 0.001909683, -0.0004365035>,
                         <0.7577866, 0.1430467, 2.15755>, <-0.1193664, 0.001590235, -0.00100093> }
        smooth_triangle {<0.7632952, 0.593843, 2.13724>, <-0.1049028, 0.0004874045, -0.001301509>,
                         <0.7620111, 1.04454, 2.11695>, <-0.09733133, -0.004630132, -0.001549791>,
                         <0.7652493, 0.9919852, 1.886>, <-0.116861, -0.004626594, -0.0005545738> }
        smooth_triangle {<0.7652493, 0.9919852, 1.886>, <-0.1175854, -0.003446643, -0.0006118641>,
                         <0.7648264, 0.5047527, 1.89267>, <-0.1225603, 0.0008682865, -0.0005217288>,
                         <0.7632952, 0.593843, 2.13724>, <-0.1086167, 0.0003888562, -0.001172065> }
        smooth_triangle {<0.7620111, 1.04454, 2.11695>, <-0.09733133, -0.004630132, -0.001549791>,
                         <0.7053204, 1.48869, 2.09704>, <-0.0895772, -0.01131505, -0.002449702>,
                         <0.7102656, 1.47267, 1.87946>, <-0.1100329, -0.01207396, -0.0005996603> }
        smooth_triangle {<0.7102656, 1.47267, 1.87946>, <-0.1103637, -0.01223532, -0.0001165107>,
                         <0.7652493, 0.9919852, 1.886>, <-0.1154848, -0.0066498, -8.26958e-005>,
                         <0.7620111, 1.04454, 2.11695>, <-0.1008376, -0.006652453, -0.0008291089> }
        smooth_triangle {<0.7053204, 1.48869, 2.09704>, <-0.0895772, -0.01131505, -0.002449702>,
                         <0.6606017, 1.93501, 2.077>, <-0.08313385, -0.005111194, -0.004108027>,
                         <0.6672539, 1.95554, 1.87288>, <-0.1046586, -0.005032514, -0.00141849> }
        smooth_triangle {<0.6672539, 1.95554, 1.87288>, <-0.1047854, -0.006122124, -0.001488639>,
                         <0.7102656, 1.47267, 1.87946>, <-0.1088162, -0.01140321, -0.0008745169>,
                         <0.7053204, 1.48869, 2.09704>, <-0.09347442, -0.01083403, -0.002262048> }
        smooth_triangle {<0.6606017, 1.93501, 2.077>, <-0.08313385, -0.005111194, -0.004108027>,
                         <0.6781763, 2.38522, 2.05673>, <-0.0764503, 0.003424676, -0.003090053>,
                         <0.6865355, 2.44228, 1.86622>, <-0.09902011, 0.00474128, -0.0009244255> }
        smooth_triangle {<0.6865355, 2.44228, 1.86622>, <-0.09907003, 0.004528842, -0.00140387>,
                         <0.6672539, 1.95554, 1.87288>, <-0.1032989, -0.002801503, -0.001774419>,
                         <0.6606017, 1.93501, 2.077>, <-0.08715533, -0.002860513, -0.003791571> }
        smooth_triangle {<0.6781763, 2.38522, 2.05673>, <-0.0764503, 0.003424676, -0.003090053>,
                         <0.7080467, 2.8338, 2.03656>, <-0.06437411, -0.005793478, -0.009957413>,
                         <0.7181129, 2.9274, 1.85959>, <-0.08640863, -0.006537233, -0.001150392> }
        smooth_triangle {<0.7181129, 2.9274, 1.85959>, <-0.08781759, -0.003412783, -0.00142613>,
                         <0.6865355, 2.44228, 1.86622>, <-0.0972762, 0.005046102, -0.001256656>,
                         <0.6781763, 2.38522, 2.05673>, <-0.08034885, 0.004058649, -0.002880877> }
        smooth_triangle {<0.7080467, 2.8338, 2.03656>, <-0.06437411, -0.005793478, -0.009957413>,
                         <0.5533254, 3.18, 2.02251>, <-0.04821388, -0.02477091, -0.02730305>,
                         <0.5650987, 3.31014, 1.855>, <-0.06734235, -0.02874794, -0.01299496> }
        smooth_triangle {<0.5650987, 3.31014, 1.855>, <-0.06732966, -0.02820705, -0.01472163>,
                         <0.7181129, 2.9274, 1.85959>, <-0.08163255, -0.01168424, -0.005406538>,
                         <0.7080467, 2.8338, 2.03656>, <-0.06510666, -0.01112643, -0.0120118> }
        smooth_triangle {<0.7581067, 0.2937667, 2.40259>, <-0.09749407, 0.0005083313, -0.001331525>,
                         <0.7607103, 0.700974, 2.36741>, <-0.09164679, -0.0002988237, -0.001429917>,
                         <0.7632952, 0.593843, 2.13724>, <-0.1049028, 0.0004874045, -0.001301509> }
        smooth_triangle {<0.7632952, 0.593843, 2.13724>, <-0.1070575, 0.000704632, -0.001147616>,
                         <0.7577866, 0.1430467, 2.15755>, <-0.1127918, 0.001336245, -0.0009334857>,
                         <0.7581067, 0.2937667, 2.40259>, <-0.1055079, 0.000932323, -0.001008731> }
        smooth_triangle {<0.7607103, 0.700974, 2.36741>, <-0.09164679, -0.0002988237, -0.001429917>,
                         <0.7565211, 1.10808, 2.33225>, <-0.08355729, -0.005081796, -0.001972245>,
                         <0.7620111, 1.04454, 2.11695>, <-0.09733133, -0.004630132, -0.001549791> }
        smooth_triangle {<0.7620111, 1.04454, 2.11695>, <-0.09947597, -0.003559608, -0.001419205>,
                         <0.7632952, 0.593843, 2.13724>, <-0.1051546, 0.0002785447, -0.001232993>,
                         <0.7607103, 0.700974, 2.36741>, <-0.09521257, -0.0003111264, -0.0013293> }
        smooth_triangle {<0.7565211, 1.10808, 2.33225>, <-0.08355729, -0.005081796, -0.001972245>,
                         <0.6969253, 1.50864, 2.29774>, <-0.07528027, -0.01143496, -0.003320519>,
                         <0.7053204, 1.48869, 2.09704>, <-0.0895772, -0.01131505, -0.002449702> }
        smooth_triangle {<0.7053204, 1.48869, 2.09704>, <-0.09140585, -0.01156504, -0.001546316>,
                         <0.7620111, 1.04454, 2.11695>, <-0.09722145, -0.006551349, -0.0008713829>,
                         <0.7565211, 1.10808, 2.33225>, <-0.08689092, -0.006890096, -0.001188223> }
        smooth_triangle {<0.6969253, 1.50864, 2.29774>, <-0.07528027, -0.01143496, -0.003320519>,
                         <0.6493015, 1.91138, 2.26301>, <-0.06825227, -0.005697323, -0.005443292>,
                         <0.6606017, 1.93501, 2.077>, <-0.08313385, -0.005111194, -0.004108027> }
        smooth_triangle {<0.6606017, 1.93501, 2.077>, <-0.08484475, -0.00611921, -0.003794695>,
                         <0.7053204, 1.48869, 2.09704>, <-0.08967726, -0.0107721, -0.002550951>,
                         <0.6969253, 1.50864, 2.29774>, <-0.07895457, -0.01086203, -0.003204063> }
        smooth_triangle {<0.6493015, 1.91138, 2.26301>, <-0.06825227, -0.005697323, -0.005443292>,
                         <0.663971, 2.31799, 2.2279>, <-0.06100045, 0.002231031, -0.004598931>,
                         <0.6781763, 2.38522, 2.05673>, <-0.0764503, 0.003424676, -0.003090053> }
        smooth_triangle {<0.6781763, 2.38522, 2.05673>, <-0.07815372, 0.003328507, -0.003485552>,
                         <0.6606017, 1.93501, 2.077>, <-0.08316638, -0.003073395, -0.004249032>,
                         <0.6493015, 1.91138, 2.26301>, <-0.07200519, -0.003512992, -0.00525048> }
        smooth_triangle {<0.663971, 2.31799, 2.2279>, <-0.06100045, 0.002231031, -0.004598931>,
                         <0.6909363, 2.72299, 2.19295>, <-0.04933995, -0.005755611, -0.01288066>,
                         <0.7080467, 2.8338, 2.03656>, <-0.06437411, -0.005793478, -0.009957413> }
        smooth_triangle {<0.7080467, 2.8338, 2.03656>, <-0.06713694, -0.003138555, -0.008559109>,
                         <0.6781763, 2.38522, 2.05673>, <-0.07619408, 0.003775061, -0.003408589>,
                         <0.663971, 2.31799, 2.2279>, <-0.06460669, 0.002879827, -0.004540247> }
        smooth_triangle {<0.6909363, 2.72299, 2.19295>, <-0.04933995, -0.005755611, -0.01288066>,
                         <0.5333099, 3.0256, 2.1682>, <-0.03516002, -0.02333098, -0.03101826>,
                         <0.5533254, 3.18, 2.02251>, <-0.04821388, -0.02477091, -0.02730305> }
        smooth_triangle {<0.5533254, 3.18, 2.02251>, <-0.04967043, -0.02465943, -0.02589169>,
                         <0.7080467, 2.8338, 2.03656>, <-0.06142647, -0.01045423, -0.0132353>,
                         <0.6909363, 2.72299, 2.19295>, <-0.05015085, -0.01042583, -0.01542774> }
        smooth_triangle {<0.7584703, 0.4497867, 2.6443>, <-0.08756082, -0.0003098046, -0.0009893963>,
                         <0.75776, 0.8118369, 2.59379>, <-0.08363308, -0.001104796, -0.001381827>,
                         <0.7607103, 0.700974, 2.36741>, <-0.09164679, -0.0002988237, -0.001429917> }
        smooth_triangle {<0.7607103, 0.700974, 2.36741>, <-0.09471445, -6.35899e-005, -0.001136981>,
                         <0.7581067, 0.2937667, 2.40259>, <-0.1007057, 0.0005752215, -0.0007948483>,
                         <0.7584703, 0.4497867, 2.6443>, <-0.09573912, 0.0001661536, -0.0006237837> }
        smooth_triangle {<0.75776, 0.8118369, 2.59379>, <-0.08363308, -0.001104796, -0.001381827>,
                         <0.7502571, 1.17379, 2.54329>, <-0.07518644, -0.007351567, -0.001942753>,
                         <0.7565211, 1.10808, 2.33225>, <-0.08355729, -0.005081796, -0.001972245> }
        smooth_triangle {<0.7565211, 1.10808, 2.33225>, <-0.08668265, -0.00407437, -0.001663341>,
                         <0.7607103, 0.700974, 2.36741>, <-0.09274977, -0.0004871412, -0.001256595>,
                         <0.75776, 0.8118369, 2.59379>, <-0.08777496, -0.001087228, -0.001166761> }
        smooth_triangle {<0.7502571, 1.17379, 2.54329>, <-0.07518644, -0.007351567, -0.001942753>,
                         <0.6873475, 1.52919, 2.49371>, <-0.06704691, -0.01132825, -0.003987241>,
                         <0.6969253, 1.50864, 2.29774>, <-0.07528027, -0.01143496, -0.003320519> }
        smooth_triangle {<0.6969253, 1.50864, 2.29774>, <-0.07816114, -0.01177461, -0.002138718>,
                         <0.7565211, 1.10808, 2.33225>, <-0.0843689, -0.007009738, -0.001127512>,
                         <0.7502571, 1.17379, 2.54329>, <-0.07905887, -0.009165566, -0.0008262729> }
        smooth_triangle {<0.6873475, 1.52919, 2.49371>, <-0.06704691, -0.01132825, -0.003987241>,
                         <0.6364099, 1.88677, 2.44382>, <-0.0598639, -0.004395536, -0.0054643>,
                         <0.6493015, 1.91138, 2.26301>, <-0.06825227, -0.005697323, -0.005443292> }
        smooth_triangle {<0.6493015, 1.91138, 2.26301>, <-0.07109877, -0.006689362, -0.004802146>,
                         <0.6969253, 1.50864, 2.29774>, <-0.07636977, -0.01099259, -0.003210066>,
                         <0.6873475, 1.52919, 2.49371>, <-0.07124402, -0.01077399, -0.00361773> }
        smooth_triangle {<0.6364099, 1.88677, 2.44382>, <-0.0598639, -0.004395536, -0.0054643>,
                         <0.6477656, 2.24823, 2.39339>, <-0.05229748, 0.00181782, -0.004685475>,
                         <0.663971, 2.31799, 2.2279>, <-0.06100045, 0.002231031, -0.004598931> }
        smooth_triangle {<0.663971, 2.31799, 2.2279>, <-0.06391446, 0.002223202, -0.004669437>,
                         <0.6493015, 1.91138, 2.26301>, <-0.06935333, -0.003723064, -0.005302707>,
                         <0.6364099, 1.88677, 2.44382>, <-0.0641281, -0.002197119, -0.005269852> }
        smooth_triangle {<0.6477656, 2.24823, 2.39339>, <-0.05229748, 0.00181782, -0.004685475>,
                         <0.6714172, 2.60807, 2.34319>, <-0.03917432, -0.01031454, -0.01797357>,
                         <0.6909363, 2.72299, 2.19295>, <-0.04933995, -0.005755611, -0.01288066> }
        smooth_triangle {<0.6909363, 2.72299, 2.19295>, <-0.05315133, -0.003342662, -0.01083095>,
                         <0.663971, 2.31799, 2.2279>, <-0.0618967, 0.00264732, -0.004619648>,
                         <0.6477656, 2.24823, 2.39339>, <-0.05639347, 0.002510609, -0.004684251> }
        smooth_triangle {<0.6714172, 2.60807, 2.34319>, <-0.03917432, -0.01031454, -0.01797357>,
                         <0.5104771, 2.86552, 2.30727>, <-0.03005519, -0.02320265, -0.03164156>,
                         <0.5333099, 3.0256, 2.1682>, <-0.03516002, -0.02333098, -0.03101826> }
        smooth_triangle {<0.5333099, 3.0256, 2.1682>, <-0.03764704, -0.02360912, -0.02868599>,
                         <0.6909363, 2.72299, 2.19295>, <-0.04766023, -0.01035805, -0.01566586>,
                         <0.6714172, 2.60807, 2.34319>, <-0.04032324, -0.01493149, -0.01998953> }
    }
    union { // Poly_Mesh
        smooth_triangle {<0.5710761, 0.617407, 0.8990452>, <0.04144279, 0.04330107, 0.03041172>,
                         <0.5706991, 0.4554567, 1.13015>, <0.03362446, 0.04717165, 0.03254815>,
                         <0.7580933, 0.2878365, 1.11344>, <0.04144279, 0.04330107, 0.03041172> }
        smooth_triangle {<0.7580933, 0.2878365, 1.11344>, <0.04254383, 0.04392586, 0.03041172>,
                         <0.7584703, 0.4497867, 0.8756594>, <0.04364487, 0.04455065, 0.03041172>,
                         <0.5710761, 0.617407, 0.8990452>, <0.04254383, 0.04392586, 0.03041172> }
        smooth_triangle {<0.5706991, 0.4554567, 1.13015>, <0.03362446, 0.04717165, 0.03254815>,
                         <0.5703755, 0.3014738, 1.36643>, <0.03406486, 0.04898108, 0.02935446>,
                         <0.7577697, 0.1338536, 1.35641>, <0.04114969, 0.04427547, 0.02890974> }
        smooth_triangle {<0.7577697, 0.1338536, 1.35641>, <0.04222411, 0.04490044, 0.02890974>,
                         <0.7580933, 0.2878365, 1.11344>, <0.04237066, 0.04441324, 0.02966073>,
                         <0.5706991, 0.4554567, 1.13015>, <0.03604298, 0.04676009, 0.03163855> }
        smooth_triangle {<0.5703755, 0.3014738, 1.36643>, <0.03406486, 0.04898108, 0.02935446>,
                         <0.5702132, 0.1803848, 1.61993>, <0.03603852, 0.0528241, 0.01683027>,
                         <0.7576073, 0.01276457, 1.61659>, <0.04289487, 0.04750231, 0.02271857> }
        smooth_triangle {<0.7576073, 0.01276457, 1.61659>, <0.0438594, 0.04812782, 0.02271857>,
                         <0.7577697, 0.1338536, 1.35641>, <0.04298681, 0.0465144, 0.02581416>,
                         <0.5703755, 0.3014738, 1.36643>, <0.03675463, 0.04892414, 0.02769549> }
        smooth_triangle {<0.5702132, 0.1803848, 1.61993>, <0.03603852, 0.0528241, 0.01683027>,
                         <0.5702167, 0.1850384, 1.896>, <0.03671898, 0.05448098, -0.008514935>,
                         <0.7576108, 0.01741816, 1.89934>, <0.04629146, 0.051735, -0.0008726356> }
        smooth_triangle {<0.7576108, 0.01741816, 1.89934>, <0.0468359, 0.05236106, -0.0008726356>,
                         <0.7576073, 0.01276457, 1.61659>, <0.04513761, 0.05024472, 0.01092297>,
                         <0.5702132, 0.1803848, 1.61993>, <0.03887398, 0.05286486, 0.01240454> }
        smooth_triangle {<0.5702167, 0.1850384, 1.896>, <0.03671898, 0.05448098, -0.008514935>,
                         <0.5703924, 0.310667, 2.14753>, <0.03501798, 0.05018752, -0.02719618>,
                         <0.7577866, 0.1430467, 2.15755>, <0.04341968, 0.04713243, -0.02357152> }
        smooth_triangle {<0.7577866, 0.1430467, 2.15755>, <0.04355997, 0.04775907, -0.02357152>,
                         <0.7576108, 0.01741816, 1.89934>, <0.04499586, 0.05006035, -0.01222208>,
                         <0.5702167, 0.1850384, 1.896>, <0.0384643, 0.05295716, -0.01227908> }
        smooth_triangle {<0.5703924, 0.310667, 2.14753>, <0.03501798, 0.05018752, -0.02719618>,
                         <0.5707126, 0.461387, 2.38588>, <0.03475207, 0.04811684, -0.03108637>,
                         <0.7581067, 0.2937667, 2.40259>, <0.04247068, 0.04466088, -0.02829771> }
        smooth_triangle {<0.7581067, 0.2937667, 2.40259>, <0.04252714, 0.045288, -0.02829771>,
                         <0.7577866, 0.1430467, 2.15755>, <0.04300164, 0.04652378, -0.02593462>,
                         <0.5703924, 0.310667, 2.14753>, <0.03690938, 0.04911942, -0.02747156> }
        smooth_triangle {<0.5707126, 0.461387, 2.38588>, <0.03475207, 0.04811684, -0.03108637>,
                         <0.5710761, 0.617407, 2.62092>, <0.03102113, 0.04945194, -0.03310894>,
                         <0.7584703, 0.4497867, 2.6443>, <0.04304568, 0.04403613, -0.02929817> }
        smooth_triangle {<0.7584703, 0.4497867, 2.6443>, <0.04308443, 0.0446634, -0.02929817>,
                         <0.7581067, 0.2937667, 2.40259>, <0.04279693, 0.04497577, -0.02879794>,
                         <0.5707126, 0.461387, 2.38588>, <0.03684485, 0.0474103, -0.03063932> }
        smooth_triangle {<0.334616, 0.6922493, 0.9094869>, <0.01828089, 0.05393842, 0.038323>,
                         <0.334239, 0.530299, 1.13761>, <0.01251926, 0.0555561, 0.03855331>,
                         <0.5706991, 0.4554567, 1.13015>, <0.03362446, 0.04717165, 0.03254815> }
        smooth_triangle {<0.5706991, 0.4554567, 1.13015>, <0.02996518, 0.04903942, 0.03399186>,
                         <0.5710761, 0.617407, 0.8990452>, <0.03021506, 0.0489719, 0.03436736>,
                         <0.334616, 0.6922493, 0.9094869>, <0.01863411, 0.05429058, 0.038323> }
        smooth_triangle {<0.334239, 0.530299, 1.13761>, <0.01251926, 0.0555561, 0.03855331>,
                         <0.3339153, 0.3763161, 1.37091>, <0.01273269, 0.05775801, 0.03465647>,
                         <0.5703755, 0.3014738, 1.36643>, <0.03406486, 0.04898108, 0.02935446> }
        smooth_triangle {<0.5703755, 0.3014738, 1.36643>, <0.03025682, 0.0507033, 0.03112461>,
                         <0.5706991, 0.4554567, 1.13015>, <0.02992652, 0.04934622, 0.03351988>,
                         <0.334239, 0.530299, 1.13761>, <0.01409762, 0.05563456, 0.03802374> }
        smooth_triangle {<0.3339153, 0.3763161, 1.37091>, <0.01273269, 0.05775801, 0.03465647>,
                         <0.333753, 0.2552271, 1.62142>, <0.01351398, 0.06234309, 0.01937523>,
                         <0.5702132, 0.1803848, 1.61993>, <0.03603852, 0.0528241, 0.01683027> }
        smooth_triangle {<0.5702132, 0.1803848, 1.61993>, <0.03190734, 0.05460307, 0.01978392>,
                         <0.5703755, 0.3014738, 1.36643>, <0.03042709, 0.0517208, 0.02917706>,
                         <0.3339153, 0.3763161, 1.37091>, <0.01442796, 0.0583035, 0.03315357> }
        smooth_triangle {<0.333753, 0.2552271, 1.62142>, <0.01351398, 0.06234309, 0.01937523>,
                         <0.3337565, 0.2598807, 1.89451>, <0.01362327, 0.06408905, -0.01066507>,
                         <0.5702167, 0.1850384, 1.896>, <0.03671898, 0.05448098, -0.008514935> }
        smooth_triangle {<0.5702167, 0.1850384, 1.896>, <0.03270304, 0.05718098, -0.006661363>,
                         <0.5702132, 0.1803848, 1.61993>, <0.0321927, 0.05593832, 0.01234754>,
                         <0.333753, 0.2552271, 1.62142>, <0.01529929, 0.06307756, 0.01425626> }
        smooth_triangle {<0.3337565, 0.2598807, 1.89451>, <0.01362327, 0.06408905, -0.01066507>,
                         <0.3339323, 0.3855093, 2.14305>, <0.01302825, 0.05904822, -0.03237018>,
                         <0.5703924, 0.310667, 2.14753>, <0.03501798, 0.05018752, -0.02719618> }
        smooth_triangle {<0.5703924, 0.310667, 2.14753>, <0.0310165, 0.05250945, -0.02782696>,
                         <0.5702167, 0.1850384, 1.896>, <0.03229225, 0.05572954, -0.01381603>,
                         <0.3337565, 0.2598807, 1.89451>, <0.01497047, 0.06293559, -0.01542863> }
        smooth_triangle {<0.3339323, 0.3855093, 2.14305>, <0.01302825, 0.05904822, -0.03237018>,
                         <0.3342524, 0.5362293, 2.37842>, <0.01296387, 0.056639, -0.0368828>,
                         <0.5707126, 0.461387, 2.38588>, <0.03475207, 0.04811684, -0.03108637> }
        smooth_triangle {<0.5707126, 0.461387, 2.38588>, <0.03069242, 0.0501776, -0.03223059>,
                         <0.5703924, 0.310667, 2.14753>, <0.03089185, 0.05173062, -0.02931295>,
                         <0.3339323, 0.3855093, 2.14305>, <0.01439955, 0.05837614, -0.03319345> }
        smooth_triangle {<0.3342524, 0.5362293, 2.37842>, <0.01296387, 0.056639, -0.0368828>,
                         <0.334616, 0.6922493, 2.61048>, <0.0100838, 0.05671286, -0.03816193>,
                         <0.5710761, 0.617407, 2.62092>, <0.03102113, 0.04945194, -0.03310894> }
        smooth_triangle {<0.5710761, 0.617407, 2.62092>, <0.02693222, 0.05149272, -0.0343792>,
                         <0.5707126, 0.461387, 2.38588>, <0.03075265, 0.0499812, -0.03254471>,
                         <0.3342524, 0.5362293, 2.37842>, <0.0144115, 0.05637282, -0.03689203> }
        smooth_triangle {<0.08206846, 0.6968662, 0.9101311>, <0.001126879, 0.05756442, 0.04090187>,
                         <0.08169145, 0.534916, 1.13807>, <0.0007485615, 0.05800689, 0.04023478>,
                         <0.334239, 0.530299, 1.13761>, <0.01251926, 0.0555561, 0.03855331> }
        smooth_triangle {<0.334239, 0.530299, 1.13761>, <0.009678831, 0.05606978, 0.03914045>,
                         <0.334616, 0.6922493, 0.9094869>, <0.009719212, 0.05577462, 0.03961243>,
                         <0.08206846, 0.6968662, 0.9101311>, <0.001142206, 0.05758762, 0.04090187> }
        smooth_triangle {<0.08169145, 0.534916, 1.13807>, <0.0007485615, 0.05800689, 0.04023478>,
                         <0.08136784, 0.380933, 1.37119>, <0.0007618936, 0.06032816, 0.03612373>,
                         <0.3339153, 0.3763161, 1.37091>, <0.01273269, 0.05775801, 0.03465647> }
        smooth_triangle {<0.3339153, 0.3763161, 1.37091>, <0.009836517, 0.0580485, 0.03571473>,
                         <0.334239, 0.530299, 1.13761>, <0.009676446, 0.05639707, 0.03863736>,
                         <0.08169145, 0.534916, 1.13807>, <0.0008484197, 0.05823516, 0.03989846> }
        smooth_triangle {<0.08136784, 0.380933, 1.37119>, <0.0007618936, 0.06032816, 0.03612373>,
                         <0.08120552, 0.259844, 1.62151>, <0.0008091022, 0.06512659, 0.01999884>,
                         <0.333753, 0.2552271, 1.62142>, <0.01351398, 0.06234309, 0.01937523> }
        smooth_triangle {<0.333753, 0.2552271, 1.62142>, <0.01043299, 0.06257362, 0.02217679>,
                         <0.3339153, 0.3763161, 1.37091>, <0.00984702, 0.05913481, 0.03363772>,
                         <0.08136784, 0.380933, 1.37119>, <0.0008689227, 0.06106242, 0.03473817> }
        smooth_triangle {<0.08120552, 0.259844, 1.62151>, <0.0008091022, 0.06512659, 0.01999884>,
                         <0.08120898, 0.2644976, 1.89442>, <0.000813921, 0.06686276, -0.01135963>,
                         <0.3337565, 0.2598807, 1.89451>, <0.01362327, 0.06408905, -0.01066507> }
        smooth_triangle {<0.3337565, 0.2598807, 1.89451>, <0.01053256, 0.065309, -0.008292623>,
                         <0.333753, 0.2552271, 1.62142>, <0.01045059, 0.06399953, 0.01423761>,
                         <0.08120552, 0.259844, 1.62151>, <0.0009219327, 0.06608715, 0.01470532> }
        smooth_triangle {<0.08120898, 0.2644976, 1.89442>, <0.000813921, 0.06686276, -0.01135963>,
                         <0.08138476, 0.3901262, 2.14278>, <0.0007788413, 0.06161976, -0.03384353>,
                         <0.3339323, 0.3855093, 2.14305>, <0.01302825, 0.05904822, -0.03237018> }
        smooth_triangle {<0.3339323, 0.3855093, 2.14305>, <0.01006095, 0.05997826, -0.03220963>,
                         <0.3337565, 0.2598807, 1.89451>, <0.01050722, 0.06375889, -0.0159308>,
                         <0.08120898, 0.2644976, 1.89442>, <0.0009002058, 0.06583917, -0.01645172> }
        smooth_triangle {<0.08138476, 0.3901262, 2.14278>, <0.0007788413, 0.06161976, -0.03384353>,
                         <0.08170492, 0.5408462, 2.37796>, <0.0007754075, 0.05912276, -0.03851517>,
                         <0.3342524, 0.5362293, 2.37842>, <0.01296387, 0.056639, -0.0368828> }
        smooth_triangle {<0.3342524, 0.5362293, 2.37842>, <0.01000498, 0.05733983, -0.03717846>,
                         <0.3339323, 0.3855093, 2.14305>, <0.01005326, 0.05914674, -0.033794>,
                         <0.08138476, 0.3901262, 2.14278>, <0.0008662067, 0.0610754, -0.03489901> }
        smooth_triangle {<0.08170492, 0.5408462, 2.37796>, <0.0007754075, 0.05912276, -0.03851517>,
                         <0.08206845, 0.6968662, 2.60983>, <0.0005855153, 0.05856728, -0.03940949>,
                         <0.334616, 0.6922493, 2.61048>, <0.0100838, 0.05671286, -0.03816193> }
        smooth_triangle {<0.334616, 0.6922493, 2.61048>, <0.007103591, 0.05734341, -0.038576>,
                         <0.3342524, 0.5362293, 2.37842>, <0.01000869, 0.05713038, -0.03751314>,
                         <0.08170492, 0.5408462, 2.37796>, <0.000867347, 0.0589932, -0.03873741> }
        smooth_triangle {<-0.1705584, 0.6968662, 0.9101311>, <5.77887e-011, 0.05758267, 0.04091298>,
                         <-0.1709354, 0.534916, 1.13807>, <-0.0003759102, 0.05802869, 0.0402372>,
                         <0.08169145, 0.534916, 1.13807>, <0.0007485615, 0.05800689, 0.04023478> }
        smooth_triangle {<0.08169145, 0.534916, 1.13807>, <0.0005614211, 0.05790083, 0.04040433>,
                         <0.08206846, 0.6968662, 0.9101311>, <0.0005634394, 0.05757355, 0.04090742>,
                         <-0.1705584, 0.6968662, 0.9101311>, <6.26085e-011, 0.05758267, 0.04091298> }
        smooth_triangle {<-0.1709354, 0.534916, 1.13807>, <-0.0003759102, 0.05802869, 0.0402372>,
                         <-0.171259, 0.380933, 1.37119>, <-0.0003732191, 0.06035034, 0.03612569>,
                         <0.08136784, 0.380933, 1.37119>, <0.0007618936, 0.06032816, 0.03612373> }
        smooth_triangle {<0.08136784, 0.380933, 1.37119>, <0.0005714202, 0.05996916, 0.03681785>,
                         <0.08169145, 0.534916, 1.13807>, <0.0005614211, 0.0582282, 0.03990114>,
                         <-0.1709354, 0.534916, 1.13807>, <-0.0002819326, 0.05824456, 0.03990295> }
        smooth_triangle {<-0.171259, 0.380933, 1.37119>, <-0.0003732191, 0.06035034, 0.03612569>,
                         <-0.1714213, 0.259844, 1.62151>, <-0.000389242, 0.06514931, 0.01999823>,
                         <0.08120552, 0.259844, 1.62151>, <0.0008091022, 0.06512659, 0.01999884> }
        smooth_triangle {<0.08120552, 0.259844, 1.62151>, <0.0006068267, 0.0646546, 0.02264671>,
                         <0.08136784, 0.380933, 1.37119>, <0.0005714203, 0.06105578, 0.03474038>,
                         <-0.171259, 0.380933, 1.37119>, <-0.0002799143, 0.06107241, 0.03474185> }
        smooth_triangle {<-0.1714213, 0.259844, 1.62151>, <-0.000389242, 0.06514931, 0.01999823>,
                         <-0.1714179, 0.2644976, 1.89442>, <-0.000420427, 0.06688484, -0.01136267>,
                         <0.08120898, 0.2644976, 1.89442>, <0.000813921, 0.06686276, -0.01135963> }
        smooth_triangle {<0.08120898, 0.2644976, 1.89442>, <0.0006104409, 0.06738307, -0.008813626>,
                         <0.08120552, 0.259844, 1.62151>, <0.0006068268, 0.06608095, 0.01470523>,
                         <-0.1714213, 0.259844, 1.62151>, <-0.0002919314, 0.06609799, 0.01470476> }
        smooth_triangle {<-0.1714179, 0.2644976, 1.89442>, <-0.000420427, 0.06688484, -0.01136267>,
                         <-0.1712421, 0.3901262, 2.14278>, <-0.0003940599, 0.06164156, -0.03384648>,
                         <0.08138476, 0.3901262, 2.14278>, <0.0007788413, 0.06161976, -0.03384353> }
        smooth_triangle {<0.08138476, 0.3901262, 2.14278>, <0.0005841312, 0.06190023, -0.03331693>,
                         <0.08120898, 0.2644976, 1.89442>, <0.000610441, 0.06583248, -0.01645401>,
                         <-0.1714179, 0.2644976, 1.89442>, <-0.00031532, 0.06584904, -0.01645629> }
        smooth_triangle {<-0.1712421, 0.3901262, 2.14278>, <-0.0003940599, 0.06164156, -0.03384648>,
                         <-0.1709219, 0.5408462, 2.37796>, <-0.0003853467, 0.05914456, -0.03851775>,
                         <0.08170492, 0.5408462, 2.37796>, <0.0007754075, 0.05912276, -0.03851517> }
        smooth_triangle {<0.08170492, 0.5408462, 2.37796>, <0.0005815558, 0.05919571, -0.03840536>,
                         <0.08138476, 0.3901262, 2.14278>, <0.0005841312, 0.06106846, -0.03490163>,
                         <-0.1712421, 0.3901262, 2.14278>, <-0.0002955447, 0.06108481, -0.03490384> }
        smooth_triangle {<-0.1709219, 0.5408462, 2.37796>, <-0.0003853467, 0.05914456, -0.03851775>,
                         <-0.1705584, 0.6968662, 2.60983>, <-0.0005859395, 0.05859075, -0.03940781>,
                         <0.08206845, 0.6968662, 2.60983>, <0.0005855153, 0.05856728, -0.03940949> }
        smooth_triangle {<0.08206845, 0.6968662, 2.60983>, <0.0003903439, 0.05857038, -0.03941127>,
                         <0.08170492, 0.5408462, 2.37796>, <0.0005815558, 0.05898622, -0.03874009>,
                         <-0.1709219, 0.5408462, 2.37796>, <-0.0002890098, 0.05900257, -0.03874202> }
        smooth_triangle {<-0.4231059, 0.6922493, 0.9094869>, <-0.001127731, 0.05761124, 0.04089839>,
                         <-0.4234829, 0.530299, 1.13761>, <-0.006917186, 0.05706032, 0.03935049>,
                         <-0.1709354, 0.534916, 1.13807>, <-0.0003759102, 0.05802869, 0.0402372> }
        smooth_triangle {<-0.1709354, 0.534916, 1.13807>, <-0.0005711042, 0.05791273, 0.04040249>,
                         <-0.1705584, 0.6968662, 0.9101311>, <-0.0005783432, 0.05757375, 0.04090568>,
                         <-0.4231059, 0.6922493, 0.9094869>, <-0.001142209, 0.05758804, 0.04089839> }
        smooth_triangle {<-0.4234829, 0.530299, 1.13761>, <-0.006917186, 0.05706032, 0.03935049>,
                         <-0.4238065, 0.3763161, 1.37091>, <-0.006886896, 0.0593531, 0.03528437>,
                         <-0.171259, 0.380933, 1.37119>, <-0.0003732191, 0.06035034, 0.03612569> }
        smooth_triangle {<-0.171259, 0.380933, 1.37119>, <-0.0005667011, 0.0599812, 0.03681589>,
                         <-0.1709354, 0.534916, 1.13807>, <-0.0005687194, 0.05823997, 0.03989953>,
                         <-0.4234829, 0.530299, 1.13761>, <-0.005474677, 0.05751369, 0.0392345> }
        smooth_triangle {<-0.4238065, 0.3763161, 1.37091>, <-0.006886896, 0.0593531, 0.03528437>,
                         <-0.4239688, 0.2552271, 1.62142>, <-0.007193844, 0.06405835, 0.01934177>,
                         <-0.1714213, 0.259844, 1.62151>, <-0.000389242, 0.06514931, 0.01999823> }
        smooth_triangle {<-0.1714213, 0.259844, 1.62151>, <-0.0005892221, 0.06466669, 0.02264366>,
                         <-0.171259, 0.380933, 1.37119>, <-0.0005772049, 0.06106746, 0.03473926>,
                         <-0.4238065, 0.3763161, 1.37091>, <-0.005462463, 0.06031953, 0.03410827> }
        smooth_triangle {<-0.4239688, 0.2552271, 1.62142>, <-0.007193844, 0.06405835, 0.01934177>,
                         <-0.4239654, 0.2598807, 1.89451>, <-0.007704186, 0.06567276, -0.01133391>,
                         <-0.1714179, 0.2644976, 1.89442>, <-0.000420427, 0.06688484, -0.01136267> }
        smooth_triangle {<-0.1714179, 0.2644976, 1.89442>, <-0.0006302143, 0.06739422, -0.00881581>,
                         <-0.1714213, 0.259844, 1.62151>, <-0.0006068256, 0.06609257, 0.01470486>,
                         <-0.4239688, 0.2552271, 1.62142>, <-0.005710277, 0.06527435, 0.01421252> }
        smooth_triangle {<-0.4239654, 0.2598807, 1.89451>, <-0.007704186, 0.06567276, -0.01133391>,
                         <-0.4237896, 0.3855092, 2.14305>, <-0.007241692, 0.06056243, -0.03316062>,
                         <-0.1712421, 0.3901262, 2.14278>, <-0.0003940599, 0.06164156, -0.03384648> }
        smooth_triangle {<-0.1712421, 0.3901262, 2.14278>, <-0.0005850977, 0.06191165, -0.03331645>,
                         <-0.1714179, 0.2644976, 1.89442>, <-0.000604873, 0.06584411, -0.01645359>,
                         <-0.4239654, 0.2598807, 1.89451>, <-0.006067693, 0.06493506, -0.01643203> }
        smooth_triangle {<-0.4237896, 0.3855092, 2.14305>, <-0.007241692, 0.06056243, -0.03316062>,
                         <-0.4234694, 0.5362293, 2.37842>, <-0.007097014, 0.05813706, -0.03769286>,
                         <-0.1709219, 0.5408462, 2.37796>, <-0.0003853467, 0.05914456, -0.03851775> }
        smooth_triangle {<-0.1709219, 0.5408462, 2.37796>, <-0.0005708735, 0.05920742, -0.03840393>,
                         <-0.1712421, 0.3901262, 2.14278>, <-0.0005774084, 0.06108017, -0.03490048>,
                         <-0.4237896, 0.3855092, 2.14305>, <-0.005713132, 0.06027082, -0.03438608> }
        smooth_triangle {<-0.4234694, 0.5362293, 2.37842>, <-0.007097014, 0.05813706, -0.03769286>,
                         <-0.4231059, 0.6922493, 2.61048>, <-0.01019587, 0.05709285, -0.03813304>,
                         <-0.1705584, 0.6968662, 2.60983>, <-0.0005859395, 0.05859075, -0.03940781> }
        smooth_triangle {<-0.1705584, 0.6968662, 2.60983>, <-0.0007713984, 0.05857996, -0.03940547>,
                         <-0.1709219, 0.5408462, 2.37796>, <-0.0005745891, 0.05899801, -0.03873851>,
                         <-0.4234694, 0.5362293, 2.37842>, <-0.00560834, 0.05824238, -0.03811984> }
        smooth_triangle {<-0.6595661, 0.617407, 0.8990452>, <-0.01850417, 0.05464949, 0.03826657>,
                         <-0.6599431, 0.4554567, 1.13015>, <-0.02648008, 0.05169635, 0.0349795>,
                         <-0.4234829, 0.530299, 1.13761>, <-0.006917186, 0.05706032, 0.03935049> }
        smooth_triangle {<-0.4234829, 0.530299, 1.13761>, <-0.009878901, 0.05628153, 0.03907951>,
                         <-0.4231059, 0.6922493, 0.9094869>, <-0.009945888, 0.05577821, 0.03958248>,
                         <-0.6595661, 0.617407, 0.8990452>, <-0.01863411, 0.05429733, 0.03826657> }
        smooth_triangle {<-0.6599431, 0.4554567, 1.13015>, <-0.02648008, 0.05169635, 0.0349795>,
                         <-0.6602667, 0.3014738, 1.36643>, <-0.0265985, 0.05378293, 0.03126948>,
                         <-0.4238065, 0.3763161, 1.37091>, <-0.006886896, 0.0593531, 0.03528437> }
        smooth_triangle {<-0.4238065, 0.3763161, 1.37091>, <-0.009817524, 0.05830716, 0.03555993>,
                         <-0.4234829, 0.530299, 1.13761>, <-0.009840242, 0.05658757, 0.03860952>,
                         <-0.6599431, 0.4554567, 1.13015>, <-0.02451241, 0.05256459, 0.03533128> }
        smooth_triangle {<-0.6602667, 0.3014738, 1.36643>, <-0.0265985, 0.05378293, 0.03126948>,
                         <-0.660429, 0.1803848, 1.61993>, <-0.02794549, 0.05799247, 0.0167282>,
                         <-0.4239688, 0.2552271, 1.62142>, <-0.007193844, 0.06405835, 0.01934177> }
        smooth_triangle {<-0.4239688, 0.2552271, 1.62142>, <-0.01021801, 0.06285275, 0.02166147>,
                         <-0.4238065, 0.3763161, 1.37091>, <-0.009987796, 0.05932382, 0.03361842>,
                         <-0.6602667, 0.3014738, 1.36643>, <-0.0247715, 0.05514619, 0.03060725> }
        smooth_triangle {<-0.660429, 0.1803848, 1.61993>, <-0.02794549, 0.05799247, 0.0167282>,
                         <-0.6604256, 0.1850384, 1.896>, <-0.02915579, 0.05924812, -0.01055487>,
                         <-0.4239654, 0.2598807, 1.89451>, <-0.007704186, 0.06567276, -0.01133391> }
        smooth_triangle {<-0.4239654, 0.2598807, 1.89451>, <-0.01088612, 0.06539845, -0.008775466>,
                         <-0.4239688, 0.2552271, 1.62142>, <-0.01050337, 0.06418764, 0.01423129>,
                         <-0.660429, 0.1803848, 1.61993>, <-0.0260671, 0.05963823, 0.01227112> }
        smooth_triangle {<-0.6604256, 0.1850384, 1.896>, <-0.02915579, 0.05924812, -0.01055487>,
                         <-0.6602498, 0.310667, 2.14753>, <-0.02762988, 0.05474269, -0.02960697>,
                         <-0.4237896, 0.3855092, 2.14305>, <-0.007241692, 0.06056243, -0.03316062> }
        smooth_triangle {<-0.4237896, 0.3855092, 2.14305>, <-0.01012846, 0.0601144, -0.03229371>,
                         <-0.4239654, 0.2598807, 1.89451>, <-0.01047533, 0.06394715, -0.01592368>,
                         <-0.6604256, 0.1850384, 1.896>, <-0.02656404, 0.05912867, -0.0153394> }
        smooth_triangle {<-0.6602498, 0.310667, 2.14753>, <-0.02762988, 0.05474269, -0.02960697>,
                         <-0.6599296, 0.461387, 2.38588>, <-0.02725788, 0.05262273, -0.033557>,
                         <-0.4234694, 0.5362293, 2.37842>, <-0.007097014, 0.05813706, -0.03769286> }
        smooth_triangle {<-0.4234694, 0.5362293, 2.37842>, <-0.009895308, 0.05751712, -0.03717348>,
                         <-0.4237896, 0.3855092, 2.14305>, <-0.01000382, 0.05933615, -0.03377429>,
                         <-0.6602498, 0.310667, 2.14753>, <-0.02529496, 0.05497135, -0.03110906> }
        smooth_triangle {<-0.6599296, 0.461387, 2.38588>, <-0.02725788, 0.05262273, -0.033557>,
                         <-0.6595661, 0.617407, 2.62092>, <-0.03169276, 0.05044301, -0.0330208>,
                         <-0.4231059, 0.6922493, 2.61048>, <-0.01019587, 0.05709285, -0.03813304> }
        smooth_triangle {<-0.4231059, 0.6922493, 2.61048>, <-0.01297428, 0.05635332, -0.03771046>,
                         <-0.4234694, 0.5362293, 2.37842>, <-0.009955539, 0.05732136, -0.03748597>,
                         <-0.6599296, 0.461387, 2.38588>, <-0.02507619, 0.05318561, -0.03438408> }
        smooth_triangle {<-0.8469602, 0.4497867, 0.8756594>, <-0.04256277, 0.04456576, 0.03028533>,
                         <-0.8473372, 0.2878365, 1.11344>, <-0.04241622, 0.04504991, 0.02954329>,
                         <-0.6599431, 0.4554567, 1.13015>, <-0.02648008, 0.05169635, 0.0349795> }
        smooth_triangle {<-0.6599431, 0.4554567, 1.13015>, <-0.03049128, 0.04960131, 0.03380596>,
                         <-0.6595661, 0.617407, 0.8990452>, <-0.03051453, 0.04898283, 0.03427595>,
                         <-0.8469602, 0.4497867, 0.8756594>, <-0.04254383, 0.04394097, 0.03028533> }
        smooth_triangle {<-0.8473372, 0.2878365, 1.11344>, <-0.04241622, 0.04504991, 0.02954329>,
                         <-0.8476608, 0.1338536, 1.35641>, <-0.04314226, 0.04714478, 0.02573271>,
                         <-0.6602667, 0.3014738, 1.36643>, <-0.0265985, 0.05378293, 0.03126948> }
        smooth_triangle {<-0.6602667, 0.3014738, 1.36643>, <-0.03049351, 0.05140823, 0.03065242>,
                         <-0.6599431, 0.4554567, 1.13015>, <-0.0304047, 0.04984329, 0.03343494>,
                         <-0.8473372, 0.2878365, 1.11344>, <-0.042337, 0.04479465, 0.02929595> }
        smooth_triangle {<-0.8476608, 0.1338536, 1.35641>, <-0.04314226, 0.04714478, 0.02573271>,
                         <-0.8478232, 0.01276458, 1.61659>, <-0.04571314, 0.05087131, 0.01089634>,
                         <-0.660429, 0.1803848, 1.61993>, <-0.02794549, 0.05799247, 0.0167282> }
        smooth_triangle {<-0.660429, 0.1803848, 1.61993>, <-0.03188511, 0.05537047, 0.01821219>,
                         <-0.6602667, 0.3014738, 1.36643>, <-0.03087486, 0.05221332, 0.02911815>,
                         <-0.8476608, 0.1338536, 1.35641>, <-0.04332949, 0.04726468, 0.02470986> }
        smooth_triangle {<-0.8478232, 0.01276458, 1.61659>, <-0.04571314, 0.05087131, 0.01089634>,
                         <-0.8478197, 0.01741817, 1.89934>, <-0.04597555, 0.05068759, -0.01219203>,
                         <-0.6604256, 0.1850384, 1.896>, <-0.02915579, 0.05924812, -0.01055487> }
        smooth_triangle {<-0.6604256, 0.1850384, 1.896>, <-0.03343194, 0.05736984, -0.008134019>,
                         <-0.660429, 0.1803848, 1.61993>, <-0.03252421, 0.0564281, 0.01232828>,
                         <-0.8478232, 0.01276458, 1.61659>, <-0.04589555, 0.05115921, 0.006973736> }
        smooth_triangle {<-0.8478197, 0.01741817, 1.89934>, <-0.04597555, 0.05068759, -0.01219203>,
                         <-0.8476439, 0.1430467, 2.15755>, <-0.04406516, 0.04715587, -0.02585149>,
                         <-0.6602498, 0.310667, 2.14753>, <-0.02762988, 0.05474269, -0.02960697> }
        smooth_triangle {<-0.6602498, 0.310667, 2.14753>, <-0.03136748, 0.05284071, -0.02808337>,
                         <-0.6604256, 0.1850384, 1.896>, <-0.03251191, 0.05621979, -0.0137943>,
                         <-0.8478197, 0.01741817, 1.89934>, <-0.04484379, 0.04950332, -0.01596555> }
        smooth_triangle {<-0.8476439, 0.1430467, 2.15755>, <-0.04406516, 0.04715587, -0.02585149>,
                         <-0.8473238, 0.2937667, 2.40259>, <-0.04387816, 0.04561446, -0.02868334>,
                         <-0.6599296, 0.461387, 2.38588>, <-0.02725788, 0.05262273, -0.033557> }
        smooth_triangle {<-0.6599296, 0.461387, 2.38588>, <-0.03080931, 0.05063441, -0.03221535>,
                         <-0.6602498, 0.310667, 2.14753>, <-0.03108831, 0.05222437, -0.02925282>,
                         <-0.8476439, 0.1430467, 2.15755>, <-0.04319798, 0.04632706, -0.02663112> }
        smooth_triangle {<-0.8473238, 0.2937667, 2.40259>, <-0.04387816, 0.04561446, -0.02868334>,
                         <-0.8469602, 0.4497867, 2.6443>, <-0.04416566, 0.04530524, -0.0291763>,
                         <-0.6595661, 0.617407, 2.62092>, <-0.03169276, 0.05044301, -0.0330208> }
        smooth_triangle {<-0.6595661, 0.617407, 2.62092>, <-0.03512957, 0.04831225, -0.0317393>,
                         <-0.6599296, 0.461387, 2.38588>, <-0.03094421, 0.05047972, -0.03246183>,
                         <-0.8473238, 0.2937667, 2.40259>, <-0.04325317, 0.04509321, -0.02884766> }
    }
    union { // Poly_Mesh
        smooth_triangle {<0.5710761, 0.617407, 2.62092>, <2.77891e-010, -0.007927357, -0.05682022>,
                         <0.5714972, 0.9222114, 2.57839>, <2.81319e-010, -0.008025155, -0.05752119>,
                         <0.75776, 0.8118369, 2.59379>, <2.77891e-010, -0.007927357, -0.05682022> }
        smooth_triangle {<0.75776, 0.8118369, 2.59379>, <3.04562e-010, -0.008688198, -0.06227363>,
                         <0.7584703, 0.4497867, 2.6443>, <3.31233e-010, -0.009449039, -0.06772704>,
                         <0.5710761, 0.617407, 2.62092>, <3.04562e-010, -0.008688198, -0.06227363> }
        smooth_triangle {<0.5714972, 0.9222114, 2.57839>, <2.81319e-010, -0.008025155, -0.05752119>,
                         <0.5670663, 1.22691, 2.53588>, <2.64463e-010, -0.007544319, -0.05407475>,
                         <0.7502571, 1.17379, 2.54329>, <2.71841e-010, -0.007754783, -0.05558327> }
        smooth_triangle {<0.7502571, 1.17379, 2.54329>, <2.98755e-010, -0.008522549, -0.06108632>,
                         <0.75776, 0.8118369, 2.59379>, <3.0178e-010, -0.008608837, -0.06170479>,
                         <0.5714972, 0.9222114, 2.57839>, <2.92406e-010, -0.008341445, -0.05978824> }
        smooth_triangle {<0.5670663, 1.22691, 2.53588>, <2.64463e-010, -0.007544319, -0.05407475>,
                         <0.5230593, 1.52507, 2.49428>, <2.39396e-010, -0.006829227, -0.04894924>,
                         <0.6873475, 1.52919, 2.49371>, <2.40451e-010, -0.006859317, -0.04916492> }
        smooth_triangle {<0.6873475, 1.52919, 2.49371>, <2.71261e-010, -0.007738225, -0.05546459>,
                         <0.7502571, 1.17379, 2.54329>, <2.86956e-010, -0.008185958, -0.05867377>,
                         <0.5670663, 1.22691, 2.53588>, <2.73865e-010, -0.007812523, -0.05599713> }
        smooth_triangle {<0.5230593, 1.52507, 2.49428>, <2.39396e-010, -0.006829227, -0.04894924>,
                         <0.4876037, 1.82541, 2.45238>, <2.24674e-010, -0.006409243, -0.04593896>,
                         <0.6364099, 1.88677, 2.44382>, <2.29214e-010, -0.00653875, -0.04686722> }
        smooth_triangle {<0.6364099, 1.88677, 2.44382>, <2.58774e-010, -0.007382032, -0.05291153>,
                         <0.6873475, 1.52919, 2.49371>, <2.64393e-010, -0.007542315, -0.05406038>,
                         <0.5230593, 1.52507, 2.49428>, <2.51631e-010, -0.007178248, -0.05145089> }
        smooth_triangle {<0.4876037, 1.82541, 2.45238>, <2.24674e-010, -0.006409243, -0.04593896>,
                         <0.4966434, 2.12962, 2.40994>, <2.149e-010, -0.006130446, -0.04394065>,
                         <0.6477656, 2.24823, 2.39339>, <2.196e-010, -0.006264511, -0.04490158> }
        smooth_triangle {<0.6477656, 2.24823, 2.39339>, <2.39626e-010, -0.006835781, -0.04899622>,
                         <0.6364099, 1.88677, 2.44382>, <2.44433e-010, -0.006972901, -0.04997904>,
                         <0.4876037, 1.82541, 2.45238>, <2.33418e-010, -0.006658695, -0.04772694> }
        smooth_triangle {<0.4966434, 2.12962, 2.40994>, <2.149e-010, -0.006130446, -0.04394065>,
                         <0.5144657, 2.43221, 2.36772>, <2.17925e-010, -0.006216741, -0.04455918>,
                         <0.6714172, 2.60807, 2.34319>, <2.1694e-010, -0.006188642, -0.04435778> }
        smooth_triangle {<0.6714172, 2.60807, 2.34319>, <2.34586e-010, -0.006692026, -0.04796584>,
                         <0.6477656, 2.24823, 2.39339>, <2.35916e-010, -0.00672996, -0.04823774>,
                         <0.4966434, 2.12962, 2.40994>, <2.24233e-010, -0.006396687, -0.04584896> }
        smooth_triangle {<0.5144657, 2.43221, 2.36772>, <2.17925e-010, -0.006216741, -0.04455918>,
                         <0.4004369, 2.63242, 2.33979>, <1.98101e-010, -0.005651215, -0.04050571>,
                         <0.5104771, 2.86552, 2.30727>, <2.37742e-010, -0.006782052, -0.04861111> }
        smooth_triangle {<0.5104771, 2.86552, 2.30727>, <2.86891e-010, -0.008184104, -0.05866047>,
                         <0.6714172, 2.60807, 2.34319>, <2.7649e-010, -0.007887399, -0.05653381>,
                         <0.5144657, 2.43221, 2.36772>, <2.47454e-010, -0.007059094, -0.05059684> }
        smooth_triangle {<0.334616, 0.6922493, 2.61048>, <2.94225e-010, -0.008393324, -0.06016009>,
                         <0.3421616, 0.9535418, 2.57402>, <2.91119e-010, -0.008304709, -0.05952493>,
                         <0.5714972, 0.9222114, 2.57839>, <2.81319e-010, -0.008025155, -0.05752119> }
        smooth_triangle {<0.5714972, 0.9222114, 2.57839>, <2.99151e-010, -0.008533847, -0.0611673>,
                         <0.5710761, 0.617407, 2.62092>, <3.15269e-010, -0.008993641, -0.06446292>,
                         <0.334616, 0.6922493, 2.61048>, <3.23436e-010, -0.009226625, -0.06613286> }
        smooth_triangle {<0.3421616, 0.9535418, 2.57402>, <2.91119e-010, -0.008304709, -0.05952493>,
                         <0.3467961, 1.21473, 2.53758>, <2.76243e-010, -0.007880357, -0.05648333>,
                         <0.5670663, 1.22691, 2.53588>, <2.64463e-010, -0.007544319, -0.05407475> }
        smooth_triangle {<0.5670663, 1.22691, 2.53588>, <2.83617e-010, -0.008090721, -0.05799114>,
                         <0.5714972, 0.9222114, 2.57839>, <2.96259e-010, -0.008451347, -0.06057597>,
                         <0.3421616, 0.9535418, 2.57402>, <3.03609e-010, -0.008661013, -0.06207878> }
        smooth_triangle {<0.3467961, 1.21473, 2.53758>, <2.76243e-010, -0.007880357, -0.05648333>,
                         <0.3276849, 1.46938, 2.50205>, <2.50063e-010, -0.007133536, -0.05113041>,
                         <0.5230593, 1.52507, 2.49428>, <2.39396e-010, -0.006829227, -0.04894924> }
        smooth_triangle {<0.5230593, 1.52507, 2.49428>, <2.60502e-010, -0.007431312, -0.05326475>,
                         <0.5670663, 1.22691, 2.53588>, <2.79302e-010, -0.007967631, -0.05710888>,
                         <0.3467961, 1.21473, 2.53758>, <2.88137e-010, -0.008219659, -0.05891532> }
        smooth_triangle {<0.3276849, 1.46938, 2.50205>, <2.50063e-010, -0.007133536, -0.05113041>,
                         <0.3137046, 1.7262, 2.46622>, <2.33149e-010, -0.006651025, -0.04767196>,
                         <0.4876037, 1.82541, 2.45238>, <2.24674e-010, -0.006409243, -0.04593896> }
        smooth_triangle {<0.4876037, 1.82541, 2.45238>, <2.42663e-010, -0.006922429, -0.04961728>,
                         <0.5230593, 1.52507, 2.49428>, <2.53705e-010, -0.007237417, -0.05187499>,
                         <0.3276849, 1.46938, 2.50205>, <2.61706e-010, -0.007465649, -0.05351087> }
        smooth_triangle {<0.3137046, 1.7262, 2.46622>, <2.33149e-010, -0.006651025, -0.04767196>,
                         <0.3264214, 1.9869, 2.42985>, <2.27018e-010, -0.006476134, -0.04641841>,
                         <0.4966434, 2.12962, 2.40994>, <2.149e-010, -0.006130446, -0.04394065> }
        smooth_triangle {<0.4966434, 2.12962, 2.40994>, <2.24762e-010, -0.00641176, -0.045957>,
                         <0.4876037, 1.82541, 2.45238>, <2.32092e-010, -0.006620858, -0.04745574>,
                         <0.3137046, 1.7262, 2.46622>, <2.38448e-010, -0.006802195, -0.04875549> }
        smooth_triangle {<0.3264214, 1.9869, 2.42985>, <2.27018e-010, -0.006476134, -0.04641841>,
                         <0.3444078, 2.24598, 2.39371>, <2.13141e-010, -0.006080253, -0.04358089>,
                         <0.5144657, 2.43221, 2.36772>, <2.17925e-010, -0.006216741, -0.04455918> }
        smooth_triangle {<0.5144657, 2.43221, 2.36772>, <2.23311e-010, -0.006370373, -0.04566036>,
                         <0.4966434, 2.12962, 2.40994>, <2.21042e-010, -0.006305652, -0.04519646>,
                         <0.3264214, 1.9869, 2.42985>, <2.30131e-010, -0.006564918, -0.04705478> }
        smooth_triangle {<0.3444078, 2.24598, 2.39371>, <2.13141e-010, -0.006080253, -0.04358089>,
                         <0.2832835, 2.40268, 2.37184>, <1.53609e-010, -0.004381992, -0.03140841>,
                         <0.4004369, 2.63242, 2.33979>, <1.98101e-010, -0.005651215, -0.04050571> }
        smooth_triangle {<0.4004369, 2.63242, 2.33979>, <2.22191e-010, -0.006338419, -0.04543133>,
                         <0.5144657, 2.43221, 2.36772>, <2.31037e-010, -0.006590763, -0.04724002>,
                         <0.3444078, 2.24598, 2.39371>, <2.27448e-010, -0.006488397, -0.04650631> }
        smooth_triangle {<0.08206845, 0.6968662, 2.60983>, <2.98033e-010, -0.008501945, -0.06093864>,
                         <0.08639635, 0.9354327, 2.57655>, <3.00664e-010, -0.008577022, -0.06147676>,
                         <0.3421616, 0.9535418, 2.57402>, <2.91119e-010, -0.008304709, -0.05952493> }
        smooth_triangle {<0.3421616, 0.9535418, 2.57402>, <2.99064e-010, -0.008531378, -0.0611496>,
                         <0.334616, 0.6922493, 2.61048>, <3.08563e-010, -0.008802354, -0.06309185>,
                         <0.08206845, 0.6968662, 2.60983>, <3.10467e-010, -0.008856664, -0.06348113> }
        smooth_triangle {<0.08639635, 0.9354327, 2.57655>, <3.00664e-010, -0.008577022, -0.06147676>,
                         <0.08975386, 1.1739, 2.54328>, <2.9604e-010, -0.008445112, -0.06053128>,
                         <0.3467961, 1.21473, 2.53758>, <2.76243e-010, -0.007880357, -0.05648333> }
        smooth_triangle {<0.3467961, 1.21473, 2.53758>, <2.88759e-010, -0.008237387, -0.05904239>,
                         <0.3421616, 0.9535418, 2.57402>, <2.99915e-010, -0.008555652, -0.06132359>,
                         <0.08639635, 0.9354327, 2.57655>, <3.07075e-010, -0.008759886, -0.06278746> }
        smooth_triangle {<0.08975386, 1.1739, 2.54328>, <2.9604e-010, -0.008445112, -0.06053128>,
                         <0.08519615, 1.40582, 2.51092>, <2.78725e-010, -0.007951165, -0.05699086>,
                         <0.3276849, 1.46938, 2.50205>, <2.50063e-010, -0.007133536, -0.05113041> }
        smooth_triangle {<0.3276849, 1.46938, 2.50205>, <2.68532e-010, -0.007660373, -0.05490657>,
                         <0.3467961, 1.21473, 2.53758>, <2.88166e-010, -0.008220489, -0.05892127>,
                         <0.08975386, 1.1739, 2.54328>, <3.03014e-010, -0.008644055, -0.06195723> }
        smooth_triangle {<0.08519615, 1.40582, 2.51092>, <2.78725e-010, -0.007951165, -0.05699086>,
                         <0.08234872, 1.63991, 2.47826>, <2.76584e-010, -0.007890093, -0.05655312>,
                         <0.3137046, 1.7262, 2.46622>, <2.33149e-010, -0.006651025, -0.04767196> }
        smooth_triangle {<0.3137046, 1.7262, 2.46622>, <2.52092e-010, -0.007191412, -0.05154525>,
                         <0.3276849, 1.46938, 2.50205>, <2.64778e-010, -0.007553295, -0.05413908>,
                         <0.08519615, 1.40582, 2.51092>, <2.86274e-010, -0.008166517, -0.05853442> }
        smooth_triangle {<0.08234872, 1.63991, 2.47826>, <2.76584e-010, -0.007890093, -0.05655312>,
                         <0.08840033, 1.87789, 2.44506>, <2.88145e-010, -0.008219889, -0.05891697>,
                         <0.3264214, 1.9869, 2.42985>, <2.27018e-010, -0.006476134, -0.04641841> }
        smooth_triangle {<0.3264214, 1.9869, 2.42985>, <2.42668e-010, -0.006922573, -0.04961831>,
                         <0.3137046, 1.7262, 2.46622>, <2.47266e-010, -0.007053742, -0.05055848>,
                         <0.08234872, 1.63991, 2.47826>, <2.79843e-010, -0.007983042, -0.05721935> }
        smooth_triangle {<0.08840033, 1.87789, 2.44506>, <2.88145e-010, -0.008219889, -0.05891697>,
                         <0.09620849, 2.11424, 2.41209>, <2.51778e-010, -0.007182453, -0.05148103>,
                         <0.3444078, 2.24598, 2.39371>, <2.13141e-010, -0.006080253, -0.04358089> }
        smooth_triangle {<0.3444078, 2.24598, 2.39371>, <2.32856e-010, -0.006642656, -0.04761198>,
                         <0.3264214, 1.9869, 2.42985>, <2.43264e-010, -0.006939566, -0.04974011>,
                         <0.08840033, 1.87789, 2.44506>, <2.89109e-010, -0.008247383, -0.05911404> }
        smooth_triangle {<0.09620849, 2.11424, 2.41209>, <2.51778e-010, -0.007182453, -0.05148103>,
                         <0.07764641, 2.24821, 2.39339>, <1.54244e-010, -0.004400088, -0.03153812>,
                         <0.2832835, 2.40268, 2.37184>, <1.53609e-010, -0.004381992, -0.03140841> }
        smooth_triangle {<0.2832835, 2.40268, 2.37184>, <1.78937e-010, -0.005104504, -0.0365871>,
                         <0.3444078, 2.24598, 2.39371>, <2.17254e-010, -0.006197572, -0.04442179>,
                         <0.09620849, 2.11424, 2.41209>, <2.46232e-010, -0.007024222, -0.05034689> }
        smooth_triangle {<-0.1705584, 0.6968662, 2.60983>, <3.04853e-010, -0.00869652, -0.06233328>,
                         <-0.1748863, 0.9354327, 2.57655>, <3.14527e-010, -0.008972498, -0.06431137>,
                         <0.08639635, 0.9354327, 2.57655>, <3.00664e-010, -0.008577022, -0.06147676> }
        smooth_triangle {<0.08639635, 0.9354327, 2.57655>, <2.99187e-010, -0.008534871, -0.06117464>,
                         <0.08206845, 0.6968662, 2.60983>, <2.96393e-010, -0.008455183, -0.06060347>,
                         <-0.1705584, 0.6968662, 2.60983>, <2.99803e-010, -0.00855247, -0.06130078> }
        smooth_triangle {<-0.1748863, 0.9354327, 2.57655>, <3.14527e-010, -0.008972498, -0.06431137>,
                         <-0.1782438, 1.1739, 2.54328>, <3.11204e-010, -0.008877692, -0.06363184>,
                         <0.08975386, 1.1739, 2.54328>, <2.9604e-010, -0.008445112, -0.06053128> }
        smooth_triangle {<0.08975386, 1.1739, 2.54328>, <2.98211e-010, -0.008507035, -0.06097512>,
                         <0.08639635, 0.9354327, 2.57655>, <3.01679e-010, -0.008605967, -0.06168423>,
                         <-0.1748863, 0.9354327, 2.57655>, <3.12076e-010, -0.008902574, -0.06381019> }
        smooth_triangle {<-0.1782438, 1.1739, 2.54328>, <3.11204e-010, -0.008877692, -0.06363184>,
                         <-0.1736861, 1.40582, 2.51092>, <2.97148e-010, -0.008476716, -0.06075781>,
                         <0.08519615, 1.40582, 2.51092>, <2.78725e-010, -0.007951165, -0.05699086> }
        smooth_triangle {<0.08519615, 1.40582, 2.51092>, <2.85038e-010, -0.008131247, -0.05828161>,
                         <0.08975386, 1.1739, 2.54328>, <2.98024e-010, -0.008501707, -0.06093693>,
                         <-0.1782438, 1.1739, 2.54328>, <3.09397e-010, -0.008826142, -0.06326235> }
        smooth_triangle {<-0.1736861, 1.40582, 2.51092>, <2.97148e-010, -0.008476716, -0.06075781>,
                         <-0.1708387, 1.63991, 2.47826>, <2.98377e-010, -0.008511764, -0.06100902>,
                         <0.08234872, 1.63991, 2.47826>, <2.76584e-010, -0.007890093, -0.05655312> }
        smooth_triangle {<0.08234872, 1.63991, 2.47826>, <2.81536e-010, -0.00803136, -0.05756567>,
                         <0.08519615, 1.40582, 2.51092>, <2.83142e-010, -0.008077165, -0.05789398>,
                         <-0.1736861, 1.40582, 2.51092>, <2.96959e-010, -0.008471328, -0.06071918> }
        smooth_triangle {<-0.1708387, 1.63991, 2.47826>, <2.98377e-010, -0.008511764, -0.06100902>,
                         <-0.1768903, 1.87789, 2.44506>, <3.10058e-010, -0.008845009, -0.06339758>,
                         <0.08840033, 1.87789, 2.44506>, <2.88145e-010, -0.008219889, -0.05891697> }
        smooth_triangle {<0.08840033, 1.87789, 2.44506>, <2.89779e-010, -0.008266486, -0.05925096>,
                         <0.08234872, 1.63991, 2.47826>, <2.81108e-010, -0.008019139, -0.05747807>,
                         <-0.1708387, 1.63991, 2.47826>, <2.97452e-010, -0.008485392, -0.06081999> }
        smooth_triangle {<-0.1768903, 1.87789, 2.44506>, <3.10058e-010, -0.008845009, -0.06339758>,
                         <-0.1846984, 2.11424, 2.41209>, <2.62445e-010, -0.007486734, -0.053662>,
                         <0.09620849, 2.11424, 2.41209>, <2.51778e-010, -0.007182453, -0.05148103> }
        smooth_triangle {<0.09620849, 2.11424, 2.41209>, <2.65498e-010, -0.007573828, -0.05428625>,
                         <0.08840033, 1.87789, 2.44506>, <2.92773e-010, -0.008351905, -0.05986321>,
                         <-0.1768903, 1.87789, 2.44506>, <3.09208e-010, -0.008820744, -0.06322367> }
        smooth_triangle {<-0.1846984, 2.11424, 2.41209>, <2.62445e-010, -0.007486734, -0.053662>,
                         <-0.1661364, 2.24821, 2.39339>, <1.81748e-010, -0.005184709, -0.03716198>,
                         <0.07764641, 2.24821, 2.39339>, <1.54244e-010, -0.004400088, -0.03153812> }
        smooth_triangle {<0.07764641, 2.24821, 2.39339>, <1.6418e-010, -0.004683545, -0.03356983>,
                         <0.09620849, 2.11424, 2.41209>, <2.34847e-010, -0.006699455, -0.04801909>,
                         <-0.1846984, 2.11424, 2.41209>, <2.42847e-010, -0.006927666, -0.04965482> }
        smooth_triangle {<-0.4231059, 0.6922493, 2.61048>, <3.26175e-010, -0.009304761, -0.06669291>,
                         <-0.4306516, 0.9535418, 2.57402>, <3.31844e-010, -0.009466491, -0.06785213>,
                         <-0.1748863, 0.9354327, 2.57655>, <3.14527e-010, -0.008972498, -0.06431137> }
        smooth_triangle {<-0.1748863, 0.9354327, 2.57655>, <3.09585e-010, -0.008831515, -0.06330087>,
                         <-0.1705584, 0.6968662, 2.60983>, <2.99806e-010, -0.008552544, -0.06130131>,
                         <-0.4231059, 0.6922493, 2.61048>, <3.10467e-010, -0.008856664, -0.06348113> }
        smooth_triangle {<-0.4306516, 0.9535418, 2.57402>, <3.31844e-010, -0.009466491, -0.06785213>,
                         <-0.4352861, 1.21473, 2.53758>, <3.2129e-010, -0.009165399, -0.06569402>,
                         <-0.1782438, 1.1739, 2.54328>, <3.11204e-010, -0.008877692, -0.06363184> }
        smooth_triangle {<-0.1782438, 1.1739, 2.54328>, <3.07901e-010, -0.008783459, -0.06295642>,
                         <-0.1748863, 0.9354327, 2.57655>, <3.10393e-010, -0.008854563, -0.06346607>,
                         <-0.4306516, 0.9535418, 2.57402>, <3.23381e-010, -0.009225058, -0.06612163> }
        smooth_triangle {<-0.4352861, 1.21473, 2.53758>, <3.2129e-010, -0.009165399, -0.06569402>,
                         <-0.4161749, 1.46938, 2.50205>, <3.00436e-010, -0.008570512, -0.0614301>,
                         <-0.1736861, 1.40582, 2.51092>, <2.97148e-010, -0.008476716, -0.06075781> }
        smooth_triangle {<-0.1736861, 1.40582, 2.51092>, <2.95976e-010, -0.008443281, -0.06051816>,
                         <-0.1782438, 1.1739, 2.54328>, <3.06518e-010, -0.008744013, -0.06267369>,
                         <-0.4352861, 1.21473, 2.53758>, <3.14082e-010, -0.008959793, -0.06422032> }
        smooth_triangle {<-0.4161749, 1.46938, 2.50205>, <3.00436e-010, -0.008570512, -0.0614301>,
                         <-0.4021945, 1.7262, 2.46622>, <2.88609e-010, -0.008233126, -0.05901185>,
                         <-0.1708387, 1.63991, 2.47826>, <2.98377e-010, -0.008511764, -0.06100902> }
        smooth_triangle {<-0.1708387, 1.63991, 2.47826>, <2.9341e-010, -0.008370073, -0.05999343>,
                         <-0.1736861, 1.40582, 2.51092>, <2.92488e-010, -0.008343787, -0.05980502>,
                         <-0.4161749, 1.46938, 2.50205>, <2.94954e-010, -0.008414134, -0.06030924> }
        smooth_triangle {<-0.4021945, 1.7262, 2.46622>, <2.88609e-010, -0.008233126, -0.05901185>,
                         <-0.4149113, 1.9869, 2.42985>, <2.82184e-010, -0.008049831, -0.05769806>,
                         <-0.1768903, 1.87789, 2.44506>, <3.10058e-010, -0.008845009, -0.06339758> }
        smooth_triangle {<-0.1768903, 1.87789, 2.44506>, <2.99223e-010, -0.008535901, -0.06118202>,
                         <-0.1708387, 1.63991, 2.47826>, <2.90461e-010, -0.008285968, -0.0593906>,
                         <-0.4021945, 1.7262, 2.46622>, <2.83136e-010, -0.008076989, -0.05789272> }
        smooth_triangle {<-0.4149113, 1.9869, 2.42985>, <2.82184e-010, -0.008049831, -0.05769806>,
                         <-0.4328977, 2.24598, 2.39371>, <2.47366e-010, -0.007056578, -0.05057881>,
                         <-0.1846984, 2.11424, 2.41209>, <2.62445e-010, -0.007486734, -0.053662> }
        smooth_triangle {<-0.1846984, 2.11424, 2.41209>, <2.64576e-010, -0.007547547, -0.05409788>,
                         <-0.1768903, 1.87789, 2.44506>, <3.00287e-010, -0.008566252, -0.06139957>,
                         <-0.4149113, 1.9869, 2.42985>, <2.79381e-010, -0.007969869, -0.05712492> }
        smooth_triangle {<-0.4328977, 2.24598, 2.39371>, <2.47366e-010, -0.007056578, -0.05057881>,
                         <-0.3717735, 2.40268, 2.37184>, <2.233e-010, -0.006370077, -0.04565824>,
                         <-0.1661364, 2.24821, 2.39339>, <1.81748e-010, -0.005184709, -0.03716198> }
        smooth_triangle {<-0.1661364, 2.24821, 2.39339>, <1.79359e-010, -0.005116568, -0.03667357>,
                         <-0.1846984, 2.11424, 2.41209>, <2.40479e-010, -0.006860122, -0.04917069>,
                         <-0.4328977, 2.24598, 2.39371>, <2.2917e-010, -0.006537505, -0.0468583> }
        smooth_triangle {<-0.6595661, 0.617407, 2.62092>, <3.41937e-010, -0.009754394, -0.06991571>,
                         <-0.6599872, 0.9222114, 2.57839>, <3.33292e-010, -0.009507802, -0.06814823>,
                         <-0.4306516, 0.9535418, 2.57402>, <3.31844e-010, -0.009466491, -0.06785213> }
        smooth_triangle {<-0.4306516, 0.9535418, 2.57402>, <3.25117e-010, -0.009274582, -0.0664766>,
                         <-0.4231059, 0.6922493, 2.61048>, <3.15555e-010, -0.009001808, -0.06452146>,
                         <-0.6595661, 0.617407, 2.62092>, <3.23436e-010, -0.009226625, -0.06613286> }
        smooth_triangle {<-0.6599872, 0.9222114, 2.57839>, <3.33292e-010, -0.009507802, -0.06814823>,
                         <-0.6555563, 1.22691, 2.53588>, <3.15908e-010, -0.009011885, -0.06459369>,
                         <-0.4352861, 1.21473, 2.53758>, <3.2129e-010, -0.009165399, -0.06569402> }
        smooth_triangle {<-0.4352861, 1.21473, 2.53758>, <3.14383e-010, -0.008968384, -0.06428189>,
                         <-0.4306516, 0.9535418, 2.57402>, <3.22299e-010, -0.009194203, -0.06590047>,
                         <-0.6599872, 0.9222114, 2.57839>, <3.23385e-010, -0.009225186, -0.06612255> }
        smooth_triangle {<-0.6555563, 1.22691, 2.53588>, <3.15908e-010, -0.009011885, -0.06459369>,
                         <-0.6115493, 1.52507, 2.49428>, <2.85447e-010, -0.008142928, -0.05836534>,
                         <-0.4161749, 1.46938, 2.50205>, <3.00436e-010, -0.008570512, -0.0614301> }
        smooth_triangle {<-0.4161749, 1.46938, 2.50205>, <2.94193e-010, -0.008392403, -0.06015348>,
                         <-0.4352861, 1.21473, 2.53758>, <3.09833e-010, -0.008838568, -0.06335142>,
                         <-0.6555563, 1.22691, 2.53588>, <3.05797e-010, -0.008723432, -0.06252617> }
        smooth_triangle {<-0.6115493, 1.52507, 2.49428>, <2.85447e-010, -0.008142928, -0.05836534>,
                         <-0.5760937, 1.82541, 2.45238>, <2.65035e-010, -0.007560635, -0.05419169>,
                         <-0.4021945, 1.7262, 2.46622>, <2.88609e-010, -0.008233126, -0.05901185> }
        smooth_triangle {<-0.4021945, 1.7262, 2.46622>, <2.78758e-010, -0.007952114, -0.05699766>,
                         <-0.4161749, 1.46938, 2.50205>, <2.87629e-010, -0.008205153, -0.05881135>,
                         <-0.6115493, 1.52507, 2.49428>, <2.76387e-010, -0.007884465, -0.05651278> }
        smooth_triangle {<-0.5760937, 1.82541, 2.45238>, <2.65035e-010, -0.007560635, -0.05419169>,
                         <-0.5851333, 2.12962, 2.40994>, <2.4765e-010, -0.007064688, -0.05063694>,
                         <-0.4149113, 1.9869, 2.42985>, <2.82184e-010, -0.008049831, -0.05769806> }
        smooth_triangle {<-0.4149113, 1.9869, 2.42985>, <2.65527e-010, -0.007574656, -0.05429219>,
                         <-0.4021945, 1.7262, 2.46622>, <2.70346e-010, -0.007712127, -0.05527753>,
                         <-0.5760937, 1.82541, 2.45238>, <2.52665e-010, -0.007207759, -0.05166241> }
        smooth_triangle {<-0.5851333, 2.12962, 2.40994>, <2.4765e-010, -0.007064688, -0.05063694>,
                         <-0.6029557, 2.43221, 2.36772>, <2.44712e-010, -0.00698087, -0.05003616>,
                         <-0.4328977, 2.24598, 2.39371>, <2.47366e-010, -0.007056578, -0.05057881> }
        smooth_triangle {<-0.4328977, 2.24598, 2.39371>, <2.36307e-010, -0.006741096, -0.04831755>,
                         <-0.4149113, 1.9869, 2.42985>, <2.6242e-010, -0.007486035, -0.05365699>,
                         <-0.5851333, 2.12962, 2.40994>, <2.3652e-010, -0.006747178, -0.04836115> }
        smooth_triangle {<-0.6029557, 2.43221, 2.36772>, <2.44712e-010, -0.00698087, -0.05003616>,
                         <-0.4889268, 2.63242, 2.33979>, <2.82432e-010, -0.008056917, -0.05774885>,
                         <-0.3717735, 2.40268, 2.37184>, <2.233e-010, -0.006370077, -0.04565824> }
        smooth_triangle {<-0.3717735, 2.40268, 2.37184>, <2.10866e-010, -0.006015352, -0.0431157>,
                         <-0.4328977, 2.24598, 2.39371>, <2.32023e-010, -0.006618909, -0.04744177>,
                         <-0.6029557, 2.43221, 2.36772>, <2.30033e-010, -0.006562128, -0.04703478> }
        smooth_triangle {<-0.8469602, 0.4497867, 2.6443>, <3.29428e-010, -0.009397567, -0.0673581>,
                         <-0.84625, 0.8118369, 2.59379>, <3.2588e-010, -0.009296336, -0.06663252>,
                         <-0.6599872, 0.9222114, 2.57839>, <3.33292e-010, -0.009507802, -0.06814823> }
        smooth_triangle {<-0.6599872, 0.9222114, 2.57839>, <3.19893e-010, -0.009125559, -0.06540846>,
                         <-0.6595661, 0.617407, 2.62092>, <3.10816e-010, -0.008866612, -0.06355243>,
                         <-0.8469602, 0.4497867, 2.6443>, <3.04562e-010, -0.008688198, -0.06227363> }
        smooth_triangle {<-0.84625, 0.8118369, 2.59379>, <3.2588e-010, -0.009296336, -0.06663252>,
                         <-0.838747, 1.17379, 2.54329>, <3.0458e-010, -0.008688702, -0.06227724>,
                         <-0.6555563, 1.22691, 2.53588>, <3.15908e-010, -0.009011885, -0.06459369> }
        smooth_triangle {<-0.6555563, 1.22691, 2.53588>, <3.05726e-010, -0.008721412, -0.06251169>,
                         <-0.6599872, 0.9222114, 2.57839>, <3.18764e-010, -0.00909335, -0.06517759>,
                         <-0.84625, 0.8118369, 2.59379>, <3.08979e-010, -0.008814222, -0.06317691> }
        smooth_triangle {<-0.838747, 1.17379, 2.54329>, <3.0458e-010, -0.008688702, -0.06227724>,
                         <-0.7758374, 1.52919, 2.49371>, <2.81175e-010, -0.008021033, -0.05749165>,
                         <-0.6115493, 1.52507, 2.49428>, <2.85447e-010, -0.008142928, -0.05836534> }
        smooth_triangle {<-0.6115493, 1.52507, 2.49428>, <2.78009e-010, -0.007930733, -0.05684441>,
                         <-0.6555563, 1.22691, 2.53588>, <3.00855e-010, -0.008582451, -0.06151567>,
                         <-0.838747, 1.17379, 2.54329>, <2.88284e-010, -0.008223852, -0.05894537> }
        smooth_triangle {<-0.7758374, 1.52919, 2.49371>, <2.81175e-010, -0.008021033, -0.05749165>,
                         <-0.7248999, 1.88677, 2.44382>, <2.68044e-010, -0.007646462, -0.05480687>,
                         <-0.5760937, 1.82541, 2.45238>, <2.65035e-010, -0.007560635, -0.05419169> }
        smooth_triangle {<-0.5760937, 1.82541, 2.45238>, <2.59283e-010, -0.00739655, -0.0530156>,
                         <-0.6115493, 1.52507, 2.49428>, <2.74593e-010, -0.00783327, -0.05614583>,
                         <-0.7758374, 1.52919, 2.49371>, <2.68126e-010, -0.007648787, -0.05482354> }
        smooth_triangle {<-0.7248999, 1.88677, 2.44382>, <2.68044e-010, -0.007646462, -0.05480687>,
                         <-0.7362556, 2.24823, 2.39339>, <2.58218e-010, -0.007366155, -0.05279774>,
                         <-0.5851333, 2.12962, 2.40994>, <2.4765e-010, -0.007064688, -0.05063694> }
        smooth_triangle {<-0.5851333, 2.12962, 2.40994>, <2.40409e-010, -0.006858118, -0.04915632>,
                         <-0.5760937, 1.82541, 2.45238>, <2.53448e-010, -0.007230078, -0.05182239>,
                         <-0.7248999, 1.88677, 2.44382>, <2.51591e-010, -0.00717711, -0.05144273> }
        smooth_triangle {<-0.7362556, 2.24823, 2.39339>, <2.58218e-010, -0.007366155, -0.05279774>,
                         <-0.7599071, 2.60807, 2.34319>, <2.8895e-010, -0.008242841, -0.05908148>,
                         <-0.6029557, 2.43221, 2.36772>, <2.44712e-010, -0.00698087, -0.05003616> }
        smooth_triangle {<-0.6029557, 2.43221, 2.36772>, <2.3686e-010, -0.006756877, -0.04843067>,
                         <-0.5851333, 2.12962, 2.40994>, <2.39064e-010, -0.006819741, -0.04888125>,
                         <-0.7362556, 2.24823, 2.39339>, <2.43247e-010, -0.006939069, -0.04973655> }
        smooth_triangle {<-0.7599071, 2.60807, 2.34319>, <2.8895e-010, -0.008242841, -0.05908148>,
                         <-0.598967, 2.86552, 2.30727>, <3.2203e-010, -0.009186528, -0.06584546>,
                         <-0.4889268, 2.63242, 2.33979>, <2.82432e-010, -0.008056917, -0.05774885> }
        smooth_triangle {<-0.4889268, 2.63242, 2.33979>, <2.72205e-010, -0.007765171, -0.05565773>,
                         <-0.6029557, 2.43221, 2.36772>, <2.46472e-010, -0.007031072, -0.05039599>,
                         <-0.7599071, 2.60807, 2.34319>, <2.7655e-010, -0.00788912, -0.05654615> }
    }
}

#declare Toe_Joint =
union {  // Layer name: TOE JOINT
    union { // Poly_Mesh
        smooth_triangle {<0.6803682, 0.4383702, -0.7409306>, <-0.06390178, 2.07053e-016, -1.12558e-010>,
                         <0.6803682, 0.6556396, -0.0740253>, <-0.07449228, 1.01199e-016, -1.31213e-010>,
                         <0.6803682, 0.7621676, -0.04115229>, <-0.06390178, 2.07053e-016, -1.12558e-010> }
        smooth_triangle {<0.6803682, 0.7621676, -0.04115229>, <-0.04977293, 3.75046e-016, -8.76714e-011>,
                         <0.6803682, 0.5115999, -0.6927509>, <-0.03564409, 5.43038e-016, -6.27846e-011>,
                         <0.6803682, 0.4383702, -0.7409306>, <-0.04977293, 3.75046e-016, -8.76714e-011> }
        smooth_triangle {<0.6803682, 0.6556396, -0.0740253>, <-0.07449228, 1.01199e-016, -1.31213e-010>,
                         <0.6803682, 0.8780162, 0.5929961>, <-0.09381404, 1.59217e-016, -1.65247e-010>,
                         <0.6803682, 1.01109, 0.6110759>, <-0.08474208, 6.10006e-016, -1.49267e-010> }
        smooth_triangle {<0.6803682, 1.01109, 0.6110759>, <-0.07301991, 4.34152e-016, -1.28619e-010>,
                         <0.6803682, 0.7621676, -0.04115229>, <-0.06259977, 2.32675e-016, -1.10265e-010>,
                         <0.6803682, 0.6556396, -0.0740253>, <-0.07119365, 1.40474e-016, -1.25402e-010> }
        smooth_triangle {<0.6803682, 0.8780162, 0.5929961>, <-0.09381404, 1.59217e-016, -1.65247e-010>,
                         <0.6803682, 1.06742, 1.27057>, <-0.1069502, 1.39593e-016, -1.88385e-010>,
                         <0.6803682, 1.21991, 1.27578>, <-0.1023348, -3.65799e-016, -1.80255e-010> }
        smooth_triangle {<0.6803682, 1.21991, 1.27578>, <-0.09350685, 1.2003e-016, -1.64706e-010>,
                         <0.6803682, 1.01109, 0.6110759>, <-0.08471048, 6.07933e-016, -1.49212e-010>,
                         <0.6803682, 0.8780162, 0.5929961>, <-0.09153025, 2.70878e-016, -1.61224e-010> }
        smooth_triangle {<0.6803682, 1.06742, 1.27057>, <-0.1069502, 1.39593e-016, -1.88385e-010>,
                         <0.6803682, 1.08577, 1.9756>, <-0.1049563, -1.53991e-016, -1.84873e-010>,
                         <0.6803682, 1.23898, 1.9722>, <-0.1080782, 5.66125e-016, -1.90372e-010> }
        smooth_triangle {<0.6803682, 1.23898, 1.9722>, <-0.1070864, 9.80509e-017, -1.88625e-010>,
                         <0.6803682, 1.21991, 1.27578>, <-0.1042147, -3.67911e-016, -1.83567e-010>,
                         <0.6803682, 1.06742, 1.27057>, <-0.1067363, 1.21892e-017, -1.88008e-010> }
        smooth_triangle {<0.6803682, 1.08577, 1.9756>, <-0.1049563, -1.53991e-016, -1.84873e-010>,
                         <0.6803682, 0.9254422, 2.66073>, <-0.0846855, -8.07914e-017, -1.49167e-010>,
                         <0.6803682, 1.06275, 2.64557>, <-0.0916447, 5.5143e-016, -1.61425e-010> }
        smooth_triangle {<0.6803682, 1.06275, 2.64557>, <-0.09710515, 5.47582e-016, -1.71044e-010>,
                         <0.6803682, 1.23898, 1.9722>, <-0.1053219, 5.54929e-016, -1.85517e-010>,
                         <0.6803682, 1.08577, 1.9756>, <-0.1043586, 2.044e-017, -1.8382e-010> }
        smooth_triangle {<0.6803682, 0.9254422, 2.66073>, <-0.0846855, -8.07914e-017, -1.49167e-010>,
                         <0.6803682, 0.6834946, 3.31938>, <-0.05719304, -7.85029e-016, -1.00742e-010>,
                         <0.6803682, 0.7892513, 3.28786>, <-0.06203052, 7.17026e-017, -1.09262e-010> }
        smooth_triangle {<0.6803682, 0.7892513, 3.28786>, <-0.07303899, 2.96572e-016, -1.28653e-010>,
                         <0.6803682, 1.06275, 2.64557>, <-0.08784608, 5.36436e-016, -1.54734e-010>,
                         <0.6803682, 0.9254422, 2.66073>, <-0.08452599, 6.97668e-017, -1.48886e-010> }
        smooth_triangle {<0.6803682, 0.6834946, 3.31938>, <-0.05719304, -7.85029e-016, -1.00742e-010>,
                         <0.6803682, 0.4381488, 3.97647>, <-0.04260322, -6.77633e-016, -7.50427e-011>,
                         <0.6803682, 0.5113787, 3.92829>, <-0.03629792, -7.62874e-016, -6.39364e-011> }
        smooth_triangle {<0.6803682, 0.5113787, 3.92829>, <-0.04763437, -3.64281e-016, -8.39046e-011>,
                         <0.6803682, 0.7892513, 3.28786>, <-0.06050068, 5.30073e-017, -1.06568e-010>,
                         <0.6803682, 0.6834946, 3.31938>, <-0.05763749, -5.80194e-016, -1.01524e-010> }
        smooth_triangle {<0.6803682, 0.3558011, -0.7704477>, <-0.074833, -5.13461e-016, -1.31813e-010>,
                         <0.6803682, 0.5397723, -0.09356788>, <-0.08370868, -2.61173e-017, -1.47447e-010>,
                         <0.6803682, 0.6556396, -0.0740253>, <-0.07449228, 1.01199e-016, -1.31213e-010> }
        smooth_triangle {<0.6803682, 0.6556396, -0.0740253>, <-0.06803236, -1.7248e-016, -1.19834e-010>,
                         <0.6803682, 0.4383702, -0.7409306>, <-0.05627718, -3.93233e-016, -9.91279e-011>,
                         <0.6803682, 0.3558011, -0.7704477>, <-0.06174279, -7.53491e-016, -1.08755e-010> }
        smooth_triangle {<0.6803682, 0.5397723, -0.09356788>, <-0.08370868, -2.61173e-017, -1.47447e-010>,
                         <0.6803682, 0.7356038, 0.5829145>, <-0.1016102, 1.0874e-016, -1.78979e-010>,
                         <0.6803682, 0.8780162, 0.5929961>, <-0.09381404, 1.59217e-016, -1.65247e-010> }
        smooth_triangle {<0.6803682, 0.8780162, 0.5929961>, <-0.08859557, 4.43324e-019, -1.56055e-010>,
                         <0.6803682, 0.6556396, -0.0740253>, <-0.07410426, -4.30699e-017, -1.30529e-010>,
                         <0.6803682, 0.5397723, -0.09356788>, <-0.08101655, -1.38557e-016, -1.42705e-010> }
        smooth_triangle {<0.6803682, 0.7356038, 0.5829145>, <-0.1016102, 1.0874e-016, -1.78979e-010>,
                         <0.6803682, 0.9055957, 1.26803>, <-0.1132431, -6.39969e-016, -1.99469e-010>,
                         <0.6803682, 1.06742, 1.27057>, <-0.1069502, 1.39593e-016, -1.88385e-010> }
        smooth_triangle {<0.6803682, 1.06742, 1.27057>, <-0.1038591, 1.56599e-016, -1.8294e-010>,
                         <0.6803682, 0.8780162, 0.5929961>, <-0.09400702, 1.71317e-016, -1.65587e-010>,
                         <0.6803682, 0.7356038, 0.5829145>, <-0.09985418, 1.33459e-016, -1.75886e-010> }
        smooth_triangle {<0.6803682, 0.9055957, 1.26803>, <-0.1132431, -6.39969e-016, -1.99469e-010>,
                         <0.6803682, 0.9232276, 1.97634>, <-0.1110108, -5.57877e-016, -1.95537e-010>,
                         <0.6803682, 1.08577, 1.9756>, <-0.1049563, -1.53991e-016, -1.84873e-010> }
        smooth_triangle {<0.6803682, 1.08577, 1.9756>, <-0.1072285, -5.77148e-017, -1.88875e-010>,
                         <0.6803682, 1.06742, 1.27057>, <-0.1087238, 1.62474e-016, -1.91509e-010>,
                         <0.6803682, 0.9055957, 1.26803>, <-0.1134436, -4.22198e-016, -1.99822e-010> }
        smooth_triangle {<0.6803682, 0.9232276, 1.97634>, <-0.1110108, -5.57877e-016, -1.95537e-010>,
                         <0.6803682, 0.7787924, 2.66789>, <-0.09287696, -8.67055e-016, -1.63596e-010>,
                         <0.6803682, 0.9254422, 2.66073>, <-0.0846855, -8.07914e-017, -1.49167e-010> }
        smooth_triangle {<0.6803682, 0.9254422, 2.66073>, <-0.09132578, -4.42841e-016, -1.60864e-010>,
                         <0.6803682, 1.08577, 1.9756>, <-0.1065289, -4.97741e-016, -1.87643e-010>,
                         <0.6803682, 0.9232276, 1.97634>, <-0.1110697, -8.00656e-016, -1.95641e-010> }
        smooth_triangle {<0.6803682, 0.7787924, 2.66789>, <-0.09287696, -8.67055e-016, -1.63596e-010>,
                         <0.6803682, 0.5683986, 3.33758>, <-0.06770105, -4.64393e-016, -1.19251e-010>,
                         <0.6803682, 0.6834946, 3.31938>, <-0.05719304, -7.85029e-016, -1.00742e-010> }
        smooth_triangle {<0.6803682, 0.6834946, 3.31938>, <-0.06660955, -7.91302e-016, -1.17328e-010>,
                         <0.6803682, 0.9254422, 2.66073>, <-0.08722889, -2.63124e-016, -1.53647e-010>,
                         <0.6803682, 0.7787924, 2.66789>, <-0.09337249, -8.52822e-016, -1.64469e-010> }
        smooth_triangle {<0.6803682, 0.5683986, 3.33758>, <-0.06770105, -4.64393e-016, -1.19251e-010>,
                         <0.6803682, 0.3555797, 4.00599>, <-0.05367492, -6.29364e-016, -9.45446e-011>,
                         <0.6803682, 0.4381488, 3.97647>, <-0.04260322, -6.77633e-016, -7.50427e-011> }
        smooth_triangle {<0.6803682, 0.4381488, 3.97647>, <-0.05212381, -1.00267e-015, -9.18126e-011>,
                         <0.6803682, 0.6834946, 3.31938>, <-0.06068603, -1.00196e-015, -1.06894e-010>,
                         <0.6803682, 0.5683986, 3.33758>, <-0.06856703, -7.61485e-016, -1.20776e-010> }
        smooth_triangle {<0.6803682, 0.2686217, -0.7709801>, <-0.08192782, 2.01665e-016, -1.4431e-010>,
                         <0.6803682, 0.4192946, -0.09240704>, <-0.08766115, 3.84493e-016, -1.54409e-010>,
                         <0.6803682, 0.5397723, -0.09356788>, <-0.08370868, -2.61173e-017, -1.47447e-010> }
        smooth_triangle {<0.6803682, 0.5397723, -0.09356788>, <-0.07750952, -1.4879e-017, -1.36527e-010>,
                         <0.6803682, 0.3558011, -0.7704477>, <-0.06687253, -2.47313e-016, -1.17791e-010>,
                         <0.6803682, 0.2686217, -0.7709801>, <-0.07041994, 1.1025e-016, -1.2404e-010> }
        smooth_triangle {<0.6803682, 0.4192946, -0.09240704>, <-0.08766115, 3.84493e-016, -1.54409e-010>,
                         <0.6803682, 0.588581, 0.585255>, <-0.1041417, -1.5398e-016, -1.83438e-010>,
                         <0.6803682, 0.7356038, 0.5829145>, <-0.1016102, 1.0874e-016, -1.78979e-010> }
        smooth_triangle {<0.6803682, 0.7356038, 0.5829145>, <-0.09663978, 1.31138e-016, -1.70224e-010>,
                         <0.6803682, 0.5397723, -0.09356788>, <-0.0832136, 2.9995e-017, -1.46575e-010>,
                         <0.6803682, 0.4192946, -0.09240704>, <-0.08617795, 3.37953e-016, -1.51796e-010> }
        smooth_triangle {<0.6803682, 0.588581, 0.585255>, <-0.1041417, -1.5398e-016, -1.83438e-010>,
                         <0.6803682, 0.7391602, 1.26963>, <-0.1141415, 6.77902e-016, -2.01052e-010>,
                         <0.6803682, 0.9055957, 1.26803>, <-0.1132431, -6.39969e-016, -1.99469e-010> }
        smooth_triangle {<0.6803682, 0.9055957, 1.26803>, <-0.1102138, -5.10495e-016, -1.94133e-010>,
                         <0.6803682, 0.7356038, 0.5829145>, <-0.1014892, 5.10363e-017, -1.78766e-010>,
                         <0.6803682, 0.588581, 0.585255>, <-0.1033878, -1.46004e-016, -1.8211e-010> }
        smooth_triangle {<0.6803682, 0.7391602, 1.26963>, <-0.1141415, 6.77902e-016, -2.01052e-010>,
                         <0.6803682, 0.7560706, 1.97294>, <-0.1117743, 9.10785e-017, -1.96882e-010>,
                         <0.6803682, 0.9232276, 1.97634>, <-0.1110108, -5.57877e-016, -1.95537e-010> }
        smooth_triangle {<0.6803682, 0.9232276, 1.97634>, <-0.112737, -5.6324e-016, -1.98578e-010>,
                         <0.6803682, 0.9055957, 1.26803>, <-0.1144113, -6.24808e-016, -2.01527e-010>,
                         <0.6803682, 0.7391602, 1.26963>, <-0.1150851, 3.63594e-016, -2.02714e-010> }
        smooth_triangle {<0.6803682, 0.7560706, 1.97294>, <-0.1117743, 9.10785e-017, -1.96882e-010>,
                         <0.6803682, 0.6275322, 2.66263>, <-0.09609024, 7.58609e-016, -1.69256e-010>,
                         <0.6803682, 0.7787924, 2.66789>, <-0.09287696, -8.67055e-016, -1.63596e-010> }
        smooth_triangle {<0.6803682, 0.7787924, 2.66789>, <-0.09867988, -4.60068e-016, -1.73818e-010>,
                         <0.6803682, 0.9232276, 1.97634>, <-0.1122802, -2.28185e-016, -1.97774e-010>,
                         <0.6803682, 0.7560706, 1.97294>, <-0.1128529, 2.58532e-016, -1.98782e-010> }
        smooth_triangle {<0.6803682, 0.6275322, 2.66263>, <-0.09609024, 7.58609e-016, -1.69256e-010>,
                         <0.6803682, 0.4486923, 3.33506>, <-0.0733741, -9.01343e-017, -1.29243e-010>,
                         <0.6803682, 0.5683986, 3.33758>, <-0.06770105, -4.64393e-016, -1.19251e-010> }
        smooth_triangle {<0.6803682, 0.5683986, 3.33758>, <-0.07637671, -3.68535e-016, -1.34532e-010>,
                         <0.6803682, 0.7787924, 2.66789>, <-0.09525864, -6.70531e-016, -1.67791e-010>,
                         <0.6803682, 0.6275322, 2.66263>, <-0.09766861, 5.48717e-016, -1.72036e-010> }
        smooth_triangle {<0.6803682, 0.4486923, 3.33506>, <-0.0733741, -9.01343e-017, -1.29243e-010>,
                         <0.6803682, 0.2684003, 4.00652>, <-0.05906476, 6.2857e-016, -1.04038e-010>,
                         <0.6803682, 0.3555797, 4.00599>, <-0.05367492, -6.29364e-016, -9.45446e-011> }
        smooth_triangle {<0.6803682, 0.3555797, 4.00599>, <-0.06263257, -1.32382e-016, -1.10323e-010>,
                         <0.6803682, 0.5683986, 3.33758>, <-0.07091276, -1.329e-016, -1.24908e-010>,
                         <0.6803682, 0.4486923, 3.33506>, <-0.07516755, 1.47795e-016, -1.32402e-010> }
        smooth_triangle {<0.6803682, 0.185037, -0.7441568>, <-0.08102766, 1.07749e-015, -1.42724e-010>,
                         <0.6803682, 0.3024117, -0.07170645>, <-0.08592928, 6.74943e-016, -1.51358e-010>,
                         <0.6803682, 0.4192946, -0.09240704>, <-0.08766115, 3.84493e-016, -1.54409e-010> }
        smooth_triangle {<0.6803682, 0.4192946, -0.09240704>, <-0.08093582, 6.06522e-016, -1.42563e-010>,
                         <0.6803682, 0.2686217, -0.7709801>, <-0.07134381, 7.37137e-016, -1.25667e-010>,
                         <0.6803682, 0.185037, -0.7441568>, <-0.07089373, 1.17505e-015, -1.24874e-010> }
        smooth_triangle {<0.6803682, 0.3024117, -0.07170645>, <-0.08592928, 6.74943e-016, -1.51358e-010>,
                         <0.6803682, 0.445153, 0.5993194>, <-0.1015808, 4.3896e-016, -1.78927e-010>,
                         <0.6803682, 0.588581, 0.585255>, <-0.1041417, -1.5398e-016, -1.83438e-010> }
        smooth_triangle {<0.6803682, 0.588581, 0.585255>, <-0.09878415, 1.4488e-016, -1.74001e-010>,
                         <0.6803682, 0.4192946, -0.09240704>, <-0.08642372, 5.48735e-016, -1.52229e-010>,
                         <0.6803682, 0.3024117, -0.07170645>, <-0.08512482, 7.66573e-016, -1.49941e-010> }
        smooth_triangle {<0.6803682, 0.445153, 0.5993194>, <-0.1015808, 4.3896e-016, -1.78927e-010>,
                         <0.6803682, 0.5763196, 1.27514>, <-0.1104779, 1.61142e-016, -1.94599e-010>,
                         <0.6803682, 0.7391602, 1.26963>, <-0.1141415, 6.77902e-016, -2.01052e-010> }
        smooth_triangle {<0.6803682, 0.7391602, 1.26963>, <-0.1106753, 5.70493e-016, -1.94946e-010>,
                         <0.6803682, 0.588581, 0.585255>, <-0.1031755, -5.34185e-017, -1.81736e-010>,
                         <0.6803682, 0.445153, 0.5993194>, <-0.1012548, 3.91287e-016, -1.78353e-010> }
        smooth_triangle {<0.6803682, 0.5763196, 1.27514>, <-0.1104779, 1.61142e-016, -1.94599e-010>,
                         <0.6803682, 0.5925085, 1.96563>, <-0.1081068, 8.77006e-016, -1.90422e-010>,
                         <0.6803682, 0.7560706, 1.97294>, <-0.1117743, 9.10785e-017, -1.96882e-010> }
        smooth_triangle {<0.6803682, 0.7560706, 1.97294>, <-0.1124857, 5.42035e-016, -1.98135e-010>,
                         <0.6803682, 0.7391602, 1.26963>, <-0.1142611, 9.82152e-016, -2.01263e-010>,
                         <0.6803682, 0.5763196, 1.27514>, <-0.1115134, 5.94582e-016, -1.96423e-010> }
        smooth_triangle {<0.6803682, 0.5925085, 1.96563>, <-0.1081068, 8.77006e-016, -1.90422e-010>,
                         <0.6803682, 0.4798669, 2.64564>, <-0.09414028, 1.37387e-016, -1.65821e-010>,
                         <0.6803682, 0.6275322, 2.66263>, <-0.09609024, 7.58609e-016, -1.69256e-010> }
        smooth_triangle {<0.6803682, 0.6275322, 2.66263>, <-0.1005044, 4.67547e-016, -1.77031e-010>,
                         <0.6803682, 0.7560706, 1.97294>, <-0.1122674, -3.3101e-017, -1.97751e-010>,
                         <0.6803682, 0.5925085, 1.96563>, <-0.1095168, 5.56345e-016, -1.92906e-010> }
        smooth_triangle {<0.6803682, 0.4798669, 2.64564>, <-0.09414028, 1.37387e-016, -1.65821e-010>,
                         <0.6803682, 0.3325808, 3.31301>, <-0.07296618, 8.80506e-016, -1.28524e-010>,
                         <0.6803682, 0.4486923, 3.33506>, <-0.0733741, -9.01343e-017, -1.29243e-010> }
        smooth_triangle {<0.6803682, 0.4486923, 3.33506>, <-0.08061383, 2.84805e-016, -1.41995e-010>,
                         <0.6803682, 0.6275322, 2.66263>, <-0.09765093, 9.21363e-016, -1.72005e-010>,
                         <0.6803682, 0.4798669, 2.64564>, <-0.09618846, 4.55446e-016, -1.69429e-010> }
        smooth_triangle {<0.6803682, 0.3325808, 3.31301>, <-0.07296618, 8.80506e-016, -1.28524e-010>,
                         <0.6803682, 0.1848157, 3.9797>, <-0.05867906, 8.00005e-016, -1.03359e-010>,
                         <0.6803682, 0.2684003, 4.00652>, <-0.05906476, 6.2857e-016, -1.04038e-010> }
        smooth_triangle {<0.6803682, 0.2684003, 4.00652>, <-0.06668972, 2.76228e-016, -1.17469e-010>,
                         <0.6803682, 0.4486923, 3.33506>, <-0.07551549, -1.74715e-016, -1.33015e-010>,
                         <0.6803682, 0.3325808, 3.31301>, <-0.07520954, 5.53266e-016, -1.32476e-010> }
        smooth_triangle {<0.6803682, 0.1033505, -0.7117904>, <-0.07850875, 7.2477e-016, -1.38288e-010>,
                         <0.6803682, 0.1874269, -0.04704644>, <-0.08186531, -2.66825e-016, -1.442e-010>,
                         <0.6803682, 0.3024117, -0.07170645>, <-0.08592928, 6.74943e-016, -1.51358e-010> }
        smooth_triangle {<0.6803682, 0.3024117, -0.07170645>, <-0.07912924, 4.34625e-016, -1.3938e-010>,
                         <0.6803682, 0.185037, -0.7441568>, <-0.06987838, 3.95581e-016, -1.23086e-010>,
                         <0.6803682, 0.1033505, -0.7117904>, <-0.06861893, 2.1922e-016, -1.20867e-010> }
        smooth_triangle {<0.6803682, 0.1874269, -0.04704644>, <-0.08186531, -2.66825e-016, -1.442e-010>,
                         <0.6803682, 0.3036232, 0.6157595>, <-0.09739369, -2.09907e-016, -1.71552e-010>,
                         <0.6803682, 0.445153, 0.5993194>, <-0.1015808, 4.3896e-016, -1.78927e-010> }
        smooth_triangle {<0.6803682, 0.445153, 0.5993194>, <-0.09635502, 5.16424e-016, -1.69722e-010>,
                         <0.6803682, 0.3024117, -0.07170645>, <-0.0846164, 6.93411e-016, -1.49046e-010>,
                         <0.6803682, 0.1874269, -0.04704644>, <-0.08156842, -1.29152e-017, -1.43677e-010> }
        smooth_triangle {<0.6803682, 0.3036232, 0.6157595>, <-0.09739369, -2.09907e-016, -1.71552e-010>,
                         <0.6803682, 0.415377, 1.28144>, <-0.1057091, 3.06355e-016, -1.86199e-010>,
                         <0.6803682, 0.5763196, 1.27514>, <-0.1104779, 1.61142e-016, -1.94599e-010> }
        smooth_triangle {<0.6803682, 0.5763196, 1.27514>, <-0.1073097, -7.74492e-017, -1.89018e-010>,
                         <0.6803682, 0.445153, 0.5993194>, <-0.1006369, 1.30915e-016, -1.77265e-010>,
                         <0.6803682, 0.3036232, 0.6157595>, <-0.09749661, -3.55736e-016, -1.71733e-010> }
        smooth_triangle {<0.6803682, 0.415377, 1.28144>, <-0.1057091, 3.06355e-016, -1.86199e-010>,
                         <0.6803682, 0.4308445, 1.95753>, <-0.1030393, -2.37435e-017, -1.81496e-010>,
                         <0.6803682, 0.5925085, 1.96563>, <-0.1081068, 8.77006e-016, -1.90422e-010> }
        smooth_triangle {<0.6803682, 0.5925085, 1.96563>, <-0.1088878, 4.26205e-016, -1.91798e-010>,
                         <0.6803682, 0.5763196, 1.27514>, <-0.1106661, -1.10694e-016, -1.9493e-010>,
                         <0.6803682, 0.415377, 1.28144>, <-0.1070895, -1.78322e-018, -1.8863e-010> }
        smooth_triangle {<0.6803682, 0.4308445, 1.95753>, <-0.1030393, -2.37435e-017, -1.81496e-010>,
                         <0.6803682, 0.3340996, 2.62628>, <-0.08988044, 4.61865e-016, -1.58318e-010>,
                         <0.6803682, 0.4798669, 2.64564>, <-0.09414028, 1.37387e-016, -1.65821e-010> }
        smooth_triangle {<0.6803682, 0.4798669, 2.64564>, <-0.09831687, 5.02215e-016, -1.73178e-010>,
                         <0.6803682, 0.5925085, 1.96563>, <-0.1087918, 1.05693e-015, -1.91629e-010>,
                         <0.6803682, 0.4308445, 1.95753>, <-0.1049911, 3.81367e-016, -1.84934e-010> }
        smooth_triangle {<0.6803682, 0.3340996, 2.62628>, <-0.08988044, 4.61865e-016, -1.58318e-010>,
                         <0.6803682, 0.2183673, 3.287>, <-0.06933273, 1.63546e-016, -1.22124e-010>,
                         <0.6803682, 0.3325808, 3.31301>, <-0.07296618, 8.80506e-016, -1.28524e-010> }
        smooth_triangle {<0.6803682, 0.3325808, 3.31301>, <-0.07975766, 4.9511e-016, -1.40487e-010>,
                         <0.6803682, 0.4798669, 2.64564>, <-0.09563824, -6.22295e-017, -1.6846e-010>,
                         <0.6803682, 0.3340996, 2.62628>, <-0.09244336, 1.81129e-016, -1.62832e-010> }
        smooth_triangle {<0.6803682, 0.2183673, 3.287>, <-0.06933273, 1.63546e-016, -1.22124e-010>,
                         <0.6803682, 0.1031292, 3.94733>, <-0.0546093, -2.12507e-016, -9.61904e-011>,
                         <0.6803682, 0.1848157, 3.9797>, <-0.05867906, 8.00005e-016, -1.03359e-010> }
        smooth_triangle {<0.6803682, 0.1848157, 3.9797>, <-0.06578201, 9.54153e-016, -1.1587e-010>,
                         <0.6803682, 0.3325808, 3.31301>, <-0.07472162, 9.75992e-016, -1.31616e-010>,
                         <0.6803682, 0.2183673, 3.287>, <-0.07199653, 4.38272e-016, -1.26817e-010> }
        smooth_triangle {<0.6803682, 0.0300661, -0.6641178>, <-0.07137007, -7.98428e-016, -1.25713e-010>,
                         <0.6803682, 0.08084425, -0.0114535>, <-0.07279794, 2.94527e-016, -1.28228e-010>,
                         <0.6803682, 0.1874269, -0.04704644>, <-0.08186531, -2.66825e-016, -1.442e-010> }
        smooth_triangle {<0.6803682, 0.1874269, -0.04704644>, <-0.07457986, -3.97339e-016, -1.31367e-010>,
                         <0.6803682, 0.1033505, -0.7117904>, <-0.06561614, -3.20557e-017, -1.15578e-010>,
                         <0.6803682, 0.0300661, -0.6641178>, <-0.0620468, -7.93655e-016, -1.09291e-010> }
        smooth_triangle {<0.6803682, 0.08084425, -0.0114535>, <-0.07279794, 2.94527e-016, -1.28228e-010>,
                         <0.6803682, 0.1704954, 0.6387593>, <-0.08825159, 5.37308e-016, -1.55449e-010>,
                         <0.6803682, 0.3036232, 0.6157595>, <-0.09739369, -2.09907e-016, -1.71552e-010> }
        smooth_triangle {<0.6803682, 0.3036232, 0.6157595>, <-0.09174012, -3.34171e-016, -1.61593e-010>,
                         <0.6803682, 0.1874269, -0.04704644>, <-0.08009383, -3.7686e-016, -1.41079e-010>,
                         <0.6803682, 0.08084425, -0.0114535>, <-0.07329331, 4.41537e-017, -1.29101e-010> }
        smooth_triangle {<0.6803682, 0.1704954, 0.6387593>, <-0.08825159, 5.37308e-016, -1.55449e-010>,
                         <0.6803682, 0.2628365, 1.28993>, <-0.09590536, -2.33551e-016, -1.6893e-010>,
                         <0.6803682, 0.415377, 1.28144>, <-0.1057091, 3.06355e-016, -1.86199e-010> }
        smooth_triangle {<0.6803682, 0.415377, 1.28144>, <-0.1020796, 4.87005e-016, -1.79806e-010>,
                         <0.6803682, 0.3036232, 0.6157595>, <-0.09584304, 9.98083e-017, -1.68821e-010>,
                         <0.6803682, 0.1704954, 0.6387593>, <-0.08898646, 6.60219e-016, -1.56743e-010> }
        smooth_triangle {<0.6803682, 0.2628365, 1.28993>, <-0.09590536, -2.33551e-016, -1.6893e-010>,
                         <0.6803682, 0.2775825, 1.94724>, <-0.09304367, 1.11558e-016, -1.6389e-010>,
                         <0.6803682, 0.4308445, 1.95753>, <-0.1030393, -2.37435e-017, -1.81496e-010> }
        smooth_triangle {<0.6803682, 0.4308445, 1.95753>, <-0.1030949, 4.5007e-017, -1.81594e-010>,
                         <0.6803682, 0.415377, 1.28144>, <-0.1050972, 2.92581e-016, -1.85121e-010>,
                         <0.6803682, 0.2628365, 1.28993>, <-0.09774442, -1.12349e-016, -1.7217e-010> }
        smooth_triangle {<0.6803682, 0.2775825, 1.94724>, <-0.09304367, 1.11558e-016, -1.6389e-010>,
                         <0.6803682, 0.1967344, 2.60036>, <-0.08086536, -5.55323e-017, -1.42439e-010>,
                         <0.6803682, 0.3340996, 2.62628>, <-0.08988044, 4.61865e-016, -1.58318e-010> }
        smooth_triangle {<0.6803682, 0.3340996, 2.62628>, <-0.09328291, 8.35283e-017, -1.64311e-010>,
                         <0.6803682, 0.4308445, 1.95753>, <-0.1031521, -2.80678e-016, -1.81695e-010>,
                         <0.6803682, 0.2775825, 1.94724>, <-0.09565533, -1.79202e-016, -1.6849e-010> }
        smooth_triangle {<0.6803682, 0.1967344, 2.60036>, <-0.08086536, -5.55323e-017, -1.42439e-010>,
                         <0.6803682, 0.112556, 3.25006>, <-0.06097915, -8.58978e-017, -1.0741e-010>,
                         <0.6803682, 0.2183673, 3.287>, <-0.06933273, 1.63546e-016, -1.22124e-010> }
        smooth_triangle {<0.6803682, 0.2183673, 3.287>, <-0.07543946, 3.07062e-016, -1.32881e-010>,
                         <0.6803682, 0.3340996, 2.62628>, <-0.09085024, 5.30802e-016, -1.60026e-010>,
                         <0.6803682, 0.1967344, 2.60036>, <-0.08408893, 1.42753e-016, -1.48117e-010> }
        smooth_triangle {<0.6803682, 0.112556, 3.25006>, <-0.06097915, -8.58978e-017, -1.0741e-010>,
                         <0.6803682, 0.02984479, 3.89966>, <-0.04559028, -1.82087e-016, -8.0304e-011>,
                         <0.6803682, 0.1031292, 3.94733>, <-0.0546093, -2.12507e-016, -9.61904e-011> }
        smooth_triangle {<0.6803682, 0.1031292, 3.94733>, <-0.06111544, -2.44214e-016, -1.0765e-010>,
                         <0.6803682, 0.2183673, 3.287>, <-0.07053148, 4.57528e-017, -1.24236e-010>,
                         <0.6803682, 0.112556, 3.25006>, <-0.06426629, -1.4133e-016, -1.132e-010> }
        smooth_triangle {<0.6803682, -0.0272259, -0.5975998>, <-0.0584004, 6.73633e-016, -1.02868e-010>,
                         <0.6803682, -0.009745987, 0.03760044>, <-0.06720929, 5.09923e-016, -1.18384e-010>,
                         <0.6803682, 0.08084425, -0.0114535>, <-0.07279794, 2.94527e-016, -1.28228e-010> }
        smooth_triangle {<0.6803682, 0.08084425, -0.0114535>, <-0.06479098, 5.21068e-016, -1.14125e-010>,
                         <0.6803682, 0.0300661, -0.6641178>, <-0.05607009, 2.01132e-016, -9.87634e-011>,
                         <0.6803682, -0.0272259, -0.5975998>, <-0.04958525, 9.37163e-016, -8.73409e-011> }
        smooth_triangle {<0.6803682, -0.009745987, 0.03760044>, <-0.06720929, 5.09923e-016, -1.18384e-010>,
                         <0.6803682, 0.05336007, 0.6698357>, <-0.08151611, 2.13686e-016, -1.43585e-010>,
                         <0.6803682, 0.1704954, 0.6387593>, <-0.08825159, 5.37308e-016, -1.55449e-010> }
        smooth_triangle {<0.6803682, 0.1704954, 0.6387593>, <-0.08201386, 5.66601e-016, -1.44462e-010>,
                         <0.6803682, 0.08084425, -0.0114535>, <-0.07042362, 3.84515e-016, -1.24046e-010>,
                         <0.6803682, -0.009745987, 0.03760044>, <-0.06590641, 5.58109e-016, -1.16089e-010> }
        smooth_triangle {<0.6803682, 0.05336007, 0.6698357>, <-0.08151611, 2.13686e-016, -1.43585e-010>,
                         <0.6803682, 0.1262885, 1.30111>, <-0.08687203, 3.24772e-016, -1.53019e-010>,
                         <0.6803682, 0.2628365, 1.28993>, <-0.09590536, -2.33551e-016, -1.6893e-010> }
        smooth_triangle {<0.6803682, 0.2628365, 1.28993>, <-0.09171514, -8.19512e-017, -1.61549e-010>,
                         <0.6803682, 0.1704954, 0.6387593>, <-0.08597481, 4.96193e-016, -1.51438e-010>,
                         <0.6803682, 0.05336007, 0.6698357>, <-0.08072556, 2.6674e-016, -1.42192e-010> }
        smooth_triangle {<0.6803682, 0.1262885, 1.30111>, <-0.08687203, 3.24772e-016, -1.53019e-010>,
                         <0.6803682, 0.1403131, 1.93426>, <-0.08282942, -1.62621e-017, -1.45898e-010>,
                         <0.6803682, 0.2775825, 1.94724>, <-0.09304367, 1.11558e-016, -1.6389e-010> }
        smooth_triangle {<0.6803682, 0.2775825, 1.94724>, <-0.09226253, 1.03755e-016, -1.62514e-010>,
                         <0.6803682, 0.2628365, 1.28993>, <-0.0944088, -1.55078e-016, -1.66294e-010>,
                         <0.6803682, 0.1262885, 1.30111>, <-0.08788772, 2.43295e-016, -1.54808e-010> }
        smooth_triangle {<0.6803682, 0.1403131, 1.93426>, <-0.08282942, -1.62621e-017, -1.45898e-010>,
                         <0.6803682, 0.07536179, 2.56636>, <-0.06923127, -1.92959e-016, -1.21946e-010>,
                         <0.6803682, 0.1967344, 2.60036>, <-0.08086536, -5.55323e-017, -1.42439e-010> }
        smooth_triangle {<0.6803682, 0.1967344, 2.60036>, <-0.08332491, 1.12918e-016, -1.46771e-010>,
                         <0.6803682, 0.2775825, 1.94724>, <-0.09245864, 2.38237e-016, -1.62859e-010>,
                         <0.6803682, 0.1403131, 1.93426>, <-0.08545413, 1.95249e-016, -1.50521e-010> }
        smooth_triangle {<0.6803682, 0.07536179, 2.56636>, <-0.06923127, -1.92959e-016, -1.21946e-010>,
                         <0.6803682, 0.02273729, 3.19965>, <-0.04958278, -2.38181e-017, -8.73364e-011>,
                         <0.6803682, 0.112556, 3.25006>, <-0.06097915, -8.58978e-017, -1.0741e-010> }
        smooth_triangle {<0.6803682, 0.112556, 3.25006>, <-0.06616364, -2.41565e-016, -1.16542e-010>,
                         <0.6803682, 0.1967344, 2.60036>, <-0.08107831, -2.18791e-016, -1.42814e-010>,
                         <0.6803682, 0.07536179, 2.56636>, <-0.07339323, -3.64827e-016, -1.29277e-010> }
        smooth_triangle {<0.6803682, 0.02273729, 3.19965>, <-0.04958278, -2.38181e-017, -8.73364e-011>,
                         <0.6803682, -0.02744703, 3.83314>, <-0.03963185, -2.62626e-016, -6.98086e-011>,
                         <0.6803682, 0.02984479, 3.89966>, <-0.04559028, -1.82087e-016, -8.0304e-011> }
        smooth_triangle {<0.6803682, 0.02984479, 3.89966>, <-0.05123199, -3.47363e-017, -9.02414e-011>,
                         <0.6803682, 0.112556, 3.25006>, <-0.06136322, 5.68052e-019, -1.08087e-010>,
                         <0.6803682, 0.02273729, 3.19965>, <-0.05389366, 7.07765e-017, -9.49297e-011> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.7288661, 0.4383702, -0.7409306>, <-0.06390178, 6.24705e-016, -1.12559e-010>,
                         <-0.7288661, 0.6556396, -0.0740253>, <-0.07449228, -3.97874e-016, -1.31213e-010>,
                         <-0.7288661, 0.7621676, -0.0411523>, <-0.06390178, 6.24705e-016, -1.12559e-010> }
        smooth_triangle {<-0.7288661, 0.7621676, -0.0411523>, <-0.04977293, 1.39122e-016, -8.76714e-011>,
                         <-0.7288661, 0.5115999, -0.6927509>, <-0.03564409, -3.46462e-016, -6.27843e-011>,
                         <-0.7288661, 0.4383702, -0.7409306>, <-0.04977293, 1.39122e-016, -8.76714e-011> }
        smooth_triangle {<-0.7288661, 0.6556396, -0.0740253>, <-0.07449228, -3.97874e-016, -1.31213e-010>,
                         <-0.7288661, 0.8780162, 0.592996>, <-0.09381404, -5.71608e-016, -1.65247e-010>,
                         <-0.7288661, 1.01109, 0.6110759>, <-0.08474208, 3.65764e-016, -1.49267e-010> }
        smooth_triangle {<-0.7288661, 1.01109, 0.6110759>, <-0.07301991, 4.87586e-016, -1.28619e-010>,
                         <-0.7288661, 0.7621676, -0.0411523>, <-0.06259977, 6.17056e-016, -1.10265e-010>,
                         <-0.7288661, 0.6556396, -0.0740253>, <-0.07119365, -1.46054e-016, -1.25402e-010> }
        smooth_triangle {<-0.7288661, 0.8780162, 0.592996>, <-0.09381404, -5.71608e-016, -1.65247e-010>,
                         <-0.7288661, 1.06742, 1.27057>, <-0.1069502, -9.27744e-016, -1.88385e-010>,
                         <-0.7288661, 1.21991, 1.27578>, <-0.1023348, -9.54313e-016, -1.80255e-010> }
        smooth_triangle {<-0.7288661, 1.21991, 1.27578>, <-0.09350685, -2.56821e-016, -1.64706e-010>,
                         <-0.7288661, 1.01109, 0.6110759>, <-0.08471048, 4.03217e-016, -1.49212e-010>,
                         <-0.7288661, 0.8780162, 0.592996>, <-0.09153025, -3.18538e-016, -1.61224e-010> }
        smooth_triangle {<-0.7288661, 1.06742, 1.27057>, <-0.1069502, -9.27744e-016, -1.88385e-010>,
                         <-0.7288661, 1.08577, 1.9756>, <-0.1049563, -4.57455e-016, -1.84873e-010>,
                         <-0.7288661, 1.23898, 1.9722>, <-0.1080782, -1.37183e-015, -1.90371e-010> }
        smooth_triangle {<-0.7288661, 1.23898, 1.9722>, <-0.1070864, -1.18974e-015, -1.88624e-010>,
                         <-0.7288661, 1.21991, 1.27578>, <-0.1042147, -9.80978e-016, -1.83566e-010>,
                         <-0.7288661, 1.06742, 1.27057>, <-0.1067363, -9.47719e-016, -1.88008e-010> }
        smooth_triangle {<-0.7288661, 1.08577, 1.9756>, <-0.1049563, -4.57455e-016, -1.84873e-010>,
                         <-0.7288661, 0.9254422, 2.66073>, <-0.0846855, -4.81831e-016, -1.49168e-010>,
                         <-0.7288661, 1.06275, 2.64557>, <-0.0916447, -3.88269e-016, -1.61426e-010> }
        smooth_triangle {<-0.7288661, 1.06275, 2.64557>, <-0.09710515, -8.57326e-016, -1.71044e-010>,
                         <-0.7288661, 1.23898, 1.9722>, <-0.1053219, -1.34911e-015, -1.85517e-010>,
                         <-0.7288661, 1.08577, 1.9756>, <-0.1043586, -6.74687e-016, -1.8382e-010> }
        smooth_triangle {<-0.7288661, 0.9254422, 2.66073>, <-0.0846855, -4.81831e-016, -1.49168e-010>,
                         <-0.7288661, 0.6834946, 3.31938>, <-0.05719304, -6.49678e-016, -1.00742e-010>,
                         <-0.7288661, 0.7892513, 3.28786>, <-0.06203052, -5.02801e-016, -1.09262e-010> }
        smooth_triangle {<-0.7288661, 0.7892513, 3.28786>, <-0.07303899, -4.12641e-016, -1.28653e-010>,
                         <-0.7288661, 1.06275, 2.64557>, <-0.08784608, -3.55375e-016, -1.54735e-010>,
                         <-0.7288661, 0.9254422, 2.66073>, <-0.08452599, -4.41994e-016, -1.48887e-010> }
        smooth_triangle {<-0.7288661, 0.6834946, 3.31938>, <-0.05719304, -6.49678e-016, -1.00742e-010>,
                         <-0.7288661, 0.4381488, 3.97647>, <-0.04260322, -3.14945e-016, -7.50426e-011>,
                         <-0.7288661, 0.5113787, 3.92829>, <-0.03629792, -8.0908e-016, -6.39364e-011> }
        smooth_triangle {<-0.7288661, 0.5113787, 3.92829>, <-0.04763437, -6.50795e-016, -8.39047e-011>,
                         <-0.7288661, 0.7892513, 3.28786>, <-0.06050068, -4.97655e-016, -1.06568e-010>,
                         <-0.7288661, 0.6834946, 3.31938>, <-0.05763749, -6.10386e-016, -1.01524e-010> }
        smooth_triangle {<-0.7288661, 0.3558011, -0.7704477>, <-0.074833, -2.18409e-015, -1.31812e-010>,
                         <-0.7288661, 0.5397723, -0.09356789>, <-0.08370868, -1.1114e-015, -1.47446e-010>,
                         <-0.7288661, 0.6556396, -0.0740253>, <-0.07449228, -3.97874e-016, -1.31213e-010> }
        smooth_triangle {<-0.7288661, 0.6556396, -0.0740253>, <-0.06803236, -5.54645e-016, -1.19834e-010>,
                         <-0.7288661, 0.4383702, -0.7409306>, <-0.05627718, -2.00127e-016, -9.91281e-011>,
                         <-0.7288661, 0.3558011, -0.7704477>, <-0.06174279, -1.60453e-015, -1.08755e-010> }
        smooth_triangle {<-0.7288661, 0.5397723, -0.09356789>, <-0.08370868, -1.1114e-015, -1.47446e-010>,
                         <-0.7288661, 0.7356038, 0.5829145>, <-0.1016102, -3.69399e-016, -1.78979e-010>,
                         <-0.7288661, 0.8780162, 0.592996>, <-0.09381404, -5.71608e-016, -1.65247e-010> }
        smooth_triangle {<-0.7288661, 0.8780162, 0.592996>, <-0.08859557, -9.6094e-016, -1.56054e-010>,
                         <-0.7288661, 0.6556396, -0.0740253>, <-0.07410426, -8.3064e-016, -1.30529e-010>,
                         <-0.7288661, 0.5397723, -0.09356789>, <-0.08101655, -1.36578e-015, -1.42704e-010> }
        smooth_triangle {<-0.7288661, 0.7356038, 0.5829145>, <-0.1016102, -3.69399e-016, -1.78979e-010>,
                         <-0.7288661, 0.9055957, 1.26803>, <-0.1132431, -1.60282e-016, -1.9947e-010>,
                         <-0.7288661, 1.06742, 1.27057>, <-0.1069502, -9.27744e-016, -1.88385e-010> }
        smooth_triangle {<-0.7288661, 1.06742, 1.27057>, <-0.1038591, -9.75986e-016, -1.8294e-010>,
                         <-0.7288661, 0.8780162, 0.592996>, <-0.09400702, -7.08884e-016, -1.65586e-010>,
                         <-0.7288661, 0.7356038, 0.5829145>, <-0.09985418, -5.57227e-016, -1.75886e-010> }
        smooth_triangle {<-0.7288661, 0.9055957, 1.26803>, <-0.1132431, -1.60282e-016, -1.9947e-010>,
                         <-0.7288661, 0.9232276, 1.97634>, <-0.1110108, -3.49917e-016, -1.95537e-010>,
                         <-0.7288661, 1.08577, 1.9756>, <-0.1049563, -4.57455e-016, -1.84873e-010> }
        smooth_triangle {<-0.7288661, 1.08577, 1.9756>, <-0.1072285, -4.64955e-016, -1.88875e-010>,
                         <-0.7288661, 1.06742, 1.27057>, <-0.1087238, -8.17672e-016, -1.91509e-010>,
                         <-0.7288661, 0.9055957, 1.26803>, <-0.1134436, -2.42075e-016, -1.99822e-010> }
        smooth_triangle {<-0.7288661, 0.9232276, 1.97634>, <-0.1110108, -3.49917e-016, -1.95537e-010>,
                         <-0.7288661, 0.7787924, 2.66789>, <-0.09287696, -4.69427e-016, -1.63596e-010>,
                         <-0.7288661, 0.9254422, 2.66073>, <-0.0846855, -4.81831e-016, -1.49168e-010> }
        smooth_triangle {<-0.7288661, 0.9254422, 2.66073>, <-0.09132578, -2.68547e-016, -1.60864e-010>,
                         <-0.7288661, 1.08577, 1.9756>, <-0.1065289, -2.50265e-016, -1.87643e-010>,
                         <-0.7288661, 0.9232276, 1.97634>, <-0.1110697, -1.69612e-016, -1.95641e-010> }
        smooth_triangle {<-0.7288661, 0.7787924, 2.66789>, <-0.09287696, -4.69427e-016, -1.63596e-010>,
                         <-0.7288661, 0.5683986, 3.33758>, <-0.06770105, -1.39769e-017, -1.1925e-010>,
                         <-0.7288661, 0.6834946, 3.31938>, <-0.05719304, -6.49678e-016, -1.00742e-010> }
        smooth_triangle {<-0.7288661, 0.6834946, 3.31938>, <-0.06660955, -6.16068e-016, -1.17328e-010>,
                         <-0.7288661, 0.9254422, 2.66073>, <-0.08722889, -4.90182e-016, -1.53648e-010>,
                         <-0.7288661, 0.7787924, 2.66789>, <-0.09337249, -4.80879e-016, -1.64469e-010> }
        smooth_triangle {<-0.7288661, 0.5683986, 3.33758>, <-0.06770105, -1.39769e-017, -1.1925e-010>,
                         <-0.7288661, 0.3555797, 4.00599>, <-0.05367492, 9.17105e-017, -9.45444e-011>,
                         <-0.7288661, 0.4381488, 3.97647>, <-0.04260322, -3.14945e-016, -7.50426e-011> }
        smooth_triangle {<-0.7288661, 0.4381488, 3.97647>, <-0.05212381, -4.17077e-016, -9.18124e-011>,
                         <-0.7288661, 0.6834946, 3.31938>, <-0.06068603, -6.42594e-016, -1.06894e-010>,
                         <-0.7288661, 0.5683986, 3.33758>, <-0.06856703, -1.65818e-016, -1.20776e-010> }
        smooth_triangle {<-0.7288661, 0.2686217, -0.7709801>, <-0.08192782, -2.38295e-017, -1.4431e-010>,
                         <-0.7288661, 0.4192946, -0.09240705>, <-0.08766115, 4.95449e-016, -1.54409e-010>,
                         <-0.7288661, 0.5397723, -0.09356789>, <-0.08370868, -1.1114e-015, -1.47446e-010> }
        smooth_triangle {<-0.7288661, 0.5397723, -0.09356789>, <-0.07750952, -9.60468e-016, -1.36527e-010>,
                         <-0.7288661, 0.3558011, -0.7704477>, <-0.06687253, -1.34588e-015, -1.17791e-010>,
                         <-0.7288661, 0.2686217, -0.7709801>, <-0.07041994, -2.65754e-016, -1.24039e-010> }
        smooth_triangle {<-0.7288661, 0.4192946, -0.09240705>, <-0.08766115, 4.95449e-016, -1.54409e-010>,
                         <-0.7288661, 0.588581, 0.585255>, <-0.1041417, 6.27688e-016, -1.83439e-010>,
                         <-0.7288661, 0.7356038, 0.5829145>, <-0.1016102, -3.69399e-016, -1.78979e-010> }
        smooth_triangle {<-0.7288661, 0.7356038, 0.5829145>, <-0.09663978, -2.83569e-016, -1.70224e-010>,
                         <-0.7288661, 0.5397723, -0.09356789>, <-0.0832136, -8.40069e-016, -1.46574e-010>,
                         <-0.7288661, 0.4192946, -0.09240705>, <-0.08617795, 3.65067e-016, -1.51796e-010> }
        smooth_triangle {<-0.7288661, 0.588581, 0.585255>, <-0.1041417, 6.27688e-016, -1.83439e-010>,
                         <-0.7288661, 0.7391602, 1.26963>, <-0.1141415, -1.22967e-016, -2.01052e-010>,
                         <-0.7288661, 0.9055957, 1.26803>, <-0.1132431, -1.60282e-016, -1.9947e-010> }
        smooth_triangle {<-0.7288661, 0.9055957, 1.26803>, <-0.1102138, -6.82298e-019, -1.94134e-010>,
                         <-0.7288661, 0.7356038, 0.5829145>, <-0.1014892, -1.5752e-016, -1.78766e-010>,
                         <-0.7288661, 0.588581, 0.585255>, <-0.1033878, 5.90295e-016, -1.8211e-010> }
        smooth_triangle {<-0.7288661, 0.7391602, 1.26963>, <-0.1141415, -1.22967e-016, -2.01052e-010>,
                         <-0.7288661, 0.7560706, 1.97294>, <-0.1117743, 7.79086e-017, -1.96882e-010>,
                         <-0.7288661, 0.9232276, 1.97634>, <-0.1110108, -3.49917e-016, -1.95537e-010> }
        smooth_triangle {<-0.7288661, 0.9232276, 1.97634>, <-0.112737, -3.6724e-016, -1.98578e-010>,
                         <-0.7288661, 0.9055957, 1.26803>, <-0.1144113, -2.25014e-016, -2.01527e-010>,
                         <-0.7288661, 0.7391602, 1.26963>, <-0.1150851, -1.97028e-016, -2.02714e-010> }
        smooth_triangle {<-0.7288661, 0.7560706, 1.97294>, <-0.1117743, 7.79086e-017, -1.96882e-010>,
                         <-0.7288661, 0.6275322, 2.66263>, <-0.09609024, 4.52422e-016, -1.69256e-010>,
                         <-0.7288661, 0.7787924, 2.66789>, <-0.09287696, -4.69427e-016, -1.63596e-010> }
        smooth_triangle {<-0.7288661, 0.7787924, 2.66789>, <-0.09867988, -5.654e-016, -1.73818e-010>,
                         <-0.7288661, 0.9232276, 1.97634>, <-0.1122802, -4.75768e-016, -1.97773e-010>,
                         <-0.7288661, 0.7560706, 1.97294>, <-0.1128529, -1.54899e-016, -1.98782e-010> }
        smooth_triangle {<-0.7288661, 0.6275322, 2.66263>, <-0.09609024, 4.52422e-016, -1.69256e-010>,
                         <-0.7288661, 0.4486923, 3.33506>, <-0.0733741, 1.94178e-016, -1.29243e-010>,
                         <-0.7288661, 0.5683986, 3.33758>, <-0.06770105, -1.39769e-017, -1.1925e-010> }
        smooth_triangle {<-0.7288661, 0.5683986, 3.33758>, <-0.07637671, -6.68755e-017, -1.34532e-010>,
                         <-0.7288661, 0.7787924, 2.66789>, <-0.09525864, -4.08463e-016, -1.67791e-010>,
                         <-0.7288661, 0.6275322, 2.66263>, <-0.09766861, 2.82924e-016, -1.72036e-010> }
        smooth_triangle {<-0.7288661, 0.4486923, 3.33506>, <-0.0733741, 1.94178e-016, -1.29243e-010>,
                         <-0.7288661, 0.2684003, 4.00652>, <-0.05906476, 7.54326e-017, -1.04038e-010>,
                         <-0.7288661, 0.3555797, 4.00599>, <-0.05367492, 9.17105e-017, -9.45444e-011> }
        smooth_triangle {<-0.7288661, 0.3555797, 4.00599>, <-0.06263257, 1.9908e-016, -1.10323e-010>,
                         <-0.7288661, 0.5683986, 3.33758>, <-0.07091276, 9.2972e-017, -1.24908e-010>,
                         <-0.7288661, 0.4486923, 3.33506>, <-0.07516755, 2.49088e-016, -1.32402e-010> }
        smooth_triangle {<-0.7288661, 0.185037, -0.7441568>, <-0.08102766, 1.03501e-015, -1.42724e-010>,
                         <-0.7288661, 0.3024117, -0.07170645>, <-0.08592928, 1.42815e-015, -1.51358e-010>,
                         <-0.7288661, 0.4192946, -0.09240705>, <-0.08766115, 4.95449e-016, -1.54409e-010> }
        smooth_triangle {<-0.7288661, 0.4192946, -0.09240705>, <-0.08093582, 8.62225e-016, -1.42563e-010>,
                         <-0.7288661, 0.2686217, -0.7709801>, <-0.07134381, 9.69361e-016, -1.25667e-010>,
                         <-0.7288661, 0.185037, -0.7441568>, <-0.07089373, 1.49878e-015, -1.24874e-010> }
        smooth_triangle {<-0.7288661, 0.3024117, -0.07170645>, <-0.08592928, 1.42815e-015, -1.51358e-010>,
                         <-0.7288661, 0.445153, 0.5993194>, <-0.1015808, 9.96671e-016, -1.78928e-010>,
                         <-0.7288661, 0.588581, 0.585255>, <-0.1041417, 6.27688e-016, -1.83439e-010> }
        smooth_triangle {<-0.7288661, 0.588581, 0.585255>, <-0.09878415, 7.10024e-016, -1.74002e-010>,
                         <-0.7288661, 0.4192946, -0.09240705>, <-0.08642372, 6.10845e-016, -1.52229e-010>,
                         <-0.7288661, 0.3024117, -0.07170645>, <-0.08512482, 1.31037e-015, -1.49941e-010> }
        smooth_triangle {<-0.7288661, 0.445153, 0.5993194>, <-0.1015808, 9.96671e-016, -1.78928e-010>,
                         <-0.7288661, 0.5763196, 1.27514>, <-0.1104779, 8.44849e-016, -1.94599e-010>,
                         <-0.7288661, 0.7391602, 1.26963>, <-0.1141415, -1.22967e-016, -2.01052e-010> }
        smooth_triangle {<-0.7288661, 0.7391602, 1.26963>, <-0.1106753, 3.77589e-016, -1.94947e-010>,
                         <-0.7288661, 0.588581, 0.585255>, <-0.1031755, 9.4058e-016, -1.81737e-010>,
                         <-0.7288661, 0.445153, 0.5993194>, <-0.1012548, 1.21732e-015, -1.78353e-010> }
        smooth_triangle {<-0.7288661, 0.5763196, 1.27514>, <-0.1104779, 8.44849e-016, -1.94599e-010>,
                         <-0.7288661, 0.5925085, 1.96563>, <-0.1081068, 1.27286e-015, -1.90422e-010>,
                         <-0.7288661, 0.7560706, 1.97294>, <-0.1117743, 7.79086e-017, -1.96882e-010> }
        smooth_triangle {<-0.7288661, 0.7560706, 1.97294>, <-0.1124857, 3.03872e-016, -1.98135e-010>,
                         <-0.7288661, 0.7391602, 1.26963>, <-0.1142611, 1.53215e-016, -2.01262e-010>,
                         <-0.7288661, 0.5763196, 1.27514>, <-0.1115134, 8.79077e-016, -1.96422e-010> }
        smooth_triangle {<-0.7288661, 0.5925085, 1.96563>, <-0.1081068, 1.27286e-015, -1.90422e-010>,
                         <-0.7288661, 0.4798669, 2.64564>, <-0.09414028, 3.33072e-016, -1.65821e-010>,
                         <-0.7288661, 0.6275322, 2.66263>, <-0.09609024, 4.52422e-016, -1.69256e-010> }
        smooth_triangle {<-0.7288661, 0.6275322, 2.66263>, <-0.1005044, 6.8103e-016, -1.77031e-010>,
                         <-0.7288661, 0.7560706, 1.97294>, <-0.1122674, 4.00145e-016, -1.97751e-010>,
                         <-0.7288661, 0.5925085, 1.96563>, <-0.1095168, 1.29636e-015, -1.92906e-010> }
        smooth_triangle {<-0.7288661, 0.4798669, 2.64564>, <-0.09414028, 3.33072e-016, -1.65821e-010>,
                         <-0.7288661, 0.3325808, 3.31301>, <-0.07296618, 3.05324e-016, -1.28524e-010>,
                         <-0.7288661, 0.4486923, 3.33506>, <-0.0733741, 1.94178e-016, -1.29243e-010> }
        smooth_triangle {<-0.7288661, 0.4486923, 3.33506>, <-0.08061383, 4.24799e-016, -1.41995e-010>,
                         <-0.7288661, 0.6275322, 2.66263>, <-0.09765093, 6.18482e-016, -1.72005e-010>,
                         <-0.7288661, 0.4798669, 2.64564>, <-0.09618846, 5.28969e-016, -1.69429e-010> }
        smooth_triangle {<-0.7288661, 0.3325808, 3.31301>, <-0.07296618, 3.05324e-016, -1.28524e-010>,
                         <-0.7288661, 0.1848157, 3.9797>, <-0.05867906, 2.65565e-016, -1.03359e-010>,
                         <-0.7288661, 0.2684003, 4.00652>, <-0.05906476, 7.54326e-017, -1.04038e-010> }
        smooth_triangle {<-0.7288661, 0.2684003, 4.00652>, <-0.06668972, 1.11158e-016, -1.17469e-010>,
                         <-0.7288661, 0.4486923, 3.33506>, <-0.07551549, 1.91286e-016, -1.33015e-010>,
                         <-0.7288661, 0.3325808, 3.31301>, <-0.07520954, 2.74645e-016, -1.32476e-010> }
        smooth_triangle {<-0.7288661, 0.1033505, -0.7117904>, <-0.07850875, 1.43005e-015, -1.38288e-010>,
                         <-0.7288661, 0.1874269, -0.04704645>, <-0.08186531, 2.78142e-016, -1.442e-010>,
                         <-0.7288661, 0.3024117, -0.07170645>, <-0.08592928, 1.42815e-015, -1.51358e-010> }
        smooth_triangle {<-0.7288661, 0.3024117, -0.07170645>, <-0.07912924, 1.19875e-015, -1.39381e-010>,
                         <-0.7288661, 0.185037, -0.7441568>, <-0.06987838, 7.72779e-016, -1.23086e-010>,
                         <-0.7288661, 0.1033505, -0.7117904>, <-0.06861893, 9.70298e-016, -1.20867e-010> }
        smooth_triangle {<-0.7288661, 0.1874269, -0.04704645>, <-0.08186531, 2.78142e-016, -1.442e-010>,
                         <-0.7288661, 0.3036232, 0.6157595>, <-0.09739369, 1.78899e-016, -1.71552e-010>,
                         <-0.7288661, 0.445153, 0.5993194>, <-0.1015808, 9.96671e-016, -1.78928e-010> }
        smooth_triangle {<-0.7288661, 0.445153, 0.5993194>, <-0.09635502, 1.08385e-015, -1.69723e-010>,
                         <-0.7288661, 0.3024117, -0.07170645>, <-0.0846164, 1.40746e-015, -1.49046e-010>,
                         <-0.7288661, 0.1874269, -0.04704645>, <-0.08156842, 5.44952e-016, -1.43677e-010> }
        smooth_triangle {<-0.7288661, 0.3036232, 0.6157595>, <-0.09739369, 1.78899e-016, -1.71552e-010>,
                         <-0.7288661, 0.415377, 1.28144>, <-0.1057091, 5.93978e-016, -1.86199e-010>,
                         <-0.7288661, 0.5763196, 1.27514>, <-0.1104779, 8.44849e-016, -1.94599e-010> }
        smooth_triangle {<-0.7288661, 0.5763196, 1.27514>, <-0.1073097, 7.01591e-016, -1.89018e-010>,
                         <-0.7288661, 0.445153, 0.5993194>, <-0.1006369, 8.15458e-016, -1.77265e-010>,
                         <-0.7288661, 0.3036232, 0.6157595>, <-0.09749661, 2.02129e-016, -1.71733e-010> }
        smooth_triangle {<-0.7288661, 0.415377, 1.28144>, <-0.1057091, 5.93978e-016, -1.86199e-010>,
                         <-0.7288661, 0.4308445, 1.95753>, <-0.1030393, 7.94441e-017, -1.81496e-010>,
                         <-0.7288661, 0.5925085, 1.96563>, <-0.1081068, 1.27286e-015, -1.90422e-010> }
        smooth_triangle {<-0.7288661, 0.5925085, 1.96563>, <-0.1088878, 1.03043e-015, -1.91798e-010>,
                         <-0.7288661, 0.5763196, 1.27514>, <-0.1106661, 7.09424e-016, -1.9493e-010>,
                         <-0.7288661, 0.415377, 1.28144>, <-0.1070895, 5.21271e-016, -1.8863e-010> }
        smooth_triangle {<-0.7288661, 0.4308445, 1.95753>, <-0.1030393, 7.94441e-017, -1.81496e-010>,
                         <-0.7288661, 0.3340996, 2.62628>, <-0.08988044, 2.78856e-016, -1.58318e-010>,
                         <-0.7288661, 0.4798669, 2.64564>, <-0.09414028, 3.33072e-016, -1.65821e-010> }
        smooth_triangle {<-0.7288661, 0.4798669, 2.64564>, <-0.09831687, 5.89432e-016, -1.73178e-010>,
                         <-0.7288661, 0.5925085, 1.96563>, <-0.1087918, 1.29427e-015, -1.91629e-010>,
                         <-0.7288661, 0.4308445, 1.95753>, <-0.1049911, 3.99211e-016, -1.84934e-010> }
        smooth_triangle {<-0.7288661, 0.3340996, 2.62628>, <-0.08988044, 2.78856e-016, -1.58318e-010>,
                         <-0.7288661, 0.2183673, 3.287>, <-0.06933273, 1.13369e-016, -1.22124e-010>,
                         <-0.7288661, 0.3325808, 3.31301>, <-0.07296618, 3.05324e-016, -1.28524e-010> }
        smooth_triangle {<-0.7288661, 0.3325808, 3.31301>, <-0.07975766, 1.45876e-016, -1.40487e-010>,
                         <-0.7288661, 0.4798669, 2.64564>, <-0.09563824, 1.66688e-016, -1.6846e-010>,
                         <-0.7288661, 0.3340996, 2.62628>, <-0.09244336, 1.26026e-016, -1.62832e-010> }
        smooth_triangle {<-0.7288661, 0.2183673, 3.287>, <-0.06933273, 1.13369e-016, -1.22124e-010>,
                         <-0.7288661, 0.1031292, 3.94733>, <-0.0546093, 2.8836e-016, -9.61902e-011>,
                         <-0.7288661, 0.1848157, 3.9797>, <-0.05867906, 2.65565e-016, -1.03359e-010> }
        smooth_triangle {<-0.7288661, 0.1848157, 3.9797>, <-0.06578201, 3.76417e-016, -1.1587e-010>,
                         <-0.7288661, 0.3325808, 3.31301>, <-0.07472162, 3.78523e-016, -1.31617e-010>,
                         <-0.7288661, 0.2183673, 3.287>, <-0.07199653, 2.34556e-016, -1.26817e-010> }
        smooth_triangle {<-0.7288661, 0.0300661, -0.6641178>, <-0.07137007, -8.40607e-016, -1.25713e-010>,
                         <-0.7288661, 0.08084425, -0.0114535>, <-0.07279794, -1.02498e-016, -1.28228e-010>,
                         <-0.7288661, 0.1874269, -0.04704645>, <-0.08186531, 2.78142e-016, -1.442e-010> }
        smooth_triangle {<-0.7288661, 0.1874269, -0.04704645>, <-0.07457986, 1.97287e-016, -1.31367e-010>,
                         <-0.7288661, 0.1033505, -0.7117904>, <-0.06561614, 6.92386e-016, -1.15578e-010>,
                         <-0.7288661, 0.0300661, -0.6641178>, <-0.0620468, -4.42942e-016, -1.09291e-010> }
        smooth_triangle {<-0.7288661, 0.08084425, -0.0114535>, <-0.07279794, -1.02498e-016, -1.28228e-010>,
                         <-0.7288661, 0.1704954, 0.6387593>, <-0.08825159, 2.40874e-016, -1.55449e-010>,
                         <-0.7288661, 0.3036232, 0.6157595>, <-0.09739369, 1.78899e-016, -1.71552e-010> }
        smooth_triangle {<-0.7288661, 0.3036232, 0.6157595>, <-0.09174012, -1.10973e-016, -1.61594e-010>,
                         <-0.7288661, 0.1874269, -0.04704645>, <-0.08009383, -3.65409e-017, -1.41079e-010>,
                         <-0.7288661, 0.08084425, -0.0114535>, <-0.07329331, -3.22021e-016, -1.29101e-010> }
        smooth_triangle {<-0.7288661, 0.1704954, 0.6387593>, <-0.08825159, 2.40874e-016, -1.55449e-010>,
                         <-0.7288661, 0.2628365, 1.28993>, <-0.09590536, -2.61705e-016, -1.6893e-010>,
                         <-0.7288661, 0.415377, 1.28144>, <-0.1057091, 5.93978e-016, -1.86199e-010> }
        smooth_triangle {<-0.7288661, 0.415377, 1.28144>, <-0.1020796, 4.66359e-016, -1.79806e-010>,
                         <-0.7288661, 0.3036232, 0.6157595>, <-0.09584304, 1.5505e-016, -1.68821e-010>,
                         <-0.7288661, 0.1704954, 0.6387593>, <-0.08898646, 2.01531e-016, -1.56743e-010> }
        smooth_triangle {<-0.7288661, 0.2628365, 1.28993>, <-0.09590536, -2.61705e-016, -1.6893e-010>,
                         <-0.7288661, 0.2775825, 1.94724>, <-0.09304367, -9.25939e-018, -1.63889e-010>,
                         <-0.7288661, 0.4308445, 1.95753>, <-0.1030393, 7.94441e-017, -1.81496e-010> }
        smooth_triangle {<-0.7288661, 0.4308445, 1.95753>, <-0.1030949, 1.0905e-016, -1.81594e-010>,
                         <-0.7288661, 0.415377, 1.28144>, <-0.1050972, 4.94951e-016, -1.85121e-010>,
                         <-0.7288661, 0.2628365, 1.28993>, <-0.09774442, -1.46812e-016, -1.72169e-010> }
        smooth_triangle {<-0.7288661, 0.2775825, 1.94724>, <-0.09304367, -9.25939e-018, -1.63889e-010>,
                         <-0.7288661, 0.1967344, 2.60036>, <-0.08086536, -4.68123e-017, -1.42438e-010>,
                         <-0.7288661, 0.3340996, 2.62628>, <-0.08988044, 2.78856e-016, -1.58318e-010> }
        smooth_triangle {<-0.7288661, 0.3340996, 2.62628>, <-0.09328291, 1.88048e-017, -1.64311e-010>,
                         <-0.7288661, 0.4308445, 1.95753>, <-0.1031521, -1.30754e-016, -1.81695e-010>,
                         <-0.7288661, 0.2775825, 1.94724>, <-0.09565533, -1.97282e-016, -1.6849e-010> }
        smooth_triangle {<-0.7288661, 0.1967344, 2.60036>, <-0.08086536, -4.68123e-017, -1.42438e-010>,
                         <-0.7288661, 0.112556, 3.25006>, <-0.06097915, -1.67001e-017, -1.0741e-010>,
                         <-0.7288661, 0.2183673, 3.287>, <-0.06933273, 1.13369e-016, -1.22124e-010> }
        smooth_triangle {<-0.7288661, 0.2183673, 3.287>, <-0.07543946, 2.16571e-016, -1.32881e-010>,
                         <-0.7288661, 0.3340996, 2.62628>, <-0.09085024, 3.40687e-016, -1.60026e-010>,
                         <-0.7288661, 0.1967344, 2.60036>, <-0.08408893, 9.64357e-017, -1.48117e-010> }
        smooth_triangle {<-0.7288661, 0.112556, 3.25006>, <-0.06097915, -1.67001e-017, -1.0741e-010>,
                         <-0.7288661, 0.02984479, 3.89966>, <-0.04559028, -8.14436e-017, -8.03039e-011>,
                         <-0.7288661, 0.1031292, 3.94733>, <-0.0546093, 2.8836e-016, -9.61902e-011> }
        smooth_triangle {<-0.7288661, 0.1031292, 3.94733>, <-0.06111544, -1.76214e-017, -1.0765e-010>,
                         <-0.7288661, 0.2183673, 3.287>, <-0.07053148, -7.23696e-017, -1.24236e-010>,
                         <-0.7288661, 0.112556, 3.25006>, <-0.06426629, -1.69921e-016, -1.132e-010> }
        smooth_triangle {<-0.7288661, -0.0272259, -0.5975998>, <-0.0584004, 5.16808e-016, -1.02868e-010>,
                         <-0.7288661, -0.009745987, 0.03760044>, <-0.06720929, 5.21867e-016, -1.18384e-010>,
                         <-0.7288661, 0.08084425, -0.0114535>, <-0.07279794, -1.02498e-016, -1.28228e-010> }
        smooth_triangle {<-0.7288661, 0.08084425, -0.0114535>, <-0.06479098, 1.44497e-016, -1.14125e-010>,
                         <-0.7288661, 0.0300661, -0.6641178>, <-0.05607009, 2.24364e-017, -9.87632e-011>,
                         <-0.7288661, -0.0272259, -0.5975998>, <-0.04958525, 7.01143e-016, -8.73407e-011> }
        smooth_triangle {<-0.7288661, -0.009745987, 0.03760044>, <-0.06720929, 5.21867e-016, -1.18384e-010>,
                         <-0.7288661, 0.05336007, 0.6698357>, <-0.08151611, 1.65114e-016, -1.43585e-010>,
                         <-0.7288661, 0.1704954, 0.6387593>, <-0.08825159, 2.40874e-016, -1.55449e-010> }
        smooth_triangle {<-0.7288661, 0.1704954, 0.6387593>, <-0.08201386, 2.43496e-016, -1.44462e-010>,
                         <-0.7288661, 0.08084425, -0.0114535>, <-0.07042362, -1.4033e-017, -1.24046e-010>,
                         <-0.7288661, -0.009745987, 0.03760044>, <-0.06590641, 4.31698e-016, -1.1609e-010> }
        smooth_triangle {<-0.7288661, 0.05336007, 0.6698357>, <-0.08151611, 1.65114e-016, -1.43585e-010>,
                         <-0.7288661, 0.1262885, 1.30111>, <-0.08687203, -3.58321e-018, -1.53019e-010>,
                         <-0.7288661, 0.2628365, 1.28993>, <-0.09590536, -2.61705e-016, -1.6893e-010> }
        smooth_triangle {<-0.7288661, 0.2628365, 1.28993>, <-0.09171514, -3.5948e-017, -1.61549e-010>,
                         <-0.7288661, 0.1704954, 0.6387593>, <-0.08597481, 3.40986e-016, -1.51439e-010>,
                         <-0.7288661, 0.05336007, 0.6698357>, <-0.08072556, 3.23851e-016, -1.42192e-010> }
        smooth_triangle {<-0.7288661, 0.1262885, 1.30111>, <-0.08687203, -3.58321e-018, -1.53019e-010>,
                         <-0.7288661, 0.1403131, 1.93426>, <-0.08282942, 7.50249e-017, -1.45898e-010>,
                         <-0.7288661, 0.2775825, 1.94724>, <-0.09304367, -9.25939e-018, -1.63889e-010> }
        smooth_triangle {<-0.7288661, 0.2775825, 1.94724>, <-0.09226253, -5.42499e-017, -1.62513e-010>,
                         <-0.7288661, 0.2628365, 1.28993>, <-0.0944088, -2.43584e-016, -1.66294e-010>,
                         <-0.7288661, 0.1262885, 1.30111>, <-0.08788772, -6.54626e-017, -1.54808e-010> }
        smooth_triangle {<-0.7288661, 0.1403131, 1.93426>, <-0.08282942, 7.50249e-017, -1.45898e-010>,
                         <-0.7288661, 0.07536179, 2.56636>, <-0.06923127, 1.84824e-016, -1.21946e-010>,
                         <-0.7288661, 0.1967344, 2.60036>, <-0.08086536, -4.68123e-017, -1.42438e-010> }
        smooth_triangle {<-0.7288661, 0.1967344, 2.60036>, <-0.08332491, 2.41354e-017, -1.46771e-010>,
                         <-0.7288661, 0.2775825, 1.94724>, <-0.09245864, 5.23e-017, -1.62859e-010>,
                         <-0.7288661, 0.1403131, 1.93426>, <-0.08545413, 1.29009e-016, -1.50521e-010> }
        smooth_triangle {<-0.7288661, 0.07536179, 2.56636>, <-0.06923127, 1.84824e-016, -1.21946e-010>,
                         <-0.7288661, 0.02273729, 3.19965>, <-0.04958278, 2.70083e-017, -8.73364e-011>,
                         <-0.7288661, 0.112556, 3.25006>, <-0.06097915, -1.67001e-017, -1.0741e-010> }
        smooth_triangle {<-0.7288661, 0.112556, 3.25006>, <-0.06616364, -4.35177e-017, -1.16542e-010>,
                         <-0.7288661, 0.1967344, 2.60036>, <-0.08107831, -6.61018e-017, -1.42814e-010>,
                         <-0.7288661, 0.07536179, 2.56636>, <-0.07339323, 8.18922e-017, -1.29277e-010> }
        smooth_triangle {<-0.7288661, 0.02273729, 3.19965>, <-0.04958278, 2.70083e-017, -8.73364e-011>,
                         <-0.7288661, -0.02744703, 3.83314>, <-0.03963185, -3.55112e-016, -6.98086e-011>,
                         <-0.7288661, 0.02984479, 3.89966>, <-0.04559028, -8.14436e-017, -8.03039e-011> }
        smooth_triangle {<-0.7288661, 0.02984479, 3.89966>, <-0.05123199, 1.06345e-016, -9.02414e-011>,
                         <-0.7288661, 0.112556, 3.25006>, <-0.06136322, 1.07956e-016, -1.08087e-010>,
                         <-0.7288661, 0.02273729, 3.19965>, <-0.05389366, 1.78646e-016, -9.49297e-011> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.7288661, 0.4383702, -0.7409306>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.5275469, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <-0.5275469, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<-0.5275469, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.7288661, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.7288661, 0.4383702, -0.7409306>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<-0.5275469, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <-0.3262277, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <-0.3262277, 0.5115999, -0.6927509>, <-2.41899e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<-0.3262277, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.5275469, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.5275469, 0.4383702, -0.7409306>, <-2.49613e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<-0.3262277, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <-0.1249086, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <-0.1249086, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<-0.1249086, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.3262277, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.3262277, 0.4383702, -0.7409306>, <-2.49613e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<-0.1249086, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.07641062, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.07641062, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<0.07641062, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.1249086, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <-0.1249086, 0.4383702, -0.7409306>, <-2.49612e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<0.07641062, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.2777298, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.2777298, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<0.2777298, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <0.07641062, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <0.07641062, 0.4383702, -0.7409306>, <-2.49613e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<0.2777298, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.479049, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.479049, 0.5115999, -0.6927509>, <-2.41899e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<0.479049, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <0.2777298, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <0.2777298, 0.4383702, -0.7409306>, <-2.49613e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<0.479049, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928>,
                         <0.6803682, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.6803682, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254> }
        smooth_triangle {<0.6803682, 0.5115999, -0.6927509>, <-2.419e-011, -0.009699497, 0.01474254>,
                         <0.479049, 0.5115999, -0.6927509>, <-2.41899e-011, -0.009699497, 0.01474254>,
                         <0.479049, 0.4383702, -0.7409306>, <-2.49612e-011, -0.008760215, 0.01521259> }
        smooth_triangle {<-0.7288661, 0.3558011, -0.7704477>, <-2.7275e-011, -0.00594237, 0.01662274>,
                         <-0.5275469, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <-0.5275469, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<-0.5275469, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.7288661, 0.4383702, -0.7409306>, <-2.57326e-011, -0.007820934, 0.01568264>,
                         <-0.7288661, 0.3558011, -0.7704477>, <-2.72751e-011, -0.00594237, 0.01662274> }
        smooth_triangle {<-0.5275469, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <-0.3262277, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <-0.3262277, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<-0.3262277, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.5275469, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.5275469, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<-0.3262277, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <-0.1249086, 0.3558011, -0.7704477>, <-2.77826e-011, -0.003997305, 0.01693212>,
                         <-0.1249086, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<-0.1249086, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.3262277, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.3262277, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<-0.1249086, 0.3558011, -0.7704477>, <-2.77826e-011, -0.003997305, 0.01693212>,
                         <0.07641062, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.07641062, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<0.07641062, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.1249086, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <-0.1249086, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<0.07641062, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.2777298, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.2777298, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<0.2777298, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.07641062, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.07641062, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<0.2777298, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.479049, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.479049, 0.4383702, -0.7409306>, <-2.52183e-011, -0.008447122, 0.01536928> }
        smooth_triangle {<0.479049, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.2777298, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.2777298, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<0.479049, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212>,
                         <0.6803682, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.6803682, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264> }
        smooth_triangle {<0.6803682, 0.4383702, -0.7409306>, <-2.62467e-011, -0.007194746, 0.01599601>,
                         <0.479049, 0.4383702, -0.7409306>, <-2.57325e-011, -0.007820934, 0.01568264>,
                         <0.479049, 0.3558011, -0.7704477>, <-2.76558e-011, -0.004483571, 0.01685478> }
        smooth_triangle {<-0.7288661, 0.2686217, -0.7709801>, <-2.87979e-011, -0.0001071754, 0.01755089>,
                         <-0.5275469, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <-0.5275469, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<-0.5275469, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.7288661, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.7288661, 0.2686217, -0.7709801>, <-2.87979e-011, -0.0001071754, 0.01755089> }
        smooth_triangle {<-0.5275469, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <-0.3262277, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <-0.3262277, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<-0.3262277, 0.3558011, -0.7704477>, <-2.80366e-011, -0.003024773, 0.01708682>,
                         <-0.5275469, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.5275469, 0.2686217, -0.7709801>, <-2.85011e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<-0.3262277, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <-0.1249086, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966>,
                         <-0.1249086, 0.3558011, -0.7704477>, <-2.77826e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<-0.1249086, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.3262277, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.3262277, 0.2686217, -0.7709801>, <-2.85011e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<-0.1249086, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966>,
                         <0.07641062, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <0.07641062, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<0.07641062, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.1249086, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <-0.1249086, 0.2686217, -0.7709801>, <-2.8501e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<0.07641062, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <0.2777298, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966>,
                         <0.2777298, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<0.2777298, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.07641062, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.07641062, 0.2686217, -0.7709801>, <-2.85012e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<0.2777298, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966>,
                         <0.479049, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <0.479049, 0.3558011, -0.7704477>, <-2.77827e-011, -0.003997305, 0.01693212> }
        smooth_triangle {<0.479049, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.2777298, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.2777298, 0.2686217, -0.7709801>, <-2.85011e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<0.479049, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966>,
                         <0.6803682, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <0.6803682, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682> }
        smooth_triangle {<0.6803682, 0.3558011, -0.7704477>, <-2.82904e-011, -0.00205224, 0.01724151>,
                         <0.479049, 0.3558011, -0.7704477>, <-2.80365e-011, -0.003024773, 0.01708682>,
                         <0.479049, 0.2686217, -0.7709801>, <-2.85011e-011, 0.001269628, 0.01736997> }
        smooth_triangle {<-0.7288661, 0.185037, -0.7441568>, <-2.76104e-011, 0.00540004, 0.01682719>,
                         <-0.5275469, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <-0.5275469, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<-0.5275469, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <-0.7288661, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <-0.7288661, 0.185037, -0.7441568>, <-2.76104e-011, 0.00540004, 0.01682719> }
        smooth_triangle {<-0.5275469, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <-0.3262277, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <-0.3262277, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<-0.3262277, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <-0.5275469, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <-0.5275469, 0.185037, -0.7441568>, <-2.74538e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<-0.3262277, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <-0.1249086, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <-0.1249086, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<-0.1249086, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <-0.3262277, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <-0.3262277, 0.185037, -0.7441568>, <-2.74537e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<-0.1249086, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <0.07641062, 0.185037, -0.7441568>, <-2.74016e-011, 0.00577202, 0.01669981>,
                         <0.07641062, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<0.07641062, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <-0.1249086, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <-0.1249086, 0.185037, -0.7441568>, <-2.74538e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<0.07641062, 0.185037, -0.7441568>, <-2.74016e-011, 0.00577202, 0.01669981>,
                         <0.2777298, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <0.2777298, 0.2686217, -0.7709801>, <-2.84021e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<0.2777298, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <0.07641062, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904>,
                         <0.07641062, 0.185037, -0.7441568>, <-2.74538e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<0.2777298, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <0.479049, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <0.479049, 0.2686217, -0.7709801>, <-2.84022e-011, 0.001728563, 0.01730966> }
        smooth_triangle {<0.479049, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <0.2777298, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <0.2777298, 0.185037, -0.7441568>, <-2.74537e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<0.479049, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981>,
                         <0.6803682, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <0.6803682, 0.2686217, -0.7709801>, <-2.82043e-011, 0.002646432, 0.01718904> }
        smooth_triangle {<0.6803682, 0.2686217, -0.7709801>, <-2.80064e-011, 0.003564301, 0.01706842>,
                         <0.479049, 0.2686217, -0.7709801>, <-2.82042e-011, 0.002646432, 0.01718904>,
                         <0.479049, 0.185037, -0.7441568>, <-2.74538e-011, 0.005679025, 0.01673165> }
        smooth_triangle {<-0.7288661, 0.1033505, -0.7117904>, <-2.69835e-011, 0.006515981, 0.01644506>,
                         <-0.5275469, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <-0.5275469, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<-0.5275469, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <-0.7288661, 0.185037, -0.7441568>, <-2.72969e-011, 0.00595801, 0.01663612>,
                         <-0.7288661, 0.1033505, -0.7117904>, <-2.69834e-011, 0.006515981, 0.01644506> }
        smooth_triangle {<-0.5275469, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <-0.3262277, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <-0.3262277, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<-0.3262277, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <-0.5275469, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <-0.5275469, 0.1033505, -0.7117904>, <-2.62897e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<-0.3262277, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <-0.1249086, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,
                         <-0.1249086, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<-0.1249086, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <-0.3262277, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <-0.3262277, 0.1033505, -0.7117904>, <-2.62896e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<-0.1249086, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,
                         <0.07641062, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,
                         <0.07641062, 0.185037, -0.7441568>, <-2.74016e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<0.07641062, 0.185037, -0.7441568>, <-2.72971e-011, 0.00595801, 0.01663612>,
                         <-0.1249086, 0.185037, -0.7441568>, <-2.72971e-011, 0.00595801, 0.01663612>,
                         <-0.1249086, 0.1033505, -0.7117904>, <-2.62897e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<0.07641062, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,
                         <0.2777298, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,

                         <0.2777298, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<0.2777298, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <0.07641062, 0.185037, -0.7441568>, <-2.72971e-011, 0.00595801, 0.01663612>,
                         <0.07641062, 0.1033505, -0.7117904>, <-2.62897e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<0.2777298, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123>,
                         <0.479049, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <0.479049, 0.185037, -0.7441568>, <-2.74015e-011, 0.00577202, 0.01669981> }
        smooth_triangle {<0.479049, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <0.2777298, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <0.2777298, 0.1033505, -0.7117904>, <-2.62896e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<0.479049, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123>,
                         <0.6803682, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.6803682, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612> }
        smooth_triangle {<0.6803682, 0.185037, -0.7441568>, <-2.71925e-011, 0.006144, 0.01657243>,
                         <0.479049, 0.185037, -0.7441568>, <-2.7297e-011, 0.00595801, 0.01663612>,
                         <0.479049, 0.1033505, -0.7117904>, <-2.62896e-011, 0.007286336, 0.01602218> }
        smooth_triangle {<-0.7288661, 0.0300661, -0.6641178>, <-2.42081e-011, 0.009597401, 0.01475357>,
                         <-0.5275469, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <-0.5275469, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<-0.5275469, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.7288661, 0.1033505, -0.7117904>, <-2.55957e-011, 0.008056691, 0.01559931>,
                         <-0.7288661, 0.0300661, -0.6641178>, <-2.4208e-011, 0.009597401, 0.01475357> }
        smooth_triangle {<-0.5275469, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <-0.3262277, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <-0.3262277, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<-0.3262277, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.5275469, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.5275469, 0.0300661, -0.6641178>, <-2.28874e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<-0.3262277, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <-0.1249086, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <-0.1249086, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<-0.1249086, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.3262277, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.3262277, 0.0300661, -0.6641178>, <-2.28873e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<-0.1249086, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.07641062, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.07641062, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<0.07641062, 0.1033505, -0.7117904>, <-2.55959e-011, 0.008056691, 0.01559931>,
                         <-0.1249086, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <-0.1249086, 0.0300661, -0.6641178>, <-2.28874e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<0.07641062, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.2777298, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.2777298, 0.1033505, -0.7117904>, <-2.60584e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<0.2777298, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.07641062, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.07641062, 0.0300661, -0.6641178>, <-2.28874e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<0.2777298, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.479049, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.479049, 0.1033505, -0.7117904>, <-2.60583e-011, 0.007543121, 0.01588123> }
        smooth_triangle {<0.479049, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.2777298, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.2777298, 0.0300661, -0.6641178>, <-2.28873e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<0.479049, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037>,
                         <0.6803682, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.6803682, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931> }
        smooth_triangle {<0.6803682, 0.1033505, -0.7117904>, <-2.51332e-011, 0.008570261, 0.0153174>,
                         <0.479049, 0.1033505, -0.7117904>, <-2.55958e-011, 0.008056691, 0.01559931>,
                         <0.479049, 0.0300661, -0.6641178>, <-2.28874e-011, 0.01054589, 0.01394867> }
        smooth_triangle {<-0.7288661, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.5275469, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.5275469, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<-0.5275469, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.7288661, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.7288661, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<-0.5275469, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.3262277, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.3262277, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<-0.3262277, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.5275469, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.5275469, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<-0.3262277, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.1249086, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <-0.1249086, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<-0.1249086, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.3262277, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.3262277, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<-0.1249086, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.07641062, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.07641062, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<0.07641062, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.1249086, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <-0.1249086, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<0.07641062, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.2777298, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.2777298, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<0.2777298, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.07641062, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.07641062, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<0.2777298, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.479049, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.479049, 0.0300661, -0.6641178>, <-2.24471e-011, 0.01086205, 0.01368037> }
        smooth_triangle {<0.479049, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.2777298, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.2777298, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
        smooth_triangle {<0.479049, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.6803682, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398>,
                         <0.6803682, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377> }
        smooth_triangle {<0.6803682, 0.0300661, -0.6641178>, <-2.06863e-011, 0.0121267, 0.01260717>,
                         <0.479049, 0.0300661, -0.6641178>, <-2.15667e-011, 0.01149437, 0.01314377>,
                         <0.479049, -0.0272259, -0.5975998>, <-1.89253e-011, 0.01339135, 0.01153398> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.7288661, 0.4381488, 3.97647>, <-2.41899e-011, 0.009699429, 0.01474258>,
                         <-0.5275469, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <-0.5275469, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<-0.5275469, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258>,
                         <-0.7288661, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258>,
                         <-0.7288661, 0.4381488, 3.97647>, <-2.41899e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<-0.5275469, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <-0.3262277, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <-0.3262277, 0.5113787, 3.92829>, <-2.41903e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<-0.3262277, 0.5113787, 3.92829>, <-2.41902e-011, 0.009699429, 0.01474258>,
                         <-0.5275469, 0.5113787, 3.92829>, <-2.419e-011, 0.009699429, 0.01474258>,
                         <-0.5275469, 0.4381488, 3.97647>, <-2.49613e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<-0.3262277, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <-0.1249086, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <-0.1249086, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<-0.1249086, 0.5113787, 3.92829>, <-2.419e-011, 0.009699429, 0.01474258>,
                         <-0.3262277, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258>,
                         <-0.3262277, 0.4381488, 3.97647>, <-2.49613e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<-0.1249086, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.07641061, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.07641061, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<0.07641061, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258>,
                         <-0.1249086, 0.5113787, 3.92829>, <-2.419e-011, 0.009699429, 0.01474258>,
                         <-0.1249086, 0.4381488, 3.97647>, <-2.49613e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<0.07641061, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.2777298, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.2777298, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<0.2777298, 0.5113787, 3.92829>, <-2.419e-011, 0.009699429, 0.01474258>,
                         <0.07641061, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258>,
                         <0.07641061, 0.4381488, 3.97647>, <-2.49613e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<0.2777298, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.479049, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.479049, 0.5113787, 3.92829>, <-2.419e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<0.479049, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258>,
                         <0.2777298, 0.5113787, 3.92829>, <-2.41899e-011, 0.009699429, 0.01474258>,
                         <0.2777298, 0.4381488, 3.97647>, <-2.49612e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<0.479049, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693>,
                         <0.6803682, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266>,
                         <0.6803682, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258> }
        smooth_triangle {<0.6803682, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258>,
                         <0.479049, 0.5113787, 3.92829>, <-2.41901e-011, 0.009699429, 0.01474258>,
                         <0.479049, 0.4381488, 3.97647>, <-2.49613e-011, 0.008760159, 0.01521262> }
        smooth_triangle {<-0.7288661, 0.3555797, 4.00599>, <-2.72751e-011, 0.005942349, 0.01662274>,
                         <-0.5275469, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <-0.5275469, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<-0.5275469, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <-0.7288661, 0.4381488, 3.97647>, <-2.57324e-011, 0.007820889, 0.01568266>,
                         <-0.7288661, 0.3555797, 4.00599>, <-2.7275e-011, 0.005942349, 0.01662274> }
        smooth_triangle {<-0.5275469, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <-0.3262277, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <-0.3262277, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<-0.3262277, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266>,
                         <-0.5275469, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266>,
                         <-0.5275469, 0.3555797, 4.00599>, <-2.76558e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<-0.3262277, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <-0.1249086, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212>,
                         <-0.1249086, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<-0.1249086, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <-0.3262277, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <-0.3262277, 0.3555797, 4.00599>, <-2.76558e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<-0.1249086, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212>,
                         <0.07641061, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212>,
                         <0.07641061, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<0.07641061, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266>,
                         <-0.1249086, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266>,
                         <-0.1249086, 0.3555797, 4.00599>, <-2.76559e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<0.07641061, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212>,
                         <0.2777298, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <0.2777298, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<0.2777298, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <0.07641061, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <0.07641061, 0.3555797, 4.00599>, <-2.76558e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<0.2777298, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <0.479049, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <0.479049, 0.4381488, 3.97647>, <-2.52184e-011, 0.008447069, 0.0153693> }
        smooth_triangle {<0.479049, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <0.2777298, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <0.2777298, 0.3555797, 4.00599>, <-2.76558e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<0.479049, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212>,
                         <0.6803682, 0.3555797, 4.00599>, <-2.80366e-011, 0.003024754, 0.01708682>,
                         <0.6803682, 0.4381488, 3.97647>, <-2.57326e-011, 0.007820889, 0.01568266> }
        smooth_triangle {<0.6803682, 0.4381488, 3.97647>, <-2.62467e-011, 0.007194709, 0.01599602>,
                         <0.479049, 0.4381488, 3.97647>, <-2.57325e-011, 0.007820889, 0.01568266>,
                         <0.479049, 0.3555797, 4.00599>, <-2.76558e-011, 0.004483551, 0.01685478> }
        smooth_triangle {<-0.7288661, 0.2684003, 4.00652>, <-2.87979e-011, 0.0001071587, 0.01755089>,
                         <-0.5275469, 0.2684003, 4.00652>, <-2.84021e-011, -0.001728573, 0.01730965>,
                         <-0.5275469, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<-0.5275469, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.7288661, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.7288661, 0.2684003, 4.00652>, <-2.8798e-011, 0.0001071587, 0.01755089> }
        smooth_triangle {<-0.5275469, 0.2684003, 4.00652>, <-2.84021e-011, -0.001728573, 0.01730965>,
                         <-0.3262277, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <-0.3262277, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<-0.3262277, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.5275469, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.5275469, 0.2684003, 4.00652>, <-2.85011e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<-0.3262277, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <-0.1249086, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <-0.1249086, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<-0.1249086, 0.3555797, 4.00599>, <-2.80366e-011, 0.003024754, 0.01708682>,
                         <-0.3262277, 0.3555797, 4.00599>, <-2.80366e-011, 0.003024754, 0.01708682>,
                         <-0.3262277, 0.2684003, 4.00652>, <-2.85012e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<-0.1249086, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.07641061, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.07641061, 0.3555797, 4.00599>, <-2.77828e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<0.07641061, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.1249086, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <-0.1249086, 0.2684003, 4.00652>, <-2.85011e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<0.07641061, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.2777298, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.2777298, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<0.2777298, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <0.07641061, 0.3555797, 4.00599>, <-2.80366e-011, 0.003024754, 0.01708682>,
                         <0.07641061, 0.2684003, 4.00652>, <-2.85012e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<0.2777298, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.479049, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.479049, 0.3555797, 4.00599>, <-2.77827e-011, 0.003997286, 0.01693212> }
        smooth_triangle {<0.479049, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <0.2777298, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <0.2777298, 0.2684003, 4.00652>, <-2.85011e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<0.479049, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965>,
                         <0.6803682, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <0.6803682, 0.3555797, 4.00599>, <-2.80366e-011, 0.003024754, 0.01708682> }
        smooth_triangle {<0.6803682, 0.3555797, 4.00599>, <-2.82904e-011, 0.002052222, 0.01724151>,
                         <0.479049, 0.3555797, 4.00599>, <-2.80365e-011, 0.003024754, 0.01708682>,
                         <0.479049, 0.2684003, 4.00652>, <-2.85011e-011, -0.00126964, 0.01736996> }
        smooth_triangle {<-0.7288661, 0.1848157, 3.9797>, <-2.76105e-011, -0.005400038, 0.01682718>,
                         <-0.5275469, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <-0.5275469, 0.2684003, 4.00652>, <-2.84021e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<-0.5275469, 0.2684003, 4.00652>, <-2.82042e-011, -0.002646439, 0.01718904>,
                         <-0.7288661, 0.2684003, 4.00652>, <-2.82042e-011, -0.002646439, 0.01718904>,
                         <-0.7288661, 0.1848157, 3.9797>, <-2.76105e-011, -0.005400038, 0.01682718> }
        smooth_triangle {<-0.5275469, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <-0.3262277, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <-0.3262277, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<-0.3262277, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <-0.5275469, 0.2684003, 4.00652>, <-2.82042e-011, -0.002646439, 0.01718904>,
                         <-0.5275469, 0.1848157, 3.9797>, <-2.74538e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<-0.3262277, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <-0.1249086, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <-0.1249086, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<-0.1249086, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <-0.3262277, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <-0.3262277, 0.1848157, 3.9797>, <-2.74538e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<-0.1249086, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <0.07641061, 0.1848157, 3.9797>, <-2.74016e-011, -0.005772008, 0.01669981>,
                         <0.07641061, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<0.07641061, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <-0.1249086, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <-0.1249086, 0.1848157, 3.9797>, <-2.74538e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<0.07641061, 0.1848157, 3.9797>, <-2.74016e-011, -0.005772008, 0.01669981>,
                         <0.2777298, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <0.2777298, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<0.2777298, 0.2684003, 4.00652>, <-2.82042e-011, -0.002646439, 0.01718904>,
                         <0.07641061, 0.2684003, 4.00652>, <-2.82042e-011, -0.002646439, 0.01718904>,
                         <0.07641061, 0.1848157, 3.9797>, <-2.74538e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<0.2777298, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981>,
                         <0.479049, 0.1848157, 3.9797>, <-2.74014e-011, -0.005772008, 0.01669981>,
                         <0.479049, 0.2684003, 4.00652>, <-2.84022e-011, -0.001728573, 0.01730965> }
        smooth_triangle {<0.479049, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <0.2777298, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <0.2777298, 0.1848157, 3.9797>, <-2.74538e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<0.479049, 0.1848157, 3.9797>, <-2.74014e-011, -0.005772008, 0.01669981>,
                         <0.6803682, 0.1848157, 3.9797>, <-2.72971e-011, -0.005957993, 0.01663612>,
                         <0.6803682, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904> }
        smooth_triangle {<0.6803682, 0.2684003, 4.00652>, <-2.80064e-011, -0.003564306, 0.01706842>,
                         <0.479049, 0.2684003, 4.00652>, <-2.82043e-011, -0.002646439, 0.01718904>,
                         <0.479049, 0.1848157, 3.9797>, <-2.74537e-011, -0.005679015, 0.01673165> }
        smooth_triangle {<-0.7288661, 0.1031292, 3.94733>, <-2.69835e-011, -0.006515948, 0.01644507>,
                         <-0.5275469, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123>,
                         <-0.5275469, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<-0.5275469, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <-0.7288661, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <-0.7288661, 0.1031292, 3.94733>, <-2.69835e-011, -0.006515948, 0.01644507> }
        smooth_triangle {<-0.5275469, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123>,
                         <-0.3262277, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <-0.3262277, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<-0.3262277, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <-0.5275469, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <-0.5275469, 0.1031292, 3.94733>, <-2.62897e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<-0.3262277, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <-0.1249086, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <-0.1249086, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<-0.1249086, 0.1848157, 3.9797>, <-2.72969e-011, -0.005957993, 0.01663612>,
                         <-0.3262277, 0.1848157, 3.9797>, <-2.72969e-011, -0.005957993, 0.01663612>,
                         <-0.3262277, 0.1031292, 3.94733>, <-2.62896e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<-0.1249086, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <0.07641061, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123>,
                         <0.07641061, 0.1848157, 3.9797>, <-2.74016e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<0.07641061, 0.1848157, 3.9797>, <-2.72971e-011, -0.005957993, 0.01663612>,
                         <-0.1249086, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <-0.1249086, 0.1031292, 3.94733>, <-2.62897e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<0.07641061, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123>,
                         <0.2777298, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <0.2777298, 0.1848157, 3.9797>, <-2.74015e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<0.2777298, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <0.07641061, 0.1848157, 3.9797>, <-2.72971e-011, -0.005957993, 0.01663612>,
                         <0.07641061, 0.1031292, 3.94733>, <-2.62897e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<0.2777298, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <0.479049, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <0.479049, 0.1848157, 3.9797>, <-2.74014e-011, -0.005772008, 0.01669981> }
        smooth_triangle {<0.479049, 0.1848157, 3.9797>, <-2.72969e-011, -0.005957993, 0.01663612>,
                         <0.2777298, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <0.2777298, 0.1031292, 3.94733>, <-2.62896e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<0.479049, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123>,
                         <0.6803682, 0.1031292, 3.94733>, <-2.55959e-011, -0.008056676, 0.01559931>,
                         <0.6803682, 0.1848157, 3.9797>, <-2.72971e-011, -0.005957993, 0.01663612> }
        smooth_triangle {<0.6803682, 0.1848157, 3.9797>, <-2.71926e-011, -0.006143978, 0.01657244>,
                         <0.479049, 0.1848157, 3.9797>, <-2.7297e-011, -0.005957993, 0.01663612>,
                         <0.479049, 0.1031292, 3.94733>, <-2.62896e-011, -0.007286312, 0.01602219> }
        smooth_triangle {<-0.7288661, 0.02984479, 3.89966>, <-2.42081e-011, -0.009597404, 0.01475356>,
                         <-0.5275469, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <-0.5275469, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<-0.5275469, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.7288661, 0.1031292, 3.94733>, <-2.55957e-011, -0.008056676, 0.01559931>,
                         <-0.7288661, 0.02984479, 3.89966>, <-2.42081e-011, -0.009597404, 0.01475356> }
        smooth_triangle {<-0.5275469, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <-0.3262277, 0.02984479, 3.89966>, <-2.2447e-011, -0.01086206, 0.01368035>,
                         <-0.3262277, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<-0.3262277, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.5275469, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.5275469, 0.02984479, 3.89966>, <-2.28873e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<-0.3262277, 0.02984479, 3.89966>, <-2.2447e-011, -0.01086206, 0.01368035>,
                         <-0.1249086, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <-0.1249086, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<-0.1249086, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.3262277, 0.1031292, 3.94733>, <-2.55957e-011, -0.008056676, 0.01559931>,
                         <-0.3262277, 0.02984479, 3.89966>, <-2.28873e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<-0.1249086, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.07641061, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.07641061, 0.1031292, 3.94733>, <-2.60584e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<0.07641061, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.1249086, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <-0.1249086, 0.02984479, 3.89966>, <-2.28874e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<0.07641061, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.2777298, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.2777298, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<0.2777298, 0.1031292, 3.94733>, <-2.55957e-011, -0.008056676, 0.01559931>,
                         <0.07641061, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <0.07641061, 0.02984479, 3.89966>, <-2.28873e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<0.2777298, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.479049, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.479049, 0.1031292, 3.94733>, <-2.60583e-011, -0.0075431, 0.01588123> }
        smooth_triangle {<0.479049, 0.1031292, 3.94733>, <-2.55957e-011, -0.008056676, 0.01559931>,
                         <0.2777298, 0.1031292, 3.94733>, <-2.55957e-011, -0.008056676, 0.01559931>,
                         <0.2777298, 0.02984479, 3.89966>, <-2.28873e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<0.479049, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035>,
                         <0.6803682, 0.02984479, 3.89966>, <-2.15667e-011, -0.01149439, 0.01314375>,
                         <0.6803682, 0.1031292, 3.94733>, <-2.55959e-011, -0.008056676, 0.01559931> }
        smooth_triangle {<0.6803682, 0.1031292, 3.94733>, <-2.51333e-011, -0.008570252, 0.01531739>,
                         <0.479049, 0.1031292, 3.94733>, <-2.55958e-011, -0.008056676, 0.01559931>,
                         <0.479049, 0.02984479, 3.89966>, <-2.28873e-011, -0.0105459, 0.01394865> }
        smooth_triangle {<-0.7288661, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.5275469, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.5275469, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<-0.5275469, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.7288661, 0.02984479, 3.89966>, <-2.15667e-011, -0.01149439, 0.01314375>,
                         <-0.7288661, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<-0.5275469, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.3262277, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.3262277, 0.02984479, 3.89966>, <-2.2447e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<-0.3262277, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.5275469, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.5275469, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<-0.3262277, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.1249086, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <-0.1249086, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<-0.1249086, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.3262277, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.3262277, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<-0.1249086, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.07641061, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.07641061, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<0.07641061, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <-0.1249086, 0.02984479, 3.89966>, <-2.15667e-011, -0.01149439, 0.01314375>,
                         <-0.1249086, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<0.07641061, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.2777298, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.2777298, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<0.2777298, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <0.07641061, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <0.07641061, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<0.2777298, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.479049, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.479049, 0.02984479, 3.89966>, <-2.24471e-011, -0.01086206, 0.01368035> }
        smooth_triangle {<0.479049, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <0.2777298, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <0.2777298, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
        smooth_triangle {<0.479049, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.6803682, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394>,
                         <0.6803682, 0.02984479, 3.89966>, <-2.15667e-011, -0.01149439, 0.01314375> }
        smooth_triangle {<0.6803682, 0.02984479, 3.89966>, <-2.06862e-011, -0.01212672, 0.01260715>,
                         <0.479049, 0.02984479, 3.89966>, <-2.15666e-011, -0.01149439, 0.01314375>,
                         <0.479049, -0.02744703, 3.83314>, <-1.89252e-011, -0.01339137, 0.01153394> }
    }
    union { // Poly_Mesh
        smooth_triangle {<0.479049, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042>,
                         <0.479049, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <0.6803682, -0.009745987, 0.03760044>, <5.77416e-012, 0.127878, -0.003519042> }
        smooth_triangle {<0.6803682, -0.009745987, 0.03760044>, <5.77416e-012, 0.127878, -0.003519042>,
                         <0.6803682, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042>,
                         <0.479049, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042> }
        smooth_triangle {<0.479049, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <0.479049, 0.05336007, 0.6698357>, <2.19273e-011, 0.1272164, -0.0133636>,
                         <0.6803682, 0.05336007, 0.6698357>, <2.08458e-011, 0.1272811, -0.01270446> }
        smooth_triangle {<0.6803682, 0.05336007, 0.6698357>, <2.08458e-011, 0.1272811, -0.01270446>,
                         <0.6803682, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <0.479049, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<0.479049, 0.05336007, 0.6698357>, <2.19273e-011, 0.1272164, -0.0133636>,
                         <0.479049, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906>,
                         <0.6803682, 0.1262885, 1.30111>, <2.40904e-011, 0.127087, -0.01468189> }
        smooth_triangle {<0.6803682, 0.1262885, 1.30111>, <2.40904e-011, 0.127087, -0.01468189>,
                         <0.6803682, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317>,
                         <0.479049, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317> }
        smooth_triangle {<0.479049, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906>,
                         <0.479049, 0.1403131, 1.93426>, <-4.06331e-012, 0.1273953, 0.002476369>,
                         <0.6803682, 0.1403131, 1.93426>, <4.63273e-012, 0.1274651, -0.002823416> }
        smooth_triangle {<0.6803682, 0.1403131, 1.93426>, <4.63273e-012, 0.1274651, -0.002823416>,
                         <0.6803682, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <0.479049, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<0.479049, 0.1403131, 1.93426>, <-4.06331e-012, 0.1273953, 0.002476369>,
                         <0.479049, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <0.6803682, 0.07536179, 2.56636>, <-2.14554e-011, 0.1272556, 0.01307594> }
        smooth_triangle {<0.6803682, 0.07536179, 2.56636>, <-2.14554e-011, 0.1272556, 0.01307594>,
                         <0.6803682, 0.1403131, 1.93426>, <-8.4113e-012, 0.1273603, 0.005126261>,
                         <0.479049, 0.1403131, 1.93426>, <-8.41131e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<0.479049, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <0.479049, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <0.6803682, 0.02273729, 3.19965>, <-1.73834e-011, 0.1274931, 0.01059432> }
        smooth_triangle {<0.6803682, 0.02273729, 3.19965>, <-1.73834e-011, 0.1274931, 0.01059432>,
                         <0.6803682, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <0.479049, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<0.479049, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <0.479049, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.6803682, -0.02744703, 3.83314>, <-1.65773e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<0.6803682, -0.02744703, 3.83314>, <-1.65773e-011, 0.1275333, 0.01010307>,
                         <0.6803682, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <0.479049, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<0.2777298, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <0.2777298, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <0.479049, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848> }
        smooth_triangle {<0.479049, -0.009745987, 0.03760044>, <9.54205e-012, 0.1277288, -0.005815397>,
                         <0.479049, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042>,
                         <0.2777298, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042> }
        smooth_triangle {<0.2777298, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <0.2777298, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <0.479049, 0.05336007, 0.6698357>, <2.19273e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<0.479049, 0.05336007, 0.6698357>, <2.16569e-011, 0.1272326, -0.01319882>,
                         <0.479049, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <0.2777298, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<0.2777298, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <0.2777298, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <0.479049, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906> }
        smooth_triangle {<0.479049, 0.1262885, 1.30111>, <1.9226e-011, 0.1271815, -0.01171727>,
                         <0.479049, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317>,
                         <0.2777298, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317> }
        smooth_triangle {<0.2777298, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <0.2777298, 0.1403131, 1.93426>, <-4.06327e-012, 0.1273953, 0.002476369>,
                         <0.479049, 0.1403131, 1.93426>, <-4.06331e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<0.479049, 0.1403131, 1.93426>, <-1.88929e-012, 0.1274127, 0.001151423>,
                         <0.479049, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <0.2777298, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<0.2777298, 0.1403131, 1.93426>, <-4.06327e-012, 0.1273953, 0.002476369>,
                         <0.2777298, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <0.479049, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<0.479049, 0.07536179, 2.56636>, <-2.04374e-011, 0.127315, 0.01245553>,
                         <0.479049, 0.1403131, 1.93426>, <-8.41132e-012, 0.1273603, 0.005126261>,
                         <0.2777298, 0.1403131, 1.93426>, <-8.41129e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<0.2777298, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <0.2777298, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <0.479049, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<0.479049, 0.02273729, 3.19965>, <-1.71819e-011, 0.1275032, 0.01047151>,
                         <0.479049, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <0.2777298, 0.07536179, 2.56636>, <-1.94193e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<0.2777298, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <0.2777298, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.479049, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<0.479049, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.479049, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <0.2777298, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<0.07641062, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <0.07641062, -0.009745987, 0.03760044>, <1.07981e-011, 0.127679, -0.006580848>,
                         <0.2777298, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848> }
        smooth_triangle {<0.2777298, -0.009745987, 0.03760044>, <9.54205e-012, 0.1277288, -0.005815397>,
                         <0.2777298, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042>,
                         <0.07641062, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042> }
        smooth_triangle {<0.07641062, -0.009745987, 0.03760044>, <1.07981e-011, 0.127679, -0.006580848>,
                         <0.07641062, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636>,
                         <0.2777298, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<0.2777298, 0.05336007, 0.6698357>, <2.1657e-011, 0.1272326, -0.01319882>,
                         <0.2777298, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <0.07641062, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<0.07641062, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636>,
                         <0.07641062, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <0.2777298, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906> }
        smooth_triangle {<0.2777298, 0.1262885, 1.30111>, <1.9226e-011, 0.1271815, -0.01171727>,
                         <0.2777298, 0.05336007, 0.6698357>, <2.24682e-011, 0.127184, -0.01369317>,
                         <0.07641062, 0.05336007, 0.6698357>, <2.24679e-011, 0.127184, -0.01369317> }
        smooth_triangle {<0.07641062, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <0.07641062, 0.1403131, 1.93426>, <-4.06328e-012, 0.1273953, 0.002476369>,
                         <0.2777298, 0.1403131, 1.93426>, <-4.06327e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<0.2777298, 0.1403131, 1.93426>, <-1.88927e-012, 0.1274127, 0.001151423>,
                         <0.2777298, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <0.07641062, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<0.07641062, 0.1403131, 1.93426>, <-4.06328e-012, 0.1273953, 0.002476369>,
                         <0.07641062, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873>,
                         <0.2777298, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<0.2777298, 0.07536179, 2.56636>, <-2.04373e-011, 0.127315, 0.01245553>,
                         <0.2777298, 0.1403131, 1.93426>, <-8.41128e-012, 0.1273603, 0.005126261>,
                         <0.07641062, 0.1403131, 1.93426>, <-8.41129e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<0.07641062, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873>,
                         <0.07641061, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <0.2777298, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<0.2777298, 0.02273729, 3.19965>, <-1.71819e-011, 0.1275032, 0.01047151>,
                         <0.2777298, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <0.07641062, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<0.07641061, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <0.07641061, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.2777298, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<0.2777298, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.2777298, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <0.07641061, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<-0.1249086, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042>,
                         <-0.1249086, -0.009745987, 0.03760044>, <1.07977e-011, 0.127679, -0.006580848>,
                         <0.07641062, -0.009745987, 0.03760044>, <1.07981e-011, 0.127679, -0.006580848> }
        smooth_triangle {<0.07641062, -0.009745987, 0.03760044>, <9.54208e-012, 0.1277288, -0.005815397>,
                         <0.07641062, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <-0.1249086, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042> }
        smooth_triangle {<-0.1249086, -0.009745987, 0.03760044>, <1.07977e-011, 0.127679, -0.006580848>,
                         <-0.1249086, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636>,
                         <0.07641062, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<0.07641062, 0.05336007, 0.6698357>, <2.16567e-011, 0.1272326, -0.01319882>,
                         <0.07641062, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <-0.1249086, -0.009745987, 0.03760044>, <1.33097e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<-0.1249086, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636>,
                         <-0.1249086, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906>,
                         <0.07641062, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906> }
        smooth_triangle {<0.07641062, 0.1262885, 1.30111>, <1.92257e-011, 0.1271815, -0.01171727>,
                         <0.07641062, 0.05336007, 0.6698357>, <2.24676e-011, 0.127184, -0.01369317>,
                         <-0.1249086, 0.05336007, 0.6698357>, <2.24676e-011, 0.127184, -0.01369317> }
        smooth_triangle {<-0.1249086, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906>,
                         <-0.1249086, 0.1403131, 1.93426>, <-4.06332e-012, 0.1273953, 0.002476369>,
                         <0.07641062, 0.1403131, 1.93426>, <-4.06328e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<0.07641062, 0.1403131, 1.93426>, <-1.88927e-012, 0.1274127, 0.001151423>,
                         <0.07641062, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.1249086, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<-0.1249086, 0.1403131, 1.93426>, <-4.06332e-012, 0.1273953, 0.002476369>,
                         <-0.1249086, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873>,
                         <0.07641062, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<0.07641062, 0.07536179, 2.56636>, <-2.04374e-011, 0.127315, 0.01245553>,
                         <0.07641062, 0.1403131, 1.93426>, <-8.41131e-012, 0.1273603, 0.005126261>,
                         <-0.1249086, 0.1403131, 1.93426>, <-8.41134e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<-0.1249086, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873>,
                         <-0.1249086, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <0.07641061, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<0.07641061, 0.02273729, 3.19965>, <-1.7182e-011, 0.1275032, 0.01047151>,
                         <0.07641062, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <-0.1249086, 0.07536179, 2.56636>, <-1.94195e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<-0.1249086, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <-0.1249086, -0.02744703, 3.83314>, <-1.65773e-011, 0.1275333, 0.01010307>,
                         <0.07641061, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<0.07641061, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <0.07641061, 0.02273729, 3.19965>, <-1.69805e-011, 0.1275132, 0.01034869>,
                         <-0.1249086, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<-0.3262277, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <-0.3262277, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <-0.1249086, -0.009745987, 0.03760044>, <1.07977e-011, 0.127679, -0.006580848> }
        smooth_triangle {<-0.1249086, -0.009745987, 0.03760044>, <9.54178e-012, 0.1277288, -0.005815397>,
                         <-0.1249086, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042>,
                         <-0.3262277, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042> }
        smooth_triangle {<-0.3262277, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <-0.3262277, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <-0.1249086, 0.05336007, 0.6698357>, <2.1927e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<-0.1249086, 0.05336007, 0.6698357>, <2.16567e-011, 0.1272326, -0.01319882>,
                         <-0.1249086, -0.009745987, 0.03760044>, <1.33097e-011, 0.1275795, -0.008111751>,
                         <-0.3262277, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<-0.3262277, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <-0.3262277, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <-0.1249086, 0.1262885, 1.30111>, <1.76046e-011, 0.127213, -0.01072906> }
        smooth_triangle {<-0.1249086, 0.1262885, 1.30111>, <1.92261e-011, 0.1271815, -0.01171727>,
                         <-0.1249086, 0.05336007, 0.6698357>, <2.24679e-011, 0.127184, -0.01369317>,
                         <-0.3262277, 0.05336007, 0.6698357>, <2.24682e-011, 0.127184, -0.01369317> }
        smooth_triangle {<-0.3262277, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <-0.3262277, 0.1403131, 1.93426>, <-4.06329e-012, 0.1273953, 0.002476369>,
                         <-0.1249086, 0.1403131, 1.93426>, <-4.06332e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<-0.1249086, 0.1403131, 1.93426>, <-1.8893e-012, 0.1274127, 0.001151423>,
                         <-0.1249086, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.3262277, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<-0.3262277, 0.1403131, 1.93426>, <-4.06329e-012, 0.1273953, 0.002476369>,
                         <-0.3262277, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <-0.1249086, 0.07536179, 2.56636>, <-2.00981e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<-0.1249086, 0.07536179, 2.56636>, <-2.04374e-011, 0.127315, 0.01245553>,
                         <-0.1249086, 0.1403131, 1.93426>, <-8.41133e-012, 0.1273603, 0.005126261>,
                         <-0.3262277, 0.1403131, 1.93426>, <-8.4113e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<-0.3262277, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <-0.3262277, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <-0.1249086, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<-0.1249086, 0.02273729, 3.19965>, <-1.71819e-011, 0.1275032, 0.01047151>,
                         <-0.1249086, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <-0.3262277, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<-0.3262277, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057>,
                         <-0.3262277, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <-0.1249086, -0.02744703, 3.83314>, <-1.65773e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<-0.1249086, -0.02744703, 3.83314>, <-1.65773e-011, 0.1275333, 0.01010307>,
                         <-0.1249086, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <-0.3262277, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<-0.5275469, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <-0.5275469, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <-0.3262277, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848> }
        smooth_triangle {<-0.3262277, -0.009745987, 0.03760044>, <9.54207e-012, 0.1277288, -0.005815397>,
                         <-0.3262277, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042>,
                         <-0.5275469, -0.0272259, -0.5975998>, <5.77413e-012, 0.127878, -0.003519042> }
        smooth_triangle {<-0.5275469, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848>,
                         <-0.5275469, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <-0.3262277, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<-0.3262277, 0.05336007, 0.6698357>, <2.1657e-011, 0.1272326, -0.01319882>,
                         <-0.3262277, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <-0.5275469, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751> }
        smooth_triangle {<-0.5275469, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636>,
                         <-0.5275469, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <-0.3262277, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906> }
        smooth_triangle {<-0.3262277, 0.1262885, 1.30111>, <1.9226e-011, 0.1271815, -0.01171727>,
                         <-0.3262277, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317>,
                         <-0.5275469, 0.05336007, 0.6698357>, <2.24681e-011, 0.127184, -0.01369317> }
        smooth_triangle {<-0.5275469, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906>,
                         <-0.5275469, 0.1403131, 1.93426>, <-4.06333e-012, 0.1273953, 0.002476369>,
                         <-0.3262277, 0.1403131, 1.93426>, <-4.06329e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<-0.3262277, 0.1403131, 1.93426>, <-1.88928e-012, 0.1274127, 0.001151423>,
                         <-0.3262277, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.5275469, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652> }
        smooth_triangle {<-0.5275469, 0.1403131, 1.93426>, <-4.06333e-012, 0.1273953, 0.002476369>,
                         <-0.5275469, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <-0.3262277, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<-0.3262277, 0.07536179, 2.56636>, <-2.04373e-011, 0.127315, 0.01245553>,
                         <-0.3262277, 0.1403131, 1.93426>, <-8.41129e-012, 0.1273603, 0.005126261>,
                         <-0.5275469, 0.1403131, 1.93426>, <-8.41132e-012, 0.1273603, 0.005126261> }
        smooth_triangle {<-0.5275469, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873>,
                         <-0.5275469, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <-0.3262277, 0.02273729, 3.19965>, <-1.71147e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<-0.3262277, 0.02273729, 3.19965>, <-1.71819e-011, 0.1275032, 0.01047151>,
                         <-0.3262277, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <-0.5275469, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513> }
        smooth_triangle {<-0.5275469, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057>,
                         <-0.5275469, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <-0.3262277, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<-0.3262277, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <-0.3262277, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <-0.5275469, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869> }
        smooth_triangle {<-0.7288661, -0.0272259, -0.5975998>, <5.77416e-012, 0.127878, -0.003519042>,
                         <-0.7288661, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <-0.5275469, -0.009745987, 0.03760044>, <1.0798e-011, 0.127679, -0.006580848> }
        smooth_triangle {<-0.5275469, -0.009745987, 0.03760044>, <9.54206e-012, 0.1277288, -0.005815397>,
                         <-0.5275469, -0.0272259, -0.5975998>, <5.77414e-012, 0.127878, -0.003519042>,
                         <-0.7288661, -0.0272259, -0.5975998>, <5.77415e-012, 0.127878, -0.003519042> }
        smooth_triangle {<-0.7288661, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <-0.7288661, 0.05336007, 0.6698357>, <2.24682e-011, 0.127184, -0.01369317>,
                         <-0.5275469, 0.05336007, 0.6698357>, <2.19274e-011, 0.1272164, -0.0133636> }
        smooth_triangle {<-0.5275469, 0.05336007, 0.6698357>, <2.1657e-011, 0.1272326, -0.01319882>,
                         <-0.5275469, -0.009745987, 0.03760044>, <1.331e-011, 0.1275795, -0.008111751>,
                         <-0.7288661, -0.009745987, 0.03760044>, <1.5822e-011, 0.1274801, -0.009642654> }
        smooth_triangle {<-0.7288661, 0.05336007, 0.6698357>, <2.24682e-011, 0.127184, -0.01369317>,
                         <-0.7288661, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.5275469, 0.1262885, 1.30111>, <1.76045e-011, 0.127213, -0.01072906> }
        smooth_triangle {<-0.5275469, 0.1262885, 1.30111>, <1.9226e-011, 0.1271815, -0.01171727>,
                         <-0.5275469, 0.05336007, 0.6698357>, <2.24682e-011, 0.127184, -0.01369317>,
                         <-0.7288661, 0.05336007, 0.6698357>, <2.3009e-011, 0.1271517, -0.01402275> }
        smooth_triangle {<-0.7288661, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.7288661, 0.1403131, 1.93426>, <-8.41124e-012, 0.1273603, 0.005126261>,
                         <-0.5275469, 0.1403131, 1.93426>, <-4.06333e-012, 0.1273953, 0.002476369> }
        smooth_triangle {<-0.5275469, 0.1403131, 1.93426>, <-1.88931e-012, 0.1274127, 0.001151423>,
                         <-0.5275469, 0.1262885, 1.30111>, <1.43616e-011, 0.1272761, -0.008752652>,
                         <-0.7288661, 0.1262885, 1.30111>, <1.11187e-011, 0.1273391, -0.00677624> }
        smooth_triangle {<-0.7288661, 0.1403131, 1.93426>, <-8.41124e-012, 0.1273603, 0.005126261>,
                         <-0.7288661, 0.07536179, 2.56636>, <-1.94193e-011, 0.1273743, 0.01183513>,
                         <-0.5275469, 0.07536179, 2.56636>, <-2.0098e-011, 0.1273347, 0.01224873> }
        smooth_triangle {<-0.5275469, 0.07536179, 2.56636>, <-2.04374e-011, 0.127315, 0.01245553>,
                         <-0.5275469, 0.1403131, 1.93426>, <-8.41133e-012, 0.1273603, 0.005126261>,
                         <-0.7288661, 0.1403131, 1.93426>, <-1.27593e-011, 0.1273254, 0.007776153> }
        smooth_triangle {<-0.7288661, 0.07536179, 2.56636>, <-1.94193e-011, 0.1273743, 0.01183513>,
                         <-0.7288661, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <-0.5275469, 0.02273729, 3.19965>, <-1.71148e-011, 0.1275065, 0.01043057> }
        smooth_triangle {<-0.5275469, 0.02273729, 3.19965>, <-1.71819e-011, 0.1275032, 0.01047151>,
                         <-0.5275469, 0.07536179, 2.56636>, <-1.94194e-011, 0.1273743, 0.01183513>,
                         <-0.7288661, 0.07536179, 2.56636>, <-1.87407e-011, 0.1274139, 0.01142153> }
        smooth_triangle {<-0.7288661, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <-0.7288661, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <-0.5275469, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307> }
        smooth_triangle {<-0.5275469, -0.02744703, 3.83314>, <-1.65774e-011, 0.1275333, 0.01010307>,
                         <-0.5275469, 0.02273729, 3.19965>, <-1.69804e-011, 0.1275132, 0.01034869>,
                         <-0.7288661, 0.02273729, 3.19965>, <-1.68461e-011, 0.1275199, 0.01026682> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-0.5275469, 0.5115999, -0.6927509>, <-8.27703e-011, -0.1311793, 0.05044409>,
                         <-0.5275469, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.7288661, 0.7621676, -0.0411523>, <-8.27703e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<-0.7288661, 0.7621676, -0.0411523>, <-8.27702e-011, -0.1311793, 0.05044409>,
                         <-0.7288661, 0.5115999, -0.6927509>, <-8.27701e-011, -0.1311793, 0.05044409>,
                         <-0.5275469, 0.5115999, -0.6927509>, <-8.27702e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<-0.5275469, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.5275469, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <-0.7288661, 1.01109, 0.6110759>, <-8.22262e-011, -0.131306, 0.05011272> }
        smooth_triangle {<-0.7288661, 1.01109, 0.6110759>, <-8.22264e-011, -0.131306, 0.05011272>,
                         <-0.7288661, 0.7621676, -0.0411523>, <-8.24984e-011, -0.1312427, 0.0502784>,
                         <-0.5275469, 0.7621676, -0.04115229>, <-8.24982e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<-0.5275469, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <-0.5275469, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <-0.7288661, 1.21991, 1.27578>, <-6.89786e-011, -0.1338177, 0.04203896> }
        smooth_triangle {<-0.7288661, 1.21991, 1.27578>, <-6.89786e-011, -0.1338177, 0.04203896>,
                         <-0.7288661, 1.01109, 0.6110759>, <-7.56024e-011, -0.1325619, 0.04607584>,
                         <-0.5275469, 1.01109, 0.6110759>, <-7.56024e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<-0.5275469, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <-0.5275469, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <-0.7288661, 1.23898, 1.9722>, <-6.301e-012, -0.1402024, 0.003840124> }
        smooth_triangle {<-0.7288661, 1.23898, 1.9722>, <-6.30098e-012, -0.1402024, 0.003840124>,
                         <-0.7288661, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954>,
                         <-0.5275469, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<-0.5275469, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <-0.5275469, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <-0.7288661, 1.06275, 2.64557>, <5.82136e-011, -0.1355627, -0.03547823> }
        smooth_triangle {<-0.7288661, 1.06275, 2.64557>, <5.82137e-011, -0.1355627, -0.03547823>,
                         <-0.7288661, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905>,
                         <-0.5275469, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<-0.5275469, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <-0.5275469, 0.7892513, 3.28786>, <9.08268e-011, -0.1291807, -0.05535443>,
                         <-0.7288661, 0.7892513, 3.28786>, <9.03456e-011, -0.1293055, -0.0550611> }
        smooth_triangle {<-0.7288661, 0.7892513, 3.28786>, <9.03456e-011, -0.1293055, -0.0550611>,
                         <-0.7288661, 1.06275, 2.64557>, <7.42796e-011, -0.1324341, -0.04526966>,
                         <-0.5275469, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<-0.5275469, 0.7892513, 3.28786>, <9.08268e-011, -0.1291807, -0.05535443>,
                         <-0.5275469, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108>,
                         <-0.7288661, 0.5113787, 3.92829>, <9.1789e-011, -0.128931, -0.05594108> }
        smooth_triangle {<-0.7288661, 0.5113787, 3.92829>, <9.17893e-011, -0.128931, -0.05594108>,
                         <-0.7288661, 0.7892513, 3.28786>, <9.10676e-011, -0.1291183, -0.05550109>,
                         <-0.5275469, 0.7892513, 3.28786>, <9.10675e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<-0.3262277, 0.5115999, -0.6927509>, <-8.27699e-011, -0.1311793, 0.05044409>,
                         <-0.3262277, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.5275469, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<-0.5275469, 0.7621676, -0.04115229>, <-8.26341e-011, -0.131211, 0.05036125>,
                         <-0.5275469, 0.5115999, -0.6927509>, <-8.27702e-011, -0.1311793, 0.05044409>,
                         <-0.3262277, 0.5115999, -0.6927509>, <-8.277e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<-0.3262277, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.3262277, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <-0.5275469, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<-0.5275469, 1.01109, 0.6110759>, <-7.89143e-011, -0.131934, 0.04809428>,
                         <-0.5275469, 0.7621676, -0.04115229>, <-8.24981e-011, -0.1312427, 0.0502784>,
                         <-0.3262277, 0.7621676, -0.04115229>, <-8.24981e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<-0.3262277, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <-0.3262277, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <-0.5275469, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601> }
        smooth_triangle {<-0.5275469, 1.21991, 1.27578>, <-5.33092e-011, -0.1354139, 0.03248925>,
                         <-0.5275469, 1.01109, 0.6110759>, <-7.56024e-011, -0.1325619, 0.04607584>,
                         <-0.3262277, 1.01109, 0.6110759>, <-7.56025e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<-0.3262277, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <-0.3262277, 1.23898, 1.9722>, <1.5204e-011, -0.1386558, -0.009265992>,
                         <-0.5275469, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<-0.5275469, 1.23898, 1.9722>, <9.82765e-012, -0.1390425, -0.005989463>,
                         <-0.5275469, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954>,
                         <-0.3262277, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<-0.3262277, 1.23898, 1.9722>, <1.5204e-011, -0.1386558, -0.009265992>,
                         <-0.3262277, 1.06275, 2.64557>, <6.89244e-011, -0.133477, -0.04200585>,
                         <-0.5275469, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585> }
        smooth_triangle {<-0.5275469, 1.06275, 2.64557>, <6.62466e-011, -0.1339984, -0.04037394>,
                         <-0.5275469, 1.23898, 1.9722>, <2.59562e-011, -0.1378825, -0.01581905>,
                         <-0.3262277, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<-0.3262277, 1.06275, 2.64557>, <6.89244e-011, -0.133477, -0.04200585>,
                         <-0.3262277, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <-0.5275469, 0.7892513, 3.28786>, <9.08268e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<-0.5275469, 0.7892513, 3.28786>, <9.07066e-011, -0.1292119, -0.05528109>,
                         <-0.5275469, 1.06275, 2.64557>, <7.42798e-011, -0.1324341, -0.04526966>,
                         <-0.3262277, 1.06275, 2.64557>, <7.42798e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<-0.3262277, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <-0.3262277, 0.5113787, 3.92829>, <9.179e-011, -0.128931, -0.05594108>,
                         <-0.5275469, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108> }
        smooth_triangle {<-0.5275469, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108>,
                         <-0.5275469, 0.7892513, 3.28786>, <9.10675e-011, -0.1291183, -0.05550109>,
                         <-0.3262277, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<-0.1249086, 0.5115999, -0.6927509>, <-8.27703e-011, -0.1311793, 0.05044409>,
                         <-0.1249086, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.3262277, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<-0.3262277, 0.7621676, -0.04115229>, <-8.26341e-011, -0.131211, 0.05036125>,
                         <-0.3262277, 0.5115999, -0.6927509>, <-8.277e-011, -0.1311793, 0.05044409>,
                         <-0.1249086, 0.5115999, -0.6927509>, <-8.27702e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<-0.1249086, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363>,
                         <-0.1249086, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <-0.3262277, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<-0.3262277, 1.01109, 0.6110759>, <-7.89145e-011, -0.131934, 0.04809428>,
                         <-0.3262277, 0.7621676, -0.04115229>, <-8.24982e-011, -0.1312427, 0.0502784>,
                         <-0.1249086, 0.7621676, -0.04115229>, <-8.24982e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<-0.1249086, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <-0.1249086, 1.21991, 1.27578>, <-4.80862e-011, -0.135946, 0.02930601>,
                         <-0.3262277, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601> }
        smooth_triangle {<-0.3262277, 1.21991, 1.27578>, <-5.33093e-011, -0.1354139, 0.03248925>,
                         <-0.3262277, 1.01109, 0.6110759>, <-7.56026e-011, -0.1325619, 0.04607584>,
                         <-0.1249086, 1.01109, 0.6110759>, <-7.56026e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<-0.1249086, 1.21991, 1.27578>, <-4.80862e-011, -0.135946, 0.02930601>,
                         <-0.1249086, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <-0.3262277, 1.23898, 1.9722>, <1.5204e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<-0.3262277, 1.23898, 1.9722>, <9.82774e-012, -0.1390425, -0.005989463>,
                         <-0.3262277, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954>,
                         <-0.1249086, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<-0.1249086, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <-0.1249086, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <-0.3262277, 1.06275, 2.64557>, <6.89244e-011, -0.133477, -0.04200585> }
        smooth_triangle {<-0.3262277, 1.06275, 2.64557>, <6.62467e-011, -0.1339984, -0.04037394>,
                         <-0.3262277, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905>,
                         <-0.1249086, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<-0.1249086, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <-0.1249086, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <-0.3262277, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<-0.3262277, 0.7892513, 3.28786>, <9.07068e-011, -0.1292119, -0.05528109>,
                         <-0.3262277, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966>,
                         <-0.1249086, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<-0.1249086, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <-0.1249086, 0.5113787, 3.92829>, <9.17896e-011, -0.128931, -0.05594108>,
                         <-0.3262277, 0.5113787, 3.92829>, <9.179e-011, -0.128931, -0.05594108> }
        smooth_triangle {<-0.3262277, 0.5113787, 3.92829>, <9.17899e-011, -0.128931, -0.05594108>,
                         <-0.3262277, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109>,
                         <-0.1249086, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<0.07641062, 0.5115999, -0.6927509>, <-8.27696e-011, -0.1311793, 0.05044409>,
                         <0.07641062, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363>,
                         <-0.1249086, 0.7621676, -0.04115229>, <-8.25888e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<-0.1249086, 0.7621676, -0.04115229>, <-8.26341e-011, -0.131211, 0.05036125>,
                         <-0.1249086, 0.5115999, -0.6927509>, <-8.27702e-011, -0.1311793, 0.05044409>,
                         <0.07641062, 0.5115999, -0.6927509>, <-8.27698e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<0.07641062, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363>,
                         <0.07641062, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <-0.1249086, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<-0.1249086, 1.01109, 0.6110759>, <-7.89143e-011, -0.131934, 0.04809428>,
                         <-0.1249086, 0.7621676, -0.04115229>, <-8.24981e-011, -0.1312427, 0.0502784>,
                         <0.07641062, 0.7621676, -0.04115229>, <-8.2498e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<0.07641062, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146>,
                         <0.07641062, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <-0.1249086, 1.21991, 1.27578>, <-4.80862e-011, -0.135946, 0.02930601> }
        smooth_triangle {<-0.1249086, 1.21991, 1.27578>, <-5.33093e-011, -0.1354139, 0.03248925>,
                         <-0.1249086, 1.01109, 0.6110759>, <-7.56025e-011, -0.1325619, 0.04607584>,
                         <0.07641062, 1.01109, 0.6110759>, <-7.56026e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<0.07641062, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <0.07641062, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <-0.1249086, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<-0.1249086, 1.23898, 1.9722>, <9.82765e-012, -0.1390425, -0.005989463>,
                         <-0.1249086, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954>,
                         <0.07641062, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<0.07641062, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <0.07641062, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <-0.1249086, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585> }
        smooth_triangle {<-0.1249086, 1.06275, 2.64557>, <6.62466e-011, -0.1339984, -0.04037394>,
                         <-0.1249086, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905>,
                         <0.07641062, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<0.07641062, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <0.07641061, 0.7892513, 3.28786>, <9.0827e-011, -0.1291807, -0.05535443>,
                         <-0.1249086, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<-0.1249086, 0.7892513, 3.28786>, <9.07068e-011, -0.1292119, -0.05528109>,
                         <-0.1249086, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966>,
                         <0.07641062, 1.06275, 2.64557>, <7.42796e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<0.07641061, 0.7892513, 3.28786>, <9.0827e-011, -0.1291807, -0.05535443>,
                         <0.07641061, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108>,
                         <-0.1249086, 0.5113787, 3.92829>, <9.17896e-011, -0.128931, -0.05594108> }
        smooth_triangle {<-0.1249086, 0.5113787, 3.92829>, <9.17896e-011, -0.128931, -0.05594108>,
                         <-0.1249086, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109>,
                         <0.07641061, 0.7892513, 3.28786>, <9.10676e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<0.2777298, 0.5115999, -0.6927509>, <-8.27703e-011, -0.1311793, 0.05044409>,
                         <0.2777298, 0.7621676, -0.04115229>, <-8.25889e-011, -0.1312215, 0.05033363>,
                         <0.07641062, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<0.07641062, 0.7621676, -0.04115229>, <-8.26341e-011, -0.131211, 0.05036125>,
                         <0.07641062, 0.5115999, -0.6927509>, <-8.27698e-011, -0.1311793, 0.05044409>,
                         <0.2777298, 0.5115999, -0.6927509>, <-8.27702e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<0.2777298, 0.7621676, -0.04115229>, <-8.25889e-011, -0.1312215, 0.05033363>,
                         <0.2777298, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <0.07641062, 1.01109, 0.6110759>, <-7.78105e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<0.07641062, 1.01109, 0.6110759>, <-7.89145e-011, -0.131934, 0.04809428>,
                         <0.07641062, 0.7621676, -0.04115229>, <-8.24982e-011, -0.1312427, 0.0502784>,
                         <0.2777298, 0.7621676, -0.04115229>, <-8.24983e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<0.2777298, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <0.2777298, 1.21991, 1.27578>, <-4.8086e-011, -0.135946, 0.02930601>,
                         <0.07641062, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601> }
        smooth_triangle {<0.07641062, 1.21991, 1.27578>, <-5.33093e-011, -0.1354139, 0.03248925>,
                         <0.07641062, 1.01109, 0.6110759>, <-7.56026e-011, -0.1325619, 0.04607584>,
                         <0.2777298, 1.01109, 0.6110759>, <-7.56024e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<0.2777298, 1.21991, 1.27578>, <-4.8086e-011, -0.135946, 0.02930601>,
                         <0.2777298, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <0.07641062, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<0.07641062, 1.23898, 1.9722>, <9.82765e-012, -0.1390425, -0.005989463>,
                         <0.07641062, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954>,
                         <0.2777298, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<0.2777298, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <0.2777298, 1.06275, 2.64557>, <6.89245e-011, -0.133477, -0.04200585>,
                         <0.07641062, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585> }
        smooth_triangle {<0.07641062, 1.06275, 2.64557>, <6.62467e-011, -0.1339984, -0.04037394>,
                         <0.07641062, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905>,
                         <0.2777298, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<0.2777298, 1.06275, 2.64557>, <6.89245e-011, -0.133477, -0.04200585>,
                         <0.2777298, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <0.07641061, 0.7892513, 3.28786>, <9.0827e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<0.07641061, 0.7892513, 3.28786>, <9.07067e-011, -0.1292119, -0.05528109>,
                         <0.07641062, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966>,
                         <0.2777298, 1.06275, 2.64557>, <7.42798e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<0.2777298, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <0.2777298, 0.5113787, 3.92829>, <9.17899e-011, -0.128931, -0.05594108>,
                         <0.07641061, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108> }
        smooth_triangle {<0.07641061, 0.5113787, 3.92829>, <9.17897e-011, -0.128931, -0.05594108>,
                         <0.07641061, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109>,
                         <0.2777298, 0.7892513, 3.28786>, <9.10679e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<0.479049, 0.5115999, -0.6927509>, <-8.27699e-011, -0.1311793, 0.05044409>,
                         <0.479049, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363>,
                         <0.2777298, 0.7621676, -0.04115229>, <-8.25889e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<0.2777298, 0.7621676, -0.04115229>, <-8.26342e-011, -0.131211, 0.05036125>,
                         <0.2777298, 0.5115999, -0.6927509>, <-8.27701e-011, -0.1311793, 0.05044409>,
                         <0.479049, 0.5115999, -0.6927509>, <-8.27699e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<0.479049, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363>,
                         <0.479049, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <0.2777298, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<0.2777298, 1.01109, 0.6110759>, <-7.89143e-011, -0.131934, 0.04809428>,
                         <0.2777298, 0.7621676, -0.04115229>, <-8.24982e-011, -0.1312427, 0.0502784>,
                         <0.479049, 0.7621676, -0.04115229>, <-8.24981e-011, -0.1312427, 0.0502784> }
        smooth_triangle {<0.479049, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146>,
                         <0.479049, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <0.2777298, 1.21991, 1.27578>, <-4.8086e-011, -0.135946, 0.02930601> }
        smooth_triangle {<0.2777298, 1.21991, 1.27578>, <-5.33091e-011, -0.1354139, 0.03248925>,
                         <0.2777298, 1.01109, 0.6110759>, <-7.56023e-011, -0.1325619, 0.04607584>,
                         <0.479049, 1.01109, 0.6110759>, <-7.56023e-011, -0.1325619, 0.04607584> }
        smooth_triangle {<0.479049, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601>,
                         <0.479049, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <0.2777298, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<0.2777298, 1.23898, 1.9722>, <9.8277e-012, -0.1390425, -0.005989463>,
                         <0.2777298, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954>,
                         <0.479049, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954> }
        smooth_triangle {<0.479049, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992>,
                         <0.479049, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <0.2777298, 1.06275, 2.64557>, <6.89245e-011, -0.133477, -0.04200585> }
        smooth_triangle {<0.2777298, 1.06275, 2.64557>, <6.62467e-011, -0.1339984, -0.04037394>,
                         <0.2777298, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905>,
                         <0.479049, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905> }
        smooth_triangle {<0.479049, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585>,
                         <0.479049, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <0.2777298, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<0.2777298, 0.7892513, 3.28786>, <9.07068e-011, -0.1292119, -0.05528109>,
                         <0.2777298, 1.06275, 2.64557>, <7.42798e-011, -0.1324341, -0.04526966>,
                         <0.479049, 1.06275, 2.64557>, <7.42797e-011, -0.1324341, -0.04526966> }
        smooth_triangle {<0.479049, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443>,
                         <0.479049, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108>,
                         <0.2777298, 0.5113787, 3.92829>, <9.17899e-011, -0.128931, -0.05594108> }
        smooth_triangle {<0.2777298, 0.5113787, 3.92829>, <9.17898e-011, -0.128931, -0.05594108>,
                         <0.2777298, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109>,
                         <0.479049, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109> }
        smooth_triangle {<0.6803682, 0.5115999, -0.6927509>, <-8.27703e-011, -0.1311793, 0.05044409>,
                         <0.6803682, 0.7621676, -0.04115229>, <-8.24984e-011, -0.1312427, 0.0502784>,
                         <0.479049, 0.7621676, -0.04115229>, <-8.25887e-011, -0.1312215, 0.05033363> }
        smooth_triangle {<0.479049, 0.7621676, -0.04115229>, <-8.26341e-011, -0.131211, 0.05036125>,
                         <0.479049, 0.5115999, -0.6927509>, <-8.27701e-011, -0.1311793, 0.05044409>,
                         <0.6803682, 0.5115999, -0.6927509>, <-8.27703e-011, -0.1311793, 0.05044409> }
        smooth_triangle {<0.6803682, 0.7621676, -0.04115229>, <-8.24984e-011, -0.1312427, 0.0502784>,
                         <0.6803682, 1.01109, 0.6110759>, <-7.56027e-011, -0.1325619, 0.04607584>,
                         <0.479049, 1.01109, 0.6110759>, <-7.78103e-011, -0.1321433, 0.04742146> }
        smooth_triangle {<0.479049, 1.01109, 0.6110759>, <-7.89143e-011, -0.131934, 0.04809428>,
                         <0.479049, 0.7621676, -0.04115229>, <-8.24981e-011, -0.1312427, 0.0502784>,
                         <0.6803682, 0.7621676, -0.04115229>, <-8.24078e-011, -0.1312638, 0.05022318> }
        smooth_triangle {<0.6803682, 1.01109, 0.6110759>, <-7.56027e-011, -0.1325619, 0.04607584>,
                         <0.6803682, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954>,
                         <0.479049, 1.21991, 1.27578>, <-4.80861e-011, -0.135946, 0.02930601> }
        smooth_triangle {<0.479049, 1.21991, 1.27578>, <-5.33093e-011, -0.1354139, 0.03248925>,
                         <0.479049, 1.01109, 0.6110759>, <-7.56024e-011, -0.1325619, 0.04607584>,
                         <0.6803682, 1.01109, 0.6110759>, <-7.33947e-011, -0.1329805, 0.04473021> }
        smooth_triangle {<0.6803682, 1.21991, 1.27578>, <-3.76399e-011, -0.1370101, 0.02293954>,
                         <0.6803682, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905>,
                         <0.479049, 1.23898, 1.9722>, <1.52039e-011, -0.1386558, -0.009265992> }
        smooth_triangle {<0.479049, 1.23898, 1.9722>, <9.82765e-012, -0.1390425, -0.005989463>,
                         <0.479049, 1.21991, 1.27578>, <-3.76398e-011, -0.1370101, 0.02293954>,
                         <0.6803682, 1.21991, 1.27578>, <-2.71936e-011, -0.1380742, 0.01657307> }
        smooth_triangle {<0.6803682, 1.23898, 1.9722>, <2.59564e-011, -0.1378825, -0.01581905>,
                         <0.6803682, 1.06275, 2.64557>, <7.42799e-011, -0.1324341, -0.04526966>,
                         <0.479049, 1.06275, 2.64557>, <6.89243e-011, -0.133477, -0.04200585> }
        smooth_triangle {<0.479049, 1.06275, 2.64557>, <6.62467e-011, -0.1339984, -0.04037394>,
                         <0.479049, 1.23898, 1.9722>, <2.59563e-011, -0.1378825, -0.01581905>,
                         <0.6803682, 1.23898, 1.9722>, <3.67088e-011, -0.1371093, -0.02237211> }
        smooth_triangle {<0.6803682, 1.06275, 2.64557>, <7.42799e-011, -0.1324341, -0.04526966>,
                         <0.6803682, 0.7892513, 3.28786>, <9.10675e-011, -0.1291183, -0.05550109>,
                         <0.479049, 0.7892513, 3.28786>, <9.08272e-011, -0.1291807, -0.05535443> }
        smooth_triangle {<0.479049, 0.7892513, 3.28786>, <9.07069e-011, -0.1292119, -0.05528109>,
                         <0.479049, 1.06275, 2.64557>, <7.42798e-011, -0.1324341, -0.04526966>,
                         <0.6803682, 1.06275, 2.64557>, <7.96353e-011, -0.1313913, -0.04853347> }
        smooth_triangle {<0.6803682, 0.7892513, 3.28786>, <9.10675e-011, -0.1291183, -0.05550109>,
                         <0.6803682, 0.5113787, 3.92829>, <9.1789e-011, -0.128931, -0.05594108>,
                         <0.479049, 0.5113787, 3.92829>, <9.17895e-011, -0.128931, -0.05594108> }
        smooth_triangle {<0.479049, 0.5113787, 3.92829>, <9.17896e-011, -0.128931, -0.05594108>,
                         <0.479049, 0.7892513, 3.28786>, <9.10678e-011, -0.1291183, -0.05550109>,
                         <0.6803682, 0.7892513, 3.28786>, <9.13082e-011, -0.1290559, -0.05564776> }
    }
}

#declare Cockpit =
union {  // Layer name: SIDE
    union { // Poly_Mesh
        smooth_triangle {<5.00942, -4.72538, 9.46177>, <-1.06522e-008, -7.45569, 4.55099>,
                         <-5.4355, -4.72538, 9.46177>, <-1.10947e-008, -7.36291, 4.74004>,
                         <-5.40433, -5.16109, 8.74796>, <-1.06522e-008, -7.45569, 4.55099> }
        smooth_triangle {<-5.40433, -5.16109, 8.74796>, <-1.06204e-008, -7.43345, 4.53741>,
                         <4.97826, -5.16109, 8.74796>, <-1.05887e-008, -7.4112, 4.52383>,
                         <5.00942, -4.72538, 9.46177>, <-1.06204e-008, -7.43345, 4.53741> }
        smooth_triangle {<5.03964, -4.25618, 10.1538>, <-1.15373e-008, -7.27013, 4.9291>,
                         <-5.46572, -4.25618, 10.1538>, <-1.25248e-008, -6.97063, 5.35101>,
                         <-5.4355, -4.72538, 9.46177>, <-1.10947e-008, -7.36291, 4.74004> }
        smooth_triangle {<-5.4355, -4.72538, 9.46177>, <-1.12201e-008, -7.31804, 4.79361>,
                         <5.00942, -4.72538, 9.46177>, <-1.10616e-008, -7.342, 4.72586>,
                         <5.03964, -4.25618, 10.1538>, <-1.15041e-008, -7.24922, 4.91492> }
        smooth_triangle {<5.06722, -3.70953, 10.7855>, <-1.35123e-008, -6.67113, 5.77292>,
                         <-5.4933, -3.70953, 10.7855>, <-1.49207e-008, -6.06333, 6.37463>,
                         <-5.46572, -4.25618, 10.1538>, <-1.25248e-008, -6.97063, 5.35101> }
        smooth_triangle {<-5.46572, -4.25618, 10.1538>, <-1.28304e-008, -6.85918, 5.48159>,
                         <5.03964, -4.25618, 10.1538>, <-1.24895e-008, -6.95321, 5.33593>,
                         <5.06722, -3.70953, 10.7855>, <-1.3477e-008, -6.65371, 5.75784> }
        smooth_triangle {<5.08968, -3.05172, 11.2999>, <-1.63291e-008, -5.45552, 6.97635>,
                         <-5.51576, -3.05172, 11.2999>, <-1.74425e-008, -4.74056, 7.45203>,
                         <-5.4933, -3.70953, 10.7855>, <-1.49207e-008, -6.06333, 6.37463> }
        smooth_triangle {<-5.4933, -3.70953, 10.7855>, <-1.53671e-008, -5.85302, 6.56535>,
                         <5.06722, -3.70953, 10.7855>, <-1.48862e-008, -6.05177, 6.35986>,
                         <5.08968, -3.05172, 11.2999>, <-1.62946e-008, -5.44397, 6.96157> }
        smooth_triangle {<5.1062, -2.30653, 11.6783>, <-1.85559e-008, -4.02559, 7.92772>,
                         <-5.53228, -2.30653, 11.6783>, <-1.91288e-008, -3.48527, 8.17247>,
                         <-5.51576, -3.05172, 11.2999>, <-1.74425e-008, -4.74056, 7.45203> }
        smooth_triangle {<-5.51576, -3.05172, 11.2999>, <-1.77945e-008, -4.49807, 7.60238>,
                         <5.08968, -3.05172, 11.2999>, <-1.74137e-008, -4.7343, 7.43972>,
                         <5.1062, -2.30653, 11.6783>, <-1.85271e-008, -4.01934, 7.9154> }
        smooth_triangle {<5.11826, -1.51711, 11.9545>, <-1.97017e-008, -2.94495, 8.41723>,
                         <-5.54434, -1.51711, 11.9545>, <-2.00068e-008, -2.53681, 8.54756>,
                         <-5.53228, -2.30653, 11.6783>, <-1.91288e-008, -3.48527, 8.17247> }
        smooth_triangle {<-5.53228, -2.30653, 11.6783>, <-1.93049e-008, -3.30294, 8.24771>,
                         <5.1062, -2.30653, 11.6783>, <-1.91066e-008, -3.48194, 8.16295>,
                         <5.11826, -1.51711, 11.9545>, <-1.96794e-008, -2.94162, 8.40771> }
        smooth_triangle {<5.12696, -0.7045735, 12.1538>, <-2.03118e-008, -2.12867, 8.67788>,
                         <-5.55304, -0.7045735, 12.1538>, <-2.04848e-008, -1.79473, 8.75177>,
                         <-5.54434, -1.51711, 11.9545>, <-2.00068e-008, -2.53681, 8.54756> }
        smooth_triangle {<-5.54434, -1.51711, 11.9545>, <-2.00974e-008, -2.39961, 8.58629>,
                         <5.11826, -1.51711, 11.9545>, <-1.99902e-008, -2.53507, 8.54049>,
                         <5.12696, -0.7045735, 12.1538>, <-2.02953e-008, -2.12693, 8.67081> }
        smooth_triangle {<5.13293, 0.1208767, 12.2905>, <-2.06577e-008, -1.46079, 8.82566>,
                         <-5.559, 0.1208767, 12.2905>, <-2.07647e-008, -1.11473, 8.87139>,
                         <-5.55304, -0.7045735, 12.1538>, <-2.04848e-008, -1.79473, 8.75177> }
        smooth_triangle {<-5.55304, -0.7045735, 12.1538>, <-2.05347e-008, -1.68287, 8.77312>,
                         <5.12696, -0.7045735, 12.1538>, <-2.04732e-008, -1.79391, 8.74685>,
                         <5.13293, 0.1208767, 12.2905>, <-2.06462e-008, -1.45998, 8.82073> }
        smooth_triangle {<5.13606, 0.9543919, 12.3623>, <-2.08718e-008, -0.768677, 8.91712>,
                         <-5.56214, 0.9543919, 12.3623>, <-2.09084e-008, -0.3694512, 8.93274>,
                         <-5.559, 0.1208767, 12.2905>, <-2.07647e-008, -1.11473, 8.87139> }
        smooth_triangle {<-5.559, 0.1208767, 12.2905>, <-2.07963e-008, -0.9992313, 8.88489>,
                         <5.13293, 0.1208767, 12.2905>, <-2.07586e-008, -1.11451, 8.86877>,
                         <5.13606, 0.9543919, 12.3623>, <-2.08657e-008, -0.7684516, 8.9145> }
        smooth_triangle {<5.13594, 1.79085, 12.3595>, <-2.09449e-008, 0.02977452, 8.94837>,
                         <-5.56202, 1.79085, 12.3595>, <-2.08582e-008, 0.5427708, 8.9113>,
                         <-5.56214, 0.9543919, 12.3623>, <-2.09084e-008, -0.3694512, 8.93274> }
        smooth_triangle {<-5.56214, 0.9543919, 12.3623>, <-2.09207e-008, -0.2363757, 8.93802>,
                         <5.13606, 0.9543919, 12.3623>, <-2.09086e-008, -0.3694509, 8.93284>,
                         <5.13594, 1.79085, 12.3595>, <-2.09452e-008, 0.02977486, 8.94847> }
        smooth_triangle {<5.13163, 2.62104, 12.2608>, <-2.07714e-008, 1.05577, 8.87423>,
                         <-5.55771, 2.62104, 12.2608>, <-2.03353e-008, 1.84979, 8.68793>,
                         <-5.56202, 1.79085, 12.3595>, <-2.08582e-008, 0.5427708, 8.9113> }
        smooth_triangle {<-5.56202, 1.79085, 12.3595>, <-2.08348e-008, 0.7140535, 8.90133>,
                         <5.13594, 1.79085, 12.3595>, <-2.08665e-008, 0.5431967, 8.91488>,
                         <5.13163, 2.62104, 12.2608>, <-2.07798e-008, 1.05619, 8.87781> }
        smooth_triangle {<5.12081, 3.41799, 12.0129>, <-1.98993e-008, 2.64381, 8.50163>,
                         <-5.54689, 3.41799, 12.0129>, <-1.84073e-008, 3.85829, 7.86421>,
                         <-5.55771, 2.62104, 12.2608>, <-2.03353e-008, 1.84979, 8.68793> }
        smooth_triangle {<-5.55771, 2.62104, 12.2608>, <-2.02034e-008, 2.11625, 8.63158>,
                         <5.13163, 2.62104, 12.2608>, <-2.03555e-008, 1.85247, 8.69655>,
                         <5.12081, 3.41799, 12.0129>, <-1.99195e-008, 2.6465, 8.51025> }
        smooth_triangle {<5.09997, 4.0981, 11.5355>, <-1.69153e-008, 5.07276, 7.22679>,
                         <-5.52604, 4.0981, 11.5355>, <-1.45319e-008, 6.0965, 6.20851>,
                         <-5.54689, 3.41799, 12.0129>, <-1.84073e-008, 3.85829, 7.86421> }
        smooth_triangle {<-5.54689, 3.41799, 12.0129>, <-1.79321e-008, 4.26975, 7.66119>,
                         <5.12081, 3.41799, 12.0129>, <-1.84405e-008, 3.86824, 7.87839>,
                         <5.09997, 4.0981, 11.5355>, <-1.69485e-008, 5.08272, 7.24097> }
        smooth_triangle {<5.07055, 4.58926, 10.8617>, <-1.21485e-008, 7.12024, 5.19024>,
                         <-5.49662, 4.58926, 10.8617>, <-1.07279e-008, 7.47404, 4.58332>,
                         <-5.52604, 4.0981, 11.5355>, <-1.45319e-008, 6.0965, 6.20851> }
        smooth_triangle {<-5.52604, 4.0981, 11.5355>, <-1.376e-008, 6.45096, 5.87872>,
                         <5.09997, 4.0981, 11.5355>, <-1.45657e-008, 6.11632, 6.22296>,
                         <5.07055, 4.58926, 10.8617>, <-1.21823e-008, 7.14006, 5.20469> }
        smooth_triangle {<5.038, 4.96789, 10.1164>, <-9.30732e-009, 7.82785, 3.9764>,
                         <-5.46408, 4.96789, 10.1164>, <-9.30732e-009, 7.82785, 3.9764>,
                         <-5.49662, 4.58926, 10.8617>, <-1.07279e-008, 7.47404, 4.58332> }
        smooth_triangle {<-5.49662, 4.58926, 10.8617>, <-1.02736e-008, 7.60815, 4.38922>,
                         <5.07055, 4.58926, 10.8617>, <-1.07567e-008, 7.4983, 4.59564>,
                         <5.038, 4.96789, 10.1164>, <-9.33616e-009, 7.8521, 3.98872> }
    }
    union { // Poly_Mesh
        smooth_triangle {<4.93333, -5.43736, 7.71891>, <0.01359976, 5.27282, -1.34757>,
                         <-0.2129116, -5.42295, 7.72337>, <0.009200267, 5.27578, -1.32647>,
                         <-0.2130385, -5.16109, 8.74796>, <0.01359976, 5.27282, -1.34757> }
        smooth_triangle {<-0.2130385, -5.16109, 8.74796>, <0.006799881, 5.30747, -1.39088>,
                         <4.97826, -5.16109, 8.74796>, <3.35692e-009, 5.34213, -1.43419>,
                         <4.93333, -5.43736, 7.71891>, <0.006799881, 5.30747, -1.39088> }
        smooth_triangle {<-0.2129116, -5.42295, 7.72337>, <0.009200267, 5.27578, -1.32647>,
                         <-5.35941, -5.43736, 7.71891>, <-0.02060027, 5.2891, -1.35339>,
                         <-5.40433, -5.16109, 8.74796>, <-0.01359975, 5.29622, -1.42246> }
        smooth_triangle {<-5.40433, -5.16109, 8.74796>, <-0.006799875, 5.3076, -1.39091>,
                         <-0.2130385, -5.16109, 8.74796>, <0.006799881, 5.2959, -1.35347>,
                         <-0.2129116, -5.42295, 7.72337>, <0.006900201, 5.28658, -1.33469> }
        smooth_triangle {<4.88813, -5.68886, 6.68359>, <0.0276008, 5.25831, -1.20938>,
                         <-0.2127847, -5.66004, 6.69251>, <0.01418852, 5.26898, -1.14395>,
                         <-0.2129116, -5.42295, 7.72337>, <0.009200267, 5.27578, -1.32647> }
        smooth_triangle {<-0.2129116, -5.42295, 7.72337>, <0.0103503, 5.28888, -1.31859>,
                         <4.93333, -5.43736, 7.71891>, <0.01370008, 5.3005, -1.32126>,
                         <4.88813, -5.68886, 6.68359>, <0.0207006, 5.29324, -1.25216> }
        smooth_triangle {<-0.2127847, -5.66004, 6.69251>, <0.01418852, 5.26898, -1.14395>,
                         <-5.3142, -5.68886, 6.68359>, <-0.03508318, 5.2863, -1.14873>,
                         <-5.35941, -5.43736, 7.71891>, <-0.02060027, 5.2891, -1.35339> }
        smooth_triangle {<-5.35941, -5.43736, 7.71891>, <-0.01833365, 5.2945, -1.30899>,
                         <-0.2129116, -5.42295, 7.72337>, <0.003450102, 5.28316, -1.2999>,
                         <-0.2127847, -5.66004, 6.69251>, <0.007191295, 5.27806, -1.16301> }
        smooth_triangle {<4.84244, -5.88886, 5.63728>, <0.04256557, 5.26667, -0.9381376>,
                         <-0.2126579, -5.84562, 5.65066>, <0.01963416, 5.27866, -0.8240968>,
                         <-0.2127847, -5.66004, 6.69251>, <0.01418852, 5.26898, -1.14395> }
        smooth_triangle {<-0.2127847, -5.66004, 6.69251>, <0.01773565, 5.28612, -1.11333>,
                         <4.88813, -5.68886, 6.68359>, <0.02798892, 5.29793, -1.11543>,
                         <4.84244, -5.88886, 5.63728>, <0.03547131, 5.30211, -0.9798084> }
        smooth_triangle {<-0.2126579, -5.84562, 5.65066>, <0.01963416, 5.27866, -0.8240968>,
                         <-5.26852, -5.88886, 5.63728>, <-0.05073401, 5.29676, -0.804567>,
                         <-5.3142, -5.68886, 6.68359>, <-0.03508318, 5.2863, -1.14873> }
        smooth_triangle {<-5.3142, -5.68886, 6.68359>, <-0.0328478, 5.29584, -1.0814>,
                         <-0.2127847, -5.66004, 6.69251>, <0.003547133, 5.28047, -1.09465>,
                         <-0.2126579, -5.84562, 5.65066>, <0.007631357, 5.28772, -0.8547582> }
        smooth_triangle {<4.79623, -6.00729, 4.57893>, <0.05890246, 5.27868, -0.5210245>,
                         <-0.212531, -5.94964, 4.59677>, <0.02543268, 5.28103, -0.3807039>,
                         <-0.2126579, -5.84562, 5.65066>, <0.01963416, 5.27866, -0.8240968> }
        smooth_triangle {<-0.2126579, -5.84562, 5.65066>, <0.02576983, 5.29666, -0.7682494>,
                         <4.84244, -5.88886, 5.63728>, <0.04337121, 5.30867, -0.7694225>,
                         <4.79623, -6.00729, 4.57893>, <0.05153965, 5.31468, -0.560866> }
        smooth_triangle {<-0.212531, -5.94964, 4.59677>, <0.02543268, 5.28103, -0.3807039>,
                         <-5.22231, -6.00729, 4.57893>, <-0.06760025, 5.29446, -0.3479946>,
                         <-5.26852, -5.88886, 5.63728>, <-0.05073401, 5.29676, -0.804567> }
        smooth_triangle {<-5.26852, -5.88886, 5.63728>, <-0.04854829, 5.30728, -0.7116902>,
                         <-0.2126579, -5.84562, 5.65066>, <0.003681406, 5.29107, -0.7495567>,
                         <-0.212531, -5.94964, 4.59677>, <0.008030301, 5.29285, -0.4170121> }
        smooth_triangle {<4.74974, -6.02676, 3.51415>, <0.07629805, 5.26149, -0.02508144>,
                         <-0.2124041, -5.9547, 3.53644>, <0.03121304, 5.25076, 0.08545125>,
                         <-0.212531, -5.94964, 4.59677>, <0.02543268, 5.28103, -0.3807039> }
        smooth_triangle {<-0.212531, -5.94964, 4.59677>, <0.03433412, 5.29429, -0.310577>,
                         <4.79623, -6.00729, 4.57893>, <0.05997045, 5.30638, -0.3106104>,
                         <4.74974, -6.02676, 3.51415>, <0.06866824, 5.29778, -0.06263886> }
        smooth_triangle {<-0.2124041, -5.9547, 3.53644>, <0.03121304, 5.25076, 0.08545125>,
                         <-5.17582, -6.02676, 3.51415>, <-0.08496858, 5.25778, 0.1033294>,
                         <-5.22231, -6.00729, 4.57893>, <-0.06760025, 5.29446, -0.3479946> }
        smooth_triangle {<-5.22231, -6.00729, 4.57893>, <-0.06541298, 5.3003, -0.2404427>,
                         <-0.212531, -5.94964, 4.59677>, <0.003814903, 5.28877, -0.2918626>,
                         <-0.2124041, -5.9547, 3.53644>, <0.008150168, 5.26607, 0.05775375> }
        smooth_triangle {<4.70332, -5.96359, 2.45086>, <0.09363911, 5.20478, 0.3814186>,
                         <-0.2122772, -5.87711, 2.47761>, <0.03687865, 5.18806, 0.4554914>,
                         <-0.2124041, -5.9547, 3.53644>, <0.03121304, 5.25076, 0.08545125> }
        smooth_triangle {<-0.2124041, -5.9547, 3.53644>, <0.04291792, 5.25737, 0.1416275>,
                         <4.74974, -6.02676, 3.51415>, <0.07716532, 5.26936, 0.1425374>,
                         <4.70332, -5.96359, 2.45086>, <0.08583585, 5.241, 0.3457874> }
        smooth_triangle {<-0.2122772, -5.87711, 2.47761>, <0.03687865, 5.18806, 0.4554914>,
                         <-5.1294, -5.96359, 2.45086>, <-0.1021375, 5.19222, 0.4552125>,
                         <-5.17582, -6.02676, 3.51415>, <-0.08496858, 5.25778, 0.1033294> }
        smooth_triangle {<-5.17582, -6.02676, 3.51415>, <-0.08265658, 5.25699, 0.1972559>,
                         <-0.2124041, -5.9547, 3.53644>, <0.003901629, 5.25192, 0.1603657>,
                         <-0.2122772, -5.87711, 2.47761>, <0.008150837, 5.2049, 0.4378958> }
        smooth_triangle {<4.65713, -5.83868, 1.39289>, <0.1106359, 5.12985, 0.6784135>,
                         <-0.2121503, -5.73779, 1.4241>, <0.04241881, 5.11317, 0.7167302>,
                         <-0.2122772, -5.87711, 2.47761>, <0.03687865, 5.18806, 0.4554914> }
        smooth_triangle {<-0.2122772, -5.87711, 2.47761>, <0.05136669, 5.1915, 0.4941217>,
                         <4.70332, -5.96359, 2.45086>, <0.09423496, 5.20329, 0.4957155>,
                         <4.65713, -5.83868, 1.39289>, <0.1027334, 5.16583, 0.6442129> }
        smooth_triangle {<-0.2121503, -5.73779, 1.4241>, <0.04241881, 5.11317, 0.7167302>,
                         <-5.08321, -5.83868, 1.39289>, <-0.1189462, 5.11748, 0.6986424>,
                         <-5.1294, -5.96359, 2.45086>, <-0.1021375, 5.19222, 0.4552125> }
        smooth_triangle {<-5.1294, -5.96359, 2.45086>, <-0.09970196, 5.18823, 0.5318267>,
                         <-0.2122772, -5.87711, 2.47761>, <0.003951283, 5.18611, 0.5128824>,
                         <-0.2121503, -5.73779, 1.4241>, <0.008106405, 5.12995, 0.7088114> }
        smooth_triangle {<4.61118, -5.67313, 0.3404149>, <0.1272564, 5.05478, 0.8679942>,
                         <-0.2120234, -5.55783, 0.3760815>, <0.04791538, 5.03804, 0.8931517>,
                         <-0.2121503, -5.73779, 1.4241>, <0.04241881, 5.11317, 0.7167302> }
        smooth_triangle {<-0.2121503, -5.73779, 1.4241>, <0.05965145, 5.11644, 0.7379117>,
                         <4.65713, -5.83868, 1.39289>, <0.1109927, 5.12804, 0.7399349>,
                         <4.61118, -5.67313, 0.3404149>, <0.1193029, 5.0905, 0.8347253> }
        smooth_triangle {<-0.2120234, -5.55783, 0.3760815>, <0.04791538, 5.03804, 0.8931517>,
                         <-5.03725, -5.67313, 0.3404149>, <-0.1355013, 5.04244, 0.8685577>,
                         <-5.08321, -5.83868, 1.39289>, <-0.1189462, 5.11748, 0.6986424> }
        smooth_triangle {<-5.08321, -5.83868, 1.39289>, <-0.1164139, 5.1133, 0.7579545>,
                         <-0.2121503, -5.73779, 1.4241>, <0.003976762, 5.11112, 0.7566923>,
                         <-0.2120234, -5.55783, 0.3760815>, <0.008099188, 5.05477, 0.8890085> }
        smooth_triangle {<4.56548, -5.47447, -0.7063069>, <0.1437461, 4.97927, 1.01796>,
                         <-0.2118965, -5.34475, -0.6661819>, <0.0534067, 4.96104, 1.04303>,
                         <-0.2120234, -5.55783, 0.3760815>, <0.04791538, 5.03804, 0.8931517> }
        smooth_triangle {<-0.2120234, -5.55783, 0.3760815>, <0.06788012, 5.04108, 0.9080945>,
                         <4.61118, -5.67313, 0.3404149>, <0.1275154, 5.05248, 0.9104584>,
                         <4.56548, -5.47447, -0.7063069>, <0.1357602, 5.01473, 0.9854408> }
        smooth_triangle {<-0.2118965, -5.34475, -0.6661819>, <0.0534067, 4.96104, 1.04303>,
                         <-4.99155, -5.47447, -0.7063069>, <-0.1519831, 4.96481, 1.01848>,
                         <-5.03725, -5.67313, 0.3404149>, <-0.1355013, 5.04244, 0.8685577> }
        smooth_triangle {<-5.03725, -5.67313, 0.3404149>, <-0.1329256, 5.03801, 0.9217469>,
                         <-0.2120234, -5.55783, 0.3760815>, <0.003992946, 5.03582, 0.9268951>,
                         <-0.2118965, -5.34475, -0.6661819>, <0.008111439, 4.97807, 1.03931> }
        smooth_triangle {<4.52008, -5.24214, -1.7461>, <0.1602201, 4.89905, 1.16753>,
                         <-0.2117696, -5.09802, -1.70152>, <0.05885224, 4.88201, 1.18145>,
                         <-0.2118965, -5.34475, -0.6661819>, <0.0534067, 4.96104, 1.04303> }
        smooth_triangle {<-0.2118965, -5.34475, -0.6661819>, <0.07610455, 4.96311, 1.05827>,
                         <4.56548, -5.47447, -0.7063069>, <0.1439721, 4.97429, 1.06098>,
                         <4.52008, -5.24214, -1.7461>, <0.1522091, 4.93418, 1.13576> }
        smooth_triangle {<-0.2117696, -5.09802, -1.70152>, <0.05885224, 4.88201, 1.18145>,
                         <-4.94615, -5.24214, -1.7461>, <-0.1683884, 4.8865, 1.15141>,
                         <-4.99155, -5.47447, -0.7063069>, <-0.1519831, 4.96481, 1.01848> }
        smooth_triangle {<-4.99155, -5.47447, -0.7063069>, <-0.1493881, 4.95939, 1.07209>,
                         <-0.2118965, -5.34475, -0.6661819>, <0.0040055, 4.95792, 1.0771>,
                         <-0.2117696, -5.09802, -1.70152>, <0.008089653, 4.89865, 1.18091> }
        smooth_triangle {<4.47496, -4.9827, -2.77949>, <0.1765567, 4.82218, 1.28347>,
                         <-0.2116427, -4.82416, -2.73045>, <0.06427236, 4.80405, 1.29758>,
                         <-0.2117696, -5.09802, -1.70152>, <0.05885224, 4.88201, 1.18145> }
        smooth_triangle {<-0.2117696, -5.09802, -1.70152>, <0.08426571, 4.88447, 1.19137>,
                         <4.52008, -5.24214, -1.7461>, <0.1603631, 4.89545, 1.19433>,
                         <4.47496, -4.9827, -2.77949>, <0.1685314, 4.85702, 1.2523> }
        smooth_triangle {<-0.2116427, -4.82416, -2.73045>, <0.06427236, 4.80405, 1.29758>,
                         <-4.90104, -4.9827, -2.77949>, <-0.1846869, 4.8081, 1.26773>,
                         <-4.94615, -5.24214, -1.7461>, <-0.1683884, 4.8865, 1.15141> }
        smooth_triangle {<-4.94615, -5.24214, -1.7461>, <-0.165761, 4.88145, 1.19978>,
                         <-0.2117696, -5.09802, -1.70152>, <0.00401265, 4.87935, 1.21022>,
                         <-0.2116427, -4.82416, -2.73045>, <0.008077742, 4.82088, 1.29731> }
        smooth_triangle {<4.43016, -4.69555, -3.80552>, <0.1928171, 4.7418, 1.39979>,
                         <-0.2115158, -4.5226, -3.75202>, <0.06965004, 4.7187, 1.42646>,
                         <-0.2116427, -4.82416, -2.73045>, <0.06427236, 4.80405, 1.29758> }
        smooth_triangle {<-0.2116427, -4.82416, -2.73045>, <0.09239152, 4.80574, 1.30785>,
                         <4.47496, -4.9827, -2.77949>, <0.1766529, 4.81649, 1.31107>,
                         <4.43016, -4.69555, -3.80552>, <0.184783, 4.7763, 1.36923> }
        smooth_triangle {<-0.2115158, -4.5226, -3.75202>, <0.06965004, 4.7187, 1.42646>,
                         <-4.85624, -4.69555, -3.80552>, <-0.2008836, 4.72035, 1.40304>,
                         <-4.90104, -4.9827, -2.77949>, <-0.1846869, 4.8081, 1.26773> }
        smooth_triangle {<-4.90104, -4.9827, -2.77949>, <-0.1820409, 4.80225, 1.31654>,
                         <-0.2116427, -4.82416, -2.73045>, <0.00401702, 4.80068, 1.32672>,
                         <-0.2115158, -4.5226, -3.75202>, <0.008050275, 4.73666, 1.42338> }
        smooth_triangle {<4.38584, -4.37203, -4.82065>, <0.2089501, 4.64626, 1.5536>,
                         <-0.211389, -4.18466, -4.76269>, <0.0749057, 4.61681, 1.59274>,
                         <-0.2115158, -4.5226, -3.75202>, <0.06965004, 4.7187, 1.42646> }
        smooth_triangle {<-0.2115158, -4.5226, -3.75202>, <0.1004568, 4.71759, 1.44335>,
                         <4.43016, -4.69555, -3.80552>, <0.1928471, 4.72803, 1.44691>,
                         <4.38584, -4.37203, -4.82065>, <0.2009136, 4.68026, 1.52381> }
        smooth_triangle {<-0.211389, -4.18466, -4.76269>, <0.0749057, 4.61681, 1.59274>,
                         <-4.81192, -4.37203, -4.82065>, <-0.2168336, 4.61537, 1.57574>,
                         <-4.85624, -4.69555, -3.80552>, <-0.2008836, 4.72035, 1.40304> }
        smooth_triangle {<-4.85624, -4.69555, -3.80552>, <-0.1982147, 4.71166, 1.45856>,
                         <-0.2115158, -4.5226, -3.75202>, <0.004018268, 4.71259, 1.46225>,
                         <-0.211389, -4.18466, -4.76269>, <0.007960015, 4.63617, 1.58696> }
        smooth_triangle {<4.34219, -4.00332, -5.82028>, <0.2247171, 4.53147, 1.74455>,
                         <-0.2112621, -3.80154, -5.75786>, <0.08008019, 4.50723, 1.76343>,
                         <-0.211389, -4.18466, -4.76269>, <0.0749057, 4.61681, 1.59274> }
        smooth_triangle {<-0.211389, -4.18466, -4.76269>, <0.1083457, 4.61212, 1.61627>,
                         <4.38584, -4.37203, -4.82065>, <0.208808, 4.62216, 1.62023>,
                         <4.34219, -4.00332, -5.82028>, <0.2166915, 4.56477, 1.71571> }
        smooth_triangle {<-0.2112621, -3.80154, -5.75786>, <0.08008019, 4.50723, 1.76343>,
                         <-4.76827, -4.00332, -5.82028>, <-0.2324789, 4.50849, 1.73647>,
                         <-4.81192, -4.37203, -4.82065>, <-0.2168336, 4.61537, 1.57574> }
        smooth_triangle {<-4.81192, -4.37203, -4.82065>, <-0.214111, 4.60302, 1.638>,
                         <-0.211389, -4.18466, -4.76269>, <0.004012802, 4.60719, 1.63519>,
                         <-0.2112621, -3.80154, -5.75786>, <0.007893672, 4.52501, 1.76321> }
        smooth_triangle {<4.29909, -3.60216, -6.80743>, <0.2402406, 4.43217, 1.87435>,
                         <-0.2111352, -3.38597, -6.74056>, <0.08534369, 4.421, 1.85877>,
                         <-0.2112621, -3.80154, -5.75786>, <0.08008019, 4.50723, 1.76343> }
        smooth_triangle {<-0.2112621, -3.80154, -5.75786>, <0.1161163, 4.50484, 1.77707>,
                         <4.34219, -4.00332, -5.82028>, <0.2244708, 4.51456, 1.78126>,
                         <4.29909, -3.60216, -6.80743>, <0.2322326, 4.46491, 1.84616> }
        smooth_triangle {<-0.2111352, -3.38597, -6.74056>, <0.08534369, 4.421, 1.85877>,
                         <-4.72517, -3.60216, -6.80743>, <-0.2481358, 4.4289, 1.81465>,
                         <-4.76827, -4.00332, -5.82028>, <-0.2324789, 4.50849, 1.73647> }
        smooth_triangle {<-4.76827, -4.00332, -5.82028>, <-0.2297274, 4.49838, 1.78889>,
                         <-0.2112621, -3.80154, -5.75786>, <0.004004006, 4.49996, 1.79601>,
                         <-0.2111352, -3.38597, -6.74056>, <0.007951629, 4.43529, 1.86751> }
        smooth_triangle {<4.25617, -3.19116, -7.79056>, <0.2560311, 4.3719, 1.90042>,
                         <-0.2110083, -2.96056, -7.71923>, <0.09063042, 4.36367, 1.87771>,
                         <-0.2111352, -3.38597, -6.74056>, <0.08534369, 4.421, 1.85877> }
        smooth_triangle {<-0.2111352, -3.38597, -6.74056>, <0.1240151, 4.425, 1.85518>,
                         <4.29909, -3.60216, -6.80743>, <0.2401349, 4.43459, 1.85938>,
                         <4.25617, -3.19116, -7.79056>, <0.2480301, 4.40446, 1.87242> }
        smooth_triangle {<-0.2110083, -2.96056, -7.71923>, <0.09063042, 4.36367, 1.87771>,
                         <-4.68225, -3.19116, -7.79056>, <-0.2639612, 4.37317, 1.83011>,
                         <-4.72517, -3.60216, -6.80743>, <-0.2481358, 4.4289, 1.81465> }
        smooth_triangle {<-4.72517, -3.60216, -6.80743>, <-0.2454336, 4.42519, 1.84987>,
                         <-0.2111352, -3.38597, -6.74056>, <0.004000481, 4.42019, 1.87415>,
                         <-0.2110083, -2.96056, -7.71923>, <0.007965533, 4.3772, 1.88835> }
        smooth_triangle {<4.21334, -2.77501, -8.77152>, <0.2718913, 4.32025, 1.90493>,
                         <-0.2108814, -2.52999, -8.69573>, <0.0957744, 4.30451, 1.89976>,
                         <-0.2110083, -2.96056, -7.71923>, <0.09063042, 4.36367, 1.87771> }
        smooth_triangle {<-0.2110083, -2.96056, -7.71923>, <0.1319472, 4.36905, 1.87057>,
                         <4.25617, -3.19116, -7.79056>, <0.2559644, 4.37854, 1.87478>,
                         <4.21334, -2.77501, -8.77152>, <0.2638945, 4.35271, 1.87704> }
        smooth_triangle {<-0.2108814, -2.52999, -8.69573>, <0.0957744, 4.30451, 1.89976>,
                         <-4.63942, -2.77501, -8.77152>, <-0.2796073, 4.31035, 1.86105>,
                         <-4.68225, -3.19116, -7.79056>, <-0.2639612, 4.37317, 1.83011> }
        smooth_triangle {<-4.68225, -3.19116, -7.79056>, <-0.2612734, 4.37084, 1.86178>,
                         <-0.2110083, -2.96056, -7.71923>, <0.003998397, 4.3643, 1.88956>,
                         <-0.2108814, -2.52999, -8.69573>, <0.007856376, 4.31993, 1.9061> }
        smooth_triangle {<4.17084, -2.34167, -9.745>, <0.2873232, 4.24584, 1.96189>,
                         <-0.2107545, -2.08224, -9.66475>, <0.1007268, 4.22364, 1.96999>,
                         <-0.2108814, -2.52999, -8.69573>, <0.0957744, 4.30451, 1.89976> }
        smooth_triangle {<-0.2108814, -2.52999, -8.69573>, <0.139671, 4.30591, 1.90151>,
                         <4.21334, -2.77501, -8.77152>, <0.271626, 4.31517, 1.90585>,
                         <4.17084, -2.34167, -9.745>, <0.279342, 4.27797, 1.93433> }
        smooth_triangle {<-0.2107545, -2.08224, -9.66475>, <0.1007268, 4.22364, 1.96999>,
                         <-4.59691, -2.34167, -9.745>, <-0.2947519, 4.22631, 1.93811>,
                         <-4.63942, -2.77501, -8.77152>, <-0.2796073, 4.31035, 1.86105> }
        smooth_triangle {<-4.63942, -2.77501, -8.77152>, <-0.2768584, 4.30401, 1.90165>,
                         <-0.2108814, -2.52999, -8.69573>, <0.003990596, 4.30122, 1.92053>,
                         <-0.2107545, -2.08224, -9.66475>, <0.007704926, 4.24057, 1.97321> }
        smooth_triangle {<4.12887, -1.88175, -10.7062>, <0.3021805, 4.15184, 2.05842>,
                         <-0.2106276, -1.60791, -10.6215>, <0.1056993, 4.13435, 2.05529>,
                         <-0.2107545, -2.08224, -9.66475>, <0.1007268, 4.22364, 1.96999> }
        smooth_triangle {<-0.2107545, -2.08224, -9.66475>, <0.1471142, 4.22149, 1.97857>,
                         <4.17084, -2.34167, -9.745>, <0.2867997, 4.23043, 1.9831>,
                         <4.12887, -1.88175, -10.7062>, <0.2942284, 4.18344, 2.03136> }
        smooth_triangle {<-0.2106276, -1.60791, -10.6215>, <0.1056993, 4.13435, 2.05529>,
                         <-4.55495, -1.88175, -10.7062>, <-0.3096392, 4.13945, 2.01796>,
                         <-4.59691, -2.34167, -9.745>, <-0.2947519, 4.22631, 1.93811> }
        smooth_triangle {<-4.59691, -2.34167, -9.745>, <-0.2919267, 4.21638, 1.98557>,
                         <-0.2107545, -2.08224, -9.66475>, <0.003976055, 4.21686, 1.99761>,
                         <-0.2106276, -1.60791, -10.6215>, <0.007705366, 4.14989, 2.06159> }
        smooth_triangle {<4.08731, -1.40269, -11.6581>, <0.3170978, 4.0718, 2.12089>,
                         <-0.2105007, -1.11443, -11.5689>, <0.1108816, 4.06417, 2.09763>,
                         <-0.2106276, -1.60791, -10.6215>, <0.1056993, 4.13435, 2.05529> }
        smooth_triangle {<-0.2106276, -1.60791, -10.6215>, <0.1545852, 4.1343, 2.05834>,
                         <4.12887, -1.88175, -10.7062>, <0.3017117, 4.14301, 2.06296>,
                         <4.08731, -1.40269, -11.6581>, <0.3091703, 4.10299, 2.0942> }
        smooth_triangle {<-0.2105007, -1.11443, -11.5689>, <0.1108816, 4.06417, 2.09763>,
                         <-4.51339, -1.40269, -11.6581>, <-0.3248713, 4.07432, 2.05032>,
                         <-4.55495, -1.88175, -10.7062>, <-0.3096392, 4.13945, 2.01796> }
        smooth_triangle {<-4.55495, -1.88175, -10.7062>, <-0.3068404, 4.1316, 2.0599>,
                         <-0.2106276, -1.60791, -10.6215>, <0.003963717, 4.12973, 2.07741>,
                         <-0.2105007, -1.11443, -11.5689>, <0.007850492, 4.0771, 2.10916> }
        smooth_triangle {<4.04587, -0.9184005, -12.6073>, <0.3326449, 4.02121, 2.12262>,
                         <-0.2103738, -0.6157338, -12.5137>, <0.1160958, 4.01525, 2.09622>,
                         <-0.2105007, -1.11443, -11.5689>, <0.1108816, 4.06417, 2.09763> }
        smooth_triangle {<-0.2105007, -1.11443, -11.5689>, <0.1623624, 4.06897, 2.09058>,
                         <4.08731, -1.40269, -11.6581>, <0.3169512, 4.07758, 2.09516>,
                         <4.04587, -0.9184005, -12.6073>, <0.3247247, 4.05228, 2.09602> }
        smooth_triangle {<-0.2103738, -0.6157338, -12.5137>, <0.1160958, 4.01525, 2.09622>,
                         <-4.47194, -0.9184005, -12.6073>, <-0.3404661, 4.02634, 2.04743>,
                         <-4.51339, -1.40269, -11.6581>, <-0.3248713, 4.07432, 2.05032> }
        smooth_triangle {<-4.51339, -1.40269, -11.6581>, <-0.3221824, 4.07132, 2.08215>,
                         <-0.2105007, -1.11443, -11.5689>, <0.003960053, 4.06446, 2.10967>,
                         <-0.2103738, -0.6157338, -12.5137>, <0.007870659, 4.02776, 2.10862> }
        smooth_triangle {<4.00449, -0.431069, -13.555>, <0.3482873, 3.9754, 2.11476>,
                         <-0.2102469, -0.1139896, -13.4569>, <0.1207758, 3.954, 2.11779>,
                         <-0.2103738, -0.6157338, -12.5137>, <0.1160958, 4.01525, 2.09622> }
        smooth_triangle {<-0.2103738, -0.6157338, -12.5137>, <0.1701858, 4.02079, 2.08758>,
                         <4.04587, -0.9184005, -12.6073>, <0.3325505, 4.02931, 2.09215>,
                         <4.00449, -0.431069, -13.555>, <0.3403717, 4.0064, 2.08822> }
        smooth_triangle {<-0.2102469, -0.1139896, -13.4569>, <0.1207758, 3.954, 2.11779>,
                         <-4.43057, -0.431069, -13.555>, <-0.3553073, 3.95743, 2.08393>,
                         <-4.47194, -0.9184005, -12.6073>, <-0.3404661, 4.02634, 2.04743> }
        smooth_triangle {<-4.47194, -0.9184005, -12.6073>, <-0.3377961, 4.02409, 2.07768>,
                         <-0.2103738, -0.6157338, -12.5137>, <0.003957805, 4.01633, 2.10671>,
                         <-0.2102469, -0.1139896, -13.4569>, <0.007467814, 3.9704, 2.12289> }
        smooth_triangle {<3.96367, 0.08041543, -14.4898>, <0.3623273, 3.88304, 2.19503>,
                         <-0.2101201, 0.4119075, -14.3873>, <0.1246523, 3.84478, 2.22559>,
                         <-0.2102469, -0.1139896, -13.4569>, <0.1207758, 3.954, 2.11779> }
        smooth_triangle {<-0.2102469, -0.1139896, -13.4569>, <0.1772253, 3.95148, 2.12405>,
                         <4.00449, -0.431069, -13.555>, <0.3474306, 3.95967, 2.1288>,
                         <3.96367, 0.08041543, -14.4898>, <0.3544506, 3.91349, 2.16893> }
        smooth_triangle {<-0.2101201, 0.4119075, -14.3873>, <0.1246523, 3.84478, 2.22559>,
                         <-4.38975, 0.08041543, -14.4898>, <-0.3681422, 3.83976, 2.20589>,
                         <-4.43057, -0.431069, -13.555>, <-0.3553073, 3.95743, 2.08393> }
        smooth_triangle {<-4.43057, -0.431069, -13.555>, <-0.3523962, 3.94707, 2.12909>,
                         <-0.2102469, -0.1139896, -13.4569>, <0.003938336, 3.94708, 2.14319>,
                         <-0.2101201, 0.4119075, -14.3873>, <0.006845761, 3.86517, 2.22405> }
        smooth_triangle {<3.92398, 0.6362578, -15.399>, <0.373957, 3.73999, 2.35746>,
                         <-0.2099932, 0.9821626, -15.292>, <0.1287099, 3.71225, 2.36705>,
                         <-0.2101201, 0.4119075, -14.3873>, <0.1246523, 3.84478, 2.22559> }
        smooth_triangle {<-0.2101201, 0.4119075, -14.3873>, <0.1830831, 3.83326, 2.2459>,
                         <3.96367, 0.08041543, -14.4898>, <0.3603514, 3.84087, 2.25092>,
                         <3.92398, 0.6362578, -15.399>, <0.3661663, 3.76935, 2.33214> }
        smooth_triangle {<-0.2099932, 0.9821626, -15.292>, <0.1287099, 3.71225, 2.36705>,
                         <-4.35006, 0.6362578, -15.399>, <-0.3800434, 3.7125, 2.33716>,
                         <-4.38975, 0.08041543, -14.4898>, <-0.3681422, 3.83976, 2.20589> }
        smooth_triangle {<-4.38975, 0.08041543, -14.4898>, <-0.3648866, 3.82028, 2.26506>,
                         <-0.2101201, 0.4119075, -14.3873>, <0.00389538, 3.82891, 2.26505>,
                         <-0.2099932, 0.9821626, -15.292>, <0.006938571, 3.72952, 2.37114> }
        smooth_triangle {<3.8851, 1.22164, -16.2895>, <0.3861298, 3.62853, 2.45619>,
                         <-0.2098663, 1.58196, -16.1781>, <-5.66789e-009, 3.64266, 2.42151>,
                         <-0.2099932, 0.9821626, -15.292>, <0.1287099, 3.71225, 2.36705> }
        smooth_triangle {<-0.2099932, 0.9821626, -15.292>, <0.1892036, 3.70561, 2.37692>,
                         <3.92398, 0.6362578, -15.399>, <0.3723208, 3.71285, 2.38199>,
                         <3.8851, 1.22164, -16.2895>, <0.3784072, 3.65712, 2.43135> }
        smooth_triangle {<-0.2098663, 1.58196, -16.1781>, <-5.66789e-009, 3.64266, 2.42151>,
                         <-4.31117, 1.22164, -16.2895>, <-0.3861298, 3.65679, 2.38683>,
                         <-4.35006, 0.6362578, -15.399>, <-0.3800434, 3.7125, 2.33716> }
        smooth_triangle {<-4.35006, 0.6362578, -15.399>, <-0.3769238, 3.69784, 2.38583>,
                         <-0.2099932, 0.9821626, -15.292>, <0.003861292, 3.70132, 2.39608>,
                         <-0.2098663, 1.58196, -16.1781>, <-0.1235615, 3.65128, 2.44206> }
    }
    union { // Poly_Mesh
        smooth_triangle {<4.96059, 4.97002, 8.34328>, <-0.8148987, 2.65066e-015, 0.03557925>,
                         <4.99086, 4.54164, 9.03652>, <-0.9182277, 2.498e-016, 0.04009068>,
                         <5.07055, 4.58926, 10.8617>, <-0.8148987, 2.65066e-015, 0.03557925> }
        smooth_triangle {<5.07055, 4.58926, 10.8617>, <-0.7423259, 1.52656e-015, 0.03241065>,
                         <5.038, 4.96789, 10.1164>, <-0.6697532, 4.02456e-016, 0.02924205>,
                         <4.96059, 4.97002, 8.34328>, <-0.7423259, 1.52656e-015, 0.03241065> }
        smooth_triangle {<4.99086, 4.54164, 9.03652>, <-0.9182277, 2.498e-016, 0.04009068>,
                         <5.01821, 4.00822, 9.66297>, <-1.18989, 4.55654e-016, 0.05195192>,
                         <5.09997, 4.0981, 11.5355>, <-1.05516, 0, 0.04606913> }
        smooth_triangle {<5.09997, 4.0981, 11.5355>, <-0.9918628, 2.33841e-015, 0.04330567>,
                         <5.07055, 4.58926, 10.8617>, <-0.871734, 3.66374e-015, 0.03806073>,
                         <4.99086, 4.54164, 9.03652>, <-0.920813, 1.35655e-015, 0.04020357> }
        smooth_triangle {<5.01821, 4.00822, 9.66297>, <-1.18989, 4.55654e-016, 0.05195192>,
                         <5.03756, 3.29847, 10.1061>, <-1.48453, 2.15106e-016, 0.06481597>,
                         <5.12081, 3.41799, 12.0129>, <-1.40635, 7.21645e-016, 0.06140266> }
        smooth_triangle {<5.12081, 3.41799, 12.0129>, <-1.3614, 1.10328e-015, 0.05943992>,
                         <5.09997, 4.0981, 11.5355>, <-1.1858, 7.42462e-016, 0.05177316>,
                         <5.01821, 4.00822, 9.66297>, <-1.22153, 7.12971e-016, 0.05333324> }
        smooth_triangle {<5.03756, 3.29847, 10.1061>, <-1.48453, 2.15106e-016, 0.06481597>,
                         <5.04755, 2.47965, 10.335>, <-1.63355, 7.83517e-016, 0.07132237>,
                         <5.13163, 2.62104, 12.2608>, <-1.60922, -3.1572e-015, 0.07026024> }
        smooth_triangle {<5.13163, 2.62104, 12.2608>, <-1.57925, -2.92474e-015, 0.06895144>,
                         <5.12081, 3.41799, 12.0129>, <-1.47781, -9.85323e-016, 0.06452265>,
                         <5.03756, 3.29847, 10.1061>, <-1.50072, -5.11743e-016, 0.06552264> }
        smooth_triangle {<5.04755, 2.47965, 10.335>, <-1.63355, 7.83517e-016, 0.07132237>,
                         <5.05147, 1.62981, 10.4247>, <-1.66697, 7.57347e-016, 0.07278165>,
                         <5.13594, 1.79085, 12.3595>, <-1.65874, 4.35242e-015, 0.07242196> }
        smooth_triangle {<5.13594, 1.79085, 12.3595>, <-1.63574, 1.77549e-015, 0.07141794>,
                         <5.13163, 2.62104, 12.2608>, <-1.61098, -1.97932e-015, 0.07033708>,
                         <5.04755, 2.47965, 10.335>, <-1.62835, 3.87277e-016, 0.07109526> }
        smooth_triangle {<5.05147, 1.62981, 10.4247>, <-1.66697, 7.57347e-016, 0.07278165>,
                         <5.05147, 0.7741244, 10.4249>, <-1.66097, -2.07367e-015, 0.07251934>,
                         <5.13606, 0.9543919, 12.3623>, <-1.65786, -2.65891e-015, 0.07238381> }
        smooth_triangle {<5.13606, 0.9543919, 12.3623>, <-1.63835, -2.80823e-015, 0.07153173>,
                         <5.13594, 1.79085, 12.3595>, <-1.63878, 6.9744e-016, 0.07155081>,
                         <5.05147, 1.62981, 10.4247>, <-1.65494, -1.71375e-016, 0.07225615> }
        smooth_triangle {<5.05147, 0.7741244, 10.4249>, <-1.66097, -2.07367e-015, 0.07251934>,
                         <5.04844, -0.07881703, 10.3554>, <-1.63727, -1.0018e-015, 0.07148471>,
                         <5.13293, 0.1208767, 12.2905>, <-1.63663, -2.28376e-015, 0.07145685> }
        smooth_triangle {<5.13293, 0.1208767, 12.2905>, <-1.61928, -9.15067e-017, 0.07069924>,
                         <5.13606, 0.9543919, 12.3623>, <-1.62989, -2.7908e-016, 0.07116272>,
                         <5.05147, 0.7741244, 10.4249>, <-1.64621, -1.03006e-015, 0.07187491> }
        smooth_triangle {<5.04844, -0.07881703, 10.3554>, <-1.63727, -1.0018e-015, 0.07148471>,
                         <5.04277, -0.9242312, 10.2254>, <-1.6001, 1.66938e-015, 0.06986182>,
                         <5.12696, -0.7045735, 12.1538>, <-1.60176, 2.34014e-015, 0.06993426> }
        smooth_triangle {<5.12696, -0.7045735, 12.1538>, <-1.58589, 2.10335e-015, 0.06924159>,
                         <5.13293, 0.1208767, 12.2905>, <-1.60333, -2.086e-016, 0.07000288>,
                         <5.04844, -0.07881703, 10.3554>, <-1.62046, -2.84711e-016, 0.07075076> }
        smooth_triangle {<5.04277, -0.9242312, 10.2254>, <-1.6001, 1.66938e-015, 0.06986182>,
                         <5.03454, -1.75759, 10.037>, <-1.54447, -7.26271e-016, 0.06743292>,
                         <5.11826, -1.51711, 11.9545>, <-1.5527, -7.02563e-016, 0.06779213> }
        smooth_triangle {<5.11826, -1.51711, 11.9545>, <-1.53791, 9.67108e-016, 0.06714649>,
                         <5.12696, -0.7045735, 12.1538>, <-1.56244, 2.48846e-015, 0.06821755>,
                         <5.04277, -0.9242312, 10.2254>, <-1.58085, 1.91123e-015, 0.06902158> }
        smooth_triangle {<5.03454, -1.75759, 10.037>, <-1.54447, -7.26271e-016, 0.06743292>,
                         <5.02318, -2.56938, 9.77674>, <-1.45345, 1.45717e-016, 0.06345883>,
                         <5.1062, -2.30653, 11.6783>, <-1.47527, -1.66533e-016, 0.06441182> }
        smooth_triangle {<5.1062, -2.30653, 11.6783>, <-1.4613, -7.91034e-016, 0.06380186>,
                         <5.11826, -1.51711, 11.9545>, <-1.50001, -1.05905e-015, 0.06549201>,
                         <5.03454, -1.75759, 10.037>, <-1.52018, -8.98587e-016, 0.06637266> }
        smooth_triangle {<5.02318, -2.56938, 9.77674>, <-1.45345, 1.45717e-016, 0.06345883>,
                         <5.00765, -3.33988, 9.42113>, <-1.29698, -6.4763e-016, 0.05662752>,
                         <5.08968, -3.05172, 11.2999>, <-1.34515, -5.48173e-016, 0.05873046> }
        smooth_triangle {<5.08968, -3.05172, 11.2999>, <-1.33137, -1.31492e-015, 0.05812868>,
                         <5.1062, -2.30653, 11.6783>, <-1.39643, -1.1241e-015, 0.06096936>,
                         <5.02318, -2.56938, 9.77674>, <-1.41948, -4.11129e-016, 0.06197585> }
        smooth_triangle {<5.00765, -3.33988, 9.42113>, <-1.29698, -6.4763e-016, 0.05662752>,
                         <4.98658, -4.02883, 8.93858>, <-1.06394, -7.03141e-016, 0.04645279>,
                         <5.06722, -3.70953, 10.7855>, <-1.11836, 3.1572e-016, 0.04882878> }
        smooth_triangle {<5.06722, -3.70953, 10.7855>, <-1.10301, 5.44703e-016, 0.04815834>,
                         <5.08968, -3.05172, 11.2999>, <-1.2164, 1.12757e-016, 0.05310918>,
                         <5.00765, -3.33988, 9.42113>, <-1.24465, -2.92301e-016, 0.05434262> }
        smooth_triangle {<4.98658, -4.02883, 8.93858>, <-1.06394, -7.03141e-016, 0.04645279>,
                         <4.96073, -4.61403, 8.34655>, <-0.8247562, 8.62736e-016, 0.03600963>,
                         <5.03964, -4.25618, 10.1538>, <-0.8457508, 9.78384e-016, 0.03692628> }
        smooth_triangle {<5.03964, -4.25618, 10.1538>, <-0.8268371, 3.43475e-016, 0.03610049>,
                         <5.06722, -3.70953, 10.7855>, <-0.9631432, 1.21431e-017, 0.04205174>,
                         <4.98658, -4.02883, 8.93858>, <-0.9999387, -6.00214e-016, 0.04365827> }
        smooth_triangle {<4.96073, -4.61403, 8.34655>, <-0.8247562, 8.62736e-016, 0.03600963>,
                         <4.93242, -5.12694, 7.69821>, <-0.6586088, 4.86879e-016, 0.02875548>,
                         <5.00942, -4.72538, 9.46177>, <-0.6441985, 2.14412e-015, 0.02812631> }
        smooth_triangle {<5.00942, -4.72538, 9.46177>, <-0.622256, 1.16573e-015, 0.02716828>,
                         <5.03964, -4.25618, 10.1538>, <-0.7230322, 5.82867e-016, 0.03156827>,
                         <4.96073, -4.61403, 8.34655>, <-0.7686455, 6.93889e-016, 0.03355979> }
        smooth_triangle {<4.93242, -5.12694, 7.69821>, <-0.6586088, 4.86879e-016, 0.02875548>,
                         <4.90323, -5.6086, 7.02955>, <-0.6138568, -2.03657e-015, 0.02680157>,
                         <4.97826, -5.16109, 8.74796>, <-0.5284523, -1.68962e-015, 0.02307272> }
        smooth_triangle {<4.97826, -5.16109, 8.74796>, <-0.505107, -5.70724e-016, 0.02205345>,
                         <5.00942, -4.72538, 9.46177>, <-0.5629801, 1.34615e-015, 0.02458024>,
                         <4.93242, -5.12694, 7.69821>, <-0.6143971, 5.02202e-016, 0.02682515> }
        smooth_triangle {<4.88317, 4.9727, 6.5702>, <-0.8846278, -1.90126e-015, 0.03862368>,
                         <4.91109, 4.50226, 7.20962>, <-0.9710657, -1.18655e-015, 0.04239764>,
                         <4.99086, 4.54164, 9.03652>, <-0.9182277, 2.498e-016, 0.04009068> }
        smooth_triangle {<4.99086, 4.54164, 9.03652>, <-0.8780949, 9.19403e-016, 0.03833845>,
                         <4.96059, 4.97002, 8.34328>, <-0.7862977, 2.78944e-015, 0.0343305>,
                         <4.88317, 4.9727, 6.5702>, <-0.8211622, 5.13478e-016, 0.03585271> }
        smooth_triangle {<4.91109, 4.50226, 7.20962>, <-0.9710657, -1.18655e-015, 0.04239764>,
                         <4.9363, 3.93429, 7.78703>, <-1.22315, 2.87733e-015, 0.0534037>,
                         <5.01821, 4.00822, 9.66297>, <-1.18989, 4.55654e-016, 0.05195192> }
        smooth_triangle {<5.01821, 4.00822, 9.66297>, <-1.14221, 4.11129e-016, 0.04987005>,
                         <4.99086, 4.54164, 9.03652>, <-0.9384617, 2.56739e-016, 0.04097412>,
                         <4.91109, 4.50226, 7.20962>, <-0.9780902, -8.20524e-016, 0.04270434> }
        smooth_triangle {<4.9363, 3.93429, 7.78703>, <-1.22315, 2.87733e-015, 0.0534037>,
                         <4.95408, 3.20257, 8.19421>, <-1.50057, 2.80447e-015, 0.06551633>,
                         <5.03756, 3.29847, 10.1061>, <-1.48453, 2.15106e-016, 0.06481597> }
        smooth_triangle {<5.03756, 3.29847, 10.1061>, <-1.45445, 4.42354e-016, 0.06350282>,
                         <5.01821, 4.00822, 9.66297>, <-1.23348, 6.22766e-016, 0.05385478>,
                         <4.9363, 3.93429, 7.78703>, <-1.25842, 2.43902e-015, 0.05494362> }
        smooth_triangle {<4.95408, 3.20257, 8.19421>, <-1.50057, 2.80447e-015, 0.06551633>,
                         <4.96317, 2.36958, 8.40244>, <-1.64571, 7.90745e-016, 0.07185307>,
                         <5.04755, 2.47965, 10.335>, <-1.63355, 7.83517e-016, 0.07132237> }
        smooth_triangle {<5.04755, 2.47965, 10.335>, <-1.62202, -8.19657e-017, 0.07081894>,
                         <5.03756, 3.29847, 10.1061>, <-1.51025, -5.08274e-016, 0.06593914>,
                         <4.95408, 3.20257, 8.19421>, <-1.52229, 1.43375e-015, 0.06646441> }
        smooth_triangle {<4.96317, 2.36958, 8.40244>, <-1.64571, 7.90745e-016, 0.07185307>,
                         <4.96662, 1.50778, 8.48148>, <-1.68323, -4.6861e-016, 0.07349119>,
                         <5.05147, 1.62981, 10.4247>, <-1.66697, 7.57347e-016, 0.07278165> }
        smooth_triangle {<5.05147, 1.62981, 10.4247>, <-1.66329, 1.683e-015, 0.07262066>,
                         <5.04755, 2.47965, 10.335>, <-1.63822, 1.70263e-015, 0.0715262>,
                         <4.96317, 2.36958, 8.40244>, <-1.64734, 1.70805e-015, 0.07192423> }
        smooth_triangle {<4.96662, 1.50778, 8.48148>, <-1.68323, -4.6861e-016, 0.07349119>,
                         <4.96644, 0.6405563, 8.47733>, <-1.68363, -1.25842e-015, 0.07350869>,
                         <5.05147, 0.7741244, 10.4249>, <-1.66097, -2.07367e-015, 0.07251934> }
        smooth_triangle {<5.05147, 0.7741244, 10.4249>, <-1.66143, -2.222e-015, 0.07253958>,
                         <5.05147, 1.62981, 10.4247>, <-1.66594, -9.8742e-017, 0.07273631>,
                         <4.96662, 1.50778, 8.48148>, <-1.67812, -1.01821e-015, 0.07326847> }
        smooth_triangle {<4.96644, 0.6405563, 8.47733>, <-1.68363, -1.25842e-015, 0.07350869>,
                         <4.96344, -0.2241199, 8.4085>, <-1.66766, -1.20621e-015, 0.07281149>,
                         <5.04844, -0.07881703, 10.3554>, <-1.63727, -1.0018e-015, 0.07148471> }
        smooth_triangle {<5.04844, -0.07881703, 10.3554>, <-1.64092, -1.36523e-015, 0.07164397>,
                         <5.05147, 0.7741244, 10.4249>, <-1.65869, -2.16913e-015, 0.07241995>,
                         <4.96644, 0.6405563, 8.47733>, <-1.67568, -1.55769e-015, 0.07316196> }
        smooth_triangle {<4.96344, -0.2241199, 8.4085>, <-1.66766, -1.20621e-015, 0.07281149>,
                         <4.95798, -1.08181, 8.28353>, <-1.63953, 1.09288e-015, 0.07158346>,
                         <5.04277, -0.9242312, 10.2254>, <-1.6001, 1.66938e-015, 0.06986182> }
        smooth_triangle {<5.04277, -0.9242312, 10.2254>, <-1.60683, 1.7885e-015, 0.07015584>,
                         <5.04844, -0.07881703, 10.3554>, <-1.63471, -2.14889e-016, 0.07137301>,
                         <4.96344, -0.2241199, 8.4085>, <-1.6575, -3.68195e-016, 0.0723681> }
        smooth_triangle {<4.95798, -1.08181, 8.28353>, <-1.63953, 1.09288e-015, 0.07158346>,
                         <4.95015, -1.9283, 8.10423>, <-1.59517, -3.15141e-016, 0.0696466>,
                         <5.03454, -1.75759, 10.037>, <-1.54447, -7.26271e-016, 0.06743292> }
        smooth_triangle {<5.03454, -1.75759, 10.037>, <-1.5555, -9.24608e-016, 0.06791464>,
                         <5.04277, -0.9242312, 10.2254>, <-1.59722, 8.72132e-016, 0.06973631>,
                         <4.95798, -1.08181, 8.28353>, <-1.6268, 4.39752e-016, 0.07102754> }
        smooth_triangle {<4.95015, -1.9283, 8.10423>, <-1.59517, -3.15141e-016, 0.0696466>,
                         <4.93941, -2.75476, 7.85831>, <-1.52005, 1.10328e-015, 0.06636678>,
                         <5.02318, -2.56938, 9.77674>, <-1.45345, 1.45717e-016, 0.06345883> }
        smooth_triangle {<5.02318, -2.56938, 9.77674>, <-1.47122, -1.69136e-016, 0.06423477>,
                         <5.03454, -1.75759, 10.037>, <-1.53948, -8.23126e-016, 0.06721534>,
                         <4.95015, -1.9283, 8.10423>, <-1.57751, -5.14779e-016, 0.0688756> }
        smooth_triangle {<4.93941, -2.75476, 7.85831>, <-1.52005, 1.10328e-015, 0.06636678>,
                         <4.92481, -3.54289, 7.5238>, <-1.38734, -3.24393e-015, 0.06057267>,
                         <5.00765, -3.33988, 9.42113>, <-1.29698, -6.4763e-016, 0.05662752> }
        smooth_triangle {<5.00765, -3.33988, 9.42113>, <-1.3258, -9.74047e-016, 0.05788563>,
                         <5.02318, -2.56938, 9.77674>, <-1.44315, -3.79037e-016, 0.06300912>,
                         <4.93941, -2.75476, 7.85831>, <-1.4931, 3.39138e-016, 0.06519008> }
        smooth_triangle {<4.92481, -3.54289, 7.5238>, <-1.38734, -3.24393e-015, 0.06057267>,
                         <4.90506, -4.25529, 7.07142>, <-1.1863, -1.36928e-015, 0.05179517>,
                         <4.98658, -4.02883, 8.93858>, <-1.06394, -7.03141e-016, 0.04645279> }
        smooth_triangle {<4.98658, -4.02883, 8.93858>, <-1.10026, -9.72313e-016, 0.04803834>,
                         <5.00765, -3.33988, 9.42113>, <-1.27504, -9.30679e-016, 0.05566939>,
                         <4.92481, -3.54289, 7.5238>, <-1.34281, -2.87791e-015, 0.05862825> }
        smooth_triangle {<4.90506, -4.25529, 7.07142>, <-1.1863, -1.36928e-015, 0.05179517>,
                         <4.88087, -4.87135, 6.51738>, <-0.9777212, -4.04769e-017, 0.04268823>,
                         <4.96073, -4.61403, 8.34655>, <-0.8247562, 8.62736e-016, 0.03600963> }
        smooth_triangle {<4.96073, -4.61403, 8.34655>, <-0.8582169, 5.96745e-016, 0.03747056>,
                         <4.98658, -4.02883, 8.93858>, <-1.03761, -5.77663e-016, 0.04530292>,
                         <4.90506, -4.25529, 7.07142>, <-1.12938, -1.07726e-015, 0.04930971> }
        smooth_triangle {<4.88087, -4.87135, 6.51738>, <-0.9777212, -4.04769e-017, 0.04268823>,
                         <4.8544, -5.42028, 5.91105>, <-0.832361, -2.38235e-016, 0.03634166>,
                         <4.93242, -5.12694, 7.69821>, <-0.6586088, 4.86879e-016, 0.02875548> }
        smooth_triangle {<4.93242, -5.12694, 7.69821>, <-0.6868011, 9.35883e-016, 0.02998638>,
                         <4.96073, -4.61403, 8.34655>, <-0.8114116, 1.21778e-015, 0.03542699>,
                         <4.88087, -4.87135, 6.51738>, <-0.9261354, 5.40366e-016, 0.04043594> }
        smooth_triangle {<4.8544, -5.42028, 5.91105>, <-0.832361, -2.38235e-016, 0.03634166>,
                         <4.8271, -5.9402, 5.28586>, <-0.8044165, -1.71564e-015, 0.03512158>,
                         <4.90323, -5.6086, 7.02955>, <-0.6138568, -2.03657e-015, 0.02680157> }
        smooth_triangle {<4.90323, -5.6086, 7.02955>, <-0.6307908, -2.18575e-015, 0.02754092>,
                         <4.93242, -5.12694, 7.69821>, <-0.6601213, -2.55872e-016, 0.02882152>,
                         <4.8544, -5.42028, 5.91105>, <-0.7904354, -7.99708e-016, 0.03451116> }
        smooth_triangle {<4.80576, 4.9764, 4.79712>, <-0.9203939, -2.30371e-015, 0.04018527>,
                         <4.83125, 4.48016, 5.38086>, <-0.9911694, 1.73935e-015, 0.04327539>,
                         <4.91109, 4.50226, 7.20962>, <-0.9710657, -1.18655e-015, 0.04239764> }
        smooth_triangle {<4.91109, 4.50226, 7.20962>, <-0.936241, -1.20563e-015, 0.04087716>,
                         <4.88317, 4.9727, 6.5702>, <-0.8581973, -1.58207e-015, 0.0374697>,
                         <4.80576, 4.9764, 4.79712>, <-0.8760804, -1.7833e-015, 0.03825049> }
        smooth_triangle {<4.83125, 4.48016, 5.38086>, <-0.9911694, 1.73935e-015, 0.04327539>,
                         <4.85423, 3.8939, 5.90736>, <-1.22206, 2.85882e-015, 0.05335635>,
                         <4.9363, 3.93429, 7.78703>, <-1.22315, 2.87733e-015, 0.0534037> }
        smooth_triangle {<4.9363, 3.93429, 7.78703>, <-1.18022, 2.36963e-015, 0.05152957>,
                         <4.91109, 4.50226, 7.20962>, <-0.991161, -6.78277e-016, 0.04327502>,
                         <4.83125, 4.48016, 5.38086>, <-1.00624, 1.51615e-015, 0.04393333> }
        smooth_triangle {<4.85423, 3.8939, 5.90736>, <-1.22206, 2.85882e-015, 0.05335635>,
                         <4.87036, 3.15648, 6.27672>, <-1.48216, 2.10248e-015, 0.06471251>,
                         <4.95408, 3.20257, 8.19421>, <-1.50057, 2.80447e-015, 0.06551633> }
        smooth_triangle {<4.95408, 3.20257, 8.19421>, <-1.47339, 2.98633e-015, 0.06432949>,
                         <4.9363, 3.93429, 7.78703>, <-1.26532, 3.04097e-015, 0.05524502>,
                         <4.85423, 3.8939, 5.90736>, <-1.26451, 3.02709e-015, 0.0552095> }
        smooth_triangle {<4.87036, 3.15648, 6.27672>, <-1.48216, 2.10248e-015, 0.06471251>,
                         <4.87847, 2.32559, 6.46244>, <-1.62406, -2.65991e-016, 0.07090809>,
                         <4.96317, 2.36958, 8.40244>, <-1.64571, 7.90745e-016, 0.07185307> }
        smooth_triangle {<4.96317, 2.36958, 8.40244>, <-1.63599, 8.6541e-016, 0.07142882>,
                         <4.95408, 3.20257, 8.19421>, <-1.52714, 2.3757e-015, 0.06667626>,
                         <4.87036, 3.15648, 6.27672>, <-1.51333, 1.84922e-015, 0.06607339> }
        smooth_triangle {<4.87847, 2.32559, 6.46244>, <-1.62406, -2.65991e-016, 0.07090809>,
                         <4.88137, 1.4681, 6.5289>, <-1.66658, -1.68196e-016, 0.07276432>,
                         <4.96662, 1.50778, 8.48148>, <-1.68323, -4.6861e-016, 0.07349119> }
        smooth_triangle {<4.96662, 1.50778, 8.48148>, <-1.68126, -1.78853e-016, 0.0734054>,
                         <4.96317, 2.36958, 8.40244>, <-1.65312, 7.65664e-016, 0.07217682>,
                         <4.87847, 2.32559, 6.46244>, <-1.63689, -2.68882e-017, 0.07146808> }
        smooth_triangle {<4.88137, 1.4681, 6.5289>, <-1.66658, -1.68196e-016, 0.07276432>,
                         <4.88092, 0.6056067, 6.51858>, <-1.67449, -1.15583e-015, 0.07310984>,
                         <4.96644, 0.6405563, 8.47733>, <-1.68363, -1.25842e-015, 0.07350869> }
        smooth_triangle {<4.96644, 0.6405563, 8.47733>, <-1.68601, -1.26425e-015, 0.07361272>,
                         <4.96662, 1.50778, 8.48148>, <-1.68571, -6.71894e-016, 0.07359959>,
                         <4.88137, 1.4681, 6.5289>, <-1.67322, -4.46583e-016, 0.07305444> }
        smooth_triangle {<4.88092, 0.6056067, 6.51858>, <-1.67449, -1.15583e-015, 0.07310984>,
                         <4.87786, -0.2545371, 6.44855>, <-1.66763, -7.89299e-016, 0.07281045>,
                         <4.96344, -0.2241199, 8.4085>, <-1.66766, -1.20621e-015, 0.07281149> }
        smooth_triangle {<4.96344, -0.2241199, 8.4085>, <-1.67356, -1.69699e-015, 0.07306934>,
                         <4.96644, 0.6405563, 8.47733>, <-1.68554, -1.73615e-015, 0.07359224>,
                         <4.88092, 0.6056067, 6.51858>, <-1.67869, -1.65921e-015, 0.0732931> }
        smooth_triangle {<4.87786, -0.2545371, 6.44855>, <-1.66763, -7.89299e-016, 0.07281045>,
                         <4.87254, -1.10823, 6.3267>, <-1.65031, -7.02563e-016, 0.07205406>,
                         <4.95798, -1.08181, 8.28353>, <-1.63953, 1.09288e-015, 0.07158346> }
        smooth_triangle {<4.95798, -1.08181, 8.28353>, <-1.64895, 1.6636e-015, 0.07199488>,
                         <4.96344, -0.2241199, 8.4085>, <-1.67005, -6.07153e-017, 0.0729159>,
                         <4.87786, -0.2545371, 6.44855>, <-1.67003, 2.51969e-016, 0.07291512> }
        smooth_triangle {<4.87254, -1.10823, 6.3267>, <-1.65031, -7.02563e-016, 0.07205406>,
                         <4.86503, -1.95159, 6.1547>, <-1.61971, 2.40606e-015, 0.07071808>,
                         <4.95015, -1.9283, 8.10423>, <-1.59517, -3.15141e-016, 0.0696466> }
        smooth_triangle {<4.95015, -1.9283, 8.10423>, <-1.6093, -5.1955e-016, 0.07026377>,
                         <4.95798, -1.08181, 8.28353>, <-1.64258, 5.36463e-016, 0.07171641>,
                         <4.87254, -1.10823, 6.3267>, <-1.65066, -8.10116e-016, 0.07206936> }
        smooth_triangle {<4.86503, -1.95159, 6.1547>, <-1.61971, 2.40606e-015, 0.07071808>,
                         <4.85484, -2.77645, 5.92119>, <-1.56425, -6.16405e-016, 0.06829672>,
                         <4.93941, -2.75476, 7.85831>, <-1.52005, 1.10328e-015, 0.06636678> }
        smooth_triangle {<4.93941, -2.75476, 7.85831>, <-1.54141, 1.25854e-015, 0.06729931>,
                         <4.95015, -1.9283, 8.10423>, <-1.59775, 1.94723e-016, 0.06975917>,
                         <4.86503, -1.95159, 6.1547>, <-1.61615, 2.23562e-015, 0.07056278> }
        smooth_triangle {<4.85484, -2.77645, 5.92119>, <-1.56425, -6.16405e-016, 0.06829672>,
                         <4.84107, -3.56594, 5.60592>, <-1.46096, -1.75438e-015, 0.06378684>,
                         <4.92481, -3.54289, 7.5238>, <-1.38734, -3.24393e-015, 0.06057267> }
        smooth_triangle {<4.92481, -3.54289, 7.5238>, <-1.42037, -2.77642e-015, 0.06201456>,
                         <4.93941, -2.75476, 7.85831>, <-1.5199, 4.83988e-016, 0.06636014>,
                         <4.85484, -2.77645, 5.92119>, <-1.55305, -8.05779e-016, 0.06780759> }
        smooth_triangle {<4.84107, -3.56594, 5.60592>, <-1.46096, -1.75438e-015, 0.06378684>,
                         <4.82256, -4.28552, 5.18184>, <-1.29872, 4.49872e-016, 0.05670334>,
                         <4.90506, -4.25529, 7.07142>, <-1.1863, -1.36928e-015, 0.05179517> }
        smooth_triangle {<4.90506, -4.25529, 7.07142>, <-1.22869, -1.68095e-015, 0.05364594>,
                         <4.92481, -3.54289, 7.5238>, <-1.37947, -3.08694e-015, 0.06022907>,
                         <4.84107, -3.56594, 5.60592>, <-1.43468, -1.96978e-015, 0.06263969> }
        smooth_triangle {<4.82256, -4.28552, 5.18184>, <-1.29872, 4.49872e-016, 0.05670334>,
                         <4.79995, -4.91617, 4.66393>, <-1.12684, -9.21716e-016, 0.04919907>,
                         <4.88087, -4.87135, 6.51738>, <-0.9777212, -4.04769e-017, 0.04268823> }
        smooth_triangle {<4.88087, -4.87135, 6.51738>, <-1.02013, -1.69136e-016, 0.04453969>,
                         <4.90506, -4.25529, 7.07142>, <-1.17656, -1.16573e-015, 0.05136989>,
                         <4.82256, -4.28552, 5.18184>, <-1.26088, 1.98626e-016, 0.05505102> }
        smooth_triangle {<4.79995, -4.91617, 4.66393>, <-1.12684, -9.21716e-016, 0.04919907>,
                         <4.77522, -5.48486, 4.09775>, <-1.00682, 1.19118e-016, 0.0439589>,
                         <4.8544, -5.42028, 5.91105>, <-0.832361, -2.38235e-016, 0.03634166> }
        smooth_triangle {<4.8544, -5.42028, 5.91105>, <-0.8718322, -7.28584e-017, 0.03806502>,
                         <4.88087, -4.87135, 6.51738>, <-0.9808524, 7.54605e-017, 0.04282494>,
                         <4.79995, -4.91617, 4.66393>, <-1.09269, -5.85469e-016, 0.04770807> }
        smooth_triangle {<4.77522, -5.48486, 4.09775>, <-1.00682, 1.19118e-016, 0.0439589>,
                         <4.74974, -6.02676, 3.51415>, <-0.9785294, -5.63785e-016, 0.04272352>,
                         <4.8271, -5.9402, 5.28586>, <-0.8044165, -1.71564e-015, 0.03512158> }
        smooth_triangle {<4.8271, -5.9402, 5.28586>, <-0.8370736, -2.21698e-015, 0.03654742>,
                         <4.8544, -5.42028, 5.91105>, <-0.8498677, -9.83588e-016, 0.03710602>,
                         <4.77522, -5.48486, 4.09775>, <-0.9807153, -7.15573e-016, 0.04281895> }
        smooth_triangle {<4.72835, 4.98169, 3.02405>, <-0.9298655, 2.61596e-015, 0.0405988>,
                         <4.75141, 4.47474, 3.55227>, <-0.9897273, -9.02056e-017, 0.04321243>,
                         <4.83125, 4.48016, 5.38086>, <-0.9911694, 1.73935e-015, 0.04327539> }
        smooth_triangle {<4.83125, 4.48016, 5.38086>, <-0.9625706, 8.11851e-016, 0.04202674>,
                         <4.80576, 4.9764, 4.79712>, <-0.898584, -2.13718e-015, 0.03923302>,
                         <4.72835, 4.98169, 3.02405>, <-0.9033198, 3.22659e-016, 0.03943979> }
        smooth_triangle {<4.75141, 4.47474, 3.55227>, <-0.9897273, -9.02056e-017, 0.04321243>,
                         <4.77218, 3.88526, 4.02802>, <-1.19959, 1.75323e-015, 0.05237514>,
                         <4.85423, 3.8939, 5.90736>, <-1.22206, 2.85882e-015, 0.05335635> }
        smooth_triangle {<4.85423, 3.8939, 5.90736>, <-1.18527, 3.44343e-015, 0.05174997>,
                         <4.83125, 4.48016, 5.38086>, <-1.0121, 2.60382e-015, 0.04418926>,
                         <4.75141, 4.47474, 3.55227>, <-1.01102, 1.23165e-015, 0.04414203> }
        smooth_triangle {<4.77218, 3.88526, 4.02802>, <-1.19959, 1.75323e-015, 0.05237514>,
                         <4.78666, 3.15723, 4.35974>, <-1.44019, 1.50747e-015, 0.06288013>,
                         <4.87036, 3.15648, 6.27672>, <-1.48216, 2.10248e-015, 0.06471251> }
        smooth_triangle {<4.87036, 3.15648, 6.27672>, <-1.45888, 2.42514e-015, 0.06369607>,
                         <4.85423, 3.8939, 5.90736>, <-1.26381, 2.9924e-015, 0.05517895>,
                         <4.77218, 3.88526, 4.02802>, <-1.24695, 2.1632e-015, 0.05444304> }
        smooth_triangle {<4.78666, 3.15723, 4.35974>, <-1.44019, 1.50747e-015, 0.06288013>,
                         <4.7938, 2.34352, 4.5231>, <-1.57522, -1.57657e-015, 0.06877545>,
                         <4.87847, 2.32559, 6.46244>, <-1.62406, -2.65991e-016, 0.07090809> }
        smooth_triangle {<4.87847, 2.32559, 6.46244>, <-1.61621, -1.63064e-016, 0.07056543>,
                         <4.87036, 3.15648, 6.27672>, <-1.50979, 1.61329e-015, 0.06591874>,
                         <4.78666, 3.15723, 4.35974>, <-1.47831, 1.16704e-015, 0.06454446> }
        smooth_triangle {<4.7938, 2.34352, 4.5231>, <-1.57522, -1.57657e-015, 0.06877545>,
                         <4.79616, 1.50542, 4.57716>, <-1.61921, 6.53991e-016, 0.07069637>,
                         <4.88137, 1.4681, 6.5289>, <-1.66658, -1.68196e-016, 0.07276432> }
        smooth_triangle {<4.88137, 1.4681, 6.5289>, <-1.66537, -3.40819e-016, 0.07271177>,
                         <4.87847, 2.32559, 6.46244>, <-1.63349, -4.14165e-016, 0.0713196>,
                         <4.7938, 2.34352, 4.5231>, <-1.59685, -1.3971e-015, 0.06972012> }
        smooth_triangle {<4.79616, 1.50542, 4.57716>, <-1.61921, 6.53991e-016, 0.07069637>,
                         <4.79544, 0.6627317, 4.56083>, <-1.63131, -6.53123e-016, 0.07122456>,
                         <4.88092, 0.6056067, 6.51858>, <-1.67449, -1.15583e-015, 0.07310984> }
        smooth_triangle {<4.88092, 0.6056067, 6.51858>, <-1.67681, -7.18257e-016, 0.07321097>,
                         <4.88137, 1.4681, 6.5289>, <-1.67087, 2.24701e-017, 0.07295183>,
                         <4.79616, 1.50542, 4.57716>, <-1.63535, 6.3911e-016, 0.07140087> }
        smooth_triangle {<4.79544, 0.6627317, 4.56083>, <-1.63131, -6.53123e-016, 0.07122456>,
                         <4.79234, -0.1777996, 4.48976>, <-1.63016, 3.74122e-016, 0.07117416>,
                         <4.87786, -0.2545371, 6.44855>, <-1.66763, -7.89299e-016, 0.07281045> }
        smooth_triangle {<4.87786, -0.2545371, 6.44855>, <-1.67271, -1.51962e-015, 0.07303221>,
                         <4.88092, 0.6056067, 6.51858>, <-1.67786, -1.79452e-015, 0.07325675>,
                         <4.79544, 0.6627317, 4.56083>, <-1.64547, -1.41749e-015, 0.07184279> }
        smooth_triangle {<4.79234, -0.1777996, 4.48976>, <-1.63016, 3.74122e-016, 0.07117416>,
                         <4.78716, -1.01242, 4.37119>, <-1.62002, 2.60209e-017, 0.0707316>,
                         <4.87254, -1.10823, 6.3267>, <-1.65031, -7.02563e-016, 0.07205406> }
        smooth_triangle {<4.87254, -1.10823, 6.3267>, <-1.65812, -2.30718e-016, 0.07239508>,
                         <4.87786, -0.2545371, 6.44855>, <-1.67111, -2.9577e-016, 0.07296237>,
                         <4.79234, -0.1777996, 4.48976>, <-1.64301, 5.76796e-016, 0.07173516> }
        smooth_triangle {<4.78716, -1.01242, 4.37119>, <-1.62002, 2.60209e-017, 0.0707316>,
                         <4.77998, -1.83756, 4.20665>, <-1.59914, 1.02927e-016, 0.06981974>,
                         <4.86503, -1.95159, 6.1547>, <-1.61971, 2.40606e-015, 0.07071808> }
        smooth_triangle {<4.86503, -1.95159, 6.1547>, <-1.6312, 1.69049e-015, 0.0712198>,
                         <4.87254, -1.10823, 6.3267>, <-1.65415, -6.4098e-016, 0.07222178>,
                         <4.78716, -1.01242, 4.37119>, <-1.63143, -9.45424e-017, 0.07122994> }
        smooth_triangle {<4.77998, -1.83756, 4.20665>, <-1.59914, 1.02927e-016, 0.06981974>,
                         <4.77033, -2.64576, 3.98574>, <-1.55837, 6.38956e-016, 0.06803972>,
                         <4.85484, -2.77645, 5.92119>, <-1.56425, -6.16405e-016, 0.06829672> }
        smooth_triangle {<4.85484, -2.77645, 5.92119>, <-1.58156, 5.46438e-016, 0.06905255>,
                         <4.86503, -1.95159, 6.1547>, <-1.62316, 2.81329e-015, 0.07086857>,
                         <4.77998, -1.83756, 4.20665>, <-1.60773, 1.08594e-015, 0.07019482> }
        smooth_triangle {<4.77033, -2.64576, 3.98574>, <-1.55837, 6.38956e-016, 0.06803972>,
                         <4.75742, -3.42152, 3.68987>, <-1.47823, -7.9219e-016, 0.064541>,
                         <4.84107, -3.56594, 5.60592>, <-1.46096, -1.75438e-015, 0.06378684> }
        smooth_triangle {<4.84107, -3.56594, 5.60592>, <-1.48802, -2.35836e-015, 0.06496852>,
                         <4.85484, -2.77645, 5.92119>, <-1.56549, -1.50487e-015, 0.06835093>,
                         <4.77033, -2.64576, 3.98574>, <-1.56108, -5.63351e-016, 0.06815819> }
        smooth_triangle {<4.75742, -3.42152, 3.68987>, <-1.47823, -7.9219e-016, 0.064541>,
                         <4.74014, -4.1332, 3.29426>, <-1.34748, -3.1225e-016, 0.05883234>,
                         <4.82256, -4.28552, 5.18184>, <-1.29872, 4.49872e-016, 0.05670334> }
        smooth_triangle {<4.82256, -4.28552, 5.18184>, <-1.33404, 3.9465e-016, 0.0582454>,
                         <4.84107, -3.56594, 5.60592>, <-1.45572, -1.25854e-015, 0.06355803>,
                         <4.75742, -3.42152, 3.68987>, <-1.46867, -5.36897e-016, 0.06412365> }
        smooth_triangle {<4.74014, -4.1332, 3.29426>, <-1.34748, -3.1225e-016, 0.05883234>,
                         <4.71912, -4.76336, 2.81264>, <-1.20578, -8.3498e-016, 0.05264566>,
                         <4.79995, -4.91617, 4.66393>, <-1.12684, -9.21716e-016, 0.04919907> }
        smooth_triangle {<4.79995, -4.91617, 4.66393>, <-1.16246, -8.89046e-016, 0.050754>,
                         <4.82256, -4.28552, 5.18184>, <-1.29136, 1.39645e-016, 0.0563822>,
                         <4.74014, -4.1332, 3.29426>, <-1.32794, -4.31946e-016, 0.05797896> }
        smooth_triangle {<4.71912, -4.76336, 2.81264>, <-1.20578, -8.3498e-016, 0.05264566>,
                         <4.69616, -5.33673, 2.28676>, <-1.10632, 2.24358e-016, 0.04830312>,
                         <4.77522, -5.48486, 4.09775>, <-1.00682, 1.19118e-016, 0.0439589> }
        smooth_triangle {<4.77522, -5.48486, 4.09775>, <-1.03995, 4.50161e-016, 0.04540526>,
                         <4.79995, -4.91617, 4.66393>, <-1.12997, -3.30465e-016, 0.04933538>,
                         <4.71912, -4.76336, 2.81264>, <-1.18917, -2.65413e-016, 0.05192032> }
        smooth_triangle {<4.69616, -5.33673, 2.28676>, <-1.10632, 2.24358e-016, 0.04830312>,
                         <4.6725, -5.88554, 1.74493>, <-1.07204, -2.17187e-015, 0.04680641>,
                         <4.74974, -6.02676, 3.51415>, <-0.9785294, -5.63785e-016, 0.04272352> }
        smooth_triangle {<4.74974, -6.02676, 3.51415>, <-1.0083, -2.42861e-017, 0.04402312>,
                         <4.77522, -5.48486, 4.09775>, <-1.02207, 3.53016e-016, 0.04462476>,
                         <4.69616, -5.33673, 2.28676>, <-1.0967, 4.31946e-016, 0.04788292> }
        smooth_triangle {<4.65093, 4.98935, 1.25099>, <-0.9273867, -2.38004e-015, 0.04049058>,
                         <4.67162, 4.48043, 1.7247>, <-0.9781769, -1.44792e-015, 0.04270813>,
                         <4.75141, 4.47474, 3.55227>, <-0.9897273, -9.02056e-017, 0.04321243> }
        smooth_triangle {<4.75141, 4.47474, 3.55227>, <-0.9659966, 6.59195e-016, 0.04217632>,
                         <4.72835, 4.98169, 3.02405>, <-0.9123351, 2.76168e-015, 0.03983341>,
                         <4.65093, 4.98935, 1.25099>, <-0.9110957, 2.63678e-016, 0.0397793> }
        smooth_triangle {<4.67162, 4.48043, 1.7247>, <-0.9781769, -1.44792e-015, 0.04270813>,
                         <4.69022, 3.89649, 2.15071>, <-1.16821, 3.88347e-015, 0.05100519>,
                         <4.77218, 3.88526, 4.02802>, <-1.19959, 1.75323e-015, 0.05237514> }
        smooth_triangle {<4.77218, 3.88526, 4.02802>, <-1.16834, 1.28543e-015, 0.05101089>,
                         <4.75141, 4.47474, 3.55227>, <-1.01095, -9.71445e-017, 0.04413886>,
                         <4.67162, 4.48043, 1.7247>, <-1.00228, -1.11543e-015, 0.04376063> }
        smooth_triangle {<4.69022, 3.89649, 2.15071>, <-1.16821, 3.88347e-015, 0.05100519>,
                         <4.7031, 3.18659, 2.44577>, <-1.38791, 1.85037e-017, 0.06059755>,
                         <4.78666, 3.15723, 4.35974>, <-1.44019, 1.50747e-015, 0.06288013> }
        smooth_triangle {<4.78666, 3.15723, 4.35974>, <-1.4209, 1.79154e-015, 0.06203776>,
                         <4.77218, 3.88526, 4.02802>, <-1.24045, 1.97585e-015, 0.05415902>,
                         <4.69022, 3.89649, 2.15071>, <-1.21691, 3.57353e-015, 0.05313156> }
        smooth_triangle {<4.7031, 3.18659, 2.44577>, <-1.38791, 1.85037e-017, 0.06059755>,
                         <4.7093, 2.39879, 2.5878>, <-1.51307, 1.164e-015, 0.066062>,
                         <4.7938, 2.34352, 4.5231>, <-1.57522, -1.57657e-015, 0.06877545> }
        smooth_triangle {<4.7938, 2.34352, 4.5231>, <-1.56957, -1.17766e-015, 0.0685289>,
                         <4.78666, 3.15723, 4.35974>, <-1.4683, 1.13538e-015, 0.06410741>,
                         <4.7031, 3.18659, 2.44577>, <-1.42909, 1.86483e-017, 0.06239547> }
        smooth_triangle {<4.7093, 2.39879, 2.5878>, <-1.51307, 1.164e-015, 0.066062>,
                         <4.71116, 1.58883, 2.63045>, <-1.55552, 8.40329e-016, 0.0679153>,
                         <4.79616, 1.50542, 4.57716>, <-1.61921, 6.53991e-016, 0.07069637> }
        smooth_triangle {<4.79616, 1.50542, 4.57716>, <-1.61916, 4.35199e-016, 0.07069388>,
                         <4.7938, 2.34352, 4.5231>, <-1.58616, -1.23773e-015, 0.06925319>,
                         <4.7093, 2.39879, 2.5878>, <-1.53955, 8.17705e-016, 0.0672181> }
        smooth_triangle {<4.71116, 1.58883, 2.63045>, <-1.55552, 8.40329e-016, 0.0679153>,
                         <4.71023, 0.7746984, 2.60911>, <-1.5688, -1.60606e-015, 0.06849516>,
                         <4.79544, 0.6627317, 4.56083>, <-1.63131, -6.53123e-016, 0.07122456> }
        smooth_triangle {<4.79544, 0.6627317, 4.56083>, <-1.63394, -5.33482e-016, 0.0713394>,
                         <4.79616, 1.50542, 4.57716>, <-1.62487, 4.46854e-016, 0.07094326>,
                         <4.71116, 1.58883, 2.63045>, <-1.57709, 5.86608e-016, 0.06885745> }
        smooth_triangle {<4.71023, 0.7746984, 2.60911>, <-1.5688, -1.60606e-015, 0.06849516>,
                         <4.70713, -0.03747564, 2.53801>, <-1.57012, 5.42968e-016, 0.06855287>,
                         <4.79234, -0.1777996, 4.48976>, <-1.63016, 3.74122e-016, 0.07117416> }
        smooth_triangle {<4.79234, -0.1777996, 4.48976>, <-1.63473, 3.4586e-016, 0.07137369>,
                         <4.79544, 0.6627317, 4.56083>, <-1.63559, -4.24574e-016, 0.0714115>,
                         <4.71023, 0.7746984, 2.60911>, <-1.58871, -1.13928e-015, 0.06936444> }
        smooth_triangle {<4.70713, -0.03747564, 2.53801>, <-1.57012, 5.42968e-016, 0.06855287>,
                         <4.70214, -0.8442731, 2.42373>, <-1.56355, 7.22801e-017, 0.06826614>,
                         <4.78716, -1.01242, 4.37119>, <-1.62002, 2.60209e-017, 0.0707316> }
        smooth_triangle {<4.78716, -1.01242, 4.37119>, <-1.62641, -7.55472e-016, 0.07101081>,
                         <4.79234, -0.1777996, 4.48976>, <-1.63402, -4.94396e-016, 0.07134273>,
                         <4.70713, -0.03747564, 2.53801>, <-1.58899, -3.67761e-016, 0.06937676> }
        smooth_triangle {<4.70214, -0.8442731, 2.42373>, <-1.56355, 7.22801e-017, 0.06826614>,
                         <4.69532, -1.64246, 2.26766>, <-1.54794, 9.08417e-016, 0.06758468>,
                         <4.77998, -1.83756, 4.20665>, <-1.59914, 1.02927e-016, 0.06981974> }
        smooth_triangle {<4.77998, -1.83756, 4.20665>, <-1.608, 9.85757e-016, 0.07020691>,
                         <4.78716, -1.01242, 4.37119>, <-1.62367, 9.28077e-016, 0.07089081>,
                         <4.70214, -0.8442731, 2.42373>, <-1.58132, 9.62772e-016, 0.06904171> }
        smooth_triangle {<4.69532, -1.64246, 2.26766>, <-1.54794, 9.08417e-016, 0.06758468>,
                         <4.68627, -2.42524, 2.06034>, <-1.51585, -1.9533e-015, 0.06618329>,
                         <4.77033, -2.64576, 3.98574>, <-1.55837, 6.38956e-016, 0.06803972> }
        smooth_triangle {<4.77033, -2.64576, 3.98574>, <-1.57132, 6.89553e-017, 0.0686053>,
                         <4.77998, -1.83756, 4.20665>, <-1.6019, -3.33067e-016, 0.06994031>,
                         <4.69532, -1.64246, 2.26766>, <-1.5635, 2.71051e-016, 0.06826401> }
        smooth_triangle {<4.68627, -2.42524, 2.06034>, <-1.51585, -1.9533e-015, 0.06618329>,
                         <4.67424, -3.17853, 1.78488>, <-1.45051, -4.14021e-016, 0.06333075>,
                         <4.75742, -3.42152, 3.68987>, <-1.47823, -7.9219e-016, 0.064541> }
        smooth_triangle {<4.75742, -3.42152, 3.68987>, <-1.4984, -9.46292e-016, 0.06542146>,
                         <4.77033, -2.64576, 3.98574>, <-1.5585, 1.27068e-016, 0.06804551>,
                         <4.68627, -2.42524, 2.06034>, <-1.52661, -1.81712e-015, 0.06665318> }
        smooth_triangle {<4.67424, -3.17853, 1.78488>, <-1.45051, -4.14021e-016, 0.06333075>,
                         <4.65826, -3.87356, 1.41874>, <-1.34126, -8.06068e-016, 0.05856076>,
                         <4.74014, -4.1332, 3.29426>, <-1.34748, -3.1225e-016, 0.05883234> }
        smooth_triangle {<4.74014, -4.1332, 3.29426>, <-1.37358, 2.75821e-016, 0.0599718>,
                         <4.75742, -3.42152, 3.68987>, <-1.47164, -8.41341e-017, 0.06425329>,
                         <4.67424, -3.17853, 1.78488>, <-1.45085, 1.99493e-016, 0.06334561> }
        smooth_triangle {<4.65826, -3.87356, 1.41874>, <-1.34126, -8.06068e-016, 0.05856076>,
                         <4.63886, -4.4945, 0.9744087>, <-1.22092, 8.44232e-017, 0.05330632>,
                         <4.71912, -4.76336, 2.81264>, <-1.20578, -8.3498e-016, 0.05264566> }
        smooth_triangle {<4.71912, -4.76336, 2.81264>, <-1.23107, -1.37737e-015, 0.05374971>,
                         <4.74014, -4.1332, 3.29426>, <-1.33734, -9.85323e-016, 0.05838972>,
                         <4.65826, -3.87356, 1.41874>, <-1.33268, -1.35569e-015, 0.05818604> }
        smooth_triangle {<4.63886, -4.4945, 0.9744087>, <-1.22092, 8.44232e-017, 0.05330632>,
                         <4.6177, -5.06379, 0.4898529>, <-1.13572, -1.56703e-015, 0.04958641>,
                         <4.69616, -5.33673, 2.28676>, <-1.10632, 2.24358e-016, 0.04830312> }
        smooth_triangle {<4.69616, -5.33673, 2.28676>, <-1.12858, 1.12757e-017, 0.04927503>,
                         <4.71912, -4.76336, 2.81264>, <-1.20318, -7.83228e-016, 0.05253193>,
                         <4.63886, -4.4945, 0.9744087>, <-1.21453, -9.36751e-017, 0.05302743> }
        smooth_triangle {<4.6177, -5.06379, 0.4898529>, <-1.13572, -1.56703e-015, 0.04958641>,

                         <4.59591, -5.61076, -0.009216214>, <-1.10038, -2.50668e-015, 0.0480435>,
                         <4.6725, -5.88554, 1.74493>, <-1.07204, -2.17187e-015, 0.04680641> }
        smooth_triangle {<4.6725, -5.88554, 1.74493>, <-1.09271, -2.19038e-015, 0.0477088>,
                         <4.69616, -5.33673, 2.28676>, <-1.11325, -3.88578e-016, 0.04860574>,
                         <4.6177, -5.06379, 0.4898529>, <-1.1353, -1.73212e-015, 0.0495682> }
        smooth_triangle {<4.57352, 5.00052, -0.5220608>, <-0.9156843, -6.23807e-015, 0.03997964>,
                         <4.59187, 4.49566, -0.1017107>, <-0.9581805, -4.16334e-017, 0.04183506>,
                         <4.67162, 4.48043, 1.7247>, <-0.9781769, -1.44792e-015, 0.04270813> }
        smooth_triangle {<4.67162, 4.48043, 1.7247>, <-0.9578927, -1.81279e-015, 0.0418225>,
                         <4.65093, 4.98935, 1.25099>, <-0.9122133, -2.64372e-015, 0.03982809>,
                         <4.57352, 5.00052, -0.5220608>, <-0.906362, -4.57273e-015, 0.03957262> }
        smooth_triangle {<4.59187, 4.49566, -0.1017107>, <-0.9581805, -4.16334e-017, 0.04183506>,
                         <4.60835, 3.92327, 0.2757071>, <-1.12906, 1.17267e-015, 0.04929563>,
                         <4.69022, 3.89649, 2.15071>, <-1.16821, 3.88347e-015, 0.05100519> }
        smooth_triangle {<4.69022, 3.89649, 2.15071>, <-1.14117, 3.46251e-015, 0.04982434>,
                         <4.67162, 4.48043, 1.7247>, <-0.9986397, -5.3603e-016, 0.04360155>,
                         <4.59187, 4.49566, -0.1017107>, <-0.9836423, 5.18682e-016, 0.04294675> }
        smooth_triangle {<4.60835, 3.92327, 0.2757071>, <-1.12906, 1.17267e-015, 0.04929563>,
                         <4.61968, 3.23753, 0.5352753>, <-1.32744, 1.67574e-015, 0.05795713>,
                         <4.7031, 3.18659, 2.44577>, <-1.38791, 1.85037e-017, 0.06059755> }
        smooth_triangle {<4.7031, 3.18659, 2.44577>, <-1.37172, 5.95878e-016, 0.05989075>,
                         <4.69022, 3.89649, 2.15071>, <-1.20695, 3.4946e-015, 0.05269648>,
                         <4.60835, 3.92327, 0.2757071>, <-1.17758, 1.4615e-015, 0.05141431> }
        smooth_triangle {<4.61968, 3.23753, 0.5352753>, <-1.32744, 1.67574e-015, 0.05795713>,
                         <4.625, 2.48167, 0.6571089>, <-1.44159, 3.16081e-015, 0.0629411>,
                         <4.7093, 2.39879, 2.5878>, <-1.51307, 1.164e-015, 0.066062> }
        smooth_triangle {<4.7093, 2.39879, 2.5878>, <-1.50926, -1.68268e-016, 0.06589589>,
                         <4.7031, 3.18659, 2.44577>, <-1.4154, -1.02739e-015, 0.06179755>,
                         <4.61968, 3.23753, 0.5352753>, <-1.37004, 2.15539e-016, 0.05981723> }
        smooth_triangle {<4.625, 2.48167, 0.6571089>, <-1.44159, 3.16081e-015, 0.0629411>,
                         <4.62642, 1.70587, 0.6895033>, <-1.4813, -1.57021e-015, 0.06467486>,
                         <4.71116, 1.58883, 2.63045>, <-1.55552, 8.40329e-016, 0.0679153> }
        smooth_triangle {<4.71116, 1.58883, 2.63045>, <-1.5567, 1.22114e-015, 0.06796694>,
                         <4.7093, 2.39879, 2.5878>, <-1.52486, 1.46389e-015, 0.06657696>,
                         <4.625, 2.48167, 0.6571089>, <-1.47125, 2.9615e-015, 0.06423629> }
        smooth_triangle {<4.62642, 1.70587, 0.6895033>, <-1.4813, -1.57021e-015, 0.06467486>,
                         <4.62532, 0.9263111, 0.6643066>, <-1.49457, -1.95937e-015, 0.0652544>,
                         <4.71023, 0.7746984, 2.60911>, <-1.5688, -1.60606e-015, 0.06849516> }
        smooth_triangle {<4.71023, 0.7746984, 2.60911>, <-1.57227, -1.75006e-015, 0.06864677>,
                         <4.71116, 1.58883, 2.63045>, <-1.56231, 8.47304e-017, 0.06821188>,
                         <4.62642, 1.70587, 0.6895033>, <-1.50665, -1.72318e-015, 0.06578155> }
        smooth_triangle {<4.62532, 0.9263111, 0.6643066>, <-1.49457, -1.95937e-015, 0.0652544>,
                         <4.62226, 0.1485168, 0.5943294>, <-1.49707, 4.67797e-016, 0.06536351>,
                         <4.70713, -0.03747564, 2.53801>, <-1.57012, 5.42968e-016, 0.06855287> }
        smooth_triangle {<4.70713, -0.03747564, 2.53801>, <-1.57516, 1.29931e-015, 0.06877312>,
                         <4.71023, 0.7746984, 2.60911>, <-1.57417, -3.12467e-016, 0.06872983>,
                         <4.62532, 0.9263111, 0.6643066>, <-1.5185, -5.77446e-016, 0.06629927> }
        smooth_triangle {<4.62226, 0.1485168, 0.5943294>, <-1.49707, 4.67797e-016, 0.06536351>,
                         <4.61751, -0.6244384, 0.4854874>, <-1.49259, 2.50205e-015, 0.06516788>,
                         <4.70214, -0.8442731, 2.42373>, <-1.56355, 7.22801e-017, 0.06826614> }
        smooth_triangle {<4.70214, -0.8442731, 2.42373>, <-1.57002, -1.39212e-016, 0.06854843>,
                         <4.70713, -0.03747564, 2.53801>, <-1.57494, 2.13805e-016, 0.06876348>,
                         <4.62226, 0.1485168, 0.5943294>, <-1.52016, 1.57426e-016, 0.06637145> }
        smooth_triangle {<4.61751, -0.6244384, 0.4854874>, <-1.49259, 2.50205e-015, 0.06516788>,
                         <4.61112, -1.38965, 0.3390328>, <-1.48039, 4.97287e-017, 0.06463539>,
                         <4.69532, -1.64246, 2.26766>, <-1.54794, 9.08417e-016, 0.06758468> }
        smooth_triangle {<4.69532, -1.64246, 2.26766>, <-1.55631, 2.60209e-018, 0.0679498>,
                         <4.70214, -0.8442731, 2.42373>, <-1.56801, -6.245e-016, 0.0684609>,
                         <4.61751, -0.6244384, 0.4854874>, <-1.51479, 1.19783e-015, 0.0661372> }
        smooth_triangle {<4.61112, -1.38965, 0.3390328>, <-1.48039, 4.97287e-017, 0.06463539>,
                         <4.60271, -2.14098, 0.1464495>, <-1.45436, -1.39877e-015, 0.06349863>,
                         <4.68627, -2.42524, 2.06034>, <-1.51585, -1.9533e-015, 0.06618329> }
        smooth_triangle {<4.68627, -2.42524, 2.06034>, <-1.52741, -5.66821e-016, 0.06668814>,
                         <4.69532, -1.64246, 2.26766>, <-1.55148, 1.57947e-015, 0.06773918>,
                         <4.61112, -1.38965, 0.3390328>, <-1.50082, 9.3545e-016, 0.06552721> }
        smooth_triangle {<4.60271, -2.14098, 0.1464495>, <-1.45436, -1.39877e-015, 0.06349863>,
                         <4.59162, -2.86578, -0.1074566>, <-1.40007, -1.46873e-016, 0.06112848>,
                         <4.67424, -3.17853, 1.78488>, <-1.45051, -4.14021e-016, 0.06333075> }
        smooth_triangle {<4.67424, -3.17853, 1.78488>, <-1.46789, -1.04344e-015, 0.06408942>,
                         <4.68627, -2.42524, 2.06034>, <-1.51689, -2.19789e-015, 0.06622883>,
                         <4.60271, -2.14098, 0.1464495>, <-1.47077, -1.78199e-015, 0.06421533> }
        smooth_triangle {<4.59162, -2.86578, -0.1074566>, <-1.40007, -1.46873e-016, 0.06112848>,
                         <4.57697, -3.53815, -0.442968>, <-1.30771, 6.71916e-016, 0.05709595>,
                         <4.65826, -3.87356, 1.41874>, <-1.34126, -8.06068e-016, 0.05856076> }
        smooth_triangle {<4.65826, -3.87356, 1.41874>, <-1.36338, -7.60676e-016, 0.05952659>,
                         <4.67424, -3.17853, 1.78488>, <-1.44532, -4.66641e-016, 0.06310409>,
                         <4.59162, -2.86578, -0.1074566>, <-1.40749, -2.6628e-016, 0.06145238> }
        smooth_triangle {<4.57697, -3.53815, -0.442968>, <-1.30771, 6.71916e-016, 0.05709595>,
                         <4.55925, -4.14383, -0.8488576>, <-1.20461, -3.28441e-016, 0.0525942>,
                         <4.63886, -4.4945, 0.9744087>, <-1.22092, 8.44232e-017, 0.05330632> }
        smooth_triangle {<4.63886, -4.4945, 0.9744087>, <-1.24194, 1.25767e-016, 0.05422443>,
                         <4.65826, -3.87356, 1.41874>, <-1.3322, -5.42101e-016, 0.05816526>,
                         <4.57697, -3.53815, -0.442968>, <-1.30704, 5.66387e-016, 0.05706665> }
        smooth_triangle {<4.55925, -4.14383, -0.8488576>, <-1.20461, -3.28441e-016, 0.0525942>,
                         <4.53995, -4.70303, -1.29095>, <-1.13079, -1.42941e-015, 0.04937139>,
                         <4.6177, -5.06379, 0.4898529>, <-1.13572, -1.56703e-015, 0.04958641> }
        smooth_triangle {<4.6177, -5.06379, 0.4898529>, <-1.15376, -9.70578e-016, 0.05037429>,
                         <4.63886, -4.4945, 0.9744087>, <-1.21766, 2.68015e-016, 0.05316422>,
                         <4.55925, -4.14383, -0.8488576>, <-1.20543, -4.16334e-017, 0.05263013> }
        smooth_triangle {<4.53995, -4.70303, -1.29095>, <-1.13079, -1.42941e-015, 0.04937139>,
                         <4.52008, -5.24214, -1.7461>, <-1.09604, 7.40727e-016, 0.04785394>,
                         <4.59591, -5.61076, -0.009216214>, <-1.10038, -2.50668e-015, 0.0480435> }
        smooth_triangle {<4.59591, -5.61076, -0.009216214>, <-1.11828, -2.96985e-015, 0.04882527>,
                         <4.6177, -5.06379, 0.4898529>, <-1.14031, -2.14932e-015, 0.04978701>,
                         <4.53995, -4.70303, -1.29095>, <-1.13662, -2.04611e-015, 0.04962575> }
        smooth_triangle {<4.49611, 5.01699, -2.29506>, <-0.8957447, 2.498e-015, 0.03910906>,
                         <4.51219, 4.52108, -1.92685>, <-0.9292896, 7.57496e-016, 0.04057366>,
                         <4.59187, 4.49566, -0.1017107>, <-0.9581805, -4.16334e-017, 0.04183506> }
        smooth_triangle {<4.59187, 4.49566, -0.1017107>, <-0.940686, -1.30451e-015, 0.04107124>,
                         <4.57352, 5.00052, -0.5220608>, <-0.9019435, -5.66561e-015, 0.0393797>,
                         <4.49611, 5.01699, -2.29506>, <-0.8919737, -1.29757e-015, 0.03894441> }
        smooth_triangle {<4.51219, 4.52108, -1.92685>, <-0.9292896, 7.57496e-016, 0.04057366>,
                         <4.5266, 3.96515, -1.59679>, <-1.08113, -2.71773e-016, 0.04720325>,
                         <4.60835, 3.92327, 0.2757071>, <-1.12906, 1.17267e-015, 0.04929563> }
        smooth_triangle {<4.60835, 3.92327, 0.2757071>, <-1.10556, 2.25861e-015, 0.04826994>,
                         <4.59187, 4.49566, -0.1017107>, <-0.9774071, 1.34788e-015, 0.04267452>,
                         <4.51219, 4.52108, -1.92685>, <-0.955739, 1.94723e-015, 0.04172846> }
        smooth_triangle {<4.5266, 3.96515, -1.59679>, <-1.08113, -2.71773e-016, 0.04720325>,
                         <4.53643, 3.30845, -1.37149>, <-1.25789, 3.12135e-015, 0.05492084>,
                         <4.61968, 3.23753, 0.5352753>, <-1.32744, 1.67574e-015, 0.05795713> }
        smooth_triangle {<4.61968, 3.23753, 0.5352753>, <-1.31388, 1.4962e-015, 0.05736503>,
                         <4.60835, 3.92327, 0.2757071>, <-1.16509, 1.1189e-015, 0.05086891>,
                         <4.5266, 3.96515, -1.59679>, <-1.12915, 3.55618e-017, 0.04929963> }
        smooth_triangle {<4.53643, 3.30845, -1.37149>, <-1.25789, 3.12135e-015, 0.05492084>,
                         <4.54092, 2.58943, -1.26862>, <-1.36047, -1.08637e-015, 0.05939962>,
                         <4.625, 2.48167, 0.6571089>, <-1.44159, 3.16081e-015, 0.0629411> }
        smooth_triangle {<4.625, 2.48167, 0.6571089>, <-1.43934, 3.51466e-015, 0.06284296>,
                         <4.61968, 3.23753, 0.5352753>, <-1.35373, 2.40086e-015, 0.05910498>,
                         <4.53643, 3.30845, -1.37149>, <-1.30157, 3.48506e-015, 0.05682777> }
        smooth_triangle {<4.54092, 2.58943, -1.26862>, <-1.36047, -1.08637e-015, 0.05939962>,
                         <4.54194, 1.85269, -1.24525>, <-1.39686, -3.42608e-017, 0.06098815>,
                         <4.62642, 1.70587, 0.6895033>, <-1.4813, -1.57021e-015, 0.06467486> }
        smooth_triangle {<4.62642, 1.70587, 0.6895033>, <-1.4836, -6.22874e-016, 0.06477521>,
                         <4.625, 2.48167, 0.6571089>, <-1.45381, 2.92539e-015, 0.06347489>,
                         <4.54092, 2.58943, -1.26862>, <-1.39298, -2.59992e-016, 0.06081878> }
        smooth_triangle {<4.54194, 1.85269, -1.24525>, <-1.39686, -3.42608e-017, 0.06098815>,
                         <4.54073, 1.1126, -1.27307>, <-1.40953, -7.09068e-016, 0.06154151>,
                         <4.62532, 0.9263111, 0.6643066>, <-1.49457, -1.95937e-015, 0.0652544> }
        smooth_triangle {<4.62532, 0.9263111, 0.6643066>, <-1.49892, -2.93895e-015, 0.06544412>,
                         <4.62642, 1.70587, 0.6895033>, <-1.48896, -2.64708e-015, 0.06500946>,
                         <4.54194, 1.85269, -1.24525>, <-1.42563, -1.49511e-015, 0.06224443> }
        smooth_triangle {<4.54073, 1.1126, -1.27307>, <-1.40953, -7.09068e-016, 0.06154151>,
                         <4.53778, 0.374088, -1.3407>, <-1.41257, -2.07415e-015, 0.06167424>,
                         <4.62226, 0.1485168, 0.5943294>, <-1.49707, 4.67797e-016, 0.06536351> }
        smooth_triangle {<4.62226, 0.1485168, 0.5943294>, <-1.50278, 2.40259e-016, 0.0656129>,
                         <4.62532, 0.9263111, 0.6643066>, <-1.50091, -1.58012e-015, 0.06553107>,
                         <4.54073, 1.1126, -1.27307>, <-1.43713, -6.4239e-016, 0.06274641> }
        smooth_triangle {<4.53778, 0.374088, -1.3407>, <-1.41257, -2.07415e-015, 0.06167424>,
                         <4.53332, -0.3601269, -1.44288>, <-1.40947, 3.08636e-015, 0.06153866>,
                         <4.61751, -0.6244384, 0.4854874>, <-1.49259, 2.50205e-015, 0.06516788> }
        smooth_triangle {<4.61751, -0.6244384, 0.4854874>, <-1.4995, 2.99847e-015, 0.06546972>,
                         <4.62226, 0.1485168, 0.5943294>, <-1.50286, 1.47278e-015, 0.06561645>,
                         <4.53778, 0.374088, -1.3407>, <-1.43949, -4.33681e-016, 0.06284949> }
        smooth_triangle {<4.53332, -0.3601269, -1.44288>, <-1.40947, 3.08636e-015, 0.06153866>,
                         <4.5274, -1.08745, -1.57848>, <-1.39981, 3.7817e-016, 0.06111686>,
                         <4.61112, -1.38965, 0.3390328>, <-1.48039, 4.97287e-017, 0.06463539> }
        smooth_triangle {<4.61112, -1.38965, 0.3390328>, <-1.48887, 7.00828e-016, 0.06500555>,
                         <4.61751, -0.6244384, 0.4854874>, <-1.49802, 2.54007e-015, 0.06540491>,
                         <4.53332, -0.3601269, -1.44288>, <-1.43568, 2.9783e-015, 0.062683> }
        smooth_triangle {<4.5274, -1.08745, -1.57848>, <-1.39981, 3.7817e-016, 0.06111686>,
                         <4.51968, -1.80245, -1.7551>, <-1.37863, -1.24033e-015, 0.06019237>,
                         <4.60271, -2.14098, 0.1464495>, <-1.45436, -1.39877e-015, 0.06349863> }
        smooth_triangle {<4.60271, -2.14098, 0.1464495>, <-1.46549, -2.43295e-015, 0.06398476>,
                         <4.61112, -1.38965, 0.3390328>, <-1.48502, -1.34658e-015, 0.06483734>,
                         <4.5274, -1.08745, -1.57848>, <-1.42458, -1.10025e-015, 0.06219844> }
        smooth_triangle {<4.51968, -1.80245, -1.7551>, <-1.37863, -1.24033e-015, 0.06019237>,
                         <4.50959, -2.49386, -1.98622>, <-1.3337, 3.63714e-016, 0.0582308>,
                         <4.59162, -2.86578, -0.1074566>, <-1.40007, -1.46873e-016, 0.06112848> }
        smooth_triangle {<4.59162, -2.86578, -0.1074566>, <-1.4161, 6.74807e-016, 0.0618284>,
                         <4.60271, -2.14098, 0.1464495>, <-1.45682, -2.64112e-016, 0.06360601>,
                         <4.51968, -1.80245, -1.7551>, <-1.40002, -1.45283e-016, 0.06112632> }
        smooth_triangle {<4.50959, -2.49386, -1.98622>, <-1.3337, 3.63714e-016, 0.0582308>,
                         <4.49634, -3.13867, -2.28987>, <-1.25623, 7.40149e-016, 0.05484829>,
                         <4.57697, -3.53815, -0.442968>, <-1.30771, 6.71916e-016, 0.05709595> }
        smooth_triangle {<4.57697, -3.53815, -0.442968>, <-1.32779, 2.74086e-016, 0.05797236>,
                         <4.59162, -2.86578, -0.1074566>, <-1.39706, -3.40006e-016, 0.06099676>,
                         <4.50959, -2.49386, -1.98622>, <-1.34728, 4.29344e-017, 0.0588235> }
        smooth_triangle {<4.49634, -3.13867, -2.28987>, <-1.25623, 7.40149e-016, 0.05484829>,
                         <4.48035, -3.72419, -2.65609>, <-1.16865, -2.1684e-015, 0.05102415>,
                         <4.55925, -4.14383, -0.8488576>, <-1.20461, -3.28441e-016, 0.0525942> }
        smooth_triangle {<4.55925, -4.14383, -0.8488576>, <-1.22365, -5.37764e-017, 0.05342558>,
                         <4.57697, -3.53815, -0.442968>, <-1.30098, 6.96491e-016, 0.0568019>,
                         <4.49634, -3.13867, -2.28987>, <-1.26237, 7.47666e-016, 0.05511616> }
        smooth_triangle {<4.48035, -3.72419, -2.65609>, <-1.16865, -2.1684e-015, 0.05102415>,
                         <4.46295, -4.2684, -3.05449>, <-1.10504, 2.89121e-017, 0.04824714>,
                         <4.53995, -4.70303, -1.29095>, <-1.13079, -1.42941e-015, 0.04937139> }
        smooth_triangle {<4.53995, -4.70303, -1.29095>, <-1.14713, -1.11456e-015, 0.05008459>,
                         <4.55925, -4.14383, -0.8488576>, <-1.20249, -2.88831e-016, 0.05250169>,
                         <4.48035, -3.72419, -2.65609>, <-1.17552, -1.6688e-015, 0.05132416> }
        smooth_triangle {<4.46295, -4.2684, -3.05449>, <-1.10504, 2.89121e-017, 0.04824714>,
                         <4.44505, -4.79476, -3.46449>, <-1.07161, 2.30024e-015, 0.04678738>,
                         <4.52008, -5.24214, -1.7461>, <-1.09604, 7.40727e-016, 0.04785394> }
        smooth_triangle {<4.52008, -5.24214, -1.7461>, <-1.11355, 1.02927e-015, 0.04861848>,
                         <4.53995, -4.70303, -1.29095>, <-1.13524, -6.70471e-016, 0.04956544>,
                         <4.46295, -4.2684, -3.05449>, <-1.11592, 4.23273e-016, 0.04872225> }
        smooth_triangle {<4.4187, 5.04175, -4.06797>, <-0.8649667, -1.97758e-016, 0.03776526>,
                         <4.43258, 4.56047, -3.75007>, <-0.8888874, -8.24572e-016, 0.03880966>,
                         <4.51219, 4.52108, -1.92685>, <-0.9292896, 7.57496e-016, 0.04057366> }
        smooth_triangle {<4.51219, 4.52108, -1.92685>, <-0.9144877, 9.28944e-016, 0.0399274>,
                         <4.49611, 5.01699, -2.29506>, <-0.8829134, 1.97065e-015, 0.03854883>,
                         <4.4187, 5.04175, -4.06797>, <-0.8675244, 6.22766e-016, 0.03787693> }
        smooth_triangle {<4.43258, 4.56047, -3.75007>, <-0.8888874, -8.24572e-016, 0.03880966>,
                         <4.445, 4.02667, -3.46557>, <-1.02135, 1.50111e-015, 0.04459327>,
                         <4.5266, 3.96515, -1.59679>, <-1.08113, -2.71773e-016, 0.04720325> }
        smooth_triangle {<4.5266, 3.96515, -1.59679>, <-1.061, -2.9577e-016, 0.04632405>,
                         <4.51219, 4.52108, -1.92685>, <-0.9471132, 4.76182e-016, 0.04135185>,
                         <4.43258, 4.56047, -3.75007>, <-0.9168115, -7.10369e-016, 0.04002886> }
        smooth_triangle {<4.445, 4.02667, -3.46557>, <-1.02135, 1.50111e-015, 0.04459327>,
                         <4.45342, 3.40469, -3.27272>, <-1.17608, 5.11454e-016, 0.05134874>,
                         <4.53643, 3.30845, -1.37149>, <-1.25789, 3.12135e-015, 0.05492084> }
        smooth_triangle {<4.53643, 3.30845, -1.37149>, <-1.24676, 2.37397e-015, 0.05443472>,
                         <4.5266, 3.96515, -1.59679>, <-1.11419, -1.7087e-016, 0.04864653>,
                         <4.445, 4.02667, -3.46557>, <-1.06936, 1.1588e-015, 0.04668905> }
        smooth_triangle {<4.45342, 3.40469, -3.27272>, <-1.17608, 5.11454e-016, 0.05134874>,
                         <4.45717, 2.72819, -3.187>, <-1.26661, -5.77663e-016, 0.0553015>,
                         <4.54092, 2.58943, -1.26862>, <-1.36047, -1.08637e-015, 0.05939962> }
        smooth_triangle {<4.54092, 2.58943, -1.26862>, <-1.35963, -1.24792e-016, 0.05936293>,
                         <4.53643, 3.30845, -1.37149>, <-1.2827, 3.031e-015, 0.05600385>,
                         <4.45342, 3.40469, -3.27272>, <-1.22134, 1.07358e-015, 0.05332477> }
        smooth_triangle {<4.45717, 2.72819, -3.187>, <-1.26661, -5.77663e-016, 0.0553015>,
                         <4.45787, 2.03618, -3.17085>, <-1.29919, -7.81168e-016, 0.05672395>,
                         <4.54194, 1.85269, -1.24525>, <-1.39686, -3.42608e-017, 0.06098815> }
        smooth_triangle {<4.54194, 1.85269, -1.24525>, <-1.40017, -2.82868e-016, 0.06113288>,
                         <4.54092, 2.58943, -1.26862>, <-1.37289, -1.07195e-015, 0.05994148>,
                         <4.45717, 2.72819, -3.187>, <-1.30249, -6.9042e-016, 0.05686789> }
        smooth_triangle {<4.45787, 2.03618, -3.17085>, <-1.29919, -7.81168e-016, 0.05672395>,
                         <4.45662, 1.34124, -3.19949>, <-1.3108, 6.04262e-016, 0.05723075>,
                         <4.54073, 1.1126, -1.27307>, <-1.40953, -7.09068e-016, 0.06154151> }
        smooth_triangle {<4.54073, 1.1126, -1.27307>, <-1.4147, -4.64472e-016, 0.06176723>,
                         <4.54194, 1.85269, -1.24525>, <-1.4052, 4.16334e-017, 0.0613522>,
                         <4.45787, 2.03618, -3.17085>, <-1.33195, -5.18547e-016, 0.05815405> }
        smooth_triangle {<4.45662, 1.34124, -3.19949>, <-1.3108, 6.04262e-016, 0.05723075>,
                         <4.45385, 0.6476773, -3.26296>, <-1.31392, -1.66302e-015, 0.05736688>,
                         <4.53778, 0.374088, -1.3407>, <-1.41257, -2.07415e-015, 0.06167424> }
        smooth_triangle {<4.53778, 0.374088, -1.3407>, <-1.41897, -2.27617e-015, 0.06195343>,
                         <4.54073, 1.1126, -1.27307>, <-1.41669, -1.25236e-015, 0.06185389>,
                         <4.45662, 1.34124, -3.19949>, <-1.34264, -2.67364e-016, 0.05862082> }
        smooth_triangle {<4.45385, 0.6476773, -3.26296>, <-1.31392, -1.66302e-015, 0.05736688>,
                         <4.44976, -0.04212333, -3.35665>, <-1.31172, 2.25485e-015, 0.05727108>,
                         <4.53332, -0.3601269, -1.44288>, <-1.40947, 3.08636e-015, 0.06153866> }
        smooth_triangle {<4.53332, -0.3601269, -1.44288>, <-1.41693, 2.5572e-015, 0.06186432>,
                         <4.53778, 0.374088, -1.3407>, <-1.41925, -1.31319e-015, 0.061966>,
                         <4.45385, 0.6476773, -3.26296>, <-1.34526, -1.00484e-015, 0.05873548> }
        smooth_triangle {<4.44976, -0.04212333, -3.35665>, <-1.31172, 2.25485e-015, 0.05727108>,
                         <4.44439, -0.7258973, -3.4796>, <-1.30412, -3.52727e-016, 0.05693914>,
                         <4.5274, -1.08745, -1.57848>, <-1.39981, 3.7817e-016, 0.06111686> }
        smooth_triangle {<4.5274, -1.08745, -1.57848>, <-1.40862, 1.07683e-015, 0.06150173>,
                         <4.53332, -0.3601269, -1.44288>, <-1.41587, 3.10797e-015, 0.06181808>,
                         <4.44976, -0.04212333, -3.35665>, <-1.34256, 2.48434e-015, 0.05861739> }
        smooth_triangle {<4.44439, -0.7258973, -3.4796>, <-1.30412, -3.52727e-016, 0.05693914>,
                         <4.43746, -1.39888, -3.63843>, <-1.2873, -4.54498e-016, 0.05620453>,
                         <4.51968, -1.80245, -1.7551>, <-1.37863, -1.24033e-015, 0.06019237> }
        smooth_triangle {<4.51968, -1.80245, -1.7551>, <-1.38976, -1.31839e-015, 0.0606783>,
                         <4.5274, -1.08745, -1.57848>, <-1.40564, -1.04517e-016, 0.06137166>,
                         <4.44439, -0.7258973, -3.4796>, <-1.33388, -6.5269e-016, 0.05823837> }
        smooth_triangle {<4.43746, -1.39888, -3.63843>, <-1.2873, -4.54498e-016, 0.05620453>,
                         <4.42844, -2.05123, -3.84496>, <-1.25116, -2.02963e-016, 0.05462702>,
                         <4.50959, -2.49386, -1.98622>, <-1.3337, 3.63714e-016, 0.0582308> }
        smooth_triangle {<4.50959, -2.49386, -1.98622>, <-1.34914, -2.53703e-016, 0.05890458>,
                         <4.51968, -1.80245, -1.7551>, <-1.38283, -1.45673e-015, 0.06037575>,
                         <4.43746, -1.39888, -3.63843>, <-1.31433, -8.67362e-016, 0.05738487> }
        smooth_triangle {<4.42844, -2.05123, -3.84496>, <-1.25116, -2.02963e-016, 0.05462702>,
                         <4.41665, -2.6628, -4.11495>, <-1.18801, -4.03612e-016, 0.05186943>,
                         <4.49634, -3.13867, -2.28987>, <-1.25623, 7.40149e-016, 0.05484829> }
        smooth_triangle {<4.49634, -3.13867, -2.28987>, <-1.27541, 1.32186e-015, 0.05568553>,
                         <4.50959, -2.49386, -1.98622>, <-1.33351, 1.03953e-015, 0.05822241>,
                         <4.42844, -2.05123, -3.84496>, <-1.27161, 6.14526e-016, 0.05551958> }
        smooth_triangle {<4.41665, -2.6628, -4.11495>, <-1.18801, -4.03612e-016, 0.05186943>,
                         <4.40247, -3.22249, -4.43969>, <-1.11546, -4.66062e-016, 0.04870211>,
                         <4.48035, -3.72419, -2.65609>, <-1.16865, -2.1684e-015, 0.05102415> }
        smooth_triangle {<4.48035, -3.72419, -2.65609>, <-1.18721, -1.92121e-015, 0.0518346>,
                         <4.49634, -3.13867, -2.28987>, <-1.2529, 2.60209e-016, 0.05470271>,
                         <4.41665, -2.6628, -4.11495>, <-1.20173, -5.97612e-016, 0.05246856> }
        smooth_triangle {<4.40247, -3.22249, -4.43969>, <-1.11546, -4.66062e-016, 0.04870211>,
                         <4.38707, -3.74604, -4.79258>, <-1.06172, 1.6954e-015, 0.04635589>,
                         <4.46295, -4.2684, -3.05449>, <-1.10504, 2.89121e-017, 0.04824714> }
        smooth_triangle {<4.46295, -4.2684, -3.05449>, <-1.12141, -8.95985e-016, 0.04896198>,
                         <4.48035, -3.72419, -2.65609>, <-1.16912, -2.54397e-015, 0.05104473>,
                         <4.40247, -3.22249, -4.43969>, <-1.12923, -1.26722e-015, 0.0493032> }
        smooth_triangle {<4.38707, -3.74604, -4.79258>, <-1.06172, 1.6954e-015, 0.04635589>,
                         <4.37121, -4.25396, -5.15562>, <-1.02871, 4.04191e-016, 0.04491433>,
                         <4.44505, -4.79476, -3.46449>, <-1.07161, 2.30024e-015, 0.04678738> }
        smooth_triangle {<4.44505, -4.79476, -3.46449>, <-1.09075, 1.72778e-015, 0.04762299>,
                         <4.46295, -4.2684, -3.05449>, <-1.11104, 1.67401e-016, 0.04850891>,
                         <4.38707, -3.74604, -4.79258>, <-1.07855, 1.41727e-015, 0.04709047> }
        smooth_triangle {<4.34131, 5.07979, -5.84063>, <-0.8216434, -1.08941e-015, 0.03587373>,
                         <4.3531, 4.61965, -5.57045>, <-0.8400993, -6.15249e-016, 0.03667953>,
                         <4.43258, 4.56047, -3.75007>, <-0.8888874, -8.24572e-016, 0.03880966> }
        smooth_triangle {<4.43258, 4.56047, -3.75007>, <-0.8769312, -6.59195e-016, 0.03828764>,
                         <4.4187, 5.04175, -4.06797>, <-0.8530147, -1.80411e-016, 0.03724342>,
                         <4.34131, 5.07979, -5.84063>, <-0.831353, -6.26235e-016, 0.03629766> }
        smooth_triangle {<4.3531, 4.61965, -5.57045>, <-0.8400993, -6.15249e-016, 0.03667953>,
                         <4.36365, 4.11449, -5.32889>, <-0.9537701, 1.02927e-016, 0.0416425>,
                         <4.445, 4.02667, -3.46557>, <-1.02135, 1.50111e-015, 0.04459327> }
        smooth_triangle {<4.445, 4.02667, -3.46557>, <-1.00474, 8.38739e-016, 0.04386773>,
                         <4.43258, 4.56047, -3.75007>, <-0.9053865, -9.05526e-016, 0.03953003>,
                         <4.3531, 4.61965, -5.57045>, <-0.8687954, -7.48533e-016, 0.03793243> }
        smooth_triangle {<4.36365, 4.11449, -5.32889>, <-0.9537701, 1.02927e-016, 0.0416425>,
                         <4.37077, 3.53376, -5.1659>, <-1.08667, 4.68086e-016, 0.04744523>,
                         <4.45342, 3.40469, -3.27272>, <-1.17608, 5.11454e-016, 0.05134874> }
        smooth_triangle {<4.45342, 3.40469, -3.27272>, <-1.16756, 1.83555e-015, 0.05097675>,
                         <4.445, 4.02667, -3.46557>, <-1.05152, 2.5778e-015, 0.04591015>,
                         <4.36365, 4.11449, -5.32889>, <-1.00083, 1.52916e-015, 0.04369707> }
        smooth_triangle {<4.37077, 3.53376, -5.1659>, <-1.08667, 4.68086e-016, 0.04744523>,
                         <4.37387, 2.90629, -5.09472>, <-1.16489, -2.19551e-016, 0.05086037>,
                         <4.45717, 2.72819, -3.187>, <-1.26661, -5.77663e-016, 0.0553015> }
        smooth_triangle {<4.45717, 2.72819, -3.187>, <-1.26738, -1.63758e-015, 0.05533489>,
                         <4.45342, 3.40469, -3.27272>, <-1.19948, -8.20741e-016, 0.05237032>,
                         <4.37077, 3.53376, -5.1659>, <-1.13242, -8.53267e-016, 0.04944269> }
        smooth_triangle {<4.37387, 2.90629, -5.09472>, <-1.16489, -2.19551e-016, 0.05086037>,
                         <4.37438, 2.26552, -5.08318>, <-1.19327, 8.96418e-016, 0.05209946>,
                         <4.45787, 2.03618, -3.17085>, <-1.29919, -7.81168e-016, 0.05672395> }
        smooth_triangle {<4.45787, 2.03618, -3.17085>, <-1.30372, -4.04326e-016, 0.05692154>,
                         <4.45717, 2.72819, -3.187>, <-1.27928, -2.51698e-016, 0.05585471>,
                         <4.37387, 2.90629, -5.09472>, <-1.20299, 1.68864e-017, 0.05252386> }
        smooth_triangle {<4.37438, 2.26552, -5.08318>, <-1.19327, 8.96418e-016, 0.05209946>,
                         <4.3732, 1.62225, -5.11003>, <-1.2034, -3.30031e-016, 0.05254154>,
                         <4.45662, 1.34124, -3.19949>, <-1.3108, 6.04262e-016, 0.05723075> }
        smooth_triangle {<4.45662, 1.34124, -3.19949>, <-1.31698, 5.99455e-016, 0.05750054>,
                         <4.45787, 2.03618, -3.17085>, <-1.30827, -4.39617e-016, 0.05712044>,
                         <4.37438, 2.26552, -5.08318>, <-1.22883, 8.18573e-016, 0.05365207> }
        smooth_triangle {<4.3732, 1.62225, -5.11003>, <-1.2034, -3.30031e-016, 0.05254154>,
                         <4.37073, 0.9801517, -5.16673>, <-1.20612, -1.10357e-015, 0.05266025>,
                         <4.45385, 0.6476773, -3.26296>, <-1.31392, -1.66302e-015, 0.05736688> }
        smooth_triangle {<4.45385, 0.6476773, -3.26296>, <-1.32117, -2.36876e-015, 0.05768343>,
                         <4.45662, 1.34124, -3.19949>, <-1.31883, -6.68302e-016, 0.05758134>,
                         <4.3732, 1.62225, -5.11003>, <-1.23828, -1.36902e-015, 0.05406442> }
        smooth_triangle {<4.37073, 0.9801517, -5.16673>, <-1.20612, -1.10357e-015, 0.05266025>,
                         <4.36712, 0.3412813, -5.24935>, <-1.20427, 1.43404e-015, 0.05257966>,
                         <4.44976, -0.04212333, -3.35665>, <-1.31172, 2.25485e-015, 0.05727108> }
        smooth_triangle {<4.44976, -0.04212333, -3.35665>, <-1.31989, 2.8662e-015, 0.05762751>,
                         <4.45385, 0.6476773, -3.26296>, <-1.32153, -7.22079e-017, 0.05769936>,
                         <4.37073, 0.9801517, -5.16673>, <-1.24068, 3.47378e-016, 0.05416939> }
        smooth_triangle {<4.36712, 0.3412813, -5.24935>, <-1.20427, 1.43404e-015, 0.05257966>,
                         <4.36242, -0.2924235, -5.35703>, <-1.19803, -8.95406e-016, 0.0523069>,
                         <4.44439, -0.7258973, -3.4796>, <-1.30412, -3.52727e-016, 0.05693914> }
        smooth_triangle {<4.44439, -0.7258973, -3.4796>, <-1.31342, -4.07226e-016, 0.05734511>,
                         <4.44976, -0.04212333, -3.35665>, <-1.31912, 1.54846e-015, 0.05759406>,
                         <4.36712, 0.3412813, -5.24935>, <-1.23853, 9.32848e-016, 0.0540755> }
        smooth_triangle {<4.36242, -0.2924235, -5.35703>, <-1.19803, -8.95406e-016, 0.0523069>,
                         <4.35638, -0.9168806, -5.49547>, <-1.18452, -4.64906e-016, 0.05171746>,
                         <4.43746, -1.39888, -3.63843>, <-1.2873, -4.54498e-016, 0.05620453> }
        smooth_triangle {<4.43746, -1.39888, -3.63843>, <-1.29855, -3.85542e-016, 0.05669609>,
                         <4.44439, -0.7258973, -3.4796>, <-1.31117, -3.09214e-016, 0.05724705>,
                         <4.36242, -0.2924235, -5.35703>, <-1.2316, -7.16224e-016, 0.05377287> }
        smooth_triangle {<4.35638, -0.9168806, -5.49547>, <-1.18452, -4.64906e-016, 0.05171746>,
                         <4.34855, -1.52365, -5.6748>, <-1.15564, 3.1572e-016, 0.0504562>,
                         <4.42844, -2.05123, -3.84496>, <-1.25116, -2.02963e-016, 0.05462702> }
        smooth_triangle {<4.42844, -2.05123, -3.84496>, <-1.26612, -1.71738e-016, 0.05527993>,
                         <4.43746, -1.39888, -3.63843>, <-1.29322, -3.60389e-016, 0.05646306>,
                         <4.35638, -0.9168806, -5.49547>, <-1.21614, -3.68195e-016, 0.05309776> }
        smooth_triangle {<4.34855, -1.52365, -5.6748>, <-1.15564, 3.1572e-016, 0.0504562>,
                         <4.33834, -2.09546, -5.90852>, <-1.10451, -8.03755e-017, 0.04822375>,

                         <4.41665, -2.6628, -4.11495>, <-1.18801, -4.03612e-016, 0.05186943> }
        smooth_triangle {<4.41665, -2.6628, -4.11495>, <-1.20638, -2.30718e-016, 0.05267181>,
                         <4.42844, -2.05123, -3.84496>, <-1.25375, -8.0231e-017, 0.05474001>,
                         <4.34855, -1.52365, -5.6748>, <-1.18211, 3.08781e-016, 0.05161189> }
        smooth_triangle {<4.33834, -2.09546, -5.90852>, <-1.10451, -8.03755e-017, 0.04822375>,
                         <4.32609, -2.62281, -6.18917>, <-1.04464, 7.8583e-016, 0.04561002>,
                         <4.40247, -3.22249, -4.43969>, <-1.11546, -4.66062e-016, 0.04870211> }
        smooth_triangle {<4.40247, -3.22249, -4.43969>, <-1.13362, -9.84456e-016, 0.0494948>,
                         <4.41665, -2.6628, -4.11495>, <-1.18803, -9.37618e-016, 0.05187029>,
                         <4.33834, -2.09546, -5.90852>, <-1.1254, -6.9519e-016, 0.04913603> }
        smooth_triangle {<4.32609, -2.62281, -6.18917>, <-1.04464, 7.8583e-016, 0.04561002>,
                         <4.31278, -3.11918, -6.49395>, <-0.9990917, -2.91434e-016, 0.04362129>,
                         <4.38707, -3.74604, -4.79258>, <-1.06172, 1.6954e-015, 0.04635589> }
        smooth_triangle {<4.38707, -3.74604, -4.79258>, <-1.07818, 1.57686e-015, 0.04707452>,
                         <4.40247, -3.22249, -4.43969>, <-1.11849, -4.42354e-017, 0.04883418>,
                         <4.32609, -2.62281, -6.18917>, <-1.06537, 8.94684e-016, 0.04651511> }
        smooth_triangle {<4.31278, -3.11918, -6.49395>, <-0.9990917, -2.91434e-016, 0.04362129>,
                         <4.29909, -3.60216, -6.80743>, <-0.9657041, -1.14839e-015, 0.04216355>,
                         <4.37121, -4.25396, -5.15562>, <-1.02871, 4.04191e-016, 0.04491433> }
        smooth_triangle {<4.37121, -4.25396, -5.15562>, <-1.04972, 1.26982e-015, 0.04583177>,
                         <4.38707, -3.74604, -4.79258>, <-1.06923, 2.02182e-015, 0.04668359>,
                         <4.31278, -3.11918, -6.49395>, <-1.02226, 5.31693e-016, 0.04463263> }
        smooth_triangle {<4.26394, 5.13916, -7.6127>, <-0.7785985, 2.08167e-017, 0.03399435>,
                         <4.27369, 4.7011, -7.38933>, <-0.7923823, 2.9259e-016, 0.03459616>,
                         <4.3531, 4.61965, -5.57045>, <-0.8400993, -6.15249e-016, 0.03667953> }
        smooth_triangle {<4.3531, 4.61965, -5.57045>, <-0.8299154, -6.71338e-016, 0.03623489>,
                         <4.34131, 5.07979, -5.84063>, <-0.8105036, -9.64506e-016, 0.03538735>,
                         <4.26394, 5.13916, -7.6127>, <-0.7889812, -4.09395e-016, 0.03444766> }
        smooth_triangle {<4.27369, 4.7011, -7.38933>, <-0.7923823, 2.9259e-016, 0.03459616>,
                         <4.2824, 4.22552, -7.18981>, <-0.8885644, -1.57918e-015, 0.03879556>,
                         <4.36365, 4.11449, -5.32889>, <-0.9537701, 1.02927e-016, 0.0416425> }
        smooth_triangle {<4.36365, 4.11449, -5.32889>, <-0.9401143, -4.77049e-017, 0.04104628>,
                         <4.3531, 4.61965, -5.57045>, <-0.8548612, -5.86337e-016, 0.03732404>,
                         <4.27369, 4.7011, -7.38933>, <-0.8190734, 9.45424e-017, 0.03576152> }
        smooth_triangle {<4.2824, 4.22552, -7.18981>, <-0.8885644, -1.57918e-015, 0.03879556>,
                         <4.28825, 3.68696, -7.05577>, <-1.00009, 2.26006e-015, 0.04366487>,
                         <4.37077, 3.53376, -5.1659>, <-1.08667, 4.68086e-016, 0.04744523> }
        smooth_triangle {<4.37077, 3.53376, -5.1659>, <-1.08066, 4.95047e-016, 0.04718247>,
                         <4.36365, 4.11449, -5.32889>, <-0.980978, 2.21177e-016, 0.04283042>,
                         <4.2824, 4.22552, -7.18981>, <-0.9320738, -1.0404e-015, 0.04069522> }
        smooth_triangle {<4.28825, 3.68696, -7.05577>, <-1.00009, 2.26006e-015, 0.04366487>,
                         <4.29076, 3.10945, -6.99824>, <-1.06583, -6.06069e-017, 0.04653516>,
                         <4.37387, 2.90629, -5.09472>, <-1.16489, -2.19551e-016, 0.05086037> }
        smooth_triangle {<4.37387, 2.90629, -5.09472>, <-1.1674, 4.06494e-016, 0.05096997>,
                         <4.37077, 3.53376, -5.1659>, <-1.10874, 9.22222e-016, 0.04840862>,
                         <4.28825, 3.68696, -7.05577>, <-1.0438, 2.2662e-015, 0.04557335> }
        smooth_triangle {<4.29076, 3.10945, -6.99824>, <-1.06583, -6.06069e-017, 0.04653516>,
                         <4.29111, 2.52087, -6.9904>, <-1.08977, -3.75423e-016, 0.04758059>,
                         <4.37438, 2.26552, -5.08318>, <-1.19327, 8.96418e-016, 0.05209946> }
        smooth_triangle {<4.37438, 2.26552, -5.08318>, <-1.1993, -2.17952e-016, 0.05236242>,
                         <4.37387, 2.90629, -5.09472>, <-1.17801, -1.05493e-015, 0.05143311>,
                         <4.29076, 3.10945, -6.99824>, <-1.10371, -9.35721e-016, 0.0481892> }
        smooth_triangle {<4.29111, 2.52087, -6.9904>, <-1.08977, -3.75423e-016, 0.04758059>,
                         <4.29005, 1.93019, -7.01455>, <-1.09815, -7.11381e-016, 0.04794648>,
                         <4.3732, 1.62225, -5.11003>, <-1.2034, -3.30031e-016, 0.05254154> }
        smooth_triangle {<4.3732, 1.62225, -5.11003>, <-1.21098, 1.15793e-015, 0.05287246>,
                         <4.37438, 2.26552, -5.08318>, <-1.20338, 2.07777e-015, 0.0525409>,
                         <4.29111, 2.52087, -6.9904>, <-1.12576, 1.12388e-015, 0.04915175> }
        smooth_triangle {<4.29005, 1.93019, -7.01455>, <-1.09815, -7.11381e-016, 0.04794648>,
                         <4.28791, 1.3405, -7.06359>, <-1.1001, 6.30283e-017, 0.04803122>,
                         <4.37073, 0.9801517, -5.16673>, <-1.20612, -1.10357e-015, 0.05266025> }
        smooth_triangle {<4.37073, 0.9801517, -5.16673>, <-1.21468, -2.11658e-015, 0.05303389>,
                         <4.3732, 1.62225, -5.11003>, <-1.21264, -1.53642e-015, 0.05294486>,
                         <4.29005, 1.93019, -7.01455>, <-1.1337, -1.82244e-015, 0.04949857> }
        smooth_triangle {<4.28791, 1.3405, -7.06359>, <-1.1001, 6.30283e-017, 0.04803122>,
                         <4.28483, 0.7534884, -7.13421>, <-1.09803, 2.41705e-016, 0.04794105>,
                         <4.36712, 0.3412813, -5.24935>, <-1.20427, 1.43404e-015, 0.05257966> }
        smooth_triangle {<4.36712, 0.3412813, -5.24935>, <-1.21361, 1.6996e-015, 0.05298724>,
                         <4.37073, 0.9801517, -5.16673>, <-1.21499, -2.03613e-016, 0.05304769>,
                         <4.28791, 1.3405, -7.06359>, <-1.13548, 6.71338e-016, 0.04957592> }
        smooth_triangle {<4.28483, 0.7534884, -7.13421>, <-1.09803, 2.41705e-016, 0.04794105>,
                         <4.28083, 0.1707866, -7.22573>, <-1.09218, -1.08912e-015, 0.04768547>,
                         <4.36242, -0.2924235, -5.35703>, <-1.19803, -8.95406e-016, 0.0523069> }
        smooth_triangle {<4.36242, -0.2924235, -5.35703>, <-1.20823, -7.80842e-016, 0.05275239>,
                         <4.36712, 0.3412813, -5.24935>, <-1.21291, 9.66241e-016, 0.05295696>,
                         <4.28483, 0.7534884, -7.13421>, <-1.13323, 7.1991e-017, 0.049478> }
        smooth_triangle {<4.28083, 0.1707866, -7.22573>, <-1.09218, -1.08912e-015, 0.04768547>,
                         <4.27572, -0.404209, -7.34288>, <-1.08027, -7.77734e-017, 0.04716576>,
                         <4.35638, -0.9168806, -5.49547>, <-1.18452, -4.64906e-016, 0.05171746> }
        smooth_triangle {<4.35638, -0.9168806, -5.49547>, <-1.19616, -5.62918e-016, 0.05222529>,
                         <4.36242, -0.2924235, -5.35703>, <-1.20628, -8.85793e-016, 0.05266737>,
                         <4.28083, 0.1707866, -7.22573>, <-1.12689, -1.03108e-015, 0.0492013> }
        smooth_triangle {<4.27572, -0.404209, -7.34288>, <-1.08027, -7.77734e-017, 0.04716576>,
                         <4.26911, -0.9644631, -7.4941>, <-1.05567, -6.95046e-016, 0.0460914>,
                         <4.34855, -1.52365, -5.6748>, <-1.15564, 3.1572e-016, 0.0504562> }
        smooth_triangle {<4.34855, -1.52365, -5.6748>, <-1.16995, 4.98733e-017, 0.05108102>,
                         <4.35638, -0.9168806, -5.49547>, <-1.19161, -5.35596e-016, 0.05202696>,
                         <4.27572, -0.404209, -7.34288>, <-1.11343, -2.45247e-016, 0.04861318> }
        smooth_triangle {<4.26911, -0.9644631, -7.4941>, <-1.05567, -6.95046e-016, 0.0460914>,
                         <4.26053, -1.49559, -7.69065>, <-1.01264, 1.3473e-016, 0.04421267>,
                         <4.33834, -2.09546, -5.90852>, <-1.10451, -8.03755e-017, 0.04822375> }
        smooth_triangle {<4.33834, -2.09546, -5.90852>, <-1.12113, 3.90313e-018, 0.04894952>,
                         <4.34855, -1.52365, -5.6748>, <-1.15948, 3.00975e-016, 0.05062386>,
                         <4.26911, -0.9644631, -7.4941>, <-1.0845, -4.571e-016, 0.04735026> }
        smooth_triangle {<4.26053, -1.49559, -7.69065>, <-1.01264, 1.3473e-016, 0.04421267>,
                         <4.25024, -1.98966, -7.9263>, <-0.961934, 1.19291e-015, 0.04199894>,
                         <4.32609, -2.62281, -6.18917>, <-1.04464, 7.8583e-016, 0.04561002> }
        smooth_triangle {<4.32609, -2.62281, -6.18917>, <-1.06052, 5.75495e-016, 0.0463033>,
                         <4.33834, -2.09546, -5.90852>, <-1.10542, -7.41594e-017, 0.04826361>,
                         <4.26053, -1.49559, -7.69065>, <-1.03652, 8.71699e-017, 0.0452553> }
        smooth_triangle {<4.25024, -1.98966, -7.9263>, <-0.961934, 1.19291e-015, 0.04199894>,
                         <4.23908, -2.45792, -8.18206>, <-0.9222727, -7.56339e-016, 0.04026729>,
                         <4.31278, -3.11918, -6.49395>, <-0.9990917, -2.91434e-016, 0.04362129> }
        smooth_triangle {<4.31278, -3.11918, -6.49395>, <-1.01313, 2.43729e-016, 0.04423406>,
                         <4.32609, -2.62281, -6.18917>, <-1.04729, 1.05168e-015, 0.04572561>,
                         <4.25024, -1.98966, -7.9263>, <-0.9852582, 1.35699e-015, 0.0430173> }
        smooth_triangle {<4.23908, -2.45792, -8.18206>, <-0.9222727, -7.56339e-016, 0.04026729>,
                         <4.22759, -2.91501, -8.44508>, <-0.8899465, -7.5287e-016, 0.0388559>,
                         <4.29909, -3.60216, -6.80743>, <-0.9657041, -1.14839e-015, 0.04216355> }
        smooth_triangle {<4.29909, -3.60216, -6.80743>, <-0.9846749, -1.42941e-015, 0.04299183>,
                         <4.31278, -3.11918, -6.49395>, <-1.00497, -7.16441e-016, 0.04387806>,
                         <4.23908, -2.45792, -8.18206>, <-0.9473587, -1.06512e-015, 0.04136257> }
        smooth_triangle {<4.1866, 5.21845, -9.38401>, <-0.7356843, -4.61436e-016, 0.03212067>,
                         <4.19435, 4.80357, -9.20644>, <-0.7434966, -1.96371e-015, 0.03246176>,
                         <4.27369, 4.7011, -7.38933>, <-0.7923823, 2.9259e-016, 0.03459616> }
        smooth_triangle {<4.27369, 4.7011, -7.38933>, <-0.7838465, 2.15973e-016, 0.03422348>,
                         <4.26394, 5.13916, -7.6127>, <-0.7684188, 3.46945e-018, 0.03354989>,
                         <4.1866, 5.21845, -9.38401>, <-0.7469617, -2.37657e-016, 0.03261305> }
        smooth_triangle {<4.19435, 4.80357, -9.20644>, <-0.7434966, -1.96371e-015, 0.03246176>,
                         <4.20127, 4.35868, -9.04795>, <-0.8211693, 4.33681e-016, 0.03585302>,
                         <4.2824, 4.22552, -7.18981>, <-0.8885644, -1.57918e-015, 0.03879556> }
        smooth_triangle {<4.2824, 4.22552, -7.18981>, <-0.8773561, -9.25041e-016, 0.03830619>,
                         <4.27369, 4.7011, -7.38933>, <-0.8052195, 4.78784e-016, 0.03515664>,
                         <4.19435, 4.80357, -9.20644>, <-0.7685553, -1.21344e-015, 0.03355585> }
        smooth_triangle {<4.20127, 4.35868, -9.04795>, <-0.8211693, 4.33681e-016, 0.03585302>,
                         <4.2059, 3.8634, -8.94184>, <-0.9097283, 1.28601e-015, 0.03971959>,
                         <4.28825, 3.68696, -7.05577>, <-1.00009, 2.26006e-015, 0.04366487> }
        smooth_triangle {<4.28825, 3.68696, -7.05577>, <-0.9957833, 1.41445e-015, 0.04347684>,
                         <4.2824, 4.22552, -7.18981>, <-0.9121391, -1.46497e-015, 0.03982485>,
                         <4.20127, 4.35868, -9.04795>, <-0.8615927, 4.46691e-017, 0.03761795> }
        smooth_triangle {<4.2059, 3.8634, -8.94184>, <-0.9097283, 1.28601e-015, 0.03971959>,
                         <4.20786, 3.33697, -8.89694>, <-0.9614737, -6.31114e-016, 0.04197885>,
                         <4.29076, 3.10945, -6.99824>, <-1.06583, -6.06069e-017, 0.04653516> }
        smooth_triangle {<4.29076, 3.10945, -6.99824>, <-1.06914, 1.39076e-016, 0.04667964>,
                         <4.28825, 3.68696, -7.05577>, <-1.01983, 1.87957e-015, 0.04452693>,
                         <4.2059, 3.8634, -8.94184>, <-0.952063, 1.14904e-015, 0.04156797> }
        smooth_triangle {<4.20786, 3.33697, -8.89694>, <-0.9614737, -6.31114e-016, 0.04197885>,
                         <4.20809, 2.80167, -8.89179>, <-0.9800105, 1.10536e-015, 0.04278818>,
                         <4.29111, 2.52087, -6.9904>, <-1.08977, -3.75423e-016, 0.04758059> }
        smooth_triangle {<4.29111, 2.52087, -6.9904>, <-1.09627, -1.33926e-016, 0.04786432>,
                         <4.29076, 3.10945, -6.99824>, <-1.07832, 1.02186e-016, 0.04708025>,
                         <4.20786, 3.33697, -8.89694>, <-1.00005, -3.25694e-016, 0.04366302> }
        smooth_triangle {<4.20809, 2.80167, -8.89179>, <-0.9800105, 1.10536e-015, 0.04278818>,
                         <4.2072, 2.26471, -8.91224>, <-0.9860048, -1.38525e-015, 0.0430499>,
                         <4.29005, 1.93019, -7.01455>, <-1.09815, -7.11381e-016, 0.04794648> }
        smooth_triangle {<4.29005, 1.93019, -7.01455>, <-1.10609, -8.94142e-016, 0.04829287>,
                         <4.29111, 2.52087, -6.9904>, <-1.0998, -6.42173e-016, 0.04801845>,
                         <4.20809, 2.80167, -8.89179>, <-1.01748, 4.68416e-016, 0.04442414> }
        smooth_triangle {<4.2072, 2.26471, -8.91224>, <-0.9860048, -1.38525e-015, 0.0430499>,
                         <4.20543, 1.72852, -8.9526>, <-0.986682, -3.21502e-016, 0.04307947>,
                         <4.28791, 1.3405, -7.06359>, <-1.1001, 6.30283e-017, 0.04803122> }
        smooth_triangle {<4.28791, 1.3405, -7.06359>, <-1.10894, -1.21647e-016, 0.04841723>,
                         <4.29005, 1.93019, -7.01455>, <-1.10748, -7.02455e-016, 0.04835368>,
                         <4.2072, 2.26471, -8.91224>, <-1.02337, -1.20786e-015, 0.04468124> }
        smooth_triangle {<4.20543, 1.72852, -8.9526>, <-0.986682, -3.21502e-016, 0.04307947>,
                         <4.20292, 1.19449, -9.01022>, <-0.9839994, -2.16985e-016, 0.04296234>,
                         <4.28483, 0.7534884, -7.13421>, <-1.09803, 2.41705e-016, 0.04794105> }
        smooth_triangle {<4.28483, 0.7534884, -7.13421>, <-1.10759, 6.77843e-016, 0.04835839>,
                         <4.28791, 1.3405, -7.06359>, <-1.10914, 5.43836e-016, 0.04842602>,
                         <4.20543, 1.72852, -8.9526>, <-1.02408, 2.55438e-016, 0.0447122> }
        smooth_triangle {<4.20292, 1.19449, -9.01022>, <-0.9839994, -2.16985e-016, 0.04296234>,
                         <4.19967, 0.6639034, -9.08456>, <-0.9781737, -5.64942e-016, 0.04270798>,
                         <4.28083, 0.1707866, -7.22573>, <-1.09218, -1.08912e-015, 0.04768547> }
        smooth_triangle {<4.28083, 0.1707866, -7.22573>, <-1.10251, -1.22471e-015, 0.04813669>,
                         <4.28483, 0.7534884, -7.13421>, <-1.1069, -2.26598e-016, 0.04832837>,
                         <4.20292, 1.19449, -9.01022>, <-1.02138, -5.70616e-016, 0.04459434> }
        smooth_triangle {<4.19967, 0.6639034, -9.08456>, <-0.9781737, -5.64942e-016, 0.04270798>,
                         <4.19553, 0.1394801, -9.17941>, <-0.9674706, -8.81529e-016, 0.04224068>,
                         <4.27572, -0.404209, -7.34288>, <-1.08027, -7.77734e-017, 0.04716576> }
        smooth_triangle {<4.27572, -0.404209, -7.34288>, <-1.09185, -8.6953e-017, 0.04767129>,
                         <4.28083, 0.1707866, -7.22573>, <-1.10078, -8.45461e-016, 0.04806107>,
                         <4.19967, 0.6639034, -9.08456>, <-1.01528, -4.52329e-016, 0.04432796> }
        smooth_triangle {<4.19553, 0.1394801, -9.17941>, <-0.9674706, -8.81529e-016, 0.04224068>,
                         <4.1902, -0.37315, -9.30151>, <-0.9466839, 1.24322e-016, 0.04133311>,
                         <4.26911, -0.9644631, -7.4941>, <-1.05567, -6.95046e-016, 0.0460914> }
        smooth_triangle {<4.26911, -0.9644631, -7.4941>, <-1.06953, -2.73653e-016, 0.04669687>,
                         <4.27572, -0.404209, -7.34288>, <-1.08799, 1.89302e-016, 0.04750264>,
                         <4.19553, 0.1394801, -9.17941>, <-1.00339, -4.13515e-016, 0.04380883> }
        smooth_triangle {<4.1902, -0.37315, -9.30151>, <-0.9466839, 1.24322e-016, 0.04133311>,
                         <4.18329, -0.8624777, -9.45987>, <-0.911316, 2.1048e-016, 0.03978891>,
                         <4.26053, -1.49559, -7.69065>, <-1.01264, 1.3473e-016, 0.04421267> }
        smooth_triangle {<4.26053, -1.49559, -7.69065>, <-1.02852, 3.68629e-017, 0.04490634>,
                         <4.26911, -0.9644631, -7.4941>, <-1.0608, -5.85469e-016, 0.04631538>,
                         <4.1902, -0.37315, -9.30151>, <-0.9790596, 2.90566e-017, 0.04274667> }
        smooth_triangle {<4.18329, -0.8624777, -9.45987>, <-0.911316, 2.1048e-016, 0.03978891>,
                         <4.17501, -1.32216, -9.64952>, <-0.8695602, 1.90588e-015, 0.03796582>,
                         <4.25024, -1.98966, -7.9263>, <-0.961934, 1.19291e-015, 0.04199894> }
        smooth_triangle {<4.25024, -1.98966, -7.9263>, <-0.9772808, 1.25811e-015, 0.042669>,
                         <4.26053, -1.49559, -7.69065>, <-1.01531, 4.64472e-016, 0.0443293>,
                         <4.18329, -0.8624777, -9.45987>, <-0.9393173, 5.21284e-016, 0.04101148> }
        smooth_triangle {<4.17501, -1.32216, -9.64952>, <-0.8695602, 1.90588e-015, 0.03796582>,
                         <4.16602, -1.7612, -9.85526>, <-0.8358208, -7.22801e-016, 0.03649272>,
                         <4.23908, -2.45792, -8.18206>, <-0.9222727, -7.56339e-016, 0.04026729> }
        smooth_triangle {<4.23908, -2.45792, -8.18206>, <-0.9361122, -8.88178e-016, 0.04087154>,
                         <4.25024, -1.98966, -7.9263>, <-0.9658582, 5.7376e-016, 0.04217028>,
                         <4.17501, -1.32216, -9.64952>, <-0.8965778, 1.10849e-015, 0.03914543> }
        smooth_triangle {<4.16602, -1.7612, -9.85526>, <-0.8358208, -7.22801e-016, 0.03649272>,
                         <4.15679, -2.1913, -10.0668>, <-0.8029537, -1.1189e-016, 0.03505771>,
                         <4.22759, -2.91501, -8.44508>, <-0.8899465, -7.5287e-016, 0.0388559> }
        smooth_triangle {<4.22759, -2.91501, -8.44508>, <-0.9093176, -7.79469e-016, 0.03970166>,
                         <4.23908, -2.45792, -8.18206>, <-0.9287194, -7.75421e-016, 0.04054877>,
                         <4.16602, -1.7612, -9.85526>, <-0.8638805, -7.50268e-016, 0.03771784> }
        smooth_triangle {<4.10923, 5.26135, -11.1561>, <-0.6892452, 1.9082e-017, 0.03009309>,
                         <4.11507, 4.87641, -11.0223>, <-0.6839857, 2.48644e-016, 0.02986346>,
                         <4.19435, 4.80357, -9.20644>, <-0.7434966, -1.96371e-015, 0.03246176> }
        smooth_triangle {<4.19435, 4.80357, -9.20644>, <-0.739523, -1.68181e-015, 0.03228827>,
                         <4.1866, 5.21845, -9.38401>, <-0.7316432, -6.48787e-016, 0.03194423>,
                         <4.10923, 5.26135, -11.1561>, <-0.7084236, -4.08527e-016, 0.03093044> }
        smooth_triangle {<4.11507, 4.87641, -11.0223>, <-0.6839857, 2.48644e-016, 0.02986346>,
                         <4.12029, 4.46896, -10.9027>, <-0.7405986, -8.22837e-016, 0.03233523>,
                         <4.20127, 4.35868, -9.04795>, <-0.8211693, 4.33681e-016, 0.03585302> }
        smooth_triangle {<4.20127, 4.35868, -9.04795>, <-0.8149535, -9.51496e-016, 0.03558164>,
                         <4.19435, 4.80357, -9.20644>, <-0.7566991, -2.74954e-015, 0.03303819>,
                         <4.11507, 4.87641, -11.0223>, <-0.7120658, -1.09027e-015, 0.03108947> }
        smooth_triangle {<4.12029, 4.46896, -10.9027>, <-0.7405986, -8.22837e-016, 0.03233523>,
                         <4.12379, 4.02372, -10.8225>, <-0.8024468, 1.01337e-015, 0.03503558>,
                         <4.2059, 3.8634, -8.94184>, <-0.9097283, 1.28601e-015, 0.03971959> }
        smooth_triangle {<4.2059, 3.8634, -8.94184>, <-0.9090279, 2.61423e-015, 0.03968901>,
                         <4.20127, 4.35868, -9.04795>, <-0.8426086, 1.97498e-015, 0.03678909>,
                         <4.12029, 4.46896, -10.9027>, <-0.7821806, 1.03259e-015, 0.03415074> }
        smooth_triangle {<4.12379, 4.02372, -10.8225>, <-0.8024468, 1.01337e-015, 0.03503558>,
                         <4.12529, 3.55512, -10.7881>, <-0.836914, 8.33119e-016, 0.03654046>,
                         <4.20786, 3.33697, -8.89694>, <-0.9614737, -6.31114e-016, 0.04197885> }
        smooth_triangle {<4.20786, 3.33697, -8.89694>, <-0.9668139, -8.74707e-016, 0.042212>,
                         <4.2059, 3.8634, -8.94184>, <-0.9280048, 5.63135e-016, 0.04051756>,
                         <4.12379, 4.02372, -10.8225>, <-0.8475437, 3.58654e-016, 0.03700456> }
        smooth_triangle {<4.12529, 3.55512, -10.7881>, <-0.836914, 8.33119e-016, 0.03654046>,
                         <4.12549, 3.07986, -10.7836>, <-0.8482263, 5.53612e-016, 0.03703436>,
                         <4.20809, 2.80167, -8.89179>, <-0.9800105, 1.10536e-015, 0.04278818> }
        smooth_triangle {<4.20809, 2.80167, -8.89179>, <-0.9878149, 7.49726e-016, 0.04312893>,
                         <4.20786, 3.33697, -8.89694>, <-0.9739123, -5.52631e-016, 0.04252193>,
                         <4.12529, 3.55512, -10.7881>, <-0.8804925, 5.45543e-016, 0.03844313> }
        smooth_triangle {<4.12549, 3.07986, -10.7836>, <-0.8482263, 5.53612e-016, 0.03703436>,
                         <4.12485, 2.60336, -10.7983>, <-0.850894, -2.36078e-015, 0.03715083>,
                         <4.2072, 2.26471, -8.91224>, <-0.9860048, -1.38525e-015, 0.0430499> }
        smooth_triangle {<4.2072, 2.26471, -8.91224>, <-0.9948848, -1.034e-015, 0.04343761>,
                         <4.20809, 2.80167, -8.89179>, <-0.9903891, 8.33955e-016, 0.04324132>,
                         <4.12549, 3.07986, -10.7836>, <-0.8915509, 4.20142e-016, 0.03892595> }
        smooth_triangle {<4.12485, 2.60336, -10.7983>, <-0.850894, -2.36078e-015, 0.03715083>,
                         <4.12356, 2.12744, -10.8278>, <-0.8497954, 1.38633e-016, 0.03710287>,
                         <4.20543, 1.72852, -8.9526>, <-0.986682, -3.21502e-016, 0.04307947> }
        smooth_triangle {<4.20543, 1.72852, -8.9526>, <-0.99624, -4.77483e-016, 0.04349678>,
                         <4.2072, 2.26471, -8.91224>, <-0.9957321, -1.27529e-015, 0.0434746>,
                         <4.12485, 2.60336, -10.7983>, <-0.894399, -2.00694e-015, 0.0390503> }
        smooth_triangle {<4.12356, 2.12744, -10.8278>, <-0.8497954, 1.38633e-016, 0.03710287>,
                         <4.1217, 1.65313, -10.8704>, <-0.8462449, 9.90238e-017, 0.03694785>,
                         <4.20292, 1.19449, -9.01022>, <-0.9839994, -2.16985e-016, 0.04296234> }
        smooth_triangle {<4.20292, 1.19449, -9.01022>, <-0.9941075, -2.74303e-017, 0.04340367>,
                         <4.20543, 1.72852, -8.9526>, <-0.9961195, -1.05818e-016, 0.04349151>,
                         <4.12356, 2.12744, -10.8278>, <-0.8934545, 2.39283e-016, 0.03900907> }
        smooth_triangle {<4.1217, 1.65313, -10.8704>, <-0.8462449, 9.90238e-017, 0.03694785>,
                         <4.1193, 1.18141, -10.9255>, <-0.8403537, 7.74265e-016, 0.03669063>,
                         <4.19967, 0.6639034, -9.08456>, <-0.9781737, -5.64942e-016, 0.04270798> }
        smooth_triangle {<4.19967, 0.6639034, -9.08456>, <-0.9889003, -7.3639e-016, 0.04317632>,
                         <4.20292, 1.19449, -9.01022>, <-0.9932696, -4.75423e-016, 0.04336708>,
                         <4.1217, 1.65313, -10.8704>, <-0.8899537, -2.38416e-016, 0.03885622> }
        smooth_triangle {<4.1193, 1.18141, -10.9255>, <-0.8403537, 7.74265e-016, 0.03669063>,
                         <4.11622, 0.7143069, -10.9959>, <-0.8307973, -2.24502e-016, 0.03627339>,
                         <4.19553, 0.1394801, -9.17941>, <-0.9674706, -8.81529e-016, 0.04224068> }
        smooth_triangle {<4.19553, 0.1394801, -9.17941>, <-0.9792271, -8.27463e-016, 0.04275398>,
                         <4.19967, 0.6639034, -9.08456>, <-0.9872544, -5.90023e-016, 0.04310446>,
                         <4.1193, 1.18141, -10.9255>, <-0.8838894, 4.14382e-016, 0.03859144> }
        smooth_triangle {<4.11622, 0.7143069, -10.9959>, <-0.8307973, -2.24502e-016, 0.03627339>,
                         <4.11225, 0.2560521, -11.0868>, <-0.8137914, -6.3115e-016, 0.0355309>,
                         <4.1902, -0.37315, -9.30151>, <-0.9466839, 1.24322e-016, 0.04133311> }
        smooth_triangle {<4.1902, -0.37315, -9.30151>, <-0.96036, -4.44957e-016, 0.04193022>,
                         <4.19553, 0.1394801, -9.17941>, <-0.97595, -1.19934e-015, 0.0426109>,
                         <4.11622, 0.7143069, -10.9959>, <-0.8734451, -7.06575e-016, 0.03813544> }
        smooth_triangle {<4.11225, 0.2560521, -11.0868>, <-0.8137914, -6.3115e-016, 0.0355309>,
                         <4.1071, -0.1847258, -11.2049>, <-0.7860783, -1.18597e-015, 0.03432092>,
                         <4.18329, -0.8624777, -9.45987>, <-0.911316, 2.1048e-016, 0.03978891> }
        smooth_triangle {<4.18329, -0.8624777, -9.45987>, <-0.9267998, 1.43115e-016, 0.04046495>,
                         <4.1902, -0.37315, -9.30151>, <-0.9533258, 7.84962e-017, 0.0416231>,
                         <4.11225, 0.2560521, -11.0868>, <-0.8536564, -4.88108e-016, 0.03727144> }
        smooth_triangle {<4.1071, -0.1847258, -11.2049>, <-0.7860783, -1.18597e-015, 0.03432092>,
                         <4.10092, -0.6032723, -11.3465>, <-0.7536198, 1.44531e-015, 0.03290375>,
                         <4.17501, -1.32216, -9.64952>, <-0.8695602, 1.90588e-015, 0.03796582> }
        smooth_triangle {<4.17501, -1.32216, -9.64952>, <-0.8848473, 2.43859e-015, 0.03863327>,
                         <4.18329, -0.8624777, -9.45987>, <-0.9161641, 1.16704e-015, 0.04000059>,
                         <4.1071, -0.1847258, -11.2049>, <-0.8222359, 1.19696e-016, 0.03589959> }
        smooth_triangle {<4.10092, -0.6032723, -11.3465>, <-0.7536198, 1.44531e-015, 0.03290375>,
                         <4.09421, -1.00633, -11.5001>, <-0.726673, 4.74158e-017, 0.03172723>,
                         <4.16602, -1.7612, -9.85526>, <-0.8358208, -7.22801e-016, 0.03649272> }
        smooth_triangle {<4.16602, -1.7612, -9.85526>, <-0.8500963, -5.61617e-016, 0.03711601>,
                         <4.17501, -1.32216, -9.64952>, <-0.8754008, 1.4099e-015, 0.03822082>,
                         <4.10092, -0.6032723, -11.3465>, <-0.7884456, 1.06447e-015, 0.03442428> }
        smooth_triangle {<4.09421, -1.00633, -11.5001>, <-0.726673, 4.74158e-017, 0.03172723>,
                         <4.08731, -1.40269, -11.6581>, <-0.6916482, -1.32446e-015, 0.03019801>,
                         <4.15679, -2.1913, -10.0668>, <-0.8029537, -1.1189e-016, 0.03505771> }
        smooth_triangle {<4.15679, -2.1913, -10.0668>, <-0.8243494, -1.65377e-016, 0.03599187>,
                         <4.16602, -1.7612, -9.85526>, <-0.8436508, -6.10189e-016, 0.03683459>,
                         <4.09421, -1.00633, -11.5001>, <-0.7617899, -3.25261e-017, 0.03326047> }
        smooth_triangle {<4.03259, 5.03593, -12.9115>, <-0.6201613, 6.62664e-016, 0.02707683>,
                         <4.0365, 4.70009, -12.8218>, <-0.5856592, -7.16007e-016, 0.02557043>,
                         <4.11507, 4.87641, -11.0223>, <-0.6839857, 2.48644e-016, 0.02986346> }
        smooth_triangle {<4.11507, 4.87641, -11.0223>, <-0.6894582, 1.88217e-016, 0.0301024>,
                         <4.10923, 5.26135, -11.1561>, <-0.6975606, 1.30104e-017, 0.03045615>,
                         <4.03259, 5.03593, -12.9115>, <-0.6630186, 3.34802e-016, 0.02894802> }
        smooth_triangle {<4.0365, 4.70009, -12.8218>, <-0.5856592, -7.16007e-016, 0.02557043>,
                         <4.04, 4.34924, -12.7417>, <-0.6200881, 2.22074e-015, 0.02707363>,
                         <4.12029, 4.46896, -10.9027>, <-0.7405986, -8.22837e-016, 0.03233523> }
        smooth_triangle {<4.12029, 4.46896, -10.9027>, <-0.7440233, -6.70904e-016, 0.03248476>,
                         <4.11507, 4.87641, -11.0223>, <-0.7015636, 1.32706e-016, 0.03063093>,
                         <4.0365, 4.70009, -12.8218>, <-0.6278187, -5.90782e-016, 0.02741116> }
        smooth_triangle {<4.04, 4.34924, -12.7417>, <-0.6200881, 2.22074e-015, 0.02707363>,
                         <4.04235, 3.97321, -12.6878>, <-0.6544417, 1.90097e-016, 0.02857354>,
                         <4.12379, 4.02372, -10.8225>, <-0.8024468, 1.01337e-015, 0.03503558> }
        smooth_triangle {<4.12379, 4.02372, -10.8225>, <-0.808931, 4.56883e-016, 0.03531869>,
                         <4.12029, 4.46896, -10.9027>, <-0.7625448, -9.20271e-016, 0.03329343>,
                         <4.04, 4.34924, -12.7417>, <-0.6721619, 1.36241e-015, 0.02934722> }
        smooth_triangle {<4.04235, 3.97321, -12.6878>, <-0.6544417, 1.90097e-016, 0.02857354>,
                         <4.04337, 3.58159, -12.6645>, <-0.6717688, 1.1897e-015, 0.02933006>,
                         <4.12529, 3.55512, -10.7881>, <-0.836914, 8.33119e-016, 0.03654046> }
        smooth_triangle {<4.12529, 3.55512, -10.7881>, <-0.8466422, 6.3232e-016, 0.0369652>,
                         <4.12379, 4.02372, -10.8225>, <-0.8207917, 7.67507e-016, 0.03583654>,
                         <4.04235, 3.97321, -12.6878>, <-0.709788, 1.50054e-016, 0.03099001> }
        smooth_triangle {<4.04337, 3.58159, -12.6645>, <-0.6717688, 1.1897e-015, 0.02933006>,
                         <4.04352, 3.18555, -12.661>, <-0.6763862, -1.3149e-015, 0.02953166>,
                         <4.12549, 3.07986, -10.7836>, <-0.8482263, 5.53612e-016, 0.03703436> }
        smooth_triangle {<4.12549, 3.07986, -10.7836>, <-0.8590738, 1.31145e-015, 0.03750797>,
                         <4.12529, 3.55512, -10.7881>, <-0.8505896, 1.52108e-015, 0.03713754>,
                         <4.04337, 3.58159, -12.6645>, <-0.7267307, 1.78851e-015, 0.03172975> }
        smooth_triangle {<4.04352, 3.18555, -12.661>, <-0.6763862, -1.3149e-015, 0.02953166>,
                         <4.04311, 2.78866, -12.6704>, <-0.676419, -8.44232e-017, 0.02953309>,
                         <4.12485, 2.60336, -10.7983>, <-0.850894, -2.36078e-015, 0.03715083> }
        smooth_triangle {<4.12485, 2.60336, -10.7983>, <-0.8622097, -2.56042e-015, 0.03764489>,
                         <4.12549, 3.07986, -10.7836>, <-0.8602089, -3.74633e-016, 0.03755753>,
                         <4.04352, 3.18555, -12.661>, <-0.7313288, -1.77602e-015, 0.03193051> }
        smooth_triangle {<4.04311, 2.78866, -12.6704>, <-0.676419, -8.44232e-017, 0.02953309>,
                         <4.04227, 2.39217, -12.6897>, <-0.6743368, -5.04226e-016, 0.02944218>,
                         <4.12356, 2.12744, -10.8278>, <-0.8497954, 1.38633e-016, 0.03710287> }
        smooth_triangle {<4.12356, 2.12744, -10.8278>, <-0.861462, -1.48536e-017, 0.03761224>,
                         <4.12485, 2.60336, -10.7983>, <-0.8622859, -1.88941e-015, 0.03764822>,
                         <4.04311, 2.78866, -12.6704>, <-0.7314297, -1.82146e-016, 0.03193491> }
        smooth_triangle {<4.04227, 2.39217, -12.6897>, <-0.6743368, -5.04226e-016, 0.02944218>,
                         <4.04105, 1.99676, -12.7176>, <-0.6707582, 1.51651e-015, 0.02928593>,
                         <4.1217, 1.65313, -10.8704>, <-0.8462449, 9.90238e-017, 0.03694785> }
        smooth_triangle {<4.1217, 1.65313, -10.8704>, <-0.8582702, 9.93129e-017, 0.03747288>,
                         <4.12356, 2.12744, -10.8278>, <-0.860933, 1.2902e-016, 0.03758915>,
                         <4.04227, 2.39217, -12.6897>, <-0.729339, -3.53125e-016, 0.03184363> }
        smooth_triangle {<4.04105, 1.99676, -12.7176>, <-0.6707582, 1.51651e-015, 0.02928593>,
                         <4.03946, 1.60306, -12.7539>, <-0.6655796, 1.31116e-016, 0.02905983>,
                         <4.1193, 1.18141, -10.9255>, <-0.8403537, 7.74265e-016, 0.03669063> }
        smooth_triangle {<4.1193, 1.18141, -10.9255>, <-0.852844, 6.41848e-016, 0.03723597>,
                         <4.1217, 1.65313, -10.8704>, <-0.8572625, 1.35417e-016, 0.03742889>,
                         <4.04105, 1.99676, -12.7176>, <-0.7256474, 1.19853e-015, 0.03168245> }
        smooth_triangle {<4.03946, 1.60306, -12.7539>, <-0.6655796, 1.31116e-016, 0.02905983>,
                         <4.03743, 1.21245, -12.8005>, <-0.657787, -1.2782e-015, 0.0287196>,
                         <4.11622, 0.7143069, -10.9959>, <-0.8307973, -2.24502e-016, 0.03627339> }
        smooth_triangle {<4.11622, 0.7143069, -10.9959>, <-0.844044, -2.22587e-016, 0.03685176>,
                         <4.1193, 1.18141, -10.9255>, <-0.8512113, 5.26489e-016, 0.03716469>,
                         <4.03946, 1.60306, -12.7539>, <-0.7201307, 4.4127e-017, 0.03144159> }
        smooth_triangle {<4.03743, 1.21245, -12.8005>, <-0.657787, -1.2782e-015, 0.0287196>,
                         <4.0348, 0.8277403, -12.8607>, <-0.6448961, -1.24495e-015, 0.02815677>,
                         <4.11225, 0.2560521, -11.0868>, <-0.8137914, -6.3115e-016, 0.0355309> }
        smooth_triangle {<4.11225, 0.2560521, -11.0868>, <-0.828401, 3.46945e-018, 0.03616877>,
                         <4.11622, 0.7143069, -10.9959>, <-0.8411554, 3.08456e-016, 0.03672564>,
                         <4.03743, 1.21245, -12.8005>, <-0.7113977, -4.81819e-016, 0.03106029> }
        smooth_triangle {<4.0348, 0.8277403, -12.8607>, <-0.6448961, -1.24495e-015, 0.02815677>,
                         <4.03139, 0.4546776, -12.939>, <-0.6251066, 1.32258e-015, 0.02729275>,
                         <4.1071, -0.1847258, -11.2049>, <-0.7860783, -1.18597e-015, 0.03432092> }
        smooth_triangle {<4.1071, -0.1847258, -11.2049>, <-0.8019057, -1.85355e-015, 0.03501196>,
                         <4.11225, 0.2560521, -11.0868>, <-0.8226906, -1.43744e-015, 0.03591945>,
                         <4.0348, 0.8277403, -12.8607>, <-0.6960191, -1.89779e-015, 0.03038885> }
        smooth_triangle {<4.03139, 0.4546776, -12.939>, <-0.6251066, 1.32258e-015, 0.02729275>,
                         <4.02728, 0.09643594, -13.0329>, <-0.6025598, 4.92372e-016, 0.02630833>,
                         <4.10092, -0.6032723, -11.3465>, <-0.7536198, 1.44531e-015, 0.03290375> }
        smooth_triangle {<4.10092, -0.6032723, -11.3465>, <-0.7692895, 1.59399e-015, 0.0335879>,
                         <4.1071, -0.1847258, -11.2049>, <-0.7936333, -3.79471e-016, 0.03465078>,
                         <4.03139, 0.4546776, -12.939>, <-0.6729046, 1.50195e-015, 0.02937965> }
        smooth_triangle {<4.02728, 0.09643594, -13.0329>, <-0.6025598, 4.92372e-016, 0.02630833>,
                         <4.02283, -0.2514787, -13.1349>, <-0.5835224, -9.08417e-016, 0.02547714>,
                         <4.09421, -1.00633, -11.5001>, <-0.726673, 4.74158e-017, 0.03172723> }
        smooth_triangle {<4.09421, -1.00633, -11.5001>, <-0.7418122, -3.16587e-016, 0.03238822>,
                         <4.10092, -0.6032723, -11.3465>, <-0.7620224, 7.31836e-016, 0.03327062>,
                         <4.02728, 0.09643594, -13.0329>, <-0.6487273, 1.71304e-017, 0.02832405> }
        smooth_triangle {<4.02283, -0.2514787, -13.1349>, <-0.5835224, -9.08417e-016, 0.02547714>,
                         <4.01825, -0.5949286, -13.2398>, <-0.546284, -7.37257e-017, 0.02385128>,
                         <4.08731, -1.40269, -11.6581>, <-0.6916482, -1.32446e-015, 0.03019801> }
        smooth_triangle {<4.08731, -1.40269, -11.6581>, <-0.7168424, -8.76614e-016, 0.03129801>,
                         <4.09421, -1.00633, -11.5001>, <-0.7368124, 4.03323e-017, 0.03216993>,
                         <4.02283, -0.2514787, -13.1349>, <-0.6294495, -6.76542e-016, 0.02748236> }
        smooth_triangle {<3.95833, 4.5363, -14.6123>, <-0.4820363, -1.60852e-015, 0.02104616>,
                         <3.96023, 4.27106, -14.5687>, <-0.4325359, 6.0007e-016, 0.01888493>,
                         <4.0365, 4.70009, -12.8218>, <-0.5856592, -7.16007e-016, 0.02557043> }
        smooth_triangle {<4.0365, 4.70009, -12.8218>, <-0.5932426, -2.99999e-016, 0.02590153>,
                         <4.03259, 5.03593, -12.9115>, <-0.6180771, 8.05345e-016, 0.02698583>,
                         <3.95833, 4.5363, -14.6123>, <-0.5490146, -3.30248e-016, 0.02397049> }
        smooth_triangle {<3.96023, 4.27106, -14.5687>, <-0.4325359, 6.0007e-016, 0.01888493>,
                         <3.96192, 3.99832, -14.53>, <-0.4492175, 1.83447e-016, 0.01961326>,
                         <4.04, 4.34924, -12.7417>, <-0.6200881, 2.22074e-015, 0.02707363> }
        smooth_triangle {<4.04, 4.34924, -12.7417>, <-0.6268828, 1.43462e-015, 0.02737029>,
                         <4.0365, 4.70009, -12.8218>, <-0.6010611, -7.6794e-016, 0.02624289>,
                         <3.96023, 4.27106, -14.5687>, <-0.4862187, 2.19117e-016, 0.02122876> }
        smooth_triangle {<3.96192, 3.99832, -14.53>, <-0.4492175, 1.83447e-016, 0.01961326>,
                         <3.96304, 3.71298, -14.5043>, <-0.4629796, 1.7705e-016, 0.02021412>,
                         <4.04235, 3.97321, -12.6878>, <-0.6544417, 1.90097e-016, 0.02857354> }
        smooth_triangle {<4.04235, 3.97321, -12.6878>, <-0.6636742, 1.24174e-015, 0.02897664>,
                         <4.04, 4.34924, -12.7417>, <-0.6379089, 2.76472e-015, 0.02785171>,
                         <3.96192, 3.99832, -14.53>, <-0.509756, 1.23675e-015, 0.02225643> }
        smooth_triangle {<3.96304, 3.71298, -14.5043>, <-0.4629796, 1.7705e-016, 0.02021412>,
                         <3.9635, 3.41986, -14.4939>, <-0.4690202, 5.69441e-016, 0.02047786>,
                         <4.04337, 3.58159, -12.6645>, <-0.6717688, 1.1897e-015, 0.02933006> }
        smooth_triangle {<4.04337, 3.58159, -12.6645>, <-0.6831856, 6.37484e-016, 0.02982853>,
                         <4.04235, 3.97321, -12.6878>, <-0.6701903, -1.12215e-016, 0.02926114>,
                         <3.96304, 3.71298, -14.5043>, <-0.5265936, -1.22e-016, 0.02299157> }
        smooth_triangle {<3.9635, 3.41986, -14.4939>, <-0.4690202, 5.69441e-016, 0.02047786>,
                         <3.96352, 3.12451, -14.4935>, <-0.4701338, 2.7649e-016, 0.02052648>,
                         <4.04352, 3.18555, -12.661>, <-0.6763862, -1.3149e-015, 0.02953166> }
        smooth_triangle {<4.04352, 3.18555, -12.661>, <-0.6885647, -6.90054e-016, 0.03006339>,
                         <4.04337, 3.58159, -12.6645>, <-0.6851017, 1.18839e-015, 0.02991219>,
                         <3.9635, 3.41986, -14.4939>, <-0.5330403, 7.23204e-016, 0.02327304> }
        smooth_triangle {<3.96352, 3.12451, -14.4935>, <-0.4701338, 2.7649e-016, 0.02052648>,
                         <3.96326, 2.82875, -14.4994>, <-0.4692513, 1.44452e-016, 0.02048795>,
                         <4.04311, 2.78866, -12.6704>, <-0.676419, -8.44232e-017, 0.02953309> }
        smooth_triangle {<4.04311, 2.78866, -12.6704>, <-0.6889869, -9.15121e-016, 0.03008182>,
                         <4.04352, 3.18555, -12.661>, <-0.6889623, -1.83798e-015, 0.03008074>,
                         <3.96352, 3.12451, -14.4935>, <-0.534273, -6.44436e-016, 0.02332686> }
        smooth_triangle {<3.96326, 2.82875, -14.4994>, <-0.4692513, 1.44452e-016, 0.02048795>,
                         <3.96278, 2.53318, -14.5104>, <-0.4672142, 1.46946e-016, 0.02039901>,
                         <4.04227, 2.39217, -12.6897>, <-0.6743368, -5.04226e-016, 0.02944218> }
        smooth_triangle {<4.04227, 2.39217, -12.6897>, <-0.687245, -2.2302e-016, 0.03000576>,
                         <4.04311, 2.78866, -12.6704>, <-0.6888066, 9.18319e-017, 0.03007395>,
                         <3.96326, 2.82875, -14.4994>, <-0.5334308, 2.63488e-016, 0.02329009> }
        smooth_triangle {<3.96278, 2.53318, -14.5104>, <-0.4672142, 1.46946e-016, 0.02039901>,
                         <3.96211, 2.23816, -14.5256>, <-0.4642322, 9.94647e-016, 0.02026882>,
                         <4.04105, 1.99676, -12.7176>, <-0.6707582, 1.51651e-015, 0.02928593> }
        smooth_triangle {<4.04105, 1.99676, -12.7176>, <-0.684033, 1.08567e-015, 0.02986553>,
                         <4.04227, 2.39217, -12.6897>, <-0.686717, -4.29886e-016, 0.02998271>,
                         <3.96278, 2.53318, -14.5104>, <-0.5313751, 5.84927e-017, 0.02320034> }
        smooth_triangle {<3.96211, 2.23816, -14.5256>, <-0.4642322, 9.94647e-016, 0.02026882>,
                         <3.96126, 1.94399, -14.545>, <-0.4601757, -4.6852e-016, 0.02009171>,
                         <4.03946, 1.60306, -12.7539>, <-0.6655796, 1.31116e-016, 0.02905983> }
        smooth_triangle {<4.03946, 1.60306, -12.7539>, <-0.6793218, 6.09647e-016, 0.02965983>,
                         <4.04105, 1.99676, -12.7176>, <-0.6832057, 1.64869e-015, 0.02982941>,
                         <3.96211, 2.23816, -14.5256>, <-0.5283113, 1.2573e-015, 0.02306657> }
        smooth_triangle {<3.96126, 1.94399, -14.545>, <-0.4601757, -4.6852e-016, 0.02009171>,
                         <3.96019, 1.65136, -14.5696>, <-0.4544696, -1.32663e-015, 0.01984257>,
                         <4.03743, 1.21245, -12.8005>, <-0.657787, -1.2782e-015, 0.0287196> }
        smooth_triangle {<4.03743, 1.21245, -12.8005>, <-0.6722134, -1.5516e-015, 0.02934947>,
                         <4.03946, 1.60306, -12.7539>, <-0.6780579, -4.94613e-016, 0.02960465>,
                         <3.96126, 1.94399, -14.545>, <-0.524005, -9.4434e-016, 0.02287855> }
        smooth_triangle {<3.96019, 1.65136, -14.5696>, <-0.4544696, -1.32663e-015, 0.01984257>,
                         <3.95882, 1.36169, -14.601>, <-0.4458831, 2.3491e-016, 0.01946768>,
                         <4.0348, 0.8277403, -12.8607>, <-0.6448961, -1.24495e-015, 0.02815677> }
        smooth_triangle {<4.0348, 0.8277403, -12.8607>, <-0.6604249, -9.2721e-016, 0.02883477>,
                         <4.03743, 1.21245, -12.8005>, <-0.6700931, -9.52146e-016, 0.0292569>,
                         <3.96019, 1.65136, -14.5696>, <-0.517605, -9.88467e-016, 0.02259912> }
        smooth_triangle {<3.95882, 1.36169, -14.601>, <-0.4458831, 2.3491e-016, 0.01946768>,
                         <3.95706, 1.07783, -14.6414>, <-0.4337985, 2.28261e-016, 0.01894005>,
                         <4.03139, 0.4546776, -12.939>, <-0.6251066, 1.32258e-015, 0.02729275> }
        smooth_triangle {<4.03139, 0.4546776, -12.939>, <-0.6415932, 4.78025e-016, 0.02801256>,
                         <4.0348, 0.8277403, -12.8607>, <-0.6564353, -1.44763e-015, 0.02866058>,
                         <3.95882, 1.36169, -14.601>, <-0.5071755, -3.37729e-016, 0.02214376> }
        smooth_triangle {<3.95706, 1.07783, -14.6414>, <-0.4337985, 2.28261e-016, 0.01894005>,
                         <3.95495, 0.8013936, -14.6897>, <-0.4203182, -7.33788e-016, 0.01835149>,
                         <4.02728, 0.09643594, -13.0329>, <-0.6025598, 4.92372e-016, 0.02630833> }
        smooth_triangle {<4.02728, 0.09643594, -13.0329>, <-0.6190256, 1.04886e-015, 0.02702724>,
                         <4.03139, 0.4546776, -12.939>, <-0.6359357, 1.67151e-015, 0.02776555>,
                         <3.95706, 1.07783, -14.6414>, <-0.4924546, 8.50773e-016, 0.02150103> }
        smooth_triangle {<3.95495, 0.8013936, -14.6897>, <-0.4203182, -7.33788e-016, 0.01835149>,
                         <3.95267, 0.5301157, -14.7419>, <-0.4079949, 9.91684e-016, 0.01781344>,
                         <4.02283, -0.2514787, -13.1349>, <-0.5835224, -9.08417e-016, 0.02547714> }
        smooth_triangle {<4.02283, -0.2514787, -13.1349>, <-0.5997168, -5.34729e-016, 0.0261842>,
                         <4.02728, 0.09643594, -13.0329>, <-0.6139948, 5.15863e-016, 0.02680759>,
                         <3.95495, 0.8013936, -14.6897>, <-0.4773136, -4.03757e-016, 0.02083996> }
        smooth_triangle {<3.95267, 0.5301157, -14.7419>, <-0.4079949, 9.91684e-016, 0.01781344>,
                         <3.95032, 0.2610703, -14.7957>, <-0.3686855, 1.52395e-015, 0.01609716>,
                         <4.01825, -0.5949286, -13.2398>, <-0.546284, -7.37257e-017, 0.02385128> }
        smooth_triangle {<4.01825, -0.5949286, -13.2398>, <-0.5754933, -1.18164e-015, 0.02512658>,
                         <4.02283, -0.2514787, -13.1349>, <-0.5961198, -1.53068e-015, 0.02602715>,
                         <3.95267, 0.5301157, -14.7419>, <-0.4644742, -1.05601e-016, 0.02027938> }
        smooth_triangle {<3.8851, 3.96077, -16.2895>, <-0.3142299, 0, 0.01371958>,
                         <3.8851, 3.77816, -16.2895>, <-0.3177705, 0, 0.01387416>,
                         <3.96023, 4.27106, -14.5687>, <-0.4325359, 6.0007e-016, 0.01888493> }
        smooth_triangle {<3.96023, 4.27106, -14.5687>, <-0.4418851, 4.36933e-017, 0.01929312>,
                         <3.95833, 4.5363, -14.6123>, <-0.4759845, -1.61698e-015, 0.02078193>,
                         <3.8851, 3.96077, -16.2895>, <-0.3920813, -8.12718e-016, 0.01711864> }
        smooth_triangle {<3.8851, 3.77816, -16.2895>, <-0.3177705, 0, 0.01387416>,
                         <3.8851, 3.59556, -16.2895>, <-0.323656, 0, 0.01413112>,
                         <3.96192, 3.99832, -14.53>, <-0.4492175, 1.83447e-016, 0.01961326> }
        smooth_triangle {<3.96192, 3.99832, -14.53>, <-0.459024, 9.26234e-016, 0.02004142>,
                         <3.96023, 4.27106, -14.5687>, <-0.4465128, 1.2387e-015, 0.01949517>,
                         <3.8851, 3.77816, -16.2895>, <-0.3746615, 1.05153e-015, 0.01635808> }
        smooth_triangle {<3.8851, 3.59556, -16.2895>, <-0.323656, 0, 0.01413112>,
                         <3.8851, 3.41295, -16.2895>, <-0.3269486, 0, 0.01427488>,
                         <3.96304, 3.71298, -14.5043>, <-0.4629796, 1.7705e-016, 0.02021412> }
        smooth_triangle {<3.96304, 3.71298, -14.5043>, <-0.4753382, -5.67607e-016, 0.02075371>,
                         <3.96192, 3.99832, -14.53>, <-0.4650166, -5.62809e-016, 0.02030306>,
                         <3.8851, 3.59556, -16.2895>, <-0.3865753, -9.33859e-016, 0.01687824> }
        smooth_triangle {<3.8851, 3.41295, -16.2895>, <-0.3269486, 0, 0.01427488>,
                         <3.8851, 3.23034, -16.2895>, <-0.3279365, 0, 0.01431802>,
                         <3.9635, 3.41986, -14.4939>, <-0.4690202, 5.69441e-016, 0.02047786> }
        smooth_triangle {<3.9635, 3.41986, -14.4939>, <-0.4833698, 1.24866e-015, 0.02110438>,
                         <3.96304, 3.71298, -14.5043>, <-0.4788394, 9.54369e-016, 0.02090658>,
                         <3.8851, 3.41295, -16.2895>, <-0.3934386, 1.09544e-015, 0.0171779> }
        smooth_triangle {<3.8851, 3.23034, -16.2895>, <-0.3279365, 0, 0.01431802>,
                         <3.8851, 3.04773, -16.2895>, <-0.3274329, 0, 0.01429603>,
                         <3.96352, 3.12451, -14.4935>, <-0.4701338, 2.7649e-016, 0.02052648> }
        smooth_triangle {<3.96352, 3.12451, -14.4935>, <-0.4852029, -2.04755e-016, 0.02118441>,
                         <3.9635, 3.41986, -14.4939>, <-0.4843677, 1.49586e-017, 0.02114795>,
                         <3.8851, 3.23034, -16.2895>, <-0.3954278, -5.49496e-016, 0.01726475> }
        smooth_triangle {<3.8851, 3.04773, -16.2895>, <-0.3274329, 0, 0.01429603>,
                         <3.8851, 2.86512, -16.2895>, <-0.3258907, 0, 0.01422869>,
                         <3.96326, 2.82875, -14.4994>, <-0.4692513, 1.44452e-016, 0.02048795> }
        smooth_triangle {<3.96326, 2.82875, -14.4994>, <-0.4846257, 7.31593e-016, 0.02115922>,
                         <3.96352, 3.12451, -14.4935>, <-0.4852876, 8.30621e-016, 0.02118811>,
                         <3.8851, 3.04773, -16.2895>, <-0.395205, 8.31005e-016, 0.01725502> }
        smooth_triangle {<3.8851, 2.86512, -16.2895>, <-0.3258907, 0, 0.01422869>,
                         <3.8851, 2.68251, -16.2895>, <-0.3234999, 0, 0.01412431>,
                         <3.96278, 2.53318, -14.5104>, <-0.4672142, 1.46946e-016, 0.02039901> }
        smooth_triangle {<3.96278, 2.53318, -14.5104>, <-0.4827835, -3.87982e-016, 0.02107878>,
                         <3.96326, 2.82875, -14.4994>, <-0.4843113, -3.89852e-016, 0.02114549>,
                         <3.8851, 2.86512, -16.2895>, <-0.3937575, -6.64255e-016, 0.01719182> }
        smooth_triangle {<3.8851, 2.68251, -16.2895>, <-0.3234999, 0, 0.01412431>,
                         <3.8851, 2.4999, -16.2895>, <-0.3203332, 0, 0.01398605>,
                         <3.96211, 2.23816, -14.5256>, <-0.4642322, 9.94647e-016, 0.02026882> }
        smooth_triangle {<3.96211, 2.23816, -14.5256>, <-0.4799699, 1.38415e-015, 0.02095594>,
                         <3.96278, 2.53318, -14.5104>, <-0.4822064, 7.48371e-016, 0.02105359>,
                         <3.8851, 2.68251, -16.2895>, <-0.3913942, 8.50882e-016, 0.01708864> }
        smooth_triangle {<3.8851, 2.4999, -16.2895>, <-0.3203332, 0, 0.01398605>,
                         <3.8851, 2.31729, -16.2895>, <-0.316317, 0, 0.0138107>,
                         <3.96126, 1.94399, -14.545>, <-0.4601757, -4.6852e-016, 0.02009171> }
        smooth_triangle {<3.96126, 1.94399, -14.545>, <-0.4761251, -2.10335e-016, 0.02078807>,
                         <3.96211, 2.23816, -14.5256>, <-0.4791675, 8.8704e-016, 0.0209209>,
                         <3.8851, 2.4999, -16.2895>, <-0.3882132, 1.88073e-016, 0.01694975> }
        smooth_triangle {<3.8851, 2.31729, -16.2895>, <-0.316317, 0, 0.0138107>,
                         <3.8851, 2.13469, -16.2895>, <-0.3112107, 0, 0.01358775>,
                         <3.96019, 1.65136, -14.5696>, <-0.4544696, -1.32663e-015, 0.01984257> }
        smooth_triangle {<3.96019, 1.65136, -14.5696>, <-0.4707646, -1.41982e-015, 0.02055403>,
                         <3.96126, 1.94399, -14.545>, <-0.4750442, -7.76235e-016, 0.02074088>,
                         <3.8851, 2.31729, -16.2895>, <-0.3840945, -5.66459e-016, 0.01676993> }
        smooth_triangle {<3.8851, 2.13469, -16.2895>, <-0.3112107, 0, 0.01358775>,
                         <3.8851, 1.95208, -16.2895>, <-0.3046544, 0, 0.0133015>,
                         <3.95882, 1.36169, -14.601>, <-0.4458831, 2.3491e-016, 0.01946768> }
        smooth_triangle {<3.95882, 1.36169, -14.601>, <-0.4627592, -3.16262e-016, 0.0202045>,
                         <3.96019, 1.65136, -14.5696>, <-0.4691992, -1.48742e-015, 0.02048568>,
                         <3.8851, 2.13469, -16.2895>, <-0.3786031, -6.56593e-016, 0.01653017> }
        smooth_triangle {<3.8851, 1.95208, -16.2895>, <-0.3046544, 0, 0.0133015>,
                         <3.8851, 1.76947, -16.2895>, <-0.2965563, 0, 0.01294793>,
                         <3.95706, 1.07783, -14.6414>, <-0.4337985, 2.28261e-016, 0.01894005> }
        smooth_triangle {<3.95706, 1.07783, -14.6414>, <-0.4511428, 9.22548e-016, 0.01969732>,
                         <3.95882, 1.36169, -14.601>, <-0.4602062, 9.27535e-016, 0.02009304>,
                         <3.8851, 1.95208, -16.2895>, <-0.3708282, 1.0018e-015, 0.01619071> }
        smooth_triangle {<3.8851, 1.76947, -16.2895>, <-0.2965563, 0, 0.01294793>,
                         <3.8851, 1.58686, -16.2895>, <-0.2873769, 0, 0.01254715>,
                         <3.95495, 0.8013936, -14.6897>, <-0.4203182, -7.33788e-016, 0.01835149> }
        smooth_triangle {<3.95495, 0.8013936, -14.6897>, <-0.4374853, -1.03118e-015, 0.01910102>,
                         <3.95706, 1.07783, -14.6414>, <-0.4475955, -3.09648e-016, 0.01954244>,
                         <3.8851, 1.76947, -16.2895>, <-0.3606997, -6.41125e-016, 0.01574849> }
        smooth_triangle {<3.8851, 1.58686, -16.2895>, <-0.2873769, 0, 0.01254715>,
                         <3.8851, 1.40425, -16.2895>, <-0.2776978, 0, 0.01212455>,
                         <3.95267, 0.5301157, -14.7419>, <-0.4079949, 9.91684e-016, 0.01781344> }
        smooth_triangle {<3.95267, 0.5301157, -14.7419>, <-0.4247644, 7.56014e-016, 0.01854561>,
                         <3.95495, 0.8013936, -14.6897>, <-0.4340069, -5.3809e-016, 0.01894915>,
                         <3.8851, 1.58686, -16.2895>, <-0.3499422, 1.63353e-017, 0.01527881> }
        smooth_triangle {<3.8851, 1.40425, -16.2895>, <-0.2776978, 0, 0.01212455>,
                         <3.8851, 1.22164, -16.2895>, <-0.2727919, 0, 0.01191035>,
                         <3.95032, 0.2610703, -14.7957>, <-0.3686855, 1.52395e-015, 0.01609716> }
        smooth_triangle {<3.95032, 0.2610703, -14.7957>, <-0.400237, 2.14253e-015, 0.01747472>,
                         <3.95267, 0.5301157, -14.7419>, <-0.4218312, 1.58868e-015, 0.01841755>,
                         <3.8851, 1.40425, -16.2895>, <-0.3395785, 1.12656e-015, 0.01482632> }
    }
    union { // Poly_Mesh
        smooth_triangle {<3.8851, 2.59121, -16.2895>, <0.1124891, 0, 4.13283>,
                         <-0.2098663, 2.59121, -16.1781>, <0.02410956, 0, 4.62756>,
                         <-0.2098663, 1.58196, -16.1781>, <0.1124891, 0, 4.13283> }
        smooth_triangle {<-0.2098663, 1.58196, -16.1781>, <0.1325693, 0, 4.87058>,
                         <3.8851, 1.22164, -16.2895>, <0.1526495, 0, 5.60832>,
                         <3.8851, 2.59121, -16.2895>, <0.1325693, 0, 4.87058> }
        smooth_triangle {<-0.2098663, 2.59121, -16.1781>, <0.02410956, 0, 4.62756>,
                         <-4.31117, 2.59121, -16.2895>, <-0.1526495, 0, 5.61701>,
                         <-4.31117, 1.22164, -16.2895>, <-0.1526495, 0, 5.61701> }
        smooth_triangle {<-4.31117, 1.22164, -16.2895>, <-0.1325693, 0, 4.87812>,
                         <-0.2098663, 1.58196, -16.1781>, <-9.68098e-009, 0, 4.13604>,
                         <-0.2098663, 2.59121, -16.1781>, <-0.01004011, 0, 4.50548> }
        smooth_triangle {<3.8851, 3.96077, -16.2895>, <0.1124891, 0, 4.13283>,
                         <-0.2098663, 3.60046, -16.1781>, <-0.02008021, 0, 4.87492>,
                         <-0.2098663, 2.59121, -16.1781>, <0.02410956, 0, 4.62756> }
        smooth_triangle {<-0.2098663, 2.59121, -16.1781>, <0.05624454, 0, 4.87275>,
                         <3.8851, 2.59121, -16.2895>, <0.1325693, 0, 4.87058>,
                         <3.8851, 3.96077, -16.2895>, <0.1325693, 0, 4.87058> }
        smooth_triangle {<-0.2098663, 3.60046, -16.1781>, <-0.02008021, 0, 4.87492>,
                         <-4.31117, 3.96077, -16.2895>, <-0.1526495, 0, 5.61701>,
                         <-4.31117, 2.59121, -16.2895>, <-0.1526495, 0, 5.61701> }
        smooth_triangle {<-4.31117, 2.59121, -16.2895>, <-0.1392627, 0, 5.12442>,
                         <-0.2098663, 2.59121, -16.1781>, <-0.01004011, 0, 4.50548>,
                         <-0.2098663, 3.60046, -16.1781>, <-0.05088317, 0, 4.62969> }
    }
    union { // Poly_Mesh
        smooth_triangle {<-4.3844, 4.5363, -14.6123>, <0.4778848, -2.64545e-017, 0.0208649>,
                         <-4.38631, 4.27106, -14.5687>, <0.5328524, -1.82724e-016, 0.02326484>,
                         <-4.31117, 3.77816, -16.2895>, <0.4778848, -2.64545e-017, 0.0208649> }
        smooth_triangle {<-4.31117, 3.77816, -16.2895>, <0.3920813, -1.32273e-017, 0.01711864>,
                         <-4.31117, 3.96077, -16.2895>, <0.3062778, 0, 0.01337238>,
                         <-4.3844, 4.5363, -14.6123>, <0.3920813, -1.32273e-017, 0.01711864> }
        smooth_triangle {<-4.38631, 4.27106, -14.5687>, <0.5328524, -1.82724e-016, 0.02326484>,
                         <-4.388, 3.99832, -14.53>, <0.556047, 3.72966e-017, 0.02427754>,
                         <-4.31117, 3.59556, -16.2895>, <0.4955247, 4.03323e-017, 0.02163508> }
        smooth_triangle {<-4.31117, 3.59556, -16.2895>, <0.4048773, 2.01662e-017, 0.01767733>,
                         <-4.31117, 3.77816, -16.2895>, <0.3960574, -1.32273e-017, 0.01729224>,
                         <-4.38631, 4.27106, -14.5687>, <0.4781968, -1.37043e-016, 0.02087852> }
        smooth_triangle {<-4.388, 3.99832, -14.53>, <0.556047, 3.72966e-017, 0.02427754>,
                         <-4.38912, 3.71298, -14.5043>, <0.5808394, -4.29344e-016, 0.02536>,
                         <-4.31117, 3.41295, -16.2895>, <0.5171038, -4.93963e-016, 0.02257724> }
        smooth_triangle {<-4.31117, 3.41295, -16.2895>, <0.4192074, -2.46981e-016, 0.01830299>,
                         <-4.31117, 3.59556, -16.2895>, <0.4084179, 2.01662e-017, 0.01783191>,
                         <-4.388, 3.99832, -14.53>, <0.497363, 2.79724e-017, 0.02171534> }
        smooth_triangle {<-4.38912, 3.71298, -14.5043>, <0.5808394, -4.29344e-016, 0.02536>,
                         <-4.38957, 3.41986, -14.4939>, <0.5930036, -3.02935e-016, 0.0258911>,
                         <-4.31117, 3.23034, -16.2895>, <0.528314, -5.22585e-016, 0.02306669> }
        smooth_triangle {<-4.31117, 3.23034, -16.2895>, <0.4271575, -2.61293e-016, 0.0186501>,
                         <-4.31117, 3.41295, -16.2895>, <0.4215524, -2.46981e-016, 0.01840538>,
                         <-4.38912, 3.71298, -14.5043>, <0.5171298, -3.22008e-016, 0.02257838> }
        smooth_triangle {<-4.38957, 3.41986, -14.4939>, <0.5930036, -3.02935e-016, 0.0258911>,
                         <-4.38959, 3.12451, -14.4935>, <0.5953647, 4.04615e-016, 0.02599418>,
                         <-4.31117, 3.04773, -16.2895>, <0.5304908, 2.36979e-016, 0.02316173> }
        smooth_triangle {<-4.31117, 3.04773, -16.2895>, <0.4291935, 1.1849e-016, 0.018739>,
                         <-4.31117, 3.23034, -16.2895>, <0.4281051, -2.61293e-016, 0.01869148>,
                         <-4.38957, 3.41986, -14.4939>, <0.5267268, -2.27201e-016, 0.02299739> }
        smooth_triangle {<-4.38959, 3.12451, -14.4935>, <0.5953647, 4.04615e-016, 0.02599418>,
                         <-4.38933, 2.82875, -14.4994>, <0.5944812, -1.88651e-017, 0.02595561>,
                         <-4.31117, 2.86512, -16.2895>, <0.5296612, -3.73291e-016, 0.02312551> }
        smooth_triangle {<-4.31117, 2.86512, -16.2895>, <0.428819, -1.86645e-016, 0.01872264>,
                         <-4.31117, 3.04773, -16.2895>, <0.4292338, 1.1849e-016, 0.01874075>,
                         <-4.38959, 3.12451, -14.4935>, <0.5285177, 3.03461e-016, 0.02307558> }
        smooth_triangle {<-4.38933, 2.82875, -14.4994>, <0.5944812, -1.88651e-017, 0.02595561>,
                         <-4.38885, 2.53318, -14.5104>, <0.5921634, 1.08167e-016, 0.02585442>,
                         <-4.31117, 2.68251, -16.2895>, <0.5274948, 4.88867e-016, 0.02303092> }
        smooth_triangle {<-4.31117, 2.68251, -16.2895>, <0.4271918, 2.44433e-016, 0.0186516>,
                         <-4.31117, 2.86512, -16.2895>, <0.4282751, -1.86645e-016, 0.01869889>,
                         <-4.38933, 2.82875, -14.4994>, <0.5275831, -1.41488e-017, 0.02303478> }
        smooth_triangle {<-4.38885, 2.53318, -14.5104>, <0.5921634, 1.08167e-016, 0.02585442>,
                         <-4.38819, 2.23816, -14.5256>, <0.5888223, 7.64001e-017, 0.02570854>,
                         <-4.31117, 2.4999, -16.2895>, <0.524398, -2.74303e-016, 0.02289571> }
        smooth_triangle {<-4.31117, 2.4999, -16.2895>, <0.4246452, -1.37152e-016, 0.01854041>,
                         <-4.31117, 2.68251, -16.2895>, <0.4261936, 2.44433e-016, 0.01860802>,
                         <-4.38885, 2.53318, -14.5104>, <0.5253457, 8.11254e-017, 0.02293709> }
        smooth_triangle {<-4.38819, 2.23816, -14.5256>, <0.5888223, 7.64001e-017, 0.02570854>,
                         <-4.38734, 1.94399, -14.545>, <0.5843698, -3.22803e-016, 0.02551414>,
                         <-4.31117, 2.31729, -16.2895>, <0.520425, 6.15393e-016, 0.02272225> }
        smooth_triangle {<-4.31117, 2.31729, -16.2895>, <0.4212661, 3.07697e-016, 0.01839288>,
                         <-4.31117, 2.4999, -16.2895>, <0.4232526, -1.37152e-016, 0.01847961>,
                         <-4.38819, 2.23816, -14.5256>, <0.5221435, 5.73001e-017, 0.02279728> }
        smooth_triangle {<-4.38734, 1.94399, -14.545>, <0.5843698, -3.22803e-016, 0.02551414>,
                         <-4.38627, 1.65136, -14.5696>, <0.5780955, 4.77772e-016, 0.0252402>,
                         <-4.31117, 2.13469, -16.2895>, <0.5151654, -3.43475e-016, 0.02249261> }
        smooth_triangle {<-4.31117, 2.13469, -16.2895>, <0.4168623, -1.71738e-016, 0.0182006>,
                         <-4.31117, 2.31729, -16.2895>, <0.419492, 3.07697e-016, 0.01831542>,
                         <-4.38734, 1.94399, -14.545>, <0.5179171, -2.42102e-016, 0.02261275> }
        smooth_triangle {<-4.38627, 1.65136, -14.5696>, <0.5780955, 4.77772e-016, 0.0252402>,
                         <-4.3849, 1.36169, -14.601>, <0.5683658, -1.13191e-016, 0.02481539>,
                         <-4.31117, 1.95208, -16.2895>, <0.5076593, 1.91687e-016, 0.02216489> }
        smooth_triangle {<-4.31117, 1.95208, -16.2895>, <0.4108671, 9.58435e-017, 0.01793885>,
                         <-4.31117, 2.13469, -16.2895>, <0.4146202, -1.71738e-016, 0.01810271>,
                         <-4.38627, 1.65136, -14.5696>, <0.5120903, 3.58329e-016, 0.02235835> }
        smooth_triangle {<-4.3849, 1.36169, -14.601>, <0.5683658, -1.13191e-016, 0.02481539>,
                         <-4.38313, 1.07783, -14.6414>, <0.5532914, 3.62846e-017, 0.02415723>,
                         <-4.31117, 1.76947, -16.2895>, <0.4957915, 2.13805e-016, 0.02164673> }
        smooth_triangle {<-4.31117, 1.76947, -16.2895>, <0.402069, 1.06902e-016, 0.01755471>,
                         <-4.31117, 1.95208, -16.2895>, <0.4080029, 9.58435e-017, 0.01781379>,
                         <-4.3849, 1.36169, -14.601>, <0.503361, -8.4893e-017, 0.02197722> }
        smooth_triangle {<-4.38313, 1.07783, -14.6414>, <0.5532914, 3.62846e-017, 0.02415723>,
                         <-4.38103, 0.8013936, -14.6897>, <0.535146, 5.86915e-017, 0.02336498>,
                         <-4.31117, 1.58686, -16.2895>, <0.4801744, 3.46945e-016, 0.02096487> }
        smooth_triangle {<-4.31117, 1.58686, -16.2895>, <0.3905684, 1.73472e-016, 0.01705258>,
                         <-4.31117, 1.76947, -16.2895>, <0.3983769, 1.06902e-016, 0.01739351>,
                         <-4.38313, 1.07783, -14.6414>, <0.4902091, 2.72135e-017, 0.021403> }
        smooth_triangle {<-4.38103, 0.8013936, -14.6897>, <0.535146, 5.86915e-017, 0.02336498>,
                         <-4.37874, 0.5301157, -14.7419>, <0.5192909, -1.97758e-016, 0.02267273>,
                         <-4.31117, 1.40425, -16.2895>, <0.4655262, 4.25007e-017, 0.02032531> }
        smooth_triangle {<-4.31117, 1.40425, -16.2895>, <0.3788382, 2.12504e-017, 0.01654044>,
                         <-4.31117, 1.58686, -16.2895>, <0.3861623, 1.73472e-016, 0.01686021>,
                         <-4.38103, 0.8013936, -14.6897>, <0.4743971, 4.40186e-017, 0.02071262> }
        smooth_triangle {<-4.37874, 0.5301157, -14.7419>, <0.5192909, -1.97758e-016, 0.02267273>,
                         <-4.3764, 0.2610703, -14.7957>, <0.5388352, -9.4022e-016, 0.02352606>,
                         <-4.31117, 1.22164, -16.2895>, <0.4535284, -1.27502e-015, 0.01980148> }
        smooth_triangle {<-4.31117, 1.22164, -16.2895>, <0.368066, -6.37511e-016, 0.01607011>,
                         <-4.31117, 1.40425, -16.2895>, <0.3740649, 2.12504e-017, 0.01633203>,
                         <-4.37874, 0.5301157, -14.7419>, <0.4601191, -1.48319e-016, 0.02008923> }
        smooth_triangle {<-4.45866, 5.03593, -12.9115>, <0.6251476, -5.6205e-016, 0.02729454>,
                         <-4.46258, 4.70009, -12.8218>, <0.6656593, -1.05818e-016, 0.02906332>,
                         <-4.38631, 4.27106, -14.5687>, <0.5328524, -1.82724e-016, 0.02326484> }
        smooth_triangle {<-4.38631, 4.27106, -14.5687>, <0.5178597, -1.37585e-016, 0.02261024>,
                         <-4.3844, 4.5363, -14.6123>, <0.4753832, -1.43115e-017, 0.02075568>,
                         <-4.45866, 5.03593, -12.9115>, <0.5490146, -2.82109e-016, 0.0239705> }
        smooth_triangle {<-4.46258, 4.70009, -12.8218>, <0.6656593, -1.05818e-016, 0.02906332>,
                         <-4.46608, 4.34924, -12.7417>, <0.7054031, -1.46584e-016, 0.03079857>,
                         <-4.388, 3.99832, -14.53>, <0.556047, 3.72966e-017, 0.02427754> }
        smooth_triangle {<-4.388, 3.99832, -14.53>, <0.5403092, 4.70544e-017, 0.02359041>,
                         <-4.38631, 4.27106, -14.5687>, <0.5229133, -1.17961e-016, 0.02283089>,
                         <-4.46258, 4.70009, -12.8218>, <0.6225185, -6.02816e-017, 0.02717975> }
        smooth_triangle {<-4.46608, 4.34924, -12.7417>, <0.7054031, -1.46584e-016, 0.03079857>,
                         <-4.46843, 3.97321, -12.6878>, <0.7506205, 1.54535e-016, 0.0327728>,
                         <-4.38912, 3.71298, -14.5043>, <0.5808394, -4.29344e-016, 0.02536> }
        smooth_triangle {<-4.38912, 3.71298, -14.5043>, <0.5654473, -4.43113e-016, 0.02468797>,
                         <-4.388, 3.99832, -14.53>, <0.546853, -9.3133e-017, 0.02387612>,
                         <-4.46608, 4.34924, -12.7417>, <0.6588701, -2.31043e-016, 0.02876689> }
        smooth_triangle {<-4.46843, 3.97321, -12.6878>, <0.7506205, 1.54535e-016, 0.0327728>,
                         <-4.46945, 3.58159, -12.6645>, <0.7748332, -6.77626e-017, 0.03382995>,
                         <-4.38957, 3.41986, -14.4939>, <0.5930036, -3.02935e-016, 0.0258911> }
        smooth_triangle {<-4.38957, 3.41986, -14.4939>, <0.5785446, -3.59447e-016, 0.02525981>,
                         <-4.38912, 3.71298, -14.5043>, <0.5694215, -4.54254e-016, 0.02486148>,
                         <-4.46843, 3.97321, -12.6878>, <0.6967573, -1.63443e-017, 0.03042108> }
        smooth_triangle {<-4.46945, 3.58159, -12.6645>, <0.7748332, -6.77626e-017, 0.03382995>,
                         <-4.4696, 3.18555, -12.661>, <0.7813356, 5.25495e-016, 0.03411385>,
                         <-4.38959, 3.12451, -14.4935>, <0.5953647, 4.04615e-016, 0.02599418> }
        smooth_triangle {<-4.38959, 3.12451, -14.4935>, <0.5816198, 3.63824e-016, 0.02539407>,
                         <-4.38957, 3.41986, -14.4939>, <0.579849, -1.66838e-016, 0.02531675>,
                         <-4.46945, 3.58159, -12.6645>, <0.7162212, 9.54098e-018, 0.03127089> }
        smooth_triangle {<-4.4696, 3.18555, -12.661>, <0.7813356, 5.25495e-016, 0.03411385>,
                         <-4.46919, 2.78866, -12.6704>, <0.7818939, -6.4763e-017, 0.03413823>,
                         <-4.38933, 2.82875, -14.4994>, <0.5944812, -1.88651e-017, 0.02595561> }
        smooth_triangle {<-4.38933, 2.82875, -14.4994>, <0.5812611, -1.08691e-016, 0.02537841>,
                         <-4.38959, 3.12451, -14.4935>, <0.5819237, 2.08919e-016, 0.02540734>,
                         <-4.4696, 3.18555, -12.661>, <0.7214019, 2.99579e-016, 0.03149709> }
        smooth_triangle {<-4.46919, 2.78866, -12.6704>, <0.7818939, -6.4763e-017, 0.03413823>,
                         <-4.46835, 2.39217, -12.6897>, <0.7800536, -3.00902e-016, 0.03405788>,
                         <-4.38885, 2.53318, -14.5104>, <0.5921634, 1.08167e-016, 0.02585442> }
        smooth_triangle {<-4.38885, 2.53318, -14.5104>, <0.5793823, 2.08113e-016, 0.02529638>,
                         <-4.38933, 2.82875, -14.4994>, <0.5811206, 1.12838e-016, 0.02537228>,
                         <-4.46919, 2.78866, -12.6704>, <0.7216801, 7.84149e-017, 0.03150924> }
        smooth_triangle {<-4.46835, 2.39217, -12.6897>, <0.7800536, -3.00902e-016, 0.03405788>,
                         <-4.46713, 1.99676, -12.7176>, <0.7766469, 2.10046e-016, 0.03390914>,
                         <-4.38819, 2.23816, -14.5256>, <0.5888223, 7.64001e-017, 0.02570854> }
        smooth_triangle {<-4.38819, 2.23816, -14.5256>, <0.576441, -1.18178e-017, 0.02516796>,
                         <-4.38885, 2.53318, -14.5104>, <0.5789468, 1.20075e-017, 0.02527737>,
                         <-4.46835, 2.39217, -12.6897>, <0.7198645, -2.94795e-016, 0.03142996> }
        smooth_triangle {<-4.46713, 1.99676, -12.7176>, <0.7766469, 2.10046e-016, 0.03390914>,
                         <-4.46554, 1.60306, -12.7539>, <0.7715786, -4.7517e-016, 0.03368785>,
                         <-4.38734, 1.94399, -14.545>, <0.5843698, -3.22803e-016, 0.02551414> }
        smooth_triangle {<-4.38734, 1.94399, -14.545>, <0.5724112, -8.18573e-017, 0.02499202>,
                         <-4.38819, 2.23816, -14.5256>, <0.5757506, 2.17545e-016, 0.02513782>,
                         <-4.46713, 1.99676, -12.7176>, <0.7166191, 3.1778e-016, 0.03128827> }
        smooth_triangle {<-4.46554, 1.60306, -12.7539>, <0.7715786, -4.7517e-016, 0.03368785>,
                         <-4.46351, 1.21245, -12.8005>, <0.7637055, 2.41849e-016, 0.0333441>,
                         <-4.38627, 1.65136, -14.5696>, <0.5780955, 4.77772e-016, 0.0252402> }
        smooth_triangle {<-4.38627, 1.65136, -14.5696>, <0.5666948, 2.64816e-016, 0.02474243>,
                         <-4.38734, 1.94399, -14.545>, <0.5714006, -3.35615e-016, 0.02494789>,
                         <-4.46554, 1.60306, -12.7539>, <0.7118072, -4.4989e-016, 0.03107818> }
        smooth_triangle {<-4.46351, 1.21245, -12.8005>, <0.7637055, 2.41849e-016, 0.0333441>,
                         <-4.46088, 0.8277403, -12.8607>, <0.7501311, -3.99565e-016, 0.03275143>,
                         <-4.3849, 1.36169, -14.601>, <0.5683658, -1.13191e-016, 0.02481539> }
        smooth_triangle {<-4.3849, 1.36169, -14.601>, <0.5578335, -3.22008e-017, 0.02435554>,
                         <-4.38627, 1.65136, -14.5696>, <0.5651308, 4.11021e-016, 0.02467415>,
                         <-4.46351, 1.21245, -12.8005>, <0.7043383, 2.34079e-016, 0.03075208> }
        smooth_triangle {<-4.46088, 0.8277403, -12.8607>, <0.7501311, -3.99565e-016, 0.03275143>,
                         <-4.45746, 0.4546776, -12.939>, <0.7278317, -1.88796e-016, 0.03177782>,
                         <-4.38313, 1.07783, -14.6414>, <0.5532914, 3.62846e-017, 0.02415723> }
        smooth_triangle {<-4.38313, 1.07783, -14.6414>, <0.5438624, 8.00141e-017, 0.02374555>,
                         <-4.3849, 1.36169, -14.601>, <0.5551681, -3.20924e-017, 0.02423917>,
                         <-4.46088, 0.8277403, -12.8607>, <0.6914921, -2.46873e-016, 0.0301912> }
        smooth_triangle {<-4.45746, 0.4546776, -12.939>, <0.7278317, -1.88796e-016, 0.03177782>,
                         <-4.45336, 0.09643594, -13.0329>, <0.7011554, 3.27574e-016, 0.03061311>,
                         <-4.38103, 0.8013936, -14.6897>, <0.535146, 5.86915e-017, 0.02336498> }
        smooth_triangle {<-4.38103, 0.8013936, -14.6897>, <0.5265315, 1.249e-016, 0.02298886>,
                         <-4.38313, 1.07783, -14.6414>, <0.5401406, 1.08095e-016, 0.02358305>,
                         <-4.45746, 0.4546776, -12.939>, <0.6710458, -6.07153e-017, 0.02929849> }
        smooth_triangle {<-4.45336, 0.09643594, -13.0329>, <0.7011554, 3.27574e-016, 0.03061311>,
                         <-4.44891, -0.2514787, -13.1349>, <0.6792844, -1.59016e-017, 0.0296582>,
                         <-4.37874, 0.5301157, -14.7419>, <0.5192909, -1.97758e-016, 0.02267273> }
        smooth_triangle {<-4.37874, 0.5301157, -14.7419>, <0.5110391, -1.53306e-016, 0.02231245>,
                         <-4.38103, 0.8013936, -14.6897>, <0.5229304, 3.90313e-017, 0.02283164>,
                         <-4.45336, 0.09643594, -13.0329>, <0.6474375, 2.40693e-016, 0.02826773> }
        smooth_triangle {<-4.44891, -0.2514787, -13.1349>, <0.6792844, -1.59016e-017, 0.0296582>,
                         <-4.44433, -0.5949286, -13.2398>, <0.6893469, -4.23273e-016, 0.03009754>,
                         <-4.3764, 0.2610703, -14.7957>, <0.5388352, -9.4022e-016, 0.02352606> }
        smooth_triangle {<-4.3764, 0.2610703, -14.7957>, <0.5173398, -1.0829e-015, 0.02258755>,
                         <-4.37874, 0.5301157, -14.7419>, <0.5080554, -4.90385e-016, 0.02218218>,
                         <-4.44891, -0.2514787, -13.1349>, <0.6280505, -3.53992e-016, 0.02742128> }
        smooth_triangle {<-4.5353, 5.26135, -11.1561>, <0.716318, -3.20924e-016, 0.03127512>,
                         <-4.54115, 4.87641, -11.0223>, <0.7401125, -7.97973e-016, 0.03231401>,
                         <-4.46258, 4.70009, -12.8218>, <0.6656593, -1.05818e-016, 0.02906332> }
        smooth_triangle {<-4.46258, 4.70009, -12.8218>, <0.6516743, -2.44162e-016, 0.02845272>,
                         <-4.45866, 5.03593, -12.9115>, <0.6174334, -6.10623e-016, 0.02695773>,
                         <-4.5353, 5.26135, -11.1561>, <0.6630186, -4.90059e-016, 0.02894802> }
        smooth_triangle {<-4.54115, 4.87641, -11.0223>, <0.7401125, -7.97973e-016, 0.03231401>,
                         <-4.54637, 4.46896, -10.9027>, <0.8019503, 5.5222e-016, 0.03501391>,
                         <-4.46608, 4.34924, -12.7417>, <0.7054031, -1.46584e-016, 0.03079857> }
        smooth_triangle {<-4.46608, 4.34924, -12.7417>, <0.6904225, 1.25767e-017, 0.0301445>,
                         <-4.46258, 4.70009, -12.8218>, <0.6606147, 4.31512e-017, 0.02884306>,
                         <-4.54115, 4.87641, -11.0223>, <0.7164546, -4.75965e-016, 0.03128109> }
        smooth_triangle {<-4.54637, 4.46896, -10.9027>, <0.8019503, 5.5222e-016, 0.03501391>,
                         <-4.54987, 4.02372, -10.8225>, <0.8757759, 7.95082e-018, 0.03823721>,
                         <-4.46843, 3.97321, -12.6878>, <0.7506205, 1.54535e-016, 0.0327728> }
        smooth_triangle {<-4.46843, 3.97321, -12.6878>, <0.7374582, 4.49944e-017, 0.03219812>,
                         <-4.46608, 4.34924, -12.7417>, <0.7035451, -1.80845e-016, 0.03071745>,
                         <-4.54637, 4.46896, -10.9027>, <0.7759555, 3.43258e-016, 0.03387895> }
        smooth_triangle {<-4.54987, 4.02372, -10.8225>, <0.8757759, 7.95082e-018, 0.03823721>,
                         <-4.55137, 3.55512, -10.7881>, <0.91864, -1.80881e-017, 0.04010869>,
                         <-4.46945, 3.58159, -12.6645>, <0.7748332, -6.77626e-017, 0.03382995> }
        smooth_triangle {<-4.46945, 3.58159, -12.6645>, <0.7640392, -2.16325e-016, 0.03335868>,
                         <-4.46843, 3.97321, -12.6878>, <0.7458797, -4.96022e-017, 0.03256581>,
                         <-4.54987, 4.02372, -10.8225>, <0.8397463, -1.5954e-016, 0.03666412> }
        smooth_triangle {<-4.55137, 3.55512, -10.7881>, <0.91864, -1.80881e-017, 0.04010869>,
                         <-4.55157, 3.07986, -10.7836>, <0.9326065, 3.43981e-016, 0.04071848>,
                         <-4.4696, 3.18555, -12.661>, <0.7813356, 5.25495e-016, 0.03411385> }
        smooth_triangle {<-4.4696, 3.18555, -12.661>, <0.771758, 7.39412e-016, 0.03369569>,
                         <-4.46945, 3.58159, -12.6645>, <0.7668813, 2.94469e-016, 0.03348276>,
                         <-4.55137, 3.55512, -10.7881>, <0.8747363, 3.31725e-016, 0.03819182> }
        smooth_triangle {<-4.55157, 3.07986, -10.7836>, <0.9326065, 3.43981e-016, 0.04071848>,
                         <-4.55093, 2.60336, -10.7983>, <0.9361229, -9.97466e-016, 0.04087201>,
                         <-4.46919, 2.78866, -12.6704>, <0.7818939, -6.4763e-017, 0.03413823> }
        smooth_triangle {<-4.46919, 2.78866, -12.6704>, <0.7729469, -9.33227e-017, 0.0337476>,
                         <-4.4696, 3.18555, -12.661>, <0.7725282, 3.49371e-016, 0.03372931>,
                         <-4.55157, 3.07986, -10.7836>, <0.8859814, 2.13235e-016, 0.03868279> }
        smooth_triangle {<-4.55093, 2.60336, -10.7983>, <0.9361229, -9.97466e-016, 0.04087201>,
                         <-4.54964, 2.12744, -10.8278>, <0.9354239, 8.80806e-016, 0.04084149>,
                         <-4.46835, 2.39217, -12.6897>, <0.7800536, -3.00902e-016, 0.03405788> }
        smooth_triangle {<-4.46835, 2.39217, -12.6897>, <0.7715042, -1.97487e-016, 0.0336846>,
                         <-4.46919, 2.78866, -12.6704>, <0.7728844, -2.0383e-017, 0.03374486>,
                         <-4.55093, 2.60336, -10.7983>, <0.8885561, -7.1991e-016, 0.0387952> }
        smooth_triangle {<-4.54964, 2.12744, -10.8278>, <0.9354239, 8.80806e-016, 0.04084149>,
                         <-4.54778, 1.65313, -10.8704>, <0.9321174, 5.65231e-017, 0.04069713>,
                         <-4.46713, 1.99676, -12.7176>, <0.7766469, 2.10046e-016, 0.03390914> }
        smooth_triangle {<-4.46713, 1.99676, -12.7176>, <0.7683847, 1.24358e-016, 0.0335484>,
                         <-4.46835, 2.39217, -12.6897>, <0.7709396, -2.58853e-016, 0.03365996>,
                         <-4.54964, 2.12744, -10.8278>, <0.8874673, 6.27428e-016, 0.03874766> }
        smooth_triangle {<-4.54778, 1.65313, -10.8704>, <0.9321174, 5.65231e-017, 0.04069713>,
                         <-4.54537, 1.18141, -10.9255>, <0.9263331, -9.34149e-016, 0.04044458>,
                         <-4.46554, 1.60306, -12.7539>, <0.7715786, -4.7517e-016, 0.03368785> }
        smooth_triangle {<-4.46554, 1.60306, -12.7539>, <0.7636143, -6.62122e-016, 0.03334012>,
                         <-4.46713, 1.99676, -12.7176>, <0.7674155, -1.4821e-016, 0.03350609>,
                         <-4.54778, 1.65313, -10.8704>, <0.8840183, -2.63353e-016, 0.03859708> }
        smooth_triangle {<-4.54537, 1.18141, -10.9255>, <0.9263331, -9.34149e-016, 0.04044458>,
                         <-4.5423, 0.7143069, -10.9959>, <0.9166635, 4.56811e-016, 0.0400224>,
                         <-4.46351, 1.21245, -12.8005>, <0.7637055, 2.41849e-016, 0.0333441> }
        smooth_triangle {<-4.46351, 1.21245, -12.8005>, <0.7562409, 5.92408e-016, 0.0330182>,
                         <-4.46554, 1.60306, -12.7539>, <0.7621458, 5.46438e-017, 0.03327601>,
                         <-4.54537, 1.18141, -10.9255>, <0.8782117, -2.8959e-016, 0.03834355> }
        smooth_triangle {<-4.5423, 0.7143069, -10.9959>, <0.9166635, 4.56811e-016, 0.0400224>,
                         <-4.53833, 0.2560521, -11.0868>, <0.8989069, -4.42933e-016, 0.03924712>,
                         <-4.46088, 0.8277403, -12.8607>, <0.7501311, -3.99565e-016, 0.03275143> }
        smooth_triangle {<-4.46088, 0.8277403, -12.8607>, <0.7436531, -4.96781e-016, 0.0324686>,
                         <-4.46351, 1.21245, -12.8005>, <0.7538339, -1.57209e-017, 0.0329131>,
                         <-4.5423, 0.7143069, -10.9959>, <0.8685524, 1.455e-016, 0.03792182> }
        smooth_triangle {<-4.53833, 0.2560521, -11.0868>, <0.8989069, -4.42933e-016, 0.03924712>,
                         <-4.53317, -0.1847258, -11.2049>, <0.8686653, 4.52763e-016, 0.03792675>,
                         <-4.45746, 0.4546776, -12.939>, <0.7278317, -1.88796e-016, 0.03177782> }
        smooth_triangle {<-4.45746, 0.4546776, -12.939>, <0.7225056, -2.48716e-016, 0.03154528>,
                         <-4.46088, 0.8277403, -12.8607>, <0.7392302, -4.06793e-016, 0.03227549>,
                         <-4.53833, 0.2560521, -11.0868>, <0.850812, -4.39319e-016, 0.03714726> }
        smooth_triangle {<-4.53317, -0.1847258, -11.2049>, <0.8686653, 4.52763e-016, 0.03792675>,
                         <-4.52699, -0.6032723, -11.3465>, <0.8320697, 4.99022e-016, 0.03632895>,
                         <-4.45336, 0.09643594, -13.0329>, <0.7011554, 3.27574e-016, 0.03061311> }
        smooth_triangle {<-4.45336, 0.09643594, -13.0329>, <0.6961886, 2.16624e-016, 0.03039626>,
                         <-4.45746, 0.4546776, -12.939>, <0.7161958, -1.70653e-016, 0.03126979>,
                         <-4.53317, -0.1847258, -11.2049>, <0.821821, 3.10516e-016, 0.03588148> }
        smooth_triangle {<-4.52699, -0.6032723, -11.3465>, <0.8320697, 4.99022e-016, 0.03632895>,
                         <-4.52028, -1.00633, -11.5001>, <0.802297, -5.59737e-016, 0.03502905>,
                         <-4.44891, -0.2514787, -13.1349>, <0.6792844, -1.59016e-017, 0.0296582> }
        smooth_triangle {<-4.44891, -0.2514787, -13.1349>, <0.6739916, 1.82796e-016, 0.02942711>,
                         <-4.45336, 0.09643594, -13.0329>, <0.6903949, 4.40403e-016, 0.0301433>,
                         <-4.52699, -0.6032723, -11.3465>, <0.7885806, 5.68989e-016, 0.03443018> }
        smooth_triangle {<-4.52028, -1.00633, -11.5001>, <0.802297, -5.59737e-016, 0.03502905>,
                         <-4.51339, -1.40269, -11.6581>, <0.8028968, -1.20563e-016, 0.03505524>,
                         <-4.44433, -0.5949286, -13.2398>, <0.6893469, -4.23273e-016, 0.03009754> }
        smooth_triangle {<-4.44433, -0.5949286, -13.2398>, <0.6731207, -4.90349e-016, 0.02938909>,
                         <-4.44891, -0.2514787, -13.1349>, <0.6696304, -1.68051e-016, 0.0292367>,
                         <-4.52028, -1.00633, -11.5001>, <0.7618898, -5.75928e-016, 0.03326483> }
        smooth_triangle {<-4.61268, 5.21845, -9.38401>, <0.7404231, -1.33921e-015, 0.03232757>,
                         <-4.62043, 4.80357, -9.20644>, <0.7737486, -1.83302e-016, 0.0337826>,
                         <-4.54115, 4.87641, -11.0223>, <0.7401125, -7.97973e-016, 0.03231401> }
        smooth_triangle {<-4.54115, 4.87641, -11.0223>, <0.7241904, -6.53557e-016, 0.03161884>,
                         <-4.5353, 5.26135, -11.1561>, <0.696371, -2.70617e-016, 0.03040422>,
                         <-4.61268, 5.21845, -9.38401>, <0.7084236, -7.79758e-016, 0.03093045> }
        smooth_triangle {<-4.62043, 4.80357, -9.20644>, <0.7737486, -1.83302e-016, 0.0337826>,
                         <-4.62735, 4.35868, -9.04795>, <0.8597471, 3.85687e-016, 0.03753737>,
                         <-4.54637, 4.46896, -10.9027>, <0.8019503, 5.5222e-016, 0.03501391> }
        smooth_triangle {<-4.54637, 4.46896, -10.9027>, <0.7842521, 2.53703e-016, 0.03424119>,
                         <-4.54115, 4.87641, -11.0223>, <0.7378738, -7.58942e-016, 0.03221627>,
                         <-4.62043, 4.80357, -9.20644>, <0.7631008, -2.97939e-016, 0.03331771> }
        smooth_triangle {<-4.62735, 4.35868, -9.04795>, <0.8597471, 3.85687e-016, 0.03753737>,
                         <-4.63198, 3.8634, -8.94184>, <0.9641059, 6.86517e-016, 0.04209378>,
                         <-4.54987, 4.02372, -10.8225>, <0.8757759, 7.95082e-018, 0.03823721> }
        smooth_triangle {<-4.54987, 4.02372, -10.8225>, <0.8610747, 3.56377e-016, 0.03759534>,
                         <-4.54637, 4.46896, -10.9027>, <0.8057055, 7.64579e-016, 0.03517786>,
                         <-4.62735, 4.35868, -9.04795>, <0.8490531, 6.39679e-016, 0.03707046> }
        smooth_triangle {<-4.63198, 3.8634, -8.94184>, <0.9641059, 6.86517e-016, 0.04209378>,
                         <-4.63394, 3.33697, -8.89694>, <1.02682, -4.20074e-016, 0.04483194>,
                         <-4.55137, 3.55512, -10.7881>, <0.91864, -1.80881e-017, 0.04010869> }
        smooth_triangle {<-4.55137, 3.55512, -10.7881>, <0.9079238, -2.33551e-016, 0.03964081>,
                         <-4.54987, 4.02372, -10.8225>, <0.8757758, -2.14022e-016, 0.0382372>,
                         <-4.63198, 3.8634, -8.94184>, <0.9420233, 2.94903e-016, 0.04112963> }
        smooth_triangle {<-4.63394, 3.33697, -8.89694>, <1.02682, -4.20074e-016, 0.04483194>,
                         <-4.63417, 2.80167, -8.89179>, <1.04928, -1.57625e-016, 0.04581249>,
                         <-4.55157, 3.07986, -10.7836>, <0.9326065, 3.43981e-016, 0.04071848> }
        smooth_triangle {<-4.55157, 3.07986, -10.7836>, <0.9239073, 3.58654e-016, 0.04033867>,
                         <-4.55137, 3.55512, -10.7881>, <0.9134324, 8.71021e-017, 0.03988133>,
                         <-4.63394, 3.33697, -8.89694>, <0.9945677, -2.14387e-016, 0.04342377> }
        smooth_triangle {<-4.63417, 2.80167, -8.89179>, <1.04928, -1.57625e-016, 0.04581249>,
                         <-4.63327, 2.26471, -8.91224>, <1.05674, 1.18612e-016, 0.04613835>,
                         <-4.55093, 2.60336, -10.7983>, <0.9361229, -9.97466e-016, 0.04087201> }
        smooth_triangle {<-4.55093, 2.60336, -10.7983>, <0.9284764, -7.81818e-016, 0.04053816>,
                         <-4.55157, 3.07986, -10.7836>, <0.9258391, 2.24267e-016, 0.04042301>,
                         <-4.63417, 2.80167, -8.89179>, <1.01334, -1.51937e-016, 0.04424352> }
        smooth_triangle {<-4.63327, 2.26471, -8.91224>, <1.05674, 1.18612e-016, 0.04613835>,
                         <-4.63151, 1.72852, -8.9526>, <1.05812, -7.67615e-017, 0.0461985>,
                         <-4.54964, 2.12744, -10.8278>, <0.9354239, 8.80806e-016, 0.04084149> }
        smooth_triangle {<-4.54964, 2.12744, -10.8278>, <0.9284706, 4.28694e-016, 0.04053791>,
                         <-4.55093, 2.60336, -10.7983>, <0.9289949, -9.8001e-016, 0.0405608>,
                         <-4.63327, 2.26471, -8.91224>, <1.01946, -1.42952e-016, 0.04451055> }
        smooth_triangle {<-4.63151, 1.72852, -8.9526>, <1.05812, -7.67615e-017, 0.0461985>,
                         <-4.629, 1.19449, -9.01022>, <1.05581, 5.66676e-016, 0.04609768>,
                         <-4.54778, 1.65313, -10.8704>, <0.9321174, 5.65231e-017, 0.04069713> }
        smooth_triangle {<-4.54778, 1.65313, -10.8704>, <0.9256916, 5.41667e-016, 0.04041657>,
                         <-4.54964, 2.12744, -10.8278>, <0.9281715, 1.15988e-015, 0.04052485>,
                         <-4.63151, 1.72852, -8.9526>, <1.02019, 4.41704e-016, 0.04454261> }
        smooth_triangle {<-4.629, 1.19449, -9.01022>, <1.05581, 5.66676e-016, 0.04609768>,
                         <-4.62575, 0.6639034, -9.08456>, <1.05022, -5.89806e-016, 0.04585353>,
                         <-4.54537, 1.18141, -10.9255>, <0.9263331, -9.34149e-016, 0.04044458> }
        smooth_triangle {<-4.54537, 1.18141, -10.9255>, <0.9204366, -1.16617e-015, 0.04018714>,
                         <-4.54778, 1.65313, -10.8704>, <0.9247748, -4.23164e-016, 0.04037654>,
                         <-4.629, 1.19449, -9.01022>, <1.01754, -4.05492e-017, 0.04442696> }
        smooth_triangle {<-4.62575, 0.6639034, -9.08456>, <1.05022, -5.89806e-016, 0.04585353>,
                         <-4.62161, 0.1394801, -9.17941>, <1.03962, 8.00286e-016, 0.04539086>,
                         <-4.5423, 0.7143069, -10.9959>, <0.9166635, 4.56811e-016, 0.0400224> }
        smooth_triangle {<-4.5423, 0.7143069, -10.9959>, <0.9115848, 3.19189e-016, 0.03980066>,
                         <-4.54537, 1.18141, -10.9255>, <0.918837, -7.2403e-016, 0.04011729>,
                         <-4.62575, 0.6639034, -9.08456>, <1.01175, -4.65773e-016, 0.04417401> }
        smooth_triangle {<-4.62161, 0.1394801, -9.17941>, <1.03962, 8.00286e-016, 0.04539086>,
                         <-4.61628, -0.37315, -9.30151>, <1.01843, -7.67904e-016, 0.04446568>,
                         <-4.53833, 0.2560521, -11.0868>, <0.8989069, -4.42933e-016, 0.03924712> }
        smooth_triangle {<-4.53833, 0.2560521, -11.0868>, <0.89535, -3.16153e-016, 0.03909183>,
                         <-4.5423, 0.7143069, -10.9959>, <0.9086675, 3.58654e-016, 0.03967328>,
                         <-4.62161, 0.1394801, -9.17941>, <1.00089, 6.16261e-016, 0.04369963> }
        smooth_triangle {<-4.61628, -0.37315, -9.30151>, <1.01843, -7.67904e-016, 0.04446568>,
                         <-4.60936, -0.8624777, -9.45987>, <0.9805876, 7.59809e-016, 0.04281338>,
                         <-4.53317, -0.1847258, -11.2049>, <0.8686653, 4.52763e-016, 0.03792675> }
        smooth_triangle {<-4.53317, -0.1847258, -11.2049>, <0.8668084, 3.54317e-016, 0.03784568>,
                         <-4.53833, 0.2560521, -11.0868>, <0.8894896, -3.17454e-016, 0.03883596>,
                         <-4.61628, -0.37315, -9.30151>, <0.979133, -5.61183e-016, 0.04274988> }
        smooth_triangle {<-4.60936, -0.8624777, -9.45987>, <0.9805876, 7.59809e-016, 0.04281338>,
                         <-4.60108, -1.32216, -9.64952>, <0.9341824, -3.6834e-016, 0.04078729>,
                         <-4.52699, -0.6032723, -11.3465>, <0.8320697, 4.99022e-016, 0.03632895> }
        smooth_triangle {<-4.52699, -0.6032723, -11.3465>, <0.830634, 5.04805e-016, 0.03626627>,
                         <-4.53317, -0.1847258, -11.2049>, <0.8580807, 4.7011e-016, 0.03746462>,
                         <-4.60936, -0.8624777, -9.45987>, <0.9420225, 7.00395e-016, 0.04112959> }
        smooth_triangle {<-4.60108, -1.32216, -9.64952>, <0.9341824, -3.6834e-016, 0.04078729>,
                         <-4.5921, -1.7612, -9.85526>, <0.8967894, 1.07553e-016, 0.03915468>,
                         <-4.52028, -1.00633, -11.5001>, <0.802297, -5.59737e-016, 0.03502905> }
        smooth_triangle {<-4.52028, -1.00633, -11.5001>, <0.8003257, -4.26308e-016, 0.03494298>,
                         <-4.52699, -0.6032723, -11.3465>, <0.8226552, 3.67761e-016, 0.03591791>,
                         <-4.60108, -1.32216, -9.64952>, <0.8992397, -2.8276e-016, 0.03926166> }
        smooth_triangle {<-4.5921, -1.7612, -9.85526>, <0.8967894, 1.07553e-016, 0.03915468>,
                         <-4.58286, -2.1913, -10.0668>, <0.8914354, 8.10116e-016, 0.03892091>,
                         <-4.51339, -1.40269, -11.6581>, <0.8028968, -1.20563e-016, 0.03505524> }
        smooth_triangle {<-4.51339, -1.40269, -11.6581>, <0.7923332, -1.93133e-016, 0.03459402>,
                         <-4.52028, -1.00633, -11.5001>, <0.7945242, -5.04371e-016, 0.03468968>,
                         <-4.5921, -1.7612, -9.85526>, <0.8653936, -3.90313e-018, 0.0377839> }
        smooth_triangle {<-4.69001, 5.13916, -7.6127>, <0.7731233, -2.42861e-016, 0.0337553>,
                         <-4.69977, 4.7011, -7.38933>, <0.8150611, 7.34945e-016, 0.03558634>,
                         <-4.62043, 4.80357, -9.20644>, <0.7737486, -1.83302e-016, 0.0337826> }
        smooth_triangle {<-4.62043, 4.80357, -9.20644>, <0.7605114, -4.80518e-016, 0.03320465>,
                         <-4.61268, 5.21845, -9.38401>, <0.7306116, -1.35569e-015, 0.03189919>,
                         <-4.69001, 5.13916, -7.6127>, <0.7469617, -8.07514e-016, 0.03261305> }
        smooth_triangle {<-4.69977, 4.7011, -7.38933>, <0.8150611, 7.34945e-016, 0.03558634>,
                         <-4.70848, 4.22552, -7.18981>, <0.920822, 1.78098e-016, 0.04020396>,
                         <-4.62735, 4.35868, -9.04795>, <0.8597471, 3.85687e-016, 0.03753737> }
        smooth_triangle {<-4.62735, 4.35868, -9.04795>, <0.842853, 5.36897e-016, 0.03679976>,
                         <-4.62043, 4.80357, -9.20644>, <0.7783541, 1.10155e-016, 0.03398368>,
                         <-4.69977, 4.7011, -7.38933>, <0.8093385, 7.9884e-016, 0.03533649> }
        smooth_triangle {<-4.70848, 4.22552, -7.18981>, <0.920822, 1.78098e-016, 0.04020396>,
                         <-4.71433, 3.68696, -7.05577>, <1.04936, 6.15827e-016, 0.04581587>,
                         <-4.63198, 3.8634, -8.94184>, <0.9641059, 6.86517e-016, 0.04209378> }
        smooth_triangle {<-4.63198, 3.8634, -8.94184>, <0.949618, 3.92156e-016, 0.04146122>,
                         <-4.62735, 4.35868, -9.04795>, <0.8713489, 1.66533e-016, 0.03804392>,
                         <-4.70848, 4.22552, -7.18981>, <0.917155, 1.0842e-017, 0.04004386> }
        smooth_triangle {<-4.71433, 3.68696, -7.05577>, <1.04936, 6.15827e-016, 0.04581587>,
                         <-4.71684, 3.10945, -6.99824>, <1.12677, -1.39313e-015, 0.0491957>,
                         <-4.63394, 3.33697, -8.89694>, <1.02682, -4.20074e-016, 0.04483194> }
        smooth_triangle {<-4.63394, 3.33697, -8.89694>, <1.01636, -2.13466e-016, 0.0443751>,
                         <-4.63198, 3.8634, -8.94184>, <0.969321, 6.16477e-016, 0.04232147>,
                         <-4.71433, 3.68696, -7.05577>, <1.03326, 5.6346e-016, 0.04511304> }
        smooth_triangle {<-4.71684, 3.10945, -6.99824>, <1.12677, -1.39313e-015, 0.0491957>,
                         <-4.71718, 2.52087, -6.9904>, <1.15502, 1.13371e-015, 0.05042944>,
                         <-4.63417, 2.80167, -8.89179>, <1.04928, -1.57625e-016, 0.04581249> }
        smooth_triangle {<-4.63417, 2.80167, -8.89179>, <1.04076, 7.41188e-017, 0.0454405>,
                         <-4.63394, 3.33697, -8.89694>, <1.02391, -1.22718e-016, 0.04470509>,
                         <-4.71684, 3.10945, -6.99824>, <1.09887, -8.52508e-016, 0.04797791> }
        smooth_triangle {<-4.71718, 2.52087, -6.9904>, <1.15502, 1.13371e-015, 0.05042944>,
                         <-4.71613, 1.93019, -7.01455>, <1.16512, -6.17995e-016, 0.05087024>,
                         <-4.63327, 2.26471, -8.91224>, <1.05674, 1.18612e-016, 0.04613835> }
        smooth_triangle {<-4.63327, 2.26471, -8.91224>, <1.04924, -4.01209e-016, 0.04581075>,
                         <-4.63417, 2.80167, -8.89179>, <1.04364, -6.08386e-016, 0.04556636>,
                         <-4.71718, 2.52087, -6.9904>, <1.12295, 3.60118e-016, 0.04902906> }
        smooth_triangle {<-4.71613, 1.93019, -7.01455>, <1.16512, -6.17995e-016, 0.05087024>,
                         <-4.71399, 1.3405, -7.06359>, <1.16791, 7.22801e-017, 0.05099216>,
                         <-4.63151, 1.72852, -8.9526>, <1.05812, -7.67615e-017, 0.0461985> }
        smooth_triangle {<-4.63151, 1.72852, -8.9526>, <1.05134, 3.45752e-016, 0.04590257>,
                         <-4.63327, 2.26471, -8.91224>, <1.05031, 4.92282e-016, 0.04585745>,
                         <-4.71613, 1.93019, -7.01455>, <1.13159, -6.01732e-017, 0.04940636> }
        smooth_triangle {<-4.71399, 1.3405, -7.06359>, <1.16791, 7.22801e-017, 0.05099216>,
                         <-4.7109, 0.7534884, -7.13421>, <1.1663, 1.25854e-015, 0.05092162>,
                         <-4.629, 1.19449, -9.01022>, <1.05581, 5.66676e-016, 0.04609768> }
        smooth_triangle {<-4.629, 1.19449, -9.01022>, <1.04965, 4.1655e-016, 0.04582853>,
                         <-4.63151, 1.72852, -8.9526>, <1.05138, -6.60279e-017, 0.04590415>,
                         <-4.71399, 1.3405, -7.06359>, <1.13372, 4.57533e-017, 0.04949939> }
        smooth_triangle {<-4.7109, 0.7534884, -7.13421>, <1.1663, 1.25854e-015, 0.05092162>,
                         <-4.70691, 0.1707866, -7.22573>, <1.16068, -8.93961e-016, 0.05067651>,
                         <-4.62575, 0.6639034, -9.08456>, <1.05022, -5.89806e-016, 0.04585353> }
        smooth_triangle {<-4.62575, 0.6639034, -9.08456>, <1.04471, -6.56593e-016, 0.04561292>,
                         <-4.629, 1.19449, -9.01022>, <1.0489, 2.10769e-016, 0.04579603>,
                         <-4.7109, 0.7534884, -7.13421>, <1.13177, 7.29668e-016, 0.04941398> }
        smooth_triangle {<-4.70691, 0.1707866, -7.22573>, <1.16068, -8.93961e-016, 0.05067651>,
                         <-4.70179, -0.404209, -7.34288>, <1.14877, 1.12815e-015, 0.05015643>,
                         <-4.62161, 0.1394801, -9.17941>, <1.03962, 8.00286e-016, 0.04539086> }
        smooth_triangle {<-4.62161, 0.1394801, -9.17941>, <1.03511, 9.67108e-016, 0.04519398>,
                         <-4.62575, 0.6639034, -9.08456>, <1.04306, -7.54605e-017, 0.04554098>,
                         <-4.70691, 0.1707866, -7.22573>, <1.12591, -3.03577e-016, 0.04915821> }
        smooth_triangle {<-4.70179, -0.404209, -7.34288>, <1.14877, 1.12815e-015, 0.05015643>,
                         <-4.69519, -0.9644631, -7.4941>, <1.12344, -5.08274e-016, 0.04905036>,
                         <-4.61628, -0.37315, -9.30151>, <1.01843, -7.67904e-016, 0.04446568> }
        smooth_triangle {<-4.61628, -0.37315, -9.30151>, <1.01578, -9.21138e-016, 0.04435011>,
                         <-4.62161, 0.1394801, -9.17941>, <1.03168, 2.55004e-016, 0.045044>,
                         <-4.70179, -0.404209, -7.34288>, <1.11354, 5.00901e-016, 0.04861817> }
        smooth_triangle {<-4.69519, -0.9644631, -7.4941>, <1.12344, -5.08274e-016, 0.04905036>,
                         <-4.68661, -1.49559, -7.69065>, <1.07736, -2.12793e-016, 0.04703837>,
                         <-4.60936, -0.8624777, -9.45987>, <0.9805876, 7.59809e-016, 0.04281338> }
        smooth_triangle {<-4.60936, -0.8624777, -9.45987>, <0.979956, 7.6111e-016, 0.04278581>,
                         <-4.61628, -0.37315, -9.30151>, <1.00834, -3.84675e-016, 0.04402503>,
                         <-4.69519, -0.9644631, -7.4941>, <1.08709, -1.89952e-016, 0.04746353> }
        smooth_triangle {<-4.68661, -1.49559, -7.69065>, <1.07736, -2.12793e-016, 0.04703837>,
                         <-4.67632, -1.98966, -7.9263>, <1.02138, 1.2039e-015, 0.04459448>,
                         <-4.60108, -1.32216, -9.64952>, <0.9341824, -3.6834e-016, 0.04078729> }
        smooth_triangle {<-4.60108, -1.32216, -9.64952>, <0.9339757, -1.69136e-017, 0.04077826>,
                         <-4.60936, -0.8624777, -9.45987>, <0.9687796, 8.29198e-016, 0.04229784>,
                         <-4.68661, -1.49559, -7.69065>, <1.04136, 9.97466e-017, 0.04546658> }
        smooth_triangle {<-4.67632, -1.98966, -7.9263>, <1.02138, 1.2039e-015, 0.04459448>,
                         <-4.66515, -2.45792, -8.18206>, <0.9775928, 8.39606e-016, 0.04268263>,
                         <-4.5921, -1.7612, -9.85526>, <0.8967894, 1.07553e-016, 0.03915468> }
        smooth_triangle {<-4.5921, -1.7612, -9.85526>, <0.8960615, -2.90566e-016, 0.0391229>,
                         <-4.60108, -1.32216, -9.64952>, <0.9241063, -6.47486e-016, 0.04034735>,
                         <-4.67632, -1.98966, -7.9263>, <0.9895055, 5.31693e-016, 0.04320275> }
        smooth_triangle {<-4.66515, -2.45792, -8.18206>, <0.9775928, 8.39606e-016, 0.04268263>,
                         <-4.65367, -2.91501, -8.44508>, <0.9689923, 1.01308e-015, 0.04230712>,
                         <-4.58286, -2.1913, -10.0668>, <0.8914354, 8.10116e-016, 0.03892091> }
        smooth_triangle {<-4.58286, -2.1913, -10.0668>, <0.8833006, 6.18718e-016, 0.03856574>,
                         <-4.5921, -1.7612, -9.85526>, <0.8893498, 1.39645e-016, 0.03882985>,
                         <-4.66515, -2.45792, -8.18206>, <0.9499523, 6.88685e-016, 0.04147582> }
        smooth_triangle {<-4.76738, 5.07979, -5.84063>, <0.8149391, 1.9186e-015, 0.03558101>,
                         <-4.77918, 4.61965, -5.57045>, <0.8618282, 4.09395e-016, 0.03762823>,
                         <-4.69977, 4.7011, -7.38933>, <0.8150611, 7.34945e-016, 0.03558634> }
        smooth_triangle {<-4.69977, 4.7011, -7.38933>, <0.8020517, 5.2432e-016, 0.03501834>,
                         <-4.69001, 5.13916, -7.6127>, <0.7680733, -1.75207e-016, 0.03353481>,
                         <-4.76738, 5.07979, -5.84063>, <0.7889812, 9.05526e-016, 0.03444767> }
        smooth_triangle {<-4.77918, 4.61965, -5.57045>, <0.8618282, 4.09395e-016, 0.03762823>,
                         <-4.78973, 4.11449, -5.32889>, <0.9851451, 5.0307e-017, 0.04301237>,
                         <-4.70848, 4.22552, -7.18981>, <0.920822, 1.78098e-016, 0.04020396> }
        smooth_triangle {<-4.70848, 4.22552, -7.18981>, <0.9028094, 2.12504e-016, 0.03941751>,
                         <-4.69977, 4.7011, -7.38933>, <0.8234888, 6.30138e-016, 0.0359543>,
                         <-4.77918, 4.61965, -5.57045>, <0.8585641, 3.85976e-016, 0.03748572> }
        smooth_triangle {<-4.78973, 4.11449, -5.32889>, <0.9851451, 5.0307e-017, 0.04301237>,
                         <-4.79684, 3.53376, -5.1659>, <1.13503, 6.84059e-016, 0.04955649>,
                         <-4.71433, 3.68696, -7.05577>, <1.04936, 6.15827e-016, 0.04581587> }
        smooth_triangle {<-4.71433, 3.68696, -7.05577>, <1.03385, 1.01221e-015, 0.04513887>,
                         <-4.70848, 4.22552, -7.18981>, <0.9374497, 6.83915e-016, 0.04092994>,
                         <-4.78973, 4.11449, -5.32889>, <0.985692, 5.88071e-016, 0.04303625> }
        smooth_triangle {<-4.79684, 3.53376, -5.1659>, <1.13503, 6.84059e-016, 0.04955649>,
                         <-4.79995, 2.90629, -5.09472>, <1.2248, -5.24537e-016, 0.05347572>,
                         <-4.71684, 3.10945, -6.99824>, <1.12677, -1.39313e-015, 0.0491957> }
        smooth_triangle {<-4.71684, 3.10945, -6.99824>, <1.11573, -1.66523e-015, 0.04871361>,
                         <-4.71433, 3.68696, -7.05577>, <1.05767, -1.5851e-016, 0.04617874>,
                         <-4.79684, 3.53376, -5.1659>, <1.12192, -1.07336e-016, 0.0489842> }
        smooth_triangle {<-4.79995, 2.90629, -5.09472>, <1.2248, -5.24537e-016, 0.05347572>,
                         <-4.80045, 2.26552, -5.08318>, <1.2574, 4.90638e-016, 0.05489912>,
                         <-4.71718, 2.52087, -6.9904>, <1.15502, 1.13371e-015, 0.05042944> }
        smooth_triangle {<-4.71718, 2.52087, -6.9904>, <1.14597, 1.03099e-015, 0.05003397>,
                         <-4.71684, 3.10945, -6.99824>, <1.12477, -8.64136e-016, 0.04910866>,
                         <-4.79995, 2.90629, -5.09472>, <1.19829, -2.12693e-016, 0.05231868> }
        smooth_triangle {<-4.80045, 2.26552, -5.08318>, <1.2574, 4.90638e-016, 0.05489912>,
                         <-4.79928, 1.62225, -5.11003>, <1.26918, -2.97505e-016, 0.05541367>,
                         <-4.71613, 1.93019, -7.01455>, <1.16512, -6.17995e-016, 0.05087024> }
        smooth_triangle {<-4.71613, 1.93019, -7.01455>, <1.15702, -2.7929e-016, 0.05051652>,
                         <-4.71718, 2.52087, -6.9904>, <1.14945, 1.03449e-015, 0.05018592>,
                         <-4.80045, 2.26552, -5.08318>, <1.22623, 5.52184e-016, 0.05353818> }
        smooth_triangle {<-4.79928, 1.62225, -5.11003>, <1.26918, -2.97505e-016, 0.05541367>,
                         <-4.79681, 0.9801517, -5.16673>, <1.27271, 9.92262e-016, 0.05556769>,
                         <-4.71399, 1.3405, -7.06359>, <1.16791, 7.22801e-017, 0.05099216> }
        smooth_triangle {<-4.71399, 1.3405, -7.06359>, <1.16048, -3.85976e-016, 0.05066771>,
                         <-4.71613, 1.93019, -7.01455>, <1.15839, -9.03683e-016, 0.05057626>,
                         <-4.79928, 1.62225, -5.11003>, <1.23643, -6.63315e-016, 0.05398384> }
        smooth_triangle {<-4.79681, 0.9801517, -5.16673>, <1.27271, 9.92262e-016, 0.05556769>,
                         <-4.7932, 0.3412813, -5.24935>, <1.27128, 1.18424e-015, 0.05550513>,
                         <-4.7109, 0.7534884, -7.13421>, <1.1663, 1.25854e-015, 0.05092162> }
        smooth_triangle {<-4.7109, 0.7534884, -7.13421>, <1.15945, 1.60202e-015, 0.05062274>,
                         <-4.71399, 1.3405, -7.06359>, <1.16066, 7.12321e-016, 0.05067565>,
                         <-4.79681, 0.9801517, -5.16673>, <1.23926, 1.40231e-015, 0.0541073> }
        smooth_triangle {<-4.7932, 0.3412813, -5.24935>, <1.27128, 1.18424e-015, 0.05550513>,
                         <-4.7885, -0.2924235, -5.35703>, <1.26524, -5.07117e-016, 0.05524157>,
                         <-4.70691, 0.1707866, -7.22573>, <1.16068, -8.93961e-016, 0.05067651> }
        smooth_triangle {<-4.70691, 0.1707866, -7.22573>, <1.15452, -1.25421e-015, 0.05040753>,
                         <-4.7109, 0.7534884, -7.13421>, <1.15873, 3.60172e-016, 0.05059137>,
                         <-4.7932, 0.3412813, -5.24935>, <1.23747, 3.04444e-016, 0.054029> }
        smooth_triangle {<-4.7885, -0.2924235, -5.35703>, <1.26524, -5.07117e-016, 0.05524157>,
                         <-4.78245, -0.9168806, -5.49547>, <1.25169, 8.54062e-016, 0.05465017>,
                         <-4.70179, -0.404209, -7.34288>, <1.14877, 1.12815e-015, 0.05015643> }
        smooth_triangle {<-4.70179, -0.404209, -7.34288>, <1.14377, 1.43375e-015, 0.04993798>,
                         <-4.70691, 0.1707866, -7.22573>, <1.1527, -8.2833e-017, 0.05032804>,
                         <-4.7885, -0.2924235, -5.35703>, <1.23112, 2.07299e-016, 0.05375184> }
        smooth_triangle {<-4.78245, -0.9168806, -5.49547>, <1.25169, 8.54062e-016, 0.05465017>,
                         <-4.77462, -1.52365, -5.6748>, <1.22202, -5.57424e-016, 0.05335463>,
                         <-4.69519, -0.9644631, -7.4941>, <1.12344, -5.08274e-016, 0.04905036> }
        smooth_triangle {<-4.69519, -0.9644631, -7.4941>, <1.12071, -7.84529e-016, 0.04893142>,
                         <-4.70179, -0.404209, -7.34288>, <1.13971, 4.42788e-016, 0.04976097>,
                         <-4.78245, -0.9168806, -5.49547>, <1.21691, 2.37223e-016, 0.05313128> }
        smooth_triangle {<-4.77462, -1.52365, -5.6748>, <1.22202, -5.57424e-016, 0.05335463>,
                         <-4.76442, -2.09546, -5.90852>, <1.1677, 8.85865e-016, 0.05098269>,
                         <-4.68661, -1.49559, -7.69065>, <1.07736, -2.12793e-016, 0.04703837> }
        smooth_triangle {<-4.68661, -1.49559, -7.69065>, <1.07706, 1.47451e-017, 0.04702561>,
                         <-4.69519, -0.9644631, -7.4941>, <1.11162, -2.06866e-016, 0.0485346>,
                         <-4.77462, -1.52365, -5.6748>, <1.18556, -2.43729e-016, 0.0517628> }
        smooth_triangle {<-4.76442, -2.09546, -5.90852>, <1.1677, 8.85865e-016, 0.05098269>,
                         <-4.75217, -2.62281, -6.18917>, <1.10238, 8.8124e-016, 0.04813109>,
                         <-4.67632, -1.98966, -7.9263>, <1.02138, 1.2039e-015, 0.04459448> }
        smooth_triangle {<-4.67632, -1.98966, -7.9263>, <1.0215, 7.64146e-016, 0.04459973>,
                         <-4.68661, -1.49559, -7.69065>, <1.06348, -2.98372e-016, 0.04643265>,
                         <-4.76442, -2.09546, -5.90852>, <1.13124, 5.25621e-016, 0.04939089> }
        smooth_triangle {<-4.75217, -2.62281, -6.18917>, <1.10238, 8.8124e-016, 0.04813109>,
                         <-4.73886, -3.11918, -6.49395>, <1.0526, -4.2096e-016, 0.04595736>,
                         <-4.66515, -2.45792, -8.18206>, <0.9775928, 8.39606e-016, 0.04268263> }
        smooth_triangle {<-4.66515, -2.45792, -8.18206>, <0.9770344, 1.12497e-015, 0.04265825>,
                         <-4.67632, -1.98966, -7.9263>, <1.00988, 1.39819e-015, 0.04409214>,
                         <-4.75217, -2.62281, -6.18917>, <1.07063, 1.15619e-015, 0.04674459> }
        smooth_triangle {<-4.73886, -3.11918, -6.49395>, <1.0526, -4.2096e-016, 0.04595736>,
                         <-4.72517, -3.60216, -6.80743>, <1.04099, 4.11129e-016, 0.04545072>,
                         <-4.65367, -2.91501, -8.44508>, <0.9689923, 1.01308e-015, 0.04230712> }
        smooth_triangle {<-4.65367, -2.91501, -8.44508>, <0.9611795, 1.13104e-015, 0.04196601>,
                         <-4.66515, -2.45792, -8.18206>, <0.969583, 9.71445e-016, 0.04233291>,
                         <-4.73886, -3.11918, -6.49395>, <1.02584, 2.60209e-017, 0.04478897> }
        smooth_triangle {<-4.84478, 5.04175, -4.06797>, <0.8573063, 1.29063e-015, 0.0374308>,
                         <-4.85866, 4.56047, -3.75007>, <0.9055386, 1.95446e-016, 0.03953667>,
                         <-4.77918, 4.61965, -5.57045>, <0.8618282, 4.09395e-016, 0.03762823> }
        smooth_triangle {<-4.77918, 4.61965, -5.57045>, <0.8477211, 8.76903e-016, 0.0370123>,
                         <-4.76738, 5.07979, -5.84063>, <0.8101694, 2.09902e-015, 0.03537276>,
                         <-4.84478, 5.04175, -4.06797>, <0.831353, 1.78503e-015, 0.03629766> }
        smooth_triangle {<-4.85866, 4.56047, -3.75007>, <0.9055386, 1.95446e-016, 0.03953667>,
                         <-4.87108, 4.02667, -3.46557>, <1.04696, 1.9799e-015, 0.04571119>,
                         <-4.78973, 4.11449, -5.32889>, <0.9851451, 5.0307e-017, 0.04301237> }
        smooth_triangle {<-4.78973, 4.11449, -5.32889>, <0.9651791, -3.95083e-016, 0.04214063>,
                         <-4.77918, 4.61965, -5.57045>, <0.8726914, -1.25767e-016, 0.03810253>,
                         <-4.85866, 4.56047, -3.75007>, <0.9054743, -2.86229e-016, 0.03953386> }
        smooth_triangle {<-4.87108, 4.02667, -3.46557>, <1.04696, 1.9799e-015, 0.04571119>,
                         <-4.8795, 3.40469, -3.27272>, <1.21826, -8.18211e-016, 0.05319027>,
                         <-4.79684, 3.53376, -5.1659>, <1.13503, 6.84059e-016, 0.04955649> }
        smooth_triangle {<-4.79684, 3.53376, -5.1659>, <1.11822, 1.09548e-015, 0.04882241>,
                         <-4.78973, 4.11449, -5.32889>, <1.0058, 6.20164e-016, 0.04391432>,
                         <-4.87108, 4.02667, -3.46557>, <1.05216, 2.06736e-015, 0.04593843> }
        smooth_triangle {<-4.8795, 3.40469, -3.27272>, <1.21826, -8.18211e-016, 0.05319027>,
                         <-4.88324, 2.72819, -3.187>, <1.32001, 1.38106e-015, 0.05763302>,
                         <-4.79995, 2.90629, -5.09472>, <1.2248, -5.24537e-016, 0.05347572> }
        smooth_triangle {<-4.79995, 2.90629, -5.09472>, <1.21328, -9.85811e-016, 0.05297287>,
                         <-4.79684, 3.53376, -5.1659>, <1.14595, -7.93636e-017, 0.05003344>,
                         <-4.8795, 3.40469, -3.27272>, <1.20837, -1.20607e-015, 0.05275877> }
        smooth_triangle {<-4.88324, 2.72819, -3.187>, <1.32001, 1.38106e-015, 0.05763302>,
                         <-4.88395, 2.03618, -3.17085>, <1.3566, -6.43655e-016, 0.0592304>,
                         <-4.80045, 2.26552, -5.08318>, <1.2574, 4.90638e-016, 0.05489912> }
        smooth_triangle {<-4.80045, 2.26552, -5.08318>, <1.24814, 8.49798e-016, 0.05449477>,
                         <-4.79995, 2.90629, -5.09472>, <1.22368, 8.84167e-017, 0.05342722>,
                         <-4.88324, 2.72819, -3.187>, <1.2951, 1.51761e-015, 0.05654519> }
        smooth_triangle {<-4.88395, 2.03618, -3.17085>, <1.3566, -6.43655e-016, 0.0592304>,
                         <-4.8827, 1.34124, -3.19949>, <1.36977, 7.58363e-016, 0.05980555>,
                         <-4.79928, 1.62225, -5.11003>, <1.26918, -2.97505e-016, 0.05541367> }
        smooth_triangle {<-4.79928, 1.62225, -5.11003>, <1.26096, -4.39752e-016, 0.05505484>,
                         <-4.80045, 2.26552, -5.08318>, <1.25212, 1.51355e-016, 0.05466894>,
                         <-4.88395, 2.03618, -3.17085>, <1.32653, -6.99365e-016, 0.05791739> }
        smooth_triangle {<-4.8827, 1.34124, -3.19949>, <1.36977, 7.58363e-016, 0.05980555>,
                         <-4.87993, 0.6476773, -3.26296>, <1.37371, 1.18771e-015, 0.05997727>,
                         <-4.79681, 0.9801517, -5.16673>, <1.27271, 9.92262e-016, 0.05556769> }
        smooth_triangle {<-4.79681, 0.9801517, -5.16673>, <1.2652, 5.71158e-016, 0.05523998>,
                         <-4.79928, 1.62225, -5.11003>, <1.26256, -3.96167e-016, 0.05512446>,
                         <-4.8827, 1.34124, -3.19949>, <1.338, 3.95734e-016, 0.05841837> }
        smooth_triangle {<-4.87993, 0.6476773, -3.26296>, <1.37371, 1.18771e-015, 0.05997727>,
                         <-4.87584, -0.04212333, -3.35665>, <1.37205, 1.05356e-015, 0.05990505>,
                         <-4.7932, 0.3412813, -5.24935>, <1.27128, 1.18424e-015, 0.05550513> }
        smooth_triangle {<-4.7932, 0.3412813, -5.24935>, <1.26439, 1.76378e-015, 0.05520448>,
                         <-4.79681, 0.9801517, -5.16673>, <1.26547, 1.6198e-015, 0.05525141>,
                         <-4.87993, 0.6476773, -3.26296>, <1.34121, 1.76638e-015, 0.0585586> }
        smooth_triangle {<-4.87584, -0.04212333, -3.35665>, <1.37205, 1.05356e-015, 0.05990505>,
                         <-4.87047, -0.7258973, -3.4796>, <1.36504, -2.02731e-015, 0.05959889>,
                         <-4.7885, -0.2924235, -5.35703>, <1.26524, -5.07117e-016, 0.05524157> }
        smooth_triangle {<-4.7885, -0.2924235, -5.35703>, <1.2591, -1.05948e-015, 0.05497367>,
                         <-4.7932, 0.3412813, -5.24935>, <1.26363, 2.09034e-016, 0.05517134>,
                         <-4.87584, -0.04212333, -3.35665>, <1.33921, 1.11022e-016, 0.05847128> }
        smooth_triangle {<-4.87047, -0.7258973, -3.4796>, <1.36504, -2.02731e-015, 0.05959889>,
                         <-4.86353, -1.39888, -3.63843>, <1.34894, 1.55663e-015, 0.05889601>,
                         <-4.78245, -0.9168806, -5.49547>, <1.25169, 8.54062e-016, 0.05465017> }
        smooth_triangle {<-4.78245, -0.9168806, -5.49547>, <1.24687, 1.32359e-015, 0.0544394>,
                         <-4.7885, -0.2924235, -5.35703>, <1.25703, 3.02709e-016, 0.05488295>,
                         <-4.87047, -0.7258973, -3.4796>, <1.33188, -8.37438e-016, 0.05815094> }
        smooth_triangle {<-4.86353, -1.39888, -3.63843>, <1.34894, 1.55663e-015, 0.05889601>,
                         <-4.85452, -2.05123, -3.84496>, <1.31339, -1.00845e-015, 0.05734387>,
                         <-4.77462, -1.52365, -5.6748>, <1.22202, -5.57424e-016, 0.05335463> }
        smooth_triangle {<-4.77462, -1.52365, -5.6748>, <1.21982, -6.00214e-016, 0.05325862>,
                         <-4.78245, -0.9168806, -5.49547>, <1.24208, 4.58401e-016, 0.05423028>,
                         <-4.86353, -1.39888, -3.63843>, <1.31501, 9.85323e-016, 0.05741466> }
        smooth_triangle {<-4.85452, -2.05123, -3.84496>, <1.31339, -1.00845e-015, 0.05734387>,
                         <-4.84273, -2.6628, -4.11495>, <1.24843, 1.50805e-015, 0.0545078>,
                         <-4.76442, -2.09546, -5.90852>, <1.1677, 8.85865e-016, 0.05098269> }
        smooth_triangle {<-4.76442, -2.09546, -5.90852>, <1.16818, 5.17815e-016, 0.05100388>,
                         <-4.77462, -1.52365, -5.6748>, <1.20893, -5.64652e-016, 0.05278283>,
                         <-4.85452, -2.05123, -3.84496>, <1.27745, -9.02924e-016, 0.05577477> }
        smooth_triangle {<-4.84273, -2.6628, -4.11495>, <1.24843, 1.50805e-015, 0.0545078>,
                         <-4.82855, -3.22249, -4.43969>, <1.17131, -9.71445e-016, 0.05114064>,
                         <-4.75217, -2.62281, -6.18917>, <1.10238, 8.8124e-016, 0.04813109> }
        smooth_triangle {<-4.75217, -2.62281, -6.18917>, <1.10305, 1.22992e-015, 0.04816031>,
                         <-4.76442, -2.09546, -5.90852>, <1.15204, 1.23339e-015, 0.05029902>,
                         <-4.84273, -2.6628, -4.11495>, <1.21259, 1.70003e-015, 0.05294285> }
        smooth_triangle {<-4.82855, -3.22249, -4.43969>, <1.17131, -9.71445e-016, 0.05114064>,
                         <-4.81314, -3.74604, -4.79258>, <1.11386, 6.54569e-016, 0.04863236>,
                         <-4.73886, -3.11918, -6.49395>, <1.0526, -4.2096e-016, 0.04595736> }
        smooth_triangle {<-4.73886, -3.11918, -6.49395>, <1.05224, -6.01949e-016, 0.04594167>,
                         <-4.75217, -2.62281, -6.18917>, <1.08958, 3.747e-016, 0.04757197>,
                         <-4.82855, -3.22249, -4.43969>, <1.14127, -1.01481e-015, 0.04982913> }
        smooth_triangle {<-4.81314, -3.74604, -4.79258>, <1.11386, 6.54569e-016, 0.04863236>,
                         <-4.79729, -4.25396, -5.15562>, <1.09375, -4.54498e-016, 0.04775401>,
                         <-4.72517, -3.60216, -6.80743>, <1.04099, 4.11129e-016, 0.04545072> }
        smooth_triangle {<-4.72517, -3.60216, -6.80743>, <1.03341, 3.64292e-016, 0.04511947>,
                         <-4.73886, -3.11918, -6.49395>, <1.04401, -2.48065e-016, 0.04558226>,
                         <-4.81314, -3.74604, -4.79258>, <1.08996, 5.58581e-016, 0.04758851> }
        smooth_triangle {<-4.92219, 5.01699, -2.29506>, <0.8896512, -4.71845e-016, 0.03884302>,
                         <-4.93826, 4.52108, -1.92685>, <0.9396711, 9.80697e-016, 0.04102693>,
                         <-4.85866, 4.56047, -3.75007>, <0.9055386, 1.95446e-016, 0.03953667> }
        smooth_triangle {<-4.85866, 4.56047, -3.75007>, <0.8905034, 4.17201e-016, 0.03888022>,
                         <-4.84478, 5.04175, -4.06797>, <0.851352, 1.18655e-015, 0.03717083>,
                         <-4.92219, 5.01699, -2.29506>, <0.8675244, 3.05311e-016, 0.03787694> }
        smooth_triangle {<-4.93826, 4.52108, -1.92685>, <0.9396711, 9.80697e-016, 0.04102693>,
                         <-4.95267, 3.96515, -1.59679>, <1.10048, 5.04226e-016, 0.04804797>,
                         <-4.87108, 4.02667, -3.46557>, <1.04696, 1.9799e-015, 0.04571119> }
        smooth_triangle {<-4.87108, 4.02667, -3.46557>, <1.02573, 1.53436e-015, 0.04478421>,
                         <-4.85866, 4.56047, -3.75007>, <0.9196622, 1.96024e-016, 0.04015332>,
                         <-4.93826, 4.52108, -1.92685>, <0.9452615, 7.84962e-016, 0.04127101> }
        smooth_triangle {<-4.95267, 3.96515, -1.59679>, <1.10048, 5.04226e-016, 0.04804797>,
                         <-4.96251, 3.30845, -1.37149>, <1.29369, 3.99565e-016, 0.05648376>,
                         <-4.8795, 3.40469, -3.27272>, <1.21826, -8.18211e-016, 0.05319027> }
        smooth_triangle {<-4.8795, 3.40469, -3.27272>, <1.20131, -1.54824e-016, 0.05245028>,
                         <-4.87108, 4.02667, -3.46557>, <1.07283, 1.94376e-015, 0.04684097>,
                         <-4.95267, 3.96515, -1.59679>, <1.11298, 8.37004e-016, 0.04859355> }
        smooth_triangle {<-4.96251, 3.30845, -1.37149>, <1.29369, 3.99565e-016, 0.05648376>,
                         <-4.967, 2.58943, -1.26862>, <1.4073, 4.80374e-016, 0.0614441>,
                         <-4.88324, 2.72819, -3.187>, <1.32001, 1.38106e-015, 0.05763302> }
        smooth_triangle {<-4.88324, 2.72819, -3.187>, <1.30949, 8.18952e-016, 0.05717373>,
                         <-4.8795, 3.40469, -3.27272>, <1.23318, -8.30499e-016, 0.05384166>,
                         <-4.96251, 3.30845, -1.37149>, <1.28975, 8.2833e-017, 0.05631178> }
        smooth_triangle {<-4.967, 2.58943, -1.26862>, <1.4073, 4.80374e-016, 0.0614441>,
                         <-4.96802, 1.85269, -1.24525>, <1.44756, 6.30717e-016, 0.06320195>,
                         <-4.88395, 2.03618, -3.17085>, <1.3566, -6.43655e-016, 0.0592304> }
        smooth_triangle {<-4.88395, 2.03618, -3.17085>, <1.34878, -3.85868e-016, 0.05888886>,
                         <-4.88324, 2.72819, -3.187>, <1.32134, 1.13267e-015, 0.05769082>,
                         <-4.967, 2.58943, -1.26862>, <1.3868, 4.57154e-016, 0.06054914> }
        smooth_triangle {<-4.96802, 1.85269, -1.24525>, <1.44756, 6.30717e-016, 0.06320195>,
                         <-4.96681, 1.1126, -1.27307>, <1.46173, -1.77809e-017, 0.06382043>,
                         <-4.8827, 1.34124, -3.19949>, <1.36977, 7.58363e-016, 0.05980555> }
        smooth_triangle {<-4.8827, 1.34124, -3.19949>, <1.36319, 7.2609e-016, 0.05951795>,
                         <-4.88395, 2.03618, -3.17085>, <1.35331, -3.25423e-016, 0.05908659>,
                         <-4.96802, 1.85269, -1.24525>, <1.42153, 6.30355e-016, 0.06206525> }
        smooth_triangle {<-4.96681, 1.1126, -1.27307>, <1.46173, -1.77809e-017, 0.06382043>,
                         <-4.96385, 0.374088, -1.3407>, <1.46552, 8.29776e-016, 0.06398621>,
                         <-4.87993, 0.6476773, -3.26296>, <1.37371, 1.18771e-015, 0.05997727> }
        smooth_triangle {<-4.87993, 0.6476773, -3.26296>, <1.36793, 9.23523e-016, 0.05972512>,
                         <-4.8827, 1.34124, -3.19949>, <1.36498, 6.01515e-016, 0.05959632>,
                         <-4.96681, 1.1126, -1.27307>, <1.43395, 1.94072e-017, 0.06260748> }
        smooth_triangle {<-4.96385, 0.374088, -1.3407>, <1.46552, 8.29776e-016, 0.06398621>,
                         <-4.95939, -0.3601269, -1.44288>, <1.4629, 5.15213e-016, 0.06387143>,
                         <-4.87584, -0.04212333, -3.35665>, <1.37205, 1.05356e-015, 0.05990505> }
        smooth_triangle {<-4.87584, -0.04212333, -3.35665>, <1.36694, 1.47755e-015, 0.0596819>,
                         <-4.87993, 0.6476773, -3.26296>, <1.36818, 1.57816e-015, 0.05973607>,
                         <-4.96385, 0.374088, -1.3407>, <1.43705, 1.30972e-015, 0.06274277> }
        smooth_triangle {<-4.95939, -0.3601269, -1.44288>, <1.4629, 5.15213e-016, 0.06387143>,
                         <-4.95347, -1.08745, -1.57848>, <1.45373, -2.34939e-015, 0.06347102>,
                         <-4.87047, -0.7258973, -3.4796>, <1.36504, -2.02731e-015, 0.05959889> }
        smooth_triangle {<-4.87047, -0.7258973, -3.4796>, <1.3607, -1.95113e-015, 0.05940952>,
                         <-4.87584, -0.04212333, -3.35665>, <1.36596, 3.59521e-016, 0.05963914>,
                         <-4.95939, -0.3601269, -1.44288>, <1.43409, -4.42354e-017, 0.06261393> }
        smooth_triangle {<-4.95347, -1.08745, -1.57848>, <1.45373, -2.34939e-015, 0.06347102>,
                         <-4.94576, -1.80245, -1.7551>, <1.43307, 2.66685e-015, 0.06256909>,
                         <-4.86353, -1.39888, -3.63843>, <1.34894, 1.55663e-015, 0.05889601> }
        smooth_triangle {<-4.86353, -1.39888, -3.63843>, <1.34592, 1.18482e-015, 0.05876406>,
                         <-4.87047, -0.7258973, -3.4796>, <1.35799, -1.50314e-015, 0.05929121>,
                         <-4.95347, -1.08745, -1.57848>, <1.42451, -1.7447e-015, 0.06219531> }
        smooth_triangle {<-4.94576, -1.80245, -1.7551>, <1.43307, 2.66685e-015, 0.06256909>,
                         <-4.93567, -2.49386, -1.98622>, <1.38831, -1.01192e-015, 0.06061502>,
                         <-4.85452, -2.05123, -3.84496>, <1.31339, -1.00845e-015, 0.05734387> }
        smooth_triangle {<-4.85452, -2.05123, -3.84496>, <1.31303, -9.46292e-016, 0.057328>,
                         <-4.86353, -1.39888, -3.63843>, <1.33969, 9.77517e-016, 0.05849211>,
                         <-4.94576, -1.80245, -1.7551>, <1.40278, 1.81018e-015, 0.06124691> }
        smooth_triangle {<-4.93567, -2.49386, -1.98622>, <1.38831, -1.01192e-015, 0.06061502>,
                         <-4.92241, -3.13867, -2.28987>, <1.30841, 1.83302e-015, 0.05712632>,
                         <-4.84273, -2.6628, -4.11495>, <1.24843, 1.50805e-015, 0.0545078> }
        smooth_triangle {<-4.84273, -2.6628, -4.11495>, <1.25039, 1.13885e-015, 0.05459317>,
                         <-4.85452, -2.05123, -3.84496>, <1.29911, -7.48533e-016, 0.05672022>,
                         <-4.93567, -2.49386, -1.98622>, <1.3553, -7.51135e-016, 0.05917358> }
        smooth_triangle {<-4.92241, -3.13867, -2.28987>, <1.30841, 1.83302e-015, 0.05712632>,
                         <-4.90642, -3.72419, -2.65609>, <1.21566, -4.3715e-016, 0.05307697>,
                         <-4.82855, -3.22249, -4.43969>, <1.17131, -9.71445e-016, 0.05114064> }
        smooth_triangle {<-4.82855, -3.22249, -4.43969>, <1.17249, -4.57967e-016, 0.05119198>,
                         <-4.84273, -2.6628, -4.11495>, <1.23033, 1.40166e-015, 0.05371735>,
                         <-4.92241, -3.13867, -2.28987>, <1.27531, 1.64539e-015, 0.05568124> }
        smooth_triangle {<-4.90642, -3.72419, -2.65609>, <1.21566, -4.3715e-016, 0.05307697>,
                         <-4.88903, -4.2684, -3.05449>, <1.14806, 2.61365e-016, 0.05012547>,
                         <-4.81314, -3.74604, -4.79258>, <1.11386, 6.54569e-016, 0.04863236> }
        smooth_triangle {<-4.81314, -3.74604, -4.79258>, <1.11311, 1.82146e-016, 0.0485994>,
                         <-4.82855, -3.22249, -4.43969>, <1.1562, -1.03736e-015, 0.05048061>,
                         <-4.90642, -3.72419, -2.65609>, <1.18946, -6.36644e-016, 0.05193286> }
        smooth_triangle {<-4.88903, -4.2684, -3.05449>, <1.14806, 2.61365e-016, 0.05012547>,
                         <-4.87113, -4.79476, -3.46449>, <1.12095, -9.15934e-016, 0.04894174>,
                         <-4.79729, -4.25396, -5.15562>, <1.09375, -4.54498e-016, 0.04775401> }
        smooth_triangle {<-4.79729, -4.25396, -5.15562>, <1.08665, -6.7076e-017, 0.04744419>,
                         <-4.81314, -3.74604, -4.79258>, <1.10351, 6.67869e-016, 0.04818041>,
                         <-4.88903, -4.2684, -3.05449>, <1.12916, 3.72966e-016, 0.04930024> }
        smooth_triangle {<-4.9996, 5.00052, -0.5220608>, <0.910759, -6.73073e-016, 0.0397646>,
                         <-5.01795, 4.49566, -0.1017107>, <0.963007, -3.7817e-016, 0.0420458>,
                         <-4.93826, 4.52108, -1.92685>, <0.9396711, 9.80697e-016, 0.04102693> }
        smooth_triangle {<-4.93826, 4.52108, -1.92685>, <0.9230505, 4.25875e-016, 0.04030126>,
                         <-4.92219, 5.01699, -2.29506>, <0.8814198, -8.55219e-016, 0.03848362>,
                         <-4.9996, 5.00052, -0.5220608>, <0.8919737, -9.55833e-016, 0.03894442> }
        smooth_triangle {<-5.01795, 4.49566, -0.1017107>, <0.963007, -3.7817e-016, 0.0420458>,
                         <-5.03443, 3.92327, 0.275707>, <1.14287, -6.09466e-016, 0.04989886>,
                         <-4.95267, 3.96515, -1.59679>, <1.10048, 5.04226e-016, 0.04804797> }
        smooth_triangle {<-4.95267, 3.96515, -1.59679>, <1.07692, 1.36523e-015, 0.04701953>,
                         <-4.93826, 4.52108, -1.92685>, <0.956318, 1.72258e-015, 0.04175375>,
                         <-5.01795, 4.49566, -0.1017107>, <0.9738199, 7.0343e-016, 0.0425179> }
        smooth_triangle {<-5.03443, 3.92327, 0.275707>, <1.14287, -6.09466e-016, 0.04989886>,
                         <-5.04576, 3.23753, 0.5352753>, <1.35761, 1.13393e-015, 0.05927445>,
                         <-4.96251, 3.30845, -1.37149>, <1.29369, 3.99565e-016, 0.05648376> }
        smooth_triangle {<-4.96251, 3.30845, -1.37149>, <1.27533, -6.10189e-016, 0.05568191>,
                         <-4.95267, 3.96515, -1.59679>, <1.13042, -5.31693e-016, 0.04935507>,
                         <-5.03443, 3.92327, 0.275707>, <1.16221, -1.36696e-015, 0.05074324> }
        smooth_triangle {<-5.04576, 3.23753, 0.5352753>, <1.35761, 1.13393e-015, 0.05927445>,
                         <-5.05108, 2.48167, 0.6571089>, <1.48263, -7.86553e-016, 0.06473308>,
                         <-4.967, 2.58943, -1.26862>, <1.4073, 4.80374e-016, 0.0614441> }
        smooth_triangle {<-4.967, 2.58943, -1.26862>, <1.3964, 1.55897e-015, 0.06096815>,
                         <-4.96251, 3.30845, -1.37149>, <1.31119, 1.49837e-015, 0.05724789>,
                         <-5.04576, 3.23753, 0.5352753>, <1.35913, 2.04914e-015, 0.05934091> }
        smooth_triangle {<-5.05108, 2.48167, 0.6571089>, <1.48263, -7.86553e-016, 0.06473308>,
                         <-5.05249, 1.70587, 0.6895032>, <1.52611, 1.62327e-015, 0.06663126>,
                         <-4.96802, 1.85269, -1.24525>, <1.44756, 6.30717e-016, 0.06320195> }
        smooth_triangle {<-4.96802, 1.85269, -1.24525>, <1.43973, -2.71213e-016, 0.06286019>,
                         <-4.967, 2.58943, -1.26862>, <1.40954, -3.8397e-016, 0.0615418>,
                         <-5.05108, 2.48167, 0.6571089>, <1.46604, -1.33416e-015, 0.06400854> }
        smooth_triangle {<-5.05249, 1.70587, 0.6895032>, <1.52611, 1.62327e-015, 0.06663126>,
                         <-5.05139, 0.9263111, 0.6643066>, <1.5408, -8.7047e-016, 0.06727278>,
                         <-4.96681, 1.1126, -1.27307>, <1.46173, -1.77809e-017, 0.06382043> }
        smooth_triangle {<-4.96681, 1.1126, -1.27307>, <1.45529, 3.51173e-016, 0.06353922>,
                         <-4.96802, 1.85269, -1.24525>, <1.44466, 8.37546e-016, 0.06307536>,
                         <-5.05249, 1.70587, 0.6895032>, <1.50357, 1.58196e-015, 0.06564735> }
        smooth_triangle {<-5.05139, 0.9263111, 0.6643066>, <1.5408, -8.7047e-016, 0.06727278>,
                         <-5.04834, 0.1485168, 0.5943293>, <1.54399, 3.38849e-016, 0.0674122>,
                         <-4.96385, 0.374088, -1.3407>, <1.46552, 8.29776e-016, 0.06398621> }
        smooth_triangle {<-4.96385, 0.374088, -1.3407>, <1.45999, 7.65013e-016, 0.06374454>,
                         <-4.96681, 1.1126, -1.27307>, <1.45714, 1.29345e-016, 0.06362021>,
                         <-5.05139, 0.9263111, 0.6643066>, <1.51645, -5.10171e-016, 0.06620947> }
        smooth_triangle {<-5.04834, 0.1485168, 0.5943293>, <1.54399, 3.38849e-016, 0.0674122>,
                         <-5.04359, -0.6244384, 0.4854874>, <1.53992, 2.26092e-015, 0.06723429>,
                         <-4.95939, -0.3601269, -1.44288>, <1.4629, 5.15213e-016, 0.06387143> }
        smooth_triangle {<-4.95939, -0.3601269, -1.44288>, <1.45812, 8.58254e-016, 0.06366273>,
                         <-4.96385, 0.374088, -1.3407>, <1.46009, 1.09418e-015, 0.06374881>,
                         <-5.04834, 0.1485168, 0.5943293>, <1.51894, 7.25982e-016, 0.0663183> }
        smooth_triangle {<-5.04359, -0.6244384, 0.4854874>, <1.53992, 2.26092e-015, 0.06723429>,
                         <-5.03719, -1.38965, 0.3390328>, <1.5281, -2.15048e-015, 0.06671847>,
                         <-4.95347, -1.08745, -1.57848>, <1.45373, -2.34939e-015, 0.06347102> }
        smooth_triangle {<-4.95347, -1.08745, -1.57848>, <1.44989, -2.93125e-015, 0.06330367>,
                         <-4.95939, -0.3601269, -1.44288>, <1.45677, -7.82794e-016, 0.06360398>,
                         <-5.04359, -0.6244384, 0.4854874>, <1.51454, 5.26489e-016, 0.06612613> }
        smooth_triangle {<-5.03719, -1.38965, 0.3390328>, <1.5281, -2.15048e-015, 0.06671847>,
                         <-5.02878, -2.14098, 0.1464495>, <1.50238, 1.56009e-015, 0.06559516>,
                         <-4.94576, -1.80245, -1.7551>, <1.43307, 2.66685e-015, 0.06256909> }
        smooth_triangle {<-4.94576, -1.80245, -1.7551>, <1.4309, 3.25868e-015, 0.06247437>,
                         <-4.95347, -1.08745, -1.57848>, <1.44639, -5.03503e-016, 0.06315081>,
                         <-5.03719, -1.38965, 0.3390328>, <1.50218, -3.54317e-016, 0.0655864> }
        smooth_triangle {<-5.02878, -2.14098, 0.1464495>, <1.50238, 1.56009e-015, 0.06559516>,
                         <-5.0177, -2.86578, -0.1074566>, <1.44787, 5.0307e-016, 0.06321557>,
                         <-4.93567, -2.49386, -1.98622>, <1.38831, -1.01192e-015, 0.06061502> }
        smooth_triangle {<-4.93567, -2.49386, -1.98622>, <1.38948, -1.37824e-015, 0.06066608>,
                         <-4.94576, -1.80245, -1.7551>, <1.42305, 1.38084e-015, 0.06213163>,
                         <-5.02878, -2.14098, 0.1464495>, <1.47503, 5.50775e-016, 0.06440118> }
        smooth_triangle {<-5.0177, -2.86578, -0.1074566>, <1.44787, 5.0307e-016, 0.06321557>,
                         <-5.00305, -3.53815, -0.442968>, <1.35251, 8.41919e-016, 0.05905175>,
                         <-4.92241, -3.13867, -2.28987>, <1.30841, 1.83302e-015, 0.05712632> }
        smooth_triangle {<-4.92241, -3.13867, -2.28987>, <1.3124, 2.15973e-015, 0.05730057>,
                         <-4.93567, -2.49386, -1.98622>, <1.37233, 2.60209e-017, 0.0599171>,
                         <-5.0177, -2.86578, -0.1074566>, <1.417, 1.16226e-015, 0.06186751> }
        smooth_triangle {<-5.00305, -3.53815, -0.442968>, <1.35251, 8.41919e-016, 0.05905175>,
                         <-4.98533, -4.14383, -0.8488576>, <1.24373, -1.95214e-015, 0.05430235>,
                         <-4.90642, -3.72419, -2.65609>, <1.21566, -4.3715e-016, 0.05307697> }
        smooth_triangle {<-4.90642, -3.72419, -2.65609>, <1.21867, -9.1073e-016, 0.05320838>,
                         <-4.92241, -3.13867, -2.28987>, <1.28823, 7.91901e-016, 0.05624539>,
                         <-5.00305, -3.53815, -0.442968>, <1.32131, 4.85723e-017, 0.05768947> }
        smooth_triangle {<-4.98533, -4.14383, -0.8488576>, <1.24373, -1.95214e-015, 0.05430235>,
                         <-4.96603, -4.70303, -1.29095>, <1.16566, 1.9799e-015, 0.0508937>,
                         <-4.88903, -4.2684, -3.05449>, <1.14806, 2.61365e-016, 0.05012547> }
        smooth_triangle {<-4.88903, -4.2684, -3.05449>, <1.14872, 8.4481e-016, 0.05015431>,
                         <-4.90642, -3.72419, -2.65609>, <1.19942, 3.20924e-016, 0.05236793>,
                         <-4.98533, -4.14383, -0.8488576>, <1.22047, -8.1532e-016, 0.05328696> }
        smooth_triangle {<-4.96603, -4.70303, -1.29095>, <1.16566, 1.9799e-015, 0.0508937>,
                         <-4.94615, -5.24214, -1.7461>, <1.13202, 3.92048e-016, 0.04942488>,
                         <-4.87113, -4.79476, -3.46449>, <1.12095, -9.15934e-016, 0.04894174> }
        smooth_triangle {<-4.87113, -4.79476, -3.46449>, <1.11612, -1.08709e-015, 0.04873067>,
                         <-4.88903, -4.2684, -3.05449>, <1.13766, -1.61329e-016, 0.04967124>,
                         <-4.96603, -4.70303, -1.29095>, <1.15085, 1.12757e-015, 0.05024741> }
        smooth_triangle {<-5.07701, 4.98935, 1.25099>, <0.9222761, -1.32533e-015, 0.04026745>,
                         <-5.09769, 4.48043, 1.7247>, <0.9764114, -4.73001e-016, 0.04263105>,
                         <-5.01795, 4.49566, -0.1017107>, <0.963007, -3.7817e-016, 0.0420458> }
        smooth_triangle {<-5.01795, 4.49566, -0.1017107>, <0.9448672, -5.11743e-016, 0.0412538>,
                         <-4.9996, 5.00052, -0.5220608>, <0.9006035, -7.92769e-016, 0.0393212>,
                         <-5.07701, 4.98935, 1.25099>, <0.906362, -1.1189e-015, 0.03957263> }
        smooth_triangle {<-5.09769, 4.48043, 1.7247>, <0.9764114, -4.73001e-016, 0.04263105>,
                         <-5.11629, 3.89649, 2.15071>, <1.17533, 1.00961e-015, 0.05131619>,
                         <-5.03443, 3.92327, 0.275707>, <1.14287, -6.09466e-016, 0.04989886> }
        smooth_triangle {<-5.03443, 3.92327, 0.275707>, <1.11707, -4.75314e-016, 0.04877229>,
                         <-5.01795, 4.49566, -0.1017107>, <0.9821705, -3.01842e-016, 0.04288249>,
                         <-5.09769, 4.48043, 1.7247>, <0.9922238, -3.72966e-016, 0.04332143> }
        smooth_triangle {<-5.11629, 3.89649, 2.15071>, <1.17533, 1.00961e-015, 0.05131619>,
                         <-5.12918, 3.18659, 2.44577>, <1.41138, 2.49222e-016, 0.06162216>,
                         <-5.04576, 3.23753, 0.5352753>, <1.35761, 1.13393e-015, 0.05927445> }
        smooth_triangle {<-5.04576, 3.23753, 0.5352753>, <1.33791, 8.83408e-016, 0.05841451>,
                         <-5.03443, 3.92327, 0.275707>, <1.17686, -4.2414e-016, 0.05138281>,
                         <-5.11629, 3.89649, 2.15071>, <1.20121, 7.90167e-016, 0.05244581> }
        smooth_triangle {<-5.12918, 3.18659, 2.44577>, <1.41138, 2.49222e-016, 0.06162216>,
                         <-5.13538, 2.39879, 2.5878>, <1.54736, -3.64292e-016, 0.06755921>,
                         <-5.05108, 2.48167, 0.6571089>, <1.48263, -7.86553e-016, 0.06473308> }
        smooth_triangle {<-5.05108, 2.48167, 0.6571089>, <1.47144, -8.09791e-016, 0.06424432>,
                         <-5.04576, 3.23753, 0.5352753>, <1.37767, 6.30572e-016, 0.06015035>,
                         <-5.12918, 3.18659, 2.44577>, <1.418, -3.29597e-017, 0.06191113> }
        smooth_triangle {<-5.13538, 2.39879, 2.5878>, <1.54736, -3.64292e-016, 0.06755921>,
                         <-5.13724, 1.58883, 2.63045>, <1.59356, 6.9454e-016, 0.0695764>,
                         <-5.05249, 1.70587, 0.6895032>, <1.52611, 1.62327e-015, 0.06663126> }
        smooth_triangle {<-5.05249, 1.70587, 0.6895032>, <1.51837, 2.10552e-015, 0.06629334>,
                         <-5.05108, 2.48167, 0.6571089>, <1.48576, 2.98156e-016, 0.0648697>,
                         <-5.13538, 2.39879, 2.5878>, <1.53431, 6.14851e-016, 0.0669893> }
        smooth_triangle {<-5.13724, 1.58883, 2.63045>, <1.59356, 6.9454e-016, 0.0695764>,
                         <-5.13631, 0.7746984, 2.60911>, <1.6083, -2.25514e-015, 0.0702201>,
                         <-5.05139, 0.9263111, 0.6643066>, <1.5408, -8.7047e-016, 0.06727278> }
        smooth_triangle {<-5.05139, 0.9263111, 0.6643066>, <1.53461, -1.15831e-015, 0.0670024>,
                         <-5.05249, 1.70587, 0.6895032>, <1.52359, 7.11996e-016, 0.06652126>,
                         <-5.13724, 1.58883, 2.63045>, <1.57418, 1.54499e-017, 0.06873012> }
        smooth_triangle {<-5.13631, 0.7746984, 2.60911>, <1.6083, -2.25514e-015, 0.0702201>,
                         <-5.1332, -0.03747564, 2.53801>, <1.6104, 2.65586e-015, 0.07031164>,
                         <-5.04834, 0.1485168, 0.5943293>, <1.54399, 3.38849e-016, 0.0674122> }
        smooth_triangle {<-5.04834, 0.1485168, 0.5943293>, <1.53881, 2.87097e-016, 0.06718595>,
                         <-5.05139, 0.9263111, 0.6643066>, <1.53642, -6.19893e-016, 0.06708139>,
                         <-5.13631, 0.7746984, 2.60911>, <1.58704, -1.6584e-015, 0.06929188> }
        smooth_triangle {<-5.1332, -0.03747564, 2.53801>, <1.6104, 2.65586e-015, 0.07031164>,
                         <-5.12821, -0.8442731, 2.42373>, <1.60436, 1.50863e-015, 0.07004786>,
                         <-5.04359, -0.6244384, 0.4854874>, <1.53992, 2.26092e-015, 0.06723429> }
        smooth_triangle {<-5.04359, -0.6244384, 0.4854874>, <1.53559, 2.82109e-015, 0.06704551>,
                         <-5.04834, 0.1485168, 0.5943293>, <1.53865, 1.37954e-015, 0.06717895>,
                         <-5.1332, -0.03747564, 2.53801>, <1.58846, 3.1173e-015, 0.06935353> }
        smooth_triangle {<-5.12821, -0.8442731, 2.42373>, <1.60436, 1.50863e-015, 0.07004786>,
                         <-5.1214, -1.64246, 2.26766>, <1.58933, -9.99779e-016, 0.06939176>,
                         <-5.03719, -1.38965, 0.3390328>, <1.5281, -2.15048e-015, 0.06671847> }
        smooth_triangle {<-5.03719, -1.38965, 0.3390328>, <1.52492, -3.35322e-015, 0.06657931>,
                         <-5.04359, -0.6244384, 0.4854874>, <1.53378, -4.46691e-017, 0.06696617>,
                         <-5.12821, -0.8442731, 2.42373>, <1.58211, -6.08888e-016, 0.06907635> }
        smooth_triangle {<-5.1214, -1.64246, 2.26766>, <1.58933, -9.99779e-016, 0.06939176>,
                         <-5.11235, -2.42524, 2.06034>, <1.55784, 1.29526e-016, 0.06801672>,
                         <-5.02878, -2.14098, 0.1464495>, <1.50238, 1.56009e-015, 0.06559516> }
        smooth_triangle {<-5.02878, -2.14098, 0.1464495>, <1.50122, 2.6628e-015, 0.06554451>,
                         <-5.03719, -1.38965, 0.3390328>, <1.52051, -1.2013e-016, 0.06638699>,
                         <-5.1214, -1.64246, 2.26766>, <1.56643, 7.42895e-016, 0.06839195> }
        smooth_triangle {<-5.11235, -2.42524, 2.06034>, <1.55784, 1.29526e-016, 0.06801672>,
                         <-5.10032, -3.17853, 1.78488>, <1.4927, -5.43547e-016, 0.06517275>,
                         <-5.0177, -2.86578, -0.1074566>, <1.44787, 5.0307e-016, 0.06321557> }
        smooth_triangle {<-5.0177, -2.86578, -0.1074566>, <1.45075, -5.73326e-016, 0.06334095>,
                         <-5.02878, -2.14098, 0.1464495>, <1.49162, 2.19443e-016, 0.06512564>,
                         <-5.11235, -2.42524, 2.06034>, <1.53322, -8.53484e-016, 0.06694181> }
        smooth_triangle {<-5.10032, -3.17853, 1.78488>, <1.4927, -5.43547e-016, 0.06517275>,
                         <-5.08433, -3.87356, 1.41874>, <1.38073, -1.66765e-015, 0.06028384>,
                         <-5.00305, -3.53815, -0.442968>, <1.35251, 8.41919e-016, 0.05905175> }
        smooth_triangle {<-5.00305, -3.53815, -0.442968>, <1.3587, 1.98973e-015, 0.05932213>,
                         <-5.0177, -2.86578, -0.1074566>, <1.43023, 1.73559e-015, 0.062445>,
                         <-5.10032, -3.17853, 1.78488>, <1.46385, 9.50628e-016, 0.06391288> }
        smooth_triangle {<-5.08433, -3.87356, 1.41874>, <1.38073, -1.66765e-015, 0.06028384>,
                         <-5.06493, -4.4945, 0.9744087>, <1.25481, 1.70928e-015, 0.05478614>,
                         <-4.98533, -4.14383, -0.8488576>, <1.24373, -1.95214e-015, 0.05430235> }
        smooth_triangle {<-4.98533, -4.14383, -0.8488576>, <1.24873, -1.93942e-015, 0.0545207>,
                         <-5.00305, -3.53815, -0.442968>, <1.33031, 1.56125e-016, 0.05808276>,
                         <-5.08433, -3.87356, 1.41874>, <1.35148, -1.72605e-015, 0.05900683> }
        smooth_triangle {<-5.06493, -4.4945, 0.9744087>, <1.25481, 1.70928e-015, 0.05478614>,
                         <-5.04378, -5.06379, 0.4898529>, <1.16547, 1.69772e-015, 0.05088572>,
                         <-4.96603, -4.70303, -1.29095>, <1.16566, 1.9799e-015, 0.0508937> }
        smooth_triangle {<-4.96603, -4.70303, -1.29095>, <1.16789, 1.18482e-015, 0.05099137>,
                         <-4.98533, -4.14383, -0.8488576>, <1.22645, -1.76421e-015, 0.05354786>,
                         <-5.06493, -4.4945, 0.9744087>, <1.23476, 9.81853e-016, 0.05391071> }
        smooth_triangle {<-5.04378, -5.06379, 0.4898529>, <1.16547, 1.69772e-015, 0.05088572>,
                         <-5.02199, -5.61076, -0.009216236>, <1.12278, 2.48065e-015, 0.0490218>,
                         <-4.94615, -5.24214, -1.7461>, <1.13202, 3.92048e-016, 0.04942488> }
        smooth_triangle {<-4.94615, -5.24214, -1.7461>, <1.12943, 2.63678e-016, 0.04931192>,
                         <-4.96603, -4.70303, -1.29095>, <1.15531, 1.48666e-015, 0.05044177>,
                         <-5.04378, -5.06379, 0.4898529>, <1.15517, 1.27502e-015, 0.05043579> }
        smooth_triangle {<-5.15442, 4.98169, 3.02405>, <0.9234788, 2.39739e-015, 0.04031996>,
                         <-5.17749, 4.47474, 3.55227>, <0.9784486, 1.02811e-015, 0.04271999>,
                         <-5.09769, 4.48043, 1.7247>, <0.9764114, -4.73001e-016, 0.04263105> }
        smooth_triangle {<-5.09769, 4.48043, 1.7247>, <0.9569867, -1.51788e-016, 0.04178295>,
                         <-5.07701, 4.98935, 1.25099>, <0.9104943, -2.56739e-016, 0.03975304>,
                         <-5.15442, 4.98169, 3.02405>, <0.9110957, 1.60462e-015, 0.0397793> }
        smooth_triangle {<-5.17749, 4.47474, 3.55227>, <0.9784486, 1.02811e-015, 0.04271999>,
                         <-5.19826, 3.88526, 4.02802>, <1.1971, 2.04003e-015, 0.05226664>,
                         <-5.11629, 3.89649, 2.15071>, <1.17533, 1.00961e-015, 0.05131619> }
        smooth_triangle {<-5.11629, 3.89649, 2.15071>, <1.14769, 3.35669e-016, 0.05010938>,
                         <-5.09769, 4.48043, 1.7247>, <0.9985015, -7.76289e-016, 0.04359552>,
                         <-5.17749, 4.47474, 3.55227>, <1.00003, 3.49547e-016, 0.04366223> }
        smooth_triangle {<-5.19826, 3.88526, 4.02802>, <1.1971, 2.04003e-015, 0.05226664>,

                         <-5.21274, 3.15723, 4.35974>, <1.45426, 1.71969e-015, 0.06349441>,
                         <-5.12918, 3.18659, 2.44577>, <1.41138, 2.49222e-016, 0.06162216> }
        smooth_triangle {<-5.12918, 3.18659, 2.44577>, <1.39088, 1.30408e-015, 0.06072727>,
                         <-5.11629, 3.89649, 2.15071>, <1.21385, 1.87437e-015, 0.0529978>,
                         <-5.19826, 3.88526, 4.02802>, <1.23018, 2.64719e-015, 0.05371064> }
        smooth_triangle {<-5.21274, 3.15723, 4.35974>, <1.45426, 1.71969e-015, 0.06349441>,
                         <-5.21987, 2.34352, 4.5231>, <1.60028, 1.32128e-016, 0.06986962>,
                         <-5.13538, 2.39879, 2.5878>, <1.54736, -3.64292e-016, 0.06755921> }
        smooth_triangle {<-5.13538, 2.39879, 2.5878>, <1.53643, -1.59768e-015, 0.06708207>,
                         <-5.12918, 3.18659, 2.44577>, <1.43445, -1.13754e-015, 0.06262928>,
                         <-5.21274, 3.15723, 4.35974>, <1.46661, -3.46945e-017, 0.06403347> }
        smooth_triangle {<-5.21987, 2.34352, 4.5231>, <1.60028, 1.32128e-016, 0.06986962>,
                         <-5.22223, 1.50542, 4.57716>, <1.64822, -6.19441e-017, 0.07196275>,
                         <-5.13724, 1.58883, 2.63045>, <1.59356, 6.9454e-016, 0.0695764> }
        smooth_triangle {<-5.13724, 1.58883, 2.63045>, <1.58646, 1.33406e-015, 0.06926644>,
                         <-5.13538, 2.39879, 2.5878>, <1.55181, 5.39933e-016, 0.06775354>,
                         <-5.21987, 2.34352, 4.5231>, <1.5915, 9.12248e-016, 0.06948635> }
        smooth_triangle {<-5.22223, 1.50542, 4.57716>, <1.64822, -6.19441e-017, 0.07196275>,
                         <-5.22152, 0.6627317, 4.56083>, <1.66205, -2.53226e-015, 0.0725665>,
                         <-5.13631, 0.7746984, 2.60911>, <1.6083, -2.25514e-015, 0.0702201> }
        smooth_triangle {<-5.13631, 0.7746984, 2.60911>, <1.60289, -1.86223e-015, 0.06998389>,
                         <-5.13724, 1.58883, 2.63045>, <1.59184, 3.50035e-016, 0.06950112>,
                         <-5.22223, 1.50542, 4.57716>, <1.63283, -2.17328e-016, 0.07129088> }
        smooth_triangle {<-5.22152, 0.6627317, 4.56083>, <1.66205, -2.53226e-015, 0.0725665>,
                         <-5.21842, -0.1777996, 4.48976>, <1.662, 1.91513e-015, 0.07256464>,
                         <-5.1332, -0.03747564, 2.53801>, <1.6104, 2.65586e-015, 0.07031164> }
        smooth_triangle {<-5.1332, -0.03747564, 2.53801>, <1.60607, 1.05363e-015, 0.07012273>,
                         <-5.13631, 0.7746984, 2.60911>, <1.6045, -2.62962e-015, 0.07005408>,
                         <-5.22152, 0.6627317, 4.56083>, <1.64481, -2.83747e-015, 0.07181388> }
        smooth_triangle {<-5.21842, -0.1777996, 4.48976>, <1.662, 1.91513e-015, 0.07256464>,
                         <-5.21324, -1.01242, 4.37119>, <1.65282, 2.73335e-015, 0.0721635>,
                         <-5.12821, -0.8442731, 2.42373>, <1.60436, 1.50863e-015, 0.07004786> }
        smooth_triangle {<-5.12821, -0.8442731, 2.42373>, <1.60095, 3.46294e-015, 0.06989878>,
                         <-5.1332, -0.03747564, 2.53801>, <1.60548, 4.32336e-015, 0.07009661>,
                         <-5.21842, -0.1777996, 4.48976>, <1.64418, 3.76782e-015, 0.07178636> }
        smooth_triangle {<-5.21324, -1.01242, 4.37119>, <1.65282, 2.73335e-015, 0.0721635>,
                         <-5.20606, -1.83756, 4.20665>, <1.63313, -2.58243e-015, 0.07130385>,
                         <-5.1214, -1.64246, 2.26766>, <1.58933, -9.99779e-016, 0.06939176> }
        smooth_triangle {<-5.1214, -1.64246, 2.26766>, <1.58717, -2.15453e-015, 0.06929733>,
                         <-5.12821, -0.8442731, 2.42373>, <1.59844, -2.73219e-016, 0.06978941>,
                         <-5.21324, -1.01242, 4.37119>, <1.63478, 6.45317e-016, 0.07137613> }
        smooth_triangle {<-5.20606, -1.83756, 4.20665>, <1.63313, -2.58243e-015, 0.07130385>,
                         <-5.19641, -2.64576, 3.98574>, <1.59384, 1.85037e-017, 0.06958873>,
                         <-5.11235, -2.42524, 2.06034>, <1.55784, 1.29526e-016, 0.06801672> }
        smooth_triangle {<-5.11235, -2.42524, 2.06034>, <1.55794, 8.69096e-016, 0.06802115>,
                         <-5.1214, -1.64246, 2.26766>, <1.58156, 2.21177e-017, 0.06905243>,
                         <-5.20606, -1.83756, 4.20665>, <1.61441, -1.16487e-015, 0.0704865> }
        smooth_triangle {<-5.19641, -2.64576, 3.98574>, <1.59384, 1.85037e-017, 0.06958873>,
                         <-5.18349, -3.42152, 3.68987>, <1.51514, -1.44792e-015, 0.0661525>,
                         <-5.10032, -3.17853, 1.78488>, <1.4927, -5.43547e-016, 0.06517275> }
        smooth_triangle {<-5.10032, -3.17853, 1.78488>, <1.49731, -5.3256e-016, 0.06537395>,
                         <-5.11235, -2.42524, 2.06034>, <1.54616, -2.77556e-017, 0.06750692>,
                         <-5.19641, -2.64576, 3.98574>, <1.57317, -1.11022e-016, 0.06868593> }
        smooth_triangle {<-5.18349, -3.42152, 3.68987>, <1.51514, -1.44792e-015, 0.0661525>,
                         <-5.16622, -4.1332, 3.29426>, <1.38274, 9.32125e-016, 0.06037174>,
                         <-5.08433, -3.87356, 1.41874>, <1.38073, -1.66765e-015, 0.06028384> }
        smooth_triangle {<-5.08433, -3.87356, 1.41874>, <1.3888, -1.64625e-015, 0.06063618>,
                         <-5.10032, -3.17853, 1.78488>, <1.47278, -8.03177e-016, 0.06430286>,
                         <-5.18349, -3.42152, 3.68987>, <1.48961, -1.48145e-015, 0.06503768> }
        smooth_triangle {<-5.16622, -4.1332, 3.29426>, <1.38274, 9.32125e-016, 0.06037174>,
                         <-5.14519, -4.76336, 2.81264>, <1.23612, 2.84032e-015, 0.05397017>,
                         <-5.06493, -4.4945, 0.9744087>, <1.25481, 1.70928e-015, 0.05478614> }
        smooth_triangle {<-5.06493, -4.4945, 0.9744087>, <1.26109, 2.91434e-016, 0.05506037>,
                         <-5.08433, -3.87356, 1.41874>, <1.35553, -2.24126e-015, 0.05918365>,
                         <-5.16622, -4.1332, 3.29426>, <1.35704, -2.91434e-016, 0.05924957> }
        smooth_triangle {<-5.14519, -4.76336, 2.81264>, <1.23612, 2.84032e-015, 0.05397017>,
                         <-5.12223, -5.33673, 2.28676>, <1.13305, 4.44089e-016, 0.04947002>,
                         <-5.04378, -5.06379, 0.4898529>, <1.16547, 1.69772e-015, 0.05088572> }
        smooth_triangle {<-5.04378, -5.06379, 0.4898529>, <1.1683, 3.12424e-015, 0.05100908>,
                         <-5.06493, -4.4945, 0.9744087>, <1.2353, 3.13291e-015, 0.05393439>,
                         <-5.14519, -4.76336, 2.81264>, <1.22128, 3.98119e-015, 0.05332241> }
        smooth_triangle {<-5.12223, -5.33673, 2.28676>, <1.13305, 4.44089e-016, 0.04947002>,
                         <-5.09858, -5.88554, 1.74493>, <1.07637, 2.00534e-015, 0.04699526>,
                         <-5.02199, -5.61076, -0.009216236>, <1.12278, 2.48065e-015, 0.0490218> }
        smooth_triangle {<-5.02199, -5.61076, -0.009216236>, <1.12155, 1.40628e-015, 0.04896781>,
                         <-5.04378, -5.06379, 0.4898529>, <1.15387, 1.08767e-015, 0.05037925>,
                         <-5.12223, -5.33673, 2.28676>, <1.12956, 1.47451e-016, 0.04931747> }
        smooth_triangle {<-5.23184, 4.9764, 4.79712>, <0.9105766, -8.32667e-016, 0.03975664>,
                         <-5.25732, 4.48016, 5.38086>, <0.9637883, 3.88578e-016, 0.04207991>,
                         <-5.17749, 4.47474, 3.55227>, <0.9784486, 1.02811e-015, 0.04271999> }
        smooth_triangle {<-5.17749, 4.47474, 3.55227>, <0.9578522, 9.47159e-016, 0.04182073>,
                         <-5.15442, 4.98169, 3.02405>, <0.9097709, 1.55084e-015, 0.03972146>,
                         <-5.23184, 4.9764, 4.79712>, <0.9033198, -6.41848e-017, 0.0394398> }
        smooth_triangle {<-5.25732, 4.48016, 5.38086>, <0.9637883, 3.88578e-016, 0.04207991>,
                         <-5.28031, 3.8939, 5.90736>, <1.20353, 2.00071e-015, 0.05254733>,
                         <-5.19826, 3.88526, 4.02802>, <1.1971, 2.04003e-015, 0.05226664> }
        smooth_triangle {<-5.19826, 3.88526, 4.02802>, <1.16795, 1.94202e-015, 0.05099378>,
                         <-5.17749, 4.47474, 3.55227>, <1.00396, 1.18308e-015, 0.04383379>,
                         <-5.25732, 4.48016, 5.38086>, <0.9929635, 7.0343e-016, 0.04335373> }
        smooth_triangle {<-5.28031, 3.8939, 5.90736>, <1.20353, 2.00071e-015, 0.05254733>,
                         <-5.29644, 3.15648, 6.27672>, <1.48107, 6.29705e-016, 0.06466496>,
                         <-5.21274, 3.15723, 4.35974>, <1.45426, 1.71969e-015, 0.06349441> }
        smooth_triangle {<-5.21274, 3.15723, 4.35974>, <1.43346, 1.69656e-015, 0.06258643>,
                         <-5.19826, 3.88526, 4.02802>, <1.2406, 1.93682e-015, 0.0541656>,
                         <-5.28031, 3.8939, 5.90736>, <1.24542, 1.90733e-015, 0.05437612> }
        smooth_triangle {<-5.29644, 3.15648, 6.27672>, <1.48107, 6.29705e-016, 0.06466496>,
                         <-5.30455, 2.32559, 6.46244>, <1.63477, 1.10473e-015, 0.07137571>,
                         <-5.21987, 2.34352, 4.5231>, <1.60028, 1.32128e-016, 0.06986962> }
        smooth_triangle {<-5.21987, 2.34352, 4.5231>, <1.59015, 4.11346e-016, 0.06942739>,
                         <-5.21274, 3.15723, 4.35974>, <1.48064, 1.60202e-015, 0.06464598>,
                         <-5.29644, 3.15648, 6.27672>, <1.50074, 7.84529e-016, 0.0655239> }
        smooth_triangle {<-5.30455, 2.32559, 6.46244>, <1.63477, 1.10473e-015, 0.07137571>,
                         <-5.30745, 1.4681, 6.5289>, <1.68204, -2.26446e-015, 0.07343947>,
                         <-5.22223, 1.50542, 4.57716>, <1.64822, -6.19441e-017, 0.07196275> }
        smooth_triangle {<-5.22223, 1.50542, 4.57716>, <1.64226, -1.9456e-016, 0.07170254>,
                         <-5.21987, 2.34352, 4.5231>, <1.6063, -4.90059e-017, 0.0701327>,
                         <-5.30455, 2.32559, 6.46244>, <1.63217, 6.80445e-016, 0.07126226> }
        smooth_triangle {<-5.30745, 1.4681, 6.5289>, <1.68204, -2.26446e-015, 0.07343947>,
                         <-5.307, 0.6056067, 6.51858>, <1.69263, -1.03995e-015, 0.07390182>,
                         <-5.22152, 0.6627317, 4.56083>, <1.66205, -2.53226e-015, 0.0725665> }
        smooth_triangle {<-5.22152, 0.6627317, 4.56083>, <1.65786, -2.45247e-015, 0.07238391>,
                         <-5.22223, 1.50542, 4.57716>, <1.64749, -5.99726e-016, 0.0719311>,
                         <-5.30745, 1.4681, 6.5289>, <1.67286, -2.25162e-015, 0.07303864> }
        smooth_triangle {<-5.307, 0.6056067, 6.51858>, <1.69263, -1.03995e-015, 0.07390182>,
                         <-5.30394, -0.2545371, 6.44855>, <1.68797, 3.59377e-015, 0.07369847>,
                         <-5.21842, -0.1777996, 4.48976>, <1.662, 1.91513e-015, 0.07256464> }
        smooth_triangle {<-5.21842, -0.1777996, 4.48976>, <1.65891, 2.06671e-015, 0.07242939>,
                         <-5.22152, 0.6627317, 4.56083>, <1.65894, -1.26884e-015, 0.07243078>,
                         <-5.307, 0.6056067, 6.51858>, <1.68188, -1.49606e-016, 0.07343228> }
        smooth_triangle {<-5.30394, -0.2545371, 6.44855>, <1.68797, 3.59377e-015, 0.07369847>,
                         <-5.29862, -1.10823, 6.3267>, <1.67288, 2.27538e-015, 0.07303946>,
                         <-5.21324, -1.01242, 4.37119>, <1.65282, 2.73335e-015, 0.0721635> }
        smooth_triangle {<-5.21324, -1.01242, 4.37119>, <1.6506, 2.22001e-015, 0.07206658>,
                         <-5.21842, -0.1777996, 4.48976>, <1.65749, 1.60635e-015, 0.07236743>,
                         <-5.30394, -0.2545371, 6.44855>, <1.67696, 2.86533e-015, 0.07321781> }
        smooth_triangle {<-5.29862, -1.10823, 6.3267>, <1.67288, 2.27538e-015, 0.07303946>,
                         <-5.29111, -1.95159, 6.1547>, <1.64521, -2.35575e-015, 0.07183125>,
                         <-5.20606, -1.83756, 4.20665>, <1.63313, -2.58243e-015, 0.07130385> }
        smooth_triangle {<-5.20606, -1.83756, 4.20665>, <1.63218, -2.05348e-015, 0.07126255>,
                         <-5.21324, -1.01242, 4.37119>, <1.64695, 1.93335e-015, 0.07190729>,
                         <-5.29862, -1.10823, 6.3267>, <1.66199, 1.58987e-015, 0.07256426> }
        smooth_triangle {<-5.29111, -1.95159, 6.1547>, <1.64521, -2.35575e-015, 0.07183125>,
                         <-5.28092, -2.77645, 5.92119>, <1.59361, 4.70688e-016, 0.06957872>,
                         <-5.19641, -2.64576, 3.98574>, <1.59384, 1.85037e-017, 0.06958873> }
        smooth_triangle {<-5.19641, -2.64576, 3.98574>, <1.59528, -5.9848e-016, 0.06965138>,
                         <-5.20606, -1.83756, 4.20665>, <1.62474, -2.54918e-015, 0.07093772>,
                         <-5.29111, -1.95159, 6.1547>, <1.6338, -2.37917e-015, 0.07133327> }
        smooth_triangle {<-5.28092, -2.77645, 5.92119>, <1.59361, 4.70688e-016, 0.06957872>,
                         <-5.26715, -3.56594, 5.60592>, <1.49497, -2.85651e-015, 0.06527189>,
                         <-5.18349, -3.42152, 3.68987>, <1.51514, -1.44792e-015, 0.0661525> }
        smooth_triangle {<-5.18349, -3.42152, 3.68987>, <1.52139, -9.02924e-016, 0.06642515>,
                         <-5.19641, -2.64576, 3.98574>, <1.58041, 1.96891e-016, 0.06900233>,
                         <-5.28092, -2.77645, 5.92119>, <1.58024, 5.3603e-016, 0.06899482> }
        smooth_triangle {<-5.26715, -3.56594, 5.60592>, <1.49497, -2.85651e-015, 0.06527189>,
                         <-5.24863, -4.28552, 5.18184>, <1.33399, 3.26359e-015, 0.05824338>,
                         <-5.16622, -4.1332, 3.29426>, <1.38274, 9.32125e-016, 0.06037174> }
        smooth_triangle {<-5.16622, -4.1332, 3.29426>, <1.39224, 1.09635e-015, 0.06078664>,
                         <-5.18349, -3.42152, 3.68987>, <1.49154, -6.88685e-016, 0.06512221>,
                         <-5.26715, -3.56594, 5.60592>, <1.47642, -1.74513e-015, 0.06446175> }
        smooth_triangle {<-5.24863, -4.28552, 5.18184>, <1.33399, 3.26359e-015, 0.05824338>,
                         <-5.22602, -4.91617, 4.66393>, <1.15914, 9.76071e-016, 0.05060931>,
                         <-5.14519, -4.76336, 2.81264>, <1.23612, 2.84032e-015, 0.05397017> }
        smooth_triangle {<-5.14519, -4.76336, 2.81264>, <1.2428, 2.60382e-015, 0.05426193>,
                         <-5.16622, -4.1332, 3.29426>, <1.35277, 1.17267e-015, 0.05906311>,
                         <-5.24863, -4.28552, 5.18184>, <1.31621, 2.92127e-015, 0.05746684> }
        smooth_triangle {<-5.22602, -4.91617, 4.66393>, <1.15914, 9.76071e-016, 0.05060931>,
                         <-5.2013, -5.48486, 4.09775>, <1.03705, 1.73472e-015, 0.04527866>,
                         <-5.12223, -5.33673, 2.28676>, <1.13305, 4.44089e-016, 0.04947002> }
        smooth_triangle {<-5.12223, -5.33673, 2.28676>, <1.13524, 2.5327e-016, 0.04956583>,
                         <-5.14519, -4.76336, 2.81264>, <1.21255, 2.05044e-015, 0.05294094>,
                         <-5.22602, -4.91617, 4.66393>, <1.15481, 6.52256e-016, 0.0504203> }
        smooth_triangle {<-5.2013, -5.48486, 4.09775>, <1.03705, 1.73472e-015, 0.04527866>,
                         <-5.17582, -6.02676, 3.51415>, <0.9540894, -2.32453e-016, 0.04165645>,
                         <-5.09858, -5.88554, 1.74493>, <1.07637, 2.00534e-015, 0.04699526> }
        smooth_triangle {<-5.09858, -5.88554, 1.74493>, <1.07563, 3.23584e-015, 0.04696297>,
                         <-5.12223, -5.33673, 2.28676>, <1.11832, 1.75727e-015, 0.04882711>,
                         <-5.2013, -5.48486, 4.09775>, <1.04633, 2.72525e-015, 0.0456836> }
        smooth_triangle {<-5.30925, 4.9727, 6.5702>, <0.8744545, -3.95517e-016, 0.03817951>,
                         <-5.33717, 4.50226, 7.20962>, <0.9250952, 4.55654e-016, 0.04039053>,
                         <-5.25732, 4.48016, 5.38086>, <0.9637883, 3.88578e-016, 0.04207991> }
        smooth_triangle {<-5.25732, 4.48016, 5.38086>, <0.9422678, 1.82146e-017, 0.0411403>,
                         <-5.23184, 4.9764, 4.79712>, <0.8941415, -9.62772e-016, 0.03903906>,
                         <-5.30925, 4.9727, 6.5702>, <0.8760804, -7.44196e-016, 0.0382505> }
        smooth_triangle {<-5.33717, 4.50226, 7.20962>, <0.9250952, 4.55654e-016, 0.04039053>,
                         <-5.36238, 3.93429, 7.78703>, <1.18658, 9.39064e-016, 0.05180699>,
                         <-5.28031, 3.8939, 5.90736>, <1.20353, 2.00071e-015, 0.05254733> }
        smooth_triangle {<-5.28031, 3.8939, 5.90736>, <1.17359, 2.00187e-015, 0.05124012>,
                         <-5.25732, 4.48016, 5.38086>, <0.9937841, 7.92769e-016, 0.04338955>,
                         <-5.33717, 4.50226, 7.20962>, <0.9647642, 8.43076e-016, 0.04212252> }
        smooth_triangle {<-5.36238, 3.93429, 7.78703>, <1.18658, 9.39064e-016, 0.05180699>,
                         <-5.38016, 3.20257, 8.19421>, <1.48215, -1.98915e-016, 0.06471214>,
                         <-5.29644, 3.15648, 6.27672>, <1.48107, 6.29705e-016, 0.06466496> }
        smooth_triangle {<-5.29644, 3.15648, 6.27672>, <1.46106, 9.45858e-016, 0.06379114>,
                         <-5.28031, 3.8939, 5.90736>, <1.2529, 1.97412e-015, 0.05470291>,
                         <-5.36238, 3.93429, 7.78703>, <1.24019, 1.17788e-015, 0.05414766> }
        smooth_triangle {<-5.38016, 3.20257, 8.19421>, <1.48215, -1.98915e-016, 0.06471214>,
                         <-5.38925, 2.36958, 8.40244>, <1.63953, -2.83338e-016, 0.07158349>,
                         <-5.30455, 2.32559, 6.46244>, <1.63477, 1.10473e-015, 0.07137571> }
        smooth_triangle {<-5.30455, 2.32559, 6.46244>, <1.62653, 8.61073e-016, 0.07101563>,
                         <-5.29644, 3.15648, 6.27672>, <1.51125, 5.04805e-016, 0.06598257>,
                         <-5.38016, 3.20257, 8.19421>, <1.51206, -1.1666e-016, 0.06601796> }
        smooth_triangle {<-5.38925, 2.36958, 8.40244>, <1.63953, -2.83338e-016, 0.07158349>,
                         <-5.3927, 1.50778, 8.48148>, <1.68226, 9.78185e-016, 0.07344923>,
                         <-5.30745, 1.4681, 6.5289>, <1.68204, -2.26446e-015, 0.07343947> }
        smooth_triangle {<-5.30745, 1.4681, 6.5289>, <1.67814, -9.99472e-016, 0.07326929>,
                         <-5.30455, 2.32559, 6.46244>, <1.64269, 1.52742e-015, 0.07172147>,
                         <-5.38925, 2.36958, 8.40244>, <1.64626, 4.86373e-016, 0.07187731> }
        smooth_triangle {<-5.3927, 1.50778, 8.48148>, <1.68226, 9.78185e-016, 0.07344923>,
                         <-5.39252, 0.6405563, 8.47733>, <1.68589, 1.32261e-015, 0.07360756>,
                         <-5.307, 0.6056067, 6.51858>, <1.69263, -1.03995e-015, 0.07390182> }
        smooth_triangle {<-5.307, 0.6056067, 6.51858>, <1.69039, -2.81588e-015, 0.07380412>,
                         <-5.30745, 1.4681, 6.5289>, <1.68245, -3.73426e-015, 0.07345735>,
                         <-5.3927, 1.50778, 8.48148>, <1.68262, -1.30228e-015, 0.07346467> }
        smooth_triangle {<-5.39252, 0.6405563, 8.47733>, <1.68589, 1.32261e-015, 0.07360756>,
                         <-5.38951, -0.2241199, 8.4085>, <1.67272, 3.50992e-016, 0.07303244>,
                         <-5.30394, -0.2545371, 6.44855>, <1.68797, 3.59377e-015, 0.07369847> }
        smooth_triangle {<-5.30394, -0.2545371, 6.44855>, <1.68657, 3.33869e-015, 0.07363721>,
                         <-5.307, 0.6056067, 6.51858>, <1.69006, -1.36596e-016, 0.07378973>,
                         <-5.39252, 0.6405563, 8.47733>, <1.68501, 1.63533e-015, 0.07356903> }
        smooth_triangle {<-5.38951, -0.2241199, 8.4085>, <1.67272, 3.50992e-016, 0.07303244>,
                         <-5.38406, -1.08181, 8.28353>, <1.64746, -2.1551e-015, 0.07192953>,
                         <-5.29862, -1.10823, 6.3267>, <1.67288, 2.27538e-015, 0.07303946> }
        smooth_triangle {<-5.29862, -1.10823, 6.3267>, <1.67203, 3.74917e-015, 0.07300246>,
                         <-5.30394, -0.2545371, 6.44855>, <1.68335, 4.73796e-015, 0.07349671>,
                         <-5.38951, -0.2241199, 8.4085>, <1.67191, 2.30588e-015, 0.0729972> }
        smooth_triangle {<-5.38406, -1.08181, 8.28353>, <1.64746, -2.1551e-015, 0.07192953>,
                         <-5.37623, -1.9283, 8.10423>, <1.60673, -1.93017e-015, 0.07015137>,
                         <-5.29111, -1.95159, 6.1547>, <1.64521, -2.35575e-015, 0.07183125> }
        smooth_triangle {<-5.29111, -1.95159, 6.1547>, <1.64535, -2.85796e-015, 0.07183743>,
                         <-5.29862, -1.10823, 6.3267>, <1.6661, 6.15393e-016, 0.07274359>,
                         <-5.38406, -1.08181, 8.28353>, <1.64704, -2.70747e-015, 0.07191113> }
        smooth_triangle {<-5.37623, -1.9283, 8.10423>, <1.60673, -1.93017e-015, 0.07015137>,
                         <-5.36549, -2.75476, 7.85831>, <1.53618, 4.46402e-016, 0.06707121>,
                         <-5.28092, -2.77645, 5.92119>, <1.59361, 4.70688e-016, 0.06957872> }
        smooth_triangle {<-5.28092, -2.77645, 5.92119>, <1.59588, 1.01568e-015, 0.06967753>,
                         <-5.29111, -1.95159, 6.1547>, <1.63457, -1.10415e-015, 0.07136693>,
                         <-5.37623, -1.9283, 8.10423>, <1.60571, -7.84962e-016, 0.07010702> }
        smooth_triangle {<-5.36549, -2.75476, 7.85831>, <1.53618, 4.46402e-016, 0.06707121>,
                         <-5.35089, -3.54289, 7.5238>, <1.40867, -2.33609e-016, 0.06150366>,
                         <-5.26715, -3.56594, 5.60592>, <1.49497, -2.85651e-015, 0.06527189> }
        smooth_triangle {<-5.26715, -3.56594, 5.60592>, <1.50185, -3.47812e-015, 0.06557219>,
                         <-5.28092, -2.77645, 5.92119>, <1.57583, -9.82721e-016, 0.06880232>,
                         <-5.36549, -2.75476, 7.85831>, <1.53276, -1.00094e-015, 0.06692169> }
        smooth_triangle {<-5.35089, -3.54289, 7.5238>, <1.40867, -2.33609e-016, 0.06150366>,
                         <-5.33114, -4.25529, 7.07142>, <1.20885, -2.09555e-015, 0.05277965>,
                         <-5.24863, -4.28552, 5.18184>, <1.33399, 3.26359e-015, 0.05824338> }
        smooth_triangle {<-5.24863, -4.28552, 5.18184>, <1.34307, 2.10595e-015, 0.05863956>,
                         <-5.26715, -3.56594, 5.60592>, <1.4638, -2.48412e-015, 0.06391094>,
                         <-5.35089, -3.54289, 7.5238>, <1.39907, -5.16948e-016, 0.06108477> }
        smooth_triangle {<-5.33114, -4.25529, 7.07142>, <1.20885, -2.09555e-015, 0.05277965>,
                         <-5.30695, -4.87135, 6.51738>, <0.9971106, 1.27213e-016, 0.04353479>,
                         <-5.22602, -4.91617, 4.66393>, <1.15914, 9.76071e-016, 0.05060931> }
        smooth_triangle {<-5.22602, -4.91617, 4.66393>, <1.16336, 2.61249e-015, 0.05079338>,
                         <-5.24863, -4.28552, 5.18184>, <1.2945, 4.32814e-015, 0.05651893>,
                         <-5.33114, -4.25529, 7.07142>, <1.20064, 3.08781e-016, 0.05242114> }
        smooth_triangle {<-5.30695, -4.87135, 6.51738>, <0.9971106, 1.27213e-016, 0.04353479>,
                         <-5.28047, -5.42028, 5.91105>, <0.8499062, 1.4988e-015, 0.03710771>,
                         <-5.2013, -5.48486, 4.09775>, <1.03705, 1.73472e-015, 0.04527866> }
        smooth_triangle {<-5.2013, -5.48486, 4.09775>, <1.03495, 2.61943e-016, 0.04518708>,
                         <-5.22602, -4.91617, 4.66393>, <1.12652, -3.07046e-016, 0.04918506>,
                         <-5.30695, -4.87135, 6.51738>, <1.005, -9.4369e-016, 0.04387917> }
        smooth_triangle {<-5.28047, -5.42028, 5.91105>, <0.8499062, 1.4988e-015, 0.03710771>,
                         <-5.25318, -5.9402, 5.28586>, <0.7425793, 2.09555e-015, 0.03242171>,
                         <-5.17582, -6.02676, 3.51415>, <0.9540894, -2.32453e-016, 0.04165645> }
        smooth_triangle {<-5.17582, -6.02676, 3.51415>, <0.9510412, -5.43547e-016, 0.04152336>,
                         <-5.2013, -5.48486, 4.09775>, <1.01403, 1.00961e-015, 0.04427329>,
                         <-5.28047, -5.42028, 5.91105>, <0.8736659, 8.32667e-016, 0.03814508> }
        smooth_triangle {<-5.38667, 4.97002, 8.34328>, <0.809907, 1.249e-016, 0.03536131>,
                         <-5.41693, 4.54164, 9.03652>, <0.8611511, 8.71988e-016, 0.03759867>,
                         <-5.33717, 4.50226, 7.20962>, <0.9250952, 4.55654e-016, 0.04039053> }
        smooth_triangle {<-5.33717, 4.50226, 7.20962>, <0.9019257, 2.41127e-016, 0.03937893>,
                         <-5.30925, 4.9727, 6.5702>, <0.8534359, -3.98986e-016, 0.03726182>,
                         <-5.38667, 4.97002, 8.34328>, <0.8211622, -1.38778e-016, 0.03585272> }
        smooth_triangle {<-5.41693, 4.54164, 9.03652>, <0.8611511, 8.71988e-016, 0.03759867>,
                         <-5.44428, 4.00822, 9.66297>, <1.14225, 3.27284e-016, 0.04987161>,
                         <-5.36238, 3.93429, 7.78703>, <1.18658, 9.39064e-016, 0.05180699> }
        smooth_triangle {<-5.36238, 3.93429, 7.78703>, <1.15502, 9.83588e-016, 0.05042939>,
                         <-5.33717, 4.50226, 7.20962>, <0.9589129, 6.21031e-016, 0.04186705>,
                         <-5.41693, 4.54164, 9.03652>, <0.9109549, 9.33281e-016, 0.03977315> }
        smooth_triangle {<-5.44428, 4.00822, 9.66297>, <1.14225, 3.27284e-016, 0.04987161>,
                         <-5.46363, 3.29847, 10.1061>, <1.45365, -8.5464e-016, 0.06346776>,
                         <-5.38016, 3.20257, 8.19421>, <1.48215, -1.98915e-016, 0.06471214> }
        smooth_triangle {<-5.38016, 3.20257, 8.19421>, <1.46231, -4.08527e-016, 0.06384563>,
                         <-5.36238, 3.93429, 7.78703>, <1.24062, 4.44957e-016, 0.05416677>,
                         <-5.44428, 4.00822, 9.66297>, <1.20738, -1.38778e-017, 0.05271524> }
        smooth_triangle {<-5.46363, 3.29847, 10.1061>, <1.45365, -8.5464e-016, 0.06346776>,
                         <-5.47362, 2.47965, 10.335>, <1.61326, 2.12041e-015, 0.07043637>,
                         <-5.38925, 2.36958, 8.40244>, <1.63953, -2.83338e-016, 0.07158349> }
        smooth_triangle {<-5.38925, 2.36958, 8.40244>, <1.63278, -1.69136e-016, 0.07128893>,
                         <-5.38016, 3.20257, 8.19421>, <1.51475, -1.05818e-016, 0.06613542>,
                         <-5.46363, 3.29847, 10.1061>, <1.49337, -5.97612e-016, 0.06520214> }
        smooth_triangle {<-5.47362, 2.47965, 10.335>, <1.61326, 2.12041e-015, 0.07043637>,
                         <-5.47754, 1.62981, 10.4247>, <1.65036, 1.52838e-015, 0.07205627>,
                         <-5.3927, 1.50778, 8.48148>, <1.68226, 9.78185e-016, 0.07344923> }
        smooth_triangle {<-5.3927, 1.50778, 8.48148>, <1.68024, 3.2728e-016, 0.07336068>,
                         <-5.38925, 2.36958, 8.40244>, <1.64819, -6.18863e-016, 0.07196138>,
                         <-5.47362, 2.47965, 10.335>, <1.62848, 1.18395e-015, 0.07110104> }
        smooth_triangle {<-5.47754, 1.62981, 10.4247>, <1.65036, 1.52838e-015, 0.07205627>,
                         <-5.47755, 0.7741244, 10.4249>, <1.64602, -2.10748e-015, 0.0718668>,
                         <-5.39252, 0.6405563, 8.47733>, <1.68589, 1.32261e-015, 0.07360756> }
        smooth_triangle {<-5.39252, 0.6405563, 8.47733>, <1.6856, 1.68001e-015, 0.07359475>,
                         <-5.3927, 1.50778, 8.48148>, <1.68288, 1.42169e-015, 0.073476>,
                         <-5.47754, 1.62981, 10.4247>, <1.65895, 1.83433e-015, 0.07243129> }
        smooth_triangle {<-5.47755, 0.7741244, 10.4249>, <1.64602, -2.10748e-015, 0.0718668>,
                         <-5.47452, -0.07881703, 10.3554>, <1.62342, -1.94694e-015, 0.07088021>,
                         <-5.38951, -0.2241199, 8.4085>, <1.67272, 3.50992e-016, 0.07303244> }
        smooth_triangle {<-5.38951, -0.2241199, 8.4085>, <1.67324, 3.53884e-016, 0.0730552>,
                         <-5.39252, 0.6405563, 8.47733>, <1.68312, 1.0826e-015, 0.07348654>,
                         <-5.47755, 0.7741244, 10.4249>, <1.65322, -1.48997e-015, 0.07218097> }
        smooth_triangle {<-5.47452, -0.07881703, 10.3554>, <1.62342, -1.94694e-015, 0.07088021>,
                         <-5.46884, -0.9242312, 10.2254>, <1.58717, 1.1056e-015, 0.06929731>,
                         <-5.38406, -1.08181, 8.28353>, <1.64746, -2.1551e-015, 0.07192953> }
        smooth_triangle {<-5.38406, -1.08181, 8.28353>, <1.64851, -8.6476e-016, 0.07197533>,
                         <-5.38951, -0.2241199, 8.4085>, <1.66745, 1.01481e-015, 0.07280252>,
                         <-5.47452, -0.07881703, 10.3554>, <1.63048, -7.08635e-016, 0.07118834> }
        smooth_triangle {<-5.46884, -0.9242312, 10.2254>, <1.58717, 1.1056e-015, 0.06929731>,
                         <-5.46061, -1.75759, 10.037>, <1.53259, -1.63064e-015, 0.06691412>,
                         <-5.37623, -1.9283, 8.10423>, <1.60673, -1.93017e-015, 0.07015137> }
        smooth_triangle {<-5.37623, -1.9283, 8.10423>, <1.60893, -3.11209e-015, 0.07024762>,
                         <-5.38406, -1.08181, 8.28353>, <1.63948, -3.2808e-015, 0.07158123>,
                         <-5.46884, -0.9242312, 10.2254>, <1.59426, -8.35269e-016, 0.06960707> }
        smooth_triangle {<-5.46061, -1.75759, 10.037>, <1.53259, -1.63064e-015, 0.06691412>,
                         <-5.44925, -2.56938, 9.77674>, <1.44246, 2.35691e-015, 0.06297911>,
                         <-5.36549, -2.75476, 7.85831>, <1.53618, 4.46402e-016, 0.06707121> }
        smooth_triangle {<-5.36549, -2.75476, 7.85831>, <1.54097, 1.00787e-015, 0.06728027>,
                         <-5.37623, -1.9283, 8.10423>, <1.59388, -7.74554e-016, 0.06959039>,
                         <-5.46061, -1.75759, 10.037>, <1.53827, -5.49907e-016, 0.06716245> }
        smooth_triangle {<-5.44925, -2.56938, 9.77674>, <1.44246, 2.35691e-015, 0.06297911>,
                         <-5.43373, -3.33988, 9.42113>, <1.28595, 2.01228e-016, 0.05614568>,
                         <-5.35089, -3.54289, 7.5238>, <1.40867, -2.33609e-016, 0.06150366> }
        smooth_triangle {<-5.35089, -3.54289, 7.5238>, <1.41899, -8.25728e-016, 0.06195447>,
                         <-5.36549, -2.75476, 7.85831>, <1.51463, -3.1572e-016, 0.06613013>,
                         <-5.44925, -2.56938, 9.77674>, <1.44434, 1.11716e-015, 0.06306106> }
        smooth_triangle {<-5.43373, -3.33988, 9.42113>, <1.28595, 2.01228e-016, 0.05614568>,
                         <-5.41266, -4.02883, 8.93858>, <1.04863, -5.34295e-016, 0.045784>,
                         <-5.33114, -4.25529, 7.07142>, <1.20885, -2.09555e-015, 0.05277965> }
        smooth_triangle {<-5.33114, -4.25529, 7.07142>, <1.22159, -8.18789e-016, 0.05333596>,
                         <-5.35089, -3.54289, 7.5238>, <1.37145, 5.77663e-016, 0.05987897>,
                         <-5.43373, -3.33988, 9.42113>, <1.27942, 9.03791e-016, 0.05586048> }
        smooth_triangle {<-5.41266, -4.02883, 8.93858>, <1.04863, -5.34295e-016, 0.045784>,
                         <-5.38681, -4.61403, 8.34655>, <0.8021508, 1.34615e-015, 0.03502267>,
                         <-5.30695, -4.87135, 6.51738>, <0.9971106, 1.27213e-016, 0.04353479> }
        smooth_triangle {<-5.30695, -4.87135, 6.51738>, <1.00404, -7.25114e-016, 0.04383726>,
                         <-5.33114, -4.25529, 7.07142>, <1.16284, -2.39218e-015, 0.0507709>,
                         <-5.41266, -4.02883, 8.93858>, <1.04267, -1.22125e-015, 0.04552416> }
        smooth_triangle {<-5.38681, -4.61403, 8.34655>, <0.8021508, 1.34615e-015, 0.03502267>,
                         <-5.3585, -5.12694, 7.69821>, <0.631392, 2.72005e-015, 0.02756717>,
                         <-5.28047, -5.42028, 5.91105>, <0.8499062, 1.4988e-015, 0.03710771> }
        smooth_triangle {<-5.28047, -5.42028, 5.91105>, <0.8494496, 2.84495e-015, 0.03708778>,
                         <-5.30695, -4.87135, 6.51738>, <0.9598529, 1.81626e-015, 0.04190809>,
                         <-5.38681, -4.61403, 8.34655>, <0.8136331, 2.73045e-015, 0.03552399> }
        smooth_triangle {<-5.3585, -5.12694, 7.69821>, <0.631392, 2.72005e-015, 0.02756717>,
                         <-5.32931, -5.6086, 7.02955>, <0.5237181, 3.85109e-015, 0.02286603>,
                         <-5.25318, -5.9402, 5.28586>, <0.7425793, 2.09555e-015, 0.03242171> }
        smooth_triangle {<-5.25318, -5.9402, 5.28586>, <0.7436449, 1.48955e-015, 0.03246824>,
                         <-5.28047, -5.42028, 5.91105>, <0.8238737, 1.19349e-015, 0.03597111>,
                         <-5.3585, -5.12694, 7.69821>, <0.659988, 2.10942e-015, 0.0288157> }
        smooth_triangle {<-5.46408, 4.96789, 10.1164>, <0.7265734, 1.20043e-015, 0.03172288>,
                         <-5.49662, 4.58926, 10.8617>, <0.8534355, 9.92262e-016, 0.0372618>,
                         <-5.41693, 4.54164, 9.03652>, <0.8611511, 8.71988e-016, 0.03759867> }
        smooth_triangle {<-5.41693, 4.54164, 9.03652>, <0.835383, 8.96852e-016, 0.03647361>,
                         <-5.38667, 4.97002, 8.34328>, <0.7839927, 5.48173e-016, 0.03422986>,
                         <-5.46408, 4.96789, 10.1164>, <0.7423259, 1.08594e-015, 0.03241065> }
        smooth_triangle {<-5.49662, 4.58926, 10.8617>, <0.8534355, 9.92262e-016, 0.0372618>,
                         <-5.52604, 4.0981, 11.5355>, <1.1671, -2.74086e-016, 0.0509567>,
                         <-5.44428, 4.00822, 9.66297>, <1.14225, 3.27284e-016, 0.04987161> }
        smooth_triangle {<-5.44428, 4.00822, 9.66297>, <1.10754, 7.45064e-016, 0.04835636>,
                         <-5.41693, 4.54164, 9.03652>, <0.8967204, 1.15359e-015, 0.03915166>,
                         <-5.49662, 4.58926, 10.8617>, <0.903433, 1.32764e-015, 0.03944474> }
        smooth_triangle {<-5.52604, 4.0981, 11.5355>, <1.1671, -2.74086e-016, 0.0509567>,
                         <-5.54689, 3.41799, 12.0129>, <1.46185, 1.84401e-015, 0.06382581>,
                         <-5.46363, 3.29847, 10.1061>, <1.45365, -8.5464e-016, 0.06346776> }
        smooth_triangle {<-5.46363, 3.29847, 10.1061>, <1.43246, -6.60062e-016, 0.06254262>,
                         <-5.44428, 4.00822, 9.66297>, <1.19891, 2.26381e-016, 0.0523455>,
                         <-5.52604, 4.0981, 11.5355>, <1.23436, -2.08167e-016, 0.05389353> }
        smooth_triangle {<-5.54689, 3.41799, 12.0129>, <1.46185, 1.84401e-015, 0.06382581>,
                         <-5.55771, 2.62104, 12.2608>, <1.59599, 3.63598e-015, 0.06968229>,
                         <-5.47362, 2.47965, 10.335>, <1.61326, 2.12041e-015, 0.07043637> }
        smooth_triangle {<-5.47362, 2.47965, 10.335>, <1.60712, 1.72648e-015, 0.07016827>,
                         <-5.46363, 3.29847, 10.1061>, <1.48741, -5.04805e-016, 0.06494182>,
                         <-5.54689, 3.41799, 12.0129>, <1.50413, 1.41091e-015, 0.06567186> }
        smooth_triangle {<-5.55771, 2.62104, 12.2608>, <1.59599, 3.63598e-015, 0.06968229>,
                         <-5.56202, 1.79085, 12.3595>, <1.62163, -1.41231e-015, 0.07080171>,
                         <-5.47754, 1.62981, 10.4247>, <1.65036, 1.52838e-015, 0.07205627> }
        smooth_triangle {<-5.47754, 1.62981, 10.4247>, <1.6501, 1.55785e-015, 0.07204476>,
                         <-5.47362, 2.47965, 10.335>, <1.62227, 2.00187e-015, 0.07082984>,
                         <-5.55771, 2.62104, 12.2608>, <1.61376, 2.97274e-015, 0.07045828> }
        smooth_triangle {<-5.56202, 1.79085, 12.3595>, <1.62163, -1.41231e-015, 0.07080171>,
                         <-5.56214, 0.9543919, 12.3623>, <1.60982, -3.11971e-015, 0.07028642>,
                         <-5.47755, 0.7741244, 10.4249>, <1.64602, -2.10748e-015, 0.0718668> }
        smooth_triangle {<-5.47755, 0.7741244, 10.4249>, <1.64842, -1.36854e-015, 0.07197153>,
                         <-5.47754, 1.62981, 10.4247>, <1.65167, 1.35835e-015, 0.07211363>,
                         <-5.56202, 1.79085, 12.3595>, <1.63296, -6.58779e-016, 0.07129638> }
        smooth_triangle {<-5.56214, 0.9543919, 12.3623>, <1.60982, -3.11971e-015, 0.07028642>,
                         <-5.559, 0.1208767, 12.2905>, <1.58018, 2.88962e-015, 0.06899223>,
                         <-5.47452, -0.07881703, 10.3554>, <1.62342, -1.94694e-015, 0.07088021> }
        smooth_triangle {<-5.47452, -0.07881703, 10.3554>, <1.62756, -2.02724e-015, 0.07106102>,
                         <-5.47755, 0.7741244, 10.4249>, <1.64451, -2.14764e-015, 0.07180096>,
                         <-5.56214, 0.9543919, 12.3623>, <1.61988, -2.83586e-015, 0.07072542> }
        smooth_triangle {<-5.559, 0.1208767, 12.2905>, <1.58018, 2.88962e-015, 0.06899223>,
                         <-5.55304, -0.7045735, 12.1538>, <1.53597, 2.02963e-016, 0.06706205>,
                         <-5.46884, -0.9242312, 10.2254>, <1.58717, 1.1056e-015, 0.06929731> }
        smooth_triangle {<-5.46884, -0.9242312, 10.2254>, <1.59287, 2.086e-016, 0.06954643>,
                         <-5.47452, -0.07881703, 10.3554>, <1.62007, -2.0808e-015, 0.07073361>,
                         <-5.559, 0.1208767, 12.2905>, <1.59012, 1.09895e-015, 0.06942608> }
        smooth_triangle {<-5.55304, -0.7045735, 12.1538>, <1.53597, 2.02963e-016, 0.06706205>,
                         <-5.54434, -1.51711, 11.9545>, <1.46935, -1.33227e-015, 0.06415312>,
                         <-5.46061, -1.75759, 10.037>, <1.53259, -1.63064e-015, 0.06691412> }
        smooth_triangle {<-5.46061, -1.75759, 10.037>, <1.54085, -1.36176e-015, 0.06727516>,
                         <-5.46884, -0.9242312, 10.2254>, <1.58179, 6.9042e-016, 0.06906255>,
                         <-5.55304, -0.7045735, 12.1538>, <1.54587, -4.97287e-017, 0.06749413> }
        smooth_triangle {<-5.54434, -1.51711, 11.9545>, <1.46935, -1.33227e-015, 0.06415312>,
                         <-5.53228, -2.30653, 11.6783>, <1.35978, 3.02536e-015, 0.05936937>,
                         <-5.44925, -2.56938, 9.77674>, <1.44246, 2.35691e-015, 0.06297911> }
        smooth_triangle {<-5.44925, -2.56938, 9.77674>, <1.45536, 2.42428e-015, 0.06354238>,
                         <-5.46061, -1.75759, 10.037>, <1.52295, -5.66387e-016, 0.06649363>,
                         <-5.54434, -1.51711, 11.9545>, <1.47759, -1.27213e-017, 0.06451281> }
        smooth_triangle {<-5.53228, -2.30653, 11.6783>, <1.35978, 3.02536e-015, 0.05936937>,
                         <-5.51576, -3.05172, 11.2999>, <1.17085, 1.00614e-016, 0.05112038>,
                         <-5.43373, -3.33988, 9.42113>, <1.28595, 2.01228e-016, 0.05614568> }
        smooth_triangle {<-5.43373, -3.33988, 9.42113>, <1.30739, 1.85615e-016, 0.0570818>,
                         <-5.44925, -2.56938, 9.77674>, <1.42477, 1.80238e-015, 0.06220688>,
                         <-5.53228, -2.30653, 11.6783>, <1.36376, 2.06316e-015, 0.05954297> }
        smooth_triangle {<-5.51576, -3.05172, 11.2999>, <1.17085, 1.00614e-016, 0.05112038>,
                         <-5.4933, -3.70953, 10.7855>, <0.9062795, -7.32053e-016, 0.03956902>,
                         <-5.41266, -4.02883, 8.93858>, <1.04863, -5.34295e-016, 0.045784> }
        smooth_triangle {<-5.41266, -4.02883, 8.93858>, <1.0753, -6.78277e-016, 0.04694878>,
                         <-5.43373, -3.33988, 9.42113>, <1.25329, -1.26635e-016, 0.05472004>,
                         <-5.51576, -3.05172, 11.2999>, <1.16568, -3.02998e-016, 0.05089463> }
        smooth_triangle {<-5.4933, -3.70953, 10.7855>, <0.9062795, -7.32053e-016, 0.03956902>,
                         <-5.46572, -4.25618, 10.1538>, <0.6557199, 1.30451e-015, 0.02862935>,
                         <-5.38681, -4.61403, 8.34655>, <0.8021508, 1.34615e-015, 0.03502267> }
        smooth_triangle {<-5.38681, -4.61403, 8.34655>, <0.8245613, 1.51615e-015, 0.03600113>,
                         <-5.41266, -4.02883, 8.93858>, <1.00942, 1.05818e-016, 0.04407212>,
                         <-5.4933, -3.70953, 10.7855>, <0.9014505, 1.8735e-016, 0.03935818> }
        smooth_triangle {<-5.46572, -4.25618, 10.1538>, <0.6557199, 1.30451e-015, 0.02862935>,
                         <-5.4355, -4.72538, 9.46177>, <0.4894251, 2.40086e-015, 0.02136876>,
                         <-5.3585, -5.12694, 7.69821>, <0.631392, 2.72005e-015, 0.02756717> }
        smooth_triangle {<-5.3585, -5.12694, 7.69821>, <0.6472825, 2.47719e-015, 0.02826097>,
                         <-5.38681, -4.61403, 8.34655>, <0.7753516, 1.44676e-015, 0.03385259>,
                         <-5.46572, -4.25618, 10.1538>, <0.6687979, 1.45254e-015, 0.02920035> }
        smooth_triangle {<-5.4355, -4.72538, 9.46177>, <0.4894251, 2.40086e-015, 0.02136876>,
                         <-5.40433, -5.16109, 8.74796>, <0.4292921, 2.70617e-015, 0.0187433>,
                         <-5.32931, -5.6086, 7.02955>, <0.5237181, 3.85109e-015, 0.02286603> }
        smooth_triangle {<-5.32931, -5.6086, 7.02955>, <0.542786, 4.06619e-015, 0.02369855>,
                         <-5.3585, -5.12694, 7.69821>, <0.6187745, 3.16414e-015, 0.02701628>,
                         <-5.4355, -4.72538, 9.46177>, <0.519924, 3.09937e-015, 0.02270038> }
    }
    union { // Poly_Mesh
        smooth_triangle {<3.92898, 4.30995, -15.2845>, <0.3850055, -4.14131, 1.50493>,
                         <-0.2099932, 3.96405, -15.1775>, <0.1230296, -4.17208, 1.46749>,
                         <-0.2098663, 3.60046, -16.1781>, <0.3850055, -4.14131, 1.50493> }
        smooth_triangle {<-0.2098663, 3.60046, -16.1781>, <0.3930264, -4.13087, 1.4595>,
                         <3.8851, 3.96077, -16.2895>, <0.4010474, -4.12044, 1.41406>,
                         <3.92898, 4.30995, -15.2845>, <0.3930264, -4.13087, 1.4595> }
        smooth_triangle {<-0.2099932, 3.96405, -15.1775>, <0.1230296, -4.17208, 1.46749>,
                         <-4.35505, 4.30995, -15.2845>, <-0.3770472, -4.202, 1.41227>,
                         <-4.31117, 3.96077, -16.2895>, <-0.3850055, -4.17059, 1.43218> }
        smooth_triangle {<-4.31117, 3.96077, -16.2895>, <-0.3930265, -4.13712, 1.46167>,
                         <-0.2098663, 3.60046, -16.1781>, <-0.008020951, -4.12248, 1.49804>,
                         <-0.2099932, 3.96405, -15.1775>, <-0.007989639, -4.15497, 1.4734> }
        smooth_triangle {<3.97305, 4.64582, -14.275>, <0.3690889, -4.20434, 1.46534>,
                         <-0.2101201, 4.31433, -14.1724>, <0.1176878, -4.24337, 1.40005>,
                         <-0.2099932, 3.96405, -15.1775>, <0.1230296, -4.17208, 1.46749> }
        smooth_triangle {<-0.2099932, 3.96405, -15.1775>, <0.1885563, -4.17483, 1.44434>,
                         <3.92898, 4.30995, -15.2845>, <0.3850708, -4.1622, 1.43993>,
                         <3.97305, 4.64582, -14.275>, <0.3771125, -4.19371, 1.42013> }
        smooth_triangle {<-0.2101201, 4.31433, -14.1724>, <0.1176878, -4.24337, 1.40005>,
                         <-4.39913, 4.64582, -14.275>, <-0.3610762, -4.27735, 1.33071>,
                         <-4.35505, 4.30995, -15.2845>, <-0.3770472, -4.202, 1.41227> }
        smooth_triangle {<-4.35505, 4.30995, -15.2845>, <-0.3797435, -4.19002, 1.42548>,
                         <-0.2099932, 3.96405, -15.1775>, <-0.004011839, -4.17057, 1.46359>,
                         <-0.2101201, 4.31433, -14.1724>, <-0.008018178, -4.22404, 1.41301> }
        smooth_triangle {<4.01758, 4.94893, -13.2553>, <0.3530635, -4.29236, 1.34245>,
                         <-0.210247, 4.63185, -13.1572>, <0.1118401, -4.34598, 1.20769>,
                         <-0.2101201, 4.31433, -14.1724>, <0.1176878, -4.24337, 1.40005> }
        smooth_triangle {<-0.2101201, 4.31433, -14.1724>, <0.1805438, -4.25009, 1.36333>,
                         <3.97305, 4.64582, -14.275>, <0.3691003, -4.2373, 1.35926>,
                         <4.01758, 4.94893, -13.2553>, <0.3610877, -4.28131, 1.29782> }
        smooth_triangle {<-0.210247, 4.63185, -13.1572>, <0.1118401, -4.34598, 1.20769>,
                         <-4.44365, 4.94893, -13.2553>, <-0.3442919, -4.38721, 1.10322>,
                         <-4.39913, 4.64582, -14.275>, <-0.3610762, -4.27735, 1.33071> }
        smooth_triangle {<-4.39913, 4.64582, -14.275>, <-0.3637547, -4.26922, 1.33049>,
                         <-0.2101201, 4.31433, -14.1724>, <-0.004012088, -4.24577, 1.38255>,
                         <-0.210247, 4.63185, -13.1572>, <-0.008397866, -4.32273, 1.23828> }
        smooth_triangle {<4.06297, 5.17122, -12.2155>, <0.3355204, -4.42429, 1.01157>,
                         <-0.2103738, 4.86856, -12.1218>, <0.1044641, -4.47806, 0.800198>,
                         <-0.210247, 4.63185, -13.1572>, <0.1118401, -4.34598, 1.20769> }
        smooth_triangle {<-0.210247, 4.63185, -13.1572>, <0.1717545, -4.3596, 1.13713>,
                         <4.01758, 4.94893, -13.2553>, <0.3522805, -4.34642, 1.13394>,
                         <4.06297, 5.17122, -12.2155>, <0.343509, -4.41239, 0.9685032> }
        smooth_triangle {<-0.2103738, 4.86856, -12.1218>, <0.1044641, -4.47806, 0.800198>,
                         <-4.48905, 5.17122, -12.2155>, <-0.3244563, -4.51933, 0.6569245>,
                         <-4.44365, 4.94893, -13.2553>, <-0.3442919, -4.38721, 1.10322> }
        smooth_triangle {<-4.44365, 4.94893, -13.2553>, <-0.3466938, -4.3858, 1.0695>,
                         <-0.210247, 4.63185, -13.1572>, <-0.003994293, -4.35522, 1.15628>,
                         <-0.2103738, 4.86856, -12.1218>, <-0.009526316, -4.45429, 0.850659> }
        smooth_triangle {<4.10923, 5.26135, -11.1561>, <0.3133923, -4.55674, 0.4516288>,
                         <-0.2105007, 4.9731, -11.067>, <0.09673379, -4.58886, 0.279054>,
                         <-0.2103738, 4.86856, -12.1218>, <0.1044641, -4.47806, 0.800198> }
        smooth_triangle {<-0.2103738, 4.86856, -12.1218>, <0.1606135, -4.49135, 0.6929372>,
                         <4.06297, 5.17122, -12.2155>, <0.3322911, -4.47775, 0.6913648>,
                         <4.10923, 5.26135, -11.1561>, <0.3212271, -4.54398, 0.4113916> }
        smooth_triangle {<-0.2105007, 4.9731, -11.067>, <0.09673379, -4.58886, 0.279054>,
                         <-4.5353, 5.26135, -11.1561>, <-0.3017968, -4.61919, 0.1548964>,
                         <-4.48905, 5.17122, -12.2155>, <-0.3244563, -4.51933, 0.6569245> }
        smooth_triangle {<-4.48905, 5.17122, -12.2155>, <-0.3259915, -4.51737, 0.5870371>,
                         <-0.2103738, 4.86856, -12.1218>, <-0.003917405, -4.48691, 0.7119641>,
                         <-0.2105007, 4.9731, -11.067>, <-0.009715133, -4.57001, 0.3211061> }
        smooth_triangle {<4.15566, 5.24901, -10.0926>, <0.2902014, -4.62434, 0.009074553>,
                         <-0.2106276, 4.97517, -10.0079>, <0.09063631, -4.64913, -0.06777881>,
                         <-0.2105007, 4.9731, -11.067>, <0.09673379, -4.58886, 0.279054> }
        smooth_triangle {<-0.2105007, 4.9731, -11.067>, <0.1489191, -4.59126, 0.1926153>,
                         <4.10923, 5.26135, -11.1561>, <0.3094337, -4.57759, 0.1924639>,
                         <4.15566, 5.24901, -10.0926>, <0.2978383, -4.61138, -0.02881318> }
        smooth_triangle {<-0.2106276, 4.97517, -10.0079>, <0.09063631, -4.64913, -0.06777881>,
                         <-4.58174, 5.24901, -10.0926>, <-0.2810551, -4.67566, -0.1441497>,
                         <-4.5353, 5.26135, -11.1561>, <-0.3017968, -4.61919, 0.1548964> }
        smooth_triangle {<-4.5353, 5.26135, -11.1561>, <-0.3030229, -4.60627, 0.1062367>,
                         <-0.2105007, 4.9731, -11.067>, <-0.00381844, -4.58675, 0.2115198>,
                         <-0.2106276, 4.97517, -10.0079>, <-0.008391553, -4.63196, -0.04860478> }
        smooth_triangle {<4.20206, 5.20156, -9.02979>, <0.2719089, -4.67019, -0.1457451>,
                         <-0.2107545, 4.94213, -8.94954>, <0.08557106, -4.69597, -0.173122>,
                         <-0.2106276, 4.97517, -10.0079>, <0.09063631, -4.64913, -0.06777881> }
        smooth_triangle {<-0.2106276, 4.97517, -10.0079>, <0.139731, -4.64794, -0.1058036>,
                         <4.15566, 5.24901, -10.0926>, <0.2886082, -4.63435, -0.1054016>,
                         <4.20206, 5.20156, -9.02979>, <0.2794619, -4.65727, -0.1828115> }
        smooth_triangle {<-0.2107545, 4.94213, -8.94954>, <0.08557106, -4.69597, -0.173122>,
                         <-4.62814, 5.20156, -9.02979>, <-0.264311, -4.72285, -0.2247507>,
                         <-4.58174, 5.24901, -10.0926>, <-0.2810551, -4.67566, -0.1441497> }
        smooth_triangle {<-4.58174, 5.24901, -10.0926>, <-0.2830418, -4.65913, -0.1442448>,
                         <-0.2106276, 4.97517, -10.0079>, <-0.003776513, -4.64337, -0.08694286>,
                         <-0.2107545, 4.94213, -8.94954>, <-0.007575449, -4.67849, -0.1659503> }
        smooth_triangle {<4.24846, 5.15306, -7.96705>, <0.2567132, -4.71925, -0.1519875>,
                         <-0.2108814, 4.90804, -7.89126>, <0.08075329, -4.7455, -0.1657886>,
                         <-0.2107545, 4.94213, -8.94954>, <0.08557106, -4.69597, -0.173122> }
        smooth_triangle {<-0.2107545, 4.94213, -8.94954>, <0.1321318, -4.69533, -0.1863592>,
                         <4.20206, 5.20156, -9.02979>, <0.2718614, -4.68181, -0.1859079>,
                         <4.24846, 5.15306, -7.96705>, <0.2642636, -4.70634, -0.1890291> }
        smooth_triangle {<-0.2108814, 4.90804, -7.89126>, <0.08075329, -4.7455, -0.1657886>,
                         <-4.67454, 5.15306, -7.96705>, <-0.2494865, -4.77249, -0.2106087>,
                         <-4.62814, 5.20156, -9.02979>, <-0.264311, -4.72285, -0.2247507> }
        smooth_triangle {<-4.62814, 5.20156, -9.02979>, <-0.266812, -4.70686, -0.2000408>,
                         <-0.2107545, 4.94213, -8.94954>, <-0.003775193, -4.69069, -0.1674968>,
                         <-0.2108814, 4.90804, -7.89126>, <-0.00738852, -4.72784, -0.1619967> }
        smooth_triangle {<4.29488, 5.11256, -6.90397>, <0.2422599, -4.77, -0.1175104>,
                         <-0.2110083, 4.88196, -6.83264>, <0.07589756, -4.79608, -0.1314697>,
                         <-0.2108814, 4.90804, -7.89126>, <0.08075329, -4.7455, -0.1657886> }
        smooth_triangle {<-0.2108814, 4.90804, -7.89126>, <0.1249152, -4.74516, -0.1723337>,
                         <4.24846, 5.15306, -7.96705>, <0.2570571, -4.7317, -0.1719783>,
                         <4.29488, 5.11256, -6.90397>, <0.2498305, -4.75707, -0.1547398> }
        smooth_triangle {<-0.2110083, 4.88196, -6.83264>, <0.07589756, -4.79608, -0.1314697>,
                         <-4.72096, 5.11256, -6.90397>, <-0.2349763, -4.82284, -0.1763504>,
                         <-4.67454, 5.15306, -7.96705>, <-0.2494865, -4.77249, -0.2106087> }
        smooth_triangle {<-4.67454, 5.15306, -7.96705>, <-0.2521247, -4.75676, -0.1792289>,
                         <-0.2108814, 4.90804, -7.89126>, <-0.00378531, -4.74046, -0.1534587>,
                         <-0.2110083, 4.88196, -6.83264>, <-0.007427105, -4.77839, -0.1277196> }
        smooth_triangle {<4.34131, 5.07979, -5.84063>, <0.2276927, -4.82049, -0.08354904>,
                         <-0.2111352, 4.8636, -5.77376>, <0.07099361, -4.84638, -0.09857407>,
                         <-0.2110083, 4.88196, -6.83264>, <0.07589756, -4.79608, -0.1314697> }
        smooth_triangle {<-0.2110083, 4.88196, -6.83264>, <0.1176412, -4.79571, -0.1381947>,
                         <4.29488, 5.11256, -6.90397>, <0.242566, -4.78231, -0.1379402>,
                         <4.34131, 5.07979, -5.84063>, <0.2352824, -4.80755, -0.1209595> }
        smooth_triangle {<-0.2111352, 4.8636, -5.77376>, <0.07099361, -4.84638, -0.09857407>,
                         <-4.76738, 5.07979, -5.84063>, <-0.2203368, -4.87291, -0.1439722>,
                         <-4.72096, 5.11256, -6.90397>, <-0.2349763, -4.82284, -0.1763504> }
        smooth_triangle {<-4.72096, 5.11256, -6.90397>, <-0.2376083, -4.80707, -0.1451754>,
                         <-0.2110083, 4.88196, -6.83264>, <-0.003794878, -4.79094, -0.1193087>,
                         <-0.2111352, 4.8636, -5.77376>, <-0.007472841, -4.82866, -0.09463696> }
        smooth_triangle {<4.38774, 5.05389, -4.7771>, <0.2129808, -4.87069, -0.05282201>,
                         <-0.2112621, 4.85211, -4.71468>, <0.06608148, -4.89644, -0.06632427>,
                         <-0.2111352, 4.8636, -5.77376>, <0.07099361, -4.84638, -0.09857407> }
        smooth_triangle {<-0.2111352, 4.8636, -5.77376>, <0.1102936, -4.84598, -0.1059216>,
                         <4.34131, 5.07979, -5.84063>, <0.2279432, -4.83264, -0.1057567>,
                         <4.38774, 5.05389, -4.7771>, <0.2205873, -4.85774, -0.09039316> }
        smooth_triangle {<-0.2112621, 4.85211, -4.71468>, <0.06608148, -4.89644, -0.06632427>,
                         <-4.81382, 5.05389, -4.7771>, <-0.2056126, -4.92277, -0.1109457>,
                         <-4.76738, 5.07979, -5.84063>, <-0.2203368, -4.87291, -0.1439722> }
        smooth_triangle {<-4.76738, 5.07979, -5.84063>, <-0.2229558, -4.85708, -0.1134427>,
                         <-0.2111352, 4.8636, -5.77376>, <-0.003803229, -4.84114, -0.08702648>,
                         <-0.2112621, 4.85211, -4.71468>, <-0.007487326, -4.87868, -0.06283914> }
        smooth_triangle {<4.43418, 5.03569, -3.7134>, <0.1982445, -4.92075, -0.01755759>,
                         <-0.211389, 4.84832, -3.65544>, <0.06106715, -4.94625, -0.03709398>,
                         <-0.2112621, 4.85211, -4.71468>, <0.06608148, -4.89644, -0.06632427> }
        smooth_triangle {<-0.2112621, 4.85211, -4.71468>, <0.1029346, -4.89604, -0.07300823>,
                         <4.38774, 5.05389, -4.7771>, <0.2132374, -4.88276, -0.07294106>,
                         <4.43418, 5.03569, -3.7134>, <0.2058692, -4.90779, -0.05530885> }
        smooth_triangle {<-0.211389, 4.84832, -3.65544>, <0.06106715, -4.94625, -0.03709398>,
                         <-4.86026, 5.03569, -3.7134>, <-0.190723, -4.97232, -0.08472478>,
                         <-4.81382, 5.05389, -4.7771>, <-0.2056126, -4.92277, -0.1109457> }
        smooth_triangle {<-4.81382, 5.05389, -4.7771>, <-0.2082398, -4.90691, -0.07977854>,
                         <-0.2112621, 4.85211, -4.71468>, <-0.003812393, -4.89113, -0.05410425>,
                         <-0.211389, 4.84832, -3.65544>, <-0.00757314, -4.92849, -0.03218153> }
        smooth_triangle {<4.48063, 5.02118, -2.64966>, <0.1832015, -4.97033, -0.000426135>,
                         <-0.2115158, 4.84823, -2.59616>, <0.05602115, -4.99571, -0.02169411>,
                         <-0.211389, 4.84832, -3.65544>, <0.06106715, -4.94625, -0.03709398> }
        smooth_triangle {<-0.211389, 4.84832, -3.65544>, <0.09541743, -4.94579, -0.04684571>,
                         <4.43418, 5.03569, -3.7134>, <0.1983564, -4.93258, -0.04682924>,
                         <4.48063, 5.02118, -2.64966>, <0.1908349, -4.95737, -0.03826351> }
        smooth_triangle {<-0.2115158, 4.84823, -2.59616>, <0.05602115, -4.99571, -0.02169411>,
                         <-4.9067, 5.02118, -2.64966>, <-0.1756325, -5.02159, -0.07018548>,
                         <-4.86026, 5.03569, -3.7134>, <-0.190723, -4.97232, -0.08472478> }
        smooth_triangle {<-4.86026, 5.03569, -3.7134>, <-0.1933047, -4.95638, -0.0566391>,
                         <-0.211389, 4.84832, -3.65544>, <-0.003816697, -4.94081, -0.02793742>,
                         <-0.2115158, 4.84823, -2.59616>, <-0.007601199, -4.97791, -0.01638751> }
        smooth_triangle {<4.52707, 5.00919, -1.58587>, <0.1680635, -5.01982, 0.01149515>,
                         <-0.2116427, 4.85065, -1.53683>, <0.0509793, -5.04511, -0.008405064>,
                         <-0.2115158, 4.84823, -2.59616>, <0.05602115, -4.99571, -0.02169411> }
        smooth_triangle {<-0.2115158, 4.84823, -2.59616>, <0.08785135, -4.99526, -0.03234485>,
                         <4.48063, 5.02118, -2.64966>, <0.1832717, -4.98211, -0.03236161>,
                         <4.52707, 5.00919, -1.58587>, <0.1757027, -5.00686, -0.02640096> }
        smooth_triangle {<-0.2116427, 4.85065, -1.53683>, <0.0509793, -5.04511, -0.008405064>,
                         <-4.95315, 5.00919, -1.58587>, <-0.1605007, -5.07082, -0.05620693>,
                         <-4.9067, 5.02118, -2.64966>, <-0.1756325, -5.02159, -0.07018548> }
        smooth_triangle {<-4.9067, 5.02118, -2.64966>, <-0.1782023, -5.00564, -0.04300776>,
                         <-0.2115158, 4.84823, -2.59616>, <-0.003819624, -4.99021, -0.01343366>,
                         <-0.2116427, 4.85065, -1.53683>, <-0.007601013, -5.02727, -0.003466876> }
        smooth_triangle {<4.57352, 5.00052, -0.5220608>, <0.1529379, -5.06932, 0.02750926>,
                         <-0.2117696, 4.8564, -0.4774775>, <0.04590069, -5.09448, 0.004639854>,
                         <-0.2116427, 4.85065, -1.53683>, <0.0509793, -5.04511, -0.008405064> }
        smooth_triangle {<-0.2116427, 4.85065, -1.53683>, <0.0802924, -5.04468, -0.01841329>,
                         <4.52707, 5.00919, -1.58587>, <0.1681476, -5.03161, -0.01847142>,
                         <4.57352, 5.00052, -0.5220608>, <0.1605848, -5.05635, -0.01046436> }
        smooth_triangle {<-0.2117696, 4.8564, -0.4774775>, <0.04590069, -5.09448, 0.004639854>,
                         <-4.9996, 5.00052, -0.5220608>, <-0.14532, -5.11999, -0.04464392>,
                         <-4.95315, 5.00919, -1.58587>, <-0.1605007, -5.07082, -0.05620693> }
        smooth_triangle {<-4.95315, 5.00919, -1.58587>, <-0.1630777, -5.05486, -0.02839818>,
                         <-0.2116427, 4.85065, -1.53683>, <-0.003823448, -5.03957, 0.0005010353>,
                         <-0.2117696, 4.8564, -0.4774775>, <-0.007632404, -5.0766, 0.01028472> }
        smooth_triangle {<4.61997, 4.99327, 0.541763>, <0.1377021, -5.1187, 0.03460455>,
                         <-0.2118965, 4.86355, 0.581888>, <0.04081733, -5.14378, 0.01171983>,
                         <-0.2117696, 4.8564, -0.4774775>, <0.04590069, -5.09448, 0.004639854> }
        smooth_triangle {<-0.2117696, 4.8564, -0.4774775>, <0.0726761, -5.09406, -0.006872258>,
                         <4.57352, 5.00052, -0.5220608>, <0.1529701, -5.08105, -0.006949665>,
                         <4.61997, 4.99327, 0.541763>, <0.1453522, -5.10574, -0.003402022> }
        smooth_triangle {<-0.2118965, 4.86355, 0.581888>, <0.04081733, -5.14378, 0.01171983>,
                         <-5.04604, 4.99327, 0.5417629>, <-0.130077, -5.1691, -0.03756931>,
                         <-4.9996, 5.00052, -0.5220608>, <-0.14532, -5.11999, -0.04464392> }
        smooth_triangle {<-4.9996, 5.00052, -0.5220608>, <-0.1478808, -5.10401, -0.01834442>,
                         <-0.2117696, 4.8564, -0.4774775>, <-0.003825058, -5.08888, 0.01204353>,
                         <-0.2118965, 4.86355, 0.581888>, <-0.007637576, -5.12585, 0.01735352> }
        smooth_triangle {<4.66642, 4.98739, 1.6056>, <0.122452, -5.16809, 0.04164854>,
                         <-0.2120234, 4.87209, 1.64126>, <0.03573074, -5.19307, 0.0189706>,
                         <-0.2118965, 4.86355, 0.581888>, <0.04081733, -5.14378, 0.01171983> }
        smooth_triangle {<-0.2118965, 4.86355, 0.581888>, <0.06505263, -5.14338, 0.0001826877>,
                         <4.61997, 4.99327, 0.541763>, <0.1377303, -5.13043, 8.79034e-005>,
                         <4.66642, 4.98739, 1.6056>, <0.1301053, -5.15513, 0.003609899> }
        smooth_triangle {<-0.2120234, 4.87209, 1.64126>, <0.03573074, -5.19307, 0.0189706>,
                         <-5.09249, 4.98739, 1.6056>, <-0.1148221, -5.21821, -0.03021311>,
                         <-5.04604, 4.99327, 0.5417629>, <-0.130077, -5.1691, -0.03756931> }
        smooth_triangle {<-5.04604, 4.99327, 0.5417629>, <-0.1326375, -5.15313, -0.01129972>,
                         <-0.2118965, 4.86355, 0.581888>, <-0.003826625, -5.13813, 0.01909974>,
                         <-0.2120234, 4.87209, 1.64126>, <-0.007641572, -5.1751, 0.02453782> }
        smooth_triangle {<4.71286, 4.98299, 2.66944>, <0.1071922, -5.21746, 0.04930829>,
                         <-0.2121503, 4.8821, 2.70064>, <0.03063091, -5.24235, 0.02506875>,
                         <-0.2120234, 4.87209, 1.64126>, <0.03573074, -5.19307, 0.0189706> }
        smooth_triangle {<-0.2120234, 4.87209, 1.64126>, <0.0574244, -5.19269, 0.007518521>,
                         <4.66642, 4.98739, 1.6056>, <0.1224787, -5.17981, 0.007405408>,
                         <4.71286, 4.98299, 2.66944>, <0.1148488, -5.2045, 0.01123528> }
        smooth_triangle {<-0.2121503, 4.8821, 2.70064>, <0.03063091, -5.24235, 0.02506875>,
                         <-5.13894, 4.98299, 2.66944>, <-0.09954247, -5.26731, -0.02489483>,
                         <-5.09249, 4.98739, 1.6056>, <-0.1148221, -5.21821, -0.03021311> }
        smooth_triangle {<-5.09249, 4.98739, 1.6056>, <-0.1173832, -5.20224, -0.00386374>,
                         <-0.2120234, 4.87209, 1.64126>, <-0.003828293, -5.18737, 0.0264367>,
                         <-0.2121503, 4.8821, 2.70064>, <-0.007653165, -5.22433, 0.03101031> }
        smooth_triangle {<4.75931, 4.97909, 3.73328>, <0.09189273, -5.26682, 0.05227915>,
                         <-0.2122772, 4.89261, 3.76003>, <0.02553484, -5.29161, 0.02923619>,
                         <-0.2121503, 4.8821, 2.70064>, <0.03063091, -5.24235, 0.02506875> }
        smooth_triangle {<-0.2121503, 4.8821, 2.70064>, <0.04977523, -5.24198, 0.01282897>,
                         <4.71286, 4.98299, 2.66944>, <0.1072002, -5.22918, 0.01270897>,
                         <4.75931, 4.97909, 3.73328>, <0.09955046, -5.25385, 0.0141944> }
        smooth_triangle {<-0.2122772, 4.89261, 3.76003>, <0.02553484, -5.29161, 0.02923619>,
                         <-5.18539, 4.97909, 3.73328>, <-0.08424862, -5.31639, -0.02012784>,
                         <-5.13894, 4.98299, 2.66944>, <-0.09954247, -5.26731, -0.02489483> }
        smooth_triangle {<-5.13894, 4.98299, 2.66944>, <-0.1020977, -5.25133, 0.0006649124>,
                         <-0.2121503, 4.8821, 2.70064>, <-0.003828864, -5.2366, 0.03174766>,
                         <-0.2122772, 4.89261, 3.76003>, <-0.00765092, -5.27355, 0.03487324> }
        smooth_triangle {<4.80576, 4.9764, 4.79712>, <0.07660451, -5.31618, 0.05883788>,
                         <-0.2124041, 4.90433, 4.81942>, <0.02042876, -5.34088, 0.03404195>,
                         <-0.2122772, 4.89261, 3.76003>, <0.02553484, -5.29161, 0.02923619> }
        smooth_triangle {<-0.2122772, 4.89261, 3.76003>, <0.04213248, -5.29127, 0.01758014>,
                         <4.75931, 4.97909, 3.73328>, <0.09190907, -5.27853, 0.01744558>,
                         <4.80576, 4.9764, 4.79712>, <0.08426496, -5.30321, 0.02072494> }
        smooth_triangle {<-0.2124041, 4.90433, 4.81942>, <0.02042876, -5.34088, 0.03404195>,
                         <-5.23184, 4.9764, 4.79712>, <-0.06894539, -5.36548, -0.01619815>,
                         <-5.18539, 4.97909, 3.73328>, <-0.08424862, -5.31639, -0.02012784> }
        smooth_triangle {<-5.18539, 4.97909, 3.73328>, <-0.08680755, -5.30041, 0.006011306>,
                         <-0.2122772, 4.89261, 3.76003>, <-0.003830225, -5.28583, 0.03649954>,
                         <-0.2124041, 4.90433, 4.81942>, <-0.007659781, -5.32277, 0.04010386> }
        smooth_triangle {<4.85221, 4.97386, 5.86097>, <0.06128628, -5.36552, 0.06013519>,
                         <-0.212531, 4.91621, 5.8788>, <0.01532526, -5.39014, 0.03649306>,
                         <-0.2124041, 4.90433, 4.81942>, <0.02042876, -5.34088, 0.03404195> }
        smooth_triangle {<-0.2124041, 4.90433, 4.81942>, <0.03447353, -5.34056, 0.02150706>,
                         <4.80576, 4.9764, 4.79712>, <0.07660618, -5.32788, 0.02137013>,
                         <4.85221, 4.97386, 5.86097>, <0.06894707, -5.35256, 0.02201879> }
        smooth_triangle {<-0.212531, 4.91621, 5.8788>, <0.01532526, -5.39014, 0.03649306>,
                         <-5.27829, 4.97386, 5.86097>, <-0.05363104, -5.41455, -0.0131695>,
                         <-5.23184, 4.9764, 4.79712>, <-0.06894539, -5.36548, -0.01619815> }
        smooth_triangle {<-5.23184, 4.9764, 4.79712>, <-0.07149955, -5.34949, 0.009061517>,
                         <-0.2124041, 4.90433, 4.81942>, <-0.003830393, -5.33504, 0.04042667>,
                         <-0.212531, 4.91621, 5.8788>, <-0.007658016, -5.37198, 0.04226501> }
        smooth_triangle {<4.89866, 4.97214, 6.92482>, <0.04597579, -5.41487, 0.06489307>,
                         <-0.2126579, 4.9289, 6.93819>, <0.01021693, -5.43939, 0.03991187>,
                         <-0.212531, 4.91621, 5.8788>, <0.01532526, -5.39014, 0.03649306> }
        smooth_triangle {<-0.212531, 4.91621, 5.8788>, <0.02681921, -5.38984, 0.02452528>,
                         <4.85221, 4.97386, 5.86097>, <0.06129367, -5.37723, 0.02437856>,
                         <4.89866, 4.97214, 6.92482>, <0.05363842, -5.40191, 0.02675751> }
        smooth_triangle {<-0.2126579, 4.9289, 6.93819>, <0.01021693, -5.43939, 0.03991187>,
                         <-5.32473, 4.97214, 6.92482>, <-0.03831329, -5.46363, -0.01042001>,
                         <-5.27829, 4.97386, 5.86097>, <-0.05363104, -5.41455, -0.0131695> }
        smooth_triangle {<-5.27829, 4.97386, 5.86097>, <-0.05618771, -5.39857, 0.01265429>,
                         <-0.212531, 4.91621, 5.8788>, <-0.003831316, -5.38425, 0.04344527>,
                         <-0.2126579, 4.9289, 6.93819>, <-0.007662567, -5.4212, 0.04600937> }
        smooth_triangle {<4.94511, 4.97045, 7.98867>, <0.03065079, -5.46422, 0.06563246>,
                         <-0.2127847, 4.94162, 7.99758>, <0.005109075, -5.48865, 0.04131123>,
                         <-0.2126579, 4.9289, 6.93819>, <0.01021693, -5.43939, 0.03991187> }
        smooth_triangle {<-0.2126579, 4.9289, 6.93819>, <0.01915674, -5.43912, 0.02727389>,
                         <4.89866, 4.97214, 6.92482>, <0.04597599, -5.42658, 0.02712652>,
                         <4.94511, 4.97045, 7.98867>, <0.03831348, -5.45125, 0.02749621> }
        smooth_triangle {<-0.2127847, 4.94162, 7.99758>, <0.005109075, -5.48865, 0.04131123>,
                         <-5.37118, 4.97045, 7.98867>, <-0.02298901, -5.5127, -0.008690396>,
                         <-5.32473, 4.97214, 6.92482>, <-0.03831329, -5.46363, -0.01042001> }
        smooth_triangle {<-5.32473, 4.97214, 6.92482>, <-0.04086759, -5.44765, 0.01473345>,
                         <-0.2126579, 4.9289, 6.93819>, <-0.003831349, -5.43347, 0.046194>,
                         <-0.2127847, 4.94162, 7.99758>, <-0.007662239, -5.47041, 0.04724352> }
        smooth_triangle {<4.99155, 4.96917, 9.05252>, <0.01532722, -5.51356, 0.06835132>,
                         <-0.2129116, 4.95476, 9.05697>, <-1.01424e-010, -5.5379, 0.04333114>,
                         <-0.2127847, 4.94162, 7.99758>, <0.005109075, -5.48865, 0.04131123> }
        smooth_triangle {<-0.2127847, 4.94162, 7.99758>, <0.01149542, -5.48839, 0.02899837>,
                         <4.94511, 4.97045, 7.98867>, <0.03065262, -5.47592, 0.02884612>,
                         <4.99155, 4.96917, 9.05252>, <0.02299084, -5.50059, 0.03020555> }
        smooth_triangle {<-0.2129116, 4.95476, 9.05697>, <-1.01424e-010, -5.5379, 0.04333114>,
                         <-5.41763, 4.96917, 9.05252>, <-0.007663612, -5.56178, -0.007019789>,
                         <-5.37118, 4.97045, 7.98867>, <-0.02298901, -5.5127, -0.008690396> }
        smooth_triangle {<-5.37118, 4.97045, 7.98867>, <-0.02554415, -5.49672, 0.01678668>,
                         <-0.2127847, 4.94162, 7.99758>, <-0.003831806, -5.48267, 0.04791863>,
                         <-0.2129116, 4.95476, 9.05697>, <-0.007663613, -5.51962, 0.04943356> }
        smooth_triangle {<5.038, 4.96789, 10.1164>, <-1.61442e-010, -5.5629, 0.06897282>,
                         <-0.2130385, 4.96789, 10.1164>, <-7.28697e-011, -5.57461, 0.03113197>,
                         <-0.2129116, 4.95476, 9.05697>, <-1.01424e-010, -5.5379, 0.04333114> }
        smooth_triangle {<-0.2129116, 4.95476, 9.05697>, <0.003831809, -5.53767, 0.03066865>,
                         <4.99155, 4.96917, 9.05252>, <0.01532723, -5.52527, 0.03051625>,
                         <5.038, 4.96789, 10.1164>, <0.007663617, -5.54994, 0.030827> }
        smooth_triangle {<-0.2130385, 4.96789, 10.1164>, <-7.28697e-011, -5.57461, 0.03113197>,
                         <-5.46408, 4.96789, 10.1164>, <1.57021e-011, -5.58631, -0.006708877>,
                         <-5.41763, 4.96917, 9.05252>, <-0.007663612, -5.56178, -0.007019789> }
        smooth_triangle {<-5.41763, 4.96917, 9.05252>, <-0.01021815, -5.5458, 0.01810766>,
                         <-0.2129116, 4.95476, 9.05697>, <-0.003831809, -5.53188, 0.049589>,
                         <-0.2130385, 4.96789, 10.1164>, <-0.005109078, -5.55435, 0.04354216> }
    }
}

#declare Leg_Strut =
    union {
        smooth_triangle {<-1.25179e-010, 2.26171, 0.9898942>, <-3.30059, 0, -3.98049e-010>,
                         <7.68304e-011, 2.2539, -0.6851488>, <-3.30059, 0, -3.98049e-010>,
                         <7.68304e-011, 0.2834451, -0.6851488>, <-3.30059, 0, -3.98049e-010> }
        smooth_triangle {<7.68304e-011, 0.2834451, -0.6851488>, <-3.87155, 0, -4.66906e-010>,
                         <-1.25179e-010, -0.3904679, 0.9898942>, <-4.44251, 0, -5.35763e-010>,
                         <-1.25179e-010, 2.26171, 0.9898942>, <-3.87155, 0, -4.66906e-010> }
        smooth_triangle {<-1.25179e-010, -0.3904679, 0.9898942>, <3.64471, 1.12461e-018, 4.39549e-010>,
                         <2.31617e-010, -2.80351, -1.96862>, <3.64471, 1.12461e-018, 4.39549e-010>,
                         <3.04386e-010, -2.06372, -2.57202>, <3.64471, 1.12461e-018, 4.39549e-010> }
        smooth_triangle {<3.04386e-010, -2.06372, -2.57202>, <4.42395, 3.136e-018, 5.33525e-010>,
                         <7.68304e-011, 0.2834451, -0.6851488>, <5.20319, 5.14739e-018, 6.27501e-010>,
                         <-1.25179e-010, -0.3904679, 0.9898942>, <4.42395, 3.136e-018, 5.33525e-010> }
        smooth_triangle {<-0.87817, -2.80351, -1.96862>, <2.81216, 6.18672e-018, 3.39144e-010>,
                         <-0.87817, -2.06372, -2.57202>, <2.81216, 6.18672e-018, 3.39144e-010>,
                         <-0.87817, 0.2834451, -0.6851488>, <2.81216, 6.18672e-018, 3.39144e-010> }
        smooth_triangle {<-0.87817, 0.2834451, -0.6851488>, <4.42395, -3.14866e-017, 5.33525e-010>,
                         <-0.87817, -0.3904679, 0.9898942>, <6.03574, -6.91599e-017, 7.27906e-010>,
                         <-0.87817, -2.80351, -1.96862>, <4.42395, -3.14866e-017, 5.33525e-010> }
        smooth_triangle {<-0.87817, 0.2834451, -0.6851488>, <3.30059, 0, 3.98049e-010>,
                         <-0.87817, 2.2539, -0.6851488>, <3.30059, 0, 3.98049e-010>,
                         <-0.87817, 2.26171, 0.9898942>, <3.30059, 0, 3.98049e-010> }
        smooth_triangle {<-0.87817, 2.26171, 0.9898942>, <3.87155, 0, 4.66906e-010>,
                         <-0.87817, -0.3904679, 0.9898942>, <4.44251, 0, 5.35763e-010>,
                         <-0.87817, 0.2834451, -0.6851488>, <3.87155, 0, 4.66906e-010> }
        smooth_triangle {<7.68304e-011, 2.2539, -0.6851488>, <0, -1.47097, 0.006856751>,
                         <-1.25179e-010, 2.26171, 0.9898942>, <0, -1.47097, 0.006856751>,
                         <-0.87817, 2.26171, 0.9898942>, <0, -1.47097, 0.006856751> }
        smooth_triangle {<-0.87817, 2.26171, 0.9898942>, <0, -1.47097, 0.006856751>,
                         <-0.87817, 2.2539, -0.6851488>, <0, -1.47097, 0.006856751>,
                         <7.68304e-011, 2.2539, -0.6851488>, <0, -1.47097, 0.006856751> }
        smooth_triangle {<-1.25179e-010, 2.26171, 0.9898942>, <0, 0, 2.32906>,
                         <-0.87817, 2.26171, 0.9898942>, <0, 0, 2.32906>,
                         <-0.87817, -0.3904679, 0.9898942>, <0, 0, 2.32906> }
        smooth_triangle {<-0.87817, -0.3904679, 0.9898942>, <0, 0, 2.32906>,
                         <-1.25179e-010, -0.3904679, 0.9898942>, <0, 0, 2.32906>,
                         <-1.25179e-010, 2.26171, 0.9898942>, <0, 0, 2.32906> }
        smooth_triangle {<-0.87817, -0.3904679, 0.9898942>, <0, -2.59808, 2.11906>,
                         <-0.87817, -2.80351, -1.96862>, <0, -2.59808, 2.11906>,
                         <2.31617e-010, -2.80351, -1.96862>, <0, -2.59808, 2.11906> }
        smooth_triangle {<2.31617e-010, -2.80351, -1.96862>, <0, -2.59808, 2.11906>,
                         <-1.25179e-010, -0.3904679, 0.9898942>, <0, -2.59808, 2.11906>,
                         <-0.87817, -0.3904679, 0.9898942>, <0, -2.59808, 2.11906> }
        smooth_triangle {<3.04386e-010, -2.06372, -2.57202>, <0, 0.5298834, 0.649664>,
                         <-0.87817, -2.06372, -2.57202>, <0, 0.5298834, 0.649664>,
                         <-0.87817, -2.80351, -1.96862>, <0, 0.5298834, 0.649664> }
        smooth_triangle {<-0.87817, -2.80351, -1.96862>, <0, 0.5298834, 0.649664>,
                         <2.31617e-010, -2.80351, -1.96862>, <0, 0.5298834, 0.649664>,
                         <3.04386e-010, -2.06372, -2.57202>, <0, 0.5298834, 0.649664> }
        smooth_triangle {<-0.87817, 0.2834451, -0.6851488>, <0, -1.65699, 2.06121>,
                         <-0.87817, -2.06372, -2.57202>, <0, -1.65699, 2.06121>,
                         <3.04386e-010, -2.06372, -2.57202>, <0, -1.65699, 2.06121> }
        smooth_triangle {<3.04386e-010, -2.06372, -2.57202>, <0, -1.65699, 2.06121>,
                         <7.68304e-011, 0.2834451, -0.6851488>, <0, -1.65699, 2.06121>,
                         <-0.87817, 0.2834451, -0.6851488>, <0, -1.65699, 2.06121> }
        smooth_triangle {<-0.87817, 0.2834451, -0.6851488>, <0, 0, -1.73039>,
                         <-0.87817, 2.2539, -0.6851488>, <0, 0, -1.73039>,
                         <7.68304e-011, 2.2539, -0.6851488>, <0, 0, -1.73039> }
        smooth_triangle {<7.68304e-011, 2.2539, -0.6851488>, <0, 0, -1.73039>,
                         <7.68304e-011, 0.2834451, -0.6851488>, <0, 0, -1.73039>,
                         <-0.87817, 0.2834451, -0.6851488>, <0, 0, -1.73039> }
    }

#declare Antenna =
    merge { // Poly_Pipe
        cone { <0, 8.0359, 8.02885>, 0.05, <0, 7.9972, 7.24119>, 0.05 }
        cone { <0, 7.9972, 7.24119>, 0.05, <0, 7.88149, 6.46112>, 0.05 }
        sphere { <0, 7.9972, 7.24119>, 0.05 }
        cone { <0, 7.88149, 6.46112>, 0.05, <0, 7.68987, 5.69615>, 0.05 }
        sphere { <0, 7.88149, 6.46112>, 0.05 }
        cone { <0, 7.68987, 5.69615>, 0.05, <0, 7.4242, 4.95364>, 0.05 }
        sphere { <0, 7.68987, 5.69615>, 0.05 }
        cone { <0, 7.4242, 4.95364>, 0.05, <0, 7.08703, 4.24075>, 0.05 }
        sphere { <0, 7.4242, 4.95364>, 0.05 }
        cone { <0, 7.08703, 4.24075>, 0.05, <0, 6.6816, 3.56434>, 0.05 }
        sphere { <0, 7.08703, 4.24075>, 0.05 }
        cone { <0, 6.6816, 3.56434>, 0.05, <0, 6.21183, 2.93093>, 0.05 }
        sphere { <0, 6.6816, 3.56434>, 0.05 }
        cone { <0, 6.21183, 2.93093>, 0.05, <0, 5.68224, 2.34661>, 0.05 }
        sphere { <0, 6.21183, 2.93093>, 0.05 }
        cone { <0, 5.68224, 2.34661>, 0.05, <0, 5.09792, 1.81701>, 0.05 }
        sphere { <0, 5.68224, 2.34661>, 0.05 }
        cone { <0, 5.09792, 1.81701>, 0.05, <0, 4.4645, 1.34724>, 0.05 }
        sphere { <0, 5.09792, 1.81701>, 0.05 }
        cone { <0, 4.4645, 1.34724>, 0.05, <0, 3.7881, 0.9418184>, 0.05 }
        sphere { <0, 4.4645, 1.34724>, 0.05 }
        cone { <0, 3.7881, 0.9418184>, 0.05, <0, 3.0752, 0.6046461>, 0.05 }
        sphere { <0, 3.7881, 0.9418184>, 0.05 }
        cone { <0, 3.0752, 0.6046461>, 0.05, <0, 2.3327, 0.3389729>, 0.05 }
        sphere { <0, 3.0752, 0.6046461>, 0.05 }
        cone { <0, 2.3327, 0.3389729>, 0.05, <0, 1.56773, 0.1473574>, 0.05 }
        sphere { <0, 2.3327, 0.3389729>, 0.05 }
        cone { <0, 1.56773, 0.1473574>, 0.05, <0, 0.7876556, 0.03164493>, 0.05 }
        sphere { <0, 1.56773, 0.1473574>, 0.05 }
        cone { <0, 0.7876556, 0.03164493>, 0.05, <0, -3.29638e-009, -0.007050106>, 0.05 }
        sphere { <0, 0.7876556, 0.03164493>, 0.05 }
    }

