// Created for the POV "SciFiction" Raytracing Competition
// Persistence of Vision Raytracer 3
//   Joel R. Cheves  1996
//   102366.230@compuserve.com 
//   jcheves@ix.netcom.com 
//   http://ourworld.compuserve.com/homepages/jcheves/

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "greytop.inc"
#include "starbak2.inc"

 camera {
   up <0,1,0>
   right <4/3, 0, 0>
   direction <0, 0, 1>
   location <3.5, .4, -7.7>
   look_at <-2, 1, 0>
} 
atmosphere {
    color rgbf <.1, .5, .9, 0.25>
    type 4
    samples 200
    distance 5000
    scattering .75
    aa_level 8
    aa_threshold 0.2
    jitter 0.05
}

light_source { <3,10,0> White * 1.5 
    spotlight
    cylinder
    radius  1
    falloff 6
    point_at <0,0,5>
}
// spot-bubble
light_source { <-8,15,0> White * 1.1
    spotlight
    cylinder
    radius  1
    falloff 6
    point_at <3,0,-7>
}
//spot-portal
light_source { <-9,20,-3> White * 1.5
    spotlight
    cylinder
    radius  1
    falloff 6
    point_at <0,2.4,0>
}

light_source {<0, 5.1, -3> color White *1.5  atmosphere off} //overhead
light_source {<-2, -3, -7> color White *.25 atmosphere off} //Blue
light_source {  //at cap
    <0, 5.01, -2>
    color White *2
   spotlight
    point_at < 0, 2.50, 0>
    radius 15
    falloff 16
    tightness 1
  atmosphere off
}

 object {
  stars
 }

superellipsoid { 
     <0.9, 0.9> 
   pigment {color VeryDarkBrown}
   finish {
         specular .1
         roughness 0.01
         ambient 0.2
         diffuse 0.8
       }
   scale <1.5, 1, 1>
   rotate <-15, 30, 0>
   translate <.5 ,0, -6>
}

sphere { <0, 0, 0>, .125 //upward
   pigment {color VeryDarkBrown}
   finish {
         specular 1.0
         roughness 0.01
         ambient 0.2
         diffuse 0.8
       }
    translate <0.0, 2.4, -0.201>
   }


#declare focus =
difference {
box { <-1, -1, -1>, <1, 1, 1>
  scale <.03, 1.6, .68>
  rotate <43, 0, 0>
  translate <0, 0.75, -2.15>
  texture {
   pigment {color White }
    finish {
     crand .1}
   }
 }
sphere { <0, 0, 0>, 2.75 
  texture {
   pigment {color White }
    finish {
     ambient .3
     crand .1}
   }
   translate <-1, -.20, -.201>
 }
}

  #declare Count=0
  #while (Count <5)
    object{focus rotate y*71*Count} //72-70
    #declare Count=Count+1
  #end

  cylinder {<0, .15, 0>,<0, -.15, 0>, 4.5 //platform
   texture {greytop 
   finish {
     crand .05}
     scale .15
  }
    translate <0.0, -.025, -0.201>
}

#declare windows =
box { <-1, -1, -1>, <1, 1, 1>
  scale <4.72, .02, .125>
   translate <0.0, -.025, 0>
  texture {
   pigment {color White }
    finish {
     ambient .9
     diffuse .9
     }
  }
}
  #declare Count=0
  #while (Count <72)
    object{windows rotate y*5*Count}
    #declare Count=Count+1
  #end

  cylinder {<0, 5, 0>,<0, -5, 0>, .7 //tube
   texture {greytop
   finish {
     crand .05}
     scale .15
  }
    translate <0.0, -5.1, -0.201>
 }

sphere { <0, 0, 0>, 1 //habitat
   texture {greytop
   finish {
     crand .05}
     scale .15
  }
   translate <0, -.1, -.201>
}

difference {
sphere { <0, 0, 0>, 3.75 
   texture {
   pigment {color VeryDarkBrown}
   finish {
     crand .05}
     scale .15
  }
   scale <1, .375, 1>
   translate <0, -.1, -.201>
}

plane { y,  -.05 inverse }
}

#declare shiptex =
  texture {
   pigment {color Silver } //White
    finish {
         specular .1
         ambient 0.4
         diffuse 0.8
     }
   }
//start ship
#declare wings =
union {
difference {
  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1 //wing           
   pigment {color CoolCopper *.75}
   finish {
         specular 1.0
         roughness 0.01
         ambient 0.2
         diffuse 0.8
       }
   scale <6,1.25,.15>
    rotate <90, 0, 0>
    translate <-4.35, 0, 0>
  }
superellipsoid { <1.0, 0.3>
   pigment {color Silver}
   finish {
         specular 1.0
         roughness 0.01
         ambient 0.2
         diffuse 0.8
       }
   scale <2,4,4>
   rotate <0, 0, 90>
  }
} //dif
  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1 //sidetube            
  texture {shiptex }
    scale <.6, 1.25, .35>
    rotate <90, 0, 0>
    translate <-6, 0, 0>
 }
  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1 //sidetube            
  texture {shiptex }
    scale <.25, 1.25, .25>
    rotate <90, 0, 0>
    translate <-10, 0, 0>
 }
} //union

union {
light_source {<0,0,0> color Cyan *3 atmosphere off}
light_source {<-3, 0, 0> color Magenta *.5 atmosphere off}
light_source {<3, 0, 0> color Magenta *.5 atmosphere off} 

difference {
superellipsoid { <1.0, 0.3>
  texture { shiptex }
   scale <2,4,16>
   rotate <0, 0, 90>
  translate z*11.7
 }
 superellipsoid { <1.0, 0.4>
   pigment {color Magenta *.5}
   finish {
         specular 1.0
         roughness 0.01
         ambient .8
         diffuse 0.4
       }
   scale <1.65,3.65,17>
   rotate <0,0, 90>
    no_shadow
   translate  z*11.7
 }
} //dif


difference {
  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1 //thruster       
  texture { pigment {color CoolCopper}
   finish {
         specular 1.0
         roughness 0.01
         ambient .2
         diffuse 0.5
       }
    }
    scale <1.75, 1.25, 1.1>
    rotate <90, 0, 0>
    translate <0, 0, -.20>
 }
  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1             
  texture { pigment {color Cyan}}
    scale <1.55, 1.26, .9>
    rotate <90, 0, 0>
    translate <0, 0, -.20>
    no_shadow
 }
}

  cylinder {<0, -2.8, 0>, <0, 7, 0>, 1             
  texture { pigment {color Cyan}
   finish {
         specular 1.0
         roughness 0.01
         ambient .9
         diffuse 0.5
       }
   }
    scale <1.55, .001, .9>
    rotate <90, 0, 0>
    translate <0, 0, -3.7>
 }

object{
 wings
    translate <0, 0, -.25>
}
object{
 wings
    rotate z*180
    translate <0, 0, -.25>
}

 sphere { <0, 0, 0>, 1
   pigment {color Magenta *.5 filter .5 }
   finish {
         specular 1.0
         roughness 0.01
         ambient 0.2
         diffuse 0.8
       }
  scale <2, 1.5, 3>
   translate <0, 2, 14>
}

   scale .15
   rotate <-20, -10, -20>
   translate <-2, 8, 10>
}

