//=============================================================================
//         LES OBJECTS DE LA SCENE
//=============================================================================


//============================================================================
//                                  LES SOL - le ciel
//----------------------------------------------------------------------
#declare sol=union{
difference{
       box{ <-99999,-100,-99999> <99999,0,99999> texture{ tex_mer1} }
       box{ <0,-5,0> <830,10,480> texture{ sol_txt} translate<-150,0,-100> }}
difference{
       box{ <-99999,-100,-99999> <99999,0,99999> texture{ tex_mer2} }
       box{ <0,-5,0> <830,10,480> texture{ sol_txt} translate<-150,0,-100> }
       translate<0,-1,0>   } }

#declare sol_bois=
  #declare nb=30
  #declare ll=13
  #declare e=90/29
  #declare count_z=0
   #while (count_z<nb)
    box{ <0,-2.5,0> <830,0,ll> translate (count_z*(ll+e))*z
         translate<-150,0,-100> texture{ bois_05 } }
    #declare count_z=count_z+1
   #end
//=========================================================================


//===============================================================================
//                          LE TEXTE
//----------------------------------------------------------------------------
#declare W_l= union{
  difference{ box{ <0,0,0> <2,5,2> }
              box{ <-10,-20,-10> <0,20,10>
                   rotate 21.8014*z translate<2,0,0> }}
  difference{ box{ <0,0,0> <2,4,2> }
              box{ <-10,-20,-10> <0,20,10>
                   rotate 26.565*z translate<2,0,0>}
              translate<2,0,0> }}

#declare E_ltop= difference{
   box{ <0,0,0> <2*sqrt(2),sqrt(2),2> }
   box{ <-10,0,-10> <10,10,10>
        rotate -26.565*z translate<0,sqrt(2),0> }
   rotate 45*z  }

#declare E_lbot= object{ E_ltop rotate 180*x }

#declare E_l= union{
  object{ E_ltop translate<1,2,0> }
  object{ E_lbot translate<1,2,0> } }

#declare B_lb1= difference{
  box{ <0,0,0> <3,1,2> }
  box{ <-10,0,-10> <10,10,10> rotate -18.4349*z translate<0,1,0> } }

#declare B_lb=union{
  object{ B_lb1 translate<0,1,0>}
  object{ B_lb1 rotate 180*x translate<0,1,0> } }

#declare B_l= union{
   object{ B_lb }
   object{ B_lb translate<0,2,0> } }

#declare P_l= difference{
  box{ <0,0,0> <4,5,2> }
  box{ <-10,0,-10> <10,10,10>
       rotate -degrees(asin(1/sqrt(17)))*z
       translate<0,5,0> }
  box{ <-10,-10,-10> <sqrt(8.5),0,10>
       rotate degrees(asin(2.5/sqrt(8.5)))*z }
  box{ <-sqrt(8.5),-10,-10> <10,0,10>
       rotate degrees(asin(1.5/sqrt(8.5)))*z
       translate <4,4,0> } }

#declare O_gruge=
  box{ <-10,-10,-10> <10,0,10>
       rotate -degrees(asin(2/sqrt(6.25)))*z
       translate <-1.5,0,0> }

#declare O_l= difference{
  box{ <-1.5,-2,0> <1.5,2,2> }
  object{ O_gruge }
  object{ O_gruge rotate 180*x }
  object{ O_gruge rotate 180*y }
  object{ O_gruge rotate 180*z } translate<1.5,2,0> }

#declare I_l= difference{
   box{ <0,0,0> <3,5,2> }
   difference{
     box{ <-10,-10,-10> <0,10,10> rotate -degrees(asin(2/sqrt(29)))*z }
     box{ <0,-20,-20> <20,20,20> rotate degrees(asin(2/sqrt(29)))*z
          translate <3,0,0> }}
   difference{
     box{ <0,-10,-10> <10,10,10> rotate degrees(asin(2/sqrt(29)))*z
          translate <3,0,0> }
     box{ <-20,-20,-20> <0,20,20> rotate -degrees(asin(2/sqrt(29)))*z } } }

#declare N_l= union{
  difference{
    box{ <0,0,0> <2,4,2> }
    box{ <-10,0,-10> <10,10,10> rotate -degrees(asin(4/sqrt(20)))*z
         translate<2,0,0> } }
  difference{
    box{ <0,0,0> <3,4,2> }
    box{ <-10,-10,-10> <10,0,10> rotate -degrees(asin(4/sqrt(20)))*z
         translate<3,0,0> } } }

#declare T_l= difference{
    box{ <0,0,0> <3,4,2> }
    box{ <-sqrt(9.25),-10,-10> <10,0,10>
         rotate -degrees(asin(3/sqrt(9.25)))*z
         translate <1.5,0,0> }
    box{ <-sqrt(9.25),-10,-10> <10,0,10>
         rotate -degrees(asin(3/sqrt(9.25)))*z
         rotate 180*y
         translate <1.5,0,0> }
    box{ <-10,-10,-10> <sqrt(2),0,10>
         rotate -45*z translate <0,4,0> }
    box{ <-sqrt(2),-10,-10> <10,0,10>
         rotate 45*z translate <3,4,0> } }

#declare WEB_gruge= union{
  object{ W_l }
  object{ E_l translate<5,-4,0>  }
  object{ B_l translate<9,-8,0>  } }

#declare POINT_gruge= union{
  object{ P_l }
  object{ O_l translate<3,-3.5,0>  }
  object{ I_l translate<6.5,-7.5,0>  }
  object{ N_l translate<11.5,-11.5,0>  }
  object{ T_l translate<16,-15.5,0>  } }

#declare gruge_txt= union{
   object{ WEB_gruge translate<6,6,0> }
   object{ POINT_gruge } }

//==============================================================================


//===============================================================================
//                                 LES MURS
//-------------------------------------------------------------------------
#declare gruge= difference{
  box{ <0,0,0> <42,13,2> texture{ beton_lisse} }
  box{ <1,1,-20> <41,12,20> texture{ beton_lisse} } }

#declare printer= box{ <0,0,-3> <30,1,+3> texture{ beton_lisse}
                       rotate 45*x }

#declare mur_bas= union{
   difference{ box{ <0,-50,0> <510,180,20> texture{ beton_lisse}}
	           box{ <150,40,-100> <470,160,100> texture{ beton_lisse}}
               object{ printer translate<60,87,20> texture{ beton_lisse}}
               object{ gruge translate<54,81,19> texture{ beton_lisse}} }
   difference{ box{ <150,40,0> <470,160,20> texture{ noir_shiny}}
               box{ <152,42,-10> <468,158,50> texture{ noir_shiny}}}
   box{ <150,40,8> <470,160,12> texture{ glass_verte}}
   box{ <0,0,0> <20,7,20> texture{ beton_lisse} translate <465,180,0> }}

#declare mur_haut= object{ mur_bas rotate 180*y }
//===============================================================================


//=============================================================================
//                        COL MORRIS
//---------------------------------------------------------------------------
#declare rayon=  cylinder{ <0,-84,0> <0,+84,0> 36
                           pigment{ color rgbt 1 }
                           halo{
                             emitting
                             cylindrical_mapping
                             linear
                             turbulence .5
                             color_map{ [ 0 color rgbt <1,.2,.2,0.991> ]
                                        [ .5 color rgbt <1,.2,.2,0> ]
                                        [ 1 color rgbt <1,0,0,-1> ] }
                             samples 20
                             scale<.8,1,.8> }
                           scale<1.2,1,1.2>
                           hollow
                           no_shadow }

#declare rayon2=  cylinder{ <0,-84,0> <0,+84,0> 15
                           pigment{ color rgbt 1 }
                           halo{
                             emitting
                             cylindrical_mapping
                             cubic
                             turbulence .9
                             color_map{ [ 0 color rgbt <1,.0,.0,1> ]
                                        [ .5 color rgbt <1,.1,.1,.05> ]
                                        [ 1 color rgbt <1,.2,.2,-3> ] }
                             samples 15
                             scale<.8,1,.8>  }
                             scale<1.3,1,1.3> hollow }

#declare col_bas= union{
  cylinder{ <0,0,0> <0,7,0> 30 texture{ gris_fonce_metal} }
  difference{
   cylinder{ <0,7,0> <0,180,0> 35.5 texture{ gris_fonce_metal} }
   cylinder{ <0,12,0> <0,175,0> 40 texture{ noir_mat} } }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5-20)*y }
  torus{ 33, 2 texture{ glass_neutre} translate 93.5*y }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5+20)*y }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5-40)*y }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5+40)*y }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5-60)*y }
  torus{ 33, 2 texture{ glass_neutre} translate (93.5+60)*y }
  object{ rayon translate 92*y }
  object{ rayon2 translate 92*y }
  cylinder{ <0,180,0> <0,187,0> 15 texture{ gris_fonce_metal} } }

#declare col_haut= object{ col_bas }
//=============================================================================


//===========================================================================
//                        LA COUVERTURE
//----------------------------------------------------------------------------
#declare faitage= difference{
  cylinder{ <10,0,0> <1190,0,0> 4.8 texture{ gris_fonce_metal} }
  box{ <-100,-50,-100> <100,0,100> texture{ gris_fonce_metal}
       rotate 20*z translate <1190,4.8,0> }
 box{ <-100,-50,-100> <100,0,100> texture{ gris_fonce_metal}
       rotate -20*z translate <10,4.8,0> } }

#declare panne_bas= union{
  cylinder{ <22.5,0,0> <507.5,0,0> 4.8 texture {gris_fonce_metal} }
  cylinder{ <5,0,0> <22.5,0,0> 2 texture {gris_fonce_metal} }
  cylinder{ <507.5,0,0> <525,0,0> 2 texture {gris_fonce_metal } } }

#declare panne_haut= object{ panne_bas translate<0,0,280> }

#declare tirant= union{
  cylinder{ <0,0,5> <0,0,20> 2 texture {gris_fonce_metal} }
  cylinder{ <0,0,260> <0,0,275> 2 texture {gris_fonce_metal} }
  cylinder{ <0,0,0> <0,0,280> .9 texture { gris_fonce_metal} } }

#declare lb=285
#declare lc=337

#declare alph=29.9
#declare beta=29.51
#declare theta=37.6
#declare phy=24.7

#declare B_barre=union{
  cylinder{ <22.5,0,0> <lb,0,0> 4.4 texture{ gris_fonce_metal} }
  cylinder{ <5,0,0> <22.5,0,0> 2 texture{ gris_fonce_metal} } }

#declare A_barre= object{ B_barre rotate 180*y }

#declare C_barre=union{
  cylinder{ <22.5,0,0> <lc,0,0> 4.4 texture{ gris_fonce_metal} }
  cylinder{ <5,0,0> <22.5,0,0> 2 texture{ gris_fonce_metal} } }

#declare D_barre= object{ C_barre rotate 180*y }

#declare sphere_01= union{
 sphere{ <0,0,0> 12.5 texture{ gris_fonce_metal} }
 object{ A_barre rotate<-50,alph,-theta> }
 object{ C_barre rotate<12,-phy,beta> }
 cylinder{ <0,-5,0> <0,-20,0> 2 texture{ gris_fonce_metal} }}

#declare sphere_04= union{
 sphere{ <0,0,0> 12.5 texture{ gris_fonce_metal} }
 object{ D_barre rotate<105,phy,-beta> }
 object{ B_barre rotate<20,-alph,theta> }
 cylinder{ <0,-5,0> <0,-20,0> 2 texture{ gris_fonce_metal} }}

#declare sphere_02= object{ sphere_04 rotate 180*y }
#declare sphere_03= object{ sphere_01 rotate 180*y }

#declare toit_01=
   #declare angl=47
   #declare ltoit=205
 difference{
  box{ <0,-1,-ltoit> <1060,1,0> texture{ glass_toit}
        rotate -angl*x translate<-265,351.5,140> }
  box{ <-500,-1000,-1000> <500,0,1000> rotate -29.51*z
       translate<-265,351.5,140> }
  box{  <-500,-1000,-1000> <500,0,1000>  rotate 29.51*z
        translate<795,351.5,140> }
  sphere{ <0,201.5,0> 23 texture{ glass_toit} }
  sphere{ <530,201.5,0> 23 texture{ glass_toit} } }

#declare toit_02= object{ toit_01
    translate <265,-351.5,-140>
    rotate (2*angl+180)*x
    translate <-265,351.5,140> }
//===============================================================================


//===============================================================================
//                  LE WEB VIEW
//------------------------------------------------------------------------------
#declare web_glass= box{ <0,0,0> <60,50,3> texture{ glass_web} }

#declare web_fix= cylinder{ <0,0,0> <0,0,5> 5/4 texture{ gris_fonce_metal}
                             translate<0,0,-1>}

#declare web_point= box{ <0,0,0> <25,6,1/100> texture{ point_web}
                          translate<0,0,-1/100> }

#declare web_ecran= box{ <0,0,0> <45,33.5,1/10> texture{ ecran_web}
                          translate<0,0,-1/10> }

#declare web_view= union{
  object{ web_glass translate <0,0,0> }
  object{ web_fix translate <15/4,15/4,0> }
  object{ web_fix translate <56.25,15/4,0> }
  object{ web_fix translate <15/4,46.25,0> }
  object{ web_fix translate <56.25,46.25,0> }
  object{ web_point translate <17.5,41,0> }
  object{ web_ecran translate <7.5,4,0> }
  light_source{ 0*x color rgb<.6,.6,.6> translate <30,25,3.1> shadowless} }

#declare web_view01= object{ web_view rotate 180*y translate<160,105,14> }
#declare web_view02= object{ web_view translate<370,105,266> }
//==============================================================================

//===============================================================================
//                  LE WEB PRINT
//-----------------------------------------------------------------------------
#declare cadre= box{ <0,0,0> <46,21,2> texture{ glass_web} }

#declare p_box_01= difference{
   box{ <0,0,0> <36,50,20> texture{ glass_web} }
   box{ <2,-10,2> <34,60,30> texture{ glass_web} } }

#declare pbox02= difference{
   object{ p_box_01 rotate -32.005*x }
   box{ <-500,-16,-500> <500,500,500> texture{ glass_web} }
   box{ <-500,-500,-0> <500,500,500> texture{ glass_web} } }

#declare p_box_fix= cylinder{ <0,0,0> <0,0,3> 1 texture{ gris_fonce_metal}
                              translate<0,0,-1/2> }

#declare web_print= union{
  object{ cadre translate <0,0,0> }
  object{ pbox02 translate <5,5,0> }
  object{ web_fix translate <2.5,2.5,0> }
  object{ web_fix translate <2.5,18.5,0> }
  object{ web_fix translate <43.5,2.5,0> }
  object{ web_fix translate <43.5,18.5,0> } }

#declare web_print01= object{ web_print rotate 180*y translate<153,52,12> }
#declare web_print02= object{ web_print translate<377,52,268> }
//===========================================================================


//===========================================================================
//                      LES CONES
//----------------------------------------------------------------------------
#declare cones_obj= difference{
  cone{ <0,-10,0> 20 <0,420,0> 2 }
  box{ <-100,0,-100> <100,100,100> rotate 67.5*z translate 400*y }
  texture{ gris_fonce_metal} }
#declare cones= union{ object{ cones_obj}
                       light_source{
                         0*x
                         color rgb <.8,1.5,.8>
                         spotlight
                         translate <30,0.5,0>
                         point_at <0,400,0>
                         radius 5
                         tightness 70 //(1...100) lower is softer, higher is tighter
                         falloff 6} }
//===============================================================================
