//========================================================================
//            SCENE PRINCIPALE I - UN KIOSQUE INFORMATION
//------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"

#include "kiosk.txt.inc"
#include "kiosk.obj.inc"


//=====================================================================
//                               CAMERAS
//----------------------------------------------------------------------
/*camera{ location  <-100,2000,-1000>   //CAM vue generale
        direction <0,0,1>           
        up y
        right (4/3)*x
        look_at <200,100,200> }*/

/*camera{ location  <320,10,10>     //CAM int vers col_02
        direction <0,0,1>        //contre plongee
        up y
        right (4/3)*x
        look_at <460,125,280> }*/

/*camera{ location  <105,100,-740>  //CAM facade en entier
        direction <0,0,1>       
        up y
        right (4/3)*x
        look_at <216,120,140> }*/

camera{ location  <845,120,50>    //CAM sur le cote
        direction <0,0,1>        //pas en entier
        up y
        right (4/3)*x
        look_at <500,135,145> }

/*camera{ location  <940,120,-410>     //CAM sur le cote
        direction <0,0,1>         
        up y
        right (4/3)*x
        look_at <460,160,145> }*/

/*camera{ location  <85,100,215>      //CAM web_01
        direction <0,0,1>          
        up y
        right (4/3)*x
        look_at <65,110,10> }*/

/*camera{ location  <110,110,-280>     //CAM text
        direction <0,0,1>           
        up y
        right (4/3)*x
        look_at <125,105,-2> }*/


/*camera{ location  <650,125,50>    //CAM col_02
        direction <0,0,1>       
        up y
        right (4/3)*x
        look_at <550,110,200> }*/

/*camera{ location  <615,228,-80>   //CAM detail_couv
        direction <0,0,1>       
        up y
        right (4/3)*x
        look_at <505,200,0> }*/
//====================================================================


//===================================================================
//                           LIGHTS SOURCES
//--------------------------------------------------------------------
global_settings{ assumed_gamma 1.5}
light_source{ <265,1500,140>  color rgb <.5,.5,.5>} //top
light_source{ <530,93.5,280> color rgb<1,.70,.70>} //col_light_02
light_source{ <0,93.5,0> color rgb<1,.70,.70>} //col_light_01
//===================================================================


//===========================================================
//                         LE CIEL ET LA TERRE
//-----------------------------------------------------------
sky_sphere { S_Cloud3 }
object{ sol translate<0,0,0> }
object{ sol_bois translate<0,0,0> }
//============================================================


//===============================================================
//                      KIOSQUE
//-----------------------------------------------------------------
object{ mur_bas translate<55,0,-10>}
object{ mur_haut translate<475,0,290>}

object{ col_bas translate<0,0,0>}
object{ col_haut translate<530,0,280>}

object{ sphere_01 translate <0,201.5,0> }
object{ sphere_02 translate <0,201.5,280> }
object{ sphere_03 translate <530,201.5,280> }
object{ sphere_04 translate <530,201.5,0> }

object{ faitage rotate 200*x translate<-335,351.5,140> }

object{ panne_haut translate <0,201.5,0> }
object{ panne_bas translate <0,201.5,0> }

object{ tirant translate<0,201.5,0> }
object{ tirant translate<530,201.5,0> }

object{ toit_01 }
object{ toit_02 }
//===================================================================


//==================================================================
//                 LES WEB VIEW
//-----------------------------------------------------------------
object{ web_view01 }
object{ web_view02 }
//==================================================================


//======================================================================
//             LES WEB PRINT
//--------------------------------------------------------------------
object{ web_print01 }
object{ web_print02 }
//================================================================


//==========================================================================
//                     LE CERCLE DE CONES
//------------------------------------------------------------------------
  #declare compteur=0
   #while (compteur<360)
    object{cones translate<-1450,0,0>
           rotate (15*compteur)*y
           translate <265,0,140>}
    #declare compteur=compteur+1
  #end
//=========================================================================


object{ gruge_txt scale<4.6,4.6,.5> translate<85,105,-11>
      texture{or}  }
