// Kithrup model -- "Props"
// Steve Sloan 27-Oct-96
// "Props" for Kithrup.POV. Includes a school of fish, a detector bouy, and an underwater
//     heliarc lamp. From David Brin's novel, Startide Rising
// This code may be used for any purpose, provided the source is acknowledged

#declare detector_buoy =
union {
    sphere {
        <0, 0, 0>, 1
        scale <.4, .5, .4>
        pigment { checker Red, White }
    }
    cylinder {
        <0,   0, 0>,   // Center of one end
        <0, -100, 0>,  // Center of other end
        .01            // Radius
        pigment { color Black }
    }
}

// Average distance between two adjacent fish in the school
#declare xgroup = 4
#declare ygroup = 3
#declare zgroup = 6

// Average distance between two adjacent fish in the school
#declare xdist = .15
#declare ydist = .4
#declare zdist = .4

// Maximum random offset from the "grid" for each fish in the school
#declare xoffset = .05
#declare yoffset = .15
#declare zoffset = .15

#declare fish_body =
union {
    intersection {
        sphere {
            <0, 0, 0>, 1
            scale <.1, .5, 1>
        }
        box {
            <-1, -1, 0>,  // Near lower left corner
            < 1,  1, 2>   // Far upper right corner
        }
    }
    intersection {
        sphere {
            <0, 0, 0>, 1
            scale <.1, .5, 1.5>
        }
        box {
            <-1, -1, -2>,  // Near lower left corner
            < 1,  1,  0>   // Far upper right corner
        }
    }
    texture { New_Penny }
}

#declare fish_eye =
sphere {
    <0, 0, 0>, 1
    scale <.03, 0.2, 0.2>
    texture { Soft_Silver }
}


#declare fish_tail =
difference {
    sphere {
        <0, 0, 0>, 1
        scale <.025, 0.5, 0.4>
    }
    union {
        cylinder {
            <-1, 0, 0>,    // Center of one end
            < 1, 0, 0>,    // Center of other end
            1              // Radius
            scale <1, 0.5, 0.1>
        }
        box {
            <-1, -1, -1>,  // Near lower left corner
            < 1,  1,  0>   // Far upper right corner
        }
    }
    texture { Soft_Silver }
}

#declare fish_fin =
intersection {
    object {
        fish_tail
    }
    box {
        <-1, 0, -1>,  // Near lower left corner
        < 1, 1,  1>   // Far upper right corner
    }
    texture { Soft_Silver }
}


#declare fish =
union {
    object{
        fish_body
    }
    object{
        fish_tail
        translate -1.75*z
    }
    object{
        fish_fin
        translate <0, .4, -.5>
    }
    object{
        fish_fin
        rotate 150*z
        translate <0, -.2, 0>
    }
    object{
        fish_fin
        rotate -150*z
        translate <0, -.2, 0>
    }
    object {
        fish_eye
        rotate 7*z
        translate <.075, .2, .3>
    }
    object {
        fish_eye
        rotate -7*z
        translate <-.075, .2, .3>
    }
    scale 0.1
}

#declare fish_school =
union {
    #declare xcount=0
    #while (xcount < xgroup)
        #declare ycount=0
        #while (ycount < ygroup)
            #declare zcount=0
            #while (zcount < zgroup)
                #declare R1 = seed(16 * xcount + 4 * ycount + zcount)
                object {
                    fish
                    #declare xpos = xdist*(xcount - xgroup/2 + 0.5) + xoffset*(2*rand(R1) - 1)
                    #declare ypos = ydist*(ycount - ygroup/2 + 0.5) + yoffset*(2*rand(R1) - 1)
                    #declare zpos = zdist*(zcount - zgroup/2 + 0.5) + zoffset*(2*rand(R1) - 1)
                    translate <xpos, ypos, zpos>
                }
                #declare zcount=zcount+1
            #end
            #declare ycount=ycount+1
        #end
        #declare xcount=xcount+1
    #end
}

#declare heliarc_tripod =
union {
    cylinder {
        <0, -0.25, 0>,  // Center of one end
        <0,    -3, 0>,  // Center of other end
        .05             // Radius
        texture { New_Penny }
    }
    sphere {
        <0, -3, 0>, .1
        texture { Soft_Silver }
    }
    cylinder {
        <0,    0, 0>,  // Center of one end
        <0, -100, 0>,  // Center of other end
        .05            // Radius
        texture { New_Penny }
        rotate 30*x
        translate -3*y
    }
    cylinder {
        <0,    0, 0>,  // Center of one end
        <0, -100, 0>,  // Center of other end
        .05            // Radius
        texture { New_Penny }
        rotate 30*x
        rotate 120*y
        translate -3*y
    }
    cylinder {
        <0,    0, 0>,  // Center of one end
        <0, -100, 0>,  // Center of other end
        .05            // Radius
        texture { New_Penny }
        rotate 30*x
        rotate -120*y
        translate -3*y
    }
}


#declare heliarc_lamp =
union {
    object {
        heliarc_tripod
    }
    sphere {
        <0, 0, 0>, 0.25
        texture {
            pigment {rgbf <1,1,1,1>}
            finish {phong .4 phong_size 80 reflection .8 refraction 1 ior 1.5}
        }
//        translate <0, 10, 10>
    }
    light_source {
        <0, 0, 0>
        colour rgb 1
    }
}
