// Kithrup model -- Dolphins
// Steve Sloan 27-Oct-96
// 3 dolphins, used with Kithrup.POV
// This code may be used for any purpose, provided the source is acknowledged

#include "colors.inc"
#include "textures.inc"

// Objects converted to POVRay V2.2 by WCVT2POV V2.7

// This object (the three dolphins combined) has the following minimum
// and maximum values (before I rescaled and translated them):
// xmin=-413.337221, xmax=413.337221
// ymin=-86.610002, ymax=86.610002
// zmin=-373.515331, zmax=373.515331

#declare dolph_scale = .0045

#declare eyex =  .25
#declare eyey = .125
#declare eyez = .5
#declare eyeangle = 40

#declare eye =
    sphere {
        0, 1
        scale <.01, .02, .03>
        rotate eyeangle*x
        texture {
            pigment { color Black } // Black is pre-defined in COLORS.INC
            finish { phong 1 }
        }
    }

#declare Dolph01 =
    union {
		union {
			triangle {
				<77.524816, 0.000000, 355.225360>,
				<38.924823, 0.000000, 320.425353>,
				< 44.254815, -8.130001, 319.665355>
			}
			triangle {
				<44.254815, -8.130001, 319.665355>,
				<85.144815, -6.100000, 353.955322>,
				< 77.524816, 0.000000, 355.225360>
			}
			triangle {
				<110.544817, 0.000000, 371.225299>,
				<77.524816, 0.000000, 355.225360>,
				< 85.144815, -6.100000, 353.955322>
			}
			triangle {
				<85.144815, -6.100000, 353.955322>,
				<113.854815, -3.560000, 368.185365>,
				< 110.544817, 0.000000, 371.225299>
			}
			triangle {
				<142.044814, 0.000000, 373.515331>,
				<110.544817, 0.000000, 371.225299>,
				< 113.854815, -3.560000, 368.185365>
			}
			triangle {
				<113.854815, -3.560000, 368.185365>,
				<143.824821, -1.270000, 369.195320>,
				< 142.044814, 0.000000, 373.515331>
			}
			triangle {
				<160.074818, 0.000000, 368.685366>,
				<142.044814, 0.000000, 373.515331>,
				< 143.824821, -1.270000, 369.195320>
			}
			triangle {
				<152.714815, 0.000000, 303.155348>,
				<142.044814, 0.000000, 328.045352>,
				< 142.554811, -9.910000, 310.015320>
			}
			triangle {
				<85.144815, -6.100000, 353.955322>,
				<44.254815, -8.130001, 319.665355>,
				< 102.924818, -11.680000, 317.885334>
			}
			triangle {
				<102.924818, -11.680000, 317.885334>,
				<117.914815, -6.100000, 339.225364>,
				< 85.144815, -6.100000, 353.955322>
			}
			triangle {
				<113.854815, -3.560000, 368.185365>,
				<85.144815, -6.100000, 353.955322>,
				< 117.914815, -6.100000, 339.225364>
			}
			triangle {
				<117.914815, -6.100000, 339.225364>,
				<128.584808, -3.560000, 350.905349>,
				< 113.854815, -3.560000, 368.185365>
			}
			triangle {
				<143.824821, -1.270000, 369.195320>,
				<113.854815, -3.560000, 368.185365>,
				< 128.584808, -3.560000, 350.905349>
			}
			triangle {
				<-137.355189, 0.000000, 209.435336>,
				<-132.275195, -7.620000, 213.245336>,
				< -126.945199, 0.000000, 221.115336>
			}
			triangle {
				<-109.415197, 0.000000, 236.865331>,
				<-126.945199, 0.000000, 221.115336>,
				< -132.275195, -7.620000, 213.245336>
			}
			triangle {
				<-132.275195, -7.620000, 213.245336>,
				<-113.225190, -13.970000, 230.515327>,
				< -109.415197, 0.000000, 236.865331>
			}
			triangle {
				<-49.725189, 0.000000, 279.785339>,
				<-83.765188, 0.000000, 256.165344>,
				< -88.585193, -5.330000, 251.345331>
			}
			triangle {
				<-88.585193, -5.330000, 251.345331>,
				<-50.745180, -18.290001, 273.695317>,
				< -49.725189, 0.000000, 279.785339>
			}
			triangle {
				<-50.745180, -18.290001, 273.695317>,
				<-88.585193, -5.330000, 251.345331>,
				< -87.575180, -13.970000, 249.305343>
			}
			triangle {
				<-7.055184, 0.000000, 300.365342>,
				<-49.725189, 0.000000, 279.785339>,
				< -50.745180, -18.290001, 273.695317>
			}
			triangle {
				<-50.745180, -18.290001, 273.695317>,
				<-7.815186, -22.350002, 295.025337>,
				< -7.055184, 0.000000, 300.365342>
			}
			triangle {
				<38.924823, 0.000000, 320.425353>,
				<-7.055184, 0.000000, 300.365342>,
				< -7.815186, -22.350002, 295.025337>
			}
			triangle {
				<-7.815186, -22.350002, 295.025337>,
				<44.254815, -8.130001, 319.665355>,
				< 38.924823, 0.000000, 320.425353>
			}
			triangle {
				<41.204820, -24.640000, 304.685353>,
				<44.254815, -8.130001, 319.665355>,
				< -7.815186, -22.350002, 295.025337>
			}
			triangle {
				<102.924818, -11.680000, 317.885334>,
				<44.254815, -8.130001, 319.665355>,
				< 41.204820, -24.640000, 304.685353>
			}
			triangle {
				<41.204820, -24.640000, 304.685353>,
				<99.374822, -26.670000, 303.155348>,
				< 102.924818, -11.680000, 317.885334>
			}
			triangle {
				<142.554811, -9.910000, 310.015320>,
				<102.924818, -11.680000, 317.885334>,
				< 99.374822, -26.670000, 303.155348>
			}
			triangle {
				<99.374822, -26.670000, 303.155348>,
				<155.504820, -20.320000, 291.215338>,
				< 142.554811, -9.910000, 310.015320>
			}
			triangle {
				<152.714815, 0.000000, 303.155348>,
				<142.554811, -9.910000, 310.015320>,
				< 155.504820, -20.320000, 291.215338>
			}
			triangle {
				<152.714815, 0.000000, 303.155348>,
				<155.504820, -20.320000, 291.215338>,
				< 221.804818, -11.680000, 255.155331>
			}
			triangle {
				<221.804818, -11.680000, 255.155331>,
				<223.074827, 0.000000, 259.215346>,
				< 152.714815, 0.000000, 303.155348>
			}
			triangle {
				<263.714813, 0.000000, 224.165352>,
				<223.074827, 0.000000, 259.215346>,
				< 221.804818, -11.680000, 255.155331>
			}
			triangle {
				<221.804818, -11.680000, 255.155331>,
				<256.094813, -14.730000, 215.015333>,
				< 263.714813, 0.000000, 224.165352>
			}
			triangle {
				<281.744816, 0.000000, 200.545328>,
				<263.714813, 0.000000, 224.165352>,
				< 256.094813, -14.730000, 215.015333>
			}
			triangle {
				<256.094813, -14.730000, 215.015333>,
				<271.834813, -11.940000, 188.095350>,
				< 281.744816, 0.000000, 200.545328>
			}
			triangle {
				<294.194838, 0.000000, 176.665351>,
				<281.744816, 0.000000, 200.545328>,
				< 271.834813, -11.940000, 188.095350>
			}
			triangle {
				<271.834813, -11.940000, 188.095350>,
				<284.794818, -7.870000, 165.235324>,
				< 294.194838, 0.000000, 176.665351>
			}
			triangle {
				<300.284831, 0.000000, 156.595345>,
				<294.194838, 0.000000, 176.665351>,
				< 284.794818, -7.870000, 165.235324>
			}
			triangle {
				<284.794818, -7.870000, 165.235324>,
				<294.694839, -9.650000, 149.235328>,
				< 300.284831, 0.000000, 156.595345>
			}
			triangle {
				<296.474803, 0.000000, 137.805329>,
				<300.284831, 0.000000, 156.595345>,
				< 294.694839, -9.650000, 149.235328>
			}
			triangle {
				<294.694839, -9.650000, 149.235328>,
				<292.414817, -7.370000, 141.615329>,
				< 296.474803, 0.000000, 137.805329>
			}
			triangle {
				<-87.575180, -13.970000, 249.305343>,
				<-113.225190, -13.970000, 230.515327>,
				< -90.115192, -22.350002, 242.955324>
			}
			triangle {
				<-87.575180, -13.970000, 249.305343>,
				<-90.115192, -22.350002, 242.955324>,
				< -73.855178, -32.770000, 241.685344>
			}
			triangle {
				<-87.575180, -13.970000, 249.305343>,
				<-73.855178, -32.770000, 241.685344>,
				< -44.395190, -29.970001, 259.725357>
			}
			triangle {
				<-44.395190, -29.970001, 259.725357>,
				<-50.745180, -18.290001, 273.695317>,
				< -87.575180, -13.970000, 249.305343>
			}
			triangle {
				<-7.815186, -22.350002, 295.025337>,
				<-50.745180, -18.290001, 273.695317>,
				< -44.395190, -29.970001, 259.725357>
			}
			triangle {
				<-44.395190, -29.970001, 259.725357>,
				<-7.305183, -31.999999, 276.235336>,
				< -7.815186, -22.350002, 295.025337>
			}
			triangle {
				<41.204820, -24.640000, 304.685353>,
				<-7.815186, -22.350002, 295.025337>,
				< -7.305183, -31.999999, 276.235336>
			}
			triangle {
				<-7.305183, -31.999999, 276.235336>,
				<41.204820, -35.810002, 286.905336>,
				< 41.204820, -24.640000, 304.685353>
			}
			triangle {
				<99.374822, -26.670000, 303.155348>,
				<41.204820, -24.640000, 304.685353>,
				< 41.204820, -35.810002, 286.905336>
			}
			triangle {
				<41.204820, -35.810002, 286.905336>,
				<91.754815, -34.040002, 285.635327>,
				< 99.374822, -26.670000, 303.155348>
			}
			triangle {
				<155.504820, -20.320000, 291.215338>,
				<99.374822, -26.670000, 303.155348>,
				< 91.754815, -34.040002, 285.635327>
			}
			triangle {
				<91.754815, -34.040002, 285.635327>,
				<152.204803, -28.450001, 277.755332>,
				< 155.504820, -20.320000, 291.215338>
			}
			triangle {
				<221.804818, -11.680000, 255.155331>,
				<155.504820, -20.320000, 291.215338>,
				< 152.204803, -28.450001, 277.755332>
			}
			triangle {
				<152.204803, -28.450001, 277.755332>,
				<218.494820, -18.290001, 248.295330>,
				< 221.804818, -11.680000, 255.155331>
			}
			triangle {
				<256.094813, -14.730000, 215.015333>,
				<221.804818, -11.680000, 255.155331>,
				< 218.494820, -18.290001, 248.295330>
			}
			triangle {
				<-95.695195, -31.750002, 230.255316>,
				<-85.535192, -36.580003, 228.735335>,
				< -73.855178, -32.770000, 241.685344>
			}
			triangle {
				<-73.855178, -32.770000, 241.685344>,
				<-90.115192, -22.350002, 242.955324>,
				< -95.695195, -31.750002, 230.255316>
			}
			triangle {
				<-103.315187, -27.430002, 223.145329>,
				<-95.695195, -31.750002, 230.255316>,
				< -90.115192, -22.350002, 242.955324>
			}
			triangle {
				<-90.115192, -22.350002, 242.955324>,
				<-113.225190, -13.970000, 230.515327>,
				< -103.315187, -27.430002, 223.145329>
			}
			triangle {
				<-119.575187, -20.830001, 206.125339>,
				<-103.315187, -27.430002, 223.145329>,
				< -113.225190, -13.970000, 230.515327>
			}
			triangle {
				<-113.225190, -13.970000, 230.515327>,
				<-132.275195, -7.620000, 213.245336>,
				< -119.575187, -20.830001, 206.125339>
			}
			triangle {
				<-133.795190, -10.160000, 191.905335>,
				<-119.575187, -20.830001, 206.125339>,
				< -132.275195, -7.620000, 213.245336>
			}
			triangle {
				<-94.175192, -30.990000, 223.145329>,
				<-83.255191, -35.810002, 218.825318>,
				< -85.535192, -36.580003, 228.735335>
			}
			triangle {
				<-85.535192, -36.580003, 228.735335>,
				<-95.695195, -31.750002, 230.255316>,
				< -94.175192, -30.990000, 223.145329>
			}
			triangle {
				<-103.315187, -27.430002, 223.145329>,
				<-94.175192, -30.990000, 223.145329>,
				< -95.695195, -31.750002, 230.255316>
			}
			triangle {
				<-133.795190, -10.160000, 191.905335>,
				<-135.575183, -13.970000, 184.285350>,
				< -119.575187, -20.830001, 206.125339>
			}
			triangle {
				<-160.465187, -7.370000, 153.805340>,
				<-155.385193, -7.370000, 151.515321>,
				< -128.715181, -14.990000, 174.635315>
			}
			triangle {
				<-128.715181, -14.990000, 174.635315>,
				<-135.575183, -13.970000, 184.285350>,
				< -160.465187, -7.370000, 153.805340>
			}
			triangle {
				<-142.945195, 0.000000, 183.015326>,
				<-166.565190, 0.000000, 151.515321>,
				< -165.295166, -4.060000, 149.995340>
			}
			triangle {
				<-165.295166, -4.060000, 149.995340>,
				<-140.145194, -5.080000, 185.305330>,
				< -142.945195, 0.000000, 183.015326>
			}
			triangle {
				<-140.145194, -5.080000, 185.305330>,
				<-133.795190, -10.160000, 191.905335>,
				< -132.275195, -7.620000, 213.245336>
			}
			triangle {
				<-132.275195, -7.620000, 213.245336>,
				<-137.355189, 0.000000, 209.435336>,
				< -140.145194, -5.080000, 185.305330>
			}
			triangle {
				<-142.945195, 0.000000, 183.015326>,
				<-140.145194, -5.080000, 185.305330>,
				< -137.355189, 0.000000, 209.435336>
			}
			triangle {
				<-96.715182, -30.730001, 217.305336>,
				<-103.315187, -27.430002, 223.145329>,
				< -104.085195, -30.480000, 209.435336>
			}
			triangle {
				<-104.085195, -30.480000, 209.435336>,
				<-103.065186, -30.730001, 206.635321>,
				< -96.715182, -30.730001, 217.305336>
			}
			triangle {
				<-103.315187, -27.430002, 223.145329>,
				<-119.575187, -20.830001, 206.125339>,
				< -116.525192, -26.420001, 202.065338>
			}
			triangle {
				<-116.525192, -26.420001, 202.065338>,
				<-104.085195, -30.480000, 209.435336>,
				< -103.315187, -27.430002, 223.145329>
			}
			triangle {
				<-103.065186, -30.730001, 206.635321>,
				<-104.085195, -30.480000, 209.435336>,
				< -116.525192, -26.420001, 202.065338>
			}
			triangle {
				<-116.525192, -26.420001, 202.065338>,
				<-113.225190, -25.910001, 196.735328>,
				< -103.065186, -30.730001, 206.635321>
			}
			triangle {
				<-113.225190, -25.910001, 196.735328>,
				<-116.525192, -26.420001, 202.065338>,
				< -135.575183, -13.970000, 184.285350>
			}
			triangle {
				<-135.575183, -13.970000, 184.285350>,
				<-128.715181, -14.990000, 174.635315>,
				< -113.225190, -25.910001, 196.735328>
			}
			triangle {
				<-124.905182, -16.260001, 170.825315>,
				<-128.715181, -14.990000, 174.635315>,
				< -155.385193, -7.370000, 151.515321>
			}
			triangle {
				<-155.385193, -7.370000, 151.515321>,
				<-149.035189, -8.380001, 150.505308>,
				< -124.905182, -16.260001, 170.825315>
			}
			triangle {
				<-113.225190, -25.910001, 196.735328>,
				<-128.715181, -14.990000, 174.635315>,
				< -124.905182, -16.260001, 170.825315>
			}
			triangle {
				<-124.905182, -16.260001, 170.825315>,
				<-106.625185, -25.910001, 185.805332>,
				< -113.225190, -25.910001, 196.735328>
			}
			triangle {
				<-97.735184, -34.540004, 201.045330>,
				<-103.065186, -30.730001, 206.635321>,
				< -113.225190, -25.910001, 196.735328>
			}
			triangle {
				<-74.875186, -34.800000, 193.175330>,
				<-97.735184, -34.540004, 201.045330>,
				< -106.625185, -25.910001, 185.805332>
			}
			triangle {
				<-106.625185, -25.910001, 185.805332>,
				<-104.085195, -27.430002, 180.225350>,
				< -74.875186, -34.800000, 193.175330>
			}
			triangle {
				<-135.575183, -13.970000, 184.285350>,
				<-133.795190, -10.160000, 191.905335>,
				< -140.145194, -5.080000, 185.305330>
			}
			triangle {
				<-96.715182, -30.730001, 217.305336>,
				<-103.065186, -30.730001, 206.635321>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-90.615193, -34.540004, 215.525330>,
				<-96.715182, -30.730001, 217.305336>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-83.255191, -35.810002, 218.825318>,
				<-90.615193, -34.540004, 215.525330>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-76.905187, -38.610003, 204.855329>,
				<-83.255191, -35.810002, 218.825318>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-97.735184, -34.540004, 201.045330>,
				<-76.905187, -38.610003, 204.855329>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-103.065186, -30.730001, 206.635321>,
				<-97.735184, -34.540004, 201.045330>,
				< -92.655182, -34.800000, 206.385320>
			}
			triangle {
				<-149.035189, -8.380001, 150.505308>,
				<-145.225189, -10.920001, 147.705322>,
				< -123.385200, -18.290001, 165.745335>
			}
			triangle {
				<-123.385200, -18.290001, 165.745335>,
				<-124.905182, -16.260001, 170.825315>,
				< -149.035189, -8.380001, 150.505308>
			}
			triangle {
				<-124.905182, -16.260001, 170.825315>,
				<-123.385200, -18.290001, 165.745335>,
				< -104.085195, -27.430002, 180.225350>
			}
			triangle {
				<-104.085195, -27.430002, 180.225350>,
				<-106.625185, -25.910001, 185.805332>,
				< -124.905182, -16.260001, 170.825315>
			}
			triangle {
				<-86.805194, -31.750002, 188.095350>,
				<-104.085195, -27.430002, 180.225350>,
				< -100.015185, -17.020001, 158.635319>
			}
			triangle {
				<-100.015185, -17.020001, 158.635319>,
				<-74.875186, -34.800000, 193.175330>,
				< -86.805194, -31.750002, 188.095350>
			}
			triangle {
				<-74.875186, -34.800000, 193.175330>,
				<-100.015185, -17.020001, 158.635319>,
				< -64.455187, -22.350002, 168.025329>
			}
			triangle {
				<-117.545186, -10.160000, 157.865325>,
				<-100.015185, -17.020001, 158.635319>,
				< -104.085195, -27.430002, 180.225350>
			}
			triangle {
				<-104.085195, -27.430002, 180.225350>,
				<-122.875189, -17.270002, 162.185337>,
				< -117.545186, -10.160000, 157.865325>
			}
			triangle {
				<-36.005191, -43.180001, 189.365330>,
				<-74.875186, -34.800000, 193.175330>,
				< -64.455187, -22.350002, 168.025329>
			}
			triangle {
				<-64.455187, -22.350002, 168.025329>,
				<-34.235183, -35.050001, 179.455328>,
				< -36.005191, -43.180001, 189.365330>
			}
			triangle {
				<-72.585190, -40.389999, 205.875338>,
				<-74.875186, -34.800000, 193.175330>,
				< -36.005191, -43.180001, 189.365330>
			}
			triangle {
				<-36.005191, -43.180001, 189.365330>,
				<-32.965181, -49.280000, 219.595340>,
				< -72.585190, -40.389999, 205.875338>
			}
			triangle {
				<-72.585190, -40.389999, 205.875338>,
				<-76.905187, -38.610003, 204.855329>,
				< -74.875186, -34.800000, 193.175330>
			}
			triangle {
				<-83.255191, -35.810002, 218.825318>,
				<-76.905187, -38.610003, 204.855329>,
				< -72.585190, -40.389999, 205.875338>
			}
			triangle {
				<-72.585190, -40.389999, 205.875338>,
				<-67.505188, -40.130003, 223.655340>,
				< -83.255191, -35.810002, 218.825318>
			}
			triangle {
				<-73.855178, -32.770000, 241.685344>,
				<-85.535192, -36.580003, 228.735335>,
				< -83.255191, -35.810002, 218.825318>
			}
			triangle {
				<-83.255191, -35.810002, 218.825318>,
				<-66.485187, -36.580003, 236.605349>,
				< -73.855178, -32.770000, 241.685344>
			}
			triangle {
				<-66.485187, -36.580003, 236.605349>,
				<-83.255191, -35.810002, 218.825318>,
				< -67.505188, -40.130003, 223.655340>
			}
			triangle {
				<-36.265183, -42.670000, 243.215349>,
				<-67.505188, -40.130003, 223.655340>,
				< -72.585190, -40.389999, 205.875338>
			}
			triangle {
				<-72.585190, -40.389999, 205.875338>,
				<-32.965181, -49.280000, 219.595340>,
				< -36.265183, -42.670000, 243.215349>
			}
			triangle {
				<-4.765183, -46.230002, 252.865327>,
				<-36.265183, -42.670000, 243.215349>,
				< -32.965181, -49.280000, 219.595340>
			}
			triangle {
				<-32.965181, -49.280000, 219.595340>,
				<7.174813, -51.050000, 227.715341>,
				< -4.765183, -46.230002, 252.865327>
			}
			triangle {
				<45.774810, -48.010002, 255.155331>,
				<-4.765183, -46.230002, 252.865327>,
				< 7.174813, -51.050000, 227.715341>
			}
			triangle {
				<7.174813, -51.050000, 227.715341>,
				<50.854816, -51.050000, 236.355348>,
				< 45.774810, -48.010002, 255.155331>
			}
			triangle {
				<93.784816, -46.230002, 260.235340>,
				<45.774810, -48.010002, 255.155331>,
				< 50.854816, -51.050000, 236.355348>
			}
			triangle {
				<50.854816, -51.050000, 236.355348>,
				<95.814823, -49.020000, 236.605349>,
				< 93.784816, -46.230002, 260.235340>
			}
			triangle {
				<149.664813, -43.939999, 254.135337>,
				<93.784816, -46.230002, 260.235340>,
				< 95.814823, -49.020000, 236.605349>
			}
			triangle {
				<95.814823, -49.020000, 236.605349>,
				<149.154816, -44.700004, 227.215339>,
				< 149.664813, -43.939999, 254.135337>
			}
			triangle {
				<208.844828, -33.020001, 229.245332>,
				<149.664813, -43.939999, 254.135337>,
				< 149.154816, -44.700004, 227.215339>
			}
			triangle {
				<149.154816, -44.700004, 227.215339>,
				<198.684824, -28.450001, 206.895332>,
				< 208.844828, -33.020001, 229.245332>
			}
			triangle {
				<244.154832, -23.370001, 204.355327>,
				<208.844828, -33.020001, 229.245332>,
				< 198.684824, -28.450001, 206.895332>
			}
			triangle {
				<198.684824, -28.450001, 206.895332>,
				<229.424831, -21.840001, 184.535351>,
				< 244.154832, -23.370001, 204.355327>
			}
			triangle {
				<261.934820, -13.970000, 180.225350>,
				<244.154832, -23.370001, 204.355327>,
				< 229.424831, -21.840001, 184.535351>
			}
			triangle {
				<229.424831, -21.840001, 184.535351>,
				<251.264820, -14.220000, 169.295324>,
				< 261.934820, -13.970000, 180.225350>
			}
			triangle {
				<273.874830, -9.910000, 163.715342>,
				<261.934820, -13.970000, 180.225350>,
				< 251.264820, -14.220000, 169.295324>
			}
			triangle {
				<251.264820, -14.220000, 169.295324>,
				<263.204830, -10.670001, 156.855356>,
				< 273.874830, -9.910000, 163.715342>
			}
			triangle {
				<-66.485187, -36.580003, 236.605349>,
				<-67.505188, -40.130003, 223.655340>,
				< -36.265183, -42.670000, 243.215349>
			}
			triangle {
				<-44.395190, -29.970001, 259.725357>,
				<-66.485187, -36.580003, 236.605349>,
				< -36.265183, -42.670000, 243.215349>
			}
			triangle {
				<-73.855178, -32.770000, 241.685344>,
				<-66.485187, -36.580003, 236.605349>,
				< -44.395190, -29.970001, 259.725357>
			}
			triangle {
				<-7.305183, -31.999999, 276.235336>,
				<-44.395190, -29.970001, 259.725357>,
				< -36.265183, -42.670000, 243.215349>
			}
			triangle {
				<-36.265183, -42.670000, 243.215349>,
				<-4.765183, -46.230002, 252.865327>,
				< -7.305183, -31.999999, 276.235336>
			}
			triangle {
				<41.204820, -35.810002, 286.905336>,
				<-7.305183, -31.999999, 276.235336>,
				< -4.765183, -46.230002, 252.865327>
			}
			triangle {
				<-4.765183, -46.230002, 252.865327>,
				<45.774810, -48.010002, 255.155331>,
				< 41.204820, -35.810002, 286.905336>
			}
			triangle {
				<91.754815, -34.040002, 285.635327>,
				<41.204820, -35.810002, 286.905336>,
				< 45.774810, -48.010002, 255.155331>
			}
			triangle {
				<45.774810, -48.010002, 255.155331>,
				<93.784816, -46.230002, 260.235340>,
				< 91.754815, -34.040002, 285.635327>
			}
			triangle {
				<152.204803, -28.450001, 277.755332>,
				<91.754815, -34.040002, 285.635327>,
				< 93.784816, -46.230002, 260.235340>
			}
			triangle {
				<93.784816, -46.230002, 260.235340>,
				<149.664813, -43.939999, 254.135337>,
				< 152.204803, -28.450001, 277.755332>
			}
			triangle {
				<218.494820, -18.290001, 248.295330>,
				<152.204803, -28.450001, 277.755332>,
				< 149.664813, -43.939999, 254.135337>
			}
			triangle {
				<149.664813, -43.939999, 254.135337>,
				<208.844828, -33.020001, 229.245332>,
				< 218.494820, -18.290001, 248.295330>
			}
			triangle {
				<256.094813, -14.730000, 215.015333>,
				<218.494820, -18.290001, 248.295330>,
				< 208.844828, -33.020001, 229.245332>
			}
			triangle {
				<208.844828, -33.020001, 229.245332>,
				<244.154832, -23.370001, 204.355327>,
				< 256.094813, -14.730000, 215.015333>
			}
			triangle {
				<271.834813, -11.940000, 188.095350>,
				<256.094813, -14.730000, 215.015333>,
				< 244.154832, -23.370001, 204.355327>
			}
			triangle {
				<244.154832, -23.370001, 204.355327>,
				<261.934820, -13.970000, 180.225350>,
				< 271.834813, -11.940000, 188.095350>
			}
			triangle {
				<284.794818, -7.870000, 165.235324>,
				<271.834813, -11.940000, 188.095350>,
				< 261.934820, -13.970000, 180.225350>
			}
			triangle {
				<261.934820, -13.970000, 180.225350>,
				<273.874830, -9.910000, 163.715342>,
				< 284.794818, -7.870000, 165.235324>
			}
			triangle {
				<294.694839, -9.650000, 149.235328>,
				<284.794818, -7.870000, 165.235324>,
				< 273.874830, -9.910000, 163.715342>
			}
			triangle {
				<273.874830, -9.910000, 163.715342>,
				<288.094834, -18.290001, 145.425328>,
				< 294.694839, -9.650000, 149.235328>
			}
			triangle {
				<292.414817, -7.370000, 141.615329>,
				<294.694839, -9.650000, 149.235328>,
				< 288.094834, -18.290001, 145.425328>
			}
			triangle {
				<7.174813, -51.050000, 227.715341>,
				<-32.965181, -49.280000, 219.595340>,
				< -36.005191, -43.180001, 189.365330>
			}
			triangle {
				<-36.005191, -43.180001, 189.365330>,
				<2.854813, -41.150004, 194.955322>,
				< 7.174813, -51.050000, 227.715341>
			}
			triangle {
				<50.854816, -51.050000, 236.355348>,
				<7.174813, -51.050000, 227.715341>,
				< 2.854813, -41.150004, 194.955322>
			}
			triangle {
				<2.854813, -41.150004, 194.955322>,
				<52.384818, -37.590002, 202.315339>,
				< 50.854816, -51.050000, 236.355348>
			}
			triangle {
				<95.814823, -49.020000, 236.605349>,
				<50.854816, -51.050000, 236.355348>,
				< 52.384818, -37.590002, 202.315339>
			}
			triangle {
				<52.384818, -37.590002, 202.315339>,
				<90.224817, -38.099999, 204.355327>,
				< 95.814823, -49.020000, 236.605349>
			}
			triangle {
				<149.154816, -44.700004, 227.215339>,
				<95.814823, -49.020000, 236.605349>,
				< 90.224817, -38.099999, 204.355327>
			}
			triangle {
				<90.224817, -38.099999, 204.355327>,
				<138.484816, -30.990000, 201.815337>,
				< 149.154816, -44.700004, 227.215339>
			}
			triangle {
				<198.684824, -28.450001, 206.895332>,
				<149.154816, -44.700004, 227.215339>,
				< 138.484816, -30.990000, 201.815337>
			}
			triangle {
				<138.484816, -30.990000, 201.815337>,
				<188.274820, -17.270002, 188.345336>,
				< 198.684824, -28.450001, 206.895332>
			}
			triangle {
				<229.424831, -21.840001, 184.535351>,
				<198.684824, -28.450001, 206.895332>,
				< 188.274820, -17.270002, 188.345336>
			}
			triangle {
				<188.274820, -17.270002, 188.345336>,
				<221.804818, -9.650000, 168.285340>,
				< 229.424831, -21.840001, 184.535351>
			}
			triangle {
				<251.264820, -14.220000, 169.295324>,
				<229.424831, -21.840001, 184.535351>,
				< 221.804818, -9.650000, 168.285340>
			}
			triangle {
				<221.804818, -9.650000, 168.285340>,
				<242.624827, -7.110000, 159.905343>,
				< 251.264820, -14.220000, 169.295324>
			}
			triangle {
				<263.204830, -10.670001, 156.855356>,
				<251.264820, -14.220000, 169.295324>,
				< 242.624827, -7.110000, 159.905343>
			}
			triangle {
				<242.624827, -7.110000, 159.905343>,
				<263.714813, -5.590000, 142.885324>,
				< 263.204830, -10.670001, 156.855356>
			}
			triangle {
				<273.104794, -11.939999, 134.755342>,
				<263.204830, -10.670001, 156.855356>,
				< 263.714813, -5.590000, 142.885324>
			}
			triangle {
				<-7.815186, -73.660008, 164.215344>,
				<-36.005191, -43.180001, 189.365330>,
				< -34.235183, -35.050001, 179.455328>
			}
			triangle {
				<-34.235183, -35.050001, 179.455328>,
				<-8.575188, -71.370004, 161.425324>,
				< -7.815186, -73.660008, 164.215344>
			}
			triangle {
				<2.854813, -41.150004, 194.955322>,
				<-36.005191, -43.180001, 189.365330>,
				< -7.815186, -73.660008, 164.215344>
			}
			triangle {
				<-7.815186, -73.660008, 164.215344>,
				<14.284814, -64.519998, 175.395327>,
				< 2.854813, -41.150004, 194.955322>
			}
			triangle {
				<37.904818, -77.220006, 160.155344>,
				<14.284814, -64.519998, 175.395327>,
				< -7.815186, -73.660008, 164.215344>
			}
			triangle {
				<-7.815186, -73.660008, 164.215344>,
				<23.684816, -80.770002, 157.365324>,
				< 37.904818, -77.220006, 160.155344>
			}
			triangle {
				<23.684816, -80.770002, 157.365324>,
				<-7.815186, -73.660008, 164.215344>,
				< 3.364815, -80.010004, 159.905343>
			}
			triangle {
				<48.824816, 0.000000, 189.115329>,
				<52.384818, -37.590002, 202.315339>,
				< 2.854813, -41.150004, 194.955322>
			}
			triangle {
				<2.854813, -41.150004, 194.955322>,
				<5.394814, 0.000000, 179.205327>,
				< 48.824816, 0.000000, 189.115329>
			}
			triangle {
				<188.274820, -17.270002, 188.345336>,
				<138.484816, -30.990000, 201.815337>,
				< 136.204822, 0.000000, 190.885326>
			}
			triangle {
				<136.204822, 0.000000, 190.885326>,
				<191.574822, 0.000000, 184.035349>,
				< 188.274820, -17.270002, 188.345336>
			}
			triangle {
				<263.714813, -5.590000, 142.885324>,
				<242.624827, -7.110000, 159.905343>,
				< 239.074823, 0.000000, 157.365324>
			}
			triangle {
				<239.074823, 0.000000, 157.365324>,
				<263.454845, 0.000000, 140.855345>,
				< 263.714813, -5.590000, 142.885324>
			}
			triangle {
				<-34.235183, -35.050001, 179.455328>,
				<-64.455187, -22.350002, 168.025329>,
				< -59.885196, 0.000000, 165.485325>
			}
			triangle {
				<-59.885196, 0.000000, 165.485325>,
				<-25.085175, 0.000000, 172.605322>,
				< -34.235183, -35.050001, 179.455328>
			}
			triangle {
				<2.854813, -41.150004, 194.955322>,
				<-34.235183, -35.050001, 179.455328>,
				< -25.085175, 0.000000, 172.605322>
			}
			triangle {
				<-25.085175, 0.000000, 172.605322>,
				<5.394814, 0.000000, 179.205327>,
				< 2.854813, -41.150004, 194.955322>
			}
			triangle {
				<-64.455187, -22.350002, 168.025329>,
				<-100.015185, -17.020001, 158.635319>,
				< -92.145192, 0.000000, 155.835332>
			}
			triangle {
				<-92.145192, 0.000000, 155.835332>,
				<-59.885196, 0.000000, 165.485325>,
				< -64.455187, -22.350002, 168.025329>
			}
			triangle {
				<-100.015185, -17.020001, 158.635319>,
				<-117.545186, -10.160000, 157.865325>,
				< -114.745178, 0.000000, 155.835332>
			}
			triangle {
				<-114.745178, 0.000000, 155.835332>,
				<-92.145192, 0.000000, 155.835332>,
				< -100.015185, -17.020001, 158.635319>
			}
			triangle {
				<-117.545186, -10.160000, 157.865325>,
				<-142.685184, -7.870000, 144.665345>,
				< -139.645193, 0.000000, 143.395335>
			}
			triangle {
				<-139.645193, 0.000000, 143.395335>,
				<-114.745178, 0.000000, 155.835332>,
				< -117.545186, -10.160000, 157.865325>
			}
			triangle {
				<-117.545186, -10.160000, 157.865325>,
				<-122.875189, -17.270002, 162.185337>,
				< -142.685184, -7.870000, 144.665345>
			}
			triangle {
				<-156.155186, -4.570000, 137.545318>,
				<-158.435180, 0.000000, 135.265325>,
				< -139.645193, 0.000000, 143.395335>
			}
			triangle {
				<-139.645193, 0.000000, 143.395335>,
				<-142.685184, -7.870000, 144.665345>,
				< -156.155186, -4.570000, 137.545318>
			}
			triangle {
				<298.764835, -63.250003, 93.355315>,
				<285.304829, -73.150003, 111.385319>,
				< 300.034816, -86.610002, 84.715337>
			}
			triangle {
				<292.414817, -7.370000, 141.615329>,
				<291.904834, -16.510000, 131.195314>,
				< 297.494826, -9.650000, 116.975347>
			}
			triangle {
				<297.494826, -9.650000, 116.975347>,
				<295.964820, 0.000000, 125.105321>,
				< 292.414817, -7.370000, 141.615329>
			}
			triangle {
				<295.964820, 0.000000, 125.105321>,
				<297.494826, -9.650000, 116.975347>,
				< 302.064823, -5.840000, 108.085331>
			}
			triangle {
				<302.064823, -5.840000, 108.085331>,
				<298.254823, 0.000000, 115.195318>,
				< 295.964820, 0.000000, 125.105321>
			}
			triangle {
				<286.314842, -24.129999, 142.885324>,
				<288.094834, -18.290001, 145.425328>,
				< 273.874830, -9.910000, 163.715342>
			}
			triangle {
				<273.874830, -9.910000, 163.715342>,
				<263.204830, -10.670001, 156.855356>,
				< 286.314842, -24.129999, 142.885324>
			}
			triangle {
				<273.104794, -11.939999, 134.755342>,
				<286.314842, -24.129999, 142.885324>,
				< 263.204830, -10.670001, 156.855356>
			}
			triangle {
				<-160.465187, -7.370000, 153.805340>,
				<-135.575183, -13.970000, 184.285350>,
				< -140.145194, -5.080000, 185.305330>
			}
			triangle {
				<-140.145194, -5.080000, 185.305330>,
				<-165.295166, -4.060000, 149.995340>,
				< -160.465187, -7.370000, 153.805340>
			}
			triangle {
				<-163.265202, 0.000000, 144.915345>,
				<-162.755191, -3.810000, 144.665345>,
				< -165.295166, -4.060000, 149.995340>
			}
			triangle {
				<-165.295166, -4.060000, 149.995340>,
				<-166.565190, 0.000000, 151.515321>,
				< -163.265202, 0.000000, 144.915345>
			}
			triangle {
				<-160.465187, -7.370000, 153.805340>,
				<-165.295166, -4.060000, 149.995340>,
				< -162.755191, -3.810000, 144.665345>
			}
			triangle {
				<-162.755191, -3.810000, 144.665345>,
				<-155.385193, -7.370000, 151.515321>,
				< -160.465187, -7.370000, 153.805340>
			}
			triangle {
				<-104.085195, -27.430002, 180.225350>,
				<-123.385200, -18.290001, 165.745335>,
				< -122.875189, -17.270002, 162.185337>
			}
			triangle {
				<-145.225189, -10.920001, 147.705322>,
				<-142.685184, -7.870000, 144.665345>,
				< -122.875189, -17.270002, 162.185337>
			}
			triangle {
				<-122.875189, -17.270002, 162.185337>,
				<-123.385200, -18.290001, 165.745335>,
				< -145.225189, -10.920001, 147.705322>
			}
			triangle {
				<-142.685184, -7.870000, 144.665345>,
				<-145.225189, -10.920001, 147.705322>,
				< -156.155186, -4.570000, 137.545318>
			}
			triangle {
				<-160.975199, -4.830000, 139.585336>,
				<-156.155186, -4.570000, 137.545318>,
				< -145.225189, -10.920001, 147.705322>
			}
			triangle {
				<-145.225189, -10.920001, 147.705322>,
				<-149.035189, -8.380001, 150.505308>,
				< -160.975199, -4.830000, 139.585336>
			}
			triangle {
				<-162.755191, -3.810000, 144.665345>,
				<-160.975199, -4.830000, 139.585336>,
				< -149.035189, -8.380001, 150.505308>
			}
			triangle {
				<-149.035189, -8.380001, 150.505308>,
				<-155.385193, -7.370000, 151.515321>,
				< -162.755191, -3.810000, 144.665345>
			}
			triangle {
				<-158.435180, 0.000000, 135.265325>,
				<-156.155186, -4.570000, 137.545318>,
				< -160.975199, -4.830000, 139.585336>
			}
			triangle {
				<-160.975199, -4.830000, 139.585336>,
				<-162.755191, 0.000000, 138.815342>,
				< -158.435180, 0.000000, 135.265325>
			}
			triangle {
				<-162.755191, -3.810000, 144.665345>,
				<-163.265202, 0.000000, 144.915345>,
				< -162.755191, 0.000000, 138.815342>
			}
			triangle {
				<-162.755191, 0.000000, 138.815342>,
				<-160.975199, -4.830000, 139.585336>,
				< -162.755191, -3.810000, 144.665345>
			}
			triangle {
				<-94.175192, -30.990000, 223.145329>,
				<-103.315187, -27.430002, 223.145329>,
				< -96.715182, -30.730001, 217.305336>
			}
			triangle {
				<-90.615193, -34.540004, 215.525330>,
				<-83.255191, -35.810002, 218.825318>,
				< -94.175192, -30.990000, 223.145329>
			}
			triangle {
				<-74.875186, -34.800000, 193.175330>,
				<-76.905187, -38.610003, 204.855329>,
				< -97.735184, -34.540004, 201.045330>
			}
			triangle {
				<-135.575183, -13.970000, 184.285350>,
				<-116.525192, -26.420001, 202.065338>,
				< -119.575187, -20.830001, 206.125339>
			}
			triangle {
				<-96.715182, -30.730001, 217.305336>,
				<-90.615193, -34.540004, 215.525330>,
				< -94.175192, -30.990000, 223.145329>
			}
			triangle {
				<3.864815, -78.230005, 157.105356>,
				<23.934815, -79.249999, 156.095343>,
				< 23.684816, -80.770002, 157.365324>
			}
			triangle {
				<23.684816, -80.770002, 157.365324>,
				<3.364815, -80.010004, 159.905343>,
				< 3.864815, -78.230005, 157.105356>
			}
			triangle {
				<3.364815, -80.010004, 159.905343>,
				<-7.815186, -73.660008, 164.215344>,
				< -8.575188, -71.370004, 161.425324>
			}
			triangle {
				<-8.575188, -71.370004, 161.425324>,
				<3.864815, -78.230005, 157.105356>,
				< 3.364815, -80.010004, 159.905343>
			}
			triangle {
				<37.904818, -77.220006, 160.155344>,
				<23.684816, -80.770002, 157.365324>,
				< 23.934815, -79.249999, 156.095343>
			}
			triangle {
				<14.284814, -64.519998, 175.395327>,
				<-8.575188, -71.370004, 161.425324>,
				< -34.235183, -35.050001, 179.455328>
			}
			triangle {
				<-34.235183, -35.050001, 179.455328>,
				<2.854813, -41.150004, 194.955322>,
				< 14.284814, -64.519998, 175.395327>
			}
			triangle {
				<37.904818, -77.220006, 160.155344>,
				<23.934815, -79.249999, 156.095343>,
				< 3.864815, -78.230005, 157.105356>
			}
			triangle {
				<3.864815, -78.230005, 157.105356>,
				<14.284814, -64.519998, 175.395327>,
				< 37.904818, -77.220006, 160.155344>
			}
			triangle {
				<14.284814, -64.519998, 175.395327>,
				<3.864815, -78.230005, 157.105356>,
				< -8.575188, -71.370004, 161.425324>
			}
			triangle {
				<142.044814, 0.000000, 328.045352>,
				<117.914815, -6.100000, 339.225364>,
				< 102.924818, -11.680000, 317.885334>
			}
			triangle {
				<102.924818, -11.680000, 317.885334>,
				<142.554811, -9.910000, 310.015320>,
				< 142.044814, 0.000000, 328.045352>
			}
			triangle {
				<142.044814, 0.000000, 328.045352>,
				<151.444834, 0.000000, 348.875313>,
				< 128.584808, -3.560000, 350.905349>
			}
			triangle {
				<128.584808, -3.560000, 350.905349>,
				<117.914815, -6.100000, 339.225364>,
				< 142.044814, 0.000000, 328.045352>
			}
			triangle {
				<151.444834, 0.000000, 348.875313>,
				<163.124819, 0.000000, 360.565308>,
				< 160.074818, 0.000000, 368.685366>
			}
			triangle {
				<160.074818, 0.000000, 368.685366>,
				<128.584808, -3.560000, 350.905349>,
				< 151.444834, 0.000000, 348.875313>
			}
			triangle {
				<128.584808, -3.560000, 350.905349>,
				<160.074818, 0.000000, 368.685366>,
				< 143.824821, -1.270000, 369.195320>
			}
			triangle {
				<138.484816, -30.990000, 201.815337>,
				<90.224817, -38.099999, 204.355327>,
				< 92.004816, 0.000000, 192.665347>
			}
			triangle {
				<92.004816, 0.000000, 192.665347>,
				<136.204822, 0.000000, 190.885326>,
				< 138.484816, -30.990000, 201.815337>
			}
			triangle {
				<92.004816, 0.000000, 192.665347>,
				<90.224817, -38.099999, 204.355327>,
				< 52.384818, -37.590002, 202.315339>
			}
			triangle {
				<52.384818, -37.590002, 202.315339>,
				<48.824816, 0.000000, 189.115329>,
				< 92.004816, 0.000000, 192.665347>
			}
			triangle {
				<239.074823, 0.000000, 157.365324>,
				<242.624827, -7.110000, 159.905343>,
				< 221.804818, -9.650000, 168.285340>
			}
			triangle {
				<221.804818, -9.650000, 168.285340>,
				<218.754831, 0.000000, 167.525342>,
				< 239.074823, 0.000000, 157.365324>
			}
			triangle {
				<191.574822, 0.000000, 184.035349>,
				<218.754831, 0.000000, 167.525342>,
				< 221.804818, -9.650000, 168.285340>
			}
			triangle {
				<221.804818, -9.650000, 168.285340>,
				<188.274820, -17.270002, 188.345336>,
				< 191.574822, 0.000000, 184.035349>
			}
			triangle {
				<263.714813, -5.590000, 142.885324>,
				<263.454845, 0.000000, 140.855345>,
				< 273.364819, 0.000000, 132.215337>
			}
			triangle {
				<273.364819, 0.000000, 132.215337>,
				<273.104794, -11.939999, 134.755342>,
				< 263.714813, -5.590000, 142.885324>
			}
			triangle {
				<278.444828, -52.320003, 124.595338>,
				<283.524808, -73.150003, 109.605320>,
				< 285.304829, -73.150003, 111.385319>
			}
			triangle {
				<285.304829, -73.150003, 111.385319>,
				<281.494830, -52.320003, 127.645326>,
				< 278.444828, -52.320003, 124.595338>
			}
			triangle {
				<281.494830, -52.320003, 127.645326>,
				<286.314842, -24.129999, 142.885324>,
				< 273.104794, -11.939999, 134.755342>
			}
			triangle {
				<273.104794, -11.939999, 134.755342>,
				<278.444828, -52.320003, 124.595338>,
				< 281.494830, -52.320003, 127.645326>
			}
			triangle {
				<300.034816, -86.610002, 84.715337>,
				<285.304829, -73.150003, 111.385319>,
				< 283.524808, -73.150003, 109.605320>
			}
			triangle {
				<292.414817, -7.370000, 141.615329>,
				<295.964820, 0.000000, 125.105321>,
				< 296.474803, 0.000000, 137.805329>
			}
			triangle {
				<273.104794, -11.939999, 134.755342>,
				<273.364819, 0.000000, 132.215337>,
				< 298.254823, 0.000000, 115.195318>
			}
			triangle {
				<298.254823, 0.000000, 115.195318>,
				<302.064823, -5.840000, 108.085331>,
				< 300.284831, -21.590000, 101.225344>
			}
			triangle {
				<300.284831, -21.590000, 101.225344>,
				<273.104794, -11.939999, 134.755342>,
				< 298.254823, 0.000000, 115.195318>
			}
			triangle {
				<273.104794, -11.939999, 134.755342>,
				<300.284831, -21.590000, 101.225344>,
				< 278.444828, -52.320003, 124.595338>
			}
			triangle {
				<300.284831, -21.590000, 101.225344>,
				<298.764835, -63.250003, 93.355315>,
				< 283.524808, -73.150003, 109.605320>
			}
			triangle {
				<283.524808, -73.150003, 109.605320>,
				<278.444828, -52.320003, 124.595338>,
				< 300.284831, -21.590000, 101.225344>
			}
			triangle {
				<283.524808, -73.150003, 109.605320>,
				<298.764835, -63.250003, 93.355315>,
				< 300.034816, -86.610002, 84.715337>
			}
			triangle {
				<285.304829, -73.150003, 111.385319>,
				<298.764835, -63.250003, 93.355315>,
				< 300.284831, -21.590000, 101.225344>
			}
			triangle {
				<300.284831, -21.590000, 101.225344>,
				<281.494830, -52.320003, 127.645326>,
				< 285.304829, -73.150003, 111.385319>
			}
			triangle {
				<300.284831, -21.590000, 101.225344>,
				<302.064823, -5.840000, 108.085331>,
				< 297.494826, -9.650000, 116.975347>
			}
			triangle {
				<297.494826, -9.650000, 116.975347>,
				<281.494830, -52.320003, 127.645326>,
				< 300.284831, -21.590000, 101.225344>
			}
			triangle {
				<281.494830, -52.320003, 127.645326>,
				<297.494826, -9.650000, 116.975347>,
				< 291.904834, -16.510000, 131.195314>
			}
			triangle {
				<281.494830, -52.320003, 127.645326>,
				<291.904834, -16.510000, 131.195314>,
				< 286.314842, -24.129999, 142.885324>
			}
			triangle {
				<291.904834, -16.510000, 131.195314>,
				<292.414817, -7.370000, 141.615329>,
				< 288.094834, -18.290001, 145.425328>
			}
			triangle {
				<288.094834, -18.290001, 145.425328>,
				<286.314842, -24.129999, 142.885324>,
				< 291.904834, -16.510000, 131.195314>
			}
			triangle {
				<-83.765188, 0.000000, 256.165344>,
				<-87.065190, 0.000000, 254.135337>,
				< -88.585193, -5.330000, 251.345331>
			}
			triangle {
				<-113.225190, -13.970000, 230.515327>,
				<-88.585193, -5.330000, 251.345331>,
				< -87.065190, 0.000000, 254.135337>
			}
			triangle {
				<-87.065190, 0.000000, 254.135337>,
				<-109.415197, 0.000000, 236.865331>,
				< -113.225190, -13.970000, 230.515327>
			}
			triangle {
				<-113.225190, -13.970000, 230.515327>,
				<-87.575180, -13.970000, 249.305343>,
				< -88.585193, -5.330000, 251.345331>
			}
			triangle {
				<38.924823, 0.000000, 320.425353>,
				<77.524816, 0.000000, 355.225360>,
				< 85.144815, 6.100000, 353.955322>
			}
			triangle {
				<85.144815, 6.100000, 353.955322>,
				<44.254815, 8.130001, 319.665355>,
				< 38.924823, 0.000000, 320.425353>
			}
			triangle {
				<77.524816, 0.000000, 355.225360>,
				<110.544817, 0.000000, 371.225299>,
				< 113.854815, 3.560000, 368.185365>
			}
			triangle {
				<113.854815, 3.560000, 368.185365>,
				<85.144815, 6.100000, 353.955322>,
				< 77.524816, 0.000000, 355.225360>
			}
			triangle {
				<110.544817, 0.000000, 371.225299>,
				<142.044814, 0.000000, 373.515331>,
				< 143.824821, 1.270000, 369.195320>
			}
			triangle {
				<143.824821, 1.270000, 369.195320>,
				<113.854815, 3.560000, 368.185365>,
				< 110.544817, 0.000000, 371.225299>
			}
			triangle {
				<143.824821, 1.270000, 369.195320>,
				<142.044814, 0.000000, 373.515331>,
				< 160.074818, 0.000000, 368.685366>
			}
			triangle {
				<142.554811, 9.910000, 310.015320>,
				<142.044814, 0.000000, 328.045352>,
				< 152.714815, 0.000000, 303.155348>
			}
			triangle {
				<44.254815, 8.130001, 319.665355>,
				<85.144815, 6.100000, 353.955322>,
				< 117.914815, 6.100000, 339.225364>
			}
			triangle {
				<117.914815, 6.100000, 339.225364>,
				<102.924818, 11.680000, 317.885334>,
				< 44.254815, 8.130001, 319.665355>
			}
			triangle {
				<85.144815, 6.100000, 353.955322>,
				<113.854815, 3.560000, 368.185365>,
				< 128.584808, 3.560000, 350.905349>
			}
			triangle {
				<128.584808, 3.560000, 350.905349>,
				<117.914815, 6.100000, 339.225364>,
				< 85.144815, 6.100000, 353.955322>
			}
			triangle {
				<128.584808, 3.560000, 350.905349>,
				<113.854815, 3.560000, 368.185365>,
				< 143.824821, 1.270000, 369.195320>
			}
			triangle {
				<-126.945199, 0.000000, 221.115336>,
				<-132.275195, 7.620000, 213.245336>,
				< -137.355189, 0.000000, 209.435336>
			}
			triangle {
				<-126.945199, 0.000000, 221.115336>,
				<-109.415197, 0.000000, 236.865331>,
				< -113.225190, 13.970000, 230.515327>
			}
			triangle {
				<-113.225190, 13.970000, 230.515327>,
				<-132.275195, 7.620000, 213.245336>,
				< -126.945199, 0.000000, 221.115336>
			}
			triangle {
				<-88.585193, 5.330000, 251.345331>,
				<-83.765188, 0.000000, 256.165344>,
				< -49.725189, 0.000000, 279.785339>
			}
			triangle {
				<-49.725189, 0.000000, 279.785339>,
				<-87.575180, 13.970000, 249.305343>,
				< -88.585193, 5.330000, 251.345331>
			}
			triangle {
				<-87.575180, 13.970000, 249.305343>,
				<-49.725189, 0.000000, 279.785339>,
				< -50.745180, 18.290001, 273.695317>
			}
			triangle {
				<-49.725189, 0.000000, 279.785339>,
				<-7.055184, 0.000000, 300.365342>,
				< -7.815186, 22.350002, 295.025337>
			}
			triangle {
				<-7.815186, 22.350002, 295.025337>,
				<-50.745180, 18.290001, 273.695317>,
				< -49.725189, 0.000000, 279.785339>
			}
			triangle {
				<-7.055184, 0.000000, 300.365342>,
				<38.924823, 0.000000, 320.425353>,
				< 44.254815, 8.130001, 319.665355>
			}
			triangle {
				<44.254815, 8.130001, 319.665355>,
				<-7.815186, 22.350002, 295.025337>,
				< -7.055184, 0.000000, 300.365342>
			}
			triangle {
				<-7.815186, 22.350002, 295.025337>,
				<44.254815, 8.130001, 319.665355>,
				< 41.204820, 24.640000, 304.685353>
			}
			triangle {
				<44.254815, 8.130001, 319.665355>,
				<102.924818, 11.680000, 317.885334>,
				< 99.374822, 26.670000, 303.155348>
			}
			triangle {
				<99.374822, 26.670000, 303.155348>,
				<41.204820, 24.640000, 304.685353>,
				< 44.254815, 8.130001, 319.665355>
			}
			triangle {
				<102.924818, 11.680000, 317.885334>,
				<142.554811, 9.910000, 310.015320>,
				< 155.504820, 20.320000, 291.215338>
			}
			triangle {
				<155.504820, 20.320000, 291.215338>,
				<99.374822, 26.670000, 303.155348>,
				< 102.924818, 11.680000, 317.885334>
			}
			triangle {
				<155.504820, 20.320000, 291.215338>,
				<142.554811, 9.910000, 310.015320>,
				< 152.714815, 0.000000, 303.155348>
			}
			triangle {
				<155.504820, 20.320000, 291.215338>,
				<152.714815, 0.000000, 303.155348>,
				< 223.074827, 0.000000, 259.215346>
			}
			triangle {
				<223.074827, 0.000000, 259.215346>,
				<221.804818, 11.680000, 255.155331>,
				< 155.504820, 20.320000, 291.215338>
			}
			triangle {
				<223.074827, 0.000000, 259.215346>,
				<263.714813, 0.000000, 224.165352>,
				< 256.094813, 14.730000, 215.015333>
			}
			triangle {
				<256.094813, 14.730000, 215.015333>,
				<221.804818, 11.680000, 255.155331>,
				< 223.074827, 0.000000, 259.215346>
			}
			triangle {
				<263.714813, 0.000000, 224.165352>,
				<281.744816, 0.000000, 200.545328>,
				< 271.834813, 11.940000, 188.095350>
			}
			triangle {
				<271.834813, 11.940000, 188.095350>,
				<256.094813, 14.730000, 215.015333>,
				< 263.714813, 0.000000, 224.165352>
			}
			triangle {
				<281.744816, 0.000000, 200.545328>,
				<294.194838, 0.000000, 176.665351>,
				< 284.794818, 7.870000, 165.235324>
			}
			triangle {
				<284.794818, 7.870000, 165.235324>,
				<271.834813, 11.940000, 188.095350>,
				< 281.744816, 0.000000, 200.545328>
			}
			triangle {
				<294.194838, 0.000000, 176.665351>,
				<300.284831, 0.000000, 156.595345>,
				< 294.694839, 9.650000, 149.235328>
			}
			triangle {
				<294.694839, 9.650000, 149.235328>,
				<284.794818, 7.870000, 165.235324>,
				< 294.194838, 0.000000, 176.665351>
			}
			triangle {
				<300.284831, 0.000000, 156.595345>,
				<296.474803, 0.000000, 137.805329>,
				< 292.414817, 7.370000, 141.615329>
			}
			triangle {
				<292.414817, 7.370000, 141.615329>,
				<294.694839, 9.650000, 149.235328>,
				< 300.284831, 0.000000, 156.595345>
			}
			triangle {
				<-90.115192, 22.350002, 242.955324>,
				<-113.225190, 13.970000, 230.515327>,
				< -87.575180, 13.970000, 249.305343>
			}
			triangle {
				<-73.855178, 32.770000, 241.685344>,
				<-90.115192, 22.350002, 242.955324>,
				< -87.575180, 13.970000, 249.305343>
			}
			triangle {
				<-73.855178, 32.770000, 241.685344>,
				<-87.575180, 13.970000, 249.305343>,
				< -50.745180, 18.290001, 273.695317>
			}
			triangle {
				<-50.745180, 18.290001, 273.695317>,
				<-44.395190, 29.970001, 259.725357>,
				< -73.855178, 32.770000, 241.685344>
			}
			triangle {
				<-50.745180, 18.290001, 273.695317>,
				<-7.815186, 22.350002, 295.025337>,
				< -7.305183, 31.999999, 276.235336>
			}
			triangle {
				<-7.305183, 31.999999, 276.235336>,
				<-44.395190, 29.970001, 259.725357>,
				< -50.745180, 18.290001, 273.695317>
			}
			triangle {
				<-7.815186, 22.350002, 295.025337>,
				<41.204820, 24.640000, 304.685353>,
				< 41.204820, 35.810002, 286.905336>
			}
			triangle {
				<41.204820, 35.810002, 286.905336>,
				<-7.305183, 31.999999, 276.235336>,
				< -7.815186, 22.350002, 295.025337>
			}
			triangle {
				<41.204820, 24.640000, 304.685353>,
				<99.374822, 26.670000, 303.155348>,
				< 91.754815, 34.040002, 285.635327>
			}
			triangle {
				<91.754815, 34.040002, 285.635327>,
				<41.204820, 35.810002, 286.905336>,
				< 41.204820, 24.640000, 304.685353>
			}
			triangle {
				<99.374822, 26.670000, 303.155348>,
				<155.504820, 20.320000, 291.215338>,
				< 152.204803, 28.450001, 277.755332>
			}
			triangle {
				<152.204803, 28.450001, 277.755332>,
				<91.754815, 34.040002, 285.635327>,
				< 99.374822, 26.670000, 303.155348>
			}
			triangle {
				<155.504820, 20.320000, 291.215338>,
				<221.804818, 11.680000, 255.155331>,
				< 218.494820, 18.290001, 248.295330>
			}
			triangle {
				<218.494820, 18.290001, 248.295330>,
				<152.204803, 28.450001, 277.755332>,
				< 155.504820, 20.320000, 291.215338>
			}
			triangle {
				<218.494820, 18.290001, 248.295330>,
				<221.804818, 11.680000, 255.155331>,
				< 256.094813, 14.730000, 215.015333>
			}
			triangle {
				<-85.535192, 36.580003, 228.735335>,
				<-95.695195, 31.750002, 230.255316>,
				< -90.115192, 22.350002, 242.955324>
			}
			triangle {
				<-90.115192, 22.350002, 242.955324>,
				<-73.855178, 32.770000, 241.685344>,
				< -85.535192, 36.580003, 228.735335>
			}
			triangle {
				<-95.695195, 31.750002, 230.255316>,
				<-103.315187, 27.430002, 223.145329>,
				< -113.225190, 13.970000, 230.515327>
			}
			triangle {
				<-113.225190, 13.970000, 230.515327>,
				<-90.115192, 22.350002, 242.955324>,
				< -95.695195, 31.750002, 230.255316>
			}
			triangle {
				<-113.225190, 13.970000, 230.515327>,
				<-103.315187, 27.430002, 223.145329>,
				< -119.575187, 20.830001, 206.125339>
			}
			triangle {
				<-119.575187, 20.830001, 206.125339>,
				<-132.275195, 7.620000, 213.245336>,
				< -113.225190, 13.970000, 230.515327>
			}
			triangle {
				<-132.275195, 7.620000, 213.245336>,
				<-119.575187, 20.830001, 206.125339>,
				< -133.795190, 10.160000, 191.905335>
			}
			triangle {
				<-83.255191, 35.810002, 218.825318>,
				<-94.175192, 30.990000, 223.145329>,
				< -95.695195, 31.750002, 230.255316>
			}
			triangle {
				<-95.695195, 31.750002, 230.255316>,
				<-85.535192, 36.580003, 228.735335>,
				< -83.255191, 35.810002, 218.825318>
			}
			triangle {
				<-95.695195, 31.750002, 230.255316>,
				<-94.175192, 30.990000, 223.145329>,
				< -103.315187, 27.430002, 223.145329>
			}
			triangle {
				<-119.575187, 20.830001, 206.125339>,
				<-135.575183, 13.970000, 184.285350>,
				< -133.795190, 10.160000, 191.905335>
			}
			triangle {
				<-155.385193, 7.370000, 151.515321>,
				<-160.465187, 7.370000, 153.805340>,
				< -135.575183, 13.970000, 184.285350>
			}
			triangle {
				<-135.575183, 13.970000, 184.285350>,
				<-128.715181, 14.990000, 174.635315>,
				< -155.385193, 7.370000, 151.515321>
			}
			triangle {
				<-166.565190, 0.000000, 151.515321>,
				<-142.945195, 0.000000, 183.015326>,
				< -140.145194, 5.080000, 185.305330>
			}
			triangle {
				<-140.145194, 5.080000, 185.305330>,
				<-165.295166, 4.060000, 149.995340>,
				< -166.565190, 0.000000, 151.515321>
			}
			triangle {
				<-133.795190, 10.160000, 191.905335>,
				<-140.145194, 5.080000, 185.305330>,
				< -137.355189, 0.000000, 209.435336>
			}
			triangle {
				<-137.355189, 0.000000, 209.435336>,
				<-132.275195, 7.620000, 213.245336>,
				< -133.795190, 10.160000, 191.905335>
			}
			triangle {
				<-137.355189, 0.000000, 209.435336>,
				<-140.145194, 5.080000, 185.305330>,
				< -142.945195, 0.000000, 183.015326>
			}
			triangle {
				<-103.315187, 27.430002, 223.145329>,
				<-96.715182, 30.730001, 217.305336>,
				< -103.065186, 30.730001, 206.635321>
			}
			triangle {
				<-103.065186, 30.730001, 206.635321>,
				<-104.085195, 30.480000, 209.435336>,
				< -103.315187, 27.430002, 223.145329>
			}
			triangle {
				<-119.575187, 20.830001, 206.125339>,
				<-103.315187, 27.430002, 223.145329>,
				< -104.085195, 30.480000, 209.435336>
			}
			triangle {
				<-104.085195, 30.480000, 209.435336>,
				<-116.525192, 26.420001, 202.065338>,
				< -119.575187, 20.830001, 206.125339>
			}
			triangle {
				<-104.085195, 30.480000, 209.435336>,
				<-103.065186, 30.730001, 206.635321>,
				< -113.225190, 25.910001, 196.735328>
			}
			triangle {
				<-113.225190, 25.910001, 196.735328>,
				<-116.525192, 26.420001, 202.065338>,
				< -104.085195, 30.480000, 209.435336>
			}
			triangle {
				<-116.525192, 26.420001, 202.065338>,
				<-113.225190, 25.910001, 196.735328>,
				< -128.715181, 14.990000, 174.635315>
			}
			triangle {
				<-128.715181, 14.990000, 174.635315>,
				<-135.575183, 13.970000, 184.285350>,
				< -116.525192, 26.420001, 202.065338>
			}
			triangle {
				<-128.715181, 14.990000, 174.635315>,
				<-124.905182, 16.260001, 170.825315>,
				< -149.035189, 8.380001, 150.505308>
			}
			triangle {
				<-149.035189, 8.380001, 150.505308>,
				<-155.385193, 7.370000, 151.515321>,
				< -128.715181, 14.990000, 174.635315>
			}
			triangle {
				<-128.715181, 14.990000, 174.635315>,
				<-113.225190, 25.910001, 196.735328>,
				< -106.625185, 25.910001, 185.805332>
			}
			triangle {
				<-106.625185, 25.910001, 185.805332>,
				<-124.905182, 16.260001, 170.825315>,
				< -128.715181, 14.990000, 174.635315>
			}
			triangle {
				<-113.225190, 25.910001, 196.735328>,
				<-103.065186, 30.730001, 206.635321>,
				< -97.735184, 34.540004, 201.045330>
			}
			triangle {
				<-97.735184, 34.540004, 201.045330>,
				<-74.875186, 34.800000, 193.175330>,
				< -104.085195, 27.430002, 180.225350>
			}
			triangle {
				<-104.085195, 27.430002, 180.225350>,
				<-106.625185, 25.910001, 185.805332>,
				< -97.735184, 34.540004, 201.045330>
			}
			triangle {
				<-140.145194, 5.080000, 185.305330>,
				<-133.795190, 10.160000, 191.905335>,
				< -135.575183, 13.970000, 184.285350>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-103.065186, 30.730001, 206.635321>,
				< -96.715182, 30.730001, 217.305336>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-96.715182, 30.730001, 217.305336>,
				< -90.615193, 34.540004, 215.525330>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-90.615193, 34.540004, 215.525330>,
				< -83.255191, 35.810002, 218.825318>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-83.255191, 35.810002, 218.825318>,
				< -76.905187, 38.610003, 204.855329>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-76.905187, 38.610003, 204.855329>,
				< -97.735184, 34.540004, 201.045330>
			}
			triangle {
				<-92.655182, 34.800000, 206.385320>,
				<-97.735184, 34.540004, 201.045330>,
				< -103.065186, 30.730001, 206.635321>
			}
			triangle {
				<-145.225189, 10.920001, 147.705322>,
				<-149.035189, 8.380001, 150.505308>,
				< -124.905182, 16.260001, 170.825315>
			}
			triangle {
				<-124.905182, 16.260001, 170.825315>,
				<-123.385200, 18.290001, 165.745335>,
				< -145.225189, 10.920001, 147.705322>
			}
			triangle {
				<-123.385200, 18.290001, 165.745335>,
				<-124.905182, 16.260001, 170.825315>,
				< -106.625185, 25.910001, 185.805332>
			}
			triangle {
				<-106.625185, 25.910001, 185.805332>,
				<-104.085195, 27.430002, 180.225350>,
				< -123.385200, 18.290001, 165.745335>
			}
			triangle {
				<-100.015185, 17.020001, 158.635319>,
				<-104.085195, 27.430002, 180.225350>,
				< -86.805194, 31.750002, 188.095350>
			}
			triangle {
				<-86.805194, 31.750002, 188.095350>,
				<-64.455187, 22.350002, 168.025329>,
				< -100.015185, 17.020001, 158.635319>
			}
			triangle {
				<-64.455187, 22.350002, 168.025329>,
				<-86.805194, 31.750002, 188.095350>,
				< -74.875186, 34.800000, 193.175330>
			}
			triangle {
				<-100.015185, 17.020001, 158.635319>,
				<-117.545186, 10.160000, 157.865325>,
				< -122.875189, 17.270002, 162.185337>
			}
			triangle {
				<-122.875189, 17.270002, 162.185337>,
				<-104.085195, 27.430002, 180.225350>,
				< -100.015185, 17.020001, 158.635319>
			}
			triangle {
				<-74.875186, 34.800000, 193.175330>,
				<-36.005191, 43.180001, 189.365330>,
				< -34.235183, 35.050001, 179.455328>
			}
			triangle {
				<-34.235183, 35.050001, 179.455328>,
				<-64.455187, 22.350002, 168.025329>,
				< -74.875186, 34.800000, 193.175330>
			}
			triangle {
				<-74.875186, 34.800000, 193.175330>,
				<-72.585190, 40.389999, 205.875338>,
				< -32.965181, 49.280000, 219.595340>
			}
			triangle {
				<-32.965181, 49.280000, 219.595340>,
				<-36.005191, 43.180001, 189.365330>,
				< -74.875186, 34.800000, 193.175330>
			}
			triangle {
				<-74.875186, 34.800000, 193.175330>,
				<-76.905187, 38.610003, 204.855329>,
				< -72.585190, 40.389999, 205.875338>
			}
			triangle {
				<-76.905187, 38.610003, 204.855329>,
				<-83.255191, 35.810002, 218.825318>,
				< -67.505188, 40.130003, 223.655340>
			}
			triangle {
				<-67.505188, 40.130003, 223.655340>,
				<-72.585190, 40.389999, 205.875338>,
				< -76.905187, 38.610003, 204.855329>
			}
			triangle {
				<-83.255191, 35.810002, 218.825318>,
				<-85.535192, 36.580003, 228.735335>,
				< -73.855178, 32.770000, 241.685344>
			}
			triangle {
				<-73.855178, 32.770000, 241.685344>,
				<-67.505188, 40.130003, 223.655340>,
				< -83.255191, 35.810002, 218.825318>
			}
			triangle {
				<-67.505188, 40.130003, 223.655340>,
				<-73.855178, 32.770000, 241.685344>,
				< -66.485187, 36.580003, 236.605349>
			}
			triangle {
				<-67.505188, 40.130003, 223.655340>,
				<-36.265183, 42.670000, 243.215349>,
				< -32.965181, 49.280000, 219.595340>
			}
			triangle {
				<-32.965181, 49.280000, 219.595340>,
				<-72.585190, 40.389999, 205.875338>,
				< -67.505188, 40.130003, 223.655340>
			}
			triangle {
				<-36.265183, 42.670000, 243.215349>,
				<-4.765183, 46.230002, 252.865327>,
				< 7.174813, 51.050000, 227.715341>
			}
			triangle {
				<7.174813, 51.050000, 227.715341>,
				<-32.965181, 49.280000, 219.595340>,
				< -36.265183, 42.670000, 243.215349>
			}
			triangle {
				<-4.765183, 46.230002, 252.865327>,
				<45.774810, 48.010002, 255.155331>,
				< 50.854816, 51.050000, 236.355348>
			}
			triangle {
				<50.854816, 51.050000, 236.355348>,
				<7.174813, 51.050000, 227.715341>,
				< -4.765183, 46.230002, 252.865327>
			}
			triangle {
				<45.774810, 48.010002, 255.155331>,
				<93.784816, 46.230002, 260.235340>,
				< 95.814823, 49.020000, 236.605349>
			}
			triangle {
				<95.814823, 49.020000, 236.605349>,
				<50.854816, 51.050000, 236.355348>,
				< 45.774810, 48.010002, 255.155331>
			}
			triangle {
				<93.784816, 46.230002, 260.235340>,
				<149.664813, 43.939999, 254.135337>,
				< 149.154816, 44.700004, 227.215339>
			}
			triangle {
				<149.154816, 44.700004, 227.215339>,
				<95.814823, 49.020000, 236.605349>,
				< 93.784816, 46.230002, 260.235340>
			}
			triangle {
				<149.664813, 43.939999, 254.135337>,
				<208.844828, 33.020001, 229.245332>,
				< 198.684824, 28.450001, 206.895332>
			}
			triangle {
				<198.684824, 28.450001, 206.895332>,
				<149.154816, 44.700004, 227.215339>,
				< 149.664813, 43.939999, 254.135337>
			}
			triangle {
				<208.844828, 33.020001, 229.245332>,
				<244.154832, 23.370001, 204.355327>,
				< 229.424831, 21.840001, 184.535351>
			}
			triangle {
				<229.424831, 21.840001, 184.535351>,
				<198.684824, 28.450001, 206.895332>,
				< 208.844828, 33.020001, 229.245332>
			}
			triangle {
				<244.154832, 23.370001, 204.355327>,
				<261.934820, 13.970000, 180.225350>,
				< 251.264820, 14.220000, 169.295324>
			}
			triangle {
				<251.264820, 14.220000, 169.295324>,
				<229.424831, 21.840001, 184.535351>,
				< 244.154832, 23.370001, 204.355327>
			}
			triangle {
				<261.934820, 13.970000, 180.225350>,
				<273.874830, 9.910000, 163.715342>,
				< 263.204830, 10.670001, 156.855356>
			}
			triangle {
				<263.204830, 10.670001, 156.855356>,
				<251.264820, 14.220000, 169.295324>,
				< 261.934820, 13.970000, 180.225350>
			}
			triangle {
				<-36.265183, 42.670000, 243.215349>,
				<-67.505188, 40.130003, 223.655340>,
				< -66.485187, 36.580003, 236.605349>
			}
			triangle {
				<-36.265183, 42.670000, 243.215349>,
				<-66.485187, 36.580003, 236.605349>,
				< -44.395190, 29.970001, 259.725357>
			}
			triangle {
				<-44.395190, 29.970001, 259.725357>,
				<-66.485187, 36.580003, 236.605349>,
				< -73.855178, 32.770000, 241.685344>
			}
			triangle {
				<-44.395190, 29.970001, 259.725357>,
				<-7.305183, 31.999999, 276.235336>,
				< -4.765183, 46.230002, 252.865327>
			}
			triangle {
				<-4.765183, 46.230002, 252.865327>,
				<-36.265183, 42.670000, 243.215349>,
				< -44.395190, 29.970001, 259.725357>
			}
			triangle {
				<-7.305183, 31.999999, 276.235336>,
				<41.204820, 35.810002, 286.905336>,
				< 45.774810, 48.010002, 255.155331>
			}
			triangle {
				<45.774810, 48.010002, 255.155331>,
				<-4.765183, 46.230002, 252.865327>,
				< -7.305183, 31.999999, 276.235336>
			}
			triangle {
				<41.204820, 35.810002, 286.905336>,
				<91.754815, 34.040002, 285.635327>,
				< 93.784816, 46.230002, 260.235340>
			}
			triangle {
				<93.784816, 46.230002, 260.235340>,
				<45.774810, 48.010002, 255.155331>,
				< 41.204820, 35.810002, 286.905336>
			}
			triangle {
				<91.754815, 34.040002, 285.635327>,
				<152.204803, 28.450001, 277.755332>,
				< 149.664813, 43.939999, 254.135337>
			}
			triangle {
				<149.664813, 43.939999, 254.135337>,
				<93.784816, 46.230002, 260.235340>,
				< 91.754815, 34.040002, 285.635327>
			}
			triangle {
				<152.204803, 28.450001, 277.755332>,
				<218.494820, 18.290001, 248.295330>,
				< 208.844828, 33.020001, 229.245332>
			}
			triangle {
				<208.844828, 33.020001, 229.245332>,
				<149.664813, 43.939999, 254.135337>,
				< 152.204803, 28.450001, 277.755332>
			}
			triangle {
				<218.494820, 18.290001, 248.295330>,
				<256.094813, 14.730000, 215.015333>,
				< 244.154832, 23.370001, 204.355327>
			}
			triangle {
				<244.154832, 23.370001, 204.355327>,
				<208.844828, 33.020001, 229.245332>,
				< 218.494820, 18.290001, 248.295330>
			}
			triangle {
				<256.094813, 14.730000, 215.015333>,
				<271.834813, 11.940000, 188.095350>,
				< 261.934820, 13.970000, 180.225350>
			}
			triangle {
				<261.934820, 13.970000, 180.225350>,
				<244.154832, 23.370001, 204.355327>,
				< 256.094813, 14.730000, 215.015333>
			}
			triangle {
				<271.834813, 11.940000, 188.095350>,
				<284.794818, 7.870000, 165.235324>,
				< 273.874830, 9.910000, 163.715342>
			}
			triangle {
				<273.874830, 9.910000, 163.715342>,
				<261.934820, 13.970000, 180.225350>,
				< 271.834813, 11.940000, 188.095350>
			}
			triangle {
				<284.794818, 7.870000, 165.235324>,
				<294.694839, 9.650000, 149.235328>,
				< 288.094834, 18.290001, 145.425328>
			}
			triangle {
				<288.094834, 18.290001, 145.425328>,
				<273.874830, 9.910000, 163.715342>,
				< 284.794818, 7.870000, 165.235324>
			}
			triangle {
				<288.094834, 18.290001, 145.425328>,
				<294.694839, 9.650000, 149.235328>,
				< 292.414817, 7.370000, 141.615329>
			}
			triangle {
				<-32.965181, 49.280000, 219.595340>,
				<7.174813, 51.050000, 227.715341>,
				< 2.854813, 41.150004, 194.955322>
			}
			triangle {
				<2.854813, 41.150004, 194.955322>,
				<-36.005191, 43.180001, 189.365330>,
				< -32.965181, 49.280000, 219.595340>
			}
			triangle {
				<7.174813, 51.050000, 227.715341>,
				<50.854816, 51.050000, 236.355348>,
				< 52.384818, 37.590002, 202.315339>
			}
			triangle {
				<52.384818, 37.590002, 202.315339>,
				<2.854813, 41.150004, 194.955322>,
				< 7.174813, 51.050000, 227.715341>
			}
			triangle {
				<50.854816, 51.050000, 236.355348>,
				<95.814823, 49.020000, 236.605349>,
				< 90.224817, 38.099999, 204.355327>
			}
			triangle {
				<90.224817, 38.099999, 204.355327>,
				<52.384818, 37.590002, 202.315339>,
				< 50.854816, 51.050000, 236.355348>
			}
			triangle {
				<95.814823, 49.020000, 236.605349>,
				<149.154816, 44.700004, 227.215339>,
				< 138.484816, 30.990000, 201.815337>
			}
			triangle {
				<138.484816, 30.990000, 201.815337>,
				<90.224817, 38.099999, 204.355327>,
				< 95.814823, 49.020000, 236.605349>
			}
			triangle {
				<149.154816, 44.700004, 227.215339>,
				<198.684824, 28.450001, 206.895332>,
				< 188.274820, 17.270002, 188.345336>
			}
			triangle {
				<188.274820, 17.270002, 188.345336>,
				<138.484816, 30.990000, 201.815337>,
				< 149.154816, 44.700004, 227.215339>
			}
			triangle {
				<198.684824, 28.450001, 206.895332>,
				<229.424831, 21.840001, 184.535351>,
				< 221.804818, 9.650000, 168.285340>
			}
			triangle {
				<221.804818, 9.650000, 168.285340>,
				<188.274820, 17.270002, 188.345336>,
				< 198.684824, 28.450001, 206.895332>
			}
			triangle {
				<229.424831, 21.840001, 184.535351>,
				<251.264820, 14.220000, 169.295324>,
				< 242.624827, 7.110000, 159.905343>
			}
			triangle {
				<242.624827, 7.110000, 159.905343>,
				<221.804818, 9.650000, 168.285340>,
				< 229.424831, 21.840001, 184.535351>
			}
			triangle {
				<251.264820, 14.220000, 169.295324>,
				<263.204830, 10.670001, 156.855356>,
				< 263.714813, 5.590000, 142.885324>
			}
			triangle {
				<263.714813, 5.590000, 142.885324>,
				<242.624827, 7.110000, 159.905343>,
				< 251.264820, 14.220000, 169.295324>
			}
			triangle {
				<263.714813, 5.590000, 142.885324>,
				<263.204830, 10.670001, 156.855356>,
				< 273.104794, 11.940000, 134.755342>
			}
			triangle {
				<-36.005191, 43.180001, 189.365330>,
				<-7.815186, 73.660008, 164.215344>,
				< -8.575188, 71.370004, 161.425324>
			}
			triangle {
				<-8.575188, 71.370004, 161.425324>,
				<-34.235183, 35.050001, 179.455328>,
				< -36.005191, 43.180001, 189.365330>
			}
			triangle {
				<-36.005191, 43.180001, 189.365330>,
				<2.854813, 41.150004, 194.955322>,
				< 14.284814, 64.519998, 175.395327>
			}
			triangle {
				<14.284814, 64.519998, 175.395327>,
				<-7.815186, 73.660008, 164.215344>,
				< -36.005191, 43.180001, 189.365330>
			}
			triangle {
				<-7.815186, 73.660008, 164.215344>,
				<14.284814, 64.519998, 175.395327>,
				< 37.904818, 77.220006, 160.155344>
			}
			triangle {
				<37.904818, 77.220006, 160.155344>,
				<3.364815, 80.010004, 159.905343>,
				< -7.815186, 73.660008, 164.215344>
			}
			triangle {
				<3.364815, 80.010004, 159.905343>,
				<37.904818, 77.220006, 160.155344>,
				< 23.684816, 80.770002, 157.365324>
			}
			triangle {
				<52.384818, 37.590002, 202.315339>,
				<48.824816, 0.000000, 189.115329>,
				< 5.394814, 0.000000, 179.205327>
			}
			triangle {
				<5.394814, 0.000000, 179.205327>,
				<2.854813, 41.150004, 194.955322>,
				< 52.384818, 37.590002, 202.315339>
			}
			triangle {
				<138.484816, 30.990000, 201.815337>,
				<188.274820, 17.270002, 188.345336>,
				< 191.574822, 0.000000, 184.035349>
			}
			triangle {
				<191.574822, 0.000000, 184.035349>,
				<136.204822, 0.000000, 190.885326>,
				< 138.484816, 30.990000, 201.815337>
			}
			triangle {
				<242.624827, 7.110000, 159.905343>,
				<263.714813, 5.590000, 142.885324>,
				< 263.454845, 0.000000, 140.855345>
			}
			triangle {
				<263.454845, 0.000000, 140.855345>,
				<239.074823, 0.000000, 157.365324>,
				< 242.624827, 7.110000, 159.905343>
			}
			triangle {
				<-64.455187, 22.350002, 168.025329>,
				<-34.235183, 35.050001, 179.455328>,
				< -25.085175, 0.000000, 172.605322>
			}
			triangle {
				<-25.085175, 0.000000, 172.605322>,
				<-59.885196, 0.000000, 165.485325>,
				< -64.455187, 22.350002, 168.025329>
			}
			triangle {
				<-34.235183, 35.050001, 179.455328>,
				<2.854813, 41.150004, 194.955322>,
				< 5.394814, 0.000000, 179.205327>
			}
			triangle {
				<5.394814, 0.000000, 179.205327>,
				<-25.085175, 0.000000, 172.605322>,
				< -34.235183, 35.050001, 179.455328>
			}
			triangle {
				<-100.015185, 17.020001, 158.635319>,
				<-64.455187, 22.350002, 168.025329>,
				< -59.885196, 0.000000, 165.485325>
			}
			triangle {
				<-59.885196, 0.000000, 165.485325>,
				<-92.145192, 0.000000, 155.835332>,
				< -100.015185, 17.020001, 158.635319>
			}
			triangle {
				<-117.545186, 10.160000, 157.865325>,
				<-100.015185, 17.020001, 158.635319>,
				< -92.145192, 0.000000, 155.835332>
			}
			triangle {
				<-92.145192, 0.000000, 155.835332>,
				<-114.745178, 0.000000, 155.835332>,
				< -117.545186, 10.160000, 157.865325>
			}
			triangle {
				<-142.685184, 7.870000, 144.665345>,
				<-117.545186, 10.160000, 157.865325>,
				< -114.745178, 0.000000, 155.835332>
			}
			triangle {
				<-114.745178, 0.000000, 155.835332>,
				<-139.645193, 0.000000, 143.395335>,
				< -142.685184, 7.870000, 144.665345>
			}
			triangle {
				<-142.685184, 7.870000, 144.665345>,
				<-122.875189, 17.270002, 162.185337>,
				< -117.545186, 10.160000, 157.865325>
			}
			triangle {
				<-158.435180, 0.000000, 135.265325>,
				<-156.155186, 4.570000, 137.545318>,
				< -142.685184, 7.870000, 144.665345>
			}
			triangle {
				<-142.685184, 7.870000, 144.665345>,
				<-139.645193, 0.000000, 143.395335>,
				< -158.435180, 0.000000, 135.265325>
			}
			triangle {
				<300.034816, 86.610002, 84.715337>,
				<285.304829, 73.150003, 111.385319>,
				< 298.764835, 63.250003, 93.355315>
			}
			triangle {
				<291.904834, 16.510000, 131.195314>,
				<292.414817, 7.370000, 141.615329>,
				< 295.964820, 0.000000, 125.105321>
			}
			triangle {
				<295.964820, 0.000000, 125.105321>,
				<297.494826, 9.650000, 116.975347>,
				< 291.904834, 16.510000, 131.195314>
			}
			triangle {
				<297.494826, 9.650000, 116.975347>,
				<295.964820, 0.000000, 125.105321>,
				< 298.254823, 0.000000, 115.195318>
			}
			triangle {
				<298.254823, 0.000000, 115.195318>,
				<302.064823, 5.840000, 108.085331>,
				< 297.494826, 9.650000, 116.975347>
			}
			triangle {
				<288.094834, 18.290001, 145.425328>,
				<286.314842, 24.129999, 142.885324>,
				< 263.204830, 10.670001, 156.855356>
			}
			triangle {
				<263.204830, 10.670001, 156.855356>,
				<273.874830, 9.910000, 163.715342>,
				< 288.094834, 18.290001, 145.425328>
			}
			triangle {
				<263.204830, 10.670001, 156.855356>,
				<286.314842, 24.129999, 142.885324>,
				< 273.104794, 11.940000, 134.755342>
			}
			triangle {
				<-135.575183, 13.970000, 184.285350>,
				<-160.465187, 7.370000, 153.805340>,
				< -165.295166, 4.060000, 149.995340>
			}
			triangle {
				<-165.295166, 4.060000, 149.995340>,
				<-140.145194, 5.080000, 185.305330>,
				< -135.575183, 13.970000, 184.285350>
			}
			triangle {
				<-162.755191, 3.810000, 144.665345>,
				<-163.265202, 0.000000, 144.915345>,
				< -166.565190, 0.000000, 151.515321>
			}
			triangle {
				<-166.565190, 0.000000, 151.515321>,
				<-165.295166, 4.060000, 149.995340>,
				< -162.755191, 3.810000, 144.665345>
			}
			triangle {
				<-165.295166, 4.060000, 149.995340>,
				<-160.465187, 7.370000, 153.805340>,
				< -155.385193, 7.370000, 151.515321>
			}
			triangle {
				<-155.385193, 7.370000, 151.515321>,
				<-162.755191, 3.810000, 144.665345>,
				< -165.295166, 4.060000, 149.995340>
			}
			triangle {
				<-122.875189, 17.270002, 162.185337>,
				<-123.385200, 18.290001, 165.745335>,
				< -104.085195, 27.430002, 180.225350>
			}
			triangle {
				<-142.685184, 7.870000, 144.665345>,
				<-145.225189, 10.920001, 147.705322>,
				< -123.385200, 18.290001, 165.745335>
			}
			triangle {
				<-123.385200, 18.290001, 165.745335>,
				<-122.875189, 17.270002, 162.185337>,
				< -142.685184, 7.870000, 144.665345>
			}
			triangle {
				<-156.155186, 4.570000, 137.545318>,
				<-145.225189, 10.920001, 147.705322>,
				< -142.685184, 7.870000, 144.665345>
			}
			triangle {
				<-156.155186, 4.570000, 137.545318>,
				<-160.975199, 4.830000, 139.585336>,
				< -149.035189, 8.380001, 150.505308>
			}
			triangle {
				<-149.035189, 8.380001, 150.505308>,
				<-145.225189, 10.920001, 147.705322>,
				< -156.155186, 4.570000, 137.545318>
			}
			triangle {
				<-160.975199, 4.830000, 139.585336>,
				<-162.755191, 3.810000, 144.665345>,
				< -155.385193, 7.370000, 151.515321>
			}
			triangle {
				<-155.385193, 7.370000, 151.515321>,
				<-149.035189, 8.380001, 150.505308>,
				< -160.975199, 4.830000, 139.585336>
			}
			triangle {
				<-156.155186, 4.570000, 137.545318>,
				<-158.435180, 0.000000, 135.265325>,
				< -162.755191, 0.000000, 138.815342>
			}
			triangle {
				<-162.755191, 0.000000, 138.815342>,
				<-160.975199, 4.830000, 139.585336>,
				< -156.155186, 4.570000, 137.545318>
			}
			triangle {
				<-163.265202, 0.000000, 144.915345>,
				<-162.755191, 3.810000, 144.665345>,
				< -160.975199, 4.830000, 139.585336>
			}
			triangle {
				<-160.975199, 4.830000, 139.585336>,
				<-162.755191, 0.000000, 138.815342>,
				< -163.265202, 0.000000, 144.915345>
			}
			triangle {
				<-96.715182, 30.730001, 217.305336>,
				<-103.315187, 27.430002, 223.145329>,
				< -94.175192, 30.990000, 223.145329>
			}
			triangle {
				<-94.175192, 30.990000, 223.145329>,
				<-83.255191, 35.810002, 218.825318>,
				< -90.615193, 34.540004, 215.525330>
			}
			triangle {
				<-97.735184, 34.540004, 201.045330>,
				<-76.905187, 38.610003, 204.855329>,
				< -74.875186, 34.800000, 193.175330>
			}
			triangle {
				<-119.575187, 20.830001, 206.125339>,
				<-116.525192, 26.420001, 202.065338>,
				< -135.575183, 13.970000, 184.285350>
			}
			triangle {
				<-94.175192, 30.990000, 223.145329>,
				<-90.615193, 34.540004, 215.525330>,
				< -96.715182, 30.730001, 217.305336>
			}
			triangle {
				<23.934815, 79.249999, 156.095343>,
				<3.864815, 78.230005, 157.105356>,
				< 3.364815, 80.010004, 159.905343>
			}
			triangle {
				<3.364815, 80.010004, 159.905343>,
				<23.684816, 80.770002, 157.365324>,
				< 23.934815, 79.249999, 156.095343>
			}
			triangle {
				<-7.815186, 73.660008, 164.215344>,
				<3.364815, 80.010004, 159.905343>,
				< 3.864815, 78.230005, 157.105356>
			}
			triangle {
				<3.864815, 78.230005, 157.105356>,
				<-8.575188, 71.370004, 161.425324>,
				< -7.815186, 73.660008, 164.215344>
			}
			triangle {
				<23.934815, 79.249999, 156.095343>,
				<23.684816, 80.770002, 157.365324>,
				< 37.904818, 77.220006, 160.155344>
			}
			triangle {
				<-8.575188, 71.370004, 161.425324>,
				<14.284814, 64.519998, 175.395327>,
				< 2.854813, 41.150004, 194.955322>
			}
			triangle {
				<2.854813, 41.150004, 194.955322>,
				<-34.235183, 35.050001, 179.455328>,
				< -8.575188, 71.370004, 161.425324>
			}
			triangle {
				<3.864815, 78.230005, 157.105356>,
				<23.934815, 79.249999, 156.095343>,
				< 37.904818, 77.220006, 160.155344>
			}
			triangle {
				<37.904818, 77.220006, 160.155344>,
				<-8.575188, 71.370004, 161.425324>,
				< 3.864815, 78.230005, 157.105356>
			}
			triangle {
				<-8.575188, 71.370004, 161.425324>,
				<37.904818, 77.220006, 160.155344>,
				< 14.284814, 64.519998, 175.395327>
			}
			triangle {
				<117.914815, 6.100000, 339.225364>,
				<142.044814, 0.000000, 328.045352>,
				< 142.554811, 9.910000, 310.015320>
			}
			triangle {
				<142.554811, 9.910000, 310.015320>,
				<102.924818, 11.680000, 317.885334>,
				< 117.914815, 6.100000, 339.225364>
			}
			triangle {
				<151.444834, 0.000000, 348.875313>,
				<142.044814, 0.000000, 328.045352>,
				< 117.914815, 6.100000, 339.225364>
			}
			triangle {
				<117.914815, 6.100000, 339.225364>,
				<128.584808, 3.560000, 350.905349>,
				< 151.444834, 0.000000, 348.875313>
			}
			triangle {
				<160.074818, 0.000000, 368.685366>,
				<163.124819, 0.000000, 360.565308>,
				< 151.444834, 0.000000, 348.875313>
			}
			triangle {
				<151.444834, 0.000000, 348.875313>,
				<143.824821, 1.270000, 369.195320>,
				< 160.074818, 0.000000, 368.685366>
			}
			triangle {
				<143.824821, 1.270000, 369.195320>,
				<151.444834, 0.000000, 348.875313>,
				< 128.584808, 3.560000, 350.905349>
			}
			triangle {
				<90.224817, 38.099999, 204.355327>,
				<138.484816, 30.990000, 201.815337>,
				< 136.204822, 0.000000, 190.885326>
			}
			triangle {
				<136.204822, 0.000000, 190.885326>,
				<92.004816, 0.000000, 192.665347>,
				< 90.224817, 38.099999, 204.355327>
			}
			triangle {
				<90.224817, 38.099999, 204.355327>,
				<92.004816, 0.000000, 192.665347>,
				< 48.824816, 0.000000, 189.115329>
			}
			triangle {
				<48.824816, 0.000000, 189.115329>,
				<52.384818, 37.590002, 202.315339>,
				< 90.224817, 38.099999, 204.355327>
			}
			triangle {
				<242.624827, 7.110000, 159.905343>,
				<239.074823, 0.000000, 157.365324>,
				< 218.754831, 0.000000, 167.525342>
			}
			triangle {
				<218.754831, 0.000000, 167.525342>,
				<221.804818, 9.650000, 168.285340>,
				< 242.624827, 7.110000, 159.905343>
			}
			triangle {
				<218.754831, 0.000000, 167.525342>,
				<191.574822, 0.000000, 184.035349>,
				< 188.274820, 17.270002, 188.345336>
			}
			triangle {
				<188.274820, 17.270002, 188.345336>,
				<221.804818, 9.650000, 168.285340>,
				< 218.754831, 0.000000, 167.525342>
			}
			triangle {
				<263.454845, 0.000000, 140.855345>,
				<263.714813, 5.590000, 142.885324>,
				< 273.104794, 11.940000, 134.755342>
			}
			triangle {
				<273.104794, 11.940000, 134.755342>,
				<273.364819, 0.000000, 132.215337>,
				< 263.454845, 0.000000, 140.855345>
			}
			triangle {
				<283.524808, 73.150003, 109.605320>,
				<278.444828, 52.320003, 124.595338>,
				< 281.494830, 52.320003, 127.645326>
			}
			triangle {
				<281.494830, 52.320003, 127.645326>,
				<285.304829, 73.150003, 111.385319>,
				< 283.524808, 73.150003, 109.605320>
			}
			triangle {
				<286.314842, 24.129999, 142.885324>,
				<281.494830, 52.320003, 127.645326>,
				< 278.444828, 52.320003, 124.595338>
			}
			triangle {
				<278.444828, 52.320003, 124.595338>,
				<273.104794, 11.940000, 134.755342>,
				< 286.314842, 24.129999, 142.885324>
			}
			triangle {
				<283.524808, 73.150003, 109.605320>,
				<285.304829, 73.150003, 111.385319>,
				< 300.034816, 86.610002, 84.715337>
			}
			triangle {
				<296.474803, 0.000000, 137.805329>,
				<295.964820, 0.000000, 125.105321>,
				< 292.414817, 7.370000, 141.615329>
			}
			triangle {
				<298.254823, 0.000000, 115.195318>,
				<273.364819, 0.000000, 132.215337>,
				< 273.104794, 11.940000, 134.755342>
			}
			triangle {
				<300.284831, 21.590000, 101.225344>,
				<302.064823, 5.840000, 108.085331>,
				< 298.254823, 0.000000, 115.195318>
			}
			triangle {
				<298.254823, 0.000000, 115.195318>,
				<278.444828, 52.320003, 124.595338>,
				< 300.284831, 21.590000, 101.225344>
			}
			triangle {
				<278.444828, 52.320003, 124.595338>,
				<298.254823, 0.000000, 115.195318>,
				< 273.104794, 11.940000, 134.755342>
			}
			triangle {
				<298.764835, 63.250003, 93.355315>,
				<300.284831, 21.590000, 101.225344>,
				< 278.444828, 52.320003, 124.595338>
			}
			triangle {
				<278.444828, 52.320003, 124.595338>,
				<283.524808, 73.150003, 109.605320>,
				< 298.764835, 63.250003, 93.355315>
			}
			triangle {
				<300.034816, 86.610002, 84.715337>,
				<298.764835, 63.250003, 93.355315>,
				< 283.524808, 73.150003, 109.605320>
			}
			triangle {
				<298.764835, 63.250003, 93.355315>,
				<285.304829, 73.150003, 111.385319>,
				< 281.494830, 52.320003, 127.645326>
			}
			triangle {
				<281.494830, 52.320003, 127.645326>,
				<300.284831, 21.590000, 101.225344>,
				< 298.764835, 63.250003, 93.355315>
			}
			triangle {
				<302.064823, 5.840000, 108.085331>,
				<300.284831, 21.590000, 101.225344>,
				< 281.494830, 52.320003, 127.645326>
			}
			triangle {
				<281.494830, 52.320003, 127.645326>,
				<297.494826, 9.650000, 116.975347>,
				< 302.064823, 5.840000, 108.085331>
			}
			triangle {
				<291.904834, 16.510000, 131.195314>,
				<297.494826, 9.650000, 116.975347>,
				< 281.494830, 52.320003, 127.645326>
			}
			triangle {
				<286.314842, 24.129999, 142.885324>,
				<291.904834, 16.510000, 131.195314>,
				< 281.494830, 52.320003, 127.645326>
			}
			triangle {
				<292.414817, 7.370000, 141.615329>,
				<291.904834, 16.510000, 131.195314>,
				< 286.314842, 24.129999, 142.885324>
			}
			triangle {
				<286.314842, 24.129999, 142.885324>,
				<288.094834, 18.290001, 145.425328>,
				< 292.414817, 7.370000, 141.615329>
			}
			triangle {
				<-88.585193, 5.330000, 251.345331>,
				<-87.065190, 0.000000, 254.135337>,
				< -83.765188, 0.000000, 256.165344>
			}
			triangle {
				<-88.585193, 5.330000, 251.345331>,
				<-113.225190, 13.970000, 230.515327>,
				< -109.415197, 0.000000, 236.865331>
			}
			triangle {
				<-109.415197, 0.000000, 236.865331>,
				<-87.065190, 0.000000, 254.135337>,
				< -88.585193, 5.330000, 251.345331>
			}
			triangle {
				<-88.585193, 5.330000, 251.345331>,
				<-87.575180, 13.970000, 249.305343>,
				< -113.225190, 13.970000, 230.515327>
			}
			triangle {
				<-97.735184, 34.540004, 201.045330>,
				<-106.625185, 25.910001, 185.805332>,
				< -113.225190, 25.910001, 196.735328>
			}
			triangle {
				<-113.225190, -25.910001, 196.735328>,
				<-106.625185, -25.910001, 185.805332>,
				< -97.735184, -34.540004, 201.045330>
			}
            rotate -90*x
            rotate 90*y
            translate -175*y
            scale dolph_scale
		}
        object {
            eye
            translate <eyex, eyey, eyez>
        }
        object {
            eye
            translate <-eyex, eyey, eyez>
        }
    }
#declare Dolph02 =
    union {
		union {
			triangle {
				<-162.946834, 0.000000, 39.481570>,
				<-201.546817, 0.000000, 4.681549>,
				< -196.216836, -8.130001, 3.921570>
			}
			triangle {
				<-196.216836, -8.130001, 3.921570>,
				<-155.326821, -6.100000, 38.211549>,
				< -162.946834, 0.000000, 39.481570>
			}
			triangle {
				<-129.926819, 0.000000, 55.481508>,
				<-162.946834, 0.000000, 39.481570>,
				< -155.326821, -6.100000, 38.211549>
			}
			triangle {
				<-155.326821, -6.100000, 38.211549>,
				<-126.616822, -3.560000, 52.441592>,
				< -129.926819, 0.000000, 55.481508>
			}
			triangle {
				<-98.426822, 0.000000, 57.771548>,
				<-129.926819, 0.000000, 55.481508>,
				< -126.616822, -3.560000, 52.441592>
			}
			triangle {
				<-126.616822, -3.560000, 52.441592>,
				<-96.646822, -1.270000, 53.451540>,
				< -98.426822, 0.000000, 57.771548>
			}
			triangle {
				<-80.396826, 0.000000, 52.941590>,
				<-98.426822, 0.000000, 57.771548>,
				< -96.646822, -1.270000, 53.451540>
			}
			triangle {
				<-87.756821, 0.000000, -12.588440>,
				<-98.426822, 0.000000, 12.301575>,
				< -97.916825, -9.910000, -5.728455>
			}
			triangle {
				<-155.326821, -6.100000, 38.211549>,
				<-196.216836, -8.130001, 3.921570>,
				< -137.546818, -11.680000, 2.141541>
			}
			triangle {
				<-137.546818, -11.680000, 2.141541>,
				<-122.556821, -6.100000, 23.481568>,
				< -155.326821, -6.100000, 38.211549>
			}
			triangle {
				<-126.616822, -3.560000, 52.441592>,
				<-155.326821, -6.100000, 38.211549>,
				< -122.556821, -6.100000, 23.481568>
			}
			triangle {
				<-122.556821, -6.100000, 23.481568>,
				<-111.886813, -3.560000, 35.161562>,
				< -126.616822, -3.560000, 52.441592>
			}
			triangle {
				<-96.646822, -1.270000, 53.451540>,
				<-126.616822, -3.560000, 52.441592>,
				< -111.886813, -3.560000, 35.161562>
			}
			triangle {
				<-379.431292, 0.000000, -82.488320>,
				<-374.053238, -7.620000, -79.112083>,
				< -368.089853, 0.000000, -71.710476>
			}
			triangle {
				<-349.315833, 0.000000, -57.466204>,
				<-368.089853, 0.000000, -71.710476>,
				< -374.053238, -7.620000, -79.112083>
			}
			triangle {
				<-374.053238, -7.620000, -79.112083>,
				<-353.638555, -13.970000, -63.478895>,
				< -349.315833, 0.000000, -57.466204>
			}
			triangle {
				<-286.276678, 0.000000, -19.636413>,
				<-322.155700, 0.000000, -40.356493>,
				< -327.358308, -5.330000, -44.760820>
			}
			triangle {
				<-327.358308, -5.330000, -44.760820>,
				<-287.797482, -18.290001, -25.621064>,
				< -286.276678, 0.000000, -19.636413>
			}
			triangle {
				<-287.797482, -18.290001, -25.621064>,
				<-327.358308, -5.330000, -44.760820>,
				< -326.520712, -13.970000, -46.877472>
			}
			triangle {
				<-242.049044, 0.000000, -2.660553>,
				<-286.276678, 0.000000, -19.636413>,
				< -287.797482, -18.290001, -25.621064>
			}
			triangle {
				<-287.797482, -18.290001, -25.621064>,
				<-243.248610, -22.350002, -7.919250>,
				< -242.049044, 0.000000, -2.660553>
			}
			triangle {
				<-201.546817, 0.000000, 4.681549>,
				<-242.049044, 0.000000, -2.660553>,
				< -243.248610, -22.350002, -7.919250>
			}
			triangle {
				<-243.248610, -22.350002, -7.919250>,
				<-196.216836, -8.130001, 3.921570>,
				< -201.546817, 0.000000, 4.681549>
			}
			triangle {
				<-199.266823, -24.640000, -11.058442>,
				<-196.216836, -8.130001, 3.921570>,
				< -243.248610, -22.350002, -7.919250>
			}
			triangle {
				<-137.546818, -11.680000, 2.141541>,
				<-196.216836, -8.130001, 3.921570>,
				< -199.266823, -24.640000, -11.058442>
			}
			triangle {
				<-199.266823, -24.640000, -11.058442>,
				<-141.096822, -26.670000, -12.588440>,
				< -137.546818, -11.680000, 2.141541>
			}
			triangle {
				<-97.916825, -9.910000, -5.728455>,
				<-137.546818, -11.680000, 2.141541>,
				< -141.096822, -26.670000, -12.588440>
			}
			triangle {
				<-141.096822, -26.670000, -12.588440>,
				<-84.966830, -20.320000, -24.528442>,
				< -97.916825, -9.910000, -5.728455>
			}
			triangle {
				<-87.756821, 0.000000, -12.588440>,
				<-97.916825, -9.910000, -5.728455>,
				< -84.966830, -20.320000, -24.528442>
			}
			triangle {
				<-87.756821, 0.000000, -12.588440>,
				<-84.966830, -20.320000, -24.528442>,
				< -30.095995, -11.680000, -36.432679>
			}
			triangle {
				<-30.095995, -11.680000, -36.432679>,
				<-30.384340, 0.000000, -32.191470>,
				< -87.756821, 0.000000, -12.588440>
			}
			triangle {
				<10.643921, 0.000000, -45.060747>,
				<-30.384340, 0.000000, -32.191470>,
				< -30.095995, -11.680000, -36.432679>
			}
			triangle {
				<-30.095995, -11.680000, -36.432679>,
				<9.985199, -14.730000, -56.791384>,
				< 10.643921, 0.000000, -45.060747>
			}
			triangle {
				<35.265642, 0.000000, -53.671952>,
				<10.643921, 0.000000, -45.060747>,
				< 9.985199, -14.730000, -56.791384>
			}
			triangle {
				<9.985199, -14.730000, -56.791384>,
				<36.177828, -11.940000, -69.452896>,
				< 35.265642, 0.000000, -53.671952>
			}
			triangle {
				<58.749894, 0.000000, -62.920227>,
				<35.265642, 0.000000, -53.671952>,
				< 36.177828, -11.940000, -69.452896>
			}
			triangle {
				<36.177828, -11.940000, -69.452896>,
				<60.586217, -7.870000, -77.568742>,
				< 58.749894, 0.000000, -62.920227>
			}
			triangle {
				<77.364933, 0.000000, -71.815673>,
				<58.749894, 0.000000, -62.920227>,
				< 60.586217, -7.870000, -77.568742>
			}
			triangle {
				<60.586217, -7.870000, -77.568742>,
				<79.414916, -9.650000, -80.839610>,
				< 77.364933, 0.000000, -71.815673>
			}
			triangle {
				<89.816332, 0.000000, -86.501415>,
				<77.364933, 0.000000, -71.815673>,
				< 79.414916, -9.650000, -80.839610>
			}
			triangle {
				<79.414916, -9.650000, -80.839610>,
				<83.908982, -7.370000, -87.441562>,
				< 89.816332, 0.000000, -86.501415>
			}
			triangle {
				<-326.520712, -13.970000, -46.877472>,
				<-353.638555, -13.970000, -63.478895>,
				< -329.577839, -22.350002, -52.995303>
			}
			triangle {
				<-326.520712, -13.970000, -46.877472>,
				<-329.577839, -22.350002, -52.995303>,
				< -313.478812, -32.770000, -55.607424>
			}
			triangle {
				<-326.520712, -13.970000, -46.877472>,
				<-313.478812, -32.770000, -55.607424>,
				< -282.626115, -29.970001, -40.068880>
			}
			triangle {
				<-282.626115, -29.970001, -40.068880>,
				<-287.797482, -18.290001, -25.621064>,
				< -326.520712, -13.970000, -46.877472>
			}
			triangle {
				<-243.248610, -22.350002, -7.919250>,
				<-287.797482, -18.290001, -25.621064>,
				< -282.626115, -29.970001, -40.068880>
			}
			triangle {
				<-282.626115, -29.970001, -40.068880>,
				<-244.296326, -31.999999, -26.686982>,
				< -243.248610, -22.350002, -7.919250>
			}
			triangle {
				<-199.266823, -24.640000, -11.058442>,
				<-243.248610, -22.350002, -7.919250>,
				< -244.296326, -31.999999, -26.686982>
			}
			triangle {
				<-244.296326, -31.999999, -26.686982>,
				<-199.266823, -35.810002, -28.838442>,
				< -199.266823, -24.640000, -11.058442>
			}
			triangle {
				<-141.096822, -26.670000, -12.588440>,
				<-199.266823, -24.640000, -11.058442>,
				< -199.266823, -35.810002, -28.838442>
			}
			triangle {
				<-199.266823, -35.810002, -28.838442>,
				<-148.716835, -34.040002, -30.108460>,
				< -141.096822, -26.670000, -12.588440>
			}
			triangle {
				<-84.966830, -20.320000, -24.528442>,
				<-141.096822, -26.670000, -12.588440>,
				< -148.716835, -34.040002, -30.108460>
			}
			triangle {
				<-148.716835, -34.040002, -30.108460>,
				<-88.266818, -28.450001, -37.988466>,
				< -84.966830, -20.320000, -24.528442>
			}
			triangle {
				<-30.095995, -11.680000, -36.432679>,
				<-84.966830, -20.320000, -24.528442>,
				< -88.266818, -28.450001, -37.988466>
			}
			triangle {
				<-88.266818, -28.450001, -37.988466>,
				<-30.437530, -18.290001, -44.028580>,
				< -30.095995, -11.680000, -36.432679>
			}
			triangle {
				<9.985199, -14.730000, -56.791384>,
				<-30.095995, -11.680000, -36.432679>,
				< -30.437530, -18.290001, -44.028580>
			}
			triangle {
				<-336.190305, -31.750002, -65.189648>,
				<-326.191051, -36.580003, -67.545747>,
				< -313.478812, -32.770000, -55.607424>
			}
			triangle {
				<-313.478812, -32.770000, -55.607424>,
				<-329.577839, -22.350002, -52.995303>,
				< -336.190305, -31.750002, -65.189648>
			}
			triangle {
				<-344.372875, -27.430002, -71.644214>,
				<-336.190305, -31.750002, -65.189648>,
				< -329.577839, -22.350002, -52.995303>
			}
			triangle {
				<-329.577839, -22.350002, -52.995303>,
				<-353.638555, -13.970000, -63.478895>,
				< -344.372875, -27.430002, -71.644214>
			}
			triangle {
				<-361.986417, -20.830001, -87.259279>,
				<-344.372875, -27.430002, -71.644214>,
				< -353.638555, -13.970000, -63.478895>
			}
			triangle {
				<-353.638555, -13.970000, -63.478895>,
				<-374.053238, -7.620000, -79.112083>,
				< -361.986417, -20.830001, -87.259279>
			}
			triangle {
				<-377.335139, -10.160000, -100.252918>,
				<-361.986417, -20.830001, -87.259279>,
				< -374.053238, -7.620000, -79.112083>
			}
			triangle {
				<-335.264294, -30.990000, -72.401083>,
				<-324.739508, -35.810002, -77.610513>,
				< -326.191051, -36.580003, -67.545747>
			}
			triangle {
				<-326.191051, -36.580003, -67.545747>,
				<-336.190305, -31.750002, -65.189648>,
				< -335.264294, -30.990000, -72.401083>
			}
			triangle {
				<-344.372875, -27.430002, -71.644214>,
				<-335.264294, -30.990000, -72.401083>,
				< -336.190305, -31.750002, -65.189648>
			}
			triangle {
				<-377.335139, -10.160000, -100.252918>,
				<-379.740010, -13.970000, -107.699346>,
				< -361.986417, -20.830001, -87.259279>
			}
			triangle {
				<-407.068493, -7.370000, -136.013582>,
				<-402.195662, -7.370000, -138.716369>,
				< -373.702720, -14.990000, -117.884288>
			}
			triangle {
				<-373.702720, -14.990000, -117.884288>,
				<-379.740010, -13.970000, -107.699346>,
				< -407.068493, -7.370000, -136.013582>
			}
			triangle {
				<-387.189900, 0.000000, -108.354702>,
				<-413.337221, 0.000000, -137.790588>,
				< -412.197426, -4.060000, -139.410524>
			}
			triangle {
				<-412.197426, -4.060000, -139.410524>,
				<-384.209823, -5.080000, -106.304416>,
				< -387.189900, 0.000000, -108.354702>
			}
			triangle {
				<-384.209823, -5.080000, -106.304416>,
				<-377.335139, -10.160000, -100.252918>,
				< -374.053238, -7.620000, -79.112083>
			}
			triangle {
				<-374.053238, -7.620000, -79.112083>,
				<-379.431292, 0.000000, -82.488320>,
				< -384.209823, -5.080000, -106.304416>
			}
			triangle {
				<-387.189900, 0.000000, -108.354702>,
				<-384.209823, -5.080000, -106.304416>,
				< -379.431292, 0.000000, -82.488320>
			}
			triangle {
				<-338.279160, -30.730001, -78.010683>,
				<-344.372875, -27.430002, -71.644214>,
				< -346.275581, -30.480000, -85.243356>
			}
			triangle {
				<-346.275581, -30.480000, -85.243356>,
				<-345.490919, -30.730001, -88.118228>,
				< -338.279160, -30.730001, -78.010683>
			}
			triangle {
				<-344.372875, -27.430002, -71.644214>,
				<-361.986417, -20.830001, -87.259279>,
				< -359.283125, -26.420001, -91.557900>
			}
			triangle {
				<-359.283125, -26.420001, -91.557900>,
				<-346.275581, -30.480000, -85.243356>,
				< -344.372875, -27.430002, -71.644214>
			}
			triangle {
				<-345.490919, -30.730001, -88.118228>,
				<-346.275581, -30.480000, -85.243356>,
				< -359.283125, -26.420001, -91.557900>
			}
			triangle {
				<-359.283125, -26.420001, -91.557900>,
				<-356.435830, -25.910001, -97.142879>,
				< -345.490919, -30.730001, -88.118228>
			}
			triangle {
				<-356.435830, -25.910001, -97.142879>,
				<-359.283125, -26.420001, -91.557900>,
				< -379.740010, -13.970000, -107.699346>
			}
			triangle {
				<-379.740010, -13.970000, -107.699346>,
				<-373.702720, -14.990000, -117.884288>,
				< -356.435830, -25.910001, -97.142879>
			}
			triangle {
				<-370.221257, -16.260001, -121.996703>,
				<-373.702720, -14.990000, -117.884288>,
				< -402.195662, -7.370000, -138.716369>
			}
			triangle {
				<-402.195662, -7.370000, -138.716369>,
				<-395.951021, -8.380001, -140.248754>,
				< -370.221257, -16.260001, -121.996703>
			}
			triangle {
				<-356.435830, -25.910001, -97.142879>,
				<-373.702720, -14.990000, -117.884288>,
				< -370.221257, -16.260001, -121.996703>
			}
			triangle {
				<-370.221257, -16.260001, -121.996703>,
				<-350.763567, -25.910001, -108.581871>,
				< -356.435830, -25.910001, -97.142879>
			}
			triangle {
				<-340.642117, -34.540004, -94.130386>,
				<-345.490919, -30.730001, -88.118228>,
				< -356.435830, -25.910001, -97.142879>
			}
			triangle {
				<-318.512348, -34.800000, -103.866341>,
				<-340.642117, -34.540004, -94.130386>,
				< -350.763567, -25.910001, -108.581871>
			}
			triangle {
				<-350.763567, -25.910001, -108.581871>,
				<-348.694415, -27.430002, -114.353028>,
				< -318.512348, -34.800000, -103.866341>
			}
			triangle {
				<-379.740010, -13.970000, -107.699346>,
				<-377.335139, -10.160000, -100.252918>,
				< -384.209823, -5.080000, -106.304416>
			}
			triangle {
				<-338.279160, -30.730001, -78.010683>,
				<-345.490919, -30.730001, -88.118228>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-332.347536, -34.540004, -80.289696>,
				<-338.279160, -30.730001, -78.010683>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-324.739508, -35.810002, -77.610513>,
				<-332.347536, -34.540004, -80.289696>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-319.568141, -38.610003, -92.058370>,
				<-324.739508, -35.810002, -77.610513>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-340.642117, -34.540004, -94.130386>,
				<-319.568141, -38.610003, -92.058370>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-345.490919, -30.730001, -88.118228>,
				<-340.642117, -34.540004, -94.130386>,
				< -335.137397, -34.800000, -89.229393>
			}
			triangle {
				<-395.951021, -8.380001, -140.248754>,
				<-392.385988, -10.920001, -143.354618>,
				< -369.127184, -18.290001, -127.185104>
			}
			triangle {
				<-369.127184, -18.290001, -127.185104>,
				<-370.221257, -16.260001, -121.996703>,
				< -395.951021, -8.380001, -140.248754>
			}
			triangle {
				<-370.221257, -16.260001, -121.996703>,
				<-369.127184, -18.290001, -127.185104>,
				< -348.694415, -27.430002, -114.353028>
			}
			triangle {
				<-348.694415, -27.430002, -114.353028>,
				<-350.763567, -25.910001, -108.581871>,
				< -370.221257, -16.260001, -121.996703>
			}
			triangle {
				<-330.822030, -31.750002, -107.940989>,
				<-348.694415, -27.430002, -114.353028>,
				< -346.426190, -17.020001, -136.205932>
			}
			triangle {
				<-346.426190, -17.020001, -136.205932>,
				<-318.512348, -34.800000, -103.866341>,
				< -330.822030, -31.750002, -107.940989>
			}
			triangle {
				<-318.512348, -34.800000, -103.866341>,
				<-346.426190, -17.020001, -136.205932>,
				< -310.210728, -22.350002, -129.792826>
			}
			triangle {
				<-363.959740, -10.160000, -135.521643>,
				<-346.426190, -17.020001, -136.205932>,
				< -348.694415, -27.430002, -114.353028>
			}
			triangle {
				<-348.694415, -27.430002, -114.353028>,
				<-368.913718, -17.270002, -130.775117>,
				< -363.959740, -10.160000, -135.521643>
			}
			triangle {
				<-280.091317, -43.180001, -110.882014>,
				<-318.512348, -34.800000, -103.866341>,
				< -310.210728, -22.350002, -129.792826>
			}
			triangle {
				<-310.210728, -22.350002, -129.792826>,
				<-279.148027, -35.050001, -120.904563>,
				< -280.091317, -43.180001, -110.882014>
			}
			triangle {
				<-315.178523, -40.389999, -91.399581>,
				<-318.512348, -34.800000, -103.866341>,
				< -280.091317, -43.180001, -110.882014>
			}
			triangle {
				<-280.091317, -43.180001, -110.882014>,
				<-274.558471, -49.280000, -81.007563>,
				< -315.178523, -40.389999, -91.399581>
			}
			triangle {
				<-315.178523, -40.389999, -91.399581>,
				<-319.568141, -38.610003, -92.058370>,
				< -318.512348, -34.800000, -103.866341>
			}
			triangle {
				<-324.739508, -35.810002, -77.610513>,
				<-319.568141, -38.610003, -92.058370>,
				< -315.178523, -40.389999, -91.399581>
			}
			triangle {
				<-315.178523, -40.389999, -91.399581>,
				<-308.643625, -40.130003, -74.101320>,
				< -324.739508, -35.810002, -77.610513>
			}
			triangle {
				<-313.478812, -32.770000, -55.607424>,
				<-326.191051, -36.580003, -67.545747>,
				< -324.739508, -35.810002, -77.610513>
			}
			triangle {
				<-324.739508, -35.810002, -77.610513>,
				<-306.554799, -36.580003, -61.280242>,
				< -313.478812, -32.770000, -55.607424>
			}
			triangle {
				<-306.554799, -36.580003, -61.280242>,
				<-324.739508, -35.810002, -77.610513>,
				< -308.643625, -40.130003, -74.101320>
			}
			triangle {
				<-275.891193, -42.670000, -57.195419>,
				<-308.643625, -40.130003, -74.101320>,
				< -315.178523, -40.389999, -91.399581>
			}
			triangle {
				<-315.178523, -40.389999, -91.399581>,
				<-274.558471, -49.280000, -81.007563>,
				< -275.891193, -42.670000, -57.195419>
			}
			triangle {
				<-243.700293, -46.230002, -50.187030>,
				<-275.891193, -42.670000, -57.195419>,
				< -274.558471, -49.280000, -81.007563>
			}
			triangle {
				<-274.558471, -49.280000, -81.007563>,
				<-233.883913, -51.050000, -76.239374>,
				< -243.700293, -46.230002, -50.187030>
			}
			triangle {
				<-194.696840, -48.010002, -60.588438>,
				<-243.700293, -46.230002, -50.187030>,
				< -233.883913, -51.050000, -76.239374>
			}
			triangle {
				<-233.883913, -51.050000, -76.239374>,
				<-189.616831, -51.050000, -79.388428>,
				< -194.696840, -48.010002, -60.588438>
			}
			triangle {
				<-146.686813, -46.230002, -55.508455>,
				<-194.696840, -48.010002, -60.588438>,
				< -189.616831, -51.050000, -79.388428>
			}
			triangle {
				<-189.616831, -51.050000, -79.388428>,
				<-144.656820, -49.020000, -79.138427>,
				< -146.686813, -46.230002, -55.508455>
			}
			triangle {
				<-90.806830, -43.939999, -61.608461>,
				<-146.686813, -46.230002, -55.508455>,
				< -144.656820, -49.020000, -79.138427>
			}
			triangle {
				<-144.656820, -49.020000, -79.138427>,
				<-91.316820, -44.700004, -88.528444>,
				< -90.806830, -43.939999, -61.608461>
			}
			triangle {
				<-31.980423, -33.020001, -65.284864>,
				<-90.806830, -43.939999, -61.608461>,
				< -91.316820, -44.700004, -88.528444>
			}
			triangle {
				<-91.316820, -44.700004, -88.528444>,
				<-33.275987, -28.450001, -89.791985>,
				< -31.980423, -33.020001, -65.284864>
			}
			triangle {
				<6.479782, -23.370001, -72.074616>,
				<-31.980423, -33.020001, -65.284864>,
				< -33.275987, -28.450001, -89.791985>
			}
			triangle {
				<-33.275987, -28.450001, -89.791985>,
				<4.376526, -21.840001, -96.617226>,
				< 6.479782, -23.370001, -72.074616>
			}
			triangle {
				<33.767840, -13.970000, -81.742428>,
				<6.479782, -23.370001, -72.074616>,
				< 4.376526, -21.840001, -96.617226>
			}
			triangle {
				<4.376526, -21.840001, -96.617226>,
				<32.061569, -14.220000, -96.929067>,
				< 33.767840, -13.970000, -81.742428>
			}
			triangle {
				<53.767442, -9.910000, -86.342159>,
				<33.767840, -13.970000, -81.742428>,
				< 32.061569, -14.220000, -96.929067>
			}
			triangle {
				<32.061569, -14.220000, -96.929067>,
				<50.242816, -10.670001, -98.698003>,
				< 53.767442, -9.910000, -86.342159>
			}
			triangle {
				<-306.554799, -36.580003, -61.280242>,
				<-308.643625, -40.130003, -74.101320>,
				< -275.891193, -42.670000, -57.195419>
			}
			triangle {
				<-282.626115, -29.970001, -40.068880>,
				<-306.554799, -36.580003, -61.280242>,
				< -275.891193, -42.670000, -57.195419>
			}
			triangle {
				<-313.478812, -32.770000, -55.607424>,
				<-306.554799, -36.580003, -61.280242>,
				< -282.626115, -29.970001, -40.068880>
			}
			triangle {
				<-244.296326, -31.999999, -26.686982>,
				<-282.626115, -29.970001, -40.068880>,
				< -275.891193, -42.670000, -57.195419>
			}
			triangle {
				<-275.891193, -42.670000, -57.195419>,
				<-243.700293, -46.230002, -50.187030>,
				< -244.296326, -31.999999, -26.686982>
			}
			triangle {
				<-199.266823, -35.810002, -28.838442>,
				<-244.296326, -31.999999, -26.686982>,
				< -243.700293, -46.230002, -50.187030>
			}
			triangle {
				<-243.700293, -46.230002, -50.187030>,
				<-194.696840, -48.010002, -60.588438>,
				< -199.266823, -35.810002, -28.838442>
			}
			triangle {
				<-148.716835, -34.040002, -30.108460>,
				<-199.266823, -35.810002, -28.838442>,
				< -194.696840, -48.010002, -60.588438>
			}
			triangle {
				<-194.696840, -48.010002, -60.588438>,
				<-146.686813, -46.230002, -55.508455>,
				< -148.716835, -34.040002, -30.108460>
			}
			triangle {
				<-88.266818, -28.450001, -37.988466>,
				<-148.716835, -34.040002, -30.108460>,
				< -146.686813, -46.230002, -55.508455>
			}
			triangle {
				<-146.686813, -46.230002, -55.508455>,
				<-90.806830, -43.939999, -61.608461>,
				< -88.266818, -28.450001, -37.988466>
			}
			triangle {
				<-30.437530, -18.290001, -44.028580>,
				<-88.266818, -28.450001, -37.988466>,
				< -90.806830, -43.939999, -61.608461>
			}
			triangle {
				<-90.806830, -43.939999, -61.608461>,
				<-31.980423, -33.020001, -65.284864>,
				< -30.437530, -18.290001, -44.028580>
			}
			triangle {
				<9.985199, -14.730000, -56.791384>,
				<-30.437530, -18.290001, -44.028580>,
				< -31.980423, -33.020001, -65.284864>
			}
			triangle {
				<-31.980423, -33.020001, -65.284864>,
				<6.479782, -23.370001, -72.074616>,
				< 9.985199, -14.730000, -56.791384>
			}
			triangle {
				<36.177828, -11.940000, -69.452896>,
				<9.985199, -14.730000, -56.791384>,
				< 6.479782, -23.370001, -72.074616>
			}
			triangle {
				<6.479782, -23.370001, -72.074616>,
				<33.767840, -13.970000, -81.742428>,
				< 36.177828, -11.940000, -69.452896>
			}
			triangle {
				<60.586217, -7.870000, -77.568742>,
				<36.177828, -11.940000, -69.452896>,
				< 33.767840, -13.970000, -81.742428>
			}
			triangle {
				<33.767840, -13.970000, -81.742428>,
				<53.767442, -9.910000, -86.342159>,
				< 60.586217, -7.870000, -77.568742>
			}
			triangle {
				<79.414916, -9.650000, -80.839610>,
				<60.586217, -7.870000, -77.568742>,
				< 53.767442, -9.910000, -86.342159>
			}
			triangle {
				<53.767442, -9.910000, -86.342159>,
				<77.822984, -18.290001, -88.424098>,
				< 79.414916, -9.650000, -80.839610>
			}
			triangle {
				<83.908982, -7.370000, -87.441562>,
				<79.414916, -9.650000, -80.839610>,
				< 77.822984, -18.290001, -88.424098>
			}
			triangle {
				<-233.883913, -51.050000, -76.239374>,
				<-274.558471, -49.280000, -81.007563>,
				< -280.091317, -43.180001, -110.882014>
			}
			triangle {
				<-280.091317, -43.180001, -110.882014>,
				<-240.901893, -41.150004, -108.529146>,
				< -233.883913, -51.050000, -76.239374>
			}
			triangle {
				<-189.616831, -51.050000, -79.388428>,
				<-233.883913, -51.050000, -76.239374>,
				< -240.901893, -41.150004, -108.529146>
			}
			triangle {
				<-240.901893, -41.150004, -108.529146>,
				<-188.086825, -37.590002, -113.428437>,
				< -189.616831, -51.050000, -79.388428>
			}
			triangle {
				<-144.656820, -49.020000, -79.138427>,
				<-189.616831, -51.050000, -79.388428>,
				< -188.086825, -37.590002, -113.428437>
			}
			triangle {
				<-188.086825, -37.590002, -113.428437>,
				<-150.246826, -38.099999, -111.388463>,
				< -144.656820, -49.020000, -79.138427>
			}
			triangle {
				<-91.316820, -44.700004, -88.528444>,
				<-144.656820, -49.020000, -79.138427>,
				< -150.246826, -38.099999, -111.388463>
			}
			triangle {
				<-150.246826, -38.099999, -111.388463>,
				<-101.986820, -30.990000, -113.928439>,
				< -91.316820, -44.700004, -88.528444>
			}
			triangle {
				<-33.275987, -28.450001, -89.791985>,
				<-91.316820, -44.700004, -88.528444>,
				< -101.986820, -30.990000, -113.928439>
			}
			triangle {
				<-101.986820, -30.990000, -113.928439>,
				<-36.663132, -17.270002, -110.809897>,
				< -33.275987, -28.450001, -89.791985>
			}
			triangle {
				<4.376526, -21.840001, -96.617226>,
				<-33.275987, -28.450001, -89.791985>,
				< -36.663132, -17.270002, -110.809897>
			}
			triangle {
				<-36.663132, -17.270002, -110.809897>,
				<6.038300, -9.650000, -114.492149>,
				< 4.376526, -21.840001, -96.617226>
			}
			triangle {
				<32.061569, -14.220000, -96.929067>,
				<4.376526, -21.840001, -96.617226>,
				< 6.038300, -9.650000, -114.492149>
			}
			triangle {
				<6.038300, -9.650000, -114.492149>,
				<30.523605, -7.110000, -109.682528>,
				< 32.061569, -14.220000, -96.929067>
			}
			triangle {
				<50.242816, -10.670001, -98.698003>,
				<32.061569, -14.220000, -96.929067>,
				< 30.523605, -7.110000, -109.682528>
			}
			triangle {
				<30.523605, -7.110000, -109.682528>,
				<60.811222, -5.590000, -108.462041>,
				< 50.242816, -10.670001, -98.698003>
			}
			triangle {
				<74.859364, -11.939999, -107.037420>,
				<50.242816, -10.670001, -98.698003>,
				< 60.811222, -5.590000, -108.462041>
			}
			triangle {
				<-254.080758, -73.660008, -124.093346>,
				<-280.091317, -43.180001, -110.882014>,
				< -279.148027, -35.050001, -120.904563>
			}
			triangle {
				<-279.148027, -35.050001, -120.904563>,
				<-255.069223, -71.370004, -125.887459>,
				< -254.080758, -73.660008, -124.093346>
			}
			triangle {
				<-240.901893, -41.150004, -108.529146>,
				<-280.091317, -43.180001, -110.882014>,
				< -254.080758, -73.660008, -124.093346>
			}
			triangle {
				<-254.080758, -73.660008, -124.093346>,
				<-231.130860, -64.519998, -117.945818>,
				< -240.901893, -41.150004, -108.529146>
			}
			triangle {
				<-208.853987, -77.220006, -129.264122>,
				<-231.130860, -64.519998, -117.945818>,
				< -254.080758, -73.660008, -124.093346>
			}
			triangle {
				<-254.080758, -73.660008, -124.093346>,
				<-223.256202, -80.770002, -130.322367>,
				< -208.853987, -77.220006, -129.264122>
			}
			triangle {
				<-223.256202, -80.770002, -130.322367>,
				<-254.080758, -73.660008, -124.093346>,
				< -243.296092, -80.010004, -127.540280>
			}
			triangle {
				<-191.646824, 0.000000, -126.628447>,
				<-188.086825, -37.590002, -113.428437>,
				< -240.901893, -41.150004, -108.529146>
			}
			triangle {
				<-240.901893, -41.150004, -108.529146>,
				<-239.674837, 0.000000, -124.435397>,
				< -191.646824, 0.000000, -126.628447>
			}
			triangle {
				<-36.663132, -17.270002, -110.809897>,
				<-101.986820, -30.990000, -113.928439>,
				< -104.266822, 0.000000, -124.858465>
			}
			triangle {
				<-104.266822, 0.000000, -124.858465>,
				<-31.637193, 0.000000, -113.679534>,
				< -36.663132, -17.270002, -110.809897>
			}
			triangle {
				<60.811222, -5.590000, -108.462041>,
				<30.523605, -7.110000, -109.682528>,
				< 28.909639, 0.000000, -113.873190>
			}
			triangle {
				<28.909639, 0.000000, -113.873190>,
				<62.121480, 0.000000, -110.088503>,
				< 60.811222, -5.590000, -108.462041>
			}
			triangle {
				<-279.148027, -35.050001, -120.904563>,
				<-310.210728, -22.350002, -129.792826>,
				< -305.866774, 0.000000, -132.702546>
			}
			triangle {
				<-305.866774, 0.000000, -132.702546>,
				<-270.596680, 0.000000, -128.488734>,
				< -279.148027, -35.050001, -120.904563>
			}
			triangle {
				<-240.901893, -41.150004, -108.529146>,
				<-279.148027, -35.050001, -120.904563>,
				< -270.596680, 0.000000, -128.488734>
			}
			triangle {
				<-270.596680, 0.000000, -128.488734>,
				<-239.674837, 0.000000, -124.435397>,
				< -240.901893, -41.150004, -108.529146>
			}
			triangle {
				<-310.210728, -22.350002, -129.792826>,
				<-346.426190, -17.020001, -136.205932>,
				< -338.815076, 0.000000, -139.648005>
			}
			triangle {
				<-338.815076, 0.000000, -139.648005>,
				<-305.866774, 0.000000, -132.702546>,
				< -310.210728, -22.350002, -129.792826>
			}
			triangle {
				<-346.426190, -17.020001, -136.205932>,
				<-363.959740, -10.160000, -135.521643>,
				< -361.337450, 0.000000, -137.776540>
			}
			triangle {
				<-361.337450, 0.000000, -137.776540>,
				<-338.815076, 0.000000, -139.648005>,
				< -346.426190, -17.020001, -136.205932>
			}
			triangle {
				<-363.959740, -10.160000, -135.521643>,
				<-390.106485, -7.870000, -146.594489>,
				< -387.182053, 0.000000, -148.111889>
			}
			triangle {
				<-387.182053, 0.000000, -148.111889>,
				<-361.337450, 0.000000, -137.776540>,
				< -363.959740, -10.160000, -135.521643>
			}
			triangle {
				<-363.959740, -10.160000, -135.521643>,
				<-368.913718, -17.270002, -130.775117>,
				< -390.106485, -7.870000, -146.594489>
			}
			triangle {
				<-404.119772, -4.570000, -152.574648>,
				<-406.580751, 0.000000, -154.658008>,
				< -387.182053, 0.000000, -148.111889>
			}
			triangle {
				<-387.182053, 0.000000, -148.111889>,
				<-390.106485, -7.870000, -146.594489>,
				< -404.119772, -4.570000, -152.574648>
			}
			triangle {
				<131.168934, -63.250003, -108.482248>,
				<104.330616, -73.150003, -111.448594>,
				< 140.521112, -86.610002, -111.186709>
			}
			triangle {
				<83.908982, -7.370000, -87.441562>,
				<92.113605, -16.510000, -94.239290>,
				< 108.369436, -9.650000, -97.612239>
			}
			triangle {
				<108.369436, -9.650000, -97.612239>,
				<100.170517, 0.000000, -94.395877>,
				< 83.908982, -7.370000, -87.441562>
			}
			triangle {
				<100.170517, 0.000000, -94.395877>,
				<108.369436, -9.650000, -97.612239>,
				< 119.593584, -5.840000, -98.166797>
			}
			triangle {
				<119.593584, -5.840000, -98.166797>,
				<110.491962, 0.000000, -97.903209>,
				< 100.170517, 0.000000, -94.395877>
			}
			triangle {
				<78.545748, -24.129999, -91.450539>,
				<77.822984, -18.290001, -88.424098>,
				< 53.767442, -9.910000, -86.342159>
			}
			triangle {
				<53.767442, -9.910000, -86.342159>,
				<50.242816, -10.670001, -98.698003>,
				< 78.545748, -24.129999, -91.450539>
			}
			triangle {
				<74.859364, -11.939999, -107.037420>,
				<78.545748, -24.129999, -91.450539>,
				< 50.242816, -10.670001, -98.698003>
			}
			triangle {
				<-407.068493, -7.370000, -136.013582>,
				<-379.740010, -13.970000, -107.699346>,
				< -384.209823, -5.080000, -106.304416>
			}
			triangle {
				<-384.209823, -5.080000, -106.304416>,
				<-412.197426, -4.060000, -139.410524>,
				< -407.068493, -7.370000, -136.013582>
			}
			triangle {
				<-410.595101, 0.000000, -144.641157>,
				<-410.107562, -3.810000, -144.932524>,
				< -412.197426, -4.060000, -139.410524>
			}
			triangle {
				<-412.197426, -4.060000, -139.410524>,
				<-413.337221, 0.000000, -137.790588>,
				< -410.595101, 0.000000, -144.641157>
			}
			triangle {
				<-407.068493, -7.370000, -136.013582>,
				<-412.197426, -4.060000, -139.410524>,
				< -410.107562, -3.810000, -144.932524>
			}
			triangle {
				<-410.107562, -3.810000, -144.932524>,
				<-402.195662, -7.370000, -138.716369>,
				< -407.068493, -7.370000, -136.013582>
			}
			triangle {
				<-348.694415, -27.430002, -114.353028>,
				<-369.127184, -18.290001, -127.185104>,
				< -368.913718, -17.270002, -130.775117>
			}
			triangle {
				<-392.385988, -10.920001, -143.354618>,
				<-390.106485, -7.870000, -146.594489>,
				< -368.913718, -17.270002, -130.775117>
			}
			triangle {
				<-368.913718, -17.270002, -130.775117>,
				<-369.127184, -18.290001, -127.185104>,
				< -392.385988, -10.920001, -143.354618>
			}
			triangle {
				<-390.106485, -7.870000, -146.594489>,
				<-392.385988, -10.920001, -143.354618>,
				< -404.119772, -4.570000, -152.574648>
			}
			triangle {
				<-408.754329, -4.830000, -150.142502>,
				<-404.119772, -4.570000, -152.574648>,
				< -392.385988, -10.920001, -143.354618>
			}
			triangle {
				<-392.385988, -10.920001, -143.354618>,
				<-395.951021, -8.380001, -140.248754>,
				< -408.754329, -4.830000, -150.142502>
			}
			triangle {
				<-410.107562, -3.810000, -144.932524>,
				<-408.754329, -4.830000, -150.142502>,
				< -395.951021, -8.380001, -140.248754>
			}
			triangle {
				<-395.951021, -8.380001, -140.248754>,
				<-402.195662, -7.370000, -138.716369>,
				< -410.107562, -3.810000, -144.932524>
			}
			triangle {
				<-406.580751, 0.000000, -154.658008>,
				<-404.119772, -4.570000, -152.574648>,
				< -408.754329, -4.830000, -150.142502>
			}
			triangle {
				<-408.754329, -4.830000, -150.142502>,
				<-410.591986, 0.000000, -150.762449>,
				< -406.580751, 0.000000, -154.658008>
			}
			triangle {
				<-410.107562, -3.810000, -144.932524>,
				<-410.595101, 0.000000, -144.641157>,
				< -410.591986, 0.000000, -150.762449>
			}
			triangle {
				<-410.591986, 0.000000, -150.762449>,
				<-408.754329, -4.830000, -150.142502>,
				< -410.107562, -3.810000, -144.932524>
			}
			triangle {
				<-335.264294, -30.990000, -72.401083>,
				<-344.372875, -27.430002, -71.644214>,
				< -338.279160, -30.730001, -78.010683>
			}
			triangle {
				<-332.347536, -34.540004, -80.289696>,
				<-324.739508, -35.810002, -77.610513>,
				< -335.264294, -30.990000, -72.401083>
			}
			triangle {
				<-318.512348, -34.800000, -103.866341>,
				<-319.568141, -38.610003, -92.058370>,
				< -340.642117, -34.540004, -94.130386>
			}
			triangle {
				<-379.740010, -13.970000, -107.699346>,
				<-359.283125, -26.420001, -91.557900>,
				< -361.986417, -20.830001, -87.259279>
			}
			triangle {
				<-338.279160, -30.730001, -78.010683>,
				<-332.347536, -34.540004, -80.289696>,
				< -335.264294, -30.990000, -72.401083>
			}
			triangle {
				<-243.029663, -78.230005, -129.409841>,
				<-223.112184, -79.249999, -131.171602>,
				< -223.256202, -80.770002, -130.322367>
			}
			triangle {
				<-223.256202, -80.770002, -130.322367>,
				<-243.296092, -80.010004, -127.540280>,
				< -243.029663, -78.230005, -129.409841>
			}
			triangle {
				<-243.296092, -80.010004, -127.540280>,
				<-254.080758, -73.660008, -124.093346>,
				< -255.069223, -71.370004, -125.887459>
			}
			triangle {
				<-255.069223, -71.370004, -125.887459>,
				<-243.029663, -78.230005, -129.409841>,
				< -243.296092, -80.010004, -127.540280>
			}
			triangle {
				<-208.853987, -77.220006, -129.264122>,
				<-223.256202, -80.770002, -130.322367>,
				< -223.112184, -79.249999, -131.171602>
			}
			triangle {
				<-231.130860, -64.519998, -117.945818>,
				<-255.069223, -71.370004, -125.887459>,
				< -279.148027, -35.050001, -120.904563>
			}
			triangle {
				<-279.148027, -35.050001, -120.904563>,
				<-240.901893, -41.150004, -108.529146>,
				< -231.130860, -64.519998, -117.945818>
			}
			triangle {
				<-208.853987, -77.220006, -129.264122>,
				<-223.112184, -79.249999, -131.171602>,
				< -243.029663, -78.230005, -129.409841>
			}
			triangle {
				<-243.029663, -78.230005, -129.409841>,
				<-231.130860, -64.519998, -117.945818>,
				< -208.853987, -77.220006, -129.264122>
			}
			triangle {
				<-231.130860, -64.519998, -117.945818>,
				<-243.029663, -78.230005, -129.409841>,
				< -255.069223, -71.370004, -125.887459>
			}
			triangle {
				<-98.426822, 0.000000, 12.301575>,
				<-122.556821, -6.100000, 23.481568>,
				< -137.546818, -11.680000, 2.141541>
			}
			triangle {
				<-137.546818, -11.680000, 2.141541>,
				<-97.916825, -9.910000, -5.728455>,
				< -98.426822, 0.000000, 12.301575>
			}
			triangle {
				<-98.426822, 0.000000, 12.301575>,
				<-89.026831, 0.000000, 33.131533>,
				< -111.886813, -3.560000, 35.161562>
			}
			triangle {
				<-111.886813, -3.560000, 35.161562>,
				<-122.556821, -6.100000, 23.481568>,
				< -98.426822, 0.000000, 12.301575>
			}
			triangle {
				<-89.026831, 0.000000, 33.131533>,
				<-77.346817, 0.000000, 44.821535>,
				< -80.396826, 0.000000, 52.941590>
			}
			triangle {
				<-80.396826, 0.000000, 52.941590>,
				<-111.886813, -3.560000, 35.161562>,
				< -89.026831, 0.000000, 33.131533>
			}
			triangle {
				<-111.886813, -3.560000, 35.161562>,
				<-80.396826, 0.000000, 52.941590>,
				< -96.646822, -1.270000, 53.451540>
			}
			triangle {
				<-101.986820, -30.990000, -113.928439>,
				<-150.246826, -38.099999, -111.388463>,
				< -148.466834, 0.000000, -123.078429>
			}
			triangle {
				<-148.466834, 0.000000, -123.078429>,
				<-104.266822, 0.000000, -124.858465>,
				< -101.986820, -30.990000, -113.928439>
			}
			triangle {
				<-148.466834, 0.000000, -123.078429>,
				<-150.246826, -38.099999, -111.388463>,
				< -188.086825, -37.590002, -113.428437>
			}
			triangle {
				<-188.086825, -37.590002, -113.428437>,
				<-191.646824, 0.000000, -126.628447>,
				< -148.466834, 0.000000, -123.078429>
			}
			triangle {
				<28.909639, 0.000000, -113.873190>,
				<30.523605, -7.110000, -109.682528>,
				< 6.038300, -9.650000, -114.492149>
			}
			triangle {
				<6.038300, -9.650000, -114.492149>,
				<3.483231, 0.000000, -116.707432>,
				< 28.909639, 0.000000, -113.873190>
			}
			triangle {
				<-31.637193, 0.000000, -113.679534>,
				<3.483231, 0.000000, -116.707432>,
				< 6.038300, -9.650000, -114.492149>
			}
			triangle {
				<6.038300, -9.650000, -114.492149>,
				<-36.663132, -17.270002, -110.809897>,
				< -31.637193, 0.000000, -113.679534>
			}
			triangle {
				<60.811222, -5.590000, -108.462041>,
				<62.121480, 0.000000, -110.088503>,
				< 77.104893, 0.000000, -108.517319>
			}
			triangle {
				<77.104893, 0.000000, -108.517319>,
				<74.859364, -11.939999, -107.037420>,
				< 60.811222, -5.590000, -108.462041>
			}
			triangle {
				<87.467762, -52.320003, -109.354475>,
				<104.525772, -73.150003, -114.022234>,
				< 104.330616, -73.150003, -111.448594>
			}
			triangle {
				<104.330616, -73.150003, -111.448594>,
				<87.316850, -52.320003, -104.962484>,
				< 87.467762, -52.320003, -109.354475>
			}
			triangle {
				<87.316850, -52.320003, -104.962484>,
				<78.545748, -24.129999, -91.450539>,
				< 74.859364, -11.939999, -107.037420>
			}
			triangle {
				<74.859364, -11.939999, -107.037420>,
				<87.467762, -52.320003, -109.354475>,
				< 87.316850, -52.320003, -104.962484>
			}
			triangle {
				<140.521112, -86.610002, -111.186709>,
				<104.330616, -73.150003, -111.448594>,
				< 104.525772, -73.150003, -114.022234>
			}
			triangle {
				<83.908982, -7.370000, -87.441562>,
				<100.170517, 0.000000, -94.395877>,
				< 89.816332, 0.000000, -86.501415>
			}
			triangle {
				<74.859364, -11.939999, -107.037420>,
				<77.104893, 0.000000, -108.517319>,
				< 110.491962, 0.000000, -97.903209>
			}
			triangle {
				<110.491962, 0.000000, -97.903209>,
				<119.593584, -5.840000, -98.166797>,
				< 124.750044, -21.590000, -103.242738>
			}
			triangle {
				<124.750044, -21.590000, -103.242738>,
				<74.859364, -11.939999, -107.037420>,
				< 110.491962, 0.000000, -97.903209>
			}
			triangle {
				<74.859364, -11.939999, -107.037420>,
				<124.750044, -21.590000, -103.242738>,
				< 87.467762, -52.320003, -109.354475>
			}
			triangle {
				<124.750044, -21.590000, -103.242738>,
				<131.168934, -63.250003, -108.482248>,
				< 104.525772, -73.150003, -114.022234>
			}
			triangle {
				<104.525772, -73.150003, -114.022234>,
				<87.467762, -52.320003, -109.354475>,
				< 124.750044, -21.590000, -103.242738>
			}
			triangle {
				<104.525772, -73.150003, -114.022234>,
				<131.168934, -63.250003, -108.482248>,
				< 140.521112, -86.610002, -111.186709>
			}
			triangle {
				<104.330616, -73.150003, -111.448594>,
				<131.168934, -63.250003, -108.482248>,
				< 124.750044, -21.590000, -103.242738>
			}
			triangle {
				<124.750044, -21.590000, -103.242738>,
				<87.316850, -52.320003, -104.962484>,
				< 104.330616, -73.150003, -111.448594>
			}
			triangle {
				<124.750044, -21.590000, -103.242738>,
				<119.593584, -5.840000, -98.166797>,
				< 108.369436, -9.650000, -97.612239>
			}
			triangle {
				<108.369436, -9.650000, -97.612239>,
				<87.316850, -52.320003, -104.962484>,
				< 124.750044, -21.590000, -103.242738>
			}
			triangle {
				<87.316850, -52.320003, -104.962484>,
				<108.369436, -9.650000, -97.612239>,
				< 92.113605, -16.510000, -94.239290>
			}
			triangle {
				<87.316850, -52.320003, -104.962484>,
				<92.113605, -16.510000, -94.239290>,
				< 78.545748, -24.129999, -91.450539>
			}
			triangle {
				<92.113605, -16.510000, -94.239290>,
				<83.908982, -7.370000, -87.441562>,
				< 77.822984, -18.290001, -88.424098>
			}
			triangle {
				<77.822984, -18.290001, -88.424098>,
				<78.545748, -24.129999, -91.450539>,
				< 92.113605, -16.510000, -94.239290>
			}
			triangle {
				<-322.155700, 0.000000, -40.356493>,
				<-325.612470, 0.000000, -42.106308>,
				< -327.358308, -5.330000, -44.760820>
			}
			triangle {
				<-353.638555, -13.970000, -63.478895>,
				<-327.358308, -5.330000, -44.760820>,
				< -325.612470, 0.000000, -42.106308>
			}
			triangle {
				<-325.612470, 0.000000, -42.106308>,
				<-349.315833, 0.000000, -57.466204>,
				< -353.638555, -13.970000, -63.478895>
			}
			triangle {
				<-353.638555, -13.970000, -63.478895>,
				<-326.520712, -13.970000, -46.877472>,
				< -327.358308, -5.330000, -44.760820>
			}
			triangle {
				<-201.546817, 0.000000, 4.681549>,
				<-162.946834, 0.000000, 39.481570>,
				< -155.326821, 6.100000, 38.211549>
			}
			triangle {
				<-155.326821, 6.100000, 38.211549>,
				<-196.216836, 8.130001, 3.921570>,
				< -201.546817, 0.000000, 4.681549>
			}
			triangle {
				<-162.946834, 0.000000, 39.481570>,
				<-129.926819, 0.000000, 55.481508>,
				< -126.616822, 3.560000, 52.441592>
			}
			triangle {
				<-126.616822, 3.560000, 52.441592>,
				<-155.326821, 6.100000, 38.211549>,
				< -162.946834, 0.000000, 39.481570>
			}
			triangle {
				<-129.926819, 0.000000, 55.481508>,
				<-98.426822, 0.000000, 57.771548>,
				< -96.646822, 1.270000, 53.451540>
			}
			triangle {
				<-96.646822, 1.270000, 53.451540>,
				<-126.616822, 3.560000, 52.441592>,
				< -129.926819, 0.000000, 55.481508>
			}
			triangle {
				<-96.646822, 1.270000, 53.451540>,
				<-98.426822, 0.000000, 57.771548>,
				< -80.396826, 0.000000, 52.941590>
			}
			triangle {
				<-97.916825, 9.910000, -5.728455>,
				<-98.426822, 0.000000, 12.301575>,
				< -87.756821, 0.000000, -12.588440>
			}
			triangle {
				<-196.216836, 8.130001, 3.921570>,
				<-155.326821, 6.100000, 38.211549>,
				< -122.556821, 6.100000, 23.481568>
			}
			triangle {
				<-122.556821, 6.100000, 23.481568>,
				<-137.546818, 11.680000, 2.141541>,
				< -196.216836, 8.130001, 3.921570>
			}
			triangle {
				<-155.326821, 6.100000, 38.211549>,
				<-126.616822, 3.560000, 52.441592>,
				< -111.886813, 3.560000, 35.161562>
			}
			triangle {
				<-111.886813, 3.560000, 35.161562>,
				<-122.556821, 6.100000, 23.481568>,
				< -155.326821, 6.100000, 38.211549>
			}
			triangle {
				<-111.886813, 3.560000, 35.161562>,
				<-126.616822, 3.560000, 52.441592>,
				< -96.646822, 1.270000, 53.451540>
			}
			triangle {
				<-368.089853, 0.000000, -71.710476>,
				<-374.053238, 7.620000, -79.112083>,
				< -379.431292, 0.000000, -82.488320>
			}
			triangle {
				<-368.089853, 0.000000, -71.710476>,
				<-349.315833, 0.000000, -57.466204>,
				< -353.638555, 13.970000, -63.478895>
			}
			triangle {
				<-353.638555, 13.970000, -63.478895>,
				<-374.053238, 7.620000, -79.112083>,
				< -368.089853, 0.000000, -71.710476>
			}
			triangle {
				<-327.358308, 5.330000, -44.760820>,
				<-322.155700, 0.000000, -40.356493>,
				< -286.276678, 0.000000, -19.636413>
			}
			triangle {
				<-286.276678, 0.000000, -19.636413>,
				<-326.520712, 13.970000, -46.877472>,
				< -327.358308, 5.330000, -44.760820>
			}
			triangle {
				<-326.520712, 13.970000, -46.877472>,
				<-286.276678, 0.000000, -19.636413>,
				< -287.797482, 18.290001, -25.621064>
			}
			triangle {
				<-286.276678, 0.000000, -19.636413>,
				<-242.049044, 0.000000, -2.660553>,
				< -243.248610, 22.350002, -7.919250>
			}
			triangle {
				<-243.248610, 22.350002, -7.919250>,
				<-287.797482, 18.290001, -25.621064>,
				< -286.276678, 0.000000, -19.636413>
			}
			triangle {
				<-242.049044, 0.000000, -2.660553>,
				<-201.546817, 0.000000, 4.681549>,
				< -196.216836, 8.130001, 3.921570>
			}
			triangle {
				<-196.216836, 8.130001, 3.921570>,
				<-243.248610, 22.350002, -7.919250>,
				< -242.049044, 0.000000, -2.660553>
			}
			triangle {
				<-243.248610, 22.350002, -7.919250>,
				<-196.216836, 8.130001, 3.921570>,
				< -199.266823, 24.640000, -11.058442>
			}
			triangle {
				<-196.216836, 8.130001, 3.921570>,
				<-137.546818, 11.680000, 2.141541>,
				< -141.096822, 26.670000, -12.588440>
			}
			triangle {
				<-141.096822, 26.670000, -12.588440>,
				<-199.266823, 24.640000, -11.058442>,
				< -196.216836, 8.130001, 3.921570>
			}
			triangle {
				<-137.546818, 11.680000, 2.141541>,
				<-97.916825, 9.910000, -5.728455>,
				< -84.966830, 20.320000, -24.528442>
			}
			triangle {
				<-84.966830, 20.320000, -24.528442>,
				<-141.096822, 26.670000, -12.588440>,
				< -137.546818, 11.680000, 2.141541>
			}
			triangle {
				<-84.966830, 20.320000, -24.528442>,
				<-97.916825, 9.910000, -5.728455>,
				< -87.756821, 0.000000, -12.588440>
			}
			triangle {
				<-84.966830, 20.320000, -24.528442>,
				<-87.756821, 0.000000, -12.588440>,
				< -30.384340, 0.000000, -32.191470>
			}
			triangle {
				<-30.384340, 0.000000, -32.191470>,
				<-30.095995, 11.680000, -36.432679>,
				< -84.966830, 20.320000, -24.528442>
			}
			triangle {
				<-30.384340, 0.000000, -32.191470>,
				<10.643921, 0.000000, -45.060747>,
				< 9.985199, 14.730000, -56.791384>
			}
			triangle {
				<9.985199, 14.730000, -56.791384>,
				<-30.095995, 11.680000, -36.432679>,
				< -30.384340, 0.000000, -32.191470>
			}
			triangle {
				<10.643921, 0.000000, -45.060747>,
				<35.265642, 0.000000, -53.671952>,
				< 36.177828, 11.940000, -69.452896>
			}
			triangle {
				<36.177828, 11.940000, -69.452896>,
				<9.985199, 14.730000, -56.791384>,
				< 10.643921, 0.000000, -45.060747>
			}
			triangle {
				<35.265642, 0.000000, -53.671952>,
				<58.749894, 0.000000, -62.920227>,
				< 60.586217, 7.870000, -77.568742>
			}
			triangle {
				<60.586217, 7.870000, -77.568742>,
				<36.177828, 11.940000, -69.452896>,
				< 35.265642, 0.000000, -53.671952>
			}
			triangle {
				<58.749894, 0.000000, -62.920227>,
				<77.364933, 0.000000, -71.815673>,
				< 79.414916, 9.650000, -80.839610>
			}
			triangle {
				<79.414916, 9.650000, -80.839610>,
				<60.586217, 7.870000, -77.568742>,
				< 58.749894, 0.000000, -62.920227>
			}
			triangle {
				<77.364933, 0.000000, -71.815673>,
				<89.816332, 0.000000, -86.501415>,
				< 83.908982, 7.370000, -87.441562>
			}
			triangle {
				<83.908982, 7.370000, -87.441562>,
				<79.414916, 9.650000, -80.839610>,
				< 77.364933, 0.000000, -71.815673>
			}
			triangle {
				<-329.577839, 22.350002, -52.995303>,
				<-353.638555, 13.970000, -63.478895>,
				< -326.520712, 13.970000, -46.877472>
			}
			triangle {
				<-313.478812, 32.770000, -55.607424>,
				<-329.577839, 22.350002, -52.995303>,
				< -326.520712, 13.970000, -46.877472>
			}
			triangle {
				<-313.478812, 32.770000, -55.607424>,
				<-326.520712, 13.970000, -46.877472>,
				< -287.797482, 18.290001, -25.621064>
			}
			triangle {
				<-287.797482, 18.290001, -25.621064>,
				<-282.626115, 29.970001, -40.068880>,
				< -313.478812, 32.770000, -55.607424>
			}
			triangle {
				<-287.797482, 18.290001, -25.621064>,
				<-243.248610, 22.350002, -7.919250>,
				< -244.296326, 31.999999, -26.686982>
			}
			triangle {
				<-244.296326, 31.999999, -26.686982>,
				<-282.626115, 29.970001, -40.068880>,
				< -287.797482, 18.290001, -25.621064>
			}
			triangle {
				<-243.248610, 22.350002, -7.919250>,
				<-199.266823, 24.640000, -11.058442>,
				< -199.266823, 35.810002, -28.838442>
			}
			triangle {
				<-199.266823, 35.810002, -28.838442>,
				<-244.296326, 31.999999, -26.686982>,
				< -243.248610, 22.350002, -7.919250>
			}
			triangle {
				<-199.266823, 24.640000, -11.058442>,
				<-141.096822, 26.670000, -12.588440>,
				< -148.716835, 34.040002, -30.108460>
			}
			triangle {
				<-148.716835, 34.040002, -30.108460>,
				<-199.266823, 35.810002, -28.838442>,
				< -199.266823, 24.640000, -11.058442>
			}
			triangle {
				<-141.096822, 26.670000, -12.588440>,
				<-84.966830, 20.320000, -24.528442>,
				< -88.266818, 28.450001, -37.988466>
			}
			triangle {
				<-88.266818, 28.450001, -37.988466>,
				<-148.716835, 34.040002, -30.108460>,
				< -141.096822, 26.670000, -12.588440>
			}
			triangle {
				<-84.966830, 20.320000, -24.528442>,
				<-30.095995, 11.680000, -36.432679>,
				< -30.437530, 18.290001, -44.028580>
			}
			triangle {
				<-30.437530, 18.290001, -44.028580>,
				<-88.266818, 28.450001, -37.988466>,
				< -84.966830, 20.320000, -24.528442>
			}
			triangle {
				<-30.437530, 18.290001, -44.028580>,
				<-30.095995, 11.680000, -36.432679>,
				< 9.985199, 14.730000, -56.791384>
			}
			triangle {
				<-326.191051, 36.580003, -67.545747>,
				<-336.190305, 31.750002, -65.189648>,
				< -329.577839, 22.350002, -52.995303>
			}
			triangle {
				<-329.577839, 22.350002, -52.995303>,
				<-313.478812, 32.770000, -55.607424>,
				< -326.191051, 36.580003, -67.545747>
			}
			triangle {
				<-336.190305, 31.750002, -65.189648>,
				<-344.372875, 27.430002, -71.644214>,
				< -353.638555, 13.970000, -63.478895>
			}
			triangle {
				<-353.638555, 13.970000, -63.478895>,
				<-329.577839, 22.350002, -52.995303>,
				< -336.190305, 31.750002, -65.189648>
			}
			triangle {
				<-353.638555, 13.970000, -63.478895>,
				<-344.372875, 27.430002, -71.644214>,
				< -361.986417, 20.830001, -87.259279>
			}
			triangle {
				<-361.986417, 20.830001, -87.259279>,
				<-374.053238, 7.620000, -79.112083>,
				< -353.638555, 13.970000, -63.478895>
			}
			triangle {
				<-374.053238, 7.620000, -79.112083>,
				<-361.986417, 20.830001, -87.259279>,
				< -377.335139, 10.160000, -100.252918>
			}
			triangle {
				<-324.739508, 35.810002, -77.610513>,
				<-335.264294, 30.990000, -72.401083>,
				< -336.190305, 31.750002, -65.189648>
			}
			triangle {
				<-336.190305, 31.750002, -65.189648>,
				<-326.191051, 36.580003, -67.545747>,
				< -324.739508, 35.810002, -77.610513>
			}
			triangle {
				<-336.190305, 31.750002, -65.189648>,
				<-335.264294, 30.990000, -72.401083>,
				< -344.372875, 27.430002, -71.644214>
			}
			triangle {
				<-361.986417, 20.830001, -87.259279>,
				<-379.740010, 13.970000, -107.699346>,
				< -377.335139, 10.160000, -100.252918>
			}
			triangle {
				<-402.195662, 7.370000, -138.716369>,
				<-407.068493, 7.370000, -136.013582>,
				< -379.740010, 13.970000, -107.699346>
			}
			triangle {
				<-379.740010, 13.970000, -107.699346>,
				<-373.702720, 14.990000, -117.884288>,
				< -402.195662, 7.370000, -138.716369>
			}
			triangle {
				<-413.337221, 0.000000, -137.790588>,
				<-387.189900, 0.000000, -108.354702>,
				< -384.209823, 5.080000, -106.304416>
			}
			triangle {
				<-384.209823, 5.080000, -106.304416>,
				<-412.197426, 4.060000, -139.410524>,
				< -413.337221, 0.000000, -137.790588>
			}
			triangle {
				<-377.335139, 10.160000, -100.252918>,
				<-384.209823, 5.080000, -106.304416>,
				< -379.431292, 0.000000, -82.488320>
			}
			triangle {
				<-379.431292, 0.000000, -82.488320>,
				<-374.053238, 7.620000, -79.112083>,
				< -377.335139, 10.160000, -100.252918>
			}
			triangle {
				<-379.431292, 0.000000, -82.488320>,
				<-384.209823, 5.080000, -106.304416>,
				< -387.189900, 0.000000, -108.354702>
			}
			triangle {
				<-344.372875, 27.430002, -71.644214>,
				<-338.279160, 30.730001, -78.010683>,
				< -345.490919, 30.730001, -88.118228>
			}
			triangle {
				<-345.490919, 30.730001, -88.118228>,
				<-346.275581, 30.480000, -85.243356>,
				< -344.372875, 27.430002, -71.644214>
			}
			triangle {
				<-361.986417, 20.830001, -87.259279>,
				<-344.372875, 27.430002, -71.644214>,
				< -346.275581, 30.480000, -85.243356>
			}
			triangle {
				<-346.275581, 30.480000, -85.243356>,
				<-359.283125, 26.420001, -91.557900>,
				< -361.986417, 20.830001, -87.259279>
			}
			triangle {
				<-346.275581, 30.480000, -85.243356>,
				<-345.490919, 30.730001, -88.118228>,
				< -356.435830, 25.910001, -97.142879>
			}
			triangle {
				<-356.435830, 25.910001, -97.142879>,
				<-359.283125, 26.420001, -91.557900>,
				< -346.275581, 30.480000, -85.243356>
			}
			triangle {
				<-359.283125, 26.420001, -91.557900>,
				<-356.435830, 25.910001, -97.142879>,
				< -373.702720, 14.990000, -117.884288>
			}
			triangle {
				<-373.702720, 14.990000, -117.884288>,
				<-379.740010, 13.970000, -107.699346>,
				< -359.283125, 26.420001, -91.557900>
			}
			triangle {
				<-373.702720, 14.990000, -117.884288>,
				<-370.221257, 16.260001, -121.996703>,
				< -395.951021, 8.380001, -140.248754>
			}
			triangle {
				<-395.951021, 8.380001, -140.248754>,
				<-402.195662, 7.370000, -138.716369>,
				< -373.702720, 14.990000, -117.884288>
			}
			triangle {
				<-373.702720, 14.990000, -117.884288>,
				<-356.435830, 25.910001, -97.142879>,
				< -350.763567, 25.910001, -108.581871>
			}
			triangle {
				<-350.763567, 25.910001, -108.581871>,
				<-370.221257, 16.260001, -121.996703>,
				< -373.702720, 14.990000, -117.884288>
			}
			triangle {
				<-356.435830, 25.910001, -97.142879>,
				<-345.490919, 30.730001, -88.118228>,
				< -340.642117, 34.540004, -94.130386>
			}
			triangle {
				<-340.642117, 34.540004, -94.130386>,
				<-318.512348, 34.800000, -103.866341>,
				< -348.694415, 27.430002, -114.353028>
			}
			triangle {
				<-348.694415, 27.430002, -114.353028>,
				<-350.763567, 25.910001, -108.581871>,
				< -340.642117, 34.540004, -94.130386>
			}
			triangle {
				<-384.209823, 5.080000, -106.304416>,
				<-377.335139, 10.160000, -100.252918>,
				< -379.740010, 13.970000, -107.699346>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-345.490919, 30.730001, -88.118228>,
				< -338.279160, 30.730001, -78.010683>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-338.279160, 30.730001, -78.010683>,
				< -332.347536, 34.540004, -80.289696>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-332.347536, 34.540004, -80.289696>,
				< -324.739508, 35.810002, -77.610513>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-324.739508, 35.810002, -77.610513>,
				< -319.568141, 38.610003, -92.058370>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-319.568141, 38.610003, -92.058370>,
				< -340.642117, 34.540004, -94.130386>
			}
			triangle {
				<-335.137397, 34.800000, -89.229393>,
				<-340.642117, 34.540004, -94.130386>,
				< -345.490919, 30.730001, -88.118228>
			}
			triangle {
				<-392.385988, 10.920001, -143.354618>,
				<-395.951021, 8.380001, -140.248754>,
				< -370.221257, 16.260001, -121.996703>
			}
			triangle {
				<-370.221257, 16.260001, -121.996703>,
				<-369.127184, 18.290001, -127.185104>,
				< -392.385988, 10.920001, -143.354618>
			}
			triangle {
				<-369.127184, 18.290001, -127.185104>,
				<-370.221257, 16.260001, -121.996703>,
				< -350.763567, 25.910001, -108.581871>
			}
			triangle {
				<-350.763567, 25.910001, -108.581871>,
				<-348.694415, 27.430002, -114.353028>,
				< -369.127184, 18.290001, -127.185104>
			}
			triangle {
				<-346.426190, 17.020001, -136.205932>,
				<-348.694415, 27.430002, -114.353028>,
				< -330.822030, 31.750002, -107.940989>
			}
			triangle {
				<-330.822030, 31.750002, -107.940989>,
				<-310.210728, 22.350002, -129.792826>,
				< -346.426190, 17.020001, -136.205932>
			}
			triangle {
				<-310.210728, 22.350002, -129.792826>,
				<-330.822030, 31.750002, -107.940989>,
				< -318.512348, 34.800000, -103.866341>
			}
			triangle {
				<-346.426190, 17.020001, -136.205932>,
				<-363.959740, 10.160000, -135.521643>,
				< -368.913718, 17.270002, -130.775117>
			}
			triangle {
				<-368.913718, 17.270002, -130.775117>,
				<-348.694415, 27.430002, -114.353028>,
				< -346.426190, 17.020001, -136.205932>
			}
			triangle {
				<-318.512348, 34.800000, -103.866341>,
				<-280.091317, 43.180001, -110.882014>,
				< -279.148027, 35.050001, -120.904563>
			}
			triangle {
				<-279.148027, 35.050001, -120.904563>,
				<-310.210728, 22.350002, -129.792826>,
				< -318.512348, 34.800000, -103.866341>
			}
			triangle {
				<-318.512348, 34.800000, -103.866341>,
				<-315.178523, 40.389999, -91.399581>,
				< -274.558471, 49.280000, -81.007563>
			}
			triangle {
				<-274.558471, 49.280000, -81.007563>,
				<-280.091317, 43.180001, -110.882014>,
				< -318.512348, 34.800000, -103.866341>
			}
			triangle {
				<-318.512348, 34.800000, -103.866341>,
				<-319.568141, 38.610003, -92.058370>,
				< -315.178523, 40.389999, -91.399581>
			}
			triangle {
				<-319.568141, 38.610003, -92.058370>,
				<-324.739508, 35.810002, -77.610513>,
				< -308.643625, 40.130003, -74.101320>
			}
			triangle {
				<-308.643625, 40.130003, -74.101320>,
				<-315.178523, 40.389999, -91.399581>,
				< -319.568141, 38.610003, -92.058370>
			}
			triangle {
				<-324.739508, 35.810002, -77.610513>,
				<-326.191051, 36.580003, -67.545747>,
				< -313.478812, 32.770000, -55.607424>
			}
			triangle {
				<-313.478812, 32.770000, -55.607424>,
				<-308.643625, 40.130003, -74.101320>,
				< -324.739508, 35.810002, -77.610513>
			}
			triangle {
				<-308.643625, 40.130003, -74.101320>,
				<-313.478812, 32.770000, -55.607424>,
				< -306.554799, 36.580003, -61.280242>
			}
			triangle {
				<-308.643625, 40.130003, -74.101320>,
				<-275.891193, 42.670000, -57.195419>,
				< -274.558471, 49.280000, -81.007563>
			}
			triangle {
				<-274.558471, 49.280000, -81.007563>,
				<-315.178523, 40.389999, -91.399581>,
				< -308.643625, 40.130003, -74.101320>
			}
			triangle {
				<-275.891193, 42.670000, -57.195419>,
				<-243.700293, 46.230002, -50.187030>,
				< -233.883913, 51.050000, -76.239374>
			}
			triangle {
				<-233.883913, 51.050000, -76.239374>,
				<-274.558471, 49.280000, -81.007563>,
				< -275.891193, 42.670000, -57.195419>
			}
			triangle {
				<-243.700293, 46.230002, -50.187030>,
				<-194.696840, 48.010002, -60.588438>,
				< -189.616831, 51.050000, -79.388428>
			}
			triangle {
				<-189.616831, 51.050000, -79.388428>,
				<-233.883913, 51.050000, -76.239374>,
				< -243.700293, 46.230002, -50.187030>
			}
			triangle {
				<-194.696840, 48.010002, -60.588438>,
				<-146.686813, 46.230002, -55.508455>,
				< -144.656820, 49.020000, -79.138427>
			}
			triangle {
				<-144.656820, 49.020000, -79.138427>,
				<-189.616831, 51.050000, -79.388428>,
				< -194.696840, 48.010002, -60.588438>
			}
			triangle {
				<-146.686813, 46.230002, -55.508455>,
				<-90.806830, 43.939999, -61.608461>,
				< -91.316820, 44.700004, -88.528444>
			}
			triangle {
				<-91.316820, 44.700004, -88.528444>,
				<-144.656820, 49.020000, -79.138427>,
				< -146.686813, 46.230002, -55.508455>
			}
			triangle {
				<-90.806830, 43.939999, -61.608461>,
				<-31.980423, 33.020001, -65.284864>,
				< -33.275987, 28.450001, -89.791985>
			}
			triangle {
				<-33.275987, 28.450001, -89.791985>,
				<-91.316820, 44.700004, -88.528444>,
				< -90.806830, 43.939999, -61.608461>
			}
			triangle {
				<-31.980423, 33.020001, -65.284864>,
				<6.479782, 23.370001, -72.074616>,
				< 4.376526, 21.840001, -96.617226>
			}
			triangle {
				<4.376526, 21.840001, -96.617226>,
				<-33.275987, 28.450001, -89.791985>,
				< -31.980423, 33.020001, -65.284864>
			}
			triangle {
				<6.479782, 23.370001, -72.074616>,
				<33.767840, 13.970000, -81.742428>,
				< 32.061569, 14.220000, -96.929067>
			}
			triangle {
				<32.061569, 14.220000, -96.929067>,
				<4.376526, 21.840001, -96.617226>,
				< 6.479782, 23.370001, -72.074616>
			}
			triangle {
				<33.767840, 13.970000, -81.742428>,
				<53.767442, 9.910000, -86.342159>,
				< 50.242816, 10.670001, -98.698003>
			}
			triangle {
				<50.242816, 10.670001, -98.698003>,
				<32.061569, 14.220000, -96.929067>,
				< 33.767840, 13.970000, -81.742428>
			}
			triangle {
				<-275.891193, 42.670000, -57.195419>,
				<-308.643625, 40.130003, -74.101320>,
				< -306.554799, 36.580003, -61.280242>
			}
			triangle {
				<-275.891193, 42.670000, -57.195419>,
				<-306.554799, 36.580003, -61.280242>,
				< -282.626115, 29.970001, -40.068880>
			}
			triangle {
				<-282.626115, 29.970001, -40.068880>,
				<-306.554799, 36.580003, -61.280242>,
				< -313.478812, 32.770000, -55.607424>
			}
			triangle {
				<-282.626115, 29.970001, -40.068880>,
				<-244.296326, 31.999999, -26.686982>,
				< -243.700293, 46.230002, -50.187030>
			}
			triangle {
				<-243.700293, 46.230002, -50.187030>,
				<-275.891193, 42.670000, -57.195419>,
				< -282.626115, 29.970001, -40.068880>
			}
			triangle {
				<-244.296326, 31.999999, -26.686982>,
				<-199.266823, 35.810002, -28.838442>,
				< -194.696840, 48.010002, -60.588438>
			}
			triangle {
				<-194.696840, 48.010002, -60.588438>,
				<-243.700293, 46.230002, -50.187030>,
				< -244.296326, 31.999999, -26.686982>
			}
			triangle {
				<-199.266823, 35.810002, -28.838442>,
				<-148.716835, 34.040002, -30.108460>,
				< -146.686813, 46.230002, -55.508455>
			}
			triangle {
				<-146.686813, 46.230002, -55.508455>,
				<-194.696840, 48.010002, -60.588438>,
				< -199.266823, 35.810002, -28.838442>
			}
			triangle {
				<-148.716835, 34.040002, -30.108460>,
				<-88.266818, 28.450001, -37.988466>,
				< -90.806830, 43.939999, -61.608461>
			}
			triangle {
				<-90.806830, 43.939999, -61.608461>,
				<-146.686813, 46.230002, -55.508455>,
				< -148.716835, 34.040002, -30.108460>
			}
			triangle {
				<-88.266818, 28.450001, -37.988466>,
				<-30.437530, 18.290001, -44.028580>,
				< -31.980423, 33.020001, -65.284864>
			}
			triangle {
				<-31.980423, 33.020001, -65.284864>,
				<-90.806830, 43.939999, -61.608461>,
				< -88.266818, 28.450001, -37.988466>
			}
			triangle {
				<-30.437530, 18.290001, -44.028580>,
				<9.985199, 14.730000, -56.791384>,
				< 6.479782, 23.370001, -72.074616>
			}
			triangle {
				<6.479782, 23.370001, -72.074616>,
				<-31.980423, 33.020001, -65.284864>,
				< -30.437530, 18.290001, -44.028580>
			}
			triangle {
				<9.985199, 14.730000, -56.791384>,
				<36.177828, 11.940000, -69.452896>,
				< 33.767840, 13.970000, -81.742428>
			}
			triangle {
				<33.767840, 13.970000, -81.742428>,
				<6.479782, 23.370001, -72.074616>,
				< 9.985199, 14.730000, -56.791384>
			}
			triangle {
				<36.177828, 11.940000, -69.452896>,
				<60.586217, 7.870000, -77.568742>,
				< 53.767442, 9.910000, -86.342159>
			}
			triangle {
				<53.767442, 9.910000, -86.342159>,
				<33.767840, 13.970000, -81.742428>,
				< 36.177828, 11.940000, -69.452896>
			}
			triangle {
				<60.586217, 7.870000, -77.568742>,
				<79.414916, 9.650000, -80.839610>,
				< 77.822984, 18.290001, -88.424098>
			}
			triangle {
				<77.822984, 18.290001, -88.424098>,
				<53.767442, 9.910000, -86.342159>,
				< 60.586217, 7.870000, -77.568742>
			}
			triangle {
				<77.822984, 18.290001, -88.424098>,
				<79.414916, 9.650000, -80.839610>,
				< 83.908982, 7.370000, -87.441562>
			}
			triangle {
				<-274.558471, 49.280000, -81.007563>,
				<-233.883913, 51.050000, -76.239374>,
				< -240.901893, 41.150004, -108.529146>
			}
			triangle {
				<-240.901893, 41.150004, -108.529146>,
				<-280.091317, 43.180001, -110.882014>,
				< -274.558471, 49.280000, -81.007563>
			}
			triangle {
				<-233.883913, 51.050000, -76.239374>,
				<-189.616831, 51.050000, -79.388428>,
				< -188.086825, 37.590002, -113.428437>
			}
			triangle {
				<-188.086825, 37.590002, -113.428437>,
				<-240.901893, 41.150004, -108.529146>,
				< -233.883913, 51.050000, -76.239374>
			}
			triangle {
				<-189.616831, 51.050000, -79.388428>,
				<-144.656820, 49.020000, -79.138427>,
				< -150.246826, 38.099999, -111.388463>
			}
			triangle {
				<-150.246826, 38.099999, -111.388463>,
				<-188.086825, 37.590002, -113.428437>,
				< -189.616831, 51.050000, -79.388428>
			}
			triangle {
				<-144.656820, 49.020000, -79.138427>,
				<-91.316820, 44.700004, -88.528444>,
				< -101.986820, 30.990000, -113.928439>
			}
			triangle {
				<-101.986820, 30.990000, -113.928439>,
				<-150.246826, 38.099999, -111.388463>,
				< -144.656820, 49.020000, -79.138427>
			}
			triangle {
				<-91.316820, 44.700004, -88.528444>,
				<-33.275987, 28.450001, -89.791985>,
				< -36.663132, 17.270002, -110.809897>
			}
			triangle {
				<-36.663132, 17.270002, -110.809897>,
				<-101.986820, 30.990000, -113.928439>,
				< -91.316820, 44.700004, -88.528444>
			}
			triangle {
				<-33.275987, 28.450001, -89.791985>,
				<4.376526, 21.840001, -96.617226>,
				< 6.038300, 9.650000, -114.492149>
			}
			triangle {
				<6.038300, 9.650000, -114.492149>,
				<-36.663132, 17.270002, -110.809897>,
				< -33.275987, 28.450001, -89.791985>
			}
			triangle {
				<4.376526, 21.840001, -96.617226>,
				<32.061569, 14.220000, -96.929067>,
				< 30.523605, 7.110000, -109.682528>
			}
			triangle {
				<30.523605, 7.110000, -109.682528>,
				<6.038300, 9.650000, -114.492149>,
				< 4.376526, 21.840001, -96.617226>
			}
			triangle {
				<32.061569, 14.220000, -96.929067>,
				<50.242816, 10.670001, -98.698003>,
				< 60.811222, 5.590000, -108.462041>
			}
			triangle {
				<60.811222, 5.590000, -108.462041>,
				<30.523605, 7.110000, -109.682528>,
				< 32.061569, 14.220000, -96.929067>
			}
			triangle {
				<60.811222, 5.590000, -108.462041>,
				<50.242816, 10.670001, -98.698003>,
				< 74.859364, 11.940000, -107.037420>
			}
			triangle {
				<-280.091317, 43.180001, -110.882014>,
				<-254.080758, 73.660008, -124.093346>,
				< -255.069223, 71.370004, -125.887459>
			}
			triangle {
				<-255.069223, 71.370004, -125.887459>,
				<-279.148027, 35.050001, -120.904563>,
				< -280.091317, 43.180001, -110.882014>
			}
			triangle {
				<-280.091317, 43.180001, -110.882014>,
				<-240.901893, 41.150004, -108.529146>,
				< -231.130860, 64.519998, -117.945818>
			}
			triangle {
				<-231.130860, 64.519998, -117.945818>,
				<-254.080758, 73.660008, -124.093346>,
				< -280.091317, 43.180001, -110.882014>
			}
			triangle {
				<-254.080758, 73.660008, -124.093346>,
				<-231.130860, 64.519998, -117.945818>,
				< -208.853987, 77.220006, -129.264122>
			}
			triangle {
				<-208.853987, 77.220006, -129.264122>,
				<-243.296092, 80.010004, -127.540280>,
				< -254.080758, 73.660008, -124.093346>
			}
			triangle {
				<-243.296092, 80.010004, -127.540280>,
				<-208.853987, 77.220006, -129.264122>,
				< -223.256202, 80.770002, -130.322367>
			}
			triangle {
				<-188.086825, 37.590002, -113.428437>,
				<-191.646824, 0.000000, -126.628447>,
				< -239.674837, 0.000000, -124.435397>
			}
			triangle {
				<-239.674837, 0.000000, -124.435397>,
				<-240.901893, 41.150004, -108.529146>,
				< -188.086825, 37.590002, -113.428437>
			}
			triangle {
				<-101.986820, 30.990000, -113.928439>,
				<-36.663132, 17.270002, -110.809897>,
				< -31.637193, 0.000000, -113.679534>
			}
			triangle {
				<-31.637193, 0.000000, -113.679534>,
				<-104.266822, 0.000000, -124.858465>,
				< -101.986820, 30.990000, -113.928439>
			}
			triangle {
				<30.523605, 7.110000, -109.682528>,
				<60.811222, 5.590000, -108.462041>,
				< 62.121480, 0.000000, -110.088503>
			}
			triangle {
				<62.121480, 0.000000, -110.088503>,
				<28.909639, 0.000000, -113.873190>,
				< 30.523605, 7.110000, -109.682528>
			}
			triangle {
				<-310.210728, 22.350002, -129.792826>,
				<-279.148027, 35.050001, -120.904563>,
				< -270.596680, 0.000000, -128.488734>
			}
			triangle {
				<-270.596680, 0.000000, -128.488734>,
				<-305.866774, 0.000000, -132.702546>,
				< -310.210728, 22.350002, -129.792826>
			}
			triangle {
				<-279.148027, 35.050001, -120.904563>,
				<-240.901893, 41.150004, -108.529146>,
				< -239.674837, 0.000000, -124.435397>
			}
			triangle {
				<-239.674837, 0.000000, -124.435397>,
				<-270.596680, 0.000000, -128.488734>,
				< -279.148027, 35.050001, -120.904563>
			}
			triangle {
				<-346.426190, 17.020001, -136.205932>,
				<-310.210728, 22.350002, -129.792826>,
				< -305.866774, 0.000000, -132.702546>
			}
			triangle {
				<-305.866774, 0.000000, -132.702546>,
				<-338.815076, 0.000000, -139.648005>,
				< -346.426190, 17.020001, -136.205932>
			}
			triangle {
				<-363.959740, 10.160000, -135.521643>,
				<-346.426190, 17.020001, -136.205932>,
				< -338.815076, 0.000000, -139.648005>
			}
			triangle {
				<-338.815076, 0.000000, -139.648005>,
				<-361.337450, 0.000000, -137.776540>,
				< -363.959740, 10.160000, -135.521643>
			}
			triangle {
				<-390.106485, 7.870000, -146.594489>,
				<-363.959740, 10.160000, -135.521643>,
				< -361.337450, 0.000000, -137.776540>
			}
			triangle {
				<-361.337450, 0.000000, -137.776540>,
				<-387.182053, 0.000000, -148.111889>,
				< -390.106485, 7.870000, -146.594489>
			}
			triangle {
				<-390.106485, 7.870000, -146.594489>,
				<-368.913718, 17.270002, -130.775117>,
				< -363.959740, 10.160000, -135.521643>
			}
			triangle {
				<-406.580751, 0.000000, -154.658008>,
				<-404.119772, 4.570000, -152.574648>,
				< -390.106485, 7.870000, -146.594489>
			}
			triangle {
				<-390.106485, 7.870000, -146.594489>,
				<-387.182053, 0.000000, -148.111889>,
				< -406.580751, 0.000000, -154.658008>
			}
			triangle {
				<140.521112, 86.610002, -111.186709>,
				<104.330616, 73.150003, -111.448594>,
				< 131.168934, 63.250003, -108.482248>
			}
			triangle {
				<92.113605, 16.510000, -94.239290>,
				<83.908982, 7.370000, -87.441562>,
				< 100.170517, 0.000000, -94.395877>
			}
			triangle {
				<100.170517, 0.000000, -94.395877>,
				<108.369436, 9.650000, -97.612239>,
				< 92.113605, 16.510000, -94.239290>
			}
			triangle {
				<108.369436, 9.650000, -97.612239>,
				<100.170517, 0.000000, -94.395877>,
				< 110.491962, 0.000000, -97.903209>
			}
			triangle {
				<110.491962, 0.000000, -97.903209>,
				<119.593584, 5.840000, -98.166797>,
				< 108.369436, 9.650000, -97.612239>
			}
			triangle {
				<77.822984, 18.290001, -88.424098>,
				<78.545748, 24.129999, -91.450539>,
				< 50.242816, 10.670001, -98.698003>
			}
			triangle {
				<50.242816, 10.670001, -98.698003>,
				<53.767442, 9.910000, -86.342159>,
				< 77.822984, 18.290001, -88.424098>
			}
			triangle {
				<50.242816, 10.670001, -98.698003>,
				<78.545748, 24.129999, -91.450539>,
				< 74.859364, 11.940000, -107.037420>
			}
			triangle {
				<-379.740010, 13.970000, -107.699346>,
				<-407.068493, 7.370000, -136.013582>,
				< -412.197426, 4.060000, -139.410524>
			}
			triangle {
				<-412.197426, 4.060000, -139.410524>,
				<-384.209823, 5.080000, -106.304416>,
				< -379.740010, 13.970000, -107.699346>
			}
			triangle {
				<-410.107562, 3.810000, -144.932524>,
				<-410.595101, 0.000000, -144.641157>,
				< -413.337221, 0.000000, -137.790588>
			}
			triangle {
				<-413.337221, 0.000000, -137.790588>,
				<-412.197426, 4.060000, -139.410524>,
				< -410.107562, 3.810000, -144.932524>
			}
			triangle {
				<-412.197426, 4.060000, -139.410524>,
				<-407.068493, 7.370000, -136.013582>,
				< -402.195662, 7.370000, -138.716369>
			}
			triangle {
				<-402.195662, 7.370000, -138.716369>,
				<-410.107562, 3.810000, -144.932524>,
				< -412.197426, 4.060000, -139.410524>
			}
			triangle {
				<-368.913718, 17.270002, -130.775117>,
				<-369.127184, 18.290001, -127.185104>,
				< -348.694415, 27.430002, -114.353028>
			}
			triangle {
				<-390.106485, 7.870000, -146.594489>,
				<-392.385988, 10.920001, -143.354618>,
				< -369.127184, 18.290001, -127.185104>
			}
			triangle {
				<-369.127184, 18.290001, -127.185104>,
				<-368.913718, 17.270002, -130.775117>,
				< -390.106485, 7.870000, -146.594489>
			}
			triangle {
				<-404.119772, 4.570000, -152.574648>,
				<-392.385988, 10.920001, -143.354618>,
				< -390.106485, 7.870000, -146.594489>
			}
			triangle {
				<-404.119772, 4.570000, -152.574648>,
				<-408.754329, 4.830000, -150.142502>,
				< -395.951021, 8.380001, -140.248754>
			}
			triangle {
				<-395.951021, 8.380001, -140.248754>,
				<-392.385988, 10.920001, -143.354618>,
				< -404.119772, 4.570000, -152.574648>
			}
			triangle {
				<-408.754329, 4.830000, -150.142502>,
				<-410.107562, 3.810000, -144.932524>,
				< -402.195662, 7.370000, -138.716369>
			}
			triangle {
				<-402.195662, 7.370000, -138.716369>,
				<-395.951021, 8.380001, -140.248754>,
				< -408.754329, 4.830000, -150.142502>
			}
			triangle {
				<-404.119772, 4.570000, -152.574648>,
				<-406.580751, 0.000000, -154.658008>,
				< -410.591986, 0.000000, -150.762449>
			}
			triangle {
				<-410.591986, 0.000000, -150.762449>,
				<-408.754329, 4.830000, -150.142502>,
				< -404.119772, 4.570000, -152.574648>
			}
			triangle {
				<-410.595101, 0.000000, -144.641157>,
				<-410.107562, 3.810000, -144.932524>,
				< -408.754329, 4.830000, -150.142502>
			}
			triangle {
				<-408.754329, 4.830000, -150.142502>,
				<-410.591986, 0.000000, -150.762449>,
				< -410.595101, 0.000000, -144.641157>
			}
			triangle {
				<-338.279160, 30.730001, -78.010683>,
				<-344.372875, 27.430002, -71.644214>,
				< -335.264294, 30.990000, -72.401083>
			}
			triangle {
				<-335.264294, 30.990000, -72.401083>,
				<-324.739508, 35.810002, -77.610513>,
				< -332.347536, 34.540004, -80.289696>
			}
			triangle {
				<-340.642117, 34.540004, -94.130386>,
				<-319.568141, 38.610003, -92.058370>,
				< -318.512348, 34.800000, -103.866341>
			}
			triangle {
				<-361.986417, 20.830001, -87.259279>,
				<-359.283125, 26.420001, -91.557900>,
				< -379.740010, 13.970000, -107.699346>
			}
			triangle {
				<-335.264294, 30.990000, -72.401083>,
				<-332.347536, 34.540004, -80.289696>,
				< -338.279160, 30.730001, -78.010683>
			}
			triangle {
				<-223.112184, 79.249999, -131.171602>,
				<-243.029663, 78.230005, -129.409841>,
				< -243.296092, 80.010004, -127.540280>
			}
			triangle {
				<-243.296092, 80.010004, -127.540280>,
				<-223.256202, 80.770002, -130.322367>,
				< -223.112184, 79.249999, -131.171602>
			}
			triangle {
				<-254.080758, 73.660008, -124.093346>,
				<-243.296092, 80.010004, -127.540280>,
				< -243.029663, 78.230005, -129.409841>
			}
			triangle {
				<-243.029663, 78.230005, -129.409841>,
				<-255.069223, 71.370004, -125.887459>,
				< -254.080758, 73.660008, -124.093346>
			}
			triangle {
				<-223.112184, 79.249999, -131.171602>,
				<-223.256202, 80.770002, -130.322367>,
				< -208.853987, 77.220006, -129.264122>
			}
			triangle {
				<-255.069223, 71.370004, -125.887459>,
				<-231.130860, 64.519998, -117.945818>,
				< -240.901893, 41.150004, -108.529146>
			}
			triangle {
				<-240.901893, 41.150004, -108.529146>,
				<-279.148027, 35.050001, -120.904563>,
				< -255.069223, 71.370004, -125.887459>
			}
			triangle {
				<-243.029663, 78.230005, -129.409841>,
				<-223.112184, 79.249999, -131.171602>,
				< -208.853987, 77.220006, -129.264122>
			}
			triangle {
				<-208.853987, 77.220006, -129.264122>,
				<-255.069223, 71.370004, -125.887459>,
				< -243.029663, 78.230005, -129.409841>
			}
			triangle {
				<-255.069223, 71.370004, -125.887459>,
				<-208.853987, 77.220006, -129.264122>,
				< -231.130860, 64.519998, -117.945818>
			}
			triangle {
				<-122.556821, 6.100000, 23.481568>,
				<-98.426822, 0.000000, 12.301575>,
				< -97.916825, 9.910000, -5.728455>
			}
			triangle {
				<-97.916825, 9.910000, -5.728455>,
				<-137.546818, 11.680000, 2.141541>,
				< -122.556821, 6.100000, 23.481568>
			}
			triangle {
				<-89.026831, 0.000000, 33.131533>,
				<-98.426822, 0.000000, 12.301575>,
				< -122.556821, 6.100000, 23.481568>
			}
			triangle {
				<-122.556821, 6.100000, 23.481568>,
				<-111.886813, 3.560000, 35.161562>,
				< -89.026831, 0.000000, 33.131533>
			}
			triangle {
				<-80.396826, 0.000000, 52.941590>,
				<-77.346817, 0.000000, 44.821535>,
				< -89.026831, 0.000000, 33.131533>
			}
			triangle {
				<-89.026831, 0.000000, 33.131533>,
				<-96.646822, 1.270000, 53.451540>,
				< -80.396826, 0.000000, 52.941590>
			}
			triangle {
				<-96.646822, 1.270000, 53.451540>,
				<-89.026831, 0.000000, 33.131533>,
				< -111.886813, 3.560000, 35.161562>
			}
			triangle {
				<-150.246826, 38.099999, -111.388463>,
				<-101.986820, 30.990000, -113.928439>,
				< -104.266822, 0.000000, -124.858465>
			}
			triangle {
				<-104.266822, 0.000000, -124.858465>,
				<-148.466834, 0.000000, -123.078429>,
				< -150.246826, 38.099999, -111.388463>
			}
			triangle {
				<-150.246826, 38.099999, -111.388463>,
				<-148.466834, 0.000000, -123.078429>,
				< -191.646824, 0.000000, -126.628447>
			}
			triangle {
				<-191.646824, 0.000000, -126.628447>,
				<-188.086825, 37.590002, -113.428437>,
				< -150.246826, 38.099999, -111.388463>
			}
			triangle {
				<30.523605, 7.110000, -109.682528>,
				<28.909639, 0.000000, -113.873190>,
				< 3.483231, 0.000000, -116.707432>
			}
			triangle {
				<3.483231, 0.000000, -116.707432>,
				<6.038300, 9.650000, -114.492149>,
				< 30.523605, 7.110000, -109.682528>
			}
			triangle {
				<3.483231, 0.000000, -116.707432>,
				<-31.637193, 0.000000, -113.679534>,
				< -36.663132, 17.270002, -110.809897>
			}
			triangle {
				<-36.663132, 17.270002, -110.809897>,
				<6.038300, 9.650000, -114.492149>,
				< 3.483231, 0.000000, -116.707432>
			}
			triangle {
				<62.121480, 0.000000, -110.088503>,
				<60.811222, 5.590000, -108.462041>,
				< 74.859364, 11.940000, -107.037420>
			}
			triangle {
				<74.859364, 11.940000, -107.037420>,
				<77.104893, 0.000000, -108.517319>,
				< 62.121480, 0.000000, -110.088503>
			}
			triangle {
				<104.525772, 73.150003, -114.022234>,
				<87.467762, 52.320003, -109.354475>,
				< 87.316850, 52.320003, -104.962484>
			}
			triangle {
				<87.316850, 52.320003, -104.962484>,
				<104.330616, 73.150003, -111.448594>,
				< 104.525772, 73.150003, -114.022234>
			}
			triangle {
				<78.545748, 24.129999, -91.450539>,
				<87.316850, 52.320003, -104.962484>,
				< 87.467762, 52.320003, -109.354475>
			}
			triangle {
				<87.467762, 52.320003, -109.354475>,
				<74.859364, 11.940000, -107.037420>,
				< 78.545748, 24.129999, -91.450539>
			}
			triangle {
				<104.525772, 73.150003, -114.022234>,
				<104.330616, 73.150003, -111.448594>,
				< 140.521112, 86.610002, -111.186709>
			}
			triangle {
				<89.816332, 0.000000, -86.501415>,
				<100.170517, 0.000000, -94.395877>,
				< 83.908982, 7.370000, -87.441562>
			}
			triangle {
				<110.491962, 0.000000, -97.903209>,
				<77.104893, 0.000000, -108.517319>,
				< 74.859364, 11.940000, -107.037420>
			}
			triangle {
				<124.750044, 21.590000, -103.242738>,
				<119.593584, 5.840000, -98.166797>,
				< 110.491962, 0.000000, -97.903209>
			}
			triangle {
				<110.491962, 0.000000, -97.903209>,
				<87.467762, 52.320003, -109.354475>,
				< 124.750044, 21.590000, -103.242738>
			}
			triangle {
				<87.467762, 52.320003, -109.354475>,
				<110.491962, 0.000000, -97.903209>,
				< 74.859364, 11.940000, -107.037420>
			}
			triangle {
				<131.168934, 63.250003, -108.482248>,
				<124.750044, 21.590000, -103.242738>,
				< 87.467762, 52.320003, -109.354475>
			}
			triangle {
				<87.467762, 52.320003, -109.354475>,
				<104.525772, 73.150003, -114.022234>,
				< 131.168934, 63.250003, -108.482248>
			}
			triangle {
				<140.521112, 86.610002, -111.186709>,
				<131.168934, 63.250003, -108.482248>,
				< 104.525772, 73.150003, -114.022234>
			}
			triangle {
				<131.168934, 63.250003, -108.482248>,
				<104.330616, 73.150003, -111.448594>,
				< 87.316850, 52.320003, -104.962484>
			}
			triangle {
				<87.316850, 52.320003, -104.962484>,
				<124.750044, 21.590000, -103.242738>,
				< 131.168934, 63.250003, -108.482248>
			}
			triangle {
				<119.593584, 5.840000, -98.166797>,
				<124.750044, 21.590000, -103.242738>,
				< 87.316850, 52.320003, -104.962484>
			}
			triangle {
				<87.316850, 52.320003, -104.962484>,
				<108.369436, 9.650000, -97.612239>,
				< 119.593584, 5.840000, -98.166797>
			}
			triangle {
				<92.113605, 16.510000, -94.239290>,
				<108.369436, 9.650000, -97.612239>,
				< 87.316850, 52.320003, -104.962484>
			}
			triangle {
				<78.545748, 24.129999, -91.450539>,
				<92.113605, 16.510000, -94.239290>,
				< 87.316850, 52.320003, -104.962484>
			}
			triangle {
				<83.908982, 7.370000, -87.441562>,
				<92.113605, 16.510000, -94.239290>,
				< 78.545748, 24.129999, -91.450539>
			}
			triangle {
				<78.545748, 24.129999, -91.450539>,
				<77.822984, 18.290001, -88.424098>,
				< 83.908982, 7.370000, -87.441562>
			}
			triangle {
				<-327.358308, 5.330000, -44.760820>,
				<-325.612470, 0.000000, -42.106308>,
				< -322.155700, 0.000000, -40.356493>
			}
			triangle {
				<-327.358308, 5.330000, -44.760820>,
				<-353.638555, 13.970000, -63.478895>,
				< -349.315833, 0.000000, -57.466204>
			}
			triangle {
				<-349.315833, 0.000000, -57.466204>,
				<-325.612470, 0.000000, -42.106308>,
				< -327.358308, 5.330000, -44.760820>
			}
			triangle {
				<-327.358308, 5.330000, -44.760820>,
				<-326.520712, 13.970000, -46.877472>,
				< -353.638555, 13.970000, -63.478895>
			}
			triangle {
				<-340.642117, 34.540004, -94.130386>,
				<-350.763567, 25.910001, -108.581871>,
				< -356.435830, 25.910001, -97.142879>
			}
			triangle {
				<-356.435830, -25.910001, -97.142879>,
				<-350.763567, -25.910001, -108.581871>,
				< -340.642117, -34.540004, -94.130386>
			}
            rotate -90*x
            rotate 90*y
            translate <0, 110, -240>
            scale dolph_scale
		}
        object {
            eye
            translate <eyex, eyey, eyez>
        }
        object {
            eye
            translate <-eyex, eyey, eyez>
        }
}

#declare Dolph03 =
    union {
		union {
			triangle {
				<124.255610, 0.000000, -207.405300>,
				<85.655613, 0.000000, -242.205307>,
				< 90.985608, -8.130001, -242.965305>
			}
			triangle {
				<90.985608, -8.130001, -242.965305>,
				<131.875609, -6.100000, -208.675310>,
				< 124.255610, 0.000000, -207.405300>
			}
			triangle {
				<157.275610, 0.000000, -191.405362>,
				<124.255610, 0.000000, -207.405300>,
				< 131.875609, -6.100000, -208.675310>
			}
			triangle {
				<131.875609, -6.100000, -208.675310>,
				<160.585608, -3.560000, -194.445267>,
				< 157.275610, 0.000000, -191.405362>
			}
			triangle {
				<188.775615, 0.000000, -189.115315>,
				<157.275610, 0.000000, -191.405362>,
				< 160.585608, -3.560000, -194.445267>
			}
			triangle {
				<160.585608, -3.560000, -194.445267>,
				<190.555607, -1.270000, -193.435326>,
				< 188.775615, 0.000000, -189.115315>
			}
			triangle {
				<206.805604, 0.000000, -193.945265>,
				<188.775615, 0.000000, -189.115315>,
				< 190.555607, -1.270000, -193.435326>
			}
			triangle {
				<199.445601, 0.000000, -259.475284>,
				<188.775615, 0.000000, -234.585294>,
				< 189.285598, -9.910000, -252.615312>
			}
			triangle {
				<131.875609, -6.100000, -208.675310>,
				<90.985608, -8.130001, -242.965305>,
				< 149.655611, -11.680000, -244.745326>
			}
			triangle {
				<149.655611, -11.680000, -244.745326>,
				<164.645608, -6.100000, -223.405296>,
				< 131.875609, -6.100000, -208.675310>
			}
			triangle {
				<160.585608, -3.560000, -194.445267>,
				<131.875609, -6.100000, -208.675310>,
				< 164.645608, -6.100000, -223.405296>
			}
			triangle {
				<164.645608, -6.100000, -223.405296>,
				<175.315623, -3.560000, -211.725297>,
				< 160.585608, -3.560000, -194.445267>
			}
			triangle {
				<190.555607, -1.270000, -193.435326>,
				<160.585608, -3.560000, -194.445267>,
				< 175.315623, -3.560000, -211.725297>
			}
			triangle {
				<-91.964084, 0.000000, -298.826769>,
				<-85.941744, -7.620000, -296.839195>,
				< -78.465489, 0.000000, -291.024401>
			}
			triangle {
				<-57.405475, 0.000000, -281.164620>,
				<-78.465489, 0.000000, -291.024401>,
				< -85.941744, -7.620000, -296.839195>
			}
			triangle {
				<-85.941744, -7.620000, -296.839195>,
				<-62.782476, -13.970000, -286.153416>,
				< -57.405475, 0.000000, -281.164620>
			}
			triangle {
				<8.182648, 0.000000, -254.260359>,
				<-28.458466, 0.000000, -269.425903>,
				< -34.135287, -5.330000, -272.862019>
			}
			triangle {
				<-34.135287, -5.330000, -272.862019>,
				<6.000183, -18.290001, -259.998998>,
				< 8.182648, 0.000000, -254.260359>
			}
			triangle {
				<6.000183, -18.290001, -259.998998>,
				<-34.135287, -5.330000, -272.862019>,
				< -33.716110, -13.970000, -275.092079>
			}
			triangle {
				<50.718706, 0.000000, -241.887329>,
				<8.182648, 0.000000, -254.260359>,
				< 6.000183, -18.290001, -259.998998>
			}
			triangle {
				<6.000183, -18.290001, -259.998998>,
				<49.216714, -22.350002, -247.035936>,
				< 50.718706, 0.000000, -241.887329>
			}
			triangle {
				<85.655613, 0.000000, -242.205307>,
				<50.718706, 0.000000, -241.887329>,
				< 49.216714, -22.350002, -247.035936>
			}
			triangle {
				<49.216714, -22.350002, -247.035936>,
				<90.985608, -8.130001, -242.965305>,
				< 85.655613, 0.000000, -242.205307>
			}
			triangle {
				<87.935614, -24.640000, -257.945307>,
				<90.985608, -8.130001, -242.965305>,
				< 49.216714, -22.350002, -247.035936>
			}
			triangle {
				<149.655611, -11.680000, -244.745326>,
				<90.985608, -8.130001, -242.965305>,
				< 87.935614, -24.640000, -257.945307>
			}
			triangle {
				<87.935614, -24.640000, -257.945307>,
				<146.105608, -26.670000, -259.475284>,
				< 149.655611, -11.680000, -244.745326>
			}
			triangle {
				<189.285598, -9.910000, -252.615312>,
				<149.655611, -11.680000, -244.745326>,
				< 146.105608, -26.670000, -259.475284>
			}
			triangle {
				<146.105608, -26.670000, -259.475284>,
				<202.235607, -20.320000, -271.415294>,
				< 189.285598, -9.910000, -252.615312>
			}
			triangle {
				<199.445601, 0.000000, -259.475284>,
				<189.285598, -9.910000, -252.615312>,
				< 202.235607, -20.320000, -271.415294>
			}
			triangle {
				<199.445601, 0.000000, -259.475284>,
				<202.235607, -20.320000, -271.415294>,
				< 250.022849, -11.680000, -274.354870>
			}
			triangle {
				<250.022849, -11.680000, -274.354870>,
				<249.065107, 0.000000, -270.231104>,
				< 199.445601, 0.000000, -259.475284>
			}
			triangle {
				<284.763865, 0.000000, -272.371681>,
				<249.065107, 0.000000, -270.231104>,
				< 250.022849, -11.680000, -274.354870>
			}
			triangle {
				<250.022849, -11.680000, -274.354870>,
				<288.582778, -14.730000, -283.436421>,
				< 284.763865, 0.000000, -272.371681>
			}
			triangle {
				<307.289037, 0.000000, -270.233066>,
				<284.763865, 0.000000, -272.371681>,
				< 288.582778, -14.730000, -283.436421>
			}
			triangle {
				<288.582778, -14.730000, -283.436421>,
				<315.724593, -11.940000, -283.423844>,
				< 307.289037, 0.000000, -270.233066>
			}
			triangle {
				<329.400056, 0.000000, -265.838572>,
				<307.289037, 0.000000, -270.233066>,
				< 315.724593, -11.940000, -283.423844>
			}
			triangle {
				<315.724593, -11.940000, -283.423844>,
				<339.392243, -7.870000, -276.360444>,
				< 329.400056, 0.000000, -265.838572>
			}
			triangle {
				<347.734999, 0.000000, -261.151457>,
				<329.400056, 0.000000, -265.838572>,
				< 339.392243, -7.870000, -276.360444>
			}
			triangle {
				<339.392243, -7.870000, -276.360444>,
				<355.077405, -9.650000, -266.337478>,
				< 347.734999, 0.000000, -261.151457>
			}
			triangle {
				<365.973276, 0.000000, -262.725050>,
				<347.734999, 0.000000, -261.151457>,
				< 355.077405, -9.650000, -266.337478>
			}
			triangle {
				<355.077405, -9.650000, -266.337478>,
				<362.663625, -7.370000, -267.799289>,
				< 365.973276, 0.000000, -262.725050>
			}
			triangle {
				<-33.716110, -13.970000, -275.092079>,
				<-62.782476, -13.970000, -286.153416>,
				< -37.718507, -22.350002, -280.565328>
			}
			triangle {
				<-33.716110, -13.970000, -275.092079>,
				<-37.718507, -22.350002, -280.565328>,
				< -22.742097, -32.770000, -285.902564>
			}
			triangle {
				<-33.716110, -13.970000, -275.092079>,
				<-22.742097, -32.770000, -285.902564>,
				< 9.035965, -29.970001, -274.985923>
			}
			triangle {
				<9.035965, -29.970001, -274.985923>,
				<6.000183, -18.290001, -259.998998>,
				< -33.716110, -13.970000, -275.092079>
			}
			triangle {
				<49.216714, -22.350002, -247.035936>,
				<6.000183, -18.290001, -259.998998>,
				< 9.035965, -29.970001, -274.985923>
			}
			triangle {
				<9.035965, -29.970001, -274.985923>,
				<46.765330, -31.999999, -265.657905>,
				< 49.216714, -22.350002, -247.035936>
			}
			triangle {
				<87.935614, -24.640000, -257.945307>,
				<49.216714, -22.350002, -247.035936>,
				< 46.765330, -31.999999, -265.657905>
			}
			triangle {
				<46.765330, -31.999999, -265.657905>,
				<87.935614, -35.810002, -275.725295>,
				< 87.935614, -24.640000, -257.945307>
			}
			triangle {
				<146.105608, -26.670000, -259.475284>,
				<87.935614, -24.640000, -257.945307>,
				< 87.935614, -35.810002, -275.725295>
			}
			triangle {
				<87.935614, -35.810002, -275.725295>,
				<138.485594, -34.040002, -276.995305>,
				< 146.105608, -26.670000, -259.475284>
			}
			triangle {
				<202.235607, -20.320000, -271.415294>,
				<146.105608, -26.670000, -259.475284>,
				< 138.485594, -34.040002, -276.995305>
			}
			triangle {
				<138.485594, -34.040002, -276.995305>,
				<198.935619, -28.450001, -284.875300>,
				< 202.235607, -20.320000, -271.415294>
			}
			triangle {
				<250.022849, -11.680000, -274.354870>,
				<202.235607, -20.320000, -271.415294>,
				< 198.935619, -28.450001, -284.875300>
			}
			triangle {
				<198.935619, -28.450001, -284.875300>,
				<251.076479, -18.290001, -281.875434>,
				< 250.022849, -11.680000, -274.354870>
			}
			triangle {
				<288.582778, -14.730000, -283.436421>,
				<250.022849, -11.680000, -274.354870>,
				< 251.076479, -18.290001, -281.875434>
			}
			triangle {
				<-46.335985, -31.750002, -291.318753>,
				<-37.083910, -36.580003, -295.484261>,
				< -22.742097, -32.770000, -285.902564>
			}
			triangle {
				<-22.742097, -32.770000, -285.902564>,
				<-37.718507, -22.350002, -280.565328>,
				< -46.335985, -31.750002, -291.318753>
			}
			triangle {
				<-55.526109, -27.430002, -296.045360>,
				<-46.335985, -31.750002, -291.318753>,
				< -37.718507, -22.350002, -280.565328>
			}
			triangle {
				<-37.718507, -22.350002, -280.565328>,
				<-62.782476, -13.970000, -286.153416>,
				< -55.526109, -27.430002, -296.045360>
			}
			triangle {
				<-76.051242, -20.830001, -307.550591>,
				<-55.526109, -27.430002, -296.045360>,
				< -62.782476, -13.970000, -286.153416>
			}
			triangle {
				<-62.782476, -13.970000, -286.153416>,
				<-85.941744, -7.620000, -296.839195>,
				< -76.051242, -20.830001, -307.550591>
			}
			triangle {
				<-94.243379, -10.160000, -316.569603>,
				<-76.051242, -20.830001, -307.550591>,
				< -85.941744, -7.620000, -296.839195>
			}
			triangle {
				<-46.815369, -30.990000, -298.573235>,
				<-37.477496, -35.810002, -305.645202>,
				< -37.083910, -36.580003, -295.484261>
			}
			triangle {
				<-37.083910, -36.580003, -295.484261>,
				<-46.335985, -31.750002, -291.318753>,
				< -46.815369, -30.990000, -298.573235>
			}
			triangle {
				<-55.526109, -27.430002, -296.045360>,
				<-46.815369, -30.990000, -298.573235>,
				< -46.335985, -31.750002, -291.318753>
			}
			triangle {
				<-94.243379, -10.160000, -316.569603>,
				<-98.474585, -13.970000, -323.189973>,
				< -76.051242, -20.830001, -307.550591>
			}
			triangle {
				<-133.625066, -7.370000, -343.074422>,
				<-129.418063, -7.370000, -347.077349>,
				< -94.919252, -14.990000, -334.566721>
			}
			triangle {
				<-94.919252, -14.990000, -334.566721>,
				<-98.474585, -13.970000, -323.189973>,
				< -133.625066, -7.370000, -343.074422>
			}
			triangle {
				<-106.069891, 0.000000, -321.921954>,
				<-140.522828, 0.000000, -342.923034>,
				< -139.838077, -4.060000, -344.814202>
			}
			triangle {
				<-139.838077, -4.060000, -344.814202>,
				<-102.578649, -5.080000, -320.707071>,
				< -106.069891, 0.000000, -321.921954>
			}
			triangle {
				<-102.578649, -5.080000, -320.707071>,
				<-94.243379, -10.160000, -316.569603>,
				< -85.941744, -7.620000, -296.839195>
			}
			triangle {
				<-85.941744, -7.620000, -296.839195>,
				<-91.964084, 0.000000, -298.826769>,
				< -102.578649, -5.080000, -320.707071>
			}
			triangle {
				<-106.069891, 0.000000, -321.921954>,
				<-102.578649, -5.080000, -320.707071>,
				< -91.964084, 0.000000, -298.826769>
			}
			triangle {
				<-50.847168, -30.730001, -303.493865>,
				<-55.526109, -27.430002, -296.045360>,
				< -60.159562, -30.480000, -308.971152>
			}
			triangle {
				<-60.159562, -30.480000, -308.971152>,
				<-59.977632, -30.730001, -311.946267>,
				< -50.847168, -30.730001, -303.493865>
			}
			triangle {
				<-55.526109, -27.430002, -296.045360>,
				<-76.051242, -20.830001, -307.550591>,
				< -74.348999, -26.420001, -312.346344>
			}
			triangle {
				<-74.348999, -26.420001, -312.346344>,
				<-60.159562, -30.480000, -308.971152>,
				< -55.526109, -27.430002, -296.045360>
			}
			triangle {
				<-59.977632, -30.730001, -311.946267>,
				<-60.159562, -30.480000, -308.971152>,
				< -74.348999, -26.420001, -312.346344>
			}
			triangle {
				<-74.348999, -26.420001, -312.346344>,
				<-72.761740, -25.910001, -318.426039>,
				< -59.977632, -30.730001, -311.946267>
			}
			triangle {
				<-72.761740, -25.910001, -318.426039>,
				<-74.348999, -26.420001, -312.346344>,
				< -98.474585, -13.970000, -323.189973>
			}
			triangle {
				<-98.474585, -13.970000, -323.189973>,
				<-94.919252, -14.990000, -334.566721>,
				< -72.761740, -25.910001, -318.426039>
			}
			triangle {
				<-92.383286, -16.260001, -339.412292>,
				<-94.919252, -14.990000, -334.566721>,
				< -129.418063, -7.370000, -347.077349>
			}
			triangle {
				<-129.418063, -7.370000, -347.077349>,
				<-123.437081, -8.380001, -350.319903>,
				< -92.383286, -16.260001, -339.412292>
			}
			triangle {
				<-72.761740, -25.910001, -318.426039>,
				<-94.919252, -14.990000, -334.566721>,
				< -92.383286, -16.260001, -339.412292>
			}
			triangle {
				<-92.383286, -16.260001, -339.412292>,
				<-69.569660, -25.910001, -330.836223>,
				< -72.761740, -25.910001, -318.426039>
			}
			triangle {
				<-56.386858, -34.540004, -318.823259>,
				<-59.977632, -30.730001, -311.946267>,
				< -72.761740, -25.910001, -318.426039>
			}
			triangle {
				<-35.954727, -34.800000, -332.596311>,
				<-56.386858, -34.540004, -318.823259>,
				< -69.569660, -25.910001, -330.836223>
			}
			triangle {
				<-69.569660, -25.910001, -330.836223>,
				<-68.715413, -27.430002, -336.922697>,
				< -35.954727, -34.800000, -332.596311>
			}
			triangle {
				<-98.474585, -13.970000, -323.189973>,
				<-94.243379, -10.160000, -316.569603>,
				< -102.578649, -5.080000, -320.707071>
			}
			triangle {
				<-50.847168, -30.730001, -303.493865>,
				<-59.977632, -30.730001, -311.946267>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-45.460023, -34.540004, -306.872432>,
				<-50.847168, -30.730001, -303.493865>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-37.477496, -35.810002, -305.645202>,
				<-45.460023, -34.540004, -306.872432>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-34.924027, -38.610003, -320.785765>,
				<-37.477496, -35.810002, -305.645202>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-56.386858, -34.540004, -318.823259>,
				<-34.924027, -38.610003, -320.785765>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-59.977632, -30.730001, -311.946267>,
				<-56.386858, -34.540004, -318.823259>,
				< -49.935288, -34.800000, -315.110791>
			}
			triangle {
				<-123.437081, -8.380001, -350.319903>,
				<-120.610967, -10.920001, -354.302464>,
				< -92.518145, -18.290001, -344.717306>
			}
			triangle {
				<-92.518145, -18.290001, -344.717306>,
				<-92.383286, -16.260001, -339.412292>,
				< -123.437081, -8.380001, -350.319903>
			}
			triangle {
				<-92.383286, -16.260001, -339.412292>,
				<-92.518145, -18.290001, -344.717306>,
				< -68.715413, -27.430002, -336.922697>
			}
			triangle {
				<-68.715413, -27.430002, -336.922697>,
				<-69.569660, -25.910001, -330.836223>,
				< -92.383286, -16.260001, -339.412292>
			}
			triangle {
				<-49.222368, -31.750002, -334.310273>,
				<-68.715413, -27.430002, -336.922697>,
				< -71.097034, -17.020001, -358.765988>
			}
			triangle {
				<-71.097034, -17.020001, -358.765988>,
				<-35.954727, -34.800000, -332.596311>,
				< -49.222368, -31.750002, -334.310273>
			}
			triangle {
				<-35.954727, -34.800000, -332.596311>,
				<-71.097034, -17.020001, -358.765988>,
				< -31.935487, -22.350002, -359.591901>
			}
			triangle {
				<-89.186310, -10.160000, -354.069152>,
				<-71.097034, -17.020001, -358.765988>,
				< -68.715413, -27.430002, -336.922697>
			}
			triangle {
				<-68.715413, -27.430002, -336.922697>,
				<-93.166477, -17.270002, -348.255597>,
				< -89.186310, -10.160000, -354.069152>
			}
			triangle {
				<2.352265, -43.180001, -345.528853>,
				<-35.954727, -34.800000, -332.596311>,
				< -31.935487, -22.350002, -359.591901>
			}
			triangle {
				<-31.935487, -22.350002, -359.591901>,
				<1.986908, -35.050001, -355.589638>,
				< 2.352265, -43.180001, -345.528853>
			}
			triangle {
				<-30.409715, -40.389999, -320.903402>,
				<-35.954727, -34.800000, -332.596311>,
				< 2.352265, -43.180001, -345.528853>
			}
			triangle {
				<2.352265, -43.180001, -345.528853>,
				<11.822602, -49.280000, -316.607363>,
				< -30.409715, -40.389999, -320.903402>
			}
			triangle {
				<-30.409715, -40.389999, -320.903402>,
				<-34.924027, -38.610003, -320.785765>,
				< -35.954727, -34.800000, -332.596311>
			}
			triangle {
				<-37.477496, -35.810002, -305.645202>,
				<-34.924027, -38.610003, -320.785765>,
				< -30.409715, -40.389999, -320.903402>
			}
			triangle {
				<-30.409715, -40.389999, -320.903402>,
				<-21.037674, -40.130003, -304.933176>,
				< -37.477496, -35.810002, -305.645202>
			}
			triangle {
				<-22.742097, -32.770000, -285.902564>,
				<-37.083910, -36.580003, -295.484261>,
				< -37.477496, -35.810002, -305.645202>
			}
			triangle {
				<-37.477496, -35.810002, -305.645202>,
				<-16.959641, -36.580003, -292.606936>,
				< -22.742097, -32.770000, -285.902564>
			}
			triangle {
				<-16.959641, -36.580003, -292.606936>,
				<-37.477496, -35.810002, -305.645202>,
				< -21.037674, -40.130003, -304.933176>
			}
			triangle {
				<13.407990, -42.670000, -292.810624>,
				<-21.037674, -40.130003, -304.933176>,
				< -30.409715, -40.389999, -320.903402>
			}
			triangle {
				<-30.409715, -40.389999, -320.903402>,
				<11.822602, -49.280000, -316.607363>,
				< 13.407990, -42.670000, -292.810624>
			}
			triangle {
				<45.420846, -46.230002, -289.126050>,
				<13.407990, -42.670000, -292.810624>,
				< 11.822602, -49.280000, -316.607363>
			}
			triangle {
				<11.822602, -49.280000, -316.607363>,
				<53.059159, -51.050000, -315.871971>,
				< 45.420846, -46.230002, -289.126050>
			}
			triangle {
				<92.505604, -48.010002, -307.475301>,
				<45.420846, -46.230002, -289.126050>,
				< 53.059159, -51.050000, -315.871971>
			}
			triangle {
				<53.059159, -51.050000, -315.871971>,
				<97.585606, -51.050000, -326.275283>,
				< 92.505604, -48.010002, -307.475301>
			}
			triangle {
				<140.515602, -46.230002, -302.395321>,
				<92.505604, -48.010002, -307.475301>,
				< 97.585606, -51.050000, -326.275283>
			}
			triangle {
				<97.585606, -51.050000, -326.275283>,
				<142.545609, -49.020000, -326.025268>,
				< 140.515602, -46.230002, -302.395321>
			}
			triangle {
				<196.395600, -43.939999, -308.495295>,
				<140.515602, -46.230002, -302.395321>,
				< 142.545609, -49.020000, -326.025268>
			}
			triangle {
				<142.545609, -49.020000, -326.025268>,
				<195.885617, -44.700004, -335.415307>,
				< 196.395600, -43.939999, -308.495295>
			}
			triangle {
				<253.540544, -33.020001, -303.030470>,
				<196.395600, -43.939999, -308.495295>,
				< 195.885617, -44.700004, -335.415307>
			}
			triangle {
				<195.885617, -44.700004, -335.415307>,
				<256.851754, -28.450001, -327.354442>,
				< 253.540544, -33.020001, -303.030470>
			}
			triangle {
				<291.288205, -23.370001, -298.850539>,
				<253.540544, -33.020001, -303.030470>,
				< 256.851754, -28.450001, -327.354442>
			}
			triangle {
				<256.851754, -28.450001, -327.354442>,
				<298.696872, -21.840001, -322.363887>,
				< 291.288205, -23.370001, -298.850539>
			}
			triangle {
				<319.902966, -13.970000, -295.218466>,
				<291.288205, -23.370001, -298.850539>,
				< 298.696872, -21.840001, -322.363887>
			}
			triangle {
				<298.696872, -21.840001, -322.363887>,
				<326.170079, -14.220000, -309.170916>,
				< 319.902966, -13.970000, -295.218466>
			}
			triangle {
				<339.296212, -9.910000, -287.567572>,
				<319.902966, -13.970000, -295.218466>,
				< 326.170079, -14.220000, -309.170916>
			}
			triangle {
				<326.170079, -14.220000, -309.170916>,
				<343.671869, -10.670001, -299.710433>,
				< 339.296212, -9.910000, -287.567572>
			}
			triangle {
				<-16.959641, -36.580003, -292.606936>,
				<-21.037674, -40.130003, -304.933176>,
				< 13.407990, -42.670000, -292.810624>
			}
			triangle {
				<9.035965, -29.970001, -274.985923>,
				<-16.959641, -36.580003, -292.606936>,
				< 13.407990, -42.670000, -292.810624>
			}
			triangle {
				<-22.742097, -32.770000, -285.902564>,
				<-16.959641, -36.580003, -292.606936>,
				< 9.035965, -29.970001, -274.985923>
			}
			triangle {
				<46.765330, -31.999999, -265.657905>,
				<9.035965, -29.970001, -274.985923>,
				< 13.407990, -42.670000, -292.810624>
			}
			triangle {
				<13.407990, -42.670000, -292.810624>,
				<45.420846, -46.230002, -289.126050>,
				< 46.765330, -31.999999, -265.657905>
			}
			triangle {
				<87.935614, -35.810002, -275.725295>,
				<46.765330, -31.999999, -265.657905>,
				< 45.420846, -46.230002, -289.126050>
			}
			triangle {
				<45.420846, -46.230002, -289.126050>,
				<92.505604, -48.010002, -307.475301>,
				< 87.935614, -35.810002, -275.725295>
			}
			triangle {
				<138.485594, -34.040002, -276.995305>,
				<87.935614, -35.810002, -275.725295>,
				< 92.505604, -48.010002, -307.475301>
			}
			triangle {
				<92.505604, -48.010002, -307.475301>,
				<140.515602, -46.230002, -302.395321>,
				< 138.485594, -34.040002, -276.995305>
			}
			triangle {
				<198.935619, -28.450001, -284.875300>,
				<138.485594, -34.040002, -276.995305>,
				< 140.515602, -46.230002, -302.395321>
			}
			triangle {
				<140.515602, -46.230002, -302.395321>,
				<196.395600, -43.939999, -308.495295>,
				< 198.935619, -28.450001, -284.875300>
			}
			triangle {
				<251.076479, -18.290001, -281.875434>,
				<198.935619, -28.450001, -284.875300>,
				< 196.395600, -43.939999, -308.495295>
			}
			triangle {
				<196.395600, -43.939999, -308.495295>,
				<253.540544, -33.020001, -303.030470>,
				< 251.076479, -18.290001, -281.875434>
			}
			triangle {
				<288.582778, -14.730000, -283.436421>,
				<251.076479, -18.290001, -281.875434>,
				< 253.540544, -33.020001, -303.030470>
			}
			triangle {
				<253.540544, -33.020001, -303.030470>,
				<291.288205, -23.370001, -298.850539>,
				< 288.582778, -14.730000, -283.436421>
			}
			triangle {
				<315.724593, -11.940000, -283.423844>,
				<288.582778, -14.730000, -283.436421>,
				< 291.288205, -23.370001, -298.850539>
			}
			triangle {
				<291.288205, -23.370001, -298.850539>,
				<319.902966, -13.970000, -295.218466>,
				< 315.724593, -11.940000, -283.423844>
			}
			triangle {
				<339.392243, -7.870000, -276.360444>,
				<315.724593, -11.940000, -283.423844>,
				< 319.902966, -13.970000, -295.218466>
			}
			triangle {
				<319.902966, -13.970000, -295.218466>,
				<339.296212, -9.910000, -287.567572>,
				< 339.392243, -7.870000, -276.360444>
			}
			triangle {
				<355.077405, -9.650000, -266.337478>,
				<339.392243, -7.870000, -276.360444>,
				< 339.296212, -9.910000, -287.567572>
			}
			triangle {
				<339.296212, -9.910000, -287.567572>,
				<359.063370, -18.290001, -272.950810>,
				< 355.077405, -9.650000, -266.337478>
			}
			triangle {
				<362.663625, -7.370000, -267.799289>,
				<355.077405, -9.650000, -266.337478>,
				< 359.063370, -18.290001, -272.950810>
			}
			triangle {
				<53.059159, -51.050000, -315.871971>,
				<11.822602, -49.280000, -316.607363>,
				< 2.352265, -43.180001, -345.528853>
			}
			triangle {
				<2.352265, -43.180001, -345.528853>,
				<43.276392, -41.150004, -347.496032>,
				< 53.059159, -51.050000, -315.871971>
			}
			triangle {
				<97.585606, -51.050000, -326.275283>,
				<53.059159, -51.050000, -315.871971>,
				< 43.276392, -41.150004, -347.496032>
			}
			triangle {
				<43.276392, -41.150004, -347.496032>,
				<99.115604, -37.590002, -360.315321>,
				< 97.585606, -51.050000, -326.275283>
			}
			triangle {
				<142.545609, -49.020000, -326.025268>,
				<97.585606, -51.050000, -326.275283>,
				< 99.115604, -37.590002, -360.315321>
			}
			triangle {
				<99.115604, -37.590002, -360.315321>,
				<136.955603, -38.099999, -358.275333>,
				< 142.545609, -49.020000, -326.025268>
			}
			triangle {
				<195.885617, -44.700004, -335.415307>,
				<142.545609, -49.020000, -326.025268>,
				< 136.955603, -38.099999, -358.275333>
			}
			triangle {
				<136.955603, -38.099999, -358.275333>,
				<185.215616, -30.990000, -360.815323>,
				< 195.885617, -44.700004, -335.415307>
			}
			triangle {
				<256.851754, -28.450001, -327.354442>,
				<195.885617, -44.700004, -335.415307>,
				< 185.215616, -30.990000, -360.815323>
			}
			triangle {
				<185.215616, -30.990000, -360.815323>,
				<257.004642, -17.270002, -348.692453>,
				< 256.851754, -28.450001, -327.354442>
			}
			triangle {
				<298.696872, -21.840001, -322.363887>,
				<256.851754, -28.450001, -327.354442>,
				< 257.004642, -17.270002, -348.692453>
			}
			triangle {
				<257.004642, -17.270002, -348.692453>,
				<307.741269, -9.650000, -338.059867>,
				< 298.696872, -21.840001, -322.363887>
			}
			triangle {
				<326.170079, -14.220000, -309.170916>,
				<298.696872, -21.840001, -322.363887>,
				< 307.741269, -9.650000, -338.059867>
			}
			triangle {
				<307.741269, -9.650000, -338.059867>,
				<331.377735, -7.110000, -320.961731>,
				< 326.170079, -14.220000, -309.170916>
			}
			triangle {
				<343.671869, -10.670001, -299.710433>,
				<326.170079, -14.220000, -309.170916>,
				< 331.377735, -7.110000, -320.961731>
			}
			triangle {
				<331.377735, -7.110000, -320.961731>,
				<358.951704, -5.590000, -300.134366>,
				< 343.671869, -10.670001, -299.710433>
			}
			triangle {
				<369.602608, -11.939999, -288.552200>,
				<343.671869, -10.670001, -299.710433>,
				< 358.951704, -5.590000, -300.134366>
			}
			triangle {
				<27.965364, -73.660008, -350.257940>,
				<2.352265, -43.180001, -345.528853>,
				< 1.986908, -35.050001, -355.589638>
			}
			triangle {
				<1.986908, -35.050001, -355.589638>,
				<26.730301, -71.370004, -351.939046>,
				< 27.965364, -73.660008, -350.257940>
			}
			triangle {
				<43.276392, -41.150004, -347.496032>,
				<2.352265, -43.180001, -345.528853>,
				< 27.965364, -73.660008, -350.257940>
			}
			triangle {
				<27.965364, -73.660008, -350.257940>,
				<52.728610, -64.519998, -346.185060>,
				< 43.276392, -41.150004, -347.496032>
			}
			triangle {
				<75.645050, -77.220006, -358.851260>,
				<52.728610, -64.519998, -346.185060>,
				< 27.965364, -73.660008, -350.257940>
			}
			triangle {
				<27.965364, -73.660008, -350.257940>,
				<60.180858, -80.770002, -359.086015>,
				< 75.645050, -77.220006, -358.851260>
			}
			triangle {
				<60.180858, -80.770002, -359.086015>,
				<27.965364, -73.660008, -350.257940>,
				< 39.048410, -80.010004, -354.738974>
			}
			triangle {
				<95.555606, 0.000000, -373.515331>,
				<99.115604, -37.590002, -360.315321>,
				< 43.276392, -41.150004, -347.496032>
			}
			triangle {
				<43.276392, -41.150004, -347.496032>,
				<43.170557, 0.000000, -363.449469>,
				< 95.555606, 0.000000, -373.515331>
			}
			triangle {
				<257.004642, -17.270002, -348.692453>,
				<185.215616, -30.990000, -360.815323>,
				< 182.935608, 0.000000, -371.745320>
			}
			triangle {
				<182.935608, 0.000000, -371.745320>,
				<263.621637, 0.000000, -350.430906>,
				< 257.004642, -17.270002, -348.692453>
			}
			triangle {
				<358.951704, -5.590000, -300.134366>,
				<331.377735, -7.110000, -320.961731>,
				< 331.958681, 0.000000, -325.493650>
			}
			triangle {
				<331.958681, 0.000000, -325.493650>,
				<361.145590, 0.000000, -300.416718>,
				< 358.951704, -5.590000, -300.134366>
			}
			triangle {
				<1.986908, -35.050001, -355.589638>,
				<-31.935487, -22.350002, -359.591901>,
				< -27.865601, 0.000000, -363.204906>
			}
			triangle {
				<-27.865601, 0.000000, -363.204906>,
				<9.998872, 0.000000, -364.219535>,
				< 1.986908, -35.050001, -355.589638>
			}
			triangle {
				<43.276392, -41.150004, -347.496032>,
				<1.986908, -35.050001, -355.589638>,
				< 9.998872, 0.000000, -364.219535>
			}
			triangle {
				<9.998872, 0.000000, -364.219535>,
				<43.170557, 0.000000, -363.449469>,
				< 43.276392, -41.150004, -347.496032>
			}
			triangle {
				<-31.935487, -22.350002, -359.591901>,
				<-71.097034, -17.020001, -358.765988>,
				< -63.855483, 0.000000, -363.769063>
			}
			triangle {
				<-63.855483, 0.000000, -363.769063>,
				<-27.865601, 0.000000, -363.204906>,
				< -31.935487, -22.350002, -359.591901>
			}
			triangle {
				<-71.097034, -17.020001, -358.765988>,
				<-89.186310, -10.160000, -354.069152>,
				< -86.994999, 0.000000, -356.888783>
			}
			triangle {
				<-86.994999, 0.000000, -356.888783>,
				<-63.855483, 0.000000, -363.769063>,
				< -71.097034, -17.020001, -358.765988>
			}
			triangle {
				<-89.186310, -10.160000, -354.069152>,
				<-119.127138, -7.870000, -358.053242>,
				< -116.493352, 0.000000, -360.316216>
			}
			triangle {
				<-116.493352, 0.000000, -360.316216>,
				<-86.994999, 0.000000, -356.888783>,
				< -89.186310, -10.160000, -354.069152>
			}
			triangle {
				<-89.186310, -10.160000, -354.069152>,
				<-93.166477, -17.270002, -348.255597>,
				< -119.127138, -7.870000, -358.053242>
			}
			triangle {
				<-135.348793, -4.570000, -359.818031>,
				<-138.509162, 0.000000, -361.087666>,
				< -116.493352, 0.000000, -360.316216>
			}
			triangle {
				<-116.493352, 0.000000, -360.316216>,
				<-119.127138, -7.870000, -358.053242>,
				< -135.348793, -4.570000, -359.818031>
			}
			triangle {
				<406.785044, -63.250003, -240.276091>,
				<394.037064, -73.150003, -266.797613>,
				< 413.337221, -86.610002, -232.496554>
			}
			triangle {
				<362.663625, -7.370000, -267.799289>,
				<373.038782, -16.510000, -266.165839>,
				< 385.791695, -9.650000, -254.917575>
			}
			triangle {
				<385.791695, -9.650000, -254.917575>,
				<378.360729, 0.000000, -259.780397>,
				< 362.663625, -7.370000, -267.799289>
			}
			triangle {
				<378.360729, 0.000000, -259.780397>,
				<385.791695, -9.650000, -254.917575>,
				< 392.535155, -5.840000, -245.460496>
			}
			triangle {
				<392.535155, -5.840000, -245.460496>,
				<387.260142, 0.000000, -253.270394>,
				< 378.360729, 0.000000, -259.780397>
			}
			triangle {
				<361.641611, -24.129999, -274.601107>,
				<359.063370, -18.290001, -272.950810>,
				< 339.296212, -9.910000, -287.567572>
			}
			triangle {
				<339.296212, -9.910000, -287.567572>,
				<343.671869, -10.670001, -299.710433>,
				< 361.641611, -24.129999, -274.601107>
			}
			triangle {
				<369.602608, -11.939999, -288.552200>,
				<361.641611, -24.129999, -274.601107>,
				< 343.671869, -10.670001, -299.710433>
			}
			triangle {
				<-133.625066, -7.370000, -343.074422>,
				<-98.474585, -13.970000, -323.189973>,
				< -102.578649, -5.080000, -320.707071>
			}
			triangle {
				<-102.578649, -5.080000, -320.707071>,
				<-139.838077, -4.060000, -344.814202>,
				< -133.625066, -7.370000, -343.074422>
			}
			triangle {
				<-139.732483, 0.000000, -350.298730>,
				<-139.317233, -3.810000, -350.723211>,
				< -139.838077, -4.060000, -344.814202>
			}
			triangle {
				<-139.838077, -4.060000, -344.814202>,
				<-140.522828, 0.000000, -342.923034>,
				< -139.732483, 0.000000, -350.298730>
			}
			triangle {
				<-133.625066, -7.370000, -343.074422>,
				<-139.838077, -4.060000, -344.814202>,
				< -139.317233, -3.810000, -350.723211>
			}
			triangle {
				<-139.317233, -3.810000, -350.723211>,
				<-129.418063, -7.370000, -347.077349>,
				< -133.625066, -7.370000, -343.074422>
			}
			triangle {
				<-68.715413, -27.430002, -336.922697>,
				<-92.518145, -18.290001, -344.717306>,
				< -93.166477, -17.270002, -348.255597>
			}
			triangle {
				<-120.610967, -10.920001, -354.302464>,
				<-119.127138, -7.870000, -358.053242>,
				< -93.166477, -17.270002, -348.255597>
			}
			triangle {
				<-93.166477, -17.270002, -348.255597>,
				<-92.518145, -18.290001, -344.717306>,
				< -120.610967, -10.920001, -354.302464>
			}
			triangle {
				<-119.127138, -7.870000, -358.053242>,
				<-120.610967, -10.920001, -354.302464>,
				< -135.348793, -4.570000, -359.818031>
			}
			triangle {
				<-139.446164, -4.830000, -356.115284>,
				<-135.348793, -4.570000, -359.818031>,
				< -120.610967, -10.920001, -354.302464>
			}
			triangle {
				<-120.610967, -10.920001, -354.302464>,
				<-123.437081, -8.380001, -350.319903>,
				< -139.446164, -4.830000, -356.115284>
			}
			triangle {
				<-139.317233, -3.810000, -350.723211>,
				<-139.446164, -4.830000, -356.115284>,
				< -123.437081, -8.380001, -350.319903>
			}
			triangle {
				<-123.437081, -8.380001, -350.319903>,
				<-129.418063, -7.370000, -347.077349>,
				< -139.317233, -3.810000, -350.723211>
			}
			triangle {
				<-138.509162, 0.000000, -361.087666>,
				<-135.348793, -4.570000, -359.818031>,
				< -139.446164, -4.830000, -356.115284>
			}
			triangle {
				<-139.446164, -4.830000, -356.115284>,
				<-141.527577, 0.000000, -356.157920>,
				< -138.509162, 0.000000, -361.087666>
			}
			triangle {
				<-139.317233, -3.810000, -350.723211>,
				<-139.732483, 0.000000, -350.298730>,
				< -141.527577, 0.000000, -356.157920>
			}
			triangle {
				<-141.527577, 0.000000, -356.157920>,
				<-139.446164, -4.830000, -356.115284>,
				< -139.317233, -3.810000, -350.723211>
			}
			triangle {
				<-46.815369, -30.990000, -298.573235>,
				<-55.526109, -27.430002, -296.045360>,
				< -50.847168, -30.730001, -303.493865>
			}
			triangle {
				<-45.460023, -34.540004, -306.872432>,
				<-37.477496, -35.810002, -305.645202>,
				< -46.815369, -30.990000, -298.573235>
			}
			triangle {
				<-35.954727, -34.800000, -332.596311>,
				<-34.924027, -38.610003, -320.785765>,
				< -56.386858, -34.540004, -318.823259>
			}
			triangle {
				<-98.474585, -13.970000, -323.189973>,
				<-74.348999, -26.420001, -312.346344>,
				< -76.051242, -20.830001, -307.550591>
			}
			triangle {
				<-50.847168, -30.730001, -303.493865>,
				<-45.460023, -34.540004, -306.872432>,
				< -46.815369, -30.990000, -298.573235>
			}
			triangle {
				<39.158363, -78.230005, -356.625180>,
				<60.276337, -79.249999, -359.943025>,
				< 60.180858, -80.770002, -359.086015>
			}
			triangle {
				<60.180858, -80.770002, -359.086015>,
				<39.048410, -80.010004, -354.738974>,
				< 39.158363, -78.230005, -356.625180>
			}
			triangle {
				<39.048410, -80.010004, -354.738974>,
				<27.965364, -73.660008, -350.257940>,
				< 26.730301, -71.370004, -351.939046>
			}
			triangle {
				<26.730301, -71.370004, -351.939046>,
				<39.158363, -78.230005, -356.625180>,
				< 39.048410, -80.010004, -354.738974>
			}
			triangle {
				<75.645050, -77.220006, -358.851260>,
				<60.180858, -80.770002, -359.086015>,
				< 60.276337, -79.249999, -359.943025>
			}
			triangle {
				<52.728610, -64.519998, -346.185060>,
				<26.730301, -71.370004, -351.939046>,
				< 1.986908, -35.050001, -355.589638>
			}
			triangle {
				<1.986908, -35.050001, -355.589638>,
				<43.276392, -41.150004, -347.496032>,
				< 52.728610, -64.519998, -346.185060>
			}
			triangle {
				<75.645050, -77.220006, -358.851260>,
				<60.276337, -79.249999, -359.943025>,
				< 39.158363, -78.230005, -356.625180>
			}
			triangle {
				<39.158363, -78.230005, -356.625180>,
				<52.728610, -64.519998, -346.185060>,
				< 75.645050, -77.220006, -358.851260>
			}
			triangle {
				<52.728610, -64.519998, -346.185060>,
				<39.158363, -78.230005, -356.625180>,
				< 26.730301, -71.370004, -351.939046>
			}
			triangle {
				<188.775615, 0.000000, -234.585294>,
				<164.645608, -6.100000, -223.405296>,
				< 149.655611, -11.680000, -244.745326>
			}
			triangle {
				<149.655611, -11.680000, -244.745326>,
				<189.285598, -9.910000, -252.615312>,
				< 188.775615, 0.000000, -234.585294>
			}
			triangle {
				<188.775615, 0.000000, -234.585294>,
				<198.175606, 0.000000, -213.755333>,
				< 175.315623, -3.560000, -211.725297>
			}
			triangle {
				<175.315623, -3.560000, -211.725297>,
				<164.645608, -6.100000, -223.405296>,
				< 188.775615, 0.000000, -234.585294>
			}
			triangle {
				<198.175606, 0.000000, -213.755333>,
				<209.855606, 0.000000, -202.065324>,
				< 206.805604, 0.000000, -193.945265>
			}
			triangle {
				<206.805604, 0.000000, -193.945265>,
				<175.315623, -3.560000, -211.725297>,
				< 198.175606, 0.000000, -213.755333>
			}
			triangle {
				<175.315623, -3.560000, -211.725297>,
				<206.805604, 0.000000, -193.945265>,
				< 190.555607, -1.270000, -193.435326>
			}
			triangle {
				<185.215616, -30.990000, -360.815323>,
				<136.955603, -38.099999, -358.275333>,
				< 138.735595, 0.000000, -369.965270>
			}
			triangle {
				<138.735595, 0.000000, -369.965270>,
				<182.935608, 0.000000, -371.745320>,
				< 185.215616, -30.990000, -360.815323>
			}
			triangle {
				<138.735595, 0.000000, -369.965270>,
				<136.955603, -38.099999, -358.275333>,
				< 99.115604, -37.590002, -360.315321>
			}
			triangle {
				<99.115604, -37.590002, -360.315321>,
				<95.555606, 0.000000, -373.515331>,
				< 138.735595, 0.000000, -369.965270>
			}
			triangle {
				<331.958681, 0.000000, -325.493650>,
				<331.377735, -7.110000, -320.961731>,
				< 307.741269, -9.650000, -338.059867>
			}
			triangle {
				<307.741269, -9.650000, -338.059867>,
				<305.789119, 0.000000, -341.259410>,
				< 331.958681, 0.000000, -325.493650>
			}
			triangle {
				<263.621637, 0.000000, -350.430906>,
				<305.789119, 0.000000, -341.259410>,
				< 307.741269, -9.650000, -338.059867>
			}
			triangle {
				<307.741269, -9.650000, -338.059867>,
				<257.004642, -17.270002, -348.692453>,
				< 263.621637, 0.000000, -350.430906>
			}
			triangle {
				<358.951704, -5.590000, -300.134366>,
				<361.145590, 0.000000, -300.416718>,
				< 372.403748, 0.000000, -287.848281>
			}
			triangle {
				<372.403748, 0.000000, -287.848281>,
				<369.602608, -11.939999, -288.552200>,
				< 358.951704, -5.590000, -300.134366>
			}
			triangle {
				<380.850295, -52.320003, -280.026989>,
				<396.182257, -73.150003, -268.169279>,
				< 394.037064, -73.150003, -266.797613>
			}
			triangle {
				<394.037064, -73.150003, -266.797613>,
				<377.520999, -52.320003, -277.203781>,
				< 380.850295, -52.320003, -280.026989>
			}
			triangle {
				<377.520999, -52.320003, -277.203781>,
				<361.641611, -24.129999, -274.601107>,
				< 369.602608, -11.939999, -288.552200>
			}
			triangle {
				<369.602608, -11.939999, -288.552200>,
				<380.850295, -52.320003, -280.026989>,
				< 377.520999, -52.320003, -277.203781>
			}
			triangle {
				<413.337221, -86.610002, -232.496554>,
				<394.037064, -73.150003, -266.797613>,
				< 396.182257, -73.150003, -268.169279>
			}
			triangle {
				<362.663625, -7.370000, -267.799289>,
				<378.360729, 0.000000, -259.780397>,
				< 365.973276, 0.000000, -262.725050>
			}
			triangle {
				<369.602608, -11.939999, -288.552200>,
				<372.403748, 0.000000, -287.848281>,
				< 387.260142, 0.000000, -253.270394>
			}
			triangle {
				<387.260142, 0.000000, -253.270394>,
				<392.535155, -5.840000, -245.460496>,
				< 399.296702, -21.590000, -243.579425>
			}
			triangle {
				<399.296702, -21.590000, -243.579425>,
				<369.602608, -11.939999, -288.552200>,
				< 387.260142, 0.000000, -253.270394>
			}
			triangle {
				<369.602608, -11.939999, -288.552200>,
				<399.296702, -21.590000, -243.579425>,
				< 380.850295, -52.320003, -280.026989>
			}
			triangle {
				<399.296702, -21.590000, -243.579425>,
				<406.785044, -63.250003, -240.276091>,
				< 396.182257, -73.150003, -268.169279>
			}
			triangle {
				<396.182257, -73.150003, -268.169279>,
				<380.850295, -52.320003, -280.026989>,
				< 399.296702, -21.590000, -243.579425>
			}
			triangle {
				<396.182257, -73.150003, -268.169279>,
				<406.785044, -63.250003, -240.276091>,
				< 413.337221, -86.610002, -232.496554>
			}
			triangle {
				<394.037064, -73.150003, -266.797613>,
				<406.785044, -63.250003, -240.276091>,
				< 399.296702, -21.590000, -243.579425>
			}
			triangle {
				<399.296702, -21.590000, -243.579425>,
				<377.520999, -52.320003, -277.203781>,
				< 394.037064, -73.150003, -266.797613>
			}
			triangle {
				<399.296702, -21.590000, -243.579425>,
				<392.535155, -5.840000, -245.460496>,
				< 385.791695, -9.650000, -254.917575>
			}
			triangle {
				<385.791695, -9.650000, -254.917575>,
				<377.520999, -52.320003, -277.203781>,
				< 399.296702, -21.590000, -243.579425>
			}
			triangle {
				<377.520999, -52.320003, -277.203781>,
				<385.791695, -9.650000, -254.917575>,
				< 373.038782, -16.510000, -266.165839>
			}
			triangle {
				<377.520999, -52.320003, -277.203781>,
				<373.038782, -16.510000, -266.165839>,
				< 361.641611, -24.129999, -274.601107>
			}
			triangle {
				<373.038782, -16.510000, -266.165839>,
				<362.663625, -7.370000, -267.799289>,
				< 359.063370, -18.290001, -272.950810>
			}
			triangle {
				<359.063370, -18.290001, -272.950810>,
				<361.641611, -24.129999, -274.601107>,
				< 373.038782, -16.510000, -266.165839>
			}
			triangle {
				<-28.458466, 0.000000, -269.425903>,
				<-32.019503, 0.000000, -270.555140>,
				< -34.135287, -5.330000, -272.862019>
			}
			triangle {
				<-62.782476, -13.970000, -286.153416>,
				<-34.135287, -5.330000, -272.862019>,
				< -32.019503, 0.000000, -270.555140>
			}
			triangle {
				<-32.019503, 0.000000, -270.555140>,
				<-57.405475, 0.000000, -281.164620>,
				< -62.782476, -13.970000, -286.153416>
			}
			triangle {
				<-62.782476, -13.970000, -286.153416>,
				<-33.716110, -13.970000, -275.092079>,
				< -34.135287, -5.330000, -272.862019>
			}
			triangle {
				<85.655613, 0.000000, -242.205307>,
				<124.255610, 0.000000, -207.405300>,
				< 131.875609, 6.100000, -208.675310>
			}
			triangle {
				<131.875609, 6.100000, -208.675310>,
				<90.985608, 8.130001, -242.965305>,
				< 85.655613, 0.000000, -242.205307>
			}
			triangle {
				<124.255610, 0.000000, -207.405300>,
				<157.275610, 0.000000, -191.405362>,
				< 160.585608, 3.560000, -194.445267>
			}
			triangle {
				<160.585608, 3.560000, -194.445267>,
				<131.875609, 6.100000, -208.675310>,
				< 124.255610, 0.000000, -207.405300>
			}
			triangle {
				<157.275610, 0.000000, -191.405362>,
				<188.775615, 0.000000, -189.115315>,
				< 190.555607, 1.270000, -193.435326>
			}
			triangle {
				<190.555607, 1.270000, -193.435326>,
				<160.585608, 3.560000, -194.445267>,
				< 157.275610, 0.000000, -191.405362>
			}
			triangle {
				<190.555607, 1.270000, -193.435326>,
				<188.775615, 0.000000, -189.115315>,
				< 206.805604, 0.000000, -193.945265>
			}
			triangle {
				<189.285598, 9.910000, -252.615312>,
				<188.775615, 0.000000, -234.585294>,
				< 199.445601, 0.000000, -259.475284>
			}
			triangle {
				<90.985608, 8.130001, -242.965305>,
				<131.875609, 6.100000, -208.675310>,
				< 164.645608, 6.100000, -223.405296>
			}
			triangle {
				<164.645608, 6.100000, -223.405296>,
				<149.655611, 11.680000, -244.745326>,
				< 90.985608, 8.130001, -242.965305>
			}
			triangle {
				<131.875609, 6.100000, -208.675310>,
				<160.585608, 3.560000, -194.445267>,
				< 175.315623, 3.560000, -211.725297>
			}
			triangle {
				<175.315623, 3.560000, -211.725297>,
				<164.645608, 6.100000, -223.405296>,
				< 131.875609, 6.100000, -208.675310>
			}
			triangle {
				<175.315623, 3.560000, -211.725297>,
				<160.585608, 3.560000, -194.445267>,
				< 190.555607, 1.270000, -193.435326>
			}
			triangle {
				<-78.465489, 0.000000, -291.024401>,
				<-85.941744, 7.620000, -296.839195>,
				< -91.964084, 0.000000, -298.826769>
			}
			triangle {
				<-78.465489, 0.000000, -291.024401>,
				<-57.405475, 0.000000, -281.164620>,
				< -62.782476, 13.970000, -286.153416>
			}
			triangle {
				<-62.782476, 13.970000, -286.153416>,
				<-85.941744, 7.620000, -296.839195>,
				< -78.465489, 0.000000, -291.024401>
			}
			triangle {
				<-34.135287, 5.330000, -272.862019>,
				<-28.458466, 0.000000, -269.425903>,
				< 8.182648, 0.000000, -254.260359>
			}
			triangle {
				<8.182648, 0.000000, -254.260359>,
				<-33.716110, 13.970000, -275.092079>,
				< -34.135287, 5.330000, -272.862019>
			}
			triangle {
				<-33.716110, 13.970000, -275.092079>,
				<8.182648, 0.000000, -254.260359>,
				< 6.000183, 18.290001, -259.998998>
			}
			triangle {
				<8.182648, 0.000000, -254.260359>,
				<50.718706, 0.000000, -241.887329>,
				< 49.216714, 22.350002, -247.035936>
			}
			triangle {
				<49.216714, 22.350002, -247.035936>,
				<6.000183, 18.290001, -259.998998>,
				< 8.182648, 0.000000, -254.260359>
			}
			triangle {
				<50.718706, 0.000000, -241.887329>,
				<85.655613, 0.000000, -242.205307>,
				< 90.985608, 8.130001, -242.965305>
			}
			triangle {
				<90.985608, 8.130001, -242.965305>,
				<49.216714, 22.350002, -247.035936>,
				< 50.718706, 0.000000, -241.887329>
			}
			triangle {
				<49.216714, 22.350002, -247.035936>,
				<90.985608, 8.130001, -242.965305>,
				< 87.935614, 24.640000, -257.945307>
			}
			triangle {
				<90.985608, 8.130001, -242.965305>,
				<149.655611, 11.680000, -244.745326>,
				< 146.105608, 26.670000, -259.475284>
			}
			triangle {
				<146.105608, 26.670000, -259.475284>,
				<87.935614, 24.640000, -257.945307>,
				< 90.985608, 8.130001, -242.965305>
			}
			triangle {
				<149.655611, 11.680000, -244.745326>,
				<189.285598, 9.910000, -252.615312>,
				< 202.235607, 20.320000, -271.415294>
			}
			triangle {
				<202.235607, 20.320000, -271.415294>,
				<146.105608, 26.670000, -259.475284>,
				< 149.655611, 11.680000, -244.745326>
			}
			triangle {
				<202.235607, 20.320000, -271.415294>,
				<189.285598, 9.910000, -252.615312>,
				< 199.445601, 0.000000, -259.475284>
			}
			triangle {
				<202.235607, 20.320000, -271.415294>,
				<199.445601, 0.000000, -259.475284>,
				< 249.065107, 0.000000, -270.231104>
			}
			triangle {
				<249.065107, 0.000000, -270.231104>,
				<250.022849, 11.680000, -274.354870>,
				< 202.235607, 20.320000, -271.415294>
			}
			triangle {
				<249.065107, 0.000000, -270.231104>,
				<284.763865, 0.000000, -272.371681>,
				< 288.582778, 14.730000, -283.436421>
			}
			triangle {
				<288.582778, 14.730000, -283.436421>,
				<250.022849, 11.680000, -274.354870>,
				< 249.065107, 0.000000, -270.231104>
			}
			triangle {
				<284.763865, 0.000000, -272.371681>,
				<307.289037, 0.000000, -270.233066>,
				< 315.724593, 11.940000, -283.423844>
			}
			triangle {
				<315.724593, 11.940000, -283.423844>,
				<288.582778, 14.730000, -283.436421>,
				< 284.763865, 0.000000, -272.371681>
			}
			triangle {
				<307.289037, 0.000000, -270.233066>,
				<329.400056, 0.000000, -265.838572>,
				< 339.392243, 7.870000, -276.360444>
			}
			triangle {
				<339.392243, 7.870000, -276.360444>,
				<315.724593, 11.940000, -283.423844>,
				< 307.289037, 0.000000, -270.233066>
			}
			triangle {
				<329.400056, 0.000000, -265.838572>,
				<347.734999, 0.000000, -261.151457>,
				< 355.077405, 9.650000, -266.337478>
			}
			triangle {
				<355.077405, 9.650000, -266.337478>,
				<339.392243, 7.870000, -276.360444>,
				< 329.400056, 0.000000, -265.838572>
			}
			triangle {
				<347.734999, 0.000000, -261.151457>,
				<365.973276, 0.000000, -262.725050>,
				< 362.663625, 7.370000, -267.799289>
			}
			triangle {
				<362.663625, 7.370000, -267.799289>,
				<355.077405, 9.650000, -266.337478>,
				< 347.734999, 0.000000, -261.151457>
			}
			triangle {
				<-37.718507, 22.350002, -280.565328>,
				<-62.782476, 13.970000, -286.153416>,
				< -33.716110, 13.970000, -275.092079>
			}
			triangle {
				<-22.742097, 32.770000, -285.902564>,
				<-37.718507, 22.350002, -280.565328>,
				< -33.716110, 13.970000, -275.092079>
			}
			triangle {
				<-22.742097, 32.770000, -285.902564>,
				<-33.716110, 13.970000, -275.092079>,
				< 6.000183, 18.290001, -259.998998>
			}
			triangle {
				<6.000183, 18.290001, -259.998998>,
				<9.035965, 29.970001, -274.985923>,
				< -22.742097, 32.770000, -285.902564>
			}
			triangle {
				<6.000183, 18.290001, -259.998998>,
				<49.216714, 22.350002, -247.035936>,
				< 46.765330, 31.999999, -265.657905>
			}
			triangle {
				<46.765330, 31.999999, -265.657905>,
				<9.035965, 29.970001, -274.985923>,
				< 6.000183, 18.290001, -259.998998>
			}
			triangle {
				<49.216714, 22.350002, -247.035936>,
				<87.935614, 24.640000, -257.945307>,
				< 87.935614, 35.810002, -275.725295>
			}
			triangle {
				<87.935614, 35.810002, -275.725295>,
				<46.765330, 31.999999, -265.657905>,
				< 49.216714, 22.350002, -247.035936>
			}
			triangle {
				<87.935614, 24.640000, -257.945307>,
				<146.105608, 26.670000, -259.475284>,
				< 138.485594, 34.040002, -276.995305>
			}
			triangle {
				<138.485594, 34.040002, -276.995305>,
				<87.935614, 35.810002, -275.725295>,
				< 87.935614, 24.640000, -257.945307>
			}
			triangle {
				<146.105608, 26.670000, -259.475284>,
				<202.235607, 20.320000, -271.415294>,
				< 198.935619, 28.450001, -284.875300>
			}
			triangle {
				<198.935619, 28.450001, -284.875300>,
				<138.485594, 34.040002, -276.995305>,
				< 146.105608, 26.670000, -259.475284>
			}
			triangle {
				<202.235607, 20.320000, -271.415294>,
				<250.022849, 11.680000, -274.354870>,
				< 251.076479, 18.290001, -281.875434>
			}
			triangle {
				<251.076479, 18.290001, -281.875434>,
				<198.935619, 28.450001, -284.875300>,
				< 202.235607, 20.320000, -271.415294>
			}
			triangle {
				<251.076479, 18.290001, -281.875434>,
				<250.022849, 11.680000, -274.354870>,
				< 288.582778, 14.730000, -283.436421>
			}
			triangle {
				<-37.083910, 36.580003, -295.484261>,
				<-46.335985, 31.750002, -291.318753>,
				< -37.718507, 22.350002, -280.565328>
			}
			triangle {
				<-37.718507, 22.350002, -280.565328>,
				<-22.742097, 32.770000, -285.902564>,
				< -37.083910, 36.580003, -295.484261>
			}
			triangle {
				<-46.335985, 31.750002, -291.318753>,
				<-55.526109, 27.430002, -296.045360>,
				< -62.782476, 13.970000, -286.153416>
			}
			triangle {
				<-62.782476, 13.970000, -286.153416>,
				<-37.718507, 22.350002, -280.565328>,
				< -46.335985, 31.750002, -291.318753>
			}
			triangle {
				<-62.782476, 13.970000, -286.153416>,
				<-55.526109, 27.430002, -296.045360>,
				< -76.051242, 20.830001, -307.550591>
			}
			triangle {
				<-76.051242, 20.830001, -307.550591>,
				<-85.941744, 7.620000, -296.839195>,
				< -62.782476, 13.970000, -286.153416>
			}
			triangle {
				<-85.941744, 7.620000, -296.839195>,
				<-76.051242, 20.830001, -307.550591>,
				< -94.243379, 10.160000, -316.569603>
			}
			triangle {
				<-37.477496, 35.810002, -305.645202>,
				<-46.815369, 30.990000, -298.573235>,
				< -46.335985, 31.750002, -291.318753>
			}
			triangle {
				<-46.335985, 31.750002, -291.318753>,
				<-37.083910, 36.580003, -295.484261>,
				< -37.477496, 35.810002, -305.645202>
			}
			triangle {
				<-46.335985, 31.750002, -291.318753>,
				<-46.815369, 30.990000, -298.573235>,
				< -55.526109, 27.430002, -296.045360>
			}
			triangle {
				<-76.051242, 20.830001, -307.550591>,
				<-98.474585, 13.970000, -323.189973>,
				< -94.243379, 10.160000, -316.569603>
			}
			triangle {
				<-129.418063, 7.370000, -347.077349>,
				<-133.625066, 7.370000, -343.074422>,
				< -98.474585, 13.970000, -323.189973>
			}
			triangle {
				<-98.474585, 13.970000, -323.189973>,
				<-94.919252, 14.990000, -334.566721>,
				< -129.418063, 7.370000, -347.077349>
			}
			triangle {
				<-140.522828, 0.000000, -342.923034>,
				<-106.069891, 0.000000, -321.921954>,
				< -102.578649, 5.080000, -320.707071>
			}
			triangle {
				<-102.578649, 5.080000, -320.707071>,
				<-139.838077, 4.060000, -344.814202>,
				< -140.522828, 0.000000, -342.923034>
			}
			triangle {
				<-94.243379, 10.160000, -316.569603>,
				<-102.578649, 5.080000, -320.707071>,
				< -91.964084, 0.000000, -298.826769>
			}
			triangle {
				<-91.964084, 0.000000, -298.826769>,
				<-85.941744, 7.620000, -296.839195>,
				< -94.243379, 10.160000, -316.569603>
			}
			triangle {
				<-91.964084, 0.000000, -298.826769>,
				<-102.578649, 5.080000, -320.707071>,
				< -106.069891, 0.000000, -321.921954>
			}
			triangle {
				<-55.526109, 27.430002, -296.045360>,
				<-50.847168, 30.730001, -303.493865>,
				< -59.977632, 30.730001, -311.946267>
			}
			triangle {
				<-59.977632, 30.730001, -311.946267>,
				<-60.159562, 30.480000, -308.971152>,
				< -55.526109, 27.430002, -296.045360>
			}
			triangle {
				<-76.051242, 20.830001, -307.550591>,
				<-55.526109, 27.430002, -296.045360>,
				< -60.159562, 30.480000, -308.971152>
			}
			triangle {
				<-60.159562, 30.480000, -308.971152>,
				<-74.348999, 26.420001, -312.346344>,
				< -76.051242, 20.830001, -307.550591>
			}
			triangle {
				<-60.159562, 30.480000, -308.971152>,
				<-59.977632, 30.730001, -311.946267>,
				< -72.761740, 25.910001, -318.426039>
			}
			triangle {
				<-72.761740, 25.910001, -318.426039>,
				<-74.348999, 26.420001, -312.346344>,
				< -60.159562, 30.480000, -308.971152>
			}
			triangle {
				<-74.348999, 26.420001, -312.346344>,
				<-72.761740, 25.910001, -318.426039>,
				< -94.919252, 14.990000, -334.566721>
			}
			triangle {
				<-94.919252, 14.990000, -334.566721>,
				<-98.474585, 13.970000, -323.189973>,
				< -74.348999, 26.420001, -312.346344>
			}
			triangle {
				<-94.919252, 14.990000, -334.566721>,
				<-92.383286, 16.260001, -339.412292>,
				< -123.437081, 8.380001, -350.319903>
			}
			triangle {
				<-123.437081, 8.380001, -350.319903>,
				<-129.418063, 7.370000, -347.077349>,
				< -94.919252, 14.990000, -334.566721>
			}
			triangle {
				<-94.919252, 14.990000, -334.566721>,
				<-72.761740, 25.910001, -318.426039>,
				< -69.569660, 25.910001, -330.836223>
			}
			triangle {
				<-69.569660, 25.910001, -330.836223>,
				<-92.383286, 16.260001, -339.412292>,
				< -94.919252, 14.990000, -334.566721>
			}
			triangle {
				<-72.761740, 25.910001, -318.426039>,
				<-59.977632, 30.730001, -311.946267>,
				< -56.386858, 34.540004, -318.823259>
			}
			triangle {
				<-56.386858, 34.540004, -318.823259>,
				<-35.954727, 34.800000, -332.596311>,
				< -68.715413, 27.430002, -336.922697>
			}
			triangle {
				<-68.715413, 27.430002, -336.922697>,
				<-69.569660, 25.910001, -330.836223>,
				< -56.386858, 34.540004, -318.823259>
			}
			triangle {
				<-102.578649, 5.080000, -320.707071>,
				<-94.243379, 10.160000, -316.569603>,
				< -98.474585, 13.970000, -323.189973>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-59.977632, 30.730001, -311.946267>,
				< -50.847168, 30.730001, -303.493865>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-50.847168, 30.730001, -303.493865>,
				< -45.460023, 34.540004, -306.872432>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-45.460023, 34.540004, -306.872432>,
				< -37.477496, 35.810002, -305.645202>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-37.477496, 35.810002, -305.645202>,
				< -34.924027, 38.610003, -320.785765>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-34.924027, 38.610003, -320.785765>,
				< -56.386858, 34.540004, -318.823259>
			}
			triangle {
				<-49.935288, 34.800000, -315.110791>,
				<-56.386858, 34.540004, -318.823259>,
				< -59.977632, 30.730001, -311.946267>
			}
			triangle {
				<-120.610967, 10.920001, -354.302464>,
				<-123.437081, 8.380001, -350.319903>,
				< -92.383286, 16.260001, -339.412292>
			}
			triangle {
				<-92.383286, 16.260001, -339.412292>,
				<-92.518145, 18.290001, -344.717306>,
				< -120.610967, 10.920001, -354.302464>
			}
			triangle {
				<-92.518145, 18.290001, -344.717306>,
				<-92.383286, 16.260001, -339.412292>,
				< -69.569660, 25.910001, -330.836223>
			}
			triangle {
				<-69.569660, 25.910001, -330.836223>,
				<-68.715413, 27.430002, -336.922697>,
				< -92.518145, 18.290001, -344.717306>
			}
			triangle {
				<-71.097034, 17.020001, -358.765988>,
				<-68.715413, 27.430002, -336.922697>,
				< -49.222368, 31.750002, -334.310273>
			}
			triangle {
				<-49.222368, 31.750002, -334.310273>,
				<-31.935487, 22.350002, -359.591901>,
				< -71.097034, 17.020001, -358.765988>
			}
			triangle {
				<-31.935487, 22.350002, -359.591901>,
				<-49.222368, 31.750002, -334.310273>,
				< -35.954727, 34.800000, -332.596311>
			}
			triangle {
				<-71.097034, 17.020001, -358.765988>,
				<-89.186310, 10.160000, -354.069152>,
				< -93.166477, 17.270002, -348.255597>
			}
			triangle {
				<-93.166477, 17.270002, -348.255597>,
				<-68.715413, 27.430002, -336.922697>,
				< -71.097034, 17.020001, -358.765988>
			}
			triangle {
				<-35.954727, 34.800000, -332.596311>,
				<2.352265, 43.180001, -345.528853>,
				< 1.986908, 35.050001, -355.589638>
			}
			triangle {
				<1.986908, 35.050001, -355.589638>,
				<-31.935487, 22.350002, -359.591901>,
				< -35.954727, 34.800000, -332.596311>
			}
			triangle {
				<-35.954727, 34.800000, -332.596311>,
				<-30.409715, 40.389999, -320.903402>,
				< 11.822602, 49.280000, -316.607363>
			}
			triangle {
				<11.822602, 49.280000, -316.607363>,
				<2.352265, 43.180001, -345.528853>,
				< -35.954727, 34.800000, -332.596311>
			}
			triangle {
				<-35.954727, 34.800000, -332.596311>,
				<-34.924027, 38.610003, -320.785765>,
				< -30.409715, 40.389999, -320.903402>
			}
			triangle {
				<-34.924027, 38.610003, -320.785765>,
				<-37.477496, 35.810002, -305.645202>,
				< -21.037674, 40.130003, -304.933176>
			}
			triangle {
				<-21.037674, 40.130003, -304.933176>,
				<-30.409715, 40.389999, -320.903402>,
				< -34.924027, 38.610003, -320.785765>
			}
			triangle {
				<-37.477496, 35.810002, -305.645202>,
				<-37.083910, 36.580003, -295.484261>,
				< -22.742097, 32.770000, -285.902564>
			}
			triangle {
				<-22.742097, 32.770000, -285.902564>,
				<-21.037674, 40.130003, -304.933176>,
				< -37.477496, 35.810002, -305.645202>
			}
			triangle {
				<-21.037674, 40.130003, -304.933176>,
				<-22.742097, 32.770000, -285.902564>,
				< -16.959641, 36.580003, -292.606936>
			}
			triangle {
				<-21.037674, 40.130003, -304.933176>,
				<13.407990, 42.670000, -292.810624>,
				< 11.822602, 49.280000, -316.607363>
			}
			triangle {
				<11.822602, 49.280000, -316.607363>,
				<-30.409715, 40.389999, -320.903402>,
				< -21.037674, 40.130003, -304.933176>
			}
			triangle {
				<13.407990, 42.670000, -292.810624>,
				<45.420846, 46.230002, -289.126050>,
				< 53.059159, 51.050000, -315.871971>
			}
			triangle {
				<53.059159, 51.050000, -315.871971>,
				<11.822602, 49.280000, -316.607363>,
				< 13.407990, 42.670000, -292.810624>
			}
			triangle {
				<45.420846, 46.230002, -289.126050>,
				<92.505604, 48.010002, -307.475301>,
				< 97.585606, 51.050000, -326.275283>
			}
			triangle {
				<97.585606, 51.050000, -326.275283>,
				<53.059159, 51.050000, -315.871971>,
				< 45.420846, 46.230002, -289.126050>
			}
			triangle {
				<92.505604, 48.010002, -307.475301>,
				<140.515602, 46.230002, -302.395321>,
				< 142.545609, 49.020000, -326.025268>
			}
			triangle {
				<142.545609, 49.020000, -326.025268>,
				<97.585606, 51.050000, -326.275283>,
				< 92.505604, 48.010002, -307.475301>
			}
			triangle {
				<140.515602, 46.230002, -302.395321>,
				<196.395600, 43.939999, -308.495295>,
				< 195.885617, 44.700004, -335.415307>
			}
			triangle {
				<195.885617, 44.700004, -335.415307>,
				<142.545609, 49.020000, -326.025268>,
				< 140.515602, 46.230002, -302.395321>
			}
			triangle {
				<196.395600, 43.939999, -308.495295>,
				<253.540544, 33.020001, -303.030470>,
				< 256.851754, 28.450001, -327.354442>
			}
			triangle {
				<256.851754, 28.450001, -327.354442>,
				<195.885617, 44.700004, -335.415307>,
				< 196.395600, 43.939999, -308.495295>
			}
			triangle {
				<253.540544, 33.020001, -303.030470>,
				<291.288205, 23.370001, -298.850539>,
				< 298.696872, 21.840001, -322.363887>
			}
			triangle {
				<298.696872, 21.840001, -322.363887>,
				<256.851754, 28.450001, -327.354442>,
				< 253.540544, 33.020001, -303.030470>
			}
			triangle {
				<291.288205, 23.370001, -298.850539>,
				<319.902966, 13.970000, -295.218466>,
				< 326.170079, 14.220000, -309.170916>
			}
			triangle {
				<326.170079, 14.220000, -309.170916>,
				<298.696872, 21.840001, -322.363887>,
				< 291.288205, 23.370001, -298.850539>
			}
			triangle {
				<319.902966, 13.970000, -295.218466>,
				<339.296212, 9.910000, -287.567572>,
				< 343.671869, 10.670001, -299.710433>
			}
			triangle {
				<343.671869, 10.670001, -299.710433>,
				<326.170079, 14.220000, -309.170916>,
				< 319.902966, 13.970000, -295.218466>
			}
			triangle {
				<13.407990, 42.670000, -292.810624>,
				<-21.037674, 40.130003, -304.933176>,
				< -16.959641, 36.580003, -292.606936>
			}
			triangle {
				<13.407990, 42.670000, -292.810624>,
				<-16.959641, 36.580003, -292.606936>,
				< 9.035965, 29.970001, -274.985923>
			}
			triangle {
				<9.035965, 29.970001, -274.985923>,
				<-16.959641, 36.580003, -292.606936>,
				< -22.742097, 32.770000, -285.902564>
			}
			triangle {
				<9.035965, 29.970001, -274.985923>,
				<46.765330, 31.999999, -265.657905>,
				< 45.420846, 46.230002, -289.126050>
			}
			triangle {
				<45.420846, 46.230002, -289.126050>,
				<13.407990, 42.670000, -292.810624>,
				< 9.035965, 29.970001, -274.985923>
			}
			triangle {
				<46.765330, 31.999999, -265.657905>,
				<87.935614, 35.810002, -275.725295>,
				< 92.505604, 48.010002, -307.475301>
			}
			triangle {
				<92.505604, 48.010002, -307.475301>,
				<45.420846, 46.230002, -289.126050>,
				< 46.765330, 31.999999, -265.657905>
			}
			triangle {
				<87.935614, 35.810002, -275.725295>,
				<138.485594, 34.040002, -276.995305>,
				< 140.515602, 46.230002, -302.395321>
			}
			triangle {
				<140.515602, 46.230002, -302.395321>,
				<92.505604, 48.010002, -307.475301>,
				< 87.935614, 35.810002, -275.725295>
			}
			triangle {
				<138.485594, 34.040002, -276.995305>,
				<198.935619, 28.450001, -284.875300>,
				< 196.395600, 43.939999, -308.495295>
			}
			triangle {
				<196.395600, 43.939999, -308.495295>,
				<140.515602, 46.230002, -302.395321>,
				< 138.485594, 34.040002, -276.995305>
			}
			triangle {
				<198.935619, 28.450001, -284.875300>,
				<251.076479, 18.290001, -281.875434>,
				< 253.540544, 33.020001, -303.030470>
			}
			triangle {
				<253.540544, 33.020001, -303.030470>,
				<196.395600, 43.939999, -308.495295>,
				< 198.935619, 28.450001, -284.875300>
			}
			triangle {
				<251.076479, 18.290001, -281.875434>,
				<288.582778, 14.730000, -283.436421>,
				< 291.288205, 23.370001, -298.850539>
			}
			triangle {
				<291.288205, 23.370001, -298.850539>,
				<253.540544, 33.020001, -303.030470>,
				< 251.076479, 18.290001, -281.875434>
			}
			triangle {
				<288.582778, 14.730000, -283.436421>,
				<315.724593, 11.940000, -283.423844>,
				< 319.902966, 13.970000, -295.218466>
			}
			triangle {
				<319.902966, 13.970000, -295.218466>,
				<291.288205, 23.370001, -298.850539>,
				< 288.582778, 14.730000, -283.436421>
			}
			triangle {
				<315.724593, 11.940000, -283.423844>,
				<339.392243, 7.870000, -276.360444>,
				< 339.296212, 9.910000, -287.567572>
			}
			triangle {
				<339.296212, 9.910000, -287.567572>,
				<319.902966, 13.970000, -295.218466>,
				< 315.724593, 11.940000, -283.423844>
			}
			triangle {
				<339.392243, 7.870000, -276.360444>,
				<355.077405, 9.650000, -266.337478>,
				< 359.063370, 18.290001, -272.950810>
			}
			triangle {
				<359.063370, 18.290001, -272.950810>,
				<339.296212, 9.910000, -287.567572>,
				< 339.392243, 7.870000, -276.360444>
			}
			triangle {
				<359.063370, 18.290001, -272.950810>,
				<355.077405, 9.650000, -266.337478>,
				< 362.663625, 7.370000, -267.799289>
			}
			triangle {
				<11.822602, 49.280000, -316.607363>,
				<53.059159, 51.050000, -315.871971>,
				< 43.276392, 41.150004, -347.496032>
			}
			triangle {
				<43.276392, 41.150004, -347.496032>,
				<2.352265, 43.180001, -345.528853>,
				< 11.822602, 49.280000, -316.607363>
			}
			triangle {
				<53.059159, 51.050000, -315.871971>,
				<97.585606, 51.050000, -326.275283>,
				< 99.115604, 37.590002, -360.315321>
			}
			triangle {
				<99.115604, 37.590002, -360.315321>,
				<43.276392, 41.150004, -347.496032>,
				< 53.059159, 51.050000, -315.871971>
			}
			triangle {
				<97.585606, 51.050000, -326.275283>,
				<142.545609, 49.020000, -326.025268>,
				< 136.955603, 38.099999, -358.275333>
			}
			triangle {
				<136.955603, 38.099999, -358.275333>,
				<99.115604, 37.590002, -360.315321>,
				< 97.585606, 51.050000, -326.275283>
			}
			triangle {
				<142.545609, 49.020000, -326.025268>,
				<195.885617, 44.700004, -335.415307>,
				< 185.215616, 30.990000, -360.815323>
			}
			triangle {
				<185.215616, 30.990000, -360.815323>,
				<136.955603, 38.099999, -358.275333>,
				< 142.545609, 49.020000, -326.025268>
			}
			triangle {
				<195.885617, 44.700004, -335.415307>,
				<256.851754, 28.450001, -327.354442>,
				< 257.004642, 17.270002, -348.692453>
			}
			triangle {
				<257.004642, 17.270002, -348.692453>,
				<185.215616, 30.990000, -360.815323>,
				< 195.885617, 44.700004, -335.415307>
			}
			triangle {
				<256.851754, 28.450001, -327.354442>,
				<298.696872, 21.840001, -322.363887>,
				< 307.741269, 9.650000, -338.059867>
			}
			triangle {
				<307.741269, 9.650000, -338.059867>,
				<257.004642, 17.270002, -348.692453>,
				< 256.851754, 28.450001, -327.354442>
			}
			triangle {
				<298.696872, 21.840001, -322.363887>,
				<326.170079, 14.220000, -309.170916>,
				< 331.377735, 7.110000, -320.961731>
			}
			triangle {
				<331.377735, 7.110000, -320.961731>,
				<307.741269, 9.650000, -338.059867>,
				< 298.696872, 21.840001, -322.363887>
			}
			triangle {
				<326.170079, 14.220000, -309.170916>,
				<343.671869, 10.670001, -299.710433>,
				< 358.951704, 5.590000, -300.134366>
			}
			triangle {
				<358.951704, 5.590000, -300.134366>,
				<331.377735, 7.110000, -320.961731>,
				< 326.170079, 14.220000, -309.170916>
			}
			triangle {
				<358.951704, 5.590000, -300.134366>,
				<343.671869, 10.670001, -299.710433>,
				< 369.602608, 11.940000, -288.552200>
			}
			triangle {
				<2.352265, 43.180001, -345.528853>,
				<27.965364, 73.660008, -350.257940>,
				< 26.730301, 71.370004, -351.939046>
			}
			triangle {
				<26.730301, 71.370004, -351.939046>,
				<1.986908, 35.050001, -355.589638>,
				< 2.352265, 43.180001, -345.528853>
			}
			triangle {
				<2.352265, 43.180001, -345.528853>,
				<43.276392, 41.150004, -347.496032>,
				< 52.728610, 64.519998, -346.185060>
			}
			triangle {
				<52.728610, 64.519998, -346.185060>,
				<27.965364, 73.660008, -350.257940>,
				< 2.352265, 43.180001, -345.528853>
			}
			triangle {
				<27.965364, 73.660008, -350.257940>,
				<52.728610, 64.519998, -346.185060>,
				< 75.645050, 77.220006, -358.851260>
			}
			triangle {
				<75.645050, 77.220006, -358.851260>,
				<39.048410, 80.010004, -354.738974>,
				< 27.965364, 73.660008, -350.257940>
			}
			triangle {
				<39.048410, 80.010004, -354.738974>,
				<75.645050, 77.220006, -358.851260>,
				< 60.180858, 80.770002, -359.086015>
			}
			triangle {
				<99.115604, 37.590002, -360.315321>,
				<95.555606, 0.000000, -373.515331>,
				< 43.170557, 0.000000, -363.449469>
			}
			triangle {
				<43.170557, 0.000000, -363.449469>,
				<43.276392, 41.150004, -347.496032>,
				< 99.115604, 37.590002, -360.315321>
			}
			triangle {
				<185.215616, 30.990000, -360.815323>,
				<257.004642, 17.270002, -348.692453>,
				< 263.621637, 0.000000, -350.430906>
			}
			triangle {
				<263.621637, 0.000000, -350.430906>,
				<182.935608, 0.000000, -371.745320>,
				< 185.215616, 30.990000, -360.815323>
			}
			triangle {
				<331.377735, 7.110000, -320.961731>,
				<358.951704, 5.590000, -300.134366>,
				< 361.145590, 0.000000, -300.416718>
			}
			triangle {
				<361.145590, 0.000000, -300.416718>,
				<331.958681, 0.000000, -325.493650>,
				< 331.377735, 7.110000, -320.961731>
			}
			triangle {
				<-31.935487, 22.350002, -359.591901>,
				<1.986908, 35.050001, -355.589638>,
				< 9.998872, 0.000000, -364.219535>
			}
			triangle {
				<9.998872, 0.000000, -364.219535>,
				<-27.865601, 0.000000, -363.204906>,
				< -31.935487, 22.350002, -359.591901>
			}
			triangle {
				<1.986908, 35.050001, -355.589638>,
				<43.276392, 41.150004, -347.496032>,
				< 43.170557, 0.000000, -363.449469>
			}
			triangle {
				<43.170557, 0.000000, -363.449469>,
				<9.998872, 0.000000, -364.219535>,
				< 1.986908, 35.050001, -355.589638>
			}
			triangle {
				<-71.097034, 17.020001, -358.765988>,
				<-31.935487, 22.350002, -359.591901>,
				< -27.865601, 0.000000, -363.204906>
			}
			triangle {
				<-27.865601, 0.000000, -363.204906>,
				<-63.855483, 0.000000, -363.769063>,
				< -71.097034, 17.020001, -358.765988>
			}
			triangle {
				<-89.186310, 10.160000, -354.069152>,
				<-71.097034, 17.020001, -358.765988>,
				< -63.855483, 0.000000, -363.769063>
			}
			triangle {
				<-63.855483, 0.000000, -363.769063>,
				<-86.994999, 0.000000, -356.888783>,
				< -89.186310, 10.160000, -354.069152>
			}
			triangle {
				<-119.127138, 7.870000, -358.053242>,
				<-89.186310, 10.160000, -354.069152>,
				< -86.994999, 0.000000, -356.888783>
			}
			triangle {
				<-86.994999, 0.000000, -356.888783>,
				<-116.493352, 0.000000, -360.316216>,
				< -119.127138, 7.870000, -358.053242>
			}
			triangle {
				<-119.127138, 7.870000, -358.053242>,
				<-93.166477, 17.270002, -348.255597>,
				< -89.186310, 10.160000, -354.069152>
			}
			triangle {
				<-138.509162, 0.000000, -361.087666>,
				<-135.348793, 4.570000, -359.818031>,
				< -119.127138, 7.870000, -358.053242>
			}
			triangle {
				<-119.127138, 7.870000, -358.053242>,
				<-116.493352, 0.000000, -360.316216>,
				< -138.509162, 0.000000, -361.087666>
			}
			triangle {
				<413.337221, 86.610002, -232.496554>,
				<394.037064, 73.150003, -266.797613>,
				< 406.785044, 63.250003, -240.276091>
			}
			triangle {
				<373.038782, 16.510000, -266.165839>,
				<362.663625, 7.370000, -267.799289>,
				< 378.360729, 0.000000, -259.780397>
			}
			triangle {
				<378.360729, 0.000000, -259.780397>,
				<385.791695, 9.650000, -254.917575>,
				< 373.038782, 16.510000, -266.165839>
			}
			triangle {
				<385.791695, 9.650000, -254.917575>,
				<378.360729, 0.000000, -259.780397>,
				< 387.260142, 0.000000, -253.270394>
			}
			triangle {
				<387.260142, 0.000000, -253.270394>,
				<392.535155, 5.840000, -245.460496>,
				< 385.791695, 9.650000, -254.917575>
			}
			triangle {
				<359.063370, 18.290001, -272.950810>,
				<361.641611, 24.129999, -274.601107>,
				< 343.671869, 10.670001, -299.710433>
			}
			triangle {
				<343.671869, 10.670001, -299.710433>,
				<339.296212, 9.910000, -287.567572>,
				< 359.063370, 18.290001, -272.950810>
			}
			triangle {
				<343.671869, 10.670001, -299.710433>,
				<361.641611, 24.129999, -274.601107>,
				< 369.602608, 11.940000, -288.552200>
			}
			triangle {
				<-98.474585, 13.970000, -323.189973>,
				<-133.625066, 7.370000, -343.074422>,
				< -139.838077, 4.060000, -344.814202>
			}
			triangle {
				<-139.838077, 4.060000, -344.814202>,
				<-102.578649, 5.080000, -320.707071>,
				< -98.474585, 13.970000, -323.189973>
			}
			triangle {
				<-139.317233, 3.810000, -350.723211>,
				<-139.732483, 0.000000, -350.298730>,
				< -140.522828, 0.000000, -342.923034>
			}
			triangle {
				<-140.522828, 0.000000, -342.923034>,
				<-139.838077, 4.060000, -344.814202>,
				< -139.317233, 3.810000, -350.723211>
			}
			triangle {
				<-139.838077, 4.060000, -344.814202>,
				<-133.625066, 7.370000, -343.074422>,
				< -129.418063, 7.370000, -347.077349>
			}
			triangle {
				<-129.418063, 7.370000, -347.077349>,
				<-139.317233, 3.810000, -350.723211>,
				< -139.838077, 4.060000, -344.814202>
			}
			triangle {
				<-93.166477, 17.270002, -348.255597>,
				<-92.518145, 18.290001, -344.717306>,
				< -68.715413, 27.430002, -336.922697>
			}
			triangle {
				<-119.127138, 7.870000, -358.053242>,
				<-120.610967, 10.920001, -354.302464>,
				< -92.518145, 18.290001, -344.717306>
			}
			triangle {
				<-92.518145, 18.290001, -344.717306>,
				<-93.166477, 17.270002, -348.255597>,
				< -119.127138, 7.870000, -358.053242>
			}
			triangle {
				<-135.348793, 4.570000, -359.818031>,
				<-120.610967, 10.920001, -354.302464>,
				< -119.127138, 7.870000, -358.053242>
			}
			triangle {
				<-135.348793, 4.570000, -359.818031>,
				<-139.446164, 4.830000, -356.115284>,
				< -123.437081, 8.380001, -350.319903>
			}
			triangle {
				<-123.437081, 8.380001, -350.319903>,
				<-120.610967, 10.920001, -354.302464>,
				< -135.348793, 4.570000, -359.818031>
			}
			triangle {
				<-139.446164, 4.830000, -356.115284>,
				<-139.317233, 3.810000, -350.723211>,
				< -129.418063, 7.370000, -347.077349>
			}
			triangle {
				<-129.418063, 7.370000, -347.077349>,
				<-123.437081, 8.380001, -350.319903>,
				< -139.446164, 4.830000, -356.115284>
			}
			triangle {
				<-135.348793, 4.570000, -359.818031>,
				<-138.509162, 0.000000, -361.087666>,
				< -141.527577, 0.000000, -356.157920>
			}
			triangle {
				<-141.527577, 0.000000, -356.157920>,
				<-139.446164, 4.830000, -356.115284>,
				< -135.348793, 4.570000, -359.818031>
			}
			triangle {
				<-139.732483, 0.000000, -350.298730>,
				<-139.317233, 3.810000, -350.723211>,
				< -139.446164, 4.830000, -356.115284>
			}
			triangle {
				<-139.446164, 4.830000, -356.115284>,
				<-141.527577, 0.000000, -356.157920>,
				< -139.732483, 0.000000, -350.298730>
			}
			triangle {
				<-50.847168, 30.730001, -303.493865>,
				<-55.526109, 27.430002, -296.045360>,
				< -46.815369, 30.990000, -298.573235>
			}
			triangle {
				<-46.815369, 30.990000, -298.573235>,
				<-37.477496, 35.810002, -305.645202>,
				< -45.460023, 34.540004, -306.872432>
			}
			triangle {
				<-56.386858, 34.540004, -318.823259>,
				<-34.924027, 38.610003, -320.785765>,
				< -35.954727, 34.800000, -332.596311>
			}
			triangle {
				<-76.051242, 20.830001, -307.550591>,
				<-74.348999, 26.420001, -312.346344>,
				< -98.474585, 13.970000, -323.189973>
			}
			triangle {
				<-46.815369, 30.990000, -298.573235>,
				<-45.460023, 34.540004, -306.872432>,
				< -50.847168, 30.730001, -303.493865>
			}
			triangle {
				<60.276337, 79.249999, -359.943025>,
				<39.158363, 78.230005, -356.625180>,
				< 39.048410, 80.010004, -354.738974>
			}
			triangle {
				<39.048410, 80.010004, -354.738974>,
				<60.180858, 80.770002, -359.086015>,
				< 60.276337, 79.249999, -359.943025>
			}
			triangle {
				<27.965364, 73.660008, -350.257940>,
				<39.048410, 80.010004, -354.738974>,
				< 39.158363, 78.230005, -356.625180>
			}
			triangle {
				<39.158363, 78.230005, -356.625180>,
				<26.730301, 71.370004, -351.939046>,
				< 27.965364, 73.660008, -350.257940>
			}
			triangle {
				<60.276337, 79.249999, -359.943025>,
				<60.180858, 80.770002, -359.086015>,
				< 75.645050, 77.220006, -358.851260>
			}
			triangle {
				<26.730301, 71.370004, -351.939046>,
				<52.728610, 64.519998, -346.185060>,
				< 43.276392, 41.150004, -347.496032>
			}
			triangle {
				<43.276392, 41.150004, -347.496032>,
				<1.986908, 35.050001, -355.589638>,
				< 26.730301, 71.370004, -351.939046>
			}
			triangle {
				<39.158363, 78.230005, -356.625180>,
				<60.276337, 79.249999, -359.943025>,
				< 75.645050, 77.220006, -358.851260>
			}
			triangle {
				<75.645050, 77.220006, -358.851260>,
				<26.730301, 71.370004, -351.939046>,
				< 39.158363, 78.230005, -356.625180>
			}
			triangle {
				<26.730301, 71.370004, -351.939046>,
				<75.645050, 77.220006, -358.851260>,
				< 52.728610, 64.519998, -346.185060>
			}
			triangle {
				<164.645608, 6.100000, -223.405296>,
				<188.775615, 0.000000, -234.585294>,
				< 189.285598, 9.910000, -252.615312>
			}
			triangle {
				<189.285598, 9.910000, -252.615312>,
				<149.655611, 11.680000, -244.745326>,
				< 164.645608, 6.100000, -223.405296>
			}
			triangle {
				<198.175606, 0.000000, -213.755333>,
				<188.775615, 0.000000, -234.585294>,
				< 164.645608, 6.100000, -223.405296>
			}
			triangle {
				<164.645608, 6.100000, -223.405296>,
				<175.315623, 3.560000, -211.725297>,
				< 198.175606, 0.000000, -213.755333>
			}
			triangle {
				<206.805604, 0.000000, -193.945265>,
				<209.855606, 0.000000, -202.065324>,
				< 198.175606, 0.000000, -213.755333>
			}
			triangle {
				<198.175606, 0.000000, -213.755333>,
				<190.555607, 1.270000, -193.435326>,
				< 206.805604, 0.000000, -193.945265>
			}
			triangle {
				<190.555607, 1.270000, -193.435326>,
				<198.175606, 0.000000, -213.755333>,
				< 175.315623, 3.560000, -211.725297>
			}
			triangle {
				<136.955603, 38.099999, -358.275333>,
				<185.215616, 30.990000, -360.815323>,
				< 182.935608, 0.000000, -371.745320>
			}
			triangle {
				<182.935608, 0.000000, -371.745320>,
				<138.735595, 0.000000, -369.965270>,
				< 136.955603, 38.099999, -358.275333>
			}
			triangle {
				<136.955603, 38.099999, -358.275333>,
				<138.735595, 0.000000, -369.965270>,
				< 95.555606, 0.000000, -373.515331>
			}
			triangle {
				<95.555606, 0.000000, -373.515331>,
				<99.115604, 37.590002, -360.315321>,
				< 136.955603, 38.099999, -358.275333>
			}
			triangle {
				<331.377735, 7.110000, -320.961731>,
				<331.958681, 0.000000, -325.493650>,
				< 305.789119, 0.000000, -341.259410>
			}
			triangle {
				<305.789119, 0.000000, -341.259410>,
				<307.741269, 9.650000, -338.059867>,
				< 331.377735, 7.110000, -320.961731>
			}
			triangle {
				<305.789119, 0.000000, -341.259410>,
				<263.621637, 0.000000, -350.430906>,
				< 257.004642, 17.270002, -348.692453>
			}
			triangle {
				<257.004642, 17.270002, -348.692453>,
				<307.741269, 9.650000, -338.059867>,
				< 305.789119, 0.000000, -341.259410>
			}
			triangle {
				<361.145590, 0.000000, -300.416718>,
				<358.951704, 5.590000, -300.134366>,
				< 369.602608, 11.940000, -288.552200>
			}
			triangle {
				<369.602608, 11.940000, -288.552200>,
				<372.403748, 0.000000, -287.848281>,
				< 361.145590, 0.000000, -300.416718>
			}
			triangle {
				<396.182257, 73.150003, -268.169279>,
				<380.850295, 52.320003, -280.026989>,
				< 377.520999, 52.320003, -277.203781>
			}
			triangle {
				<377.520999, 52.320003, -277.203781>,
				<394.037064, 73.150003, -266.797613>,
				< 396.182257, 73.150003, -268.169279>
			}
			triangle {
				<361.641611, 24.129999, -274.601107>,
				<377.520999, 52.320003, -277.203781>,
				< 380.850295, 52.320003, -280.026989>
			}
			triangle {
				<380.850295, 52.320003, -280.026989>,
				<369.602608, 11.940000, -288.552200>,
				< 361.641611, 24.129999, -274.601107>
			}
			triangle {
				<396.182257, 73.150003, -268.169279>,
				<394.037064, 73.150003, -266.797613>,
				< 413.337221, 86.610002, -232.496554>
			}
			triangle {
				<365.973276, 0.000000, -262.725050>,
				<378.360729, 0.000000, -259.780397>,
				< 362.663625, 7.370000, -267.799289>
			}
			triangle {
				<387.260142, 0.000000, -253.270394>,
				<372.403748, 0.000000, -287.848281>,
				< 369.602608, 11.940000, -288.552200>
			}
			triangle {
				<399.296702, 21.590000, -243.579425>,
				<392.535155, 5.840000, -245.460496>,
				< 387.260142, 0.000000, -253.270394>
			}
			triangle {
				<387.260142, 0.000000, -253.270394>,
				<380.850295, 52.320003, -280.026989>,
				< 399.296702, 21.590000, -243.579425>
			}
			triangle {
				<380.850295, 52.320003, -280.026989>,
				<387.260142, 0.000000, -253.270394>,
				< 369.602608, 11.940000, -288.552200>
			}
			triangle {
				<406.785044, 63.250003, -240.276091>,
				<399.296702, 21.590000, -243.579425>,
				< 380.850295, 52.320003, -280.026989>
			}
			triangle {
				<380.850295, 52.320003, -280.026989>,
				<396.182257, 73.150003, -268.169279>,
				< 406.785044, 63.250003, -240.276091>
			}
			triangle {
				<413.337221, 86.610002, -232.496554>,
				<406.785044, 63.250003, -240.276091>,
				< 396.182257, 73.150003, -268.169279>
			}
			triangle {
				<406.785044, 63.250003, -240.276091>,
				<394.037064, 73.150003, -266.797613>,
				< 377.520999, 52.320003, -277.203781>
			}
			triangle {
				<377.520999, 52.320003, -277.203781>,
				<399.296702, 21.590000, -243.579425>,
				< 406.785044, 63.250003, -240.276091>
			}
			triangle {
				<392.535155, 5.840000, -245.460496>,
				<399.296702, 21.590000, -243.579425>,
				< 377.520999, 52.320003, -277.203781>
			}
			triangle {
				<377.520999, 52.320003, -277.203781>,
				<385.791695, 9.650000, -254.917575>,
				< 392.535155, 5.840000, -245.460496>
			}
			triangle {
				<373.038782, 16.510000, -266.165839>,
				<385.791695, 9.650000, -254.917575>,
				< 377.520999, 52.320003, -277.203781>
			}
			triangle {
				<361.641611, 24.129999, -274.601107>,
				<373.038782, 16.510000, -266.165839>,
				< 377.520999, 52.320003, -277.203781>
			}
			triangle {
				<362.663625, 7.370000, -267.799289>,
				<373.038782, 16.510000, -266.165839>,
				< 361.641611, 24.129999, -274.601107>
			}
			triangle {
				<361.641611, 24.129999, -274.601107>,
				<359.063370, 18.290001, -272.950810>,
				< 362.663625, 7.370000, -267.799289>
			}
			triangle {
				<-34.135287, 5.330000, -272.862019>,
				<-32.019503, 0.000000, -270.555140>,
				< -28.458466, 0.000000, -269.425903>
			}
			triangle {
				<-34.135287, 5.330000, -272.862019>,
				<-62.782476, 13.970000, -286.153416>,
				< -57.405475, 0.000000, -281.164620>
			}
			triangle {
				<-57.405475, 0.000000, -281.164620>,
				<-32.019503, 0.000000, -270.555140>,
				< -34.135287, 5.330000, -272.862019>
			}
			triangle {
				<-34.135287, 5.330000, -272.862019>,
				<-33.716110, 13.970000, -275.092079>,
				< -62.782476, 13.970000, -286.153416>
			}
			triangle {
				<-56.386858, 34.540004, -318.823259>,
				<-69.569660, 25.910001, -330.836223>,
				< -72.761740, 25.910001, -318.426039>
			}
			triangle {
				<-72.761740, -25.910001, -318.426039>,
				<-69.569660, -25.910001, -330.836223>,
				< -56.386858, -34.540004, -318.823259>
			}
            rotate -90*x
            rotate 90*y
            translate 350*y
//            translate 100*z
            scale dolph_scale
		}
        object {
            eye
            translate <eyex, eyey, eyez>
        }
        object {
            eye
            translate <-eyex, eyey, eyez>
        }
    }
