// Kithrup model
// Steve Sloan 27-Oct-96
// A scene from David Brin's novel, Startide Rising, set on the sea floor of
//     the planet Kithrup
// This code may be used for any purpose, provided the source is acknowledged

#include "colors.inc"
#include "streaker.inc"
#include "buoy.inc"
#include "dolphins.inc"
#include "crewfen.inc"

#declare F = 1.04

#declare buoy_x = 200
#declare buoy_y = 10
#declare buoy_z = 300

#declare lamp_x = 300
#declare lamp_y = 10
#declare lamp_z = 400

#declare Crei_x = buoy_x
#declare Crei_y = buoy_y
#declare Crei_z = -buoy_z - 2

#declare mainbuoy_x = buoy_x
#declare mainbuoy_y = buoy_y
#declare mainbuoy_z = -buoy_z

#declare xlookat = 0
#declare ylookat = 10
#declare zlookat = -30

#declare camera_x = F*(.5*Crei_x +.5*mainbuoy_x - xlookat) + xlookat
#declare camera_y = F*(.5*Crei_y +.5*mainbuoy_y - ylookat) + ylookat
#declare camera_z = F*(.5*Crei_z +.5*mainbuoy_z - zlookat) + zlookat


// The sea floor of planet Kithrup (or at least a small chunk)
height_field {
    tga "kithrup.tga"
    smooth
    pigment { Gray80 }
    translate <-.5, -.35, -.5>
    scale <1000, 25, 1000>
}

// Transparent box to simulate seawater (had to comment it out, because it slowed
// rendering too much, the night before the due date)
//box {
//    <-5000, -5000, -5000>,  // Near lower left corner
//    < 5000,  5000,  5000>   // Far upper right corner
//    pigment { White filter .75 }
//    finish {
//        ambient 0
//        diffuse 0
//        reflection .25
//        refraction 1
//        ior 1.75           //1.33 for water
//        specular 1
//        roughness .001
//    }
//}

object {
    Streaker
    translate <0, 10, -60>
}

object {
    Creideiki
    translate -1.75*z
    rotate -20*x
    rotate 90*y
    translate <Crei_x, Crei_y, -buoy_z>
}

object {
    fish_school
    translate <buoy_x + 0.5, buoy_y, -buoy_z>
}

// The light sources (heliarc lamps placed by the Streaker crew)
object {
    heliarc_lamp
    translate <lamp_x, lamp_y, lamp_z>
}
object {
    heliarc_lamp
    translate <lamp_x, lamp_y, -lamp_z>
}
object {
    heliarc_lamp
    translate <-lamp_x, lamp_y, lamp_z>
}
object {
    heliarc_lamp
    translate <-lamp_x, lamp_y, -lamp_z>
}

// Detector Buoys
object {
    detector_buoy
    translate <buoy_x, buoy_y, buoy_z>
}
object {
    detector_buoy
    translate <buoy_x, buoy_y, 0>
}
object {
    detector_buoy
    translate <buoy_x, buoy_y, -buoy_z>
}
object {
    detector_buoy
    translate <-buoy_x, buoy_y, buoy_z>
}
object {
    detector_buoy
    translate <-buoy_x, buoy_y, 0>
}
object {
    detector_buoy
    translate <-buoy_x, buoy_y, -buoy_z>
}

camera{
    location <camera_x, camera_y, camera_z>
    look_at <xlookat, ylookat, zlookat>
    angle 15
}




