//
//  No life guard on duty
//     By : Pat Shaw
//          0002141403@mcimail.com
//
#version 3.0
global_settings { assumed_gamma 2.2 }

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"

camera
{
   direction <0.0, 0.0, 1.5>
   up  <0.0,  1.0,  0.0>
   right <4/3, 0.0, 0.0>
   translate <0.0, 0.0,  -100.0>
   look_at <0.0,  0.0,  0.0>
}

#declare GOLD = texture 
{ 
   pigment
   {
      color red 0.62 green 0.55 blue 0.0 
   }
   finish
   {
      ambient 0.3 
      diffuse 0.5
      reflection 0.6 
      brilliance 8.0
      specular 0.5
   }
}

#declare BRONZE = texture 
{ 
   pigment
   {
      color red 0.70 green 0.45 blue 0.15
   }
   finish
   {
      ambient 0.3 
      diffuse 0.5
      reflection 0.6 
      brilliance 8.0
      specular 0.5
   }
}

#declare SILVER = 
texture 
{ 
   pigment
   {
      colour red 0.50 green 0.58 blue 0.68
   }
   finish
   {
      ambient 0.2 
      diffuse 0.5
      reflection 0.6 
      brilliance 7.0
      specular 0.5
      roughness 0.01
   }
}


#declare PLASTIC = finish
{
   ambient 0.40
   diffuse 0.60
   phong 1.00
   phong_size 35.0
}

#declare SunGlasses =
union
{
   sphere
   {
      0,1
      scale <2,2,0.01>
      translate <-2.4,0,0>
      pigment { color rgbf <0.6, 0.7, 0.9, 0.8> }
      finish { F_Glass4 }
   }
   sphere
   {
      0,1
      scale <2,2,0.01>
      translate <2.4,0,0>
      pigment { color rgbf <0.6, 0.7, 0.9, 0.8> }
      finish { F_Glass4 }
   }
   union
   {
      torus { 2,   0.05 rotate <90,0,0> translate <-2.4,0,0> }
      torus { 2,   0.05 rotate <90,0,0> translate < 2.4,0,0> }
      torus { 0.4, 0.05 clipped_by {plane {z,0}} rotate <90,0,0> }
      union
      {
         cylinder { <0,0,0>, <0,0,5> 0.05 rotate <0,-5,0> translate <-4.4,0,0> }
         torus { 1.2,  0.05 clipped_by {plane {x,0}} rotate <90,90,0> translate <0,-1.2,0> rotate < 0,0,-15 > translate <-4.4,0,5> rotate <0,-5,0> }
      } 
      union
      {
         cylinder { <0,0,0>, <0,0,5> 0.05 rotate <0,5,0> translate < 4.4,0,0> }
         torus { 1.2,  0.05 clipped_by {plane {x,0}} rotate <90,90,0> translate <0,-1.2,0> rotate < 0,0, 15 > translate < 4.4,0,5> rotate <0,5,0> }
      } 

      texture { T_Silver_3C }
   }                            
}                            

#declare BWhite = colour red 0.9 green 0.9 blue 1.0
#declare LRVein = colour red 1.0 green 0.8 blue 0.8
#declare RVein = colour red 1.0 green 0.2 blue 0.2
#declare Eye_Marble = pigment
{
   marble
   turbulence 1.3
   colour_map 
   {
      [0.0  0.87   colour BWhite   colour BWhite]
      [0.87 0.90   colour BWhite   colour LRVein]
      [0.90 0.92   colour LRVein   colour RVein]
      [0.92 0.95   colour RVein    colour RVein]
      [0.95 0.97   colour RVein    colour LRVein]
      [0.97 1.00   colour LRVein   colour BWhite]
   }
}

#declare Eye_Glass = finish
{
   specular 1.0
   roughness 0.005
   ambient 0.0
   diffuse 0.0
   reflection 0.2
   refraction 1.0
   ior 1.95
}



//---- EYE 
#declare EYE = union                                         
{                                                            
                                                             
   union                                                  
   {                                                      
      intersection                                        
      {                                                   
         sphere{ <0,0,0> 3.1}                             
         plane { <0.0, -1.0, 0.0> 0.0 }
         rotate <25, 0, 0>
      }                                                   
      intersection                                        
      {                                                   
         sphere{ <0,0,0> 3.1}                             
         plane { <0.0, 1.0, 0.0> 0.0 }                    
         rotate <-35, 0, 0>
      }                                                   
      texture                                                
      {                                                      
         GOLD                                                
      }                                                      
   }                                                         
                                                             
   // blood shot ball                                        
   intersection                                           
   {                                                         
      sphere{ <0,0,0> 3}                                  
      plane { <0.0, 0.0, -1.0> 2.8 }                      
      texture                                                
      {
         pigment
         {
            Eye_Marble
            scale <30.8, 1.0, 1.0>
         }

         finish
         {
            ambient 0.2
            diffuse 0.5
            reflection 0.2
            specular 0.75
            roughness 0.01
         }
      }
   }


   intersection
   {
      sphere { <0, 0, 0> 3}
      plane  { <0, 0, -1> 2.8 inverse }
      texture
      {
        pigment
        {
           color red 0.2 green 0.2 blue 0.8 filter 1.0
        }
        finish
        {
           Eye_Glass
        }
      }
   }

   plane
   { 
      <0, 0, -1> 2.8001 inverse 
      clipped_by
      {
         sphere{ <0,0,0> 3}
      }
      texture
      {
        pigment
        {
           Blue_Sky
           scale <0.1, 0.1, 0.1>
        }
        finish
        {
           ambient 0.8
           diffuse 0.2
        }
      }
   }

   // pupil
   sphere
   { 
      <0,0,0> 1
      scale <0.5,0.5,0.02>
      texture
      {
        pigment
        {
           color red 0.0 green 0.0 blue 0.0
        }
        finish
        {
           ambient 0.3
           diffuse 0.7
           reflection 0.1
           specular 0.75
           roughness 0.01
        }
      }
      translate <0, 0, -3.0>
   }
}

#declare BLUEHALO =
texture
{
   pigment { colour Clear }

   halo
   {
      emitting
      spherical_mapping
      linear
      colour_map {
         [ 0 color rgbt <0, 0,   1,   1> ]
         [ 1 color rgbt <0, 0.5, 1, 0.3> ]
      }
      samples 60
   }
}

#declare PINKHALO =
texture
{
   pigment { colour Clear }

   halo
   {
      emitting
      spherical_mapping
      linear
      colour_map {
         [ 0 color rgbt <1.00,0.43,0.78,   1> ]
         [ 1 color rgbt <1.00,0.43,0.78, 0.3> ]
      }
      samples 60
   }
}

#declare LEG = 
union
{
   cylinder { <0,0,0>, <3,-1,0>, 0.2 }
   sphere   { <3,-1,0>, 0.4 }
   cylinder { <3,-1,0>, <4,-3,0>,0.2 }
   cylinder { <4,-3,0>, <4,-3.1,0>, 0.8 }
   texture { GOLD }
}

#declare ARM = 
union
{             
   cylinder { <-1,-1,0>, <2,2,0>, 0.2 }
   sphere   { <2,2,0>, 0.4 }
   cylinder { <2,2,0>, <1,6,0>, 0.2 }
   sphere   { <1,6,0>, 0.4 }
   texture { GOLD }
}

#declare BLUEARM = 
union
{
   object { ARM }
   sphere
   {
      0,1
      hollow
      texture { BLUEHALO }
      scale 1.4
      translate <1,6,0>
   }
}



#declare PINKARM = 
union
{
   object { ARM }
   sphere
   {
      0,1
      hollow
      texture { PINKHALO }
      scale 1.4
      translate <1,6,0>
   }
}

#declare ROBOT = 
union
{
   object { SunGlasses translate <0.0, 2, -8.4> }
      

   object { EYE scale 0.5 translate < 2,2.2,-6.8> }
   object { EYE scale 0.5 translate <-2,2.2,-6.8> }

   intersection
   {
      sphere
      {
         0,1
         clipped_by { plane {-y,0}}
         scale <5,5,8>
      }
      cylinder {<-5,1.6,-3.5>,<5,1.6,-3.5>,0.8 inverse }
      cylinder {<-5,1.6, 3.5>,<5,1.6, 3.5>,0.8 inverse}
      cylinder {<0,1.9, 0>, <0,1.9, 8>,1.2 inverse}
      texture { BRONZE }
   }

   torus
   {
      1, 0.05
      scale <5,5,8>
      texture { GOLD }
   }

   object { LEG              translate <0.0, 0, 0> }
   object { LEG rotate y*180 translate <0.0, 0, 0> }
   object { LEG              translate <0.0, 0, 4> }
   object { LEG rotate y*180 translate <0.0, 0, 4> }
   object { LEG              translate <0.0, 0,-4> }
   object { LEG rotate y*180 translate <0.0, 0,-4> }
}


#declare BLUEJETS =
union
{
   sphere { 0,1 hollow texture { BLUEHALO } scale <1.4,1,1>     translate <-4.3,1.6,-3.5> }
   sphere { 0,1 hollow texture { BLUEHALO } scale <1.4,1,1>     translate < 4.3,1.6,-3.5> }
   sphere { 0,1 hollow texture { BLUEHALO } scale <1.4,1,1>     translate <-4.3,1.6, 3.5> }
   sphere { 0,1 hollow texture { BLUEHALO } scale <1.4,1,1>     translate < 4.3,1.6, 3.5> }
   sphere { 0,1 hollow texture { BLUEHALO } scale <1.4,1.4,1.8> translate <   0,1.9, 7.3> }
}

#declare PINKJETS =
union
{
   sphere { 0,1 hollow texture { PINKHALO } scale <1.4,1,1>     translate <-4.3,1.2,-3.5> }
   sphere { 0,1 hollow texture { PINKHALO } scale <1.4,1,1>     translate < 4.3,1.2,-3.5> }
   sphere { 0,1 hollow texture { PINKHALO } scale <1.4,1,1>     translate <-4.3,1.2, 3.5> }
   sphere { 0,1 hollow texture { PINKHALO } scale <1.4,1,1>     translate < 4.3,1.2, 3.5> }
   sphere { 0,1 hollow texture { PINKHALO } scale <1.4,1.4,1.8> translate <   0,1.5, 7.3> }
                                                                                  
}

/*

union
{
   object { ROBOT }
   object { PINKJETS }
   object { PINKARM              rotate x*-40 translate <4,1,-6>}
   object { PINKARM rotate y*180 rotate x*-40 translate <-4,1,-6>}
   rotate <10,30,0>
   translate <1.0, -2.0, -70.0>
}
*/


//--------- SANDRING

#declare SANDRING = 
union
{

   //---- Out Side Gold Ring
   torus
   {
      18, 1.5
      pigment
      {
         color red 0.62 green 0.55 blue 0.0 
      }
      normal
      {
        crackle 0.9
        scale 0.96
      }
      finish
      {
         ambient 0.3 
         diffuse 0.5
         reflection 0.6 
         brilliance 8.0
         specular 0.5
      }
   }


   //---- Sand 
   cylinder
   {
      <0,-1.1,0>, <0,1.1,0>, 16.5

      pigment { colour red 1.0 green 0.66 blue 0.2 }
      normal
      {
         ripples 0.7
         frequency 200.0
         scale 300.0
      }
      finish
      {
         crand 0.05  /* This value dithers the colours */
         ambient 0.5
         diffuse 0.5
      }
   }


   sphere 
   {
      0, 1
      scale <28,1,28> 

      hollow

      texture
      {
         pigment { colour Clear }

         halo
         {
            emitting
            spherical_mapping
            linear
            colour_map {
               [ 0 color rgbt <1,   0, 1, 1> ]
               [ 1 color rgbt <0.5, 1, 1, 0.3> ]
            }
            samples 60
         }

         scale <28,28,28>
      }
   }
}


//-------- SANDRING WITH SANDCASTLE, BUCKET, ROBOT AND BEACHBALL
union
{
   object {SANDRING}

   //---- Sand Castle
   cone
   {
      <0,0,0>, 1.5, <0,2.7,0>, 1.2

      pigment { colour red 1.0 green 0.66 blue 0.2 }

      normal
      {
         ripples 0.7
         frequency 200.0
         scale 1.0
      }
      finish
      {
         crand 0.05  /* This value dithers the colours */
         ambient 0.5
         diffuse 0.5
      }
      translate <-9,1.1,-8>
   }

   //---- Beach Ball
   sphere
   {
      0,3

      pigment
      {
         gradient y
         color_map {
            [0.0  0.33 color NeonPink color NeonPink]
            [0.33 0.66 color NeonBlue color NeonBlue]
            [0.66 1.00 color NeonPink color NeonPink]
         }
         scale 6.0
         translate 3*y
      }
      finish { PLASTIC }
      rotate <0,10,-30>
      translate <-8,4.1,6>
   }

   // Sand Bucket
   union
   {
      difference
      {
         cone
         {
            <0,2.7,0>, 1.5,
            <0,0.0,0>, 1.2
         }

         cone
         {
             <0,2.7,0>, 1.5,
             <0,0.0,0>, 1.2
             translate <0,0.1,0>
         }
      }

      torus { 1.6, 0.1 translate <0,2.7,0> }

      
      difference
      {
         object { Disk_X scale <0.2,1.8,1.8> }
         object { Disk_X scale <0.2,1.7,1.7> inverse}

         clipped_by {plane {-y,0}}

         translate <0,2.6,0>
      }

      pigment { colour red 0.0 green 1.0 blue 0.2 }
      finish { PLASTIC }
      rotate <0,-30,0>
      translate <-5,1.1,-11>
   }

   union
   {
      object { ROBOT }
      object { BLUEJETS }
      object { BLUEARM              rotate x*-100 translate <4,1,-6>}
      object { BLUEARM rotate y*180 rotate x*-100 translate <-4,1,-6>}
      rotate <0,40,0>
      translate <6.0, 4.2, -3.0>
   }

   bounded_by { box {<-29,-2,-29> <29,10,29>} }
   rotate <-15,0,-10>
   translate <-9,-12,-30>
}


//-------- 2 SANDRING WITH 2 ROBOTS 
union
{


   union
   {
      object {SANDRING}
      union
      {
         object { ROBOT }
         object { BLUEJETS }
         object { BLUEARM              rotate x*-30 translate <4,1,-6> }
         object { BLUEARM rotate y*180 rotate x*-60 translate <-4,1,-6> }
         scale 0.6 
         rotate <0,195,0>
         translate <-8, 2.96, -6>
      }

      union
      {
         object { ROBOT }
         object { PINKJETS }
         object { PINKARM              rotate x*-40 translate <4,1,-6>}
         object { PINKARM rotate y*180 rotate x*-40 translate <-4,1,-6>}
         scale 0.6 
         rotate <0,165,0>
         translate <8, 2.96, -6>
      }

      bounded_by { box {<-29,-2,-29> <29,10,29>} }

      translate <0,0,-35>
   }

   union
   {
      object {SANDRING}
      union
      {
         object { ROBOT }
         object { PINKJETS }
         object { PINKARM              rotate x*-60 translate <4,1,-6>}
         object { PINKARM rotate y*180 rotate x*-60 translate <-4,1,-6>}
         scale 0.6 
         rotate <0,15,0>
         translate <-8, 2.96, 6>
      }

      union
      {
         object { ROBOT }
         object { BLUEJETS }
         object { BLUEARM              rotate x*-30 translate <4,1,-6>}
         object { BLUEARM rotate y*180 rotate x*-60 translate <-4,1,-6>}
         scale 0.6 
         rotate <0,-15,0>
         translate <8, 2.96, 6>
      }

      bounded_by { box {<-29,-2,-29> <29,10,29>} }

      translate <0,0,35>
   }

   union
   {
      // Sides
      cylinder { <-15,0,0>,  <-15,20,0> 0.3 }
      cylinder { < 15,0,0>,  < 15,20,0> 0.3 }

      // Top & Bottom
      cylinder { <-15,10,0>,  < 15,10,0> 0.2 }
      cylinder { <-15,19,0>,  < 15,19,0> 0.2 }

      // Horizontal Net
      cylinder { <-15,11,0>,  < 15,11,0> 0.1 }
      cylinder { <-15,12,0>,  < 15,12,0> 0.1 }
      cylinder { <-15,13,0>,  < 15,13,0> 0.1 }
      cylinder { <-15,14,0>,  < 15,14,0> 0.1 }
      cylinder { <-15,15,0>,  < 15,15,0> 0.1 }
      cylinder { <-15,16,0>,  < 15,16,0> 0.1 }
      cylinder { <-15,17,0>,  < 15,17,0> 0.1 }
      cylinder { <-15,18,0>,  < 15,18,0> 0.1 }

      // Vertical Net
      cylinder { <-13,10,0>,  <-13,19,0> 0.1 }
      cylinder { <-11,10,0>,  <-11,19,0> 0.1 }
      cylinder { <-9 ,10,0>,  <-9 ,19,0> 0.1 }
      cylinder { <-7 ,10,0>,  <-7 ,19,0> 0.1 }
      cylinder { <-5 ,10,0>,  <-5 ,19,0> 0.1 }
      cylinder { <-3 ,10,0>,  <-3 ,19,0> 0.1 }
      cylinder { <-1 ,10,0>,  <-1 ,19,0> 0.1 }
      cylinder { < 1 ,10,0>,  < 1 ,19,0> 0.1 }
      cylinder { < 3 ,10,0>,  < 3 ,19,0> 0.1 }
      cylinder { < 5 ,10,0>,  < 5 ,19,0> 0.1 }
      cylinder { < 7 ,10,0>,  < 7 ,19,0> 0.1 }
      cylinder { < 9 ,10,0>,  < 9 ,19,0> 0.1 }
      cylinder { <11 ,10,0>,  <11 ,19,0> 0.1 }
      cylinder { <13 ,10,0>,  <13 ,19,0> 0.1 }

      sphere   { < 15,20,0> 0.3 }
      sphere   { <-15,20,0> 0.3 }

      texture { T_Silver_3C }
   }

   sphere { 0,1 hollow texture { BLUEHALO } scale <5,1.5,5> translate <-15,0,0> }
   sphere { 0,1 hollow texture { BLUEHALO } scale <5,1.5,5> translate < 15,0,0> }

   sphere
   {
      <3,22,-8> 2.4
      pigment { color NeonBlue }
      finish { PLASTIC }
   }

   rotate <-30,-5,10>
   translate <35,0,60>
}

//-------- SIGN 

#declare SCORNER =
sphere
{
   0, 1
   hollow

   texture 
   {
      GOLD
   }
}

#declare SPIPE =
cylinder
{
   y, -y, 1
   hollow

   texture
   {
      pigment { colour Clear }

      halo
      {
         emitting
         cylindrical_mapping
         linear
         colour_map {
            [ 0 color rgbt <0, 1, 0, 1> ]
            [ 1 color rgbt <0, 1, 1, 0> ]
         }
         samples 60
      }

   }
}

#declare SIGN = union
{

   union
   {
      object { SPIPE scale <1,4.5,1>  translate x*9.5 }
      object { SPIPE scale <1,4.5,1>  translate x*-9.5 }
      object { SPIPE scale <1,9.5,1> rotate z*90 translate y*4.5 }
      object { SPIPE scale <1,9.5,1> rotate z*90 translate y*-4.5 }
      object { SCORNER translate <-9.5,-4.5,0> }
      object { SCORNER translate <-9.5, 4.5,0> }
      object { SCORNER translate < 9.5,-4.5,0> }
      object { SCORNER translate < 9.5, 4.5,0> }
      translate y*4.5
   }

   object { SCORNER translate < 0,0,0> }
   object { SPIPE scale <1,7.5,1>  translate y*-7.5 }

   box
   {
      <-9, -4, -0.01> <9,4,0>
    
      pigment
      {
         image_map {gif "life.gif" map_type 0 interpolate 2 once}
         translate <-0.5, -0.52, 0>
         scale <22, 12.5, 22>
      }

      finish
      {
         brilliance 8.0
         diffuse 0.0
         ambient 1.0
      }
      hollow
      translate y*4.5
   }


   translate <0,15,0>
}



//-------- SANDRING WITH SIGN ABOVE IT
union
{
   object {SANDRING}

   object {SIGN translate <0,0,0> }

   bounded_by { box {<-29,-2,-29> <29,26,29>} }
   rotate <-20,0,20>
   translate <-40,7,60>
}




//-------- STARS
sphere
{
   <0, 0, 0> 2000

   pigment
   {
      image_map {tga "starfld2.tga" map_type 0 interpolate 2}
      translate <-0.5, -0.5, 0>
      scale 600

   }
 
   finish
   {
      brilliance 8.0
      diffuse 0
      ambient 1
   }
   hollow
}

//-------- GALAXY in background
sphere
{
   <0, 0, 0> 1999.9
   pigment
   {
      color Clear
   }
 
   pigment
   {
      image_map {tga "galaxy.tga" map_type 0 interpolate 2 once}
      translate <-0.5, -0.5, 0>
      scale <580, 420, 420>
      translate <-500, 430, 0>
   }


   finish
   {
      brilliance 8.0
      diffuse 0
      ambient 1
   }
   hollow
}

//-------- PLANET
union
{
   sphere
   {
       <0.0 0.0 0.0> 80
       pigment
       {
          crackle
          turbulence 0.4
          colour_map
          {
             [0.01 colour rgb<0.7, 0, 0>   ]
             [0.02 colour rgb<0,   0, 0>   ]
             [0.10 colour rgb<0,   0, 0>   ]
             [1.00 colour rgb<0,   0, 0.2> ]
          }
          scale 24
       }
       finish
       {
          crand .08
          ambient 0.000002
          diffuse 0.999998
       }
   }


   sphere
   {
       <0.0 0.0 0.0> 80.8
       pigment
       {
          bozo

          color_map {
             [0.0,   0.3   color rgbt<0.35, 0.0, 0.45, 0.2>
                           color rgbt<0.35, 0.0, 0.45, 0.7> ]
             [0.3,   0.035 color rgbt<0.35, 0.0, 0.45, 0.7>
                           color Clear]
             [0.035, 1.001 color Clear
                           color Clear]
          }
          turbulence 1.0
          scale <32, 8, 32>
          rotate <30, 0, -45>
       }
       finish
       {
          ambient 0.000002
          diffuse 0.999998
       }
   }


   sphere
   {
      0, 1
      hollow

      texture
      {
         pigment { colour Clear }

         halo
         {
            emitting
            spherical_mapping
            linear
            turbulence 0.1
            colour_map {
               [ 0 color rgbt <1, 0, 0  , 1> ]
               [ 1 color rgbt <1, 0, 1  , 0> ]
            }
            samples 60
         }

      }

      scale 105
   }
   bounded_by { box {<-110,-110,-110> <110,110,110>} }
   translate <60,60,400>
}


light_source { <1200.0, 1000.0, -1200.0> colour White }
//light_source { 20000*<-1, 1, -1> rgb 1 }
//light_source { <-60, 60, -80> color White }

