#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "shapes.inc"
#include "shapesq.inc"
#include "mytext.inc"
#include "marble.inc"
#include "rose.inc"
#include "glass.inc"
#include "golds.inc"
#include "metals.inc"
#include "consts.inc"
#include "mytext2.inc"
#include "ships.inc"
#include "fount.inc"
#include "embellishment2.inc"
#include "cup.inc"
#include "ban.inc"
#include "drop.inc"

//Planet surface texture

#declare ground1 = texture {
  pigment{
  	gradient < 0, 1, 0>
    color_map	{
        [0.000 color rgbf <0.000, 0.300, 0.150, 0.000>]
        [0.250 color rgbf <0.000, 0.200, 0.400, 0.000>]
        [0.340 color rgbf <0.000, 0.100, 0.600, 0.000>]
        [0.560 color rgbf <0.000, 0.400, 0.750, 0.000>]
        [0.700 color rgbf <0.000, 0.300, 0.800, 0.000>]
        [0.999 color rgbf <0.800, 0.800, 0.800, 0.000>]
    }
  }
  finish	{ambient 0.2 diffuse 0.7 phong 0.2 phong_size 1.0}
}


//Link up of attenuating and emitting halos to give nebula effect

sphere { 0, 3
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 1, 1, 1> ]
        [ 1 color rgbt <0, 0, 1, -1> ]
      }
      samples 10
   }
    hollow
    scale 500
    translate <-5100, 800, 4000>
  }


sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 2
    lambda 10
    octaves 1
    omega 7
    color_map {
      [.3 color rgbt <0, 0, 1, 1>]
      [.6 color rgbt <1, .5, 1, -1>]
      [.8 color rgbt <0, 0, 1, 1>]
    }
    frequency 3
    samples 30
    scale .75
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [0 color rgbt <0, 0, 1, 1> ]
     [.5 color rgbt <1, .5, 1, -1>]
      [1 color rgbt <0, 0, 1, 1> ]
    }
    frequency 2
    samples 20
    scale <.75, .4, 1>
    translate <2, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 2
    color_map {
      [0 color rgbt <0, 0, 1, 1>]
      [.5 color rgbt <1, .5, 1, -1>]
      [1 color rgbt <0, 0, 1, 1>]
    }
    frequency 2
    samples 20
    scale <.75, .2, 1>
    translate <-2, 0, 0>
  }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    lambda 20
    octaves 1
    omega 6
    color_map {
      [0 color rgbt <0, 0, 1, 1>]
      [.5 color rgbt <1, 1, 1, -1>]
      [1 color rgbt <0, 0, 1, 1>]
    }
    frequency 3
    samples 30
    scale <.8, .6, 1>
    translate <1, 1.5, 0>
  }
  hollow
  scale <60, 24, 36>
  translate <20, 40, 200>
}


sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 2
    lambda 10
    octaves 1
    omega 7
    color_map {
      [.3 color rgbt <0, 0, 1, 1>]
      [.6 color rgbt <1, .5, 1, -1>]
      [.8 color rgbt <0, 0, 1, 1>]
    }
    frequency 3
    samples 30
    scale .75
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [0 color rgbt <0, 0, 1, 1> ]
      [.5 color rgbt <1, .5, 1, -1>]
      [1 color rgbt <0, 0, 1, 1> ]
    }
    frequency 2
    samples 20
    scale <.75, .4, 1>
    translate <2, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 2
    color_map {
      [0 color rgbt <0, 0, 1, 1>]
      [.5 color rgbt <1, .5, 1, -1>]
      [1 color rgbt <0, 0, 1, 1>]
    }
    frequency 2
    samples 20
    scale <.75, .2, 1>
    translate <-2, 0, 0>
  }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    lambda 20
    octaves 1
    omega 6
    color_map {
      [0 color rgbt <0, 0, 1, 1>]
      [.5 color rgbt <1, 1, 1, -1>]
      [1 color rgbt <0, 0, 1, 1>]
    }
    frequency 3
    samples 30
    scale <.8, .6, 1>
    translate <1, 1.5, 0>
  }
  hollow
  scale <300, 100, 160>
  translate <-20, 80, 400>
}






//Texture declares for moon surface

#declare Atmosphere = pigment {
  gradient x
  turbulence .5
  lambda 30
  omega 1
  octaves 2
  color_map {
    [0.0 color Gray85 filter .7]
    [0.1 color Gray85 filter .7]
    [0.3 color Black filter .7]
    [0.5 color Gray75 filter .7]
    [0.7 color Gray85 filter .7]
  }
  rotate -45*z
}

#declare UpperAtmosphere = pigment {
  gradient x
  turbulence .6
  color_map {
    [0.0 color Gray85 filter .8]
    [0.2 color Gray85 filter .8]
    [0.3 color Gray50 filter .8]
    [0.35 color Gray85 filter .8]
    [0.4 color Gray40 filter .8]
    [0.7 color Gray85 filter .8]
  }
  rotate -45*z
}

#declare Land = pigment {
    gradient x
    turbulence .5
    lambda 20
    omega 1
    octaves 2
    color_map {
      [0.0 color Gray85]
      [0.25 color Gray85]
      [0.3 color Gray50]
      [0.35 color Gray85]
      [0.4 color Gray40]
      [0.7 color Gray85]
    }
    rotate -45*z
  }

//Moon object

sphere { <0, 0, 0>, 1
  texture {Land}
  texture {Atmosphere}
  texture {UpperAtmosphere}
  normal {wrinkles 2 scale 3}
  finish {
    irid {
      .2
      thickness .9
      turbulence .5
    }
  }
  scale 475
  translate <-1800, 600, 1000>
}

//Lights for moon

light_source {
  <-800, -3000, 7500>
  color NeonBlue
  spotlight
  point_at <-1450, 200, 1050>
  radius 30
  falloff 60
  tightness 1
}

light_source {
  <-800, -3000, 7500>
   color SlateBlue
   spotlight
   point_at <-1450, 200, 1050>
   radius 30
   falloff 60
   tightness 2
 }
 
 
light_source {
  <-800, -3000, 7500>
  color White
  spotlight
  point_at <-1450, 200, 1050>
  radius 30
  falloff 60
  tightness 4
}

light_source {
  <-1500, 2500, -1000>
  color Blue
  spotlight
  point_at <-1700, 600, 500>
  radius 45
  falloff 60
  tightness 4
}

//Airglow for moon horizon

light_source {
  <-1200, 0, 1400>
  color White
  spotlight
  point_at <-1480, 200, 1400>
  radius 15
  falloff 30
  tightness .1
}

//This spotlight is providing the reflection on the water

light_source {
  <-17, 5, 15>
  color White
  spotlight
  point_at <-1, 0, -1>
  radius 15
  falloff 30
  tightness 2
}

//Spotlight being used for the foreground and midground

light_source {
  <300, 180, 10>
   color White
   spotlight
   point_at <0, 0, 0>
   radius 45
   falloff 60
   tightness 7
 }


// Star and galaxy background

sphere { 0, 10000
  texture {Universe}
  hollow
}

// Central Pedestal objects

cylinder {
  <0, -1, 0>, <0, .55, 0>, 3.3
  texture { BlueMarble}
}

difference {

  cylinder {
    <0, -1, 0>, <0, .55, 0>, 3.35
    texture {T_Silver_4A finish {F_MetalD} }
  }

  cylinder {
    <0, -1, 0>, <0, .6, 0>, 3.3
    texture {T_Silver_4A finish {F_MetalD} }
  }
}

cylinder {
  <0, -1, 0>, <0, .65, 0>, 2.7
  texture { BlueMarble}
}

difference {

  cylinder {
    <0, -1, 0>, <0, .65, 0>, 2.75
    texture {T_Silver_4A finish {F_MetalD} }
  }

  cylinder {
    <0, -1, 0>, <0, .7, 0>, 2.7
    texture {T_Silver_4A finish {F_MetalD} }
  }
}

cylinder {
  <0, -1, 0>, <0, .75, 0>, 2.1
  texture {BlueMarble}
}

difference {

  cylinder {
    <0, -1, 0>, <0, .75, 0>, 2.15
    texture {T_Silver_4A finish {F_MetalD} }
  }

  cylinder {
    <0, -1, 0>, <0, .8, 0>, 2.1
    texture {T_Silver_4A finish {F_MetalD} }
  }
}

cylinder {
  <0, -1, 0>, <0, .85, 0>, 1.5
  texture {BlueMarble}
}

difference {

  cylinder {
    <0, -1, 0>, <0, .85, 0>, 1.55
    texture {T_Silver_4A finish {F_MetalD} }
  }

  cylinder {
    <0, -1, 0>, <0, .9, 0>, 1.5
    texture {T_Silver_4A finish {F_MetalD} }
  }
}


cylinder {
  <0, -1, 0>, <0, .95, 0>, .9
  texture {BlueMarble}
}

difference {

  cylinder {
    <0, -1, 0>, <0, .95, 0>, .95
    texture {T_Silver_4A finish {F_MetalD} }
  }

  cylinder {
    <0, -1, 0>, <0, 1, 0>, .9
    texture {T_Silver_4A finish {F_MetalD} }
  }
}

// Water objects

union {

  disc {
    <0, .5, 0>, <0, 1.45, 0>, 4, 3.3
  }

  disc {
    <0, .5, 0>, <0, 1.45, 0>, 8
  }
  pigment {color Turquoise}
  finish {reflection .4 phong 1}
  normal {wrinkles 1 scale .1}
}

// Setup and embellishment for the border marble around inner water ring

difference {

  cylinder {
    <0, -1, 0>, <0, .55, 0>, 4.1
  }

  cylinder {
    <0, -1, 0>, <0, .65, 0>, 4.0
  }
  
   box { <2.1, .51, .2>, <7, .56, -.3>
    texture {T_Grnt20}
    rotate 85*y
  }
  
  texture {BlueMarble}
}

object {InnerCircle1}

object {InnerCircle2}

//Arch

 difference {

  cylinder {
    <4, .45, 0>, <4.1, .45, 0>, .35
  }

  cylinder {
    <3.9, .45, 0>, <4.2, .45, 0>, .3
  }
  scale <1, 1.6, 1>
  texture {BlueMarble}
  rotate 85*y
}


//Path to the pedestal

union {

 
    box { <3.3, .45, .3>, <7, .55, -.4>
      texture {BlueMarble}
      rotate 85*y
    }


    box { <3.3, .51, .2>, <7, .57, -.3>
      texture {T_Grnt20}
      rotate 85*y
    }


    difference {

      box { <3.3, .51, .2>, <7, .57, -.3>
        texture {T_Grnt20}
        rotate 85*y
      }

      difference {

        cylinder {
          <0, .45, 0>, <0, .55, 0>, 6.2
        }

        cylinder {
          <0, -.2, 0>, <0, .58, 0>, 5.7
        }

        texture {BlueMarble} 
    }
  }
}


//Lining for pathway

union {

object {SphereE translate <.11, .8, -4.2> }

object {SphereE translate <.11, .8, -4.8> }

object {SphereE translate <.11, .8, -5.75> }

object {SphereE translate <.11, .8, -6.2> }

object {SphereE translate <.11, .8, -7.2> }


object {RodE translate <.11, .4, -4.2> }

object {RodE translate <.11, .4, -4.8> }

object {RodE translate <.11, .4, -5.75> }

object {RodE translate <.11, .4, -6.2> }

object {RodE translate <.11, .4, -7.2> }


object {SphereE translate <.75, .8, -4.2> }

object {SphereE translate <.75, .8, -4.8> }

object {SphereE translate <.75, .8, -5.75> }

object {SphereE translate <.8, .8, -6.2> }

object {SphereE translate <.75, .8, -7.2> }


object {RodE translate <.75, .4, -4.2> }

object {RodE translate <.75, .4, -4.8> }

object {RodE translate <.75, .4, -5.75> }

object {RodE translate <.8, .4, -6.2> }

object {RodE translate <.75, .4, -7.2> }

}

// Marble borders for middle ring

difference {

  cylinder {
    <0, .45, 0>, <0, .55, 0>, 6.2
  }

  cylinder {
    <0, -.2, 0>, <0, .6, 0>, 5.7
  }
  texture {BlueMarble} 
}

difference {

  cylinder {
    <0, .45, 0>, <0, .57, 0>, 6.15
  }

  cylinder {
    <0, -.2, 0>, <0, .59, 0>, 5.75
  }
  texture {T_Grnt20}
}

object {InnerCircle1 scale <1.38, 1, 1.38>}

object {InnerCircle2 scale <1.38, 1, 1.38>}


object {InnerCircle1 scale <1.53, 1, 1.53>}

object {InnerCircle2 scale <1.53, 1, 1.53>}

// Marble borders for outer ring

union {

difference {

  cylinder {
    <0, .45, 0>, <0, .55, 0>, 7
  }

  cylinder {
    <0, -.2, 0>, <0, .65, 0>, 6.9
  }
  texture {BlueMarble}
}

difference {

  cylinder  {
    <0, .45, 0>, <0, .55, 0>, 8.1
  }

  cylinder {
    <0, -.2, 0>, <0, .65, 0>, 8
  }
  texture {BlueMarble}
}

}

object {InnerCircle1 scale <1.73, 1, 1.73>}

object {InnerCircle2 scale <1.73, 1, 1.73>}


object {InnerCircle1 scale <1.96, 1, 1.96>}

object {InnerCircle2 scale <1.96, 1, 1.96>}


//Outer marble ring clean-up

difference {

  cylinder {
    <0, .45, 0>, <0, .55, 0>, 7
  }

  cylinder {
    <0, -.2, 0>, <0, .65, 0>, 6.9
  }

  box { <-.3, .45, 6.8>, <.3, .65, 7.2> }

  box { <-.3, .45, -6.8>, <.3, .65, -7.2> }

  box { <6.8, .45, .3>, <7.2, .65, -.3> }

  box { <-6.8, .45, .3>, <-7.2, .65, -.3> }

  texture {BlueMarble}
}

//Mountains

height_field {
  tga "test5.tga"
  water_level 0.05
  smooth
  texture{ ground1}
  translate<-.5, 0, -.5>
  scale <120, 0.3, 150>
  translate <.3, .2, .5>
}

height_field {
  tga "test0.tga"
  water_level 0.05
  texture { ground1 }
  translate <-.5, 0, -.5>
  scale <60, 14, 50>
  translate <-30, -10, 50>
}


height_field {
  tga "test0.tga"
  water_level 0.05
  texture { ground1 }
  translate <-.5, 0, -.5>
  scale <60, 14, 50>
  translate <-60, -10, 50>
}

height_field {
  tga "test0.tga"
  water_level 0.05
  texture { ground1 }
  translate <-.5, 0, -.5>
  scale <60, 14, 50>
  translate <-90, -10, 50>
}

height_field {
  tga "test1.tga"
  water_level 0.05
  texture { ground1 }
  translate <-.5, 0, -.5>
  scale <20, 2.5, 20>
  translate <0, -.3, 18>
}


//Base for Rose

cylinder { <0, -.6, 0>, <0, .85, 0>, 0.5
	pigment {White}
}

//Rose and RoseVase objects

object { Rose
  translate <0, 1.4, 0>
}

object { RoseVase
  translate <0, 1.4, 0>
}

//Spotlight shining on rose

light_source {
  <0, 3, 0>
  color White
  spotlight
  point_at <0, 1.2, 0>
  radius 15
  falloff 30
  tightness 1
}

//Bannister set up

object {Banister translate <0, 1, -7.65> rotate -30*y}

//Chalice

object { Cup scale .44 translate <0, 1.30, -6.75> rotate -30*y }

object { WineDrop }

//Toy boat

object { Toy_Boat
  translate <0, .74, -5>
  rotate  60*y
}

//Fountains

object { TheFountain translate <-1, .5, -5> }

object { TheFountain translate <2, .5, -5>}

//Light Mist

fog {
  fog_type 2
  distance 10
  color White
  turbulence 1.5
  turb_depth .9
  omega 1
  lambda 3
  octaves 4
  fog_offset .5
  fog_alt .3
  up <0, 1, 0>
}


camera {
   location  <3.7,  2,  -8>
   look_at   <-1,  .4,   0>
}

