#include "colors.inc"
#include "glass.inc"
#include "stones1.inc"
#include "metals.inc"
#include "woods.inc"
#include "remote.inc"

camera { location <0, 1, -3> look_at <10, -10, 50> }
sphere { 0, 1 pigment { rgbt 1 }
  hollow
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 pigment SkyBlue ]
      [ 0.9 pigment MidnightBlue ]
      [ 1 pigment Black ]
    }
  }
  scale 200
  translate <-75, 50, 520>
}
sphere { 0, 0.95
  texture {
    bozo
    turbulence 0.75
    texture_map {
      [0 pigment { bozo color_map { [ 0 color Khaki ] [ 0.5 color Khaki ] [ 1 color DarkGreen ] } scale 0.5 } normal { bumps 0.3 scale 0.1 } finish { crand 0.01 ambient 0 } ]
      [0.325 pigment { DarkGreen } finish { crand 0.01 ambient 0 } ]
      [0.4 pigment { SteelBlue } finish { specular 0.25 crand 0.01 ambient 0 } ]
      [1 pigment { SteelBlue } finish { specular 0.5 crand 0.01 ambient 0 } ]
    }
  }
  rotate y * -45
  scale 200
  translate <-75, 50, 520>
}
sphere { 0, 0.96
  texture {
    bozo
    turbulence 4
    texture_map {
      [0 pigment { LightGray transmit 0.4 } normal { bumps 0.5 scale 0.1 } ]
      [0.2 pigment { Clear } ]
      [1 pigment { Clear } ]
    }
    scale <0.5, 0.2, 0.2>
  }
  scale 200
  rotate x * 45
  translate <-75, 50, 520>
}
sky_sphere {
  pigment {
    bozo
    color_map {
      [0 color Black]
      [0.99 color Black]
      [1 color White]
    }
    scale 0.001
  }
}
//sky_sphere { pigment { MidnightBlue } }


difference {
  plane { z, 3 }
  box { <-10, -4, 1>, <10, 4, -9> }
  box { <-3, -1.7, -1>, <3, 1.7, 4> }
  box { <-2.7, -2, -1>, <2.7, 2, 4> }
  cylinder { <-2.7, -1.7, -1>, <-2.7, -1.7, 4>, 0.3 }
  cylinder { <-2.7, 1.7, -1>, <-2.7, 1.7, 4>, 0.3 }
  cylinder { <2.7, -1.7, -1>, <2.7, -1.7, 4>, 0.3 }
  cylinder { <2.7, 1.7, -1>, <2.7, 1.7, 4>, 0.3 }
  box { <-10, -10, 2.75>, <10, 10, 1.75> }
  box { <-10, -10, 1.5>, <10, 10, 1.25> }
  pigment { Gray }
  finish { crand 0.01 }
}

box { <-10, -10, 1.24>, <3.3, -2.3, 2.76>
  pigment { DimGray }
  finish { crand 0.01 }
  normal { hexagon rotate x * 90 }
}

box { <3.3, -2.3, 1.24>, <4, 2.3, 2.76>
  pigment { DimGray }
  finish { crand 0.01 }
  normal { hexagon rotate x * 90 }
}

cylinder { <3.15, -2.15, 1.24>, <3.15, -2.15, 2.76>, 0.05
  texture { T_Glass2 }
}

cylinder { <3.15, -2.15, 1.24>, <3.15, -2.15, 2.76>, 0.0375
  texture { T_Chrome_2A }
}

#declare joint=
union {
  cylinder { 0, z * -1, 0.125 }
  cylinder { <0, -0.5, -1.5>, <0, -1, -1.5>, 0.125 }
  difference {
    torus { 0.5, 0.125 rotate z * 90 translate <0, -0.5, -1> }
    plane { z * -1, 1 }
    plane { y, -0.5 }
  }
}

object { joint scale 0.5 translate <3.25, 1.5, 1.5> texture { T_Chrome_3A } }
object { joint scale 0.5 rotate z * 180 translate <3.25, -1.5, 1.5> texture { T_Chrome_3A } }
cylinder { <3.25, 1, 0.75>, <3.25, -1, 0.75>, 0.0625 texture { T_Chrome_3A normal { quilted scale 0.1 } } }
box { <-2.7, -2.1, 1>, <2.7, -2.6, -3> texture { T_Wood1 scale 0.5 } }
box { <-2.75, -2.05, 1>, <2.75, -2.65, 0.9> pigment { Gray } }
cylinder { <-2.75, -2.35, 1>, <-2.75, -2.35, 0.9>, 0.25 pigment { Gray } }
cylinder { <2.75, -2.35, 1>, <2.75, -2.35, 0.9>, 0.25 pigment { Gray } }


#declare sidedetail=
difference {
  box { <14, -7.5, 0>, <17.5, -2.5, 100>
    pigment {
      agate
      color_map {
        [ 0 color Blue ]
        [ 0.95 color MidnightBlue ]
        [ 1 color Black ]
      }
    }
    finish { metallic ambient 0 }
  }
  box { <14, -8, 0>, <17.5, -7.4, 100> pigment { DimGray } }
  box { <14, -2, 0>, <17.5, -2.6, 100> pigment { DimGray } }
  box { <14, -7.5, 99.9>, <17.5, -2.5, 100.1> pigment { DimGray } }
  cylinder { <17.5, -7.5, 10>, <17.5, -2.5, 10>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { specular 0.3 } }
  cylinder { <17.5, -7.5, 20>, <17.5, -2.5, 20>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { specular 0.3 } }
  cylinder { <17.5, -7.5, 30>, <17.5, -2.5, 30>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { specular 0.3 } }
  cylinder { <17.5, -7.5, 40>, <17.5, -2.5, 40>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }
  cylinder { <17.5, -7.5, 50>, <17.5, -2.5, 50>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }
  cylinder { <17.5, -7.5, 60>, <17.5, -2.5, 60>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }
  cylinder { <17.5, -7.5, 70>, <17.5, -2.5, 70>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }
  cylinder { <17.5, -7.5, 80>, <17.5, -2.5, 80>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }
  cylinder { <17.5, -7.5, 90>, <17.5, -2.5, 90>, 1 pigment { hexagon Gray, LightGray, DimGray scale 0.1 } finish { ambient 0 specular 0.3 } }

  box { <17.49, -3.25, 36.5>, <17.6, -3.75, 38.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 36.5>, <17.6, -5.25, 38.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 36.5>, <17.6, -6.75, 38.5> pigment { DimGray * 0.5 } finish { ambient 0 } }
  box { <17.49, -3.25, 34>, <17.6, -3.75, 36> pigment { DimGray * 0.5 } finish { ambient 0 } }
  box { <17.49, -4.75, 34>, <17.6, -5.25, 36> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 34>, <17.6, -6.75, 36> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 31.5>, <17.6, -3.75, 33.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 31.5>, <17.6, -5.25, 33.5> pigment { DimGray * 0.5 } finish { ambient 0 } }
  box { <17.49, -6.25, 31.5>, <17.6, -6.75, 33.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }

  box { <17.49, -3.25, 46.5>, <17.6, -3.75, 48.5> pigment { DimGray * 0.5 } finish { ambient 0 } }
  box { <17.49, -4.75, 46.5>, <17.6, -5.25, 48.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 46.5>, <17.6, -6.75, 48.5> pigment { DimGray * 0.5 } finish { ambient 0 } }
  box { <17.49, -3.25, 44>, <17.6, -3.75, 46> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 44>, <17.6, -5.25, 46> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 44>, <17.6, -6.75, 46> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -3.25, 41.5>, <17.6, -3.75, 43.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 41.5>, <17.6, -5.25, 43.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 41.5>, <17.6, -6.75, 43.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }

  box { <17.49, -3.25, 56.5>, <17.6, -3.75, 58.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 56.5>, <17.6, -5.25, 58.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 56.5>, <17.6, -6.75, 58.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 54>, <17.6, -3.75, 56> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 54>, <17.6, -5.25, 56> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 54>, <17.6, -6.75, 56> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 51.5>, <17.6, -3.75, 53.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 51.5>, <17.6, -5.25, 53.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 51.5>, <17.6, -6.75, 53.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }

  box { <17.49, -3.25, 66.5>, <17.6, -3.75, 68.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 66.5>, <17.6, -5.25, 68.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 66.5>, <17.6, -6.75, 68.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 64>, <17.6, -3.75, 66> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 64>, <17.6, -5.25, 66> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 64>, <17.6, -6.75, 66> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 61.5>, <17.6, -3.75, 63.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 61.5>, <17.6, -5.25, 63.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 61.5>, <17.6, -6.75, 63.5> pigment { DimGray * 0.5 } finish { ambient 0 } }

  box { <17.49, -3.25, 76.5>, <17.6, -3.75, 78.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 76.5>, <17.6, -5.25, 78.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 76.5>, <17.6, -6.75, 78.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 74>, <17.6, -3.75, 76> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 74>, <17.6, -5.25, 76> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 74>, <17.6, -6.75, 76> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 71.5>, <17.6, -3.75, 73.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 71.5>, <17.6, -5.25, 73.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 71.5>, <17.6, -6.75, 73.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }

  box { <17.49, -3.25, 86.5>, <17.6, -3.75, 88.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 86.5>, <17.6, -5.25, 88.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 86.5>, <17.6, -6.75, 88.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -3.25, 84>, <17.6, -3.75, 86> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 84>, <17.6, -5.25, 86> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 84>, <17.6, -6.75, 86> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 81.5>, <17.6, -3.75, 83.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 81.5>, <17.6, -5.25, 83.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -6.25, 81.5>, <17.6, -6.75, 83.5> pigment { DimGray * 0.5 } finish { ambient 0} }

  box { <17.49, -3.25, 96.5>, <17.6, -3.75, 98.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 96.5>, <17.6, -5.25, 98.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 96.5>, <17.6, -6.75, 98.5> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -3.25, 94>, <17.6, -3.75, 96> pigment { LightGray } finish { ambient 1 diffuse 0 specular 0.4} }
  box { <17.49, -4.75, 94>, <17.6, -5.25, 96> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 94>, <17.6, -6.75, 96> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -3.25, 91.5>, <17.6, -3.75, 93.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -4.75, 91.5>, <17.6, -5.25, 93.5> pigment { DimGray * 0.5 } finish { ambient 0} }
  box { <17.49, -6.25, 91.5>, <17.6, -6.75, 93.5> pigment { DimGray * 0.5 } finish { ambient 0} }
}


difference {
  union {
    cylinder {
      <30, 0, 0>, <30, 0, 100>, 15
      texture {
        checker
        texture { pigment { LightGray } finish { ambient 0 specular 0.35 metallic  } },
        texture { pigment { Gray } finish { ambient 0 specular 0.1 metallic  } }
        scale <0.5, 0.5, 1>
      }
    }
    sphere { <30, 0, 100>, 15 pigment { Gray } finish { ambient 0 } }
    scale <1, 0.67, 1>
    translate y * -5
  }
  object { sidedetail }
}

difference {
  cylinder { <30, 0, 50>, <30, 5, 50>, 10 pigment { Gray } finish { crand 0.05 specular 0.25 ambient 0 } }
  box { <19, 4.8, 49>, <30, 3.8, 51> pigment { DimGray } }
}

cylinder { <18.25, 1.55, 0>, <18.25, 1.55, 100>, 0.25 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <17.75, 1, 0>, <17.75, 1, 100>, 0.25 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <17, 0.25, 0>, <17, 0.25, 100>, 0.25 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 35>, <18, -1, 35>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 45>, <18, -1, 45>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 55>, <18, -1, 55>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 65>, <18, -1, 65>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 75>, <18, -1, 75>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 85>, <18, -1, 85>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }
cylinder { <18, 2, 95>, <18, -1, 95>, 1.5 texture { T_Chrome_3A } finish { ambient 0 } }

#declare evaguy=
union {
  cylinder { <0.25, 0.3, 0>, <0.25, 0.7, 0>, 0.1 }
  cylinder { <0.05, 0.7, 0>, <0.45, 0.7, 0>, 0.05 }
  cylinder { <0.05, 0.7, 0>, <0, 0.35, 0>, 0.035 }
  cylinder { <0.45, 0.7, 0>, <0.5, 0.35, 0>, 0.035 }
  cylinder { <0.15, 0.3, 0>, <0.1, 0, 0>, 0.035 }
  cylinder { <0.35, 0.3, 0>, <0.4, 0, 0>, 0.035 }
  sphere { <0.25, 0.85, 0>, 0.1 }
  light_source { <0, 0.34, 0> color White
    spotlight
    point_at <0.25, 0, -0.4>
    radius 0.3
    falloff 0.5
  }
  pigment { LightGray }
}

object { evaguy translate <16.25, -7.5, 42.5> }
object { evaguy rotate y * 90 translate <20, 3.8, 49.5> }

//box { <-10, -10, 2.75>, <10, 10, 1.75> texture { T_Glass3 } }
difference {
  box { <-10, -10, 1.5>, <10, 10, 1.25> texture { T_Glass3 } }
  box { <-2.1, 1.6, 1.51>, <-0.1, 1.00, 1.249> texture { T_Glass3 } }
}

object { remote no_shadow finish { ambient 0 } rotate y * -90 rotate z * -15 scale 0.5 translate <5, 0, 50> }

text {
  ttf "c:\windows\fonts\arialbd.ttf",
  "WARNING",
  0.001, 0
  pigment { rgbt <1, 0, 0, 0.7> }
  no_shadow
  finish { ambient 1 diffuse 0 }
  scale 0.25
  translate <-1.7, 1.35, 1.249999>
}

box { <-2.1, 1.6, 1.2499>, <-0.1, 1.00, 1.24999>
  pigment { rgbt <0.1, 0.1, 0, 0.9> }
  no_shadow
}

text {
  ttf "c:\windows\fonts\arialbd.ttf",
  "ARTIFICIAL GRAVITY OFFLINE",
  0.001, 0
  pigment { rgbt <1, 0, 0, 0.7> }
  no_shadow
  finish { ambient 1 diffuse 0 }
  scale 0.125
  translate <-2, 1.2, 1.249999>
}

text {
  ttf "c:\windows\fonts\arialbd.ttf",
  "ESTIMATED REPAIR TIME 0:37",
  0.001, 0
  pigment {rgbt <1, 0, 0, 0.7> }
  no_shadow
  finish { ambient 1 diffuse 0 }
  scale 0.125
  translate <-2, 1.05, 1.249999>
}

union {
  difference {
    cone { 0, 0.1, y * 0.5, 0.125 }
    cone { y * 0.05, 0.09, y * 0.51, 0.115 }
    texture { T_Glass3 }
  }
  intersection {
    sphere { <-0.116, 0.1, 0>, 0.125
      scale <0.5, 2, 0.5>
    }
    cone { y * 0.25, 0.09, y * 0.51, 0.115 }
    pigment { color rgbt <1, 0.9, 0, 0.3> }
    finish { phong 0.4 }
  }
  rotate z * 80
  rotate y * -45
  translate <0.75, 0, -0.5>
}

blob { threshold 0.25
  sphere { 0, 0.075, 0.6 }
  sphere { <0.03, -0.023, -0.02>, 0.075, 0.4 }
  pigment { color rgbt <1, 0.9, 0, 0.3> }
  finish { phong 0.4 }
  normal { ripples scale 0.025 }
  scale <1, 0.85, 1>
  translate <0.25, 0.25, -1>
}

blob { threshold 0.25
  sphere { 0, 0.1, 0.75 }
  sphere { <-0.035, -0.05, -0.035>, 0.1, 0.4 }
  sphere { <0.075, 0, 0>, 0.1, 0.6 }
  pigment { color rgbt <1, 0.9, 0, 0.3> }
  finish { phong 0.4 }
  normal { ripples scale 0.25 }
  scale 1.75
  scale <1, 0.85, 1>
  rotate y * -45
  translate <0, 0, -1.25>
}


light_source { <0, 3.75, -4> color White }
light_source { <100, 55, 200> color White
  spotlight
  point_at <-75, 50, 520>
  radius 200
  falloff 200
  tightness 1
}

