// The Saucer04 P.O.V. file
//
// This file built by Nick Stevens of Starbase One BBS.
// god@starbase.org
//

// Comments on how this was done...

/*
This is the POV code for a madly weaponed UFO thingy!


This one grew bit by bit rather than being planed at all, not the usual way
I work. I started with the idea of a lopsided leans for the basic shape,
and then remembered seeing some toys of some sort years ago where the shape 
was similar, but the outermost bits were extended on think rods - kind of 
a UFO with outriggers. I then rendered this for a basic shape, and added 
a hexagon texture to try and give the surface a bit more interest.

The next stage was the 'cockpit'.

The idea of a smaller squashed sphere lifted up, with a dark mirror
texture sounded good, and went in first time.


The shape was a bit boring so I scribbled on paper until I came up with
the fins - originallty these were going to be on the top only, but once
I worked out how to do them as squashed sphere's with cylindrical cutouts
there was a natural symetry, and I liked the look, so I ended up with 5 
of them rather than the two I planned.

I liked it at this stage, but it looked rather bland - and I wanted
something that looked agressive. So after a bit of thought I came up
with the guns, and then the punk spikes. The last touches were to add
the rocket nozzle at the back, and the torpedo thingy underneath.

I'm not totally convinced the torpedo works, which is why I ended up
merging it into the belly of the ship.
*/


// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions
#include "textures.inc" // Standard Texture definitions


// Starz1, by Nick Stevens
#declare Starz1 =
texture {
    pigment {
	granite
	color_map {
	    [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
	    [ 0.88  0.85 color Gray20 color Gray40 ] // Very Very Faint Stars
	    [ 0.90  0.88 color Gray40 color Gray60 ] // Very Faint Stars                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
	    [ 0.93  0.93 color Gray80 color Gray95 ] // Medium White Stars
	    [ 0.96  0.96 color Gray95 color White  ] // White Stars
	    [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
	}
    scale .015
    }
    finish { ambient 1 }
}
// Starz2, by Nick Stevens, (fainter)
#declare Starz2 =
texture {
    pigment {
	granite
	color_map {
	    [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
	    [ 0.88  0.85 color Gray20 color Gray30 ] // Very Very Faint Stars
	    [ 0.91  0.88 color Gray40 color Gray50 ] // Very Faint Stars                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
	    [ 0.92  0.93 color Gray80 color Gray85 ] // Medium White Stars
	    [ 0.95  0.95 color Gray95 color Gray90  ] // White Stars
	    [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
	}
    scale .015
    }
    finish { ambient 1 }
}

// The Starry Background

#declare supersky=union {

// Ball of stars for even coverage
sphere { <0,0,0> 1
	 texture {Starz1 scale 1.7}
	 scale 2000000
	 }

// Extra bands give the Milky Way effect

// Extra band of stars around the horizon, more distant
cylinder { <0,-0.1, 0> , <0, 0.1, 0> 1.2 open
	 texture {Starz2 scale 1.3}
	 scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.07, 0> , <0, 0.07, 0> 1.4 open
	 texture {Starz2 scale 1.1}
	 rotate <0, 90, 0>
	 scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.05, 0> , <0, 0.05, 0> 1.5 open
	 texture {Starz2 scale 1}
	 rotate <0, 180, 0>
	 scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.04, 0> , <0, 0.04, 0> 1.6 open
	 texture {Starz2 scale 1}
	 rotate <0, 270, 0>
	 scale 2000000
}

} // end union

object {supersky
	rotate < 85, 0, 0 > // set inclination to horizon
	rotate < 0, 180, 0>  // spin about the zenith
 hollow
}


// Get the textures declared up front. These tend to come in several flavours
// to add some subtle variety

#default {texture {finish {reflection 0.02 specular 0.13 ambient 0.02}}}

#declare Metallic =
texture {
    pigment { color LightGray }
    finish {
	ambient 0.02
	diffuse 0.7
	reflection 0.15
	brilliance 8
	specular 0.8
	roughness 0.1
    }
}

#declare GunT =
texture {
    pigment { color  green 0.63 blue 0.72 red 0.68}
    finish {
	ambient 0.35
	diffuse 0.85
	reflection 0.05
	brilliance 5
	specular 0.8
	roughness 0.1
    }
}
#declare GunT2 =
texture {
    pigment { color  green 0.7 blue 0.75 red 0.72}
    finish {
	ambient 0.35
	diffuse 0.85
	reflection 0.05
	brilliance 5
	specular 0.8
	roughness 0.1
    }
}
#declare GunT3 =
texture {
    pigment { color  green 0.67 blue 0.75 red 0.6}
    finish {
	ambient 0.35
	diffuse 0.85
	reflection 0.05
	brilliance 5
	specular 0.8
	roughness 0.1
    }
}


#declare MetalG1 =
texture {
    pigment { color  green 0.92 blue 0.45 red 0.3}
    finish {
	ambient 0.02
	diffuse 0.85
	reflection 0.15
	brilliance .5
	specular 0.8
	roughness 0.1
    }
}
#declare MetalG2 =
texture {
    pigment { color  green 1.0 blue 0.498039 red 0.2}
    finish {
	ambient 0.02
	diffuse 0.85
	reflection 0.15
	brilliance .5
	specular 0.8
	roughness 0.1
    }
}
#declare MetalG3 =
texture {
    pigment { color   green 1.0 blue 0.6 red 0.25}
    finish {
	ambient 0.02
	diffuse 0.75
	reflection 0.10
	brilliance .5
	specular 0.7
	roughness 0.05
    }
}

#declare Metal2 =
texture {
    pigment { color Gray95 }
    finish {
	ambient 0.02
	diffuse 0.85
	reflection 0.15
	brilliance 5
	specular 0.8
	roughness 0.1
    }
}

// The shiny reflective dome texture

#declare DomeT =
texture {
    pigment { color Gray95 }
    finish {
	ambient 0.02
	diffuse 0.15
	reflection 0.75
	brilliance 5
	specular 0.8
	roughness 0.01
    }
}


// Glass textures contributed by Norm Bowler, of Richland WA
#declare NBglass =
texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
	ambient 0.1
	diffuse 0.1
	reflection .25
	refraction 1
	ior 1.5
	specular 1
	roughness .001
    }
}
#declare NBoldglass=
texture {
    NBglass
    pigment { color rgbf <0.8, 0.9, 0.85, 0.85> }
}

camera {
   location  <0.95, 1.2, 2.43>
   direction <0, 0, 1.45>
   sky <0.1,1,0.65>
   look_at   <0, 0, 0.2>
}


// Alternate camera viewpoint

// There is no one view that shows all the features, so try several to 
// explore the object
/*
camera {
   location  <-2.45, 0.40, 1.93>
   direction <0, 0, 1.45>
   look_at   <0, 0, 0.2>
}
*/

#declare Sun=
sphere {<0,0,0> 100 pigment {White}}

light_source {<-2000, 4000, 1500> colour White looks_like {Sun} }



// The main body. This is sort of a flat unsymjentrical lens shape, got by
// verticaly squashing two spheres to different degrees, then adding the
// top half of one to the bottom half of the other


#declare Top= intersection {

// create a sphere shape
sphere { <0, 0, 0> 1 scale <1,0.3,1> }
plane  {<0,-1,0> 0}
 }

#declare Bottom= intersection {

// create a sphere shape
sphere { <0, 0, 0> 1 scale <1,0.15,1> }
plane  {<0,1,0> 0} }

#declare Body=union {
 object {Top}
 object {Bottom}
 cylinder {<0,0.2,0> <0,0.2,-0.7> 0.4 scale <1,0.5,1> translate <0,0.1,0>}
 sphere {<0,0.2,0> 0.4 scale <1,0.5,0.5> translate <0,0.1,0>}}

// Main body chunk with cutouts

#declare Segmented=difference{
 object {Body}
 box {< 0.6,100,100>< 0.7,-100,-100>}
 box {<-0.6,100,100><-0.7,-100,-100>}
  texture {
    hexagon
      texture { GunT },
      texture { GunT2 },
      texture { GunT3 }
     scale 0.02
 }
}

// The colours and hexagon texture are probably overdoing it somewhat,
// but as this is an over the top object anyway...


//Thick connecting rods to hold outriggers on!
#declare Rods = union {
 cylinder {<0.75,0, 0.0> <-0.75,0, 0.0> 0.05 texture {Metallic} }
 cylinder {<0.75,0, 0.5> <-0.75,0, 0.5> 0.05 texture {Metallic} }
 cylinder {<0.75,0,-0.5> <-0.75,0,-0.5> 0.05 texture {Metallic} }
}


// Bubble domes on the top surfce
#declare Cockpit=
union {
sphere { <0, 0.4, 0.45> 0.5 scale <1,0.35,1> texture {DomeT} }
sphere { <+0.32, 0.20, 0.17> 0.12 texture {DomeT} }
sphere { <-0.32, 0.20, 0.17> 0.12 texture {DomeT} }
sphere { <-0.45, 0.20, 0.29> 0.10 texture {DomeT} }
sphere { <+0.45, 0.20, 0.29> 0.10 texture {DomeT} }
}

// Comments on the guns
/*
I'm rather pleased with the way the guns turned out - they are utterly 
silly but certainly look like weapons - I grabbed what struck me as 
the distinctive bits of every sci fi weapon I could think of then added
some knobbly bits, and a glowing tip!

*/

// Start work on the guns - drawn to larger scale, then shrunk.

// Gunsleeve

#declare Sleeve = difference {
 cylinder {<0,7.5,0> <0,10,0> 0.5 }
 cylinder {<0,7.4,0> <0,11,0> 0.4 }

 cylinder {<-3,8,0> <+3,8,0> 0.23}
 cylinder {<0,8,-3> <0,8,+3> 0.23}
 cylinder {<-3,8.7,0> <+3,8.7,0> 0.23}
 cylinder {<0,8.7,-3> <0,8.7,+3> 0.23}
 cylinder {<-3,9.4,0> <+3,9.4,0> 0.23}
 cylinder {<0,9.4,-3> <0,9.4,+3> 0.23}
 texture {White_Marble}
 finish {ambient 0.7}
}

#declare Gun=
union {

  lathe {
    linear_spline
    10,
    <0, 0>, <1.3, 1>, <1.3,2>, <0.2, 3>, <0.2, 5>, <1.5, 5.5>, <1.5,6.5>, <0.2,7>, <0.2,11>, <0,11>
    texture {GunT}
  }

  cylinder {<0,11,0><0,11.2,0> 0.25
  pigment {Red}
  finish {ambient 0.85}
  }

  disc {<0,3,0>   <0,1,0> 1.5 0.7 pigment {White}   finish {Shiny ambient 0.3 reflection .35}}
  disc {<0,3.6,0> <0,1,0> 1.5 0.7 pigment {White}   finish {Shiny ambient 0.3 reflection .35}}
  disc {<0,4.2,0>   <0,1,0> 1.5 0.7 pigment {White}   finish {Shiny ambient 0.3 reflection .35}}

  object {Sleeve}

  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,000,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,040,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,080,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,120,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,160,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,200,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,240,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,280,0> }
  sphere {<1.3,6,0> 0.4 texture {Metallic} rotate <0,320,0> }
light_source
 {
  <0,11.2,0>
  color rgb <1 0 0>
  fade_distance 0.16
  fade_power 2
 }
}


// This is a kind of rocket nozzle sticking out the rear

#declare Nozzle=
  lathe {
    linear_spline
    9,
    <0   , 0.9>,
    <0.05, 1.00>
    <0.05, 1.05>
    <0.10, 1.10>
    <0.05, 1.15>
    <0.10, 1.20>
    <0.20, 1.35>
    <0.00, 1.15>
    <0.00, 0.9>

    texture {Metallic}
    finish {ambient 0.8}
   rotate <-90,0,0>
  }


// This is a kind of torpedo thingy merged underneath. I'm not entirely
// sure about it, but most views don't show the underside anyway


#declare Torpedo=
union{
 cylinder {<0,0,0.5> <0,0,-0.5> 0.15   texture {Metal2} }
 sphere {<0,0,0.5> 0.15 pigment {Red} finish {Shiny} }
 cone {<0,0,-0.5> 0.15 <0,0,-0.7> 0.04 texture {Metal2}}
 cone {<0,0,-0.7> 0.04 <0,0,-0.8> 0.1 open texture {Metal2}}
 cylinder {<0,0, 0.2> <0,0.3, 0.2> 0.05 texture {Metal2}}
 cylinder {<0,0,-0.2> <0,0.3,-0.2> 0.05 texture {Metal2}}
 }

#declare Gun2=
object {Gun scale 0.04 rotate <90,0,0>}


// The fins are basicly squashed sphere's with cylindrical cutouts
// This works surprisingly well for such a simple shape.


//Tail Fins

#declare Fin=
difference {
 sphere {<0,0,0> 2}
 cylinder { <-20,0,-2> <20,0,-2> 3}
 scale <0.10,0.6,1>
 scale 0.6
 pigment {White}
}

#declare UFO=union{
object {Segmented}
object {Rods}
object {Cockpit}


// Red knobs along the front
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0,  00,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0,  08,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0, -08,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0,  16,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0, -16,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0,  24,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0, -24,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0,  32,0> }
sphere {<0,0,0.92> 0.085 pigment {Red} finish {Shiny} rotate <0, -32,0> }


// These spikes are really silly for a spaceship, but they look mean!

// White horns forward
cone {<+0.5,0,0> 0.04 <+0.5,0.2,1.2> 0 pigment {White} finish {Shiny brilliance 0.31} }
cone {<-0.5,0,0> 0.04 <-0.5,0.2,1.2> 0 pigment {White} finish {Shiny brilliance 0.31} }
cone {<+0.5,0,0> 0.04 <+0.5,0.3,1.1> 0 pigment {White} finish {Shiny brilliance 0.31} }
cone {<-0.5,0,0> 0.04 <-0.5,0.3,1.1> 0 pigment {White} finish {Shiny brilliance 0.31} }
cone {<+0.5,0,0> 0.04 <+0.5,0.4,1.0> 0 pigment {White} finish {Shiny brilliance 0.31} }
cone {<-0.5,0,0> 0.04 <-0.5,0.4,1.0> 0 pigment {White} finish {Shiny brilliance 0.31} }

//trailling spikes
//cone {<+0.8,0,0> 0.07 <+0.8,0,-1.3> 0 pigment {White} finish {Shiny brilliance 0.1} }
//cone {<-0.8,0,0> 0.07 <-0.8,0,-1.3> 0 pigment {White} finish {Shiny brilliance 0.1} }

object {Gun2 translate < 1.05,0,0> }
object {Gun2 translate <-1.05,0,0> }
object {Gun2 translate <+0.2,-0.05,0.9> }
object {Gun2 translate <-0.2,-0.05,0.9> }
object {Gun2 scale 1.2 translate < 0.0,-0.05,0.95> }

object {Nozzle}
object {Torpedo translate <0,-0.1,0.1>}

object {Fin translate <0,0,-1.1> texture {GunT} }
object {Fin scale 0.7 translate <+0.43,0,-0.8> texture {GunT}}
object {Fin scale 0.7 translate <-0.43,0,-0.8> texture {GunT}}

object {Fin scale 0.45 translate <+0.77,0,-0.0> texture {GunT2}}
object {Fin scale 0.45 translate <-0.77,0,-0.0> texture {GunT2}}
}


// Add in the object, ready for viewing


// Note this means you can effectively remove the last line, (and 
// the supersky) and use this as an include file for the UFO object

object {UFO}
