// Persistence Of Vision raytracer version 3.0 
// Planet scape with astranout- for the Internet Ray Tracing Competition.
// By Brendan Gregg		
// 				c9607692@engmail.newcastle.edu.au
// --> If this needs to be better documentated then just email me and I will
//     add more comments throught the code. I had only 7 days to write this
//     for the competition and I did not get around to fixing the layout or
//     comments. Things are a bit rushed- sorry!

global_settings {number_of_waves 1}

camera {
   location <-70, 25, -150> 
   direction <0, 0, 1>
   up  <0, 1, 0>
   right <1.6, 0, 0>  //  4/3 is 640, 1.6 is 320  1.4 is 640???
   look_at <55,20,0>
}
light_source {<-6000, 10000, -10000> color rgb <0.66,0.66,0.66>}
light_source {<-5000, 10000, -10000> color rgb <0.66,0.66,0.66>}
light_source {<-9000, 10000, -10000> color rgb <0.66,0.66,0.66>}

difference{
lathe { cubic_spline    17
	<0,0> <0.2,0> <0.45,0> <0.455,0.008> <0.0456,0.0093> <0.0458,0.015> 
	<0.0459,0.018> <0.46,0.02> <0.462,0.03> <0.465 0.05>
	<0.47,0.1> <0.475,0.13> <0.48,0.16>
	<0.5,0.18> <0.599,0.201> <0.68,0.25> <0.75,0.4>
	scale <100,5,100>
	scale 0.9
	scale <1,1,3>
	rotate <0,-12,0>
	translate <-71.5,1.8,-85>
	clipped_by { box { <-72,-10,1000>,<200,200,-150>}}
//      sturm
texture{
      pigment {
	bozo
	turbulence 0.9
	octaves 6
	lambda 0.8
	omega 1.5
	color_map {
		  [0.0 color rgb <0.7,0.6,0.4>]        
		  [0.5 color rgb <0.8,0.7,0.5>]        
		  [1.0 color rgb <0.9,0.85,0.6>]        
		}
	scale 0.01
	translate<100,0,0>
    }
    normal {
	bumps 0.8
	scale 0.00001
    }
    finish{ ambient 0.4 }
    translate <-0.5, 0, -0.5>
    scale<1000,250,1000>
}
}
 cylinder { <0,-1,0>,<0,1,0>,0.45
	scale <100,5,100>
	scale 0.9
	scale <1,1,3>
	rotate <0,-12,0>
	translate <-71.5,1.8,-85>
	pigment { color red 1 blue 1 green 1 filter 1 }
} 
}

#declare Moon1 = sphere {<0,0,0>,20 texture{ 
		   pigment{ bozo color_map{
			    [0.0 color rgb <0.75,0.75,0.75>]
			    [0.05 color rgb <0.75,0.75,0.75>]
			    [0.1 color rgb <0.65,0.65,0.65>]
			    [0.1 color rgb <0.6,0.6,0.6>]
			    [0.3 color rgb <0.55,0.55,0.55>]
			    [0.4 color rgb <0.45,0.45,0.45>]
			    [0.45 color rgb <0.6,0.6,0.6>]
			    [0.6 color rgb <0.75,0.75,0.75>]
			    [0.7 color rgb <0.7,0.7,0.7>]
			    [0.95 color rgb <0.8,0.8,0.8>]
			    [1 color rgb <0.85,0.85,0.85>]}
			    turbulence 0.6 lambda 1.6 omega 0.80 octaves 10
			    scale 5 } } }

#declare Mount1 = texture{ //dark chunky caked dirt
    pigment {
	agate
	agate_turb 0.5
	color_map {
		[0.0 color rgb <0.20,0.10,0.08>]
		[0.2 color rgb <0.50,0.24,0.20>]
		[0.7 color rgb <0.32,0.18,0.15>]
		[0.9 color rgb <0.40,0.20,0.18>]
		}
	scale <0.5,2,0.5>
	scale 0.02 }
    finish{ ambient 0.5 } } 

#declare Mount2 = texture{ //chunky caked dirt
    pigment {
	agate
	agate_turb 0.5
	color_map {
		[0.0 color rgb <0.20,0.10,0.08>]
		[0.2 color rgb <0.54,0.27,0.21>]
		[0.7 color rgb <0.32,0.18,0.15>]
		[0.9 color rgb <0.44,0.24,0.20>]
		}
	scale <0.5,2,0.5>
	scale 0.02 }
    finish{ ambient 0.5 } } 

#declare Mount3 = texture{  //dark snow 
    pigment {
	bozo
	color_map {
		[0.0 color rgb <0.8,0.8,0.8>]
		[0.9 color rgb <0.8,0.8,0.8>]
		[1.0 color rgb <0.7,0.7,0.7>]
		}
	turbulence 0.2
	scale 0.001 }
    finish{ ambient 0.15 reflection 0.1 } } 

#declare Mount4 = texture{  //bright snow
    pigment {
	bozo
	color_map {
		[0.0 color rgb <1.0,1.0,1.0>]
		[0.9 color rgb <1.0,1.0,1.0>]
		[1.0 color rgb <0.8,0.8,0.8>]
		}
	turbulence 0.2
	scale 0.001 }
    finish{ ambient 0.25 reflection 0.1 } } 

height_field { //sand
    gif "map1a.gif"  
    smooth
    pigment {
	bozo
	turbulence 0.9
	octaves 6
	lambda 0.8
	omega 1.5
	color_map {
		  [0.0 color rgb <0.7,0.6,0.4>]        
		  [0.5 color rgb <0.8,0.7,0.5>]        
		  [1.0 color rgb <0.9,0.85,0.6>]        
		}
	scale 0.01
	translate<100,0,0>
    }
    normal {
	bumps 0.8
	scale 0.00001
    }
    finish{ ambient 0.4 }
    translate <-0.5, 0, -0.5>
    scale<1000,250,1000>
}
 
height_field { //grass 
    gif "mymap2.gif"  
    pigment {
	leopard
	color_map {
		[0.05 color rgb <0.50,0.24,0.20>]
		[0.3 color rgb <0.32,0.18,0.15>]
		[0.6 color rgb <0.44,0.24,0.20>]
		[0.7 color rgb <0.04,0.18,0.01>]
		[1.0 color rgb <0.08,0.31,0.01>]
		}
	turbulence 0.6
	octaves 5//6
	lambda 5
	omega 1.8
	scale <2,1.5,2>
	scale 0.0002
    }
    finish{ ambient 0.3 }
    translate <-0.5, 0, -0.5>
    scale<1000,250,1000>
    translate <0,-0.5,0>
    //clipped_by { 
    //  box { <-1001,250,1001>,<1001,-10,180> } }
    clipped_by { box { <-2000,500,2000>,<2000,-500,180> rotate <0,45,0> }}
}
    
height_field { //mountains
    gif "map1c.gif"
    texture {
	gradient y 
	texture_map {
    [0.00 Mount1]
    [0.68 Mount2]//0.66
    [0.74 Mount3]//0.70
    [1.00 Mount4]
    }
    turbulence 0.15//0.15
    octaves 5//5
    lambda 5//5
    omega 0.5//0.5
    scale <0.08,0.84,0.09>
    }
    translate <-0.5, 0, -0.5>    
    scale<1000,250,1000>
}

box { <-1500,1.895,1000>,<1000,0,-1500> //y1.4  or 1.5 to rid of all black 
	pigment { waves
		color_map {
		[0.00 color rgb <0.0,0.05,0.5>]
		[0.75 color rgb <0.0,0.1,0.6>]
		[0.95 color rgb <0.04,0.14,0.7>]
		}
		turbulence 0.8
		octaves 5
		lambda 7
		omega 1.0
		scale 1.2
		translate <-500,0,-100>
		}
	finish{ ambient 1.0 reflection 0.5 diffuse 0.0 }
	normal{ dents 0.5 scale 1 }
}
plane { y,-1
	pigment { waves
		color_map {
		[0.00 color rgb <0.0,0.05,0.5>]
		[0.75 color rgb <0.0,0.1,0.6>]
		[0.95 color rgb <0.04,0.14,0.7>]
		}
		turbulence 0.8
		octaves 5
		lambda 7
		omega 1.0
		scale 1.2
		translate <-500,0,-100>
		}
	finish{ ambient 1.0 reflection 0.5 diffuse 0.0 }
	normal{ dents 0.5 scale 1 }
}
object { Moon1 scale 75 translate <9000,2700,5000> } //y2400


sphere{ <0,0,0>,10000 pigment { bozo  //Star sphere
		color_map {
			[0.00 color rgb <0,0,0>]
			[0.95 color rgb <0,0,0>]
			[0.98 color rgb <1,1,1>]
			[1.00 color rgb <1,1,1>]
			}
			scale 15
		}
		finish { ambient 1.0 }
	scale 5
}

#declare MyCloth1 = texture {//dark and patchy
	pigment { bozo color_map {
		[0.0 color rgb <0.6,0.6,0.6> ]
		[0.2 color rgb <0.7,0.7,0.7> ]
		[0.5 color rgb <0.9,0.9,0.9> ]
		[1.0 color rgb <1.0,1.0,1.0> ]}
	turbulence 0.8
	lambda 2
	octaves 5
	omega 0.6
	scale <2,0.2,1>
	scale 3
	} 
	normal { bumps 1.8 scale 4 }
	finish { ambient 0.5 diffuse 0.3 }
	}
#declare MyCloth2 = texture {  //vertical wonky creases
	pigment { gradient y color_map {
		[0.0 color rgb <1.0,1.0,1.0> ]
		[0.4 color rgb <0.75,0.75,0.75> ]
		[0.5 color rgb <0.5,0.5,0.5> ]
		[0.6 color rgb <0.75,0.75,0.75> ]
		[1.0 color rgb <1.0,1.0,1.0> ]}
	turbulence 0.3
	lambda 1.5
	octaves 5
	omega 1.0
	scale <1,0.12,1>
	scale 4
	} 
	finish { ambient 0.5 diffuse 0.3 }
	}
#declare MyCloth3 = texture {//very wrinkly in all directions
	pigment { bozo color_map {
		[0.0 color rgb <0.6,0.6,0.6> ]
		[0.16 color rgb <0.65,0.65,0.65> ]
		[0.2 color rgb <0.7,0.7,0.7> ]
		[0.5 color rgb <0.9,0.9,0.9> ]
		[1.0 color rgb <1.0,1.0,1.0> ]}
	turbulence 0.8
	lambda 0.8
	octaves 5
	omega 1.8
	scale <2,1,2>
	scale 1
	} 
	finish { ambient 0.5 diffuse 0.3 }
	}
#declare MyCloth4 = texture {//smooth and plain
	pigment { bozo color_map {
		[0.0 color rgb <0.75,0.75,0.75> ]
		[0.16 color rgb <0.8,0.8,0.8> ]
		[0.2 color rgb <0.85,0.85,0.85> ]
		[0.5 color rgb <0.9,0.9,0.9> ]
		[1.0 color rgb <1.0,1.0,1.0> ]}
	turbulence 0.01
	lambda 8
	octaves 8
	omega 1
	scale <2,1,2>
	scale 1
	} 
	finish { ambient 0.6 diffuse 0.3 }
	}
#declare MyCloth5 = texture {//very wrinkly in all directions and dark!
	pigment { bozo color_map {
		[0.0 color rgb <0.6,0.6,0.6> ]
		[0.16 color rgb <0.65,0.65,0.65> ]
		[0.2 color rgb <0.7,0.7,0.7> ]
		[0.5 color rgb <0.6,0.6,0.6> ]
		[1.0 color rgb <0.7,0.7,0.7> ]}
	turbulence 0.9
	lambda 0.8
	octaves 5
	omega 2.0
	scale <2,1,2>
	scale 1
	} 
	normal { bumps 0.3 scale 0.5 } //remember to fix!!!!!! <----
	finish { ambient 0.3 diffuse 0.3 }
	}
#declare Rubber1 = texture {
	pigment { gradient z color_map {
		[0.0 color rgb <0.2,0.2,0.2>]
		[0.7 color rgb <0.4,0.4,0.4>]
		[0.8 color rgb <0.6,0.6,0.6>]
		[1.0 color rgb <0.6,0.6,0.6>]}
		}
	scale 0.2 
	finish { ambient 0.6 diffuse 0.2 phong 0.3 phong_size 20 }
	}
#declare Leg1 = object {
  sor { 8
	<0.05,0> <0.1,0.05> <0.14,0.2> 
	<0.135,0.4>
	<0.148,0.48> <0.14,0.7> <0.18,0.9> //0.15
	<0.18,1.0>
	scale 10
	scale <1.1,1,1.1>
	texture { gradient y
		texture_map {
			[0.0 MyCloth2 scale 0.07]
			[0.1 MyCloth2 scale 0.07]
			[0.2 MyCloth4 scale 0.07]
			[0.8 MyCloth4 scale 0.07]
			[0.9 MyCloth2 scale 0.07]
			[1.0 MyCloth2 scale 0.07] }
		scale 10 }
	sturm
	}
	bounded_by { cylinder { <0,0,0>,<0,10.5,0>,2 } }
	}
#declare Leg2 = object {
  sor { 8
	<0.05,0> <0.1,0.05> <0.14,0.2> 
	<0.135,0.4>
	<0.148,0.48> <0.14,0.7> <0.18,0.9> //0.15
	<0.18,1.0>
	scale 10
	scale <1.1,1,1.1>
	texture { gradient y
		texture_map {
			[0.0 MyCloth2 scale 0.07]
			[0.1 MyCloth2 scale 0.07]
			[0.2 MyCloth4 scale 0.07]
			[0.8 MyCloth4 scale 0.07]
			[0.85 MyCloth2 scale 0.07]
			[1.0 MyCloth2 scale 0.07] }
		translate <10,0,0>
		scale 10 }
	sturm
	}
	bounded_by { cylinder { <0,0,0>,<0,10.5,0>,2 } }
	}
#declare MyGloss1 = finish { reflection 0.7 specular 0.9 roughness 0.01 }
#declare BumpMetal1 = texture { pigment { color rgb <0.8,0.8,0.8> } 
			  finish { reflection 0.7 specular 0.9 roughness 0.01}
			  normal { bumps 0.9 scale <0.45,0.2,0.5> }
			  }

#declare ShoeCloth1 = texture { MyCloth5 scale 3 }
#declare Shoe1 = union { 
	sphere { <0,0,0>,1 
		scale <2,1,2.5>
		translate <0,1,-4>
		texture { ShoeCloth1 }
		}
	cylinder { <0,0,-4>,<0,0,0>,1
		scale <2,1,1>
		translate <0,1,0>
		texture { ShoeCloth1 }
		}
	cylinder { <0,0,0>,<0,1,0>,1
		scale <2,1,2.5>
		translate <0,0,-4>
		texture { Rubber1 }
		}
	box { <-2,0,-4>,<2,1,0>
		texture { Rubber1 }
		}
	cylinder { <0,1,0>,<0,5,0>,2
		texture { ShoeCloth1 }
		}
	cylinder { <0,4,0>,<0,4.9,0>,2.3
		texture { BumpMetal1 }
		}
	cylinder { <0,0,0>,<0,1,0>,2
		texture { Rubber1 }
		}
	torus { 4,2 
		rotate <0,0,90>
		translate <0,4,-4>
		texture { ShoeCloth1 }
		clipped_by { box { <-4,0,-4>,<4,4,0> } } 
	      }
	      clipped_by { box { <-5,10,-10>,<5,0.2,10> } }
	      bounded_by { box { <-2.5,6,-7>,<2.5,0,3> } }
}        
#declare DP = object{ 
	torus { 3,0.5 
		bounded_by { cylinder { <0,-1,0>,<0,1,0>,5 } }
		rotate <0,0,90> 
		clipped_by { box { <-5,0,-5>,<5,-5,2> } }
		texture { MyCloth3 scale 0.6 }
		sturm
		}}
#declare Torso1 = union {             
	//cylinder { <0,0,0>,<0,7,0>,2 scale <2,1,0.9>
	superellipsoid { <0.8,0.5> rotate <90,0,0>
		scale <4,4,2.2> translate <0,3,0>
		//texture { pigment { rgb <1,1,1> } }
		texture { gradient y texture_map {
		[0.0 MyCloth2 scale 0.06]
		[0.1 bozo texture_map {
			[0.0 MyCloth3]
			[0.4 MyCloth4]
			[1.0 MyCloth4]} 
		  turbulence 0.4 lambda 0.3 octaves 4 omega 0.1 scale 0.2 ]
		[0.77 bozo texture_map {
			[0.0 MyCloth3]
			[0.5 MyCloth4]
			[1.0 MyCloth4]} 
		  turbulence 0.4 lambda 0.3 octaves 4 omega 0.1 scale 0.1 ]
		[0.9 MyCloth3 scale 0.081]
		[0.93 MyCloth3 scale 0.081]
		[1.0 MyCloth2 scale 0.06]
		} scale 7 }
		clipped_by { plane { y,0.5 rotate <180,0,0> } }
		}
	box { <-1.4,4.5,-2.4>,<1.4,6,0> texture { MyCloth4 
			normal { bumps 0.6 scale 0.4 } }
			} //chest box
	box { <-0.5,6.1,-2.41>,<0,5,0> texture { pigment { rgb <0.5,0.5,0.5> }
		finish { reflection 0.7 specular 0.7 roughness 0.02 }
		normal { dents 0.5 scale 0.05 }
		}}//front grey bit
	cylinder { <-1.5,4.7,-2.3>,<-1.5,5.5,-2.3>,0.12 texture {
			pigment { rgb <0.1,0.1,0.1> }
			finish { MyGloss1 }
		}}//left cylinders
	cylinder { <-1.5,5.5,-2.3>,<-1.5,5.8,-2.3>,0.13 texture {
			pigment { rgb <1,1,1> }
			finish { MyGloss1 }
		}}
	cylinder { <-1.5,5,-2.3>,<-1.5,5.1,-2.3>,0.18 texture {
			pigment { rgb <1,1,1> }
			finish { MyGloss1 }
		}}
	cylinder { <-1.5,4.7,-2.3>,<-1.5,5.5,-2.3>,0.12 texture {
			pigment { rgb <0.1,0.1,0.1> }
			finish { MyGloss1 }
		}}//right large cylinders
	cylinder { <1.6,5.5,-2.3>,<1.6,5.9,-2.3>,0.22 texture {
			pigment { rgb <0.1,0.1,0.1> }
			finish { MyGloss1 }
		}}
	cylinder { <1.6,5.75,-2.3>,<1.6,5.85,-2.3>,0.23 texture {
			pigment { rgb <0.5,0.5,0.5> }
			finish { MyGloss1 }
		}}
	box { <1.41,5.75,-2.41>,<1.1,5.85,0> texture {
			pigment { rgb <0.5,0.5,0.5> }
			finish { MyGloss1 }
		}}
	sphere { <0.8,5.95,-2.09>,0.3 texture {
			pigment { rgb <0.3,0.3,0.3> }
			finish { MyGloss1 }
		}}
	box { <0.9,4.6,-2.405>,<1.3,4.73,0> pigment { rgb <0,0,0> } }
	box { <0.3,4.6,-2.405>,<0.7,4.73,0> pigment { rgb <0,0,0> } }
	box { <0.9,4.8,-2.405>,<1.3,4.93,0> pigment { rgb <0,0,0> } }
	box { <0.3,4.8,-2.405>,<0.7,4.93,0> pigment { rgb <0,0,0> } }
	// big grey front bit
	box { <-0.6,3.5,-2.3>,<0.6,5,0> texture { MyCloth5 scale 0.1 } }
	//left air connection
	cylinder { <-1.2,2.5,0>,<-1.2,2.5,-2.3>,0.7 texture {
			pigment { rgb <0.2,0.2,0.2> }
			finish { MyGloss1 }
		}}
	cylinder { <-1.2,2.5,-2.3>,<-1.2,2.5,-2.6>,0.4 texture {
			pigment { rgb <0.6,0.6,0.6> }
			finish { MyGloss1 }
		}}
	sphere { <-1.2,2.5,-2.6>,0.38 texture {
			pigment { rgb <0.6,0.6,0.6> }
			finish { MyGloss1 }
		}}
	cylinder { <-1.2,2.5,-2.5>,<-3.5,1,-2.2>,0.2  //pipes
		texture { MyCloth1 scale 0.02 } }
	cylinder { <-1.5,4.7,-2.5>,<-3.5,0.5,-2.0>,0.2 //pipes
		texture { MyCloth1 scale 0.02 } }
	//red connection
	cylinder { <-1.2,1,0>,<-1.2,1,-2.3>,0.5 texture {
		pigment { rgb <0.6,0.34,0.34> }
		finish { MyGloss1 }
		normal { bumps 1.0 scale 0.05 }
		}}
	//right air connection
	cylinder { <1.2,2.4,0>,<1.2,2.4,-2.3>,0.7 texture {
			pigment { rgb <0.2,0.2,0.2> }
			finish { MyGloss1 }
		}}
	cylinder { <1.2,2.4,-2.3>,<1.2,2.4,-2.6>,0.4 texture {
			pigment { rgb <0.6,0.6,0.6> }
			finish { MyGloss1 }
		}}
	sphere { <1.2,2.4,-2.6>,0.38 texture {
			pigment { rgb <0.6,0.6,0.6> }
			finish { MyGloss1 }
		}}
	cylinder { <1.65,5.5,-2.3>,<2.8,2.4,-2.3>,0.2
		texture { MyCloth1 scale 0.05 } }
	torus { 0.8,0.2 rotate <90,0,0> 
		clipped_by { box { <-5,0,-5>,<5,-5,5> } }
		translate <2,2.4,-2.3> 
		texture { MyCloth1 scale 0.05 } }
	//red thing
	cylinder { <0.2,1,-2.2>,<0.2,1,0>,0.2 texture {
		pigment { color rgb <0.9,0.3,0.3> }
		finish { MyGloss1 }
		}}
	//lower right air
	cylinder { <1.2,1.0,0>,<1.2,1.0,-2.3>,0.5 texture {
			pigment { rgb <0.2,0.2,0.2> }
			finish { MyGloss1 }
		}}
	cylinder { <1.2,1.0,0>,<1.2,1.0,-2.5>,0.3 texture {
			pigment { rgb <0.2,0.2,0.2> }
			finish { MyGloss1 }
		}}
	sphere { <1.2,1,-2.5>,0.2 texture {
			pigment { rgb <0.2,0.2.0.2> }
			finish { MyGloss1 }
		}}
	cylinder { <1.2,1.0,-2.5>,<1.95,0.8,-2.5>,0.15 texture {
			pigment { rgb <0.2,0.2,0.2> }
			finish { MyGloss1 }
		}}
}
#declare HandCloth1 = texture { MyCloth5 scale 1 }
#declare Arm1 = union {
	cylinder { <0.5,0.9,0>,<2,1.4,0>,2 texture { MyCloth4 scale 0.3 } }
	cylinder { <1.3,1.3,0>,<-1,-1,0>,2.05 texture { bozo
		texture_map {
			[0.0 MyCloth2 scale 0.7 rotate <0,0,-45>]
			[0.2 MyCloth2 scale 0.7 rotate <0,0,-45>]
			[1.0 MyCloth4 scale 0.6]} }
		 translate <0,0,0> }
	cone { <-1,7,0>,2,<-1,0,0>,1.3 texture { gradient y
		texture_map {
			[0.0 MyCloth2 scale 0.05]
			[0.1 MyCloth1 scale 0.05]
			[0.3 MyCloth1 scale 0.05]
			[0.45 MyCloth2 scale 0.05]
			[0.55 MyCloth2 scale 0.05]
			[0.6 MyCloth1 scale 0.05]
			[0.9 MyCloth1 scale 0.05]
			[1.0 MyCloth3 scale 0.06]
			} scale 7 }
	translate <0,-8,0>
	}
	torus { 6,2 rotate <90,0,0> 
		clipped_by { box { <-100,100,100>,<100,0,-100> 
			rotate <0,0,-10> } }
		clipped_by { box { <-100,-100,100>,<100,0,-100> 
			rotate <0,0,-26> } }
		translate <4.8,-3,0>
		texture { bozo 
		  texture_map {
			[0.0 MyCloth3 scale 0.5]
			[0.5 MyCloth3 scale 0.5]
			[1.0 MyCloth4 scale 0.6]
			}}
		}
	object{ union {
	//cylinder { <-2,-7.5,0>,<-2,-9.5,0>,1.3 scale <1,1,0.5>
	superellipsoid { <0.4,1> scale <1.3,1.1,0.65>
		translate <-2,-8.5,0>
		translate <0,0,-0.4> texture { HandCloth1 }
		}
	cylinder { <-2,-7.5,0>,<-2,-8.2,0>,1.31 scale <1,1,0.5>
		translate <0,0,-0.4> pigment { rgb <0.2,0.2,0.2> }
		finish { MyGloss1 }
		}
	cylinder { <-2.9,-7.5,-0.0>,<-2.9,-10.0,-0.0>,0.26
		texture { HandCloth1 } } //a finger
	cylinder { <-2.3,-7.5,-0.2>,<-2.3,-10.4,-0.2>,0.33
		texture { HandCloth1 } }
	cylinder { <-1.7,-7.5,-0.3>,<-1.7,-10.6,-0.3>,0.33
		texture { HandCloth1 } }
	cylinder { <-1.05,-7.5,-0.2>,<-1.05,-10.5,-0.2>,0.33
		texture { HandCloth1 } }
	cylinder { <-1,-7.5,0.2>,<-1,-10,0.2>,0.30
		texture { HandCloth1 } }
	sphere { <-2.9,-10,0>,0.26
		texture { HandCloth1 } } //a finger joint
	sphere { <-2.3,-10.4,-0.2>,0.33
		texture { HandCloth1 } }
	sphere { <-1.7,-10.6,-0.3>,0.33
		texture { HandCloth1 } }
	sphere { <-1.05,-10.5,-0.2>,0.33
		texture { HandCloth1 } } 
	sphere { <-1,-10,0.2>,0.30
		texture { HandCloth1 } } 
	}
	translate <1,0.3,0> } //here it is
}
#declare Arm3 = union {
	cylinder { <0.5,0.9,0>,<2,1.4,0>,2 texture { MyCloth4 scale 0.3 } }
	cylinder { <1.3,1.3,0>,<-1,-1,0>,2.05 texture { bozo
		texture_map {
			[0.0 MyCloth2 scale 0.7 rotate <0,0,-45>]
			[0.2 MyCloth2 scale 0.7 rotate <0,0,-45>]
			[1.0 MyCloth4 scale 0.6]} }
		 translate <0,0,0> }
	cone { <-1,7,0>,2,<-1,0,0>,1.3 texture { gradient y
		texture_map {
			[0.0 MyCloth2 scale 0.05]
			[0.1 MyCloth1 scale 0.05]
			[0.3 MyCloth1 scale 0.05]
			[0.45 MyCloth2 scale 0.05]
			[0.55 MyCloth2 scale 0.05]
			[0.6 MyCloth1 scale 0.05]
			[0.9 MyCloth1 scale 0.05]
			[1.0 MyCloth3 scale 0.06]
			} scale 7 }
	translate <0,-8,0>
	}
	torus { 6,2 rotate <90,0,0> 
		clipped_by { box { <-100,100,100>,<100,0,-100> 
			rotate <0,0,-10> } }
		clipped_by { box { <-100,-100,100>,<100,0,-100> 
			rotate <0,0,-26> } }
		translate <4.8,-3,0>
		texture { bozo 
		  texture_map {
			[0.0 MyCloth3 scale 0.5]
			[0.5 MyCloth3 scale 0.5]
			[1.0 MyCloth4 scale 0.6]
			}}
		}
	object{ union {
	//cylinder { <-2,-7.5,0>,<-2,-9.5,0>,1.3 scale <1,1,0.5>
	superellipsoid { <0.4,1> scale <1.3,1.1,0.65>
		translate <-2,-8.5,0>
		translate <0,0,-0.4> texture { HandCloth1 }
		}
	cylinder { <-2,-7.5,0>,<-2,-8.2,0>,1.31 scale <1,1,0.5>
		translate <0,0,-0.4> pigment { rgb <0.2,0.2,0.2> }
		finish { MyGloss1 }
		}
	cylinder { <-2.9,-7.5,-0.0>,<-2.9,-10.0,-0.0>,0.26
		texture { HandCloth1 } } //a finger
	cylinder { <-2.3,-7.5,-0.2>,<-2.3,-10.4,-0.2>,0.33
		texture { HandCloth1 } }
	cylinder { <-1.7,-7.5,-0.3>,<-1.7,-10.6,-0.3>,0.33
		texture { HandCloth1 } }
	cylinder { <-1.05,-7.5,-0.2>,<-1.05,-10.5,-0.2>,0.33
		texture { HandCloth1 } }
	cylinder { <-2.9,-8,0.7>,<-2.9,-9,0.6>,0.28
		texture { HandCloth1 } }
	sphere { <-2.9,-10,0>,0.26
		texture { HandCloth1 } } //a finger joint
	sphere { <-2.3,-10.4,-0.2>,0.33
		texture { HandCloth1 } }
	sphere { <-1.7,-10.6,-0.3>,0.33
		texture { HandCloth1 } }
	sphere { <-1.05,-10.5,-0.2>,0.33
		texture { HandCloth1 } } 
	sphere { <-2.9,-9,0.6>,0.28
		texture { HandCloth1 } } 
	}
	translate <2,0,0> rotate <0,-135,0> translate <-1,0.5,0> }
}


#declare Head1 = union {
	sphere { <0,0,0>,3 texture { pigment { color rgb <0.8,0.5,0.2> }
		finish { reflection 0.85 specular 0.98 roughness 0.0001
			diffuse 0.01 ambient 0.005 brilliance 4
			metallic}
		} } 
	difference {
	 sphere { <0,0,0>,3.15 texture { pigment { 
			color rgb <0.85,0.85,0.85> }
		finish { ambient 0.5 diffuse 0.3 } } }
	 union {
	   box { <-10,0.9,-10>,<10,-20,-1.0> }
	   box { <-10,0,-10>,<10,-20,-1.0> rotate <30,0,0> translate <0,0.9,0> }
		texture { pigment { color rgb <0.85,0.85,0.85> }
		finish { ambient 0.5 diffuse 0.3 } }
	 }
		texture { pigment { color rgb <0.85,0.85,0.85> }
		finish { ambient 0.5 diffuse 0.3 } }
	 }
	difference {
	 sphere { <0,0,0>,3.05 texture { pigment { 
			color rgb <0.9,0.9,0.9> }
		finish { ambient 0.85 diffuse 0.3 } } }
	 union {
	   box { <-10,0.9,-10>,<10,-2,-1.0> }
	   box { <-10,0,-10>,<10,-2,-1.0> rotate <30,0,0> translate <0,0.9,0> }
	   box { <-10,0,-10>,<10,2,-1.0> rotate <-30,0,0> translate <0,-2,0> }
		texture { pigment { color rgb <0.85,0.85,0.85> }
		finish { ambient 0.5 diffuse 0.3 } }
	 }
		texture { pigment { color rgb <0.85,0.85,0.85> }
		finish { ambient 0.5 diffuse 0.3 } }
	 translate <0,0,-0.1>
	 }
}

#declare BackPack1 = union {
	superellipsoid { <0.2,0.3> scale <3.3,4,2>
		texture { MyCloth4 }
		translate <-0.47,15,4>
		}
	torus { 3,0.2 rotate <90,-10,0>
		clipped_by { box { <0,9,-9>,<-9,-9,9> } }
		translate <-1.8,14.5,2> 
		texture { MyCloth1 scale 0.02 } }
	box { <2.2,18,1.95>,<2.7,18.2,3> texture {
		pigment { color rgb <0.3,0.3,0.3> }
		} }
	box { <-2,19,2.4>,<2,15,3.8> texture { MyCloth4 } }
}
#declare Arm2 = union { //I ran out of time to finish this arm
	cylinder { <-3,1.5,0>,<-0.6,0.9,0>,2 texture { MyCloth4 scale 0.3 }}
	cone { <-3.6,0.9,0>,2,<1,1.3,0>,1.8 texture { MyCloth2 scale 0.7
					rotate <0,0,90> }}
	torus { 5,1.7 rotate <-60,0,0> scale <1,1,0.6>
		clipped_by { box { <0,100,100>,<100,-100,-100> } }
		clipped_by { box { <0,100,100>,<100,-100,-100> } 
			rotate <0,-50,0>}//-15
		translate <-2.0,3.5,-4>
		texture { bozo 
		  texture_map {
			[0.0 MyCloth3 scale 0.5]
			[0.2 MyCloth3 scale 0.5]
			[1.0 MyCloth4 scale 0.6]
			}}
		  }


}

object { union { //The full astranout.
	object { Leg1 rotate <0,0,-5> translate <-3,0,0> }
	object { Leg2 rotate <0,0,11> translate <3,0.2,0> }
	object { Shoe1 scale 0.56 translate <-3,-1.7,0> }
	object { Shoe1 rotate <0,0,6> scale 0.56 translate <3.2,-1.8,0> }
	object { DP  scale<1.8,0.45,0.45> translate <-0.4,9,0> }
	object { Torso1 scale <0.97,1.05,0.95> translate <-0.47,9,0.1> }
	object { Arm1 rotate <0,0,-12> scale 0.78 translate <-4.2,14,0.1> }
	object { Head1 scale 0.9 scale <1,0.87,1> translate <-0.47,17.7,-0.7> }
	object { BackPack1 scale 1 translate <0,0.5,0> }
	//object { Arm2 rotate <0,0,12> scale 0.78 translate <4.2,14,0.1> }
	object {Arm3 rotate <0,0,-14> scale 0.78 translate <-3.6,13.8,0.1>
		rotate <0,180,0> }
	scale 1
	rotate <0,38,0>
	translate <2,0,0>
}
translate <5,13,-50>     }


	



