//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 18 textures and 369 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.0.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/14/1996    (14.10.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera Camera01
  location  <10.000, 500.000, 30.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 15.000>
}

// *******  L I G H T S *******
light_source { // ToLightScene
  <0.000, 875.000, 175.000>
  color  rgb .5
  area_light <200.000, 0.000, 0.000>, <0.000, 70.711, -70.711>, 10, 3
  adaptive 1
  jitter
}
sky_sphere {   pigment {      gradient y      color_map {        [0.000 0.002 color rgb <1.0, 0.2, 0.0>                     color rgb <1.0, 0.2, 0.0>]        [0.002 0.200 color rgb <0.8, 0.1, 0.0>                     color rgb <0.2, 0.2, 0.3>]      }}


// ********  TEXTURES  *******
//

#include "sacrifce.inc"



// ********  REFERENCED OBJECTS  *******


#declare Curve_A_1 = difference {
  torus { // Curve_P_A_1
    0.75, 0.1  rotate -x*90
  }
  box { // Curve_Cut_A_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.85, 0.425, 0.1>
    translate  0.425*y
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.5, 0.75, 0.75>
}
#declare Curve_B_1 = difference {
  torus { // Curve_P_B_1
    0.75, 0.1  rotate -x*90
  }
  box { // Curve_Cut_B_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.85, 0.425, 0.1>
    translate  0.425*y
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.5, 0.75, 0.75>
}
#declare Head_T_1 = union {
  sphere { // Head1
    <0,0,0>,1
  }
  object { Curve_A_1 }
  object { Curve_B_1 }
  sphere { // Tip_A_1
    <0,0,0>,1
    scale 0.25
    translate  <0.5, 1.5, 0.75>
  }
  sphere { // Tip_B_1
    <0,0,0>,1
    scale 0.25
    translate  <-0.5, 1.5, 0.75>
  }
  sphere { // Eye_A_1
    <0,0,0>,1
    texture {
      Eye_T2
    }
    scale 0.375
    translate  <0.0, 1.0, 0.15>
  }
  rotate -45.0*x
  translate  2.0*z
}
#declare Pilgrim = union { // Pilgrim1
  object { Head_T_1 }
  cone { // LegPar_D_1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.1875, 0.1875, 2.5>
    rotate 94.0*x
    translate  <1.0, -2.325, 0.1875>
  }
  sphere { // Joint_F_1
    <0,0,0>,1
    scale 0.19
    translate  <1.0, -2.325, 0.19>
  }
  sphere { // Joint_E_1
    <0,0,0>,1
    scale 0.19
    translate  <-1.0, -2.325, 0.19>
  }
  cone { // LegPar_C_1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.1875, 0.1875, 2.5>
    rotate 94.0*x
    translate  <-1.0, -2.325, 0.1875>
  }
  cylinder { // LegPar_B_1
    <0,0,1>, <0,0,0>, 1
    scale <0.1875, 0.1875, 2.0>
    rotate <-143.0, 15.0, 0.0>
    translate  <-0.575, -3.5625, 1.675>
  }
  cylinder { // LegPar_A_1
    <0,0,1>, <0,0,0>, 1
    scale <0.1875, 0.1875, 2.0>
    rotate <-143.0, -15.0, 0.0>
    translate  <0.575, -3.5625, 1.675>
  }
  sphere { // Hand_B_1
    <0,0,0>,1
    scale <0.25, 0.5, 0.125>
    translate  <-2.25, 1.5, 0.145>
  }
  sphere { // Hand_A_1
    <0,0,0>,1
    scale <0.25, 0.5, 0.125>
    translate  <2.25, 1.5, 0.145>
  }
  sphere { // Joint_D_1
    <0,0,0>,1
    scale 0.15
    translate  <-2.25, -0.5, 0.5>
  }
  sphere { // Joint_C_1
    <0,0,0>,1
    scale 0.15
    translate  <2.25, -0.5, 0.5>
  }
  cylinder { // Arm_D_1
    <0,0,1>, <0,0,0>, 1
    scale <0.125, 0.125, 2.0>
    rotate -100.0*x
    translate  <-2.25, -0.5, 0.5>
  }
  cylinder { // Arm_C_1
    <0,0,1>, <0,0,0>, 1
    scale <0.125, 0.125, 2.0>
    rotate -100.0*x
    translate  <2.25, -0.5, 0.5>
  }
  cylinder { // Arm_B_1
    <0,0,1>, <0,0,0>, 1
    scale <0.125, 0.125, 2.0>
    rotate <-150.0, 45.0, 0.0>
    translate  <-1.0, -1.5, 1.75>
  }
  sphere { // Joint_B_1
    <0,0,0>,1
    scale 0.15
    translate  <-1.0, -1.5, 1.75>
  }
  sphere { // Joint_A_1
    <0,0,0>,1
    scale 0.15
    translate  <1.0, -1.5, 1.75>
  }
  cylinder { // Arm_A_1
    <0,0,1>, <0,0,0>, 1
    scale <0.125, 0.125, 2.0>
    rotate <-150.0, -45.0, 0.0>
    translate  <1.0, -1.5, 1.75>
  }
  sphere { // Body1
    <0,0,0>,1
    scale <1.0, 1.0, 2.0>
    rotate -85.0*x
    translate  <0.0, -2.5, 1.75>
  }
  disc { // Wing_A_1
    <0,0,0>, <0,0,1>, 1.0
    scale <1.0, 3.0, 1.0>
    rotate <-5.0, 0.0, -25.0>
    translate  <-1.25, -3.9375, 2.9875>
  }
  disc { // Wing_B_1
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Wing_T
    }
    scale <1.0, 3.0, 1.0>
    rotate <-5.0, 0.0, 25.0>
    translate  <1.25, -3.9375, 2.9875>
  }
  sphere { // Wing_Joint_1
    <0,0,0>,1
    scale 0.25
    translate  <0.0, -1.3, 2.6125>
  }
  texture {
    Carapace_T
  }
  scale 3.0
  translate -150*x*.5}




#declare Marker1 = object {Pilgrim}
   translate  <-75.0, 120.0, 0.0>
}
#declare Marker_Row1 = union { // Marker_Row1
  object { Marker1 }
  object { // Marker2->Marker1
    Marker1
    translate  25.0*x
  }
  object { // Marker3->Marker1
    Marker1
    translate  50.0*x
  }
  object { // Marker4->Marker1
    Marker1
    translate  75.0*x
  }
  object { // Marker5->Marker1
    Marker1
    translate  100.0*x
  }
  object { // Marker6->Marker1
    Marker1
    translate  125.0*x
  }
  object { // Marker7->Marker1
    Marker1
    translate  150.0*x
  }
}




// ********  OBJECTS  *******

#include "range.pov"

object { // Marker_Row7->Marker_Row1
  Marker_Row1
  translate  300.0*y
}


object { // Marker_Row6->Marker_Row1
  Marker_Row1
  translate  250.0*y
}


object { // Marker_Row5->Marker_Row1
  Marker_Row1
  translate  200.0*y
}


object { // Marker_Row4->Marker_Row1
  Marker_Row1
  translate  150.0*y
}


object { // Marker_Row3->Marker_Row1
  Marker_Row1
  translate  100.0*y
}


object { // Marker_Row2->Marker_Row1
  Marker_Row1
  translate  50.0*y
}


object { Marker_Row1 }


union { // Ground_Thang
  disc { // Ground_P1
    <0,0,0>, <0,0,1>, 1.0
    scale <500.0, 500.0, 1.0>
  }
  torus { // Ground_Curve1
    500.0, 500.0  rotate -x*90
    translate  -500.0*z
  }
  texture {
    Ground_T
  }
}




// Include contains 'Top1'
#include "sacrifce.in1"

#declare Top1 = object {
  Top1_Raw
  scale <2.5, 3.25, 5.0>
  rotate -105.0*z
  translate  <-9.0, -5.0, 20.0>
}
#declare Palm6 = union {
  sphere { // Palm_Par11
    <0,0,0>,1
    scale <1.0, 0.25, 0.5>
    translate  2.0*z
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 1.0>
    translate  1.0*z
  }
  sphere { // Palm_Par12
    <0,0,0>,1
    scale <1.0, 0.25, 1.0>
  }
  translate  1.0*z
}
#declare Fing_Seg40 = union {
  cone { // Fing_Par16
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint36
    <0,0,0>,1
    scale 0.25
  }
  rotate -25.0*x
  translate  1.0*z
}
#declare Fing_Seg41 = union {
  cylinder { // FingPar25
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint35
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg40 }
  rotate -15.0*x
  translate  1.0*z
}
#declare Fing_Seg42 = union {
  cylinder { // FingPar24
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint34
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg41 }
  rotate <-25.0, 10.0, 0.0>
  translate  <0.75, 0.0, 3.0>
}
#declare Fing_Seg43 = union {
  cone { // Fing_Par17
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint39
    <0,0,0>,1
    scale 0.25
  }
  rotate -45.0*x
  translate  1.0*z
}
#declare Fing_Seg44 = union {
  cylinder { // FingPar27
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint38
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg43 }
  rotate -45.0*x
  translate  1.0*z
}
#declare Fing_Seg45 = union {
  cylinder { // FingPar26
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint37
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg44 }
  rotate <-45.0, -5.0, 0.0>
  translate  3.0*z
}
#declare Fing_Seg46 = union {
  cone { // Fing_Par18
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint42
    <0,0,0>,1
    scale 0.25
  }
  rotate -80.0*x
  translate  1.0*z
}
#declare Fing_Seg47 = union {
  sphere { // Fing_Joint41
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg46 }
  cylinder { // FingPar29
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  rotate -75.0*x
  translate  1.0*z
}
#declare Fing_Seg48 = union {
  cylinder { // FingPar28
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint40
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg47 }
  rotate <-45.0, -20.0, 0.0>
  translate  <-0.75, 0.0, 3.0>
}
#declare Thumb_Seg15 = union {
  cone { // ThumbPar20
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Thumb_Joint21
    <0,0,0>,1
    scale 0.25
  }
  rotate 60.0*x
  translate  1.0*z
}
#declare Thumb_Seg16 = union {
  cylinder { // ThumbPar19
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint20
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg15 }
  rotate 80.0*x
  translate  1.0*z
}
#declare Thumb6 = union {
  cylinder { // ThumbPar18
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint19
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg16 }
  rotate -110.0*x
  translate  <0.375, 0.0, 1.0>
}
#declare Hand3 = union {
  object { Palm6 }
  object { Fing_Seg42 }
  object { Fing_Seg45 }
  object { Fing_Seg48 }
  object { Thumb6 }
  rotate <170.0, 0.0, -180.0>
  translate  -10.0*z
}
#declare Arm_Seg4 = union {
  sphere { // Arm_Joint5
    <0,0,0>,1
  }
  cylinder { // Arm_Par5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  sphere { // HandMJoint3
    <0,0,0>,1
    scale <1.0, 1.0, 0.125>
    translate  -10.0*z
  }
  object { Hand3 }
  torus { // Bond2
    1.5, 0.5  rotate -x*90
    texture {
      Rusty_Iron2
    }
    translate  -9.0*z
  }
  cylinder { // Rope1
    <0,0,1>, <0,0,0>, 1
    texture {
      Rope_T1
    }
    scale <0.5, 0.5, 10.0>
    rotate 45.0*x
    translate  <0.0, -1.5, -9.0>
  }
  rotate <20.0, 10.0, 0.0>
  translate  -10.0*z
}
#declare Arm3 = union {
  sphere { // Arm_Joint4
    <0,0,0>,1
    scale 1.5
  }
  cylinder { // Arm_Par4
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  object { Arm_Seg4 }
  rotate 85.0*y
  translate  -8.75*x
}
#declare Palm7 = union {
  sphere { // Palm_Par13
    <0,0,0>,1
    scale <1.0, 0.25, 0.5>
    translate  2.0*z
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 1.0>
    translate  1.0*z
  }
  sphere { // Palm_Par14
    <0,0,0>,1
    scale <1.0, 0.25, 1.0>
  }
  translate  1.0*z
}
#declare Fing_Seg49 = union {
  cone { // Fing_Par19
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint45
    <0,0,0>,1
    scale 0.25
  }
  rotate -45.0*x
  translate  1.0*z
}
#declare Fing_Seg50 = union {
  cylinder { // FingPar31
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint44
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg49 }
  rotate -120.0*x
  translate  1.0*z
}
#declare Fing_Seg51 = union {
  cylinder { // FingPar30
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint43
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg50 }
  rotate 10.0*x
  translate  <0.75, 0.0, 3.0>
}
#declare Fing_Seg52 = union {
  cone { // Fing_Par20
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint48
    <0,0,0>,1
    scale 0.25
  }
  rotate -110.0*x
  translate  1.0*z
}
#declare Fing_Seg53 = union {
  cylinder { // FingPar33
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint47
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg52 }
  rotate -45.0*x
  translate  1.0*z
}
#declare Fing_Seg54 = union {
  cylinder { // FingPar32
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint46
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg53 }
  rotate -60.0*x
  translate  3.0*z
}
#declare Fing_Seg55 = union {
  cone { // Fing_Par21
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint51
    <0,0,0>,1
    scale 0.25
  }
  rotate -20.0*x
  translate  1.0*z
}
#declare Fing_Seg56 = union {
  sphere { // Fing_Joint50
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg55 }
  cylinder { // FingPar35
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  rotate -50.0*x
  translate  1.0*z
}
#declare Fing_Seg57 = union {
  cylinder { // FingPar34
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint49
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg56 }
  rotate -20.0*x
  translate  <-0.75, 0.0, 3.0>
}
#declare Thumb_Seg17 = union {
  cone { // ThumbPar23
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Thumb_Joint24
    <0,0,0>,1
    scale 0.25
  }
  rotate 30.0*x
  translate  1.0*z
}
#declare Thumb_Seg18 = union {
  cylinder { // ThumbPar22
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint23
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg17 }
  rotate 75.0*x
  translate  1.0*z
}
#declare Thumb7 = union {
  cylinder { // ThumbPar21
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint22
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg18 }
  rotate -100.0*x
  translate  <-0.375, 0.0, 1.0>
}
#declare Hand4 = union {
  object { Palm7 }
  object { Fing_Seg51 }
  object { Fing_Seg54 }
  object { Fing_Seg57 }
  object { Thumb7 }
  rotate <-200.0, 0.0, -180.0>
  translate  -10.0*z
}
#declare Arm_Seg5 = union {
  sphere { // Arm_Joint7
    <0,0,0>,1
  }
  cylinder { // Arm_Par7
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  sphere { // HandMJoint4
    <0,0,0>,1
    scale <1.0, 1.0, 0.125>
    translate  -10.0*z
  }
  object { Hand4 }
  torus { // Bond1
    1.5, 0.5  rotate -x*90
    texture {
      Rusty_Iron2
    }
    translate  -9.0*z
  }
  cylinder { // Rope2
    <0,0,1>, <0,0,0>, 1
    texture {
      Rope_T1
    }
    scale <0.5, 0.5, 10.0>
    rotate 45.0*x
    translate  <0.0, -1.5, -9.0>
  }
  rotate <20.0, -10.0, 0.0>
  translate  -10.0*z
}
#declare Arm4 = union {
  sphere { // Arm_Joint6
    <0,0,0>,1
    scale 1.5
  }
  cylinder { // Arm_Par6
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  object { Arm_Seg5 }
  rotate -85.0*y
  translate  8.75*x
}
#declare Shoulders2 = union {
  cylinder { // Shoulder_Bar1
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 17.5>
    rotate -90.0*y
    translate  8.75*x
  }
  object { Arm3 }
  object { Arm4 }
  translate  12.5*z
}
#declare Skull = difference {
  sphere { // Skull_P
    <0,0,0>,1
    scale <2.0, 2.0, 1.0>
  }
  sphere { // Nostril1
    <0,0,0>,1
    scale <0.25, 1.0, 0.25>
    translate  <0.5, 1.5, 0.0>
  }
  sphere { // Nostril3
    <0,0,0>,1
    scale <0.25, 1.0, 0.25>
    translate  <-0.5, 1.5, 0.0>
  }
  cylinder { // Mouth_Cut
    <0,0,1>, <0,0,0>, 1
    scale <0.293333, 0.293333, 4.0>
    rotate -90.0*x
    translate  <0.0, -1.333333, -0.4>
  }
}
#declare Anten_Part4 = union {
  sphere { // Anten_Joint4
    <0,0,0>,1
    scale 0.25
  }
  cone { // Anten_Tip1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  rotate -45.0*x
  translate  1.25*z
}
#declare Anten_Part3 = union {
  cylinder { // AntenPar3
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint3
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part4 }
  rotate <-10.0, -5.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part2 = union {
  cylinder { // AntenPar2
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint2
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part3 }
  rotate <-45.0, -15.0, 0.0>
  translate  1.25*z
}
#declare Antenna1 = union {
  cylinder { // AntenPar1
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint1
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part2 }
  texture {
    Anten_T2
  }
  rotate <-10.0, -45.0, 0.0>
  translate  <-0.5, 0.0, 0.75>
}
#declare Anten_Part6 = union {
  sphere { // Anten_Joint8
    <0,0,0>,1
    scale 0.25
  }
  cone { // Anten_Tip2
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  rotate <-20.0, -15.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part7 = union {
  cylinder { // AntenPar6
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint7
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part6 }
  rotate <-25.0, -15.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part5 = union {
  cylinder { // AntenPar5
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint6
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part7 }
  rotate <-5.0, -35.0, 0.0>
  translate  1.25*z
}
#declare Antenna2 = union {
  cylinder { // AntenPar4
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint5
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part5 }
  texture {
    Anten_T2
  }
  rotate <-5.0, 45.0, 0.0>
  translate  <0.5, 0.0, 0.75>
}
#declare Head = union {
  object { Skull }
  sphere { // Eye1
    <0,0,0>,1
    texture {
      Eye_T3
    }
    scale 0.5
    rotate -90.0*x
    translate  <1.0, 1.375, 0.75>
  }
  sphere { // Eye2
    <0,0,0>,1
    texture {
      Eye_T3
    }
    scale 0.5
    rotate -90.0*x
    translate  <-1.0, 1.375, 0.75>
  }
  object { Antenna1 }
  object { Antenna2 }
  scale 3.75
  rotate <-25.0, 0.0, -10.0>
  translate  22.0*z
}
#declare CSG001 = difference {
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
  }
  torus { // Torus9
    1.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  1.0*z
  }
}
#declare CSG003 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.5
    translate  1.0*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.125
    translate  1.5*z
  }
}
#declare HemiSphere = difference {
  sphere { // Sphere003
    <0,0,0>,1
  }
  box { // Cut5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  0.5*z
  }
}
#declare Nipple1 = merge {
  object { CSG001 }
  object { CSG003 }
  object { HemiSphere }
  texture {
    Nip_T1
  }
  translate  9.625*z
}
#declare Breast1 = merge {
  sphere { // Sphere2
    <0,0,0>,1
    scale <4.0, 4.0, 5.0>
    translate  5.0*z
  }
  object { Nipple1 }
  rotate -90.0*x
  translate  3.0*x
}
#declare CSG2 = difference {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
  }
  torus { // Torus10
    1.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  1.0*z
  }
}
#declare CSG4 = difference {
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.5
    translate  1.0*z
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.125
    translate  1.5*z
  }
}
#declare HemiSphere1 = difference {
  sphere { // Sphere6
    <0,0,0>,1
  }
  box { // Cut6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  0.5*z
  }
}
#declare Nipple2 = merge {
  object { CSG2 }
  object { CSG4 }
  object { HemiSphere1 }
  texture {
    Nip_T1
  }
  translate  9.625*z
}
#declare Breast2 = merge {
  sphere { // Sphere4
    <0,0,0>,1
    scale <4.0, 4.0, 5.0>
    translate  5.0*z
  }
  object { Nipple2 }
  rotate -90.0*x
  translate  -3.0*x
}
#declare Bosom = union {
  object { Breast1 }
  object { Breast2 }
  translate  9.0*z
}
#declare Middle_Torso = union {
  sphere { // Body_Seg2
    <0,0,0>,1
    scale <7.25, 6.25, 10.625>
    translate  9.0*z
  }
  object { Shoulders2 }
  object { Head }
  object { Bosom }
  rotate -5.0*x
  translate  45.0*z
}
#declare Leg_Par2 = union {
  sphere { // Leg_Joint2
    <0,0,0>,1
  }
  cone { // Leg_End1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 20.0>
    translate  -20.0*z
  }
  rotate <-88.0, 5.0, 0.0>
  translate  -15.0*z
}
#declare Leg1 = union {
  sphere { // Leg_Joint1
    <0,0,0>,1
  }
  cylinder { // Leg_Seg1
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    translate  -15.0*z
  }
  object { Leg_Par2 }
  rotate <45.0, -5.0, 0.0>
  translate  8.75*x
}
#declare Leg_Par3 = union {
  sphere { // Leg_Joint4
    <0,0,0>,1
  }
  cone { // Leg_End2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 20.0>
    translate  -20.0*z
  }
  rotate <-5.0, -5.0, 0.0>
  translate  -15.0*z
}
#declare Leg2 = union {
  sphere { // Leg_Joint3
    <0,0,0>,1
  }
  cylinder { // Leg_Seg2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    translate  -15.0*z
  }
  object { Leg_Par3 }
  rotate 40.0*y
  translate  -8.75*x
}
#declare Hips = union {
  object { Leg1 }
  object { Leg2 }
  cylinder { // Hip_Bar1
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 17.5>
    rotate -90.0*y
    translate  8.75*x
  }
  rotate -8.0*x
  translate  -10.0*z
}
#declare Ab_Section1 = difference {
  sphere { // BodySeg3
    <0,0,0>,1
    scale <6.25, 6.25, 2.0>
  }
  box { // Ab_Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.25, 6.25, 1.0>
    translate  1.0*z
  }
}
#declare Ab_Section2 = difference {
  sphere { // BodySeg4
    <0,0,0>,1
    scale <6.25, 6.25, 17.5>
  }
  box { // Ab_Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.25, 6.25, 8.75>
    translate  -8.75*z
  }
}
#declare Ab_Section = merge {
  object { Ab_Section1 }
  object { Ab_Section2 }
  translate  -17.5*z
}
#declare Lower_Ab = difference {
  object { Ab_Section }
  cylinder { // Tube
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 18.0>
    translate  -19.5*z
  }
}
#declare Lower_Torso = union {
  object { Hips }
  object { Lower_Ab }
  torus { // Ring
    1.5, 0.5  rotate -x*90
    texture {
      Nip_T1
    }
    translate  -19.5*z
  }
  rotate 1.0*x
  translate  45.0*z
}
#declare Insect1 = merge {
  object { Middle_Torso }
  object { Lower_Torso }
  texture {
    Carapace2
  }
  scale 0.5
  rotate 90.0*x
  translate  <0.0, 20.0, 28.0>
}
#declare Altar = merge {
  box { // Base_P1
    <-1, -1, -1>, <1, 1, 1>
    scale <12.5, 25.0, 10.0>
    translate  10.0*z
  }
  object { Top1 }
  object { Insect1 }
  texture {
    Ruff_Stone
  }
}
#declare Palm8 = union {
  sphere { // Palm_Par15
    <0,0,0>,1
    scale <1.0, 0.25, 0.5>
    translate  2.0*z
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 1.0>
    translate  1.0*z
  }
  sphere { // Palm_Par16
    <0,0,0>,1
    scale <1.0, 0.25, 1.0>
  }
  translate  1.0*z
}
#declare Fing_Seg58 = union {
  cone { // Fing_Par22
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint54
    <0,0,0>,1
    scale 0.25
  }
  rotate -47.5*x
  translate  1.0*z
}
#declare Fing_Seg59 = union {
  cylinder { // FingPar37
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint53
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg58 }
  rotate -40.0*x
  translate  1.0*z
}
#declare Fing_Seg60 = union {
  cylinder { // FingPar36
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint52
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg59 }
  rotate -55.0*x
  translate  <0.75, 0.0, 3.0>
}
#declare Fing_Seg61 = union {
  cone { // Fing_Par23
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint57
    <0,0,0>,1
    scale 0.25
  }
  rotate -45.0*x
  translate  1.0*z
}
#declare Fing_Seg62 = union {
  cylinder { // FingPar39
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint56
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg61 }
  rotate -40.0*x
  translate  1.0*z
}
#declare Fing_Seg63 = union {
  cylinder { // FingPar38
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint55
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg62 }
  rotate -52.5*x
  translate  3.0*z
}
#declare Fing_Seg64 = union {
  cone { // Fing_Par24
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint60
    <0,0,0>,1
    scale 0.25
  }
  rotate -50.0*x
  translate  1.0*z
}
#declare Fing_Seg65 = union {
  sphere { // Fing_Joint59
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg64 }
  cylinder { // FingPar41
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  rotate -50.0*x
  translate  1.0*z
}
#declare Fing_Seg66 = union {
  cylinder { // FingPar40
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint58
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg65 }
  rotate -45.0*x
  translate  <-0.75, 0.0, 3.0>
}
#declare Thumb_Seg19 = union {
  cone { // ThumbPar26
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Thumb_Joint27
    <0,0,0>,1
    scale 0.25
  }
  rotate 35.0*x
  translate  1.0*z
}
#declare Thumb_Seg20 = union {
  cylinder { // ThumbPar25
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint26
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg19 }
  rotate 20.0*x
  translate  1.0*z
}
#declare Thumb8 = union {
  cylinder { // ThumbPar24
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint25
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg20 }
  rotate -90.0*x
  translate  <0.375, 0.0, 1.0>
}
#declare Blade1 = intersection {
  sphere { // Part1
    <0,0,0>,1
    scale <20.0, 20.0, 2.5>
    translate  1.0*z
  }
  sphere { // Part2
    <0,0,0>,1
    scale <20.0, 20.0, 2.5>
    translate  -1.0*z
  }
}
#declare Blade_T1 = difference {
  object { Blade1 }
  box { // Half_Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 20.0, 1.5>
    translate  9.0*x
  }
  translate  -10.0*x
}
#declare Bridge1 = intersection {
  cylinder { // Bridge_P1
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 1.0>
    rotate -90.0*y
    translate  1.0*z
  }
  cylinder { // Bridge_P2
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 1.0>
    rotate -90.0*y
    translate  -1.0*z
  }
  scale <10.0, 8.0, 1.0>
}
#declare Bridge_T = difference {
  object { Bridge1 }
  cylinder { // Cut1
    <0,0,1>, <0,0,0>, 1
    scale <17.32, 12.32, 3.0>
    translate  <7.32, 17.32, -1.5>
  }
  cylinder { // Cut2
    <0,0,1>, <0,0,0>, 1
    scale <17.32, 12.32, 3.0>
    translate  <7.32, -17.32, -1.5>
  }
}
#declare L_AxeBlade = merge {
  object { Blade_T1 }
  object { Bridge_T }
}
#declare Blade2 = intersection {
  sphere { // Part3
    <0,0,0>,1
    scale <20.0, 20.0, 2.5>
    translate  1.0*z
  }
  sphere { // Part4
    <0,0,0>,1
    scale <20.0, 20.0, 2.5>
    translate  -1.0*z
  }
}
#declare Blade_T2 = difference {
  object { Blade2 }
  box { // Half_Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 20.0, 1.5>
    translate  9.0*x
  }
  translate  -10.0*x
}
#declare Bridge2 = intersection {
  cylinder { // Bridge_P3
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 1.0>
    rotate -90.0*y
    translate  1.0*z
  }
  cylinder { // Bridge_P4
    <0,0,1>, <0,0,0>, 1
    scale <2.5, 2.5, 1.0>
    rotate -90.0*y
    translate  -1.0*z
  }
  scale <10.0, 8.0, 1.0>
}
#declare Bridge_T1 = difference {
  object { Bridge2 }
  cylinder { // Cut3
    <0,0,1>, <0,0,0>, 1
    scale <17.32, 12.32, 3.0>
    translate  <7.32, 17.32, -1.5>
  }
  cylinder { // Cut4
    <0,0,1>, <0,0,0>, 1
    scale <17.32, 12.32, 3.0>
    translate  <7.32, -17.32, -1.5>
  }
}
#declare R_AxeBlade = merge {
  object { Blade_T2 }
  object { Bridge_T1 }
  rotate 180.0*z
}
#declare AxeHead = merge {
  object { L_AxeBlade }
  object { R_AxeBlade }
  texture {
    Speckled_Metal
  }
  rotate -90.0*x
  translate  50.0*z
}
#declare Axe1 = union {
  cylinder { // Shaft1
    <0,0,1>, <0,0,0>, 1
    texture {
      MyWood
    }
    scale <2.5, 2.5, 65.0>
  }
  object { AxeHead }
  scale 0.375
  rotate 90.0*y
  translate  <-3.0, 1.25, 2.375>
}
#declare Hand5 = union {
  object { Palm8 }
  object { Fing_Seg60 }
  object { Fing_Seg63 }
  object { Fing_Seg66 }
  object { Thumb8 }
  object { Axe1 }
  rotate <-180.0, 0.0, 90.0>
  translate  -10.0*z
}
#declare Arm_Seg6 = union {
  sphere { // Arm_Joint9
    <0,0,0>,1
  }
  cylinder { // Arm_Par9
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  sphere { // HandMJoint5
    <0,0,0>,1
    scale <1.0, 1.0, 0.125>
    translate  -10.0*z
  }
  object { Hand5 }
  rotate 45.0*x
  translate  -10.0*z
}
#declare Arm5 = union {
  sphere { // Arm_Joint8
    <0,0,0>,1
    scale 1.5
  }
  cylinder { // Arm_Par8
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  object { Arm_Seg6 }
  rotate <135.0, -45.0, 0.0>
  translate  -8.75*x
}
#declare Palm9 = union {
  sphere { // Palm_Par17
    <0,0,0>,1
    scale <1.0, 0.25, 0.5>
    translate  2.0*z
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.25, 1.0>
    translate  1.0*z
  }
  sphere { // Palm_Par18
    <0,0,0>,1
    scale <1.0, 0.25, 1.0>
  }
  translate  1.0*z
}
#declare Fing_Seg67 = union {
  cone { // Fing_Par25
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint63
    <0,0,0>,1
    scale 0.25
  }
  rotate -10.0*x
  translate  1.0*z
}
#declare Fing_Seg68 = union {
  cylinder { // FingPar43
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint62
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg67 }
  rotate -20.0*x
  translate  1.0*z
}
#declare Fing_Seg69 = union {
  cylinder { // FingPar42
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint61
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg68 }
  rotate <35.0, 15.0, 0.0>
  translate  <0.75, 0.0, 3.0>
}
#declare Fing_Seg70 = union {
  cone { // Fing_Par26
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint66
    <0,0,0>,1
    scale 0.25
  }
  rotate -20.0*x
  translate  1.0*z
}
#declare Fing_Seg71 = union {
  cylinder { // FingPar45
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint65
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg70 }
  rotate -15.0*x
  translate  1.0*z
}
#declare Fing_Seg72 = union {
  cylinder { // FingPar44
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint64
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg71 }
  rotate 5.0*x
  translate  3.0*z
}
#declare Fing_Seg73 = union {
  cone { // Fing_Par27
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Fing_Joint69
    <0,0,0>,1
    scale 0.25
  }
  rotate -15.0*x
  translate  1.0*z
}
#declare Fing_Seg74 = union {
  sphere { // Fing_Joint68
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg73 }
  cylinder { // FingPar47
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  rotate -20.0*x
  translate  1.0*z
}
#declare Fing_Seg75 = union {
  cylinder { // FingPar46
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Fing_Joint67
    <0,0,0>,1
    scale 0.25
  }
  object { Fing_Seg74 }
  rotate <45.0, -15.0, 0.0>
  translate  <-0.75, 0.0, 3.0>
}
#declare Thumb_Seg21 = union {
  cone { // ThumbPar29
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  sphere { // Thumb_Joint30
    <0,0,0>,1
    scale 0.25
  }
  rotate 45.0*x
  translate  1.0*z
}
#declare Thumb_Seg22 = union {
  cylinder { // ThumbPar28
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint29
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg21 }
  rotate 35.0*x
  translate  1.0*z
}
#declare Thumb9 = union {
  cylinder { // ThumbPar27
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.0>
  }
  sphere { // Thumb_Joint28
    <0,0,0>,1
    scale 0.25
  }
  object { Thumb_Seg22 }
  rotate <-90.0, -45.0, 0.0>
  translate  <0.375, 0.0, 1.0>
}
#declare Hand6 = union {
  object { Palm9 }
  object { Fing_Seg69 }
  object { Fing_Seg72 }
  object { Fing_Seg75 }
  object { Thumb9 }
  rotate <-150.0, -15.0, 0.0>
  translate  -10.0*z
}
#declare Arm_Seg7 = union {
  sphere { // Arm_Joint11
    <0,0,0>,1
  }
  cylinder { // Arm_Par11
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  sphere { // HandMJoint6
    <0,0,0>,1
    scale <1.0, 1.0, 0.125>
    translate  -10.0*z
  }
  object { Hand6 }
  rotate <-20.0, 35.0, 0.0>
  translate  -10.0*z
}
#declare Arm6 = union {
  sphere { // Arm_Joint10
    <0,0,0>,1
    scale 1.5
  }
  cylinder { // Arm_Par10
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate -180.0*x
  }
  object { Arm_Seg7 }
  rotate <-175.0, 45.0, 0.0>
  translate  8.75*x
}
#declare Shoulders3 = union {
  cylinder { // Shoulder_Bar2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 17.5>
    rotate -90.0*y
    translate  8.75*x
  }
  object { Arm5 }
  object { Arm6 }
  translate  10.0*z
}
#declare Skull1 = difference {
  sphere { // Skull_P1
    <0,0,0>,1
    scale <2.0, 3.0, 1.0>
  }
  sphere { // Nostril2
    <0,0,0>,1
    scale <0.25, 1.0, 0.25>
    translate  <0.5, 2.5, 0.0>
  }
  sphere { // Nostril4
    <0,0,0>,1
    scale <0.25, 1.0, 0.25>
    translate  <-0.5, 2.5, 0.0>
  }
}
#declare Anten_Part8 = union {
  sphere { // Anten_Joint12
    <0,0,0>,1
    scale 0.25
  }
  cone { // Anten_Tip3
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  rotate -85.0*x
  translate  1.25*z
}
#declare Anten_Part9 = union {
  cylinder { // AntenPar9
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint11
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part8 }
  rotate <-35.0, -5.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part10 = union {
  cylinder { // AntenPar8
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint10
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part9 }
  rotate <-45.0, -20.0, 0.0>
  translate  1.25*z
}
#declare Antenna3 = union {
  cylinder { // AntenPar7
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint9
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part10 }
  texture {
    Anten_T3
  }
  rotate <25.0, -45.0, 0.0>
  translate  <-0.5, 0.0, 0.75>
}
#declare Anten_Part11 = union {
  sphere { // Anten_Joint16
    <0,0,0>,1
    scale 0.25
  }
  cone { // Anten_Tip4
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.25, 0.25, 2.0>
  }
  rotate <-20.0, -15.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part12 = union {
  cylinder { // AntenPar12
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint15
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part11 }
  rotate <-25.0, -15.0, 0.0>
  translate  1.25*z
}
#declare Anten_Part13 = union {
  cylinder { // AntenPar11
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint14
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part12 }
  rotate <-5.0, -35.0, 0.0>
  translate  1.25*z
}
#declare Antenna4 = union {
  cylinder { // AntenPar10
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 1.25>
  }
  sphere { // Anten_Joint13
    <0,0,0>,1
    scale 0.25
  }
  object { Anten_Part13 }
  texture {
    Anten_T3
  }
  rotate <60.0, 45.0, 0.0>
  translate  <0.5, 0.0, 0.75>
}
#declare Head2 = union {
  object { Skull1 }
  sphere { // Eye3
    <0,0,0>,1
    texture {
      Eye_T4
    }
    scale 0.5
    rotate -90.0*x
    translate  <1.0, 1.375, 0.75>
  }
  sphere { // Eye4
    <0,0,0>,1
    texture {
      Eye_T4
    }
    scale 0.5
    rotate -90.0*x
    translate  <-1.0, 1.375, 0.75>
  }
  object { Antenna3 }
  object { Antenna4 }
  scale 3.75
  rotate -20.0*x
  translate  22.0*z
}
#declare Middle_Torso1 = union {
  sphere { // Body_Seg3
    <0,0,0>,1
    scale <7.25, 6.25, 10.625>
    translate  9.0*z
  }
  object { Shoulders3 }
  object { Head2 }
  rotate -25.0*x
  translate  45.0*z
}
#declare Leg_Par4 = union {
  sphere { // Leg_Joint6
    <0,0,0>,1
  }
  cone { // Leg_End3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 20.0>
    translate  -20.0*z
  }
  rotate -132.0*x
  translate  -15.0*z
}
#declare Leg3 = union {
  sphere { // Leg_Joint5
    <0,0,0>,1
  }
  cylinder { // Leg_Seg3
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    translate  -15.0*z
  }
  object { Leg_Par4 }
  translate  7.5*x
}
#declare Leg_Par5 = union {
  sphere { // Leg_Joint8
    <0,0,0>,1
  }
  cone { // Leg_End4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 20.0>
    translate  -20.0*z
  }
  rotate -132.0*x
  translate  -15.0*z
}
#declare Leg4 = union {
  sphere { // Leg_Joint7
    <0,0,0>,1
  }
  cylinder { // Leg_Seg4
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    translate  -15.0*z
  }
  object { Leg_Par5 }
  translate  -7.5*x
}
#declare Hips1 = union {
  object { Leg3 }
  object { Leg4 }
  cylinder { // Hip_Bar2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 15.0>
    rotate -90.0*y
    translate  7.5*x
  }
  rotate 45.0*x
  translate  -10.0*z
}
#declare Lower_Torso1 = union {
  object { Hips1 }
  sphere { // BodySeg5
    <0,0,0>,1
    scale <6.25, 6.25, 10.0>
    translate  -10.0*z
  }
  sphere { // Waist_Joint
    <0,0,0>,1
    scale 2.5
    translate  -1.0*z
  }
  translate  45.0*z
}
#declare Priest = merge {
  object { Middle_Torso1 }
  object { Lower_Torso1 }
  texture {
    Carapace3
  }
  scale 0.5
  rotate 90.0*z
  translate  <20.0, 0.0, 13.375>
}
union { // Altar_Scene
  object { Altar }
  object { Priest }
  rotate -90.0*z
  translate  30.0*z
}




#declare CSG_Pillar5 = difference {
  cylinder { // Column_Mid5
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting41
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting42
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting43
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting44
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting45
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting46
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting47
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting48
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base5 = difference {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus6
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column6 = union {
  object { CSG_Pillar5 }
  object { Base5 }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <-60.0, 42.5, 35.0>
}
#declare CSG_Pillar4 = difference {
  cylinder { // Column_Mid4
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting33
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting34
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting35
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting36
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting37
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting38
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting39
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting40
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base4 = difference {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus5
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column5 = union {
  object { CSG_Pillar4 }
  object { Base4 }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <-36.0, 42.5, 35.0>
}
#declare CSG_Pillar3 = difference {
  cylinder { // Column_Mid3
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting25
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting26
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting27
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting28
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting29
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting30
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting31
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting32
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base3 = difference {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus4
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column4 = union {
  object { CSG_Pillar3 }
  object { Base3 }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <-12.0, 42.5, 35.0>
}
#declare CSG_Pillar2 = difference {
  cylinder { // Column_Mid2
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting17
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting18
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting19
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting20
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting21
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting22
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting23
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting24
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base2 = difference {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus3
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column3 = union {
  object { CSG_Pillar2 }
  object { Base2 }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <12.0, 42.5, 35.0>
}
#declare CSG_Pillar1 = difference {
  cylinder { // Column_Mid1
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting9
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting10
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting11
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting12
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting13
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting14
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting15
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting16
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base1 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus2
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column2 = union {
  object { CSG_Pillar1 }
  object { Base1 }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <36.0, 42.5, 35.0>
}
#declare CSG_Pillar = difference {
  cylinder { // Column_Mid
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <5.0, 5.0, 50.0>
  }
  sphere { // Fluting1
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <5.0, 0.0, 25.0>
  }
  sphere { // Fluting2
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-5.0, 0.0, 25.0>
  }
  sphere { // Fluting3
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, 5.0, 25.0>
  }
  sphere { // Fluting4
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <0.0, -5.0, 25.0>
  }
  sphere { // Fluting5
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting6
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, 3.535534, 25.0>
  }
  sphere { // Fluting7
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <3.535534, -3.535534, 25.0>
  }
  sphere { // Fluting8
    <0,0,0>,1
    scale <1.0, 1.0, 20.0>
    translate  <-3.535534, -3.535534, 25.0>
  }
  texture {
    White_Marble
  }
}
#declare Base = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Marble
    }
    scale <7.5, 7.5, 5.0>
    translate  -5.0*z
  }
  torus { // Torus001
    7.5, 2.5  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
  texture {
    White_Marble
  }
}
#declare Column1 = union {
  object { CSG_Pillar }
  object { Base }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      White_Marble
    }
    scale 10.0
    translate  45.0*z
  }
  texture {
    White_Marble
  }
  translate  <60.0, 42.5, 35.0>
}
union { // Stage
  box { // Base_Stairs_2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <98.0, 73.5, 1.0>
    translate  3.0*z
  }
  box { // Base_Stairs_3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <96.0, 72.0, 1.0>
    translate  5.0*z
  }
  object { Column6 }
  object { Column5 }
  object { Column4 }
  object { Column3 }
  object { Column2 }
  object { Column1 }
  box { // Base_Stairs_P1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <100.0, 75.0, 1.0>
    translate  1.0*z
  }
  box { // Base_Stairs_15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <72.0, 54.0, 1.0>
    translate  29.0*z
  }
  box { // Base_Stairs_14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <74.0, 55.5, 1.0>
    translate  27.0*z
  }
  box { // Base_Stairs_13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <76.0, 57.0, 1.0>
    translate  25.0*z
  }
  box { // Base_Stairs_12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <78.0, 58.5, 1.0>
    translate  23.0*z
  }
  box { // Base_Stairs_11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <80.0, 60.0, 1.0>
    translate  21.0*z
  }
  box { // Base_Stairs_10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <82.0, 61.5, 1.0>
    translate  19.0*z
  }
  box { // Base_Stairs_9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <84.0, 63.0, 1.0>
    translate  17.0*z
  }
  box { // Base_Stairs_8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <86.0, 64.5, 1.0>
    translate  15.0*z
  }
  box { // Base_Stairs_7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <88.0, 66.0, 1.0>
    translate  13.0*z
  }
  box { // Base_Stairs_6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <90.0, 67.5, 1.0>
    translate  11.0*z
  }
  box { // Base_Stairs_5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <92.0, 69.0, 1.0>
    translate  9.0*z
  }
  box { // Base_Stairs_4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Marble
    }
    scale <94.0, 70.5, 1.0>
    translate  7.0*z
  }
  texture {
    White_Marble
  }
  rotate -180.0*z
}


