#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stars.inc"

camera {
	location        <.6, -1.0, -1.5>
	direction       <0, 0, 2.5>
	up              <0, 0, -1>
	right           <4/3, 0, 0>
	look_at         <.6, .5, -.1>
}

object { light_source { <3, 2, -1>  color red 1 green .75 blue .5
  area_light <0.2, 0, 0> <0,0,-2.5> 2, 7
  adaptive 1
  jitter
  } 
}

object { light_source { <-3, -3, -.7> color red .7 green .28 blue .112
    area_light <.5, -.5, 0> <0, 0, -1> 2, 10
    adaptive 1
    jitter
   }
}


object { light_source { <-2, -2, -10>  color red .03 green .084 blue .12
  area_light <4, 0, 0> <0, 4, 0> 3, 3
  adaptive 1
  jitter
  } 
}

light_source { <1,-1,1> color White
		spotlight
		point_at <1,1,-10>
		radius 100 falloff 180
	}

object { plane { z,+1 
	 pigment { image_map { gif "sgalien.gif" } }
	       }
       }

object {
	 sphere { <.5,.5,-.1> .1 }
		  texture { pigment { rgbf<0.2,0.4,0.7,1> }
			    finish {    ambient .1
					diffuse .1
					refraction 1
					reflection .3 }
			  }
		
       }

object { cylinder { <.4,.55,-3>,
		    <.5,.55,-.1>,
		    .01
		    open
		  }
	 texture { pigment { rgbf<0.2,0.4,0.7,1> }
		   finish {  ambient .1
			     diffuse .1
			     refraction 1
			     reflection .3 }
		 }
      }

object { cylinder { <-3,.55,-.1>,
		    <.5,.55,-.1>,
		    .01
		    open
		  }
	 texture { pigment { rgbf<0.2,0.4,0.7,1> }
		   finish {  ambient .1
			     diffuse .1
			     refraction 1
			     reflection .3 }
		 }
      }

object {
	 height_field {tga "sgalien.tga" }
	 scale < 1, 0.2, 1 >          
	 rotate < -90, 0, 0 >         
	 translate < 0, 0, 0 >
	 texture { 
		      pigment {color White}
		      finish { diffuse 1 ambient 0.02 }
		    }
       } 
