  
#include "colors.inc" // The include files contain
#include "shapes.inc" // pre-defined scene elements
#include "shapesq.inc" // pre-defined scene elements
#include "textures.inc"
#include "metals.inc"
#include "stones1.inc"
#include "mytext.inc"
#include "ship.inc"

camera {
location <-2.5,5.8,-40.0>
 look_at <0,1,0>
 }


 light_source {<-3,16,-45> color White} 
 light_source {<3,16,0> color White} 


fog {
    distance 5
     colour rgbf <1., 1., 1., 1.0>
     fog_type 2
     fog_offset -4
     fog_alt 1.5
     turbulence 0.8
     turb_depth 0.3
}


fog {
    distance 5
     colour rgbf <0.752941, 0.752941, 0.752941, 1.0>
     fog_type 2
     fog_offset -5
     fog_alt .4
     turbulence 0.5
     turb_depth 0.4
}

//  mountains

height_field {tga "granite.tga" smooth
   pigment {
      image_map {tga "granite.tga"} 
      rotate x*90 }
   finish {ambient .40 }   
   rotate <0,180,0>
   scale <4.2,.55,.1>
   scale 320
   translate <189,-85,200>
   //translate <189,-75,200>
   }


sky_sphere {
pigment {RichBlue
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85> 
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75> 
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1> 
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x

}

#declare block =

union {

// spikes

     cone {
        <3,9,0>,.05
        <3,10,-1>,0
          texture {Polished_Black}
         } 	

     cone {
        <3,9,0>,.05
        <3,10,1>,0
          texture {Polished_Black}
         } 	

     cone {
        <3,9,0>,.05
        <2,10,0>,0
          texture {Polished_Black}
         } 	

     cone {
        <3,9,0>,.05
        <4,10,0>,0
          texture {Polished_Black}
         } 	

     cone {
        <3,9,0>,.05
        <3,11,0>,0
          texture {Polished_Black}
         } 	


difference {
     box {<-3,-6,-6>,<3,9,6>
	texture {T_Stone3
	scale <.1,.1,.1>
	}
        }


      plane {x,0
	rotate <0,0,-20>
	//rotate <0,0,-15>
	translate <-1.2,0,0>
	texture {T_Stone3}
	}

//....windows...
//   LEVEL 1

     box {<-4,8.9,-5.9>,<7,8,-5>
 }

     box {<-4,8.9,-4.9>,<7,8,-4>
}
	
     box {<-4,8.9,-3.9>,<7,8,-3>
}

     box {<-4,8.9,-2.9>,<7,8,-2>
}
	
     box {<-4,8.9,-1.9>,<7,8,-1>
}
	
     box {<-4,8.9,1.9>,<7,8,1>
}
	
     box {<-4,8.9,2.9>,<7,8,2>
}
	
     box {<-4,8.9,3.9>,<7,8,3>
}
	
     box {<-4,8.9,4.9>,<7,8,4>
}
	
     box {<-4,8.9,5.9>,<7,8,5>
}
	


//   LEVEL 2

     box {<-4,7.9,-5.9>,<7,7,-5>
}

     box {<-4,7.9,-4.9>,<7,7,-4>
}
	
     box {<-4,7.9,-3.9>,<7,7,-3>
}

     box {<-4,7.9,-2.9>,<7,7,-2>
}
	
     box {<-4,7.9,-1.9>,<7,7,-1>
}
	
     box {<-4,7.9,1.9>,<7,7,1>
}
	
     box {<-4,7.9,2.9>,<7,7,2>
}
	
     box {<-4,7.9,3.9>,<7,7,3>
}
	
     box {<-4,7.9,4.9>,<7,7,4>
}
	
     box {<-4,7.9,5.9>,<7,7,5>
}
	


//   LEVEL 3
     box {<-4,6.9,-5.9>,<7,6,-5>
         }

     box {<-4,6.9,-4.9>,<7,6,-4>
         }
	
     box {<-4,6.9,-3.9>,<7,6,-3>
         }

     box {<-4,6.9,-2.9>,<7,6,-2>
         }
	
     box {<-4,6.9,-1.9>,<7,6,-1>
         }
	
     box {<-4,6.9,1.9>,<7,6,1>
         }
	
     box {<-4,6.9,2.9>,<7,6,2>
         }
	
     box {<-4,6.9,3.9>,<7,6,3>
         }
	
     box {<-4,6.9,4.9>,<7,6,4>
         }
	
     box {<-4,6.9,5.9>,<7,6,5>
         }
	

//....LEVEL 4

     box {<-4,5.9,-5.9>,<7,5,-5>
         }

     box {<-4,5.9,-4.9>,<7,5,-4>
         }
	
     box {<-4,5.9,-3.9>,<7,5,-3>
         }

     box {<-4,5.9,-2.9>,<7,5,-2>
         }
	
     box {<-4,5.9,-1.9>,<7,5,-1>
         }
	
     box {<-4,5.9,1.9>,<7,5,1>
         }
	
     box {<-4,5.9,2.9>,<7,5,2>
         }
	
     box {<-4,5.9,3.9>,<7,5,3>
         }
	
     box {<-4,5.9,4.9>,<7,5,4>
         }
	
     box {<-4,5.9,5.9>,<7,5,5>
         }
	


//....LEVEL 5

     box {<-4,4.9,-5.9>,<7,4,-5>
         }

     box {<-4,4.9,-4.9>,<7,4,-4>
         }
	
     box {<-4,4.9,-3.9>,<7,4,-3>
         }

     box {<-4,4.9,-2.9>,<7,4,-2>
         }
	
     box {<-4,4.9,-1.9>,<7,4,-1>
         }
	
     box {<-4,4.9,1.9>,<7,4,1>
         }
	
     box {<-4,4.9,2.9>,<7,4,2>
         }
	
     box {<-4,4.9,3.9>,<7,4,3>
         }
	
     box {<-4,4.9,4.9>,<7,4,4>
         }
	
     box {<-4,4.9,5.9>,<7,4,5>
         }
	



//....LEVEL 6

     box {<-4,3.9,-5.9>,<7,3,-5>
         }

     box {<-4,3.9,-4.9>,<7,3,-4>
         }
	
     box {<-4,3.9,-3.9>,<7,3,-3>
         }

     box {<-4,3.9,-2.9>,<7,3,-2>
         }
	
     box {<-4,3.9,-1.9>,<7,3,-1>
         }
	
     box {<-4,3.9,1.9>,<7,3,1>
         }
	
     box {<-4,3.9,2.9>,<7,3,2>
         }
	
     box {<-4,3.9,3.9>,<7,3,3>
         }
	
     box {<-4,3.9,4.9>,<7,3,4>
         }
	
     box {<-4,3.9,5.9>,<7,3,5>
         }
	



//....LEVEL 7

     box {<-4,2.9,-5.9>,<7,2,-5>
         }

     box {<-4,2.9,-4.9>,<7,2,-4>
         }
	
     box {<-4,2.9,-3.9>,<7,2,-3>
         }

     box {<-4,2.9,-2.9>,<7,2,-2>
         }
	
     box {<-4,2.9,-1.9>,<7,2,-1>
         }
	
     box {<-4,2.9,1.9>,<7,2,1>
         }
	
     box {<-4,2.9,2.9>,<7,2,2>
         }
	
     box {<-4,2.9,3.9>,<7,2,3>
         }
	
     box {<-4,2.9,4.9>,<7,2,4>
         }
	
     box {<-4,2.9,5.9>,<7,2,5>
         }
	



//....LEVEL 8

     box {<-4,1.9,-5.9>,<7,1,-5>
         }

     box {<-4,1.9,-4.9>,<7,1,-4>
         }
	
     box {<-4,1.9,-3.9>,<7,1,-3>
         }

     box {<-4,1.9,-2.9>,<7,1,-2>
         }
	
     box {<-4,1.9,-1.9>,<7,1,-1>
         }
	
     box {<-4,1.9,1.9>,<7,1,1>
         }
	
     box {<-4,1.9,2.9>,<7,1,2>
         }
	
     box {<-4,1.9,3.9>,<7,1,3>
         }
	
     box {<-4,1.9,4.9>,<7,1,4>
         }
	
     box {<-4,1.9,5.9>,<7,1,5>
         }
	


//....LEVEL 9

     box {<-4,0.9,-5.9>,<7,0,-5>
         }

     box {<-4,0.9,-4.9>,<7,0,-4>
         }
	
     box {<-4,0.9,-3.9>,<7,0,-3>
         }

     box {<-4,0.9,-2.9>,<7,0,-2>
         }
	
     box {<-4,0.9,-1.9>,<7,0,-1>
         }
	
     box {<-4,0.9,1.9>,<7,0,1>
         }
	
     box {<-4,0.9,2.9>,<7,0,2>
         }
	
     box {<-4,0.9,3.9>,<7,0,3>
         }
	
     box {<-4,0.9,4.9>,<7,0,4>
         }
	
     box {<-4,0.9,5.9>,<7,0,5>
         }

  }


difference {


     box {<-3,-6,-5.9>,<2.9,9,5.9>
	texture {Polished_Gold}
	}

      plane {x,0
	texture {Polished_Gold}
	rotate <0,0,-20>
	translate <-1.1,0,0>
	}

}
}



#declare tower1 = 
union {

     cylinder {
           <0,6.0,0>,
           <0,5.65,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,5.65,0>,
           <0,5.5,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,5.5,0>,
           <0,5.15,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,5.15,0>,
           <0,5.0,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,5.0,0>,
           <0,4.65,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,4.65,0>,
           <0,4.5,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,4.5,0>,
           <0,4.15,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,4.15,0>,
           <0,4.0,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,4.0,0>,
           <0,3.65,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,3.65,0>,
           <0,3.5,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,3.5,0>,
           <0,3.15,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,3.15,0>,
           <0,3,0>,1
           texture {Polished_Chrome}
          }


     cylinder {
           <0,3.0,0>,
           <0,2.65,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,2.65,0>,
           <0,2.5,0>,1
           texture {Polished_Chrome}
          }


     cylinder {
           <0,2.5,0>,
           <0,2.15,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,2.15,0>,
           <0,2,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,2.0,0>,
           <0,1.65,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,1.65,0>,
           <0,1.5,0>,1
           texture {Polished_Chrome}
          }


     cylinder {
           <0,1.5,0>,
           <0,1.15,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,1.15,0>,
           <0,1,0>,1
           texture {Polished_Chrome}
          }

     cylinder {
           <0,1.0,0>,
           <0,0.65,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,0.65,0>,
           <0,0.5,0>,1
           texture {Polished_Chrome}
          }


     cylinder {
           <0,0.5,0>,
           <0,0.15,0>,1
           texture {T_Stone15
		scale .1}
          }

     cylinder {
           <0,0.15,0>,
           <0,0,0>,1
           texture {Polished_Chrome}
          }


     cylinder {
           <0,0.0,0>,
           <0,-0.65,0>,1
           texture {T_Stone15
		scale .1}
          }


     cylinder {
           <0,0,0>,
           <0,-10,0>,.25
           texture {Aluminum}
          }



//landling platform


     cylinder {
           <0,5,0>,
           <0,4.98,0>,2
           texture {T_Stone8
           scale .01}
         }

torus { 2,0.04
   texture {New_Penny}
   translate <0,5.15,0>
}

     cylinder {
           <0,2.5,0>,
           <0,2.48,0>,2
           texture {T_Stone8
           scale .01}
         }

torus { 2,0.04
   texture {New_Penny}
   translate <0,2.65,0>
}


     cylinder {
           <0,0,0>,
           <0,-0.02,0>,2
           texture {T_Stone8
           scale .01}
         }

torus { 2,0.04
   texture {New_Penny}
   translate <0,0.15,0>
}



// spikes

     cone {
        <0,6,0>,.05
        <0,7,-1>,0
          texture {Polished_Black}
         } 	

     cone {
        <0,6,0>,.05
        <0,7,1>,0
          texture {Polished_Black}
         } 	

     cone {
        <0,6,0>,.05
        <-1,7,0>,0
          texture {Polished_Black}
         } 	

     cone {
        <0,6,0>,.05
        <1,7,0>,0
          texture {Polished_Black}
         } 	

     cone {
        <0,6,0>,.05
        <0,8,0>,0
          texture {Polished_Black}
         } 	

}


//........................................................................

// place objects

object { tower1
   translate <-4.40,0,-38>
 }


object {tower1
   translate <1,0,-19>
}

object {tower1
 	translate <-16,0,6>
}

object {tower1
 	translate <19,0,20>
}

object {block
	rotate <0,-5,0>
	translate <13.5,0,-18>
}


object {block
	rotate <0,-120,0>
	translate <-18.5,0,40>
	//translate <-12.5,0,40>
}

  
//......................................................................


//ship  - close up
object {ship
	translate <-2.56,5.810,-39.8>
	//translate <-2.63,5.860,-39.6>
}

  
//ship  - on right
object {ship
   	rotate <28,-140,0>
	translate <-2.13,5.700,-39.3>
	//translate <-2.13,5.800,-39.2>
}
  
// tower number 1

//ship on landing platform
object {ship
   	rotate <0,180,0>
	translate <-2.72,5.01,-38>
}

//ship on landing platform
object {ship
   	rotate <0,180,0>
	translate <-2.92,5.01,-38.1>
}


//ship on landing platform
object {ship
   	rotate <0,180,0>
	translate <-2.52,5.01,-38.1>
}

//................................................................

//ship on landing platform
object {ship
   	rotate <0,80,0>
	translate <-2.76,5.01,-38.5>
}


//ship on landing platform
object {ship
   	rotate <0,80,0>
	translate <-2.96,5.01,-38.6>
}


//ship on landing platform
object {ship
   	rotate <0,80,0>
	translate <-2.56,5.01,-38.5>
}

//................................................................


//ship on landing platform
object {ship
   	rotate <0,18,0>
	translate <-3.55,5.01,-36.8>
}


//ship on landing platform
object {ship
   	rotate <0,18,0>
	translate <-3.35,5.01,-36.9>
}


//ship on landing platform
object {ship
   	rotate <0,18,0>
	translate <-3.15,5.01,-37.0>
}

//..................................................................

//ship on landing platform
object {ship
   	rotate <0,0,0>
	translate <-3.05,5.01,-37.4>
}

//ship on landing platform
object {ship
   	rotate <0,0,0>
	translate <-2.85,5.01,-37.5>
}


//ship on landing platform
object {ship
   	rotate <0,0,0>
	translate <-2.65,5.01,-37.6>
}

//..............................................................................

// tower number 2

//ship on landing platform
object {ship
   	rotate <0,0,0>
	translate <0.5,2.51,-1.6>
}


//ship on landing platform
object {ship
   	rotate <0,50,0>
	translate <-0.5,2.51,-1.6>
}

//ship on landing platform
object {ship
   	rotate <0,50,0>
	translate <0,2.51,-1>
}

//...........................................................................

// tower number 3

//ship on landing platform
object {ship
   	rotate <0,0,0>
	translate <0.5,0.01,-1.6>
}


//ship on landing platform
object {ship
   	rotate <0,50,0>
	translate <-0.5,0.01,-1.6>
}


//ship on landing platform
object {ship
   	rotate <0,50,0>
	translate <0,0.01,-1>
}


//..............................................................................
//power distribution


     cone {
        <0,-5,0>,3
        <0,17,0>,0
          texture {Polished_Black}
         } 	



cylinder {
         <-4.4,8,-38>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     


cylinder {
         <1,8,-19>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     

cylinder {
         <-16,8,6>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     


cylinder {
         <19,8,20>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     


cylinder {
         <-15.5,11,40>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     

cylinder {
         <13.5,11,-18>
         <0,17,0>,0.02
         texture {Ruby_Glass}
	no_shadow
}     
