unit Flshmake;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const MAX_ALF=6;
      MAX_BET=6;
      MAX_LIN=10;

function RToSmn(a:single;m,n:byte):string;
var s:string[30]; i:byte;
begin
 Str(a:m:n,s);
{ i:=Pos('.',s);
 if i>0 then begin s[i]:=','; end;}
 RToSmn:=s;
end;

procedure TForm1.Button1Click(Sender: TObject);
var f:textfile;
    a,b,c,lins:integer;
    alf, bet, alf0,bet0, ka,kb:single;
    xx,yy,zz, ax,ay,az, rr:single;
    M:array [0..3,0..2] of single;
begin
 assignfile(f,'flashes.inc');
 rewrite(f);
 writeln(f,'#declare FLASHES=object {');
 writeln(f,'union {');
 for a:=0 to MAX_ALF do begin
  alf0:=a*(2*pi/(MAX_ALF+1)); alf:=alf0;
  for b:=0 to MAX_BET do begin
   bet0:=b*(2*pi/(MAX_BET+1)); alf:=alf0; bet:=bet0;
   xx:=2*cos(bet0)*cos(alf0);
   yy:=2*sin(bet0);
   zz:=2*cos(bet0)*sin(alf0);
   for lins:=0 to MAX_LIN do begin
    ka:=0.7*(alf-alf0);
    kb:=0.7*(bet-bet0);
    if alf>alf0 then
     alf:=alf-(0.6+random*0.4)
    else
     alf:=alf+(0.6+random*0.4);
    if bet>bet0 then
     bet:=bet-(0.6+random*0.4)
    else
     bet:=bet+(0.6+random*0.4);
    rr:=random*0.5;
    ay:=alf*180/pi;
    if sqrt(xx*xx+yy*yy+zz*zz)>=2 then begin
     {writeln(f,'cylinder { <0,0,0>, <1,0,0>, 1');}
     writeln(f,'cylinder { <0,0,0>, <'+rtosmn(rr*cos(bet)*cos(alf),10,5)+','+
                                       rtosmn(rr*sin(bet),10,5)+','+
                                       rtosmn(rr*cos(bet)*sin(alf),10,5)+',>, THIN');
     writeln(f,'  pigment { color rgbt<0, 0.2, 1, 0> }');
     writeln(f,'  finish { ambient 1.0 diffuse 0.0 }');
    (* writeln(f,'  halo { glowing spherical_mapping linear');
     writeln(f,'         color_map { [ 0 color rgbt <0, 1, 1, 0> ] [ 1 color rgbt <0.0, 0.0, 1, 0> ] }');
     writeln(f,'         samples 12');
     writeln(f,'       }');
     writeln(f,'  hollow');*)
     {writeln(f,'  scale  <THIN,1,THIN>')
     writeln(f,'  rotate    <'+rtosmn(ax,10,5)+','+rtosmn(ay,10,5)+','+rtosmn(az,10,5)+'>');}
     writeln(f,'  translate <'+rtosmn(xx,10,5)+','+rtosmn(yy,10,5)+','+rtosmn(zz,10,5)+'>');
     writeln(f,'}');
    end;
    xx:=xx+rr*cos(bet)*cos(alf);
    yy:=yy+rr*sin(bet);
    zz:=zz+rr*cos(bet)*sin(alf);
   end; {for lines}
   (*writeln(f,'sphere { 0, 2');
   writeln(f,' pigment { color rgbt <1, 1, 1, 1> }');
   writeln(f,' halo {  glowing spherical_mapping linear');
   writeln(f,' color_map { [ 0 color rgbt <0, 1, 1, 1> ] [ 1 color rgbt <0, 0, 1, 0> ]  }');
   writeln(f,' samples 10');
   writeln(f,' }');
   writeln(f,' hollow');
   writeln(f,'  scale <0.05,0.05,0.05>');
   writeln(f,'  translate <'+rtosmn(xx,10,5)+','+rtosmn(yy,10,5)+','+rtosmn(zz,10,5)+'>');
   writeln(f,'}');*)
   end;
 end;
 writeln(f,'}');
 writeln(f,'}');
 closefile(f);
 Close;
end;

const Max_AX=10;
procedure TForm1.Button2Click(Sender: TObject);
var f:textfile;
    ax, ay, N, lins:integer;
    xx,yy,zz, ax0, ay0, rr, r0, alf, bet, x0,y0,z0:single;
begin
 r0:=1.5;
 assignfile(f,'flashes.inc');
 rewrite(f);
 writeln(f,'#declare FLASHES=object {');
 writeln(f,'union {');
 for ax:=0 to MAX_AX-1 do begin
  ax0:=ax*(pi/MAX_AX); alf:=ax0; N:=abs(round(MAX_AX/1.7*sin(ax0)))+1;
  Memo1.Lines.Add(IntToStr(N));
  for ay:=0 to N-1 do begin
   ay0:=ay*(1.9*pi/N); alf:=ax0; bet:=ay0;
   x0:=r0*sin(alf)*sin(bet); xx:=x0;
   y0:=r0*cos(alf);          yy:=y0;
   z0:=r0*sin(alf)*cos(bet); zz:=z0;
   {xx:=0; yy:=0; zz:=0;}
   rr:=0.6;
   for lins:=0 to MAX_LIN+2 do begin
    if alf>ax0 then  alf:=alf-(0.6+random*0.4)*1.2
                else  alf:=alf+(0.6+random*0.4)*1.2;
    if bet>ay0 then  bet:=bet-(0.6+random*0.4)*1.2
                else  bet:=bet+(0.6+random*0.4)*1.2;
    rr:=random*0.2;
     writeln(f,'cylinder { <0,0,0>, <0,1,0>, 1');
     writeln(f,'  pigment { color rgbt<1, 1, 1, 1> }');
     writeln(f,'  halo {emitting cylindrical_mapping linear');
     writeln(f,'         color_map { [ 0   color rgbt <0, 1, 1, 0.8> ]'+
                                    '[ 0.5 color rgbt <0, 0, 1, 0> ]'+
                                    '[ 1   color rgbt <0.0, 0.0, 1, -1> ] }');
     writeln(f,'         samples 12');
     writeln(f,'       }');
     writeln(f,'  hollow');
     writeln(f,'  scale  <THIN,'+rtosmn(rr,10,5)+',THIN>');
     writeln(f,'  rotate    <'+rtosmn(alf*180/pi,10,5)+','+rtosmn(bet*180/pi,10,5)+',0>');
     writeln(f,'  translate <'+rtosmn(xx,10,5)+','+rtosmn(yy,10,5)+','+rtosmn(zz,10,5)+'>');
     writeln(f,'}');

   writeln(f,'cylinder { <0,0,0>, <0,1,0>, 1');
   writeln(f,'  pigment { color rgbt<1, 1, 1, 1> }');
   writeln(f,'  halo {glowing cylindrical_mapping linear turbulence 1.7 frequency 1.2');
   writeln(f,'         color_map { [ 0   color rgbt <1, 1, 1, 1> ]'+
                                  '[ 1 color rgbt <1, 1, 0, 0.8> ] }');
   writeln(f,'         samples 8');
   writeln(f,'         scale  <0.5,0.8,0.5>');
   writeln(f,'       }');
   writeln(f,'  hollow');
   writeln(f,'  scale  <THIN*10,'+rtosmn(rr*1.2,10,5)+',THIN*10>');
   writeln(f,'  rotate    <'+rtosmn(alf*180/pi,10,5)+','+rtosmn(bet*180/pi,10,5)+',0>');
   writeln(f,'  translate <'+rtosmn(xx,10,5)+','+rtosmn(yy,10,5)+','+rtosmn(zz,10,5)+'>');
   writeln(f,'}');

    xx:=xx+(rr)*sin(alf)*sin(bet);
    yy:=yy+(rr)*cos(alf);
    zz:=zz+(rr)*sin(alf)*cos(bet);
   end; {for lines}
  end;
 end;
 writeln(f,'}');
 writeln(f,'}');
 closefile(f);
 close;
end;

procedure TForm1.Button3Click(Sender: TObject);
var f:textfile;
    ax, ay, N, lins:integer;
    xx,yy,zz, ax0, ay0, rr, r0, alf, bet, x0,y0,z0:single;
begin
 r0:=1.5;
 assignfile(f,'flashes.inc');
 rewrite(f);
 writeln(f,'#declare FLASHES=object {');
 writeln(f,'sphere {0,  5');
 writeln(f,'  pigment { color rgbt<1, 1, 1, 1> }');
 for ax:=0 to MAX_AX-1 do begin
  ax0:=ax*(pi/MAX_AX); alf:=ax0; N:=abs(round(MAX_AX/1.7*sin(ax0)))+1;
  Memo1.Lines.Add(IntToStr(N));
  for ay:=0 to N-1 do begin
   ay0:=ay*(1.9*pi/N); alf:=ax0; bet:=ay0;
   x0:=r0*sin(alf)*sin(bet); xx:=x0;
   y0:=r0*cos(alf);          yy:=y0;
   z0:=r0*sin(alf)*cos(bet); zz:=z0;
   {xx:=0; yy:=0; zz:=0;}
   rr:=0.6;
   for lins:=0 to MAX_LIN+2 do begin
    if alf>ax0 then  alf:=alf-(0.6+random*0.4)*1.2
                else  alf:=alf+(0.6+random*0.4)*1.2;
    if bet>ay0 then  bet:=bet-(0.6+random*0.4)*1.2
                else  bet:=bet+(0.6+random*0.4)*1.2;
    rr:=random*0.2;
     writeln(f,'  halo {emitting cylindrical_mapping linear');
     writeln(f,'         color_map { [ 0   color rgbt <0, 1, 1, 1> ]'+
                                    '[ 1   color rgbt <0.0, 0.0, 1, 0> ] }');
     writeln(f,'         samples 4');
     writeln(f,'  scale  <THIN,'+rtosmn(rr,10,5)+',THIN>');
     writeln(f,'  rotate    <'+rtosmn(alf*180/pi,10,5)+','+rtosmn(bet*180/pi,10,5)+',0>');
     writeln(f,'  translate <'+rtosmn(xx,10,5)+','+rtosmn(yy,10,5)+','+rtosmn(zz,10,5)+'>');
     writeln(f,'       }');
    xx:=xx+(rr)*sin(alf)*sin(bet);
    yy:=yy+(rr)*cos(alf);
    zz:=zz+(rr)*sin(alf)*cos(bet);
   end; {for lines}
  end;
 end;
 writeln(f,' hollow');
 writeln(f,'} //sphere');
 writeln(f,'} //object');
 closefile(f);
 close;
end;

end.
(*
  cylinder { <0,0,0>, <0,1,0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, 1, 1, 0.9> ]
        [ 1 color rgbt <0.0, 0.0, 1, 0> ]
      }
      samples 10
    }
    hollow
    scale <0.02, LEN ,0.02>
    translate <X, Y, Z> //Begin
    rotate <A,B,C>      //
  }
*)