#include "colors.inc"
#include "glass.inc"
#include "stones.inc"

camera {
    location <0, 0, -5>
    look_at <0, 0, 0>
//    look_at <-1,-1.6,1.4>
}

atmosphere {
    type 1          //5=HENYEY_GREENSTEIN_SCATTERING; 1=ISOTROPIC_SCATTERING
    samples 50
    distance 40
    scattering 0.4
    aa_level 4
    aa_threshold 0.1
    jitter 0.2
}

// Violett-Himmel als Halo im Box
box {
 <0,0,0>,
 <1,1,1>
    pigment {
      color rgbt <1, 1, 1, 1>
    }
    halo {
      emitting
      box_mapping
      linear
      turbulence <-1.52345,-0.1,-1.345>
      color_map {
        [ 0 color rgbt <0, 0, 1, 1> ]
        [ 1 color rgbt <1, 0, 1, -1> ]
      }
      frequency 19.17
      samples 20
    }
 hollow
 scale <100,5,100>
 translate <-50,3,-1>
 rotate x*-2
}

//Landschaft um die Betrachter
#declare T_MyStone =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.25 diffuse 0.9 crand 0.03}
}
texture{T_Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

height_field
{
 gif "m64x48.gif"
 scale <60,4,60>
 translate <-30,-3,-30>
 texture { T_MyStone }
 smooth
// water_level 0.1
 hollow
}

// The water surface
plane { y, 0
    pigment { red 0.2 green 0.6 blue 1.0 filter 0.8 }
    finish { refraction 1.0 ior 1.1 reflection 0.7 caustics 1.1 }
    translate <0, -1.7, 0>
    normal { bumps 0.3 }
}

// Source of Light-Beam
light_source {
   <2, 2, 2>
   color rgb <0.5, 0.9, 1>
   spotlight
   point_at <-1,-1.4,1.4>
   radius 4
   falloff 7
  }

//Glass-Sphere
sphere { <-1,-1.4,1.4>, 0.4
  texture {T_Glass3}
  hollow
}

//Flashes
#declare THIN =0.021
#include "flashes.inc"
object {
 FLASHES
 scale <0.2,0.2,0.2>
 translate <-1,-1.4,1.4>
}


//Blaue Umgebung
sphere { <0,0,0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <0, 0, 1, 1> ]
        [ 1 color rgbt <0, 1, 1, -0.5> ]
      }
      samples 10
    }
   hollow
   translate <2,2,2>
}

//Blaue Lichtkrper
sphere { <0,0,0>, 0.4
 pigment { color rgbt <1, 1, 1, 1> }
 halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, 0, 1, 1> ]
        [ 1 color rgbt <0, 1, 1, -1> ]
      }
      samples 7
    }
    hollow
    translate <2,2,2>
}
