
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//



#version 3

#include "colors.inc"
#include "woods.inc"
#include "stones.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 7
}


#declare H1=10
#declare H2=10
#declare L1=10
#declare L2=10
#declare L3=pow(H2*H2+L1*L1*4,0.5)
#declare W1=L1*2
#declare W2=L2*2.5
// ----------------------------------------

#declare View_test    =0
#declare View_outside =1  //tavout, tavoutt
#declare View_shield  =2  //shield, shieldt
#declare View_HTable  =3  //tavin1, tavin1t
#declare View_pan     =4  //wide
#declare View_HTub    =5  //htub, htubt
#declare View_Bar     =6  //bar, bart
#declare View_Bottles =7  //bot, bott
#declare View_HTub2   =8  //htub2, htub2t
#declare View_FPlace  =9  //fplace, fplacet

/*
fog { fog_type 1
      distance 400
      colour rgbt <0.3,0.3,0.3,0.6>
      turbulence 0.9}
*/


#declare Detail=10


#declare View_name = View_HTable   //   **Change View Here ***
//#declare View_name = View_test   //   **Change View Here ***

#switch (View_name)
  #case (View_outside)
    camera { location <50.0, 19, -66.0>
         direction 1.5*z
         right     4/3*x
         look_at <0,4,0>  }
  #break

  #case (View_shield)
    camera { location <-12.5,6,0>
         direction 1.5*z
         right     3/4*x
         look_at <-W1,6,0>  }
  #break

  #case (View_pan)
    camera { location <0,6,0>    // 780 x 120
         cylinder 1
         right     3/4*x
         angle 360
         look_at <-1.0,6,0>  }

  #break

  #case (View_Bottles)
    camera { location <-10,6,-18>
         direction 1.5*z
         right     4/3*x
         look_at <-13,4.25,-25>  }

  #break

  #case (View_Bar)
    camera { location <19.45,6,-24.45>
         direction 1.5*z
         right     4/3*x
         look_at <-19,6,24>  }

  #break

  #case (View_HTable)
    camera { location <19.45,6-0.05,24.45>
         direction 1.5*z
         right     4/3*x
         //look_at <-19,6,-24>
         look_at <-19,5,-20> }

  #break

  #case (View_HTub)
    camera { location <-19.0,4.5,24.0>
         direction 1.5*z
         right     4/3*x
         look_at <0,4.75,4>  }

  #break

  #case (View_HTub2)
    camera { location <-18.80,6.2,-2>
         direction 1.5*z
         right     4/3*x
         look_at <-13.5,5.0,24>  }

  #break
  #case (View_FPlace)
    camera { location <0,6.2,9.66>
         direction 1.5*z
         right     4/3*x
         look_at <0,4.5,24>  }

  #break
  #else  //Test View
/*camera { location <3-W1,5.5,-8> //look at htub
         direction 1.5*z
         right     4/3*x
         look_at <-10,4.5,W2>  } */

/*camera { location <4-W1,4.5,W2-4> //view FROM htub
         direction 1.5*z
         right     4/3*x
         look_at <W1,5,15-W2>  } */


 camera { location <W1-7.75,13,W2-8.5>
         direction 1.5*z
         right     4/3*x
         look_at <W1-7.75,0,W2-8.5>  }


#end



sky_sphere { S_Cloud3 }



#declare Grass = pigment{crackle scale 0.03 color_map{
        [0 rgb <0.7,0.5,0.3>*0.35]
        [1 DarkGreen]
        }}

#declare T_Landscape=
texture{
pigment {bozo scale 100
pigment_map{
[ 0.25 agate scale 0.1 pigment_map{
  [0 rgb <0.7,0.5,0.3>*0.5]
  [0.8 Grass]}]

[ 0.75 agate scale 0.3 pigment_map{
  [0.3 Grass]
  [1 rgb <0.7,0.5,0.3>]}]}}
normal{bumps scale 40 turbulence 0.4}}


plane { y, 0 texture {T_Landscape}}

sphere{-0.5*y,1 scale <5000,250,5000> translate<-5000,0,10000>
texture{T_Landscape}}
sphere{-0.5*y,1 scale <5000,100,5000> translate<10000,0,10000>
texture{T_Landscape}}
sphere{-0.5*y,1 scale <5000,250,5000> translate<10000,0,5000>
texture{T_Landscape}}
sphere{-0.5*y,1 scale <5000,100,5000> translate<-10000,0,5000>
texture{T_Landscape}}

union{
sphere { 0, 1.0
    scale <2500,2700,2500>
    translate <-20000+2000,0,20000>}
sphere { 0, 1.0
    scale <2500,2000,2500>
    translate <-20000,0,20000-2500>}
sphere { 0, 1.0
    scale <2500,1500,2500>
    translate <-20000+2000,0,20000-1500>}
cone { 1*y,  0.0,
       0*y, 1.0
    scale 5000
    translate <-20000,0,20000>}

  pigment{bumps turbulence 0.76 scale 50 color_map{
  [0 rgb <0.7,0.5,0.3>]
  [0.72 rgb <0.7,0.5,0.3>*0.5]
  [1 rgb<0.35,0.75,0.15>/3]}}
  normal{ crackle scale 100 }
  }


#include "bldg.pov"
#include "lights.inc"
#include "details.inc"
#include "fplace.inc"
#include "pig.inc"
#include "robwat.inc"
#include "robwat2.inc"
#include "alien1.inc"
#include "alien2.inc"
#include "alien3.inc"

/*sphere{0,1 translate <10,5,10> texture{T_Chrome_1A}}
sphere{0,1 translate <8,5,10> texture{T_Chrome_2A}}
sphere{0,1 translate <6,5,10> texture{T_Chrome_3A}}
sphere{0,1 translate <4,5,10> texture{T_Chrome_4A}}
sphere{0,1 translate <2,5,10> texture{T_Chrome_5A}}
*/



