// Drivers and passengers
// Include file for Traffic
// Entry to October 1996 POVray competition
// By The Butter-Fingered Juggler


#declare Alien1 =
blob {
     threshold 0.1
     component 1.0, 4.0, <0, 0, 0> 
     component 1.0, 2.0, <4, -2, 0>
     component 1.0, 2.0, <-4, -2, 0>
     component 1.0, 0.5, <-1, 3, 0>
     component 1.0, 0.5, <-1.3, 3.3, 0> 
     component 1.0, 0.5, <-1.6, 3.7, 0>
     component 1.0, 0.5, <-1.9, 4.1, 0>
     component 1.0, 1.0, <-2.5, 5, 0>
     component 1.0, 0.5, <1, 3, -2>
     component 1.0, 0.5, <1.2, 3.4, -2>
     component 1.0, 0.5, <1.6, 3.8, -2>
     component 1.0, 0.5, <2.1, 4.2, -2>
     component 1.0, 1.0, <2.6, 4.6, -2>
     component 1.0, 0.5, <1, 3, 2>
     component 1.0, 0.5, <1.2, 3.4, 2>
     component 1.0, 0.5, <1.6, 3.8, 2>
     component 1.0, 0.5, <2.1, 4.2, 2>
     component 1.0, 1.0, <2.6, 4.6, 2>
}

// -------------------------------------------------
// reused head from zoot

#declare Alien2 = union {
blob {
     threshold 0.1
     component 1.0, 4.0, <1, 7, -3> // main head nodes
     component 1.0, 4.0, <1, 7, 3>
     component 1.0, 3.0, <2.5, 5, -1.5>
     component 1.0, 3.0, <2.5, 5, 1.5>
     component 1.0, 2.0, <1, 3, -4> // back jaw
     component 1.0, 2.0, <1, 3, 4>
     component 1.0, 2.0, <1.5, 2.5, -3.5>
     component 1.0, 2.0, <1.5, 2.5, 3.5>
     component 1.0, 2.0, <2, 2, -3>
     component 1.0, 2.0, <2, 2, 3>
     component 1.0, 2.0, <3, 2, -2>
     component 1.0, 2.0, <3, 2, 2>
     component 1.0, 3.0, <5, 2, 0> // top jaw
     component 1.0, 2.0, <3, -1, 0> // bottom jaw
     component 1.0, 2.0, <4, 0, 0>
     component 1.0, 2.0, <6, 5, -1> // eye bones
     component 1.0, 2.0, <6, 5, 1>
     component -1.0, 1.0, <7, 4, -1> // eye sockets
     component -1.0, 1.0, <7, 4, 1>
     component 1.0, 2.0, <7, 7, 0> // forehead
     component 1.0, 3.0, <4, 7, 0>
     component 1.0, 8.0, <-5, -2, 0> // body
     component 1.0, 8.0, <-10, -4, 0>
}

// eyes
sphere {<7, 4, -1>, 1 pigment {color Black} }
sphere {<7, 4, 1>, 1 pigment {color Black} }

} // end alien 2 union



// --------------------------------------------------
// It seemed a shame to waste them so here's Zoot and Bowba
// from the band, busking on the bus

#declare Zoot_Body = union {

// Head
blob {
     threshold 0.1
     component 1.0, 4.0, <1, 7, -3> // main head nodes
     component 1.0, 4.0, <1, 7, 3>
     component 1.0, 3.0, <2.5, 5, -1.5>
     component 1.0, 3.0, <2.5, 5, 1.5>
     component 1.0, 2.0, <1, 3, -4> // back jaw
     component 1.0, 2.0, <1, 3, 4>
     component 1.0, 2.0, <1.5, 2.5, -3.5>
     component 1.0, 2.0, <1.5, 2.5, 3.5>
     component 1.0, 2.0, <2, 2, -3>
     component 1.0, 2.0, <2, 2, 3>
     component 1.0, 2.0, <3, 2, -2>
     component 1.0, 2.0, <3, 2, 2>
     component 1.0, 3.0, <5, 2, 0> // top jaw
     component 1.0, 2.0, <3, -1, 0> // bottom jaw
     component -1.0, 1.0, <4, 0, 0> // mouth
     component 1.0, 2.0, <4, 0, 0>
     component 1.0, 2.0, <6, 5, -1> // eye bones
     component 1.0, 2.0, <6, 5, 1>
     component -1.0, 1.0, <7, 4, -1> // eye sockets
     component -1.0, 1.0, <7, 4, 1>
     component 1.0, 2.0, <7, 7, 0> // forehead
     component 1.0, 3.0, <4, 7, 0>
}

// eyes
sphere {<7, 4, -1>, 0.5 
	texture {
		pigment {
		gradient x
        	color_map {
			[0.0, 0.85 color White color White]
			[0.85, 0.98 color Blue color Cyan]
			[0.98, 1.01 color Black color Black]}
		}
		scale 0.5
//		rotate <0, 90, 0>	
	}
}
sphere {<7, 4, 1>, 0.5
	texture {
		pigment {
		gradient x
        	color_map {
			[0.0, 0.85 color White color White]
			[0.85, 0.98 color Blue color Cyan]
			[0.98, 1.01 color Black color Black]}
		}
		scale 0.5
//		rotate <0, 90, 0>	
	}
}

// right arms
sphere { <-2, -3, -5>, 0.8 }
cylinder { <-2, -3, -5>, <3, -4, -10>, 0.5 }
sphere { <3, -4, -10>, 0.8 }
cylinder { <3, -4, -10>, <7, -3, -3>, 0.5 }
sphere { <7, -3, -3>, 0.8 }

sphere { <-2, -5, -5>, 0.8 }
cylinder { <-2, -5, -5>, <3, -6, -11>, 0.5 }
sphere { <3, -6, -11>, 0.8 }
cylinder { <3, -6, -11>, <7, -7, -5.5>, 0.5 }
sphere {<7, -7, -5.5>, 0.8 }

// left arms
sphere { <-2, -3, 5>, 0.8 }
cylinder { <-2, -3, 5>, <3, -4, 6>, 0.5 }
sphere { <3, -4, 6>, 0.8 }
cylinder { <3, -4, 6>, <7, -3, -1>, 0.5 }
sphere {<7, -3, -1>, 0.8 }

sphere { <-2, -5, 5>, 0.8 }
cylinder { <-2, -5, 5>, <3, -6, 4>, 0.5 }
sphere { <3, -6, 4>, 0.8 }
cylinder { <3, -6, 4>, <7, -8, -4>, 0.5 }
sphere {<7, -8, -4>, 0.8 }

// skin visible between arms
cylinder { <-2, -3, 5>, <-2, -3, -5>, 1.5 }
cylinder { <-2, -5, 5>, <-2, -5, -5>, 1.5 }

// left leg
sphere { <-2, -14, -4>, 1.5 }
cone { <-2, -14, -4>, 1.5
       <0, -20, -4>, 1 }
sphere { <0, -20, -4>, 1.2 }
cylinder { <0, -20, -4>, <-3, -30, -4>, 1 }
sphere { <-3, -30, -4>, 1.2 }
cone { <-3, -30.2, -4>, 0.6
       <2, -30.7, -2>, 0}
cone { <-3, -30.2, -4>, 0.6
       <2, -30.7, -6>, 0}
cone { <-3, -30.2, -4>, 1
       <-8, -30.7, -4>, 0}

// right leg
sphere { <-2, -14, 4>, 1.5 }
cone { <-2, -14, 4>, 1.5
       <0, -20, 4>, 1 }
sphere { <0, -20, 4>, 1.2 }
cylinder { <0, -20, 4>, <-3, -30, 4>, 1 }
sphere { <-3, -30, 4>, 1.2 }
cone { <-3, -30.2, 4>, 0.6
       <2, -30.7, 2>, 0}
cone { <-3, -30.2, 4>, 0.6
       <2, -30.7, 6>, 0}
cone { <-3, -30.2, 4>, 1
       <-8, -30.7, 4>, 0}

} // End union

// ------------------------------------------------
// clothing

#declare Zoot_Clothes = union {
// neck
torus { 3, 0.8
        translate <0, 1, 0> }
torus { 3, 0.8 }
torus { 2.75, 0.8
        translate <0, -1, 0> }
torus { 2.5, 0.8
        translate <0, -2, 0> }
torus { 2.25, 0.8
        translate <0, -3, 0> }
// shoulder holes
torus { 1.6, 0.2
        scale <1, 1, 2>
        rotate <90, 0, 0>
        translate <-2, -4, -5.1>
        }
torus { 1.6, 0.2
        scale <1, 1, 2>
        rotate <90, 0, 0>
        translate <-2, -4, 5.1>
        }
// shoulders
cylinder {<-2, -2, -4.9>, <-2, -2, 4.9>, 1.7
          scale <1, 2, 1> }
// body
cone {<0, -3, 0>, 2
      <0, -9.9, 0>, 5 }
torus {4.5, 0.5
       translate <0, -10, 0> }
cone {<0, -10.2, 0>, 5
      <0, -15, 0>, 2.5 }

// leggs
cone {<-2, -14, -4>, 2
      <-3, -10, -1>, 1.5}
cone {<-2, -14, 4>, 2
      <-3, -10, 1>, 1.5}

} // end union clothes


// ----------------------------------------------
#declare Zoot = union {
object {Zoot_Body
        texture {
           pigment {
            bozo
            turbulence 0.5
            color_map {
             [0.3 color red 0.8 green 1.0 blue 0.27 ]
             [0.6 color red 0.6 green 1.0 blue 0.1 ]
             [1.0 color Sienna ] }
           }
        scale 0.5
        }
}

object {Zoot_Clothes
	texture {
	        pigment {color Lilac }
		normal {wrinkles 0.5 scale 2}
	}
}
} // end Zoot Union

// ------------------------------------------------------
//

#declare Bowba_Skin = texture {
	pigment {
		bozo
		color_map {
		[0.0,0.5 color Yellow color Firebrick]
		[0.5,1.01 color Orange color Salmon]}
	}
}

#declare Bowba_Body = 
blob {
     threshold 0.1
     component 1.0, 4.0, <0, 0, 10>
     component 1.0, 4.0, <5, 0, 9>
     component 1.0, 4.0, <9, 0, 5>
     component 1.0, 4.0, <10, 0, 0>
     component 1.0, 4.0, <9, 0, -5>
     component 1.0, 4.0, <5, 0, -9>
     component 1.0, 4.0, <0, 0, -10>
     component 1.0, 4.0, <-5, 0, -9>
     component 1.0, 4.0, <-9, 0, -5>
     component 1.0, 4.0, <-10, 0, 0>
     component 1.0, 4.0, <-9, 0, 5>
     component 1.0, 4.0, <-5, 0, 9>

	texture {Bowba_Skin}
}

#declare Bowba_Arm =
blob {
     threshold 0.1
     component 1.0, 1.0, <1, 0, 0>
     component 1.0, 1.5, <2, -1, 0>
     component 1.0, 2.0, <4, -2, 0>
     component 1.0, 2.0, <6, -2.5, 0>
     component 1.0, 2.5, <8, -3, 0>
     component 1.0, 2.5, <10, -3, 0>
     component 1.0, 2.5, <12, -3, 0>
     component 1.0, 2.5, <14, -2, 0>
     component 1.0, 2.5, <15, -1, 0>
     component 1.0, 2.5, <17, 0.5, 0>
     component 1.0, 3.0, <18, 2, 0>
     component 1.0, 3.0, <19, 4, 0>
     component 1.0, 3.0, <20, 6, 0>
     component 1.0, 3.0, <22, 8, 0>
     component 1.0, 3.0, <23, 8, 0>
     component 1.0, 3.0, <25, 8.5, 0>
     component 1.0, 4.0, <26, 9, 0>
     component 1.0, 4.0, <30, 9.5, 0>
     component 1.0, 3.5, <32, 10, 0>

	texture {Bowba_Skin}
}

#declare Bowba_Leg =
blob {
     threshold 0.1
     component 1.0, 1.0, <0.5, 0, 0>
     component 1.0, 1.5, <1, -1, 0>
     component 1.0, 2.0, <2, -2, 0>
     component 1.0, 2.0, <3, -2.5, 0>
     component 1.0, 2.5, <4, -3, 0>
     component 1.0, 2.5, <5, -3, 0>
     component 1.0, 2.5, <7, -2, 0>
     component 1.0, 2.5, <8, -1, 0>
     component 1.0, 2.5, <8.5, 0.5, 0>
     component 1.0, 3.0, <9, 2, 0>
     component 1.0, 3.0, <9.5, 4, 0>
     component 1.0, 3.0, <10, 6, 0>
     component 1.0, 3.0, <11, 8, 0>
     component 1.0, 3.0, <12.5, 8.5, 0>
     component 1.0, 4.0, <13, 9, 0>
     component 1.0, 4.0, <15, 9.5, 0>
     component 1.0, 3.5, <16, 10, 0>

	texture {Bowba_Skin}
}

#declare Bowba_Eye = 
sphere {<0, 0, 0>, 3
	texture {
		pigment {
			gradient x
        		color_map {
			[0.0, 0.85 color White color White]
			[0.85, 0.98 color Blue color Cyan]
			[0.98, 1.01 color Black color Black]}
		}
	scale 3
	rotate <0, 90, 0>	
	}
}

// ------------------------------------------------

#declare Bowba = union {

object {Bowba_Leg
	translate <-25, 0, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 30, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 60, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 90, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 120, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 150, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 180, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 210, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 240, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 270, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 300, 0>
}
object {Bowba_Leg
	translate <-25, 0, 0>
        rotate <0, 330, 0>
}
// ---------------------------------------------
object {Bowba_Body
        translate <0, 10, 0>
}
object {Bowba_Body
	rotate <0, 6, 0>
        translate <0, 13, 0>
}
object {Bowba_Body
	rotate <0, 12, 0>
        translate <0, 16, 0>
}
object {Bowba_Body
	rotate <0, 18, 0>
        translate <0, 19, 0>
}

//--------------------------------------------
// eyes
object {Bowba_Eye
	translate <0, 21, 10>
}
object {Bowba_Eye
	translate <5, 21, 9>
}
object {Bowba_Eye
        translate <9, 21, 5>
}
object {Bowba_Eye
	translate <10, 21, 0>
}
object {Bowba_Eye
	translate <9, 21, -5>
}
object {Bowba_Eye
	translate <5, 21, -9>
}
object {Bowba_Eye
	translate <0, 21, -10>
}
object {Bowba_Eye
	translate <-5, 21, -9>
}
object {Bowba_Eye
	translate <-9, 21, -5>
}
object {Bowba_Eye
	translate <-10, 21, 0>
}
object {Bowba_Eye
	translate <-9, 21, 5>
}
object {Bowba_Eye
	translate <-5, 21, 9>
}

// -----------------------------------------------

object {Bowba_Body
	rotate <0, 30, 0>
	scale 0.8
        translate <0, 24, 0>
}
object {Bowba_Body
	rotate <0, 36, 0>
	scale 0.6
        translate <0, 27, 0>
}
object {Bowba_Body
	rotate <0, 42, 0>
	scale 0.4
        translate <0, 29, 0>
}
object {Bowba_Body
	rotate <0, 48, 0>
	scale 0.2
        translate <0, 30, 0>
}
// ------------------------------------------------
object {Bowba_Arm
        translate <-34, 19, 0>
        rotate <0, 30, 0>
}
object {Bowba_Arm
        translate <-34, 19, 0>
        rotate <0, -30, 0>
}
object {Bowba_Arm
        translate <-34, 19, 0>
        rotate <0, 150, 0>
}
object {Bowba_Arm
        translate <-34, 19, 0>
        rotate <0, 210, 0>
}

} // end bowba union
