//  Author : Bryan Garnett-Law
//  POV    : 3.0
//  Date   : 09/10/1996    (10.09.1996)
//


global_settings { max_trace_level 10 }


// Stars in the background
sky_sphere
{
  pigment{
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .1

  }
}


camera {  //  Camera StdCam
  location  <5.456, -45.166, 11.619>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-3.151, -0.627, 0.093>
}


// *******  L I G H T S *******
light_source {   // Spotlight SpotL2
  <-0.155, -4.934, 9.418>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-0.155, -4.934, 6.946>
    falloff   15.0  // outer radius (in deg)
      radius    14.2  // inner radius
}

light_source {   // Spotlight SpotL001
  <-1.159, -10.916, 11.184>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-1.159, -10.916, 8.712>
    falloff   15.0  // outer radius (in deg)
      radius    14.2  // inner radius
}


// ********  TEXTURES  *******
//

#include "voyager1.inc"

// ********  OBJECTS  *******

sphere { // planet3
  <0,0,0>,1
  texture {
    orange_sky
  }
  no_shadow
  scale 22.0
  translate  <-25.459452, -0.166738, 0.0>
}


sphere { // planet2
  <0,0,0>,1
  texture {
    t_planet1
  }
  no_shadow
  scale 20.0
  translate  <-25.459452, -0.166738, 0.0>
}


sphere { // planet1
  <0,0,0>,1
  texture {
    t_planet2
  }
  no_shadow
  scale 19.0
  translate  <-25.459452, -0.166738, 0.0>
}


#declare diff1 = difference {
  sphere { // v_base1
    <0,0,0>,1
    scale <0.797936, 1.227811, 0.056511>
    translate  -0.179583*z
  }
  box { // cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.039476, 0.368389>
    translate  -1.415195*y
  }
  scale <1.4942, 2.008625, 3.0>
  translate  <0.0, -0.003204, 0.404291>
}
#declare union1 = merge {
  sphere { // v_base
    <0,0,0>,1
    scale <1.819324, 3.383487, 0.205623>
  }
  object { diff1 }
}
#declare diff2 = difference {
  object { union1 }
  box { // window1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.273647, 0.108785, 0.112356>
    rotate -3.705396*x
    translate  <0.0, 1.760528, -0.338987>
  }
}
#declare beams1 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.62603, 3.089369, 1.0>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <1.52, 2.98, 1.2>
    translate  -0.119704*z
  }
}
#declare beams2 = difference {
  object { beams1 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.452724, 1.811261, 1.0>
    translate  <-0.0566, -1.509323, 0.241389>
  }
}
#declare beams3 = difference {
  object { beams2 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.543456, 1.304362, 1.0>
    translate  <0.01793, 2.549035, 0.442546>
  }
  scale <1.0, 1.0, 0.1>
  translate  -0.149689*z
}
#declare union2 = union {
  object { diff2 }
  object { beams3 }
}
#declare beams4 = difference {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <1.62603, 3.089369, 1.0>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <1.52, 2.98, 1.2>
    translate  -0.119704*z
  }
}
#declare beams5 = difference {
  object { beams4 }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.452724, 1.811261, 1.0>
    translate  <-0.0566, -1.509323, 0.241389>
  }
  scale <1.0, 1.0, 0.1>
  translate  0.061587*z
}
#declare diff3 = difference {
  object { union2 }
  object { beams5 }
  scale <0.69771, 1.0, 0.986857>
}
#declare diff4 = difference {
  object { diff3 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.304654, 0.308574, 0.193822>
    rotate 1.810653*x
    translate  <0.0, 1.955346, 0.327332>
  }
}
#declare diff5 = intersection {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.447992, 1.0, 0.145702>
    translate  <-0.015514, 0.0, 0.184003>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    translate  <-0.007113, -0.303757, 0.039429>
  }
  scale <1.226214, 1.010772, 1.0>
  translate  <0.016487, -0.686306, -0.069661>
}
#declare union3 = merge {
  object { diff4 }
  object { diff5 }
}
#declare cuts2 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <0.492464, 1.771235, 1.0>
    rotate 25.627316*z
    translate  <-1.100993, -2.526829, 0.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.492464, 1.771235, 1.0>
    rotate -25.627316*z
    translate  <1.096511, -2.526829, 0.0>
  }
  translate  -0.48242*z
}
#declare diff6 = difference {
  object { union3 }
  object { cuts2 }
}
#declare cuts3 = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.43, 1.687567, 0.111732>
    rotate 4.428628*x
    translate  <-0.003726, -2.448565, 0.09951>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.38106, 1.257458>
  }
}
#declare union4 = merge {
  object { diff6 }
  object { cuts3 }
}
#declare union5 = merge {
  object { union4 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.43, 2.000102, 0.114932>
    rotate 1.820695*x
    translate  <0.0, -3.841067, -0.030991>
  }
}
#declare diff7 = difference {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.9, 0.9, 1.2>
    translate  -0.088899*z
  }
  scale <0.15, 0.15, 0.1>
  translate  <0.0, -0.248922, 0.215898>
}
#declare diff8 = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <0.989628, 0.626617, 1.0>
    translate  <0.954201, -1.026804, 0.0>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.889628, 0.526617, 1.2>
    translate  <0.954201, -1.026804, -0.114299>
  }
  scale <1.0, 1.0, 0.15>
  translate  0.215898*z
}
#declare cuts4 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.51918, -1.317213, 0.0>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.072602, 1.0, 1.0>
    translate  <0.948734, -2.01212, 0.0>
  }
}
#declare diff9 = difference {
  object { diff8 }
  object { cuts4 }
  translate  -0.05*z
}
#declare diff10 = difference {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.989628, 0.626617, 1.0>
    translate  <0.954201, -1.026804, 0.0>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.889628, 0.526617, 1.2>
    translate  <0.954201, -1.026804, -0.114299>
  }
  scale <1.0, 1.0, 0.15>
  translate  0.215898*z
}
#declare cuts5 = union {
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.51918, -1.317213, 0.0>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.072602, 1.0, 1.0>
    translate  <0.948734, -2.01212, 0.0>
  }
}
#declare diff11 = difference {
  object { diff10 }
  object { cuts5 }
  rotate <180.0, 0.0, 180.0>
  translate  0.533652*z
}
#declare union6 = union {
  object { diff7 }
  object { diff9 }
  object { diff11 }
}
#declare union7 = merge {
  object { union5 }
  object { union6 }
}
#declare union8 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.058818, 0.904137, 0.068569>
    rotate 4.661583*x
    translate  <-0.000858, -2.723017, 0.182609>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.058818, 0.904137, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -4.479889, 0.088744>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.06, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -1.822783, 0.254813>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.06, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -3.60057, 0.117626>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.06, 0.068569>
    rotate <5.465693, 0.0, 0.0>
    translate  <-0.12957, -2.69834, 0.18639>
  }
  translate  -0.038536*z
}
#declare diff12 = difference {
  object { union7 }
  object { union8 }
  translate  <-0.052729, 1.265506, 0.0>
}
#declare union9 = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -0.148807, -0.349733>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -5.528476, -0.363185>
  }
}
#declare diff13 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.866166, 2.510246, 0.402287>
    translate  <-0.046593, -2.422266, -0.340692>
  }
  object { union9 }
  translate  -0.04144*y
}
#declare diff14 = union {
  object { diff13 }
  cylinder { // blue_cut
    <0,0,1>, <0,0,0>, 1
    texture {
      blue_1
    }
    scale <0.66582, 0.206913, 0.191912>
    rotate -90.0*x
    translate  <-0.041773, -1.319676, -0.387231>
  }
}
#declare union14 = union {
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-2.89229, 0.0, 1.155957>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-1.945544, 0.0, 0.268024>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-2.890856, 0.0, 0.268024>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-1.945544, 0.0, 1.155957>
  }
}
#declare diff15 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.0, 0.264391>
    translate  <-2.417001, 0.0, 0.709337>
  }
  object { union14 }
  translate  <0.412786, 0.0, -0.81586>
}
#declare union15 = union {
  object { diff15 }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue2
    }
    scale <0.06468, 0.8, 0.067688>
    translate  <-2.285669, 0.0, -0.075186>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.669493, 0.459748, 0.115628>
    translate  <-1.118639, -0.080239, -0.095339>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.131821, 0.115628, 0.069378>
    rotate 0.0*y
    translate  <-2.013158, 1.017546, -0.103334>
  }
  rotate -4.0*y
  translate  -4.042356*y
}
#declare union16 = union {
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-2.89229, 0.0, 1.155957>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-1.945544, 0.0, 0.268024>
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-2.890856, 0.0, 0.268024>
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-1.945544, 0.0, 1.155957>
  }
}
#declare diff16 = difference {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.0, 0.264391>
    translate  <-2.417001, 0.0, 0.709337>
  }
  object { union16 }
  translate  <0.412786, 0.0, -0.81586>
}
#declare union17 = union {
  object { diff16 }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue2
    }
    scale <0.06468, 0.8, 0.067688>
    translate  <-2.285669, 0.0, -0.075186>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.669493, 0.459748, 0.115628>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.12755, -0.080239, -0.118806>
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.131821, 0.115628, 0.069378>
    rotate <-180.0, 0.0, -180.0>
    translate  <-2.028166, 1.017546, -0.114781>
  }
  rotate <180.0, -4.0, 180.0>
  translate  <-0.125475, -4.042356, -0.216537>
}
merge { // voyager
  object { diff12 }
  object { diff14 }
  cylinder { // blue_cut1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.045, 0.191912>
    rotate -90.0*x
    translate  <-0.041773, -1.311921, -0.351039>
  }
  object { union15 }
  object { union17 }
  texture {
    ship
  }
  no_shadow
  scale 1.25
  rotate <-5.846527, -7.221987, 0.472628>
  translate  <-1.405685, -7.496985, 0.0>
}


