//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 6 lights, 28 textures and 128 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/22/1996    (22.10.1996)
//


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


global_settings { max_trace_level 5 }


//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//






/*camera {  //  Camera StdCam
  location  <-65.088, -15.573, 13.900>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}*/

camera {  //  Camera StdCam
  location  <-105.088, -15.573, 23.900>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 18.000, 0.000>
}

sphere { <80,60,-50>, 30.0
   pigment {
      bozo
      turbulence 0.3
      colour_map {
         [0.0 0.7  colour red 0.8 green 0.7 blue 0.0
                   colour red 0.8 green 0.7 blue 0.0]
         [0.7 1.0  colour red 0.0 green 0.05 blue 0.3
                   colour red 0.7 green 0.6 blue 0.0]
         [1.0 1.01 colour red 0.7 green 0.6 blue 0.0
                   colour red 0.3 green 0.3 blue 0.7]
      }
      scale 10.0
      translate 100*x
   }
   finish {
      crand 0.08
      ambient 0.0
      diffuse 0.4
   }
}

sphere { <80,60,-50>, 30.2
   pigment {
      bozo
      turbulence 1.0
      colour_map {
         [0.0 0.4 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0 filter 1.0]
         [0.4 0.9 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0]
         [0.9 1.0 colour red 1.0 green 1.0 blue 1.0
                  colour red 1.0 green 1.0 blue 1.0]
      }
      scale <12.0, 3.0, 12.0>
      rotate <30.0, 0.0, -45.0>
   }
   finish {
      ambient 0.0
      diffuse 0.6
   }
}
// *******  L I G H T S *******

light_source {   // Light4
  <-19.485, -0.994, 10.316>
  color rgb <0.500, 0.500, 0.500>
}

light_source {   // Light3
  <0.024, 17.637, 10.316>
  color rgb <1.000, 1.000, 1.000>
}

/*light_source {   // Light2
  <19.006, -1.169, 10.316>
  color rgb <1.000, 1.000, 1.000>
}*/

light_source {   // Light1
  <-0.151, -19.800, 10.316>
  color rgb <1.000, 1.000, 1.000>
}

/*light_source {   // Light5
  <-19.988, -12.116, 39.734>
  color rgb <1.000, 1.000, 1.000>
  //atmospheric_attenuation off
}*/

#declare Halo = texture {
   pigment { colour Clear }
   halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.5
      colour_map {
         [ 0 color rgbt <1, 0, 0, 1> ]
         [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
   }
}
#declare Halo2 = texture {
   pigment { colour Clear }
   halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.8
      colour_map {
         [ 0 color rgbt <1, 1, 0, 1> ]
         [ 1 color rgbt <1, 0, 0, 0> ]
      }
      samples 8
   }

}
#declare Halo3 = texture {
   pigment { colour Clear }
   halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.8
      colour_map {
         [ 0 color rgbt <1, 1, 0, 0> ]
         [ 1 color rgbt <1, 0, 0, 0> ]
      }
      samples 12
   }

}

sphere { 0, 1 hollow texture { Halo } scale 32 translate <273.797, 22.290, -25.000>}
sphere { 0, 1 hollow texture { Halo2 } scale 32 translate <273.797, 22.290, -25.000>}

// ********  TEXTURES  *******
//

#include "voyager2.inc"

// ********  OBJECTS  *******

#declare arms1 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <20.0, 9.0, 2.5>
    rotate 90.0*x
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <17.5, 7.0, 3.0>
    rotate 90.0*x
    translate  0.2*y
  }
}
#declare arms2 = difference {
  object { arms1 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <20.700001, 2.0, 4.5>
    translate  <0.1, -1.2, 5.1>
  }
  translate  0.1*y
}
#declare hold1 = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.5, 1.0>
    translate  <-18.9, -1.2, -0.3>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.0>
    translate  <-18.4, -1.2, -1.5>
  }
}
#declare hold2 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.5, 1.0>
    translate  <-18.9, -1.2, -0.3>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.0>
    translate  <-18.4, -1.2, -1.5>
  }
  rotate 180.0*z
  translate  -2.4*y
}
#declare arms3 = union {
  object { arms2 }
  object { hold1 }
  object { hold2 }
}
#declare arms4 = difference {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <20.0, 9.0, 2.5>
    rotate 90.0*x
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <17.5, 7.0, 3.0>
    rotate 90.0*x
    translate  0.2*y
  }
}
#declare arms5 = difference {
  object { arms4 }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <20.700001, 2.0, 4.5>
    translate  <0.1, -1.2, 5.1>
  }
  translate  0.1*y
}
#declare hold3 = union {
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.5, 1.0>
    translate  <-18.9, -1.2, -0.3>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.0>
    translate  <-18.4, -1.2, -1.5>
  }
}
#declare hold4 = union {
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.5, 1.0>
    translate  <-18.9, -1.2, -0.3>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.0>
    translate  <-18.4, -1.2, -1.5>
  }
  rotate 180.0*z
  translate  -2.4*y
}
#declare arms6 = union {
  object { arms5 }
  object { hold3 }
  object { hold4 }
  rotate -90.0*z
  translate  <1.2, -1.2, 0.0>
}
#declare docking_arms = merge {
  object { arms3 }
  object { arms6 }
}
#declare CSG001 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <17.9, 1.1, 0.7>
    translate  <0.0, 0.582426, -0.3>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <17.9, 1.1, 0.7>
    translate  <0.0, -2.797029, -0.3>
  }
  texture {
    black_lights
  }
}
#declare prom1 = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 35.0>
    rotate -90.0*y
    translate  <17.6, -1.1, -0.3>
  }
  object { CSG001 }
}
#declare CSG2 = union {
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <17.9, 1.1, 0.7>
    translate  <0.0, 0.582426, -0.3>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <17.9, 1.1, 0.7>
    translate  <0.0, -2.797029, -0.3>
  }
  texture {
    black_lights
  }
}
#declare prom2 = difference {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 35.0>
    rotate -90.0*y
    translate  <17.6, -1.1, -0.3>
  }
  object { CSG2 }
  rotate 90.0*z
  translate  <-1.101235, -1.331833, 0.0>
}
#declare proms = merge {
  object { prom1 }
  object { prom2 }
}
#declare dock1 = intersection {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.381227, 1.217419, 3.61935>
    translate  <-21.119569, -1.188888, 2.142945>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <7.417004, 6.22639, 3.989505>
    rotate 90.0*x
    translate  <-24.546864, 0.536409, 0.0>
  }
}
#declare dock1_b = difference {
  object { dock1 }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <4.202347, 5.33343, 3.989505>
    rotate 90.0*x
    translate  <-24.784986, 0.536409, -0.833429>
  }
  scale <1.0, 1.0, 0.345163>
  translate  <-0.238123, 0.0, 1.190613>
}
#declare dock1_cuts = union {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate -5.701344*x
    translate  <-21.408728, -3.311379, 2.147136>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate 5.701344*x
    translate  <-21.408728, 0.89349, 2.147136>
  }
}
#declare dock1_c = difference {
  object { dock1_b }
  object { dock1_cuts }
}
#declare dock2 = intersection {
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <3.381227, 1.217419, 3.61935>
    translate  <-21.119569, -1.188888, 2.142945>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <7.417004, 6.22639, 3.989505>
    rotate 90.0*x
    translate  <-24.546864, 0.536409, 0.0>
  }
}
#declare dock1_b1 = difference {
  object { dock2 }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <4.202347, 5.33343, 3.989505>
    rotate 90.0*x
    translate  <-24.784986, 0.536409, -0.833429>
  }
  scale <1.0, 1.0, 0.345163>
  translate  <-0.238123, 0.0, 1.190613>
}
#declare dock1_cuts1 = union {
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate -5.701344*x
    translate  <-21.408728, -3.311379, 2.147136>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate 5.701344*x
    translate  <-21.408728, 0.89349, 2.147136>
  }
}
#declare dock1_c1 = difference {
  object { dock1_b1 }
  object { dock1_cuts1 }
  rotate 90.0*z
  translate  <-1.179898, -1.159337, 0.0>
}
#declare dock3 = intersection {
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <3.381227, 1.217419, 3.61935>
    translate  <-21.119569, -1.188888, 2.142945>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <7.417004, 6.22639, 3.989505>
    rotate 90.0*x
    translate  <-24.546864, 0.536409, 0.0>
  }
}
#declare dock1_b2 = difference {
  object { dock3 }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <4.202347, 5.33343, 3.989505>
    rotate 90.0*x
    translate  <-24.784986, 0.536409, -0.833429>
  }
  scale <1.0, 1.0, 0.345163>
  translate  <-0.238123, 0.0, 1.190613>
}
#declare dock1_cuts2 = union {
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate -5.701344*x
    translate  <-21.408728, -3.311379, 2.147136>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate 5.701344*x
    translate  <-21.408728, 0.89349, 2.147136>
  }
}
#declare dock1_c2 = difference {
  object { dock1_b2 }
  object { dock1_cuts2 }
  rotate -90.0*z
  translate  <1.205109, -1.159337, 0.0>
}
#declare dock4 = intersection {
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <3.381227, 1.217419, 3.61935>
    translate  <-21.119569, -1.188888, 2.142945>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <7.417004, 6.22639, 3.989505>
    rotate 90.0*x
    translate  <-24.546864, 0.536409, 0.0>
  }
}
#declare dock1_b3 = difference {
  object { dock4 }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <4.202347, 5.33343, 3.989505>
    rotate 90.0*x
    translate  <-24.784986, 0.536409, -0.833429>
  }
  scale <1.0, 1.0, 0.345163>
  translate  <-0.238123, 0.0, 1.190613>
}
#declare dock1_cuts3 = union {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate -5.701344*x
    translate  <-21.408728, -3.311379, 2.147136>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <4.333718, 1.0, 2.369205>
    rotate 5.701344*x
    translate  <-21.408728, 0.89349, 2.147136>
  }
}
#declare dock1_c3 = difference {
  object { dock1_b3 }
  object { dock1_cuts3 }
  rotate -180.0*z
  translate  <-0.121383, -2.365239, 0.0>
}
#declare CSG002 = union {
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <3.5, 3.5, 0.5>
    translate  <0.0, -1.102411, 11.803334>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <3.5, 3.5, 0.5>
    translate  <0.0, -1.102411, 10.798879>
  }
}
#declare CSG003 = difference {
  object { CSG002 }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 2.5>
    translate  <0.0, -1.102411, 10.320567>
  }
  texture {
    comm
  }
  scale <1.01, 1.01, 1.0>
}
#declare comm_ctr = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <3.5, 3.5, 2.5>
    translate  <0.0, -1.102411, 10.320567>
  }
  object { CSG003 }
  translate  -0.573974*z
}
#declare passages = merge {
  box { // passage_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 14.110235, 0.8>
    translate  <0.0, -1.088599, 4.907718>
  }
  box { // passage_2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 14.110235, 0.8>
    rotate -90.0*z
    translate  <0.0, -1.088599, 4.907718>
  }
  scale <1.0, 1.0, 0.85>
  translate  <0.0, 0.037495, 0.749899>
}
merge { // part1
  object { docking_arms }
  object { proms }
  object { dock1_c }
  object { dock1_c1 }
  object { dock1_c2 }
  object { dock1_c3 }
  cylinder { // transtube
    <0,0,1>, <0,0,0>, 1
    texture {
      habitat_tex
    }
    scale <1.7, 1.7, 20.0>
    translate  <0.0, -1.089035, -8.335073>
  }
  torus { // lower_habitat
    1.0, 1.0  rotate -x*90
    texture {
      habitat_tex
    }
    scale <4.0, 4.0, 1.0>
    translate  <0.0, -1.102997, -3.533051>
  }
  object { comm_ctr }
  torus { // habitat
    1.75, 0.25  rotate -x*90
    texture {
      habitat_tex
    }
    scale <9.0, 9.0, 3.0>
    translate  <0.0, -1.079083, 4.903073>
  }
  object { passages }
  no_shadow
  texture {
    Silver4
  }
}




#declare diff1 = difference {
  sphere { // v_base1
    <0,0,0>,1
    scale <0.797936, 1.227811, 0.056511>
    translate  -0.179583*z
  }
  box { // cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.039476, 0.368389>
    translate  -1.415195*y
  }
  scale <1.4942, 2.008625, 3.0>
  translate  <0.0, -0.003204, 0.404291>
}
#declare union1 = merge {
  sphere { // v_base
    <0,0,0>,1
    scale <1.819324, 3.383487, 0.205623>
  }
  object { diff1 }
}
#declare diff2 = difference {
  object { union1 }
  box { // window1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.273647, 0.108785, 0.112356>
    rotate -3.705396*x
    translate  <0.0, 1.760528, -0.338987>
  }
}
#declare beams1 = difference {
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <1.62603, 3.089369, 1.0>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <1.52, 2.98, 1.2>
    translate  -0.119704*z
  }
}
#declare beams2 = difference {
  object { beams1 }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <2.452724, 1.811261, 1.0>
    translate  <-0.0566, -1.509323, 0.241389>
  }
}
#declare beams3 = difference {
  object { beams2 }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.543456, 1.304362, 1.0>
    translate  <0.01793, 2.549035, 0.442546>
  }
  scale <1.0, 1.0, 0.1>
  translate  -0.149689*z
}
#declare union2 = union {
  object { diff2 }
  object { beams3 }
}
#declare beams4 = difference {
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <1.62603, 3.089369, 1.0>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <1.52, 2.98, 1.2>
    translate  -0.119704*z
  }
}
#declare beams5 = difference {
  object { beams4 }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <2.452724, 1.811261, 1.0>
    translate  <-0.0566, -1.509323, 0.241389>
  }
  scale <1.0, 1.0, 0.1>
  translate  0.061587*z
}
#declare diff3 = difference {
  object { union2 }
  object { beams5 }
  scale <0.69771, 1.0, 0.986857>
}
#declare diff4 = difference {
  object { diff3 }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.304654, 0.308574, 0.193822>
    rotate 1.810653*x
    translate  <0.0, 1.955346, 0.327332>
  }
}
#declare diff5 = intersection {
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.447992, 1.0, 0.145702>
    translate  <-0.015514, 0.0, 0.184003>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    translate  <-0.007113, -0.303757, 0.039429>
  }
  scale <1.226214, 1.010772, 1.0>
  translate  <0.016487, -0.686306, -0.069661>
}
#declare union3 = merge {
  object { diff4 }
  object { diff5 }
}
#declare cuts2 = union {
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.492464, 1.771235, 1.0>
    rotate 25.627316*z
    translate  <-1.100993, -2.526829, 0.0>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <0.492464, 1.771235, 1.0>
    rotate -25.627316*z
    translate  <1.096511, -2.526829, 0.0>
  }
  translate  -0.48242*z
}
#declare diff6 = difference {
  object { union3 }
  object { cuts2 }
}
#declare cuts3 = difference {
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.43, 1.687567, 0.111732>
    rotate 4.428628*x
    translate  <-0.003726, -2.448565, 0.09951>
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.38106, 1.257458>
  }
}
#declare union4 = merge {
  object { diff6 }
  object { cuts3 }
}
#declare union5 = merge {
  object { union4 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.43, 2.000102, 0.114932>
    rotate 1.820695*x
    translate  <0.0, -3.841067, -0.030991>
  }
}
#declare diff7 = difference {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <0.9, 0.9, 1.2>
    translate  -0.088899*z
  }
  scale <0.15, 0.15, 0.1>
  translate  <0.0, -0.248922, 0.215898>
}
#declare diff8 = difference {
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <0.989628, 0.626617, 1.0>
    translate  <0.954201, -1.026804, 0.0>
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    scale <0.889628, 0.526617, 1.2>
    translate  <0.954201, -1.026804, -0.114299>
  }
  scale <1.0, 1.0, 0.15>
  translate  0.215898*z
}
#declare cuts4 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.51918, -1.317213, 0.0>
  }
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    scale <1.072602, 1.0, 1.0>
    translate  <0.948734, -2.01212, 0.0>
  }
}
#declare diff9 = difference {
  object { diff8 }
  object { cuts4 }
  translate  -0.05*z
}
#declare diff10 = difference {
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    scale <0.989628, 0.626617, 1.0>
    translate  <0.954201, -1.026804, 0.0>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    scale <0.889628, 0.526617, 1.2>
    translate  <0.954201, -1.026804, -0.114299>
  }
  scale <1.0, 1.0, 0.15>
  translate  0.215898*z
}
#declare cuts5 = union {
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.51918, -1.317213, 0.0>
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    scale <1.072602, 1.0, 1.0>
    translate  <0.948734, -2.01212, 0.0>
  }
}
#declare diff11 = difference {
  object { diff10 }
  object { cuts5 }
  rotate <180.0, 0.0, 180.0>
  translate  0.533652*z
}
#declare union6 = union {
  object { diff7 }
  object { diff9 }
  object { diff11 }
}
#declare union7 = merge {
  object { union5 }
  object { union6 }
}
#declare union8 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.058818, 0.904137, 0.068569>
    rotate 4.661583*x
    translate  <-0.000858, -2.723017, 0.182609>
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.058818, 0.904137, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -4.479889, 0.088744>
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.06, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -1.822783, 0.254813>
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.06, 0.068569>
    rotate 2.03521*x
    translate  <-0.000858, -3.60057, 0.117626>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.06, 0.068569>
    rotate <5.465693, 0.0, 0.0>
    translate  <-0.12957, -2.69834, 0.18639>
  }
  translate  -0.038536*z
}
#declare diff12 = difference {
  object { union7 }
  object { union8 }
  translate  <-0.052729, 1.265506, 0.0>
}
#declare union9 = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -0.148807, -0.349733>
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -5.528476, -0.363185>
  }
}
#declare diff13 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.866166, 2.510246, 0.402287>
    translate  <-0.046593, -2.422266, -0.340692>
  }
  object { union9 }
  translate  -0.04144*y
}
#declare diff14 = union {
  object { diff13 }
  cylinder { // blue_cut
    <0,0,1>, <0,0,0>, 1
    texture {
      blue_2
    }
    scale <0.66582, 0.206913, 0.191912>
    rotate -90.0*x
    translate  <-0.041773, -1.319676, -0.387231>
  }
}
#declare union14 = union {
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-2.89229, 0.0, 1.155957>
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-1.945544, 0.0, 0.268024>
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-2.890856, 0.0, 0.268024>
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-1.945544, 0.0, 1.155957>
  }
}
#declare diff15 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.0, 0.264391>
    translate  <-2.417001, 0.0, 0.709337>
  }
  object { union14 }
  translate  <0.412786, 0.0, -0.81586>
}
#declare union15 = union {
  object { diff15 }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue3
    }
    scale <0.06468, 0.8, 0.067688>
    translate  <-2.285669, 0.0, -0.075186>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.669493, 0.459748, 0.115628>
    translate  <-1.118639, -0.080239, -0.095339>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.131821, 0.115628, 0.069378>
    rotate 0.0*y
    translate  <-2.013158, 1.017546, -0.103334>
  }
  rotate -4.0*y
  translate  -4.042356*y
}
#declare union16 = union {
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-2.89229, 0.0, 1.155957>
  }
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate 45.0*y
    translate  <-1.945544, 0.0, 0.268024>
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-2.890856, 0.0, 0.268024>
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.2, 0.264391>
    rotate -45.0*y
    translate  <-1.945544, 0.0, 1.155957>
  }
}
#declare diff16 = difference {
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    scale <0.308177, 1.0, 0.264391>
    translate  <-2.417001, 0.0, 0.709337>
  }
  object { union16 }
  translate  <0.412786, 0.0, -0.81586>
}
#declare union17 = union {
  object { diff16 }
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue3
    }
    scale <0.06468, 0.8, 0.067688>
    translate  <-2.285669, 0.0, -0.075186>
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    scale <0.669493, 0.459748, 0.115628>
    rotate <0.0, 0.0, 0.0>
    translate  <-1.12755, -0.080239, -0.118806>
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    scale <0.131821, 0.115628, 0.069378>
    rotate <-180.0, 0.0, -180.0>
    translate  <-2.028166, 1.017546, -0.114781>
  }
  rotate <180.0, -4.0, 180.0>
  translate  <-0.125475, -4.042356, -0.216537>
}
merge { // voyager
  object { diff12 }
  object { diff14 }
  cylinder { // blue_cut1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.045, 0.191912>
    rotate -90.0*x
    translate  <-0.041773, -1.311921, -0.351039>
  }
  object { union15 }
  object { union17 }
  texture {
    ship1
  }
  scale <1.75, 1.5, 2.0>
  rotate -90.0*z
  translate  <-27.239655, -1.351134, 3.881902>
}




#declare base1 = difference {
  sphere { // Sphere2
    <0,0,0>,1
    scale <1.732714, 2.573346, 1.005644>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale <2.214653, 3.100317, 0.666148>
    translate  -0.376309*z
  }
}
#declare cut2 = union {
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.301211, 0.348795>
    rotate <-180.0, 75.943993, -180.0>
    translate  <-1.043671, 0.0, 0.256995>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.301211, 0.348795>
    rotate <-180.0, -75.943993, -180.0>
    translate  <1.06481, 0.0, 0.256995>
  }
  scale <1.0, 1.3, 1.0>
}
#declare base2 = difference {
  object { base1 }
  object { cut2 }
}
#declare cuts6 = union {
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.320262, 0.174785>
    rotate 7.6*y
    translate  <-1.867623, 0.0, 0.542846>
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.320262, 0.174785>
    rotate -7.6*y
    translate  <1.880714, 0.0, 0.542846>
  }
  scale <1.031269, 1.0, 1.96934>
  translate  <0.0, 0.025177, -0.208321>
}
#declare base3 = difference {
  object { base2 }
  object { cuts6 }
}
#declare base4 = difference {
  object { base3 }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    scale <1.993552, 1.124194, 1.0>
    rotate 51.593632*x
    translate  <-0.031049, 2.356564, 1.3254>
  }
  texture {
    Texture01
  }
}
#declare engine1 = difference {
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    scale <0.329818, 1.0, 0.041009>
    rotate -12.289334*y
    translate  <1.634315, -0.015316, 0.200528>
  }
  box { // Cube52
    <-1, -1, -1>, <1, 1, 1>
    scale <1.015316, 1.275697, 1.0>
    translate  0.643292*x
  }
  texture {
    engine
  }
  translate  -0.195395*x
}
#declare engine2 = difference {
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    scale <0.329818, 1.0, 0.041009>
    rotate -12.289334*y
    translate  <1.634315, -0.015316, 0.200528>
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    scale <1.015316, 1.275697, 1.0>
    translate  0.643292*x
  }
  texture {
    engine
  }
  rotate -180.0*z
  translate  <0.210339, -0.014944, 0.0>
}
#declare ship3 = union {
  object { base4 }
  object { engine1 }
  object { engine2 }
}
#declare cut3 = union {
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.301211, 0.3>
    rotate <-180.0, 75.943993, -180.0>
    translate  <-1.043671, 0.0, 0.256995>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.301211, 0.3>
    rotate <-180.0, -75.943993, -180.0>
    translate  <1.06481, 0.0, 0.256995>
  }
  scale <1.0, 1.3, 1.0>
}
#declare windows = difference {
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    scale <0.900724, 1.0, 0.11985>
    translate  <0.01805, 0.0, 0.676882>
  }
  object { cut3 }
  texture {
    window
  }
}
#declare ship4 = union {
  object { ship3 }
  object { windows }
}
#declare lifters = union {
  box { // lifter1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue_1
    }
    scale <0.066952, 1.0, 0.066952>
    translate  <-0.297828, 0.0, 0.216602>
  }
  box { // lifter2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      red1
    }
    scale <0.066952, 1.0, 0.066952>
    translate  <0.0, 0.0, 0.216602>
  }
  box { // lifter3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blue2
    }
    scale <0.066952, 1.0, 0.066952>
    translate  <0.279778, 0.0, 0.216602>
  }
  texture {
    blue_2
  }
  translate  <-0.003473, 0.0, 0.02431>
}
#declare ship5 = union {
  object { ship4 }
  object { lifters }
}
#declare BzPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, -0.263566>, <-1.000000, -2.000000, -0.263566>, <0.000000, -2.000000, -0.263566>, <1.000000, -2.000000, -0.263566>,
      <-2.000000, -1.000000, -0.263566>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, -0.263566>,
      <-1.626735, 0.018624, -0.263566>, <-0.859928, 0.018624, 0.000000>, <-0.093121, 0.018624, 0.000000>, <0.673686, 0.018624, -0.263566>,
      <-1.152914, 1.000474, -0.263566>, <-0.688202, 1.000474, -0.263566>, <-0.223490, 1.000474, -0.263566>, <0.241222, 1.000474, -0.263566>
    }
  }
  texture {
    window
  }
  scale <0.384174, 0.280891, 0.851057>
  rotate 22.098759*x
  translate  <0.207507, -1.72601, 0.929628>
}
union { // ship6e
  object { ship5 }
  object { BzPtch001 }
  scale 2.0
  rotate <-1.51187, 10.088589, -71.351318>
  translate  <-37.146656, -16.610357, 6.515398>
}



// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .125
    }
}
